"""
These modules contain mappers for converting Boosty API -> domain objects.

This is the main entry point for data transformation.
"""

from boosty_downloader.src.application.ok_video_ranking import (
    get_best_video,
    get_quality_ranking,
)

from .external_video import to_external_video_content
from .file import to_domain_file_chunk
from .image import to_domain_image_chunk
from .link_header_text import to_domain_text_chunk
from .list import to_domain_list_chunk
from .ok_boosty_video import to_ok_boosty_video_content
from .post_mapper import map_post_dto_to_domain

__all__ = [
    'get_best_video',
    'get_quality_ranking',
    'map_post_dto_to_domain',
    'to_domain_file_chunk',
    'to_domain_image_chunk',
    'to_domain_list_chunk',
    'to_domain_text_chunk',
    'to_external_video_content',
    'to_ok_boosty_video_content',
]
