# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AuthnMappingArgs', 'AuthnMapping']

@pulumi.input_type
class AuthnMappingArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str],
                 role: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthnMapping resource.
        :param pulumi.Input[str] key: Identity provider key.
        :param pulumi.Input[str] value: Identity provider value.
        :param pulumi.Input[str] role: The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        :param pulumi.Input[str] team: The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Identity provider key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Identity provider value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class _AuthnMappingState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthnMapping resources.
        :param pulumi.Input[str] key: Identity provider key.
        :param pulumi.Input[str] role: The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        :param pulumi.Input[str] team: The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        :param pulumi.Input[str] value: Identity provider value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team is not None:
            pulumi.set(__self__, "team", team)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Identity provider key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Identity provider value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class AuthnMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog AuthN Mappings resource. This feature lets you automatically assign roles to users based on their SAML attributes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Source the role
        ro_role = datadog.get_role(filter="Datadog Read Only Role")
        # Create a new AuthN mapping
        dev_ro_role_mapping = datadog.AuthnMapping("dev_ro_role_mapping",
            key="Member-of",
            value="Development",
            role=ro_role.id)
        ```

        ## Import

        AuthN mappings can be imported using their ID, e.g.

        ```sh
        $ pulumi import datadog:index/authnMapping:AuthnMapping dev_ro_mapping 000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Identity provider key.
        :param pulumi.Input[str] role: The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        :param pulumi.Input[str] team: The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        :param pulumi.Input[str] value: Identity provider value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthnMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog AuthN Mappings resource. This feature lets you automatically assign roles to users based on their SAML attributes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Source the role
        ro_role = datadog.get_role(filter="Datadog Read Only Role")
        # Create a new AuthN mapping
        dev_ro_role_mapping = datadog.AuthnMapping("dev_ro_role_mapping",
            key="Member-of",
            value="Development",
            role=ro_role.id)
        ```

        ## Import

        AuthN mappings can be imported using their ID, e.g.

        ```sh
        $ pulumi import datadog:index/authnMapping:AuthnMapping dev_ro_mapping 000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param AuthnMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthnMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthnMappingArgs.__new__(AuthnMappingArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["role"] = role
            __props__.__dict__["team"] = team
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(AuthnMapping, __self__).__init__(
            'datadog:index/authnMapping:AuthnMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            team: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'AuthnMapping':
        """
        Get an existing AuthnMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Identity provider key.
        :param pulumi.Input[str] role: The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        :param pulumi.Input[str] team: The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        :param pulumi.Input[str] value: Identity provider value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthnMappingState.__new__(_AuthnMappingState)

        __props__.__dict__["key"] = key
        __props__.__dict__["role"] = role
        __props__.__dict__["team"] = team
        __props__.__dict__["value"] = value
        return AuthnMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Identity provider key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of a role to attach to all users with the corresponding key and value. Cannot be used in conjunction with `team`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def team(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of a team to add all users with the corresponding key and value to. Cannot be used in conjunction with `role`.
        """
        return pulumi.get(self, "team")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Identity provider value.
        """
        return pulumi.get(self, "value")

