# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 account_specific_namespace_rules: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 excluded_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 filter_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_collection_enabled: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[str] access_key_id: Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        :param pulumi.Input[str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[Mapping[str, Any]] account_specific_namespace_rules: Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        :param pulumi.Input[str] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_regions: An array of AWS regions to exclude from metrics collection.
        :param pulumi.Input[str] extended_resource_collection_enabled: Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_tags: Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_tags: Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        :param pulumi.Input[str] metrics_collection_enabled: Whether Datadog collects metrics for this AWS account.
        :param pulumi.Input[str] resource_collection_enabled: Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        :param pulumi.Input[str] role_name: Your Datadog role delegation name.
        :param pulumi.Input[str] secret_access_key: Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_specific_namespace_rules is not None:
            pulumi.set(__self__, "account_specific_namespace_rules", account_specific_namespace_rules)
        if cspm_resource_collection_enabled is not None:
            pulumi.set(__self__, "cspm_resource_collection_enabled", cspm_resource_collection_enabled)
        if excluded_regions is not None:
            pulumi.set(__self__, "excluded_regions", excluded_regions)
        if extended_resource_collection_enabled is not None:
            pulumi.set(__self__, "extended_resource_collection_enabled", extended_resource_collection_enabled)
        if filter_tags is not None:
            pulumi.set(__self__, "filter_tags", filter_tags)
        if host_tags is not None:
            pulumi.set(__self__, "host_tags", host_tags)
        if metrics_collection_enabled is not None:
            pulumi.set(__self__, "metrics_collection_enabled", metrics_collection_enabled)
        if resource_collection_enabled is not None:
            warnings.warn("""Deprecated in favor of `extended_resource_collection_enabled`.""", DeprecationWarning)
            pulumi.log.warn("""resource_collection_enabled is deprecated: Deprecated in favor of `extended_resource_collection_enabled`.""")
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="accountSpecificNamespaceRules")
    def account_specific_namespace_rules(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        """
        return pulumi.get(self, "account_specific_namespace_rules")

    @account_specific_namespace_rules.setter
    def account_specific_namespace_rules(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "account_specific_namespace_rules", value)

    @property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @cspm_resource_collection_enabled.setter
    def cspm_resource_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cspm_resource_collection_enabled", value)

    @property
    @pulumi.getter(name="excludedRegions")
    def excluded_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of AWS regions to exclude from metrics collection.
        """
        return pulumi.get(self, "excluded_regions")

    @excluded_regions.setter
    def excluded_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_regions", value)

    @property
    @pulumi.getter(name="extendedResourceCollectionEnabled")
    def extended_resource_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        """
        return pulumi.get(self, "extended_resource_collection_enabled")

    @extended_resource_collection_enabled.setter
    def extended_resource_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extended_resource_collection_enabled", value)

    @property
    @pulumi.getter(name="filterTags")
    def filter_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        """
        return pulumi.get(self, "filter_tags")

    @filter_tags.setter
    def filter_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "filter_tags", value)

    @property
    @pulumi.getter(name="hostTags")
    def host_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        """
        return pulumi.get(self, "host_tags")

    @host_tags.setter
    def host_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_tags", value)

    @property
    @pulumi.getter(name="metricsCollectionEnabled")
    def metrics_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects metrics for this AWS account.
        """
        return pulumi.get(self, "metrics_collection_enabled")

    @metrics_collection_enabled.setter
    def metrics_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics_collection_enabled", value)

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    @_utilities.deprecated("""Deprecated in favor of `extended_resource_collection_enabled`.""")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_collection_enabled", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Your Datadog role delegation name.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 account_specific_namespace_rules: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 excluded_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 filter_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_collection_enabled: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[str] access_key_id: Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        :param pulumi.Input[str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[Mapping[str, Any]] account_specific_namespace_rules: Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        :param pulumi.Input[str] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_regions: An array of AWS regions to exclude from metrics collection.
        :param pulumi.Input[str] extended_resource_collection_enabled: Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_tags: Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_tags: Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        :param pulumi.Input[str] metrics_collection_enabled: Whether Datadog collects metrics for this AWS account.
        :param pulumi.Input[str] resource_collection_enabled: Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        :param pulumi.Input[str] role_name: Your Datadog role delegation name.
        :param pulumi.Input[str] secret_access_key: Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_specific_namespace_rules is not None:
            pulumi.set(__self__, "account_specific_namespace_rules", account_specific_namespace_rules)
        if cspm_resource_collection_enabled is not None:
            pulumi.set(__self__, "cspm_resource_collection_enabled", cspm_resource_collection_enabled)
        if excluded_regions is not None:
            pulumi.set(__self__, "excluded_regions", excluded_regions)
        if extended_resource_collection_enabled is not None:
            pulumi.set(__self__, "extended_resource_collection_enabled", extended_resource_collection_enabled)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if filter_tags is not None:
            pulumi.set(__self__, "filter_tags", filter_tags)
        if host_tags is not None:
            pulumi.set(__self__, "host_tags", host_tags)
        if metrics_collection_enabled is not None:
            pulumi.set(__self__, "metrics_collection_enabled", metrics_collection_enabled)
        if resource_collection_enabled is not None:
            warnings.warn("""Deprecated in favor of `extended_resource_collection_enabled`.""", DeprecationWarning)
            pulumi.log.warn("""resource_collection_enabled is deprecated: Deprecated in favor of `extended_resource_collection_enabled`.""")
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="accountSpecificNamespaceRules")
    def account_specific_namespace_rules(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        """
        return pulumi.get(self, "account_specific_namespace_rules")

    @account_specific_namespace_rules.setter
    def account_specific_namespace_rules(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "account_specific_namespace_rules", value)

    @property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @cspm_resource_collection_enabled.setter
    def cspm_resource_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cspm_resource_collection_enabled", value)

    @property
    @pulumi.getter(name="excludedRegions")
    def excluded_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of AWS regions to exclude from metrics collection.
        """
        return pulumi.get(self, "excluded_regions")

    @excluded_regions.setter
    def excluded_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_regions", value)

    @property
    @pulumi.getter(name="extendedResourceCollectionEnabled")
    def extended_resource_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        """
        return pulumi.get(self, "extended_resource_collection_enabled")

    @extended_resource_collection_enabled.setter
    def extended_resource_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extended_resource_collection_enabled", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="filterTags")
    def filter_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        """
        return pulumi.get(self, "filter_tags")

    @filter_tags.setter
    def filter_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "filter_tags", value)

    @property
    @pulumi.getter(name="hostTags")
    def host_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        """
        return pulumi.get(self, "host_tags")

    @host_tags.setter
    def host_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_tags", value)

    @property
    @pulumi.getter(name="metricsCollectionEnabled")
    def metrics_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects metrics for this AWS account.
        """
        return pulumi.get(self, "metrics_collection_enabled")

    @metrics_collection_enabled.setter
    def metrics_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics_collection_enabled", value)

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    @_utilities.deprecated("""Deprecated in favor of `extended_resource_collection_enabled`.""")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_collection_enabled", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Your Datadog role delegation name.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)


class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 account_specific_namespace_rules: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 excluded_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 filter_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_collection_enabled: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog - Amazon Web Services integration resource. This can be used to create and manage Datadog - Amazon Web Services integration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog - Amazon Web Services integration
        sandbox = datadog.aws.Integration("sandbox",
            account_id="1234567890",
            role_name="DatadogAWSIntegrationRole",
            filter_tags=["key:value"],
            host_tags=[
                "key:value",
                "key2:value2",
            ],
            account_specific_namespace_rules={
                "auto_scaling": False,
                "opsworks": False,
            },
            excluded_regions=[
                "us-east-1",
                "us-west-2",
            ])
        ```

        ## Import

        Amazon Web Services integrations can be imported using their account ID and role name separated with a colon (:), while the external_id should be passed by setting an environment variable called EXTERNAL_ID

        ```sh
        $ pulumi import datadog:aws/integration:Integration EXTERNAL_ID=${external_id} datadog_integration_aws.test ${account_id}:${role_name}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key_id: Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        :param pulumi.Input[str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[Mapping[str, Any]] account_specific_namespace_rules: Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        :param pulumi.Input[str] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_regions: An array of AWS regions to exclude from metrics collection.
        :param pulumi.Input[str] extended_resource_collection_enabled: Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_tags: Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_tags: Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        :param pulumi.Input[str] metrics_collection_enabled: Whether Datadog collects metrics for this AWS account.
        :param pulumi.Input[str] resource_collection_enabled: Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        :param pulumi.Input[str] role_name: Your Datadog role delegation name.
        :param pulumi.Input[str] secret_access_key: Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IntegrationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog - Amazon Web Services integration resource. This can be used to create and manage Datadog - Amazon Web Services integration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog - Amazon Web Services integration
        sandbox = datadog.aws.Integration("sandbox",
            account_id="1234567890",
            role_name="DatadogAWSIntegrationRole",
            filter_tags=["key:value"],
            host_tags=[
                "key:value",
                "key2:value2",
            ],
            account_specific_namespace_rules={
                "auto_scaling": False,
                "opsworks": False,
            },
            excluded_regions=[
                "us-east-1",
                "us-west-2",
            ])
        ```

        ## Import

        Amazon Web Services integrations can be imported using their account ID and role name separated with a colon (:), while the external_id should be passed by setting an environment variable called EXTERNAL_ID

        ```sh
        $ pulumi import datadog:aws/integration:Integration EXTERNAL_ID=${external_id} datadog_integration_aws.test ${account_id}:${role_name}
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 account_specific_namespace_rules: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 excluded_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 filter_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics_collection_enabled: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["account_specific_namespace_rules"] = account_specific_namespace_rules
            __props__.__dict__["cspm_resource_collection_enabled"] = cspm_resource_collection_enabled
            __props__.__dict__["excluded_regions"] = excluded_regions
            __props__.__dict__["extended_resource_collection_enabled"] = extended_resource_collection_enabled
            __props__.__dict__["filter_tags"] = filter_tags
            __props__.__dict__["host_tags"] = host_tags
            __props__.__dict__["metrics_collection_enabled"] = metrics_collection_enabled
            __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["secret_access_key"] = None if secret_access_key is None else pulumi.Output.secret(secret_access_key)
            __props__.__dict__["external_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'datadog:aws/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[str]] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            account_specific_namespace_rules: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cspm_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
            excluded_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            extended_resource_collection_enabled: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            filter_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metrics_collection_enabled: Optional[pulumi.Input[str]] = None,
            resource_collection_enabled: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            secret_access_key: Optional[pulumi.Input[str]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key_id: Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        :param pulumi.Input[str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[Mapping[str, Any]] account_specific_namespace_rules: Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        :param pulumi.Input[str] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_regions: An array of AWS regions to exclude from metrics collection.
        :param pulumi.Input[str] extended_resource_collection_enabled: Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_tags: Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_tags: Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        :param pulumi.Input[str] metrics_collection_enabled: Whether Datadog collects metrics for this AWS account.
        :param pulumi.Input[str] resource_collection_enabled: Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        :param pulumi.Input[str] role_name: Your Datadog role delegation name.
        :param pulumi.Input[str] secret_access_key: Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["account_specific_namespace_rules"] = account_specific_namespace_rules
        __props__.__dict__["cspm_resource_collection_enabled"] = cspm_resource_collection_enabled
        __props__.__dict__["excluded_regions"] = excluded_regions
        __props__.__dict__["extended_resource_collection_enabled"] = extended_resource_collection_enabled
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["filter_tags"] = filter_tags
        __props__.__dict__["host_tags"] = host_tags
        __props__.__dict__["metrics_collection_enabled"] = metrics_collection_enabled
        __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["secret_access_key"] = secret_access_key
        return Integration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountSpecificNamespaceRules")
    def account_specific_namespace_rules(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
        """
        return pulumi.get(self, "account_specific_namespace_rules")

    @property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> pulumi.Output[str]:
        """
        Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @property
    @pulumi.getter(name="excludedRegions")
    def excluded_regions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of AWS regions to exclude from metrics collection.
        """
        return pulumi.get(self, "excluded_regions")

    @property
    @pulumi.getter(name="extendedResourceCollectionEnabled")
    def extended_resource_collection_enabled(self) -> pulumi.Output[str]:
        """
        Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection_enabled`.
        """
        return pulumi.get(self, "extended_resource_collection_enabled")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="filterTags")
    def filter_tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
        """
        return pulumi.get(self, "filter_tags")

    @property
    @pulumi.getter(name="hostTags")
    def host_tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
        """
        return pulumi.get(self, "host_tags")

    @property
    @pulumi.getter(name="metricsCollectionEnabled")
    def metrics_collection_enabled(self) -> pulumi.Output[str]:
        """
        Whether Datadog collects metrics for this AWS account.
        """
        return pulumi.get(self, "metrics_collection_enabled")

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    @_utilities.deprecated("""Deprecated in favor of `extended_resource_collection_enabled`.""")
    def resource_collection_enabled(self) -> pulumi.Output[str]:
        """
        Whether Datadog collects a standard set of resources from your AWS account. **Deprecated.** Deprecated in favor of `extended_resource_collection_enabled`.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        Your Datadog role delegation name.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[str]]:
        """
        Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
        """
        return pulumi.get(self, "secret_access_key")

