# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 tenant_name: pulumi.Input[str],
                 app_service_plan_filters: Optional[pulumi.Input[str]] = None,
                 automute: Optional[pulumi.Input[bool]] = None,
                 container_app_filters: Optional[pulumi.Input[str]] = None,
                 cspm_enabled: Optional[pulumi.Input[bool]] = None,
                 custom_metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[str] client_id: Your Azure web application ID.
        :param pulumi.Input[str] client_secret: (Required for Initial Creation) Your Azure web application secret key.
        :param pulumi.Input[str] tenant_name: Your Azure Active Directory ID.
        :param pulumi.Input[str] app_service_plan_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        :param pulumi.Input[bool] automute: Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        :param pulumi.Input[str] container_app_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] cspm_enabled: When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
               Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        :param pulumi.Input[bool] custom_metrics_enabled: Enable custom metrics for your organization. Defaults to `false`.
        :param pulumi.Input[str] host_filters: String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "tenant_name", tenant_name)
        if app_service_plan_filters is not None:
            pulumi.set(__self__, "app_service_plan_filters", app_service_plan_filters)
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if container_app_filters is not None:
            pulumi.set(__self__, "container_app_filters", container_app_filters)
        if cspm_enabled is not None:
            pulumi.set(__self__, "cspm_enabled", cspm_enabled)
        if custom_metrics_enabled is not None:
            pulumi.set(__self__, "custom_metrics_enabled", custom_metrics_enabled)
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Your Azure web application ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        (Required for Initial Creation) Your Azure web application secret key.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Input[str]:
        """
        Your Azure Active Directory ID.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_name", value)

    @property
    @pulumi.getter(name="appServicePlanFilters")
    def app_service_plan_filters(self) -> Optional[pulumi.Input[str]]:
        """
        This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        """
        return pulumi.get(self, "app_service_plan_filters")

    @app_service_plan_filters.setter
    def app_service_plan_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_service_plan_filters", value)

    @property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[bool]]:
        """
        Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automute", value)

    @property
    @pulumi.getter(name="containerAppFilters")
    def container_app_filters(self) -> Optional[pulumi.Input[str]]:
        """
        This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "container_app_filters")

    @container_app_filters.setter
    def container_app_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_app_filters", value)

    @property
    @pulumi.getter(name="cspmEnabled")
    def cspm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
        Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_enabled")

    @cspm_enabled.setter
    def cspm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cspm_enabled", value)

    @property
    @pulumi.getter(name="customMetricsEnabled")
    def custom_metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable custom metrics for your organization. Defaults to `false`.
        """
        return pulumi.get(self, "custom_metrics_enabled")

    @custom_metrics_enabled.setter
    def custom_metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_metrics_enabled", value)

    @property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> Optional[pulumi.Input[str]]:
        """
        String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_filters", value)

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 app_service_plan_filters: Optional[pulumi.Input[str]] = None,
                 automute: Optional[pulumi.Input[bool]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 container_app_filters: Optional[pulumi.Input[str]] = None,
                 cspm_enabled: Optional[pulumi.Input[bool]] = None,
                 custom_metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[str] app_service_plan_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        :param pulumi.Input[bool] automute: Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        :param pulumi.Input[str] client_id: Your Azure web application ID.
        :param pulumi.Input[str] client_secret: (Required for Initial Creation) Your Azure web application secret key.
        :param pulumi.Input[str] container_app_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] cspm_enabled: When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
               Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        :param pulumi.Input[bool] custom_metrics_enabled: Enable custom metrics for your organization. Defaults to `false`.
        :param pulumi.Input[str] host_filters: String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        :param pulumi.Input[str] tenant_name: Your Azure Active Directory ID.
        """
        if app_service_plan_filters is not None:
            pulumi.set(__self__, "app_service_plan_filters", app_service_plan_filters)
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if container_app_filters is not None:
            pulumi.set(__self__, "container_app_filters", container_app_filters)
        if cspm_enabled is not None:
            pulumi.set(__self__, "cspm_enabled", cspm_enabled)
        if custom_metrics_enabled is not None:
            pulumi.set(__self__, "custom_metrics_enabled", custom_metrics_enabled)
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)

    @property
    @pulumi.getter(name="appServicePlanFilters")
    def app_service_plan_filters(self) -> Optional[pulumi.Input[str]]:
        """
        This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        """
        return pulumi.get(self, "app_service_plan_filters")

    @app_service_plan_filters.setter
    def app_service_plan_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_service_plan_filters", value)

    @property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[bool]]:
        """
        Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automute", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your Azure web application ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        (Required for Initial Creation) Your Azure web application secret key.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="containerAppFilters")
    def container_app_filters(self) -> Optional[pulumi.Input[str]]:
        """
        This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "container_app_filters")

    @container_app_filters.setter
    def container_app_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_app_filters", value)

    @property
    @pulumi.getter(name="cspmEnabled")
    def cspm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
        Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_enabled")

    @cspm_enabled.setter
    def cspm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cspm_enabled", value)

    @property
    @pulumi.getter(name="customMetricsEnabled")
    def custom_metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable custom metrics for your organization. Defaults to `false`.
        """
        return pulumi.get(self, "custom_metrics_enabled")

    @custom_metrics_enabled.setter
    def custom_metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_metrics_enabled", value)

    @property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> Optional[pulumi.Input[str]]:
        """
        String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_filters", value)

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resource_collection_enabled", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[str]]:
        """
        Your Azure Active Directory ID.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_name", value)


class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_plan_filters: Optional[pulumi.Input[str]] = None,
                 automute: Optional[pulumi.Input[bool]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 container_app_filters: Optional[pulumi.Input[str]] = None,
                 cspm_enabled: Optional[pulumi.Input[bool]] = None,
                 custom_metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog - Microsoft Azure integration resource. This can be used to create and manage the integrations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog - Microsoft Azure integration
        sandbox = datadog.azure.Integration("sandbox",
            tenant_name="<azure_tenant_name>",
            client_id="<azure_client_id>",
            client_secret="<azure_client_secret_key>",
            host_filters="examplefilter:true,example:true",
            app_service_plan_filters="examplefilter:true,example:another",
            container_app_filters="examplefilter:true,example:one_more",
            automute=True,
            cspm_enabled=True,
            custom_metrics_enabled=False)
        ```

        ## Import

        Microsoft Azure integrations can be imported using their `tenant name` and `client` id separated with a colon (`:`).

        ```sh
        $ pulumi import datadog:azure/integration:Integration sandbox ${tenant_name}:${client_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_service_plan_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        :param pulumi.Input[bool] automute: Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        :param pulumi.Input[str] client_id: Your Azure web application ID.
        :param pulumi.Input[str] client_secret: (Required for Initial Creation) Your Azure web application secret key.
        :param pulumi.Input[str] container_app_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] cspm_enabled: When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
               Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        :param pulumi.Input[bool] custom_metrics_enabled: Enable custom metrics for your organization. Defaults to `false`.
        :param pulumi.Input[str] host_filters: String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        :param pulumi.Input[str] tenant_name: Your Azure Active Directory ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog - Microsoft Azure integration resource. This can be used to create and manage the integrations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog - Microsoft Azure integration
        sandbox = datadog.azure.Integration("sandbox",
            tenant_name="<azure_tenant_name>",
            client_id="<azure_client_id>",
            client_secret="<azure_client_secret_key>",
            host_filters="examplefilter:true,example:true",
            app_service_plan_filters="examplefilter:true,example:another",
            container_app_filters="examplefilter:true,example:one_more",
            automute=True,
            cspm_enabled=True,
            custom_metrics_enabled=False)
        ```

        ## Import

        Microsoft Azure integrations can be imported using their `tenant name` and `client` id separated with a colon (`:`).

        ```sh
        $ pulumi import datadog:azure/integration:Integration sandbox ${tenant_name}:${client_id}
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_plan_filters: Optional[pulumi.Input[str]] = None,
                 automute: Optional[pulumi.Input[bool]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 container_app_filters: Optional[pulumi.Input[str]] = None,
                 cspm_enabled: Optional[pulumi.Input[bool]] = None,
                 custom_metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["app_service_plan_filters"] = app_service_plan_filters
            __props__.__dict__["automute"] = automute
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["container_app_filters"] = container_app_filters
            __props__.__dict__["cspm_enabled"] = cspm_enabled
            __props__.__dict__["custom_metrics_enabled"] = custom_metrics_enabled
            __props__.__dict__["host_filters"] = host_filters
            __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
            if tenant_name is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_name'")
            __props__.__dict__["tenant_name"] = tenant_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'datadog:azure/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_plan_filters: Optional[pulumi.Input[str]] = None,
            automute: Optional[pulumi.Input[bool]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            container_app_filters: Optional[pulumi.Input[str]] = None,
            cspm_enabled: Optional[pulumi.Input[bool]] = None,
            custom_metrics_enabled: Optional[pulumi.Input[bool]] = None,
            host_filters: Optional[pulumi.Input[str]] = None,
            resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
            tenant_name: Optional[pulumi.Input[str]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_service_plan_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        :param pulumi.Input[bool] automute: Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        :param pulumi.Input[str] client_id: Your Azure web application ID.
        :param pulumi.Input[str] client_secret: (Required for Initial Creation) Your Azure web application secret key.
        :param pulumi.Input[str] container_app_filters: This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] cspm_enabled: When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
               Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        :param pulumi.Input[bool] custom_metrics_enabled: Enable custom metrics for your organization. Defaults to `false`.
        :param pulumi.Input[str] host_filters: String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        :param pulumi.Input[str] tenant_name: Your Azure Active Directory ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["app_service_plan_filters"] = app_service_plan_filters
        __props__.__dict__["automute"] = automute
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["container_app_filters"] = container_app_filters
        __props__.__dict__["cspm_enabled"] = cspm_enabled
        __props__.__dict__["custom_metrics_enabled"] = custom_metrics_enabled
        __props__.__dict__["host_filters"] = host_filters
        __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        __props__.__dict__["tenant_name"] = tenant_name
        return Integration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appServicePlanFilters")
    def app_service_plan_filters(self) -> pulumi.Output[str]:
        """
        This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure App Service Plans. Only App Service Plans that match one of the defined tags are imported into Datadog. The rest, including the apps and functions running on them, are ignored. This also filters the metrics for any App or Function running on the App Service Plan(s). Defaults to `""`.
        """
        return pulumi.get(self, "app_service_plan_filters")

    @property
    @pulumi.getter
    def automute(self) -> pulumi.Output[bool]:
        """
        Silence monitors for expected Azure VM shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        Your Azure web application ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        (Required for Initial Creation) Your Azure web application secret key.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="containerAppFilters")
    def container_app_filters(self) -> pulumi.Output[str]:
        """
        This comma-separated list of tags (in the form `key:value,key:value`) defines a filter that Datadog uses when collecting metrics from Azure Container Apps. Only Container Apps that match one of the defined tags are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "container_app_filters")

    @property
    @pulumi.getter(name="cspmEnabled")
    def cspm_enabled(self) -> pulumi.Output[bool]:
        """
        When enabled, Datadog’s Cloud Security Management product scans resource configurations monitored by this app registration.
        Note: This requires `resource_collection_enabled` to be set to true. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_enabled")

    @property
    @pulumi.getter(name="customMetricsEnabled")
    def custom_metrics_enabled(self) -> pulumi.Output[bool]:
        """
        Enable custom metrics for your organization. Defaults to `false`.
        """
        return pulumi.get(self, "custom_metrics_enabled")

    @property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> pulumi.Output[str]:
        """
        String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red` Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> pulumi.Output[bool]:
        """
        When enabled, Datadog collects metadata and configuration info from cloud resources (such as compute instances, databases, and load balancers) monitored by this app registration.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Output[str]:
        """
        Your Azure Active Directory ID.
        """
        return pulumi.get(self, "tenant_name")

