# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

import types

__config__ = pulumi.Config('datadog')


class _ExportableConfig(types.ModuleType):
    @property
    def api_key(self) -> Optional[str]:
        """
        (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        """
        return __config__.get('apiKey')

    @property
    def api_url(self) -> Optional[str]:
        """
        The API URL. This can also be set via the DD_HOST environment variable. Note that this URL must not end with the `/api/`
        path. For example, `https://api.datadoghq.com/` is a correct value, while `https://api.datadoghq.com/api/` is not. And
        if you're working with "EU" version of Datadog, use `https://api.datadoghq.eu/`. Other Datadog region examples:
        `https://api.us5.datadoghq.com/`, `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See
        https://docs.datadoghq.com/getting_started/site/ for all available regions.
        """
        return __config__.get('apiUrl')

    @property
    def app_key(self) -> Optional[str]:
        """
        (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        """
        return __config__.get('appKey')

    @property
    def http_client_retry_backoff_base(self) -> Optional[int]:
        """
        The HTTP request retry back off base. Defaults to 2.
        """
        return __config__.get_int('httpClientRetryBackoffBase')

    @property
    def http_client_retry_backoff_multiplier(self) -> Optional[int]:
        """
        The HTTP request retry back off multiplier. Defaults to 2.
        """
        return __config__.get_int('httpClientRetryBackoffMultiplier')

    @property
    def http_client_retry_enabled(self) -> Optional[str]:
        """
        Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        """
        return __config__.get('httpClientRetryEnabled')

    @property
    def http_client_retry_max_retries(self) -> Optional[int]:
        """
        The HTTP request maximum retry number. Defaults to 3.
        """
        return __config__.get_int('httpClientRetryMaxRetries')

    @property
    def http_client_retry_timeout(self) -> Optional[int]:
        """
        The HTTP request retry timeout period. Defaults to 60 seconds.
        """
        return __config__.get_int('httpClientRetryTimeout')

    @property
    def validate(self) -> Optional[str]:
        """
        Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
        is true. When false, api_key won't be checked.
        """
        return __config__.get('validate')

