# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 layout_type: pulumi.Input[str],
                 title: pulumi.Input[str],
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 notify_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reflow_type: Optional[pulumi.Input[str]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_variable_presets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input[str] layout_type: The layout type of the dashboard. Valid values are `ordered`, `free`.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] description: The description of the dashboard.
        :param pulumi.Input[bool] is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_lists: The list of handles for the users to notify when changes are made to this dashboard.
        :param pulumi.Input[str] reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]] template_variable_presets: The list of selectable template variable presets for this dashboard.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]] template_variables: The list of template variables for this dashboard.
        :param pulumi.Input[str] url: The URL of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]] widgets: The list of widgets to display on the dashboard.
        """
        pulumi.set(__self__, "layout_type", layout_type)
        pulumi.set(__self__, "title", title)
        if dashboard_lists is not None:
            pulumi.set(__self__, "dashboard_lists", dashboard_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_read_only is not None:
            warnings.warn("""Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""", DeprecationWarning)
            pulumi.log.warn("""is_read_only is deprecated: Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""")
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if notify_lists is not None:
            pulumi.set(__self__, "notify_lists", notify_lists)
        if reflow_type is not None:
            pulumi.set(__self__, "reflow_type", reflow_type)
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_variable_presets is not None:
            pulumi.set(__self__, "template_variable_presets", template_variable_presets)
        if template_variables is not None:
            pulumi.set(__self__, "template_variables", template_variables)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter(name="layoutType")
    def layout_type(self) -> pulumi.Input[str]:
        """
        The layout type of the dashboard. Valid values are `ordered`, `free`.
        """
        return pulumi.get(self, "layout_type")

    @layout_type.setter
    def layout_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "layout_type", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="dashboardLists")
    def dashboard_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        return pulumi.get(self, "dashboard_lists")

    @dashboard_lists.setter
    def dashboard_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "dashboard_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isReadOnly")
    @_utilities.deprecated("""Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""")
    def is_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only", value)

    @property
    @pulumi.getter(name="notifyLists")
    def notify_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of handles for the users to notify when changes are made to this dashboard.
        """
        return pulumi.get(self, "notify_lists")

    @notify_lists.setter
    def notify_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notify_lists", value)

    @property
    @pulumi.getter(name="reflowType")
    def reflow_type(self) -> Optional[pulumi.Input[str]]:
        """
        The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        """
        return pulumi.get(self, "reflow_type")

    @reflow_type.setter
    def reflow_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reflow_type", value)

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        UUIDs of roles whose associated users are authorized to edit the dashboard.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateVariablePresets")
    def template_variable_presets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]]]:
        """
        The list of selectable template variable presets for this dashboard.
        """
        return pulumi.get(self, "template_variable_presets")

    @template_variable_presets.setter
    def template_variable_presets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]]]):
        pulumi.set(self, "template_variable_presets", value)

    @property
    @pulumi.getter(name="templateVariables")
    def template_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]]]:
        """
        The list of template variables for this dashboard.
        """
        return pulumi.get(self, "template_variables")

    @template_variables.setter
    def template_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]]]):
        pulumi.set(self, "template_variables", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the dashboard.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]]:
        """
        The list of widgets to display on the dashboard.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 dashboard_lists_removeds: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 layout_type: Optional[pulumi.Input[str]] = None,
                 notify_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reflow_type: Optional[pulumi.Input[str]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_variable_presets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] dashboard_lists_removeds: A list of dashboard lists this dashboard should be removed from. Internal only.
        :param pulumi.Input[str] description: The description of the dashboard.
        :param pulumi.Input[bool] is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        :param pulumi.Input[str] layout_type: The layout type of the dashboard. Valid values are `ordered`, `free`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_lists: The list of handles for the users to notify when changes are made to this dashboard.
        :param pulumi.Input[str] reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]] template_variable_presets: The list of selectable template variable presets for this dashboard.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]] template_variables: The list of template variables for this dashboard.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] url: The URL of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]] widgets: The list of widgets to display on the dashboard.
        """
        if dashboard_lists is not None:
            pulumi.set(__self__, "dashboard_lists", dashboard_lists)
        if dashboard_lists_removeds is not None:
            pulumi.set(__self__, "dashboard_lists_removeds", dashboard_lists_removeds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_read_only is not None:
            warnings.warn("""Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""", DeprecationWarning)
            pulumi.log.warn("""is_read_only is deprecated: Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""")
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if layout_type is not None:
            pulumi.set(__self__, "layout_type", layout_type)
        if notify_lists is not None:
            pulumi.set(__self__, "notify_lists", notify_lists)
        if reflow_type is not None:
            pulumi.set(__self__, "reflow_type", reflow_type)
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_variable_presets is not None:
            pulumi.set(__self__, "template_variable_presets", template_variable_presets)
        if template_variables is not None:
            pulumi.set(__self__, "template_variables", template_variables)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter(name="dashboardLists")
    def dashboard_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        return pulumi.get(self, "dashboard_lists")

    @dashboard_lists.setter
    def dashboard_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "dashboard_lists", value)

    @property
    @pulumi.getter(name="dashboardListsRemoveds")
    def dashboard_lists_removeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of dashboard lists this dashboard should be removed from. Internal only.
        """
        return pulumi.get(self, "dashboard_lists_removeds")

    @dashboard_lists_removeds.setter
    def dashboard_lists_removeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "dashboard_lists_removeds", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isReadOnly")
    @_utilities.deprecated("""Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""")
    def is_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only", value)

    @property
    @pulumi.getter(name="layoutType")
    def layout_type(self) -> Optional[pulumi.Input[str]]:
        """
        The layout type of the dashboard. Valid values are `ordered`, `free`.
        """
        return pulumi.get(self, "layout_type")

    @layout_type.setter
    def layout_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "layout_type", value)

    @property
    @pulumi.getter(name="notifyLists")
    def notify_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of handles for the users to notify when changes are made to this dashboard.
        """
        return pulumi.get(self, "notify_lists")

    @notify_lists.setter
    def notify_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notify_lists", value)

    @property
    @pulumi.getter(name="reflowType")
    def reflow_type(self) -> Optional[pulumi.Input[str]]:
        """
        The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        """
        return pulumi.get(self, "reflow_type")

    @reflow_type.setter
    def reflow_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reflow_type", value)

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        UUIDs of roles whose associated users are authorized to edit the dashboard.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateVariablePresets")
    def template_variable_presets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]]]:
        """
        The list of selectable template variable presets for this dashboard.
        """
        return pulumi.get(self, "template_variable_presets")

    @template_variable_presets.setter
    def template_variable_presets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariablePresetArgs']]]]):
        pulumi.set(self, "template_variable_presets", value)

    @property
    @pulumi.getter(name="templateVariables")
    def template_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]]]:
        """
        The list of template variables for this dashboard.
        """
        return pulumi.get(self, "template_variables")

    @template_variables.setter
    def template_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTemplateVariableArgs']]]]):
        pulumi.set(self, "template_variables", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the dashboard.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]]:
        """
        The list of widgets to display on the dashboard.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardWidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 layout_type: Optional[pulumi.Input[str]] = None,
                 notify_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reflow_type: Optional[pulumi.Input[str]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_variable_presets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariablePresetArgs']]]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariableArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]]] = None,
                 __props__=None):
        """
        Provides a Datadog dashboard resource. This can be used to create and manage Datadog dashboards.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Example Ordered Layout
        ordered_dashboard = datadog.Dashboard("ordered_dashboard",
            title="Ordered Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="ordered",
            widgets=[
                datadog.DashboardWidgetArgs(
                    alert_graph_definition=datadog.DashboardWidgetAlertGraphDefinitionArgs(
                        alert_id="895605",
                        viz_type="timeseries",
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    alert_value_definition=datadog.DashboardWidgetAlertValueDefinitionArgs(
                        alert_id="895605",
                        precision=3,
                        unit="b",
                        text_align="center",
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    alert_value_definition=datadog.DashboardWidgetAlertValueDefinitionArgs(
                        alert_id="895605",
                        precision=3,
                        unit="b",
                        text_align="center",
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    change_definition=datadog.DashboardWidgetChangeDefinitionArgs(
                        requests=[datadog.DashboardWidgetChangeDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            change_type="absolute",
                            compare_to="week_before",
                            increase_good=True,
                            order_by="name",
                            order_dir="desc",
                            show_present=True,
                        )],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    distribution_definition=datadog.DashboardWidgetDistributionDefinitionArgs(
                        requests=[datadog.DashboardWidgetDistributionDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            style=datadog.DashboardWidgetDistributionDefinitionRequestStyleArgs(
                                palette="warm",
                            ),
                        )],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    check_status_definition=datadog.DashboardWidgetCheckStatusDefinitionArgs(
                        check="aws.ecs.agent_connected",
                        grouping="cluster",
                        group_bies=[
                            "account",
                            "cluster",
                        ],
                        tags=[
                            "account:demo",
                            "cluster:awseb-ruthebdog-env-8-dn3m6u3gvk",
                        ],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    heatmap_definition=datadog.DashboardWidgetHeatmapDefinitionArgs(
                        requests=[datadog.DashboardWidgetHeatmapDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            style=datadog.DashboardWidgetHeatmapDefinitionRequestStyleArgs(
                                palette="warm",
                            ),
                        )],
                        yaxis=datadog.DashboardWidgetHeatmapDefinitionYaxisArgs(
                            min="1",
                            max="2",
                            include_zero=True,
                            scale="sqrt",
                        ),
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    hostmap_definition=datadog.DashboardWidgetHostmapDefinitionArgs(
                        request=datadog.DashboardWidgetHostmapDefinitionRequestArgs(
                            fills=[datadog.DashboardWidgetHostmapDefinitionRequestFillArgs(
                                q="avg:system.load.1{*} by {host}",
                            )],
                            sizes=[datadog.DashboardWidgetHostmapDefinitionRequestSizeArgs(
                                q="avg:memcache.uptime{*} by {host}",
                            )],
                        ),
                        node_type="container",
                        groups=[
                            "host",
                            "region",
                        ],
                        no_group_hosts=True,
                        no_metric_hosts=True,
                        scopes=[
                            "region:us-east-1",
                            "aws_account:727006795293",
                        ],
                        style=datadog.DashboardWidgetHostmapDefinitionStyleArgs(
                            palette="yellow_to_green",
                            palette_flip=True,
                            fill_min="10",
                            fill_max="20",
                        ),
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    note_definition=datadog.DashboardWidgetNoteDefinitionArgs(
                        content="note text",
                        background_color="pink",
                        font_size="14",
                        text_align="center",
                        show_tick=True,
                        tick_edge="left",
                        tick_pos="50%",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    query_value_definition=datadog.DashboardWidgetQueryValueDefinitionArgs(
                        requests=[datadog.DashboardWidgetQueryValueDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            aggregator="sum",
                            conditional_formats=[
                                datadog.DashboardWidgetQueryValueDefinitionRequestConditionalFormatArgs(
                                    comparator="<",
                                    value=2,
                                    palette="white_on_green",
                                ),
                                datadog.DashboardWidgetQueryValueDefinitionRequestConditionalFormatArgs(
                                    comparator=">",
                                    value=2.2,
                                    palette="white_on_red",
                                ),
                            ],
                        )],
                        autoscale=True,
                        custom_unit="xx",
                        precision=4,
                        text_align="right",
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    query_table_definition=datadog.DashboardWidgetQueryTableDefinitionArgs(
                        requests=[datadog.DashboardWidgetQueryTableDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            aggregator="sum",
                            limit=10,
                            conditional_formats=[
                                datadog.DashboardWidgetQueryTableDefinitionRequestConditionalFormatArgs(
                                    comparator="<",
                                    value=2,
                                    palette="white_on_green",
                                ),
                                datadog.DashboardWidgetQueryTableDefinitionRequestConditionalFormatArgs(
                                    comparator=">",
                                    value=2.2,
                                    palette="white_on_red",
                                ),
                            ],
                        )],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    scatterplot_definition=datadog.DashboardWidgetScatterplotDefinitionArgs(
                        request=datadog.DashboardWidgetScatterplotDefinitionRequestArgs(
                            xes=[datadog.DashboardWidgetScatterplotDefinitionRequestXArgs(
                                q="avg:system.cpu.user{*} by {service, account}",
                                aggregator="max",
                            )],
                            ys=[datadog.DashboardWidgetScatterplotDefinitionRequestYArgs(
                                q="avg:system.mem.used{*} by {service, account}",
                                aggregator="min",
                            )],
                        ),
                        color_by_groups=[
                            "account",
                            "apm-role-group",
                        ],
                        xaxis=datadog.DashboardWidgetScatterplotDefinitionXaxisArgs(
                            include_zero=True,
                            label="x",
                            min="1",
                            max="2000",
                            scale="pow",
                        ),
                        yaxis=datadog.DashboardWidgetScatterplotDefinitionYaxisArgs(
                            include_zero=False,
                            label="y",
                            min="5",
                            max="2222",
                            scale="log",
                        ),
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    servicemap_definition=datadog.DashboardWidgetServicemapDefinitionArgs(
                        service="master-db",
                        filters=[
                            "env:prod",
                            "datacenter:dc1",
                        ],
                        title="env: prod, datacenter:dc1, service: master-db",
                        title_size="16",
                        title_align="left",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                q="avg:system.cpu.user{app:general} by {env}",
                                display_type="line",
                                style=datadog.DashboardWidgetTimeseriesDefinitionRequestStyleArgs(
                                    palette="warm",
                                    line_type="dashed",
                                    line_width="thin",
                                ),
                                metadatas=[datadog.DashboardWidgetTimeseriesDefinitionRequestMetadataArgs(
                                    expression="avg:system.cpu.user{app:general} by {env}",
                                    alias_name="Alpha",
                                )],
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                log_query=datadog.DashboardWidgetLogQueryArgs(
                                    index="mcnulty",
                                    compute_query=datadog.DashboardWidgetLogQueryComputeQueryArgs(
                                        aggregation="avg",
                                        facet="@duration",
                                        interval=5000,
                                    ),
                                    search_query="status:info",
                                    group_bies=[datadog.DashboardWidgetLogQueryGroupByArgs(
                                        facet="host",
                                        limit=10,
                                        sort_query=datadog.DashboardWidgetLogQueryGroupBySortQueryArgs(
                                            aggregation="avg",
                                            order="desc",
                                            facet="@duration",
                                        ),
                                    )],
                                ),
                                display_type="area",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                apm_query=datadog.DashboardWidgetApmQueryArgs(
                                    index="apm-search",
                                    compute_query=datadog.DashboardWidgetApmQueryComputeQueryArgs(
                                        aggregation="avg",
                                        facet="@duration",
                                        interval=5000,
                                    ),
                                    search_query="type:web",
                                    group_bies=[datadog.DashboardWidgetApmQueryGroupByArgs(
                                        facet="resource_name",
                                        limit=50,
                                        sort_query=datadog.DashboardWidgetApmQueryGroupBySortQueryArgs(
                                            aggregation="avg",
                                            order="desc",
                                            facet="@string_query.interval",
                                        ),
                                    )],
                                ),
                                display_type="bars",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                process_query=datadog.DashboardWidgetTimeseriesDefinitionRequestProcessQueryArgs(
                                    metric="process.stat.cpu.total_pct",
                                    search_by="error",
                                    filter_bies=["active"],
                                    limit=50,
                                ),
                                display_type="area",
                            ),
                        ],
                        markers=[
                            datadog.DashboardWidgetTimeseriesDefinitionMarkerArgs(
                                display_type="error dashed",
                                label=" z=6 ",
                                value="y = 4",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionMarkerArgs(
                                display_type="ok solid",
                                value="10 < y < 999",
                                label=" x=8 ",
                            ),
                        ],
                        title="Widget Title",
                        show_legend=True,
                        legend_size="2",
                        live_span="1h",
                        events=[
                            datadog.DashboardWidgetTimeseriesDefinitionEventArgs(
                                q="sources:test tags:1",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionEventArgs(
                                q="sources:test tags:2",
                            ),
                        ],
                        yaxis=datadog.DashboardWidgetTimeseriesDefinitionYaxisArgs(
                            scale="log",
                            include_zero=False,
                            max="100",
                        ),
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    toplist_definition=datadog.DashboardWidgetToplistDefinitionArgs(
                        requests=[datadog.DashboardWidgetToplistDefinitionRequestArgs(
                            q="avg:system.cpu.user{app:general} by {env}",
                            conditional_formats=[
                                datadog.DashboardWidgetToplistDefinitionRequestConditionalFormatArgs(
                                    comparator="<",
                                    value=2,
                                    palette="white_on_green",
                                ),
                                datadog.DashboardWidgetToplistDefinitionRequestConditionalFormatArgs(
                                    comparator=">",
                                    value=2.2,
                                    palette="white_on_red",
                                ),
                            ],
                        )],
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    group_definition=datadog.DashboardWidgetGroupDefinitionArgs(
                        layout_type="ordered",
                        title="Group Widget",
                        widgets=[
                            datadog.DashboardWidgetGroupDefinitionWidgetArgs(
                                note_definition=datadog.DashboardWidgetNoteDefinitionArgs(
                                    content="cluster note widget",
                                    background_color="pink",
                                    font_size="14",
                                    text_align="center",
                                    show_tick=True,
                                    tick_edge="left",
                                    tick_pos="50%",
                                ),
                            ),
                            datadog.DashboardWidgetGroupDefinitionWidgetArgs(
                                alert_graph_definition=datadog.DashboardWidgetAlertGraphDefinitionArgs(
                                    alert_id="123",
                                    viz_type="toplist",
                                    title="Alert Graph",
                                    live_span="1h",
                                ),
                            ),
                        ],
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    service_level_objective_definition=datadog.DashboardWidgetServiceLevelObjectiveDefinitionArgs(
                        title="Widget Title",
                        view_type="detail",
                        slo_id="56789",
                        show_error_budget=True,
                        view_mode="overall",
                        time_windows=[
                            "7d",
                            "previous_week",
                        ],
                    ),
                ),
            ],
            template_variables=[
                datadog.DashboardTemplateVariableArgs(
                    name="var_1",
                    prefix="host",
                    default="aws",
                ),
                datadog.DashboardTemplateVariableArgs(
                    name="var_2",
                    prefix="service_name",
                    default="autoscaling",
                ),
            ],
            template_variable_presets=[datadog.DashboardTemplateVariablePresetArgs(
                name="preset_1",
                template_variables=[
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_1",
                        value="host.dc",
                    ),
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_2",
                        value="my_service",
                    ),
                ],
            )])
        # Example Free Layout
        free_dashboard = datadog.Dashboard("free_dashboard",
            title="Free Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="free",
            widgets=[
                datadog.DashboardWidgetArgs(
                    event_stream_definition=datadog.DashboardWidgetEventStreamDefinitionArgs(
                        query="*",
                        event_size="l",
                        title="Widget Title",
                        title_size="16",
                        title_align="left",
                        live_span="1h",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=43,
                        width=32,
                        x=0,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    event_timeline_definition=datadog.DashboardWidgetEventTimelineDefinitionArgs(
                        query="*",
                        title="Widget Title",
                        title_size="16",
                        title_align="left",
                        live_span="1h",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=9,
                        width=66,
                        x=33,
                        y=60,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    free_text_definition=datadog.DashboardWidgetFreeTextDefinitionArgs(
                        text="free text content",
                        color="#d00",
                        font_size="36",
                        text_align="left",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=20,
                        width=34,
                        x=33,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    iframe_definition=datadog.DashboardWidgetIframeDefinitionArgs(
                        url="http://google.com",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=46,
                        width=39,
                        x=101,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    image_definition=datadog.DashboardWidgetImageDefinitionArgs(
                        url="https://images.pexels.com/photos/67636/rose-blue-flower-rose-blooms-67636.jpeg?auto=compress&cs=tinysrgb&h=350",
                        sizing="fit",
                        margin="small",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=20,
                        width=30,
                        x=69,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    log_stream_definition=datadog.DashboardWidgetLogStreamDefinitionArgs(
                        indexes=["main"],
                        query="error",
                        columns=[
                            "core_host",
                            "core_service",
                            "tag_source",
                        ],
                        show_date_column=True,
                        show_message_column=True,
                        message_display="expanded-md",
                        sort=datadog.DashboardWidgetLogStreamDefinitionSortArgs(
                            column="time",
                            order="desc",
                        ),
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=36,
                        width=32,
                        x=0,
                        y=45,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    manage_status_definition=datadog.DashboardWidgetManageStatusDefinitionArgs(
                        color_preference="text",
                        display_format="countsAndList",
                        hide_zero_counts=True,
                        query="type:metric",
                        show_last_triggered=False,
                        sort="status,asc",
                        summary_type="monitors",
                        title="Widget Title",
                        title_size="16",
                        title_align="left",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=40,
                        width=30,
                        x=101,
                        y=48,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    trace_service_definition=datadog.DashboardWidgetTraceServiceDefinitionArgs(
                        display_format="three_column",
                        env="datadog.com",
                        service="alerting-cassandra",
                        show_breakdown=True,
                        show_distribution=True,
                        show_errors=True,
                        show_hits=True,
                        show_latency=False,
                        show_resource_list=False,
                        size_format="large",
                        span_name="cassandra.query",
                        title="alerting-cassandra #env:datadog.com",
                        title_align="center",
                        title_size="13",
                        live_span="1h",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=38,
                        width=66,
                        x=33,
                        y=21,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                            formulas=[
                                datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaArgs(
                                    formula_expression="my_query_1 + my_query_2",
                                    alias="my ff query",
                                ),
                                datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaArgs(
                                    formula_expression="my_query_1 * my_query_2",
                                    limit=datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaLimitArgs(
                                        count=5,
                                        order="desc",
                                    ),
                                    alias="my second ff query",
                                ),
                            ],
                            queries=[
                                datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    metric_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryMetricQueryArgs(
                                        data_source="metrics",
                                        query="avg:system.cpu.user{app:general} by {env}",
                                        name="my_query_1",
                                        aggregator="sum",
                                    ),
                                ),
                                datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    metric_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryMetricQueryArgs(
                                        query="avg:system.cpu.user{app:general} by {env}",
                                        name="my_query_2",
                                        aggregator="sum",
                                    ),
                                ),
                            ],
                        )],
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=16,
                        width=25,
                        x=58,
                        y=83,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    event_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryArgs(
                                        name="my-query",
                                        data_source="logs",
                                        indexes=["days-3"],
                                        computes=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryComputeArgs(
                                            aggregation="count",
                                        )],
                                        group_bies=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryGroupByArgs(
                                            facet="host",
                                            sort=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryGroupBySortArgs(
                                                metric="@lambda.max_memory_used",
                                                aggregation="avg",
                                            ),
                                            limit=10,
                                        )],
                                    ),
                                )],
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                display_type="overlay",
                                queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    metric_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryMetricQueryArgs(
                                        name="MyOverlay",
                                        data_source="metrics",
                                        query="avg:system.cpu.user{host:COMP-QJWVM2FYT4}",
                                    ),
                                )],
                            ),
                        ],
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=16,
                        width=28,
                        x=29,
                        y=83,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                            queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                process_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryProcessQueryArgs(
                                    data_source="process",
                                    text_filter="abc",
                                    metric="process.stat.cpu.total_pct",
                                    limit=10,
                                    tag_filters=["some_filter"],
                                    name="my_process_query",
                                    sort="asc",
                                    is_normalized_cpu=True,
                                    aggregator="sum",
                                ),
                            )],
                        )],
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=16,
                        width=28,
                        x=0,
                        y=83,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                            formulas=[datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaArgs(
                                formula_expression="query1",
                                alias="my cloud cost query",
                            )],
                            queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                cloud_cost_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryCloudCostQueryArgs(
                                    data_source="cloud_cost",
                                    query="sum:aws.cost.amortized{*}",
                                    name="query1",
                                    aggregator="sum",
                                ),
                            )],
                        )],
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    powerpack_definition=datadog.DashboardWidgetPowerpackDefinitionArgs(
                        powerpack_id="00000000-0000-0000-0000-000000000000",
                        background_color="blue",
                        banner_img="https://example.org/example.png",
                        show_title=True,
                        title="Powerpack Widget",
                        template_variables=datadog.DashboardWidgetPowerpackDefinitionTemplateVariablesArgs(
                            controlled_externallies=[datadog.DashboardWidgetPowerpackDefinitionTemplateVariablesControlledExternallyArgs(
                                name="var_2",
                                values=["autoscaling"],
                                prefix="service_name",
                            )],
                            controlled_by_powerpacks=[datadog.DashboardWidgetPowerpackDefinitionTemplateVariablesControlledByPowerpackArgs(
                                name="var_3",
                                prefix="timeframe",
                                values=[
                                    "default",
                                    "values",
                                    "here",
                                ],
                            )],
                        ),
                    ),
                ),
            ],
            template_variables=[
                datadog.DashboardTemplateVariableArgs(
                    name="var_1",
                    prefix="host",
                    default="aws",
                ),
                datadog.DashboardTemplateVariableArgs(
                    name="var_2",
                    prefix="service_name",
                    default="autoscaling",
                ),
            ],
            template_variable_presets=[datadog.DashboardTemplateVariablePresetArgs(
                name="preset_1",
                template_variables=[
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_1",
                        value="host.dc",
                    ),
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_2",
                        value="my_service",
                    ),
                ],
            )])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/dashboard:Dashboard my_service_dashboard sv7-gyh-kas
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the dashboard.
        :param pulumi.Input[bool] is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        :param pulumi.Input[str] layout_type: The layout type of the dashboard. Valid values are `ordered`, `free`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_lists: The list of handles for the users to notify when changes are made to this dashboard.
        :param pulumi.Input[str] reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariablePresetArgs']]]] template_variable_presets: The list of selectable template variable presets for this dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariableArgs']]]] template_variables: The list of template variables for this dashboard.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] url: The URL of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]] widgets: The list of widgets to display on the dashboard.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog dashboard resource. This can be used to create and manage Datadog dashboards.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Example Ordered Layout
        ordered_dashboard = datadog.Dashboard("ordered_dashboard",
            title="Ordered Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="ordered",
            widgets=[
                datadog.DashboardWidgetArgs(
                    alert_graph_definition=datadog.DashboardWidgetAlertGraphDefinitionArgs(
                        alert_id="895605",
                        viz_type="timeseries",
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    alert_value_definition=datadog.DashboardWidgetAlertValueDefinitionArgs(
                        alert_id="895605",
                        precision=3,
                        unit="b",
                        text_align="center",
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    alert_value_definition=datadog.DashboardWidgetAlertValueDefinitionArgs(
                        alert_id="895605",
                        precision=3,
                        unit="b",
                        text_align="center",
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    change_definition=datadog.DashboardWidgetChangeDefinitionArgs(
                        requests=[datadog.DashboardWidgetChangeDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            change_type="absolute",
                            compare_to="week_before",
                            increase_good=True,
                            order_by="name",
                            order_dir="desc",
                            show_present=True,
                        )],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    distribution_definition=datadog.DashboardWidgetDistributionDefinitionArgs(
                        requests=[datadog.DashboardWidgetDistributionDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            style=datadog.DashboardWidgetDistributionDefinitionRequestStyleArgs(
                                palette="warm",
                            ),
                        )],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    check_status_definition=datadog.DashboardWidgetCheckStatusDefinitionArgs(
                        check="aws.ecs.agent_connected",
                        grouping="cluster",
                        group_bies=[
                            "account",
                            "cluster",
                        ],
                        tags=[
                            "account:demo",
                            "cluster:awseb-ruthebdog-env-8-dn3m6u3gvk",
                        ],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    heatmap_definition=datadog.DashboardWidgetHeatmapDefinitionArgs(
                        requests=[datadog.DashboardWidgetHeatmapDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            style=datadog.DashboardWidgetHeatmapDefinitionRequestStyleArgs(
                                palette="warm",
                            ),
                        )],
                        yaxis=datadog.DashboardWidgetHeatmapDefinitionYaxisArgs(
                            min="1",
                            max="2",
                            include_zero=True,
                            scale="sqrt",
                        ),
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    hostmap_definition=datadog.DashboardWidgetHostmapDefinitionArgs(
                        request=datadog.DashboardWidgetHostmapDefinitionRequestArgs(
                            fills=[datadog.DashboardWidgetHostmapDefinitionRequestFillArgs(
                                q="avg:system.load.1{*} by {host}",
                            )],
                            sizes=[datadog.DashboardWidgetHostmapDefinitionRequestSizeArgs(
                                q="avg:memcache.uptime{*} by {host}",
                            )],
                        ),
                        node_type="container",
                        groups=[
                            "host",
                            "region",
                        ],
                        no_group_hosts=True,
                        no_metric_hosts=True,
                        scopes=[
                            "region:us-east-1",
                            "aws_account:727006795293",
                        ],
                        style=datadog.DashboardWidgetHostmapDefinitionStyleArgs(
                            palette="yellow_to_green",
                            palette_flip=True,
                            fill_min="10",
                            fill_max="20",
                        ),
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    note_definition=datadog.DashboardWidgetNoteDefinitionArgs(
                        content="note text",
                        background_color="pink",
                        font_size="14",
                        text_align="center",
                        show_tick=True,
                        tick_edge="left",
                        tick_pos="50%",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    query_value_definition=datadog.DashboardWidgetQueryValueDefinitionArgs(
                        requests=[datadog.DashboardWidgetQueryValueDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            aggregator="sum",
                            conditional_formats=[
                                datadog.DashboardWidgetQueryValueDefinitionRequestConditionalFormatArgs(
                                    comparator="<",
                                    value=2,
                                    palette="white_on_green",
                                ),
                                datadog.DashboardWidgetQueryValueDefinitionRequestConditionalFormatArgs(
                                    comparator=">",
                                    value=2.2,
                                    palette="white_on_red",
                                ),
                            ],
                        )],
                        autoscale=True,
                        custom_unit="xx",
                        precision=4,
                        text_align="right",
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    query_table_definition=datadog.DashboardWidgetQueryTableDefinitionArgs(
                        requests=[datadog.DashboardWidgetQueryTableDefinitionRequestArgs(
                            q="avg:system.load.1{env:staging} by {account}",
                            aggregator="sum",
                            limit=10,
                            conditional_formats=[
                                datadog.DashboardWidgetQueryTableDefinitionRequestConditionalFormatArgs(
                                    comparator="<",
                                    value=2,
                                    palette="white_on_green",
                                ),
                                datadog.DashboardWidgetQueryTableDefinitionRequestConditionalFormatArgs(
                                    comparator=">",
                                    value=2.2,
                                    palette="white_on_red",
                                ),
                            ],
                        )],
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    scatterplot_definition=datadog.DashboardWidgetScatterplotDefinitionArgs(
                        request=datadog.DashboardWidgetScatterplotDefinitionRequestArgs(
                            xes=[datadog.DashboardWidgetScatterplotDefinitionRequestXArgs(
                                q="avg:system.cpu.user{*} by {service, account}",
                                aggregator="max",
                            )],
                            ys=[datadog.DashboardWidgetScatterplotDefinitionRequestYArgs(
                                q="avg:system.mem.used{*} by {service, account}",
                                aggregator="min",
                            )],
                        ),
                        color_by_groups=[
                            "account",
                            "apm-role-group",
                        ],
                        xaxis=datadog.DashboardWidgetScatterplotDefinitionXaxisArgs(
                            include_zero=True,
                            label="x",
                            min="1",
                            max="2000",
                            scale="pow",
                        ),
                        yaxis=datadog.DashboardWidgetScatterplotDefinitionYaxisArgs(
                            include_zero=False,
                            label="y",
                            min="5",
                            max="2222",
                            scale="log",
                        ),
                        title="Widget Title",
                        live_span="1h",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    servicemap_definition=datadog.DashboardWidgetServicemapDefinitionArgs(
                        service="master-db",
                        filters=[
                            "env:prod",
                            "datacenter:dc1",
                        ],
                        title="env: prod, datacenter:dc1, service: master-db",
                        title_size="16",
                        title_align="left",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                q="avg:system.cpu.user{app:general} by {env}",
                                display_type="line",
                                style=datadog.DashboardWidgetTimeseriesDefinitionRequestStyleArgs(
                                    palette="warm",
                                    line_type="dashed",
                                    line_width="thin",
                                ),
                                metadatas=[datadog.DashboardWidgetTimeseriesDefinitionRequestMetadataArgs(
                                    expression="avg:system.cpu.user{app:general} by {env}",
                                    alias_name="Alpha",
                                )],
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                log_query=datadog.DashboardWidgetLogQueryArgs(
                                    index="mcnulty",
                                    compute_query=datadog.DashboardWidgetLogQueryComputeQueryArgs(
                                        aggregation="avg",
                                        facet="@duration",
                                        interval=5000,
                                    ),
                                    search_query="status:info",
                                    group_bies=[datadog.DashboardWidgetLogQueryGroupByArgs(
                                        facet="host",
                                        limit=10,
                                        sort_query=datadog.DashboardWidgetLogQueryGroupBySortQueryArgs(
                                            aggregation="avg",
                                            order="desc",
                                            facet="@duration",
                                        ),
                                    )],
                                ),
                                display_type="area",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                apm_query=datadog.DashboardWidgetApmQueryArgs(
                                    index="apm-search",
                                    compute_query=datadog.DashboardWidgetApmQueryComputeQueryArgs(
                                        aggregation="avg",
                                        facet="@duration",
                                        interval=5000,
                                    ),
                                    search_query="type:web",
                                    group_bies=[datadog.DashboardWidgetApmQueryGroupByArgs(
                                        facet="resource_name",
                                        limit=50,
                                        sort_query=datadog.DashboardWidgetApmQueryGroupBySortQueryArgs(
                                            aggregation="avg",
                                            order="desc",
                                            facet="@string_query.interval",
                                        ),
                                    )],
                                ),
                                display_type="bars",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                process_query=datadog.DashboardWidgetTimeseriesDefinitionRequestProcessQueryArgs(
                                    metric="process.stat.cpu.total_pct",
                                    search_by="error",
                                    filter_bies=["active"],
                                    limit=50,
                                ),
                                display_type="area",
                            ),
                        ],
                        markers=[
                            datadog.DashboardWidgetTimeseriesDefinitionMarkerArgs(
                                display_type="error dashed",
                                label=" z=6 ",
                                value="y = 4",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionMarkerArgs(
                                display_type="ok solid",
                                value="10 < y < 999",
                                label=" x=8 ",
                            ),
                        ],
                        title="Widget Title",
                        show_legend=True,
                        legend_size="2",
                        live_span="1h",
                        events=[
                            datadog.DashboardWidgetTimeseriesDefinitionEventArgs(
                                q="sources:test tags:1",
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionEventArgs(
                                q="sources:test tags:2",
                            ),
                        ],
                        yaxis=datadog.DashboardWidgetTimeseriesDefinitionYaxisArgs(
                            scale="log",
                            include_zero=False,
                            max="100",
                        ),
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    toplist_definition=datadog.DashboardWidgetToplistDefinitionArgs(
                        requests=[datadog.DashboardWidgetToplistDefinitionRequestArgs(
                            q="avg:system.cpu.user{app:general} by {env}",
                            conditional_formats=[
                                datadog.DashboardWidgetToplistDefinitionRequestConditionalFormatArgs(
                                    comparator="<",
                                    value=2,
                                    palette="white_on_green",
                                ),
                                datadog.DashboardWidgetToplistDefinitionRequestConditionalFormatArgs(
                                    comparator=">",
                                    value=2.2,
                                    palette="white_on_red",
                                ),
                            ],
                        )],
                        title="Widget Title",
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    group_definition=datadog.DashboardWidgetGroupDefinitionArgs(
                        layout_type="ordered",
                        title="Group Widget",
                        widgets=[
                            datadog.DashboardWidgetGroupDefinitionWidgetArgs(
                                note_definition=datadog.DashboardWidgetNoteDefinitionArgs(
                                    content="cluster note widget",
                                    background_color="pink",
                                    font_size="14",
                                    text_align="center",
                                    show_tick=True,
                                    tick_edge="left",
                                    tick_pos="50%",
                                ),
                            ),
                            datadog.DashboardWidgetGroupDefinitionWidgetArgs(
                                alert_graph_definition=datadog.DashboardWidgetAlertGraphDefinitionArgs(
                                    alert_id="123",
                                    viz_type="toplist",
                                    title="Alert Graph",
                                    live_span="1h",
                                ),
                            ),
                        ],
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    service_level_objective_definition=datadog.DashboardWidgetServiceLevelObjectiveDefinitionArgs(
                        title="Widget Title",
                        view_type="detail",
                        slo_id="56789",
                        show_error_budget=True,
                        view_mode="overall",
                        time_windows=[
                            "7d",
                            "previous_week",
                        ],
                    ),
                ),
            ],
            template_variables=[
                datadog.DashboardTemplateVariableArgs(
                    name="var_1",
                    prefix="host",
                    default="aws",
                ),
                datadog.DashboardTemplateVariableArgs(
                    name="var_2",
                    prefix="service_name",
                    default="autoscaling",
                ),
            ],
            template_variable_presets=[datadog.DashboardTemplateVariablePresetArgs(
                name="preset_1",
                template_variables=[
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_1",
                        value="host.dc",
                    ),
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_2",
                        value="my_service",
                    ),
                ],
            )])
        # Example Free Layout
        free_dashboard = datadog.Dashboard("free_dashboard",
            title="Free Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="free",
            widgets=[
                datadog.DashboardWidgetArgs(
                    event_stream_definition=datadog.DashboardWidgetEventStreamDefinitionArgs(
                        query="*",
                        event_size="l",
                        title="Widget Title",
                        title_size="16",
                        title_align="left",
                        live_span="1h",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=43,
                        width=32,
                        x=0,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    event_timeline_definition=datadog.DashboardWidgetEventTimelineDefinitionArgs(
                        query="*",
                        title="Widget Title",
                        title_size="16",
                        title_align="left",
                        live_span="1h",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=9,
                        width=66,
                        x=33,
                        y=60,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    free_text_definition=datadog.DashboardWidgetFreeTextDefinitionArgs(
                        text="free text content",
                        color="#d00",
                        font_size="36",
                        text_align="left",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=20,
                        width=34,
                        x=33,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    iframe_definition=datadog.DashboardWidgetIframeDefinitionArgs(
                        url="http://google.com",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=46,
                        width=39,
                        x=101,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    image_definition=datadog.DashboardWidgetImageDefinitionArgs(
                        url="https://images.pexels.com/photos/67636/rose-blue-flower-rose-blooms-67636.jpeg?auto=compress&cs=tinysrgb&h=350",
                        sizing="fit",
                        margin="small",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=20,
                        width=30,
                        x=69,
                        y=0,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    log_stream_definition=datadog.DashboardWidgetLogStreamDefinitionArgs(
                        indexes=["main"],
                        query="error",
                        columns=[
                            "core_host",
                            "core_service",
                            "tag_source",
                        ],
                        show_date_column=True,
                        show_message_column=True,
                        message_display="expanded-md",
                        sort=datadog.DashboardWidgetLogStreamDefinitionSortArgs(
                            column="time",
                            order="desc",
                        ),
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=36,
                        width=32,
                        x=0,
                        y=45,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    manage_status_definition=datadog.DashboardWidgetManageStatusDefinitionArgs(
                        color_preference="text",
                        display_format="countsAndList",
                        hide_zero_counts=True,
                        query="type:metric",
                        show_last_triggered=False,
                        sort="status,asc",
                        summary_type="monitors",
                        title="Widget Title",
                        title_size="16",
                        title_align="left",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=40,
                        width=30,
                        x=101,
                        y=48,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    trace_service_definition=datadog.DashboardWidgetTraceServiceDefinitionArgs(
                        display_format="three_column",
                        env="datadog.com",
                        service="alerting-cassandra",
                        show_breakdown=True,
                        show_distribution=True,
                        show_errors=True,
                        show_hits=True,
                        show_latency=False,
                        show_resource_list=False,
                        size_format="large",
                        span_name="cassandra.query",
                        title="alerting-cassandra #env:datadog.com",
                        title_align="center",
                        title_size="13",
                        live_span="1h",
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=38,
                        width=66,
                        x=33,
                        y=21,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                            formulas=[
                                datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaArgs(
                                    formula_expression="my_query_1 + my_query_2",
                                    alias="my ff query",
                                ),
                                datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaArgs(
                                    formula_expression="my_query_1 * my_query_2",
                                    limit=datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaLimitArgs(
                                        count=5,
                                        order="desc",
                                    ),
                                    alias="my second ff query",
                                ),
                            ],
                            queries=[
                                datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    metric_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryMetricQueryArgs(
                                        data_source="metrics",
                                        query="avg:system.cpu.user{app:general} by {env}",
                                        name="my_query_1",
                                        aggregator="sum",
                                    ),
                                ),
                                datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    metric_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryMetricQueryArgs(
                                        query="avg:system.cpu.user{app:general} by {env}",
                                        name="my_query_2",
                                        aggregator="sum",
                                    ),
                                ),
                            ],
                        )],
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=16,
                        width=25,
                        x=58,
                        y=83,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    event_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryArgs(
                                        name="my-query",
                                        data_source="logs",
                                        indexes=["days-3"],
                                        computes=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryComputeArgs(
                                            aggregation="count",
                                        )],
                                        group_bies=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryGroupByArgs(
                                            facet="host",
                                            sort=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryEventQueryGroupBySortArgs(
                                                metric="@lambda.max_memory_used",
                                                aggregation="avg",
                                            ),
                                            limit=10,
                                        )],
                                    ),
                                )],
                            ),
                            datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                                display_type="overlay",
                                queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                    metric_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryMetricQueryArgs(
                                        name="MyOverlay",
                                        data_source="metrics",
                                        query="avg:system.cpu.user{host:COMP-QJWVM2FYT4}",
                                    ),
                                )],
                            ),
                        ],
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=16,
                        width=28,
                        x=29,
                        y=83,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                            queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                process_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryProcessQueryArgs(
                                    data_source="process",
                                    text_filter="abc",
                                    metric="process.stat.cpu.total_pct",
                                    limit=10,
                                    tag_filters=["some_filter"],
                                    name="my_process_query",
                                    sort="asc",
                                    is_normalized_cpu=True,
                                    aggregator="sum",
                                ),
                            )],
                        )],
                    ),
                    widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                        height=16,
                        width=28,
                        x=0,
                        y=83,
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    timeseries_definition=datadog.DashboardWidgetTimeseriesDefinitionArgs(
                        requests=[datadog.DashboardWidgetTimeseriesDefinitionRequestArgs(
                            formulas=[datadog.DashboardWidgetTimeseriesDefinitionRequestFormulaArgs(
                                formula_expression="query1",
                                alias="my cloud cost query",
                            )],
                            queries=[datadog.DashboardWidgetTimeseriesDefinitionRequestQueryArgs(
                                cloud_cost_query=datadog.DashboardWidgetTimeseriesDefinitionRequestQueryCloudCostQueryArgs(
                                    data_source="cloud_cost",
                                    query="sum:aws.cost.amortized{*}",
                                    name="query1",
                                    aggregator="sum",
                                ),
                            )],
                        )],
                    ),
                ),
                datadog.DashboardWidgetArgs(
                    powerpack_definition=datadog.DashboardWidgetPowerpackDefinitionArgs(
                        powerpack_id="00000000-0000-0000-0000-000000000000",
                        background_color="blue",
                        banner_img="https://example.org/example.png",
                        show_title=True,
                        title="Powerpack Widget",
                        template_variables=datadog.DashboardWidgetPowerpackDefinitionTemplateVariablesArgs(
                            controlled_externallies=[datadog.DashboardWidgetPowerpackDefinitionTemplateVariablesControlledExternallyArgs(
                                name="var_2",
                                values=["autoscaling"],
                                prefix="service_name",
                            )],
                            controlled_by_powerpacks=[datadog.DashboardWidgetPowerpackDefinitionTemplateVariablesControlledByPowerpackArgs(
                                name="var_3",
                                prefix="timeframe",
                                values=[
                                    "default",
                                    "values",
                                    "here",
                                ],
                            )],
                        ),
                    ),
                ),
            ],
            template_variables=[
                datadog.DashboardTemplateVariableArgs(
                    name="var_1",
                    prefix="host",
                    default="aws",
                ),
                datadog.DashboardTemplateVariableArgs(
                    name="var_2",
                    prefix="service_name",
                    default="autoscaling",
                ),
            ],
            template_variable_presets=[datadog.DashboardTemplateVariablePresetArgs(
                name="preset_1",
                template_variables=[
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_1",
                        value="host.dc",
                    ),
                    datadog.DashboardTemplateVariablePresetTemplateVariableArgs(
                        name="var_2",
                        value="my_service",
                    ),
                ],
            )])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/dashboard:Dashboard my_service_dashboard sv7-gyh-kas
        ```

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 layout_type: Optional[pulumi.Input[str]] = None,
                 notify_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reflow_type: Optional[pulumi.Input[str]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_variable_presets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariablePresetArgs']]]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariableArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["dashboard_lists"] = dashboard_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["is_read_only"] = is_read_only
            if layout_type is None and not opts.urn:
                raise TypeError("Missing required property 'layout_type'")
            __props__.__dict__["layout_type"] = layout_type
            __props__.__dict__["notify_lists"] = notify_lists
            __props__.__dict__["reflow_type"] = reflow_type
            __props__.__dict__["restricted_roles"] = restricted_roles
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_variable_presets"] = template_variable_presets
            __props__.__dict__["template_variables"] = template_variables
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["url"] = url
            __props__.__dict__["widgets"] = widgets
            __props__.__dict__["dashboard_lists_removeds"] = None
        super(Dashboard, __self__).__init__(
            'datadog:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            dashboard_lists_removeds: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            is_read_only: Optional[pulumi.Input[bool]] = None,
            layout_type: Optional[pulumi.Input[str]] = None,
            notify_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            reflow_type: Optional[pulumi.Input[str]] = None,
            restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            template_variable_presets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariablePresetArgs']]]]] = None,
            template_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariableArgs']]]]] = None,
            title: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            widgets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] dashboard_lists_removeds: A list of dashboard lists this dashboard should be removed from. Internal only.
        :param pulumi.Input[str] description: The description of the dashboard.
        :param pulumi.Input[bool] is_read_only: Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        :param pulumi.Input[str] layout_type: The layout type of the dashboard. Valid values are `ordered`, `free`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_lists: The list of handles for the users to notify when changes are made to this dashboard.
        :param pulumi.Input[str] reflow_type: The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: UUIDs of roles whose associated users are authorized to edit the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariablePresetArgs']]]] template_variable_presets: The list of selectable template variable presets for this dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardTemplateVariableArgs']]]] template_variables: The list of template variables for this dashboard.
        :param pulumi.Input[str] title: The title of the dashboard.
        :param pulumi.Input[str] url: The URL of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardWidgetArgs']]]] widgets: The list of widgets to display on the dashboard.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["dashboard_lists"] = dashboard_lists
        __props__.__dict__["dashboard_lists_removeds"] = dashboard_lists_removeds
        __props__.__dict__["description"] = description
        __props__.__dict__["is_read_only"] = is_read_only
        __props__.__dict__["layout_type"] = layout_type
        __props__.__dict__["notify_lists"] = notify_lists
        __props__.__dict__["reflow_type"] = reflow_type
        __props__.__dict__["restricted_roles"] = restricted_roles
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_variable_presets"] = template_variable_presets
        __props__.__dict__["template_variables"] = template_variables
        __props__.__dict__["title"] = title
        __props__.__dict__["url"] = url
        __props__.__dict__["widgets"] = widgets
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashboardLists")
    def dashboard_lists(self) -> pulumi.Output[Optional[Sequence[int]]]:
        return pulumi.get(self, "dashboard_lists")

    @property
    @pulumi.getter(name="dashboardListsRemoveds")
    def dashboard_lists_removeds(self) -> pulumi.Output[Sequence[int]]:
        """
        A list of dashboard lists this dashboard should be removed from. Internal only.
        """
        return pulumi.get(self, "dashboard_lists_removeds")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isReadOnly")
    @_utilities.deprecated("""Prefer using `restricted_roles` to define which roles are required to edit the dashboard.""")
    def is_read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard. Defaults to `false`.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter(name="layoutType")
    def layout_type(self) -> pulumi.Output[str]:
        """
        The layout type of the dashboard. Valid values are `ordered`, `free`.
        """
        return pulumi.get(self, "layout_type")

    @property
    @pulumi.getter(name="notifyLists")
    def notify_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of handles for the users to notify when changes are made to this dashboard.
        """
        return pulumi.get(self, "notify_lists")

    @property
    @pulumi.getter(name="reflowType")
    def reflow_type(self) -> pulumi.Output[Optional[str]]:
        """
        The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
        """
        return pulumi.get(self, "reflow_type")

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        UUIDs of roles whose associated users are authorized to edit the dashboard.
        """
        return pulumi.get(self, "restricted_roles")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags assigned to the Dashboard. Only team names of the form `team:<name>` are supported.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateVariablePresets")
    def template_variable_presets(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardTemplateVariablePreset']]]:
        """
        The list of selectable template variable presets for this dashboard.
        """
        return pulumi.get(self, "template_variable_presets")

    @property
    @pulumi.getter(name="templateVariables")
    def template_variables(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardTemplateVariable']]]:
        """
        The list of template variables for this dashboard.
        """
        return pulumi.get(self, "template_variables")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL of the dashboard.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def widgets(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardWidget']]]:
        """
        The list of widgets to display on the dashboard.
        """
        return pulumi.get(self, "widgets")

