# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardListArgs', 'DashboardList']

@pulumi.input_type
class DashboardListArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 dash_items: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]]] = None):
        """
        The set of arguments for constructing a DashboardList resource.
        :param pulumi.Input[str] name: The name of the Dashboard List
        :param pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]] dash_items: A set of dashboard items that belong to this list
        """
        pulumi.set(__self__, "name", name)
        if dash_items is not None:
            pulumi.set(__self__, "dash_items", dash_items)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Dashboard List
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="dashItems")
    def dash_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]]]:
        """
        A set of dashboard items that belong to this list
        """
        return pulumi.get(self, "dash_items")

    @dash_items.setter
    def dash_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]]]):
        pulumi.set(self, "dash_items", value)


@pulumi.input_type
class _DashboardListState:
    def __init__(__self__, *,
                 dash_items: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DashboardList resources.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]] dash_items: A set of dashboard items that belong to this list
        :param pulumi.Input[str] name: The name of the Dashboard List
        """
        if dash_items is not None:
            pulumi.set(__self__, "dash_items", dash_items)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dashItems")
    def dash_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]]]:
        """
        A set of dashboard items that belong to this list
        """
        return pulumi.get(self, "dash_items")

    @dash_items.setter
    def dash_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardListDashItemArgs']]]]):
        pulumi.set(self, "dash_items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Dashboard List
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class DashboardList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dash_items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardListDashItemArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog dashboard_list resource. This can be used to create and manage Datadog Dashboard Lists and the individual dashboards within them.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        time = datadog.Dashboard("time",
            title="TF Test Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="ordered",
            is_read_only=True,
            widgets=[datadog.DashboardWidgetArgs(
                alert_graph_definition=datadog.DashboardWidgetAlertGraphDefinitionArgs(
                    alert_id="1234",
                    viz_type="timeseries",
                    title="Widget Title",
                    live_span="1h",
                ),
            )])
        screen = datadog.Dashboard("screen",
            title="TF Test Free Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="free",
            is_read_only=False,
            widgets=[datadog.DashboardWidgetArgs(
                event_stream_definition=datadog.DashboardWidgetEventStreamDefinitionArgs(
                    query="*",
                    event_size="l",
                    title="Widget Title",
                    title_size="16",
                    title_align="left",
                    live_span="1h",
                ),
                widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                    height=43,
                    width=32,
                    x=5,
                    y=5,
                ),
            )])
        # Create a new Dashboard List with two Dashboards
        new_list = datadog.DashboardList("new_list",
            name="Automated Created List",
            dash_items=[
                datadog.DashboardListDashItemArgs(
                    type="custom_timeboard",
                    dash_id=time.id,
                ),
                datadog.DashboardListDashItemArgs(
                    type="custom_screenboard",
                    dash_id=screen.id,
                ),
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    screen,
                    time,
                ]))
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/dashboardList:DashboardList new_list 123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardListDashItemArgs']]]] dash_items: A set of dashboard items that belong to this list
        :param pulumi.Input[str] name: The name of the Dashboard List
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog dashboard_list resource. This can be used to create and manage Datadog Dashboard Lists and the individual dashboards within them.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        time = datadog.Dashboard("time",
            title="TF Test Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="ordered",
            is_read_only=True,
            widgets=[datadog.DashboardWidgetArgs(
                alert_graph_definition=datadog.DashboardWidgetAlertGraphDefinitionArgs(
                    alert_id="1234",
                    viz_type="timeseries",
                    title="Widget Title",
                    live_span="1h",
                ),
            )])
        screen = datadog.Dashboard("screen",
            title="TF Test Free Layout Dashboard",
            description="Created using the Datadog provider in Pulumi",
            layout_type="free",
            is_read_only=False,
            widgets=[datadog.DashboardWidgetArgs(
                event_stream_definition=datadog.DashboardWidgetEventStreamDefinitionArgs(
                    query="*",
                    event_size="l",
                    title="Widget Title",
                    title_size="16",
                    title_align="left",
                    live_span="1h",
                ),
                widget_layout=datadog.DashboardWidgetWidgetLayoutArgs(
                    height=43,
                    width=32,
                    x=5,
                    y=5,
                ),
            )])
        # Create a new Dashboard List with two Dashboards
        new_list = datadog.DashboardList("new_list",
            name="Automated Created List",
            dash_items=[
                datadog.DashboardListDashItemArgs(
                    type="custom_timeboard",
                    dash_id=time.id,
                ),
                datadog.DashboardListDashItemArgs(
                    type="custom_screenboard",
                    dash_id=screen.id,
                ),
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    screen,
                    time,
                ]))
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/dashboardList:DashboardList new_list 123456
        ```

        :param str resource_name: The name of the resource.
        :param DashboardListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dash_items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardListDashItemArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardListArgs.__new__(DashboardListArgs)

            __props__.__dict__["dash_items"] = dash_items
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(DashboardList, __self__).__init__(
            'datadog:index/dashboardList:DashboardList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dash_items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardListDashItemArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'DashboardList':
        """
        Get an existing DashboardList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardListDashItemArgs']]]] dash_items: A set of dashboard items that belong to this list
        :param pulumi.Input[str] name: The name of the Dashboard List
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardListState.__new__(_DashboardListState)

        __props__.__dict__["dash_items"] = dash_items
        __props__.__dict__["name"] = name
        return DashboardList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashItems")
    def dash_items(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardListDashItem']]]:
        """
        A set of dashboard items that belong to this list
        """
        return pulumi.get(self, "dash_items")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Dashboard List
        """
        return pulumi.get(self, "name")

