# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 client_email: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 private_key: pulumi.Input[str],
                 private_key_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 automute: Optional[pulumi.Input[bool]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[str] host_filters: Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "project_id", project_id)
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if cspm_resource_collection_enabled is not None:
            pulumi.set(__self__, "cspm_resource_collection_enabled", cspm_resource_collection_enabled)
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if is_security_command_center_enabled is not None:
            pulumi.set(__self__, "is_security_command_center_enabled", is_security_command_center_enabled)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Input[str]:
        """
        Your email found in your JSON service account key.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Your ID found in your JSON service account key.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        Your private key name found in your JSON service account key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Input[str]:
        """
        Your private key ID found in your JSON service account key.
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Your Google Cloud project ID found in your JSON service account key.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[bool]]:
        """
        Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automute", value)

    @property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @cspm_resource_collection_enabled.setter
    def cspm_resource_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cspm_resource_collection_enabled", value)

    @property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> Optional[pulumi.Input[str]]:
        """
        Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_filters", value)

    @property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @is_security_command_center_enabled.setter
    def is_security_command_center_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_security_command_center_enabled", value)

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 automute: Optional[pulumi.Input[bool]] = None,
                 client_email: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[bool]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[str] host_filters: Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if cspm_resource_collection_enabled is not None:
            pulumi.set(__self__, "cspm_resource_collection_enabled", cspm_resource_collection_enabled)
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if is_security_command_center_enabled is not None:
            pulumi.set(__self__, "is_security_command_center_enabled", is_security_command_center_enabled)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[bool]]:
        """
        Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automute", value)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[str]]:
        """
        Your email found in your JSON service account key.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your ID found in your JSON service account key.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @cspm_resource_collection_enabled.setter
    def cspm_resource_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cspm_resource_collection_enabled", value)

    @property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> Optional[pulumi.Input[str]]:
        """
        Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_filters", value)

    @property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @is_security_command_center_enabled.setter
    def is_security_command_center_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_security_command_center_enabled", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Your private key name found in your JSON service account key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your private key ID found in your JSON service account key.
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Your Google Cloud project ID found in your JSON service account key.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automute: Optional[pulumi.Input[bool]] = None,
                 client_email: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[bool]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource is deprecated—use the `gcp.IntegrationSts` resource instead. Provides a Datadog - Google Cloud Platform integration resource. This can be used to create and manage Datadog - Google Cloud Platform integration.

        ## Import

        Google Cloud Platform integrations can be imported using their project ID, e.g.

        ```sh
        $ pulumi import datadog:gcp/integration:Integration awesome_gcp_project_integration project_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[str] host_filters: Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is deprecated—use the `gcp.IntegrationSts` resource instead. Provides a Datadog - Google Cloud Platform integration resource. This can be used to create and manage Datadog - Google Cloud Platform integration.

        ## Import

        Google Cloud Platform integrations can be imported using their project ID, e.g.

        ```sh
        $ pulumi import datadog:gcp/integration:Integration awesome_gcp_project_integration project_id
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automute: Optional[pulumi.Input[bool]] = None,
                 client_email: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 host_filters: Optional[pulumi.Input[str]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[bool]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["automute"] = automute
            if client_email is None and not opts.urn:
                raise TypeError("Missing required property 'client_email'")
            __props__.__dict__["client_email"] = client_email
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["cspm_resource_collection_enabled"] = cspm_resource_collection_enabled
            __props__.__dict__["host_filters"] = host_filters
            __props__.__dict__["is_security_command_center_enabled"] = is_security_command_center_enabled
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if private_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_key_id'")
            __props__.__dict__["private_key_id"] = private_key_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'datadog:gcp/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automute: Optional[pulumi.Input[bool]] = None,
            client_email: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            cspm_resource_collection_enabled: Optional[pulumi.Input[bool]] = None,
            host_filters: Optional[pulumi.Input[str]] = None,
            is_security_command_center_enabled: Optional[pulumi.Input[bool]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            private_key_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            resource_collection_enabled: Optional[pulumi.Input[bool]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[str] host_filters: Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["automute"] = automute
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["cspm_resource_collection_enabled"] = cspm_resource_collection_enabled
        __props__.__dict__["host_filters"] = host_filters
        __props__.__dict__["is_security_command_center_enabled"] = is_security_command_center_enabled
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        return Integration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def automute(self) -> pulumi.Output[bool]:
        """
        Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[str]:
        """
        Your email found in your JSON service account key.
        """
        return pulumi.get(self, "client_email")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        Your ID found in your JSON service account key.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> pulumi.Output[bool]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> pulumi.Output[str]:
        """
        Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> pulumi.Output[bool]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        Your private key name found in your JSON service account key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[str]:
        """
        Your private key ID found in your JSON service account key.
        """
        return pulumi.get(self, "private_key_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Your Google Cloud project ID found in your JSON service account key.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> pulumi.Output[bool]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

