# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetApmRetentionFiltersOrderResult',
    'AwaitableGetApmRetentionFiltersOrderResult',
    'get_apm_retention_filters_order',
    'get_apm_retention_filters_order_output',
]

@pulumi.output_type
class GetApmRetentionFiltersOrderResult:
    """
    A collection of values returned by getApmRetentionFiltersOrder.
    """
    def __init__(__self__, filter_ids=None, id=None):
        if filter_ids and not isinstance(filter_ids, list):
            raise TypeError("Expected argument 'filter_ids' to be a list")
        pulumi.set(__self__, "filter_ids", filter_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="filterIds")
    def filter_ids(self) -> Sequence[str]:
        """
        The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        return pulumi.get(self, "filter_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetApmRetentionFiltersOrderResult(GetApmRetentionFiltersOrderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApmRetentionFiltersOrderResult(
            filter_ids=self.filter_ids,
            id=self.id)


def get_apm_retention_filters_order(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApmRetentionFiltersOrderResult:
    """
    Provides a Datadog [APM Retention Filters API](https://docs.datadoghq.com/api/v2/apm-retention-filters/) order datasource. This can be used to retrieve APM retention filters order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    foo = datadog.get_apm_retention_filters_order()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getApmRetentionFiltersOrder:getApmRetentionFiltersOrder', __args__, opts=opts, typ=GetApmRetentionFiltersOrderResult).value

    return AwaitableGetApmRetentionFiltersOrderResult(
        filter_ids=pulumi.get(__ret__, 'filter_ids'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_apm_retention_filters_order)
def get_apm_retention_filters_order_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApmRetentionFiltersOrderResult]:
    """
    Provides a Datadog [APM Retention Filters API](https://docs.datadoghq.com/api/v2/apm-retention-filters/) order datasource. This can be used to retrieve APM retention filters order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    foo = datadog.get_apm_retention_filters_order()
    ```
    """
    ...
