# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetMonitorResult',
    'AwaitableGetMonitorResult',
    'get_monitor',
    'get_monitor_output',
]

@pulumi.output_type
class GetMonitorResult:
    """
    A collection of values returned by getMonitor.
    """
    def __init__(__self__, enable_logs_sample=None, enable_samples=None, escalation_message=None, evaluation_delay=None, group_retention_duration=None, groupby_simple_monitor=None, id=None, include_tags=None, locked=None, message=None, monitor_tags_filters=None, monitor_threshold_windows=None, monitor_thresholds=None, name=None, name_filter=None, new_group_delay=None, new_host_delay=None, no_data_timeframe=None, notification_preset_name=None, notify_audit=None, notify_bies=None, notify_no_data=None, on_missing_data=None, query=None, renotify_interval=None, renotify_occurrences=None, renotify_statuses=None, require_full_window=None, restricted_roles=None, scheduling_options=None, tags=None, tags_filters=None, timeout_h=None, type=None):
        if enable_logs_sample and not isinstance(enable_logs_sample, bool):
            raise TypeError("Expected argument 'enable_logs_sample' to be a bool")
        pulumi.set(__self__, "enable_logs_sample", enable_logs_sample)
        if enable_samples and not isinstance(enable_samples, bool):
            raise TypeError("Expected argument 'enable_samples' to be a bool")
        pulumi.set(__self__, "enable_samples", enable_samples)
        if escalation_message and not isinstance(escalation_message, str):
            raise TypeError("Expected argument 'escalation_message' to be a str")
        pulumi.set(__self__, "escalation_message", escalation_message)
        if evaluation_delay and not isinstance(evaluation_delay, int):
            raise TypeError("Expected argument 'evaluation_delay' to be a int")
        pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if group_retention_duration and not isinstance(group_retention_duration, str):
            raise TypeError("Expected argument 'group_retention_duration' to be a str")
        pulumi.set(__self__, "group_retention_duration", group_retention_duration)
        if groupby_simple_monitor and not isinstance(groupby_simple_monitor, bool):
            raise TypeError("Expected argument 'groupby_simple_monitor' to be a bool")
        pulumi.set(__self__, "groupby_simple_monitor", groupby_simple_monitor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_tags and not isinstance(include_tags, bool):
            raise TypeError("Expected argument 'include_tags' to be a bool")
        pulumi.set(__self__, "include_tags", include_tags)
        if locked and not isinstance(locked, bool):
            raise TypeError("Expected argument 'locked' to be a bool")
        pulumi.set(__self__, "locked", locked)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if monitor_tags_filters and not isinstance(monitor_tags_filters, list):
            raise TypeError("Expected argument 'monitor_tags_filters' to be a list")
        pulumi.set(__self__, "monitor_tags_filters", monitor_tags_filters)
        if monitor_threshold_windows and not isinstance(monitor_threshold_windows, list):
            raise TypeError("Expected argument 'monitor_threshold_windows' to be a list")
        pulumi.set(__self__, "monitor_threshold_windows", monitor_threshold_windows)
        if monitor_thresholds and not isinstance(monitor_thresholds, list):
            raise TypeError("Expected argument 'monitor_thresholds' to be a list")
        pulumi.set(__self__, "monitor_thresholds", monitor_thresholds)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)
        if new_group_delay and not isinstance(new_group_delay, int):
            raise TypeError("Expected argument 'new_group_delay' to be a int")
        pulumi.set(__self__, "new_group_delay", new_group_delay)
        if new_host_delay and not isinstance(new_host_delay, int):
            raise TypeError("Expected argument 'new_host_delay' to be a int")
        pulumi.set(__self__, "new_host_delay", new_host_delay)
        if no_data_timeframe and not isinstance(no_data_timeframe, int):
            raise TypeError("Expected argument 'no_data_timeframe' to be a int")
        pulumi.set(__self__, "no_data_timeframe", no_data_timeframe)
        if notification_preset_name and not isinstance(notification_preset_name, str):
            raise TypeError("Expected argument 'notification_preset_name' to be a str")
        pulumi.set(__self__, "notification_preset_name", notification_preset_name)
        if notify_audit and not isinstance(notify_audit, bool):
            raise TypeError("Expected argument 'notify_audit' to be a bool")
        pulumi.set(__self__, "notify_audit", notify_audit)
        if notify_bies and not isinstance(notify_bies, list):
            raise TypeError("Expected argument 'notify_bies' to be a list")
        pulumi.set(__self__, "notify_bies", notify_bies)
        if notify_no_data and not isinstance(notify_no_data, bool):
            raise TypeError("Expected argument 'notify_no_data' to be a bool")
        pulumi.set(__self__, "notify_no_data", notify_no_data)
        if on_missing_data and not isinstance(on_missing_data, str):
            raise TypeError("Expected argument 'on_missing_data' to be a str")
        pulumi.set(__self__, "on_missing_data", on_missing_data)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if renotify_interval and not isinstance(renotify_interval, int):
            raise TypeError("Expected argument 'renotify_interval' to be a int")
        pulumi.set(__self__, "renotify_interval", renotify_interval)
        if renotify_occurrences and not isinstance(renotify_occurrences, int):
            raise TypeError("Expected argument 'renotify_occurrences' to be a int")
        pulumi.set(__self__, "renotify_occurrences", renotify_occurrences)
        if renotify_statuses and not isinstance(renotify_statuses, list):
            raise TypeError("Expected argument 'renotify_statuses' to be a list")
        pulumi.set(__self__, "renotify_statuses", renotify_statuses)
        if require_full_window and not isinstance(require_full_window, bool):
            raise TypeError("Expected argument 'require_full_window' to be a bool")
        pulumi.set(__self__, "require_full_window", require_full_window)
        if restricted_roles and not isinstance(restricted_roles, list):
            raise TypeError("Expected argument 'restricted_roles' to be a list")
        pulumi.set(__self__, "restricted_roles", restricted_roles)
        if scheduling_options and not isinstance(scheduling_options, list):
            raise TypeError("Expected argument 'scheduling_options' to be a list")
        pulumi.set(__self__, "scheduling_options", scheduling_options)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tags_filters and not isinstance(tags_filters, list):
            raise TypeError("Expected argument 'tags_filters' to be a list")
        pulumi.set(__self__, "tags_filters", tags_filters)
        if timeout_h and not isinstance(timeout_h, int):
            raise TypeError("Expected argument 'timeout_h' to be a int")
        pulumi.set(__self__, "timeout_h", timeout_h)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="enableLogsSample")
    def enable_logs_sample(self) -> bool:
        """
        Whether or not a list of log values which triggered the alert is included. This is only used by log monitors.
        """
        return pulumi.get(self, "enable_logs_sample")

    @property
    @pulumi.getter(name="enableSamples")
    def enable_samples(self) -> bool:
        """
        Whether or not a list of samples which triggered the alert is included. This is only used by CI Test and Pipeline monitors.
        """
        return pulumi.get(self, "enable_samples")

    @property
    @pulumi.getter(name="escalationMessage")
    def escalation_message(self) -> str:
        """
        Message included with a re-notification for this monitor.
        """
        return pulumi.get(self, "escalation_message")

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> int:
        """
        Time (in seconds) for which evaluation is delayed. This is only used by metric monitors.
        """
        return pulumi.get(self, "evaluation_delay")

    @property
    @pulumi.getter(name="groupRetentionDuration")
    def group_retention_duration(self) -> str:
        """
        The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour, and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        """
        return pulumi.get(self, "group_retention_duration")

    @property
    @pulumi.getter(name="groupbySimpleMonitor")
    def groupby_simple_monitor(self) -> bool:
        """
        Whether or not to trigger one alert if any source breaches a threshold.
        """
        return pulumi.get(self, "groupby_simple_monitor")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> bool:
        """
        Whether or not notifications from the monitor automatically inserts its triggering tags into the title.
        """
        return pulumi.get(self, "include_tags")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Whether or not changes to the monitor are restricted to the creator or admins.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message included with notifications for this monitor
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="monitorTagsFilters")
    def monitor_tags_filters(self) -> Optional[Sequence[str]]:
        """
        A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
        """
        return pulumi.get(self, "monitor_tags_filters")

    @property
    @pulumi.getter(name="monitorThresholdWindows")
    def monitor_threshold_windows(self) -> Sequence['outputs.GetMonitorMonitorThresholdWindowResult']:
        """
        Mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m`. This is only used by anomaly monitors.
        """
        return pulumi.get(self, "monitor_threshold_windows")

    @property
    @pulumi.getter(name="monitorThresholds")
    def monitor_thresholds(self) -> Sequence['outputs.GetMonitorMonitorThresholdResult']:
        """
        Alert thresholds of the monitor.
        """
        return pulumi.get(self, "monitor_thresholds")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the monitor
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[str]:
        """
        A monitor name to limit the search.
        """
        return pulumi.get(self, "name_filter")

    @property
    @pulumi.getter(name="newGroupDelay")
    def new_group_delay(self) -> int:
        """
        Time (in seconds) to skip evaluations for new groups.
        """
        return pulumi.get(self, "new_group_delay")

    @property
    @pulumi.getter(name="newHostDelay")
    def new_host_delay(self) -> int:
        """
        Time (in seconds) allowing a host to boot and applications to fully start before starting the evaluation of monitor results.
        """
        return pulumi.get(self, "new_host_delay")

    @property
    @pulumi.getter(name="noDataTimeframe")
    def no_data_timeframe(self) -> int:
        """
        The number of minutes before the monitor notifies when data stops reporting.
        """
        return pulumi.get(self, "no_data_timeframe")

    @property
    @pulumi.getter(name="notificationPresetName")
    def notification_preset_name(self) -> str:
        """
        Toggles the display of additional content sent in the monitor notification. Valid values are: `show_all`, `hide_query`, `hide_handles`, and `hide_all`.
        """
        return pulumi.get(self, "notification_preset_name")

    @property
    @pulumi.getter(name="notifyAudit")
    def notify_audit(self) -> bool:
        """
        Whether or not tagged users are notified on changes to the monitor.
        """
        return pulumi.get(self, "notify_audit")

    @property
    @pulumi.getter(name="notifyBies")
    def notify_bies(self) -> Sequence[str]:
        """
        Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by` to `[*]` configures the monitor to notify as a simple-alert.
        """
        return pulumi.get(self, "notify_bies")

    @property
    @pulumi.getter(name="notifyNoData")
    def notify_no_data(self) -> bool:
        """
        Whether or not this monitor notifies when data stops reporting.
        """
        return pulumi.get(self, "notify_no_data")

    @property
    @pulumi.getter(name="onMissingData")
    def on_missing_data(self) -> str:
        """
        Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are: `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        """
        return pulumi.get(self, "on_missing_data")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query of the monitor.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="renotifyInterval")
    def renotify_interval(self) -> int:
        """
        The number of minutes after the last notification before the monitor re-notifies on the current status.
        """
        return pulumi.get(self, "renotify_interval")

    @property
    @pulumi.getter(name="renotifyOccurrences")
    def renotify_occurrences(self) -> int:
        """
        The number of re-notification messages that should be sent on the current status.
        """
        return pulumi.get(self, "renotify_occurrences")

    @property
    @pulumi.getter(name="renotifyStatuses")
    def renotify_statuses(self) -> Sequence[str]:
        """
        The types of statuses for which re-notification messages should be sent. Valid values are `alert`, `warn`, `no data`.
        """
        return pulumi.get(self, "renotify_statuses")

    @property
    @pulumi.getter(name="requireFullWindow")
    def require_full_window(self) -> bool:
        """
        Whether or not the monitor needs a full window of data before it is evaluated.
        """
        return pulumi.get(self, "require_full_window")

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Sequence[str]:
        return pulumi.get(self, "restricted_roles")

    @property
    @pulumi.getter(name="schedulingOptions")
    def scheduling_options(self) -> Sequence['outputs.GetMonitorSchedulingOptionResult']:
        """
        Configuration options for scheduling.
        """
        return pulumi.get(self, "scheduling_options")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        List of tags associated with the monitor.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsFilters")
    def tags_filters(self) -> Optional[Sequence[str]]:
        """
        A list of tags to limit the search. This filters on the monitor scope.
        """
        return pulumi.get(self, "tags_filters")

    @property
    @pulumi.getter(name="timeoutH")
    def timeout_h(self) -> int:
        """
        Number of hours of the monitor not reporting data before it automatically resolves from a triggered state.
        """
        return pulumi.get(self, "timeout_h")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the monitor.
        """
        return pulumi.get(self, "type")


class AwaitableGetMonitorResult(GetMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitorResult(
            enable_logs_sample=self.enable_logs_sample,
            enable_samples=self.enable_samples,
            escalation_message=self.escalation_message,
            evaluation_delay=self.evaluation_delay,
            group_retention_duration=self.group_retention_duration,
            groupby_simple_monitor=self.groupby_simple_monitor,
            id=self.id,
            include_tags=self.include_tags,
            locked=self.locked,
            message=self.message,
            monitor_tags_filters=self.monitor_tags_filters,
            monitor_threshold_windows=self.monitor_threshold_windows,
            monitor_thresholds=self.monitor_thresholds,
            name=self.name,
            name_filter=self.name_filter,
            new_group_delay=self.new_group_delay,
            new_host_delay=self.new_host_delay,
            no_data_timeframe=self.no_data_timeframe,
            notification_preset_name=self.notification_preset_name,
            notify_audit=self.notify_audit,
            notify_bies=self.notify_bies,
            notify_no_data=self.notify_no_data,
            on_missing_data=self.on_missing_data,
            query=self.query,
            renotify_interval=self.renotify_interval,
            renotify_occurrences=self.renotify_occurrences,
            renotify_statuses=self.renotify_statuses,
            require_full_window=self.require_full_window,
            restricted_roles=self.restricted_roles,
            scheduling_options=self.scheduling_options,
            tags=self.tags,
            tags_filters=self.tags_filters,
            timeout_h=self.timeout_h,
            type=self.type)


def get_monitor(monitor_tags_filters: Optional[Sequence[str]] = None,
                name_filter: Optional[str] = None,
                tags_filters: Optional[Sequence[str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitorResult:
    """
    Use this data source to retrieve information about an existing monitor for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_monitor(name_filter="My awesome monitor",
        monitor_tags_filters=["foo:bar"])
    ```


    :param Sequence[str] monitor_tags_filters: A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
    :param str name_filter: A monitor name to limit the search.
    :param Sequence[str] tags_filters: A list of tags to limit the search. This filters on the monitor scope.
    """
    __args__ = dict()
    __args__['monitorTagsFilters'] = monitor_tags_filters
    __args__['nameFilter'] = name_filter
    __args__['tagsFilters'] = tags_filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getMonitor:getMonitor', __args__, opts=opts, typ=GetMonitorResult).value

    return AwaitableGetMonitorResult(
        enable_logs_sample=pulumi.get(__ret__, 'enable_logs_sample'),
        enable_samples=pulumi.get(__ret__, 'enable_samples'),
        escalation_message=pulumi.get(__ret__, 'escalation_message'),
        evaluation_delay=pulumi.get(__ret__, 'evaluation_delay'),
        group_retention_duration=pulumi.get(__ret__, 'group_retention_duration'),
        groupby_simple_monitor=pulumi.get(__ret__, 'groupby_simple_monitor'),
        id=pulumi.get(__ret__, 'id'),
        include_tags=pulumi.get(__ret__, 'include_tags'),
        locked=pulumi.get(__ret__, 'locked'),
        message=pulumi.get(__ret__, 'message'),
        monitor_tags_filters=pulumi.get(__ret__, 'monitor_tags_filters'),
        monitor_threshold_windows=pulumi.get(__ret__, 'monitor_threshold_windows'),
        monitor_thresholds=pulumi.get(__ret__, 'monitor_thresholds'),
        name=pulumi.get(__ret__, 'name'),
        name_filter=pulumi.get(__ret__, 'name_filter'),
        new_group_delay=pulumi.get(__ret__, 'new_group_delay'),
        new_host_delay=pulumi.get(__ret__, 'new_host_delay'),
        no_data_timeframe=pulumi.get(__ret__, 'no_data_timeframe'),
        notification_preset_name=pulumi.get(__ret__, 'notification_preset_name'),
        notify_audit=pulumi.get(__ret__, 'notify_audit'),
        notify_bies=pulumi.get(__ret__, 'notify_bies'),
        notify_no_data=pulumi.get(__ret__, 'notify_no_data'),
        on_missing_data=pulumi.get(__ret__, 'on_missing_data'),
        query=pulumi.get(__ret__, 'query'),
        renotify_interval=pulumi.get(__ret__, 'renotify_interval'),
        renotify_occurrences=pulumi.get(__ret__, 'renotify_occurrences'),
        renotify_statuses=pulumi.get(__ret__, 'renotify_statuses'),
        require_full_window=pulumi.get(__ret__, 'require_full_window'),
        restricted_roles=pulumi.get(__ret__, 'restricted_roles'),
        scheduling_options=pulumi.get(__ret__, 'scheduling_options'),
        tags=pulumi.get(__ret__, 'tags'),
        tags_filters=pulumi.get(__ret__, 'tags_filters'),
        timeout_h=pulumi.get(__ret__, 'timeout_h'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_monitor)
def get_monitor_output(monitor_tags_filters: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       name_filter: Optional[pulumi.Input[Optional[str]]] = None,
                       tags_filters: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitorResult]:
    """
    Use this data source to retrieve information about an existing monitor for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_monitor(name_filter="My awesome monitor",
        monitor_tags_filters=["foo:bar"])
    ```


    :param Sequence[str] monitor_tags_filters: A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
    :param str name_filter: A monitor name to limit the search.
    :param Sequence[str] tags_filters: A list of tags to limit the search. This filters on the monitor scope.
    """
    ...
