# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetMonitorsResult',
    'AwaitableGetMonitorsResult',
    'get_monitors',
    'get_monitors_output',
]

@pulumi.output_type
class GetMonitorsResult:
    """
    A collection of values returned by getMonitors.
    """
    def __init__(__self__, id=None, monitor_tags_filters=None, monitors=None, name_filter=None, tags_filters=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitor_tags_filters and not isinstance(monitor_tags_filters, list):
            raise TypeError("Expected argument 'monitor_tags_filters' to be a list")
        pulumi.set(__self__, "monitor_tags_filters", monitor_tags_filters)
        if monitors and not isinstance(monitors, list):
            raise TypeError("Expected argument 'monitors' to be a list")
        pulumi.set(__self__, "monitors", monitors)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)
        if tags_filters and not isinstance(tags_filters, list):
            raise TypeError("Expected argument 'tags_filters' to be a list")
        pulumi.set(__self__, "tags_filters", tags_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitorTagsFilters")
    def monitor_tags_filters(self) -> Optional[Sequence[str]]:
        """
        A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
        """
        return pulumi.get(self, "monitor_tags_filters")

    @property
    @pulumi.getter
    def monitors(self) -> Sequence['outputs.GetMonitorsMonitorResult']:
        """
        List of monitors
        """
        return pulumi.get(self, "monitors")

    @property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[str]:
        """
        A monitor name to limit the search.
        """
        return pulumi.get(self, "name_filter")

    @property
    @pulumi.getter(name="tagsFilters")
    def tags_filters(self) -> Optional[Sequence[str]]:
        """
        A list of tags to limit the search. This filters on the monitor scope.
        """
        return pulumi.get(self, "tags_filters")


class AwaitableGetMonitorsResult(GetMonitorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitorsResult(
            id=self.id,
            monitor_tags_filters=self.monitor_tags_filters,
            monitors=self.monitors,
            name_filter=self.name_filter,
            tags_filters=self.tags_filters)


def get_monitors(monitor_tags_filters: Optional[Sequence[str]] = None,
                 name_filter: Optional[str] = None,
                 tags_filters: Optional[Sequence[str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitorsResult:
    """
    Use this data source to list several existing monitors for use in other resources.


    :param Sequence[str] monitor_tags_filters: A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
    :param str name_filter: A monitor name to limit the search.
    :param Sequence[str] tags_filters: A list of tags to limit the search. This filters on the monitor scope.
    """
    __args__ = dict()
    __args__['monitorTagsFilters'] = monitor_tags_filters
    __args__['nameFilter'] = name_filter
    __args__['tagsFilters'] = tags_filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getMonitors:getMonitors', __args__, opts=opts, typ=GetMonitorsResult).value

    return AwaitableGetMonitorsResult(
        id=pulumi.get(__ret__, 'id'),
        monitor_tags_filters=pulumi.get(__ret__, 'monitor_tags_filters'),
        monitors=pulumi.get(__ret__, 'monitors'),
        name_filter=pulumi.get(__ret__, 'name_filter'),
        tags_filters=pulumi.get(__ret__, 'tags_filters'))


@_utilities.lift_output_func(get_monitors)
def get_monitors_output(monitor_tags_filters: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        name_filter: Optional[pulumi.Input[Optional[str]]] = None,
                        tags_filters: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitorsResult]:
    """
    Use this data source to list several existing monitors for use in other resources.


    :param Sequence[str] monitor_tags_filters: A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
    :param str name_filter: A monitor name to limit the search.
    :param Sequence[str] tags_filters: A list of tags to limit the search. This filters on the monitor scope.
    """
    ...
