# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetRoleUsersResult',
    'AwaitableGetRoleUsersResult',
    'get_role_users',
    'get_role_users_output',
]

@pulumi.output_type
class GetRoleUsersResult:
    """
    A collection of values returned by getRoleUsers.
    """
    def __init__(__self__, exact_match=None, filter=None, id=None, role_id=None, role_users=None):
        if exact_match and not isinstance(exact_match, bool):
            raise TypeError("Expected argument 'exact_match' to be a bool")
        pulumi.set(__self__, "exact_match", exact_match)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if role_id and not isinstance(role_id, str):
            raise TypeError("Expected argument 'role_id' to be a str")
        pulumi.set(__self__, "role_id", role_id)
        if role_users and not isinstance(role_users, list):
            raise TypeError("Expected argument 'role_users' to be a list")
        pulumi.set(__self__, "role_users", role_users)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[bool]:
        """
        When true, `filter_keyword` string is exact matched against the user's `name`.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        Search query, can be user name.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        The role's identifier.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="roleUsers")
    def role_users(self) -> Sequence['outputs.GetRoleUsersRoleUserResult']:
        """
        List of users assigned to role.
        """
        return pulumi.get(self, "role_users")


class AwaitableGetRoleUsersResult(GetRoleUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleUsersResult(
            exact_match=self.exact_match,
            filter=self.filter,
            id=self.id,
            role_id=self.role_id,
            role_users=self.role_users)


def get_role_users(exact_match: Optional[bool] = None,
                   filter: Optional[str] = None,
                   role_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleUsersResult:
    """
    Use this data source to retrieve information about existing Datadog role users assignments. This data source is in beta and is subject to change.


    :param bool exact_match: When true, `filter_keyword` string is exact matched against the user's `name`.
    :param str filter: Search query, can be user name.
    :param str role_id: The role's identifier.
    """
    __args__ = dict()
    __args__['exactMatch'] = exact_match
    __args__['filter'] = filter
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getRoleUsers:getRoleUsers', __args__, opts=opts, typ=GetRoleUsersResult).value

    return AwaitableGetRoleUsersResult(
        exact_match=pulumi.get(__ret__, 'exact_match'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        role_id=pulumi.get(__ret__, 'role_id'),
        role_users=pulumi.get(__ret__, 'role_users'))


@_utilities.lift_output_func(get_role_users)
def get_role_users_output(exact_match: Optional[pulumi.Input[Optional[bool]]] = None,
                          filter: Optional[pulumi.Input[Optional[str]]] = None,
                          role_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRoleUsersResult]:
    """
    Use this data source to retrieve information about existing Datadog role users assignments. This data source is in beta and is subject to change.


    :param bool exact_match: When true, `filter_keyword` string is exact matched against the user's `name`.
    :param str filter: Search query, can be user name.
    :param str role_id: The role's identifier.
    """
    ...
