# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetRumApplicationResult',
    'AwaitableGetRumApplicationResult',
    'get_rum_application',
    'get_rum_application_output',
]

@pulumi.output_type
class GetRumApplicationResult:
    """
    A collection of values returned by getRumApplication.
    """
    def __init__(__self__, client_token=None, id=None, name=None, name_filter=None, type=None, type_filter=None):
        if client_token and not isinstance(client_token, str):
            raise TypeError("Expected argument 'client_token' to be a str")
        pulumi.set(__self__, "client_token", client_token)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if type_filter and not isinstance(type_filter, str):
            raise TypeError("Expected argument 'type_filter' to be a str")
        pulumi.set(__self__, "type_filter", type_filter)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> str:
        """
        The client token.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the RUM application. Cannot be used with name and type filters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the RUM application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[str]:
        """
        The name used to search for a RUM application.
        """
        return pulumi.get(self, "name_filter")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeFilter")
    def type_filter(self) -> Optional[str]:
        """
        The type used to search for a RUM application.
        """
        return pulumi.get(self, "type_filter")


class AwaitableGetRumApplicationResult(GetRumApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRumApplicationResult(
            client_token=self.client_token,
            id=self.id,
            name=self.name,
            name_filter=self.name_filter,
            type=self.type,
            type_filter=self.type_filter)


def get_rum_application(id: Optional[str] = None,
                        name_filter: Optional[str] = None,
                        type_filter: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRumApplicationResult:
    """
    Use this data source to retrieve a Datadog RUM Application.


    :param str id: ID of the RUM application. Cannot be used with name and type filters.
    :param str name_filter: The name used to search for a RUM application.
    :param str type_filter: The type used to search for a RUM application.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['nameFilter'] = name_filter
    __args__['typeFilter'] = type_filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getRumApplication:getRumApplication', __args__, opts=opts, typ=GetRumApplicationResult).value

    return AwaitableGetRumApplicationResult(
        client_token=pulumi.get(__ret__, 'client_token'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        name_filter=pulumi.get(__ret__, 'name_filter'),
        type=pulumi.get(__ret__, 'type'),
        type_filter=pulumi.get(__ret__, 'type_filter'))


@_utilities.lift_output_func(get_rum_application)
def get_rum_application_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                               name_filter: Optional[pulumi.Input[Optional[str]]] = None,
                               type_filter: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRumApplicationResult]:
    """
    Use this data source to retrieve a Datadog RUM Application.


    :param str id: ID of the RUM application. Cannot be used with name and type filters.
    :param str name_filter: The name used to search for a RUM application.
    :param str type_filter: The type used to search for a RUM application.
    """
    ...
