# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetSyntheticsTestResult',
    'AwaitableGetSyntheticsTestResult',
    'get_synthetics_test',
    'get_synthetics_test_output',
]

@pulumi.output_type
class GetSyntheticsTestResult:
    """
    A collection of values returned by getSyntheticsTest.
    """
    def __init__(__self__, id=None, name=None, tags=None, test_id=None, url=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if test_id and not isinstance(test_id, str):
            raise TypeError("Expected argument 'test_id' to be a str")
        pulumi.set(__self__, "test_id", test_id)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the synthetic test.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A list of tags assigned to the synthetic test.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="testId")
    def test_id(self) -> str:
        """
        The synthetic test id or URL to search for
        """
        return pulumi.get(self, "test_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The start URL of the synthetic test.
        """
        return pulumi.get(self, "url")


class AwaitableGetSyntheticsTestResult(GetSyntheticsTestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSyntheticsTestResult(
            id=self.id,
            name=self.name,
            tags=self.tags,
            test_id=self.test_id,
            url=self.url)


def get_synthetics_test(test_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSyntheticsTestResult:
    """
    Use this data source to retrieve a Datadog Synthetic Test.


    :param str test_id: The synthetic test id or URL to search for
    """
    __args__ = dict()
    __args__['testId'] = test_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getSyntheticsTest:getSyntheticsTest', __args__, opts=opts, typ=GetSyntheticsTestResult).value

    return AwaitableGetSyntheticsTestResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'),
        test_id=pulumi.get(__ret__, 'test_id'),
        url=pulumi.get(__ret__, 'url'))


@_utilities.lift_output_func(get_synthetics_test)
def get_synthetics_test_output(test_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSyntheticsTestResult]:
    """
    Use this data source to retrieve a Datadog Synthetic Test.


    :param str test_id: The synthetic test id or URL to search for
    """
    ...
