# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTeamResult',
    'AwaitableGetTeamResult',
    'get_team',
    'get_team_output',
]

@pulumi.output_type
class GetTeamResult:
    """
    A collection of values returned by getTeam.
    """
    def __init__(__self__, description=None, filter_keyword=None, handle=None, id=None, link_count=None, name=None, summary=None, team_id=None, user_count=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter_keyword and not isinstance(filter_keyword, str):
            raise TypeError("Expected argument 'filter_keyword' to be a str")
        pulumi.set(__self__, "filter_keyword", filter_keyword)
        if handle and not isinstance(handle, str):
            raise TypeError("Expected argument 'handle' to be a str")
        pulumi.set(__self__, "handle", handle)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link_count and not isinstance(link_count, int):
            raise TypeError("Expected argument 'link_count' to be a int")
        pulumi.set(__self__, "link_count", link_count)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if summary and not isinstance(summary, str):
            raise TypeError("Expected argument 'summary' to be a str")
        pulumi.set(__self__, "summary", summary)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)
        if user_count and not isinstance(user_count, int):
            raise TypeError("Expected argument 'user_count' to be a int")
        pulumi.set(__self__, "user_count", user_count)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Free-form markdown description/content for the team's homepage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="filterKeyword")
    def filter_keyword(self) -> Optional[str]:
        """
        Search query. Can be team name, team handle, or email of team member.
        """
        return pulumi.get(self, "filter_keyword")

    @property
    @pulumi.getter
    def handle(self) -> str:
        """
        The team's handle.
        """
        return pulumi.get(self, "handle")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkCount")
    def link_count(self) -> int:
        """
        The number of links belonging to the team.
        """
        return pulumi.get(self, "link_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the team.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        A brief summary of the team, derived from the `description`.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The team's identifier.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userCount")
    def user_count(self) -> int:
        """
        The number of users belonging to the team.
        """
        return pulumi.get(self, "user_count")


class AwaitableGetTeamResult(GetTeamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamResult(
            description=self.description,
            filter_keyword=self.filter_keyword,
            handle=self.handle,
            id=self.id,
            link_count=self.link_count,
            name=self.name,
            summary=self.summary,
            team_id=self.team_id,
            user_count=self.user_count)


def get_team(filter_keyword: Optional[str] = None,
             team_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamResult:
    """
    Use this data source to retrieve information about an existing Datadog team.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    foo = datadog.get_team(team_id="e6723c40-edb1-11ed-b816-da7ad0900002")
    ```


    :param str filter_keyword: Search query. Can be team name, team handle, or email of team member.
    :param str team_id: The team's identifier.
    """
    __args__ = dict()
    __args__['filterKeyword'] = filter_keyword
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult).value

    return AwaitableGetTeamResult(
        description=pulumi.get(__ret__, 'description'),
        filter_keyword=pulumi.get(__ret__, 'filter_keyword'),
        handle=pulumi.get(__ret__, 'handle'),
        id=pulumi.get(__ret__, 'id'),
        link_count=pulumi.get(__ret__, 'link_count'),
        name=pulumi.get(__ret__, 'name'),
        summary=pulumi.get(__ret__, 'summary'),
        team_id=pulumi.get(__ret__, 'team_id'),
        user_count=pulumi.get(__ret__, 'user_count'))


@_utilities.lift_output_func(get_team)
def get_team_output(filter_keyword: Optional[pulumi.Input[Optional[str]]] = None,
                    team_id: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTeamResult]:
    """
    Use this data source to retrieve information about an existing Datadog team.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    foo = datadog.get_team(team_id="e6723c40-edb1-11ed-b816-da7ad0900002")
    ```


    :param str filter_keyword: Search query. Can be team name, team handle, or email of team member.
    :param str team_id: The team's identifier.
    """
    ...
