# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, email=None, exact_match=None, filter=None, id=None, name=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if exact_match and not isinstance(exact_match, bool):
            raise TypeError("Expected argument 'exact_match' to be a bool")
        pulumi.set(__self__, "exact_match", exact_match)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[bool]:
        """
        When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute. Defaults to `false`.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Filter all users by the given string.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the user.
        """
        return pulumi.get(self, "name")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            email=self.email,
            exact_match=self.exact_match,
            filter=self.filter,
            id=self.id,
            name=self.name)


def get_user(exact_match: Optional[bool] = None,
             filter: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to retrieve information about an existing user to use it in an other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_user(filter="user.name@company.com")
    ```


    :param bool exact_match: When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute. Defaults to `false`.
    :param str filter: Filter all users by the given string.
    """
    __args__ = dict()
    __args__['exactMatch'] = exact_match
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        email=pulumi.get(__ret__, 'email'),
        exact_match=pulumi.get(__ret__, 'exact_match'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_user)
def get_user_output(exact_match: Optional[pulumi.Input[Optional[bool]]] = None,
                    filter: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to retrieve information about an existing user to use it in an other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_user(filter="user.name@company.com")
    ```


    :param bool exact_match: When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute. Defaults to `false`.
    :param str filter: Filter all users by the given string.
    """
    ...
