# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, filter=None, filter_status=None, id=None, users=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if filter_status and not isinstance(filter_status, str):
            raise TypeError("Expected argument 'filter_status' to be a str")
        pulumi.set(__self__, "filter_status", filter_status)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        Filter all users by the given string.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterStatus")
    def filter_status(self) -> Optional[str]:
        """
        Filter on status attribute. Comma-separated list with possible values of Active, Pending, and Disabled.
        """
        return pulumi.get(self, "filter_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUsersUserResult']:
        """
        List of users
        """
        return pulumi.get(self, "users")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            filter=self.filter,
            filter_status=self.filter_status,
            id=self.id,
            users=self.users)


def get_users(filter: Optional[str] = None,
              filter_status: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    Use this data source to retrieve information about existing users for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_users(filter="user.name@company.com",
        filter_status="Active,Pending")
    ```


    :param str filter: Filter all users by the given string.
    :param str filter_status: Filter on status attribute. Comma-separated list with possible values of Active, Pending, and Disabled.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['filterStatus'] = filter_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        filter=pulumi.get(__ret__, 'filter'),
        filter_status=pulumi.get(__ret__, 'filter_status'),
        id=pulumi.get(__ret__, 'id'),
        users=pulumi.get(__ret__, 'users'))


@_utilities.lift_output_func(get_users)
def get_users_output(filter: Optional[pulumi.Input[Optional[str]]] = None,
                     filter_status: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsersResult]:
    """
    Use this data source to retrieve information about existing users for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_users(filter="user.name@company.com",
        filter_status="Active,Pending")
    ```


    :param str filter: Filter all users by the given string.
    :param str filter_status: Filter on status attribute. Comma-separated list with possible values of Active, Pending, and Disabled.
    """
    ...
