# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogsArchiveArgs', 'LogsArchive']

@pulumi.input_type
class LogsArchiveArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 query: pulumi.Input[str],
                 azure_archive: Optional[pulumi.Input['LogsArchiveAzureArchiveArgs']] = None,
                 gcs_archive: Optional[pulumi.Input['LogsArchiveGcsArchiveArgs']] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 rehydration_max_scan_size_in_gb: Optional[pulumi.Input[int]] = None,
                 rehydration_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_archive: Optional[pulumi.Input['LogsArchiveS3ArchiveArgs']] = None):
        """
        The set of arguments for constructing a LogsArchive resource.
        :param pulumi.Input[str] name: Your archive name.
        :param pulumi.Input[str] query: The archive query/filter. Logs matching this query are included in the archive.
        :param pulumi.Input['LogsArchiveAzureArchiveArgs'] azure_archive: Definition of an azure archive.
        :param pulumi.Input['LogsArchiveGcsArchiveArgs'] gcs_archive: Definition of a GCS archive.
        :param pulumi.Input[bool] include_tags: To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        :param pulumi.Input[int] rehydration_max_scan_size_in_gb: To limit the rehydration scan size for the archive, set a value in GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rehydration_tags: An array of tags to add to rehydrated logs from an archive.
        :param pulumi.Input['LogsArchiveS3ArchiveArgs'] s3_archive: Definition of an s3 archive.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        if azure_archive is not None:
            pulumi.set(__self__, "azure_archive", azure_archive)
        if gcs_archive is not None:
            pulumi.set(__self__, "gcs_archive", gcs_archive)
        if include_tags is not None:
            pulumi.set(__self__, "include_tags", include_tags)
        if rehydration_max_scan_size_in_gb is not None:
            pulumi.set(__self__, "rehydration_max_scan_size_in_gb", rehydration_max_scan_size_in_gb)
        if rehydration_tags is not None:
            pulumi.set(__self__, "rehydration_tags", rehydration_tags)
        if s3_archive is not None:
            pulumi.set(__self__, "s3_archive", s3_archive)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Your archive name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        The archive query/filter. Logs matching this query are included in the archive.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="azureArchive")
    def azure_archive(self) -> Optional[pulumi.Input['LogsArchiveAzureArchiveArgs']]:
        """
        Definition of an azure archive.
        """
        return pulumi.get(self, "azure_archive")

    @azure_archive.setter
    def azure_archive(self, value: Optional[pulumi.Input['LogsArchiveAzureArchiveArgs']]):
        pulumi.set(self, "azure_archive", value)

    @property
    @pulumi.getter(name="gcsArchive")
    def gcs_archive(self) -> Optional[pulumi.Input['LogsArchiveGcsArchiveArgs']]:
        """
        Definition of a GCS archive.
        """
        return pulumi.get(self, "gcs_archive")

    @gcs_archive.setter
    def gcs_archive(self, value: Optional[pulumi.Input['LogsArchiveGcsArchiveArgs']]):
        pulumi.set(self, "gcs_archive", value)

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        """
        return pulumi.get(self, "include_tags")

    @include_tags.setter
    def include_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_tags", value)

    @property
    @pulumi.getter(name="rehydrationMaxScanSizeInGb")
    def rehydration_max_scan_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        To limit the rehydration scan size for the archive, set a value in GB.
        """
        return pulumi.get(self, "rehydration_max_scan_size_in_gb")

    @rehydration_max_scan_size_in_gb.setter
    def rehydration_max_scan_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rehydration_max_scan_size_in_gb", value)

    @property
    @pulumi.getter(name="rehydrationTags")
    def rehydration_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of tags to add to rehydrated logs from an archive.
        """
        return pulumi.get(self, "rehydration_tags")

    @rehydration_tags.setter
    def rehydration_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rehydration_tags", value)

    @property
    @pulumi.getter(name="s3Archive")
    def s3_archive(self) -> Optional[pulumi.Input['LogsArchiveS3ArchiveArgs']]:
        """
        Definition of an s3 archive.
        """
        return pulumi.get(self, "s3_archive")

    @s3_archive.setter
    def s3_archive(self, value: Optional[pulumi.Input['LogsArchiveS3ArchiveArgs']]):
        pulumi.set(self, "s3_archive", value)


@pulumi.input_type
class _LogsArchiveState:
    def __init__(__self__, *,
                 azure_archive: Optional[pulumi.Input['LogsArchiveAzureArchiveArgs']] = None,
                 gcs_archive: Optional[pulumi.Input['LogsArchiveGcsArchiveArgs']] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 rehydration_max_scan_size_in_gb: Optional[pulumi.Input[int]] = None,
                 rehydration_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_archive: Optional[pulumi.Input['LogsArchiveS3ArchiveArgs']] = None):
        """
        Input properties used for looking up and filtering LogsArchive resources.
        :param pulumi.Input['LogsArchiveAzureArchiveArgs'] azure_archive: Definition of an azure archive.
        :param pulumi.Input['LogsArchiveGcsArchiveArgs'] gcs_archive: Definition of a GCS archive.
        :param pulumi.Input[bool] include_tags: To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        :param pulumi.Input[str] name: Your archive name.
        :param pulumi.Input[str] query: The archive query/filter. Logs matching this query are included in the archive.
        :param pulumi.Input[int] rehydration_max_scan_size_in_gb: To limit the rehydration scan size for the archive, set a value in GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rehydration_tags: An array of tags to add to rehydrated logs from an archive.
        :param pulumi.Input['LogsArchiveS3ArchiveArgs'] s3_archive: Definition of an s3 archive.
        """
        if azure_archive is not None:
            pulumi.set(__self__, "azure_archive", azure_archive)
        if gcs_archive is not None:
            pulumi.set(__self__, "gcs_archive", gcs_archive)
        if include_tags is not None:
            pulumi.set(__self__, "include_tags", include_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if rehydration_max_scan_size_in_gb is not None:
            pulumi.set(__self__, "rehydration_max_scan_size_in_gb", rehydration_max_scan_size_in_gb)
        if rehydration_tags is not None:
            pulumi.set(__self__, "rehydration_tags", rehydration_tags)
        if s3_archive is not None:
            pulumi.set(__self__, "s3_archive", s3_archive)

    @property
    @pulumi.getter(name="azureArchive")
    def azure_archive(self) -> Optional[pulumi.Input['LogsArchiveAzureArchiveArgs']]:
        """
        Definition of an azure archive.
        """
        return pulumi.get(self, "azure_archive")

    @azure_archive.setter
    def azure_archive(self, value: Optional[pulumi.Input['LogsArchiveAzureArchiveArgs']]):
        pulumi.set(self, "azure_archive", value)

    @property
    @pulumi.getter(name="gcsArchive")
    def gcs_archive(self) -> Optional[pulumi.Input['LogsArchiveGcsArchiveArgs']]:
        """
        Definition of a GCS archive.
        """
        return pulumi.get(self, "gcs_archive")

    @gcs_archive.setter
    def gcs_archive(self, value: Optional[pulumi.Input['LogsArchiveGcsArchiveArgs']]):
        pulumi.set(self, "gcs_archive", value)

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        """
        return pulumi.get(self, "include_tags")

    @include_tags.setter
    def include_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Your archive name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        The archive query/filter. Logs matching this query are included in the archive.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="rehydrationMaxScanSizeInGb")
    def rehydration_max_scan_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        To limit the rehydration scan size for the archive, set a value in GB.
        """
        return pulumi.get(self, "rehydration_max_scan_size_in_gb")

    @rehydration_max_scan_size_in_gb.setter
    def rehydration_max_scan_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rehydration_max_scan_size_in_gb", value)

    @property
    @pulumi.getter(name="rehydrationTags")
    def rehydration_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of tags to add to rehydrated logs from an archive.
        """
        return pulumi.get(self, "rehydration_tags")

    @rehydration_tags.setter
    def rehydration_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rehydration_tags", value)

    @property
    @pulumi.getter(name="s3Archive")
    def s3_archive(self) -> Optional[pulumi.Input['LogsArchiveS3ArchiveArgs']]:
        """
        Definition of an s3 archive.
        """
        return pulumi.get(self, "s3_archive")

    @s3_archive.setter
    def s3_archive(self, value: Optional[pulumi.Input['LogsArchiveS3ArchiveArgs']]):
        pulumi.set(self, "s3_archive", value)


class LogsArchive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveAzureArchiveArgs']]] = None,
                 gcs_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveGcsArchiveArgs']]] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 rehydration_max_scan_size_in_gb: Optional[pulumi.Input[int]] = None,
                 rehydration_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveS3ArchiveArgs']]] = None,
                 __props__=None):
        """
        Provides a Datadog Logs Archive API resource, which is used to create and manage Datadog logs archives.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_s3_archive = datadog.LogsArchive("my_s3_archive",
            name="my s3 archive",
            query="service:myservice",
            s3_archive=datadog.LogsArchiveS3ArchiveArgs(
                bucket="my-bucket",
                path="/path/foo",
                account_id="001234567888",
                role_name="my-role-name",
            ))
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/logsArchive:LogsArchive my_s3_archive 1Aabc2_dfQPLnXy3HlfK4hi
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LogsArchiveAzureArchiveArgs']] azure_archive: Definition of an azure archive.
        :param pulumi.Input[pulumi.InputType['LogsArchiveGcsArchiveArgs']] gcs_archive: Definition of a GCS archive.
        :param pulumi.Input[bool] include_tags: To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        :param pulumi.Input[str] name: Your archive name.
        :param pulumi.Input[str] query: The archive query/filter. Logs matching this query are included in the archive.
        :param pulumi.Input[int] rehydration_max_scan_size_in_gb: To limit the rehydration scan size for the archive, set a value in GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rehydration_tags: An array of tags to add to rehydrated logs from an archive.
        :param pulumi.Input[pulumi.InputType['LogsArchiveS3ArchiveArgs']] s3_archive: Definition of an s3 archive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsArchiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Logs Archive API resource, which is used to create and manage Datadog logs archives.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_s3_archive = datadog.LogsArchive("my_s3_archive",
            name="my s3 archive",
            query="service:myservice",
            s3_archive=datadog.LogsArchiveS3ArchiveArgs(
                bucket="my-bucket",
                path="/path/foo",
                account_id="001234567888",
                role_name="my-role-name",
            ))
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/logsArchive:LogsArchive my_s3_archive 1Aabc2_dfQPLnXy3HlfK4hi
        ```

        :param str resource_name: The name of the resource.
        :param LogsArchiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsArchiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveAzureArchiveArgs']]] = None,
                 gcs_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveGcsArchiveArgs']]] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 rehydration_max_scan_size_in_gb: Optional[pulumi.Input[int]] = None,
                 rehydration_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveS3ArchiveArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsArchiveArgs.__new__(LogsArchiveArgs)

            __props__.__dict__["azure_archive"] = azure_archive
            __props__.__dict__["gcs_archive"] = gcs_archive
            __props__.__dict__["include_tags"] = include_tags
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["rehydration_max_scan_size_in_gb"] = rehydration_max_scan_size_in_gb
            __props__.__dict__["rehydration_tags"] = rehydration_tags
            __props__.__dict__["s3_archive"] = s3_archive
        super(LogsArchive, __self__).__init__(
            'datadog:index/logsArchive:LogsArchive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveAzureArchiveArgs']]] = None,
            gcs_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveGcsArchiveArgs']]] = None,
            include_tags: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            query: Optional[pulumi.Input[str]] = None,
            rehydration_max_scan_size_in_gb: Optional[pulumi.Input[int]] = None,
            rehydration_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            s3_archive: Optional[pulumi.Input[pulumi.InputType['LogsArchiveS3ArchiveArgs']]] = None) -> 'LogsArchive':
        """
        Get an existing LogsArchive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LogsArchiveAzureArchiveArgs']] azure_archive: Definition of an azure archive.
        :param pulumi.Input[pulumi.InputType['LogsArchiveGcsArchiveArgs']] gcs_archive: Definition of a GCS archive.
        :param pulumi.Input[bool] include_tags: To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        :param pulumi.Input[str] name: Your archive name.
        :param pulumi.Input[str] query: The archive query/filter. Logs matching this query are included in the archive.
        :param pulumi.Input[int] rehydration_max_scan_size_in_gb: To limit the rehydration scan size for the archive, set a value in GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rehydration_tags: An array of tags to add to rehydrated logs from an archive.
        :param pulumi.Input[pulumi.InputType['LogsArchiveS3ArchiveArgs']] s3_archive: Definition of an s3 archive.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsArchiveState.__new__(_LogsArchiveState)

        __props__.__dict__["azure_archive"] = azure_archive
        __props__.__dict__["gcs_archive"] = gcs_archive
        __props__.__dict__["include_tags"] = include_tags
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["rehydration_max_scan_size_in_gb"] = rehydration_max_scan_size_in_gb
        __props__.__dict__["rehydration_tags"] = rehydration_tags
        __props__.__dict__["s3_archive"] = s3_archive
        return LogsArchive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureArchive")
    def azure_archive(self) -> pulumi.Output[Optional['outputs.LogsArchiveAzureArchive']]:
        """
        Definition of an azure archive.
        """
        return pulumi.get(self, "azure_archive")

    @property
    @pulumi.getter(name="gcsArchive")
    def gcs_archive(self) -> pulumi.Output[Optional['outputs.LogsArchiveGcsArchive']]:
        """
        Definition of a GCS archive.
        """
        return pulumi.get(self, "gcs_archive")

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> pulumi.Output[Optional[bool]]:
        """
        To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive. Defaults to `false`.
        """
        return pulumi.get(self, "include_tags")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Your archive name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[str]:
        """
        The archive query/filter. Logs matching this query are included in the archive.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="rehydrationMaxScanSizeInGb")
    def rehydration_max_scan_size_in_gb(self) -> pulumi.Output[Optional[int]]:
        """
        To limit the rehydration scan size for the archive, set a value in GB.
        """
        return pulumi.get(self, "rehydration_max_scan_size_in_gb")

    @property
    @pulumi.getter(name="rehydrationTags")
    def rehydration_tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of tags to add to rehydrated logs from an archive.
        """
        return pulumi.get(self, "rehydration_tags")

    @property
    @pulumi.getter(name="s3Archive")
    def s3_archive(self) -> pulumi.Output[Optional['outputs.LogsArchiveS3Archive']]:
        """
        Definition of an s3 archive.
        """
        return pulumi.get(self, "s3_archive")

