# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogsIndexArgs', 'LogsIndex']

@pulumi.input_type
class LogsIndexArgs:
    def __init__(__self__, *,
                 filters: pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]],
                 name: pulumi.Input[str],
                 daily_limit: Optional[pulumi.Input[int]] = None,
                 daily_limit_reset: Optional[pulumi.Input['LogsIndexDailyLimitResetArgs']] = None,
                 daily_limit_warning_threshold_percentage: Optional[pulumi.Input[float]] = None,
                 disable_daily_limit: Optional[pulumi.Input[bool]] = None,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a LogsIndex resource.
        :param pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]] filters: Logs filter
        :param pulumi.Input[str] name: The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        :param pulumi.Input[int] daily_limit: The number of log events you can send in this index per day before you are rate-limited.
        :param pulumi.Input['LogsIndexDailyLimitResetArgs'] daily_limit_reset: Object containing options to override the default daily limit reset time.
        :param pulumi.Input[float] daily_limit_warning_threshold_percentage: A percentage threshold of the daily quota at which a Datadog warning event is generated.
        :param pulumi.Input[bool] disable_daily_limit: If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        :param pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]] exclusion_filters: List of exclusion filters.
        :param pulumi.Input[int] retention_days: The number of days before logs are deleted from this index.
        """
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "name", name)
        if daily_limit is not None:
            pulumi.set(__self__, "daily_limit", daily_limit)
        if daily_limit_reset is not None:
            pulumi.set(__self__, "daily_limit_reset", daily_limit_reset)
        if daily_limit_warning_threshold_percentage is not None:
            pulumi.set(__self__, "daily_limit_warning_threshold_percentage", daily_limit_warning_threshold_percentage)
        if disable_daily_limit is not None:
            pulumi.set(__self__, "disable_daily_limit", disable_daily_limit)
        if exclusion_filters is not None:
            pulumi.set(__self__, "exclusion_filters", exclusion_filters)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]]:
        """
        Logs filter
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="dailyLimit")
    def daily_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The number of log events you can send in this index per day before you are rate-limited.
        """
        return pulumi.get(self, "daily_limit")

    @daily_limit.setter
    def daily_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "daily_limit", value)

    @property
    @pulumi.getter(name="dailyLimitReset")
    def daily_limit_reset(self) -> Optional[pulumi.Input['LogsIndexDailyLimitResetArgs']]:
        """
        Object containing options to override the default daily limit reset time.
        """
        return pulumi.get(self, "daily_limit_reset")

    @daily_limit_reset.setter
    def daily_limit_reset(self, value: Optional[pulumi.Input['LogsIndexDailyLimitResetArgs']]):
        pulumi.set(self, "daily_limit_reset", value)

    @property
    @pulumi.getter(name="dailyLimitWarningThresholdPercentage")
    def daily_limit_warning_threshold_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        A percentage threshold of the daily quota at which a Datadog warning event is generated.
        """
        return pulumi.get(self, "daily_limit_warning_threshold_percentage")

    @daily_limit_warning_threshold_percentage.setter
    def daily_limit_warning_threshold_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "daily_limit_warning_threshold_percentage", value)

    @property
    @pulumi.getter(name="disableDailyLimit")
    def disable_daily_limit(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        """
        return pulumi.get(self, "disable_daily_limit")

    @disable_daily_limit.setter
    def disable_daily_limit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_daily_limit", value)

    @property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]]]:
        """
        List of exclusion filters.
        """
        return pulumi.get(self, "exclusion_filters")

    @exclusion_filters.setter
    def exclusion_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]]]):
        pulumi.set(self, "exclusion_filters", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days before logs are deleted from this index.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.input_type
class _LogsIndexState:
    def __init__(__self__, *,
                 daily_limit: Optional[pulumi.Input[int]] = None,
                 daily_limit_reset: Optional[pulumi.Input['LogsIndexDailyLimitResetArgs']] = None,
                 daily_limit_warning_threshold_percentage: Optional[pulumi.Input[float]] = None,
                 disable_daily_limit: Optional[pulumi.Input[bool]] = None,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering LogsIndex resources.
        :param pulumi.Input[int] daily_limit: The number of log events you can send in this index per day before you are rate-limited.
        :param pulumi.Input['LogsIndexDailyLimitResetArgs'] daily_limit_reset: Object containing options to override the default daily limit reset time.
        :param pulumi.Input[float] daily_limit_warning_threshold_percentage: A percentage threshold of the daily quota at which a Datadog warning event is generated.
        :param pulumi.Input[bool] disable_daily_limit: If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        :param pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]] exclusion_filters: List of exclusion filters.
        :param pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]] filters: Logs filter
        :param pulumi.Input[str] name: The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        :param pulumi.Input[int] retention_days: The number of days before logs are deleted from this index.
        """
        if daily_limit is not None:
            pulumi.set(__self__, "daily_limit", daily_limit)
        if daily_limit_reset is not None:
            pulumi.set(__self__, "daily_limit_reset", daily_limit_reset)
        if daily_limit_warning_threshold_percentage is not None:
            pulumi.set(__self__, "daily_limit_warning_threshold_percentage", daily_limit_warning_threshold_percentage)
        if disable_daily_limit is not None:
            pulumi.set(__self__, "disable_daily_limit", disable_daily_limit)
        if exclusion_filters is not None:
            pulumi.set(__self__, "exclusion_filters", exclusion_filters)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="dailyLimit")
    def daily_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The number of log events you can send in this index per day before you are rate-limited.
        """
        return pulumi.get(self, "daily_limit")

    @daily_limit.setter
    def daily_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "daily_limit", value)

    @property
    @pulumi.getter(name="dailyLimitReset")
    def daily_limit_reset(self) -> Optional[pulumi.Input['LogsIndexDailyLimitResetArgs']]:
        """
        Object containing options to override the default daily limit reset time.
        """
        return pulumi.get(self, "daily_limit_reset")

    @daily_limit_reset.setter
    def daily_limit_reset(self, value: Optional[pulumi.Input['LogsIndexDailyLimitResetArgs']]):
        pulumi.set(self, "daily_limit_reset", value)

    @property
    @pulumi.getter(name="dailyLimitWarningThresholdPercentage")
    def daily_limit_warning_threshold_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        A percentage threshold of the daily quota at which a Datadog warning event is generated.
        """
        return pulumi.get(self, "daily_limit_warning_threshold_percentage")

    @daily_limit_warning_threshold_percentage.setter
    def daily_limit_warning_threshold_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "daily_limit_warning_threshold_percentage", value)

    @property
    @pulumi.getter(name="disableDailyLimit")
    def disable_daily_limit(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        """
        return pulumi.get(self, "disable_daily_limit")

    @disable_daily_limit.setter
    def disable_daily_limit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_daily_limit", value)

    @property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]]]:
        """
        List of exclusion filters.
        """
        return pulumi.get(self, "exclusion_filters")

    @exclusion_filters.setter
    def exclusion_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexExclusionFilterArgs']]]]):
        pulumi.set(self, "exclusion_filters", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]]]:
        """
        Logs filter
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsIndexFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days before logs are deleted from this index.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_days", value)


class LogsIndex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_limit: Optional[pulumi.Input[int]] = None,
                 daily_limit_reset: Optional[pulumi.Input[pulumi.InputType['LogsIndexDailyLimitResetArgs']]] = None,
                 daily_limit_warning_threshold_percentage: Optional[pulumi.Input[float]] = None,
                 disable_daily_limit: Optional[pulumi.Input[bool]] = None,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexExclusionFilterArgs']]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexFilterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # A sample Datadog logs index resource definition.
        sample_index = datadog.LogsIndex("sample_index",
            name="your index",
            daily_limit=200000,
            daily_limit_reset=datadog.LogsIndexDailyLimitResetArgs(
                reset_time="14:00",
                reset_utc_offset="+02:00",
            ),
            daily_limit_warning_threshold_percentage=50,
            retention_days=7,
            filters=[datadog.LogsIndexFilterArgs(
                query="*",
            )],
            exclusion_filters=[
                datadog.LogsIndexExclusionFilterArgs(
                    name="Filter coredns logs",
                    is_enabled=True,
                    filters=[datadog.LogsIndexExclusionFilterFilterArgs(
                        query="app:coredns",
                        sample_rate=0.97,
                    )],
                ),
                datadog.LogsIndexExclusionFilterArgs(
                    name="Kubernetes apiserver",
                    is_enabled=True,
                    filters=[datadog.LogsIndexExclusionFilterFilterArgs(
                        query="service:kube_apiserver",
                        sample_rate=1,
                    )],
                ),
            ])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/logsIndex:LogsIndex name> <indexName>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] daily_limit: The number of log events you can send in this index per day before you are rate-limited.
        :param pulumi.Input[pulumi.InputType['LogsIndexDailyLimitResetArgs']] daily_limit_reset: Object containing options to override the default daily limit reset time.
        :param pulumi.Input[float] daily_limit_warning_threshold_percentage: A percentage threshold of the daily quota at which a Datadog warning event is generated.
        :param pulumi.Input[bool] disable_daily_limit: If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexExclusionFilterArgs']]]] exclusion_filters: List of exclusion filters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexFilterArgs']]]] filters: Logs filter
        :param pulumi.Input[str] name: The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        :param pulumi.Input[int] retention_days: The number of days before logs are deleted from this index.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsIndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # A sample Datadog logs index resource definition.
        sample_index = datadog.LogsIndex("sample_index",
            name="your index",
            daily_limit=200000,
            daily_limit_reset=datadog.LogsIndexDailyLimitResetArgs(
                reset_time="14:00",
                reset_utc_offset="+02:00",
            ),
            daily_limit_warning_threshold_percentage=50,
            retention_days=7,
            filters=[datadog.LogsIndexFilterArgs(
                query="*",
            )],
            exclusion_filters=[
                datadog.LogsIndexExclusionFilterArgs(
                    name="Filter coredns logs",
                    is_enabled=True,
                    filters=[datadog.LogsIndexExclusionFilterFilterArgs(
                        query="app:coredns",
                        sample_rate=0.97,
                    )],
                ),
                datadog.LogsIndexExclusionFilterArgs(
                    name="Kubernetes apiserver",
                    is_enabled=True,
                    filters=[datadog.LogsIndexExclusionFilterFilterArgs(
                        query="service:kube_apiserver",
                        sample_rate=1,
                    )],
                ),
            ])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/logsIndex:LogsIndex name> <indexName>
        ```

        :param str resource_name: The name of the resource.
        :param LogsIndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsIndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_limit: Optional[pulumi.Input[int]] = None,
                 daily_limit_reset: Optional[pulumi.Input[pulumi.InputType['LogsIndexDailyLimitResetArgs']]] = None,
                 daily_limit_warning_threshold_percentage: Optional[pulumi.Input[float]] = None,
                 disable_daily_limit: Optional[pulumi.Input[bool]] = None,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexExclusionFilterArgs']]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexFilterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsIndexArgs.__new__(LogsIndexArgs)

            __props__.__dict__["daily_limit"] = daily_limit
            __props__.__dict__["daily_limit_reset"] = daily_limit_reset
            __props__.__dict__["daily_limit_warning_threshold_percentage"] = daily_limit_warning_threshold_percentage
            __props__.__dict__["disable_daily_limit"] = disable_daily_limit
            __props__.__dict__["exclusion_filters"] = exclusion_filters
            if filters is None and not opts.urn:
                raise TypeError("Missing required property 'filters'")
            __props__.__dict__["filters"] = filters
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_days"] = retention_days
        super(LogsIndex, __self__).__init__(
            'datadog:index/logsIndex:LogsIndex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            daily_limit: Optional[pulumi.Input[int]] = None,
            daily_limit_reset: Optional[pulumi.Input[pulumi.InputType['LogsIndexDailyLimitResetArgs']]] = None,
            daily_limit_warning_threshold_percentage: Optional[pulumi.Input[float]] = None,
            disable_daily_limit: Optional[pulumi.Input[bool]] = None,
            exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexExclusionFilterArgs']]]]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexFilterArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            retention_days: Optional[pulumi.Input[int]] = None) -> 'LogsIndex':
        """
        Get an existing LogsIndex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] daily_limit: The number of log events you can send in this index per day before you are rate-limited.
        :param pulumi.Input[pulumi.InputType['LogsIndexDailyLimitResetArgs']] daily_limit_reset: Object containing options to override the default daily limit reset time.
        :param pulumi.Input[float] daily_limit_warning_threshold_percentage: A percentage threshold of the daily quota at which a Datadog warning event is generated.
        :param pulumi.Input[bool] disable_daily_limit: If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexExclusionFilterArgs']]]] exclusion_filters: List of exclusion filters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogsIndexFilterArgs']]]] filters: Logs filter
        :param pulumi.Input[str] name: The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        :param pulumi.Input[int] retention_days: The number of days before logs are deleted from this index.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsIndexState.__new__(_LogsIndexState)

        __props__.__dict__["daily_limit"] = daily_limit
        __props__.__dict__["daily_limit_reset"] = daily_limit_reset
        __props__.__dict__["daily_limit_warning_threshold_percentage"] = daily_limit_warning_threshold_percentage
        __props__.__dict__["disable_daily_limit"] = disable_daily_limit
        __props__.__dict__["exclusion_filters"] = exclusion_filters
        __props__.__dict__["filters"] = filters
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_days"] = retention_days
        return LogsIndex(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dailyLimit")
    def daily_limit(self) -> pulumi.Output[Optional[int]]:
        """
        The number of log events you can send in this index per day before you are rate-limited.
        """
        return pulumi.get(self, "daily_limit")

    @property
    @pulumi.getter(name="dailyLimitReset")
    def daily_limit_reset(self) -> pulumi.Output['outputs.LogsIndexDailyLimitReset']:
        """
        Object containing options to override the default daily limit reset time.
        """
        return pulumi.get(self, "daily_limit_reset")

    @property
    @pulumi.getter(name="dailyLimitWarningThresholdPercentage")
    def daily_limit_warning_threshold_percentage(self) -> pulumi.Output[float]:
        """
        A percentage threshold of the daily quota at which a Datadog warning event is generated.
        """
        return pulumi.get(self, "daily_limit_warning_threshold_percentage")

    @property
    @pulumi.getter(name="disableDailyLimit")
    def disable_daily_limit(self) -> pulumi.Output[bool]:
        """
        If true, sets the daily*limit value to null and the index is not limited on a daily basis (any specified daily*limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
        """
        return pulumi.get(self, "disable_daily_limit")

    @property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> pulumi.Output[Optional[Sequence['outputs.LogsIndexExclusionFilter']]]:
        """
        List of exclusion filters.
        """
        return pulumi.get(self, "exclusion_filters")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Sequence['outputs.LogsIndexFilter']]:
        """
        Logs filter
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the index. Index names cannot be modified after creation. If this value is changed, a new index will be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[int]:
        """
        The number of days before logs are deleted from this index.
        """
        return pulumi.get(self, "retention_days")

