# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LogsPipelineOrderArgs', 'LogsPipelineOrder']

@pulumi.input_type
class LogsPipelineOrderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 pipelines: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a LogsPipelineOrder resource.
        :param pulumi.Input[str] name: The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pipelines: The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pipelines(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "pipelines", value)


@pulumi.input_type
class _LogsPipelineOrderState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering LogsPipelineOrder resources.
        :param pulumi.Input[str] name: The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pipelines: The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pipelines", value)


class LogsPipelineOrder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Logs Pipeline API resource, which is used to manage Datadog log pipelines order.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_pipeline_order = datadog.LogsPipelineOrder("sample_pipeline_order",
            name="sample_pipeline_order",
            pipelines=[
                sample_pipeline["id"],
                python["id"],
            ])
        ```

        ## Import

        There must be at most one datadog_logs_pipeline_order resource. Pipeline order creation is not supported from logs config API. You can import the datadog_logs_pipeline_order or create a pipeline order (which is actually doing the update operation).

        ```sh
        $ pulumi import datadog:index/logsPipelineOrder:LogsPipelineOrder name> <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pipelines: The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsPipelineOrderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Logs Pipeline API resource, which is used to manage Datadog log pipelines order.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_pipeline_order = datadog.LogsPipelineOrder("sample_pipeline_order",
            name="sample_pipeline_order",
            pipelines=[
                sample_pipeline["id"],
                python["id"],
            ])
        ```

        ## Import

        There must be at most one datadog_logs_pipeline_order resource. Pipeline order creation is not supported from logs config API. You can import the datadog_logs_pipeline_order or create a pipeline order (which is actually doing the update operation).

        ```sh
        $ pulumi import datadog:index/logsPipelineOrder:LogsPipelineOrder name> <name>
        ```

        :param str resource_name: The name of the resource.
        :param LogsPipelineOrderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsPipelineOrderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsPipelineOrderArgs.__new__(LogsPipelineOrderArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if pipelines is None and not opts.urn:
                raise TypeError("Missing required property 'pipelines'")
            __props__.__dict__["pipelines"] = pipelines
        super(LogsPipelineOrder, __self__).__init__(
            'datadog:index/logsPipelineOrder:LogsPipelineOrder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'LogsPipelineOrder':
        """
        Get an existing LogsPipelineOrder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pipelines: The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsPipelineOrderState.__new__(_LogsPipelineOrderState)

        __props__.__dict__["name"] = name
        __props__.__dict__["pipelines"] = pipelines
        return LogsPipelineOrder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name attribute in the resource `LogsPipelineOrder` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pipelines(self) -> pulumi.Output[Sequence[str]]:
        """
        The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
        """
        return pulumi.get(self, "pipelines")

