# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 message: pulumi.Input[str],
                 name: pulumi.Input[str],
                 query: pulumi.Input[str],
                 type: pulumi.Input[str],
                 enable_logs_sample: Optional[pulumi.Input[bool]] = None,
                 escalation_message: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[int]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 group_retention_duration: Optional[pulumi.Input[str]] = None,
                 groupby_simple_monitor: Optional[pulumi.Input[bool]] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 monitor_threshold_windows: Optional[pulumi.Input['MonitorMonitorThresholdWindowsArgs']] = None,
                 monitor_thresholds: Optional[pulumi.Input['MonitorMonitorThresholdsArgs']] = None,
                 new_group_delay: Optional[pulumi.Input[int]] = None,
                 new_host_delay: Optional[pulumi.Input[int]] = None,
                 no_data_timeframe: Optional[pulumi.Input[int]] = None,
                 notification_preset_name: Optional[pulumi.Input[str]] = None,
                 notify_audit: Optional[pulumi.Input[bool]] = None,
                 notify_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notify_no_data: Optional[pulumi.Input[bool]] = None,
                 on_missing_data: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 renotify_interval: Optional[pulumi.Input[int]] = None,
                 renotify_occurrences: Optional[pulumi.Input[int]] = None,
                 renotify_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_full_window: Optional[pulumi.Input[bool]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling_options: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout_h: Optional[pulumi.Input[int]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 variables: Optional[pulumi.Input['MonitorVariablesArgs']] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[str] message: A message to include with notifications for this monitor.
        :param pulumi.Input[str] name: Name of Datadog monitor.
        :param pulumi.Input[str] type: The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
               Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
               cannot be changed after a monitor is created.
        :param pulumi.Input[bool] enable_logs_sample: A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
               monitors. Defaults to `false`.
        :param pulumi.Input[str] escalation_message: A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        :param pulumi.Input[int] evaluation_delay: (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
               value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
               from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
               data during evaluation.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
               composite monitor).
        :param pulumi.Input[str] group_retention_duration: The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
               and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
               Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        :param pulumi.Input[bool] groupby_simple_monitor: Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
               `false`.
        :param pulumi.Input[bool] include_tags: A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        :param pulumi.Input[bool] locked: A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        :param pulumi.Input['MonitorMonitorThresholdWindowsArgs'] monitor_threshold_windows: A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
               required for, anomaly monitors.
        :param pulumi.Input['MonitorMonitorThresholdsArgs'] monitor_thresholds: Alert thresholds of the monitor.
        :param pulumi.Input[int] new_group_delay: The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
               nonzero value.
        :param pulumi.Input[int] new_host_delay: **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
               starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
               and monitors not grouped by host. The only case when this should be used is to override the default and set
               `new_host_delay` to zero for monitors grouped by host.
        :param pulumi.Input[int] no_data_timeframe: The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
               timeframe for metric alerts or 2 minutes for service checks.
        :param pulumi.Input[str] notification_preset_name: Toggles the display of additional content sent in the monitor notification.
        :param pulumi.Input[bool] notify_audit: A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_bies: Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
               grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
               conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
               in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
               to `[*]` configures the monitor to notify as a simple-alert.
        :param pulumi.Input[bool] notify_no_data: A boolean indicating whether this monitor will notify when data stops reporting.
        :param pulumi.Input[str] on_missing_data: Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
               in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
               evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
               `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
               available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
               `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        :param pulumi.Input[str] priority: Integer from 1 (high) to 5 (low) indicating alert severity.
        :param pulumi.Input[int] renotify_interval: The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
               re-notify if it's not resolved.
        :param pulumi.Input[int] renotify_occurrences: The number of re-notification messages that should be sent on the current status.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] renotify_statuses: The types of statuses for which re-notification messages should be sent.
        :param pulumi.Input[bool] require_full_window: A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
               you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
               `require_full_window` must be false and will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
               updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
               identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
               field.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]] scheduling_options: Configuration options for scheduling.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
               page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[int] timeout_h: The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
               minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        :param pulumi.Input[bool] validate: If set to `false`, skip the validation call done during plan.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "type", type)
        if enable_logs_sample is not None:
            pulumi.set(__self__, "enable_logs_sample", enable_logs_sample)
        if escalation_message is not None:
            pulumi.set(__self__, "escalation_message", escalation_message)
        if evaluation_delay is not None:
            pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if group_retention_duration is not None:
            pulumi.set(__self__, "group_retention_duration", group_retention_duration)
        if groupby_simple_monitor is not None:
            pulumi.set(__self__, "groupby_simple_monitor", groupby_simple_monitor)
        if include_tags is not None:
            pulumi.set(__self__, "include_tags", include_tags)
        if locked is not None:
            warnings.warn("""Use `restricted_roles`.""", DeprecationWarning)
            pulumi.log.warn("""locked is deprecated: Use `restricted_roles`.""")
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if monitor_threshold_windows is not None:
            pulumi.set(__self__, "monitor_threshold_windows", monitor_threshold_windows)
        if monitor_thresholds is not None:
            pulumi.set(__self__, "monitor_thresholds", monitor_thresholds)
        if new_group_delay is not None:
            pulumi.set(__self__, "new_group_delay", new_group_delay)
        if new_host_delay is not None:
            warnings.warn("""Use `new_group_delay` except when setting `new_host_delay` to zero.""", DeprecationWarning)
            pulumi.log.warn("""new_host_delay is deprecated: Use `new_group_delay` except when setting `new_host_delay` to zero.""")
        if new_host_delay is not None:
            pulumi.set(__self__, "new_host_delay", new_host_delay)
        if no_data_timeframe is not None:
            pulumi.set(__self__, "no_data_timeframe", no_data_timeframe)
        if notification_preset_name is not None:
            pulumi.set(__self__, "notification_preset_name", notification_preset_name)
        if notify_audit is not None:
            pulumi.set(__self__, "notify_audit", notify_audit)
        if notify_bies is not None:
            pulumi.set(__self__, "notify_bies", notify_bies)
        if notify_no_data is not None:
            pulumi.set(__self__, "notify_no_data", notify_no_data)
        if on_missing_data is not None:
            pulumi.set(__self__, "on_missing_data", on_missing_data)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if renotify_interval is not None:
            pulumi.set(__self__, "renotify_interval", renotify_interval)
        if renotify_occurrences is not None:
            pulumi.set(__self__, "renotify_occurrences", renotify_occurrences)
        if renotify_statuses is not None:
            pulumi.set(__self__, "renotify_statuses", renotify_statuses)
        if require_full_window is not None:
            pulumi.set(__self__, "require_full_window", require_full_window)
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if scheduling_options is not None:
            pulumi.set(__self__, "scheduling_options", scheduling_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout_h is not None:
            pulumi.set(__self__, "timeout_h", timeout_h)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[str]:
        """
        A message to include with notifications for this monitor.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of Datadog monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
        Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
        cannot be changed after a monitor is created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="enableLogsSample")
    def enable_logs_sample(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
        monitors. Defaults to `false`.
        """
        return pulumi.get(self, "enable_logs_sample")

    @enable_logs_sample.setter
    def enable_logs_sample(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logs_sample", value)

    @property
    @pulumi.getter(name="escalationMessage")
    def escalation_message(self) -> Optional[pulumi.Input[str]]:
        """
        A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        """
        return pulumi.get(self, "escalation_message")

    @escalation_message.setter
    def escalation_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escalation_message", value)

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> Optional[pulumi.Input[int]]:
        """
        (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
        value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
        from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
        data during evaluation.
        """
        return pulumi.get(self, "evaluation_delay")

    @evaluation_delay.setter
    def evaluation_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_delay", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
        composite monitor).
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="groupRetentionDuration")
    def group_retention_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
        and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
        Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        """
        return pulumi.get(self, "group_retention_duration")

    @group_retention_duration.setter
    def group_retention_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_retention_duration", value)

    @property
    @pulumi.getter(name="groupbySimpleMonitor")
    def groupby_simple_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
        `false`.
        """
        return pulumi.get(self, "groupby_simple_monitor")

    @groupby_simple_monitor.setter
    def groupby_simple_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "groupby_simple_monitor", value)

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        """
        return pulumi.get(self, "include_tags")

    @include_tags.setter
    def include_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_tags", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use `restricted_roles`.""")
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter(name="monitorThresholdWindows")
    def monitor_threshold_windows(self) -> Optional[pulumi.Input['MonitorMonitorThresholdWindowsArgs']]:
        """
        A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
        required for, anomaly monitors.
        """
        return pulumi.get(self, "monitor_threshold_windows")

    @monitor_threshold_windows.setter
    def monitor_threshold_windows(self, value: Optional[pulumi.Input['MonitorMonitorThresholdWindowsArgs']]):
        pulumi.set(self, "monitor_threshold_windows", value)

    @property
    @pulumi.getter(name="monitorThresholds")
    def monitor_thresholds(self) -> Optional[pulumi.Input['MonitorMonitorThresholdsArgs']]:
        """
        Alert thresholds of the monitor.
        """
        return pulumi.get(self, "monitor_thresholds")

    @monitor_thresholds.setter
    def monitor_thresholds(self, value: Optional[pulumi.Input['MonitorMonitorThresholdsArgs']]):
        pulumi.set(self, "monitor_thresholds", value)

    @property
    @pulumi.getter(name="newGroupDelay")
    def new_group_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
        nonzero value.
        """
        return pulumi.get(self, "new_group_delay")

    @new_group_delay.setter
    def new_group_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_group_delay", value)

    @property
    @pulumi.getter(name="newHostDelay")
    @_utilities.deprecated("""Use `new_group_delay` except when setting `new_host_delay` to zero.""")
    def new_host_delay(self) -> Optional[pulumi.Input[int]]:
        """
        **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
        starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
        and monitors not grouped by host. The only case when this should be used is to override the default and set
        `new_host_delay` to zero for monitors grouped by host.
        """
        return pulumi.get(self, "new_host_delay")

    @new_host_delay.setter
    def new_host_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_host_delay", value)

    @property
    @pulumi.getter(name="noDataTimeframe")
    def no_data_timeframe(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
        timeframe for metric alerts or 2 minutes for service checks.
        """
        return pulumi.get(self, "no_data_timeframe")

    @no_data_timeframe.setter
    def no_data_timeframe(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "no_data_timeframe", value)

    @property
    @pulumi.getter(name="notificationPresetName")
    def notification_preset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Toggles the display of additional content sent in the monitor notification.
        """
        return pulumi.get(self, "notification_preset_name")

    @notification_preset_name.setter
    def notification_preset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_preset_name", value)

    @property
    @pulumi.getter(name="notifyAudit")
    def notify_audit(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        """
        return pulumi.get(self, "notify_audit")

    @notify_audit.setter
    def notify_audit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_audit", value)

    @property
    @pulumi.getter(name="notifyBies")
    def notify_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
        grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
        conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
        in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
        to `[*]` configures the monitor to notify as a simple-alert.
        """
        return pulumi.get(self, "notify_bies")

    @notify_bies.setter
    def notify_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notify_bies", value)

    @property
    @pulumi.getter(name="notifyNoData")
    def notify_no_data(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor will notify when data stops reporting.
        """
        return pulumi.get(self, "notify_no_data")

    @notify_no_data.setter
    def notify_no_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_no_data", value)

    @property
    @pulumi.getter(name="onMissingData")
    def on_missing_data(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
        in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
        evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
        `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
        available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
        `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        """
        return pulumi.get(self, "on_missing_data")

    @on_missing_data.setter
    def on_missing_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_missing_data", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        Integer from 1 (high) to 5 (low) indicating alert severity.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="renotifyInterval")
    def renotify_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
        re-notify if it's not resolved.
        """
        return pulumi.get(self, "renotify_interval")

    @renotify_interval.setter
    def renotify_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renotify_interval", value)

    @property
    @pulumi.getter(name="renotifyOccurrences")
    def renotify_occurrences(self) -> Optional[pulumi.Input[int]]:
        """
        The number of re-notification messages that should be sent on the current status.
        """
        return pulumi.get(self, "renotify_occurrences")

    @renotify_occurrences.setter
    def renotify_occurrences(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renotify_occurrences", value)

    @property
    @pulumi.getter(name="renotifyStatuses")
    def renotify_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of statuses for which re-notification messages should be sent.
        """
        return pulumi.get(self, "renotify_statuses")

    @renotify_statuses.setter
    def renotify_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "renotify_statuses", value)

    @property
    @pulumi.getter(name="requireFullWindow")
    def require_full_window(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
        you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
        `require_full_window` must be false and will be ignored.
        """
        return pulumi.get(self, "require_full_window")

    @require_full_window.setter
    def require_full_window(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_full_window", value)

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
        updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
        identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
        field.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @property
    @pulumi.getter(name="schedulingOptions")
    def scheduling_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]]]:
        """
        Configuration options for scheduling.
        """
        return pulumi.get(self, "scheduling_options")

    @scheduling_options.setter
    def scheduling_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]]]):
        pulumi.set(self, "scheduling_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
        page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeoutH")
    def timeout_h(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
        minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        """
        return pulumi.get(self, "timeout_h")

    @timeout_h.setter
    def timeout_h(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_h", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `false`, skip the validation call done during plan.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input['MonitorVariablesArgs']]:
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input['MonitorVariablesArgs']]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 enable_logs_sample: Optional[pulumi.Input[bool]] = None,
                 enable_samples: Optional[pulumi.Input[bool]] = None,
                 escalation_message: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[int]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 group_retention_duration: Optional[pulumi.Input[str]] = None,
                 groupby_simple_monitor: Optional[pulumi.Input[bool]] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 monitor_threshold_windows: Optional[pulumi.Input['MonitorMonitorThresholdWindowsArgs']] = None,
                 monitor_thresholds: Optional[pulumi.Input['MonitorMonitorThresholdsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_group_delay: Optional[pulumi.Input[int]] = None,
                 new_host_delay: Optional[pulumi.Input[int]] = None,
                 no_data_timeframe: Optional[pulumi.Input[int]] = None,
                 notification_preset_name: Optional[pulumi.Input[str]] = None,
                 notify_audit: Optional[pulumi.Input[bool]] = None,
                 notify_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notify_no_data: Optional[pulumi.Input[bool]] = None,
                 on_missing_data: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 renotify_interval: Optional[pulumi.Input[int]] = None,
                 renotify_occurrences: Optional[pulumi.Input[int]] = None,
                 renotify_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_full_window: Optional[pulumi.Input[bool]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling_options: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout_h: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 variables: Optional[pulumi.Input['MonitorVariablesArgs']] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[bool] enable_logs_sample: A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
               monitors. Defaults to `false`.
        :param pulumi.Input[bool] enable_samples: Whether or not a list of samples which triggered the alert is included. This is only used by CI Test and Pipeline
               monitors.
        :param pulumi.Input[str] escalation_message: A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        :param pulumi.Input[int] evaluation_delay: (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
               value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
               from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
               data during evaluation.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
               composite monitor).
        :param pulumi.Input[str] group_retention_duration: The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
               and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
               Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        :param pulumi.Input[bool] groupby_simple_monitor: Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
               `false`.
        :param pulumi.Input[bool] include_tags: A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        :param pulumi.Input[bool] locked: A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        :param pulumi.Input[str] message: A message to include with notifications for this monitor.
        :param pulumi.Input['MonitorMonitorThresholdWindowsArgs'] monitor_threshold_windows: A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
               required for, anomaly monitors.
        :param pulumi.Input['MonitorMonitorThresholdsArgs'] monitor_thresholds: Alert thresholds of the monitor.
        :param pulumi.Input[str] name: Name of Datadog monitor.
        :param pulumi.Input[int] new_group_delay: The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
               nonzero value.
        :param pulumi.Input[int] new_host_delay: **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
               starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
               and monitors not grouped by host. The only case when this should be used is to override the default and set
               `new_host_delay` to zero for monitors grouped by host.
        :param pulumi.Input[int] no_data_timeframe: The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
               timeframe for metric alerts or 2 minutes for service checks.
        :param pulumi.Input[str] notification_preset_name: Toggles the display of additional content sent in the monitor notification.
        :param pulumi.Input[bool] notify_audit: A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_bies: Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
               grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
               conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
               in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
               to `[*]` configures the monitor to notify as a simple-alert.
        :param pulumi.Input[bool] notify_no_data: A boolean indicating whether this monitor will notify when data stops reporting.
        :param pulumi.Input[str] on_missing_data: Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
               in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
               evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
               `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
               available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
               `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        :param pulumi.Input[str] priority: Integer from 1 (high) to 5 (low) indicating alert severity.
        :param pulumi.Input[int] renotify_interval: The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
               re-notify if it's not resolved.
        :param pulumi.Input[int] renotify_occurrences: The number of re-notification messages that should be sent on the current status.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] renotify_statuses: The types of statuses for which re-notification messages should be sent.
        :param pulumi.Input[bool] require_full_window: A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
               you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
               `require_full_window` must be false and will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
               updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
               identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
               field.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]] scheduling_options: Configuration options for scheduling.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
               page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[int] timeout_h: The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
               minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        :param pulumi.Input[str] type: The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
               Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
               cannot be changed after a monitor is created.
        :param pulumi.Input[bool] validate: If set to `false`, skip the validation call done during plan.
        """
        if enable_logs_sample is not None:
            pulumi.set(__self__, "enable_logs_sample", enable_logs_sample)
        if enable_samples is not None:
            pulumi.set(__self__, "enable_samples", enable_samples)
        if escalation_message is not None:
            pulumi.set(__self__, "escalation_message", escalation_message)
        if evaluation_delay is not None:
            pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if group_retention_duration is not None:
            pulumi.set(__self__, "group_retention_duration", group_retention_duration)
        if groupby_simple_monitor is not None:
            pulumi.set(__self__, "groupby_simple_monitor", groupby_simple_monitor)
        if include_tags is not None:
            pulumi.set(__self__, "include_tags", include_tags)
        if locked is not None:
            warnings.warn("""Use `restricted_roles`.""", DeprecationWarning)
            pulumi.log.warn("""locked is deprecated: Use `restricted_roles`.""")
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if monitor_threshold_windows is not None:
            pulumi.set(__self__, "monitor_threshold_windows", monitor_threshold_windows)
        if monitor_thresholds is not None:
            pulumi.set(__self__, "monitor_thresholds", monitor_thresholds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_group_delay is not None:
            pulumi.set(__self__, "new_group_delay", new_group_delay)
        if new_host_delay is not None:
            warnings.warn("""Use `new_group_delay` except when setting `new_host_delay` to zero.""", DeprecationWarning)
            pulumi.log.warn("""new_host_delay is deprecated: Use `new_group_delay` except when setting `new_host_delay` to zero.""")
        if new_host_delay is not None:
            pulumi.set(__self__, "new_host_delay", new_host_delay)
        if no_data_timeframe is not None:
            pulumi.set(__self__, "no_data_timeframe", no_data_timeframe)
        if notification_preset_name is not None:
            pulumi.set(__self__, "notification_preset_name", notification_preset_name)
        if notify_audit is not None:
            pulumi.set(__self__, "notify_audit", notify_audit)
        if notify_bies is not None:
            pulumi.set(__self__, "notify_bies", notify_bies)
        if notify_no_data is not None:
            pulumi.set(__self__, "notify_no_data", notify_no_data)
        if on_missing_data is not None:
            pulumi.set(__self__, "on_missing_data", on_missing_data)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if renotify_interval is not None:
            pulumi.set(__self__, "renotify_interval", renotify_interval)
        if renotify_occurrences is not None:
            pulumi.set(__self__, "renotify_occurrences", renotify_occurrences)
        if renotify_statuses is not None:
            pulumi.set(__self__, "renotify_statuses", renotify_statuses)
        if require_full_window is not None:
            pulumi.set(__self__, "require_full_window", require_full_window)
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if scheduling_options is not None:
            pulumi.set(__self__, "scheduling_options", scheduling_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout_h is not None:
            pulumi.set(__self__, "timeout_h", timeout_h)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="enableLogsSample")
    def enable_logs_sample(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
        monitors. Defaults to `false`.
        """
        return pulumi.get(self, "enable_logs_sample")

    @enable_logs_sample.setter
    def enable_logs_sample(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logs_sample", value)

    @property
    @pulumi.getter(name="enableSamples")
    def enable_samples(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not a list of samples which triggered the alert is included. This is only used by CI Test and Pipeline
        monitors.
        """
        return pulumi.get(self, "enable_samples")

    @enable_samples.setter
    def enable_samples(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_samples", value)

    @property
    @pulumi.getter(name="escalationMessage")
    def escalation_message(self) -> Optional[pulumi.Input[str]]:
        """
        A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        """
        return pulumi.get(self, "escalation_message")

    @escalation_message.setter
    def escalation_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escalation_message", value)

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> Optional[pulumi.Input[int]]:
        """
        (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
        value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
        from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
        data during evaluation.
        """
        return pulumi.get(self, "evaluation_delay")

    @evaluation_delay.setter
    def evaluation_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_delay", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
        composite monitor).
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="groupRetentionDuration")
    def group_retention_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
        and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
        Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        """
        return pulumi.get(self, "group_retention_duration")

    @group_retention_duration.setter
    def group_retention_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_retention_duration", value)

    @property
    @pulumi.getter(name="groupbySimpleMonitor")
    def groupby_simple_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
        `false`.
        """
        return pulumi.get(self, "groupby_simple_monitor")

    @groupby_simple_monitor.setter
    def groupby_simple_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "groupby_simple_monitor", value)

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        """
        return pulumi.get(self, "include_tags")

    @include_tags.setter
    def include_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_tags", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use `restricted_roles`.""")
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A message to include with notifications for this monitor.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="monitorThresholdWindows")
    def monitor_threshold_windows(self) -> Optional[pulumi.Input['MonitorMonitorThresholdWindowsArgs']]:
        """
        A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
        required for, anomaly monitors.
        """
        return pulumi.get(self, "monitor_threshold_windows")

    @monitor_threshold_windows.setter
    def monitor_threshold_windows(self, value: Optional[pulumi.Input['MonitorMonitorThresholdWindowsArgs']]):
        pulumi.set(self, "monitor_threshold_windows", value)

    @property
    @pulumi.getter(name="monitorThresholds")
    def monitor_thresholds(self) -> Optional[pulumi.Input['MonitorMonitorThresholdsArgs']]:
        """
        Alert thresholds of the monitor.
        """
        return pulumi.get(self, "monitor_thresholds")

    @monitor_thresholds.setter
    def monitor_thresholds(self, value: Optional[pulumi.Input['MonitorMonitorThresholdsArgs']]):
        pulumi.set(self, "monitor_thresholds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Datadog monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newGroupDelay")
    def new_group_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
        nonzero value.
        """
        return pulumi.get(self, "new_group_delay")

    @new_group_delay.setter
    def new_group_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_group_delay", value)

    @property
    @pulumi.getter(name="newHostDelay")
    @_utilities.deprecated("""Use `new_group_delay` except when setting `new_host_delay` to zero.""")
    def new_host_delay(self) -> Optional[pulumi.Input[int]]:
        """
        **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
        starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
        and monitors not grouped by host. The only case when this should be used is to override the default and set
        `new_host_delay` to zero for monitors grouped by host.
        """
        return pulumi.get(self, "new_host_delay")

    @new_host_delay.setter
    def new_host_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_host_delay", value)

    @property
    @pulumi.getter(name="noDataTimeframe")
    def no_data_timeframe(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
        timeframe for metric alerts or 2 minutes for service checks.
        """
        return pulumi.get(self, "no_data_timeframe")

    @no_data_timeframe.setter
    def no_data_timeframe(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "no_data_timeframe", value)

    @property
    @pulumi.getter(name="notificationPresetName")
    def notification_preset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Toggles the display of additional content sent in the monitor notification.
        """
        return pulumi.get(self, "notification_preset_name")

    @notification_preset_name.setter
    def notification_preset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_preset_name", value)

    @property
    @pulumi.getter(name="notifyAudit")
    def notify_audit(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        """
        return pulumi.get(self, "notify_audit")

    @notify_audit.setter
    def notify_audit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_audit", value)

    @property
    @pulumi.getter(name="notifyBies")
    def notify_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
        grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
        conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
        in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
        to `[*]` configures the monitor to notify as a simple-alert.
        """
        return pulumi.get(self, "notify_bies")

    @notify_bies.setter
    def notify_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notify_bies", value)

    @property
    @pulumi.getter(name="notifyNoData")
    def notify_no_data(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor will notify when data stops reporting.
        """
        return pulumi.get(self, "notify_no_data")

    @notify_no_data.setter
    def notify_no_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_no_data", value)

    @property
    @pulumi.getter(name="onMissingData")
    def on_missing_data(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
        in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
        evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
        `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
        available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
        `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        """
        return pulumi.get(self, "on_missing_data")

    @on_missing_data.setter
    def on_missing_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_missing_data", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        Integer from 1 (high) to 5 (low) indicating alert severity.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="renotifyInterval")
    def renotify_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
        re-notify if it's not resolved.
        """
        return pulumi.get(self, "renotify_interval")

    @renotify_interval.setter
    def renotify_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renotify_interval", value)

    @property
    @pulumi.getter(name="renotifyOccurrences")
    def renotify_occurrences(self) -> Optional[pulumi.Input[int]]:
        """
        The number of re-notification messages that should be sent on the current status.
        """
        return pulumi.get(self, "renotify_occurrences")

    @renotify_occurrences.setter
    def renotify_occurrences(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renotify_occurrences", value)

    @property
    @pulumi.getter(name="renotifyStatuses")
    def renotify_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of statuses for which re-notification messages should be sent.
        """
        return pulumi.get(self, "renotify_statuses")

    @renotify_statuses.setter
    def renotify_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "renotify_statuses", value)

    @property
    @pulumi.getter(name="requireFullWindow")
    def require_full_window(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
        you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
        `require_full_window` must be false and will be ignored.
        """
        return pulumi.get(self, "require_full_window")

    @require_full_window.setter
    def require_full_window(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_full_window", value)

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
        updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
        identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
        field.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @property
    @pulumi.getter(name="schedulingOptions")
    def scheduling_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]]]:
        """
        Configuration options for scheduling.
        """
        return pulumi.get(self, "scheduling_options")

    @scheduling_options.setter
    def scheduling_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorSchedulingOptionArgs']]]]):
        pulumi.set(self, "scheduling_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
        page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeoutH")
    def timeout_h(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
        minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        """
        return pulumi.get(self, "timeout_h")

    @timeout_h.setter
    def timeout_h(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_h", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
        Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
        cannot be changed after a monitor is created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `false`, skip the validation call done during plan.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input['MonitorVariablesArgs']]:
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input['MonitorVariablesArgs']]):
        pulumi.set(self, "variables", value)


class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_logs_sample: Optional[pulumi.Input[bool]] = None,
                 escalation_message: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[int]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 group_retention_duration: Optional[pulumi.Input[str]] = None,
                 groupby_simple_monitor: Optional[pulumi.Input[bool]] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 monitor_threshold_windows: Optional[pulumi.Input[pulumi.InputType['MonitorMonitorThresholdWindowsArgs']]] = None,
                 monitor_thresholds: Optional[pulumi.Input[pulumi.InputType['MonitorMonitorThresholdsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_group_delay: Optional[pulumi.Input[int]] = None,
                 new_host_delay: Optional[pulumi.Input[int]] = None,
                 no_data_timeframe: Optional[pulumi.Input[int]] = None,
                 notification_preset_name: Optional[pulumi.Input[str]] = None,
                 notify_audit: Optional[pulumi.Input[bool]] = None,
                 notify_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notify_no_data: Optional[pulumi.Input[bool]] = None,
                 on_missing_data: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 renotify_interval: Optional[pulumi.Input[int]] = None,
                 renotify_occurrences: Optional[pulumi.Input[int]] = None,
                 renotify_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_full_window: Optional[pulumi.Input[bool]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorSchedulingOptionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout_h: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 variables: Optional[pulumi.Input[pulumi.InputType['MonitorVariablesArgs']]] = None,
                 __props__=None):
        """
        Provides a Datadog monitor resource. This can be used to create and manage Datadog monitors.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        foo = datadog.Monitor("foo",
            name="Name for monitor foo",
            type="metric alert",
            message="Monitor triggered. Notify: @hipchat-channel",
            escalation_message="Escalation message @pagerduty",
            query="avg(last_1h):avg:aws.ec2.cpu{environment:foo,host:foo} by {host} > 4",
            monitor_thresholds=datadog.MonitorMonitorThresholdsArgs(
                warning="2",
                critical="4",
            ),
            include_tags=True,
            tags=[
                "foo:bar",
                "team:fooBar",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/monitor:Monitor bytes_received_localhost 2081
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_logs_sample: A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
               monitors. Defaults to `false`.
        :param pulumi.Input[str] escalation_message: A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        :param pulumi.Input[int] evaluation_delay: (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
               value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
               from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
               data during evaluation.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
               composite monitor).
        :param pulumi.Input[str] group_retention_duration: The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
               and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
               Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        :param pulumi.Input[bool] groupby_simple_monitor: Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
               `false`.
        :param pulumi.Input[bool] include_tags: A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        :param pulumi.Input[bool] locked: A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        :param pulumi.Input[str] message: A message to include with notifications for this monitor.
        :param pulumi.Input[pulumi.InputType['MonitorMonitorThresholdWindowsArgs']] monitor_threshold_windows: A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
               required for, anomaly monitors.
        :param pulumi.Input[pulumi.InputType['MonitorMonitorThresholdsArgs']] monitor_thresholds: Alert thresholds of the monitor.
        :param pulumi.Input[str] name: Name of Datadog monitor.
        :param pulumi.Input[int] new_group_delay: The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
               nonzero value.
        :param pulumi.Input[int] new_host_delay: **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
               starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
               and monitors not grouped by host. The only case when this should be used is to override the default and set
               `new_host_delay` to zero for monitors grouped by host.
        :param pulumi.Input[int] no_data_timeframe: The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
               timeframe for metric alerts or 2 minutes for service checks.
        :param pulumi.Input[str] notification_preset_name: Toggles the display of additional content sent in the monitor notification.
        :param pulumi.Input[bool] notify_audit: A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_bies: Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
               grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
               conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
               in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
               to `[*]` configures the monitor to notify as a simple-alert.
        :param pulumi.Input[bool] notify_no_data: A boolean indicating whether this monitor will notify when data stops reporting.
        :param pulumi.Input[str] on_missing_data: Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
               in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
               evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
               `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
               available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
               `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        :param pulumi.Input[str] priority: Integer from 1 (high) to 5 (low) indicating alert severity.
        :param pulumi.Input[int] renotify_interval: The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
               re-notify if it's not resolved.
        :param pulumi.Input[int] renotify_occurrences: The number of re-notification messages that should be sent on the current status.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] renotify_statuses: The types of statuses for which re-notification messages should be sent.
        :param pulumi.Input[bool] require_full_window: A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
               you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
               `require_full_window` must be false and will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
               updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
               identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
               field.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorSchedulingOptionArgs']]]] scheduling_options: Configuration options for scheduling.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
               page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[int] timeout_h: The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
               minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        :param pulumi.Input[str] type: The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
               Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
               cannot be changed after a monitor is created.
        :param pulumi.Input[bool] validate: If set to `false`, skip the validation call done during plan.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog monitor resource. This can be used to create and manage Datadog monitors.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        foo = datadog.Monitor("foo",
            name="Name for monitor foo",
            type="metric alert",
            message="Monitor triggered. Notify: @hipchat-channel",
            escalation_message="Escalation message @pagerduty",
            query="avg(last_1h):avg:aws.ec2.cpu{environment:foo,host:foo} by {host} > 4",
            monitor_thresholds=datadog.MonitorMonitorThresholdsArgs(
                warning="2",
                critical="4",
            ),
            include_tags=True,
            tags=[
                "foo:bar",
                "team:fooBar",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/monitor:Monitor bytes_received_localhost 2081
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_logs_sample: Optional[pulumi.Input[bool]] = None,
                 escalation_message: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[int]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 group_retention_duration: Optional[pulumi.Input[str]] = None,
                 groupby_simple_monitor: Optional[pulumi.Input[bool]] = None,
                 include_tags: Optional[pulumi.Input[bool]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 monitor_threshold_windows: Optional[pulumi.Input[pulumi.InputType['MonitorMonitorThresholdWindowsArgs']]] = None,
                 monitor_thresholds: Optional[pulumi.Input[pulumi.InputType['MonitorMonitorThresholdsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_group_delay: Optional[pulumi.Input[int]] = None,
                 new_host_delay: Optional[pulumi.Input[int]] = None,
                 no_data_timeframe: Optional[pulumi.Input[int]] = None,
                 notification_preset_name: Optional[pulumi.Input[str]] = None,
                 notify_audit: Optional[pulumi.Input[bool]] = None,
                 notify_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notify_no_data: Optional[pulumi.Input[bool]] = None,
                 on_missing_data: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 renotify_interval: Optional[pulumi.Input[int]] = None,
                 renotify_occurrences: Optional[pulumi.Input[int]] = None,
                 renotify_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_full_window: Optional[pulumi.Input[bool]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorSchedulingOptionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout_h: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 variables: Optional[pulumi.Input[pulumi.InputType['MonitorVariablesArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["enable_logs_sample"] = enable_logs_sample
            __props__.__dict__["escalation_message"] = escalation_message
            __props__.__dict__["evaluation_delay"] = evaluation_delay
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["group_retention_duration"] = group_retention_duration
            __props__.__dict__["groupby_simple_monitor"] = groupby_simple_monitor
            __props__.__dict__["include_tags"] = include_tags
            __props__.__dict__["locked"] = locked
            if message is None and not opts.urn:
                raise TypeError("Missing required property 'message'")
            __props__.__dict__["message"] = message
            __props__.__dict__["monitor_threshold_windows"] = monitor_threshold_windows
            __props__.__dict__["monitor_thresholds"] = monitor_thresholds
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["new_group_delay"] = new_group_delay
            __props__.__dict__["new_host_delay"] = new_host_delay
            __props__.__dict__["no_data_timeframe"] = no_data_timeframe
            __props__.__dict__["notification_preset_name"] = notification_preset_name
            __props__.__dict__["notify_audit"] = notify_audit
            __props__.__dict__["notify_bies"] = notify_bies
            __props__.__dict__["notify_no_data"] = notify_no_data
            __props__.__dict__["on_missing_data"] = on_missing_data
            __props__.__dict__["priority"] = priority
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["renotify_interval"] = renotify_interval
            __props__.__dict__["renotify_occurrences"] = renotify_occurrences
            __props__.__dict__["renotify_statuses"] = renotify_statuses
            __props__.__dict__["require_full_window"] = require_full_window
            __props__.__dict__["restricted_roles"] = restricted_roles
            __props__.__dict__["scheduling_options"] = scheduling_options
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout_h"] = timeout_h
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["validate"] = validate
            __props__.__dict__["variables"] = variables
            __props__.__dict__["enable_samples"] = None
        super(Monitor, __self__).__init__(
            'datadog:index/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_logs_sample: Optional[pulumi.Input[bool]] = None,
            enable_samples: Optional[pulumi.Input[bool]] = None,
            escalation_message: Optional[pulumi.Input[str]] = None,
            evaluation_delay: Optional[pulumi.Input[int]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            group_retention_duration: Optional[pulumi.Input[str]] = None,
            groupby_simple_monitor: Optional[pulumi.Input[bool]] = None,
            include_tags: Optional[pulumi.Input[bool]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            message: Optional[pulumi.Input[str]] = None,
            monitor_threshold_windows: Optional[pulumi.Input[pulumi.InputType['MonitorMonitorThresholdWindowsArgs']]] = None,
            monitor_thresholds: Optional[pulumi.Input[pulumi.InputType['MonitorMonitorThresholdsArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_group_delay: Optional[pulumi.Input[int]] = None,
            new_host_delay: Optional[pulumi.Input[int]] = None,
            no_data_timeframe: Optional[pulumi.Input[int]] = None,
            notification_preset_name: Optional[pulumi.Input[str]] = None,
            notify_audit: Optional[pulumi.Input[bool]] = None,
            notify_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            notify_no_data: Optional[pulumi.Input[bool]] = None,
            on_missing_data: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[str]] = None,
            query: Optional[pulumi.Input[str]] = None,
            renotify_interval: Optional[pulumi.Input[int]] = None,
            renotify_occurrences: Optional[pulumi.Input[int]] = None,
            renotify_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            require_full_window: Optional[pulumi.Input[bool]] = None,
            restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scheduling_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorSchedulingOptionArgs']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            timeout_h: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            validate: Optional[pulumi.Input[bool]] = None,
            variables: Optional[pulumi.Input[pulumi.InputType['MonitorVariablesArgs']]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_logs_sample: A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
               monitors. Defaults to `false`.
        :param pulumi.Input[bool] enable_samples: Whether or not a list of samples which triggered the alert is included. This is only used by CI Test and Pipeline
               monitors.
        :param pulumi.Input[str] escalation_message: A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        :param pulumi.Input[int] evaluation_delay: (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
               value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
               from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
               data during evaluation.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
               composite monitor).
        :param pulumi.Input[str] group_retention_duration: The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
               and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
               Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        :param pulumi.Input[bool] groupby_simple_monitor: Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
               `false`.
        :param pulumi.Input[bool] include_tags: A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        :param pulumi.Input[bool] locked: A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        :param pulumi.Input[str] message: A message to include with notifications for this monitor.
        :param pulumi.Input[pulumi.InputType['MonitorMonitorThresholdWindowsArgs']] monitor_threshold_windows: A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
               required for, anomaly monitors.
        :param pulumi.Input[pulumi.InputType['MonitorMonitorThresholdsArgs']] monitor_thresholds: Alert thresholds of the monitor.
        :param pulumi.Input[str] name: Name of Datadog monitor.
        :param pulumi.Input[int] new_group_delay: The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
               nonzero value.
        :param pulumi.Input[int] new_host_delay: **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
               starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
               and monitors not grouped by host. The only case when this should be used is to override the default and set
               `new_host_delay` to zero for monitors grouped by host.
        :param pulumi.Input[int] no_data_timeframe: The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
               timeframe for metric alerts or 2 minutes for service checks.
        :param pulumi.Input[str] notification_preset_name: Toggles the display of additional content sent in the monitor notification.
        :param pulumi.Input[bool] notify_audit: A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_bies: Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
               grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
               conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
               in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
               to `[*]` configures the monitor to notify as a simple-alert.
        :param pulumi.Input[bool] notify_no_data: A boolean indicating whether this monitor will notify when data stops reporting.
        :param pulumi.Input[str] on_missing_data: Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
               in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
               evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
               `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
               available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
               `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        :param pulumi.Input[str] priority: Integer from 1 (high) to 5 (low) indicating alert severity.
        :param pulumi.Input[int] renotify_interval: The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
               re-notify if it's not resolved.
        :param pulumi.Input[int] renotify_occurrences: The number of re-notification messages that should be sent on the current status.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] renotify_statuses: The types of statuses for which re-notification messages should be sent.
        :param pulumi.Input[bool] require_full_window: A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
               you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
               `require_full_window` must be false and will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
               updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
               identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
               field.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorSchedulingOptionArgs']]]] scheduling_options: Configuration options for scheduling.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
               page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[int] timeout_h: The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
               minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        :param pulumi.Input[str] type: The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
               Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
               cannot be changed after a monitor is created.
        :param pulumi.Input[bool] validate: If set to `false`, skip the validation call done during plan.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["enable_logs_sample"] = enable_logs_sample
        __props__.__dict__["enable_samples"] = enable_samples
        __props__.__dict__["escalation_message"] = escalation_message
        __props__.__dict__["evaluation_delay"] = evaluation_delay
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["group_retention_duration"] = group_retention_duration
        __props__.__dict__["groupby_simple_monitor"] = groupby_simple_monitor
        __props__.__dict__["include_tags"] = include_tags
        __props__.__dict__["locked"] = locked
        __props__.__dict__["message"] = message
        __props__.__dict__["monitor_threshold_windows"] = monitor_threshold_windows
        __props__.__dict__["monitor_thresholds"] = monitor_thresholds
        __props__.__dict__["name"] = name
        __props__.__dict__["new_group_delay"] = new_group_delay
        __props__.__dict__["new_host_delay"] = new_host_delay
        __props__.__dict__["no_data_timeframe"] = no_data_timeframe
        __props__.__dict__["notification_preset_name"] = notification_preset_name
        __props__.__dict__["notify_audit"] = notify_audit
        __props__.__dict__["notify_bies"] = notify_bies
        __props__.__dict__["notify_no_data"] = notify_no_data
        __props__.__dict__["on_missing_data"] = on_missing_data
        __props__.__dict__["priority"] = priority
        __props__.__dict__["query"] = query
        __props__.__dict__["renotify_interval"] = renotify_interval
        __props__.__dict__["renotify_occurrences"] = renotify_occurrences
        __props__.__dict__["renotify_statuses"] = renotify_statuses
        __props__.__dict__["require_full_window"] = require_full_window
        __props__.__dict__["restricted_roles"] = restricted_roles
        __props__.__dict__["scheduling_options"] = scheduling_options
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout_h"] = timeout_h
        __props__.__dict__["type"] = type
        __props__.__dict__["validate"] = validate
        __props__.__dict__["variables"] = variables
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableLogsSample")
    def enable_logs_sample(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log
        monitors. Defaults to `false`.
        """
        return pulumi.get(self, "enable_logs_sample")

    @property
    @pulumi.getter(name="enableSamples")
    def enable_samples(self) -> pulumi.Output[bool]:
        """
        Whether or not a list of samples which triggered the alert is included. This is only used by CI Test and Pipeline
        monitors.
        """
        return pulumi.get(self, "enable_samples")

    @property
    @pulumi.getter(name="escalationMessage")
    def escalation_message(self) -> pulumi.Output[Optional[str]]:
        """
        A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
        """
        return pulumi.get(self, "escalation_message")

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> pulumi.Output[int]:
        """
        (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer. For example, if the
        value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data
        from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have
        data during evaluation.
        """
        return pulumi.get(self, "evaluation_delay")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO,
        composite monitor).
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="groupRetentionDuration")
    def group_retention_duration(self) -> pulumi.Output[Optional[str]]:
        """
        The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour,
        and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace
        Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
        """
        return pulumi.get(self, "group_retention_duration")

    @property
    @pulumi.getter(name="groupbySimpleMonitor")
    def groupby_simple_monitor(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to
        `false`.
        """
        return pulumi.get(self, "groupby_simple_monitor")

    @property
    @pulumi.getter(name="includeTags")
    def include_tags(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title.
        """
        return pulumi.get(self, "include_tags")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use `restricted_roles`.""")
    def locked(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[str]:
        """
        A message to include with notifications for this monitor.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="monitorThresholdWindows")
    def monitor_threshold_windows(self) -> pulumi.Output[Optional['outputs.MonitorMonitorThresholdWindows']]:
        """
        A mapping containing `recovery_window` and `trigger_window` values, e.g. `last_15m` . Can only be used for, and are
        required for, anomaly monitors.
        """
        return pulumi.get(self, "monitor_threshold_windows")

    @property
    @pulumi.getter(name="monitorThresholds")
    def monitor_thresholds(self) -> pulumi.Output[Optional['outputs.MonitorMonitorThresholds']]:
        """
        Alert thresholds of the monitor.
        """
        return pulumi.get(self, "monitor_thresholds")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of Datadog monitor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newGroupDelay")
    def new_group_delay(self) -> pulumi.Output[Optional[int]]:
        """
        The time (in seconds) to skip evaluations for new groups. `new_group_delay` overrides `new_host_delay` if it is set to a
        nonzero value.
        """
        return pulumi.get(self, "new_group_delay")

    @property
    @pulumi.getter(name="newHostDelay")
    @_utilities.deprecated("""Use `new_group_delay` except when setting `new_host_delay` to zero.""")
    def new_host_delay(self) -> pulumi.Output[Optional[int]]:
        """
        **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before
        starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors
        and monitors not grouped by host. The only case when this should be used is to override the default and set
        `new_host_delay` to zero for monitors grouped by host.
        """
        return pulumi.get(self, "new_host_delay")

    @property
    @pulumi.getter(name="noDataTimeframe")
    def no_data_timeframe(self) -> pulumi.Output[Optional[int]]:
        """
        The number of minutes before a monitor will notify when data stops reporting. We recommend at least 2x the monitor
        timeframe for metric alerts or 2 minutes for service checks.
        """
        return pulumi.get(self, "no_data_timeframe")

    @property
    @pulumi.getter(name="notificationPresetName")
    def notification_preset_name(self) -> pulumi.Output[Optional[str]]:
        """
        Toggles the display of additional content sent in the monitor notification.
        """
        return pulumi.get(self, "notification_preset_name")

    @property
    @pulumi.getter(name="notifyAudit")
    def notify_audit(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
        """
        return pulumi.get(self, "notify_audit")

    @property
    @pulumi.getter(name="notifyBies")
    def notify_bies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor
        grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert
        conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags
        in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by`
        to `[*]` configures the monitor to notify as a simple-alert.
        """
        return pulumi.get(self, "notify_bies")

    @property
    @pulumi.getter(name="notifyNoData")
    def notify_no_data(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether this monitor will notify when data stops reporting.
        """
        return pulumi.get(self, "notify_no_data")

    @property
    @pulumi.getter(name="onMissingData")
    def on_missing_data(self) -> pulumi.Output[Optional[str]]:
        """
        Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results
        in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor
        evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than
        `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only
        available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are:
        `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
        """
        return pulumi.get(self, "on_missing_data")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[str]]:
        """
        Integer from 1 (high) to 5 (low) indicating alert severity.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[str]:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="renotifyInterval")
    def renotify_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The number of minutes after the last notification before a monitor will re-notify on the current status. It will only
        re-notify if it's not resolved.
        """
        return pulumi.get(self, "renotify_interval")

    @property
    @pulumi.getter(name="renotifyOccurrences")
    def renotify_occurrences(self) -> pulumi.Output[Optional[int]]:
        """
        The number of re-notification messages that should be sent on the current status.
        """
        return pulumi.get(self, "renotify_occurrences")

    @property
    @pulumi.getter(name="renotifyStatuses")
    def renotify_statuses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The types of statuses for which re-notification messages should be sent.
        """
        return pulumi.get(self, "renotify_statuses")

    @property
    @pulumi.getter(name="requireFullWindow")
    def require_full_window(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether this monitor needs a full window of data before it's evaluated. Datadog strongly recommends
        you set this to `false` for sparse metrics, otherwise some evaluations may be skipped. If there's a custom_schedule set,
        `require_full_window` must be false and will be ignored.
        """
        return pulumi.get(self, "require_full_window")

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any
        updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique
        identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id`
        field.
        """
        return pulumi.get(self, "restricted_roles")

    @property
    @pulumi.getter(name="schedulingOptions")
    def scheduling_options(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorSchedulingOption']]]:
        """
        Configuration options for scheduling.
        """
        return pulumi.get(self, "scheduling_options")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors
        page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeoutH")
    def timeout_h(self) -> pulumi.Output[Optional[int]]:
        """
        The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The
        minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
        """
        return pulumi.get(self, "timeout_h")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the
        Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type
        cannot be changed after a monitor is created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `false`, skip the validation call done during plan.
        """
        return pulumi.get(self, "validate")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional['outputs.MonitorVariables']]:
        return pulumi.get(self, "variables")

