# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MonitorJsonArgs', 'MonitorJson']

@pulumi.input_type
class MonitorJsonArgs:
    def __init__(__self__, *,
                 monitor: pulumi.Input[str],
                 url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MonitorJson resource.
        :param pulumi.Input[str] monitor: The JSON formatted definition of the monitor.
        :param pulumi.Input[str] url: The URL of the monitor.
        """
        pulumi.set(__self__, "monitor", monitor)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Input[str]:
        """
        The JSON formatted definition of the monitor.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the monitor.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _MonitorJsonState:
    def __init__(__self__, *,
                 monitor: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MonitorJson resources.
        :param pulumi.Input[str] monitor: The JSON formatted definition of the monitor.
        :param pulumi.Input[str] url: The URL of the monitor.
        """
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON formatted definition of the monitor.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the monitor.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class MonitorJson(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog monitor JSON resource. This can be used to create and manage Datadog monitors using the JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        monitor_json = datadog.MonitorJson("monitor_json", monitor=\"\"\"{
            "name": "Example monitor - service check",
            "type": "service check",
            "query": "\\"ntp.in_sync\\".by(\\"*\\").last(2).count_by_status()",
            "message": "Change the message triggers if any host's clock goes out of sync with the time given by NTP. The offset threshold is configured in the Agent's 'ntp.yaml' file.\\n\\nSee [Troubleshooting NTP Offset issues](https://docs.datadoghq.com/agent/troubleshooting/ntp for more details on cause and resolution.",
            "tags": [],
            "multi": true,
        \\x09"restricted_roles": null,
            "options": {
                "include_tags": true,
                "new_host_delay": 150,
                "notify_audit": false,
                "notify_no_data": false,
                "thresholds": {
                    "warning": 1,
                    "ok": 1,
                    "critical": 1
                }
            },
            "priority": null,
            "classification": "custom"
        }
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/monitorJson:MonitorJson monitor_json 123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] monitor: The JSON formatted definition of the monitor.
        :param pulumi.Input[str] url: The URL of the monitor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorJsonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog monitor JSON resource. This can be used to create and manage Datadog monitors using the JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        monitor_json = datadog.MonitorJson("monitor_json", monitor=\"\"\"{
            "name": "Example monitor - service check",
            "type": "service check",
            "query": "\\"ntp.in_sync\\".by(\\"*\\").last(2).count_by_status()",
            "message": "Change the message triggers if any host's clock goes out of sync with the time given by NTP. The offset threshold is configured in the Agent's 'ntp.yaml' file.\\n\\nSee [Troubleshooting NTP Offset issues](https://docs.datadoghq.com/agent/troubleshooting/ntp for more details on cause and resolution.",
            "tags": [],
            "multi": true,
        \\x09"restricted_roles": null,
            "options": {
                "include_tags": true,
                "new_host_delay": 150,
                "notify_audit": false,
                "notify_no_data": false,
                "thresholds": {
                    "warning": 1,
                    "ok": 1,
                    "critical": 1
                }
            },
            "priority": null,
            "classification": "custom"
        }
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/monitorJson:MonitorJson monitor_json 123456
        ```

        :param str resource_name: The name of the resource.
        :param MonitorJsonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorJsonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorJsonArgs.__new__(MonitorJsonArgs)

            if monitor is None and not opts.urn:
                raise TypeError("Missing required property 'monitor'")
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["url"] = url
        super(MonitorJson, __self__).__init__(
            'datadog:index/monitorJson:MonitorJson',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            monitor: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'MonitorJson':
        """
        Get an existing MonitorJson resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] monitor: The JSON formatted definition of the monitor.
        :param pulumi.Input[str] url: The URL of the monitor.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorJsonState.__new__(_MonitorJsonState)

        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["url"] = url
        return MonitorJson(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[str]:
        """
        The JSON formatted definition of the monitor.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL of the monitor.
        """
        return pulumi.get(self, "url")

