# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_url: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 http_client_retry_backoff_base: Optional[pulumi.Input[int]] = None,
                 http_client_retry_backoff_multiplier: Optional[pulumi.Input[int]] = None,
                 http_client_retry_enabled: Optional[pulumi.Input[str]] = None,
                 http_client_retry_max_retries: Optional[pulumi.Input[int]] = None,
                 http_client_retry_timeout: Optional[pulumi.Input[int]] = None,
                 validate: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] api_key: (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        :param pulumi.Input[str] api_url: The API URL. This can also be set via the DD_HOST environment variable. Note that this URL must not end with the `/api/`
               path. For example, `https://api.datadoghq.com/` is a correct value, while `https://api.datadoghq.com/api/` is not. And
               if you're working with "EU" version of Datadog, use `https://api.datadoghq.eu/`. Other Datadog region examples:
               `https://api.us5.datadoghq.com/`, `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See
               https://docs.datadoghq.com/getting_started/site/ for all available regions.
        :param pulumi.Input[str] app_key: (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        :param pulumi.Input[int] http_client_retry_backoff_base: The HTTP request retry back off base. Defaults to 2.
        :param pulumi.Input[int] http_client_retry_backoff_multiplier: The HTTP request retry back off multiplier. Defaults to 2.
        :param pulumi.Input[str] http_client_retry_enabled: Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        :param pulumi.Input[int] http_client_retry_max_retries: The HTTP request maximum retry number. Defaults to 3.
        :param pulumi.Input[int] http_client_retry_timeout: The HTTP request retry timeout period. Defaults to 60 seconds.
        :param pulumi.Input[str] validate: Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
               is true. When false, api_key won't be checked.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if http_client_retry_backoff_base is not None:
            pulumi.set(__self__, "http_client_retry_backoff_base", http_client_retry_backoff_base)
        if http_client_retry_backoff_multiplier is not None:
            pulumi.set(__self__, "http_client_retry_backoff_multiplier", http_client_retry_backoff_multiplier)
        if http_client_retry_enabled is not None:
            pulumi.set(__self__, "http_client_retry_enabled", http_client_retry_enabled)
        if http_client_retry_max_retries is not None:
            pulumi.set(__self__, "http_client_retry_max_retries", http_client_retry_max_retries)
        if http_client_retry_timeout is not None:
            pulumi.set(__self__, "http_client_retry_timeout", http_client_retry_timeout)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[str]]:
        """
        The API URL. This can also be set via the DD_HOST environment variable. Note that this URL must not end with the `/api/`
        path. For example, `https://api.datadoghq.com/` is a correct value, while `https://api.datadoghq.com/api/` is not. And
        if you're working with "EU" version of Datadog, use `https://api.datadoghq.eu/`. Other Datadog region examples:
        `https://api.us5.datadoghq.com/`, `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See
        https://docs.datadoghq.com/getting_started/site/ for all available regions.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_url", value)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="httpClientRetryBackoffBase")
    def http_client_retry_backoff_base(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP request retry back off base. Defaults to 2.
        """
        return pulumi.get(self, "http_client_retry_backoff_base")

    @http_client_retry_backoff_base.setter
    def http_client_retry_backoff_base(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_client_retry_backoff_base", value)

    @property
    @pulumi.getter(name="httpClientRetryBackoffMultiplier")
    def http_client_retry_backoff_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP request retry back off multiplier. Defaults to 2.
        """
        return pulumi.get(self, "http_client_retry_backoff_multiplier")

    @http_client_retry_backoff_multiplier.setter
    def http_client_retry_backoff_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_client_retry_backoff_multiplier", value)

    @property
    @pulumi.getter(name="httpClientRetryEnabled")
    def http_client_retry_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        """
        return pulumi.get(self, "http_client_retry_enabled")

    @http_client_retry_enabled.setter
    def http_client_retry_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_client_retry_enabled", value)

    @property
    @pulumi.getter(name="httpClientRetryMaxRetries")
    def http_client_retry_max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP request maximum retry number. Defaults to 3.
        """
        return pulumi.get(self, "http_client_retry_max_retries")

    @http_client_retry_max_retries.setter
    def http_client_retry_max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_client_retry_max_retries", value)

    @property
    @pulumi.getter(name="httpClientRetryTimeout")
    def http_client_retry_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP request retry timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "http_client_retry_timeout")

    @http_client_retry_timeout.setter
    def http_client_retry_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_client_retry_timeout", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[str]]:
        """
        Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
        is true. When false, api_key won't be checked.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validate", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_url: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 http_client_retry_backoff_base: Optional[pulumi.Input[int]] = None,
                 http_client_retry_backoff_multiplier: Optional[pulumi.Input[int]] = None,
                 http_client_retry_enabled: Optional[pulumi.Input[str]] = None,
                 http_client_retry_max_retries: Optional[pulumi.Input[int]] = None,
                 http_client_retry_timeout: Optional[pulumi.Input[int]] = None,
                 validate: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the datadog package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        :param pulumi.Input[str] api_url: The API URL. This can also be set via the DD_HOST environment variable. Note that this URL must not end with the `/api/`
               path. For example, `https://api.datadoghq.com/` is a correct value, while `https://api.datadoghq.com/api/` is not. And
               if you're working with "EU" version of Datadog, use `https://api.datadoghq.eu/`. Other Datadog region examples:
               `https://api.us5.datadoghq.com/`, `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See
               https://docs.datadoghq.com/getting_started/site/ for all available regions.
        :param pulumi.Input[str] app_key: (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        :param pulumi.Input[int] http_client_retry_backoff_base: The HTTP request retry back off base. Defaults to 2.
        :param pulumi.Input[int] http_client_retry_backoff_multiplier: The HTTP request retry back off multiplier. Defaults to 2.
        :param pulumi.Input[str] http_client_retry_enabled: Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        :param pulumi.Input[int] http_client_retry_max_retries: The HTTP request maximum retry number. Defaults to 3.
        :param pulumi.Input[int] http_client_retry_timeout: The HTTP request retry timeout period. Defaults to 60 seconds.
        :param pulumi.Input[str] validate: Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
               is true. When false, api_key won't be checked.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the datadog package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_url: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 http_client_retry_backoff_base: Optional[pulumi.Input[int]] = None,
                 http_client_retry_backoff_multiplier: Optional[pulumi.Input[int]] = None,
                 http_client_retry_enabled: Optional[pulumi.Input[str]] = None,
                 http_client_retry_max_retries: Optional[pulumi.Input[int]] = None,
                 http_client_retry_timeout: Optional[pulumi.Input[int]] = None,
                 validate: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["api_url"] = api_url
            __props__.__dict__["app_key"] = None if app_key is None else pulumi.Output.secret(app_key)
            __props__.__dict__["http_client_retry_backoff_base"] = pulumi.Output.from_input(http_client_retry_backoff_base).apply(pulumi.runtime.to_json) if http_client_retry_backoff_base is not None else None
            __props__.__dict__["http_client_retry_backoff_multiplier"] = pulumi.Output.from_input(http_client_retry_backoff_multiplier).apply(pulumi.runtime.to_json) if http_client_retry_backoff_multiplier is not None else None
            __props__.__dict__["http_client_retry_enabled"] = http_client_retry_enabled
            __props__.__dict__["http_client_retry_max_retries"] = pulumi.Output.from_input(http_client_retry_max_retries).apply(pulumi.runtime.to_json) if http_client_retry_max_retries is not None else None
            __props__.__dict__["http_client_retry_timeout"] = pulumi.Output.from_input(http_client_retry_timeout).apply(pulumi.runtime.to_json) if http_client_retry_timeout is not None else None
            __props__.__dict__["validate"] = validate
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "appKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'datadog',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[str]]:
        """
        (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[Optional[str]]:
        """
        The API URL. This can also be set via the DD_HOST environment variable. Note that this URL must not end with the `/api/`
        path. For example, `https://api.datadoghq.com/` is a correct value, while `https://api.datadoghq.com/api/` is not. And
        if you're working with "EU" version of Datadog, use `https://api.datadoghq.eu/`. Other Datadog region examples:
        `https://api.us5.datadoghq.com/`, `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See
        https://docs.datadoghq.com/getting_started/site/ for all available regions.
        """
        return pulumi.get(self, "api_url")

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Output[Optional[str]]:
        """
        (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        """
        return pulumi.get(self, "app_key")

    @property
    @pulumi.getter(name="httpClientRetryEnabled")
    def http_client_retry_enabled(self) -> pulumi.Output[Optional[str]]:
        """
        Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        """
        return pulumi.get(self, "http_client_retry_enabled")

    @property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[str]]:
        """
        Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
        is true. When false, api_key won't be checked.
        """
        return pulumi.get(self, "validate")

