# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RestrictionPolicyArgs', 'RestrictionPolicy']

@pulumi.input_type
class RestrictionPolicyArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionPolicyBindingArgs']]]] = None):
        """
        The set of arguments for constructing a RestrictionPolicy resource.
        :param pulumi.Input[str] resource_id: Identifier for the resource, formatted as resource*type:resource*id.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        Identifier for the resource, formatted as resource*type:resource*id.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionPolicyBindingArgs']]]]:
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionPolicyBindingArgs']]]]):
        pulumi.set(self, "bindings", value)


@pulumi.input_type
class _RestrictionPolicyState:
    def __init__(__self__, *,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionPolicyBindingArgs']]]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RestrictionPolicy resources.
        :param pulumi.Input[str] resource_id: Identifier for the resource, formatted as resource*type:resource*id.
        """
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionPolicyBindingArgs']]]]:
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionPolicyBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the resource, formatted as resource*type:resource*id.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


class RestrictionPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RestrictionPolicyBindingArgs']]]]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog RestrictionPolicy resource. This can be used to create and manage Datadog restriction policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new restriction_policy resource
        foo = datadog.RestrictionPolicy("foo",
            resource_id="security-rule:abc-def-ghi",
            bindings=[
                datadog.RestrictionPolicyBindingArgs(
                    principals=["role:00000000-0000-1111-0000-000000000000"],
                    relation="editor",
                ),
                datadog.RestrictionPolicyBindingArgs(
                    principals=["org:10000000-0000-1111-0000-000000000000"],
                    relation="viewer",
                ),
            ])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/restrictionPolicy:RestrictionPolicy new_list "<policy_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_id: Identifier for the resource, formatted as resource*type:resource*id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestrictionPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog RestrictionPolicy resource. This can be used to create and manage Datadog restriction policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new restriction_policy resource
        foo = datadog.RestrictionPolicy("foo",
            resource_id="security-rule:abc-def-ghi",
            bindings=[
                datadog.RestrictionPolicyBindingArgs(
                    principals=["role:00000000-0000-1111-0000-000000000000"],
                    relation="editor",
                ),
                datadog.RestrictionPolicyBindingArgs(
                    principals=["org:10000000-0000-1111-0000-000000000000"],
                    relation="viewer",
                ),
            ])
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/restrictionPolicy:RestrictionPolicy new_list "<policy_id>"
        ```

        :param str resource_name: The name of the resource.
        :param RestrictionPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestrictionPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RestrictionPolicyBindingArgs']]]]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestrictionPolicyArgs.__new__(RestrictionPolicyArgs)

            __props__.__dict__["bindings"] = bindings
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
        super(RestrictionPolicy, __self__).__init__(
            'datadog:index/restrictionPolicy:RestrictionPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bindings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RestrictionPolicyBindingArgs']]]]] = None,
            resource_id: Optional[pulumi.Input[str]] = None) -> 'RestrictionPolicy':
        """
        Get an existing RestrictionPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_id: Identifier for the resource, formatted as resource*type:resource*id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestrictionPolicyState.__new__(_RestrictionPolicyState)

        __props__.__dict__["bindings"] = bindings
        __props__.__dict__["resource_id"] = resource_id
        return RestrictionPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bindings(self) -> pulumi.Output[Optional[Sequence['outputs.RestrictionPolicyBinding']]]:
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        Identifier for the resource, formatted as resource*type:resource*id.
        """
        return pulumi.get(self, "resource_id")

