# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityMonitoringDefaultRuleArgs', 'SecurityMonitoringDefaultRule']

@pulumi.input_type
class SecurityMonitoringDefaultRuleArgs:
    def __init__(__self__, *,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]] = None,
                 options: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']] = None):
        """
        The set of arguments for constructing a SecurityMonitoringDefaultRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs'] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]:
        """
        Cases of the rule, this is used to update notifications.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Custom tags for generated signals.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]:
        """
        Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class _SecurityMonitoringDefaultRuleState:
    def __init__(__self__, *,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]] = None,
                 options: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityMonitoringDefaultRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs'] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        :param pulumi.Input[str] type: The rule type.
        """
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]:
        """
        Cases of the rule, this is used to update notifications.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Custom tags for generated signals.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]:
        """
        Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The rule type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class SecurityMonitoringDefaultRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleCaseArgs']]]]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleFilterArgs']]]]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleOptionsArgs']]] = None,
                 __props__=None):
        """
        Provides a Datadog Security Monitoring Rule API resource for default rules. It can only be imported, you can't create a default rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        adefaultrule = datadog.SecurityMonitoringDefaultRule("adefaultrule",
            enabled=True,
            cases=[datadog.SecurityMonitoringDefaultRuleCaseArgs(
                status="high",
                notifications=["@me"],
            )])
        ```

        ## Import

        Default rules need to be imported using their ID before applying.

        resource "datadog_security_monitoring_default_rule" "adefaultrule" {

        }

        ```sh
        $ pulumi import datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule adefaultrule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleCaseArgs']]]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleFilterArgs']]]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleOptionsArgs']] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityMonitoringDefaultRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Security Monitoring Rule API resource for default rules. It can only be imported, you can't create a default rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        adefaultrule = datadog.SecurityMonitoringDefaultRule("adefaultrule",
            enabled=True,
            cases=[datadog.SecurityMonitoringDefaultRuleCaseArgs(
                status="high",
                notifications=["@me"],
            )])
        ```

        ## Import

        Default rules need to be imported using their ID before applying.

        resource "datadog_security_monitoring_default_rule" "adefaultrule" {

        }

        ```sh
        $ pulumi import datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule adefaultrule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param SecurityMonitoringDefaultRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityMonitoringDefaultRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleCaseArgs']]]]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleFilterArgs']]]]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleOptionsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityMonitoringDefaultRuleArgs.__new__(SecurityMonitoringDefaultRuleArgs)

            __props__.__dict__["cases"] = cases
            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filters"] = filters
            __props__.__dict__["options"] = options
            __props__.__dict__["type"] = None
        super(SecurityMonitoringDefaultRule, __self__).__init__(
            'datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleCaseArgs']]]]] = None,
            custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleFilterArgs']]]]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleOptionsArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'SecurityMonitoringDefaultRule':
        """
        Get an existing SecurityMonitoringDefaultRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleCaseArgs']]]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleFilterArgs']]]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input[pulumi.InputType['SecurityMonitoringDefaultRuleOptionsArgs']] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        :param pulumi.Input[str] type: The rule type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityMonitoringDefaultRuleState.__new__(_SecurityMonitoringDefaultRuleState)

        __props__.__dict__["cases"] = cases
        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filters"] = filters
        __props__.__dict__["options"] = options
        __props__.__dict__["type"] = type
        return SecurityMonitoringDefaultRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cases(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringDefaultRuleCase']]]:
        """
        Cases of the rule, this is used to update notifications.
        """
        return pulumi.get(self, "cases")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Custom tags for generated signals.
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable the rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringDefaultRuleFilter']]]:
        """
        Additional queries to filter matched events before they are processed.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.SecurityMonitoringDefaultRuleOptions']]:
        """
        Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The rule type.
        """
        return pulumi.get(self, "type")

