# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityMonitoringRuleArgs', 'SecurityMonitoringRule']

@pulumi.input_type
class SecurityMonitoringRuleArgs:
    def __init__(__self__, *,
                 message: pulumi.Input[str],
                 name: pulumi.Input[str],
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]]] = None,
                 has_extended_title: Optional[pulumi.Input[bool]] = None,
                 options: Optional[pulumi.Input['SecurityMonitoringRuleOptionsArgs']] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]]] = None,
                 signal_queries: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 third_party_cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SecurityMonitoringRule resource.
        :param pulumi.Input[str] message: Message for generated signals.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]] cases: Cases for generating signals.
        :param pulumi.Input[bool] enabled: Whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        :param pulumi.Input[bool] has_extended_title: Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        :param pulumi.Input['SecurityMonitoringRuleOptionsArgs'] options: Options on rules.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]] queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]] signal_queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for generated signals.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]] third_party_cases: Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        :param pulumi.Input[str] type: The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        :param pulumi.Input[bool] validate: Whether or not to validate the Rule.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if has_extended_title is not None:
            pulumi.set(__self__, "has_extended_title", has_extended_title)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if signal_queries is not None:
            pulumi.set(__self__, "signal_queries", signal_queries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if third_party_cases is not None:
            pulumi.set(__self__, "third_party_cases", third_party_cases)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[str]:
        """
        Message for generated signals.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]]]:
        """
        Cases for generating signals.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="hasExtendedTitle")
    def has_extended_title(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        """
        return pulumi.get(self, "has_extended_title")

    @has_extended_title.setter
    def has_extended_title(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_extended_title", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SecurityMonitoringRuleOptionsArgs']]:
        """
        Options on rules.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SecurityMonitoringRuleOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="signalQueries")
    def signal_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "signal_queries")

    @signal_queries.setter
    def signal_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]]]):
        pulumi.set(self, "signal_queries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for generated signals.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thirdPartyCases")
    def third_party_cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]]]:
        """
        Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        """
        return pulumi.get(self, "third_party_cases")

    @third_party_cases.setter
    def third_party_cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]]]):
        pulumi.set(self, "third_party_cases", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to validate the Rule.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _SecurityMonitoringRuleState:
    def __init__(__self__, *,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]]] = None,
                 has_extended_title: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['SecurityMonitoringRuleOptionsArgs']] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]]] = None,
                 signal_queries: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 third_party_cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SecurityMonitoringRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]] cases: Cases for generating signals.
        :param pulumi.Input[bool] enabled: Whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        :param pulumi.Input[bool] has_extended_title: Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        :param pulumi.Input[str] message: Message for generated signals.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input['SecurityMonitoringRuleOptionsArgs'] options: Options on rules.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]] queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]] signal_queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for generated signals.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]] third_party_cases: Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        :param pulumi.Input[str] type: The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        :param pulumi.Input[bool] validate: Whether or not to validate the Rule.
        """
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if has_extended_title is not None:
            pulumi.set(__self__, "has_extended_title", has_extended_title)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if signal_queries is not None:
            pulumi.set(__self__, "signal_queries", signal_queries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if third_party_cases is not None:
            pulumi.set(__self__, "third_party_cases", third_party_cases)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]]]:
        """
        Cases for generating signals.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="hasExtendedTitle")
    def has_extended_title(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        """
        return pulumi.get(self, "has_extended_title")

    @has_extended_title.setter
    def has_extended_title(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_extended_title", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Message for generated signals.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SecurityMonitoringRuleOptionsArgs']]:
        """
        Options on rules.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SecurityMonitoringRuleOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="signalQueries")
    def signal_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "signal_queries")

    @signal_queries.setter
    def signal_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleSignalQueryArgs']]]]):
        pulumi.set(self, "signal_queries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for generated signals.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thirdPartyCases")
    def third_party_cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]]]:
        """
        Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        """
        return pulumi.get(self, "third_party_cases")

    @third_party_cases.setter
    def third_party_cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringRuleThirdPartyCaseArgs']]]]):
        pulumi.set(self, "third_party_cases", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to validate the Rule.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)


class SecurityMonitoringRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleCaseArgs']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleFilterArgs']]]]] = None,
                 has_extended_title: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleOptionsArgs']]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleQueryArgs']]]]] = None,
                 signal_queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleSignalQueryArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 third_party_cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleThirdPartyCaseArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a Datadog Security Monitoring Rule API resource. This can be used to create and manage Datadog security monitoring rules. To change settings for a default rule use `datadog_security_default_rule` instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        myrule = datadog.SecurityMonitoringRule("myrule",
            name="My rule",
            message="The rule has triggered.",
            enabled=True,
            queries=[
                datadog.SecurityMonitoringRuleQueryArgs(
                    name="errors",
                    query="status:error",
                    aggregation="count",
                    group_by_fields=["host"],
                ),
                datadog.SecurityMonitoringRuleQueryArgs(
                    name="warnings",
                    query="status:warning",
                    aggregation="count",
                    group_by_fields=["host"],
                ),
            ],
            cases=[datadog.SecurityMonitoringRuleCaseArgs(
                status="high",
                condition="errors > 3 && warnings > 10",
                notifications=["@user"],
            )],
            options=datadog.SecurityMonitoringRuleOptionsArgs(
                evaluation_window=300,
                keep_alive=600,
                max_signal_duration=900,
            ),
            tags=["type:dos"])
        ```

        ## Import

        Security monitoring rules can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/securityMonitoringRule:SecurityMonitoringRule my_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleCaseArgs']]]] cases: Cases for generating signals.
        :param pulumi.Input[bool] enabled: Whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleFilterArgs']]]] filters: Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        :param pulumi.Input[bool] has_extended_title: Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        :param pulumi.Input[str] message: Message for generated signals.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[pulumi.InputType['SecurityMonitoringRuleOptionsArgs']] options: Options on rules.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleQueryArgs']]]] queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleSignalQueryArgs']]]] signal_queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for generated signals.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleThirdPartyCaseArgs']]]] third_party_cases: Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        :param pulumi.Input[str] type: The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        :param pulumi.Input[bool] validate: Whether or not to validate the Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityMonitoringRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Security Monitoring Rule API resource. This can be used to create and manage Datadog security monitoring rules. To change settings for a default rule use `datadog_security_default_rule` instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        myrule = datadog.SecurityMonitoringRule("myrule",
            name="My rule",
            message="The rule has triggered.",
            enabled=True,
            queries=[
                datadog.SecurityMonitoringRuleQueryArgs(
                    name="errors",
                    query="status:error",
                    aggregation="count",
                    group_by_fields=["host"],
                ),
                datadog.SecurityMonitoringRuleQueryArgs(
                    name="warnings",
                    query="status:warning",
                    aggregation="count",
                    group_by_fields=["host"],
                ),
            ],
            cases=[datadog.SecurityMonitoringRuleCaseArgs(
                status="high",
                condition="errors > 3 && warnings > 10",
                notifications=["@user"],
            )],
            options=datadog.SecurityMonitoringRuleOptionsArgs(
                evaluation_window=300,
                keep_alive=600,
                max_signal_duration=900,
            ),
            tags=["type:dos"])
        ```

        ## Import

        Security monitoring rules can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/securityMonitoringRule:SecurityMonitoringRule my_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param SecurityMonitoringRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityMonitoringRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleCaseArgs']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleFilterArgs']]]]] = None,
                 has_extended_title: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleOptionsArgs']]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleQueryArgs']]]]] = None,
                 signal_queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleSignalQueryArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 third_party_cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleThirdPartyCaseArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityMonitoringRuleArgs.__new__(SecurityMonitoringRuleArgs)

            __props__.__dict__["cases"] = cases
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filters"] = filters
            __props__.__dict__["has_extended_title"] = has_extended_title
            if message is None and not opts.urn:
                raise TypeError("Missing required property 'message'")
            __props__.__dict__["message"] = message
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["queries"] = queries
            __props__.__dict__["signal_queries"] = signal_queries
            __props__.__dict__["tags"] = tags
            __props__.__dict__["third_party_cases"] = third_party_cases
            __props__.__dict__["type"] = type
            __props__.__dict__["validate"] = validate
        super(SecurityMonitoringRule, __self__).__init__(
            'datadog:index/securityMonitoringRule:SecurityMonitoringRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleCaseArgs']]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleFilterArgs']]]]] = None,
            has_extended_title: Optional[pulumi.Input[bool]] = None,
            message: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleOptionsArgs']]] = None,
            queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleQueryArgs']]]]] = None,
            signal_queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleSignalQueryArgs']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            third_party_cases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleThirdPartyCaseArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            validate: Optional[pulumi.Input[bool]] = None) -> 'SecurityMonitoringRule':
        """
        Get an existing SecurityMonitoringRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleCaseArgs']]]] cases: Cases for generating signals.
        :param pulumi.Input[bool] enabled: Whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleFilterArgs']]]] filters: Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        :param pulumi.Input[bool] has_extended_title: Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        :param pulumi.Input[str] message: Message for generated signals.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[pulumi.InputType['SecurityMonitoringRuleOptionsArgs']] options: Options on rules.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleQueryArgs']]]] queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleSignalQueryArgs']]]] signal_queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for generated signals.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityMonitoringRuleThirdPartyCaseArgs']]]] third_party_cases: Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        :param pulumi.Input[str] type: The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        :param pulumi.Input[bool] validate: Whether or not to validate the Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityMonitoringRuleState.__new__(_SecurityMonitoringRuleState)

        __props__.__dict__["cases"] = cases
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filters"] = filters
        __props__.__dict__["has_extended_title"] = has_extended_title
        __props__.__dict__["message"] = message
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["queries"] = queries
        __props__.__dict__["signal_queries"] = signal_queries
        __props__.__dict__["tags"] = tags
        __props__.__dict__["third_party_cases"] = third_party_cases
        __props__.__dict__["type"] = type
        __props__.__dict__["validate"] = validate
        return SecurityMonitoringRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cases(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringRuleCase']]]:
        """
        Cases for generating signals.
        """
        return pulumi.get(self, "cases")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringRuleFilter']]]:
        """
        Additional queries to filter matched events before they are processed. **Note**: This field is deprecated for log detection, signal correlation, and workload security rules.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="hasExtendedTitle")
    def has_extended_title(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the notifications include the triggering group-by values in their title. Defaults to `false`.
        """
        return pulumi.get(self, "has_extended_title")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[str]:
        """
        Message for generated signals.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.SecurityMonitoringRuleOptions']]:
        """
        Options on rules.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringRuleQuery']]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter(name="signalQueries")
    def signal_queries(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringRuleSignalQuery']]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "signal_queries")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags for generated signals.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thirdPartyCases")
    def third_party_cases(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringRuleThirdPartyCase']]]:
        """
        Cases for generating signals for third-party rules. Only required and accepted for third-party rules
        """
        return pulumi.get(self, "third_party_cases")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The rule type. Valid values are `application_security`, `log_detection`, `workload_security`, `signal_correlation`. Defaults to `"log_detection"`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to validate the Rule.
        """
        return pulumi.get(self, "validate")

