# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SensitiveDataScannerRuleArgs', 'SensitiveDataScannerRule']

@pulumi.input_type
class SensitiveDataScannerRuleArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 excluded_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 included_keyword_configuration: Optional[pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 standard_pattern_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_replacement: Optional[pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs']] = None):
        """
        The set of arguments for constructing a SensitiveDataScannerRule resource.
        :param pulumi.Input[str] group_id: Id of the scanning group the rule belongs to.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_namespaces: Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        :param pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs'] included_keyword_configuration: Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        :param pulumi.Input[bool] is_enabled: Whether or not the rule is enabled.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        :param pulumi.Input[str] pattern: Not included if there is a relationship to a standard pattern.
        :param pulumi.Input[int] priority: Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        :param pulumi.Input[str] standard_pattern_id: Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags.
        :param pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs'] text_replacement: Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        pulumi.set(__self__, "group_id", group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excluded_namespaces is not None:
            pulumi.set(__self__, "excluded_namespaces", excluded_namespaces)
        if included_keyword_configuration is not None:
            pulumi.set(__self__, "included_keyword_configuration", included_keyword_configuration)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if standard_pattern_id is not None:
            pulumi.set(__self__, "standard_pattern_id", standard_pattern_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if text_replacement is not None:
            pulumi.set(__self__, "text_replacement", text_replacement)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Id of the scanning group the rule belongs to.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        """
        return pulumi.get(self, "excluded_namespaces")

    @excluded_namespaces.setter
    def excluded_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_namespaces", value)

    @property
    @pulumi.getter(name="includedKeywordConfiguration")
    def included_keyword_configuration(self) -> Optional[pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]:
        """
        Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        """
        return pulumi.get(self, "included_keyword_configuration")

    @included_keyword_configuration.setter
    def included_keyword_configuration(self, value: Optional[pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]):
        pulumi.set(self, "included_keyword_configuration", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Not included if there is a relationship to a standard pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="standardPatternId")
    def standard_pattern_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        """
        return pulumi.get(self, "standard_pattern_id")

    @standard_pattern_id.setter
    def standard_pattern_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standard_pattern_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="textReplacement")
    def text_replacement(self) -> Optional[pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs']]:
        """
        Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        return pulumi.get(self, "text_replacement")

    @text_replacement.setter
    def text_replacement(self, value: Optional[pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs']]):
        pulumi.set(self, "text_replacement", value)


@pulumi.input_type
class _SensitiveDataScannerRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 excluded_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 included_keyword_configuration: Optional[pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 standard_pattern_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_replacement: Optional[pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs']] = None):
        """
        Input properties used for looking up and filtering SensitiveDataScannerRule resources.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_namespaces: Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        :param pulumi.Input[str] group_id: Id of the scanning group the rule belongs to.
        :param pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs'] included_keyword_configuration: Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        :param pulumi.Input[bool] is_enabled: Whether or not the rule is enabled.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        :param pulumi.Input[str] pattern: Not included if there is a relationship to a standard pattern.
        :param pulumi.Input[int] priority: Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        :param pulumi.Input[str] standard_pattern_id: Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags.
        :param pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs'] text_replacement: Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excluded_namespaces is not None:
            pulumi.set(__self__, "excluded_namespaces", excluded_namespaces)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if included_keyword_configuration is not None:
            pulumi.set(__self__, "included_keyword_configuration", included_keyword_configuration)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if standard_pattern_id is not None:
            pulumi.set(__self__, "standard_pattern_id", standard_pattern_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if text_replacement is not None:
            pulumi.set(__self__, "text_replacement", text_replacement)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        """
        return pulumi.get(self, "excluded_namespaces")

    @excluded_namespaces.setter
    def excluded_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_namespaces", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the scanning group the rule belongs to.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="includedKeywordConfiguration")
    def included_keyword_configuration(self) -> Optional[pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]:
        """
        Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        """
        return pulumi.get(self, "included_keyword_configuration")

    @included_keyword_configuration.setter
    def included_keyword_configuration(self, value: Optional[pulumi.Input['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]):
        pulumi.set(self, "included_keyword_configuration", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Not included if there is a relationship to a standard pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="standardPatternId")
    def standard_pattern_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        """
        return pulumi.get(self, "standard_pattern_id")

    @standard_pattern_id.setter
    def standard_pattern_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standard_pattern_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="textReplacement")
    def text_replacement(self) -> Optional[pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs']]:
        """
        Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        return pulumi.get(self, "text_replacement")

    @text_replacement.setter
    def text_replacement(self, value: Optional[pulumi.Input['SensitiveDataScannerRuleTextReplacementArgs']]):
        pulumi.set(self, "text_replacement", value)


class SensitiveDataScannerRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 excluded_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 included_keyword_configuration: Optional[pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 standard_pattern_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_replacement: Optional[pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleTextReplacementArgs']]] = None,
                 __props__=None):
        """
        Provides a Datadog SensitiveDataScannerRule resource. This can be used to create and manage Datadog sensitive_data_scanner_rule. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying the `included_keyword_configuration` field to avoid unexpectedly disabling Sensitive Data Scanner groups.

        ## Import

        ```sh
        $ pulumi import datadog:index/sensitiveDataScannerRule:SensitiveDataScannerRule new_list "<rule_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_namespaces: Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        :param pulumi.Input[str] group_id: Id of the scanning group the rule belongs to.
        :param pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']] included_keyword_configuration: Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        :param pulumi.Input[bool] is_enabled: Whether or not the rule is enabled.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        :param pulumi.Input[str] pattern: Not included if there is a relationship to a standard pattern.
        :param pulumi.Input[int] priority: Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        :param pulumi.Input[str] standard_pattern_id: Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags.
        :param pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleTextReplacementArgs']] text_replacement: Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveDataScannerRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog SensitiveDataScannerRule resource. This can be used to create and manage Datadog sensitive_data_scanner_rule. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying the `included_keyword_configuration` field to avoid unexpectedly disabling Sensitive Data Scanner groups.

        ## Import

        ```sh
        $ pulumi import datadog:index/sensitiveDataScannerRule:SensitiveDataScannerRule new_list "<rule_id>"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveDataScannerRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveDataScannerRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 excluded_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 included_keyword_configuration: Optional[pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 standard_pattern_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_replacement: Optional[pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleTextReplacementArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveDataScannerRuleArgs.__new__(SensitiveDataScannerRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["excluded_namespaces"] = excluded_namespaces
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["included_keyword_configuration"] = included_keyword_configuration
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["namespaces"] = namespaces
            __props__.__dict__["pattern"] = pattern
            __props__.__dict__["priority"] = priority
            __props__.__dict__["standard_pattern_id"] = standard_pattern_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["text_replacement"] = text_replacement
        super(SensitiveDataScannerRule, __self__).__init__(
            'datadog:index/sensitiveDataScannerRule:SensitiveDataScannerRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            excluded_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            included_keyword_configuration: Optional[pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            pattern: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            standard_pattern_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            text_replacement: Optional[pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleTextReplacementArgs']]] = None) -> 'SensitiveDataScannerRule':
        """
        Get an existing SensitiveDataScannerRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_namespaces: Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        :param pulumi.Input[str] group_id: Id of the scanning group the rule belongs to.
        :param pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleIncludedKeywordConfigurationArgs']] included_keyword_configuration: Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        :param pulumi.Input[bool] is_enabled: Whether or not the rule is enabled.
        :param pulumi.Input[str] name: Name of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        :param pulumi.Input[str] pattern: Not included if there is a relationship to a standard pattern.
        :param pulumi.Input[int] priority: Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        :param pulumi.Input[str] standard_pattern_id: Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags.
        :param pulumi.Input[pulumi.InputType['SensitiveDataScannerRuleTextReplacementArgs']] text_replacement: Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveDataScannerRuleState.__new__(_SensitiveDataScannerRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["excluded_namespaces"] = excluded_namespaces
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["included_keyword_configuration"] = included_keyword_configuration
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["namespaces"] = namespaces
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["priority"] = priority
        __props__.__dict__["standard_pattern_id"] = standard_pattern_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["text_replacement"] = text_replacement
        return SensitiveDataScannerRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Attributes excluded from the scan. If namespaces is provided, it has to be a sub-path of the namespaces array.
        """
        return pulumi.get(self, "excluded_namespaces")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Id of the scanning group the rule belongs to.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="includedKeywordConfiguration")
    def included_keyword_configuration(self) -> pulumi.Output[Optional['outputs.SensitiveDataScannerRuleIncludedKeywordConfiguration']]:
        """
        Object defining a set of keywords and a number of characters that help reduce noise. You can provide a list of keywords you would like to check within a defined proximity of the matching pattern. If any of the keywords are found within the proximity check then the match is kept. If none are found, the match is discarded. Setting the `create_before_destroy` lifecycle Meta-argument to `true` is highly recommended if modifying this field to avoid unexpectedly disabling Sensitive Data Scanner groups.
        """
        return pulumi.get(self, "included_keyword_configuration")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespaces(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Attributes included in the scan. If namespaces is empty or missing, all attributes except excluded_namespaces are scanned. If both are missing the whole event is scanned.
        """
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[Optional[str]]:
        """
        Not included if there is a relationship to a standard pattern.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority level of the rule (optional). Used to order sensitive data discovered in the sds summary page. It must be between 1 and 5 (1 being the most important).
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="standardPatternId")
    def standard_pattern_id(self) -> pulumi.Output[Optional[str]]:
        """
        Id of the standard pattern the rule refers to. If provided, then pattern must not be provided.
        """
        return pulumi.get(self, "standard_pattern_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="textReplacement")
    def text_replacement(self) -> pulumi.Output[Optional['outputs.SensitiveDataScannerRuleTextReplacement']]:
        """
        Object describing how the scanned event will be replaced. Defaults to `type: none`
        """
        return pulumi.get(self, "text_replacement")

