# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceAccountApplicationKeyArgs', 'ServiceAccountApplicationKey']

@pulumi.input_type
class ServiceAccountApplicationKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service_account_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ServiceAccountApplicationKey resource.
        :param pulumi.Input[str] name: Name of the application key.
        :param pulumi.Input[str] service_account_id: ID of the service account that owns this key.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the application key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[str]:
        """
        ID of the service account that owns this key.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_account_id", value)


@pulumi.input_type
class _ServiceAccountApplicationKeyState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 last4: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceAccountApplicationKey resources.
        :param pulumi.Input[str] created_at: Creation date of the application key.
        :param pulumi.Input[str] key: The value of the service account application key. This value cannot be imported.
        :param pulumi.Input[str] last4: The last four characters of the application key.
        :param pulumi.Input[str] name: Name of the application key.
        :param pulumi.Input[str] service_account_id: ID of the service account that owns this key.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if last4 is not None:
            pulumi.set(__self__, "last4", last4)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation date of the application key.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the service account application key. This value cannot be imported.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def last4(self) -> Optional[pulumi.Input[str]]:
        """
        The last four characters of the application key.
        """
        return pulumi.get(self, "last4")

    @last4.setter
    def last4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last4", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the service account that owns this key.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_id", value)


class ServiceAccountApplicationKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog `service_account_application_key` resource. This can be used to create and manage Datadog service account application keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new service_account_application_key resource
        foo = datadog.ServiceAccountApplicationKey("foo",
            service_account_id="00000000-0000-1234-0000-000000000000",
            name="Application key for managing dashboards")
        ```

        ## Import

        Importing a service account's application key cannot import the value of the key.

        ```sh
        $ pulumi import datadog:index/serviceAccountApplicationKey:ServiceAccountApplicationKey this "<service_account_id>:<application_key_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the application key.
        :param pulumi.Input[str] service_account_id: ID of the service account that owns this key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAccountApplicationKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog `service_account_application_key` resource. This can be used to create and manage Datadog service account application keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new service_account_application_key resource
        foo = datadog.ServiceAccountApplicationKey("foo",
            service_account_id="00000000-0000-1234-0000-000000000000",
            name="Application key for managing dashboards")
        ```

        ## Import

        Importing a service account's application key cannot import the value of the key.

        ```sh
        $ pulumi import datadog:index/serviceAccountApplicationKey:ServiceAccountApplicationKey this "<service_account_id>:<application_key_id>"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAccountApplicationKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAccountApplicationKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAccountApplicationKeyArgs.__new__(ServiceAccountApplicationKeyArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["last4"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceAccountApplicationKey, __self__).__init__(
            'datadog:index/serviceAccountApplicationKey:ServiceAccountApplicationKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            last4: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_account_id: Optional[pulumi.Input[str]] = None) -> 'ServiceAccountApplicationKey':
        """
        Get an existing ServiceAccountApplicationKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation date of the application key.
        :param pulumi.Input[str] key: The value of the service account application key. This value cannot be imported.
        :param pulumi.Input[str] last4: The last four characters of the application key.
        :param pulumi.Input[str] name: Name of the application key.
        :param pulumi.Input[str] service_account_id: ID of the service account that owns this key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAccountApplicationKeyState.__new__(_ServiceAccountApplicationKeyState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["key"] = key
        __props__.__dict__["last4"] = last4
        __props__.__dict__["name"] = name
        __props__.__dict__["service_account_id"] = service_account_id
        return ServiceAccountApplicationKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation date of the application key.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The value of the service account application key. This value cannot be imported.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def last4(self) -> pulumi.Output[str]:
        """
        The last four characters of the application key.
        """
        return pulumi.get(self, "last4")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the application key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[str]:
        """
        ID of the service account that owns this key.
        """
        return pulumi.get(self, "service_account_id")

