# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceDefinitionYamlArgs', 'ServiceDefinitionYaml']

@pulumi.input_type
class ServiceDefinitionYamlArgs:
    def __init__(__self__, *,
                 service_definition: pulumi.Input[str]):
        """
        The set of arguments for constructing a ServiceDefinitionYaml resource.
        :param pulumi.Input[str] service_definition: The YAML/JSON formatted definition of the service
        """
        pulumi.set(__self__, "service_definition", service_definition)

    @property
    @pulumi.getter(name="serviceDefinition")
    def service_definition(self) -> pulumi.Input[str]:
        """
        The YAML/JSON formatted definition of the service
        """
        return pulumi.get(self, "service_definition")

    @service_definition.setter
    def service_definition(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_definition", value)


@pulumi.input_type
class _ServiceDefinitionYamlState:
    def __init__(__self__, *,
                 service_definition: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceDefinitionYaml resources.
        :param pulumi.Input[str] service_definition: The YAML/JSON formatted definition of the service
        """
        if service_definition is not None:
            pulumi.set(__self__, "service_definition", service_definition)

    @property
    @pulumi.getter(name="serviceDefinition")
    def service_definition(self) -> Optional[pulumi.Input[str]]:
        """
        The YAML/JSON formatted definition of the service
        """
        return pulumi.get(self, "service_definition")

    @service_definition.setter
    def service_definition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_definition", value)


class ServiceDefinitionYaml(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 service_definition: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog service definition resource. This can be used to create and manage Datadog service definitions in the service catalog using the YAML/JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Service Definition with v2.2 Schema Definition
        service_definition_v22 = datadog.ServiceDefinitionYaml("service_definition_v2_2", service_definition=\"\"\"schema-version: v2.2
        dd-service: shopping-cart
        team: e-commerce-team
        contacts:
          - name: Support Email
            type: email
            contact: team@shopping.com
          - name: Support Slack
            type: slack
            contact: https://www.slack.com/archives/shopping-cart
        description: shopping cart service responsible for managing shopping carts
        tier: high
        lifecycle: production
        application: e-commerce
        languages: 
          - go
          - python
        type: web 
        ci-pipeline-fingerprints:
          - fp1 
          - fp2 
        links:
          - name: shopping-cart runbook
            type: runbook
            url: https://runbook/shopping-cart
          - name: shopping-cart architecture
            type: doc
            provider: gdoc
            url: https://google.drive/shopping-cart-architecture
          - name: shopping-cart service Wiki
            type: doc
            provider: wiki
            url: https://wiki/shopping-cart
          - name: shopping-cart source code
            type: repo
            provider: github
            url: http://github/shopping-cart
        tags:
          - business-unit:retail
          - cost-center:engineering
        integrations:
          pagerduty: 
            service-url: https://www.pagerduty.com/service-directory/Pshopping-cart
        extensions:
          mycompany.com/shopping-cart:
            customField: customValue
        \"\"\")
        # Service Definition with v2.1 Schema Definition
        service_definition_v21 = datadog.ServiceDefinitionYaml("service_definition_v2_1", service_definition=\"\"\"schema-version: v2.1
        dd-service: shopping-cart
        team: e-commerce-team
        contacts:
          - name: Support Email
            type: email
            contact: team@shopping.com
          - name: Support Slack
            type: slack
            contact: https://www.slack.com/archives/shopping-cart
        description: shopping cart service responsible for managing shopping carts
        tier: high
        lifecycle: production
        application: e-commerce
        links:
          - name: shopping-cart runbook
            type: runbook
            url: https://runbook/shopping-cart
          - name: shopping-cart architecture
            type: doc
            provider: gdoc
            url: https://google.drive/shopping-cart-architecture
          - name: shopping-cart service Wiki
            type: doc
            provider: wiki
            url: https://wiki/shopping-cart
          - name: shopping-cart source code
            type: repo
            provider: github
            url: http://github/shopping-cart
        tags:
          - business-unit:retail
          - cost-center:engineering
        integrations:
          pagerduty: 
            service-url: https://www.pagerduty.com/service-directory/Pshopping-cart
        extensions:
          mycompany.com/shopping-cart:
            customField: customValue
        \"\"\")
        # Service Definition with v2 Schema Definition
        service_definition_v2 = datadog.ServiceDefinitionYaml("service_definition_v2", service_definition=\"\"\"schema-version: v2
        dd-service: shopping-cart
        team: E Commerce
        contacts:
          - name: Support Email
            type: email
            contact: team@shopping.com
          - name: Support Slack
            type: slack
            contact: https://www.slack.com/archives/shopping-cart
        repos:
          - name: shopping-cart source code
            provider: github
            url: http://github/shopping-cart
        docs:
          - name: shopping-cart architecture
            provider: gdoc
            url: https://google.drive/shopping-cart-architecture
          - name: shopping-cart service Wiki
            provider: wiki
            url: https://wiki/shopping-cart
        links:
          - name: shopping-cart runbook
            type: runbook
            url: https://runbook/shopping-cart
        tags:
          - business-unit:retail
          - cost-center:engineering
        integrations:
          pagerduty: https://www.pagerduty.com/service-directory/Pshopping-cart
        extensions:
          datadoghq.com/shopping-cart:
            customField: customValue
        \"\"\")
        # Service Definition with backstage.io Schema
        service_definition_backstage = datadog.ServiceDefinitionYaml("service_definition_backstage", service_definition=\"\"\"apiVersion: backstage.io/v1alpha1
        kind: Component
        metadata:
          annotations:
            backstage.io/techdocs-ref: http://a/b/c
            some.annotation: value
          namespace: default
          name: shopping-cart
          title: Shopping Cart
          description: A shopping cart service
          tags: ["taga:valuea", "tagb:valueb"]
          links:
            - title: Wiki
              url: https://wiki/shopping-cart
              icon: help
          ignore-attribute:
            id: 1
            value: "value"
        spec:
          type: service
          lifecycle: production
          owner: e-commerce
          system: retail
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/serviceDefinitionYaml:ServiceDefinitionYaml service_definition "<dd-service>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] service_definition: The YAML/JSON formatted definition of the service
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDefinitionYamlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog service definition resource. This can be used to create and manage Datadog service definitions in the service catalog using the YAML/JSON definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Service Definition with v2.2 Schema Definition
        service_definition_v22 = datadog.ServiceDefinitionYaml("service_definition_v2_2", service_definition=\"\"\"schema-version: v2.2
        dd-service: shopping-cart
        team: e-commerce-team
        contacts:
          - name: Support Email
            type: email
            contact: team@shopping.com
          - name: Support Slack
            type: slack
            contact: https://www.slack.com/archives/shopping-cart
        description: shopping cart service responsible for managing shopping carts
        tier: high
        lifecycle: production
        application: e-commerce
        languages: 
          - go
          - python
        type: web 
        ci-pipeline-fingerprints:
          - fp1 
          - fp2 
        links:
          - name: shopping-cart runbook
            type: runbook
            url: https://runbook/shopping-cart
          - name: shopping-cart architecture
            type: doc
            provider: gdoc
            url: https://google.drive/shopping-cart-architecture
          - name: shopping-cart service Wiki
            type: doc
            provider: wiki
            url: https://wiki/shopping-cart
          - name: shopping-cart source code
            type: repo
            provider: github
            url: http://github/shopping-cart
        tags:
          - business-unit:retail
          - cost-center:engineering
        integrations:
          pagerduty: 
            service-url: https://www.pagerduty.com/service-directory/Pshopping-cart
        extensions:
          mycompany.com/shopping-cart:
            customField: customValue
        \"\"\")
        # Service Definition with v2.1 Schema Definition
        service_definition_v21 = datadog.ServiceDefinitionYaml("service_definition_v2_1", service_definition=\"\"\"schema-version: v2.1
        dd-service: shopping-cart
        team: e-commerce-team
        contacts:
          - name: Support Email
            type: email
            contact: team@shopping.com
          - name: Support Slack
            type: slack
            contact: https://www.slack.com/archives/shopping-cart
        description: shopping cart service responsible for managing shopping carts
        tier: high
        lifecycle: production
        application: e-commerce
        links:
          - name: shopping-cart runbook
            type: runbook
            url: https://runbook/shopping-cart
          - name: shopping-cart architecture
            type: doc
            provider: gdoc
            url: https://google.drive/shopping-cart-architecture
          - name: shopping-cart service Wiki
            type: doc
            provider: wiki
            url: https://wiki/shopping-cart
          - name: shopping-cart source code
            type: repo
            provider: github
            url: http://github/shopping-cart
        tags:
          - business-unit:retail
          - cost-center:engineering
        integrations:
          pagerduty: 
            service-url: https://www.pagerduty.com/service-directory/Pshopping-cart
        extensions:
          mycompany.com/shopping-cart:
            customField: customValue
        \"\"\")
        # Service Definition with v2 Schema Definition
        service_definition_v2 = datadog.ServiceDefinitionYaml("service_definition_v2", service_definition=\"\"\"schema-version: v2
        dd-service: shopping-cart
        team: E Commerce
        contacts:
          - name: Support Email
            type: email
            contact: team@shopping.com
          - name: Support Slack
            type: slack
            contact: https://www.slack.com/archives/shopping-cart
        repos:
          - name: shopping-cart source code
            provider: github
            url: http://github/shopping-cart
        docs:
          - name: shopping-cart architecture
            provider: gdoc
            url: https://google.drive/shopping-cart-architecture
          - name: shopping-cart service Wiki
            provider: wiki
            url: https://wiki/shopping-cart
        links:
          - name: shopping-cart runbook
            type: runbook
            url: https://runbook/shopping-cart
        tags:
          - business-unit:retail
          - cost-center:engineering
        integrations:
          pagerduty: https://www.pagerduty.com/service-directory/Pshopping-cart
        extensions:
          datadoghq.com/shopping-cart:
            customField: customValue
        \"\"\")
        # Service Definition with backstage.io Schema
        service_definition_backstage = datadog.ServiceDefinitionYaml("service_definition_backstage", service_definition=\"\"\"apiVersion: backstage.io/v1alpha1
        kind: Component
        metadata:
          annotations:
            backstage.io/techdocs-ref: http://a/b/c
            some.annotation: value
          namespace: default
          name: shopping-cart
          title: Shopping Cart
          description: A shopping cart service
          tags: ["taga:valuea", "tagb:valueb"]
          links:
            - title: Wiki
              url: https://wiki/shopping-cart
              icon: help
          ignore-attribute:
            id: 1
            value: "value"
        spec:
          type: service
          lifecycle: production
          owner: e-commerce
          system: retail
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import datadog:index/serviceDefinitionYaml:ServiceDefinitionYaml service_definition "<dd-service>"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceDefinitionYamlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDefinitionYamlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 service_definition: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDefinitionYamlArgs.__new__(ServiceDefinitionYamlArgs)

            if service_definition is None and not opts.urn:
                raise TypeError("Missing required property 'service_definition'")
            __props__.__dict__["service_definition"] = service_definition
        super(ServiceDefinitionYaml, __self__).__init__(
            'datadog:index/serviceDefinitionYaml:ServiceDefinitionYaml',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            service_definition: Optional[pulumi.Input[str]] = None) -> 'ServiceDefinitionYaml':
        """
        Get an existing ServiceDefinitionYaml resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] service_definition: The YAML/JSON formatted definition of the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDefinitionYamlState.__new__(_ServiceDefinitionYamlState)

        __props__.__dict__["service_definition"] = service_definition
        return ServiceDefinitionYaml(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="serviceDefinition")
    def service_definition(self) -> pulumi.Output[str]:
        """
        The YAML/JSON formatted definition of the service
        """
        return pulumi.get(self, "service_definition")

