# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceLevelObjectiveArgs', 'ServiceLevelObjective']

@pulumi.input_type
class ServiceLevelObjectiveArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 thresholds: pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitor_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 query: Optional[pulumi.Input['ServiceLevelObjectiveQueryArgs']] = None,
                 sli_specification: Optional[pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_threshold: Optional[pulumi.Input[float]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 warning_threshold: Optional[pulumi.Input[float]] = None):
        """
        The set of arguments for constructing a ServiceLevelObjective resource.
        :param pulumi.Input[str] name: Name of Datadog service level objective
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]] thresholds: A list of thresholds and targets that define the service level objectives from the provided SLIs.
        :param pulumi.Input[str] type: The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        :param pulumi.Input[str] description: A description of this service level objective.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A static set of groups to filter monitor-based SLOs
        :param pulumi.Input[Sequence[pulumi.Input[int]]] monitor_ids: A static set of monitor IDs to use as part of the SLO
        :param pulumi.Input['ServiceLevelObjectiveQueryArgs'] query: The metric query of good / total events
        :param pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs'] sli_specification: A map of SLI specifications to use as part of the SLO.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[float] target_threshold: The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        :param pulumi.Input[str] timeframe: The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        :param pulumi.Input[bool] validate: Whether or not to validate the SLO.
        :param pulumi.Input[float] warning_threshold: The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "thresholds", thresholds)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if monitor_ids is not None:
            pulumi.set(__self__, "monitor_ids", monitor_ids)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if sli_specification is not None:
            pulumi.set(__self__, "sli_specification", sli_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_threshold is not None:
            pulumi.set(__self__, "target_threshold", target_threshold)
        if timeframe is not None:
            pulumi.set(__self__, "timeframe", timeframe)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of Datadog service level objective
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thresholds(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]]:
        """
        A list of thresholds and targets that define the service level objectives from the provided SLIs.
        """
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of this service level objective.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A static set of groups to filter monitor-based SLOs
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="monitorIds")
    def monitor_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A static set of monitor IDs to use as part of the SLO
        """
        return pulumi.get(self, "monitor_ids")

    @monitor_ids.setter
    def monitor_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "monitor_ids", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input['ServiceLevelObjectiveQueryArgs']]:
        """
        The metric query of good / total events
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input['ServiceLevelObjectiveQueryArgs']]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sliSpecification")
    def sli_specification(self) -> Optional[pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs']]:
        """
        A map of SLI specifications to use as part of the SLO.
        """
        return pulumi.get(self, "sli_specification")

    @sli_specification.setter
    def sli_specification(self, value: Optional[pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs']]):
        pulumi.set(self, "sli_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetThreshold")
    def target_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        """
        return pulumi.get(self, "target_threshold")

    @target_threshold.setter
    def target_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_threshold", value)

    @property
    @pulumi.getter
    def timeframe(self) -> Optional[pulumi.Input[str]]:
        """
        The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeframe", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to validate the SLO.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        return pulumi.get(self, "warning_threshold")

    @warning_threshold.setter
    def warning_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warning_threshold", value)


@pulumi.input_type
class _ServiceLevelObjectiveState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitor_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input['ServiceLevelObjectiveQueryArgs']] = None,
                 sli_specification: Optional[pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_threshold: Optional[pulumi.Input[float]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 warning_threshold: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering ServiceLevelObjective resources.
        :param pulumi.Input[str] description: A description of this service level objective.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A static set of groups to filter monitor-based SLOs
        :param pulumi.Input[Sequence[pulumi.Input[int]]] monitor_ids: A static set of monitor IDs to use as part of the SLO
        :param pulumi.Input[str] name: Name of Datadog service level objective
        :param pulumi.Input['ServiceLevelObjectiveQueryArgs'] query: The metric query of good / total events
        :param pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs'] sli_specification: A map of SLI specifications to use as part of the SLO.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[float] target_threshold: The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]] thresholds: A list of thresholds and targets that define the service level objectives from the provided SLIs.
        :param pulumi.Input[str] timeframe: The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        :param pulumi.Input[str] type: The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        :param pulumi.Input[bool] validate: Whether or not to validate the SLO.
        :param pulumi.Input[float] warning_threshold: The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if monitor_ids is not None:
            pulumi.set(__self__, "monitor_ids", monitor_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if sli_specification is not None:
            pulumi.set(__self__, "sli_specification", sli_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_threshold is not None:
            pulumi.set(__self__, "target_threshold", target_threshold)
        if thresholds is not None:
            pulumi.set(__self__, "thresholds", thresholds)
        if timeframe is not None:
            pulumi.set(__self__, "timeframe", timeframe)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of this service level objective.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A static set of groups to filter monitor-based SLOs
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="monitorIds")
    def monitor_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A static set of monitor IDs to use as part of the SLO
        """
        return pulumi.get(self, "monitor_ids")

    @monitor_ids.setter
    def monitor_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "monitor_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Datadog service level objective
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input['ServiceLevelObjectiveQueryArgs']]:
        """
        The metric query of good / total events
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input['ServiceLevelObjectiveQueryArgs']]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="sliSpecification")
    def sli_specification(self) -> Optional[pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs']]:
        """
        A map of SLI specifications to use as part of the SLO.
        """
        return pulumi.get(self, "sli_specification")

    @sli_specification.setter
    def sli_specification(self, value: Optional[pulumi.Input['ServiceLevelObjectiveSliSpecificationArgs']]):
        pulumi.set(self, "sli_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetThreshold")
    def target_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        """
        return pulumi.get(self, "target_threshold")

    @target_threshold.setter
    def target_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_threshold", value)

    @property
    @pulumi.getter
    def thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]]]:
        """
        A list of thresholds and targets that define the service level objectives from the provided SLIs.
        """
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLevelObjectiveThresholdArgs']]]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter
    def timeframe(self) -> Optional[pulumi.Input[str]]:
        """
        The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeframe", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to validate the SLO.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        return pulumi.get(self, "warning_threshold")

    @warning_threshold.setter
    def warning_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warning_threshold", value)


class ServiceLevelObjective(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitor_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveQueryArgs']]] = None,
                 sli_specification: Optional[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveSliSpecificationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_threshold: Optional[pulumi.Input[float]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveThresholdArgs']]]]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 warning_threshold: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        Provides a Datadog service level objective resource. This can be used to create and manage Datadog service level objectives.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Metric-Based SLO
        # Create a new Datadog service level objective
        foo = datadog.ServiceLevelObjective("foo",
            name="Example Metric SLO",
            type="metric",
            description="My custom metric SLO",
            query=datadog.ServiceLevelObjectiveQueryArgs(
                numerator="sum:my.custom.count.metric{type:good_events}.as_count()",
                denominator="sum:my.custom.count.metric{*}.as_count()",
            ),
            thresholds=[
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="7d",
                    target=99.9,
                    warning=99.99,
                ),
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="30d",
                    target=99.9,
                    warning=99.99,
                ),
            ],
            timeframe="30d",
            target_threshold=99.9,
            warning_threshold=99.99,
            tags=[
                "foo:bar",
                "baz",
            ])
        # Monitor-Based SLO
        # Create a new Datadog service level objective
        bar = datadog.ServiceLevelObjective("bar",
            name="Example Monitor SLO",
            type="monitor",
            description="My custom monitor SLO",
            monitor_ids=[
                1,
                2,
                3,
            ],
            thresholds=[
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="7d",
                    target=99.9,
                    warning=99.99,
                ),
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="30d",
                    target=99.9,
                    warning=99.99,
                ),
            ],
            timeframe="30d",
            target_threshold=99.9,
            warning_threshold=99.99,
            tags=[
                "foo:bar",
                "baz",
            ])
        time_slice_slo = datadog.ServiceLevelObjective("time_slice_slo",
            name="Example Time Slice SLO",
            type="time_slice",
            description="My custom time slice SLO",
            sli_specification=datadog.ServiceLevelObjectiveSliSpecificationArgs(
                time_slice=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceArgs(
                    query=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryArgs(
                        formula=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryFormulaArgs(
                            formula_expression="query1",
                        ),
                        queries=[datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryQueryArgs(
                            metric_query=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryQueryMetricQueryArgs(
                                name="query1",
                                query="avg:my.custom.count.metric{*}.as_count()",
                            ),
                        )],
                    ),
                    comparator=">",
                    threshold=0.9,
                ),
            ),
            thresholds=[datadog.ServiceLevelObjectiveThresholdArgs(
                timeframe="7d",
                target=99.9,
                warning=99.99,
            )],
            timeframe="7d",
            target_threshold=99.9,
            warning_threshold=99.99,
            tags=[
                "service:myservice",
                "team:myteam",
            ])
        ```

        ## Import

        Service Level Objectives can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/serviceLevelObjective:ServiceLevelObjective baz 12345678901234567890123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of this service level objective.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A static set of groups to filter monitor-based SLOs
        :param pulumi.Input[Sequence[pulumi.Input[int]]] monitor_ids: A static set of monitor IDs to use as part of the SLO
        :param pulumi.Input[str] name: Name of Datadog service level objective
        :param pulumi.Input[pulumi.InputType['ServiceLevelObjectiveQueryArgs']] query: The metric query of good / total events
        :param pulumi.Input[pulumi.InputType['ServiceLevelObjectiveSliSpecificationArgs']] sli_specification: A map of SLI specifications to use as part of the SLO.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[float] target_threshold: The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveThresholdArgs']]]] thresholds: A list of thresholds and targets that define the service level objectives from the provided SLIs.
        :param pulumi.Input[str] timeframe: The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        :param pulumi.Input[str] type: The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        :param pulumi.Input[bool] validate: Whether or not to validate the SLO.
        :param pulumi.Input[float] warning_threshold: The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceLevelObjectiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog service level objective resource. This can be used to create and manage Datadog service level objectives.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Metric-Based SLO
        # Create a new Datadog service level objective
        foo = datadog.ServiceLevelObjective("foo",
            name="Example Metric SLO",
            type="metric",
            description="My custom metric SLO",
            query=datadog.ServiceLevelObjectiveQueryArgs(
                numerator="sum:my.custom.count.metric{type:good_events}.as_count()",
                denominator="sum:my.custom.count.metric{*}.as_count()",
            ),
            thresholds=[
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="7d",
                    target=99.9,
                    warning=99.99,
                ),
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="30d",
                    target=99.9,
                    warning=99.99,
                ),
            ],
            timeframe="30d",
            target_threshold=99.9,
            warning_threshold=99.99,
            tags=[
                "foo:bar",
                "baz",
            ])
        # Monitor-Based SLO
        # Create a new Datadog service level objective
        bar = datadog.ServiceLevelObjective("bar",
            name="Example Monitor SLO",
            type="monitor",
            description="My custom monitor SLO",
            monitor_ids=[
                1,
                2,
                3,
            ],
            thresholds=[
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="7d",
                    target=99.9,
                    warning=99.99,
                ),
                datadog.ServiceLevelObjectiveThresholdArgs(
                    timeframe="30d",
                    target=99.9,
                    warning=99.99,
                ),
            ],
            timeframe="30d",
            target_threshold=99.9,
            warning_threshold=99.99,
            tags=[
                "foo:bar",
                "baz",
            ])
        time_slice_slo = datadog.ServiceLevelObjective("time_slice_slo",
            name="Example Time Slice SLO",
            type="time_slice",
            description="My custom time slice SLO",
            sli_specification=datadog.ServiceLevelObjectiveSliSpecificationArgs(
                time_slice=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceArgs(
                    query=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryArgs(
                        formula=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryFormulaArgs(
                            formula_expression="query1",
                        ),
                        queries=[datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryQueryArgs(
                            metric_query=datadog.ServiceLevelObjectiveSliSpecificationTimeSliceQueryQueryMetricQueryArgs(
                                name="query1",
                                query="avg:my.custom.count.metric{*}.as_count()",
                            ),
                        )],
                    ),
                    comparator=">",
                    threshold=0.9,
                ),
            ),
            thresholds=[datadog.ServiceLevelObjectiveThresholdArgs(
                timeframe="7d",
                target=99.9,
                warning=99.99,
            )],
            timeframe="7d",
            target_threshold=99.9,
            warning_threshold=99.99,
            tags=[
                "service:myservice",
                "team:myteam",
            ])
        ```

        ## Import

        Service Level Objectives can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/serviceLevelObjective:ServiceLevelObjective baz 12345678901234567890123456789012
        ```

        :param str resource_name: The name of the resource.
        :param ServiceLevelObjectiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceLevelObjectiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitor_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveQueryArgs']]] = None,
                 sli_specification: Optional[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveSliSpecificationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_threshold: Optional[pulumi.Input[float]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveThresholdArgs']]]]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 warning_threshold: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceLevelObjectiveArgs.__new__(ServiceLevelObjectiveArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["groups"] = groups
            __props__.__dict__["monitor_ids"] = monitor_ids
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["query"] = query
            __props__.__dict__["sli_specification"] = sli_specification
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_threshold"] = target_threshold
            if thresholds is None and not opts.urn:
                raise TypeError("Missing required property 'thresholds'")
            __props__.__dict__["thresholds"] = thresholds
            __props__.__dict__["timeframe"] = timeframe
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["validate"] = validate
            __props__.__dict__["warning_threshold"] = warning_threshold
        super(ServiceLevelObjective, __self__).__init__(
            'datadog:index/serviceLevelObjective:ServiceLevelObjective',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            monitor_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            query: Optional[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveQueryArgs']]] = None,
            sli_specification: Optional[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveSliSpecificationArgs']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target_threshold: Optional[pulumi.Input[float]] = None,
            thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveThresholdArgs']]]]] = None,
            timeframe: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            validate: Optional[pulumi.Input[bool]] = None,
            warning_threshold: Optional[pulumi.Input[float]] = None) -> 'ServiceLevelObjective':
        """
        Get an existing ServiceLevelObjective resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of this service level objective.
        :param pulumi.Input[bool] force_delete: A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A static set of groups to filter monitor-based SLOs
        :param pulumi.Input[Sequence[pulumi.Input[int]]] monitor_ids: A static set of monitor IDs to use as part of the SLO
        :param pulumi.Input[str] name: Name of Datadog service level objective
        :param pulumi.Input[pulumi.InputType['ServiceLevelObjectiveQueryArgs']] query: The metric query of good / total events
        :param pulumi.Input[pulumi.InputType['ServiceLevelObjectiveSliSpecificationArgs']] sli_specification: A map of SLI specifications to use as part of the SLO.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        :param pulumi.Input[float] target_threshold: The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceLevelObjectiveThresholdArgs']]]] thresholds: A list of thresholds and targets that define the service level objectives from the provided SLIs.
        :param pulumi.Input[str] timeframe: The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        :param pulumi.Input[str] type: The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        :param pulumi.Input[bool] validate: Whether or not to validate the SLO.
        :param pulumi.Input[float] warning_threshold: The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceLevelObjectiveState.__new__(_ServiceLevelObjectiveState)

        __props__.__dict__["description"] = description
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["groups"] = groups
        __props__.__dict__["monitor_ids"] = monitor_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["sli_specification"] = sli_specification
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_threshold"] = target_threshold
        __props__.__dict__["thresholds"] = thresholds
        __props__.__dict__["timeframe"] = timeframe
        __props__.__dict__["type"] = type
        __props__.__dict__["validate"] = validate
        __props__.__dict__["warning_threshold"] = warning_threshold
        return ServiceLevelObjective(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of this service level objective.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether this monitor can be deleted even if it's referenced by other resources (for example, dashboards).
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A static set of groups to filter monitor-based SLOs
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="monitorIds")
    def monitor_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        A static set of monitor IDs to use as part of the SLO
        """
        return pulumi.get(self, "monitor_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of Datadog service level objective
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[Optional['outputs.ServiceLevelObjectiveQuery']]:
        """
        The metric query of good / total events
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="sliSpecification")
    def sli_specification(self) -> pulumi.Output[Optional['outputs.ServiceLevelObjectiveSliSpecification']]:
        """
        A map of SLI specifications to use as part of the SLO.
        """
        return pulumi.get(self, "sli_specification")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags to associate with your service level objective. This can help you categorize and filter service level objectives in the service level objectives page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetThreshold")
    def target_threshold(self) -> pulumi.Output[float]:
        """
        The objective's target in `(0,100)`. This must match the corresponding thresholds of the primary time frame.
        """
        return pulumi.get(self, "target_threshold")

    @property
    @pulumi.getter
    def thresholds(self) -> pulumi.Output[Sequence['outputs.ServiceLevelObjectiveThreshold']]:
        """
        A list of thresholds and targets that define the service level objectives from the provided SLIs.
        """
        return pulumi.get(self, "thresholds")

    @property
    @pulumi.getter
    def timeframe(self) -> pulumi.Output[str]:
        """
        The primary time frame for the objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API documentation page. Valid values are `7d`, `30d`, `90d`, `custom`.
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Valid values are `metric`, `monitor`, `time_slice`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to validate the SLO.
        """
        return pulumi.get(self, "validate")

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> pulumi.Output[float]:
        """
        The objective's warning value in `(0,100)`. This must be greater than the target value and match the corresponding thresholds of the primary time frame.
        """
        return pulumi.get(self, "warning_threshold")

