# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ChannelArgs', 'Channel']

@pulumi.input_type
class ChannelArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 channel_name: pulumi.Input[str],
                 display: pulumi.Input['ChannelDisplayArgs']):
        """
        The set of arguments for constructing a Channel resource.
        :param pulumi.Input[str] account_name: Slack account name.
        :param pulumi.Input[str] channel_name: Slack channel name.
        :param pulumi.Input['ChannelDisplayArgs'] display: Configuration options for what is shown in an alert event message.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "display", display)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Slack account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        Slack channel name.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def display(self) -> pulumi.Input['ChannelDisplayArgs']:
        """
        Configuration options for what is shown in an alert event message.
        """
        return pulumi.get(self, "display")

    @display.setter
    def display(self, value: pulumi.Input['ChannelDisplayArgs']):
        pulumi.set(self, "display", value)


@pulumi.input_type
class _ChannelState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 display: Optional[pulumi.Input['ChannelDisplayArgs']] = None):
        """
        Input properties used for looking up and filtering Channel resources.
        :param pulumi.Input[str] account_name: Slack account name.
        :param pulumi.Input[str] channel_name: Slack channel name.
        :param pulumi.Input['ChannelDisplayArgs'] display: Configuration options for what is shown in an alert event message.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if display is not None:
            pulumi.set(__self__, "display", display)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Slack account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[str]]:
        """
        Slack channel name.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def display(self) -> Optional[pulumi.Input['ChannelDisplayArgs']]:
        """
        Configuration options for what is shown in an alert event message.
        """
        return pulumi.get(self, "display")

    @display.setter
    def display(self, value: Optional[pulumi.Input['ChannelDisplayArgs']]):
        pulumi.set(self, "display", value)


class Channel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 display: Optional[pulumi.Input[pulumi.InputType['ChannelDisplayArgs']]] = None,
                 __props__=None):
        """
        Resource for interacting with the Datadog Slack channel API

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        test_channel = datadog.slack.Channel("test_channel",
            account_name="foo",
            channel_name="#test_channel",
            display=datadog.slack.ChannelDisplayArgs(
                message=True,
                notified=False,
                snapshot=False,
                tags=True,
            ))
        ```

        ## Import

        Slack channel integrations can be imported using their account_name and channel_name separated with a colon (`:`).

        ```sh
        $ pulumi import datadog:slack/channel:Channel test_channel "foo:#test_channel"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Slack account name.
        :param pulumi.Input[str] channel_name: Slack channel name.
        :param pulumi.Input[pulumi.InputType['ChannelDisplayArgs']] display: Configuration options for what is shown in an alert event message.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for interacting with the Datadog Slack channel API

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        test_channel = datadog.slack.Channel("test_channel",
            account_name="foo",
            channel_name="#test_channel",
            display=datadog.slack.ChannelDisplayArgs(
                message=True,
                notified=False,
                snapshot=False,
                tags=True,
            ))
        ```

        ## Import

        Slack channel integrations can be imported using their account_name and channel_name separated with a colon (`:`).

        ```sh
        $ pulumi import datadog:slack/channel:Channel test_channel "foo:#test_channel"
        ```

        :param str resource_name: The name of the resource.
        :param ChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 display: Optional[pulumi.Input[pulumi.InputType['ChannelDisplayArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelArgs.__new__(ChannelArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if channel_name is None and not opts.urn:
                raise TypeError("Missing required property 'channel_name'")
            __props__.__dict__["channel_name"] = channel_name
            if display is None and not opts.urn:
                raise TypeError("Missing required property 'display'")
            __props__.__dict__["display"] = display
        super(Channel, __self__).__init__(
            'datadog:slack/channel:Channel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            channel_name: Optional[pulumi.Input[str]] = None,
            display: Optional[pulumi.Input[pulumi.InputType['ChannelDisplayArgs']]] = None) -> 'Channel':
        """
        Get an existing Channel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Slack account name.
        :param pulumi.Input[str] channel_name: Slack channel name.
        :param pulumi.Input[pulumi.InputType['ChannelDisplayArgs']] display: Configuration options for what is shown in an alert event message.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelState.__new__(_ChannelState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["channel_name"] = channel_name
        __props__.__dict__["display"] = display
        return Channel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        Slack account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Output[str]:
        """
        Slack channel name.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def display(self) -> pulumi.Output['outputs.ChannelDisplay']:
        """
        Configuration options for what is shown in an alert event message.
        """
        return pulumi.get(self, "display")

