# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyntheticsGlobalVariableArgs', 'SyntheticsGlobalVariable']

@pulumi.input_type
class SyntheticsGlobalVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']] = None,
                 parse_test_id: Optional[pulumi.Input[str]] = None,
                 parse_test_options: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SyntheticsGlobalVariable resource.
        :param pulumi.Input[str] name: Synthetics global variable name.
        :param pulumi.Input[str] value: The value of the global variable.
        :param pulumi.Input[str] description: Description of the global variable.
        :param pulumi.Input['SyntheticsGlobalVariableOptionsArgs'] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs'] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable.
        :param pulumi.Input[bool] secure: If set to true, the value of the global variable is hidden. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics global variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if parse_test_id is not None:
            pulumi.set(__self__, "parse_test_id", parse_test_id)
        if parse_test_options is not None:
            pulumi.set(__self__, "parse_test_options", parse_test_options)
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Synthetics global variable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the global variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the global variable.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]:
        """
        Additional options for the variable, such as a MFA token.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="parseTestId")
    def parse_test_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the Synthetics test to use for a variable from test.
        """
        return pulumi.get(self, "parse_test_id")

    @parse_test_id.setter
    def parse_test_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parse_test_id", value)

    @property
    @pulumi.getter(name="parseTestOptions")
    def parse_test_options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]:
        """
        ID of the Synthetics test to use a source of the global variable value.
        """
        return pulumi.get(self, "parse_test_options")

    @parse_test_options.setter
    def parse_test_options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]):
        pulumi.set(self, "parse_test_options", value)

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of role identifiers to associate with the Synthetics global variable.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @property
    @pulumi.getter
    def secure(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the value of the global variable is hidden. Defaults to `false`.
        """
        return pulumi.get(self, "secure")

    @secure.setter
    def secure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your synthetics global variable.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SyntheticsGlobalVariableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']] = None,
                 parse_test_id: Optional[pulumi.Input[str]] = None,
                 parse_test_options: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SyntheticsGlobalVariable resources.
        :param pulumi.Input[str] description: Description of the global variable.
        :param pulumi.Input[str] name: Synthetics global variable name.
        :param pulumi.Input['SyntheticsGlobalVariableOptionsArgs'] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs'] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable.
        :param pulumi.Input[bool] secure: If set to true, the value of the global variable is hidden. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[str] value: The value of the global variable.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if parse_test_id is not None:
            pulumi.set(__self__, "parse_test_id", parse_test_id)
        if parse_test_options is not None:
            pulumi.set(__self__, "parse_test_options", parse_test_options)
        if restricted_roles is not None:
            pulumi.set(__self__, "restricted_roles", restricted_roles)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the global variable.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Synthetics global variable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]:
        """
        Additional options for the variable, such as a MFA token.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="parseTestId")
    def parse_test_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the Synthetics test to use for a variable from test.
        """
        return pulumi.get(self, "parse_test_id")

    @parse_test_id.setter
    def parse_test_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parse_test_id", value)

    @property
    @pulumi.getter(name="parseTestOptions")
    def parse_test_options(self) -> Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]:
        """
        ID of the Synthetics test to use a source of the global variable value.
        """
        return pulumi.get(self, "parse_test_options")

    @parse_test_options.setter
    def parse_test_options(self, value: Optional[pulumi.Input['SyntheticsGlobalVariableParseTestOptionsArgs']]):
        pulumi.set(self, "parse_test_options", value)

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of role identifiers to associate with the Synthetics global variable.
        """
        return pulumi.get(self, "restricted_roles")

    @restricted_roles.setter
    def restricted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_roles", value)

    @property
    @pulumi.getter
    def secure(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the value of the global variable is hidden. Defaults to `false`.
        """
        return pulumi.get(self, "secure")

    @secure.setter
    def secure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your synthetics global variable.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the global variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class SyntheticsGlobalVariable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableOptionsArgs']]] = None,
                 parse_test_id: Optional[pulumi.Input[str]] = None,
                 parse_test_options: Optional[pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableParseTestOptionsArgs']]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog synthetics global variable resource. This can be used to create and manage Datadog synthetics global variables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        test_variable = datadog.SyntheticsGlobalVariable("test_variable",
            name="EXAMPLE_VARIABLE",
            description="Description of the variable",
            tags=[
                "foo:bar",
                "env:test",
            ],
            value="variable-value")
        ```

        ## Import

        Synthetics global variables can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable fizz abcde123-fghi-456-jkl-mnopqrstuv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the global variable.
        :param pulumi.Input[str] name: Synthetics global variable name.
        :param pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableOptionsArgs']] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableParseTestOptionsArgs']] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable.
        :param pulumi.Input[bool] secure: If set to true, the value of the global variable is hidden. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[str] value: The value of the global variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticsGlobalVariableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog synthetics global variable resource. This can be used to create and manage Datadog synthetics global variables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        test_variable = datadog.SyntheticsGlobalVariable("test_variable",
            name="EXAMPLE_VARIABLE",
            description="Description of the variable",
            tags=[
                "foo:bar",
                "env:test",
            ],
            value="variable-value")
        ```

        ## Import

        Synthetics global variables can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable fizz abcde123-fghi-456-jkl-mnopqrstuv
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticsGlobalVariableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticsGlobalVariableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableOptionsArgs']]] = None,
                 parse_test_id: Optional[pulumi.Input[str]] = None,
                 parse_test_options: Optional[pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableParseTestOptionsArgs']]] = None,
                 restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticsGlobalVariableArgs.__new__(SyntheticsGlobalVariableArgs)

            __props__.__dict__["description"] = description
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["parse_test_id"] = parse_test_id
            __props__.__dict__["parse_test_options"] = parse_test_options
            __props__.__dict__["restricted_roles"] = restricted_roles
            __props__.__dict__["secure"] = secure
            __props__.__dict__["tags"] = tags
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = None if value is None else pulumi.Output.secret(value)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SyntheticsGlobalVariable, __self__).__init__(
            'datadog:index/syntheticsGlobalVariable:SyntheticsGlobalVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableOptionsArgs']]] = None,
            parse_test_id: Optional[pulumi.Input[str]] = None,
            parse_test_options: Optional[pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableParseTestOptionsArgs']]] = None,
            restricted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            secure: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'SyntheticsGlobalVariable':
        """
        Get an existing SyntheticsGlobalVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the global variable.
        :param pulumi.Input[str] name: Synthetics global variable name.
        :param pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableOptionsArgs']] options: Additional options for the variable, such as a MFA token.
        :param pulumi.Input[str] parse_test_id: Id of the Synthetics test to use for a variable from test.
        :param pulumi.Input[pulumi.InputType['SyntheticsGlobalVariableParseTestOptionsArgs']] parse_test_options: ID of the Synthetics test to use a source of the global variable value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_roles: A list of role identifiers to associate with the Synthetics global variable.
        :param pulumi.Input[bool] secure: If set to true, the value of the global variable is hidden. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics global variable.
        :param pulumi.Input[str] value: The value of the global variable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticsGlobalVariableState.__new__(_SyntheticsGlobalVariableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["parse_test_id"] = parse_test_id
        __props__.__dict__["parse_test_options"] = parse_test_options
        __props__.__dict__["restricted_roles"] = restricted_roles
        __props__.__dict__["secure"] = secure
        __props__.__dict__["tags"] = tags
        __props__.__dict__["value"] = value
        return SyntheticsGlobalVariable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the global variable.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Synthetics global variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.SyntheticsGlobalVariableOptions']]:
        """
        Additional options for the variable, such as a MFA token.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="parseTestId")
    def parse_test_id(self) -> pulumi.Output[Optional[str]]:
        """
        Id of the Synthetics test to use for a variable from test.
        """
        return pulumi.get(self, "parse_test_id")

    @property
    @pulumi.getter(name="parseTestOptions")
    def parse_test_options(self) -> pulumi.Output[Optional['outputs.SyntheticsGlobalVariableParseTestOptions']]:
        """
        ID of the Synthetics test to use a source of the global variable value.
        """
        return pulumi.get(self, "parse_test_options")

    @property
    @pulumi.getter(name="restrictedRoles")
    def restricted_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of role identifiers to associate with the Synthetics global variable.
        """
        return pulumi.get(self, "restricted_roles")

    @property
    @pulumi.getter
    def secure(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to true, the value of the global variable is hidden. Defaults to `false`.
        """
        return pulumi.get(self, "secure")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags to associate with your synthetics global variable.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The value of the global variable.
        """
        return pulumi.get(self, "value")

