# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyntheticsTestArgs', 'SyntheticsTest']

@pulumi.input_type
class SyntheticsTestArgs:
    def __init__(__self__, *,
                 locations: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 options_list: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']] = None,
                 request_basicauth: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']] = None,
                 request_client_certificate: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']] = None,
                 request_definition: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_proxy: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 set_cookie: Optional[pulumi.Input[str]] = None,
                 subtype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 variables_from_script: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SyntheticsTest resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        :param pulumi.Input[str] name: Name of Datadog synthetics test.
        :param pulumi.Input[str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[str] type: Synthetics test type. Valid values are `api`, `browser`.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]] api_steps: Steps for multi-step api tests
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        :param pulumi.Input[bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input['SyntheticsTestRequestBasicauthArgs'] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestClientCertificateArgs'] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestDefinitionArgs'] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, Any]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, Any]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input['SyntheticsTestRequestProxyArgs'] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, Any]] request_query: Query arguments name and value map.
        :param pulumi.Input[str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if api_steps is not None:
            pulumi.set(__self__, "api_steps", api_steps)
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if browser_steps is not None:
            pulumi.set(__self__, "browser_steps", browser_steps)
        if browser_variables is not None:
            pulumi.set(__self__, "browser_variables", browser_variables)
        if config_variables is not None:
            pulumi.set(__self__, "config_variables", config_variables)
        if device_ids is not None:
            pulumi.set(__self__, "device_ids", device_ids)
        if force_delete_dependencies is not None:
            pulumi.set(__self__, "force_delete_dependencies", force_delete_dependencies)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if options_list is not None:
            pulumi.set(__self__, "options_list", options_list)
        if request_basicauth is not None:
            pulumi.set(__self__, "request_basicauth", request_basicauth)
        if request_client_certificate is not None:
            pulumi.set(__self__, "request_client_certificate", request_client_certificate)
        if request_definition is not None:
            pulumi.set(__self__, "request_definition", request_definition)
        if request_files is not None:
            pulumi.set(__self__, "request_files", request_files)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if request_metadata is not None:
            pulumi.set(__self__, "request_metadata", request_metadata)
        if request_proxy is not None:
            pulumi.set(__self__, "request_proxy", request_proxy)
        if request_query is not None:
            pulumi.set(__self__, "request_query", request_query)
        if set_cookie is not None:
            pulumi.set(__self__, "set_cookie", set_cookie)
        if subtype is not None:
            pulumi.set(__self__, "subtype", subtype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variables_from_script is not None:
            pulumi.set(__self__, "variables_from_script", variables_from_script)

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of Datadog synthetics test.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Synthetics test type. Valid values are `api`, `browser`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="apiSteps")
    def api_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]:
        """
        Steps for multi-step api tests
        """
        return pulumi.get(self, "api_steps")

    @api_steps.setter
    def api_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]):
        pulumi.set(self, "api_steps", value)

    @property
    @pulumi.getter
    def assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]:
        """
        Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "assertions")

    @assertions.setter
    def assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]):
        pulumi.set(self, "assertions", value)

    @property
    @pulumi.getter(name="browserSteps")
    def browser_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]:
        """
        Steps for browser tests.
        """
        return pulumi.get(self, "browser_steps")

    @browser_steps.setter
    def browser_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]):
        pulumi.set(self, "browser_steps", value)

    @property
    @pulumi.getter(name="browserVariables")
    def browser_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]:
        """
        Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "browser_variables")

    @browser_variables.setter
    def browser_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]):
        pulumi.set(self, "browser_variables", value)

    @property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]:
        """
        Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "config_variables")

    @config_variables.setter
    def config_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]):
        pulumi.set(self, "config_variables", value)

    @property
    @pulumi.getter(name="deviceIds")
    def device_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        """
        return pulumi.get(self, "device_ids")

    @device_ids.setter
    def device_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_ids", value)

    @property
    @pulumi.getter(name="forceDeleteDependencies")
    def force_delete_dependencies(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        """
        return pulumi.get(self, "force_delete_dependencies")

    @force_delete_dependencies.setter
    def force_delete_dependencies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete_dependencies", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="optionsList")
    def options_list(self) -> Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]:
        return pulumi.get(self, "options_list")

    @options_list.setter
    def options_list(self, value: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]):
        pulumi.set(self, "options_list", value)

    @property
    @pulumi.getter(name="requestBasicauth")
    def request_basicauth(self) -> Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]:
        """
        The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_basicauth")

    @request_basicauth.setter
    def request_basicauth(self, value: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]):
        pulumi.set(self, "request_basicauth", value)

    @property
    @pulumi.getter(name="requestClientCertificate")
    def request_client_certificate(self) -> Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]:
        """
        Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_client_certificate")

    @request_client_certificate.setter
    def request_client_certificate(self, value: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]):
        pulumi.set(self, "request_client_certificate", value)

    @property
    @pulumi.getter(name="requestDefinition")
    def request_definition(self) -> Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]:
        """
        Required if `type = "api"`. The synthetics test request.
        """
        return pulumi.get(self, "request_definition")

    @request_definition.setter
    def request_definition(self, value: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]):
        pulumi.set(self, "request_definition", value)

    @property
    @pulumi.getter(name="requestFiles")
    def request_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]:
        """
        Files to be used as part of the request in the test.
        """
        return pulumi.get(self, "request_files")

    @request_files.setter
    def request_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]):
        pulumi.set(self, "request_files", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Header name and value map.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter(name="requestMetadata")
    def request_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata to include when performing the gRPC request.
        """
        return pulumi.get(self, "request_metadata")

    @request_metadata.setter
    def request_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "request_metadata", value)

    @property
    @pulumi.getter(name="requestProxy")
    def request_proxy(self) -> Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]:
        """
        The proxy to perform the test.
        """
        return pulumi.get(self, "request_proxy")

    @request_proxy.setter
    def request_proxy(self, value: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]):
        pulumi.set(self, "request_proxy", value)

    @property
    @pulumi.getter(name="requestQuery")
    def request_query(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Query arguments name and value map.
        """
        return pulumi.get(self, "request_query")

    @request_query.setter
    def request_query(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "request_query", value)

    @property
    @pulumi.getter(name="setCookie")
    def set_cookie(self) -> Optional[pulumi.Input[str]]:
        """
        Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        """
        return pulumi.get(self, "set_cookie")

    @set_cookie.setter
    def set_cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "set_cookie", value)

    @property
    @pulumi.getter
    def subtype(self) -> Optional[pulumi.Input[str]]:
        """
        The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        """
        return pulumi.get(self, "subtype")

    @subtype.setter
    def subtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtype", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="variablesFromScript")
    def variables_from_script(self) -> Optional[pulumi.Input[str]]:
        """
        Variables defined from JavaScript code for API HTTP tests.
        """
        return pulumi.get(self, "variables_from_script")

    @variables_from_script.setter
    def variables_from_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "variables_from_script", value)


@pulumi.input_type
class _SyntheticsTestState:
    def __init__(__self__, *,
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 monitor_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_list: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']] = None,
                 request_basicauth: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']] = None,
                 request_client_certificate: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']] = None,
                 request_definition: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_proxy: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 set_cookie: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subtype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variables_from_script: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SyntheticsTest resources.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]] api_steps: Steps for multi-step api tests
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        :param pulumi.Input[bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        :param pulumi.Input[str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[int] monitor_id: ID of the monitor associated with the Datadog synthetics test.
        :param pulumi.Input[str] name: Name of Datadog synthetics test.
        :param pulumi.Input['SyntheticsTestRequestBasicauthArgs'] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestClientCertificateArgs'] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestDefinitionArgs'] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, Any]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, Any]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input['SyntheticsTestRequestProxyArgs'] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, Any]] request_query: Query arguments name and value map.
        :param pulumi.Input[str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[str] type: Synthetics test type. Valid values are `api`, `browser`.
        :param pulumi.Input[str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        if api_steps is not None:
            pulumi.set(__self__, "api_steps", api_steps)
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if browser_steps is not None:
            pulumi.set(__self__, "browser_steps", browser_steps)
        if browser_variables is not None:
            pulumi.set(__self__, "browser_variables", browser_variables)
        if config_variables is not None:
            pulumi.set(__self__, "config_variables", config_variables)
        if device_ids is not None:
            pulumi.set(__self__, "device_ids", device_ids)
        if force_delete_dependencies is not None:
            pulumi.set(__self__, "force_delete_dependencies", force_delete_dependencies)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_list is not None:
            pulumi.set(__self__, "options_list", options_list)
        if request_basicauth is not None:
            pulumi.set(__self__, "request_basicauth", request_basicauth)
        if request_client_certificate is not None:
            pulumi.set(__self__, "request_client_certificate", request_client_certificate)
        if request_definition is not None:
            pulumi.set(__self__, "request_definition", request_definition)
        if request_files is not None:
            pulumi.set(__self__, "request_files", request_files)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if request_metadata is not None:
            pulumi.set(__self__, "request_metadata", request_metadata)
        if request_proxy is not None:
            pulumi.set(__self__, "request_proxy", request_proxy)
        if request_query is not None:
            pulumi.set(__self__, "request_query", request_query)
        if set_cookie is not None:
            pulumi.set(__self__, "set_cookie", set_cookie)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subtype is not None:
            pulumi.set(__self__, "subtype", subtype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if variables_from_script is not None:
            pulumi.set(__self__, "variables_from_script", variables_from_script)

    @property
    @pulumi.getter(name="apiSteps")
    def api_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]:
        """
        Steps for multi-step api tests
        """
        return pulumi.get(self, "api_steps")

    @api_steps.setter
    def api_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]):
        pulumi.set(self, "api_steps", value)

    @property
    @pulumi.getter
    def assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]:
        """
        Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "assertions")

    @assertions.setter
    def assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]):
        pulumi.set(self, "assertions", value)

    @property
    @pulumi.getter(name="browserSteps")
    def browser_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]:
        """
        Steps for browser tests.
        """
        return pulumi.get(self, "browser_steps")

    @browser_steps.setter
    def browser_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]):
        pulumi.set(self, "browser_steps", value)

    @property
    @pulumi.getter(name="browserVariables")
    def browser_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]:
        """
        Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "browser_variables")

    @browser_variables.setter
    def browser_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]):
        pulumi.set(self, "browser_variables", value)

    @property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]:
        """
        Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "config_variables")

    @config_variables.setter
    def config_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]):
        pulumi.set(self, "config_variables", value)

    @property
    @pulumi.getter(name="deviceIds")
    def device_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        """
        return pulumi.get(self, "device_ids")

    @device_ids.setter
    def device_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_ids", value)

    @property
    @pulumi.getter(name="forceDeleteDependencies")
    def force_delete_dependencies(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        """
        return pulumi.get(self, "force_delete_dependencies")

    @force_delete_dependencies.setter
    def force_delete_dependencies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete_dependencies", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the monitor associated with the Datadog synthetics test.
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitor_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Datadog synthetics test.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionsList")
    def options_list(self) -> Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]:
        return pulumi.get(self, "options_list")

    @options_list.setter
    def options_list(self, value: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]):
        pulumi.set(self, "options_list", value)

    @property
    @pulumi.getter(name="requestBasicauth")
    def request_basicauth(self) -> Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]:
        """
        The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_basicauth")

    @request_basicauth.setter
    def request_basicauth(self, value: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]):
        pulumi.set(self, "request_basicauth", value)

    @property
    @pulumi.getter(name="requestClientCertificate")
    def request_client_certificate(self) -> Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]:
        """
        Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_client_certificate")

    @request_client_certificate.setter
    def request_client_certificate(self, value: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]):
        pulumi.set(self, "request_client_certificate", value)

    @property
    @pulumi.getter(name="requestDefinition")
    def request_definition(self) -> Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]:
        """
        Required if `type = "api"`. The synthetics test request.
        """
        return pulumi.get(self, "request_definition")

    @request_definition.setter
    def request_definition(self, value: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]):
        pulumi.set(self, "request_definition", value)

    @property
    @pulumi.getter(name="requestFiles")
    def request_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]:
        """
        Files to be used as part of the request in the test.
        """
        return pulumi.get(self, "request_files")

    @request_files.setter
    def request_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]):
        pulumi.set(self, "request_files", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Header name and value map.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter(name="requestMetadata")
    def request_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata to include when performing the gRPC request.
        """
        return pulumi.get(self, "request_metadata")

    @request_metadata.setter
    def request_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "request_metadata", value)

    @property
    @pulumi.getter(name="requestProxy")
    def request_proxy(self) -> Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]:
        """
        The proxy to perform the test.
        """
        return pulumi.get(self, "request_proxy")

    @request_proxy.setter
    def request_proxy(self, value: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]):
        pulumi.set(self, "request_proxy", value)

    @property
    @pulumi.getter(name="requestQuery")
    def request_query(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Query arguments name and value map.
        """
        return pulumi.get(self, "request_query")

    @request_query.setter
    def request_query(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "request_query", value)

    @property
    @pulumi.getter(name="setCookie")
    def set_cookie(self) -> Optional[pulumi.Input[str]]:
        """
        Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        """
        return pulumi.get(self, "set_cookie")

    @set_cookie.setter
    def set_cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "set_cookie", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subtype(self) -> Optional[pulumi.Input[str]]:
        """
        The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        """
        return pulumi.get(self, "subtype")

    @subtype.setter
    def subtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtype", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Synthetics test type. Valid values are `api`, `browser`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="variablesFromScript")
    def variables_from_script(self) -> Optional[pulumi.Input[str]]:
        """
        Variables defined from JavaScript code for API HTTP tests.
        """
        return pulumi.get(self, "variables_from_script")

    @variables_from_script.setter
    def variables_from_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "variables_from_script", value)


class SyntheticsTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestApiStepArgs']]]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestAssertionArgs']]]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserStepArgs']]]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserVariableArgs']]]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestConfigVariableArgs']]]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_list: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestOptionsListArgs']]] = None,
                 request_basicauth: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestBasicauthArgs']]] = None,
                 request_client_certificate: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestClientCertificateArgs']]] = None,
                 request_definition: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestDefinitionArgs']]] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestRequestFileArgs']]]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_proxy: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestProxyArgs']]] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 set_cookie: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subtype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variables_from_script: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog synthetics test resource. This can be used to create and manage Datadog synthetics test.

        #### *Warning*
        Starting from version 3.1.0+, the direct usage of global variables in the configuration is deprecated, in favor of
        local variables of type `global`. As an example, if you were previously using `{{ GLOBAL_VAR }}` directly in your
        configuration, add a `config_variable` of type `global` with the `id` matching the `id` of the global variable `GLOBAL_VAR`, which can be found in the Synthetics UI or from the output of the `SyntheticsGlobalVariable` resource. The name can be chosen freely.

        In practice, it means going from (simplified configuration):

        to

        which you can now use in your request definition:

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_datadog as datadog

        # Example Usage (Synthetics API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_uptime = datadog.SyntheticsTest("test_uptime",
            name="An Uptime test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                method="GET",
                url="https://www.example.org",
            ),
            request_headers={
                "Content-Type": "application/json",
            },
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="statusCode",
                operator="is",
                target="200",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                retry=datadog.SyntheticsTestOptionsListRetryArgs(
                    count=2,
                    interval=300,
                ),
                monitor_options=datadog.SyntheticsTestOptionsListMonitorOptionsArgs(
                    renotify_interval=120,
                ),
            ))
        # Example Usage (Authenticated API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_api = datadog.SyntheticsTest("test_api",
            name="An API test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                method="GET",
                url="https://www.example.org",
            ),
            request_headers={
                "Content-Type": "application/json",
                "Authentication": "Token: 1234566789",
            },
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="statusCode",
                operator="is",
                target="200",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                retry=datadog.SyntheticsTestOptionsListRetryArgs(
                    count=2,
                    interval=300,
                ),
                monitor_options=datadog.SyntheticsTestOptionsListMonitorOptionsArgs(
                    renotify_interval=120,
                ),
            ))
        # Example Usage (Synthetics SSL test)
        # Create a new Datadog Synthetics API/SSL test on example.org
        test_ssl = datadog.SyntheticsTest("test_ssl",
            name="An API test on example.org",
            type="api",
            subtype="ssl",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
            ),
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="certificate",
                operator="isInMoreThan",
                target="30",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                accept_self_signed=True,
            ))
        # Example Usage (Synthetics TCP test)
        # Create a new Datadog Synthetics API/TCP test on example.org
        test_tcp = datadog.SyntheticsTest("test_tcp",
            name="An API test on example.org",
            type="api",
            subtype="tcp",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
            ),
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="responseTime",
                operator="lessThan",
                target="2000",
            )],
            config_variables=[datadog.SyntheticsTestConfigVariableArgs(
                type="global",
                name="MY_GLOBAL_VAR",
                id="76636cd1-82e2-4aeb-9cfe-51366a8198a2",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        # Example Usage (Synthetics DNS test)
        # Create a new Datadog Synthetics API/DNS test on example.org
        test_dns = datadog.SyntheticsTest("test_dns",
            name="An API test on example.org",
            type="api",
            subtype="dns",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
            ),
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="recordSome",
                operator="is",
                property="A",
                target="0.0.0.0",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        # Example Usage (Synthetics Multistep API test)
        # Create a new Datadog Synthetics Multistep API test
        test_multi_step = datadog.SyntheticsTest("test_multi_step",
            name="Multistep API test",
            type="api",
            subtype="multi",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            api_steps=[
                datadog.SyntheticsTestApiStepArgs(
                    name="An API test on example.org",
                    subtype="http",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        method="GET",
                        url="https://www.example.org",
                    ),
                    request_headers={
                        "Content-Type": "application/json",
                        "Authentication": "Token: 1234566789",
                    },
                ),
                datadog.SyntheticsTestApiStepArgs(
                    name="An API test on example.org",
                    subtype="http",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        method="GET",
                        url="http://example.org",
                    ),
                ),
                datadog.SyntheticsTestApiStepArgs(
                    name="A gRPC health check on example.org",
                    subtype="grpc",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        host="example.org",
                        port=443,
                        call_type="healthcheck",
                        service="greeter.Greeter",
                    ),
                ),
                datadog.SyntheticsTestApiStepArgs(
                    name="A gRPC behavior check on example.org",
                    subtype="grpc",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        host="example.org",
                        port=443,
                        call_type="unary",
                        service="greeter.Greeter",
                        method="SayHello",
                        message="{\\"name\\": \\"John\\"}",
                        plain_proto_file=\"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
                    ),
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                accept_self_signed=True,
            ))
        # Example Usage (Synthetics Browser test)
        # Create a new Datadog Synthetics Browser test starting on https://www.example.org
        test_browser = datadog.SyntheticsTest("test_browser",
            name="A Browser test on example.org",
            type="browser",
            status="paused",
            message="Notify @qa",
            device_ids=["laptop_large"],
            locations=["aws:eu-central-1"],
            tags=[],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                method="GET",
                url="https://www.example.org",
            ),
            browser_steps=[
                datadog.SyntheticsTestBrowserStepArgs(
                    name="Check current url",
                    type="assertCurrentUrl",
                    params=datadog.SyntheticsTestBrowserStepParamsArgs(
                        check="contains",
                        value="datadoghq",
                    ),
                ),
                datadog.SyntheticsTestBrowserStepArgs(
                    name="Test a downloaded file",
                    type="assertFileDownload",
                    params=datadog.SyntheticsTestBrowserStepParamsArgs(
                        file=json.dumps({
                            "md5": "abcdef1234567890",
                            "sizeCheck": {
                                "type": "equals",
                                "value": 1,
                            },
                            "nameCheck": {
                                "type": "contains",
                                "value": ".xls",
                            },
                        }),
                    ),
                ),
            ],
            browser_variables=[
                datadog.SyntheticsTestBrowserVariableArgs(
                    type="text",
                    name="MY_PATTERN_VAR",
                    pattern="{{numeric(3)}}",
                    example="597",
                ),
                datadog.SyntheticsTestBrowserVariableArgs(
                    type="email",
                    name="MY_EMAIL_VAR",
                    pattern="jd8-afe-ydv.{{ numeric(10) }}@synthetics.dtdg.co",
                    example="jd8-afe-ydv.4546132139@synthetics.dtdg.co",
                ),
                datadog.SyntheticsTestBrowserVariableArgs(
                    type="global",
                    name="MY_GLOBAL_VAR",
                    id="76636cd1-82e2-4aeb-9cfe-51366a8198a2",
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=3600,
            ))
        # Example Usage (GRPC API behavior check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # targeting service `greeter.Greeter` with the method `SayHello`
        # and the message {"name": "John"}
        test_grpc_unary = datadog.SyntheticsTest("test_grpc_unary",
            name="GRPC API behavior check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
                call_type="unary",
                service="greeter.Greeter",
                method="SayHello",
                message="{\\"name\\": \\"John\\"}",
                plain_proto_file=\"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
            ),
            request_metadata={
                "header": "value",
            },
            assertions=[
                datadog.SyntheticsTestAssertionArgs(
                    type="responseTime",
                    operator="lessThan",
                    target="2000",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    type="grpcHealthcheckStatus",
                    target="1",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    type="grpcProto",
                    target="proto target",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    property="property",
                    type="grpcMetadata",
                    target="123",
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        # Example Usage (GRPC API health check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # testing the overall health of the service
        test_grpc_health = datadog.SyntheticsTest("test_grpc_health",
            name="GRPC API health check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
                call_type="healthcheck",
                service="greeter.Greeter",
            ),
            assertions=[
                datadog.SyntheticsTestAssertionArgs(
                    type="responseTime",
                    operator="lessThan",
                    target="2000",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    type="grpcHealthcheckStatus",
                    target="1",
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        ```

        ## Import

        Synthetics tests can be imported using their public string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsTest:SyntheticsTest fizz abc-123-xyz
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestApiStepArgs']]]] api_steps: Steps for multi-step api tests
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestAssertionArgs']]]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserStepArgs']]]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserVariableArgs']]]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestConfigVariableArgs']]]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        :param pulumi.Input[bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        :param pulumi.Input[str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[str] name: Name of Datadog synthetics test.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestBasicauthArgs']] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestClientCertificateArgs']] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestDefinitionArgs']] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestRequestFileArgs']]]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, Any]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, Any]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestProxyArgs']] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, Any]] request_query: Query arguments name and value map.
        :param pulumi.Input[str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[str] type: Synthetics test type. Valid values are `api`, `browser`.
        :param pulumi.Input[str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticsTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog synthetics test resource. This can be used to create and manage Datadog synthetics test.

        #### *Warning*
        Starting from version 3.1.0+, the direct usage of global variables in the configuration is deprecated, in favor of
        local variables of type `global`. As an example, if you were previously using `{{ GLOBAL_VAR }}` directly in your
        configuration, add a `config_variable` of type `global` with the `id` matching the `id` of the global variable `GLOBAL_VAR`, which can be found in the Synthetics UI or from the output of the `SyntheticsGlobalVariable` resource. The name can be chosen freely.

        In practice, it means going from (simplified configuration):

        to

        which you can now use in your request definition:

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_datadog as datadog

        # Example Usage (Synthetics API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_uptime = datadog.SyntheticsTest("test_uptime",
            name="An Uptime test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                method="GET",
                url="https://www.example.org",
            ),
            request_headers={
                "Content-Type": "application/json",
            },
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="statusCode",
                operator="is",
                target="200",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                retry=datadog.SyntheticsTestOptionsListRetryArgs(
                    count=2,
                    interval=300,
                ),
                monitor_options=datadog.SyntheticsTestOptionsListMonitorOptionsArgs(
                    renotify_interval=120,
                ),
            ))
        # Example Usage (Authenticated API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_api = datadog.SyntheticsTest("test_api",
            name="An API test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                method="GET",
                url="https://www.example.org",
            ),
            request_headers={
                "Content-Type": "application/json",
                "Authentication": "Token: 1234566789",
            },
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="statusCode",
                operator="is",
                target="200",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                retry=datadog.SyntheticsTestOptionsListRetryArgs(
                    count=2,
                    interval=300,
                ),
                monitor_options=datadog.SyntheticsTestOptionsListMonitorOptionsArgs(
                    renotify_interval=120,
                ),
            ))
        # Example Usage (Synthetics SSL test)
        # Create a new Datadog Synthetics API/SSL test on example.org
        test_ssl = datadog.SyntheticsTest("test_ssl",
            name="An API test on example.org",
            type="api",
            subtype="ssl",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
            ),
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="certificate",
                operator="isInMoreThan",
                target="30",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                accept_self_signed=True,
            ))
        # Example Usage (Synthetics TCP test)
        # Create a new Datadog Synthetics API/TCP test on example.org
        test_tcp = datadog.SyntheticsTest("test_tcp",
            name="An API test on example.org",
            type="api",
            subtype="tcp",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
            ),
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="responseTime",
                operator="lessThan",
                target="2000",
            )],
            config_variables=[datadog.SyntheticsTestConfigVariableArgs(
                type="global",
                name="MY_GLOBAL_VAR",
                id="76636cd1-82e2-4aeb-9cfe-51366a8198a2",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        # Example Usage (Synthetics DNS test)
        # Create a new Datadog Synthetics API/DNS test on example.org
        test_dns = datadog.SyntheticsTest("test_dns",
            name="An API test on example.org",
            type="api",
            subtype="dns",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
            ),
            assertions=[datadog.SyntheticsTestAssertionArgs(
                type="recordSome",
                operator="is",
                property="A",
                target="0.0.0.0",
            )],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        # Example Usage (Synthetics Multistep API test)
        # Create a new Datadog Synthetics Multistep API test
        test_multi_step = datadog.SyntheticsTest("test_multi_step",
            name="Multistep API test",
            type="api",
            subtype="multi",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            api_steps=[
                datadog.SyntheticsTestApiStepArgs(
                    name="An API test on example.org",
                    subtype="http",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        method="GET",
                        url="https://www.example.org",
                    ),
                    request_headers={
                        "Content-Type": "application/json",
                        "Authentication": "Token: 1234566789",
                    },
                ),
                datadog.SyntheticsTestApiStepArgs(
                    name="An API test on example.org",
                    subtype="http",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        method="GET",
                        url="http://example.org",
                    ),
                ),
                datadog.SyntheticsTestApiStepArgs(
                    name="A gRPC health check on example.org",
                    subtype="grpc",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        host="example.org",
                        port=443,
                        call_type="healthcheck",
                        service="greeter.Greeter",
                    ),
                ),
                datadog.SyntheticsTestApiStepArgs(
                    name="A gRPC behavior check on example.org",
                    subtype="grpc",
                    assertions=[datadog.SyntheticsTestApiStepAssertionArgs(
                        type="statusCode",
                        operator="is",
                        target="200",
                    )],
                    request_definition=datadog.SyntheticsTestApiStepRequestDefinitionArgs(
                        host="example.org",
                        port=443,
                        call_type="unary",
                        service="greeter.Greeter",
                        method="SayHello",
                        message="{\\"name\\": \\"John\\"}",
                        plain_proto_file=\"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
                    ),
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
                accept_self_signed=True,
            ))
        # Example Usage (Synthetics Browser test)
        # Create a new Datadog Synthetics Browser test starting on https://www.example.org
        test_browser = datadog.SyntheticsTest("test_browser",
            name="A Browser test on example.org",
            type="browser",
            status="paused",
            message="Notify @qa",
            device_ids=["laptop_large"],
            locations=["aws:eu-central-1"],
            tags=[],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                method="GET",
                url="https://www.example.org",
            ),
            browser_steps=[
                datadog.SyntheticsTestBrowserStepArgs(
                    name="Check current url",
                    type="assertCurrentUrl",
                    params=datadog.SyntheticsTestBrowserStepParamsArgs(
                        check="contains",
                        value="datadoghq",
                    ),
                ),
                datadog.SyntheticsTestBrowserStepArgs(
                    name="Test a downloaded file",
                    type="assertFileDownload",
                    params=datadog.SyntheticsTestBrowserStepParamsArgs(
                        file=json.dumps({
                            "md5": "abcdef1234567890",
                            "sizeCheck": {
                                "type": "equals",
                                "value": 1,
                            },
                            "nameCheck": {
                                "type": "contains",
                                "value": ".xls",
                            },
                        }),
                    ),
                ),
            ],
            browser_variables=[
                datadog.SyntheticsTestBrowserVariableArgs(
                    type="text",
                    name="MY_PATTERN_VAR",
                    pattern="{{numeric(3)}}",
                    example="597",
                ),
                datadog.SyntheticsTestBrowserVariableArgs(
                    type="email",
                    name="MY_EMAIL_VAR",
                    pattern="jd8-afe-ydv.{{ numeric(10) }}@synthetics.dtdg.co",
                    example="jd8-afe-ydv.4546132139@synthetics.dtdg.co",
                ),
                datadog.SyntheticsTestBrowserVariableArgs(
                    type="global",
                    name="MY_GLOBAL_VAR",
                    id="76636cd1-82e2-4aeb-9cfe-51366a8198a2",
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=3600,
            ))
        # Example Usage (GRPC API behavior check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # targeting service `greeter.Greeter` with the method `SayHello`
        # and the message {"name": "John"}
        test_grpc_unary = datadog.SyntheticsTest("test_grpc_unary",
            name="GRPC API behavior check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
                call_type="unary",
                service="greeter.Greeter",
                method="SayHello",
                message="{\\"name\\": \\"John\\"}",
                plain_proto_file=\"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
            ),
            request_metadata={
                "header": "value",
            },
            assertions=[
                datadog.SyntheticsTestAssertionArgs(
                    type="responseTime",
                    operator="lessThan",
                    target="2000",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    type="grpcHealthcheckStatus",
                    target="1",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    type="grpcProto",
                    target="proto target",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    property="property",
                    type="grpcMetadata",
                    target="123",
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        # Example Usage (GRPC API health check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # testing the overall health of the service
        test_grpc_health = datadog.SyntheticsTest("test_grpc_health",
            name="GRPC API health check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition=datadog.SyntheticsTestRequestDefinitionArgs(
                host="example.org",
                port=443,
                call_type="healthcheck",
                service="greeter.Greeter",
            ),
            assertions=[
                datadog.SyntheticsTestAssertionArgs(
                    type="responseTime",
                    operator="lessThan",
                    target="2000",
                ),
                datadog.SyntheticsTestAssertionArgs(
                    operator="is",
                    type="grpcHealthcheckStatus",
                    target="1",
                ),
            ],
            options_list=datadog.SyntheticsTestOptionsListArgs(
                tick_every=900,
            ))
        ```

        ## Import

        Synthetics tests can be imported using their public string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsTest:SyntheticsTest fizz abc-123-xyz
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticsTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticsTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestApiStepArgs']]]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestAssertionArgs']]]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserStepArgs']]]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserVariableArgs']]]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestConfigVariableArgs']]]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_list: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestOptionsListArgs']]] = None,
                 request_basicauth: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestBasicauthArgs']]] = None,
                 request_client_certificate: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestClientCertificateArgs']]] = None,
                 request_definition: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestDefinitionArgs']]] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestRequestFileArgs']]]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_proxy: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestProxyArgs']]] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 set_cookie: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subtype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variables_from_script: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticsTestArgs.__new__(SyntheticsTestArgs)

            __props__.__dict__["api_steps"] = api_steps
            __props__.__dict__["assertions"] = assertions
            __props__.__dict__["browser_steps"] = browser_steps
            __props__.__dict__["browser_variables"] = browser_variables
            __props__.__dict__["config_variables"] = config_variables
            __props__.__dict__["device_ids"] = device_ids
            __props__.__dict__["force_delete_dependencies"] = force_delete_dependencies
            if locations is None and not opts.urn:
                raise TypeError("Missing required property 'locations'")
            __props__.__dict__["locations"] = locations
            __props__.__dict__["message"] = message
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["options_list"] = options_list
            __props__.__dict__["request_basicauth"] = request_basicauth
            __props__.__dict__["request_client_certificate"] = request_client_certificate
            __props__.__dict__["request_definition"] = request_definition
            __props__.__dict__["request_files"] = request_files
            __props__.__dict__["request_headers"] = request_headers
            __props__.__dict__["request_metadata"] = request_metadata
            __props__.__dict__["request_proxy"] = request_proxy
            __props__.__dict__["request_query"] = request_query
            __props__.__dict__["set_cookie"] = set_cookie
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["subtype"] = subtype
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["variables_from_script"] = variables_from_script
            __props__.__dict__["monitor_id"] = None
        super(SyntheticsTest, __self__).__init__(
            'datadog:index/syntheticsTest:SyntheticsTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestApiStepArgs']]]]] = None,
            assertions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestAssertionArgs']]]]] = None,
            browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserStepArgs']]]]] = None,
            browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserVariableArgs']]]]] = None,
            config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestConfigVariableArgs']]]]] = None,
            device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            force_delete_dependencies: Optional[pulumi.Input[bool]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            message: Optional[pulumi.Input[str]] = None,
            monitor_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options_list: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestOptionsListArgs']]] = None,
            request_basicauth: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestBasicauthArgs']]] = None,
            request_client_certificate: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestClientCertificateArgs']]] = None,
            request_definition: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestDefinitionArgs']]] = None,
            request_files: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestRequestFileArgs']]]]] = None,
            request_headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            request_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            request_proxy: Optional[pulumi.Input[pulumi.InputType['SyntheticsTestRequestProxyArgs']]] = None,
            request_query: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            set_cookie: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subtype: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            variables_from_script: Optional[pulumi.Input[str]] = None) -> 'SyntheticsTest':
        """
        Get an existing SyntheticsTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestApiStepArgs']]]] api_steps: Steps for multi-step api tests
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestAssertionArgs']]]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserStepArgs']]]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestBrowserVariableArgs']]]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestConfigVariableArgs']]]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        :param pulumi.Input[bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        :param pulumi.Input[str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[int] monitor_id: ID of the monitor associated with the Datadog synthetics test.
        :param pulumi.Input[str] name: Name of Datadog synthetics test.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestBasicauthArgs']] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestClientCertificateArgs']] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestDefinitionArgs']] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SyntheticsTestRequestFileArgs']]]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, Any]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, Any]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input[pulumi.InputType['SyntheticsTestRequestProxyArgs']] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, Any]] request_query: Query arguments name and value map.
        :param pulumi.Input[str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[str] type: Synthetics test type. Valid values are `api`, `browser`.
        :param pulumi.Input[str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticsTestState.__new__(_SyntheticsTestState)

        __props__.__dict__["api_steps"] = api_steps
        __props__.__dict__["assertions"] = assertions
        __props__.__dict__["browser_steps"] = browser_steps
        __props__.__dict__["browser_variables"] = browser_variables
        __props__.__dict__["config_variables"] = config_variables
        __props__.__dict__["device_ids"] = device_ids
        __props__.__dict__["force_delete_dependencies"] = force_delete_dependencies
        __props__.__dict__["locations"] = locations
        __props__.__dict__["message"] = message
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["options_list"] = options_list
        __props__.__dict__["request_basicauth"] = request_basicauth
        __props__.__dict__["request_client_certificate"] = request_client_certificate
        __props__.__dict__["request_definition"] = request_definition
        __props__.__dict__["request_files"] = request_files
        __props__.__dict__["request_headers"] = request_headers
        __props__.__dict__["request_metadata"] = request_metadata
        __props__.__dict__["request_proxy"] = request_proxy
        __props__.__dict__["request_query"] = request_query
        __props__.__dict__["set_cookie"] = set_cookie
        __props__.__dict__["status"] = status
        __props__.__dict__["subtype"] = subtype
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["variables_from_script"] = variables_from_script
        return SyntheticsTest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiSteps")
    def api_steps(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestApiStep']]]:
        """
        Steps for multi-step api tests
        """
        return pulumi.get(self, "api_steps")

    @property
    @pulumi.getter
    def assertions(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestAssertion']]]:
        """
        Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "assertions")

    @property
    @pulumi.getter(name="browserSteps")
    def browser_steps(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestBrowserStep']]]:
        """
        Steps for browser tests.
        """
        return pulumi.get(self, "browser_steps")

    @property
    @pulumi.getter(name="browserVariables")
    def browser_variables(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestBrowserVariable']]]:
        """
        Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "browser_variables")

    @property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestConfigVariable']]]:
        """
        Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "config_variables")

    @property
    @pulumi.getter(name="deviceIds")
    def device_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Required if `type = "browser"`. Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
        """
        return pulumi.get(self, "device_ids")

    @property
    @pulumi.getter(name="forceDeleteDependencies")
    def force_delete_dependencies(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        """
        return pulumi.get(self, "force_delete_dependencies")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence[str]]:
        """
        Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[Optional[str]]:
        """
        A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[int]:
        """
        ID of the monitor associated with the Datadog synthetics test.
        """
        return pulumi.get(self, "monitor_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of Datadog synthetics test.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optionsList")
    def options_list(self) -> pulumi.Output[Optional['outputs.SyntheticsTestOptionsList']]:
        return pulumi.get(self, "options_list")

    @property
    @pulumi.getter(name="requestBasicauth")
    def request_basicauth(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestBasicauth']]:
        """
        The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_basicauth")

    @property
    @pulumi.getter(name="requestClientCertificate")
    def request_client_certificate(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestClientCertificate']]:
        """
        Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_client_certificate")

    @property
    @pulumi.getter(name="requestDefinition")
    def request_definition(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestDefinition']]:
        """
        Required if `type = "api"`. The synthetics test request.
        """
        return pulumi.get(self, "request_definition")

    @property
    @pulumi.getter(name="requestFiles")
    def request_files(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestRequestFile']]]:
        """
        Files to be used as part of the request in the test.
        """
        return pulumi.get(self, "request_files")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Header name and value map.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter(name="requestMetadata")
    def request_metadata(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Metadata to include when performing the gRPC request.
        """
        return pulumi.get(self, "request_metadata")

    @property
    @pulumi.getter(name="requestProxy")
    def request_proxy(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestProxy']]:
        """
        The proxy to perform the test.
        """
        return pulumi.get(self, "request_proxy")

    @property
    @pulumi.getter(name="requestQuery")
    def request_query(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Query arguments name and value map.
        """
        return pulumi.get(self, "request_query")

    @property
    @pulumi.getter(name="setCookie")
    def set_cookie(self) -> pulumi.Output[Optional[str]]:
        """
        Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        """
        return pulumi.get(self, "set_cookie")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subtype(self) -> pulumi.Output[Optional[str]]:
        """
        The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        """
        return pulumi.get(self, "subtype")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Synthetics test type. Valid values are `api`, `browser`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="variablesFromScript")
    def variables_from_script(self) -> pulumi.Output[Optional[str]]:
        """
        Variables defined from JavaScript code for API HTTP tests.
        """
        return pulumi.get(self, "variables_from_script")

