# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TeamPermissionSettingArgs', 'TeamPermissionSetting']

@pulumi.input_type
class TeamPermissionSettingArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 team_id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The set of arguments for constructing a TeamPermissionSetting resource.
        :param pulumi.Input[str] action: The identifier for the action. Valid values are `manage_membership`, `edit`.
        :param pulumi.Input[str] team_id: ID of the team the team permission setting is associated with.
        :param pulumi.Input[str] value: The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "team_id", team_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The identifier for the action. Valid values are `manage_membership`, `edit`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[str]:
        """
        ID of the team the team permission setting is associated with.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _TeamPermissionSettingState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TeamPermissionSetting resources.
        :param pulumi.Input[str] action: The identifier for the action. Valid values are `manage_membership`, `edit`.
        :param pulumi.Input[str] team_id: ID of the team the team permission setting is associated with.
        :param pulumi.Input[str] value: The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the action. Valid values are `manage_membership`, `edit`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the team the team permission setting is associated with.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class TeamPermissionSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog TeamPermissionSetting resource. This can be used to manage Datadog team_permission_setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        foo = datadog.Team("foo",
            description="Example team",
            handle="example-team-updated",
            name="Example Team-updated")
        foo_team_permission_setting = datadog.TeamPermissionSetting("foo",
            team_id=foo.id,
            action="manage_membership",
            value="organization")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The identifier for the action. Valid values are `manage_membership`, `edit`.
        :param pulumi.Input[str] team_id: ID of the team the team permission setting is associated with.
        :param pulumi.Input[str] value: The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamPermissionSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog TeamPermissionSetting resource. This can be used to manage Datadog team_permission_setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        foo = datadog.Team("foo",
            description="Example team",
            handle="example-team-updated",
            name="Example Team-updated")
        foo_team_permission_setting = datadog.TeamPermissionSetting("foo",
            team_id=foo.id,
            action="manage_membership",
            value="organization")
        ```

        :param str resource_name: The name of the resource.
        :param TeamPermissionSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamPermissionSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamPermissionSettingArgs.__new__(TeamPermissionSettingArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(TeamPermissionSetting, __self__).__init__(
            'datadog:index/teamPermissionSetting:TeamPermissionSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'TeamPermissionSetting':
        """
        Get an existing TeamPermissionSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The identifier for the action. Valid values are `manage_membership`, `edit`.
        :param pulumi.Input[str] team_id: ID of the team the team permission setting is associated with.
        :param pulumi.Input[str] value: The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamPermissionSettingState.__new__(_TeamPermissionSettingState)

        __props__.__dict__["action"] = action
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["value"] = value
        return TeamPermissionSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The identifier for the action. Valid values are `manage_membership`, `edit`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        ID of the team the team permission setting is associated with.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The action value. Valid values are dependent on the action. `manage_membership` action allows `admins`, `members`, `organization`, `user_access_manage` values. `edit` action allows `admins`, `members`, `teams_manage` values.
        """
        return pulumi.get(self, "value")

