# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserRoleArgs', 'UserRole']

@pulumi.input_type
class UserRoleArgs:
    def __init__(__self__, *,
                 role_id: pulumi.Input[str],
                 user_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a UserRole resource.
        :param pulumi.Input[str] role_id: ID of the role that the user is assigned to.
        :param pulumi.Input[str] user_id: The ID of the user.
        """
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[str]:
        """
        ID of the role that the user is assigned to.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _UserRoleState:
    def __init__(__self__, *,
                 role_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserRole resources.
        :param pulumi.Input[str] role_id: ID of the role that the user is assigned to.
        :param pulumi.Input[str] user_id: The ID of the user.
        """
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the role that the user is assigned to.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class UserRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Datadog UserRole resource. This can be used to create and manage Datadog User Roles. Conflicts may occur if used together with the `User` resource's `roles` attribute or the `ServiceAccount` resource's `roles` attribute. This resource is in beta and is subject to change.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        monitor_writer_role = datadog.Role("monitor_writer_role",
            name="Monitor Writer Role",
            permissions=[datadog.RolePermissionArgs(
                id=bar["permissions"]["monitorsWrite"],
            )])
        new_user = datadog.User("new_user", email="new@example.com")
        # Create new user_role resource
        new_user_with_monitor_writer_role = datadog.UserRole("new_user_with_monitor_writer_role",
            role_id=monitor_writer_role.id,
            user_id=new_user.id)
        ```

        ## Import

        This resource is imported using user_id and role_id seperated by `:`.

        ```sh
        $ pulumi import datadog:index/userRole:UserRole user_with_admin_role "${role_id}:${user_id}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role_id: ID of the role that the user is assigned to.
        :param pulumi.Input[str] user_id: The ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog UserRole resource. This can be used to create and manage Datadog User Roles. Conflicts may occur if used together with the `User` resource's `roles` attribute or the `ServiceAccount` resource's `roles` attribute. This resource is in beta and is subject to change.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        monitor_writer_role = datadog.Role("monitor_writer_role",
            name="Monitor Writer Role",
            permissions=[datadog.RolePermissionArgs(
                id=bar["permissions"]["monitorsWrite"],
            )])
        new_user = datadog.User("new_user", email="new@example.com")
        # Create new user_role resource
        new_user_with_monitor_writer_role = datadog.UserRole("new_user_with_monitor_writer_role",
            role_id=monitor_writer_role.id,
            user_id=new_user.id)
        ```

        ## Import

        This resource is imported using user_id and role_id seperated by `:`.

        ```sh
        $ pulumi import datadog:index/userRole:UserRole user_with_admin_role "${role_id}:${user_id}"
        ```

        :param str resource_name: The name of the resource.
        :param UserRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserRoleArgs.__new__(UserRoleArgs)

            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserRole, __self__).__init__(
            'datadog:index/userRole:UserRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role_id: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'UserRole':
        """
        Get an existing UserRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role_id: ID of the role that the user is assigned to.
        :param pulumi.Input[str] user_id: The ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserRoleState.__new__(_UserRoleState)

        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["user_id"] = user_id
        return UserRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[str]:
        """
        ID of the role that the user is assigned to.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

