
import pytest

@pytest.fixture
def association_counts_response():
    return {'responseHeader': {'QTime': 2, 'params': {'facet.query': ['(category:"biolink:DiseaseToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GeneToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:PairwiseGeneToGeneInteraction") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GeneToPathwayAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GeneToExpressionSiteAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GeneToGeneHomologyAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:ChemicalToPathwayAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:MacromolecularMachineToMolecularActivityAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:MacromolecularMachineToCellularComponentAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:MacromolecularMachineToBiologicalProcessAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:CausalGeneToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:CorrelatedGeneToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:VariantToGeneAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:VariantToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:ChemicalOrDrugOrTreatmentToDiseaseOrPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:VariantToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToGeneAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToVariantAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")', '(category:"biolink:DiseaseToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GeneToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:PairwiseGeneToGeneInteraction") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GeneToPathwayAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GeneToExpressionSiteAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GeneToGeneHomologyAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:ChemicalToPathwayAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:MacromolecularMachineToMolecularActivityAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:MacromolecularMachineToCellularComponentAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:MacromolecularMachineToBiologicalProcessAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:CausalGeneToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:CorrelatedGeneToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:VariantToGeneAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:VariantToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:ChemicalOrDrugOrTreatmentToDiseaseOrPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:VariantToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToGeneAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")', '(category:"biolink:GenotypeToVariantAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")'], 'mm': '100%', 'q': '*:*', 'defType': 'edismax', 'facet_min_count': '1', 'hl': 'false', 'start': '0', 'q.op': 'AND', 'fq': 'subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121" OR object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121"', 'facet.mincount': '1', 'rows': '20', 'facet': 'true'}}, 'response': {'num_found': 8470, 'start': 0, 'docs': [{'id': 'uuid:5747da89-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0000501'], 'negated': False, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0012215', 'object': 'HP:0100303', 'original_subject': 'OMIM:609200', 'subject_label': 'myofibrillar myopathy 3', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0002921', 'MONDO:0020120', 'MONDO:0012215', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0015151', 'MONDO:0700096', 'MONDO:0016971', 'MONDO:0020121', 'MONDO:0018943', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'myofibrillar myopathy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'limb-girdle muscular dystrophy', 'congenital structural myopathy', 'neuromuscular disease', 'autosomal dominant disease', 'progressive muscular dystrophy', 'distal myopathy', 'congenital myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'muscular dystrophy, limb-girdle, autosomal dominant', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'myofibrillar myopathy 3', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'object_label': 'Muscle fiber cytoplasmatic inclusion bodies', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002576', 'BFO:0000040', 'UPHENO:0002577', 'UBERON:0002050', 'UBERON:0002329', 'UBERON:0017650', 'UBERON:0000922', 'UBERON:0000307', 'UPHENO:0002526', 'UPHENO:0002731', 'BFO:0000002', 'UPHENO:0004545', 'UPHENO:0003432', 'UPHENO:0076692', 'UBERON:0000061', 'UBERON:0034923', 'UBERON:0000926', 'UBERON:0007503', 'UBERON:0000486', 'UPHENO:0004143', 'HP:0000118', 'UPHENO:0003022', 'UPHENO:0088180', 'UPHENO:0003234', 'CL:0000255', 'UBERON:0007285', 'UBERON:0000923', 'HP:0003011', 'HP:0033127', 'UPHENO:0002564', 'UPHENO:0004969', 'UPHENO:0003160', 'UPHENO:0002976', 'UBERON:0000477', 'UBERON:0003077', 'UBERON:0013701', 'UBERON:0013702', 'HP:0004303', 'UPHENO:0003372', 'UPHENO:0003191', 'UBERON:0002385', 'UBERON:0001630', 'GO:0005622', 'UBERON:0009142', 'UBERON:0001015', 'UPHENO:0004892', 'UPHENO:0002530', 'BFO:0000004', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0015212', 'UBERON:0005256', 'UPHENO:0001001', 'UPHENO:0087047', 'UPHENO:0003047', 'UPHENO:0002720', 'UPHENO:0005135', 'UPHENO:0002926', 'BFO:0000001', 'UBERON:0000467', 'UBERON:0010316', 'GO:0005575', 'UBERON:0011676', 'UPHENO:0002567', 'UPHENO:0002541', 'UPHENO:0086477', 'UPHENO:0087663', 'UPHENO:0076710', 'UBERON:0010000', 'UBERON:0000062', 'HP:0011805', 'UPHENO:0086482', 'UPHENO:0088123', 'UPHENO:0002897', 'UPHENO:0086505', 'UPHENO:0002963', 'UPHENO:0002571', 'BFO:0000002', 'CL:0000000', 'UBERON:0018254', 'UBERON:0003059', 'UBERON:0004120', 'UBERON:0005090', 'GO:0110165', 'UBERON:0000468', 'UBERON:0011216', 'UPHENO:0003163', 'UPHENO:0002816', 'UPHENO:0001003', 'UBERON:0001062', 'UBERON:0001134', 'UPHENO:0087665', 'UPHENO:0086172', 'HP:0100299', 'BFO:0000001', 'BFO:0000004', 'UBERON:0006598', 'UBERON:0002036', 'UBERON:0014892', 'GO:0016234', 'UPHENO:0087660', 'UPHENO:0002542', 'UBERON:0003082', 'UBERON:0000483', 'UBERON:0005291', 'UBERON:0003104', 'HP:0000001', 'UPHENO:0005141', 'UPHENO:0081581', 'UPHENO:0002554', 'HP:0100303', 'UBERON:0001062', 'BFO:0000040', 'UBERON:0000475', 'UPHENO:0001002', 'UPHENO:0002949', 'UBERON:0005423', 'RO:0002577', 'UPHENO:0004680', 'UPHENO:0087849', 'UPHENO:0002536', 'UPHENO:0003413', 'UBERON:0000383', 'CL:0000188', 'UBERON:0007524', 'UBERON:0002100', 'UPHENO:0004900', 'UPHENO:0003025', 'UPHENO:0004885', 'UPHENO:0003081', 'UPHENO:0002568', 'UPHENO:0003182', 'UBERON:0000479'], 'object_closure_label': ['embryo phenotype', 'developing anatomical structure phenotype', 'myotome morphology phenotype', 'mesoderm morphology phenotype', 'independent continuant', 'multicellular anatomical structure phenotype', 'continuant', 'system', 'germ layer morphology phenotype', 'material anatomical entity', 'anatomical system', 'germ layer / neural crest', 'embryo morphology phenotype', 'cell phenotype', 'Muscle fiber inclusion bodies', 'muscle organ phenotype', 'somite phenotype', 'musculature of body phenotype', 'anatomical entity morphology phenotype', 'epithelial vesicle phenotype', 'myotome phenotype', 'organ system subdivision phenotype', 'organism subdivision', 'germ layer / neural crest phenotype', 'mesenchyme morphology phenotype', 'skeletal musculature phenotype', 'organism subdivision phenotype', 'independent continuant', 'presumptive structure', 'striated muscle tissue', 'skeletal muscle organ, vertebrate', 'inclusion body', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'trunk mesenchyme phenotype', 'entity', 'anatomical entity', 'material entity', 'paraxial mesoderm', 'main body axis', 'body proper', 'skeletal muscle tissue', 'phenotypic effect', 'anatomical system phenotype', 'anatomical structure', 'disconnected anatomical group', 'organ', 'blastula', 'material entity', 'skeletal muscle organ, vertebrate phenotype', 'presomitic mesoderm morphology phenotype', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'muscle tissue', 'muscle organ', 'intracellular anatomical structure', 'entire embryonic mesenchyme', 'musculature of body', 'cell of skeletal muscle', 'developing mesenchymal structure phenotype', 'skeletal muscle tissue morphology phenotype', 'muscle structure phenotype', 'subdivision of organism along main body axis phenotype', 'mesoderm phenotype', 'epithelium phenotype', 'tissue', 'Abnormality of the musculature', 'taxon specific phenotype', 'embryonic structure phenotype', 'mesoderm-derived structure phenotype', 'Muscle fiber cytoplasmatic inclusion bodies', 'embryonic structure', 'somite', 'developing mesenchymal structure', 'cellular_component', 'epithelium', 'embryonic tissue', 'mesenchyme', 'All', 'multicellular organism phenotype', 'muscle organ morphology phenotype', 'lateral structure', 'musculature', 'phenotype', 'muscle tissue phenotype', 'multilaminar epithelium phenotype', 'multicellular organism morphology phenotype', 'trunk phenotype', 'entity', 'cell', 'skeletal musculature', 'presomitic mesoderm', 'mesoderm-derived structure', 'muscle structure', 'cellular anatomical structure', 'trunk mesenchyme', 'Abnormal muscle fiber morphology', 'organ phenotype', 'germ layer phenotype', 'eukaryotic cell', 'presumptive paraxial mesoderm', 'germ layer', 'anatomical cluster phenotype', 'tissue phenotype', 'paraxial mesoderm phenotype', 'presomitic mesoderm phenotype', 'anatomical cluster', 'myotome', 'subdivision of organism along main body axis', 'mesoderm', 'epithelial vesicle', 'multilaminar epithelium', 'presumptive paraxial mesoderm phenotype', 'Phenotypic abnormality', 'mesenchyme phenotype', 'dense mesenchyme tissue phenotype', 'cell of skeletal muscle morphology phenotype', 'anatomical entity', 'lateral structure phenotype', 'continuant', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'developing anatomical structure', 'multicellular organism', 'organ system subdivision', 'embryo', 'dense mesenchyme tissue', 'trunk', 'Abnormal skeletal muscle morphology', 'paraxial mesoderm morphology phenotype', 'embryonic tissue morphology phenotype', 'anatomical entity phenotype', 'multicellular anatomical structure'], 'evidence_count': 1, 'grouping_key': 'MONDO:0012215|False|biolink:has_phenotype|HP:0100303', 'highlighting': None}, {'id': 'uuid:5747da8e-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0000501'], 'negated': False, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0012215', 'object': 'HP:0002600', 'original_subject': 'OMIM:609200', 'subject_label': 'myofibrillar myopathy 3', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0002921', 'MONDO:0020120', 'MONDO:0012215', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0015151', 'MONDO:0700096', 'MONDO:0016971', 'MONDO:0020121', 'MONDO:0018943', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'myofibrillar myopathy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'limb-girdle muscular dystrophy', 'congenital structural myopathy', 'neuromuscular disease', 'autosomal dominant disease', 'progressive muscular dystrophy', 'distal myopathy', 'congenital myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'muscular dystrophy, limb-girdle, autosomal dominant', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'myofibrillar myopathy 3', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'object_label': 'Hyporeflexia of lower limbs', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0049622', 'UPHENO:0002433', 'UPHENO:0049708', 'UPHENO:0003065', 'UBERON:0001016', 'UBERON:0000922', 'HP:0002814', 'UPHENO:0049699', 'HP:0012638', 'UPHENO:0050875', 'UBERON:0000061', 'UBERON:0002103', 'UBERON:0005418', 'UPHENO:0004456', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0049587', 'UPHENO:0002830', 'UBERON:0004709', 'UBERON:0002101', 'UBERON:0010709', 'UBERON:0005420', 'NBO:0000388', 'UPHENO:0003095', 'UPHENO:0004467', 'UPHENO:0001003', 'UBERON:0004357', 'UBERON:0000026', 'UBERON:0000154', 'GO:0060004', 'GO:0050881', 'NBO:0000313', 'GO:0050877', 'UPHENO:0077910', 'UPHENO:0002944', 'UPHENO:0003516', 'HP:0031826', 'UPHENO:0002945', 'UPHENO:0002553', 'BFO:0000015', 'BFO:0000040', 'HP:0001265', 'UPHENO:0001002', 'UPHENO:0003411', 'UPHENO:0053473', 'UPHENO:0002530', 'UPHENO:0003049', 'UPHENO:0049874', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0003102', 'UBERON:0002529', 'UPHENO:0001001', 'UPHENO:0052915', 'UPHENO:0052178', 'UPHENO:7000774', 'HP:0001315', 'UPHENO:0049703', 'UPHENO:0079826', 'UPHENO:0002267', 'UPHENO:0002926', 'HP:0100022', 'UPHENO:0002747', 'UPHENO:0002541', 'UPHENO:0002585', 'UPHENO:0050606', 'BFO:0000004', 'UBERON:0000467', 'UBERON:0000468', 'UBERON:0010758', 'UBERON:0006058', 'BFO:0000003', 'UPHENO:0005433', 'UPHENO:0051276', 'HP:0002600', 'UPHENO:0002571', 'BFO:0000002', 'UBERON:0008784', 'NBO:0000403', 'NBO:0000001', 'UPHENO:0003163', 'UPHENO:0005625', 'UPHENO:0050079', 'UPHENO:0079833', 'UBERON:0001062', 'BFO:0000001', 'UBERON:0010538', 'UPHENO:7000780', 'BFO:0000040', 'UPHENO:0002963', 'BFO:0000001', 'UPHENO:0053022', 'BFO:0000004', 'UBERON:0006598', 'UBERON:0000978', 'UPHENO:0050613', 'HP:0000707', 'UPHENO:0003366', 'HP:0040064', 'UBERON:0004708', 'UBERON:0010707', 'NBO:0000389', 'HP:0000001', 'UPHENO:0002861', 'UBERON:0000475', 'BFO:0000002', 'UPHENO:0077943', 'UPHENO:0002949', 'UPHENO:0003070', 'UPHENO:0002385', 'GO:0008150', 'RO:0002577', 'GO:0050896', 'GO:0032501', 'GO:0040007', 'UPHENO:0050106', 'UPHENO:0082875', 'UPHENO:0002269', 'UPHENO:0002536', 'UPHENO:0004523', 'UBERON:0005423', 'UBERON:0010000', 'UPHENO:0049586', 'UPHENO:0080377', 'UPHENO:0004900', 'UPHENO:0005629', 'UPHENO:0005491', 'UPHENO:0003334', 'UPHENO:0002568', 'UPHENO:0077889', 'UBERON:0001062', 'BFO:0000003', 'UBERON:0002050', 'UBERON:0004347', 'GO:0009605', 'GO:0050879', 'GO:0007610', 'GO:0003008', 'GO:0050882', 'NBO:0000338', 'GO:0050905'], 'object_closure_label': ['response to stimulus phenotype', 'biological_process rate phenotype', 'embryo phenotype', 'appendage phenotype', 'developing anatomical structure phenotype', 'lower limb segment phenotype', 'voluntary musculoskeletal movement phenotype', 'multi-limb segment region phenotype', 'growth phenotype', 'multicellular anatomical structure phenotype', 'continuant', 'multicellular anatomical structure', 'system', 'response to stimulus', 'multicellular organismal process', 'growth', 'reflex', 'musculoskeletal movement', 'behavior process', 'nervous system process', 'multicellular organismal process phenotype', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'continuant', 'limb bud phenotype', 'Abnormality of limbs', 'material anatomical entity', 'left isomerism; left-sided isomerism', 'Abnormality of movement', 'surface structure phenotype', 'nervous system process phenotype', 'embryonic structure', 'organism subdivision', 'limb segment', 'paired limb/fin bud phenotype', 'material anatomical entity physiology phenotype', 'organism subdivision phenotype', 'independent continuant', 'presumptive structure', 'presumptive structure phenotype', 'paired limb/fin phenotype', 'behavior process phenotype', 'entity', 'anatomical entity', 'entity', 'paired limb/fin bud', 'appendage', 'posterior region of body', 'paired limb/fin segment', 'involuntary movement behavior', 'decreased biological_process in pelvic complex', 'leg phenotype', 'anatomical structure physiology phenotype', 'anatomical structure', 'multicellular organism', 'subdivision of organism along appendicular axis', 'Hyporeflexia', 'decreased qualitatively response to external stimulus', 'material anatomical entity phenotype', 'biological_process phenotype', 'anatomical structure phenotype', 'material entity', 'multi-limb segment region', 'lower limb segment', 'voluntary movement behavior', 'body part movement', 'pelvic appendage phenotype', 'structure with developmental contribution from neural crest phenotype', 'decreased qualitatively reflex', 'limb bud', 'Abnormality of the lower limb', 'pelvic appendage bud phenotype', 'decreased response to external stimulus', 'decreased response to stimulus', 'embryonic structure phenotype', 'All', 'phenotypic effect', 'hindlimb phenotype', 'decreased biological_process', 'reflex phenotype', 'Hyporeflexia of lower limbs', 'multicellular organism phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'surface structure', 'nervous system', 'leg', 'phenotype', 'decreased qualitatively response to stimulus', 'decreased qualitatively biological_process', 'reflex', 'nervous system phenotype', 'voluntary musculoskeletal movement', 'kinesthetic behavior', 'neuromuscular process', 'decreased reflex in pelvic complex', 'limb segment phenotype', 'material entity', 'anatomical system phenotype', 'paired limb/fin segment phenotype', 'anatomical entity', 'occurrent', 'pelvic appendage', 'limb', 'pelvic complex', 'pelvic appendage bud', 'behavior phenotype', 'musculoskeletal movement phenotype', 'Reduced tendon reflexes', 'system process phenotype', 'decreased biological_process in multicellular organism', 'limb phenotype', 'process', 'paired limb/fin', 'appendage girdle complex', 'hindlimb', 'hindlimb bud', 'reflexive behavior', 'occurrent', 'Abnormal reflex', 'Phenotypic abnormality', 'lateral structure phenotype', 'nervous system physiology phenotype', 'multicellular organismal movement phenotype', 'Abnormality of the nervous system', 'voluntary movement behavior phenotype', 'response to external stimulus', 'multicellular organismal movement', 'behavior', 'system process', 'decreased reflex', 'response to external stimulus phenotype', 'taxon specific phenotype', 'Abnormal nervous system physiology', 'neuromuscular process phenotype', 'biological_process', 'embryo', 'subdivision of organism along appendicular axis phenotype', 'hindlimb bud phenotype', 'anatomical entity phenotype', 'independent continuant', 'developing anatomical structure', 'anatomical system'], 'evidence_count': 1, 'grouping_key': 'MONDO:0012215|False|biolink:has_phenotype|HP:0002600', 'highlighting': None}, {'id': 'uuid:430c942d-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'disease_context_qualifier': 'MONDO:0013835', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:37276', 'object': 'HP:0008551', 'original_subject': 'NCBIGene:729920', 'subject_label': 'CRPPA', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Microtia', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0080110', 'UBERON:0004456', 'UPHENO:0002526', 'BFO:0000002', 'UPHENO:0002866', 'UPHENO:0076692', 'UBERON:0034923', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002928', 'HP:0031703', 'UPHENO:0076730', 'UPHENO:0080111', 'HP:0008771', 'UPHENO:0003412', 'UBERON:0015203', 'UBERON:0013701', 'UBERON:0013702', 'HP:0000377', 'UBERON:0000465', 'UBERON:0001032', 'UPHENO:0002903', 'HP:0008551', 'UPHENO:0081091', 'BFO:0000004', 'UPHENO:0002525', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0000468', 'UPHENO:0080079', 'UPHENO:0002764', 'UPHENO:0086699', 'UPHENO:0002926', 'BFO:0000001', 'UBERON:0000467', 'UBERON:0011676', 'UPHENO:0002844', 'UBERON:0000062', 'UBERON:0001444', 'UBERON:0007811', 'UBERON:0000020', 'UPHENO:0002963', 'UPHENO:0002553', 'BFO:0000002', 'UPHENO:0080300', 'BFO:0000040', 'UPHENO:0001003', 'UBERON:0001062', 'UPHENO:0004494', 'UPHENO:0002901', 'BFO:0000001', 'BFO:0000004', 'UPHENO:0086589', 'HP:0008772', 'UPHENO:0002536', 'UBERON:0001690', 'UBERON:0000153', 'HP:0000001', 'UPHENO:0005986', 'UPHENO:0087907', 'UPHENO:0081119', 'UPHENO:0002530', 'UPHENO:0081581', 'UBERON:0001062', 'BFO:0000040', 'UBERON:0000475', 'UPHENO:0001001', 'UPHENO:0001002', 'HP:0000356', 'UPHENO:0002949', 'UBERON:0002105', 'UPHENO:0041226', 'UBERON:0000061', 'UBERON:0010000', 'UBERON:0000033', 'UPHENO:0003025', 'HP:0000598', 'UPHENO:0002568', 'UBERON:0001691'], 'object_closure_label': ['shape of external ear phenotype', 'head morphology phenotype', 'external ear hypoplasia', 'anatomical entity hypoplasia', 'independent continuant', 'multicellular anatomical structure phenotype', 'continuant', 'multicellular anatomical structure', 'vestibulo-auditory system', 'shape of anatomical entity phenotype', 'craniocervical region morphology phenotype', 'sense organ phenotype', 'anatomical entity phenotype', 'anatomical system', 'head phenotype', 'Abnormal ear morphology', 'anatomical entity morphology phenotype', 'organism subdivision', 'Abnormality of the ear', 'external ear morphology phenotype', 'organism subdivision phenotype', 'independent continuant', 'material entity', 'entity', 'anatomical entity', 'material entity', 'main body axis', 'body proper', 'shape of continuant phenotype', 'phenotypic effect', 'subdivision of head phenotype', 'Abnormality of the outer ear', 'anatomical system phenotype', 'structure with developmental contribution from neural crest phenotype', 'material anatomical entity', 'disconnected anatomical group', 'organ', 'subdivision of head', 'craniocervical region', 'sense organ', 'ear phenotype', 'Microtia', 'anatomical structure phenotype', 'sensory system', 'phenotype', 'craniocervical region phenotype', 'subdivision of organism along main body axis phenotype', 'material anatomical entity phenotype', 'external ear', 'sensory system phenotype', 'Aplasia/Hypoplasia of the external ear', 'vestibulo-auditory system phenotype', 'taxon specific phenotype', 'anterior region of body', 'All', 'multicellular organism phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'entire sense organ system', 'aplasia or hypoplasia of anatomical entity', 'multicellular organism morphology phenotype', 'entity', 'organ phenotype', 'external ear phenotype', 'aplasia or hypoplasia of external ear', 'aplasia or hypoplasia of ear', 'non-connected functional system', 'ear', 'subdivision of organism along main body axis', 'Abnormal pinna morphology', 'Phenotypic abnormality', 'lateral structure phenotype', 'ear morphology phenotype', 'anatomical entity', 'continuant', 'head', 'Aplasia/Hypoplasia of the ear', 'anatomical structure', 'multicellular organism'], 'disease_context_qualifier_label': 'muscular dystrophy-dystroglycanopathy (congenital with brain and eye anomalies), type A, 7', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0045010', 'MONDO:0020120', 'MONDO:0100530', 'MONDO:0016155', 'MONDO:0018282', 'MONDO:0000001', 'MONDO:0018276', 'MONDO:0000171', 'MONDO:0013835', 'MONDO:0005066', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0017741', 'MONDO:0020121', 'MONDO:0024322', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0015286', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081', 'MONDO:0019052'], 'disease_context_qualifier_closure_label': ['hereditary skeletal muscle disorder', 'congenital disorder of glycosylation', 'muscular dystrophy', 'skeletal muscle disorder', 'myopathy caused by variation in CRPPA', 'metabolic disease', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'disorder of protein O-glycosylation', 'neuromuscular disease', 'congenital muscular dystrophy', 'glycoprotein metabolism disease', 'muscular dystrophy-dystroglycanopathy (congenital with brain and eye anomalies), type A, 7', 'myopathy', 'muscular dystrophy-dystroglycanopathy, type A', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'inborn errors of metabolism', 'qualitative or quantitative defects of protein involved in O-glycosylation of alpha-dystroglycan', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'neuromuscular disease caused by qualitative or quantitative defects of alpha-dystroglycan', 'disease', 'muscular dystrophy-dystroglycanopathy', 'disorder of glycosylation', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'HGNC:37276||biolink:has_phenotype|HP:0008551', 'highlighting': None}, {'id': 'uuid:5747ed2a-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:orphanet', 'has_evidence': ['ECO:0000304'], 'negated': False, 'frequency_qualifier': 'HP:0040281', 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0011787', 'object': 'HP:0003701', 'original_subject': 'Orphanet:34515', 'subject_label': 'autosomal recessive limb-girdle muscular dystrophy type 2I', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0045010', 'MONDO:0006025', 'MONDO:0020120', 'MONDO:0016155', 'MONDO:0018282', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0005066', 'MONDO:0015152', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0016971', 'MONDO:0017741', 'MONDO:0020121', 'MONDO:0011787', 'MONDO:0024322', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0015286', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0100545', 'MONDO:0002081', 'MONDO:0016156', 'MONDO:0019052', 'MONDO:0700066'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'congenital disorder of glycosylation', 'muscular dystrophy', 'skeletal muscle disorder', 'metabolic disease', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'qualitative or quantitative defects of FKRP', 'limb-girdle muscular dystrophy', 'disorder of protein O-glycosylation', 'autosomal recessive disease', 'neuromuscular disease', 'progressive muscular dystrophy', 'glycoprotein metabolism disease', 'myopathy', 'myopathy caused by variation in FKRP', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'inborn errors of metabolism', 'qualitative or quantitative defects of protein involved in O-glycosylation of alpha-dystroglycan', 'muscle tissue disorder', 'nervous system disorder', 'autosomal recessive limb-girdle muscular dystrophy', 'congenital nervous system disorder', 'neuromuscular disease caused by qualitative or quantitative defects of alpha-dystroglycan', 'disease', 'autosomal genetic disease', 'autosomal recessive limb-girdle muscular dystrophy type 2I', 'disorder of glycosylation', 'hereditary disease'], 'object_label': 'Proximal muscle weakness', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002526', 'UPHENO:0003432', 'HP:0000118', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UPHENO:0002385', 'HP:0003011', 'HP:0033127', 'UPHENO:0001003', 'UPHENO:0002976', 'UPHENO:0080555', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0001002', 'UPHENO:0002530', 'UPHENO:0002568', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0000468', 'UPHENO:0003047', 'UPHENO:0080556', 'UPHENO:0002267', 'UBERON:0000467', 'UPHENO:0002320', 'BFO:0000004', 'UBERON:0010000', 'UBERON:0000062', 'UPHENO:0001001', 'HP:0003701', 'UPHENO:0002963', 'HP:0011804', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UPHENO:0002816', 'BFO:0000001', 'BFO:0000040', 'BFO:0000001', 'BFO:0000004', 'UPHENO:0002536', 'HP:0000001', 'BFO:0000040', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0082875', 'UPHENO:0002308', 'UBERON:0001062', 'UBERON:0000061', 'UBERON:0000383', 'HP:0001324', 'UBERON:0001062'], 'object_closure_label': ['Abnormal muscle physiology', 'continuant', 'anatomical entity physiology phenotype', 'continuant', 'anatomical entity phenotype', 'material anatomical entity', 'anatomical system', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'material anatomical entity physiology phenotype', 'anatomical entity', 'independent continuant', 'muscle organ physiology phenotype', 'decreased anatomical entity strength', 'entity', 'entity', 'material entity', 'anatomical system phenotype', 'organ', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'muscle organ', 'musculature of body', 'muscle structure phenotype', 'Muscle weakness', 'Abnormality of the musculature', 'All', 'phenotypic effect', 'multicellular organism phenotype', 'musculature', 'multicellular anatomical structure physiology phenotype', 'muscle structure', 'organ phenotype', 'material entity', 'anatomical entity', 'decreased muscle organ strength', 'anatomical structure physiology phenotype', 'phenotype', 'Phenotypic abnormality', 'organ physiology phenotype', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'organ system subdivision', 'Proximal muscle weakness', 'independent continuant', 'multicellular anatomical structure phenotype', 'anatomical structure', 'multicellular anatomical structure', 'multicellular organism'], 'frequency_qualifier_label': 'Very frequent', 'frequency_qualifier_category': 'biolink:PhenotypicFeature', 'frequency_qualifier_namespace': 'HP', 'evidence_count': 1, 'grouping_key': 'MONDO:0011787|False|biolink:has_phenotype|HP:0003701', 'highlighting': None}, {'id': 'uuid:582da20a-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:orphanet', 'has_evidence': ['ECO:0000304'], 'negated': False, 'frequency_qualifier': 'HP:0040282', 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0009677', 'object': 'HP:0100284', 'original_subject': 'Orphanet:353', 'subject_label': 'autosomal recessive limb-girdle muscular dystrophy type 2C', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0005267', 'MONDO:0006025', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0005217', 'MONDO:0015152', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0016971', 'MONDO:0020121', 'MONDO:0004995', 'MONDO:0016333', 'MONDO:0003939', 'MONDO:0016140', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0009677', 'MONDO:0000591', 'MONDO:0004994', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0005021', 'MONDO:0016143', 'MONDO:0100547', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['qualitative or quantitative defects of gamma-sarcoglycan', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'cardiovascular disorder', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'limb-girdle muscular dystrophy', 'autosomal recessive disease', 'neuromuscular disease', 'dilated cardiomyopathy', 'progressive muscular dystrophy', 'sarcoglycanopathy', 'autosomal recessive limb-girdle muscular dystrophy type 2C', 'familial cardiomyopathy', 'familial dilated cardiomyopathy', 'cardiomyopathy', 'heart disorder', 'myopathy', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'intrinsic cardiomyopathy', 'muscle tissue disorder', 'nervous system disorder', 'autosomal recessive limb-girdle muscular dystrophy', 'disease', 'autosomal genetic disease', 'cardiogenetic disease', 'hereditary disease'], 'object_label': 'EMG: myotonic discharges', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002526', 'UPHENO:0003432', 'UBERON:0000061', 'HP:0000118', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UPHENO:0002385', 'HP:0003011', 'HP:0033127', 'UPHENO:0001003', 'UPHENO:0002976', 'BFO:0000002', 'BFO:0000001', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0001002', 'UPHENO:0002530', 'UPHENO:0002525', 'UBERON:0000465', 'UPHENO:0003047', 'UPHENO:0002267', 'BFO:0000001', 'UPHENO:0002320', 'HP:0003457', 'UBERON:0010000', 'UBERON:0000467', 'UBERON:0000062', 'UBERON:0000468', 'UPHENO:0001001', 'UPHENO:0002963', 'HP:0011804', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UPHENO:0002816', 'HP:0100284', 'UBERON:0001062', 'BFO:0000040', 'BFO:0000004', 'UPHENO:0002536', 'HP:0000001', 'BFO:0000004', 'UPHENO:0002949', 'UPHENO:0082875', 'UPHENO:0002308', 'UBERON:0000383', 'UPHENO:0002568', 'UBERON:0001062'], 'object_closure_label': ['EMG abnormality', 'multicellular anatomical structure phenotype', 'Abnormal muscle physiology', 'continuant', 'anatomical entity physiology phenotype', 'anatomical entity phenotype', 'material anatomical entity', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'material anatomical entity physiology phenotype', 'independent continuant', 'muscle organ physiology phenotype', 'anatomical entity', 'continuant', 'anatomical system phenotype', 'anatomical structure', 'organ', 'multicellular organism', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'material entity', 'muscle organ', 'musculature of body', 'muscle structure phenotype', 'Abnormality of the musculature', 'All', 'phenotypic effect', 'multicellular organism phenotype', 'musculature', 'multicellular anatomical structure physiology phenotype', 'entity', 'muscle structure', 'organ phenotype', 'material entity', 'anatomical entity', 'anatomical structure physiology phenotype', 'phenotype', 'Phenotypic abnormality', 'organ physiology phenotype', 'EMG: myotonic discharges', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'independent continuant', 'entity', 'organ system subdivision', 'multicellular anatomical structure', 'anatomical system'], 'frequency_qualifier_label': 'Frequent', 'frequency_qualifier_category': 'biolink:PhenotypicFeature', 'frequency_qualifier_namespace': 'HP', 'evidence_count': 1, 'grouping_key': 'MONDO:0009677|False|biolink:has_phenotype|HP:0100284', 'highlighting': None}, {'id': 'urn:uuid:3b87e39a-8aef-4013-861c-8ce44b440c74', 'predicate': 'biolink:subclass_of', 'category': 'biolink:Association', 'agent_type': 'not_provided', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:phenio'], 'knowledge_level': 'not_provided', 'primary_knowledge_source': 'infores:mondo', 'provided_by': 'phenio_edges', 'subject': 'MONDO:0030355', 'object': 'MONDO:0001347', 'subject_label': 'facioscapulohumeral muscular dystrophy 4, digenic', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0030355', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0001347', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'facioscapulohumeral muscular dystrophy', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'progressive muscular dystrophy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'disease', 'facioscapulohumeral muscular dystrophy 4, digenic', 'hereditary disease'], 'object_label': 'facioscapulohumeral muscular dystrophy', 'object_category': 'biolink:Disease', 'object_namespace': 'MONDO', 'object_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0001347', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0100545', 'MONDO:0002081'], 'object_closure_label': ['hereditary skeletal muscle disorder', 'facioscapulohumeral muscular dystrophy', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'progressive muscular dystrophy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'disease', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'MONDO:0030355||biolink:subclass_of|MONDO:0001347', 'highlighting': None}, {'id': 'uuid:4341f4cb-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'disease_context_qualifier': 'MONDO:0011181', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:691', 'object': 'HP:0000646', 'original_subject': 'NCBIGene:401', 'subject_label': 'PHOX2A', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Amblyopia', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0087661', 'UPHENO:0002902', 'HP:0012373', 'UPHENO:0052162', 'BFO:0000001', 'UBERON:0002050', 'UBERON:0001048', 'UBERON:0010312', 'UBERON:0004456', 'UBERON:0000970', 'UBERON:0010230', 'UBERON:0000307', 'UPHENO:0002526', 'UPHENO:0002866', 'UPHENO:0087852', 'UPHENO:0049699', 'UPHENO:0003021', 'UPHENO:0004433', 'UBERON:0000061', 'UBERON:0034923', 'UBERON:0000924', 'UPHENO:0004888', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002928', 'UPHENO:0004064', 'UPHENO:0002386', 'UPHENO:0049587', 'UPHENO:0003236', 'UPHENO:0052159', 'UPHENO:7000490', 'UBERON:0000923', 'UBERON:0001003', 'GO:0007601', 'UPHENO:0002352', 'UPHENO:0005030', 'UPHENO:0001003', 'UPHENO:0002976', 'UBERON:0015203', 'UBERON:0010164', 'UBERON:3000961', 'UBERON:0007376', 'UBERON:0002346', 'UBERON:0013701', 'UBERON:0013702', 'UBERON:0001444', 'GO:0050877', 'UPHENO:0002403', 'UPHENO:0003189', 'HP:0000504', 'UPHENO:0002765', 'UPHENO:0002531', 'UPHENO:0002553', 'UPHENO:0005058', 'UPHENO:0004537', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0004529', 'UBERON:0001032', 'UBERON:0034944', 'UPHENO:0003037', 'UPHENO:0001002', 'UPHENO:0011531', 'UPHENO:0004404', 'UPHENO:0002301', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0003102', 'UBERON:0004121', 'UBERON:0000468', 'UBERON:0000490', 'UBERON:0000076', 'UBERON:0003056', 'UBERON:0001037', 'UPHENO:0003410', 'UPHENO:0003186', 'UPHENO:0002764', 'UPHENO:0052178', 'UPHENO:0087928', 'UPHENO:0076739', 'UPHENO:0050236', 'UPHENO:0049703', 'UPHENO:0002867', 'UPHENO:0002267', 'UPHENO:0002926', 'BFO:0000001', 'UBERON:0034925', 'UBERON:0000467', 'UBERON:0010316', 'UBERON:0010166', 'UBERON:0011676', 'UPHENO:0002567', 'UPHENO:0002844', 'UPHENO:0002747', 'UPHENO:0002541', 'UPHENO:0052160', 'UPHENO:0002635', 'BFO:0000004', 'UPHENO:0002564', 'UPHENO:3000007', 'UBERON:0010000', 'UBERON:0000062', 'UBERON:0007811', 'UBERON:0004088', 'UBERON:0001456', 'BFO:0000003', 'UPHENO:0001001', 'UPHENO:0011484', 'UPHENO:0088123', 'UPHENO:0003722', 'UPHENO:0011538', 'UPHENO:0002360', 'UPHENO:0002963', 'UPHENO:0086842', 'UPHENO:0002571', 'BFO:0000002', 'UBERON:0034768', 'UBERON:0011216', 'UBERON:0000481', 'UBERON:0000020', 'UBERON:0000922', 'GO:0050953', 'UPHENO:0005110', 'HP:0000646', 'UPHENO:0011560', 'UPHENO:0003163', 'UPHENO:0003020', 'UPHENO:0002430', 'UPHENO:0011552', 'UPHENO:0011491', 'UBERON:0000064', 'UBERON:0002416', 'UBERON:0016880', 'UBERON:0006601', 'UBERON:0016879', 'UBERON:0000021', 'UPHENO:0086475', 'UPHENO:0087665', 'UPHENO:0050620', 'UPHENO:0004494', 'BFO:0000040', 'UPHENO:0004757', 'UPHENO:0052161', 'HP:0000505', 'UPHENO:0011511', 'UPHENO:0076692', 'UPHENO:0086722', 'UPHENO:0002525', 'UPHENO:0050622', 'BFO:0000004', 'BFO:0000015', 'UBERON:0006598', 'UBERON:0000047', 'UPHENO:0004721', 'UPHENO:0002807', 'UPHENO:0011536', 'UPHENO:0087660', 'UPHENO:0002219', 'UPHENO:0004615', 'UPHENO:0002552', 'UBERON:0003071', 'UBERON:0000014', 'UBERON:0000019', 'UBERON:0002199', 'UBERON:0002097', 'UBERON:0005291', 'UBERON:0000153', 'HP:0000001', 'UPHENO:0005097', 'UPHENO:0052164', 'UPHENO:0003811', 'UPHENO:0002910', 'UPHENO:0011572', 'UPHENO:0002768', 'HP:0000478', 'UPHENO:0011498', 'UPHENO:0002530', 'UPHENO:0005141', 'UPHENO:0081581', 'UPHENO:0005055', 'UBERON:0001062', 'GO:0008150', 'UBERON:0000475', 'HP:0007663', 'BFO:0000002', 'UPHENO:0002580', 'UPHENO:0002949', 'UPHENO:0004519', 'UPHENO:0002385', 'UBERON:0005423', 'RO:0002577', 'GO:0032501', 'UBERON:0013703', 'UBERON:0002104', 'UBERON:0011932', 'UPHENO:0050106', 'UPHENO:0082875', 'UPHENO:0004482', 'UPHENO:0011535', 'UPHENO:0075997', 'UPHENO:0004680', 'UPHENO:0052165', 'UPHENO:0087435', 'UPHENO:0002536', 'UPHENO:0002308', 'UPHENO:0002648', 'UBERON:0001062', 'UBERON:0000063', 'UBERON:0006003', 'UBERON:0000033', 'UPHENO:0004900', 'UPHENO:0003025', 'UPHENO:0002548', 'UPHENO:0004885', 'UPHENO:0002568', 'UPHENO:0002211', 'UPHENO:7000479', 'BFO:0000003', 'UBERON:0004128', 'UBERON:0010371', 'UBERON:0000479', 'UBERON:0003075', 'UBERON:0000483', 'GO:0003008', 'GO:0007600'], 'object_closure_label': ['embryo phenotype', 'decreased qualitatively visual perception', 'skin of body phenotype', 'face phenotype', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'strand of hair phenotype', 'Abnormality of the eye', 'developing anatomical structure phenotype', 'decreased qualitatively multicellular organismal process', 'integument phenotype', 'multicellular anatomical structure phenotype', 'continuant', 'system', 'multicellular organismal process', 'integumentary projection', 'visual system', 'nervous system process', 'multicellular organismal process phenotype', 'anatomical entity physiology phenotype', 'primordium phenotype', 'number of anatomical enitites of type strand of hair phenotype', 'orbital region phenotype', 'germ layer morphology phenotype', 'camera-type eye physiology phenotype', 'continuant', 'sense organ phenotype', 'anatomical system', 'germ layer / neural crest', 'sense organ', 'embryo', 'pilosebaceous unit morphology phenotype', 'embryo morphology phenotype', 'sensory perception phenotype', 'head phenotype', 'surface structure phenotype', 'number of anatomical enitites of type anatomical entity phenotype', 'integumental system phenotype', 'external ectoderm morphology phenotype', 'nervous system process phenotype', 'zone of organ phenotype', 'organ system subdivision phenotype', 'organism subdivision', 'strand of hair', 'immature eye phenotype', 'anatomical projection phenotype', 'number of anatomical enitites of type material anatomical entity phenotype', 'germ layer / neural crest phenotype', 'eye phenotype', 'material anatomical entity physiology phenotype', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'process', 'presumptive structure', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'Abnormality of vision', 'organ subunit phenotype', 'Abnormal eye physiology', 'cutaneous appendage phenotype', 'biological_process', 'external integument structure', 'outer epithelium', 'neurectoderm', 'main body axis', 'body proper', 'subdivision of head', 'cutaneous appendage', 'visual perception', 'ectoderm morphology phenotype', 'Amblyopia', 'number of anatomical enitites of type morphological feature phenotype', 'subdivision of head phenotype', 'integumentary adnexa phenotype', 'anatomical system phenotype', 'integumentary adnexa morphology phenotype', 'neurectoderm phenotype', 'anatomical structure physiology phenotype', 'material anatomical entity', 'anatomical structure', 'disconnected anatomical group', 'organ', 'craniocervical region', 'eye', 'eyeball of camera-type eye', 'blastula', 'integumentary projection phenotype', 'outer epithelium phenotype', 'external integument structure phenotype', 'decreased qualitatively sensory perception of light stimulus', 'biological_process phenotype', 'pre-chordal neural plate phenotype', 'material entity', 'anatomical projection', 'sensory system', 'organ subunit', 'integumentary adnexa', 'orbital region', 'face', 'sensory perception of light stimulus', 'eye physiology phenotype', 'craniocervical region phenotype', 'subdivision of organism along main body axis phenotype', 'material anatomical entity phenotype', 'epithelium phenotype', 'organ part phenotype', 'structure with developmental contribution from neural crest phenotype', 'simple eye phenotype', 'anatomical structure phenotype', 'visual perception phenotype', 'optic vesicle', 'ecto-epithelium', 'tissue', 'neural plate', 'epithelium', 'sensory system phenotype', 'ecto-epithelium phenotype', 'number of anatomical enitites of type cutaneous appendage phenotype', 'embryonic structure phenotype', 'future central nervous system phenotype', 'embryonic structure', 'primordium', 'immature eye', 'coat of hair', 'embryonic tissue', 'anterior region of body', 'All', 'camera-type eye phenotype', 'phenotypic effect', 'number of anatomical enitites of type anatomical structure phenotype', 'number of anatomical enitites of type organ part phenotype', 'lateral structure physiology phenotype', 'multicellular organism phenotype', 'vision/eye phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'surface structure', 'ectoderm-derived structure', 'entire sense organ system', 'zone of organ', 'simple eye', 'visual system phenotype', 'neural plate phenotype', 'presumptive ectoderm phenotype', 'decreased qualitatively biological_process', 'zone of skin morphology phenotype', 'skin of body morphology phenotype', 'multicellular organism morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'anatomical collection phenotype', 'entity', 'anatomical collection', 'morphological feature', 'organ part', 'integumental system', 'unilaminar epithelium', 'external ectoderm', 'pre-chordal neural plate', 'sensory perception', 'organ phenotype', 'material entity', 'ectoderm-derived structure phenotype', 'germ layer phenotype', 'decreased qualitatively sensory perception', 'Visual impairment', 'number of anatomical enitites of type integumentary projection phenotype', 'anatomical entity morphology phenotype', 'coat of hair morphology phenotype', 'entity', 'occurrent', 'germ layer', 'skin epidermis', 'unilaminar epithelium phenotype', 'morphological feature phenotype', 'sensory perception of light stimulus phenotype', 'system process phenotype', 'sense organ physiology phenotype', 'decreased visual acuity; reduced visual acuity', 'decreased qualitatively nervous system process', 'sparse hair', 'non-connected functional system', 'collection of hairs', 'eye primordium', 'zone of skin', 'camera-type eye', 'integument', 'skin of body', 'subdivision of organism along main body axis', 'ectoderm', 'occurrent', 'phenotype', 'eye primordium phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'multi-tissue structure phenotype', 'organ physiology phenotype', 'anatomical entity', 'system process', 'Reduced visual acuity', 'ectoderm phenotype', 'eyeball of camera-type eye phenotype', 'simple eye physiology phenotype', 'number of anatomical enitites of type anatomical projection phenotype', 'taxon specific phenotype', 'skin epidermis phenotype', 'optic vesicle phenotype', 'developing anatomical structure', 'organ system subdivision', 'multi-tissue structure', 'head', 'structure with developmental contribution from neural crest physiology phenotype', 'number of anatomical enitites of type integumentary adnexa phenotype', 'embryonic tissue morphology phenotype', 'decreased qualitatively system process', 'skin epidermis morphology phenotype', 'anatomical entity phenotype', 'independent continuant', 'tissue phenotype', 'ectoderm-derived structure physiology phenotype', 'multicellular anatomical structure', 'multicellular organism', 'future nervous system', 'presumptive ectoderm', 'future central nervous system', 'pilosebaceous unit'], 'disease_context_qualifier_label': 'fibrosis of extraocular muscles, congenital, 2', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0001584', 'MONDO:0024458', 'MONDO:0004746', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0007614', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0003569', 'MONDO:0002022', 'MONDO:0011181', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0000462', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0100545', 'MONDO:0002081'], 'disease_context_qualifier_closure_label': ['cranial nerve neuropathy', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'ocular motility disease', 'disorder of visual system', 'neuromuscular disease', 'fibrosis of extraocular muscles, congenital, 2', 'congenital fibrosis of extraocular muscles', 'progressive muscular dystrophy', 'eye adnexa disorder', 'disorder of orbital region', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'myopathy of extraocular muscle', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'HGNC:691||biolink:has_phenotype|HP:0000646', 'highlighting': None}, {'id': 'uuid:5747da86-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0000501'], 'negated': False, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0012215', 'object': 'HP:0003693', 'original_subject': 'OMIM:609200', 'subject_label': 'myofibrillar myopathy 3', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0002921', 'MONDO:0020120', 'MONDO:0012215', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0015151', 'MONDO:0700096', 'MONDO:0016971', 'MONDO:0020121', 'MONDO:0018943', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'myofibrillar myopathy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'limb-girdle muscular dystrophy', 'congenital structural myopathy', 'neuromuscular disease', 'autosomal dominant disease', 'progressive muscular dystrophy', 'distal myopathy', 'congenital myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'muscular dystrophy, limb-girdle, autosomal dominant', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'myofibrillar myopathy 3', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'object_label': 'Distal amyotrophy', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0068971', 'UPHENO:0002526', 'BFO:0000002', 'UPHENO:0003432', 'UBERON:0000061', 'HP:0000118', 'UPHENO:0003022', 'UPHENO:0013936', 'HP:0003011', 'HP:0033127', 'UPHENO:0013993', 'UPHENO:0002976', 'UPHENO:0014000', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0002530', 'UPHENO:0069062', 'UPHENO:0003047', 'BFO:0000001', 'UBERON:0000467', 'BFO:0000004', 'UPHENO:0076710', 'UBERON:0010000', 'UBERON:0000062', 'HP:0011805', 'UPHENO:0002963', 'BFO:0000002', 'UBERON:0018254', 'UBERON:0005090', 'UBERON:0000468', 'UBERON:0011216', 'UPHENO:0014111', 'UPHENO:0002816', 'UPHENO:0001003', 'BFO:0000040', 'UPHENO:0069266', 'UPHENO:0076692', 'BFO:0000001', 'UPHENO:0002525', 'BFO:0000004', 'HP:0003693', 'HP:0000001', 'UPHENO:0081581', 'UBERON:0001062', 'UPHENO:0001001', 'HP:0003202', 'UPHENO:0001002', 'UPHENO:0002949', 'UPHENO:0002536', 'UBERON:0001062', 'UBERON:0000383', 'UPHENO:0075195', 'UPHENO:0003081', 'UPHENO:0002568'], 'object_closure_label': ['multicellular anatomical structure phenotype', 'continuant', 'anatomical system', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'skeletal musculature phenotype', 'anatomical entity', 'independent continuant', 'entity', 'skeletal musculature atrophy', 'phenotypic effect', 'anatomical system phenotype', 'material anatomical entity', 'anatomical structure', 'organ', 'material anatomical entity phenotype', 'material entity', 'muscle organ', 'musculature of body', 'phenotype', 'muscle structure phenotype', 'material anatomical entity atrophy', 'anatomical structure phenotype', 'decreased size of the anatomical entity', 'Distal amyotrophy', 'Abnormality of the musculature', 'taxon specific phenotype', 'All', 'multicellular organism phenotype', 'muscle organ morphology phenotype', 'musculature', 'multicellular organism morphology phenotype', 'entity', 'skeletal musculature', 'muscle structure', 'organ phenotype', 'material entity', 'decreased size of the material anatomical entity', 'size of anatomical entity phenotype', 'anatomical entity morphology phenotype', 'anatomical structure atrophy', 'Phenotypic abnormality', 'anatomical entity', 'Skeletal muscle atrophy', 'continuant', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'multicellular organism', 'organ system subdivision', 'anatomical entity atrophy', 'Abnormal skeletal muscle morphology', 'anatomical entity phenotype', 'independent continuant', 'decreased size of the anatomical structure', 'multicellular anatomical structure'], 'evidence_count': 1, 'grouping_key': 'MONDO:0012215|False|biolink:has_phenotype|HP:0003693', 'highlighting': None}, {'id': 'uuid:4318e0cc-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'disease_context_qualifier': 'MONDO:0014800', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:129', 'object': 'HP:0009027', 'original_subject': 'NCBIGene:58', 'subject_label': 'ACTA1', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Foot dorsiflexor weakness', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002963', 'UBERON:0002050', 'UPHENO:0002526', 'UPHENO:0003432', 'UBERON:0000061', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UPHENO:0002385', 'UPHENO:0002830', 'UBERON:0002101', 'UBERON:0007271', 'HP:0003690', 'HP:0003011', 'HP:0033127', 'UPHENO:0001003', 'UPHENO:0002976', 'UBERON:0004357', 'UBERON:0000026', 'BFO:0000002', 'UPHENO:0002945', 'UPHENO:0080555', 'UPHENO:0002553', 'BFO:0000001', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0001002', 'UPHENO:0002568', 'UBERON:0000465', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0003102', 'UBERON:0000468', 'UBERON:0004480', 'UPHENO:0003047', 'UPHENO:0003045', 'UPHENO:0080556', 'UPHENO:0002267', 'UPHENO:0002926', 'BFO:0000001', 'UPHENO:0002320', 'UPHENO:0002747', 'UPHENO:0002541', 'UPHENO:0076710', 'UBERON:0000467', 'UBERON:0000062', 'UPHENO:0001001', 'HP:0011805', 'UPHENO:0002571', 'HP:0011804', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UBERON:0000922', 'UPHENO:0003163', 'UPHENO:0002816', 'UPHENO:0002647', 'BFO:0000040', 'UPHENO:0076692', 'UPHENO:0002525', 'BFO:0000004', 'UBERON:0006598', 'HP:0009127', 'UPHENO:0002536', 'UPHENO:0003366', 'HP:0040064', 'UBERON:0004708', 'UBERON:0010707', 'HP:0000001', 'UPHENO:0002861', 'UPHENO:0002530', 'UPHENO:0081581', 'BFO:0000004', 'UBERON:0001062', 'UBERON:0000475', 'UPHENO:0002949', 'UBERON:0005423', 'RO:0002577', 'UPHENO:0082875', 'HP:0009027', 'UPHENO:0002308', 'UBERON:0001062', 'UBERON:0010000', 'UBERON:0000383', 'UPHENO:0004900', 'HP:0001324', 'UPHENO:0003334', 'UBERON:0004347'], 'object_closure_label': ['embryo phenotype', 'appendage phenotype', 'developing anatomical structure phenotype', 'Abnormal muscle physiology', 'continuant', 'multicellular anatomical structure', 'system', 'anatomical entity physiology phenotype', 'Abnormality of the musculature of the limbs', 'anatomical entity phenotype', 'limb bud phenotype', 'Abnormality of limbs', 'material anatomical entity', 'embryo', 'surface structure phenotype', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'organism subdivision', 'musculature of limb', 'paired limb/fin bud phenotype', 'material anatomical entity physiology phenotype', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'presumptive structure', 'muscle organ physiology phenotype', 'presumptive structure phenotype', 'paired limb/fin phenotype', 'decreased anatomical entity strength', 'anatomical system phenotype', 'paired limb/fin bud', 'appendage', 'continuant', 'anatomical structure', 'organ', 'material entity', 'muscle organ', 'musculature of body', 'muscle structure phenotype', 'material anatomical entity phenotype', 'structure with developmental contribution from neural crest phenotype', 'anatomical structure phenotype', 'limb bud', 'Muscle weakness', 'Abnormality of the musculature', 'embryonic structure phenotype', 'embryonic structure', 'All', 'phenotypic effect', 'multicellular organism phenotype', 'muscle organ morphology phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'surface structure', 'musculature', 'Limb muscle weakness', 'appendage musculature phenotype', 'multicellular organism morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'entity', 'muscle structure', 'organ phenotype', 'material entity', 'anatomical entity morphology phenotype', 'limb', 'appendage musculature', 'decreased muscle organ strength', 'anatomical structure physiology phenotype', 'limb phenotype', 'paired limb/fin', 'appendage girdle complex', 'phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'organ physiology phenotype', 'musculature of limb phenotype', 'anatomical entity', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'independent continuant', 'entity', 'developing anatomical structure', 'organ system subdivision', 'Abnormal skeletal muscle morphology', 'Foot dorsiflexor weakness', 'multicellular anatomical structure phenotype', 'anatomical system', 'multicellular organism'], 'disease_context_qualifier_label': 'progressive scapulohumeroperoneal distal myopathy', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0100084', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0014800', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0100545', 'MONDO:0002081'], 'disease_context_qualifier_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'alpha-actinopathy', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'progressive muscular dystrophy', 'congenital myopathy', 'myopathy', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'progressive scapulohumeroperoneal distal myopathy', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'HGNC:129||biolink:has_phenotype|HP:0009027', 'highlighting': None}, {'id': 'uuid:4318df34-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'publications': ['PMID:33239111'], 'has_count': 3, 'has_percentage': 42.857143, 'has_quotient': 0.42857143, 'has_total': 7, 'disease_context_qualifier': 'MONDO:0023671', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:53924', 'object': 'HP:0003693', 'original_subject': 'NCBIGene:100996717', 'subject_label': 'NOTCH2NLC', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Distal amyotrophy', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0068971', 'UPHENO:0002526', 'BFO:0000002', 'UPHENO:0003432', 'UBERON:0000061', 'HP:0000118', 'UPHENO:0003022', 'UPHENO:0013936', 'HP:0003011', 'HP:0033127', 'UPHENO:0013993', 'UPHENO:0002976', 'UPHENO:0014000', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0002530', 'UPHENO:0069062', 'UPHENO:0003047', 'BFO:0000001', 'UBERON:0000467', 'BFO:0000004', 'UPHENO:0076710', 'UBERON:0010000', 'UBERON:0000062', 'HP:0011805', 'UPHENO:0002963', 'BFO:0000002', 'UBERON:0018254', 'UBERON:0005090', 'UBERON:0000468', 'UBERON:0011216', 'UPHENO:0014111', 'UPHENO:0002816', 'UPHENO:0001003', 'BFO:0000040', 'UPHENO:0069266', 'UPHENO:0076692', 'BFO:0000001', 'UPHENO:0002525', 'BFO:0000004', 'HP:0003693', 'HP:0000001', 'UPHENO:0081581', 'UBERON:0001062', 'UPHENO:0001001', 'HP:0003202', 'UPHENO:0001002', 'UPHENO:0002949', 'UPHENO:0002536', 'UBERON:0001062', 'UBERON:0000383', 'UPHENO:0075195', 'UPHENO:0003081', 'UPHENO:0002568'], 'object_closure_label': ['multicellular anatomical structure phenotype', 'continuant', 'anatomical system', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'skeletal musculature phenotype', 'anatomical entity', 'independent continuant', 'entity', 'skeletal musculature atrophy', 'phenotypic effect', 'anatomical system phenotype', 'material anatomical entity', 'anatomical structure', 'organ', 'material anatomical entity phenotype', 'material entity', 'muscle organ', 'musculature of body', 'phenotype', 'muscle structure phenotype', 'material anatomical entity atrophy', 'anatomical structure phenotype', 'decreased size of the anatomical entity', 'Distal amyotrophy', 'Abnormality of the musculature', 'taxon specific phenotype', 'All', 'multicellular organism phenotype', 'muscle organ morphology phenotype', 'musculature', 'multicellular organism morphology phenotype', 'entity', 'skeletal musculature', 'muscle structure', 'organ phenotype', 'material entity', 'decreased size of the material anatomical entity', 'size of anatomical entity phenotype', 'anatomical entity morphology phenotype', 'anatomical structure atrophy', 'Phenotypic abnormality', 'anatomical entity', 'Skeletal muscle atrophy', 'continuant', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'multicellular organism', 'organ system subdivision', 'anatomical entity atrophy', 'Abnormal skeletal muscle morphology', 'anatomical entity phenotype', 'independent continuant', 'decreased size of the anatomical structure', 'multicellular anatomical structure'], 'disease_context_qualifier_label': 'oculopharyngodistal myopathy 3', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0025193', 'MONDO:0020121', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0023671', 'MONDO:0100545', 'MONDO:0002081'], 'disease_context_qualifier_closure_label': ['hereditary skeletal muscle disorder', 'oculopharyngodistal myopathy', 'muscular dystrophy', 'skeletal muscle disorder', 'oculopharyngodistal myopathy 3', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'progressive muscular dystrophy', 'distal myopathy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'disease', 'hereditary disease'], 'evidence_count': 1, 'grouping_key': 'HGNC:53924||biolink:has_phenotype|HP:0003693', 'highlighting': None}, {'id': 'uuid:582daf46-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:orphanet', 'has_evidence': ['ECO:0000304'], 'negated': False, 'frequency_qualifier': 'HP:0040283', 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0018278', 'object': 'HP:0002878', 'original_subject': 'Orphanet:370968', 'subject_label': 'congenital muscular dystrophy with intellectual disability', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0018276', 'MONDO:0005066', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0024322', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0018278', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0015286', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081', 'MONDO:0019052'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'congenital disorder of glycosylation', 'muscular dystrophy', 'skeletal muscle disorder', 'metabolic disease', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'congenital muscular dystrophy', 'congenital muscular dystrophy with intellectual disability', 'myopathy', 'human disease', 'inborn errors of metabolism', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'muscular dystrophy-dystroglycanopathy', 'disorder of glycosylation', 'hereditary disease'], 'object_label': 'Respiratory failure', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0049873', 'UBERON:0000061', 'GO:0006479', 'UPHENO:0049976', 'HP:0000118', 'UPHENO:0049587', 'UBERON:0001004', 'GO:0008213', 'UPHENO:0001003', 'GO:0043170', 'GO:0044238', 'GO:0032259', 'BFO:0000002', 'UPHENO:0050131', 'UPHENO:0050116', 'BFO:0000001', 'BFO:0000015', 'BFO:0000040', 'UPHENO:0001002', 'UPHENO:0002530', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0000468', 'UPHENO:0001001', 'HP:0002093', 'UPHENO:0002267', 'UBERON:0000467', 'UPHENO:0002448', 'UPHENO:7000396', 'BFO:0000003', 'UPHENO:0050107', 'UPHENO:0002963', 'UPHENO:0049744', 'HP:0002086', 'GO:0036211', 'UPHENO:0049979', 'BFO:0000001', 'UPHENO:0050038', 'BFO:0000040', 'HP:0002878', 'BFO:0000004', 'UPHENO:0049861', 'UPHENO:0049652', 'UPHENO:0002536', 'HP:0000001', 'UPHENO:0004536', 'UPHENO:0050121', 'BFO:0000004', 'GO:0008150', 'UPHENO:0002949', 'UPHENO:7000119', 'HP:0002795', 'UPHENO:0002385', 'GO:0009987', 'UPHENO:0082875', 'UPHENO:0002269', 'UBERON:0001062', 'UBERON:0010000', 'UPHENO:0002568', 'BFO:0000002', 'BFO:0000003', 'GO:0008152', 'GO:0043412', 'GO:0019538', 'GO:0043414'], 'object_closure_label': ['respiratory system phenotype', 'multicellular anatomical structure phenotype', 'Abnormality of the respiratory system', 'multicellular anatomical structure', 'cellular process', 'macromolecule metabolic process', 'primary metabolic process', 'methylation', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'methylation phenotype', 'macromolecule metabolic process phenotype', 'anatomical entity phenotype', 'material anatomical entity', 'anatomical system', 'cellular process phenotype', 'metabolic process phenotype', 'material anatomical entity physiology phenotype', 'anatomical entity', 'independent continuant', 'respiratory system physiology phenotype', 'protein metabolic process phenotype', 'entity', 'biological_process', 'protein alkylation', 'continuant', 'anatomical system phenotype', 'Abnormal respiratory system physiology', 'anatomical structure physiology phenotype', 'anatomical structure', 'material anatomical entity phenotype', 'biological_process phenotype', 'anatomical structure phenotype', 'material entity', 'protein modification process', 'primary metabolic process phenotype', 'protein methylation', 'macromolecule modification phenotype', 'protein alkylation phenotype', 'macromolecule methylation phenotype', 'protein modification process phenotype', 'All', 'phenotypic effect', 'multicellular organism phenotype', 'histone methylation; histone methylation variant', 'respiratory failure', 'phenotype', 'Respiratory insufficiency', 'macromolecule modification', 'protein metabolic process', 'macromolecule methylation', 'material entity', 'Respiratory failure', 'continuant', 'occurrent', 'respiratory system', 'process', 'occurrent', 'Phenotypic abnormality', 'metabolic process', 'taxon specific phenotype', 'independent continuant', 'entity', 'protein methylation phenotype', 'multicellular organism'], 'frequency_qualifier_label': 'Occasional', 'frequency_qualifier_category': 'biolink:PhenotypicFeature', 'frequency_qualifier_namespace': 'HP', 'evidence_count': 1, 'grouping_key': 'MONDO:0018278|False|biolink:has_phenotype|HP:0002878', 'highlighting': None}, {'id': 'urn:uuid:3c558ea9-7894-42ba-9cca-a4b695fc7713', 'predicate': 'biolink:subclass_of', 'category': 'biolink:Association', 'agent_type': 'not_provided', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:phenio'], 'knowledge_level': 'not_provided', 'primary_knowledge_source': 'infores:mondo', 'provided_by': 'phenio_edges', 'subject': 'MONDO:0016097', 'object': 'MONDO:0016333', 'subject_label': 'symptomatic form of muscular dystrophy of Duchenne and Becker in female carriers', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0005267', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0005217', 'MONDO:0016097', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0004995', 'MONDO:0016333', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0000591', 'MONDO:0004994', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0005021', 'MONDO:0100547', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'cardiovascular disorder', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'dilated cardiomyopathy', 'progressive muscular dystrophy', 'familial cardiomyopathy', 'familial dilated cardiomyopathy', 'cardiomyopathy', 'symptomatic form of muscular dystrophy of Duchenne and Becker in female carriers', 'heart disorder', 'myopathy', 'human disease', 'intrinsic cardiomyopathy', 'muscle tissue disorder', 'nervous system disorder', 'disease', 'cardiogenetic disease', 'hereditary disease'], 'object_label': 'familial dilated cardiomyopathy', 'object_category': 'biolink:Disease', 'object_namespace': 'MONDO', 'object_closure': ['MONDO:0005267', 'MONDO:0000001', 'MONDO:0005217', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0004995', 'MONDO:0016333', 'MONDO:0003939', 'MONDO:0000591', 'MONDO:0004994', 'MONDO:0005021', 'MONDO:0100547', 'MONDO:0002081'], 'object_closure_label': ['cardiovascular disorder', 'musculoskeletal system disorder', 'dilated cardiomyopathy', 'familial cardiomyopathy', 'familial dilated cardiomyopathy', 'cardiomyopathy', 'heart disorder', 'human disease', 'intrinsic cardiomyopathy', 'muscle tissue disorder', 'disease', 'cardiogenetic disease', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'MONDO:0016097||biolink:subclass_of|MONDO:0016333', 'highlighting': None}, {'id': 'uuid:5747da85-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0000304'], 'negated': False, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0012215', 'object': 'HP:0003552', 'original_subject': 'OMIM:609200', 'subject_label': 'myofibrillar myopathy 3', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0002921', 'MONDO:0020120', 'MONDO:0012215', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0015151', 'MONDO:0700096', 'MONDO:0016971', 'MONDO:0020121', 'MONDO:0018943', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'myofibrillar myopathy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'limb-girdle muscular dystrophy', 'congenital structural myopathy', 'neuromuscular disease', 'autosomal dominant disease', 'progressive muscular dystrophy', 'distal myopathy', 'congenital myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'muscular dystrophy, limb-girdle, autosomal dominant', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'myofibrillar myopathy 3', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'object_label': 'Muscle stiffness', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['HP:0003552', 'UPHENO:0002526', 'BFO:0000002', 'UPHENO:0003432', 'HP:0000118', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UPHENO:0002385', 'HP:0003011', 'HP:0033127', 'UPHENO:0002976', 'UPHENO:0002949', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0002530', 'UPHENO:0002525', 'UBERON:0000468', 'UPHENO:0001001', 'UPHENO:0003047', 'UPHENO:0002267', 'BFO:0000001', 'UBERON:0000467', 'UPHENO:0002320', 'UBERON:0010000', 'UBERON:0000062', 'UPHENO:0002963', 'HP:0011804', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UPHENO:0002816', 'UPHENO:0001003', 'BFO:0000040', 'BFO:0000001', 'BFO:0000004', 'HP:0000001', 'BFO:0000004', 'UBERON:0001062', 'UPHENO:0001002', 'UPHENO:0082875', 'UPHENO:0002536', 'UPHENO:0002308', 'UBERON:0001062', 'UBERON:0000061', 'UBERON:0000383', 'UPHENO:0002568'], 'object_closure_label': ['multicellular anatomical structure phenotype', 'Abnormal muscle physiology', 'continuant', 'anatomical entity physiology phenotype', 'anatomical system', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'material anatomical entity physiology phenotype', 'anatomical entity', 'independent continuant', 'muscle organ physiology phenotype', 'entity', 'phenotypic effect', 'anatomical system phenotype', 'material anatomical entity', 'organ', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'material entity', 'muscle organ', 'musculature of body', 'muscle structure phenotype', 'multicellular organism phenotype', 'Abnormality of the musculature', 'taxon specific phenotype', 'All', 'musculature', 'phenotype', 'multicellular anatomical structure physiology phenotype', 'entity', 'muscle structure', 'organ phenotype', 'material entity', 'anatomical structure physiology phenotype', 'Phenotypic abnormality', 'Muscle stiffness', 'organ physiology phenotype', 'anatomical entity', 'continuant', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'independent continuant', 'organ system subdivision', 'anatomical entity phenotype', 'anatomical structure', 'multicellular anatomical structure', 'multicellular organism'], 'evidence_count': 1, 'grouping_key': 'MONDO:0012215|False|biolink:has_phenotype|HP:0003552', 'highlighting': None}, {'id': 'uuid:582dade3-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:orphanet', 'has_evidence': ['ECO:0000304'], 'negated': False, 'frequency_qualifier': 'HP:0040282', 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0011362', 'object': 'HP:0002747', 'original_subject': 'Orphanet:178464', 'subject_label': 'myopathy, myofibrillar, 9, with early respiratory failure', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0002320', 'MONDO:0016112', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0100494', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0011362', 'MONDO:0020121', 'MONDO:0100175', 'MONDO:0016191', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'TTN-related myopathy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'myopathy, myofibrillar, 9, with early respiratory failure', 'neuromuscular disease', 'autosomal dominant disease', 'hereditary inclusion-body myopathy', 'progressive muscular dystrophy', 'distal myopathy', 'neuromuscular disease caused by qualitative or quantitative defects of titin', 'congenital myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'autosomal dominant titinopathy', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'object_label': 'Respiratory insufficiency due to muscle weakness', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002526', 'BFO:0000002', 'UPHENO:0003432', 'UPHENO:0003000', 'UBERON:0000061', 'HP:0000118', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UBERON:0001004', 'HP:0003011', 'HP:0033127', 'UPHENO:0002976', 'UPHENO:0080555', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0002525', 'UBERON:0000468', 'HP:0002093', 'UPHENO:0003047', 'UPHENO:0080556', 'UPHENO:0002267', 'BFO:0000001', 'BFO:0000004', 'UBERON:0000467', 'UPHENO:0002448', 'UPHENO:0002320', 'UPHENO:0002675', 'UBERON:0010000', 'UBERON:0000062', 'UPHENO:0080577', 'UPHENO:0002963', 'HP:0011804', 'HP:0002086', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UPHENO:0002816', 'UPHENO:0001003', 'UPHENO:0002536', 'UBERON:0014398', 'BFO:0000040', 'BFO:0000001', 'UBERON:0003831', 'HP:0002747', 'UBERON:0001062', 'HP:0000001', 'UPHENO:0004536', 'HP:0004347', 'UPHENO:0002530', 'BFO:0000004', 'UBERON:0001062', 'UPHENO:0001001', 'UPHENO:0001002', 'UPHENO:0002949', 'HP:0002795', 'UPHENO:0002385', 'UPHENO:0082875', 'UPHENO:0002269', 'UPHENO:0002308', 'UBERON:0000383', 'HP:0001324', 'UPHENO:0002568'], 'object_closure_label': ['respiratory system phenotype', 'Weakness of muscles of respiration', 'respiratory muscle phenotype', 'multicellular anatomical structure phenotype', 'Abnormal muscle physiology', 'Abnormality of the respiratory system', 'continuant', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'anatomical system', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'material anatomical entity physiology phenotype', 'respiratory system muscle', 'respiratory system physiology phenotype', 'muscle organ physiology phenotype', 'decreased anatomical entity strength', 'entity', 'respiratory muscle', 'phenotypic effect', 'anatomical system phenotype', 'Abnormal respiratory system physiology', 'anatomical structure physiology phenotype', 'material anatomical entity', 'anatomical structure', 'organ', 'anatomical structure phenotype', 'material entity', 'muscle organ', 'musculature of body', 'phenotype', 'muscle structure phenotype', 'material anatomical entity phenotype', 'Muscle weakness', 'Respiratory insufficiency due to muscle weakness', 'Abnormality of the musculature', 'taxon specific phenotype', 'anatomical entity phenotype', 'All', 'multicellular organism phenotype', 'anatomical entity', 'musculature', 'Respiratory insufficiency', 'multicellular anatomical structure physiology phenotype', 'entity', 'independent continuant', 'muscle structure', 'organ phenotype', 'material entity', 'respiratory system', 'decreased muscle organ strength', 'Phenotypic abnormality', 'organ physiology phenotype', 'anatomical entity', 'continuant', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'independent continuant', 'respiratory system muscle phenotype', 'organ system subdivision', 'decreased respiratory muscle strength', 'multicellular anatomical structure', 'multicellular organism'], 'frequency_qualifier_label': 'Frequent', 'frequency_qualifier_category': 'biolink:PhenotypicFeature', 'frequency_qualifier_namespace': 'HP', 'evidence_count': 1, 'grouping_key': 'MONDO:0011362|False|biolink:has_phenotype|HP:0002747', 'highlighting': None}, {'id': 'uuid:582daf36-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:orphanet', 'has_evidence': ['ECO:0000304'], 'negated': False, 'frequency_qualifier': 'HP:0040283', 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0018278', 'object': 'HP:0000478', 'original_subject': 'Orphanet:370968', 'subject_label': 'congenital muscular dystrophy with intellectual disability', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0018276', 'MONDO:0005066', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0024322', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0018278', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0015286', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081', 'MONDO:0019052'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'congenital disorder of glycosylation', 'muscular dystrophy', 'skeletal muscle disorder', 'metabolic disease', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'congenital muscular dystrophy', 'congenital muscular dystrophy with intellectual disability', 'myopathy', 'human disease', 'inborn errors of metabolism', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'muscular dystrophy-dystroglycanopathy', 'disorder of glycosylation', 'hereditary disease'], 'object_label': 'Abnormality of the eye', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002902', 'UBERON:0002050', 'UBERON:0001048', 'UBERON:0010312', 'UBERON:0004456', 'UBERON:0000922', 'UBERON:0000970', 'UBERON:0010230', 'UBERON:0000307', 'UPHENO:0002526', 'UPHENO:0002866', 'UPHENO:0004433', 'UBERON:0000061', 'UBERON:0034923', 'UBERON:0000924', 'UPHENO:0004888', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002928', 'UPHENO:0003236', 'UBERON:0000923', 'UPHENO:0005030', 'UPHENO:0002564', 'UBERON:0015203', 'UBERON:0002346', 'UBERON:0013702', 'UPHENO:0003189', 'UPHENO:0002553', 'UPHENO:0005058', 'UBERON:0001032', 'UPHENO:0002530', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0004121', 'UBERON:0000490', 'UBERON:0003056', 'UPHENO:0003410', 'UPHENO:0003186', 'UPHENO:0002764', 'UPHENO:0002926', 'UBERON:0010316', 'UBERON:0000153', 'UBERON:0011676', 'UBERON:0013701', 'UPHENO:0002567', 'UPHENO:0002844', 'UPHENO:0002541', 'UPHENO:3000007', 'UBERON:0010000', 'UBERON:0000467', 'UBERON:0000062', 'UBERON:0001444', 'UBERON:0007811', 'UBERON:0004088', 'UBERON:0001456', 'UPHENO:0002963', 'UPHENO:0002571', 'BFO:0000002', 'UBERON:0000468', 'UBERON:0000481', 'UBERON:0000020', 'UPHENO:0005110', 'UPHENO:0003163', 'UPHENO:0003020', 'UPHENO:0001003', 'UPHENO:0002536', 'BFO:0000001', 'UBERON:0016880', 'UBERON:0006601', 'UBERON:0016879', 'UPHENO:0004494', 'BFO:0000040', 'UPHENO:0004757', 'BFO:0000001', 'BFO:0000004', 'UBERON:0006598', 'UBERON:0000047', 'UPHENO:0004721', 'UPHENO:0004615', 'UBERON:0003071', 'UBERON:0000019', 'UBERON:0005291', 'HP:0000001', 'UPHENO:0005097', 'UPHENO:0002910', 'HP:0000478', 'UPHENO:0005141', 'BFO:0000004', 'UPHENO:0005055', 'UBERON:0001062', 'BFO:0000040', 'UBERON:0000475', 'UPHENO:0001001', 'UPHENO:0001002', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0004519', 'UBERON:0002104', 'UPHENO:0004482', 'UPHENO:0075997', 'UPHENO:0004680', 'UBERON:0001062', 'UBERON:0005423', 'UBERON:0000033', 'UPHENO:0004900', 'UPHENO:0003025', 'UPHENO:0002548', 'UPHENO:0004885', 'UPHENO:0002568', 'UBERON:0004128', 'UBERON:0010371', 'UBERON:0000479', 'UBERON:0003075', 'UBERON:0000483'], 'object_closure_label': ['embryo phenotype', 'face phenotype', 'Abnormality of the eye', 'developing anatomical structure phenotype', 'multicellular anatomical structure phenotype', 'continuant', 'visual system', 'primordium phenotype', 'orbital region phenotype', 'continuant', 'sense organ phenotype', 'material anatomical entity', 'germ layer / neural crest', 'sense organ', 'head phenotype', 'organism subdivision', 'immature eye phenotype', 'germ layer / neural crest phenotype', 'eye phenotype', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'presumptive structure', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'entity', 'entity', 'material entity', 'neurectoderm', 'body proper', 'phenotypic effect', 'subdivision of head phenotype', 'anatomical system phenotype', 'neurectoderm phenotype', 'anatomical structure', 'disconnected anatomical group', 'organ', 'subdivision of head', 'craniocervical region', 'eye', 'eyeball of camera-type eye', 'blastula', 'material anatomical entity phenotype', 'pre-chordal neural plate phenotype', 'anatomical structure phenotype', 'sensory system', 'orbital region', 'face', 'phenotype', 'craniocervical region phenotype', 'subdivision of organism along main body axis phenotype', 'epithelium phenotype', 'structure with developmental contribution from neural crest phenotype', 'simple eye phenotype', 'optic vesicle', 'ecto-epithelium', 'tissue', 'neural plate', 'epithelium', 'sensory system phenotype', 'ecto-epithelium phenotype', 'taxon specific phenotype', 'anatomical entity phenotype', 'embryonic structure phenotype', 'future central nervous system phenotype', 'embryonic structure', 'primordium', 'immature eye', 'embryonic tissue', 'All', 'camera-type eye phenotype', 'multicellular organism phenotype', 'vision/eye phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'ectoderm-derived structure', 'entire sense organ system', 'simple eye', 'visual system phenotype', 'neural plate phenotype', 'presumptive ectoderm phenotype', 'unilaminar epithelium', 'pre-chordal neural plate', 'organ phenotype', 'material entity', 'ectoderm-derived structure phenotype', 'germ layer phenotype', 'germ layer', 'unilaminar epithelium phenotype', 'tissue phenotype', 'non-connected functional system', 'eye primordium', 'camera-type eye', 'anterior region of body', 'subdivision of organism along main body axis', 'main body axis', 'ectoderm', 'eye primordium phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'multi-tissue structure phenotype', 'anatomical entity', 'ectoderm phenotype', 'eyeball of camera-type eye phenotype', 'independent continuant', 'optic vesicle phenotype', 'multicellular organism', 'multi-tissue structure', 'embryo', 'head', 'developing anatomical structure', 'multicellular anatomical structure', 'anatomical system', 'future nervous system', 'presumptive ectoderm', 'future central nervous system'], 'frequency_qualifier_label': 'Occasional', 'frequency_qualifier_category': 'biolink:PhenotypicFeature', 'frequency_qualifier_namespace': 'HP', 'evidence_count': 1, 'grouping_key': 'MONDO:0018278|False|biolink:has_phenotype|HP:0000478', 'highlighting': None}, {'id': 'uuid:432683d1-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'publications': ['PMID:33239111'], 'has_count': 1, 'has_percentage': 14.285714, 'has_quotient': 0.14285715, 'has_total': 7, 'disease_context_qualifier': 'MONDO:0023671', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:53924', 'object': 'HP:0031237', 'original_subject': 'NCBIGene:100996717', 'subject_label': 'NOTCH2NLC', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Internally nucleated skeletal muscle fibers', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002576', 'UPHENO:0002577', 'UBERON:0002050', 'UBERON:0002329', 'UBERON:0000922', 'UBERON:0000307', 'UPHENO:0002526', 'BFO:0000002', 'UPHENO:0004545', 'UPHENO:0003432', 'UBERON:0000061', 'UBERON:0034923', 'UBERON:0000926', 'UBERON:0007503', 'UBERON:0000486', 'UPHENO:0004143', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0006889', 'UPHENO:0003022', 'UPHENO:0088180', 'UPHENO:0003234', 'CL:0000183', 'CL:0000255', 'CL:0000211', 'UBERON:0007285', 'UBERON:0000923', 'HP:0003011', 'HP:0033127', 'UPHENO:0001003', 'UPHENO:0002564', 'UPHENO:0004969', 'UPHENO:0003160', 'UPHENO:0002976', 'UBERON:0003077', 'UBERON:0013701', 'UBERON:0013702', 'HP:0004303', 'UPHENO:0003372', 'UPHENO:0003191', 'UPHENO:0002949', 'BFO:0000001', 'UBERON:0002385', 'UBERON:0001630', 'GO:0043226', 'GO:0005737', 'GO:0099080', 'GO:0005622', 'GO:0030017', 'UBERON:0009142', 'UBERON:0001015', 'UPHENO:0001002', 'UPHENO:0004892', 'UPHENO:0002530', 'BFO:0000004', 'UBERON:0000465', 'UBERON:0017650', 'UBERON:0015212', 'UBERON:0005256', 'GO:0043292', 'UPHENO:0087047', 'UPHENO:0003047', 'UPHENO:0002720', 'UPHENO:0005135', 'HP:0031237', 'UPHENO:0002926', 'UBERON:0000467', 'UBERON:0010316', 'GO:0005575', 'UBERON:0011676', 'UPHENO:0002567', 'UPHENO:0002541', 'UPHENO:0086477', 'UPHENO:0087663', 'UPHENO:0076710', 'UBERON:0000062', 'UBERON:0000468', 'HP:0011805', 'UPHENO:0086482', 'UPHENO:0088123', 'UPHENO:0002897', 'UPHENO:0086505', 'UPHENO:0002963', 'UPHENO:0002571', 'UPHENO:0067696', 'CL:0000000', 'UBERON:0018254', 'UBERON:0003059', 'UBERON:0004120', 'UBERON:0005090', 'GO:0110165', 'UBERON:0000477', 'UBERON:0011216', 'GO:0030016', 'UPHENO:0003163', 'UPHENO:0002816', 'HP:0020201', 'UBERON:0001062', 'BFO:0000001', 'UBERON:0001134', 'GO:0043232', 'GO:0099512', 'UPHENO:0087665', 'UPHENO:0086172', 'BFO:0000040', 'UPHENO:0076692', 'UPHENO:0002525', 'BFO:0000004', 'UBERON:0006598', 'CL:0000393', 'UBERON:0002036', 'UBERON:0014892', 'GO:0043229', 'GO:0043228', 'GO:0099081', 'UPHENO:0087660', 'UPHENO:0067691', 'UPHENO:0002542', 'UBERON:0003082', 'UBERON:0005291', 'UBERON:0003104', 'HP:0000001', 'UPHENO:0005141', 'UPHENO:0081581', 'UPHENO:0002554', 'UBERON:0001062', 'BFO:0000040', 'UBERON:0000475', 'UPHENO:0001001', 'RO:0002577', 'CL:0000737', 'UPHENO:0004680', 'UPHENO:0087849', 'UPHENO:0002536', 'UPHENO:0003413', 'UBERON:0005423', 'UBERON:0010000', 'UBERON:0000383', 'CL:0000187', 'CL:0000188', 'UBERON:0007524', 'UBERON:0002100', 'UPHENO:0004900', 'UPHENO:0003025', 'UPHENO:0004885', 'UPHENO:0003081', 'UPHENO:0002568', 'UPHENO:0003182', 'BFO:0000002', 'UBERON:0000479', 'UBERON:0000483'], 'object_closure_label': ['embryo phenotype', 'developing anatomical structure phenotype', 'myotome morphology phenotype', 'mesoderm morphology phenotype', 'independent continuant', 'multicellular anatomical structure phenotype', 'morphology of sarcomere phenotype', 'multicellular anatomical structure', 'system', 'germ layer morphology phenotype', 'morphology of cellular_component phenotype', 'material anatomical entity', 'anatomical system', 'germ layer / neural crest', 'embryo morphology phenotype', 'cell phenotype', 'cellular_component phenotype', 'muscle organ phenotype', 'somite phenotype', 'musculature of body phenotype', 'epithelial vesicle phenotype', 'myotome phenotype', 'organ system subdivision phenotype', 'organism subdivision', 'contractile muscle fiber', 'germ layer / neural crest phenotype', 'mesenchyme morphology phenotype', 'skeletal musculature phenotype', 'organism subdivision phenotype', 'independent continuant', 'presumptive structure', 'electrically responsive cell', 'striated muscle tissue', 'skeletal muscle organ, vertebrate', 'intracellular organelle', 'membraneless organelle', 'supramolecular polymer', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'trunk mesenchyme phenotype', 'anatomical entity', 'entity', 'material entity', 'paraxial mesoderm', 'main body axis', 'body proper', 'skeletal muscle tissue', 'intracellular membraneless organelle', 'supramolecular fiber', 'anatomical system phenotype', 'anatomical structure', 'disconnected anatomical group', 'organ', 'multicellular organism', 'blastula', 'skeletal muscle organ, vertebrate phenotype', 'presomitic mesoderm morphology phenotype', 'material anatomical entity phenotype', 'muscle tissue', 'muscle organ', 'organelle', 'cytoplasm', 'supramolecular complex', 'intracellular anatomical structure', 'sarcomere', 'entire embryonic mesenchyme', 'musculature of body', 'muscle cell', 'cell of skeletal muscle', 'myofibril', 'phenotype', 'developing mesenchymal structure phenotype', 'skeletal muscle tissue morphology phenotype', 'muscle structure phenotype', 'subdivision of organism along main body axis phenotype', 'mesoderm phenotype', 'epithelium phenotype', 'multicellular organism phenotype', 'anatomical structure phenotype', 'tissue', 'epithelium', 'Abnormality of the musculature', 'Abnormal sarcomere morphology', 'embryonic structure phenotype', 'mesoderm-derived structure phenotype', 'embryonic structure', 'somite', 'cellular_component', 'embryonic tissue', 'mesenchyme', 'All', 'phenotypic effect', 'muscle organ morphology phenotype', 'developing mesenchymal structure', 'lateral structure', 'musculature', 'muscle tissue phenotype', 'multilaminar epithelium phenotype', 'multicellular organism morphology phenotype', 'trunk phenotype', 'cell', 'skeletal musculature', 'presomitic mesoderm', 'mesoderm-derived structure', 'muscle structure', 'cellular anatomical structure', 'anatomical cluster', 'trunk mesenchyme', 'Abnormal muscle fiber morphology', 'organ phenotype', 'material entity', 'germ layer phenotype', 'anatomical entity morphology phenotype', 'continuant', 'contractile cell', 'eukaryotic cell', 'electrically active cell', 'presumptive paraxial mesoderm', 'germ layer', 'anatomical cluster phenotype', 'Internally nucleated skeletal muscle fibers', 'tissue phenotype', 'paraxial mesoderm phenotype', 'presomitic mesoderm phenotype', 'myotome', 'subdivision of organism along main body axis', 'mesoderm', 'epithelial vesicle', 'multilaminar epithelium', 'presumptive paraxial mesoderm phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'mesenchyme phenotype', 'dense mesenchyme tissue phenotype', 'cell of skeletal muscle morphology phenotype', 'anatomical entity', 'continuant', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'entity', 'organ system subdivision', 'embryo', 'dense mesenchyme tissue', 'trunk', 'Abnormal skeletal muscle morphology', 'paraxial mesoderm morphology phenotype', 'embryonic tissue morphology phenotype', 'anatomical entity phenotype', 'developing anatomical structure', 'striated muscle cell'], 'disease_context_qualifier_label': 'oculopharyngodistal myopathy 3', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0025193', 'MONDO:0020121', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0023671', 'MONDO:0100545', 'MONDO:0002081'], 'disease_context_qualifier_closure_label': ['hereditary skeletal muscle disorder', 'oculopharyngodistal myopathy', 'muscular dystrophy', 'skeletal muscle disorder', 'oculopharyngodistal myopathy 3', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'progressive muscular dystrophy', 'distal myopathy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'disease', 'hereditary disease'], 'evidence_count': 1, 'grouping_key': 'HGNC:53924||biolink:has_phenotype|HP:0031237', 'highlighting': None}, {'id': 'uuid:432683fb-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'disease_context_qualifier': 'MONDO:0013835', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:37276', 'object': 'HP:0000490', 'original_subject': 'NCBIGene:729920', 'subject_label': 'CRPPA', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Deeply set eye', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:7000184', 'BFO:0000040', 'UPHENO:0002902', 'BFO:0000001', 'UBERON:0002050', 'UBERON:0001048', 'UBERON:0010312', 'UBERON:0004456', 'UBERON:0000970', 'UBERON:0010230', 'UBERON:0000307', 'UPHENO:0002526', 'UPHENO:0004757', 'UPHENO:0002866', 'UPHENO:0004433', 'HP:0100886', 'UBERON:0000061', 'UBERON:0000924', 'HP:0012372', 'UPHENO:0087472', 'UPHENO:0004888', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002928', 'UPHENO:0003236', 'UBERON:0000923', 'UPHENO:0005030', 'UPHENO:0001003', 'UPHENO:0002564', 'UBERON:0015203', 'UBERON:0002346', 'UBERON:0013701', 'UBERON:0013702', 'UPHENO:0018418', 'UPHENO:0003189', 'UPHENO:0018424', 'UPHENO:0002553', 'UPHENO:0005058', 'BFO:0000040', 'UBERON:0001032', 'UPHENO:0001002', 'UPHENO:0002530', 'UPHENO:0002568', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0004121', 'UBERON:0000490', 'UBERON:0003056', 'UPHENO:0003410', 'UPHENO:7000170', 'UPHENO:0003186', 'UPHENO:0002764', 'UPHENO:0002926', 'BFO:0000001', 'UBERON:0034923', 'UBERON:0000467', 'UBERON:0010316', 'UBERON:0000153', 'UBERON:0011676', 'UPHENO:0002567', 'UPHENO:0002844', 'UPHENO:0002541', 'UPHENO:3000007', 'UBERON:0000062', 'UBERON:0000468', 'UBERON:0001444', 'UBERON:0007811', 'UBERON:0004088', 'UBERON:0001456', 'UPHENO:0002571', 'BFO:0000002', 'UBERON:0000481', 'UBERON:0000020', 'UBERON:0000922', 'UPHENO:0005110', 'UPHENO:0003163', 'UPHENO:0003020', 'UBERON:0016880', 'UBERON:0006601', 'UBERON:0016879', 'UPHENO:0004494', 'UPHENO:0002963', 'UPHENO:0076692', 'BFO:0000004', 'UBERON:0006598', 'UBERON:0000047', 'UPHENO:0004721', 'UPHENO:0086589', 'UPHENO:0004615', 'UPHENO:7000632', 'UBERON:0003071', 'UBERON:0000019', 'UBERON:0005291', 'HP:0000001', 'UPHENO:0005097', 'UPHENO:0087907', 'UPHENO:0002910', 'HP:0000478', 'UPHENO:0005141', 'UPHENO:0081581', 'BFO:0000004', 'UPHENO:0005055', 'UBERON:0001062', 'UBERON:0000475', 'UPHENO:0001001', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0004519', 'UBERON:0002104', 'UPHENO:0004482', 'UPHENO:0075997', 'HP:0000490', 'UPHENO:0087924', 'UPHENO:0004680', 'UPHENO:0002536', 'UBERON:0001062', 'UBERON:0005423', 'UBERON:0010000', 'UBERON:0000033', 'UPHENO:0004900', 'UPHENO:0018390', 'UPHENO:0003025', 'UPHENO:0002548', 'UPHENO:0004885', 'UPHENO:7000640', 'UBERON:0004128', 'UBERON:0010371', 'UBERON:0000479', 'UBERON:0003075', 'UBERON:0000483'], 'object_closure_label': ['embryo phenotype', 'head morphology phenotype', 'face phenotype', 'Abnormality of the eye', 'developing anatomical structure phenotype', 'continuant', 'multicellular anatomical structure', 'visual system', 'primordium phenotype', 'orbital region phenotype', 'Deeply set eye', 'craniocervical region morphology phenotype', 'continuant', 'eye phenotype', 'sense organ phenotype', 'eye morphology', 'material anatomical entity', 'anatomical system', 'germ layer / neural crest', 'sense organ', 'embryo', 'head phenotype', 'organism subdivision', 'immature eye phenotype', 'germ layer / neural crest phenotype', 'dysesthesia; hyperalgesia', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'presumptive structure', 'embryonic tissue phenotype', 'camera-type eye morphology phenotype', 'presumptive structure phenotype', 'neurectoderm', 'main body axis', 'body proper', 'subdivision of head phenotype', 'neurectoderm phenotype', 'anatomical structure', 'organ', 'multicellular organism', 'subdivision of head', 'craniocervical region', 'eye', 'eyeball of camera-type eye', 'blastula', 'material entity', 'material anatomical entity phenotype', 'pre-chordal neural plate phenotype', 'anatomical structure phenotype', 'material entity', 'sensory system', 'orbital region', 'face', 'phenotype', 'location of camera-type eye phenotype', 'craniocervical region phenotype', 'location of anatomical entity phenotype', 'subdivision of organism along main body axis phenotype', 'epithelium phenotype', 'structure with developmental contribution from neural crest phenotype', 'simple eye phenotype', 'optic vesicle', 'ecto-epithelium', 'tissue', 'neural plate', 'epithelium', 'sensory system phenotype', 'ecto-epithelium phenotype', 'embryonic structure phenotype', 'future central nervous system phenotype', 'embryonic structure', 'primordium', 'immature eye', 'embryonic tissue', 'All', 'camera-type eye phenotype', 'phenotypic effect', 'multicellular organism phenotype', 'vision/eye phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'ectoderm-derived structure', 'entire sense organ system', 'simple eye', 'visual system phenotype', 'deeply set eye; enophthalmos', 'neural plate phenotype', 'presumptive ectoderm phenotype', 'multicellular organism morphology phenotype', 'entity', 'disconnected anatomical group', 'unilaminar epithelium', 'pre-chordal neural plate', 'organ phenotype', 'ectoderm-derived structure phenotype', 'germ layer phenotype', 'anatomical system phenotype', 'anatomical entity morphology phenotype', 'entity', 'germ layer', 'unilaminar epithelium phenotype', 'esotropia', 'tissue phenotype', 'non-connected functional system', 'eye primordium', 'camera-type eye', 'anterior region of body', 'subdivision of organism along main body axis', 'ectoderm', 'eye primordium phenotype', 'location of eyeball of camera-type eye phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'multi-tissue structure phenotype', 'anatomical entity', 'Abnormal eye morphology', 'face morphology phenotype', 'ectoderm phenotype', 'eyeball of camera-type eye phenotype', 'taxon specific phenotype', 'independent continuant', 'optic vesicle phenotype', 'Abnormality of globe location', 'multi-tissue structure', 'head', 'anatomical entity phenotype', 'multicellular anatomical structure phenotype', 'developing anatomical structure', 'future nervous system', 'presumptive ectoderm', 'future central nervous system'], 'disease_context_qualifier_label': 'muscular dystrophy-dystroglycanopathy (congenital with brain and eye anomalies), type A, 7', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0045010', 'MONDO:0020120', 'MONDO:0100530', 'MONDO:0016155', 'MONDO:0018282', 'MONDO:0000001', 'MONDO:0018276', 'MONDO:0000171', 'MONDO:0013835', 'MONDO:0005066', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0017741', 'MONDO:0020121', 'MONDO:0024322', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0015286', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081', 'MONDO:0019052'], 'disease_context_qualifier_closure_label': ['hereditary skeletal muscle disorder', 'congenital disorder of glycosylation', 'muscular dystrophy', 'skeletal muscle disorder', 'myopathy caused by variation in CRPPA', 'metabolic disease', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'disorder of protein O-glycosylation', 'neuromuscular disease', 'congenital muscular dystrophy', 'glycoprotein metabolism disease', 'muscular dystrophy-dystroglycanopathy (congenital with brain and eye anomalies), type A, 7', 'myopathy', 'muscular dystrophy-dystroglycanopathy, type A', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'inborn errors of metabolism', 'qualitative or quantitative defects of protein involved in O-glycosylation of alpha-dystroglycan', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'neuromuscular disease caused by qualitative or quantitative defects of alpha-dystroglycan', 'disease', 'muscular dystrophy-dystroglycanopathy', 'disorder of glycosylation', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'HGNC:37276||biolink:has_phenotype|HP:0000490', 'highlighting': None}, {'id': 'uuid:582dadf5-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:orphanet', 'has_evidence': ['ECO:0000304'], 'negated': False, 'frequency_qualifier': 'HP:0040283', 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0011362', 'object': 'HP:0008981', 'original_subject': 'Orphanet:178464', 'subject_label': 'myopathy, myofibrillar, 9, with early respiratory failure', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0002320', 'MONDO:0016112', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0100494', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0011362', 'MONDO:0020121', 'MONDO:0100175', 'MONDO:0016191', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'TTN-related myopathy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'myopathy, myofibrillar, 9, with early respiratory failure', 'neuromuscular disease', 'autosomal dominant disease', 'hereditary inclusion-body myopathy', 'progressive muscular dystrophy', 'distal myopathy', 'neuromuscular disease caused by qualitative or quantitative defects of titin', 'congenital myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'autosomal dominant titinopathy', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'object_label': 'Calf muscle hypertrophy', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002576', 'UPHENO:0001267', 'UPHENO:0002577', 'UPHENO:0003065', 'UBERON:0002050', 'UBERON:0002329', 'UBERON:0017650', 'UBERON:0000307', 'HP:0002814', 'UPHENO:0002526', 'UPHENO:0002731', 'HP:0030236', 'UPHENO:0003046', 'UPHENO:0004545', 'UPHENO:0003432', 'UPHENO:0001134', 'UPHENO:0076692', 'UPHENO:0002525', 'UBERON:0002103', 'UBERON:0005418', 'UBERON:0007503', 'UBERON:0000486', 'UPHENO:0002847', 'UPHENO:0004456', 'UPHENO:0084763', 'UPHENO:0001195', 'UPHENO:0004143', 'HP:0000118', 'UPHENO:0003022', 'UPHENO:0084715', 'UPHENO:0084767', 'UPHENO:0003234', 'UPHENO:0002830', 'UBERON:0007285', 'UBERON:0004709', 'UBERON:0002101', 'UBERON:0010709', 'UBERON:0005420', 'UBERON:0007271', 'UBERON:0014792', 'UPHENO:0003095', 'UPHENO:0004467', 'HP:0003011', 'UPHENO:0086546', 'HP:0033127', 'UPHENO:0001003', 'HP:0008968', 'UPHENO:0004969', 'UPHENO:0003160', 'UPHENO:0084489', 'UPHENO:0002976', 'UBERON:0000477', 'UBERON:0003077', 'UBERON:0004357', 'UBERON:0013701', 'UBERON:0000026', 'UBERON:0000154', 'UBERON:0013702', 'UPHENO:0002644', 'UPHENO:0003516', 'UPHENO:0003372', 'UPHENO:0002945', 'UPHENO:0003191', 'UPHENO:0002553', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0002385', 'UBERON:0001630', 'UBERON:0009142', 'UBERON:0001015', 'UPHENO:0075952', 'UPHENO:0001002', 'UPHENO:0003411', 'UPHENO:0002530', 'UPHENO:0003049', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0003102', 'UBERON:0000468', 'UBERON:0005256', 'UBERON:0007270', 'UBERON:0004480', 'UBERON:0014795', 'UBERON:0003663', 'UBERON:0002529', 'HP:0008981', 'UPHENO:0084535', 'UPHENO:0087047', 'UPHENO:0003047', 'UPHENO:0002720', 'UPHENO:0003045', 'UPHENO:0005135', 'UPHENO:0001031', 'UPHENO:0001592', 'UPHENO:0002926', 'UBERON:0034923', 'UBERON:0006598', 'UBERON:0011676', 'UPHENO:0002567', 'UPHENO:0002747', 'UPHENO:0002541', 'UPHENO:0002585', 'UPHENO:0086477', 'BFO:0000004', 'UPHENO:0002564', 'UPHENO:0086635', 'UPHENO:0001360', 'UPHENO:0076710', 'UBERON:0000467', 'UBERON:0000062', 'UBERON:0010758', 'UBERON:0006058', 'UBERON:0004466', 'UBERON:0004256', 'UBERON:0003823', 'UPHENO:0001001', 'UPHENO:0075777', 'UPHENO:0001655', 'HP:0011805', 'UPHENO:0086482', 'UPHENO:0088123', 'HP:0003712', 'UPHENO:0002897', 'UPHENO:0086505', 'UPHENO:0002963', 'UPHENO:0002571', 'UPHENO:0001693', 'BFO:0000002', 'UBERON:0018254', 'UBERON:0003059', 'UBERON:0004120', 'UBERON:0005090', 'UBERON:0011216', 'UBERON:0000922', 'UBERON:0004482', 'UBERON:0001383', 'UBERON:0008784', 'UBERON:0002471', 'UPHENO:0075164', 'UPHENO:0003163', 'UPHENO:0002816', 'UPHENO:0087443', 'UPHENO:0002647', 'BFO:0000001', 'UBERON:0001134', 'UBERON:0010890', 'UBERON:0003661', 'UBERON:0010538', 'UPHENO:0002944', 'UPHENO:0002684', 'UPHENO:0087665', 'BFO:0000040', 'BFO:0000001', 'BFO:0000004', 'UBERON:0002036', 'UBERON:0014892', 'UBERON:0000978', 'UPHENO:0001097', 'HP:0009127', 'UPHENO:0002542', 'UPHENO:0001303', 'UPHENO:0003366', 'HP:0040064', 'UBERON:0003082', 'UBERON:0004708', 'UBERON:0010707', 'UBERON:0005291', 'UBERON:0003104', 'UBERON:0006067', 'UPHENO:0001135', 'HP:0000001', 'UPHENO:0090177', 'UPHENO:0002861', 'UPHENO:0086780', 'UPHENO:0084485', 'UPHENO:0005141', 'UPHENO:0081581', 'UPHENO:0002554', 'UPHENO:0001900', 'UBERON:0001062', 'UBERON:0000475', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0003070', 'UBERON:0005423', 'RO:0002577', 'UPHENO:0002785', 'UPHENO:0087849', 'HP:0001430', 'UPHENO:0087344', 'UPHENO:0002536', 'HP:0001437', 'UPHENO:0003413', 'UBERON:0001062', 'UBERON:0000061', 'UBERON:0010000', 'UBERON:0000383', 'UBERON:0007524', 'UBERON:0002100', 'UPHENO:0004900', 'UPHENO:0086628', 'UPHENO:0003025', 'UPHENO:0075195', 'UPHENO:0003081', 'UPHENO:0001072', 'UPHENO:0003334', 'UPHENO:0002568', 'UPHENO:0003182', 'UBERON:0000479', 'UBERON:0004347', 'UBERON:0000483'], 'object_closure_label': ['embryo phenotype', 'hindlimb morphology phenotype', 'appendage phenotype', 'hindlimb zeugopod morphology phenotype', 'hypertrophic skeletal muscle tissue', 'developing anatomical structure phenotype', 'lower limb segment phenotype', 'myotome morphology phenotype', 'multi-limb segment region phenotype', 'multicellular anatomical structure phenotype', 'increased size of the muscle structure', 'continuant', 'multicellular anatomical structure', 'system', 'zeugopod phenotype', 'increased size of the muscle tissue', 'Abnormality of the musculature of the limbs', 'continuant', 'limb bud phenotype', 'Abnormality of limbs', 'presumptive structure', 'embryo', 'limb segment phenotype', 'musculature of leg phenotype', 'embryo morphology phenotype', 'surface structure phenotype', 'muscle organ phenotype', 'Abnormality of muscle size', 'pelvic appendage musculature phenotype', 'somite phenotype', 'musculature of body phenotype', 'increased size of the anatomical structure', 'anatomical entity morphology phenotype', 'epithelial vesicle phenotype', 'myotome phenotype', 'hypertrophic multicellular anatomical structure', 'organ system subdivision phenotype', 'organism subdivision', 'pelvic appendage musculature', 'musculature of limb', 'pelvic appendage muscle', 'hindlimb muscle', 'limb segment', 'mesenchyme morphology phenotype', 'Abnormal calf musculature morphology', 'skeletal musculature phenotype', 'increased size of the anatomical entity', 'paired limb/fin bud phenotype', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'striated muscle tissue', 'skeletal muscle organ, vertebrate', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'paired limb/fin phenotype', 'trunk mesenchyme phenotype', 'increased size of the skeletal muscle organ, vertebrate', 'entity', 'entity', 'paraxial mesoderm', 'paired limb/fin bud', 'main body axis', 'appendage', 'posterior region of body', 'body proper', 'skeletal muscle tissue', 'pelvic complex muscle', 'limb muscle', 'paired limb/fin segment', 'size of skeletal muscle tissue phenotype', 'anatomical system phenotype', 'leg phenotype', 'material anatomical entity', 'organ', 'subdivision of organism along appendicular axis', 'blastula', 'hindlimb zeugopod phenotype', 'skeletal muscle organ, vertebrate phenotype', 'presomitic mesoderm morphology phenotype', 'material anatomical entity phenotype', 'material entity', 'muscle tissue', 'muscle organ', 'entire embryonic mesenchyme', 'musculature of body', 'multi-limb segment region', 'musculature of lower limb', 'muscle of leg', 'lower limb segment', 'zeugopod', 'pelvic appendage phenotype', 'developing mesenchymal structure phenotype', 'skeletal muscle tissue morphology phenotype', 'muscle structure phenotype', 'subdivision of organism along main body axis phenotype', 'epithelium phenotype', 'structure with developmental contribution from neural crest phenotype', 'tissue', 'limb bud', 'epithelium', 'Abnormality of the lower limb', 'musculature of pelvic complex phenotype', 'pelvic appendage bud phenotype', 'Abnormality of the musculature', 'limb bud morphology phenotype', 'embryonic structure phenotype', 'mesoderm-derived structure phenotype', 'increased size of the striated muscle tissue', 'embryonic structure', 'somite', 'developing mesenchymal structure', 'embryonic tissue', 'mesenchyme', 'increased size of the organ', 'All', 'hindlimb zeugopod muscle morphology phenotype', 'phenotypic effect', 'hindlimb phenotype', 'multicellular organism phenotype', 'limb morphology phenotype', 'increased size of the multicellular anatomical structure', 'muscle organ morphology phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'surface structure', 'musculature', 'leg', 'Calf muscle hypertrophy', 'hypertrophic pelvic complex muscle', 'muscle tissue phenotype', 'appendage musculature phenotype', 'multilaminar epithelium phenotype', 'multicellular organism morphology phenotype', 'Abnormality of the musculature of the lower limbs', 'trunk phenotype', 'disconnected anatomical group', 'skeletal musculature', 'presomitic mesoderm', 'mesoderm-derived structure', 'muscle structure', 'trunk mesenchyme', 'musculature of lower limb phenotype', 'organ phenotype', 'material entity', 'size of anatomical entity phenotype', 'paired limb/fin segment phenotype', 'presumptive paraxial mesoderm', 'pelvic appendage', 'limb', 'pelvic complex', 'pelvic appendage bud', 'appendage musculature', 'musculature of pelvic complex', 'musculature of leg', 'hindlimb zeugopod muscle', 'hindlimb zeugopod', 'anatomical cluster phenotype', 'increased size of the mesoderm-derived structure', 'Muscle hypertrophy of the lower extremities', 'paraxial mesoderm phenotype', 'presomitic mesoderm phenotype', 'limb phenotype', 'anatomical cluster', 'myotome', 'paired limb/fin', 'appendage girdle complex', 'subdivision of organism along main body axis', 'hindlimb', 'hindlimb bud', 'epithelial vesicle', 'multilaminar epithelium', 'musculature of hindlimb zeugopod', 'phenotype', 'presumptive paraxial mesoderm phenotype', 'Phenotypic abnormality', 'increased size of the tissue', 'mesenchyme phenotype', 'dense mesenchyme tissue phenotype', 'increased size of the material anatomical entity', 'increased volume of anatomical entity', 'anatomical entity morphology in the pelvic complex phenotype', 'musculature of limb phenotype', 'anatomical entity', 'anatomical entity morphology in the appendage girdle complex phenotype', 'increased size of the skeletal muscle tissue', 'lateral structure phenotype', 'musculature phenotype', 'limb muscle morphology phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'anatomical structure phenotype', 'developing anatomical structure', 'organ system subdivision', 'dense mesenchyme tissue', 'trunk', 'subdivision of organism along appendicular axis phenotype', 'hindlimb bud phenotype', 'hindlimb zeugopod muscle phenotype', 'increased size of the muscle organ', 'Abnormal skeletal muscle morphology', 'paraxial mesoderm morphology phenotype', 'embryonic tissue morphology phenotype', 'Skeletal muscle hypertrophy', 'hindlimb bud morphology phenotype', 'anatomical entity phenotype', 'independent continuant', 'tissue phenotype', 'anatomical structure', 'anatomical system', 'multicellular organism'], 'frequency_qualifier_label': 'Occasional', 'frequency_qualifier_category': 'biolink:PhenotypicFeature', 'frequency_qualifier_namespace': 'HP', 'evidence_count': 1, 'grouping_key': 'MONDO:0011362|False|biolink:has_phenotype|HP:0008981', 'highlighting': None}, {'id': 'uuid:4341f4cc-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'disease_context_qualifier': 'MONDO:0011181', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:691', 'object': 'HP:0025584', 'original_subject': 'NCBIGene:401', 'subject_label': 'PHOX2A', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Hypotropia', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0087661', 'UPHENO:0049622', 'UPHENO:0002902', 'HP:0012373', 'UBERON:0002050', 'UBERON:0001048', 'UBERON:0010312', 'UBERON:0004456', 'UBERON:0000922', 'UBERON:0000970', 'UBERON:0010230', 'UBERON:0000307', 'UPHENO:0002526', 'BFO:0000002', 'UPHENO:0002866', 'UPHENO:0087597', 'UPHENO:0004433', 'UPHENO:0087232', 'UBERON:0000061', 'UBERON:0034923', 'UBERON:0000924', 'UPHENO:0086486', 'UPHENO:0087472', 'UPHENO:0004888', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002928', 'HP:0025588', 'UPHENO:0002386', 'UPHENO:0049587', 'UPHENO:0003236', 'NCBITaxon:33208', 'UBERON:0000923', 'UBERON:0004734', 'NBO:0000444', 'UPHENO:0002352', 'UPHENO:0005030', 'UPHENO:0001003', 'HP:0000486', 'UBERON:0015203', 'UBERON:0006800', 'UBERON:0003072', 'UBERON:0013702', 'NBO:0000313', 'UPHENO:0002403', 'UPHENO:0018418', 'UPHENO:0003189', 'UPHENO:0002765', 'UPHENO:0002531', 'UPHENO:0005058', 'BFO:0000001', 'UPHENO:0005029', 'UBERON:0000465', 'UBERON:0000466', 'BFO:0000040', 'UBERON:0001032', 'UBERON:0004923', 'UBERON:0000060', 'UPHENO:7000169', 'UPHENO:0087577', 'UPHENO:0002530', 'UPHENO:0002301', 'UPHENO:0002525', 'NCBITaxon:131567', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0004121', 'UBERON:0000468', 'NCBITaxon:6072', 'UBERON:0000490', 'UBERON:0003056', 'UPHENO:0003410', 'UPHENO:0003186', 'UPHENO:0002764', 'UPHENO:0079826', 'UPHENO:0002267', 'HP:0000549', 'UPHENO:0002926', 'BFO:0000001', 'UBERON:0000015', 'UBERON:0006598', 'UBERON:0010316', 'UBERON:0010222', 'UBERON:0000153', 'UBERON:0011676', 'UBERON:0013701', 'UPHENO:0002567', 'UPHENO:0002844', 'UPHENO:0002541', 'UPHENO:0002564', 'UPHENO:3000007', 'UBERON:0000467', 'UBERON:0000062', 'UBERON:0001444', 'UBERON:0007811', 'UBERON:0004088', 'UBERON:0001456', 'UPHENO:0001001', 'UPHENO:0088123', 'UPHENO:0002360', 'UPHENO:0002963', 'UPHENO:0002553', 'UPHENO:0002571', 'BFO:0000002', 'UBERON:0000964', 'UBERON:0000481', 'UBERON:0000020', 'NBO:0000001', 'UPHENO:0005110', 'UPHENO:0003163', 'UPHENO:0003020', 'UPHENO:0079828', 'UPHENO:0002430', 'UPHENO:0002568', 'NCBITaxon:33154', 'UBERON:0000064', 'UBERON:0016880', 'UBERON:0006601', 'UBERON:0016879', 'UPHENO:0087665', 'UPHENO:0004494', 'BFO:0000040', 'HP:0032012', 'UPHENO:0004757', 'HP:0000496', 'UPHENO:0076692', 'BFO:0000004', 'BFO:0000015', 'UBERON:0000047', 'UPHENO:0004721', 'UPHENO:0087660', 'UPHENO:0086589', 'UPHENO:0002219', 'UPHENO:0086679', 'UPHENO:0004615', 'HP:0025584', 'UPHENO:0002712', 'NCBITaxon:1', 'UBERON:0003071', 'UBERON:0012430', 'UBERON:0010313', 'UBERON:0000019', 'UBERON:0000483', 'UBERON:0002384', 'UBERON:0005291', 'HP:0000001', 'UPHENO:0005097', 'UPHENO:0087907', 'UPHENO:0002910', 'HP:0000478', 'UPHENO:0005141', 'UPHENO:0081581', 'BFO:0000004', 'UPHENO:0005055', 'UBERON:0001062', 'BFO:0000141', 'GO:0008150', 'UBERON:0000475', 'UPHENO:0086485', 'UPHENO:0001002', 'UPHENO:0002949', 'UPHENO:0004764', 'UPHENO:0002987', 'UPHENO:0002385', 'NCBITaxon:2759', 'GO:0032501', 'UBERON:0002104', 'UBERON:0001801', 'UBERON:0010409', 'UPHENO:0050106', 'UPHENO:0082875', 'UPHENO:0004482', 'UPHENO:0075997', 'UPHENO:7000183', 'UPHENO:0002550', 'UPHENO:0087924', 'UPHENO:0004680', 'UPHENO:0002536', 'UPHENO:0002308', 'UPHENO:0004519', 'UBERON:0001062', 'UBERON:0005423', 'UBERON:0010000', 'UBERON:0000063', 'UBERON:0000033', 'UPHENO:0004900', 'UPHENO:0018390', 'UPHENO:0003025', 'UPHENO:0002548', 'UPHENO:0004885', 'UPHENO:0002211', 'BFO:0000003', 'UBERON:0002346', 'UBERON:0004128', 'UBERON:0010371', 'UBERON:0000479', 'UBERON:0003075', 'GO:0007610', 'NBO:0000338'], 'object_closure_label': ['embryo phenotype', 'head morphology phenotype', 'face phenotype', 'Abnormality of the eye', 'developing anatomical structure phenotype', 'continuant', 'multicellular anatomical structure', 'multicellular organismal process', 'visual system', 'behavior process', 'multicellular organismal process phenotype', 'anatomical entity physiology phenotype', 'primordium phenotype', 'orbital region phenotype', 'cornea scarring; corneal scarring', 'germ layer morphology phenotype', 'craniocervical region morphology phenotype', 'camera-type eye physiology phenotype', 'sense organ phenotype', 'connective tissue phenotype', 'cellular organisms', 'presumptive structure', 'germ layer / neural crest', 'sense organ', 'embryo morphology phenotype', 'head phenotype', 'Hypodeviation', 'anterior segment of eyeball morphology phenotype', 'organism subdivision', 'immature eye phenotype', 'germ layer / neural crest phenotype', 'Heterotropia', 'eye phenotype', 'material anatomical entity physiology phenotype', 'Abnormal conjugate eye movement', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'process', 'embryonic tissue phenotype', 'neural crest-derived structure phenotype', 'camera-type eye morphology phenotype', 'presumptive structure phenotype', 'organ subunit phenotype', 'Abnormal eye physiology', 'behavior process phenotype', 'immaterial entity', 'biological_process', 'optic cup', 'body proper', 'eye movement', 'ectoderm morphology phenotype', 'phenotypic effect', 'subdivision of head phenotype', 'anatomical system phenotype', 'structure with developmental contribution from neural crest phenotype', 'cornea phenotype', 'organ component layer phenotype', 'anatomical structure physiology phenotype', 'material anatomical entity', 'immaterial anatomical entity', 'anatomical structure', 'disconnected anatomical group', 'organ', 'subdivision of head', 'craniocervical region', 'eye', 'eyeball of camera-type eye', 'blastula', 'cornea morphology phenotype', 'material anatomical entity phenotype', 'biological_process phenotype', 'pre-chordal neural plate phenotype', 'anatomical structure phenotype', 'material entity', 'sensory system', 'organ subunit', 'orbital region', 'face', 'body part movement', 'eye physiology phenotype', 'location of camera-type eye phenotype', 'craniocervical region phenotype', 'location of anatomical entity phenotype', 'subdivision of organism along main body axis phenotype', 'epithelium phenotype', 'organ part phenotype', 'simple eye phenotype', 'neurectoderm', 'optic vesicle', 'ecto-epithelium', 'tissue', 'neural plate', 'sensory system phenotype', 'gastrula morphology phenotype', 'ecto-epithelium phenotype', 'embryonic structure phenotype', 'future central nervous system phenotype', 'embryonic structure', 'primordium', 'immature eye', 'Metazoa', 'anatomical line between pupils', 'epithelium', 'connective tissue', 'embryonic tissue', 'All', 'camera-type eye phenotype', 'strabismus', 'lateral structure physiology phenotype', 'multicellular organism phenotype', 'vision/eye phenotype', 'root', 'structure with developmental contribution from neural crest', 'lateral structure', 'ectoderm-derived structure', 'entire sense organ system', 'organ component layer', 'anatomical wall', 'simple eye', 'visual system phenotype', 'neural plate phenotype', 'presumptive ectoderm phenotype', 'multicellular organism morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'neurectoderm phenotype', 'entity', 'non-material anatomical boundary', 'organ part', 'Eumetazoa', 'unilaminar epithelium', 'pre-chordal neural plate', 'kinesthetic behavior', 'organ phenotype', 'material entity', 'ectoderm-derived structure phenotype', 'germ layer phenotype', 'Abnormality of eye movement', 'anatomical entity morphology phenotype', 'occurrent', 'germ layer', 'gastrula', 'unilaminar epithelium phenotype', 'behavior phenotype', 'Strabismus', 'sense organ physiology phenotype', 'non-connected functional system', 'anatomical line', 'eye primordium', 'tunica fibrosa of eyeball', 'neural crest-derived structure', 'camera-type eye', 'anterior region of body', 'subdivision of organism along main body axis', 'main body axis', 'ectoderm', 'phenotype', 'eye primordium phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'multi-tissue structure phenotype', 'Hypotropia', 'organ physiology phenotype', 'multicellular anatomical structure phenotype', 'anatomical entity', 'Opisthokonta', 'behavior', 'optic cup morphology phenotype', 'face morphology phenotype', 'neural plate morphology phenotype', 'ectoderm phenotype', 'continuant', 'eyeball of camera-type eye phenotype', 'eye movement phenotype', 'simple eye physiology phenotype', 'taxon specific phenotype', 'independent continuant', 'entity', 'anatomical wall phenotype', 'optic vesicle phenotype', 'ocular surface region morphology phenotype', 'Eukaryota', 'cornea', 'multi-tissue structure', 'embryo', 'head', 'structure with developmental contribution from neural crest physiology phenotype', 'embryonic tissue morphology phenotype', 'anatomical entity phenotype', 'tissue phenotype', 'ectoderm-derived structure physiology phenotype', 'developing anatomical structure', 'anatomical system', 'multicellular organism', 'future nervous system', 'presumptive ectoderm', 'future central nervous system', 'anterior segment of eyeball', 'ocular surface region'], 'disease_context_qualifier_label': 'fibrosis of extraocular muscles, congenital, 2', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0001584', 'MONDO:0024458', 'MONDO:0004746', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0007614', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0003569', 'MONDO:0002022', 'MONDO:0011181', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0000462', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0100545', 'MONDO:0002081'], 'disease_context_qualifier_closure_label': ['cranial nerve neuropathy', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'ocular motility disease', 'disorder of visual system', 'neuromuscular disease', 'fibrosis of extraocular muscles, congenital, 2', 'congenital fibrosis of extraocular muscles', 'progressive muscular dystrophy', 'eye adnexa disorder', 'disorder of orbital region', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'myopathy of extraocular muscle', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'evidence_count': 0, 'grouping_key': 'HGNC:691||biolink:has_phenotype|HP:0025584', 'highlighting': None}, {'id': 'uuid:43797449-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:GeneToPhenotypicFeatureAssociation', 'agent_type': 'automated_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative'], 'knowledge_level': 'logical_entailment', 'primary_knowledge_source': 'infores:hpo-annotations', 'publications': ['PMID:11805270'], 'has_count': 1, 'has_percentage': 100.0, 'has_quotient': 1.0, 'has_total': 1, 'disease_context_qualifier': 'MONDO:0013686', 'provided_by': 'hpoa_gene_to_phenotype_edges', 'subject': 'HGNC:1529', 'object': 'HP:0001962', 'original_subject': 'NCBIGene:859', 'subject_label': 'CAV3', 'subject_category': 'biolink:Gene', 'subject_namespace': 'HGNC', 'subject_taxon': 'NCBITaxon:9606', 'subject_taxon_label': 'Homo sapiens', 'object_label': 'Palpitations', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0004507', 'HP:0011025', 'UBERON:0001009', 'UPHENO:0002406', 'HP:0001626', 'HP:0000118', 'HP:0011675', 'UPHENO:0002352', 'HP:0030956', 'UPHENO:0001003', 'GO:0003013', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0002553', 'UBERON:0000465', 'BFO:0000015', 'BFO:0000040', 'UPHENO:0001002', 'UPHENO:0002530', 'UPHENO:9002003', 'UPHENO:0002525', 'UBERON:0010314', 'UBERON:0000468', 'HP:0001962', 'UPHENO:0002267', 'UBERON:0010000', 'UBERON:0000467', 'UPHENO:0002963', 'BFO:0000002', 'GO:0060047', 'BFO:0000001', 'BFO:0000040', 'BFO:0000001', 'BFO:0000004', 'UBERON:0004535', 'HP:0000001', 'BFO:0000004', 'UPHENO:0001001', 'UPHENO:0002385', 'GO:0008150', 'GO:0032501', 'UPHENO:0082875', 'UPHENO:0002269', 'UPHENO:0002536', 'UBERON:0001062', 'UBERON:0000061', 'UPHENO:0002568', 'UBERON:0001062', 'BFO:0000003', 'GO:0003008', 'GO:0003015', 'GO:0008015'], 'object_closure_label': ['circulatory system phenotype', 'multicellular anatomical structure phenotype', 'continuant', 'multicellular organismal process', 'circulatory system process', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'material anatomical entity physiology phenotype', 'anatomical entity', 'independent continuant', 'cardiovascular system phenotype', 'entity', 'entity', 'continuant', 'anatomical system phenotype', 'anatomical structure physiology phenotype', 'material anatomical entity', 'material anatomical entity phenotype', 'Abnormal cardiovascular system physiology', 'Arrhythmia', 'anatomical structure phenotype', 'material entity', 'heart contraction', 'phenotype', 'multicellular organism phenotype', 'structure with developmental contribution from neural crest phenotype', 'Abnormality of the cardiovascular system', 'All', 'phenotypic effect', 'structure with developmental contribution from neural crest', 'circulatory system', 'Palpitations', 'heart process', 'blood circulation', 'material entity', 'anatomical entity', 'occurrent', 'process', 'cardiovascular system', 'Phenotypic abnormality', 'system process', 'taxon specific phenotype', 'independent continuant', 'cardiovascular system physiology phenotype', 'biological_process', 'structure with developmental contribution from neural crest physiology phenotype', 'Abnormality of cardiovascular system electrophysiology', 'anatomical entity phenotype', 'anatomical structure', 'multicellular anatomical structure', 'anatomical system', 'multicellular organism'], 'disease_context_qualifier_label': 'distal myopathy, Tateyama type', 'disease_context_qualifier_category': 'biolink:Disease', 'disease_context_qualifier_namespace': 'MONDO', 'disease_context_qualifier_closure': ['MONDO:0013686', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0000429', 'MONDO:0003847', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0000426', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0018949', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0016108', 'MONDO:0100545', 'MONDO:0002081'], 'disease_context_qualifier_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'autosomal dominant disease', 'distal myopathy', 'autosomal dominant distal myopathy', 'myopathy', 'human disease', 'distal myopathy, Tateyama type', 'muscle tissue disorder', 'nervous system disorder', 'disease', 'autosomal genetic disease', 'hereditary disease'], 'evidence_count': 1, 'grouping_key': 'HGNC:1529||biolink:has_phenotype|HP:0001962', 'highlighting': None}]}, 'facet_counts': {'facet_fields': {}, 'facet_queries': {'(category:"biolink:DiseaseToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 4193, '(category:"biolink:GeneToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:PairwiseGeneToGeneInteraction") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToPathwayAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToExpressionSiteAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToGeneHomologyAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:ChemicalToPathwayAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:MacromolecularMachineToMolecularActivityAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:MacromolecularMachineToCellularComponentAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:MacromolecularMachineToBiologicalProcessAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:CausalGeneToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:CorrelatedGeneToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:VariantToGeneAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:VariantToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToDiseaseAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:ChemicalOrDrugOrTreatmentToDiseaseOrPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:VariantToPhenotypicFeatureAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToGeneAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToVariantAssociation") AND (subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121")': 0, '(category:"biolink:DiseaseToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 2907, '(category:"biolink:PairwiseGeneToGeneInteraction") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToPathwayAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToExpressionSiteAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GeneToGeneHomologyAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:ChemicalToPathwayAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:MacromolecularMachineToMolecularActivityAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:MacromolecularMachineToCellularComponentAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:MacromolecularMachineToBiologicalProcessAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:CausalGeneToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 126, '(category:"biolink:CorrelatedGeneToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 150, '(category:"biolink:VariantToGeneAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:VariantToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 340, '(category:"biolink:GenotypeToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToDiseaseAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 243, '(category:"biolink:ChemicalOrDrugOrTreatmentToDiseaseOrPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 4, '(category:"biolink:VariantToPhenotypicFeatureAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToGeneAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0, '(category:"biolink:GenotypeToVariantAssociation") AND (object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121")': 0}}, 'highlighting': {}}
