
import pytest

@pytest.fixture
def association_table_response():
    return {'responseHeader': {'QTime': 1, 'params': {'mm': '100%', 'q': '*:*', 'defType': 'edismax', 'facet_min_count': '1', 'hl': 'false', 'start': '0', 'q.op': 'AND', 'fq': ['category:biolink\\:DiseaseToPhenotypicFeatureAssociation', 'subject:"MONDO:0020121" OR subject_closure:"MONDO:0020121" OR object:"MONDO:0020121" OR object_closure:"MONDO:0020121" OR disease_context_qualifier:"MONDO:0020121" OR disease_context_qualifier_closure:"MONDO:0020121"'], 'facet.mincount': '1', 'sort': 'frequency_computed_sortable_float desc, evidence_count desc, subject_label asc, predicate asc, object_label asc, primary_knowledge_source asc', 'rows': '5', 'facet': 'true'}}, 'response': {'num_found': 4193, 'start': 0, 'docs': [{'id': 'uuid:56641af8-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0006017'], 'publications': ['PMID:16075202', 'PMID:11381124', 'PMID:11506412', 'PMID:20729548', 'PMID:20106987'], 'negated': False, 'has_count': 7, 'has_percentage': 100.0, 'has_quotient': 1.0, 'has_total': 7, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0958235', 'object': 'HP:0006094', 'original_subject': 'OMIM:620727', 'subject_label': 'Ullrich congenital muscular dystrophy 1B', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0700096', 'MONDO:0958235', 'MONDO:0020121', 'MONDO:0000355', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['Ullrich congenital muscular dystrophy', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'Ullrich congenital muscular dystrophy 1B', 'neuromuscular disease', 'congenital muscular dystrophy', 'congenital myopathy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'object_label': 'Finger joint hypermobility', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002593', 'UPHENO:0002577', 'HP:0006256', 'UPHENO:0002648', 'BFO:0000001', 'UBERON:0002050', 'UBERON:0002204', 'UBERON:0000922', 'UBERON:0000075', 'UPHENO:0002526', 'UPHENO:0076703', 'UPHENO:0003812', 'UPHENO:0081439', 'UPHENO:0076943', 'UPHENO:0084448', 'UPHENO:0003432', 'UPHENO:0002733', 'UPHENO:0076944', 'UBERON:0000926', 'UBERON:0002102', 'UBERON:0005417', 'UPHENO:0086769', 'UPHENO:0084763', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0003159', 'UPHENO:0002870', 'UPHENO:0002896', 'HP:0011844', 'UPHENO:0002467', 'UPHENO:0003065', 'UPHENO:0002880', 'UPHENO:0002830', 'UPHENO:0003799', 'UBERON:0000923', 'UBERON:0002101', 'UBERON:0004710', 'UBERON:0010708', 'UBERON:0005419', 'UBERON:0011249', 'UPHENO:0002746', 'UPHENO:0003095', 'UPHENO:0087347', 'UPHENO:0002905', 'HP:0034430', 'HP:0000924', 'UPHENO:0002559', 'UPHENO:0002983', 'UPHENO:0086546', 'HP:0033127', 'UPHENO:0002564', 'UPHENO:0002976', 'UPHENO:0004466', 'UBERON:0004770', 'UBERON:0004288', 'UBERON:0004357', 'UBERON:0000026', 'UBERON:5002544', 'UBERON:0005881', 'UPHENO:0087006', 'BFO:0000002', 'UPHENO:0002708', 'UPHENO:0002945', 'UPHENO:0002782', 'BFO:0000040', 'UBERON:0011582', 'UBERON:0001015', 'UBERON:0010912', 'UBERON:0001434', 'HP:0001167', 'UPHENO:0001002', 'HP:0006094', 'UPHENO:0004892', 'UPHENO:0002530', 'UPHENO:0003049', 'UPHENO:0076727', 'UPHENO:0002568', 'UBERON:0000465', 'UBERON:0010314', 'UBERON:0015212', 'UBERON:0003102', 'UBERON:0000468', 'UBERON:0003657', 'UBERON:0002529', 'UPHENO:0003227', 'UPHENO:0004909', 'UPHENO:0002632', 'UPHENO:0002542', 'UPHENO:0002267', 'UPHENO:0002926', 'UBERON:0034925', 'UBERON:0010316', 'UBERON:0003081', 'UBERON:0002389', 'UBERON:0010740', 'UPHENO:0002567', 'UPHENO:0002747', 'UPHENO:0002541', 'UPHENO:0087663', 'UPHENO:0081440', 'UPHENO:0086635', 'UBERON:0010000', 'UBERON:0000467', 'UBERON:0000062', 'UBERON:0010758', 'UBERON:0004765', 'UBERON:0001474', 'UBERON:0006058', 'UBERON:0010363', 'UBERON:0002398', 'UBERON:0005451', 'UBERON:0012140', 'UBERON:0012354', 'UPHENO:0001001', 'HP:0001155', 'HP:0011842', 'UPHENO:0088123', 'HP:0002817', 'UPHENO:0002650', 'UPHENO:0002963', 'UPHENO:0002553', 'UPHENO:0002571', 'UPHENO:0002600', 'UPHENO:0005092', 'BFO:0000002', 'UBERON:0004120', 'UBERON:0011216', 'UBERON:0034921', 'UBERON:0003839', 'UBERON:0002470', 'UBERON:0008785', 'UBERON:0012139', 'HP:0011729', 'UPHENO:0003163', 'UPHENO:0002816', 'UPHENO:0004476', 'UPHENO:0001003', 'UPHENO:0003514', 'UBERON:0001062', 'BFO:0000001', 'UBERON:0010130', 'UBERON:0000982', 'UBERON:0010538', 'UPHENO:0002944', 'UPHENO:0087665', 'UPHENO:0003415', 'UPHENO:0086633', 'BFO:0000040', 'UPHENO:0003066', 'UPHENO:0077419', 'UPHENO:0002643', 'UPHENO:0076692', 'UPHENO:0084761', 'HP:0011297', 'UPHENO:0002525', 'UPHENO:0086700', 'UPHENO:0079876', 'HP:0011843', 'BFO:0000004', 'UBERON:0006598', 'UBERON:0004381', 'UBERON:0002513', 'UBERON:0001460', 'UBERON:0015061', 'UPHENO:0077421', 'UPHENO:0087660', 'UPHENO:0005214', 'UPHENO:0002536', 'UPHENO:0003366', 'HP:0040064', 'UPHENO:0076697', 'UBERON:0004708', 'UBERON:0010707', 'UBERON:0005291', 'UBERON:0003104', 'UBERON:0000153', 'UBERON:0012141', 'HP:0000001', 'UPHENO:0002861', 'HP:0001382', 'HP:0002813', 'UPHENO:0081581', 'BFO:0000004', 'UPHENO:0002554', 'UBERON:0001062', 'UBERON:0000475', 'UBERON:0004375', 'UBERON:0002428', 'UPHENO:0002949', 'UPHENO:0002586', 'HP:0040068', 'UPHENO:0002385', 'RO:0002577', 'UBERON:0004905', 'UBERON:0010712', 'UBERON:0002091', 'UPHENO:0082875', 'UPHENO:0002269', 'UPHENO:0004680', 'UPHENO:0003015', 'UPHENO:0087849', 'UPHENO:0076723', 'UPHENO:0002964', 'UPHENO:0002308', 'UPHENO:0004475', 'UBERON:0005423', 'UBERON:0000061', 'UBERON:0000383', 'UBERON:0007524', 'UBERON:5002389', 'UBERON:0002544', 'UPHENO:0076740', 'UPHENO:0004900', 'UPHENO:0004885', 'UPHENO:0003005', 'UPHENO:0003334', 'HP:0430046', 'UBERON:0000479', 'UBERON:0004347'], 'object_closure_label': ['appendicular skeleton morphology phenotype', 'embryo phenotype', 'appendage phenotype', 'Joint hypermobility', 'developing anatomical structure phenotype', 'mesoderm morphology phenotype', 'multi-limb segment region phenotype', 'limb bone morphology phenotype', 'limb endochondral element phenotype', 'musculoskeletal system phenotype', 'continuant', 'system', 'articulation', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'increased skeletal joint mobility', 'germ layer morphology phenotype', 'paired limb/fin skeleton phenotype', 'skeletal joint physiology phenotype', 'anatomical entity phenotype', 'limb bud phenotype', 'Abnormality of limbs', 'lateral plate mesoderm morphology phenotype', 'material anatomical entity', 'germ layer / neural crest', 'lateral plate mesoderm', 'manual digit', 'bone of appendage girdle complex', 'limb segment phenotype', 'embryo morphology phenotype', 'surface structure phenotype', 'Abnormal limb bone morphology', 'bone element phenotype', 'limb bone phenotype', 'anatomical entity mobility phenotype', 'anatomical entity morphology in the manus phenotype', 'musculature of body phenotype', 'autopodial extension phenotype', 'organ system subdivision phenotype', 'pectoral appendage bud phenotype', 'organism subdivision', 'limb joint', 'limb segment', 'germ layer / neural crest phenotype', 'articulation phenotype', 'mesenchyme morphology phenotype', 'manus morphology phenotype', 'paired limb/fin bud phenotype', 'material anatomical entity physiology phenotype', 'organism subdivision phenotype', 'independent continuant', 'presumptive structure', 'skeleton of limb', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'manus phenotype', 'paired limb/fin phenotype', 'autopod region phenotype', 'Abnormality of hand joint mobility', 'anatomical entity', 'entity', 'paired limb/fin bud', 'appendage', 'digit plus metapodial segment', 'autopodial extension', 'skeletal joint', 'paired limb/fin segment', 'bone of appendage girdle complex phenotype', 'Abnormality of joint mobility', 'continuant', 'lateral plate mesoderm phenotype', 'anatomical system phenotype', 'structure with developmental contribution from neural crest phenotype', 'upper limb segment phenotype', 'Abnormality of limb bone', 'anatomical structure physiology phenotype', 'organ', 'subdivision of organism along appendicular axis', 'skeletal element', 'Abnormal finger morphology', 'Abnormality of the upper limb', 'material anatomical entity phenotype', 'anatomical collection phenotype', 'paired limb/fin segment phenotype', 'material entity', 'paired limb/fin skeleton', 'musculature of body', 'bone element', 'multi-limb segment region', 'endochondral element', 'forelimb joint', 'autopod region', 'upper limb segment', 'segment of autopod', 'mesoderm phenotype', 'anatomical structure phenotype', 'digit morphology phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'Abnormal musculoskeletal physiology', 'tissue', 'limb bud', 'embryonic autopod plate morphology phenotype', 'forelimb phenotype', 'forelimb morphology phenotype', 'limb bud morphology phenotype', 'taxon specific phenotype', 'pectoral appendage phenotype', 'embryonic structure phenotype', 'mesoderm-derived structure phenotype', 'embryonic structure', 'embryonic tissue', 'mesenchyme', 'anterior region of body', 'All', 'phenotypic effect', 'Finger joint hypermobility', 'subdivision of skeleton phenotype', 'multicellular organism phenotype', 'musculoskeletal system physiology phenotype', 'limb morphology phenotype', 'structure with developmental contribution from neural crest', 'lateral structure', 'surface structure', 'musculoskeletal system', 'musculature', 'subdivision of skeleton', 'skeletal system', 'endochondral bone', 'arm', 'limb endochondral element', 'skeleton of limb phenotype', 'digit phenotype', 'Abnormal joint physiology', 'Abnormality of the skeletal system', 'multicellular organism morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'forelimb bud phenotype', 'anatomical collection', 'mesoderm-derived structure', 'organ phenotype', 'skeletal system morphology phenotype', 'material entity', 'germ layer phenotype', 'endochondral element phenotype', 'skeletal joint phenotype', 'increased anatomical entity mobility', 'multi organ part structure phenotype', 'anatomical entity morphology phenotype', 'manual digit morphology in the manus phenotype', 'Abnormal digit morphology', 'entity', 'germ layer', 'limb', 'pectoral appendage', 'pectoral complex', 'pectoral appendage bud', 'appendicular skeletal system', 'manus', 'segment of manus', 'digitopodium region', 'acropodium region', 'skeletal element phenotype', 'endochondral bone phenotype', 'limb skeleton subdivision phenotype', 'bone of free limb or fin phenotype', 'dense mesenchyme tissue phenotype', 'tissue phenotype', 'Small joint hypermobilty', 'arm phenotype', 'limb phenotype', 'skeleton phenotype', 'articular system', 'skeleton', 'paired limb/fin', 'appendage girdle complex', 'mesoderm', 'forelimb', 'forelimb bud', 'manual digitopodium region', 'phenotype', 'autopod region morphology phenotype', 'Phenotypic abnormality', 'lateral structure phenotype', 'mesenchyme phenotype', 'Abnormal appendicular skeleton morphology', 'multi organ part structure physiology phenotype', 'anatomical entity', 'bone of free limb or fin', 'limb bone', 'anatomical entity morphology in the appendage girdle complex phenotype', 'appendicular skeleton phenotype', 'musculature phenotype', 'manual digit phenotype', 'Abnormality of the musculoskeletal system', 'independent continuant', 'skeletal joint mobility phenotype', 'organ system subdivision', 'multi organ part structure', 'embryo', 'subdivision of skeletal system', 'dense mesenchyme tissue', 'manual digit plus metapodial segment', 'digit', 'subdivision of skeletal system phenotype', 'subdivision of organism along appendicular axis phenotype', 'forelimb bud morphology phenotype', 'Abnormality of the hand', 'Abnormal skeletal morphology', 'embryonic tissue morphology phenotype', 'skeletal system phenotype', 'multicellular anatomical structure phenotype', 'developing anatomical structure', 'anatomical structure', 'multicellular anatomical structure', 'anatomical system', 'multicellular organism', 'embryonic autopod plate', 'limb skeleton subdivision', 'appendicular skeleton'], 'evidence_count': 6, 'grouping_key': 'MONDO:0958235|False|biolink:has_phenotype|HP:0006094', 'highlighting': None}, {'id': 'uuid:56641af3-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0006017'], 'publications': ['PMID:16075202', 'PMID:11381124', 'PMID:11506412', 'PMID:20729548', 'PMID:20106987'], 'negated': False, 'has_count': 5, 'has_percentage': 100.0, 'has_quotient': 1.0, 'has_total': 5, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0958235', 'object': 'HP:0001252', 'original_subject': 'OMIM:620727', 'subject_label': 'Ullrich congenital muscular dystrophy 1B', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0700096', 'MONDO:0958235', 'MONDO:0020121', 'MONDO:0000355', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['Ullrich congenital muscular dystrophy', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'Ullrich congenital muscular dystrophy 1B', 'neuromuscular disease', 'congenital muscular dystrophy', 'congenital myopathy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'object_label': 'Hypotonia', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0066939', 'UPHENO:0002577', 'UPHENO:0002311', 'UPHENO:0002636', 'BFO:0000001', 'UBERON:0005173', 'UBERON:0000489', 'UBERON:0006555', 'UPHENO:0002526', 'UPHENO:0066903', 'UPHENO:0066927', 'UPHENO:0003432', 'UPHENO:0002803', 'UBERON:0000061', 'UBERON:0007503', 'UBERON:0004819', 'UPHENO:0051280', 'UPHENO:0066950', 'HP:0000118', 'UPHENO:0002731', 'UPHENO:0002422', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UPHENO:0004791', 'UPHENO:0049587', 'UPHENO:0002385', 'UBERON:8450002', 'UPHENO:0066960', 'UPHENO:0066943', 'UPHENO:0003430', 'HP:0003011', 'HP:0033127', 'UPHENO:0002564', 'UPHENO:0004969', 'UPHENO:0002976', 'UBERON:0002113', 'UBERON:0009569', 'UBERON:0013702', 'GO:0003014', 'UPHENO:0066921', 'BFO:0000002', 'UPHENO:0002411', 'UPHENO:0002531', 'UPHENO:0005201', 'UPHENO:0003381', 'UPHENO:0003088', 'BFO:0000015', 'BFO:0000040', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0002530', 'UPHENO:7000439', 'UPHENO:0005285', 'UPHENO:0024906', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0015212', 'UBERON:0000468', 'UBERON:0003914', 'UPHENO:0001001', 'UPHENO:0066954', 'UPHENO:0003047', 'UPHENO:0002252', 'UPHENO:0066951', 'UPHENO:0049703', 'UPHENO:0082557', 'UPHENO:0002267', 'UPHENO:0002926', 'BFO:0000001', 'UBERON:0011676', 'UBERON:0013701', 'UBERON:0004211', 'UBERON:0007684', 'UBERON:0009773', 'UPHENO:0002567', 'UPHENO:0002320', 'UPHENO:0004360', 'UPHENO:0002541', 'UBERON:0000467', 'UBERON:0000062', 'UBERON:0004111', 'UPHENO:0002248', 'UPHENO:0002360', 'UPHENO:0002963', 'UPHENO:0002571', 'UPHENO:0002442', 'HP:0011804', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UBERON:0005177', 'UBERON:0003103', 'UBERON:0000025', 'UBERON:0000922', 'UPHENO:0003094', 'UPHENO:0002668', 'UPHENO:7000425', 'UPHENO:0003163', 'UPHENO:0002816', 'UPHENO:0001003', 'UBERON:0000064', 'HP:0003808', 'BFO:0000040', 'UPHENO:0002754', 'UPHENO:0002210', 'BFO:0000004', 'UBERON:0006598', 'UBERON:0005172', 'UPHENO:0002832', 'UPHENO:0002909', 'UPHENO:0002346', 'UPHENO:0066959', 'UPHENO:0002536', 'UBERON:0011143', 'UBERON:0005291', 'UBERON:0003104', 'UPHENO:0066946', 'HP:0000001', 'UPHENO:0002377', 'UPHENO:0066964', 'UPHENO:0003050', 'UPHENO:0005141', 'BFO:0000004', 'UBERON:0001062', 'GO:0008150', 'UBERON:0000475', 'UBERON:0001231', 'UPHENO:0082555', 'UPHENO:0002287', 'UPHENO:0075902', 'UPHENO:0001002', 'UPHENO:0003093', 'HP:0001252', 'UPHENO:0002949', 'UPHENO:0066913', 'UBERON:0005423', 'GO:0032501', 'UPHENO:0050106', 'UPHENO:0082875', 'UPHENO:0002269', 'UPHENO:0002426', 'UPHENO:0002859', 'UPHENO:0002308', 'UPHENO:0002427', 'UPHENO:0003413', 'UBERON:0001062', 'UBERON:0010000', 'UBERON:0001285', 'UBERON:0000383', 'UBERON:0001008', 'UBERON:0003918', 'UBERON:0002417', 'UBERON:0002100', 'UBERON:0000916', 'UPHENO:0066925', 'UPHENO:0003941', 'UPHENO:0004900', 'UPHENO:0002246', 'UPHENO:0003025', 'UPHENO:0051191', 'UPHENO:0002568', 'UPHENO:0005277', 'BFO:0000003', 'UBERON:0007688', 'UBERON:0002050', 'UBERON:0000479', 'UBERON:0000483', 'GO:0003008', 'GO:0070293'], 'object_closure_label': ['decreased functionality of the multicellular anatomical structure', 'nephron epithelium phenotype', 'embryo phenotype', 'decreased functionality of the anatomical conduit', 'developing anatomical structure phenotype', 'multicellular anatomical structure phenotype', 'renal system physiology phenotype', 'Abnormal muscle physiology', 'continuant', 'multicellular anatomical structure', 'multicellular organismal process', 'renal system process', 'multicellular organismal process phenotype', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'abdominal segment element physiology phenotype', 'abdominal segment element phenotype', 'anatomical entity phenotype', 'material anatomical entity', 'trunk region element', 'compound organ', 'tube', 'embryo', 'nephron epithelium', 'uriniferous tubule', 'renal tubule', 'anlage phenotype', 'subdivision of trunk phenotype', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'decreased functionality of the anatomical entity', 'musculature of body phenotype', 'epithelial vesicle phenotype', 'organ system subdivision phenotype', 'anlage', 'embryonic structure', 'organism subdivision', 'renal system phenotype', 'cavitated compound organ phenotype', 'tube phenotype', 'compound organ phenotype', 'material anatomical entity physiology phenotype', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'presumptive structure', 'embryonic tissue phenotype', 'muscle organ physiology phenotype', 'presumptive structure phenotype', 'kidney physiology phenotype', 'anatomical conduit physiology phenotype', 'decreased muscle organ tone', 'biological_process', 'kidney', 'subdivision of trunk', 'body proper', 'muscle tone', 'phenotypic effect', 'continuant', 'trunk region element physiology phenotype', 'Hypotonia', 'anatomical system phenotype', 'decreased functionality of the material anatomical entity', 'anatomical structure', 'organ', 'anatomical conduit', 'abdominal segment element', 'cavitated compound organ', 'excretory tube', 'material anatomical entity phenotype', 'excretory tube phenotype', 'biological_process phenotype', 'anatomical structure phenotype', 'material entity', 'muscle organ', 'nephron', 'musculature of body', 'renal system', 'decreased functionality of the tissue', 'decreased functionality of the epithelial tube', 'muscle structure phenotype', 'subdivision of organism along main body axis phenotype', 'epithelium phenotype', 'organ part phenotype', 'kidney epithelium phenotype', 'nephron phenotype', 'trunk region element phenotype', 'tissue', 'epithelium', 'renal absorption phenotype', 'Abnormal muscle tone', 'cavitated compound organ physiology phenotype', 'epithelial tube physiology phenotype', 'Abnormality of the musculature', 'taxon specific phenotype', 'embryonic structure phenotype', 'embryonic tissue', 'mesenchyme', 'decreased functionality of the kidney epithelium', 'All', 'compound organ physiology phenotype', 'epithelium physiology phenotype', 'lateral structure physiology phenotype', 'multicellular organism phenotype', 'lateral structure', 'musculature', 'abdomen element', 'phenotype', 'multicellular anatomical structure physiology phenotype', 'abdomen element physiology phenotype', 'trunk phenotype', 'entity', 'muscle structure', 'organ part', 'epithelial tube', 'renal absorption', 'organ phenotype', 'material entity', 'renal system process phenotype', 'tube physiology phenotype', 'entity', 'occurrent', 'excretory system', 'abdomen element phenotype', 'anatomical conduit phenotype', 'decreased functionality of the tube', 'decreased functionality of the epithelium', 'decreased functionality of the nephron tubule', 'nephron tubule phenotype', 'decreased functionality of the renal tubule', 'tissue physiology phenotype', 'decreased functionality of the nephron epithelium', 'system process phenotype', 'tissue phenotype', 'kidney mesenchyme phenotype', 'anatomical structure physiology phenotype', 'process', 'upper urinary tract', 'subdivision of organism along main body axis', 'main body axis', 'epithelial vesicle', 'kidney epithelium', 'decreased functionality of the excretory tube', 'Phenotypic abnormality', 'lateral structure phenotype', 'mesenchyme phenotype', 'organ physiology phenotype', 'renal tubule phenotype', 'anatomical entity', 'system process', 'nephron tubule', 'decreased anatomical entity tone', 'excretory tube physiology phenotype', 'upper urinary tract phenotype', 'decreased functionality of the anatomical structure', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'independent continuant', 'kidney phenotype', 'developing anatomical structure', 'organ system subdivision', 'kidney mesenchyme', 'abdominal segment of trunk', 'trunk', 'abdomen', 'impaired renal concentrating ability; isosthenuria', 'epithelial tube phenotype', 'anatomical entity dysfunction in independent continuant', 'anatomical system', 'multicellular organism'], 'evidence_count': 6, 'grouping_key': 'MONDO:0958235|False|biolink:has_phenotype|HP:0001252', 'highlighting': None}, {'id': 'uuid:56641b14-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0006017'], 'publications': ['PMID:16075202', 'PMID:11381124', 'PMID:20106987'], 'negated': False, 'has_count': 4, 'has_percentage': 100.0, 'has_quotient': 1.0, 'has_total': 4, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0958235', 'object': 'HP:0003557', 'original_subject': 'OMIM:620727', 'subject_label': 'Ullrich congenital muscular dystrophy 1B', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0700096', 'MONDO:0958235', 'MONDO:0020121', 'MONDO:0000355', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['Ullrich congenital muscular dystrophy', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'Ullrich congenital muscular dystrophy 1B', 'neuromuscular disease', 'congenital muscular dystrophy', 'congenital myopathy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'object_label': 'Increased variability in muscle fiber diameter', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002576', 'UPHENO:0002577', 'UBERON:0002050', 'UBERON:0002329', 'UBERON:0000307', 'UPHENO:0002526', 'UPHENO:0002731', 'UPHENO:0004545', 'UPHENO:0003432', 'UPHENO:0079572', 'UBERON:0000926', 'UBERON:0007503', 'UBERON:0000486', 'UPHENO:0004143', 'HP:0000118', 'UPHENO:0003022', 'UPHENO:0088180', 'UPHENO:0003234', 'CL:0002242', 'CL:0000183', 'CL:0000255', 'CL:0000211', 'UBERON:0007285', 'UBERON:0000923', 'HP:0003011', 'HP:0033127', 'UPHENO:0001003', 'UPHENO:0086457', 'UPHENO:0004969', 'UPHENO:0003160', 'UPHENO:0002976', 'UBERON:0000477', 'UBERON:0003077', 'UBERON:0013701', 'UBERON:0013702', 'HP:0004303', 'UPHENO:0003372', 'BFO:0000002', 'UPHENO:0003191', 'UPHENO:0002949', 'UPHENO:0079562', 'BFO:0000001', 'UBERON:0000465', 'BFO:0000040', 'UBERON:0002385', 'UBERON:0001630', 'UBERON:0009142', 'UBERON:0001015', 'UPHENO:0001002', 'UPHENO:0004892', 'UPHENO:0002568', 'UBERON:0017650', 'UBERON:0015212', 'UBERON:0000468', 'UBERON:0005256', 'CL:0002372', 'UPHENO:0087047', 'UPHENO:0003047', 'UPHENO:0002720', 'UPHENO:0005135', 'UPHENO:0002542', 'UPHENO:0086462', 'UPHENO:0002926', 'UBERON:0034923', 'UBERON:0000467', 'CL:0000000', 'UBERON:0010316', 'UBERON:0011676', 'UPHENO:0002567', 'UPHENO:0002541', 'UPHENO:0086477', 'UPHENO:0087663', 'UPHENO:0002564', 'UPHENO:0076710', 'UBERON:0010000', 'UBERON:0000062', 'HP:0011805', 'UPHENO:0086482', 'UPHENO:0088123', 'UPHENO:0002897', 'UPHENO:0086505', 'UPHENO:0002963', 'UPHENO:0002571', 'UBERON:0018254', 'UBERON:0003059', 'UBERON:0004120', 'UBERON:0005090', 'UBERON:0011216', 'UBERON:0000922', 'UPHENO:0003163', 'UPHENO:0002816', 'BFO:0000001', 'UBERON:0001134', 'UPHENO:0087665', 'UPHENO:0086172', 'BFO:0000040', 'HP:0012084', 'UPHENO:0076692', 'UPHENO:0077801', 'UPHENO:0002525', 'BFO:0000004', 'UBERON:0006598', 'CL:0000393', 'UBERON:0002036', 'UBERON:0014892', 'UPHENO:0087660', 'UBERON:0003082', 'UBERON:0005291', 'UBERON:0003104', 'HP:0000001', 'UPHENO:0002530', 'UPHENO:0005141', 'UPHENO:0081581', 'BFO:0000004', 'UPHENO:0002554', 'UBERON:0000475', 'UPHENO:0001001', 'RO:0002577', 'CL:4052002', 'CL:0000737', 'CL:0008002', 'UPHENO:0004680', 'UPHENO:0087849', 'UPHENO:0002536', 'UPHENO:0003413', 'UBERON:0001062', 'UBERON:0005423', 'UBERON:0000061', 'UBERON:0000383', 'CL:0000228', 'CL:0000187', 'CL:0000188', 'UBERON:0007524', 'UBERON:0002100', 'UPHENO:0004900', 'UPHENO:0079564', 'UPHENO:0003025', 'UPHENO:0004885', 'HP:0003557', 'UPHENO:0075195', 'UPHENO:0003081', 'UPHENO:0003182', 'UBERON:0001062', 'BFO:0000002', 'UBERON:0000479', 'UBERON:0000483'], 'object_closure_label': ['embryo phenotype', 'developing anatomical structure phenotype', 'myotome morphology phenotype', 'mesoderm morphology phenotype', 'system', 'germ layer morphology phenotype', 'anatomical system', 'cell', 'germ layer / neural crest', 'embryo', 'embryo morphology phenotype', 'cell phenotype', 'muscle organ phenotype', 'somite phenotype', 'musculature of body phenotype', 'epithelial vesicle phenotype', 'myotome phenotype', 'organ system subdivision phenotype', 'organism subdivision', 'myotube', 'germ layer / neural crest phenotype', 'mesenchyme morphology phenotype', 'skeletal musculature phenotype', 'organism subdivision phenotype', 'anatomical entity', 'independent continuant', 'presumptive structure', 'electrically responsive cell', 'striated muscle tissue', 'skeletal muscle organ, vertebrate', 'embryonic tissue phenotype', 'presumptive structure phenotype', 'trunk mesenchyme phenotype', 'size of skeletal muscle fiber phenotype', 'entity', 'paraxial mesoderm', 'main body axis', 'body proper', 'skeletal muscle tissue', 'continuant', 'anatomical system phenotype', 'material anatomical entity', 'organ', 'blastula', 'skeletal muscle organ, vertebrate phenotype', 'presomitic mesoderm morphology phenotype', 'material entity', 'muscle tissue', 'muscle organ', 'entire embryonic mesenchyme', 'musculature of body', 'multinucleate cell', 'muscle cell', 'cell of skeletal muscle', 'phenotype', 'developing mesenchymal structure phenotype', 'skeletal muscle tissue morphology phenotype', 'muscle structure phenotype', 'subdivision of organism along main body axis phenotype', 'mesoderm phenotype', 'material anatomical entity phenotype', 'epithelium phenotype', 'multicellular organism phenotype', 'morphology of muscle cell phenotype', 'anatomical structure phenotype', 'tissue', 'epithelium', 'morphology of cell of skeletal muscle phenotype', 'Abnormality of the musculature', 'embryonic structure phenotype', 'mesoderm-derived structure phenotype', 'embryonic structure', 'somite', 'embryonic tissue', 'mesenchyme', 'All', 'phenotypic effect', 'muscle organ morphology phenotype', 'developing mesenchymal structure', 'lateral structure', 'musculature', 'muscle tissue phenotype', 'multilaminar epithelium phenotype', 'multicellular organism morphology phenotype', 'trunk phenotype', 'disconnected anatomical group', 'skeletal musculature', 'presomitic mesoderm', 'mesoderm-derived structure', 'muscle structure', 'trunk mesenchyme', 'Abnormal muscle fiber morphology', 'organ phenotype', 'material entity', 'germ layer phenotype', 'Increased variability in muscle fiber diameter', 'size of anatomical entity phenotype', 'Abnormality of skeletal muscle fiber size', 'anatomical entity morphology phenotype', 'size of cell phenotype', 'anatomical entity', 'continuant', 'nucleate cell', 'contractile cell', 'eukaryotic cell', 'electrically active cell', 'presumptive paraxial mesoderm', 'germ layer', 'anatomical cluster phenotype', 'dense mesenchyme tissue phenotype', 'size of cell of skeletal muscle phenotype', 'paraxial mesoderm phenotype', 'presomitic mesoderm phenotype', 'anatomical cluster', 'myotome', 'subdivision of organism along main body axis', 'mesoderm', 'epithelial vesicle', 'multilaminar epithelium', 'presumptive paraxial mesoderm phenotype', 'Phenotypic abnormality', 'mesenchyme phenotype', 'cell of skeletal muscle morphology phenotype', 'lateral structure phenotype', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'independent continuant', 'entity', 'morphology of myotube phenotype', 'organ system subdivision', 'dense mesenchyme tissue', 'trunk', 'Abnormal skeletal muscle morphology', 'paraxial mesoderm morphology phenotype', 'embryonic tissue morphology phenotype', 'anatomical entity phenotype', 'tissue phenotype', 'multicellular anatomical structure phenotype', 'developing anatomical structure', 'anatomical structure', 'multicellular anatomical structure', 'multicellular organism', 'syncytial cell', 'striated muscle cell', 'skeletal muscle fiber'], 'evidence_count': 4, 'grouping_key': 'MONDO:0958235|False|biolink:has_phenotype|HP:0003557', 'highlighting': None}, {'id': 'uuid:56641af5-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0006017'], 'publications': ['PMID:16075202', 'PMID:11506412', 'PMID:20729548'], 'negated': False, 'has_count': 3, 'has_percentage': 100.0, 'has_quotient': 1.0, 'has_total': 3, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0958235', 'object': 'HP:0001270', 'original_subject': 'OMIM:620727', 'subject_label': 'Ullrich congenital muscular dystrophy 1B', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0020120', 'MONDO:0000001', 'MONDO:0002320', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0700096', 'MONDO:0958235', 'MONDO:0020121', 'MONDO:0000355', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['Ullrich congenital muscular dystrophy', 'hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'Ullrich congenital muscular dystrophy 1B', 'neuromuscular disease', 'congenital muscular dystrophy', 'congenital myopathy', 'myopathy', 'human disease', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'object_label': 'Motor delay', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['BFO:0000040', 'UPHENO:0002433', 'BFO:0000001', 'UBERON:0001016', 'HP:0012638', 'UBERON:0000061', 'HP:0000118', 'UPHENO:7000079', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0002530', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0000468', 'HP:0012759', 'UPHENO:0002267', 'BFO:0000001', 'UBERON:0000467', 'UPHENO:0002963', 'BFO:0000002', 'UPHENO:7000241', 'UPHENO:0001003', 'BFO:0000004', 'HP:0000707', 'HP:0012758', 'HP:0000001', 'HP:0001270', 'BFO:0000004', 'UBERON:0001062', 'BFO:0000040', 'UPHENO:0001001', 'UPHENO:0001002', 'UPHENO:0002385', 'UPHENO:0082875', 'UPHENO:0002269', 'UPHENO:0002536', 'UPHENO:0004523', 'UBERON:0001062', 'UBERON:0010000', 'UPHENO:0002568'], 'object_closure_label': ['Motor delay', 'multicellular anatomical structure phenotype', 'continuant', 'multicellular anatomical structure', 'anatomical entity physiology phenotype', 'anatomical system physiology phenotype', 'Neurodevelopmental delay', 'material anatomical entity', 'material anatomical entity physiology phenotype', 'anatomical entity', 'independent continuant', 'material entity', 'motor delay; motor developmental delay', 'phenotypic effect', 'continuant', 'anatomical system phenotype', 'anatomical structure physiology phenotype', 'anatomical structure', 'material entity', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'phenotype', 'multicellular organism phenotype', 'taxon specific phenotype', 'All', 'nervous system', 'Neurodevelopmental abnormality', 'nervous system phenotype', 'entity', 'vacuole', 'entity', 'Phenotypic abnormality', 'nervous system physiology phenotype', 'Abnormality of the nervous system', 'anatomical entity', 'independent continuant', 'Abnormal nervous system physiology', 'anatomical entity phenotype', 'anatomical system', 'multicellular organism'], 'evidence_count': 4, 'grouping_key': 'MONDO:0958235|False|biolink:has_phenotype|HP:0001270', 'highlighting': None}, {'id': 'uuid:50dea543-7730-11f0-81dd-0022484ab340', 'predicate': 'biolink:has_phenotype', 'category': 'biolink:DiseaseToPhenotypicFeatureAssociation', 'agent_type': 'manual_agent', 'aggregator_knowledge_source': ['infores:monarchinitiative', 'infores:hpo-annotations'], 'knowledge_level': 'knowledge_assertion', 'primary_knowledge_source': 'infores:omim', 'has_evidence': ['ECO:0006017'], 'publications': ['PMID:30808312', 'PMID:17886299'], 'negated': False, 'has_count': 4, 'has_percentage': 100.0, 'has_quotient': 1.0, 'has_total': 4, 'provided_by': 'hpoa_disease_to_phenotype_edges', 'subject': 'MONDO:0024530', 'object': 'HP:0003701', 'original_subject': 'OMIM:158810', 'subject_label': 'Bethlem myopathy 1A', 'subject_category': 'biolink:Disease', 'subject_namespace': 'MONDO', 'subject_closure': ['MONDO:0100225', 'MONDO:0020120', 'MONDO:0000001', 'MONDO:0002320', 'MONDO:0016106', 'MONDO:0003847', 'MONDO:0019952', 'MONDO:0024530', 'MONDO:0016139', 'MONDO:0700096', 'MONDO:0020121', 'MONDO:0003939', 'MONDO:0100546', 'MONDO:0005336', 'MONDO:0700223', 'MONDO:0008029', 'MONDO:0005071', 'MONDO:0019056', 'MONDO:0019950', 'MONDO:0100545', 'MONDO:0002081'], 'subject_closure_label': ['hereditary skeletal muscle disorder', 'muscular dystrophy', 'skeletal muscle disorder', 'hereditary neuromuscular disease', 'hereditary neurological disease', 'musculoskeletal system disorder', 'neuromuscular disease', 'congenital muscular dystrophy', 'progressive muscular dystrophy', 'Bethlem myopathy', 'congenital myopathy', 'myopathy', 'Bethlem myopathy 1A', 'qualitative or quantitative protein defects in neuromuscular diseases', 'human disease', 'collagen 6-related myopathy', 'muscle tissue disorder', 'nervous system disorder', 'congenital nervous system disorder', 'disease', 'hereditary disease'], 'object_label': 'Proximal muscle weakness', 'object_category': 'biolink:PhenotypicFeature', 'object_namespace': 'HP', 'object_closure': ['UPHENO:0002526', 'UPHENO:0003432', 'HP:0000118', 'UPHENO:0002359', 'UPHENO:0003022', 'UPHENO:0002386', 'UPHENO:0002385', 'HP:0003011', 'HP:0033127', 'UPHENO:0001003', 'UPHENO:0002976', 'UPHENO:0080555', 'UBERON:0001630', 'UBERON:0001015', 'UPHENO:0001002', 'UPHENO:0002530', 'UPHENO:0002568', 'UPHENO:0002525', 'UBERON:0000465', 'UBERON:0000468', 'UPHENO:0003047', 'UPHENO:0080556', 'UPHENO:0002267', 'UBERON:0000467', 'UPHENO:0002320', 'BFO:0000004', 'UBERON:0010000', 'UBERON:0000062', 'UPHENO:0001001', 'HP:0003701', 'UPHENO:0002963', 'HP:0011804', 'BFO:0000002', 'UBERON:0005090', 'UBERON:0011216', 'UPHENO:0002816', 'BFO:0000001', 'BFO:0000040', 'BFO:0000001', 'BFO:0000004', 'UPHENO:0002536', 'HP:0000001', 'BFO:0000040', 'BFO:0000002', 'UPHENO:0002949', 'UPHENO:0082875', 'UPHENO:0002308', 'UBERON:0001062', 'UBERON:0000061', 'UBERON:0000383', 'HP:0001324', 'UBERON:0001062'], 'object_closure_label': ['Abnormal muscle physiology', 'continuant', 'anatomical entity physiology phenotype', 'continuant', 'anatomical entity phenotype', 'material anatomical entity', 'anatomical system', 'muscle structure physiology phenotype', 'muscle organ phenotype', 'musculature of body phenotype', 'organ system subdivision phenotype', 'material anatomical entity physiology phenotype', 'anatomical entity', 'independent continuant', 'muscle organ physiology phenotype', 'decreased anatomical entity strength', 'entity', 'entity', 'material entity', 'anatomical system phenotype', 'organ', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'muscle organ', 'musculature of body', 'muscle structure phenotype', 'Muscle weakness', 'Abnormality of the musculature', 'All', 'phenotypic effect', 'multicellular organism phenotype', 'musculature', 'multicellular anatomical structure physiology phenotype', 'muscle structure', 'organ phenotype', 'material entity', 'anatomical entity', 'decreased muscle organ strength', 'anatomical structure physiology phenotype', 'phenotype', 'Phenotypic abnormality', 'organ physiology phenotype', 'musculature phenotype', 'Abnormality of the musculoskeletal system', 'taxon specific phenotype', 'organ system subdivision', 'Proximal muscle weakness', 'independent continuant', 'multicellular anatomical structure phenotype', 'anatomical structure', 'multicellular anatomical structure', 'multicellular organism'], 'evidence_count': 3, 'grouping_key': 'MONDO:0024530|False|biolink:has_phenotype|HP:0003701', 'highlighting': None}]}, 'facet_counts': {'facet_fields': {}, 'facet_queries': {}}, 'highlighting': {}}
