
import pytest

@pytest.fixture
def autocomplete_response():
    return {'responseHeader': {'QTime': 1, 'params': {'mm': '100%', 'q': 'fanc', 'defType': 'edismax', 'facet_min_count': '1', 'hl': 'false', 'qf': 'id^100 name^10 name_t^5 name_ac symbol^10 symbol_t^5 symbol_ac synonym synonym_t synonym_ac description_t xref', 'start': '0', 'q.op': 'AND', 'boost': 'product(if(termfreq(category,"biolink:PhenotypicFeature"),1.1,1),if(termfreq(category,"biolink:Disease"),1.3,1),if(and(termfreq(in_taxon,"NCBITaxon:9606"),termfreq(category,"biolink:Gene")),1.1,1),if(termfreq(deprecated,"true"),0.1,1))', 'facet.mincount': '1', 'rows': '10', 'facet': 'true'}}, 'response': {'num_found': 400, 'start': 0, 'docs': [{'id': 'MONDO:0009215', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group A', 'description': 'Fanconi anemia caused by mutations of the FANCA gene. FANCA gene mutations are the most common cause of Fanconi anemia. This gene provides instructions for making a protein that is involved in the Fanconi anemia (FA) pathway.', 'xref': ['DOID:0111095', 'GARD:15170', 'GTR:AN1051558', 'MEDGEN:483333', 'NCIT:C125702', 'OMIM:227650', 'UMLS:C3469521'], 'synonym': ['Estren-Dameshek variant of Fanconi Anaemia', 'Estren-Dameshek variant of Fanconi Anemia', 'Estren-Dameshek variant of Fanconi pancytopenia', 'FANCA', 'FANCA Fanconi anaemia', 'FANCA Fanconi anemia', 'Fanconi Anaemia', 'Fanconi Anemia', 'Fanconi Anemia, Estren-Dameshek variant', 'Fanconi Anemia, complementation group type a', 'Fanconi anaemia caused by mutation in FANCA', 'Fanconi anaemia complementation group type A', 'Fanconi anemia caused by mutation in FANCA', 'Fanconi anemia complementation group A', 'Fanconi anemia complementation group type A', 'Fanconi anemia, complementation group A'], 'exact_synonym': ['FANCA', 'FANCA Fanconi anaemia', 'FANCA Fanconi anemia', 'Fanconi Anemia, complementation group type a', 'Fanconi anaemia caused by mutation in FANCA', 'Fanconi anaemia complementation group type A', 'Fanconi anemia caused by mutation in FANCA', 'Fanconi anemia complementation group A', 'Fanconi anemia complementation group type A'], 'related_synonym': ['Estren-Dameshek variant of Fanconi Anaemia', 'Estren-Dameshek variant of Fanconi Anemia', 'Estren-Dameshek variant of Fanconi pancytopenia', 'Fanconi Anaemia', 'Fanconi Anemia', 'Fanconi Anemia, Estren-Dameshek variant', 'Fanconi anemia, complementation group A'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0001627', 'HP:0000028', 'HP:0001873', 'HP:0000486', 'HP:0001249', 'HP:0000104', 'HP:0003251', 'HP:0003213', 'HP:0001909', 'HP:0001518', 'HP:0030680', 'HP:0000815', 'HP:0009777', 'HP:0001875', 'HP:0000365', 'HP:0001896', 'HP:0001903', 'HP:0000086', 'HP:0003214', 'HP:0009943', 'HP:0012210', 'HP:0001017', 'HP:0000978', 'HP:0001876', 'HP:0000085', 'HP:0000568', 'HP:0001000', 'HP:0004322', 'HP:0000081', 'HP:0003221', 'HP:0000957', 'HP:0003974', 'HP:0000252', 'HP:0009778'], 'has_phenotype_label': ['Decreased total neutrophil count', 'Short stature', 'Reticulocytopenia', 'Anemia', 'Abnormal renal morphology', 'Anemic pallor', 'Complete duplication of thumb phalanx', 'Hypergonadotropic hypogonadism', 'Hearing impairment', 'Leukemia', 'Cryptorchidism', 'Chromosomal breakage induced by crosslinking agents', 'Small for gestational age', 'Male infertility', 'Absent thumb', 'Intellectual disability', 'Abnormality of skin pigmentation', 'Pancytopenia', 'Absent radius', 'Bruising susceptibility', 'Microcephaly', 'Short thumb', 'Prolonged G2 phase of cell cycle', 'Strabismus', 'Horseshoe kidney', 'Renal agenesis', 'Microphthalmia', 'Abnormal cardiovascular system morphology', 'Deficient excision of UV-induced pyrimidine dimers in DNA', 'Cafe-au-lait spot', 'Abnormal heart morphology', 'Ectopic kidney', 'Duplicated collecting system', 'Thrombocytopenia'], 'has_phenotype_count': 34, 'has_phenotype_closure': ['GO:0007600', 'UPHENO:0005513', 'HP:0000598', 'UPHENO:0052165', 'UBERON:0001690', 'UPHENO:0005512', 'HP:0000365', 'UPHENO:0050620', 'UPHENO:0052231', 'GO:0050954', 'UPHENO:0052160', 'UPHENO:0052178', 'GO:0007605', 'UPHENO:0052159', 'UPHENO:0052970', 'NBO:0000338', 'UPHENO:0002211', 'UPHENO:0002550', 'UPHENO:0004764', 'UBERON:0002384', 'UBERON:0010313', 'UPHENO:0002430', 'UPHENO:0079828', 'NBO:0000001', 'UBERON:0000964', 'UPHENO:0002360', 'UBERON:0010222', 'UPHENO:0002301', 'UPHENO:0087577', 'UPHENO:7000169', 'UBERON:0000466', 'UPHENO:0002403', 'HP:0000486', 'UPHENO:0005517', 'UPHENO:0002352', 'UPHENO:0087597', 'HP:0012373', 'UPHENO:0046624', 'UPHENO:0046552', 'HP:0009778', 'UPHENO:0046426', 'UPHENO:0046750', 'UPHENO:0046483', 'UBERON:0006800', 'UPHENO:0012440', 'UPHENO:0046528', 'UPHENO:0046741', 'UPHENO:0046445', 'HP:0011927', 'UPHENO:0012312', 'UPHENO:0026095', 'UPHENO:0002219', 'UPHENO:0026073', 'UPHENO:0025508', 'HP:0006501', 'UPHENO:0026098', 'UPHENO:0002785', 'HP:0002817', 'HP:0011842', 'UBERON:0012354', 'UBERON:0003221', 'UPHENO:0026806', 'UBERON:0003607', 'UBERON:0008962', 'UBERON:0003081', 'UPHENO:0025585', 'UPHENO:0002542', 'UPHENO:0002632', 'UBERON:0002529', 'HP:0000135', 'UBERON:0006717', 'UBERON:5102544', 'UPHENO:0075902', 'UPHENO:0002751', 'UBERON:0010912', 'UPHENO:0003020', 'UPHENO:0002782', 'UPHENO:0002803', 'UPHENO:0002945', 'HP:0033127', 'UPHENO:0086546', 'UPHENO:0002905', 'UPHENO:0087347', 'UBERON:0002101', 'HP:0000119', 'UPHENO:0069684', 'UPHENO:0049588', 'UPHENO:0002830', 'UPHENO:0050019', 'HP:0002715', 'HP:0009998', 'UPHENO:0076703', 'GO:0022403', 'UPHENO:0003415', 'GO:0008152', 'GO:0044848', 'UPHENO:0002593', 'UPHENO:0050121', 'UPHENO:0076739', 'MPATH:119', 'UPHENO:0076692', 'HP:0009380', 'UPHENO:0049904', 'UPHENO:0002764', 'UPHENO:0025497', 'UPHENO:0086769', 'UPHENO:0018390', 'UPHENO:0026227', 'HP:0031704', 'UBERON:0002513', 'UPHENO:0053643', 'UPHENO:0046505', 'UPHENO:0053566', 'UPHENO:0053632', 'UBERON:0001008', 'HP:0100542', 'UPHENO:0002750', 'UPHENO:0076779', 'UPHENO:0004482', 'UPHENO:0050778', 'HP:0000079', 'UPHENO:0018418', 'UPHENO:0041629', 'UPHENO:0076723', 'UPHENO:0049989', 'UPHENO:0004892', 'UBERON:0010230', 'UBERON:0005388', 'UPHENO:0076941', 'UBERON:0011143', 'UPHENO:0069149', 'UPHENO:0087006', 'UBERON:0005181', 'UBERON:0005172', 'UPHENO:0041465', 'UPHENO:3000004', 'UPHENO:0025187', 'UPHENO:0002642', 'UBERON:0011582', 'UPHENO:0041821', 'HP:0002011', 'UBERON:0002113', 'UBERON:0000026', 'UPHENO:0002926', 'UBERON:0005173', 'UBERON:0011250', 'UBERON:0004122', 'UPHENO:0003413', 'UBERON:0000063', 'UPHENO:0002969', 'UPHENO:0004469', 'UPHENO:0080079', 'UBERON:0019221', 'UPHENO:0053610', 'UBERON:0005178', 'UBERON:0011249', 'UBERON:0005177', 'UPHENO:0087663', 'UPHENO:0084004', 'UPHENO:0003088', 'UPHENO:3000007', 'HP:0001627', 'UPHENO:0087907', 'UPHENO:0008703', 'UBERON:0002100', 'UPHENO:0085302', 'UBERON:0011584', 'UPHENO:0077391', 'UPHENO:0086173', 'UPHENO:0004881', 'HP:0000811', 'CL:0000458', 'HP:0012145', 'UPHENO:7000640', 'NBO:0001845', 'HP:0000496', 'CL:0000081', 'UPHENO:0049870', 'UPHENO:0084448', 'UPHENO:0003084', 'UBERON:0001474', 'HP:0001892', 'UBERON:0002405', 'UPHENO:0086633', 'UBERON:0015203', 'UBERON:0000061', 'UBERON:0000468', 'CL:0000225', 'UPHENO:0002553', 'UPHENO:0049587', 'UPHENO:0077348', 'UBERON:0010363', 'UPHENO:0025811', 'HP:0003214', 'UPHENO:0046411', 'UPHENO:0002527', 'UPHENO:0076740', 'UPHENO:0085371', 'UPHENO:0004344', 'UBERON:0002204', 'UPHENO:7000306', 'UPHENO:0087123', 'HP:0012443', 'UPHENO:0053633', 'UPHENO:0002948', 'UBERON:0002390', 'CL:0000988', 'UPHENO:0002708', 'UPHENO:0085968', 'UPHENO:0000541', 'CL:0000094', 'UBERON:0000020', 'UPHENO:0075195', 'UBERON:0001434', 'UPHENO:0069327', 'UPHENO:0069674', 'UPHENO:0081424', 'UPHENO:0011536', 'UPHENO:0069062', 'UPHENO:0049874', 'UPHENO:0080351', 'UPHENO:0002949', 'UPHENO:0005025', 'UPHENO:0068971', 'UBERON:0010740', 'HP:0032251', 'GO:0043473', 'BFO:0000015', 'UPHENO:0075220', 'HP:0011018', 'UPHENO:0003004', 'UPHENO:0003227', 'UPHENO:0050008', 'CL:0000329', 'UBERON:0004128', 'UBERON:0002342', 'UBERON:0001015', 'UPHENO:0088166', 'UPHENO:0080352', 'HP:0001873', 'UBERON:0000916', 'UPHENO:0087510', 'HP:0001000', 'UBERON:0003075', 'UBERON:0004121', 'UPHENO:0076804', 'UPHENO:0002523', 'HP:0011276', 'UPHENO:0002548', 'UPHENO:0003025', 'UPHENO:0004900', 'UBERON:0000926', 'HP:0000364', 'UPHENO:0002635', 'HP:0010987', 'HP:0000077', 'UPHENO:0054304', 'UBERON:0002417', 'UBERON:0002416', 'UPHENO:0004036', 'HP:0003953', 'UPHENO:0087228', 'UBERON:0003466', 'UPHENO:0002832', 'UBERON:0015228', 'UBERON:0000053', 'UPHENO:0025545', 'UPHENO:0004615', 'UPHENO:0009163', 'BFO:0000141', 'UPHENO:0027017', 'UPHENO:0008475', 'UPHENO:0003412', 'GO:0005575', 'HP:0025354', 'UBERON:0002097', 'UBERON:0004357', 'UBERON:0005061', 'HP:0001876', 'UPHENO:0087928', 'UPHENO:0002964', 'UPHENO:0002983', 'UBERON:0016879', 'UPHENO:0005433', 'UPHENO:0002909', 'UPHENO:0080300', 'UPHENO:0002944', 'UBERON:0004053', 'UPHENO:0002393', 'UBERON:0015410', 'UBERON:0000153', 'HP:0004322', 'BFO:0000003', 'UPHENO:0003410', 'UBERON:0004710', 'UBERON:0012430', 'HP:0004325', 'UBERON:0012475', 'UPHENO:0063794', 'UPHENO:0041075', 'UPHENO:3000003', 'UPHENO:0011817', 'UPHENO:9002003', 'UBERON:0015212', 'UPHENO:0080114', 'UPHENO:0075159', 'UPHENO:0081451', 'UPHENO:0087081', 'UBERON:0004923', 'UBERON:0003056', 'GO:0008150', 'GO:0005840', 'UPHENO:0027189', 'HP:0000924', 'GO:0042592', 'UPHENO:0001003', 'UBERON:0002470', 'GO:0044238', 'UPHENO:0004884', 'UBERON:0015024', 'GO:0051325', 'HP:0005561', 'GO:0009987', 'UBERON:0005291', 'UBERON:0000490', 'UPHENO:0003186', 'CL:0000219', 'UPHENO:0026643', 'UPHENO:0003049', 'UBERON:0010314', 'UPHENO:0066925', 'NCBITaxon:2759', 'UPHENO:0004523', 'UBERON:0001032', 'UBERON:0000060', 'UPHENO:0052161', 'UPHENO:0079826', 'UPHENO:0076718', 'UPHENO:0003812', 'UPHENO:7000101', 'NCBITaxon:131567', 'UBERON:0015063', 'UBERON:0003072', 'UBERON:0001890', 'UBERON:0001048', 'UPHENO:0076675', 'HP:0000951', 'UPHENO:0076810', 'HP:0001167', 'UPHENO:7000223', 'UBERON:0004765', 'UPHENO:0002531', 'UPHENO:0086679', 'UBERON:0007213', 'MPATH:0', 'UPHENO:0004766', 'HP:0002060', 'UBERON:0002102', 'UPHENO:0075219', 'UPHENO:0086484', 'HP:0011354', 'UPHENO:0063787', 'UBERON:0002346', 'UPHENO:0027547', 'UPHENO:0004047', 'UBERON:0001016', 'UPHENO:7000294', 'UPHENO:0087427', 'UBERON:0000915', 'UPHENO:0026309', 'HP:0000252', 'UPHENO:0077418', 'CL:0000738', 'HP:0002597', 'HP:0000001', 'UBERON:0009142', 'UPHENO:0078629', 'UPHENO:0005110', 'GO:0110165', 'UPHENO:0003334', 'UPHENO:0003159', 'UBERON:0015021', 'UPHENO:0002928', 'UPHENO:0003369', 'UBERON:0005417', 'UBERON:5002544', 'GO:0005622', 'UBERON:0019207', 'UPHENO:0002568', 'UBERON:0010758', 'UPHENO:0002597', 'UPHENO:0077399', 'UPHENO:0010795', 'NCBITaxon:6072', 'UPHENO:0069523', 'UPHENO:0005058', 'UPHENO:0005090', 'UBERON:0002495', 'UPHENO:0002733', 'UBERON:0009569', 'UBERON:0005156', 'UBERON:0010312', 'UPHENO:0002844', 'UPHENO:0005093', 'UBERON:0000076', 'HP:0010974', 'UPHENO:0002576', 'UPHENO:0004459', 'UPHENO:0009337', 'UBERON:0007100', 'MPATH:120', 'HP:0005918', 'UBERON:0011216', 'UBERON:0004347', 'GO:0009890', 'UPHENO:0002719', 'UBERON:0003496', 'NCBITaxon:33208', 'UPHENO:0002385', 'UPHENO:0049699', 'UPHENO:0002204', 'UBERON:5001463', 'UBERON:0010409', 'HP:0011875', 'UPHENO:0004484', 'UBERON:0011362', 'UPHENO:0002267', 'UPHENO:0088162', 'CL:0000763', 'UPHENO:0086485', 'HP:0003213', 'UPHENO:0063722', 'UPHENO:0004888', 'UBERON:0005897', 'UBERON:0005419', 'BFO:0000002', 'UPHENO:0004721', 'UPHENO:0003123', 'UPHENO:0008430', 'UPHENO:0049868', 'UBERON:0011818', 'UPHENO:0087596', 'UBERON:0002075', 'HP:0000568', 'UPHENO:0086635', 'UBERON:0007798', 'UBERON:0001802', 'UPHENO:0002902', 'UBERON:0001981', 'UPHENO:0087915', 'UPHENO:0002746', 'UPHENO:0053563', 'UPHENO:0003177', 'UPHENO:0011548', 'UBERON:0011137', 'UPHENO:0008604', 'UBERON:0010708', 'HP:0000815', 'UPHENO:0049743', 'CL:0000232', 'UPHENO:0009010', 'UPHENO:0049703', 'UPHENO:0080187', 'UBERON:0002200', 'UBERON:0000307', 'UPHENO:0005030', 'UPHENO:0004909', 'UPHENO:0003086', 'BFO:0000001', 'UBERON:0000924', 'UBERON:0001062', 'UBERON:0003129', 'HP:0000549', 'UBERON:0004088', 'UBERON:0007811', 'HP:0010935', 'HP:0030680', 'HP:0012041', 'HP:0001903', 'HP:0002973', 'UBERON:0001009', 'UPHENO:0002870', 'UBERON:0003133', 'UPHENO:7000183', 'UPHENO:0002530', 'UPHENO:0002754', 'UBERON:0000062', 'UPHENO:0004519', 'UBERON:0005451', 'UPHENO:0002308', 'UPHENO:0009115', 'UPHENO:0087186', 'UPHENO:0004827', 'UBERON:0003099', 'UPHENO:0084815', 'UBERON:0006876', 'GO:0007631', 'UBERON:0007530', 'UPHENO:0002634', 'UBERON:0002443', 'UPHENO:0076782', 'UPHENO:0053601', 'UPHENO:0050040', 'HP:0006265', 'UBERON:0005881', 'UPHENO:0080010', 'UPHENO:0087472', 'UBERON:0004734', 'UPHENO:0011492', 'UPHENO:0002731', 'HP:0000085', 'HP:0001871', 'UBERON:0003103', 'UPHENO:0002577', 'UPHENO:0004802', 'HP:0006496', 'UPHENO:0076776', 'BFO:0000040', 'UPHENO:0003189', 'UPHENO:0049835', 'UPHENO:0003031', 'UBERON:0000015', 'HP:0000953', 'GO:0031052', 'UPHENO:0026183', 'UPHENO:0003069', 'UPHENO:0069266', 'HP:0001510', 'UBERON:0010543', 'UPHENO:0066905', 'UBERON:0001444', 'HP:0000118', 'HP:0000478', 'HP:0004275', 'UBERON:0012140', 'UPHENO:0069161', 'UPHENO:0006889', 'UPHENO:0002866', 'NCBITaxon:1', 'UPHENO:0008743', 'UBERON:0012357', 'UBERON:0000075', 'UPHENO:0003236', 'UBERON:0002104', 'HP:0001574', 'UPHENO:0003001', 'UBERON:0000923', 'UPHENO:0005029', 'UPHENO:0088170', 'UPHENO:0001002', 'HP:0011844', 'UBERON:0000970', 'UBERON:5101463', 'UBERON:0005253', 'UPHENO:7000303', 'UPHENO:0066902', 'HP:0009121', 'UPHENO:0003184', 'UPHENO:0066927', 'UBERON:0000019', 'UPHENO:0002541', 'UPHENO:0003432', 'UPHENO:0002747', 'UBERON:0000966', 'UPHENO:0066903', 'GO:0006281', 'UPHENO:0002343', 'HP:0011446', 'HP:0003251', 'UPHENO:0053561', 'CL:0000000', 'UPHENO:0011498', 'UPHENO:0002564', 'UPHENO:0025882', 'UBERON:0034925', 'UPHENO:0003021', 'GO:0051319', 'UPHENO:0005141', 'UPHENO:0004704', 'HP:0000980', 'UPHENO:0002903', 'UBERON:0010000', 'UPHENO:0003082', 'UBERON:8450003', 'HP:0001939', 'UPHENO:0002311', 'UBERON:0012151', 'UPHENO:0001001', 'UBERON:0001456', 'CL:0000151', 'UBERON:0000047', 'UPHENO:0088123', 'UBERON:0005423', 'UBERON:0010538', 'CL:0002242', 'UPHENO:0002976', 'UPHENO:0087846', 'UPHENO:0025587', 'UPHENO:0002963', 'GO:0019222', 'UPHENO:0085301', 'UPHENO:0011770', 'UBERON:0002193', 'UBERON:0004120', 'UPHENO:0081423', 'UPHENO:0002896', 'UPHENO:7000547', 'UPHENO:0041226', 'UPHENO:0087802', 'UBERON:0005157', 'HP:0009815', 'UPHENO:0085330', 'UBERON:0000055', 'UBERON:0005389', 'UBERON:0006003', 'CL:0002092', 'UBERON:0004288', 'UPHENO:0003776', 'UBERON:0002371', 'HP:0011297', 'NBO:0000313', 'UPHENO:0003056', 'UPHENO:0002940', 'UPHENO:0005518', 'GO:0043226', 'UBERON:0004535', 'UBERON:0034923', 'UPHENO:0087852', 'UBERON:0003071', 'UBERON:0000465', 'UPHENO:0086048', 'UPHENO:0086172', 'UPHENO:0004494', 'UPHENO:0086297', 'UBERON:0002398', 'UBERON:0004708', 'UBERON:0004111', 'UPHENO:0085344', 'UPHENO:0004831', 'UPHENO:0004757', 'UPHENO:0009382', 'UBERON:0000467', 'UPHENO:0005092', 'UPHENO:0087665', 'UBERON:0002199', 'UPHENO:0002525', 'UPHENO:0005277', 'UPHENO:7000311', 'UPHENO:0025176', 'UPHENO:0088164', 'UPHENO:0002410', 'HP:0009943', 'UPHENO:0008640', 'UBERON:0006598', 'HP:0012210', 'UBERON:0015023', 'UPHENO:0002567', 'UPHENO:0025955', 'GO:0043229', 'UPHENO:0087339', 'UPHENO:0004507', 'UPHENO:0002206', 'GO:0043228', 'UPHENO:0087660', 'HP:0000978', 'UPHENO:0086589', 'UPHENO:0004525', 'HP:0011991', 'UBERON:0003102', 'GO:0009058', 'UBERON:0006601', 'HP:0040068', 'UPHENO:0086296', 'UBERON:0001768', 'UBERON:0002471', 'UPHENO:0002765', 'UBERON:0000473', 'UBERON:0000014', 'HP:0000234', 'UPHENO:0085356', 'UPHENO:0002580', 'UPHENO:0054957', 'UPHENO:0004885', 'UBERON:0002050', 'UBERON:0000477', 'UPHENO:0025855', 'UBERON:0000483', 'HP:0001933', 'UPHENO:7000539', 'UBERON:0001776', 'UPHENO:0066972', 'UBERON:0003104', 'UPHENO:0009344', 'UPHENO:0076729', 'UPHENO:0053580', 'UPHENO:0002910', 'UPHENO:0081581', 'HP:0009602', 'UBERON:0000475', 'UPHENO:0000543', 'UPHENO:0087661', 'UBERON:0005062', 'HP:0000002', 'UPHENO:0002559', 'UPHENO:7000015', 'UPHENO:0053588', 'UBERON:0013701', 'UPHENO:0004064', 'UPHENO:0002704', 'UPHENO:0002571', 'RO:0002577', 'UPHENO:0076702', 'HP:0009997', 'UPHENO:0076777', 'MPATH:105', 'UPHENO:0054315', 'UPHENO:0009021', 'UBERON:0004537', 'UPHENO:0069254', 'UPHENO:0004433', 'HP:0045060', 'UPHENO:0075997', 'UBERON:0013702', 'GO:0050877', 'UPHENO:0003095', 'UPHENO:0004680', 'UPHENO:0026074', 'CL:0000457', 'UPHENO:0004765', 'UPHENO:0002536', 'UPHENO:0004621', 'UPHENO:0002650', 'UPHENO:0002600', 'UBERON:5102389', 'GO:0050794', 'UPHENO:0081466', 'UPHENO:0049952', 'UBERON:0010688', 'UPHENO:0002554', 'UBERON:0008785', 'GO:0065007', 'UPHENO:0002816', 'UPHENO:0004360', 'UBERON:0002091', 'UPHENO:0082794', 'UPHENO:0005596', 'UBERON:0001017', 'UBERON:0010130', 'UPHENO:0025845', 'UPHENO:0050126', 'UBERON:0001440', 'UPHENO:7000007', 'UBERON:0004249', 'UPHENO:0009399', 'HP:0009142', 'UPHENO:0086700', 'HP:0012638', 'UPHENO:0079876', 'UPHENO:0011531', 'UBERON:0007272', 'UPHENO:0005437', 'UBERON:0002203', 'UPHENO:7000632', 'GO:0010556', 'UPHENO:0086486', 'UBERON:0004381', 'HP:0007364', 'UBERON:0001460', 'UBERON:0015061', 'UBERON:0004456', 'GO:0010605', 'UPHENO:0005214', 'UPHENO:0003366', 'UPHENO:0008545', 'UPHENO:0011566', 'UPHENO:0011559', 'UPHENO:0026096', 'HP:0040064', 'UPHENO:0003799', 'UPHENO:0076697', 'UPHENO:0086019', 'UBERON:0010707', 'UPHENO:0046707', 'UPHENO:0026504', 'UBERON:0012358', 'UPHENO:0025546', 'UPHENO:0079872', 'UBERON:0003620', 'UBERON:0015204', 'UPHENO:0002861', 'HP:0004323', 'UBERON:8450002', 'UBERON:0002389', 'UPHENO:0067691', 'UPHENO:0012274', 'HP:0009942', 'HP:0001155', 'UBERON:0003101', 'UPHENO:0076724', 'UPHENO:0085263', 'UPHENO:0088186', 'UPHENO:0008709', 'UBERON:0019231', 'UPHENO:0008523', 'UBERON:0006048', 'UBERON:0010741', 'UBERON:0004375', 'UBERON:0002428', 'UPHENO:0086002', 'UBERON:0003606', 'HP:0001875', 'GO:0060255', 'UPHENO:0002586', 'UPHENO:0080200', 'UBERON:0010712', 'UPHENO:0002526', 'UPHENO:7000299', 'UPHENO:7000538', 'UPHENO:0004475', 'HP:0001909', 'UPHENO:0026757', 'UBERON:0000922', 'UBERON:0000383', 'UBERON:0007524', 'UBERON:5006048', 'HP:0040072', 'UPHENO:0027631', 'HP:0011017', 'UBERON:0002544', 'HP:0001172', 'HP:0100547', 'HP:0011793', 'UBERON:0000949', 'UPHENO:0046740', 'UPHENO:0076727', 'HP:0001881', 'HP:0002664', 'UPHENO:0002987', 'HP:0004377', 'UPHENO:0049873', 'UPHENO:0008825', 'UPHENO:0087089', 'UPHENO:0049990', 'UPHENO:0011931', 'GO:0043170', 'UPHENO:0049671', 'UPHENO:0049720', 'UBERON:5106048', 'HP:0003254', 'UPHENO:0080209', 'UPHENO:0002323', 'UPHENO:0051124', 'GO:0006259', 'UPHENO:0049964', 'UPHENO:0002859', 'GO:0050896', 'GO:0006950', 'GO:0051716', 'GO:0006974', 'GO:0090304', 'HP:0005922', 'HP:0001626', 'UBERON:0010323', 'HP:0006503', 'GO:0006139', 'HP:0008678', 'UPHENO:0027014', 'UPHENO:0002712', 'UPHENO:0003163', 'UPHENO:0011749', 'UPHENO:0026600', 'UPHENO:0088148', 'UPHENO:0008816', 'UPHENO:0026507', 'UPHENO:0005055', 'UPHENO:0026506', 'UPHENO:0003514', 'UPHENO:0026146', 'UPHENO:0003094', 'UPHENO:0011533', 'HP:0010461', 'UPHENO:0026010', 'UPHENO:0025631', 'HP:0000104', 'UPHENO:0026630', 'UPHENO:7000013', 'UPHENO:0002804', 'UPHENO:0009209', 'UPHENO:0025661', 'UPHENO:0080126', 'UPHENO:0008668', 'UPHENO:0009356', 'UPHENO:0009011', 'UPHENO:0003065', 'UPHENO:0004521', 'UPHENO:0008593', 'UPHENO:0003093', 'UBERON:5002389', 'UPHENO:0008827', 'UPHENO:0025776', 'UBERON:0012139', 'UPHENO:0003055', 'MPATH:603', 'UPHENO:0009129', 'UPHENO:0050063', 'UPHENO:0026308', 'UPHENO:0011572', 'UBERON:0006058', 'UPHENO:0002678', 'UPHENO:0009020', 'GO:0033554', 'UPHENO:0049586', 'UPHENO:0011739', 'UBERON:0001869', 'UPHENO:0076799', 'UBERON:0000064', 'UPHENO:0003811', 'UBERON:0000073', 'UPHENO:0002594', 'HP:0001872', 'UPHENO:0005285', 'UBERON:0003914', 'HP:0012639', 'UPHENO:0087531', 'UPHENO:0079835', 'GO:0007049', 'UPHENO:7000599', 'UBERON:0016880', 'HP:0011121', 'GO:0009889', 'HP:0002813', 'HP:0002818', 'UPHENO:0010743', 'HP:0011873', 'UBERON:0000025', 'UBERON:0003080', 'UPHENO:0087363', 'GO:0043232', 'HP:0001249', 'UPHENO:0049775', 'UPHENO:0076805', 'UPHENO:0025852', 'UPHENO:0002736', 'UPHENO:0087518', 'UPHENO:0076791', 'UPHENO:0004261', 'UBERON:0001893', 'UPHENO:0080377', 'UBERON:0001049', 'HP:0012372', 'UPHENO:0010808', 'UBERON:0001463', 'UBERON:0011676', 'UPHENO:0087924', 'UBERON:0000481', 'UPHENO:0026097', 'UPHENO:0069064', 'HP:0100887', 'HP:0001518', 'UPHENO:0010763', 'UPHENO:0010850', 'UPHENO:0050116', 'UPHENO:0054374', 'UPHENO:0067694', 'HP:0000086', 'UBERON:0000990', 'HP:0000789', 'UPHENO:0077386', 'HP:0000078', 'GO:0005694', 'HP:0000080', 'UPHENO:0049664', 'UPHENO:0046183', 'UPHENO:7000016', 'UPHENO:0002269', 'UPHENO:0002378', 'HP:0000144', 'HP:0004742', 'HP:0032309', 'UBERON:0015025', 'HP:0000081', 'UPHENO:0050625', 'UPHENO:0075787', 'UBERON:0004100', 'UBERON:0003918', 'UBERON:0007688', 'CL:0000558', 'CL:0002422', 'UPHENO:0003050', 'UPHENO:0069352', 'HP:0004312', 'UPHENO:0004262', 'UBERON:0010316', 'HP:0001896', 'UBERON:0002386', 'UPHENO:0087973', 'HP:0001877', 'GO:0010629', 'UPHENO:0049622', 'GO:0032501', 'UPHENO:0088176', 'UPHENO:0004466', 'UPHENO:0066913', 'UPHENO:0080325', 'GO:0007610', 'UPHENO:0087547', 'GO:0042756', 'UBERON:0001442', 'UPHENO:0002685', 'UBERON:0001801', 'HP:0012243', 'UPHENO:0027630', 'UPHENO:7000069', 'UPHENO:7000206', 'UPHENO:0002682', 'UPHENO:0053644', 'UPHENO:0025166', 'GO:0009892', 'UPHENO:0076789', 'HP:0000035', 'UPHENO:0053647', 'UPHENO:0002659', 'UPHENO:0053571', 'UPHENO:0050234', 'UPHENO:0002595', 'UPHENO:0087849', 'UPHENO:0053559', 'HP:0000028', 'HP:0000032', 'UBERON:0000079', 'HP:0008056', 'UPHENO:0027231', 'UBERON:0000991', 'GO:0040007', 'UBERON:0004176', 'CL:0001035', 'UPHENO:0005016', 'UPHENO:0053572', 'HP:0003221', 'GO:0010467', 'GO:0048519', 'CL:0000764', 'UPHENO:0084763', 'UBERON:0003135', 'UPHENO:0050065', 'HP:0003220', 'UPHENO:0049620', 'UPHENO:0078606', 'GO:0031049', 'UPHENO:0050007', 'GO:0010558', 'BFO:0000004', 'UPHENO:0025211', 'UBERON:0015001', 'UPHENO:0069605', 'GO:0010468', 'UPHENO:0050435', 'UPHENO:0049837', 'UPHENO:0004476', 'HP:0040012', 'UPHENO:0002240', 'UPHENO:0049757', 'UBERON:0003460', 'UPHENO:0049642', 'GO:0009059', 'CL:0000255', 'UPHENO:0082761', 'GO:0048523', 'UPHENO:0025507', 'UPHENO:0077373', 'HP:0040195', 'UPHENO:0075804', 'UBERON:0011138', 'UPHENO:0075148', 'UPHENO:0069236', 'UBERON:0034944', 'HP:0000152', 'UPHENO:0084761', 'HP:0000707', 'CL:0000766', 'NBO:0000444', 'UPHENO:0081566', 'HP:0000929', 'UPHENO:0002880', 'HP:0000818', 'UPHENO:3000000', 'UBERON:0012150', 'UBERON:0000948', 'UBERON:0005944', 'UBERON:0002090', 'HP:0002977', 'HP:0000240', 'CL:0000233', 'HP:0008373', 'UPHENO:0002648', 'UPHENO:0002386', 'UPHENO:0024906', 'UBERON:0002616', 'UPHENO:0002381', 'HP:0011355', 'UPHENO:0066945', 'UBERON:0002105', 'UBERON:0000955', 'HP:0009115', 'UPHENO:0026181', 'UPHENO:0008548', 'UPHENO:0080099', 'HP:0009601', 'UPHENO:0009146', 'UPHENO:0011825', 'HP:0005927', 'UPHENO:0026078', 'HP:0009777', 'UPHENO:0025509', 'UPHENO:0026640', 'UPHENO:0026312', 'UPHENO:0026108', 'UPHENO:0080662', 'UPHENO:0087232', 'UBERON:0010371', 'UBERON:0000479', 'HP:0012733', 'UPHENO:0053619', 'HP:0007400', 'UPHENO:0012308', 'HP:0000957', 'UPHENO:0074584', 'UPHENO:0010799', 'HP:0001034', 'UPHENO:0074575', 'UPHENO:0054970', 'UBERON:0000965', 'UPHENO:0011573', 'UPHENO:0087349', 'UPHENO:0084816', 'UPHENO:7000235', 'HP:0001017', 'UPHENO:0086956', 'UPHENO:0002668', 'UPHENO:0002433', 'HP:0012759', 'GO:0003008', 'GO:0050890', 'UPHENO:0086176', 'HP:0001874', 'UBERON:0002049', 'HP:0001911', 'CL:0000775', 'UBERON:0012141', 'UPHENO:7000530', 'HP:0011992', 'UPHENO:0025547', 'UPHENO:0088175', 'UPHENO:0002967', 'HP:0009381', 'HP:0011893', 'UPHENO:0002738', 'UPHENO:0003116', 'UPHENO:0086016', 'UPHENO:0085354', 'UPHENO:0050106', 'UPHENO:0006894', 'UPHENO:0049652', 'UPHENO:0026023', 'UPHENO:0025808', 'UBERON:0001436', 'UPHENO:0087501', 'HP:0001507', 'UPHENO:0025544', 'UPHENO:0009391', 'UPHENO:0025652', 'UBERON:0001423', 'UPHENO:0025136', 'UBERON:0000489', 'UPHENO:0026486', 'MPATH:1000', 'UBERON:0010703', 'UPHENO:0011568', 'UPHENO:0081511', 'HP:0009822', 'UPHENO:0087423', 'UPHENO:0026808', 'UPHENO:0005097', 'UPHENO:0002637', 'UPHENO:7000590', 'UPHENO:0025961', 'UBERON:0000033', 'UPHENO:0004173', 'UPHENO:0075944', 'HP:0003974', 'UPHENO:0082875', 'UPHENO:0025883', 'UPHENO:0076754', 'NCBITaxon:33154', 'GO:0050789', 'UPHENO:0053612', 'HP:0040070', 'UPHENO:0009341', 'UPHENO:0026344', 'UPHENO:0008865', 'UPHENO:0004595', 'UPHENO:0009366', 'UPHENO:0003005', 'UPHENO:0009295', 'UPHENO:0026317', 'UPHENO:0025135', 'UPHENO:0025553'], 'has_phenotype_closure_label': ['decreased qualitatively system process', 'sensory perception of mechanical stimulus phenotype', 'decreased sensory perception of sound', 'decreased qualitatively nervous system process', 'decreased sensory perception', 'decreased qualitatively sensory perception', 'sensory perception', 'ear physiology phenotype', 'decreased biological_process', 'vestibulo-auditory system phenotype', 'ear phenotype', 'decreased multicellular organismal process', 'decreased qualitatively sensory perception of mechanical stimulus', 'sensory perception of sound', 'Abnormality of the ear', 'nervous system process phenotype', 'sensory perception phenotype', 'decreased nervous system process', 'decreased qualitatively sensory perception of sound', 'Hearing impairment', 'vestibulo-auditory system', 'decreased qualitatively multicellular organismal process', 'ocular surface region', 'cornea', 'simple eye physiology phenotype', 'anatomical line', 'Strabismus', 'Abnormality of eye movement', 'kinesthetic behavior', 'non-material anatomical boundary', 'anatomical line between pupils', 'eye physiology phenotype', 'body part movement', 'immaterial anatomical entity', 'cornea phenotype', 'immaterial entity', 'neural crest-derived structure phenotype', 'anterior segment of eyeball morphology phenotype', 'connective tissue phenotype', 'camera-type eye physiology phenotype', 'cornea scarring; corneal scarring', 'decreased size of the material anatomical entity in the pectoral complex', 'decreased size of the anatomical entity in the pectoral complex', 'decreased size of the anatomical structure in the pectoral complex', 'decreased length of digit', 'decreased length of manual digit 1', 'decreased length of manual digit', 'Short finger', 'anatomical entity length phenotype', 'Short thumb', 'decreased size of the autopodial extension', 'absent skeletal element in the limb', 'absent endochondral bone in the limb', 'aplasia or hypoplasia of radius bone', 'absent bone of free limb or fin in the limb', 'absent anatomical structure in the skeletal system', 'long bone', 'Abnormal axial skeleton morphology', 'localised abdomen element', 'occurrent', 'nucleic acid metabolic process phenotype', 'manual digit 1 morphology phenotype', 'digit morphology phenotype', 'neural fold', 'Abnormal hand morphology', 'Abnormality of the upper limb', 'orbital region phenotype', 'lateral plate mesoderm phenotype', 'Duplication of hand bones', 'bone of appendage girdle complex phenotype', 'limb bone morphology phenotype', 'autopodial extension', 'face morphology phenotype', 'manus phenotype', 'manual digit digitopodial skeleton', 'dense mesenchyme tissue', 'myeloid leukocyte', 'limb morphology phenotype', 'Abnormality of limb bone', 'autopodial skeleton', 'regulation of macromolecule biosynthetic process phenotype', 'limb bone phenotype', 'system', 'Neurodevelopmental abnormality', 'Abnormal forearm morphology', 'bone element phenotype', 'Abnormality of body height', 'cerebral hemisphere morphology phenotype', 'Abnormal limb bone morphology', 'lateral plate mesoderm', 'arm', 'myeloid leukocyte morphology', 'paired limb/fin skeleton phenotype', 'cell cycle phenotype', 'absent trunk region element', 'forelimb zeugopod phenotype', 'multi-limb segment region phenotype', 'appendicular skeleton morphology phenotype', 'homeostatic process phenotype', 'primordium phenotype', 'localised material anatomical entity', 'viscus', 'autopod region phenotype', 'ecto-epithelium phenotype', 'retina morphology phenotype', 'localised anatomical structure', 'location of anatomical entity phenotype', 'tissue', 'absent material anatomical entity', 'cellular process', 'multi-limb segment region', 'localised multicellular anatomical structure', 'multicellular organism morphology phenotype', 'Hematological neoplasm', 'sensory perception of sound phenotype', 'Duplication of phalanx of hand', 'phenotype', 'Abnormal cellular phenotype', 'localised cavitated compound organ', 'kidney morphology phenotype', 'immune system phenotype', 'localised lateral structure', 'kidney phenotype', 'macromolecule biosynthetic process phenotype', 'U-shaped anatomical entity', 'neurectoderm', 'hemorrhage and non-specified extravasation', 'renal system morphology phenotype', 'forelimb long bone phenotype', 'abdomen element', 'entire embryonic mesenchyme', 'upper urinary tract', 'genitourinary system', 'Short digit', 'limb long bone phenotype', '3-D shape anatomical entity', 'continuant', 'DNA metabolic process', 'manual digit phenotype', 'abdominal segment element', 'skeleton of manual digitopodium', 'absent long bone in the forelimb', 'Horseshoe kidney', 'kidney', 'cerebral hemisphere', 'Abnormality of the genitourinary system', 'cavitated compound organ phenotype', 'renal system phenotype', 'embryonic autopod plate morphology phenotype', 'manus', 'skeleton of manus', 'decreased size of the anatomical structure', 'absent anatomical entity in the limb', 'absent organ in the renal system', 'U-shaped kidney', 'limb endochondral element', 'shape of anatomical entity phenotype', 'trunk', 'absent material anatomical entity in the multicellular organism', 'heart plus pericardium', 'heart', 'thoracic cavity element', 'Prolonged G2 phase of cell cycle', 'subdivision of skeleton', 'anatomical entity phenotype', 'circulatory organ phenotype', 'aneuploidy', 'subdivision of trunk', 'ectoderm phenotype', 'subdivision of trunk phenotype', 'intracellular membraneless organelle', 'trunk region element', 'Pallor', 'aplastic forelimb zeugopod bone', 'decreased length of digit 1 or 5', 'bone marrow cell', 'lateral structure', 'manus bone', 'manual digit bone', 'forebrain morphology phenotype', 'phalanx of manus', 'number of hematopoietic cell phenotype', 'lateral plate mesoderm morphology phenotype', 'erythroid lineage cell morphology phenotype', 'decreased number of platelet', 'forelimb morphology phenotype', 'shape of continuant phenotype', 'mesenchyme morphology phenotype', 'decreased number of anatomical structure', 'hematopoietic cell', 'programmed DNA elimination', 'manual digit', 'skull morphology phenotype', 'upper limb segment phenotype', 'compound organ phenotype', 'craniocervical region phenotype', 'neutrophil morphology phenotype', 'serotonin secreting cell', 'optic vesicle', 'pancytopenia', 'musculoskeletal system', 'bone marrow', 'absent material anatomical entity in the tissue', 'immune system', 'forelimb bud morphology phenotype', 'decreased number of myeloid cell', 'bone element', 'cellular_component', 'forelimb zeugopod bone', 'pectoral appendage bud phenotype', 'number of anatomical enitites of type endochondral element phenotype', 'erythrocyte', 'neoplasm phenotype', 'leukocyte', 'appendicular skeleton phenotype', 'Abnormal eye physiology', 'localised anatomical entity', 'anucleate cell', 'Abnormality of the urinary system', 'number of leukocyte phenotype', 'forelimb skeleton', 'mesoderm-derived structure', 'platelet phenotype', 'reproductive structure', 'Abnormality of the endocrine system', 'lateral structure physiology phenotype', 'manual digit 1', 'subdivision of skeleton phenotype', 'blood cell phenotype', 'number of anatomical enitites of type material anatomical entity phenotype', 'digit 1 digitopodial skeleton', 'primary metabolic process phenotype', 'multicellular organism height phenotype', 'subdivision of head', 'decreased size of the digit', 'All', 'Growth delay', 'localised kidney', 'decreased size of the anatomical entity', 'decreased size of the multicellular anatomical structure', 'Duplication of bones involving the upper extremities', 'vessel physiology phenotype', 'nucleate cell', 'genitourinary system phenotype', 'presumptive structure', 'absent forelimb bone', 'process', 'multicellular anatomical structure', 'abdominal segment of trunk', 'decreased number of hematopoietic cell', 'absent bone element', 'pigmentation phenotype', 'Abnormality of skin pigmentation', 'future nervous system', 'migrating mesenchyme population', 'decreased length of autopodial extension', 'multi-tissue structure', 'thoracic segment organ', 'circulatory disorder', 'anatomical cluster', 'eye movement phenotype', 'limb bud phenotype', 'eyeball of camera-type eye phenotype', 'biosynthetic process', 'face', 'anatomical structure phenotype', 'absent bone of pectoral complex', 'integumentary adnexa', 'decreased length of digit 1', 'postcranial axial skeletal system', 'disconnected anatomical group', 'Abnormality of multiple cell lineages in the bone marrow', 'bone of appendage girdle complex', 'enucleated reticulocyte', 'trunk region element phenotype', 'negative regulation of gene expression phenotype', 'Decreased fertility in males', 'immature eye phenotype', 'vasculature', 'pre-chordal neural plate phenotype', 'leukocyte morphology phenotype', 'number of anatomical enitites of type trunk region element phenotype', 'Opisthokonta', 'paired limb/fin phenotype', 'anatomical entity dysfunction in independent continuant', 'photoreceptor array phenotype', 'decreased number of material anatomical entity', 'Short stature', 'tissue phenotype', 'Decreased head circumference', 'neural crest phenotype', 'anatomical wall phenotype', 'blood vessel', 'orbital region', 'limb skeleton subdivision', 'cranial blood vasculature', 'segment of autopod', 'decreased number of reticulocyte', 'Abnormal neutrophil morphology', 'size of multicellular organism phenotype', 'male organism phenotype', 'cellular_component phenotype', 'number of anatomical enitites of type erythrocyte phenotype', 'decreased height of the anatomical entity', 'eye movement', 'Abnormal conjugate eye movement', 'reproductive system physiology phenotype', 'subdivision of organism along appendicular axis', 'regulation of metabolic process', 'Pancytopenia', 'cellular response to stress phenotype', 'neural groove phenotype', 'thoracic cavity element phenotype', 'Aplasia/hypoplasia involving the skeleton', 'Abnormal brain morphology', 'cardiovascular system', 'myeloid leukocyte phenotype', 'organ subunit', 'unilaminar epithelium', 'Eumetazoa', 'multicellular organism', 'nervous system morphology phenotype', 'appendage', 'ear', 'neurectoderm phenotype', 'male reproductive organ phenotype', 'anatomical system phenotype', 'anatomical entity morphology phenotype', 'primordium', 'compound organ', 'localised compound organ', 'sense organ', 'anlage', 'vasculature of eye phenotype', 'Chromosome breakage', 'decreased functionality of the gonad', 'subdivision of head phenotype', 'Growth abnormality', 'multicellular organism phenotype', 'simple eye phenotype', 'developing anatomical structure', 'cell cycle', 'phenotypic effect', 'Duplication of thumb phalanx', 'subcutaneous hemorrhage', 'absent radius bone', 'opaque anatomical entity', 'Abnormality of metabolism/homeostasis', 'zone of organ', 'metabolic acidosis', 'limb segment phenotype', 'abdomen element phenotype', 'endochondral element phenotype', 'Abnormality of the cell cycle', 'optic choroid morphology phenotype', 'Microphthalmia', 'germ layer phenotype', 'cranial neural crest phenotype', 'vasculature of eye', 'Hypergonadotropic hypogonadism', 'optic cup morphology phenotype', 'Abnormality of the skeletal system', 'nervous system', 'absent endochondral element', 'skeleton of digitopodium', 'cranial skeletal system', 'manual digit 1 or 5', 'upper urinary tract phenotype', 'absent abdomen element', 'main body axis', 'head mesenchyme morphology phenotype', 'decreased number of neutrophil', 'retina', 'negative regulation of biological process', 'optic vesicle phenotype', 'Abnormal ear physiology', 'localised testis', 'cellular_component function phenotype', 'presumptive structure phenotype', 'cardiovascular system morphology phenotype', 'Irregular hyperpigmentation', 'ribosome biogenesis', 'G2 phase', 'absent compound organ in the renal system', 'anatomical conduit', 'cell cycle phase', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'opaque lens of camera-type eye', 'localised gonad', 'chorioretinal region', 'camera-type eye morphology phenotype', 'blood vessel physiology phenotype', 'structure with developmental contribution from neural crest physiology phenotype', 'cellular process phenotype', 'neutrophil', 'embryonic structure phenotype', 'decreased size of the manual digit', 'pathological entity', 'cellular organisms', 'paired limb/fin bud phenotype', 'testis', 'absent limb endochondral element', 'subdivision of organism along main body axis', 'germ layer morphology phenotype', 'epithelial fold phenotype', 'vasculature of head phenotype', 'pectoral appendage phenotype', 'Abnormal finger morphology', 'material anatomical entity phenotype', 'neural crest morphology phenotype', 'organ component layer phenotype', 'eye primordium', 'epithelial fold', 'skin of body phenotype', 'interphase', 'absent arm bone in the forelimb', 'absent limb bone', 'visual system phenotype', 'organ system subdivision', 'Macule', 'integumentary adnexa phenotype', 'organ part physiology phenotype', 'absent organism subdivision', 'Abnormal eye morphology', 'intracellular organelle', 'embryonic tissue phenotype', 'regulation of biological process', 'number of anatomical enitites of type abdominal segment element phenotype', 'organ subunit phenotype', 'ectoderm-derived structure phenotype', 'integumental system', 'material anatomical entity', 'limb bud morphology phenotype', 'erythroid lineage cell', 'radius bone morphology phenotype', 'eukaryotic cell', 'germ layer', 'sense organ physiology phenotype', 'surface structure', 'eyeball of camera-type eye', 'forelimb zeugopod morphology phenotype', 'embryo phenotype', 'lens of camera-type eye phenotype', 'decreased number of leukocyte', 'subdivision of organism along appendicular axis phenotype', 'Abnormality of the skin', 'growth', 'entity', 'anatomical conduit physiology phenotype', 'Abnormal heart morphology', 'Abnormal localization of kidney', 'epithelium phenotype', 'vasculature of eye morphology phenotype', 'organ', 'migrating mesenchyme population phenotype', 'circulatory system phenotype', 'organ part phenotype', 'absent anatomical structure in the limb', 'connective tissue', 'anatomical entity physiology phenotype', 'mesenchyme derived from head neural crest phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'subdivision of organism along main body axis phenotype', 'growth phenotype', 'size of skull phenotype', 'number of anatomical enitites of type reticulocyte phenotype', 'Abnormal bleeding', 'forelimb zeugopod bone phenotype', 'cell phenotype', 'phalanx', 'Abnormality of the upper urinary tract', 'secretory cell', 'Bruising susceptibility', 'negative regulation of gene expression', 'face phenotype', 'digit phenotype', 'decreased size of the subdivision of organism along main body axis', 'skeletal element phenotype', 'optic choroid', 'absent digit', 'head phenotype', 'endochondral element', 'regulation of biological process phenotype', 'skin vasculature morphology; vascular skin abnormality', 'membraneless organelle', 'strabismus', 'Abnormality of the cardiovascular system', 'eye', 'sense organ phenotype', 'decreased number of erythrocyte', 'Duplicated collecting system', 'organ component layer', 'Abnormal skin morphology', 'external male genitalia phenotype', 'body proper', 'decreased qualitatively biological_process', 'musculature of body', 'Cafe-au-lait spot', 'head', 'future central nervous system', 'embryo', 'Localized skin lesion', 'musculoskeletal system phenotype', 'embryonic craniocervical region', 'anatomical entity', 'embryonic structure', 'multicellular anatomical structure phenotype', 'absent forelimb endochondral element', 'decreased length of organism subdivision', 'head blood vessel morphology phenotype', 'vasculature of head', 'appendage phenotype', 'Abnormality of the integument', 'absent forelimb endochondral element in the forelimb', 'paired limb/fin bud', 'decreased anatomical structure mass', 'neural plate', 'number of anatomical enitites of type granulocyte phenotype', 'DNA damage response phenotype', 'cranial neural crest', 'shape of kidney phenotype', 'myeloid cell', 'limb long bone morphology phenotype', 'Aplasia/hypoplasia involving forearm bones', 'regional part of brain phenotype', 'absent radius endochondral element', 'choroidal blood vessel phenotype', 'skeleton phenotype', 'endochondral bone', 'biological phase', 'material anatomical entity physiology phenotype', 'multicellular anatomical structure physiology phenotype', 'vessel', 'Aplasia/Hypoplasia involving the central nervous system', 'absent limb bone in the forelimb', 'blastula', 'skeletal system phenotype', 'integument', 'localised reproductive organ', 'Renal hypoplasia/aplasia', 'integumentary adnexa physiology phenotype', 'regulation of cellular process', 'skeletal system', 'phalanx endochondral element', 'aplasia or hypoplasia of manual digit 1', 'eye primordium phenotype', 'hematopoietic system', 'pathological phenotype observation', 'Phenotypic abnormality', 'cardiovascular system phenotype', 'telencephalon morphology phenotype', 'anatomical system physiology phenotype', 'digit plus metapodial segment', 'absent forelimb long bone in the forelimb', 'camera-type eye phenotype', 'heart phenotype', 'head mesenchyme', 'ribosome', 'choroidal neovascularization', 'platelet', 'system process phenotype', 'circulatory system', 'nervous system phenotype', 'head blood vessel', 'absent compound organ', 'regional part of nervous system phenotype', 'blood vessel morphology phenotype', 'appendicular skeletal system', 'reticulocyte', 'primary circulatory organ', 'ectoderm-derived structure physiology phenotype', 'uvea morphology phenotype', 'zone of organ phenotype', 'skin of body morphology phenotype', 'blood vessel phenotype', 'transparent eye structure', 'Abnormality of blood and blood-forming tissues', 'Abnormality of the vasculature', 'Generalized abnormality of skin', 'reproductive system phenotype', 'multicellular organismal process phenotype', 'oxygen accumulating cell', 'unilaminar epithelium phenotype', 'anatomical system', 'skeleton of manual acropodium', 'pectoral appendage skeleton', 'individual digit of digitopodial skeleton', 'structure with developmental contribution from neural crest phenotype', 'thoracic segment organ phenotype', 'Abnormal skull morphology', 'number of cell phenotype', 'behavior', 'bone cell', 'ecto-epithelium', 'Neoplasm by anatomical site', 'Abnormal bone marrow cell morphology', 'blood vasculature', 'vasculature phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'Abnormal finger phalanx morphology', 'independent continuant', 'Abnormal myeloid leukocyte morphology', 'immature eye', 'choroidal blood vessel', 'absent manual digit', 'mesenchyme', 'testis phenotype', 'absent multicellular anatomical structure in the tissue', 'organelle', 'paired limb/fin segment', 'non-connected functional system', 'manual digit 1 plus metapodial segment', 'Complete duplication of thumb phalanx', 'renal/urinary system phenotype', 'biological_process phenotype', 'epithelium', 'embryonic tissue', 'decreased number of cell', 'intracellular anatomical structure', 'absent organ in the limb', 'Abnormal renal morphology', 'anatomical entity morphology in the pectoral complex phenotype', 'neural fold morphology phenotype', 'choroidal blood vessel morphology phenotype', 'system process', 'primary circulatory organ phenotype', 'hemolymphoid system', 'sensory system phenotype', 'endocrine system', 'photoreceptor array', 'decreased length of anatomical structure', 'Abnormality of chromosome stability', 'vasculature of organ phenotype', 'decreased length of material anatomical entity', 'neural plate morphology phenotype', 'manus morphology phenotype', 'hematopoietic system phenotype', 'decreased number of anatomical entity', 'Subcutaneous hemorrhage', 'Puberty and gonadal disorders', 'anatomical structure physiology phenotype', 'morphology of intracellular organelle phenotype', 'Abnormal cardiovascular system morphology', 'absent organ in the tissue', 'head blood vessel phenotype', 'root', 'structure with developmental contribution from neural crest', 'sensory system', 'axial skeleton plus cranial skeleton morphology phenotype', 'head morphology phenotype', 'zone of skin', 'dysesthesia; hyperalgesia', 'excretory system', 'entire sense organ system', 'macula lutea', 'DNA repair', 'organism subdivision', 'multi-tissue structure phenotype', 'Abnormal cellular immune system morphology', 'neural plate phenotype', 'axial skeleton plus cranial skeleton phenotype', 'absent bone of pectoral complex in the limb', 'ectoderm morphology phenotype', 'neural crest', 'increased pigmentation', 'presumptive ectoderm phenotype', 'decreased length of multicellular anatomical structure', 'concave 3-D shape anatomical entity', 'zone of skin morphology phenotype', 'visual system', 'brain morphology phenotype', 'Abnormal cellular physiology', 'renal system', 'Ectopic kidney', 'viscus phenotype', 'decreased size of the material anatomical entity', 'Aplasia/hypoplasia involving bones of the hand', 'forelimb zeugopod bone morphology phenotype', 'cell', 'localised organ', 'number of anatomical enitites of type organ phenotype', 'Abnormality of mental function', 'circulatory organ', 'vascular system', 'cellular anatomical structure', 'decreased size of the head', 'decreased number of granulocyte', 'number of platelet phenotype', 'surface structure phenotype', 'developing anatomical structure phenotype', 'abdomen', 'external ectoderm', 'mesoderm morphology phenotype', 'craniocervical region morphology phenotype', 'musculature', 'pre-chordal neural plate', 'male infertility; male sterile', 'ribosome function phenotype', 'Abnormality of limbs', 'anatomical conduit phenotype', 'metabolic process phenotype', 'pathological anatomical entity', 'superficial fascia', 'anatomical entity morphology in the manus phenotype', 'posterior segment of eyeball morphology phenotype', 'neural fold phenotype', 'Eukaryota', 'localised trunk region element', 'number of myeloid cell phenotype', 'integument phenotype', 'upper limb segment', 'arm bone', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'uvea', 'digitopodium bone', 'Abnormality of the kidney', 'gastrula', 'Abnormality of the eye', 'skin of body', 'ectoderm', 'embryo morphology phenotype', 'germ layer / neural crest', 'ecchymosis', 'homeostatic process', 'absent material anatomical entity in the skeletal system', 'heart morphology phenotype', 'organism subdivision phenotype', 'decreased functionality of the multicellular anatomical structure', 'anatomical collection phenotype', 'anatomical collection', 'skeletal system morphology phenotype', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'macromolecule metabolic process phenotype', 'Abnormal digit morphology', 'limb', 'intracellular organelle function phenotype', 'pectoral appendage', 'decreased system process', 'pectoral complex', 'morphology of chromosome phenotype', 'pectoral appendage bud', 'central nervous system phenotype', 'Reticulocytopenia', 'Aplasia/Hypoplasia affecting the eye', 'behavior process', 'autopod bone', 'forelimb bone', 'forelimb long bone', 'behavior process phenotype', 'manual digit phalanx endochondral element', 'anatomical wall', 'manual digit 1 digitopodial skeleton', 'segment of manus', 'Small for gestational age', 'Intellectual disability', 'digitopodium region', 'tube', 'morphology of cellular_component phenotype', 'tube phenotype', 'organ phenotype', 'integumental system phenotype', 'testis morphology phenotype', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'decreased length of manual digit 1 or 5', 'acropodium region', 'ocular surface region morphology phenotype', 'Abnormality of thumb phalanx', 'autopod region', 'endochondral bone phenotype', 'male reproductive system morphology phenotype', 'Abnormal male external genitalia morphology', 'increased biological_process', 'appendicular skeleton', 'limb skeleton subdivision phenotype', 'dense mesenchyme tissue phenotype', 'arm phenotype', 'limb phenotype', 'skeleton', 'appendage girdle complex', 'subdivision of skeletal system phenotype', 'renal collecting system phenotype', 'neural tube', 'mesoderm', 'skeletal element', 'macromolecule biosynthetic process', 'lateral structure phenotype', 'forelimb', 'forelimb bud', 'manual digitopodium region', 'Vascular skin abnormality', 'manual digitopodium bone', 'presumptive ectoderm', 'manual digit 1 phalanx', 'reproductive system', 'autopod region morphology phenotype', 'Abnormal forearm bone morphology', 'regulation of cellular process phenotype', 'Abnormal appendicular skeleton morphology', 'bone of pectoral complex', 'camera-type eye', 'bone of free limb or fin', 'eye phenotype', 'limb bone', 'Abnormality of head or neck', 'decreased size of the multicellular organism', 'limb long bone', 'Abnormal thumb morphology', 'long bone morphology phenotype', 'forelimb endochondral element', 'Anemic pallor', 'autopod endochondral element', 'abdominal segment element phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'biological_process rate phenotype', 'digit 1', 'musculature phenotype', 'macula lutea morphology phenotype', 'mesenchyme derived from head neural crest', 'subdivision of skeletal system', 'consumption behavior phenotype', 'Absent forearm bone', 'digit', 'Abnormality of the hand', 'Abnormal skeletal morphology', 'embryonic autopod plate', 'vessel phenotype', 'skeleton of pectoral complex', 'Neoplasm', 'limb bud', 'platelet morphology', 'morphology of organelle phenotype', 'absent anatomical structure in the tissue', 'neural groove', 'absent forelimb bone in the forelimb', 'limb endochondral element phenotype', 'Abnormality of the immune system', 'Leukemia', 'absent multicellular anatomical structure in the renal system', 'Abnormal immune system morphology', 'absent lateral structure', 'forelimb skeleton phenotype', 'biological_process', 'immune system morphology phenotype', 'response to stimulus phenotype', 'cellular response to stress', 'macromolecule metabolic process', 'response to stress phenotype', 'number of anatomical enitites of type abdomen element phenotype', 'Microcephaly', 'regulation of biosynthetic process phenotype', 'nucleobase-containing compound metabolic process phenotype', 'anatomical entity mass phenotype', 'aplastic manual digit 1', 'Deficient excision of UV-induced pyrimidine dimers in DNA', 'DNA repair phenotype', 'size of anatomical entity phenotype', 'cellular response to stimulus phenotype', 'primary metabolic process', 'nucleobase-containing compound metabolic process', 'DNA metabolic process phenotype', 'response to stress', 'cellular response to stimulus', 'Aplasia/hypoplasia involving bones of the extremities', 'decreased size of the organ', 'germ layer / neural crest phenotype', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'absent material anatomical entity in the limb', 'absent organ', 'number of anatomical enitites of type compound organ phenotype', 'mesoderm phenotype', 'number of anatomical enitites of type kidney phenotype', 'anatomical cluster phenotype', 'absent anatomical structure in the multicellular organism', 'absent kidney', 'absent multicellular anatomical structure in the multicellular organism', 'embryonic tissue morphology phenotype', 'absent anatomical entity in the multicellular organism', 'cornea morphology phenotype', 'absent anatomical entity', 'external genitalia morphology; external genitalia phenotype', 'craniocervical region', 'number of anatomical enitites of type lateral structure phenotype', 'absent cavitated compound organ', 'arm bone phenotype', 'Renal agenesis', 'regulation of gene expression', 'absent material anatomical entity in the renal system', 'absent abdominal segment element', 'absent cavitated compound organ in the renal system', 'absent multicellular anatomical structure', 'Abnormality of the male genitalia', 'absent abdominal segment element in the renal system', 'decreased sensory perception of mechanical stimulus', 'absent anatomical entity in the renal system', 'decreased functionality of the anatomical structure', 'absent trunk region element in the renal system', 'absent organ in the multicellular organism', 'programmed DNA elimination by chromosome breakage', 'optic cup', 'number of anatomical enitites of type anatomical structure phenotype', 'digit 1 phenotype', 'absent abdomen element in the renal system', 'number of anatomical enitites of type anatomical entity phenotype', 'absent anatomical structure', 'number of anatomical enitites of type cavitated compound organ phenotype', 'absent forelimb endochondral element in the limb', 'neural tube phenotype', 'Abnormal platelet count', 'Thrombocytopenia', 'central nervous system', 'pallor', 'brain phenotype', 'Abnormality of neutrophils', 'bone of pectoral complex morphology phenotype', 'telencephalon phenotype', 'Abnormality of thrombocytes', 'Abnormal platelet morphology', 'forebrain phenotype', 'nervous system physiology phenotype', 'Decreased fertility', 'telencephalon', 'Anemia', 'brain', 'forebrain', 'absent anatomical entity in the forelimb', 'central nervous system morphology phenotype', 'regional part of nervous system', 'epithelial tube', 'Complete duplication of phalanx of hand', 'decreased height of the multicellular organism', 'decreased material anatomical entity mass', 'epithelial tube phenotype', 'Aplasia/Hypoplasia of the thumb', 'regional part of brain', 'Abnormality of globe size', 'eye morphology', 'hematopoietic system morphology phenotype', 'anterior polar cataract', 'decreased size of the sense organ', 'male reproductive organ morphology phenotype', 'negative regulation of biosynthetic process', 'aplasia or hypoplasia of eyeball of camera-type eye', 'vision/eye phenotype', 'aplasia or hypoplasia of anatomical entity', 'size of eyeball of camera-type eye phenotype', 'decreased size of the eyeball of camera-type eye', 'granulocyte morphology phenotype', 'organ part', 'decreased multicellular anatomical structure mass', 'anatomical structure mass phenotype', 'Decreased multicellular organism mass', 'autopodial extension phenotype', 'absent organ in the forelimb', 'blood cell', 'postcranial axial skeleton', 'Decreased anatomical entity mass', 'multicellular anatomical structure mass phenotype', 'tunica fibrosa of eyeball', 'material anatomical entity mass phenotype', 'negative regulation of cellular process', 'Abnormality of the head', 'decreased length of anatomical entity', 'number of cellular_component phenotype', 'Abnormality of reproductive system physiology', 'chromosome', 'Infertility', 'simple eye', 'Male infertility', 'number of chromosome phenotype', 'digit 1 plus metapodial segment', 'infertility; sterile', 'absent long bone', 'Abnormality of the musculoskeletal system', 'Abnormality of the genital system', 'anlage phenotype', 'Abnormal renal collecting system morphology', 'kidney mesenchyme phenotype', 'kidney mesenchyme', 'aplastic anatomical entity', 'Abnormal reticulocyte morphology', 'vascular system morphology phenotype', 'erythrocyte morphology phenotype', 'Abnormal erythrocyte morphology', 'enucleated reticulocyte morphology phenotype', 'Hearing abnormality', 'absent bone of free limb or fin in the forelimb', 'multicellular organismal process', 'delayed biological_process', 'acropodial skeleton', 'feeding behavior', 'anatomical structure', 'feeding behavior phenotype', 'paired limb/fin skeleton', 'drinking behavior phenotype', 'polydipsia', 'paired limb/fin segment phenotype', 'aplasia or hypoplasia of manual digit', 'anemia', 'drinking behavior', 'Metazoa', 'anterior neural tube phenotype', 'behavior phenotype', 'absent bone of pectoral complex in the forelimb', 'localised abdominal segment element', 'reproductive system morphology phenotype', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'external male genitalia', 'external genitalia phenotype', 'number of anatomical enitites of type organism subdivision phenotype', 'normal growth on benomyl', 'Abnormal external genitalia morphology', 'thoracic segment of trunk', 'male reproductive system', 'male reproductive system phenotype', 'negative regulation of biological process phenotype', 'reproductive structure phenotype', 'Aplasia/hypoplasia of the extremities', 'ectoderm-derived structure', 'pectoral appendage skeleton phenotype', 'digit 1 or 5 phenotype', 'taxon specific phenotype', 'gonad phenotype', 'absent forelimb long bone', 'Abnormal testis morphology', 'Abnormal morphology of the radius', 'reproductive organ phenotype', 'localised male reproductive organ', 'renal collecting system', 'Abnormal reproductive system morphology', 'increased qualitatively biological_process', 'localised reproductive structure', 'Cryptorchidism', 'male organism', 'Morphological central nervous system abnormality', 'cognition', 'gonad', 'male reproductive organ', 'sensory perception of mechanical stimulus', 'external genitalia', 'trunk phenotype', 'biological regulation', 'negative regulation of macromolecule metabolic process phenotype', 'regulation of metabolic process phenotype', 'musculature of body phenotype', 'negative regulation of macromolecule metabolic process', 'regulation of macromolecule biosynthetic process', 'absent limb long bone in the forelimb', 'gene expression phenotype', 'gene expression', 'Abnormal leukocyte morphology', 'negative regulation of metabolic process', 'regulation of biosynthetic process', 'regulation of macromolecule metabolic process', 'female infertility; female sterile', 'regulation of macromolecule metabolic process phenotype', 'regulation of gene expression phenotype', 'biosynthetic process phenotype', 'negative regulation of cellular process phenotype', 'negative regulation of macromolecule biosynthetic process', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'limb segment', 'paired limb/fin', 'negative regulation of metabolic process phenotype', 'Chromosomal breakage induced by crosslinking agents', 'biological regulation phenotype', 'Abnormal forebrain morphology', 'absent endochondral bone', 'nucleic acid metabolic process', 'Abnormal nervous system morphology', 'decreased size of the organism subdivision', 'Aplasia/Hypoplasia of the cerebrum', 'Abnormal cerebral morphology', 'multicellular organism mass phenotype', 'Abnormality of skull size', 'axial skeletal system', 'skull', 'Abnormality of the nervous system', 'anterior neural tube', 'skull phenotype', 'absent anatomical structure in the renal system', 'craniofacial/craniocervical phenotype', 'agenesis of anatomical entity', 'mesenchyme phenotype', 'size of head phenotype', 'head mesenchyme phenotype', 'axial skeleton plus cranial skeleton', 'anatomical entity height phenotype', 'decreased functionality of the organ', 'endocrine system phenotype', 'decreased functionality of the anatomical entity', 'decreased functionality of the material anatomical entity', 'retina phenotype', 'absent endochondral element in the forelimb', 'reproductive organ physiology phenotype', 'reproductive structure physiology phenotype', 'glandular system', 'decreased functionality of the reproductive structure', 'skeleton of limb', 'organ system subdivision phenotype', 'gonad physiology phenotype', 'external ectoderm morphology phenotype', 'decreased functionality of the reproductive organ', 'Hypogonadism', 'motile cell', 'long bone phenotype', 'organ physiology phenotype', 'absent material anatomical entity in the forelimb', 'absent limb long bone', 'delayed growth', 'absent organism subdivision in the multicellular organism', 'Aplasia/hypoplasia involving bones of the upper limbs', 'location of camera-type eye phenotype', 'absent multicellular anatomical structure in the forelimb', 'absent anatomical entity in the limb bud', 'material entity', 'Abnormality of DNA repair', 'absent material anatomical entity in the limb bud', 'Absent thumb', 'absent endochondral bone in the forelimb', 'aplasia or hypoplasia of skeleton', 'number of anatomical enitites of type neutrophil phenotype', 'neural crest-derived structure', 'Abnormal granulocyte count', 'absent multicellular anatomical structure in the limb', 'absent bone element in the limb', 'absent anatomical structure in the forelimb', 'Finger aplasia', 'Decreased body weight', 'Aplasia/Hypoplasia of fingers', 'Hypermelanotic macule', 'increased pigmentation in skin of body', 'radius bone phenotype', 'increased biological_process in skin of body', 'Hyperpigmentation of the skin', 'lens of camera-type eye', 'neural tube morphology phenotype', 'transparent eye structure phenotype', 'anterior segment of eyeball', 'nervous system process', 'Abnormal nervous system physiology', 'Abnormal leukocyte count', 'absent autopodial extension', 'anisocytosis', 'Abnormal granulocyte morphology', 'granulocyte', 'response to stimulus', 'Decreased total neutrophil count', 'neutrophil phenotype', 'Abnormal total neutrophil count', 'absent bone element in the forelimb', 'absent bone of appendage girdle complex', 'Absent radius', 'Abnormal upper limb bone morphology', 'metabolic process', 'bone of pectoral complex phenotype', 'Abnormality of body weight', 'absent limb endochondral element in the limb', 'forelimb zeugopod skeleton', 'zeugopod phenotype', 'absent skeletal element', 'absent arm bone', 'absent limb bone in the limb', 'zeugopodial skeleton', 'anterior region of body', 'forelimb bone phenotype', 'absent lateral structure in the renal system', 'absent radius endochondral element in the forelimb', 'absent skeletal element in the forelimb', 'biogenic amine secreting cell', 'absent limb endochondral element in the forelimb', 'posterior segment of eyeball', 'manual digit 1 phalanx endochondral element', 'number of anatomical enitites of type endochondral bone phenotype', 'cavitated compound organ', 'Aplasia involving forearm bones', 'digit 1 or 5', 'DNA damage response', 'radius bone', 'absent multicellular anatomical structure in the skeletal system', 'zeugopod', 'absent forelimb bone in the limb', 'forelimb endochondral element phenotype', 'number of anatomical enitites of type bone element phenotype', 'absent bone of appendage girdle complex in the forelimb', 'absent endochondral element in the limb', 'absent bone of free limb or fin', 'mesoderm-derived structure phenotype', 'number of anatomical enitites of type skeletal element phenotype', 'Aplasia/Hypoplasia of the radius', 'cerebral amyloid angiopathy', 'absent forelimb zeugopod bone in the forelimb', 'pigmentation', 'radius endochondral element', 'forelimb zeugopod', 'consumption behavior', 'absent anatomical entity in the skeletal system', 'reproductive organ', 'absent anatomical entity in the tissue', 'absent trunk region element in the multicellular organism', 'absent bone of appendage girdle complex in the limb', 'absent forelimb zeugopod bone'], 'has_descendant': ['MONDO:0009215'], 'has_descendant_label': ['Fanconi anemia complementation group A'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0013566', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group L', 'description': 'Any Fanconi anemia in which the cause of the disease is a mutation in the FANCL gene.', 'xref': ['DOID:0111082', 'GARD:15754', 'MEDGEN:854018', 'OMIM:614083', 'UMLS:C3469528'], 'synonym': ['FANCL', 'FANCL Fanconi anaemia', 'FANCL Fanconi anemia', 'Fanconi Anemia, complementation Group 50', 'Fanconi Anemia, complementation group type 50', 'Fanconi anaemia caused by mutation in FANCL', 'Fanconi anaemia complementation group type L', 'Fanconi anemia caused by mutation in FANCL', 'Fanconi anemia complementation group L', 'Fanconi anemia complementation group type L', 'Fanconi anemia, complementation group L'], 'exact_synonym': ['FANCL', 'FANCL Fanconi anaemia', 'FANCL Fanconi anemia', 'Fanconi Anemia, complementation group type 50', 'Fanconi anaemia caused by mutation in FANCL', 'Fanconi anaemia complementation group type L', 'Fanconi anemia caused by mutation in FANCL', 'Fanconi anemia complementation group L', 'Fanconi anemia complementation group type L'], 'related_synonym': ['Fanconi Anemia, complementation Group 50', 'Fanconi anemia, complementation group L'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0007018', 'HP:0000089', 'HP:0001511', 'HP:0000054', 'HP:0008551', 'HP:0001263', 'HP:0000437', 'HP:0000465', 'HP:0002032', 'HP:0002023', 'HP:0000582', 'HP:0000175', 'HP:0005528', 'HP:0002575', 'HP:0000316', 'HP:0000369', 'HP:0011968', 'HP:0001510', 'HP:0000238', 'HP:0000347', 'HP:0001776', 'HP:0003974', 'HP:0000470', 'HP:0000431', 'HP:0000957', 'HP:0003221', 'HP:0040012', 'HP:0004590', 'HP:0000568', 'HP:0000151', 'HP:0001321', 'HP:0001903', 'HP:0009892', 'HP:0002188', 'HP:0000122', 'HP:0009777'], 'has_phenotype_label': ['Growth delay', 'Anotia', 'Absent thumb', 'Hydrocephalus', 'Upslanted palpebral fissure', 'Intrauterine growth retardation', 'Bone marrow hypocellularity', 'Webbed neck', 'Global developmental delay', 'Anal atresia', 'Delayed CNS myelination', 'Micropenis', 'Microtia', 'Chromosomal breakage induced by crosslinking agents', 'Hypoplastic sacrum', 'Aplasia of the uterus', 'Chromosome breakage', 'Cerebellar hypoplasia', 'Anemia', 'Unilateral renal agenesis', 'Depressed nasal tip', 'Cleft palate', 'Feeding difficulties', 'Micrognathia', 'Wide nasal bridge', 'Short neck', 'Cafe-au-lait spot', 'Attention deficit hyperactivity disorder', 'Tracheoesophageal fistula', 'Esophageal atresia', 'Microphthalmia', 'Hypertelorism', 'Renal hypoplasia', 'Bilateral talipes equinovarus', 'Absent radius', 'Low-set ears'], 'has_phenotype_count': 36, 'has_phenotype_closure': ['UPHENO:0026095', 'UPHENO:0026098', 'UPHENO:0002785', 'UPHENO:0008640', 'UPHENO:0087349', 'HP:0003953', 'UPHENO:0009356', 'UPHENO:0086956', 'UPHENO:0009399', 'UBERON:0015021', 'UBERON:0003606', 'UBERON:0010741', 'UPHENO:0025135', 'UBERON:0003466', 'UPHENO:0002751', 'UPHENO:0008604', 'UBERON:0002495', 'UPHENO:0011492', 'UPHENO:0025166', 'UPHENO:0009366', 'UPHENO:0079872', 'UPHENO:0004595', 'UPHENO:0002659', 'UPHENO:0025547', 'UPHENO:0008865', 'UPHENO:0009341', 'UPHENO:0002594', 'UBERON:0010703', 'UPHENO:0026074', 'UPHENO:0009337', 'UPHENO:0076754', 'UBERON:0003607', 'HP:0006503', 'UPHENO:0025497', 'HP:0003974', 'UPHENO:0008743', 'UPHENO:0002969', 'UPHENO:0008475', 'UPHENO:0075944', 'UPHENO:0027189', 'UPHENO:0025882', 'UPHENO:0011568', 'HP:0040072', 'UPHENO:0011573', 'UPHENO:0002738', 'UPHENO:0009344', 'UPHENO:0025136', 'UBERON:0001423', 'UBERON:0003460', 'UPHENO:0025652', 'UPHENO:0087501', 'UPHENO:0025808', 'UPHENO:0009115', 'UPHENO:0027630', 'UPHENO:0002967', 'UPHENO:0086628', 'HP:0001883', 'UPHENO:0076941', 'HP:0001760', 'UBERON:0002387', 'UPHENO:0002585', 'UPHENO:0089269', 'UPHENO:0003411', 'UBERON:0000154', 'UBERON:0005420', 'UBERON:0002471', 'UBERON:0010709', 'UBERON:0004709', 'UBERON:0005418', 'UBERON:0002103', 'HP:0001776', 'HP:0011458', 'HP:0000357', 'UPHENO:0018426', 'UPHENO:0081783', 'HP:0000369', 'UPHENO:0081784', 'GO:0050890', 'NBO:0000338', 'NBO:0000607', 'GO:0003008', 'HP:5200241', 'HP:0007018', 'UPHENO:0049855', 'UPHENO:0002719', 'UPHENO:0055063', 'NBO:0000308', 'HP:0000736', 'HP:0000708', 'HP:0000734', 'UPHENO:0012047', 'GO:0050877', 'HP:5200044', 'NBO:0000455', 'UPHENO:0080671', 'HP:0009822', 'UPHENO:0081511', 'UPHENO:0080281', 'HP:0025780', 'UPHENO:0055002', 'HP:0011446', 'UPHENO:0002211', 'UPHENO:7000165', 'UPHENO:0026073', 'UPHENO:0002219', 'UPHENO:7000179', 'UPHENO:0087928', 'UPHENO:0002403', 'UPHENO:0002352', 'GO:0019222', 'GO:0009059', 'UPHENO:0050040', 'UPHENO:0049642', 'UPHENO:0025845', 'UPHENO:0050126', 'UPHENO:0049757', 'GO:0065007', 'GO:0042592', 'UPHENO:0049870', 'UPHENO:0049837', 'UPHENO:0049775', 'UPHENO:0050778', 'UPHENO:0050007', 'HP:0003220', 'UPHENO:0008430', 'UPHENO:0049868', 'HP:0001939', 'UPHENO:0050063', 'GO:0050794', 'GO:0048519', 'GO:0009058', 'GO:0043170', 'GO:0010556', 'GO:0009890', 'UPHENO:0078606', 'UPHENO:0049620', 'UPHENO:0049904', 'GO:0010467', 'UPHENO:0049873', 'HP:0003221', 'HP:0000951', 'UPHENO:0074575', 'GO:0043473', 'HP:0001034', 'HP:0011355', 'HP:0025354', 'UBERON:0002097', 'UBERON:0002199', 'UPHENO:0002635', 'HP:0001574', 'HP:0001000', 'UPHENO:0081119', 'HP:0005561', 'UPHENO:0077418', 'UBERON:0002405', 'UPHENO:0085409', 'HP:0012145', 'UPHENO:0080009', 'UPHENO:0077371', 'UPHENO:0085306', 'UPHENO:0003067', 'UPHENO:0081585', 'UPHENO:0006147', 'UPHENO:0006161', 'UPHENO:0006140', 'UBERON:0008340', 'UPHENO:0087278', 'UBERON:0006333', 'UPHENO:0025961', 'HP:0000422', 'HP:0000431', 'UBERON:0000079', 'UPHENO:0002697', 'HP:0000032', 'HP:0000036', 'UPHENO:0068921', 'UPHENO:0002597', 'UPHENO:0068967', 'UBERON:0004053', 'UPHENO:0068824', 'UPHENO:0081320', 'HP:0000811', 'UBERON:0000989', 'HP:0000957', 'UPHENO:0087548', 'UPHENO:0068979', 'GO:0008152', 'UPHENO:7000149', 'UPHENO:0087585', 'UBERON:0004089', 'UPHENO:0075655', 'HP:0000153', 'UPHENO:0076786', 'UPHENO:0076739', 'UPHENO:0033592', 'UBERON:0001709', 'UBERON:0000978', 'UBERON:0002371', 'UPHENO:7000055', 'UPHENO:0004520', 'UBERON:0000167', 'UBERON:0000464', 'UPHENO:0033565', 'HP:0100543', 'UPHENO:0075998', 'UBERON:0002553', 'UPHENO:0033612', 'UPHENO:0033599', 'UPHENO:0033560', 'UPHENO:0076760', 'HP:5201015', 'UBERON:0000995', 'UBERON:0000474', 'UPHENO:7000069', 'UBERON:0001716', 'UPHENO:0009192', 'UPHENO:0026509', 'UPHENO:0002955', 'UBERON:0005156', 'HP:0000008', 'UBERON:0013515', 'UBERON:0003133', 'UPHENO:0025546', 'UPHENO:0026014', 'UPHENO:0005170', 'HP:0000151', 'UBERON:0000014', 'UPHENO:0011847', 'UPHENO:0025215', 'UPHENO:0026152', 'UPHENO:0011485', 'HP:0000130', 'UPHENO:0005022', 'UPHENO:0080187', 'UPHENO:0025817', 'UPHENO:0002598', 'UPHENO:0087806', 'UPHENO:0008850', 'UPHENO:0080158', 'HP:0000078', 'UPHENO:0025243', 'HP:0010460', 'UPHENO:0003053', 'UPHENO:0009010', 'UPHENO:0087974', 'UPHENO:0002523', 'UPHENO:0052855', 'UPHENO:0025401', 'HP:0012243', 'HP:0007400', 'UPHENO:0026407', 'UPHENO:0009181', 'UBERON:0000990', 'HP:0008684', 'UPHENO:0080377', 'HP:0000174', 'HP:0001511', 'UPHENO:0005573', 'UPHENO:0052160', 'UPHENO:0005597', 'UPHENO:0052178', 'UPHENO:0052694', 'UPHENO:0080382', 'UPHENO:0005642', 'UPHENO:0080393', 'UPHENO:0087802', 'UBERON:0000004', 'UBERON:0005497', 'UBERON:0034929', 'HP:0010938', 'UPHENO:0041098', 'UPHENO:0002727', 'UPHENO:0002782', 'UPHENO:0002803', 'UPHENO:0002945', 'UPHENO:0087006', 'UBERON:5002544', 'UBERON:0000026', 'UBERON:0004357', 'UBERON:0005061', 'UPHENO:0004466', 'NBO:0000604', 'UPHENO:0026181', 'HP:0000119', 'UPHENO:0002830', 'UPHENO:0002880', 'UPHENO:0074360', 'HP:0009380', 'UPHENO:0076692', 'UPHENO:0050121', 'UPHENO:0002896', 'UBERON:0003050', 'UPHENO:0025585', 'UBERON:0003081', 'HP:0012443', 'HP:0008518', 'UPHENO:0086769', 'UBERON:0002102', 'UPHENO:0075219', 'UPHENO:0076703', 'UPHENO:0054937', 'UBERON:0002204', 'UPHENO:0025544', 'HP:0001507', 'UPHENO:0002708', 'UBERON:0004176', 'GO:0040007', 'UPHENO:0000541', 'UBERON:0000020', 'UPHENO:0076735', 'UPHENO:0002532', 'HP:0001762', 'UPHENO:0049874', 'UPHENO:0014971', 'UPHENO:0002859', 'UPHENO:0002769', 'HP:0008771', 'UPHENO:0002430', 'UPHENO:0074311', 'HP:0001263', 'UBERON:0005174', 'UPHENO:0002905', 'UPHENO:0001134', 'UPHENO:0080114', 'UPHENO:0050435', 'UPHENO:0063639', 'UPHENO:0025507', 'UPHENO:7000206', 'UPHENO:0002763', 'UPHENO:0003812', 'UBERON:0004582', 'UPHENO:7000208', 'UPHENO:0002755', 'UPHENO:0004456', 'HP:0002589', 'UPHENO:0050406', 'UPHENO:0063562', 'UPHENO:0063580', 'UBERON:0000924', 'UPHENO:0063576', 'UBERON:0003076', 'UPHENO:0005214', 'UPHENO:0063594', 'UBERON:0003134', 'UPHENO:0063558', 'UPHENO:0026023', 'UPHENO:0049652', 'HP:0012758', 'UPHENO:0000509', 'UBERON:5001463', 'UPHENO:0050068', 'UBERON:0007779', 'HP:0000598', 'UPHENO:0081581', 'UPHENO:0063565', 'UPHENO:0002837', 'UBERON:0013522', 'HP:0010461', 'UPHENO:0026010', 'UPHENO:0011572', 'UBERON:0002101', 'UPHENO:0005986', 'UPHENO:0026108', 'UPHENO:0083162', 'UPHENO:7000372', 'HP:0033127', 'UPHENO:0008689', 'UPHENO:0052778', 'UBERON:0002398', 'UBERON:0004708', 'UPHENO:0025708', 'UPHENO:0087849', 'UPHENO:0086699', 'UPHENO:0079835', 'UPHENO:0025875', 'UPHENO:0074228', 'UBERON:0006077', 'UPHENO:0081210', 'UBERON:0002268', 'UPHENO:0074584', 'UPHENO:0025666', 'UBERON:0000117', 'HP:0008551', 'UPHENO:0033572', 'UBERON:0019221', 'UPHENO:0026984', 'UBERON:0001690', 'UPHENO:0003459', 'UBERON:0011138', 'UPHENO:0002308', 'UBERON:0005451', 'UPHENO:0026940', 'UPHENO:0076730', 'UPHENO:0026082', 'UPHENO:0002576', 'UPHENO:0008523', 'UBERON:0019231', 'UPHENO:0026514', 'UBERON:0005085', 'UPHENO:0068965', 'UPHENO:0087547', 'GO:0042756', 'GO:0048709', 'BFO:0000003', 'UPHENO:0050106', 'UBERON:0008785', 'UPHENO:0002554', 'UPHENO:0011770', 'CL:0000000', 'UPHENO:0076718', 'UPHENO:0079826', 'UBERON:0003075', 'UBERON:0004121', 'BFO:0000015', 'GO:0007631', 'UBERON:0006876', 'UPHENO:0004704', 'UPHENO:0025176', 'UPHENO:7000311', 'UPHENO:7000640', 'NBO:0001845', 'CL:0000988', 'UBERON:0001434', 'UPHENO:0075195', 'UPHENO:0076740', 'UPHENO:0026183', 'UPHENO:0049622', 'UPHENO:0049664', 'UPHENO:0081091', 'UPHENO:0081466', 'UPHENO:0018390', 'UPHENO:0026227', 'UPHENO:0002891', 'UBERON:0000926', 'UPHENO:0004143', 'UPHENO:0004173', 'UBERON:0000033', 'UPHENO:0002887', 'UPHENO:0002910', 'UPHENO:0049743', 'UPHENO:0003460', 'UPHENO:0002637', 'UPHENO:0005097', 'UPHENO:0002948', 'HP:0012718', 'UPHENO:0063575', 'UBERON:0000153', 'UPHENO:0026312', 'UPHENO:0003488', 'UPHENO:0086589', 'UBERON:0004288', 'UPHENO:0026706', 'BFO:0000002', 'UPHENO:0004503', 'GO:0030587', 'UPHENO:0004721', 'UPHENO:0002577', 'HP:0005656', 'HP:0002031', 'UPHENO:0004757', 'UPHENO:0004494', 'UPHENO:0026317', 'UBERON:0004362', 'UBERON:0004088', 'UBERON:0007811', 'UPHENO:0002844', 'UBERON:0010312', 'HP:0000953', 'UBERON:0000015', 'UPHENO:0004969', 'UPHENO:0003070', 'UPHENO:0003410', 'UBERON:0004710', 'UBERON:0012475', 'HP:0001877', 'UBERON:0001032', 'UPHENO:0001570', 'UPHENO:0008703', 'UPHENO:0018424', 'HP:0001510', 'UPHENO:0002822', 'UBERON:0001444', 'UPHENO:0014865', 'UBERON:0000075', 'HP:0001903', 'HP:0011968', 'UPHENO:0003159', 'UPHENO:0004536', 'UPHENO:0003207', 'UPHENO:0005025', 'UPHENO:0083646', 'UPHENO:0034969', 'UBERON:0007503', 'UBERON:0010712', 'UPHENO:0002731', 'UPHENO:0072194', 'UBERON:0005881', 'UPHENO:0080010', 'UPHENO:0087472', 'GO:0010558', 'HP:0100886', 'UBERON:0007798', 'UPHENO:0088168', 'UPHENO:0075997', 'UPHENO:0004433', 'HP:0045060', 'HP:0032039', 'UPHENO:0063834', 'GO:0032501', 'UPHENO:0002866', 'UPHENO:0027631', 'UPHENO:0072185', 'UPHENO:0005008', 'UPHENO:0002567', 'UPHENO:0002701', 'UPHENO:0002916', 'UBERON:0004572', 'UPHENO:0011498', 'UPHENO:0063586', 'UPHENO:0086501', 'UBERON:0000063', 'UPHENO:0076729', 'HP:0000924', 'HP:0006501', 'UPHENO:0025234', 'UBERON:0001711', 'UPHENO:0063581', 'UBERON:0001043', 'UBERON:0005409', 'UPHENO:0054970', 'UPHENO:0084770', 'UPHENO:0027547', 'UPHENO:0004047', 'UBERON:0003089', 'UPHENO:0004523', 'UPHENO:0002536', 'UPHENO:0088326', 'UPHENO:0004621', 'UPHENO:0081436', 'UPHENO:0046505', 'HP:0002011', 'UBERON:0000465', 'UBERON:0006598', 'UPHENO:0009031', 'HP:0012639', 'UPHENO:0025852', 'UPHENO:0076805', 'HP:0002032', 'UPHENO:0002434', 'UBERON:0004908', 'NCBITaxon:1', 'UPHENO:0009305', 'UPHENO:0087347', 'UPHENO:0080079', 'UPHENO:0002733', 'UPHENO:0081314', 'UPHENO:0008709', 'UPHENO:0088186', 'UPHENO:0074245', 'UPHENO:0080300', 'UPHENO:0002944', 'UPHENO:0087089', 'UPHENO:0005433', 'UPHENO:0002909', 'UBERON:0009569', 'UPHENO:0063559', 'UPHENO:0035150', 'UBERON:0004732', 'UPHENO:0004892', 'UPHENO:0003004', 'GO:0032502', 'UPHENO:0002839', 'UBERON:0009145', 'UPHENO:0003516', 'UBERON:0016879', 'UPHENO:0002983', 'UPHENO:0003550', 'UPHENO:0002949', 'UPHENO:3000007', 'UPHENO:0003088', 'UPHENO:0081601', 'GO:0010001', 'HP:0012372', 'HP:0008772', 'UPHENO:0002818', 'HP:0000054', 'UPHENO:0035003', 'UPHENO:0076791', 'NBO:0000011', 'UPHENO:0087478', 'UPHENO:0002987', 'UBERON:0000025', 'UPHENO:0003020', 'UBERON:0010912', 'HP:0006265', 'UPHENO:0011825', 'UPHENO:0009396', 'UPHENO:0087186', 'UPHENO:0001003', 'UBERON:0002470', 'UPHENO:0086932', 'UPHENO:7000632', 'UPHENO:0011531', 'UBERON:0007272', 'UBERON:0002390', 'UBERON:0011216', 'UBERON:0004347', 'GO:0007610', 'UPHENO:0002559', 'UBERON:0000019', 'UPHENO:0050108', 'GO:0022008', 'RO:0002577', 'UPHENO:0002571', 'UPHENO:0009295', 'UPHENO:0003005', 'UBERON:0010222', 'UBERON:0000468', 'UPHENO:0076776', 'HP:0001317', 'HP:0006496', 'UPHENO:0004802', 'UBERON:0010758', 'UBERON:0001359', 'UPHENO:0050034', 'UPHENO:0002927', 'UBERON:0013702', 'UPHENO:0002963', 'UPHENO:0005141', 'UPHENO:0004625', 'UPHENO:0003055', 'UBERON:0012139', 'UPHENO:0084771', 'GO:0051703', 'UBERON:0003129', 'UBERON:0001062', 'GO:0048523', 'CL:0000255', 'UPHENO:0002527', 'UPHENO:0088123', 'UBERON:0005423', 'UPHENO:0027008', 'HP:0025033', 'UPHENO:0080087', 'UPHENO:0002907', 'UBERON:0002530', 'UBERON:0002037', 'UBERON:0004111', 'UPHENO:0002542', 'UPHENO:0035160', 'UBERON:0000047', 'HP:0000316', 'HP:0011283', 'UPHENO:0002568', 'UPHENO:0002864', 'GO:0048856', 'UBERON:0005856', 'UPHENO:0003412', 'UPHENO:0000554', 'UPHENO:0086792', 'UPHENO:0081095', 'UPHENO:0002558', 'UPHENO:0003002', 'UBERON:0009142', 'UPHENO:0002746', 'UPHENO:0002721', 'UBERON:0011158', 'UBERON:0000463', 'UPHENO:0054958', 'CL:0002092', 'HP:0012252', 'UBERON:0000925', 'HP:0000175', 'UBERON:0000490', 'UBERON:0011584', 'HP:0011024', 'UPHENO:0086824', 'UPHENO:0035147', 'UPHENO:0002734', 'HP:0007360', 'UBERON:0001460', 'UPHENO:0002962', 'GO:0030154', 'UPHENO:0002654', 'UPHENO:0081099', 'UBERON:0000916', 'UPHENO:0005030', 'UPHENO:0004909', 'NCBITaxon:33208', 'UPHENO:0002765', 'UPHENO:0080099', 'UPHENO:0087359', 'UPHENO:0086717', 'HP:0002977', 'UPHENO:0081598', 'UPHENO:0076779', 'UPHENO:0001072', 'UPHENO:0074310', 'UPHENO:0087660', 'UPHENO:0050065', 'UBERON:0003135', 'UPHENO:0084763', 'CL:0000764', 'UPHENO:0002388', 'HP:0002575', 'HP:0011017', 'UBERON:0002544', 'UBERON:0003929', 'UPHENO:0004507', 'UPHENO:0004484', 'UPHENO:0002541', 'UPHENO:0003432', 'UBERON:0000466', 'UBERON:0000993', 'UBERON:0003458', 'UPHENO:0063603', 'UBERON:0001691', 'UPHENO:0086679', 'UPHENO:0088170', 'UPHENO:0001002', 'UPHENO:0025855', 'UBERON:0000477', 'HP:0000118', 'UPHENO:0027020', 'UBERON:0015833', 'CL:0000232', 'GO:0032291', 'UBERON:0003100', 'UBERON:0012140', 'UPHENO:0069161', 'UPHENO:0002269', 'UPHENO:0076803', 'UBERON:0015204', 'UPHENO:0002870', 'UPHENO:0051450', 'UPHENO:0002868', 'UPHENO:0004519', 'UBERON:0000062', 'UPHENO:0026280', 'HP:0000582', 'UPHENO:0005058', 'HP:0040070', 'GO:0050789', 'NCBITaxon:33154', 'HP:0005107', 'UPHENO:0069523', 'UBERON:0006601', 'HP:0000163', 'HP:0040068', 'UBERON:0003057', 'UPHENO:0063722', 'UPHENO:0004888', 'UBERON:0007375', 'UPHENO:0002548', 'UPHENO:0074237', 'UPHENO:0002903', 'UBERON:0010000', 'UPHENO:0003082', 'UPHENO:0025553', 'UPHENO:0050734', 'GO:0031049', 'UPHENO:0002732', 'UPHENO:0004680', 'UPHENO:0003095', 'UBERON:0011249', 'UPHENO:0063822', 'UPHENO:0002443', 'HP:0000377', 'UPHENO:0002385', 'GO:0010605', 'UBERON:0004456', 'UBERON:0005417', 'UPHENO:0005647', 'UPHENO:0005275', 'UPHENO:0004788', 'UBERON:0005291', 'HP:0001321', 'GO:0009987', 'UPHENO:0004709', 'UPHENO:0003027', 'UPHENO:0086797', 'UPHENO:0002754', 'UPHENO:0002530', 'UPHENO:0080089', 'UPHENO:0003334', 'GO:0009790', 'UPHENO:0002579', 'HP:5200263', 'CL:0000081', 'UPHENO:0002725', 'CL:0001035', 'UPHENO:0005016', 'UPHENO:0056150', 'UBERON:0010913', 'UPHENO:0002736', 'UPHENO:0014240', 'UBERON:0002050', 'UPHENO:0087363', 'UPHENO:0002971', 'UBERON:0000483', 'UPHENO:0049590', 'UPHENO:0003181', 'UBERON:0004119', 'UPHENO:0088162', 'UPHENO:0004891', 'CL:0000763', 'UPHENO:0086485', 'NCBITaxon:131567', 'UBERON:0002049', 'HP:0000122', 'UBERON:0003975', 'UPHENO:0025777', 'UPHENO:0003485', 'HP:0000478', 'UPHENO:0086635', 'NCBITaxon:2759', 'UPHENO:0003811', 'UBERON:0000064', 'UBERON:0000073', 'HP:0002973', 'UPHENO:0025570', 'UBERON:0001009', 'GO:0048731', 'UPHENO:0080110', 'UPHENO:0002593', 'UBERON:0001132', 'HP:0012638', 'UPHENO:0086700', 'UPHENO:0002674', 'UPHENO:9002003', 'UPHENO:0072264', 'UPHENO:0087907', 'UPHENO:0074329', 'UPHENO:0076720', 'UBERON:0013765', 'GO:0010629', 'UPHENO:0072200', 'UPHENO:0083161', 'UPHENO:0026146', 'UPHENO:0003514', 'UBERON:0006800', 'HP:0011844', 'UPHENO:0063846', 'UPHENO:0002668', 'UPHENO:0002433', 'GO:0008366', 'UBERON:0010188', 'UPHENO:0009146', 'UBERON:0000970', 'UPHENO:0002687', 'UPHENO:0063579', 'HP:0001167', 'UBERON:0008814', 'UPHENO:0054957', 'UPHENO:0004885', 'UPHENO:0002574', 'BFO:0000001', 'HP:0000001', 'HP:0009892', 'UPHENO:0084761', 'HP:0000707', 'UPHENO:0083046', 'UBERON:0001004', 'UPHENO:0003001', 'UBERON:0000923', 'UPHENO:0003058', 'UPHENO:0003413', 'UBERON:0006314', 'UPHENO:0081786', 'UPHENO:0000543', 'UBERON:0001007', 'GO:0099120', 'UPHENO:0080325', 'UBERON:0012314', 'UPHENO:0026506', 'UPHENO:0005055', 'UBERON:0002028', 'UPHENO:0003186', 'UPHENO:0008548', 'UPHENO:0087665', 'UPHENO:0002525', 'UBERON:0000467', 'UPHENO:0005092', 'UBERON:0004535', 'UPHENO:0002750', 'HP:0011282', 'HP:0011400', 'UPHENO:0004459', 'UBERON:0010230', 'UBERON:0003126', 'UPHENO:0063577', 'UPHENO:0005285', 'UBERON:0001016', 'UBERON:0001456', 'UBERON:0001041', 'UPHENO:0001001', 'UPHENO:0063615', 'HP:0012733', 'UBERON:0010371', 'UBERON:0000479', 'UPHENO:0003936', 'HP:0001871', 'UBERON:0003103', 'HP:0009115', 'UBERON:0002105', 'UBERON:0000955', 'UBERON:0010708', 'UPHENO:0011739', 'UPHENO:0076752', 'UPHENO:0005424', 'UBERON:0001048', 'UPHENO:0072195', 'UPHENO:0005110', 'UPHENO:0078629', 'UPHENO:0025187', 'HP:0002921', 'UPHENO:3000004', 'UBERON:0005181', 'UPHENO:0002832', 'UPHENO:0002764', 'UBERON:0000061', 'HP:0000568', 'UPHENO:0063563', 'HP:0000104', 'UBERON:0004733', 'UBERON:0000065', 'HP:0000752', 'UPHENO:0003025', 'UPHENO:0076785', 'HP:0025031', 'UPHENO:0002261', 'UPHENO:0087339', 'UPHENO:0003391', 'HP:0005607', 'GO:0009889', 'HP:0011121', 'UBERON:0016880', 'UPHENO:0004900', 'UPHENO:7000623', 'UBERON:0001049', 'HP:0004590', 'UBERON:0000475', 'UBERON:0002075', 'UBERON:0005911', 'UPHENO:0025545', 'UPHENO:0009163', 'UPHENO:0004615', 'HP:0000079', 'UPHENO:0011536', 'UPHENO:0002553', 'UPHENO:0049587', 'UPHENO:0002634', 'UBERON:0002368', 'HP:0000925', 'UPHENO:0035045', 'UBERON:0005177', 'UBERON:0001895', 'UPHENO:0015184', 'UPHENO:0002813', 'UBERON:0005358', 'UBERON:0006072', 'UBERON:0034923', 'UPHENO:7000359', 'HP:0000492', 'UPHENO:0003116', 'UBERON:0003509', 'UPHENO:0089270', 'UPHENO:0003776', 'UBERON:0001558', 'HP:0012210', 'UPHENO:0003571', 'UPHENO:0063574', 'UPHENO:0003101', 'UPHENO:0002919', 'UBERON:0012354', 'UPHENO:0053456', 'UPHENO:0004481', 'UPHENO:0002267', 'UPHENO:0003031', 'UPHENO:0002529', 'UPHENO:0074229', 'UBERON:0004734', 'UPHENO:0004205', 'UPHENO:0002994', 'UBERON:0006075', 'UBERON:0000915', 'UPHENO:0026309', 'UPHENO:0002448', 'UBERON:0002193', 'UBERON:0004120', 'UBERON:0007196', 'UPHENO:0002386', 'UPHENO:0002648', 'UBERON:0034921', 'UPHENO:0074231', 'HP:0009118', 'UBERON:0008811', 'UBERON:0001005', 'GO:0048869', 'UBERON:0000055', 'GO:0008150', 'UPHENO:0003084', 'UPHENO:0086546', 'UPHENO:0011845', 'UPHENO:0004094', 'UPHENO:0087816', 'UBERON:0010740', 'UPHENO:0068971', 'UPHENO:0003086', 'UPHENO:0002902', 'UBERON:0001981', 'UPHENO:0002747', 'UPHENO:0009382', 'UPHENO:0003019', 'UPHENO:0075948', 'UPHENO:0084448', 'UPHENO:0005104', 'UBERON:0002616', 'UPHENO:0025508', 'UBERON:0003828', 'UPHENO:0053330', 'UBERON:0005178', 'UBERON:0003462', 'UPHENO:0005106', 'UPHENO:0041226', 'UBERON:0003920', 'UBERON:0001555', 'UPHENO:0003050', 'UBERON:0015203', 'UPHENO:0086633', 'UBERON:0002346', 'UPHENO:0004443', 'UBERON:0003258', 'UPHENO:0087846', 'UPHENO:0002976', 'UBERON:0000949', 'UPHENO:0087433', 'UPHENO:0014292', 'UBERON:0000072', 'UPHENO:0041821', 'UBERON:0011582', 'UBERON:0001015', 'UBERON:0010314', 'UPHENO:0003049', 'UPHENO:0081141', 'UPHENO:0076727', 'UBERON:0005419', 'UBERON:0001819', 'UPHENO:0075902', 'UPHENO:0026643', 'HP:0025032', 'UPHENO:0004525', 'UBERON:0003102', 'UBERON:0002529', 'UPHENO:0050008', 'UPHENO:0003227', 'UPHENO:0080126', 'UPHENO:0008668', 'UPHENO:0009209', 'UPHENO:0002804', 'UPHENO:0025661', 'UPHENO:0076702', 'UPHENO:0002833', 'HP:0000437', 'HP:0009601', 'UPHENO:0046483', 'UPHENO:0002632', 'UBERON:0007827', 'UBERON:0002355', 'UBERON:8450002', 'UBERON:0002389', 'UBERON:0001638', 'UPHENO:0087663', 'HP:0011821', 'UPHENO:0002531', 'UBERON:0004765', 'UBERON:0001474', 'UBERON:0035639', 'UPHENO:0026808', 'UPHENO:0033635', 'UPHENO:0087423', 'UPHENO:0009020', 'UPHENO:0002678', 'UBERON:0006058', 'UBERON:0010363', 'UPHENO:0026097', 'UBERON:0011676', 'UPHENO:0087924', 'UBERON:0000481', 'UBERON:0001463', 'HP:0011842', 'HP:0002118', 'UPHENO:0003069', 'HP:0002817', 'UPHENO:0087662', 'UPHENO:0080171', 'HP:0005927', 'UPHENO:0025195', 'UPHENO:0002650', 'HP:0000347', 'HP:0009777', 'UPHENO:0002685', 'UBERON:0001442', 'HP:0040012', 'UPHENO:0004476', 'UBERON:0002091', 'UBERON:0010130', 'UBERON:0001440', 'UPHENO:0002646', 'UBERON:0010538', 'UBERON:0010313', 'UPHENO:0026486', 'UBERON:0000489', 'UBERON:0004921', 'UPHENO:0003415', 'UPHENO:0025509', 'HP:0000202', 'UPHENO:0035181', 'UPHENO:0087513', 'NBO:0000313', 'HP:0011297', 'UBERON:0002513', 'UBERON:0002546', 'UPHENO:0079876', 'GO:0042063', 'UBERON:0015061', 'GO:0009892', 'UPHENO:0000556', 'UPHENO:0004480', 'UPHENO:0026640', 'UPHENO:0081451', 'UPHENO:0080165', 'UPHENO:0003366', 'UPHENO:0008545', 'UPHENO:0011566', 'UPHENO:0011559', 'UPHENO:0026096', 'HP:0040064', 'UPHENO:0003605', 'UBERON:0010707', 'UPHENO:0026504', 'UBERON:0005473', 'UBERON:0003104', 'UBERON:0012141', 'UPHENO:0002861', 'UBERON:0003101', 'HP:0001155', 'UPHENO:0076724', 'UBERON:0006048', 'UBERON:0004375', 'UBERON:0002428', 'GO:0060255', 'UPHENO:0002586', 'UPHENO:0056149', 'UBERON:0009955', 'UPHENO:0003237', 'UPHENO:0076723', 'UPHENO:0004475', 'UPHENO:0041458', 'UBERON:0000922', 'UPHENO:0026757', 'UBERON:0000383', 'UBERON:0007524', 'UBERON:5006048', 'UPHENO:0080111', 'HP:0001172', 'UPHENO:0002600', 'UPHENO:0014285', 'UPHENO:0002977', 'UPHENO:0004956', 'GO:0014003', 'UPHENO:0085938', 'UPHENO:0025955', 'UBERON:0000178', 'UPHENO:0056242', 'UBERON:0002386', 'UPHENO:0088185', 'GO:0048468', 'UPHENO:0050372', 'UBERON:0004381', 'UPHENO:0086486', 'UPHENO:0014351', 'HP:0000238', 'UBERON:0008784', 'UPHENO:0005029', 'UBERON:0004923', 'HP:0008736', 'UBERON:0000060', 'UPHENO:0088047', 'UPHENO:0026630', 'UPHENO:0056250', 'UPHENO:0075877', 'UPHENO:0056158', 'HP:0000315', 'UPHENO:0027231', 'HP:0008056', 'UPHENO:0005230', 'HP:0009122', 'UPHENO:0041041', 'UPHENO:0003824', 'UPHENO:0086172', 'UBERON:0000179', 'UBERON:0004756', 'HP:0002086', 'UBERON:0003947', 'UPHENO:0000508', 'UPHENO:0014761', 'UBERON:0011156', 'HP:0003241', 'UPHENO:0014291', 'UBERON:0002104', 'UPHENO:0088116', 'UPHENO:0011538', 'UPHENO:0008825', 'UPHENO:0004064', 'UBERON:0013701', 'UPHENO:0002704', 'UPHENO:0004418', 'UPHENO:0063599', 'UPHENO:0003163', 'UPHENO:0011749', 'UBERON:0006717', 'UPHENO:0004505', 'HP:0000234', 'UPHENO:0056230', 'UBERON:0005282', 'UBERON:0003061', 'UPHENO:0063794', 'UPHENO:0056333', 'UPHENO:0056251', 'UBERON:0003080', 'UPHENO:0002964', 'UPHENO:0000555', 'UBERON:0005629', 'UBERON:0036302', 'GO:0010468', 'GO:0007272', 'UPHENO:0003177', 'UPHENO:0011548', 'UPHENO:0006146', 'UBERON:0011137', 'UPHENO:0002546', 'UBERON:0001890', 'UBERON:0003072', 'UPHENO:0074230', 'UBERON:0001245', 'UPHENO:0003952', 'HP:0004378', 'UPHENO:0086644', 'UPHENO:0041212', 'HP:0008678', 'UPHENO:0069391', 'UPHENO:0063596', 'UPHENO:0001304', 'UPHENO:0001584', 'HP:0000929', 'UPHENO:0046426', 'UPHENO:0002812', 'HP:0034915', 'HP:0002023', 'UPHENO:0083951', 'UPHENO:0025587', 'UPHENO:0000553', 'UBERON:0003056', 'UBERON:0003059', 'UPHENO:0000558', 'UPHENO:0084007', 'HP:0012447', 'UPHENO:0056237', 'HP:0002188', 'UPHENO:0074335', 'NCBITaxon:6072', 'UPHENO:0003085', 'UPHENO:0086480', 'UPHENO:0063750', 'UPHENO:0080662', 'GO:0007399', 'GO:0007417', 'GO:0022010', 'HP:0012448', 'UPHENO:0087228', 'UPHENO:0000552', 'HP:0009815', 'UPHENO:0083952', 'UPHENO:0002550', 'HP:0000356', 'UPHENO:0050379', 'UPHENO:0025811', 'GO:0007275', 'HP:0002818', 'HP:0002813', 'GO:0042552', 'UPHENO:0026507', 'BFO:0000141', 'UPHENO:0027017', 'GO:0021782', 'UBERON:0034925', 'HP:0008050', 'UPHENO:0074227', 'HP:0000271', 'HP:0200006', 'UPHENO:0002643', 'UPHENO:0026806', 'GO:0040011', 'HP:0002778', 'UPHENO:0076761', 'HP:0030669', 'UBERON:0015001', 'BFO:0000004', 'UPHENO:0025211', 'UPHENO:0075878', 'UPHENO:0005319', 'UPHENO:0087374', 'UPHENO:0002616', 'HP:0025668', 'UPHENO:0002934', 'UBERON:0006983', 'UBERON:0004247', 'UBERON:0001008', 'UBERON:0015212', 'UPHENO:0004545', 'UBERON:0001637', 'UPHENO:0046571', 'UPHENO:0041203', 'UPHENO:0087510', 'UPHENO:0002694', 'UPHENO:0003038', 'UPHENO:0003234', 'UBERON:0001270', 'UBERON:0007285', 'UPHENO:0087950', 'UPHENO:0002595', 'UBERON:0001130', 'HP:0031816', 'UBERON:0002342', 'UBERON:0003077', 'UPHENO:0002901', 'UBERON:0003914', 'UPHENO:0003092', 'UPHENO:0069236', 'UPHENO:0046445', 'UPHENO:0069062', 'UBERON:0008962', 'HP:0002814', 'UBERON:0005256', 'UPHENO:0049835', 'BFO:0000040', 'UPHENO:0003189', 'HP:0000470', 'HP:0003319', 'UBERON:0001137', 'UBERON:0012477', 'UBERON:0004086', 'UBERON:0008001', 'UPHENO:0002301', 'UPHENO:0002543', 'UBERON:0003113', 'UPHENO:0003191', 'UBERON:0011585', 'UPHENO:0003074', 'HP:0000464', 'UPHENO:0002693', 'HP:0025766', 'GO:0031052', 'UPHENO:0063777', 'UBERON:0001417', 'UPHENO:0069266', 'UBERON:0002412', 'HP:0012759', 'UBERON:0002413', 'UPHENO:0069327', 'UBERON:0000974', 'UBERON:0004451', 'UBERON:0002539', 'UBERON:0005944', 'UBERON:0002090', 'UPHENO:0046552', 'UBERON:0000307', 'UPHENO:0002761', 'UBERON:0007530', 'CL:0000329', 'UBERON:0004128', 'UPHENO:0005257', 'UPHENO:0081788', 'UBERON:0005434', 'HP:0009121', 'UPHENO:0076766', 'UPHENO:0002547', 'UPHENO:0002682', 'UPHENO:0063789', 'UPHENO:0003182', 'UPHENO:0074232', 'UPHENO:0076697', 'UPHENO:0003799', 'UBERON:0012360', 'UPHENO:0002838', 'UPHENO:0075804', 'UBERON:0001893', 'UPHENO:0004261', 'UBERON:0005867', 'UPHENO:7000299', 'UPHENO:0002526', 'UBERON:0004768', 'UBERON:0003463', 'UPHENO:0087344', 'HP:0000812', 'UBERON:0005281', 'UBERON:0001684', 'UPHENO:0081575', 'UPHENO:0003065', 'UPHENO:0004521', 'UPHENO:0008593', 'HP:0005922', 'UBERON:0010323', 'UPHENO:0002828', 'UPHENO:0075890', 'UBERON:0004742', 'UPHENO:0087404', 'UPHENO:0035105', 'UPHENO:0086505', 'UPHENO:0084457', 'UBERON:0003690', 'HP:0000152', 'UBERON:0034944', 'UBERON:0010316', 'UPHENO:0004262', 'UBERON:0005157', 'UBERON:0000165', 'UPHENO:0002815', 'UPHENO:0002772', 'UBERON:0007842', 'UBERON:0002514', 'UPHENO:0002942', 'UPHENO:0002957', 'UBERON:0015007', 'UPHENO:0086482', 'HP:0030791', 'UBERON:8450003', 'UPHENO:0002928', 'UPHENO:0003446', 'UPHENO:0086595', 'UPHENO:0002875', 'UBERON:0007914', 'UPHENO:0002816', 'UBERON:0008907', 'HP:0000050', 'UPHENO:3000000', 'UBERON:0011595', 'UPHENO:0087563', 'UPHENO:0086518', 'UPHENO:0081566', 'UBERON:0003278', 'UPHENO:0087661', 'UBERON:0005062', 'UBERON:0001708', 'UPHENO:0002564', 'UBERON:0001710', 'UPHENO:0018414', 'UBERON:0004175', 'UPHENO:0076800', 'UPHENO:0074330', 'UBERON:0003457', 'HP:0000277', 'UBERON:0004537', 'UPHENO:0009021', 'UPHENO:0002988', 'UBERON:0010364', 'HP:0009116', 'UPHENO:0003029', 'UPHENO:0002926', 'UBERON:0005173', 'UPHENO:0003021', 'UPHENO:0081328', 'UPHENO:0009129', 'UPHENO:0076695', 'UPHENO:0080196', 'UBERON:0005179', 'UBERON:0011159', 'HP:0008517', 'UBERON:0002416', 'UBERON:0002417', 'UPHENO:0063865', 'UPHENO:0027014', 'HP:0005528', 'UPHENO:0002651', 'UPHENO:0035145', 'UBERON:0000166', 'UBERON:0004122', 'UPHENO:0004486', 'UPHENO:0026600', 'UPHENO:0001303', 'UPHENO:0026529', 'UPHENO:0008816', 'HP:0000077', 'UPHENO:0003094', 'UPHENO:0011533', 'UBERON:0002113', 'UPHENO:0025631', 'UPHENO:0002642', 'UPHENO:0063845', 'HP:0000465', 'UPHENO:0005596', 'UBERON:0001017', 'UPHENO:0035148', 'UPHENO:0009011', 'UBERON:5002389', 'UPHENO:0003093', 'UPHENO:0008827', 'UPHENO:0025883', 'UPHENO:0049966', 'UPHENO:0082875', 'UBERON:0002329', 'UPHENO:0063760', 'HP:0010935', 'UPHENO:0035013', 'HP:0031703', 'UPHENO:0035073', 'UPHENO:0011817', 'UPHENO:0025776', 'UBERON:0005172', 'UPHENO:0035029', 'UPHENO:0063787', 'UPHENO:0026308', 'UPHENO:0011931', 'UPHENO:0035034', 'UBERON:0011143', 'UPHENO:0003236', 'UPHENO:0035151', 'UPHENO:0087427', 'UPHENO:0080209', 'UPHENO:0069064', 'UPHENO:0004467', 'UPHENO:0085410', 'HP:0100887', 'UBERON:0000161', 'HP:0000089', 'UPHENO:0002360', 'UPHENO:0002715', 'UBERON:0003071', 'UPHENO:0087852', 'UPHENO:0003298', 'UPHENO:0002722', 'UPHENO:0026344', 'UPHENO:0004372', 'UPHENO:0076675', 'UPHENO:0004434', 'UBERON:0012128', 'UPHENO:0026078', 'HP:0005105', 'UBERON:0002100', 'UPHENO:0003228', 'UBERON:0000076', 'UPHENO:0009391', 'UPHENO:0087430', 'UPHENO:0004482', 'HP:0000366', 'HP:0000436', 'UPHENO:0041080'], 'has_phenotype_closure_label': ['absent endochondral bone in the limb', 'aplasia or hypoplasia of radius bone', 'absent bone of free limb or fin in the limb', 'absent anatomical structure in the skeletal system', 'absent radius bone', 'absent forelimb zeugopod bone', 'forelimb endochondral element', 'limb long bone', 'bone of pectoral complex', 'aplastic forelimb zeugopod bone', 'forelimb zeugopod bone', 'arm bone phenotype', 'absent material anatomical entity in the skeletal system', 'forelimb zeugopod', 'forelimb bone', 'absent limb long bone in the forelimb', 'absent forelimb zeugopod bone in the forelimb', 'absent radius endochondral element', 'forelimb skeleton phenotype', 'Aplasia/Hypoplasia of the radius', 'absent limb endochondral element', 'absent forelimb endochondral element in the forelimb', 'long bone', 'long bone phenotype', 'Aplasia/hypoplasia involving forearm bones', 'absent endochondral bone in the forelimb', 'absent forelimb endochondral element', 'forelimb endochondral element phenotype', 'absent bone of free limb or fin in the forelimb', 'zeugopod', 'forelimb zeugopod skeleton', 'absent long bone in the forelimb', 'absent limb bone', 'absent forelimb long bone', 'absent forelimb long bone in the forelimb', 'absent multicellular anatomical structure in the skeletal system', 'forelimb zeugopod morphology phenotype', 'absent organ in the tissue', 'radius bone morphology phenotype', 'number of anatomical enitites of type endochondral bone phenotype', 'absent bone of pectoral complex in the limb', 'absent limb long bone', 'absent bone of pectoral complex', 'number of anatomical enitites of type endochondral element phenotype', 'absent arm bone', 'absent bone of pectoral complex in the forelimb', 'absent material anatomical entity in the tissue', 'absent anatomical structure in the tissue', 'absent endochondral element', 'absent endochondral element in the forelimb', 'forelimb zeugopod bone phenotype', 'absent forelimb bone', 'zeugopod phenotype', 'Abnormal forearm morphology', 'absent bone element', 'Abnormal upper limb bone morphology', 'absent bone of appendage girdle complex', 'Absent radius', 'absent bone element in the forelimb', 'clavate autopod region', 'hindlimb bud phenotype', 'hindlimb', 'pes', 'hindlimb phenotype', 'pelvic appendage bud phenotype', 'Abnormality of the lower limb', 'pelvic appendage phenotype', 'absent bone of free limb or fin', 'clavate anatomical entity', 'posterior region of body', 'hindlimb morphology phenotype', 'Abnormal location of ears', 'Low-set ears', 'Decreased anatomical entity position', 'Decreased external ear position', '3-D shape anatomical entity', 'decreased behavior', 'Abnormal affect', 'absent skeletal element in the forelimb', 'absent limb endochondral element in the forelimb', 'Disinhibition', 'increased kinesthetic behavior', 'cognition', 'social behavior', 'kinesthetic behavior', 'cognitive behavior', 'Cognitive impairment', 'increased rate of behavior process', 'social inhibition', 'Abnormality of mental function', 'attention behavior', 'increased behavior', 'Recurrent maladaptive behavior', 'increased multicellular organismal process', 'Hyperactivity', 'Abnormal volitional state', 'Short attention span', 'absent forelimb bone in the limb', 'increased locomotion', 'Attention deficit hyperactivity disorder', 'Webbed neck', 'zone of skin morphology phenotype', 'webbed neck', 'hypermetropia', 'camera-type eye physiology phenotype', 'Abnormal cellular physiology', 'homeostatic process phenotype', 'bone of pectoral complex phenotype', 'metabolic process', 'Chromosomal breakage induced by crosslinking agents', 'negative regulation of gene expression', 'negative regulation of cellular process phenotype', 'negative regulation of cellular process', 'regulation of gene expression phenotype', 'programmed DNA elimination by chromosome breakage', 'regulation of macromolecule metabolic process', 'regulation of biosynthetic process', 'negative regulation of metabolic process', 'gene expression', 'gene expression phenotype', 'macromolecule biosynthetic process phenotype', 'regulation of macromolecule biosynthetic process phenotype', 'regulation of metabolic process phenotype', 'regulation of biosynthetic process phenotype', 'metabolic process phenotype', 'Abnormal cellular phenotype', 'negative regulation of macromolecule metabolic process phenotype', 'Abnormal forearm bone morphology', 'regulation of cellular process phenotype', 'regulation of cellular process', 'negative regulation of biological process', 'biosynthetic process', 'macromolecule metabolic process', 'homeostatic process', 'Macule', 'Hyperpigmentation of the skin', 'decreased qualitatively behavior', 'Irregular hyperpigmentation', 'skin of body', 'integumental system', 'increased biological_process in skin of body', 'increased pigmentation in skin of body', 'Cafe-au-lait spot', 'increased qualitatively biological_process', 'integument phenotype', 'skin of body phenotype', 'Microtia', 'external ear hypoplasia', 'bone marrow cell', 'Abnormality of multiple cell lineages in the bone marrow', 'number of bone marrow cell phenotype', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'negative regulation of biological process phenotype', 'decreased number of anatomical entity in the bone element', 'number of cell phenotype', 'Abnormal bone marrow cell morphology', 'bone marrow', 'decreased number of material anatomical entity in the bone element', 'immune system phenotype', 'decreased number of anatomical entity in the bone marrow', 'Bone marrow hypocellularity', 'nasal bridge morphology phenotype', 'regulation of macromolecule metabolic process phenotype', 'nasal bridge phenotype', 'snout morphology phenotype', 'snout', 'increased size of the anatomical structure', 'leg phenotype', 'pigmentation phenotype', 'increased width of anatomical structure', 'intromittent organ phenotype', 'external genitalia', 'male reproductive organ', 'external male genitalia phenotype', 'male reproductive organ phenotype', 'decreased size of the intromittent organ', 'Hypoplastic male external genitalia', 'decreased size of the mesoderm-derived structure', 'male reproductive organ morphology phenotype', 'Hypoplasia of penis', 'penis hypoplasia', 'male reproductive system phenotype', 'absent skeletal element in the limb', 'penis morphology phenotype', 'Abnormality of the male genitalia', 'Abnormal external genitalia morphology', 'Abnormal penis morphology', 'external male genitalia hypoplasia', 'decreased size of the reproductive organ', 'intromittent organ', 'penis phenotype', 'male reproductive system morphology phenotype', 'Abnormal male external genitalia morphology', 'decreased size of the penis', 'simple eye physiology phenotype', 'secondary palate', 'opening of the anatomical entity', 'oral cavity phenotype', 'midface', 'anatomical space phenotype', 'Craniofacial cleft', 'anatomical cavity', 'biosynthetic process phenotype', 'oral cavity morphology phenotype', 'Abnormal palate morphology', 'incomplete closing of the material anatomical entity', 'decreased size of the reproductive structure', 'roof of mouth', 'oral cavity', 'midface morphology phenotype', 'oral cleft; orofacial cleft', 'secondary palate morphology phenotype', 'midface phenotype', 'roof of mouth morphology phenotype', 'incomplete closing of the anatomical structure', 'Abnormal oral morphology', 'upper jaw region', 'Orofacial cleft', 'Cleft palate', 'absent reproductive structure in the reproductive system', 'absent anatomical entity in the female reproductive system', 'Abnormality of the uterus', 'absent organ part', 'uterus', 'internal genitalia', 'forelimb long bone phenotype', 'female reproductive organ', 'reproductive system phenotype', 'negative regulation of gene expression phenotype', 'penis', 'absent anatomical structure in the reproductive system', 'subdivision of oviduct phenotype', 'Abnormal reproductive system morphology', 'female reproductive system phenotype', 'Aplasia/hypoplasia of the uterus', 'Abnormal morphology of the radius', 'reproductive organ phenotype', 'absent subdivision of tube in the female reproductive system', 'absent subdivision of tube', 'absent reproductive structure', 'oviduct phenotype', 'reproductive system', 'female organism phenotype', 'absent reproductive structure in the female reproductive system', 'subdivision of oviduct', 'absent anatomical entity in the tissue', 'reproductive organ', 'reproductive structure phenotype', 'number of anatomical enitites of type subdivision of tube phenotype', 'absent subdivision of oviduct in the female reproductive system', 'uterus phenotype', 'internal female genitalia morphology phenotype', 'Abnormality of skin pigmentation', 'absent uterus', 'female reproductive organ morphology phenotype', 'internal genitalia phenotype', 'reproductive structure', 'Abnormal morphology of female internal genitalia', 'absent multicellular anatomical structure in the female reproductive system', 'reproductive system morphology phenotype', 'absent material anatomical entity in the reproductive system', 'biological regulation phenotype', 'decreased qualitatively multicellular organism development', 'ectoderm-derived structure physiology phenotype', 'decreased qualitatively anatomical structure development', 'decreased qualitatively embryo development', 'Micropenis', 'decreased developmental process', 'decreased biological_process', 'decreased multicellular organism development', 'decreased qualitatively developmental process', 'decreased multicellular organismal process', 'decreased anatomical structure development', 'developmental process rate phenotype', 'embryo development rate phenotype', 'decreased qualitatively multicellular organismal process', 'ectodermal placode phenotype', 'increased biological_process', 'flattened anatomical entity', 'neurogenic placode', 'external soft tissue zone', 'negative regulation of macromolecule biosynthetic process', 'external soft tissue zone phenotype', 'absent anatomical entity in the limb bud', 'absent multicellular anatomical structure in the forelimb', 'lateral plate mesoderm phenotype', 'endo-epithelium', 'absent anatomical structure in the limb', 'organ part phenotype', 'circulatory system phenotype', 'autopodial extension', 'ecto-epithelium phenotype', 'face morphology phenotype', 'increased number of brain ventricle', 'polydipsia', 'autopod region phenotype', 'paired limb/fin phenotype', 'pes morphology phenotype', 'forelimb morphology phenotype', 'absent organ in the forelimb', 'autopodial extension phenotype', 'Talipes equinovarus', 'neural groove phenotype', 'Aplasia/hypoplasia involving bones of the upper limbs', 'limb bone phenotype', 'Neurodevelopmental abnormality', 'system', 'neurectoderm', 'bone element phenotype', 'digit phenotype', 'mandible phenotype', 'Abnormal mandible morphology', 'anatomical entity morphology in the manus phenotype', 'surface structure phenotype', 'mesoderm-derived structure', 'vertebra', 'absent anatomical entity in the limb', 'decreased size of the anatomical structure', 'lateral plate mesoderm', 'absent autopodial extension', 'increased size of the anatomical entity', 'absent material anatomical entity in the forelimb', 'limb endochondral element phenotype', 'pelvic region of trunk', 'mouth morphology phenotype', 'absent trunk region element', 'pes phenotype', 'olfactory organ', 'multi-limb segment region phenotype', 'biological_process', 'cell development', 'growth phenotype', 'aplastic anatomical entity', 'anatomical structure atresia', 'Abnormality of head or neck', 'vertebral element', 'closing of the multicellular anatomical structure', 'Renal agenesis', 'myelination phenotype', 'organ part atresia', 'body proper', 'Abnormality of the kidney', 'decreased number of compound organ', 'negative regulation of macromolecule metabolic process', 'musculature of body phenotype', 'ectoderm', 'vertebra phenotype', 'Abnormality of the integument', 'anatomical structure development', 'organ system subdivision phenotype', 'skeleton of limb', 'socially cooperative development', 'macromolecule biosynthetic process', 'skeletal element', 'biological process involved in intraspecies interaction between organisms phenotype', 'decreased length of neck', 'delayed anatomical structure development', 'Neurodevelopmental delay', 'developmental process phenotype', 'digit', 'central nervous system myelination', 'number of anatomical enitites of type organ phenotype', 'Abnormal pinna morphology', 'aplasia or hypoplasia of ear', 'absent subdivision of head in the head', 'bone of appendage girdle complex phenotype', 'Abnormality of the ear', 'absent lateral structure', 'vestibulo-auditory system phenotype', 'renal system', 'anatomical entity atresia', 'absent lateral structure in the head', 'subdivision of tube atresia', 'external nose', 'arm', 'limb long bone morphology phenotype', 'myeloid cell', 'nasal bridge', 'absent anatomical structure in the ear', 'shape of nose tip phenotype', 'shape of anatomical entity phenotype', 'vestibulo-auditory system', 'absent subdivision of head', 'absent material anatomical entity in the limb', 'process', 'number of anatomical enitites of type organ component layer phenotype', 'decreased number of bone marrow cell', 'Abnormality of blood and blood-forming tissues', 'posterior neural tube', 'Renal hypoplasia', 'hematopoietic cell', 'manual digit', 'skull morphology phenotype', 'Absent forearm bone', 'consumption behavior phenotype', 'genitourinary system', 'manus morphology phenotype', 'absent long bone', 'Abnormality of the genital system', 'Abnormality of the musculoskeletal system', 'hematopoietic system phenotype', 'closing of the anatomical system', 'pectoral appendage bud phenotype', 'erythrocyte', 'pelvic complex', 'esophagus atresia', 'fused sacrum hypoplasia', 'subdivision of vertebral column phenotype', 'facial skeleton phenotype', 'aplasia or hypoplasia of skull', 'absent multicellular anatomical structure in the multicellular organism', 'immune system', 'ocular adnexa', 'appendicular skeleton morphology phenotype', 'cell phenotype', 'multicellular organismal process phenotype', 'Abnormality of the eye', 'gastrula', 'radius endochondral element', 'pigmentation', 'vein morphology phenotype', 'Aplasia/Hypoplasia involving bones of the skull', 'delayed biological_process', 'feeding behavior', 'immaterial entity', 'central nervous system phenotype', 'pectoral appendage bud', 'Feeding difficulties', 'Hypertelorism', 'jaw skeleton morphology phenotype', 'optic vesicle phenotype', 'limb bud phenotype', 'eyeball of camera-type eye phenotype', 'closing of the anatomical entity', 'autopodial skeleton', 'pectoral appendage skeleton', 'skeleton of lower jaw', 'delayed cellular process', 'pre-chordal neural plate', 'Esophageal atresia', 'subdivision of tube', 'non-material anatomical boundary', 'presumptive structure phenotype', 'skeletal element phenotype', 'immaterial anatomical entity phenotype', 'entity', 'anus phenotype', 'entire sense organ system', 'lateral plate mesoderm morphology phenotype', 'erythroid lineage cell morphology phenotype', 'Abnormal eye morphology', 'absent organism subdivision', 'lateral structure', 'cerebellum morphology phenotype', 'aplasia or hypoplasia of eyeball of camera-type eye', 'multicellular organismal process', 'forelimb bone phenotype', 'anterior region of body', 'subdivision of head phenotype', 'external genitalia phenotype', 'paraxial mesoderm phenotype', 'Abnormality of the orbital region', 'digestive tract epithelium', 'simple eye phenotype', 'multicellular organism phenotype', 'skin of body morphology phenotype', 'zone of organ phenotype', 'location of anatomical entity phenotype', 'oxygen accumulating cell', 'craniocervical region phenotype', 'compound organ phenotype', 'number of anatomical enitites of type lateral structure phenotype', 'craniocervical region', 'subdivision of head', 'All', 'Aplasia of the uterus', 'trunk region element atresia', 'absent multicellular anatomical structure in the renal system', 'increased length of the anatomical line', 'Unilateral renal agenesis', 'anatomical structure development phenotype', 'increased size of the non-material anatomical boundary', 'forelimb bud morphology phenotype', 'number of anatomical enitites of type anatomical entity phenotype', 'absent anatomical structure', 'limb bone', 'eye phenotype', 'absent material anatomical entity in the ear', 'eye morphology', 'hematopoietic system morphology phenotype', 'forelimb zeugopod phenotype', 'esophagus phenotype', 'negative regulation of metabolic process phenotype', 'limb segment', 'paired limb/fin', 'visual system', 'brain morphology phenotype', 'face phenotype', 'vasculature morphology in the alimentary part of gastrointestinal system phenotype', 'glial cell development', 'socially cooperative development phenotype', 'trunk region element', 'trunk', 'internal female genitalia phenotype', 'bone of lower jaw phenotype', 'absent material anatomical entity in the multicellular organism', 'biological_process in central nervous system phenotype', 'male reproductive system', 'thoracic segment of trunk', 'digestive system morphology phenotype', 'system process', 'orifice phenotype', 'Abnormality of the digestive system', 'Abnormality of the female genitalia', 'absent material anatomical entity', 'tissue', 'Abnormal tracheobronchial morphology', 'paraxial mesoderm morphology phenotype', 'mesenchyme morphology phenotype', 'shape of continuant phenotype', 'increased size of the material anatomical entity', 'parathyroid gland phenotype', 'development of anatomical entity phenotype', 'sense organ phenotype', 'eye', 'anatomical line', 'head bone phenotype', 'increased length of the anatomical entity', 'subdivision of organism along main body axis', 'germ layer morphology phenotype', 'cavitated compound organ phenotype', 'Abnormal internal genitalia', 'cerebellum hypoplasia', 'subdivision of digestive tract atresia', 'Abnormality of the urinary system', 'cranial placode phenotype', 'digestive system element phenotype', 'irregular bone', 'Abnormality of globe location', 'absent anatomical structure in the female reproductive system', 'Gastrointestinal atresia', 'cerebellum phenotype', 'cellular organisms', 'cervical region', 'programmed DNA elimination', 'sorocarp development phenotype', 'subdivision of trunk', 'forelimb zeugopod bone morphology phenotype', 'cell', 'viscus phenotype', 'cerebrospinal fluid', 'anatomical conduit atresia', 'anatomical line between pupils', 'trachea', 'Eukaryota', 'absent multicellular anatomical structure in the reproductive system', 'neurogenesis', 'viscus', 'sacral region of vertebral column phenotype', 'location of external ear phenotype', 'external ear morphology phenotype', 'Hypermelanotic macule', 'hindbrain phenotype', 'decreased length of material anatomical entity', 'neural plate morphology phenotype', 'vasculature of organ phenotype', 'Opisthokonta', 'Abnormal nasal tip morphology', 'foregut phenotype', 'paired limb/fin bud phenotype', 'cardiovascular system', 'Abnormal brain morphology', 'hematopoietic system', 'Abnormal erythrocyte morphology', 'pharyngeal arch 1 phenotype', 'Phenotypic abnormality', 'Aplasia/Hypoplasia involving the central nervous system', 'anatomical cavity phenotype', 'vessel', 'Abnormality of metabolism/homeostasis', 'upper digestive tract', 'absent multicellular anatomical structure in the head', 'absent manual digit', 'limb bone morphology phenotype', 'incomplete closing of the multi-tissue structure', 'anatomical structure', 'feeding behavior phenotype', 'non-connected functional system', 'appendage', 'pharyngeal arch phenotype', 'ear', 'increased size of the immaterial anatomical entity', 'neurectoderm phenotype', 'subdivision of skeleton', 'anatomical entity phenotype', 'thoracic cavity element', 'absent anatomical entity in the skeletal system', 'consumption behavior', 'mandible morphology phenotype', 'anatomical system atresia', 'thoracic cavity element atresia', 'Abnormal ear morphology', 'endoderm of foregut', 'presumptive structure', 'pelvic appendage', 'genitourinary system phenotype', 'embryo', 'future central nervous system', 'paired limb/fin skeleton phenotype', 'Abnormal gastrointestinal tract morphology', 'Abnormality of the skeletal system', 'optic cup morphology phenotype', 'biological_process phenotype', 'sensory system', 'embryo development', 'axial skeleton plus cranial skeleton morphology phenotype', 'head morphology phenotype', 'pectoral appendage skeleton phenotype', 'ectoderm-derived structure', 'Growth abnormality', 'Abnormality of the respiratory system', 'phenotypic effect', 'arterial blood vessel', 'sense organ', 'epithelium', 'biological regulation', 'trunk phenotype', 'organ subunit', 'leg', 'metencephalon phenotype', 'Global developmental delay', 'embryonic structure', 'anatomical entity', 'alimentary part of gastrointestinal system phenotype', 'abdominal segment bone phenotype', 'Abnormality of the face', 'esophagus morphology phenotype', 'female reproductive organ phenotype', 'closing of the ectoderm-derived structure', 'endocrine gland phenotype', 'embryonic structure phenotype', 'blood', 'Aplasia/Hypoplasia of the cerebellum', 'cervical vertebra', 'absent organ', 'epithelial tube', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'paired limb/fin bud', 'trachea phenotype', 'concave 3-D shape anatomical entity', 'decreased length of multicellular anatomical structure', 'neural plate', 'immature eye', 'independent continuant', 'radius bone phenotype', 'endocrine gland', 'anatomical system phenotype', 'skeleton of manus', 'lower jaw region', 'closing of the thoracic segment organ', 'respiratory system morphology phenotype', 'skeleton', 'behavior process', 'Aplasia/Hypoplasia affecting the eye', 'endoderm', 'size of anatomical entity phenotype', 'organ part', 'negative regulation of biosynthetic process', 'respiratory tube morphology phenotype', 'bone of pectoral complex morphology phenotype', 'neck bone phenotype', 'dysesthesia; hyperalgesia', 'renal/urinary system phenotype', 'foregut epithelium phenotype', 'aplasia or hypoplasia of vertebral column', 'absent subdivision of oviduct', 'root', 'trunk mesenchyme phenotype', 'absent forelimb endochondral element in the limb', 'neural tube phenotype', 'Abnormal nervous system morphology', 'decreased number of material anatomical entity in the trunk', 'renal system phenotype', 'tube', 'digitopodium region', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'phenotype', 'aplasia or hypoplasia of external ear', 'anatomical structure phenotype', 'agenesis of anatomical entity', 'bone cell', 'ecto-epithelium', 'face', 'delayed developmental process', 'behavior process phenotype', 'increased number of material anatomical entity', 'Morphological central nervous system abnormality', 'multi-tissue structure phenotype', 'nervous system', 'subdivision of digestive tract phenotype', 'dorsum', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'closing of the anatomical conduit', 'germ layer / neural crest phenotype', 'cervical vertebra endochondral element phenotype', 'craniofacial/craniocervical phenotype', 'absent anatomical structure in the renal system', 'brain phenotype', 'endocrine gland physiology phenotype', 'Abnormal axial skeleton morphology', 'sclerotome phenotype', 'external nose morphology phenotype', 'Abnormality of the outer ear', 'anatomical entity physiology phenotype', 'Abnormality of chromosome stability', 'decreased length of anatomical structure', 'epithelial tube phenotype', 'head phenotype', 'olfactory placode phenotype', 'absent anatomical structure in the head', 'Cerebellar hypoplasia', 'musculoskeletal system', 'non-material anatomical boundary phenotype', 'incomplete closing of the roof of mouth', 'multicellular organism development phenotype', 'brain', 'increased number of anatomical entity in the blood', 'tissue phenotype', 'nose tip', 'posterior neural tube phenotype', 'immaterial anatomical entity', 'decreased size of the male reproductive organ', 'neural plate phenotype', 'Abnormality of the ocular adnexa', 'axial skeleton plus cranial skeleton phenotype', 'digit plus metapodial segment', 'mandibular prominence', 'subdivision of digestive tract', 'Abnormal cerebellum morphology', 'neural tube morphology phenotype', 'eyelid', 'embryo phenotype', 'decreased number of multicellular anatomical structure in the multicellular organism', 'biological process involved in intraspecies interaction between organisms', 'structure with developmental contribution from neural crest physiology phenotype', 'cellular process phenotype', 'absent anatomical entity in the head', 'simple eye', 'anatomical system', 'limb long bone phenotype', 'increased width of nasal bridge', 'chordal neural plate phenotype', 'forelimb long bone', 'Abnormality of the palpebral fissures', 'anatomical entity hypoplasia', 'material anatomical entity atresia', 'pharyngeal arch system', 'material anatomical entity', 'increased pigmentation', 'presumptive ectoderm phenotype', 'multi organ part structure phenotype', 'digestive tract epithelium phenotype', 'circulatory system', 'nervous system phenotype', 'hindbrain morphology phenotype', 'mandible hypoplasia', 'decreased number of anatomical entity in the trunk', 'eye physiology phenotype', 'tracheobronchial tree morphology phenotype', 'regional part of nervous system phenotype', 'blood vessel morphology phenotype', 'appendicular skeletal system', 'cardiovascular system morphology phenotype', 'Positional foot deformity', 'segmental subdivision of nervous system phenotype', 'Abnormal limb bone morphology', 'increased number of brain ventricle in the cerebrospinal fluid', 'aplastic manual digit 1', 'normal growth on benomyl', 'number of anatomical enitites of type organism subdivision phenotype', 'decreased qualitatively biological_process', 'musculature of body', 'blastula', 'Abnormality of the gastrointestinal tract', 'skeletal system phenotype', 'parathyroid gland physiology phenotype', 'embryonic tissue phenotype', 'regulation of biological process', 'number of anatomical enitites of type abdominal segment element phenotype', 'organ subunit phenotype', 'ectoderm-derived structure phenotype', 'absent anatomical structure in the multicellular organism', 'anatomical cluster phenotype', 'closing of the trunk region element', 'aplasia or hypoplasia of cerebellum', 'foregut epithelium', 'Abnormality of limbs', 'absent organ part in the female reproductive system', 'anatomical conduit phenotype', 'embryonic facial prominence', 'head bone', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'haemolymphatic fluid phenotype', 'manus phenotype', 'Aplasia/Hypoplasia of the ear', 'blood vessel phenotype', 'anatomical cluster', 'epithelium phenotype', 'absent organ in the limb', 'sacral region of vertebral column', 'integumental system phenotype', 'tube phenotype', 'organ phenotype', 'Abnormality of the skin', 'growth', 'subdivision of organism along appendicular axis phenotype', 'migrating mesenchyme population', 'central nervous system', 'anemia', 'absent endochondral element in the limb', 'absent bone of appendage girdle complex in the forelimb', 'segmental subdivision of hindbrain phenotype', 'delayed axon ensheathment', 'delayed sorocarp development', 'abdominal segment element', 'Atypical behavior', 'regional part of nervous system', 'Reduced attention regulation', 'nervous system physiology phenotype', 'forebrain phenotype', 'organ physiology phenotype', 'multi-tissue structure', 'segmental subdivision of hindbrain', 'thoracic segment organ', 'anatomical conduit', 'organism subdivision', 'multicellular organism', 'nervous system morphology phenotype', 'organ system subdivision', 'visual system phenotype', 'decreased number of material anatomical entity', 'tracheobronchial tree', 'oviduct', 'orifice atresia', 'membrane bone', 'embryonic tissue', 'material anatomical entity phenotype', 'future nervous system', 'increased length of the non-material anatomical boundary', 'ventricle of nervous system phenotype', 'segmental subdivision of nervous system', 'Eumetazoa', 'sclerotome morphology phenotype', 'metencephalon morphology phenotype', 'gastrointestinal arteriovenous malformation', 'respiratory system phenotype', 'aplasia or hypoplasia of uterus', 'Aplasia/Hypoplasia of the mandible', 'venous blood vessel', 'anatomical entity morphology in the alimentary part of gastrointestinal system phenotype', 'nose morphology phenotype', 'occurrent', 'lower limb segment', 'Abnormality of limb bone', 'limb morphology phenotype', 'continuant', 'chordal neural plate', 'artery phenotype', 'appendage phenotype', 'Bilateral talipes equinovarus', 'Abnormal anus morphology', 'subdivision of organism along main body axis phenotype', 'bone marrow phenotype', 'dermal bone phenotype', 'Abnormal sacrum morphology', 'anatomical entity length phenotype', 'blood vasculature', 'sensory system phenotype', 'endocrine system', 'hemolymphoid system', 'primordium phenotype', 'Abnormal nervous system physiology', 'cardiovascular system phenotype', 'Abnormal nasal bridge morphology', 'foregut', 'decreased number of kidney', 'shape of autopod region phenotype', 'paired limb/fin segment', 'anatomical structure physiology phenotype', 'digestive system element atresia', 'endocrine system phenotype', 'Abnormal cerebral ventricle morphology', 'endoderm-derived structure phenotype', 'Hydrocephalus', 'artery morphology phenotype', 'integument', 'gland', 'absent arm bone in the forelimb', 'hindlimb bud', 'palpebral fissure', 'primordium', 'compound organ', 'hindlimb bud morphology phenotype', 'ventricular system of brain', 'Tracheoesophageal fistula', 'Abnormal respiratory system morphology', 'Growth delay', 'resistance to salt stress', 'absent trunk region element in the renal system', 'trachea morphology phenotype', 'acropodium region', 'subdivision of trunk phenotype', 'decreased activity of parathyroid; hypoparathyroidism', 'aplasia or hypoplasia of manual digit 1', 'cerebellum', 'eye primordium phenotype', 'alimentary part of gastrointestinal system atresia', 'behavior', 'endoderm phenotype', 'Talipes', 'biological_process in nervous system phenotype', 'subdivision of skeletal system', 'alimentary part of gastrointestinal system morphology phenotype', 'anterior neural tube', 'skull phenotype', 'vascular system', 'external genitalia morphology; external genitalia phenotype', 'cervical region of vertebral column', 'Aplasia/Hypoplasia involving the vertebral column', 'sorocarp development', 'vein phenotype', 'increased width of material anatomical entity', 'proximo-distal subdivision of respiratory tract phenotype', 'material anatomical entity physiology phenotype', 'abdominal segment bone', 'multicellular anatomical structure physiology phenotype', 'aplasia or hypoplasia of fused sacrum', 'increased length of the anatomical line between pupils', 'venous system', 'unilaminar epithelium phenotype', 'bone of dorsum phenotype', 'erythrocyte morphology phenotype', 'vascular system morphology phenotype', 'Abnormality of the nervous system', 'closing of the subdivision of digestive tract', 'glandular system', 'Anemia', 'telencephalon', 'neural crest morphology phenotype', 'primary subdivision of skull phenotype', 'decreased number of lateral structure', 'blood vessel', 'orbital region', 'limb skeleton subdivision', 'respiratory system', 'endochondral bone', 'bodily fluid phenotype', 'primary subdivision of cranial skeletal system phenotype', 'main body axis', 'eukaryotic cell', 'germ layer', 'radius bone', 'digit 1 or 5', 'respiratory tube phenotype', 'manual digit 1 plus metapodial segment', 'arm bone', 'upper limb segment', 'optic vesicle', 'presumptive ectoderm', 'lower respiratory tract', 'endoderm-derived structure', 'vasculature', 'Wide nasal bridge', 'male organism phenotype', 'endoderm of foregut phenotype', 'internal female genitalia', 'cerebrospinal fluid morphology phenotype', 'unilaminar epithelium', 'ear morphology phenotype', 'venous blood vessel phenotype', 'esophagus', 'bone of appendage girdle complex', 'number of anatomical enitites of type skeletal element phenotype', 'mesoderm-derived structure phenotype', 'trunk region element phenotype', 'ectoderm phenotype', 'respiratory tube', 'number of anatomical enitites of type reproductive structure phenotype', 'multicellular anatomical structure phenotype', 'increased number of organ part', 'absent organism subdivision in the multicellular organism', 'delayed growth', 'pre-chordal neural plate phenotype', 'number of anatomical enitites of type trunk region element phenotype', 'digestive tract', 'incomplete closing of the secondary palate', 'mesenchyme', 'disconnected anatomical group', 'Aplasia/Hypoplasia of the external ear', 'Aplasia/Hypoplasia of the thumb', 'regional part of brain', 'endoderm morphology phenotype', 'pelvic appendage bud', 'decreased number of abdominal segment element', 'multicellular anatomical structure atresia', 'cell condensation', 'skin of neck', 'pelvic region element', 'tracheoesophageal fistula', 'bodily fluid', 'Abnormal hindbrain morphology', 'bone of craniocervical region phenotype', 'digestive system physiology phenotype', 'eyeball of camera-type eye', 'long bone morphology phenotype', 'Abnormal thumb morphology', 'subdivision of tube phenotype', 'bone element hypoplasia in face', 'closing of the anatomical structure', 'absent multicellular anatomical structure in the ear', 'Abnormal esophagus morphology', 'anatomical point phenotype', 'number of anatomical enitites of type material anatomical entity phenotype', 'male organism', 'vein', 'artery', 'craniocervical region morphology phenotype', 'brain ventricle phenotype', 'musculature', 'mesoderm morphology phenotype', 'decreased size of the multicellular anatomical structure', 'Chromosome breakage', 'endo-epithelium phenotype', 'central nervous system myelination phenotype', 'structure with developmental contribution from neural crest phenotype', 'Abnormally increased volition', 'regional part of brain phenotype', 'vasculature phenotype', 'female reproductive system', 'respiratory system morphology', 'organism substance phenotype', 'arterial blood vessel phenotype', 'Abnormal digestive system morphology', 'immature eye phenotype', 'decreased number of trunk region element', 'central nervous system morphology phenotype', 'absent material anatomical entity in the head', 'structure with developmental contribution from neural crest', 'anatomical entity morphology phenotype', 'anatomical system physiology phenotype', 'parathyroid gland', 'digestive system', 'orbital region phenotype', 'Abnormality of the upper limb', 'Abnormal tracheal morphology', 'gland physiology phenotype', 'decreased number of anatomical structure in the bone element', 'shape of external ear phenotype', 'number of anatomical enitites of type abdomen element phenotype', 'regulation of metabolic process', 'subdivision of organism along appendicular axis', 'bone element', 'material entity', 'respiratory airway', 'absent material anatomical entity in the limb bud', 'locomotion phenotype', 'Short neck', 'epithelial fold', 'cervical vertebra phenotype', 'Abnormal finger morphology', 'pectoral appendage phenotype', 'decreased size of the material anatomical entity', 'female reproductive system morphology phenotype', 'anatomical collection phenotype', 'aplasia or hypoplasia of manual digit', 'paired limb/fin segment phenotype', 'haemolymphatic fluid', 'drinking behavior phenotype', 'paired limb/fin skeleton', 'vision/eye phenotype', 'sclerotome', 'decreased number of cavitated compound organ', 'developmental process', 'multi-limb segment region', 'anatomical space', 'decreased number of anatomical entity in the multicellular organism', 'regulation of biological process phenotype', 'endochondral element', 'segment of autopod', 'Abnormal hand morphology', 'digit morphology phenotype', 'neural fold', 'anatomical entity morphology in the pectoral complex phenotype', 'limb bud', 'manus', 'embryonic autopod plate morphology phenotype', 'dentary phenotype', 'erythroid lineage cell', 'limb bud morphology phenotype', 'Absent thumb', 'manual digit 1 morphology phenotype', 'respiratory system physiology phenotype', 'non-neural ectoderm', 'Abnormal nasal morphology', 'blood cell phenotype', 'subdivision of skeleton phenotype', 'sense organ physiology phenotype', 'surface structure', 'skeletal system', 'dermal bone', 'mouth phenotype', 'limb endochondral element', 'Abnormal ocular adnexa morphology', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'sacral region', 'aplasia or hypoplasia of skeleton', 'absent multicellular anatomical structure in the limb', 'anatomical collection', 'developing mesenchymal condensation phenotype', 'limb segment phenotype', 'absent anatomical entity in the reproductive system', 'endochondral element phenotype', 'foregut morphology phenotype', 'abdomen element phenotype', 'skeletal system morphology phenotype', 'absent anatomical structure in the forelimb', 'decreased number of anatomical structure in the trunk', 'absent multicellular anatomical structure', 'Abnormality of the nose', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'lower limb segment phenotype', 'macromolecule metabolic process phenotype', 'fused sacrum morphology phenotype', 'Abnormal digit morphology', 'neck phenotype', 'limb', 'pectoral appendage', 'pectoral complex', 'absent digit', 'pharyngeal arch morphology phenotype', 'ocular adnexa phenotype', 'lateral structure physiology phenotype', 'manual digit 1', 'absent multicellular anatomical structure in the tissue', 'blood phenotype', 'segment of manus', 'Abnormality of the mouth', 'autopod region', 'endochondral bone phenotype', 'increased number of multicellular anatomical structure', 'non-neural ectoderm phenotype', 'brain ventricle', 'bony pelvis', 'external male genitalia', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'Abnormality of digestive system physiology', 'arm phenotype', 'limb phenotype', 'somite', 'external nose phenotype', 'decreased rate of behavior process', 'skeleton phenotype', 'appendage girdle complex', 'incomplete closing of the anatomical entity', 'subdivision of skeletal system phenotype', 'neural tube', 'mesoderm', 'neural crest-derived structure phenotype', 'lateral structure phenotype', 'increased size of the anatomical line', 'forelimb bud', 'forelimb', 'decreased number of material anatomical entity in the multicellular organism', 'manual digitopodium region', 'Slanting of the palpebral fissure', 'Abnormal external nose morphology', 'autopod region morphology phenotype', 'dense mesenchyme tissue phenotype', 'Finger aplasia', 'Abnormal appendicular skeleton morphology', 'camera-type eye', 'bone of free limb or fin', 'digit 1', 'musculature phenotype', 'manual digit phenotype', 'Aplasia involving forearm bones', 'arterial system', 'cavitated compound organ', 'manual digit plus metapodial segment', 'digit 1 plus metapodial segment', 'absent anatomical entity in the forelimb', 'forebrain', 'decreased number of anatomical structure in the multicellular organism', 'gland phenotype', 'Aplasia/hypoplasia of the extremities', 'Abnormality of the hand', 'Abnormal skeletal morphology', 'embryonic autopod plate', 'vessel phenotype', 'skeleton of pectoral complex', 'limb skeleton subdivision phenotype', 'appendicular skeleton', 'cranial skeletal system', 'vascular plexus', 'vasculature of central nervous system plus retina', 'increased number of organ part in the cerebrospinal fluid', 'primary subdivision of skull', 'appendicular skeleton phenotype', 'Abnormal myelination', 'female organism', 'increased number of material anatomical entity in the cerebrospinal fluid', 'developing anatomical structure', 'jaw region', 'increased number of anatomical entity', 'zeugopodial skeleton', 'number of anatomical entities of type anatomical entity in blood phenotype', 'respiratory tract', 'brain ventricle morphology phenotype', 'Abdominal symptom', 'decreased size of the organism subdivision', 'brain ventricle/choroid plexus phenotype', 'increased number of brain ventricle/choroid plexus in the cerebrospinal fluid', 'thoracic segment organ phenotype', 'increased number of multicellular anatomical structure in the cerebrospinal fluid', 'Abnormal skull morphology', 'increased number of brain ventricle/choroid plexus', 'vascular plexus phenotype', 'ectoderm morphology phenotype', 'neural crest', 'eye primordium', 'organ component layer phenotype', 'Intrauterine growth retardation', 'neural fold morphology phenotype', 'decreased number of multicellular anatomical structure in the trunk', 'closing of the organ', 'organism substance', 'location of eyeball of camera-type eye phenotype', 'brain ventricle/choroid plexus', 'telencephalon phenotype', 'anus', 'dermal skeletal element phenotype', 'head', 'transudate', 'Anotia', 'Micrognathia', 'cervical vertebra endochondral element', 'absent bone element in the limb', 'number of anatomical enitites of type organ part phenotype', 'organ component layer', 'anatomical wall', 'bone of dorsum', 'brain ventricle/choroid plexus morphology phenotype', 'increased number of anatomical structure in the cerebrospinal fluid', 'cerebrospinal fluid phenotype', 'increased number of ventricle of nervous system in the cerebrospinal fluid', 'behavior phenotype', 'Metazoa', 'anterior neural tube phenotype', 'Abnormal cerebrospinal fluid morphology', 'mesenchyme phenotype', 'increased number of ventricle of nervous system', 'dermatocranium', 'camera-type eye phenotype', 'increased number of anatomical entity in the cerebrospinal fluid', 'anatomical wall phenotype', 'blood island phenotype', 'pharyngeal arch 1', 'decreased number of anatomical entity', 'increased number of anatomical structure', 'vertebral column morphology phenotype', 'blood island', 'ventricle of nervous system', 'Abnormal jaw morphology', 'orifice', 'locomotion', 'Abnormality of the anus', 'germ layer phenotype', 'anus morphology phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'anus atresia', 'Anal atresia', 'epithelial fold phenotype', 'cellular process', 'cell differentiation', 'absent skeletal element', 'system development', 'delayed axon ensheathment in central nervous system', 'upper limb segment phenotype', 'ensheathment of neurons phenotype', 'anatomical line phenotype', 'Abnormal metencephalon morphology', 'nervous system development', 'anatomical entity morphology in the appendage girdle complex phenotype', 'abdominal segment element phenotype', 'number of anatomical enitites of type bone element phenotype', 'central nervous system development', 'delayed ensheathment of neurons', 'developing anatomical structure phenotype', 'abdomen', 'axon ensheathment phenotype', 'oligodendrocyte development', 'closing of the organ part', 'hindbrain', 'oligodendrocyte differentiation', 'number of anatomical enitites of type cavitated compound organ phenotype', 'Delayed CNS myelination', 'decreased size of the sense organ', 'delayed central nervous system myelination', 'external ear phenotype', 'Abnormal CNS myelination', 'absent limb endochondral element in the limb', 'axon ensheathment in central nervous system', 'blood cell', 'postcranial axial skeleton', 'myelination', 'glial cell differentiation', 'decreased social inhibition', 'embryo morphology phenotype', 'germ layer / neural crest', 'axon ensheathment in central nervous system phenotype', 'Aplasia/hypoplasia involving the skeleton', 'thoracic cavity element phenotype', 'multicellular organism development', 'ensheathment of neurons', 'cellular developmental process', 'absent external ear', 'absent cavitated compound organ', 'forelimb skeleton', 'delayed biological_process in central nervous system', 'Abnormality of the head', 'increased qualitatively locomotion', 'Abnormal eyelid morphology', 'facial bone phenotype', 'eyelid phenotype', 'camera-type eye morphology phenotype', 'Upslanted palpebral fissure', 'trunk bone phenotype', 'palpebral fissure phenotype', 'multi organ part structure', 'Abnormality of the vertebral column', 'Aplasia/hypoplasia involving bones of the extremities', 'decreased size of the organ', 'dorsal part of neck', 'neck bone', 'Aplasia/Hypoplasia of fingers', 'somite phenotype', 'taxon specific phenotype', 'digit 1 or 5 phenotype', 'epithelial vesicle phenotype', 'facial bone hypoplasia', 'decreased number of organ', 'decreased length of anatomical entity', 'cell condensation phenotype', 'skull', 'ectoderm-derived structure atresia', 'decreased length of organism subdivision', 'biological_process rate phenotype', 'dorsal region element', 'decreased number of cell', 'Hypoplastic sacrum', 'paraxial mesoderm', 'pelvic region element phenotype', 'increased number of organ component layer in the cerebrospinal fluid', 'vertebral element phenotype', 'absent endochondral bone', 'developing mesenchymal condensation', 'facial bone', 'bone of jaw phenotype', 'entire embryonic mesenchyme', 'abdomen element', 'bone marrow cell phenotype', 'closing of the material anatomical entity', 'migrating mesenchyme population phenotype', 'zone of skin', 'dorsal region element phenotype', 'Delayed myelination', 'presomitic mesoderm', 'ventricular system of central nervous system', 'decreased size of the anatomical entity', 'neck morphology phenotype', 'neck', 'incomplete closing of the multicellular anatomical structure', 'trunk mesenchyme', 'presumptive paraxial mesoderm', 'axial skeletal system', 'Abnormal oral cavity morphology', 'vertebral column', 'postcranial axial skeletal system', 'postcranial axial skeleton phenotype', 'Abnormal neck morphology', 'regulation of macromolecule biosynthetic process', 'Abnormality of the cervical spine', 'mesoderm phenotype', 'number of anatomical enitites of type kidney phenotype', 'Abnormal skin morphology', 'presomitic mesoderm phenotype', 'epithelial vesicle', 'absent material anatomical entity in the female reproductive system', 'presumptive paraxial mesoderm phenotype', 'trunk or cervical vertebra', 'Abnormality of the neck', 'trunk or cervical vertebra phenotype', 'Abnormal facial skeleton morphology', 'irregular bone phenotype', 'musculoskeletal system phenotype', 'embryonic craniocervical region', 'axial skeleton plus cranial skeleton', 'aplasia or hypoplasia of mandible', 'ear phenotype', 'dermal skeleton phenotype', 'absent anatomical entity in the multicellular organism', 'embryonic tissue morphology phenotype', 'membrane bone phenotype', 'intramembranous bone', 'gliogenesis', 'head bone morphology phenotype', 'dense mesenchyme tissue', 'proximo-distal subdivision of respiratory tract', 'intramembranous bone phenotype', 'drinking behavior', 'mouth', 'olfactory organ phenotype', 'dentary', 'skin of neck morphology phenotype', 'bone of jaw', 'thoracic segment organ atresia', 'oral opening', 'neural crest phenotype', 'delayed myelination', 'dermal skeletal element', 'mandibular prominence morphology phenotype', 'absent limb bone in the limb', 'pharyngeal arch', 'facial skeleton morphology phenotype', 'absent abdominal segment element', 'protuberance phenotype', 'eyelid morphology phenotype', 'pharyngeal region of foregut', 'subdivision of vertebral column', 'zone of organ', 'bone of craniocervical region', 'organ atresia', 'facial skeleton', 'bone of lower jaw', 'absent anatomical entity', 'mandible', 'primary subdivision of cranial skeletal system', 'dermatocranium phenotype', 'pharyngeal arch 1 morphology phenotype', 'neural fold phenotype', 'absent forelimb bone in the forelimb', 'neural groove', 'neural crest-derived structure', 'location of ear phenotype', 'jaw skeleton', 'anatomical entity hypoplasia in face', 'skeleton of lower jaw phenotype', 'Aplasia/hypoplasia affecting bones of the axial skeleton', 'absent radius endochondral element in the forelimb', 'absent lateral structure in the renal system', 'decreased number of multicellular anatomical structure', 'increased width of anatomical entity', 'absent organism subdivision in the head', 'alimentary part of gastrointestinal system', 'dermal skeleton', 'digestive system element', 'protuberance', 'External genital hypoplasia', 'Aplasia/Hypoplasia of the sacrum', 'trunk bone', 'closing of the subdivision of tube', 'Aplasia/hypoplasia involving bones of the hand', 'presomitic mesoderm morphology phenotype', 'fused sacrum phenotype', 'vertebral column phenotype', 'external ectoderm', 'axon ensheathment', 'abdominal segment of trunk', 'organism subdivision phenotype', 'decreased number of abdomen element', 'upper urinary tract', 'number of anatomical enitites of type compound organ phenotype', 'anatomical point', 'absent kidney', 'nervous system process', 'decreased number of anatomical structure in the abdomen', 'flat anatomical entity', 'Abnormal renal morphology', 'neurogenic placode phenotype', 'absent anatomical entity in the ear', 'Abnormality of the genitourinary system', 'kidney', 'Renal hypoplasia/aplasia', 'decreased number of anatomical entity in the abdomen', 'absent compound organ in the renal system', 'absent organ in the renal system', 'Abnormality of the upper urinary tract', 'multicellular anatomical structure', 'decreased number of multicellular anatomical structure in the abdomen', 'absent abdomen element', 'manual digit 1 or 5', 'upper urinary tract phenotype', 'aplasia or hypoplasia of anatomical entity', 'vasculature of central nervous system plus retina phenotype', 'nose tip phenotype', 'Abnormal foot morphology', 'fused sacrum', 'excretory system', 'absent bone of appendage girdle complex in the limb', 'decreased embryo development', 'absent trunk region element in the multicellular organism', 'regulation of gene expression', 'absent material anatomical entity in the renal system', 'absent cavitated compound organ in the renal system', 'decreased number of anatomical structure', 'absent compound organ', 'absent abdominal segment element in the renal system', 'absent anatomical entity in the renal system', 'absent organ in the multicellular organism', 'embryo development phenotype', 'number of anatomical enitites of type anatomical structure phenotype', 'digit 1 phenotype', 'optic cup', 'absent abdomen element in the renal system', 'decreased number of material anatomical entity in the abdomen', 'kidney phenotype', 'renal system morphology phenotype', 'olfactory placode', 'kidney morphology phenotype', 'Abnormality of globe size', 'size of eyeball of camera-type eye phenotype', 'increased length of the immaterial anatomical entity', 'Microphthalmia', 'decreased size of the eyeball of camera-type eye', 'kidney hypoplasia', 'Depressed nasal tip', 'sensation behavior', 'Localized skin lesion', 'nose phenotype', 'ectodermal placode', 'metencephalon', 'external ectoderm morphology phenotype', 'increased number of organ component layer', 'curvature anatomical entity', 'flat nose tip', 'absent limb bone in the forelimb', 'nose', 'olfactory placode morphology phenotype', 'organ', 'nose tip morphology phenotype', 'external ear', 'cranial placode'], 'has_descendant': ['MONDO:0013566'], 'has_descendant_label': ['Fanconi anemia complementation group L'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0010953', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group E', 'description': 'Fanconi anemia caused by mutations of the FANCE gene. This is a protein coding gene. It is required for the nuclear accumulation of FANCC and provides a critical bridge between the FA complex and FANCD2.', 'xref': ['DOID:0111084', 'GARD:15324', 'MEDGEN:463628', 'NCIT:C125709', 'OMIM:600901', 'UMLS:C3160739'], 'synonym': ['FACE', 'FANCE', 'FANCE Fanconi anaemia', 'FANCE Fanconi anemia', 'Fanconi Anemia, complementation group type E', 'Fanconi anaemia caused by mutation in FANCE', 'Fanconi anaemia complementation group type E', 'Fanconi anemia caused by mutation in FANCE', 'Fanconi anemia complementation group E', 'Fanconi anemia complementation group type E', 'Fanconi anemia, complementation group E', 'face'], 'exact_synonym': ['FACE', 'FANCE', 'FANCE Fanconi anaemia', 'FANCE Fanconi anemia', 'Fanconi Anemia, complementation group type E', 'Fanconi anaemia caused by mutation in FANCE', 'Fanconi anaemia complementation group type E', 'Fanconi anemia caused by mutation in FANCE', 'Fanconi anemia complementation group E', 'Fanconi anemia complementation group type E', 'face'], 'related_synonym': ['Fanconi anemia, complementation group E'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0000365', 'HP:0001875', 'HP:0000815', 'HP:0009777', 'HP:0001909', 'HP:0001518', 'HP:0001017', 'HP:0009943', 'HP:0003214', 'HP:0000086', 'HP:0009778', 'HP:0000252', 'HP:0001249', 'HP:0000953', 'HP:0000104', 'HP:0001873', 'HP:0000486', 'HP:0000028', 'HP:0001627', 'HP:0001263', 'HP:0000085', 'HP:0000568', 'HP:0000978', 'HP:0001876', 'HP:0001903', 'HP:0001896', 'HP:0003974', 'HP:0000081', 'HP:0003221', 'HP:0000957', 'HP:0004322', 'HP:0003213'], 'has_phenotype_label': ['Horseshoe kidney', 'Microphthalmia', 'Renal agenesis', 'Deficient excision of UV-induced pyrimidine dimers in DNA', 'Cafe-au-lait spot', 'Absent radius', 'Thrombocytopenia', 'Duplicated collecting system', 'Ectopic kidney', 'Complete duplication of thumb phalanx', 'Hypergonadotropic hypogonadism', 'Hearing impairment', 'Global developmental delay', 'Abnormal heart morphology', 'Pancytopenia', 'Decreased total neutrophil count', 'Bruising susceptibility', 'Short thumb', 'Microcephaly', 'Anemia', 'Anemic pallor', 'Reticulocytopenia', 'Short stature', 'Strabismus', 'Prolonged G2 phase of cell cycle', 'Intellectual disability', 'Absent thumb', 'Small for gestational age', 'Chromosomal breakage induced by crosslinking agents', 'Cryptorchidism', 'Leukemia', 'Hyperpigmentation of the skin'], 'has_phenotype_count': 32, 'has_phenotype_closure': ['GO:0048856', 'UPHENO:0083162', 'GO:0051703', 'UPHENO:0083161', 'UPHENO:0050068', 'HP:0001263', 'UPHENO:0000508', 'UPHENO:0083046', 'UPHENO:0081436', 'UPHENO:0050108', 'UPHENO:0049590', 'UPHENO:0000543', 'UPHENO:0000541', 'HP:0004322', 'HP:0001510', 'UPHENO:0069254', 'UPHENO:0080351', 'UPHENO:0081423', 'HP:0004323', 'UPHENO:0082794', 'UPHENO:0010808', 'UPHENO:0010850', 'UPHENO:0010763', 'UPHENO:0049874', 'UPHENO:0054304', 'UPHENO:0054315', 'HP:0001518', 'GO:0007600', 'UPHENO:0005513', 'HP:0000598', 'UPHENO:0052165', 'UBERON:0001690', 'UPHENO:0005512', 'HP:0000365', 'UPHENO:0050620', 'UPHENO:0052231', 'GO:0050954', 'UPHENO:0052160', 'UPHENO:0052178', 'GO:0007605', 'UPHENO:0052159', 'UPHENO:0052970', 'UPHENO:0008668', 'UPHENO:0081466', 'UPHENO:0026108', 'HP:0009777', 'UPHENO:0011825', 'UPHENO:0009146', 'UPHENO:0009382', 'UPHENO:0008548', 'HP:0009380', 'UPHENO:0054970', 'UPHENO:0080377', 'UPHENO:0074575', 'GO:0043473', 'UPHENO:0010799', 'HP:0001034', 'HP:0011355', 'UPHENO:0074584', 'HP:0001000', 'UPHENO:0080662', 'UPHENO:0053601', 'UPHENO:0049642', 'UBERON:0010130', 'UPHENO:0002240', 'UPHENO:0049757', 'UBERON:0003460', 'UPHENO:0049837', 'GO:0010629', 'HP:0001877', 'UPHENO:0087363', 'GO:0031052', 'UPHENO:0026183', 'GO:0031049', 'UPHENO:0050063', 'GO:0043170', 'UBERON:0010708', 'GO:0009890', 'UBERON:0004347', 'UPHENO:0002719', 'UBERON:0011216', 'UPHENO:0086296', 'GO:0010467', 'UPHENO:0049873', 'UPHENO:0008825', 'HP:0100542', 'UPHENO:0002750', 'UPHENO:0041465', 'HP:0002011', 'UBERON:0007688', 'UBERON:0001008', 'UPHENO:0003413', 'UPHENO:0002969', 'UBERON:0000063', 'UPHENO:0076779', 'UPHENO:0050778', 'UPHENO:0004482', 'HP:0000079', 'UPHENO:0087427', 'UBERON:0002113', 'UBERON:0005181', 'UBERON:0005172', 'UBERON:0000916', 'UPHENO:3000004', 'UPHENO:0025187', 'UBERON:0009569', 'UBERON:0005156', 'UBERON:0008962', 'UPHENO:0002803', 'UPHENO:0002782', 'UBERON:0004122', 'GO:0050890', 'UPHENO:0002267', 'HP:0012759', 'HP:0006501', 'UPHENO:0002600', 'GO:0050877', 'UBERON:0013702', 'UPHENO:0002385', 'UPHENO:0049699', 'UPHENO:0002204', 'UBERON:0001049', 'UBERON:0001890', 'UBERON:0003072', 'UPHENO:0085371', 'UPHENO:0004344', 'UBERON:0002100', 'UPHENO:0085302', 'UBERON:0011584', 'UPHENO:0075902', 'UPHENO:0002751', 'UPHENO:0005433', 'UPHENO:0002909', 'UPHENO:0080300', 'UPHENO:0002944', 'UBERON:0004053', 'UPHENO:0003177', 'UPHENO:0053563', 'UPHENO:0002548', 'UPHENO:0004523', 'UPHENO:0077391', 'GO:0065007', 'UPHENO:0087518', 'UPHENO:0003025', 'UPHENO:0002859', 'UPHENO:0049964', 'UPHENO:0086173', 'UPHENO:0004881', 'CL:0000458', 'NBO:0001845', 'UPHENO:7000640', 'HP:0012145', 'NCBITaxon:2759', 'UPHENO:0076702', 'UPHENO:0086485', 'UPHENO:0025852', 'UPHENO:0076805', 'NCBITaxon:1', 'UPHENO:0008743', 'UPHENO:0086679', 'UBERON:0016879', 'HP:0004742', 'HP:0032309', 'UPHENO:0053632', 'UPHENO:0018390', 'UPHENO:0026227', 'UPHENO:0002542', 'UPHENO:0080352', 'HP:0001873', 'UBERON:0001015', 'UBERON:0002342', 'UPHENO:0088166', 'UBERON:0003056', 'UBERON:0003914', 'HP:0012639', 'UPHENO:0005285', 'HP:0001872', 'UPHENO:0050040', 'HP:0006265', 'UPHENO:0002594', 'UPHENO:0004621', 'UPHENO:0002536', 'UPHENO:0076799', 'UPHENO:0063787', 'UBERON:0002346', 'UBERON:0004734', 'UPHENO:0011492', 'NCBITaxon:33208', 'UBERON:0004111', 'UPHENO:0085344', 'UPHENO:0041226', 'UPHENO:0087802', 'UPHENO:0076675', 'UBERON:0019221', 'UBERON:0011137', 'UPHENO:0011548', 'UPHENO:7000206', 'UPHENO:0002219', 'UPHENO:0026073', 'RO:0002577', 'UPHENO:0002571', 'UBERON:0003918', 'UPHENO:0004900', 'HP:0003220', 'UPHENO:0076740', 'UBERON:0007524', 'UBERON:0005423', 'UPHENO:0088123', 'HP:0000081', 'UBERON:0015025', 'UPHENO:0025587', 'UPHENO:0000509', 'CL:0002242', 'UPHENO:0004475', 'HP:0001909', 'UPHENO:0049904', 'UPHENO:0025497', 'UPHENO:0002764', 'UPHENO:0002964', 'UPHENO:0026074', 'UPHENO:0002736', 'UBERON:0000924', 'UBERON:0003607', 'UPHENO:0008640', 'HP:0009943', 'UPHENO:0050625', 'UPHENO:0075787', 'GO:0060255', 'UPHENO:0002586', 'UPHENO:0080200', 'HP:0003953', 'UPHENO:0004047', 'UPHENO:0027547', 'UPHENO:0004036', 'MPATH:105', 'UPHENO:0009399', 'UBERON:0004249', 'GO:0009058', 'UBERON:0003102', 'HP:0010461', 'UPHENO:0026010', 'UPHENO:0025553', 'UBERON:0015021', 'UPHENO:0003159', 'UPHENO:0076723', 'UPHENO:0049989', 'UBERON:0003606', 'HP:0001875', 'UBERON:0002428', 'UPHENO:0086002', 'UBERON:0010741', 'UPHENO:0025135', 'UBERON:0000079', 'CL:0000766', 'UBERON:0003466', 'UPHENO:0087228', 'UBERON:0003104', 'HP:0003221', 'UBERON:0010712', 'UPHENO:0002526', 'UPHENO:7000299', 'UPHENO:7000538', 'UBERON:0010707', 'UPHENO:0011572', 'UBERON:0004708', 'UBERON:0002398', 'UPHENO:0086019', 'UPHENO:0003186', 'UPHENO:0008475', 'UBERON:0000153', 'UBERON:0015410', 'UPHENO:0003366', 'UPHENO:0011559', 'HP:0045060', 'UPHENO:0004433', 'UPHENO:0008604', 'UPHENO:0026317', 'UPHENO:0087660', 'UPHENO:0026640', 'UPHENO:0026312', 'UPHENO:0008703', 'UPHENO:0087907', 'HP:0001627', 'UPHENO:0003005', 'UPHENO:0009295', 'UBERON:0015061', 'UBERON:0004456', 'GO:0010605', 'UBERON:0002495', 'UPHENO:0005090', 'UPHENO:0011531', 'UBERON:0007272', 'GO:0010556', 'HP:0002715', 'GO:0042592', 'UPHENO:0001003', 'GO:0044238', 'UBERON:0002470', 'HP:0000924', 'UPHENO:0003334', 'UPHENO:0087846', 'UPHENO:0002976', 'UPHENO:0025136', 'UPHENO:0004615', 'UPHENO:0009163', 'UPHENO:0025545', 'UBERON:0002102', 'UPHENO:0075219', 'UPHENO:0086546', 'UPHENO:0002738', 'UPHENO:0002861', 'UBERON:0002101', 'HP:0000119', 'UPHENO:0050019', 'HP:0012210', 'UBERON:0006598', 'UPHENO:0049703', 'UPHENO:0080187', 'CL:0000232', 'UPHENO:0009010', 'HP:0011844', 'UPHENO:0003088', 'UPHENO:3000007', 'UPHENO:0087663', 'UBERON:0010538', 'UBERON:0010313', 'UBERON:0004710', 'UPHENO:0003410', 'CL:0000151', 'UPHENO:0002577', 'UPHENO:0002967', 'UPHENO:0005030', 'UPHENO:0004909', 'NBO:0000001', 'UBERON:0000307', 'UPHENO:0046750', 'UPHENO:0003031', 'UBERON:0010912', 'UPHENO:0003020', 'UPHENO:0050126', 'UPHENO:0025845', 'UPHENO:0009391', 'HP:0001507', 'UPHENO:0025544', 'UPHENO:0087531', 'UPHENO:0079835', 'HP:0012443', 'UPHENO:0085263', 'HP:0010935', 'UBERON:0000053', 'UPHENO:0076692', 'UPHENO:0050121', 'UPHENO:0076739', 'MPATH:119', 'HP:0033127', 'UPHENO:0026095', 'UBERON:0002105', 'UBERON:0000955', 'HP:0009115', 'UPHENO:0025882', 'UPHENO:0002564', 'UPHENO:0005214', 'UPHENO:0009115', 'UBERON:0005177', 'UBERON:0011249', 'UPHENO:0008523', 'UBERON:0019231', 'UPHENO:0011536', 'HP:0009998', 'UBERON:0002204', 'UPHENO:0025507', 'UPHENO:0041075', 'UPHENO:0011817', 'UPHENO:3000003', 'HP:0012638', 'UPHENO:0086700', 'UPHENO:0027630', 'HP:0012243', 'UPHENO:0002553', 'UPHENO:0049587', 'CL:0000225', 'NCBITaxon:131567', 'UPHENO:0076776', 'UPHENO:0077348', 'UPHENO:0027014', 'UPHENO:0026181', 'UBERON:0000468', 'UPHENO:0076697', 'UPHENO:0003799', 'UPHENO:0025546', 'UPHENO:0079872', 'UBERON:0012358', 'UPHENO:0025508', 'BFO:0000002', 'UPHENO:0026098', 'UBERON:0002050', 'UPHENO:0002983', 'NCBITaxon:6072', 'UPHENO:0069523', 'UPHENO:0005277', 'UPHENO:0002525', 'UPHENO:7000311', 'UPHENO:0025176', 'UPHENO:0005596', 'UBERON:0001017', 'UPHENO:0026146', 'UPHENO:0003514', 'UPHENO:0002568', 'BFO:0000001', 'HP:0000811', 'GO:0050794', 'UBERON:5102389', 'UPHENO:0005055', 'UPHENO:0026506', 'UPHENO:0002433', 'UPHENO:0002668', 'HP:0031704', 'UBERON:0002513', 'UPHENO:0002642', 'UPHENO:0049622', 'UPHENO:0076703', 'UPHENO:0087339', 'UPHENO:0004507', 'UPHENO:0002206', 'UPHENO:0050435', 'HP:0007364', 'CL:0000000', 'UPHENO:0080325', 'UPHENO:0006894', 'UPHENO:0050106', 'UPHENO:0012312', 'UPHENO:0004466', 'UPHENO:0066913', 'HP:0003974', 'UPHENO:0002963', 'GO:0019222', 'HP:0040068', 'UBERON:0006601', 'UPHENO:0086172', 'UPHENO:0050007', 'HP:0011297', 'NBO:0000313', 'CL:0000988', 'UBERON:0001434', 'UPHENO:0075195', 'UPHENO:0003004', 'HP:0011018', 'UBERON:0001423', 'UBERON:0002390', 'UPHENO:0002948', 'GO:0003008', 'UPHENO:0002593', 'UBERON:0000489', 'UPHENO:0026486', 'HP:0012373', 'UBERON:0001460', 'UPHENO:0004459', 'UPHENO:0002731', 'UBERON:0001981', 'UPHENO:0002902', 'UPHENO:0002559', 'GO:0007610', 'GO:0043229', 'UPHENO:0025955', 'UPHENO:0087665', 'UPHENO:0005517', 'UPHENO:0002352', 'UBERON:0005291', 'GO:0009987', 'HP:0005561', 'UBERON:0003075', 'UBERON:0004121', 'UBERON:0002384', 'UPHENO:0004680', 'UPHENO:0003095', 'UPHENO:0087510', 'UPHENO:0009366', 'HP:0040064', 'UPHENO:0026096', 'CL:0000329', 'UBERON:0004128', 'UPHENO:0088170', 'UPHENO:0001002', 'UPHENO:0086956', 'HP:0001017', 'UBERON:0002193', 'UBERON:0004120', 'UPHENO:0049870', 'HP:0002817', 'UPHENO:0011573', 'UBERON:0000965', 'UBERON:0005417', 'UPHENO:0025808', 'UPHENO:0082761', 'GO:0048523', 'CL:0000255', 'HP:0003214', 'UPHENO:0025652', 'UBERON:0003129', 'UBERON:0001062', 'UPHENO:0004360', 'UBERON:0002091', 'HP:0040012', 'UPHENO:0004476', 'UBERON:0004357', 'UBERON:0005061', 'UPHENO:0002830', 'UPHENO:0049664', 'HP:0000080', 'UPHENO:0008865', 'GO:0007631', 'UBERON:0006876', 'UBERON:0001016', 'UPHENO:0002903', 'UBERON:0010000', 'UPHENO:0003082', 'UPHENO:0088175', 'UPHENO:0025547', 'UPHENO:0080010', 'UBERON:0005881', 'BFO:0000015', 'UPHENO:0075220', 'UBERON:0000467', 'UPHENO:0005092', 'UPHENO:0003432', 'UPHENO:0002541', 'UPHENO:0066927', 'UBERON:0000019', 'UPHENO:0003184', 'UPHENO:0011498', 'UBERON:0000062', 'UPHENO:0002530', 'UPHENO:7000183', 'UPHENO:0002754', 'UPHENO:0003001', 'UBERON:0000923', 'UPHENO:0003236', 'UBERON:0002104', 'UBERON:0000075', 'HP:0001903', 'HP:0030680', 'UPHENO:0003415', 'GO:0022403', 'UPHENO:0054957', 'UPHENO:0004885', 'HP:0000001', 'HP:0002597', 'UPHENO:0050008', 'UPHENO:0003227', 'HP:0000077', 'UBERON:0000926', 'HP:0000364', 'UPHENO:0002635', 'HP:0010987', 'UPHENO:0086635', 'UPHENO:0079828', 'UPHENO:0025166', 'UPHENO:0053644', 'UBERON:0000061', 'GO:0032501', 'UPHENO:0088176', 'HP:0006496', 'UPHENO:0004802', 'UBERON:0010758', 'UPHENO:0002597', 'UPHENO:0002632', 'UBERON:0000025', 'CL:0000763', 'UPHENO:0088162', 'UBERON:0008785', 'UPHENO:0002554', 'UPHENO:0011770', 'HP:0011446', 'UPHENO:0002343', 'UPHENO:0002949', 'UPHENO:0005025', 'GO:0048519', 'CL:0000457', 'UPHENO:0004765', 'GO:0008152', 'UPHENO:0003094', 'UPHENO:0011533', 'UBERON:0004288', 'UBERON:0000026', 'HP:0012758', 'UPHENO:0049652', 'UPHENO:0026023', 'HP:0040072', 'UPHENO:0027631', 'UBERON:5006048', 'UBERON:0003080', 'UPHENO:0004595', 'UPHENO:0009356', 'UPHENO:0080126', 'UPHENO:0002945', 'UBERON:0001440', 'UPHENO:0081511', 'HP:0009822', 'UPHENO:0025585', 'UBERON:0003081', 'UBERON:0010740', 'UPHENO:0068971', 'HP:0032251', 'UBERON:0001869', 'UPHENO:0041821', 'UBERON:0011582', 'HP:0000118', 'UBERON:0012140', 'UPHENO:0069161', 'HP:0000478', 'HP:0004275', 'UPHENO:0026757', 'UBERON:0000383', 'UBERON:0000922', 'UPHENO:0063722', 'UPHENO:0004888', 'UPHENO:0076941', 'UPHENO:0004892', 'UBERON:0005173', 'UPHENO:0002926', 'UBERON:0010230', 'UBERON:0005388', 'UBERON:0015212', 'UBERON:0000483', 'UPHENO:7000590', 'UPHENO:0025961', 'UPHENO:0026643', 'UPHENO:0025211', 'BFO:0000004', 'UBERON:0015001', 'GO:0010558', 'NBO:0000338', 'UPHENO:0003049', 'UBERON:0010314', 'UPHENO:0066925', 'UPHENO:0011568', 'UPHENO:0008430', 'UPHENO:0049868', 'UPHENO:0003123', 'UPHENO:0002269', 'UBERON:0002529', 'HP:0000135', 'UPHENO:0087347', 'UPHENO:0080079', 'UPHENO:0004469', 'UPHENO:0026078', 'UPHENO:0081581', 'HP:0002818', 'HP:0002813', 'UBERON:0007213', 'MPATH:0', 'UPHENO:0025811', 'UBERON:0010363', 'UBERON:0011143', 'UPHENO:0069149', 'UPHENO:0052161', 'UPHENO:0079826', 'UPHENO:0076718', 'UBERON:0000060', 'UPHENO:0075944', 'UPHENO:0076791', 'UPHENO:0002785', 'UPHENO:0063794', 'UPHENO:0005141', 'UPHENO:0004704', 'HP:0000980', 'UBERON:0034925', 'UPHENO:0009344', 'UBERON:0000073', 'UBERON:0000064', 'UPHENO:0003811', 'UPHENO:0076754', 'UPHENO:0002567', 'UBERON:0004100', 'GO:0042756', 'UPHENO:0087547', 'HP:0011873', 'UPHENO:0010743', 'UPHENO:0002531', 'UBERON:0004765', 'UPHENO:0027189', 'GO:0008150', 'GO:0005840', 'HP:0006503', 'GO:0090304', 'UPHENO:0087577', 'UPHENO:0082875', 'UPHENO:0025883', 'UPHENO:0026806', 'UBERON:0003221', 'UBERON:0001474', 'HP:0001892', 'UPHENO:0026808', 'UPHENO:0087423', 'UPHENO:0049620', 'UPHENO:0078606', 'HP:0000085', 'HP:0001871', 'UBERON:0003103', 'UBERON:0004375', 'HP:0009815', 'UPHENO:0085330', 'HP:0011842', 'BFO:0000003', 'UPHENO:0002650', 'UBERON:0002471', 'UBERON:0001768', 'NCBITaxon:33154', 'GO:0050789', 'HP:0040070', 'UPHENO:0053612', 'UPHENO:0009341', 'HP:0009778', 'UPHENO:0026344', 'UPHENO:0002816', 'HP:0012372', 'UPHENO:0004519', 'UPHENO:0002870', 'UBERON:0003133', 'UPHENO:0025509', 'UPHENO:0079876', 'GO:0009059', 'UPHENO:0087089', 'UPHENO:0049990', 'UPHENO:0011931', 'UPHENO:0049671', 'UPHENO:0054374', 'UPHENO:0050116', 'UPHENO:0049720', 'UBERON:5106048', 'HP:0003254', 'UPHENO:0080209', 'UPHENO:0002323', 'UPHENO:0051124', 'GO:0006281', 'GO:0009889', 'UBERON:0016880', 'HP:0011121', 'GO:0006259', 'HP:0003213', 'UBERON:0003101', 'UPHENO:0076724', 'HP:0001155', 'GO:0050896', 'GO:0006950', 'GO:0051716', 'GO:0006974', 'GO:0006139', 'UBERON:0001801', 'UBERON:0012139', 'UPHENO:0003055', 'UPHENO:0025776', 'UPHENO:0053561', 'UPHENO:0002523', 'UPHENO:0076804', 'UBERON:0002386', 'UPHENO:0087973', 'UPHENO:0046426', 'UPHENO:7000069', 'UPHENO:0046505', 'UPHENO:0053566', 'UPHENO:0049743', 'HP:0000815', 'HP:0000078', 'UPHENO:0002682', 'UBERON:0000473', 'HP:0000002', 'UPHENO:0087661', 'UBERON:0005062', 'UPHENO:0053647', 'UPHENO:0002659', 'UPHENO:0053571', 'UPHENO:0002940', 'UPHENO:0003056', 'UPHENO:0050234', 'UPHENO:0002595', 'UPHENO:0026504', 'UPHENO:0046707', 'UPHENO:0087849', 'UPHENO:0053559', 'HP:0000028', 'HP:0000032', 'UBERON:0000991', 'UPHENO:0050065', 'UPHENO:0084763', 'CL:0000764', 'UBERON:0003135', 'GO:0040007', 'UBERON:0004176', 'UPHENO:0053572', 'HP:0000568', 'UBERON:0002075', 'UBERON:0001048', 'UBERON:0010312', 'UPHENO:0002844', 'UBERON:0000970', 'UPHENO:0002866', 'UBERON:0004381', 'UPHENO:0086486', 'UPHENO:0087472', 'UPHENO:0002928', 'UPHENO:0086633', 'UBERON:0015203', 'UBERON:0002405', 'UPHENO:0069064', 'UPHENO:0049835', 'BFO:0000040', 'UPHENO:0003189', 'UPHENO:0005058', 'UBERON:0001032', 'UPHENO:0069062', 'UBERON:0000490', 'UPHENO:0027231', 'HP:0008056', 'UBERON:0034923', 'UBERON:0001444', 'UPHENO:0004764', 'UBERON:0007811', 'HP:0000549', 'UBERON:0004088', 'UPHENO:0001001', 'UBERON:0001456', 'CL:0000094', 'UBERON:0000020', 'UPHENO:0078629', 'UPHENO:0005110', 'UBERON:0009142', 'UPHENO:0004494', 'UPHENO:0069266', 'UPHENO:0004831', 'UPHENO:0004757', 'UBERON:0000047', 'GO:0030587', 'UPHENO:0004721', 'UPHENO:0086589', 'UPHENO:0004525', 'HP:0011991', 'UPHENO:0069327', 'UPHENO:0081424', 'UPHENO:0069674', 'UPHENO:0002637', 'UPHENO:0005097', 'UPHENO:0053580', 'UPHENO:0002910', 'HP:0100887', 'UPHENO:0075997', 'UPHENO:0004173', 'UBERON:0000033', 'UPHENO:0046624', 'UPHENO:0002576', 'HP:0000978', 'UPHENO:0009209', 'UPHENO:0025661', 'UPHENO:0002804', 'UBERON:0007798', 'UBERON:0001802', 'HP:0002973', 'UBERON:0001009', 'UBERON:0003071', 'UPHENO:0087852', 'UPHENO:0002393', 'UPHENO:0006889', 'UPHENO:0076782', 'UBERON:0001893', 'UPHENO:0004261', 'HP:0001574', 'UPHENO:0087596', 'UBERON:0011818', 'UPHENO:0025855', 'UBERON:0000477', 'UPHENO:0002747', 'UBERON:0000966', 'UPHENO:0066903', 'HP:0011354', 'GO:0010468', 'UPHENO:0069605', 'UPHENO:0002765', 'HP:0000707', 'UPHENO:0084761', 'UPHENO:0005029', 'UPHENO:0009129', 'MPATH:603', 'UBERON:0019207', 'UBERON:0004923', 'UPHENO:0081451', 'UPHENO:0087081', 'UBERON:0010316', 'HP:0001896', 'UPHENO:0004262', 'HP:0007400', 'UPHENO:0053619', 'UPHENO:0004884', 'UPHENO:0004766', 'HP:0002060', 'UPHENO:0002746', 'UPHENO:0087915', 'UPHENO:0041629', 'UPHENO:0018418', 'UPHENO:9002003', 'UBERON:0005157', 'UBERON:0003099', 'UPHENO:0084815', 'UBERON:0000076', 'UPHENO:0005093', 'HP:0010974', 'UBERON:0005253', 'HP:0009121', 'HP:0001876', 'UPHENO:0087928', 'GO:0009892', 'HP:0000035', 'UPHENO:0076789', 'UBERON:0015063', 'UBERON:0010703', 'MPATH:1000', 'UBERON:8450003', 'HP:0001939', 'UPHENO:0002311', 'UBERON:0012151', 'UPHENO:0003412', 'GO:0005575', 'HP:0025354', 'UBERON:0002097', 'UPHENO:0003369', 'UBERON:0013701', 'UPHENO:0004064', 'UPHENO:0002704', 'GO:0110165', 'UBERON:0000055', 'UBERON:0005389', 'UBERON:0002443', 'UPHENO:0002634', 'UPHENO:0003776', 'UBERON:0002417', 'UBERON:0002416', 'UPHENO:0049775', 'HP:0001249', 'GO:0043232', 'UPHENO:0005437', 'UPHENO:7000632', 'UBERON:0002203', 'UPHENO:0004484', 'UBERON:0010409', 'HP:0011875', 'UBERON:0011362', 'UPHENO:0009020', 'UBERON:0006058', 'UPHENO:0002678', 'UPHENO:0086297', 'GO:0043228', 'UBERON:0003496', 'UPHENO:7000303', 'UPHENO:0066902', 'UPHENO:0003812', 'UPHENO:7000101', 'UBERON:0000014', 'UPHENO:0085356', 'HP:0000234', 'UBERON:0002199', 'UPHENO:0005518', 'GO:0043226', 'UBERON:0004535', 'UPHENO:0088164', 'UPHENO:0002410', 'HP:0001933', 'UPHENO:7000539', 'UBERON:0001776', 'UPHENO:0066972', 'UPHENO:0002580', 'UBERON:8450002', 'UBERON:0002389', 'UPHENO:0002896', 'UPHENO:7000547', 'UPHENO:0009021', 'UBERON:0004537', 'UBERON:0002200', 'HP:0009997', 'UPHENO:0076777', 'UPHENO:0076729', 'UPHENO:0004827', 'UPHENO:0087186', 'UPHENO:0086484', 'UBERON:0007530', 'HP:0011276', 'UPHENO:0076810', 'HP:0000951', 'UBERON:0007100', 'UPHENO:0009337', 'MPATH:120', 'HP:0005918', 'UPHENO:0087597', 'HP:0012733', 'UBERON:0010371', 'UBERON:0000479', 'UPHENO:0087232', 'UPHENO:0002648', 'UPHENO:0002386', 'HP:0000486', 'HP:0001874', 'UPHENO:0002403', 'UBERON:0000466', 'UPHENO:7000169', 'UPHENO:0002301', 'HP:0000953', 'UBERON:0000015', 'UBERON:0010222', 'UPHENO:0002360', 'UBERON:0000964', 'UPHENO:0002430', 'CL:0000081', 'HP:0000496', 'GO:0099120', 'UPHENO:0066945', 'HP:0004325', 'UBERON:0012475', 'UBERON:0012430', 'UPHENO:0027017', 'BFO:0000141', 'UPHENO:0002550', 'UPHENO:0002211', 'UPHENO:7000223', 'HP:0001167', 'UPHENO:0087349', 'UPHENO:0084816', 'UPHENO:7000235', 'UPHENO:0088148', 'UPHENO:0026600', 'CL:0000558', 'CL:0002422', 'UPHENO:0003050', 'UPHENO:0069352', 'HP:0004312', 'HP:0008678', 'UPHENO:0003163', 'UPHENO:0002712', 'UPHENO:0011749', 'UPHENO:0008816', 'UPHENO:0026507', 'UPHENO:0011566', 'UPHENO:0008545', 'UPHENO:0002308', 'UBERON:0005451', 'UPHENO:0026309', 'HP:0000252', 'UBERON:0000915', 'UPHENO:0025631', 'HP:0000104', 'UPHENO:0026630', 'UPHENO:0009011', 'UPHENO:0004521', 'UPHENO:0003065', 'UPHENO:0008593', 'UPHENO:0026308', 'GO:0033554', 'UPHENO:0049586', 'UPHENO:0011739', 'UBERON:0000475', 'HP:0009602', 'UPHENO:0084448', 'UPHENO:0002733', 'UPHENO:0086769', 'UBERON:0005419', 'UBERON:0005897', 'UBERON:0012357', 'UPHENO:0087501', 'UBERON:0001436', 'UPHENO:0002905', 'UPHENO:0075159', 'UPHENO:0080114', 'GO:0005622', 'UBERON:5002544', 'UPHENO:0087006', 'UPHENO:0002708', 'UBERON:0012354', 'UBERON:5102544', 'UBERON:0010543', 'UPHENO:0066905', 'UBERON:0006717', 'HP:0001626', 'UBERON:0010323', 'HP:0005922', 'UBERON:5001463', 'UBERON:0011676', 'UBERON:0000481', 'UPHENO:0087924', 'UPHENO:0026097', 'UBERON:0001463', 'UBERON:0011250', 'UPHENO:7000599', 'GO:0007049', 'UBERON:0015024', 'UBERON:0015023', 'UBERON:5101463', 'UPHENO:0003069', 'UPHENO:0049952', 'UBERON:0010688', 'UPHENO:0002685', 'UBERON:0001442', 'HP:0009142', 'UBERON:0003620', 'UBERON:0015204', 'UPHENO:0012274', 'HP:0009942', 'UBERON:0006048', 'UPHENO:0003093', 'UPHENO:0008827', 'UBERON:5002389', 'HP:0011017', 'UBERON:0002544', 'HP:0001172', 'GO:0051325', 'UPHENO:0003021', 'GO:0051319', 'GO:0044848', 'UBERON:0000990', 'HP:0000086', 'UPHENO:0086176', 'UBERON:0002049', 'HP:0001911', 'CL:0000219', 'UPHENO:0046740', 'UPHENO:0076727', 'HP:0001881', 'UPHENO:0010795', 'UPHENO:0077399', 'CL:0000775', 'UBERON:0012141', 'UPHENO:7000530', 'HP:0011992', 'UPHENO:0087123', 'UPHENO:7000306', 'UPHENO:0085354', 'UPHENO:0077418', 'CL:0000738', 'UPHENO:0085301', 'UPHENO:7000294', 'UPHENO:0005016', 'CL:0001035', 'UPHENO:0003084', 'UBERON:0002371', 'UBERON:0006003', 'CL:0002092', 'UBERON:0000465', 'UPHENO:0086048', 'HP:0000957', 'UPHENO:0012308', 'HP:0011893', 'HP:0009381', 'HP:0011927', 'UPHENO:0080099', 'UPHENO:0069236', 'UPHENO:0046445', 'UPHENO:0046741', 'UPHENO:0046528', 'UBERON:0006800', 'UPHENO:0012440', 'UPHENO:0086016', 'UPHENO:0003116', 'UPHENO:0046483', 'HP:0009601', 'UPHENO:0008709', 'UPHENO:0088186', 'HP:0005927', 'UPHENO:0049588', 'UPHENO:0069684', 'UPHENO:0002527', 'UPHENO:0046411', 'UPHENO:0046552', 'CL:0000233', 'HP:0008373', 'UPHENO:0024906', 'UBERON:0002616', 'UPHENO:0002381', 'UPHENO:0002880', 'HP:0000818', 'HP:0000929', 'UBERON:0000949', 'HP:0100547', 'HP:0011793', 'UPHENO:0002378', 'HP:0002664', 'UPHENO:0002987', 'HP:0004377', 'UPHENO:0077373', 'HP:0040195', 'UPHENO:0075804', 'UBERON:0011138', 'UPHENO:0075148', 'UBERON:0034944', 'HP:0000152', 'NBO:0000444', 'UPHENO:0081566', 'UPHENO:3000000', 'UBERON:0002090', 'HP:0002977', 'HP:0000240', 'UPHENO:0002832', 'UBERON:0015228', 'UPHENO:0003086', 'UPHENO:0053610', 'UBERON:0005178', 'UBERON:0012150', 'UBERON:0005944', 'UBERON:0000948', 'UPHENO:0053588', 'UPHENO:0053643', 'GO:0032502', 'UPHENO:0053633'], 'has_phenotype_closure_label': ['delayed sorocarp development', 'biological process involved in intraspecies interaction between organisms phenotype', 'anatomical structure development phenotype', 'Global developmental delay', 'delayed anatomical structure development', 'socially cooperative development phenotype', 'Neurodevelopmental delay', 'development of anatomical entity phenotype', 'developmental process phenotype', 'sorocarp development', 'biological process involved in intraspecies interaction between organisms', 'multicellular organism height phenotype', 'decreased height of the anatomical entity', 'size of multicellular organism phenotype', 'Growth delay', 'Abnormality of body height', 'multicellular anatomical structure mass phenotype', 'Decreased anatomical entity mass', 'decreased anatomical structure mass', 'anatomical entity mass phenotype', 'Small for gestational age', 'Decreased multicellular organism mass', 'anatomical structure mass phenotype', 'growth phenotype', 'Growth abnormality', 'decreased qualitatively system process', 'sensory perception of mechanical stimulus phenotype', 'decreased sensory perception of sound', 'decreased qualitatively nervous system process', 'decreased sensory perception', 'decreased qualitatively sensory perception', 'sensory perception', 'ear physiology phenotype', 'decreased biological_process', 'vestibulo-auditory system phenotype', 'ear phenotype', 'decreased multicellular organismal process', 'decreased qualitatively sensory perception of mechanical stimulus', 'sensory perception of sound', 'Abnormality of the ear', 'nervous system process phenotype', 'sensory perception phenotype', 'decreased nervous system process', 'decreased qualitatively sensory perception of sound', 'Hearing impairment', 'vestibulo-auditory system', 'decreased qualitatively multicellular organismal process', 'Finger aplasia', 'Absent thumb', 'absent digit', 'aplastic manual digit 1', 'delayed growth', 'absent organism subdivision in the multicellular organism', 'Macule', 'Hyperpigmentation of the skin', 'Irregular hyperpigmentation', 'pigmentation phenotype', 'increased biological_process in skin of body', 'increased pigmentation in skin of body', 'Cafe-au-lait spot', 'Hypermelanotic macule', 'Abnormality of skin pigmentation', 'increased qualitatively biological_process', 'Localized skin lesion', 'increased biological_process', 'biological_process rate phenotype', 'localised trunk region element', 'primordium phenotype', 'head phenotype', 'Chromosomal breakage induced by crosslinking agents', 'negative regulation of gene expression', 'negative regulation of macromolecule biosynthetic process', 'negative regulation of cellular process phenotype', 'number of anatomical enitites of type erythrocyte phenotype', 'neural crest-derived structure phenotype', 'sorocarp development phenotype', 'programmed DNA elimination', 'hematopoietic cell', 'regulation of macromolecule metabolic process', 'Abnormality of metabolism/homeostasis', 'zone of organ', 'gene expression phenotype', 'regulation of cellular process', 'integumentary adnexa physiology phenotype', 'negative regulation of biological process', 'retina', 'decreased length of digit', '3-D shape anatomical entity', 'continuant', 'DNA metabolic process', 'absent organ in the renal system', 'shape of anatomical entity phenotype', 'abdominal segment of trunk', 'kidney phenotype', 'dense mesenchyme tissue phenotype', 'subdivision of organism along main body axis phenotype', 'abdominal segment element', 'skeleton of manual digitopodium', 'body proper', 'subdivision of trunk', 'ectoderm phenotype', 'absent abdomen element', 'main body axis', 'Abnormality of the genitourinary system', 'cavitated compound organ phenotype', 'anlage', 'sense organ', 'Abnormal renal collecting system morphology', 'renal/urinary system phenotype', 'biological_process phenotype', 'trunk region element', 'system process', 'Abnormality of mental function', 'number of anatomical enitites of type organ phenotype', 'localised organ', 'Abnormal nervous system physiology', 'nervous system process', 'anatomical system physiology phenotype', 'telencephalon morphology phenotype', 'cardiovascular system phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'mesenchyme derived from head neural crest phenotype', 'number of myeloid cell phenotype', 'thoracic segment organ', 'Eukaryota', 'homeostatic process phenotype', 'multi-tissue structure phenotype', 'Abnormal cellular immune system morphology', 'vasculature of organ phenotype', 'ectoderm', 'decreased number of platelet', 'forelimb morphology phenotype', 'anatomical entity physiology phenotype', 'connective tissue', 'decreased number of anatomical structure', 'ectoderm-derived structure phenotype', 'organ subunit phenotype', 'integumental system', 'absent bone element', 'decreased number of hematopoietic cell', 'epithelial tube', 'Eumetazoa', 'choroidal neovascularization', 'platelet', 'increased pigmentation', 'presumptive ectoderm phenotype', 'neural plate phenotype', 'absent bone of pectoral complex in the limb', 'immaterial anatomical entity', 'axial skeleton plus cranial skeleton phenotype', 'nervous system', 'absent endochondral element', 'root', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'decreased number of myeloid cell', 'epithelium', 'subdivision of trunk phenotype', 'intracellular membraneless organelle', 'mesoderm', 'neural tube', 'forebrain phenotype', 'nervous system physiology phenotype', 'Intellectual disability', 'segment of manus', 'epithelium phenotype', 'excretory system', 'neoplasm phenotype', 'pre-chordal neural plate phenotype', 'number of anatomical enitites of type trunk region element phenotype', 'leukocyte morphology phenotype', 'central nervous system phenotype', 'pectoral appendage bud', 'Reticulocytopenia', 'Abnormal platelet morphology', 'negative regulation of gene expression phenotype', 'trunk region element phenotype', 'telencephalon phenotype', 'blastula', 'skeletal system phenotype', 'bone of pectoral complex morphology phenotype', 'Abnormality of neutrophils', 'brain phenotype', 'decreased number of cell', 'intracellular anatomical structure', 'absent organ in the limb', 'renal system phenotype', 'hemorrhage and non-specified extravasation', 'neurectoderm', 'cerebral hemisphere morphology phenotype', 'Abnormal limb bone morphology', 'regulation of biosynthetic process', 'regulation of metabolic process phenotype', 'Abnormality of eye movement', 'cerebral hemisphere', 'kidney', 'future nervous system', 'face phenotype', 'Abnormal platelet count', 'forebrain morphology phenotype', 'manus bone', 'manual digit bone', 'erythrocyte', 'tube', 'digitopodium region', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'regulation of gene expression phenotype', 'kidney mesenchyme phenotype', 'absent anatomical structure in the tissue', 'Neoplasm', 'skeleton of digitopodium', 'cranial skeletal system', 'size of eyeball of camera-type eye phenotype', 'Short stature', 'tissue phenotype', 'Short finger', 'Decreased head circumference', 'integument', 'absent skeletal element in the limb', 'Aplasia/hypoplasia of the extremities', 'migrating mesenchyme population', 'upper urinary tract phenotype', 'manual digit 1 or 5', 'absent anatomical entity in the forelimb', 'forebrain', 'Abnormal cellular phenotype', 'absent anatomical entity in the limb', 'decreased size of the anatomical structure', 'skull morphology phenotype', 'manual digit', 'skeleton of manus', 'subdivision of skeletal system phenotype', 'appendage girdle complex', 'renal collecting system phenotype', 'absent bone of free limb or fin in the limb', 'hematopoietic system morphology phenotype', 'eye morphology', 'anterior polar cataract', 'appendicular skeleton phenotype', 'leukocyte', 'abdominal segment element phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'absent forelimb zeugopod bone', 'manual digit phenotype', 'Chromosome breakage', 'vasculature of eye phenotype', 'decreased functionality of the gonad', 'forelimb endochondral element', 'Anemic pallor', 'Opisthokonta', 'decreased size of the multicellular organism', 'limb long bone', 'Abnormality of head or neck', 'bone of pectoral complex', 'camera-type eye physiology phenotype', 'Abnormal appendicular skeleton morphology', 'pectoral appendage skeleton', 'individual digit of digitopodial skeleton', 'forelimb long bone phenotype', 'renal system morphology phenotype', 'Abnormality of the eye', 'gastrula', 'multicellular organismal process phenotype', 'absent organ in the multicellular organism', 'programmed DNA elimination by chromosome breakage', 'macromolecule metabolic process', 'cellular organisms', 'regulation of macromolecule biosynthetic process', 'absent limb long bone in the forelimb', 'decreased size of the anatomical entity in the pectoral complex', 'arm phenotype', 'absent material anatomical entity in the skeletal system', 'homeostatic process', 'regulation of macromolecule metabolic process phenotype', 'absent bone element in the limb', 'absent multicellular anatomical structure in the limb', 'regulation of macromolecule biosynthetic process phenotype', 'appendicular skeleton', 'limb skeleton subdivision phenotype', 'reproductive organ', 'absent anatomical entity in the tissue', 'forelimb zeugopod', 'pigmentation', 'radius endochondral element', 'forelimb long bone', 'delayed developmental process', 'behavior process phenotype', 'forelimb bone', 'appendicular skeletal system', 'regional part of nervous system phenotype', 'blood vessel morphology phenotype', 'decreased system process', 'pectoral complex', 'biosynthetic process phenotype', 'cognition', 'male organism', 'Morphological central nervous system abnormality', 'number of anatomical enitites of type endochondral element phenotype', 'pectoral appendage bud phenotype', 'gene expression', 'Abnormality of the upper limb', 'orbital region phenotype', 'U-shaped anatomical entity', 'macromolecule biosynthetic process phenotype', 'autopodial skeleton', 'biosynthetic process', 'absent manual digit', 'choroidal blood vessel', 'limb bone phenotype', 'Abnormal forearm morphology', 'system', 'Neurodevelopmental abnormality', 'radius bone phenotype', 'absent arm bone', 'absent bone of pectoral complex in the forelimb', 'anterior neural tube phenotype', 'Metazoa', 'behavior phenotype', 'bone element phenotype', 'decreased size of the subdivision of organism along main body axis', 'digit phenotype', 'absent material anatomical entity in the tissue', 'bone marrow', 'face morphology phenotype', 'autopodial extension', 'phenotype', 'sensory perception of sound phenotype', 'Duplication of phalanx of hand', 'aplasia or hypoplasia of radius bone', 'forelimb bud phenotype', 'skeleton of limb phenotype', 'absent endochondral bone in the limb', 'Abnormal forearm bone morphology', 'regulation of cellular process phenotype', 'autopod region morphology phenotype', 'material anatomical entity', 'anucleate cell', 'brain morphology phenotype', 'visual system', 'anatomical cluster phenotype', 'absent anatomical structure in the multicellular organism', 'absent material anatomical entity in the forelimb', 'absent limb long bone', 'arm bone phenotype', 'absent cavitated compound organ', 'Anemia', 'telencephalon', 'zeugopod phenotype', 'multicellular anatomical structure phenotype', 'absent forelimb endochondral element', 'behavior process', 'Aplasia/Hypoplasia affecting the eye', 'anatomical conduit', 'absent skeletal element', 'platelet phenotype', 'reproductive structure', 'Abnormality of the endocrine system', 'forelimb skeleton', 'mesoderm-derived structure', 'Abnormality of body weight', 'absent limb endochondral element in the limb', 'forelimb zeugopod skeleton', 'Aplasia/hypoplasia involving forearm bones', 'organ', 'forelimb zeugopod phenotype', 'absent trunk region element', 'cell cycle phenotype', 'limb bone morphology phenotype', 'number of hematopoietic cell phenotype', 'phalanx of manus', 'secretory cell', 'Abnormality of the upper urinary tract', 'DNA damage response phenotype', 'number of anatomical enitites of type granulocyte phenotype', 'forelimb bud', 'forelimb', 'lateral structure phenotype', 'absent bone element in the forelimb', 'absent material anatomical entity in the limb', 'forelimb zeugopod bone phenotype', 'number of anatomical enitites of type reticulocyte phenotype', 'Abnormal bleeding', 'embryo phenotype', 'lens of camera-type eye phenotype', 'cerebral amyloid angiopathy', 'absent forelimb zeugopod bone in the forelimb', 'organ part phenotype', 'absent anatomical structure in the limb', 'circulatory system phenotype', 'anatomical system', 'bone of appendage girdle complex', 'enucleated reticulocyte', 'number of anatomical enitites of type skeletal element phenotype', 'mesoderm-derived structure phenotype', 'cranial blood vasculature', 'decreased number of reticulocyte', 'segment of autopod', 'Abnormal neutrophil morphology', 'absent organ', 'independent continuant', 'Abnormal myeloid leukocyte morphology', 'multi-limb segment region phenotype', 'absent bone of free limb or fin', 'kidney morphology phenotype', 'immune system phenotype', 'bone element', 'forelimb zeugopod bone', 'regulation of metabolic process', 'subdivision of organism along appendicular axis', 'cellular_component', 'surface structure phenotype', 'paired limb/fin skeleton', 'drinking behavior phenotype', 'pectoral appendage skeleton phenotype', 'ectoderm-derived structure', 'absent limb bone in the limb', 'forelimb zeugopod morphology phenotype', 'eyeball of camera-type eye', 'long bone morphology phenotype', 'Abnormal thumb morphology', 'Horseshoe kidney', 'zeugopodial skeleton', 'nucleic acid metabolic process phenotype', 'renal system', 'forelimb zeugopod bone morphology phenotype', 'cell', 'behavior', 'number of cell phenotype', 'oxygen accumulating cell', 'Abnormality of thrombocytes', 'anatomical entity', 'embryonic structure', 'absent multicellular anatomical structure', 'Abnormality of the male genitalia', 'organism subdivision', 'multicellular organismal process', 'anatomical structure', 'feeding behavior phenotype', 'absent anatomical entity in the skeletal system', 'consumption behavior', 'Prolonged G2 phase of cell cycle', 'thoracic cavity element', 'presumptive structure', 'genitourinary system phenotype', 'absent forelimb bone', 'entity', 'anatomical conduit physiology phenotype', 'absent material anatomical entity in the multicellular organism', 'number of anatomical enitites of type material anatomical entity phenotype', 'Aplasia/hypoplasia involving bones of the upper limbs', 'abdomen', 'developing anatomical structure phenotype', 'pre-chordal neural plate', 'appendicular skeleton morphology phenotype', 'Strabismus', 'future central nervous system', 'embryo', 'embryonic structure phenotype', 'germ layer phenotype', 'regional part of brain phenotype', 'absent radius endochondral element', 'decreased multicellular anatomical structure mass', 'organ part', 'aplastic forelimb zeugopod bone', 'Pallor', 'absent forelimb bone in the limb', 'cell phenotype', 'phalanx', 'dense mesenchyme tissue', 'myeloid leukocyte', 'digit 1 plus metapodial segment', 'manus morphology phenotype', 'paired limb/fin phenotype', 'Renal hypoplasia/aplasia', 'localised reproductive organ', 'anatomical entity dysfunction in independent continuant', 'regional part of brain', 'Aplasia/Hypoplasia of the thumb', 'absent anatomical structure', 'number of anatomical enitites of type anatomical entity phenotype', 'endochondral bone', 'biological phase', 'Abnormality of the nervous system', 'multicellular anatomical structure', 'process', 'occurrent', 'localised abdomen element', 'multicellular organism morphology phenotype', 'localised multicellular anatomical structure', 'Hematological neoplasm', 'cellular process', 'decreased functionality of the material anatomical entity', 'ribosome biogenesis', 'negative regulation of macromolecule metabolic process phenotype', 'developing anatomical structure', 'lateral structure', 'aplasia or hypoplasia of anatomical entity', 'subdivision of skeleton phenotype', 'blood cell phenotype', 'nervous system morphology phenotype', 'multicellular organism', 'Abnormal male external genitalia morphology', 'male reproductive system morphology phenotype', 'number of anatomical enitites of type bone element phenotype', 'cornea scarring; corneal scarring', 'primary circulatory organ phenotype', 'hemolymphoid system', 'embryonic tissue phenotype', 'embryonic tissue morphology phenotype', 'absent anatomical entity in the multicellular organism', 'absent multicellular anatomical structure in the multicellular organism', 'shape of kidney phenotype', 'limb long bone morphology phenotype', 'myeloid cell', 'polydipsia', 'paired limb/fin segment phenotype', 'aplasia or hypoplasia of manual digit', 'neural groove phenotype', 'paired limb/fin skeleton phenotype', 'external genitalia morphology; external genitalia phenotype', 'anemia', 'decreased number of material anatomical entity', 'organ system subdivision', 'visual system phenotype', 'photoreceptor array phenotype', 'Bruising susceptibility', 'skeleton phenotype', 'choroidal blood vessel phenotype', 'Abnormal skeletal morphology', 'drinking behavior', 'lateral plate mesoderm', 'Abnormal upper limb bone morphology', 'metabolic process', 'bone of pectoral complex phenotype', 'simple eye', 'anatomical structure physiology phenotype', 'decreased number of anatomical entity', 'presumptive structure phenotype', 'non-material anatomical boundary', 'paired limb/fin segment', 'organelle', 'decreased length of anatomical structure', 'Abnormality of chromosome stability', 'photoreceptor array', 'Absent radius', 'absent bone of appendage girdle complex', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'testis', 'paired limb/fin bud phenotype', 'erythroid lineage cell morphology phenotype', 'lateral plate mesoderm morphology phenotype', 'orbital region', 'limb skeleton subdivision', 'blood vessel', 'hematopoietic system', 'pathological phenotype observation', 'Abnormal erythrocyte morphology', 'Phenotypic abnormality', 'anatomical conduit phenotype', 'Abnormality of limbs', 'absent anatomical structure in the skeletal system', 'radius bone morphology phenotype', 'biogenic amine secreting cell', 'absent skeletal element in the forelimb', 'absent limb endochondral element in the forelimb', 'posterior segment of eyeball', 'manual digit 1 phalanx endochondral element', 'number of anatomical enitites of type endochondral bone phenotype', 'kidney mesenchyme', 'organism subdivision phenotype', 'Hypogonadism', 'abdomen element phenotype', 'endochondral element phenotype', 'Neoplasm by anatomical site', 'agenesis of anatomical entity', 'skeleton', 'Hearing abnormality', 'absent bone of free limb or fin in the forelimb', 'enucleated reticulocyte morphology phenotype', 'Thrombocytopenia', 'absent multicellular anatomical structure in the skeletal system', 'cavitated compound organ', 'Aplasia involving forearm bones', 'kinesthetic behavior', 'arm', 'material anatomical entity physiology phenotype', 'absent forelimb long bone', 'limb', 'absent organ in the tissue', 'biological regulation', 'trunk phenotype', 'Abnormal cardiovascular system morphology', 'U-shaped kidney', 'limb endochondral element', 'cornea', 'multi-tissue structure', 'decreased length of autopodial extension', 'trunk', 'anlage phenotype', 'absent endochondral bone', 'Abnormal forebrain morphology', 'abdomen element', 'entire embryonic mesenchyme', 'absent forelimb endochondral element in the forelimb', 'anatomical structure development', 'Abnormality of the integument', 'Short digit', 'limb long bone phenotype', 'genitourinary system', 'Absent forearm bone', 'consumption behavior phenotype', 'bone of appendage girdle complex phenotype', 'ear', 'neurectoderm phenotype', 'male reproductive organ phenotype', 'vasculature phenotype', 'appendage', 'upper limb segment', 'arm bone', 'absent forelimb bone in the forelimb', 'neural groove', 'negative regulation of cellular process', 'Abnormality of the head', 'forelimb bud morphology phenotype', 'immune system', 'anatomical system phenotype', 'zeugopod', 'lateral plate mesoderm phenotype', 'anatomical entity phenotype', 'subdivision of skeleton', 'Abnormal axial skeleton morphology', 'central nervous system morphology phenotype', 'structure with developmental contribution from neural crest', 'material anatomical entity phenotype', 'pectoral appendage phenotype', 'Abnormal finger morphology', 'absent anatomical entity in the limb bud', 'decreased size of the multicellular anatomical structure', 'Duplication of bones involving the upper extremities', 'structure with developmental contribution from neural crest phenotype', 'compound organ phenotype', 'craniocervical region phenotype', 'neutrophil morphology phenotype', 'germ layer', 'eukaryotic cell', 'upper limb segment phenotype', 'delayed biological_process', 'acropodial skeleton', 'feeding behavior', 'immaterial entity', 'limb morphology phenotype', 'Abnormality of limb bone', 'developmental process', 'multi-limb segment region', 'macromolecule biosynthetic process', 'skeletal element', 'material anatomical entity mass phenotype', 'tunica fibrosa of eyeball', 'musculature of body phenotype', 'negative regulation of macromolecule metabolic process', 'absent material anatomical entity', 'tissue', 'primary metabolic process phenotype', 'digit 1 digitopodial skeleton', 'decreased functionality of the multicellular anatomical structure', 'anatomical collection phenotype', 'upper urinary tract', 'absent arm bone in the forelimb', 'interphase', 'absent long bone in the forelimb', 'mesenchyme morphology phenotype', 'shape of continuant phenotype', 'absent forelimb endochondral element in the limb', 'neural tube phenotype', 'decreased qualitatively biological_process', 'musculature of body', 'regulation of biological process phenotype', 'endochondral element', 'absent forelimb long bone in the forelimb', 'digit plus metapodial segment', 'decreased size of the digit', 'All', 'subdivision of head', 'forelimb endochondral element phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'multicellular organism phenotype', 'simple eye phenotype', 'platelet morphology', 'limb bud', 'erythroid lineage cell', 'limb bud morphology phenotype', 'absent endochondral bone in the forelimb', 'anatomical entity morphology phenotype', 'limb phenotype', 'embryonic tissue', 'brain', 'mesenchyme', 'central nervous system', 'pallor', 'Abnormal renal morphology', 'forelimb bone phenotype', 'anterior region of body', 'subdivision of head phenotype', 'skeletal system morphology phenotype', 'absent anatomical structure in the forelimb', 'epithelial tube phenotype', 'musculoskeletal system', 'regional part of nervous system', 'skeletal system', 'phalanx endochondral element', 'aplasia or hypoplasia of skeleton', 'number of anatomical enitites of type neutrophil phenotype', 'long bone', 'Abnormal localization of kidney', 'Abnormal heart morphology', 'neural plate', 'paired limb/fin bud', 'negative regulation of biosynthetic process', 'male reproductive organ morphology phenotype', 'decreased size of the sense organ', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'germ layer / neural crest phenotype', 'Aplasia/Hypoplasia of the radius', 'absent bone of pectoral complex', 'anatomical structure phenotype', 'absent limb bone in the forelimb', 'vessel', 'Aplasia/Hypoplasia involving the central nervous system', 'hematopoietic system phenotype', 'Abnormality of the skeletal system', 'number of anatomical enitites of type abdominal segment element phenotype', 'regulation of biological process', 'optic cup morphology phenotype', 'absent limb bone', 'absent multicellular anatomical structure in the tissue', 'testis phenotype', 'absent bone of appendage girdle complex in the forelimb', 'absent endochondral element in the limb', 'anatomical collection', 'absent limb endochondral element', 'sense organ phenotype', 'eye', 'anatomical line', 'neural plate morphology phenotype', 'decreased length of material anatomical entity', 'forelimb skeleton phenotype', 'absent lateral structure', 'Abnormal immune system morphology', 'Abnormal cellular physiology', 'negative regulation of biological process phenotype', 'male reproductive system phenotype', 'biological regulation phenotype', 'response to stimulus phenotype', 'cellular response to stress', 'response to stress phenotype', 'number of anatomical enitites of type abdomen element phenotype', 'Deficient excision of UV-induced pyrimidine dimers in DNA', 'DNA repair phenotype', 'DNA repair', 'size of anatomical entity phenotype', 'cellular response to stimulus phenotype', 'cellular response to stress phenotype', 'Pancytopenia', 'digit 1 or 5', 'radius bone', 'DNA damage response', 'Abnormality of the urinary system', 'number of leukocyte phenotype', 'primary metabolic process', 'nucleobase-containing compound metabolic process', 'material entity', 'absent material anatomical entity in the limb bud', 'Abnormality of DNA repair', 'intracellular organelle', 'anatomical line between pupils', 'DNA metabolic process phenotype', 'response to stress', 'cellular response to stimulus', 'Aplasia/hypoplasia involving bones of the extremities', 'decreased size of the organ', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'external male genitalia', 'external genitalia phenotype', 'number of anatomical enitites of type organism subdivision phenotype', 'normal growth on benomyl', 'Abnormal external genitalia morphology', 'location of anatomical entity phenotype', 'reproductive structure phenotype', 'Abnormal ear physiology', 'localised testis', 'optic vesicle phenotype', 'reproductive system', 'presumptive ectoderm', 'manual digit 1 phalanx', 'Abnormal testis morphology', 'opaque lens of camera-type eye', 'localised gonad', 'erythrocyte morphology phenotype', 'vascular system morphology phenotype', 'Abnormal morphology of the radius', 'reproductive organ phenotype', 'body part movement', 'localised male reproductive organ', 'renal collecting system', 'Abnormal reproductive system morphology', 'external male genitalia phenotype', 'Abnormal skin morphology', 'localised reproductive structure', 'Cryptorchidism', 'male organism phenotype', 'localised anatomical structure', 'reproductive system phenotype', 'Generalized abnormality of skin', 'gonad', 'surface structure', 'sense organ physiology phenotype', 'male reproductive organ', 'sensory perception of mechanical stimulus', 'external genitalia', 'localised material anatomical entity', 'localised compound organ', 'compound organ', 'primordium', 'viscus', 'absent long bone', 'Abnormality of the musculoskeletal system', 'Abnormality of the genital system', 'head morphology phenotype', 'Abnormality of globe size', 'musculature', 'mesoderm morphology phenotype', 'craniocervical region morphology phenotype', 'immature eye phenotype', 'limb bone', 'eye phenotype', 'dysesthesia; hyperalgesia', 'zone of skin', 'camera-type eye morphology phenotype', 'localised kidney', 'sensory system', 'axial skeleton plus cranial skeleton morphology phenotype', 'face', 'heart plus pericardium', 'aplasia or hypoplasia of eyeball of camera-type eye', 'vision/eye phenotype', 'decreased size of the anatomical entity', 'endocrine system', 'sensory system phenotype', 'neutrophil', 'immature eye', 'camera-type eye phenotype', 'entire sense organ system', 'disconnected anatomical group', 'Abnormality of multiple cell lineages in the bone marrow', 'unilaminar epithelium', 'taxon specific phenotype', 'gonad phenotype', 'digit 1 or 5 phenotype', 'decreased size of the material anatomical entity', 'Aplasia/hypoplasia involving bones of the hand', 'unilaminar epithelium phenotype', 'non-connected functional system', 'epithelial fold', 'bone of free limb or fin', 'camera-type eye', 'aplasia or hypoplasia of manual digit 1', 'eye primordium phenotype', 'Microphthalmia', 'optic choroid morphology phenotype', 'Puberty and gonadal disorders', 'Subcutaneous hemorrhage', 'absent organism subdivision', 'Abnormal eye morphology', 'organ part physiology phenotype', 'eye movement phenotype', 'limb bud phenotype', 'eyeball of camera-type eye phenotype', 'head', 'decreased size of the eyeball of camera-type eye', 'granulocyte morphology phenotype', 'skin of body phenotype', 'vessel physiology phenotype', 'blood vessel physiology phenotype', 'integument phenotype', 'vasculature of eye morphology phenotype', 'blood vasculature', 'appendage phenotype', 'vasculature of head', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'subdivision of skeletal system', 'mesenchyme derived from head neural crest', 'macula lutea morphology phenotype', 'tube phenotype', 'testis morphology phenotype', 'organ phenotype', 'integumental system phenotype', 'cellular_component phenotype', 'ribosome', 'skeletal element phenotype', 'optic choroid', 'reticulocyte', 'blood vessel phenotype', 'Abnormality of the vasculature', 'membraneless organelle', 'cellular_component function phenotype', 'skeleton of pectoral complex', 'vessel phenotype', 'neural crest morphology phenotype', 'Abnormality of blood and blood-forming tissues', 'transparent eye structure', 'Hypergonadotropic hypogonadism', 'cardiovascular system morphology phenotype', 'skin vasculature morphology; vascular skin abnormality', 'integumentary adnexa phenotype', 'negative regulation of metabolic process phenotype', 'paired limb/fin', 'limb segment', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'eye primordium', 'organ component layer phenotype', 'myeloid leukocyte phenotype', 'neural crest phenotype', 'vasculature', 'organ subunit', 'integumentary adnexa', 'musculoskeletal system phenotype', 'embryonic craniocervical region', 'migrating mesenchyme population phenotype', 'number of platelet phenotype', 'decreased number of granulocyte', 'epithelial fold phenotype', 'vasculature of head phenotype', 'absent endochondral element in the forelimb', 'retina phenotype', 'Duplicated collecting system', 'decreased number of erythrocyte', 'ectoderm morphology phenotype', 'neural crest', 'pectoral appendage', 'intracellular organelle function phenotype', 'choroidal blood vessel morphology phenotype', 'head blood vessel phenotype', 'vascular system', 'system process phenotype', 'nervous system phenotype', 'circulatory system', 'endochondral bone phenotype', 'autopod region', 'chorioretinal region', 'organ component layer', 'macula lutea', 'head blood vessel', 'absent compound organ', 'zone of skin morphology phenotype', 'zone of organ phenotype', 'skin of body morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'head mesenchyme morphology phenotype', 'decreased number of neutrophil', 'neural fold morphology phenotype', 'cellular anatomical structure', 'decreased size of the head', 'cranial neural crest', 'external ectoderm', 'absent anatomical entity', 'cornea morphology phenotype', 'ribosome function phenotype', 'decreased size of the manual digit', 'pathological entity', 'subcutaneous hemorrhage', 'absent radius bone', 'opaque anatomical entity', 'Duplication of thumb phalanx', 'growth', 'subdivision of organism along appendicular axis phenotype', 'Abnormality of the skin', 'neural fold phenotype', 'metabolic process phenotype', 'pathological anatomical entity', 'anatomical cluster', 'circulatory disorder', 'reproductive system physiology phenotype', 'eye movement', 'Abnormal conjugate eye movement', 'neural fold', 'digit morphology phenotype', 'uvea', 'skin of body', 'ecto-epithelium phenotype', 'retina morphology phenotype', 'autopod region phenotype', 'embryo morphology phenotype', 'germ layer / neural crest', 'ecchymosis', 'cornea phenotype', 'anatomical wall phenotype', 'vasculature of eye', 'cranial neural crest phenotype', 'connective tissue phenotype', 'Abnormality of the cell cycle', 'anterior segment of eyeball morphology phenotype', 'localised anatomical entity', 'Abnormal eye physiology', 'eye physiology phenotype', 'Abnormality of the kidney', 'digitopodium bone', 'absent multicellular anatomical structure in the forelimb', 'location of camera-type eye phenotype', 'Abnormality of the cardiovascular system', 'strabismus', 'Abnormal granulocyte count', 'neural crest-derived structure', 'organ physiology phenotype', 'simple eye physiology phenotype', 'cellular process phenotype', 'structure with developmental contribution from neural crest physiology phenotype', 'uvea morphology phenotype', 'ectoderm-derived structure physiology phenotype', 'anterior segment of eyeball', 'ocular surface region', 'endocrine system phenotype', 'lens of camera-type eye', 'neural tube morphology phenotype', 'transparent eye structure phenotype', 'aplastic anatomical entity', 'Abnormal reticulocyte morphology', 'absent radius endochondral element in the forelimb', 'absent lateral structure in the renal system', 'size of skull phenotype', 'number of anatomical enitites of type compound organ phenotype', 'mesoderm phenotype', 'number of anatomical enitites of type kidney phenotype', 'absent kidney', 'absent multicellular anatomical structure in the renal system', 'Leukemia', 'craniocervical region', 'number of anatomical enitites of type lateral structure phenotype', 'absent compound organ in the renal system', 'G2 phase', 'regulation of biosynthetic process phenotype', 'nucleobase-containing compound metabolic process phenotype', 'Microcephaly', 'craniofacial/craniocervical phenotype', 'absent anatomical structure in the renal system', 'Renal agenesis', 'absent bone of appendage girdle complex in the limb', 'absent trunk region element in the multicellular organism', 'regulation of gene expression', 'absent material anatomical entity in the renal system', 'absent abdominal segment element', 'absent cavitated compound organ in the renal system', 'absent abdominal segment element in the renal system', 'decreased sensory perception of mechanical stimulus', 'absent anatomical entity in the renal system', 'decreased functionality of the anatomical structure', 'absent trunk region element in the renal system', 'number of anatomical enitites of type cavitated compound organ phenotype', 'Abnormal finger phalanx morphology', 'decreased height of the multicellular organism', 'decreased material anatomical entity mass', 'Complete duplication of phalanx of hand', 'myeloid leukocyte morphology', 'superficial fascia', 'posterior segment of eyeball morphology phenotype', 'anatomical entity morphology in the manus phenotype', 'absent organ in the forelimb', 'autopodial extension phenotype', 'manus phenotype', 'Duplication of hand bones', 'number of anatomical enitites of type anatomical structure phenotype', 'optic cup', 'absent abdomen element in the renal system', 'digit 1 phenotype', 'manual digit digitopodial skeleton', 'skeleton of manual acropodium', 'Abnormal hand morphology', 'manus', 'embryonic autopod plate morphology phenotype', 'manual digit 1 morphology phenotype', 'manual digit 1 plus metapodial segment', 'Complete duplication of thumb phalanx', 'decreased length of anatomical entity', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'macromolecule metabolic process phenotype', 'Abnormal digit morphology', 'lateral structure physiology phenotype', 'manual digit 1', 'ecto-epithelium', 'bone cell', 'autopod bone', 'manual digit phalanx endochondral element', 'anatomical wall', 'manual digit 1 digitopodial skeleton', 'ocular surface region morphology phenotype', 'Abnormality of thumb phalanx', 'manual digitopodium region', 'Vascular skin abnormality', 'manual digitopodium bone', 'musculature phenotype', 'digit 1', 'autopod endochondral element', 'digit', 'Abnormality of the hand', 'embryonic autopod plate', 'phenotypic effect', 'cell cycle', 'cell cycle phase', 'limb endochondral element phenotype', 'Abnormality of the immune system', 'Abnormal leukocyte count', 'absent autopodial extension', 'anisocytosis', 'Abnormal granulocyte morphology', 'granulocyte', 'response to stimulus', 'Decreased total neutrophil count', 'negative regulation of metabolic process', 'Abnormal leukocyte morphology', 'long bone phenotype', 'motile cell', 'nucleate cell', 'neutrophil phenotype', 'decreased number of leukocyte', 'Abnormal total neutrophil count', 'biological_process', 'immune system morphology phenotype', 'limb segment phenotype', 'metabolic acidosis', 'Abnormal bone marrow cell morphology', 'serotonin secreting cell', 'optic vesicle', 'pancytopenia', 'decreased size of the autopodial extension', 'Short thumb', 'anatomical entity length phenotype', 'bone marrow cell', 'decreased length of digit 1 or 5', 'glandular system', 'head blood vessel morphology phenotype', 'decreased length of organism subdivision', 'decreased length of manual digit', 'decreased size of the organism subdivision', 'acropodium region', 'decreased length of manual digit 1 or 5', 'decreased length of manual digit 1', 'concave 3-D shape anatomical entity', 'decreased length of multicellular anatomical structure', 'postcranial axial skeletal system', 'decreased length of digit 1', 'decreased size of the anatomical structure in the pectoral complex', 'Decreased body weight', 'Aplasia/Hypoplasia of fingers', 'decreased size of the material anatomical entity in the pectoral complex', 'anatomical entity height phenotype', 'decreased functionality of the organ', 'Abnormality of reproductive system physiology', 'decreased functionality of the anatomical entity', 'reproductive organ physiology phenotype', 'reproductive structure physiology phenotype', 'decreased functionality of the reproductive structure', 'socially cooperative development', 'skeleton of limb', 'organ system subdivision phenotype', 'gonad physiology phenotype', 'external ectoderm morphology phenotype', 'decreased functionality of the reproductive organ', 'Abnormal skull morphology', 'thoracic segment organ phenotype', 'cardiovascular system', 'Abnormal brain morphology', 'localised lateral structure', 'nucleic acid metabolic process', 'Abnormal nervous system morphology', 'Aplasia/Hypoplasia of the cerebrum', 'Abnormal cerebral morphology', 'multicellular organism mass phenotype', 'Abnormality of skull size', 'axial skeletal system', 'skull', 'anterior neural tube', 'skull phenotype', 'mesenchyme phenotype', 'size of head phenotype', 'head mesenchyme phenotype', 'axial skeleton plus cranial skeleton', 'blood cell', 'postcranial axial skeleton', 'head mesenchyme', 'heart phenotype', 'heart morphology phenotype', 'circulatory organ', 'Aplasia/hypoplasia involving the skeleton', 'thoracic cavity element phenotype', 'circulatory organ phenotype', 'primary circulatory organ', 'heart', 'male reproductive system', 'thoracic segment of trunk', 'localised cavitated compound organ', 'viscus phenotype', 'Ectopic kidney', 'reproductive system morphology phenotype', 'localised abdominal segment element'], 'has_descendant': ['MONDO:0010953'], 'has_descendant_label': ['Fanconi anemia complementation group E'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0001083', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome', 'description': 'A genetic or acquired disorder characterized by impairment of the function of the proximal tubules of the kidney. It results in decreased reabsorption of electrolytes, glucose, amino acids, and other nutrients.', 'xref': ['DOID:1062', 'GARD:9120', 'MEDGEN:4653', 'MESH:D005198', 'NANDO:2100027', 'NANDO:2200187', 'NCIT:C3034', 'SCTID:236466005', 'SCTID:40488004', 'UMLS:C0015624'], 'synonym': ['De toni-Fanconi syndrome', 'De toni-debre-Fanconi syndrome', 'Fanconi syndrome', "Fanconi's syndrome", 'Fanconi-de toni syndrome', 'Fanconi-de-toni syndrome', 'Lignac-Fanconi syndrome', 'adult Fanconi syndrome', 'congenital Fanconi syndrome', 'deToni Fanconi syndrome', 'infantile nephropathic cystinosis', 'toni-debre-Fanconi syndrome'], 'exact_synonym': ['De toni-Fanconi syndrome', 'De toni-debre-Fanconi syndrome', 'Fanconi syndrome', "Fanconi's syndrome", 'Fanconi-de toni syndrome', 'Fanconi-de-toni syndrome', 'Lignac-Fanconi syndrome', 'deToni Fanconi syndrome'], 'narrow_synonym': ['adult Fanconi syndrome', 'congenital Fanconi syndrome'], 'related_synonym': ['infantile nephropathic cystinosis', 'toni-debre-Fanconi syndrome'], 'subsets': ['gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:0060778', 'MONDO:0024525', 'MONDO:0013247', 'MONDO:0007600', 'MONDO:0014275', 'MONDO:0001083', 'MONDO:0014458', 'MONDO:0030056', 'MONDO:0022948', 'MONDO:0060779', 'MONDO:0100238', 'MONDO:0060781'], 'has_descendant_label': ['adult Fanconi syndrome', 'Fanconi renotubular syndrome 1', 'Fanconi renotubular syndrome 2', 'primary Fanconi syndrome', 'Fanconi renotubular syndrome 3', 'Fanconi renotubular syndrome', 'Fanconi renotubular syndrome 4 with maturity-onset diabetes of the young', 'Fanconi renotubular syndrome 5', 'Deal Barratt Dillon syndrome', 'acquired Fanconi syndrome', 'inherited Fanconi renotubular syndrome', 'Preeyasombat-Varavithya syndrome'], 'has_descendant_count': 12, 'highlighting': None}, {'id': 'MONDO:0019391', 'category': 'biolink:Disease', 'name': 'Fanconi anemia', 'description': 'Fanconi anemia (FA) is a hereditary DNA repair disorder characterized by progressive pancytopenia with bone marrow failure, variable congenital malformations and predisposition to develop hematological or solid tumors.', 'xref': ['DOID:13636', 'GARD:6425', 'ICD9:284.09', 'MEDGEN:41967', 'MESH:D005199', 'MedDRA:10055206', 'NANDO:1200303', 'NANDO:1200891', 'NANDO:2200652', 'NCIT:C62505', 'NORD:1132', 'OMIMPS:227650', 'Orphanet:84', 'SCTID:30575002', 'UMLS:C0015625'], 'synonym': ['Fanconi anemia', 'Fanconi pancytopenia', 'Fanconi panmyelopathy', "Fanconi's anaemia", "Fanconi's anemia", 'Panmyelopathy, Fanconi', 'pancytopenia, congenital', 'primary erythroid hypoplasia'], 'exact_synonym': ['Fanconi anemia', 'Fanconi pancytopenia', 'Fanconi panmyelopathy', "Fanconi's anaemia", "Fanconi's anemia", 'Panmyelopathy, Fanconi', 'pancytopenia, congenital', 'primary erythroid hypoplasia'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'ordo_disorder', 'ordo_malformation_syndrome', 'orphanet_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0002827', 'HP:0001511', 'HP:0000504', 'HP:0008053', 'HP:0001537', 'HP:0003220', 'HP:0001249', 'HP:0000453', 'HP:0000047', 'HP:0001824', 'HP:0000813', 'HP:0001882', 'HP:0001199', 'HP:0004209', 'HP:0000486', 'HP:0001873', 'HP:0006101', 'HP:0100026', 'HP:0001679', 'HP:0002863', 'HP:0000568', 'HP:0000079', 'HP:0004322', 'HP:0001000', 'HP:0002007', 'HP:0000027', 'HP:0000364', 'HP:0006265', 'HP:0001871', 'HP:0100867', 'HP:0000028', 'HP:0001263', 'HP:0000268', 'HP:0002817', 'HP:0001636', 'HP:0000508', 'HP:0002414', 'HP:0001639', 'HP:0010293', 'HP:0000324', 'HP:0001903', 'HP:0004349', 'HP:0000218', 'HP:0001562', 'HP:0100760', 'HP:0008678', 'HP:0007874', 'HP:0001760', 'HP:0000483', 'HP:0000252', 'HP:0005344', 'HP:0002251', 'HP:0002245', 'HP:0000864', 'HP:0012745', 'HP:0000130', 'HP:0010469', 'HP:0000377', 'HP:0007565', 'HP:0100587', 'HP:0006501', 'HP:0001643', 'HP:0001631', 'HP:0000035', 'HP:0000286', 'HP:0000083', 'HP:0001510', 'HP:0000347', 'HP:0012639', 'HP:0000072', 'HP:0100542', 'HP:0000518', 'HP:0001671', 'HP:0006824', 'HP:0003022', 'HP:0000238', 'HP:0000175', 'HP:0002119', 'HP:0000478', 'HP:0000010', 'HP:0000492', 'HP:0000582', 'HP:0002023', 'HP:0002650', 'HP:0001770', 'HP:0000340', 'HP:0012041', 'HP:0005522', 'HP:0001763', 'HP:0001172', 'HP:0002823', 'HP:0000639', 'HP:0040071', 'HP:0012210', 'HP:0000135', 'HP:0001053', 'HP:0000316', 'HP:0001347', 'HP:0007400', 'HP:0001646', 'HP:0002575', 'HP:0001392', 'HP:0000520', 'HP:0002664', 'HP:0000505', 'HP:0000365'], 'has_phenotype_label': ['Cryptorchidism', 'Oligohydramnios', 'Abnormal preputium morphology', 'Anal atresia', 'Aganglionic megacolon', 'Abnormal thumb morphology', 'Abnormality of the upper limb', 'Abnormality of vision', 'Abnormal aortic valve morphology', 'Abnormality of the eye', 'Upslanted palpebral fissure', 'Facial asymmetry', 'Intellectual disability', 'Hypoplasia of the ulna', 'Intrauterine growth retardation', 'Hydrocephalus', 'Microcephaly', 'Renal hypoplasia/aplasia', 'Hypospadias', 'Arteriovenous malformation', 'Bicornuate uterus', 'Abnormal aortic morphology', 'Aplasia/Hypoplasia of the uvula', 'Clinodactyly of the 5th finger', 'Hip dislocation', 'High palate', 'Short stature', 'Anemia', 'Scoliosis', 'Abnormal renal morphology', 'Choanal atresia', 'Abnormal localization of kidney', 'Weight loss', 'Hearing abnormality', 'Growth delay', 'Abnormality of the hypothalamus-pituitary axis', 'Duodenal stenosis', 'Strabismus', 'Hydroureter', 'Cranial nerve paralysis', 'Spina bifida', 'Ptosis', 'Pyridoxine-responsive sideroblastic anemia', 'Hypogonadism', 'Azoospermia', 'Visual impairment', 'Abnormal testis morphology', 'Abnormality of chromosome stability', 'Meckel diverticulum', 'Global developmental delay', 'Cataract', 'Hearing impairment', 'Tetralogy of Fallot', 'Hyperreflexia', 'Abnormality of skin pigmentation', 'Pes planus', 'Aplasia/Hypoplasia of fingers', 'Abnormality of the uterus', 'Myelodysplasia', 'Micrognathia', 'Frontal bossing', 'Aplasia/Hypoplasia of the radius', 'Atrial septal defect', 'Abnormal cardiac septum morphology', 'Cleft palate', 'Decreased fertility in males', 'Recurrent urinary tract infections', 'Triphalangeal thumb', 'Abnormal morphology of ulna', 'Proptosis', 'Thrombocytopenia', 'Hypopigmented skin patches', 'Epicanthus', 'Renal insufficiency', 'Hypertelorism', 'Abnormality of the urinary system', 'Neoplasm', 'Dolichocephaly', 'Hypertrophic cardiomyopathy', 'Astigmatism', 'Abnormality of blood and blood-forming tissues', 'Nystagmus', 'Abnormal pinna morphology', 'Umbilical hernia', 'Reduced bone mineral density', 'Abnormal nervous system morphology', 'Finger syndactyly', 'Abnormal femur morphology', 'Multiple cafe-au-lait spots', 'Patent ductus arteriosus', 'Toe syndactyly', 'Abnormal foot morphology', 'Sloping forehead', 'Decreased total leukocyte count', 'Short palpebral fissure', 'Abnormal carotid artery morphology', 'Abnormal eyelid morphology', 'Clubbing of toes', 'Irregular hyperpigmentation', 'Tracheoesophageal fistula', 'Ventriculomegaly', 'Absent testis', 'Abnormality of the liver', 'Aplasia/Hypoplasia of the iris', 'Almond-shaped palpebral fissure', 'Microphthalmia'], 'has_phenotype_count': 106, 'has_phenotype_closure': ['UPHENO:0002427', 'UPHENO:0002411', 'UPHENO:0063524', 'UPHENO:0063519', 'UPHENO:0063518', 'UPHENO:0063513', 'UBERON:0036302', 'UPHENO:0003391', 'UPHENO:0015184', 'UPHENO:0014865', 'UPHENO:0056251', 'UPHENO:0056333', 'UPHENO:0056158', 'UPHENO:0075877', 'UPHENO:0056149', 'HP:0000238', 'UPHENO:0014351', 'UPHENO:0056242', 'UPHENO:0085938', 'UPHENO:0072263', 'UBERON:0001712', 'UBERON:0000014', 'UPHENO:0072332', 'UPHENO:0072315', 'UPHENO:0087928', 'UBERON:0000076', 'UPHENO:0001231', 'UPHENO:0072355', 'HP:0000286', 'UPHENO:0072415', 'UPHENO:0072212', 'UPHENO:0031179', 'UPHENO:0031144', 'UPHENO:0031228', 'UPHENO:0001217', 'UPHENO:0001227', 'UPHENO:0031226', 'UPHENO:0001519', 'UPHENO:0001187', 'UPHENO:0031123', 'UPHENO:0041037', 'UPHENO:0001025', 'UPHENO:0031129', 'UPHENO:0041395', 'HP:0011563', 'UPHENO:0077800', 'UPHENO:0004724', 'UPHENO:0002802', 'UPHENO:7000168', 'UPHENO:0067030', 'UPHENO:0054374', 'HP:0004323', 'UPHENO:0082794', 'UBERON:1000021', 'UPHENO:0010808', 'UPHENO:0010763', 'HP:0001824', 'UPHENO:0054304', 'UPHENO:0054315', 'UPHENO:0002904', 'UPHENO:7000916', 'UBERON:0001359', 'HP:0410043', 'UBERON:0000344', 'UBERON:0005863', 'UPHENO:0002646', 'UBERON:0002412', 'UPHENO:0081609', 'UBERON:0001199', 'UPHENO:0033628', 'UBERON:0010358', 'UBERON:0007844', 'UBERON:0005174', 'UBERON:0001137', 'UPHENO:0003112', 'UPHENO:0002959', 'UPHENO:7001123', 'UPHENO:0033562', 'UBERON:0000328', 'UPHENO:0076744', 'UPHENO:0086958', 'UPHENO:0002688', 'UBERON:0010039', 'UPHENO:0085534', 'UPHENO:0085538', 'UPHENO:0014291', 'UBERON:0000162', 'UPHENO:0002824', 'UBERON:0035651', 'UBERON:0012241', 'UPHENO:7000052', 'UBERON:0001333', 'UBERON:0005629', 'UPHENO:7000305', 'UPHENO:0087424', 'UPHENO:0084004', 'UPHENO:0087871', 'GO:0005694', 'UPHENO:7000141', 'HP:0032076', 'UPHENO:0006889', 'UBERON:0001556', 'UPHENO:0005513', 'UPHENO:0005512', 'UPHENO:0052231', 'GO:0050954', 'UPHENO:0050625', 'UPHENO:0052970', 'UPHENO:0067095', 'UPHENO:0069523', 'HP:0000568', 'UPHENO:0075219', 'UPHENO:0052694', 'UPHENO:0002927', 'UPHENO:0050034', 'UPHENO:0005642', 'UPHENO:0080393', 'UBERON:0005913', 'UBERON:0010719', 'UPHENO:0076767', 'UBERON:0007828', 'UPHENO:0081608', 'UPHENO:0002766', 'UPHENO:0002728', 'UPHENO:0076728', 'HP:0003272', 'UBERON:0000982', 'UBERON:0011107', 'UPHENO:0086091', 'HP:0001384', 'UPHENO:0075871', 'UBERON:0008114', 'UBERON:0003657', 'UBERON:0007832', 'UPHENO:0081584', 'UPHENO:0086100', 'UBERON:0001464', 'UBERON:0001271', 'UBERON:0001272', 'HP:0002827', 'UPHENO:0003376', 'UBERON:0003463', 'UPHENO:0046405', 'UPHENO:0069292', 'UPHENO:0069163', 'UPHENO:0046397', 'UPHENO:0085968', 'UPHENO:0046554', 'HP:0006495', 'UPHENO:0079872', 'UPHENO:0069047', 'UPHENO:0046392', 'UPHENO:0046479', 'UPHENO:0069194', 'UPHENO:0081344', 'HP:0030311', 'UPHENO:0046538', 'UPHENO:0046465', 'UPHENO:0069125', 'UPHENO:0031206', 'UPHENO:0069064', 'UPHENO:0069030', 'UPHENO:0012274', 'UPHENO:0046460', 'UPHENO:0075943', 'HP:0003022', 'UPHENO:0046540', 'UBERON:0000122', 'UPHENO:0004508', 'UPHENO:0081709', 'UPHENO:0081700', 'UPHENO:0004142', 'HP:0031910', 'HP:0007874', 'UPHENO:0041462', 'HP:0000268', 'HP:0000517', 'UPHENO:0084815', 'HP:0000518', 'UBERON:0000965', 'UPHENO:0004765', 'UPHENO:0078246', 'HP:0001770', 'UPHENO:0078375', 'UPHENO:0078347', 'UBERON:0012240', 'HP:0100542', 'HP:0001053', 'UPHENO:0077874', 'UPHENO:0077877', 'UBERON:0010377', 'UBERON:0005726', 'UPHENO:0086610', 'UBERON:0005725', 'UPHENO:0002711', 'UPHENO:0063588', 'UPHENO:0003395', 'GO:0007600', 'UPHENO:0052164', 'UPHENO:0050620', 'UPHENO:0052160', 'UPHENO:0050236', 'HP:0009826', 'HP:0000504', 'UPHENO:0004470', 'UPHENO:0087894', 'UBERON:0003826', 'UPHENO:0003584', 'UBERON:0000376', 'UBERON:0015052', 'UBERON:0005893', 'HP:0000083', 'HP:0002823', 'UPHENO:0046396', 'UPHENO:0078267', 'UPHENO:0078215', 'UPHENO:0078288', 'UPHENO:0078125', 'UPHENO:0078159', 'CL:0000457', 'UPHENO:0077391', 'UPHENO:0086173', 'UBERON:0010418', 'HP:0009821', 'UPHENO:7000590', 'CL:0000458', 'UPHENO:0075213', 'UPHENO:7000599', 'CL:0000225', 'CL:0000151', 'UPHENO:0001447', 'UBERON:0005179', 'UPHENO:7000351', 'UPHENO:0001019', 'HP:0000072', 'UPHENO:0063529', 'UPHENO:0001439', 'UPHENO:0002806', 'UPHENO:0001174', 'UPHENO:0076780', 'UBERON:0006555', 'HP:0011994', 'UPHENO:0033559', 'UPHENO:0002740', 'UPHENO:7000601', 'HP:0000415', 'UBERON:0002099', 'UPHENO:0003815', 'UPHENO:0002456', 'UPHENO:0033607', 'UBERON:0003037', 'HP:0005120', 'UBERON:0002081', 'UPHENO:0033596', 'UPHENO:7000198', 'UPHENO:0086857', 'UPHENO:0086863', 'HP:0001631', 'UPHENO:0083162', 'GO:0051703', 'UPHENO:0050068', 'UPHENO:0041079', 'HP:0001263', 'UPHENO:0014761', 'UPHENO:0000508', 'UPHENO:0083046', 'GO:0048232', 'GO:0019953', 'GO:0003006', 'UPHENO:0078081', 'UPHENO:0005592', 'UPHENO:0005651', 'HP:0012874', 'UPHENO:0080011', 'UPHENO:0046484', 'UPHENO:0049701', 'UPHENO:0053500', 'HP:0000025', 'GO:0005634', 'UPHENO:0078452', 'CL:0000015', 'CL:0000408', 'UPHENO:0085875', 'UBERON:0001968', 'UPHENO:0002599', 'UBERON:0004054', 'UPHENO:0053298', 'UPHENO:0012312', 'UPHENO:0002321', 'CL:0000039', 'UPHENO:0080382', 'UPHENO:0052965', 'UPHENO:0086201', 'UPHENO:0077404', 'UPHENO:0066925', 'HP:0001638', 'GO:0099120', 'UPHENO:0066945', 'UPHENO:0031142', 'HP:0000135', 'UPHENO:0024906', 'UPHENO:0002323', 'GO:0050890', 'HP:0012759', 'GO:0043232', 'HP:0001249', 'HP:0011446', 'UPHENO:0002869', 'HP:0011603', 'UBERON:0006876', 'UBERON:0002201', 'UPHENO:0015277', 'HP:0025633', 'UPHENO:0033603', 'UPHENO:0033579', 'UPHENO:0015281', 'UPHENO:0015331', 'UBERON:0018674', 'UPHENO:0033580', 'UPHENO:0005069', 'UPHENO:0005134', 'UPHENO:0087309', 'UPHENO:0087018', 'UBERON:0011695', 'HP:0001159', 'UPHENO:0033581', 'UBERON:0005985', 'HP:0001549', 'UPHENO:0049985', 'UPHENO:0049940', 'HP:0002245', 'UBERON:0002472', 'GO:0009792', 'GO:0007275', 'UPHENO:0051077', 'UPHENO:0076773', 'UBERON:0000011', 'UPHENO:0004487', 'UPHENO:0002790', 'UPHENO:0001342', 'UPHENO:0084121', 'HP:0004362', 'UPHENO:0087058', 'UBERON:0000045', 'UPHENO:0066902', 'UPHENO:0086997', 'UPHENO:0002941', 'UBERON:0004907', 'UBERON:0001046', 'HP:0001367', 'GO:0060562', 'GO:0002009', 'GO:0016331', 'GO:0072175', 'GO:0021915', 'UBERON:0000010', 'GO:0035148', 'GO:0048731', 'GO:0009888', 'UBERON:0001808', 'UPHENO:0003979', 'HP:6000852', 'GO:0001843', 'GO:0001838', 'UPHENO:0001031', 'UPHENO:0081436', 'UPHENO:0050108', 'UPHENO:0005046', 'UPHENO:0005116', 'UBERON:0000059', 'UPHENO:0067694', 'HP:0006824', 'UPHENO:7000670', 'HP:0010935', 'UPHENO:0076779', 'UPHENO:0087427', 'UPHENO:0075902', 'UPHENO:0002467', 'UBERON:0011143', 'UPHENO:0005433', 'UPHENO:0002909', 'UPHENO:0003571', 'HP:0012210', 'HP:0000077', 'UBERON:0000163', 'UPHENO:0002803', 'HP:0006501', 'UPHENO:0076754', 'HP:0006503', 'UPHENO:0046455', 'UPHENO:0075944', 'UBERON:0000057', 'UBERON:0001423', 'UPHENO:0002967', 'UBERON:0007530', 'UPHENO:0002558', 'UBERON:0003089', 'UPHENO:0086480', 'UBERON:0001486', 'HP:0010674', 'UPHENO:0086505', 'UPHENO:0002527', 'HP:0002650', 'UBERON:0005856', 'UPHENO:0004969', 'HP:0000925', 'UPHENO:0046531', 'HP:0000520', 'UPHENO:0041098', 'UPHENO:0041203', 'UBERON:0000956', 'UPHENO:0076695', 'UPHENO:7000389', 'UBERON:0011215', 'UBERON:0022303', 'UPHENO:0084465', 'HP:0011218', 'UBERON:0002116', 'UBERON:0004339', 'UBERON:0000209', 'UBERON:0011164', 'UPHENO:0087214', 'UBERON:0010428', 'UPHENO:0003098', 'UPHENO:0063621', 'HP:0025028', 'UPHENO:0004149', 'UPHENO:0003052', 'HP:0430000', 'UPHENO:0033609', 'UPHENO:0081603', 'UPHENO:0033573', 'HP:0000290', 'UBERON:0008200', 'HP:0002683', 'UPHENO:0002700', 'UPHENO:0076748', 'UPHENO:0002730', 'UBERON:0004766', 'UBERON:0001950', 'UBERON:0001703', 'UBERON:0005253', 'UPHENO:0003103', 'UPHENO:0087531', 'UPHENO:0002820', 'UPHENO:0014240', 'CL:0000233', 'HP:0008373', 'UPHENO:0041369', 'UPHENO:0082900', 'HP:0002007', 'UBERON:0001869', 'UPHENO:0088115', 'UBERON:0016529', 'UBERON:0003128', 'UPHENO:0002985', 'HP:0100491', 'UPHENO:0004143', 'UBERON:0003528', 'UPHENO:0063599', 'HP:0034915', 'UPHENO:0063577', 'UPHENO:0086644', 'HP:0004378', 'UBERON:0005389', 'UPHENO:0063565', 'UBERON:0013766', 'UPHENO:0002839', 'UPHENO:0001369', 'UBERON:0001245', 'UPHENO:0074230', 'GO:0001503', 'GO:0048646', 'CL:0000842', 'UPHENO:0082834', 'UPHENO:0082835', 'UPHENO:0085602', 'UPHENO:0056230', 'CL:0000226', 'UPHENO:0002270', 'HP:0003026', 'UPHENO:7000414', 'CL:0000945', 'UPHENO:0085578', 'CL:0000236', 'UPHENO:0003184', 'UPHENO:0085566', 'HP:0004349', 'CL:0000542', 'UPHENO:0085616', 'UPHENO:0002281', 'UPHENO:0004764', 'UPHENO:7000169', 'UPHENO:0018418', 'UPHENO:7000365', 'HP:0000486', 'UPHENO:0002785', 'UPHENO:0002719', 'UPHENO:0084816', 'UPHENO:0087349', 'UBERON:0003466', 'UPHENO:0002751', 'UPHENO:0004595', 'UPHENO:0002594', 'UBERON:0002085', 'UBERON:0010703', 'UPHENO:0002377', 'UBERON:0015003', 'UPHENO:0005573', 'HP:0011314', 'HP:0040071', 'HP:0040072', 'UPHENO:0002738', 'UPHENO:0052165', 'UBERON:0001424', 'UPHENO:0050101', 'UBERON:0003460', 'UPHENO:0002651', 'UPHENO:0075915', 'HP:0100026', 'HP:0000036', 'UBERON:0012361', 'UPHENO:0078729', 'UBERON:0034929', 'UPHENO:0087905', 'UPHENO:0002813', 'UPHENO:0086965', 'UBERON:0009196', 'UBERON:0012292', 'UBERON:0009142', 'UBERON:0000989', 'UBERON:0011374', 'UPHENO:0002569', 'UPHENO:0052178', 'HP:0002270', 'UPHENO:0004596', 'UPHENO:0086628', 'UBERON:5001466', 'UPHENO:0002758', 'UPHENO:0005597', 'HP:0010161', 'UPHENO:0066905', 'UPHENO:0063596', 'HP:0001780', 'UPHENO:0086956', 'HP:0009824', 'UPHENO:0001347', 'UBERON:0015022', 'UPHENO:0063562', 'UBERON:0010742', 'GO:0048598', 'UPHENO:0087369', 'UBERON:0012359', 'UBERON:0012142', 'UPHENO:0002992', 'UBERON:0001449', 'UPHENO:0002917', 'UBERON:0001441', 'UPHENO:0003110', 'UBERON:0012180', 'HP:0000539', 'UBERON:0010696', 'UBERON:0012152', 'HP:0001760', 'UPHENO:0066903', 'UBERON:0002387', 'UBERON:0003608', 'UPHENO:0002750', 'UPHENO:0002585', 'UBERON:0001466', 'UPHENO:0002969', 'UPHENO:0002716', 'UBERON:0001445', 'UPHENO:0003411', 'UPHENO:0080185', 'UPHENO:0002856', 'UPHENO:0002601', 'UPHENO:0002883', 'UPHENO:0002697', 'UBERON:0005899', 'UBERON:0012476', 'UBERON:0005420', 'UBERON:0001870', 'UBERON:0002471', 'UBERON:0010709', 'UPHENO:0002292', 'UBERON:0004709', 'HP:0100760', 'HP:0008678', 'UPHENO:0041212', 'UPHENO:0076806', 'UPHENO:0004456', 'UBERON:0005418', 'UBERON:0002103', 'UPHENO:0087422', 'HP:0001217', 'HP:0003220', 'GO:0007601', 'UPHENO:0049904', 'HP:0004322', 'UPHENO:0069254', 'HP:0001873', 'UPHENO:0080352', 'UPHENO:0080351', 'UPHENO:0081423', 'GO:0030097', 'NBO:0001845', 'UPHENO:0087858', 'UPHENO:0002638', 'GO:0048856', 'GO:0002262', 'GO:0035239', 'GO:0048869', 'GO:0022414', 'GO:0048871', 'CL:0000232', 'GO:0032502', 'GO:0009987', 'UPHENO:0005508', 'GO:0042592', 'HP:0001877', 'HP:0005522', 'HP:0045005', 'GO:0034101', 'GO:0030154', 'GO:0048468', 'GO:0007631', 'UBERON:0003828', 'GO:0048872', 'UPHENO:0001252', 'UPHENO:0002968', 'HP:0001903', 'GO:0030218', 'HP:0000483', 'UPHENO:0087339', 'UPHENO:0084729', 'HP:0000324', 'HP:0100627', 'HP:0000365', 'UBERON:0000056', 'HP:0200006', 'HP:0000582', 'HP:0001636', 'UPHENO:0033616', 'UBERON:0003697', 'UBERON:0007118', 'UBERON:0002384', 'HP:0004299', 'UBERON:0007779', 'UPHENO:0087577', 'UPHENO:0033610', 'UPHENO:0014971', 'UPHENO:0076722', 'UPHENO:0033615', 'HP:0003549', 'UPHENO:0002755', 'UBERON:0008202', 'UPHENO:0086122', 'HP:0100790', 'UBERON:0000154', 'HP:0010866', 'HP:0012758', 'UBERON:0005401', 'UPHENO:0075843', 'UBERON:0016887', 'HP:0005105', 'UPHENO:0085876', 'UPHENO:0076794', 'UPHENO:0075872', 'UBERON:0007823', 'UPHENO:0081313', 'UPHENO:0086116', 'UPHENO:0041664', 'UPHENO:0051003', 'UBERON:0000489', 'HP:0004298', 'UPHENO:0005071', 'UBERON:0005445', 'HP:0009179', 'UPHENO:0076736', 'UBERON:5006052', 'UPHENO:0005982', 'UPHENO:0086150', 'UBERON:0011585', 'UPHENO:0003191', 'UPHENO:0080369', 'HP:0004097', 'HP:0004209', 'UPHENO:0084834', 'UPHENO:0086143', 'UPHENO:0084842', 'UPHENO:0049970', 'HP:0004207', 'HP:0030084', 'HP:0007565', 'UPHENO:0010799', 'HP:0001034', 'UPHENO:0001427', 'HP:0011355', 'UPHENO:0012308', 'UPHENO:0087548', 'HP:0000957', 'UBERON:0001769', 'UPHENO:0076804', 'CL:0000300', 'UPHENO:0071332', 'UBERON:0000063', 'UBERON:0001801', 'GO:0014020', 'UBERON:0035133', 'UPHENO:7000311', 'UPHENO:0071317', 'UBERON:0011892', 'UBERON:0001768', 'HP:0008062', 'UPHENO:0080202', 'UPHENO:0041591', 'UBERON:0006311', 'HP:0008056', 'HP:0007700', 'UBERON:0001766', 'UPHENO:0002765', 'UPHENO:0076781', 'UPHENO:0076957', 'UPHENO:0076941', 'HP:0000553', 'UPHENO:0080201', 'UPHENO:0080209', 'UPHENO:0071334', 'HP:0000525', 'UPHENO:0063527', 'UBERON:0001691', 'HP:0000598', 'HP:0000356', 'UBERON:0001690', 'UPHENO:0086699', 'HP:0000377', 'GO:0005575', 'UPHENO:0003412', 'UBERON:0000003', 'UPHENO:0076730', 'HP:0001639', 'HP:0031703', 'UPHENO:0088088', 'UPHENO:0087403', 'HP:0010293', 'HP:0001872', 'UBERON:0003277', 'UBERON:0001734', 'UBERON:0005868', 'UPHENO:0001044', 'UPHENO:0041525', 'UPHENO:0004436', 'UBERON:0034768', 'UPHENO:0003034', 'UBERON:0004529', 'UBERON:5006048', 'UPHENO:0056237', 'UBERON:0015063', 'HP:0001574', 'UPHENO:0005319', 'UPHENO:0002442', 'UPHENO:0046552', 'UBERON:0011159', 'UPHENO:0002963', 'NCBITaxon:2759', 'NCBITaxon:1', 'HP:0030669', 'UPHENO:0002812', 'HP:0004348', 'UPHENO:0086679', 'HP:0000795', 'UPHENO:7000780', 'HP:0040070', 'NCBITaxon:33154', 'UPHENO:0018390', 'UPHENO:7000293', 'UPHENO:0087980', 'HP:0032039', 'UPHENO:0004433', 'HP:0045060', 'UPHENO:0087203', 'NCBITaxon:131567', 'GO:0043009', 'UBERON:0002049', 'UBERON:0001474', 'HP:0000492', 'UBERON:0003072', 'HP:0002143', 'UPHENO:0003158', 'UBERON:0004734', 'NCBITaxon:33208', 'UPHENO:0041565', 'UPHENO:0068971', 'UBERON:0010740', 'UPHENO:0002713', 'CL:0000081', 'HP:0000496', 'HP:0000639', 'UPHENO:0072255', 'UPHENO:0002543', 'UPHENO:0002301', 'UPHENO:0003298', 'UPHENO:0046594', 'UPHENO:0002403', 'UPHENO:0003031', 'UPHENO:0005517', 'UPHENO:0002352', 'UPHENO:0087665', 'UBERON:0001558', 'HP:0012373', 'UPHENO:0087814', 'NBO:0000338', 'UBERON:0017672', 'GO:0050882', 'UPHENO:0050622', 'UPHENO:0080377', 'UPHENO:0005647', 'UPHENO:0005275', 'UPHENO:0004788', 'UPHENO:0050106', 'HP:0200007', 'UPHENO:0080103', 'UPHENO:0079833', 'UPHENO:7000356', 'UBERON:0000970', 'UPHENO:0050079', 'UPHENO:0005214', 'UPHENO:0050613', 'GO:0043228', 'UBERON:0002368', 'UPHENO:0068941', 'UPHENO:0050606', 'UPHENO:0002267', 'UPHENO:0085302', 'UBERON:0000474', 'UPHENO:0052161', 'UPHENO:0003104', 'UPHENO:0076718', 'UPHENO:0079826', 'UBERON:0003075', 'UBERON:0004121', 'UPHENO:0055094', 'UPHENO:0080187', 'UPHENO:0049703', 'UPHENO:0002942', 'GO:0050877', 'HP:0012331', 'UBERON:0013702', 'NBO:0000388', 'UPHENO:0002385', 'HP:0001347', 'UPHENO:0087816', 'UPHENO:0004094', 'GO:0007399', 'UPHENO:0080662', 'UPHENO:0002577', 'UBERON:0000203', 'UPHENO:0083263', 'HP:0008055', 'UPHENO:0002430', 'UBERON:0007273', 'UPHENO:0049622', 'UPHENO:0002916', 'UBERON:0004571', 'UBERON:0006052', 'HP:0001510', 'UPHENO:0002822', 'UBERON:0010543', 'UPHENO:0005118', 'HP:0033353', 'UPHENO:0002772', 'UBERON:0000464', 'UPHENO:0004723', 'UPHENO:0085344', 'UBERON:0004111', 'UPHENO:0035160', 'UPHENO:0002240', 'UPHENO:0087334', 'HP:0002597', 'HP:0000001', 'UPHENO:0004523', 'UBERON:0003519', 'UBERON:0003509', 'UPHENO:0003776', 'HP:0009484', 'UPHENO:0003423', 'UPHENO:0063515', 'UPHENO:0087307', 'CL:0000413', 'HP:0040019', 'HP:0012638', 'HP:0000340', 'GO:0043227', 'HP:0000069', 'UPHENO:0086700', 'UPHENO:9002003', 'HP:0001679', 'UBERON:0005157', 'UPHENO:0076776', 'UPHENO:0003234', 'HP:0030680', 'UBERON:0019221', 'UPHENO:0033572', 'HP:0012041', 'HP:0002973', 'UBERON:0001009', 'UPHENO:0002206', 'UPHENO:0004507', 'UPHENO:0076783', 'UPHENO:0087083', 'HP:0011875', 'UBERON:0010409', 'UPHENO:0004484', 'UBERON:0003929', 'UBERON:0002217', 'UPHENO:0002576', 'HP:0000364', 'UPHENO:0005648', 'UBERON:0004716', 'UPHENO:0002635', 'UPHENO:0002994', 'HP:0100887', 'UPHENO:0004467', 'UPHENO:0085410', 'UPHENO:0046753', 'HP:0000027', 'UPHENO:0069062', 'UPHENO:0011536', 'UBERON:0000160', 'UPHENO:0075933', 'UPHENO:0086595', 'HP:0011893', 'UBERON:0006717', 'UPHENO:0004505', 'UPHENO:0086855', 'HP:0000234', 'UPHENO:0087123', 'UPHENO:7000586', 'UPHENO:0088166', 'UPHENO:0055092', 'UBERON:0001015', 'UPHENO:0041147', 'UPHENO:0002532', 'UBERON:0000020', 'UPHENO:0000541', 'HP:0002644', 'UPHENO:0076735', 'UBERON:0000161', 'UPHENO:0088185', 'UBERON:0002386', 'UPHENO:0002807', 'UPHENO:0087973', 'UBERON:0002405', 'UPHENO:0041053', 'UPHENO:0004172', 'UPHENO:0004434', 'UPHENO:0076675', 'UBERON:0010425', 'UPHENO:0005636', 'UPHENO:0002219', 'UPHENO:0069562', 'UPHENO:0082548', 'UBERON:0003975', 'UPHENO:0010795', 'UPHENO:0077399', 'UPHENO:0049708', 'UPHENO:0077348', 'UPHENO:0076765', 'UPHENO:0002433', 'UPHENO:0002668', 'UPHENO:0049699', 'CL:0000988', 'UBERON:0003064', 'UPHENO:0002542', 'GO:0060004', 'HP:0011873', 'UPHENO:0003207', 'UPHENO:0003026', 'UPHENO:0003159', 'GO:0007605', 'UPHENO:0005336', 'UPHENO:0004536', 'UBERON:0015021', 'UPHENO:0085371', 'UBERON:0002100', 'UPHENO:0004704', 'UPHENO:0033598', 'UBERON:0000478', 'UPHENO:0002211', 'UPHENO:0063787', 'UPHENO:0004047', 'UPHENO:0002538', 'UPHENO:7000640', 'UPHENO:0002426', 'UPHENO:0003025', 'UPHENO:0002887', 'UPHENO:0002537', 'UPHENO:0050234', 'UBERON:0001130', 'UPHENO:0002595', 'UPHENO:0084653', 'UPHENO:0004909', 'UPHENO:0005030', 'UPHENO:0052162', 'UBERON:0035639', 'HP:0001392', 'HP:0001010', 'UPHENO:0002637', 'UPHENO:0005097', 'UBERON:0002113', 'UPHENO:0055024', 'UPHENO:0041146', 'HP:0000079', 'UPHENO:0086589', 'HP:0001000', 'UBERON:0003513', 'UPHENO:0087501', 'UBERON:0001436', 'UPHENO:0004494', 'UBERON:0004362', 'UBERON:0034921', 'UPHENO:0002386', 'UPHENO:0002648', 'UPHENO:0003516', 'UBERON:0016879', 'UBERON:0004145', 'UPHENO:0049586', 'UPHENO:0002636', 'UBERON:0007100', 'UPHENO:0053632', 'UPHENO:0003020', 'UBERON:0010912', 'UPHENO:0003002', 'UPHENO:0086866', 'HP:0000549', 'UBERON:0004088', 'UBERON:0007811', 'UBERON:0000477', 'UPHENO:3000007', 'UPHENO:0003088', 'UPHENO:0075195', 'UBERON:0001434', 'UPHENO:0003048', 'UPHENO:0066913', 'UPHENO:0004466', 'HP:0000953', 'UBERON:0000015', 'UPHENO:0088118', 'UPHENO:0074245', 'UPHENO:0088186', 'UPHENO:0003186', 'HP:0001637', 'UPHENO:0041821', 'UBERON:0011582', 'UBERON:0006925', 'HP:0002817', 'UPHENO:0004545', 'UBERON:0015212', 'UPHENO:0082761', 'CL:0000255', 'HP:0011849', 'UPHENO:0088123', 'UBERON:0005423', 'UBERON:0015025', 'UPHENO:0049623', 'NBO:0000411', 'UBERON:0012354', 'UBERON:0036295', 'UPHENO:0002919', 'UPHENO:0004910', 'UPHENO:0074584', 'UBERON:0004872', 'UPHENO:0077889', 'UPHENO:0002308', 'UBERON:0005451', 'UBERON:0002390', 'UBERON:0011216', 'UBERON:0004347', 'UPHENO:0002531', 'UBERON:0004765', 'UPHENO:0076809', 'UPHENO:0084734', 'UPHENO:0002962', 'UPHENO:0063558', 'UBERON:0003134', 'UBERON:0000916', 'UPHENO:0066927', 'UBERON:0000019', 'UPHENO:0074237', 'UPHENO:0002903', 'UBERON:0010000', 'UPHENO:0002732', 'UPHENO:0086797', 'HP:0011821', 'UBERON:0011300', 'UBERON:0010538', 'UBERON:0010313', 'UPHENO:0050875', 'UPHENO:0002541', 'UPHENO:0086198', 'GO:0030099', 'UPHENO:0003432', 'UPHENO:0003038', 'UPHENO:0087510', 'HP:0008053', 'UPHENO:0002694', 'UPHENO:0003999', 'RO:0002577', 'UBERON:0002240', 'UPHENO:0003005', 'UPHENO:0002571', 'UBERON:0005876', 'HP:0033127', 'UBERON:0015001', 'BFO:0000004', 'UPHENO:0075878', 'UPHENO:0086484', 'UPHENO:0002643', 'UBERON:0004786', 'UPHENO:0004625', 'UPHENO:0005141', 'UBERON:0003840', 'UPHENO:0005092', 'HP:0008050', 'UBERON:0034925', 'GO:0043226', 'UPHENO:0005518', 'UPHENO:0033568', 'UBERON:0004535', 'HP:0001882', 'UPHENO:0002548', 'UBERON:0007375', 'UPHENO:0001135', 'HP:0009116', 'UPHENO:0068838', 'UBERON:0005256', 'HP:0002814', 'UBERON:0008962', 'UPHENO:0002905', 'UPHENO:0076703', 'HP:0000172', 'UPHENO:0002955', 'UBERON:0002005', 'GO:0032501', 'HP:0005927', 'UPHENO:0050008', 'UPHENO:0003227', 'GO:0007283', 'UBERON:0016880', 'HP:0011121', 'UBERON:0010222', 'HP:0000813', 'UBERON:0000468', 'HP:0002251', 'UBERON:0015061', 'UBERON:0001299', 'UPHENO:0002704', 'UBERON:0013701', 'UPHENO:0004064', 'UBERON:0010758', 'HP:0006496', 'UPHENO:0004802', 'UPHENO:0002597', 'UPHENO:0002844', 'UBERON:0010312', 'UPHENO:0004892', 'UBERON:0003126', 'UBERON:0010230', 'UPHENO:0088337', 'UPHENO:7000342', 'UBERON:0013522', 'UBERON:0005358', 'UPHENO:0076729', 'HP:0002818', 'HP:0002813', 'UPHENO:0000509', 'UPHENO:0005231', 'CL:0002242', 'UBERON:0004573', 'UPHENO:0001440', 'UPHENO:0063794', 'UBERON:0003061', 'HP:0012443', 'UPHENO:0004457', 'UPHENO:0001072', 'UPHENO:0087660', 'UPHENO:0002747', 'UBERON:0006598', 'UBERON:0002102', 'UPHENO:0041644', 'UBERON:0002428', 'UPHENO:0001303', 'UPHENO:0026529', 'UPHENO:0002422', 'GO:0030587', 'UPHENO:0004721', 'UBERON:0004151', 'BFO:0000002', 'HP:0000453', 'UPHENO:0004503', 'UPHENO:0005994', 'UPHENO:0002818', 'UPHENO:0046483', 'UBERON:0001084', 'UBERON:0011250', 'HP:0000316', 'UBERON:0000047', 'HP:0002031', 'HP:0004325', 'UBERON:0012430', 'UBERON:0012475', 'UPHENO:0003070', 'UPHENO:0003410', 'UPHENO:0069046', 'HP:0001167', 'UPHENO:0002896', 'NBO:0000416', 'UBERON:0008814', 'UBERON:0000466', 'UBERON:0019264', 'HP:0100022', 'UBERON:0011249', 'UBERON:0010314', 'UPHENO:0003049', 'UPHENO:0081141', 'UPHENO:0011845', 'UPHENO:0086546', 'UPHENO:7000774', 'UPHENO:0033602', 'UBERON:0007688', 'UPHENO:0003001', 'UBERON:0000923', 'HP:0008669', 'UPHENO:0081786', 'UPHENO:0004173', 'UBERON:0000033', 'UBERON:0007798', 'HP:0100886', 'UPHENO:0086635', 'UPHENO:0079828', 'HP:0000478', 'UBERON:0004456', 'UPHENO:0004519', 'UPHENO:0002870', 'UBERON:0003133', 'UPHENO:0002868', 'UBERON:0003464', 'UPHENO:0002559', 'UBERON:0001981', 'UPHENO:0002902', 'UPHENO:0075919', 'UPHENO:0003812', 'UPHENO:0002792', 'UPHENO:0002814', 'UBERON:0002105', 'UBERON:0000955', 'HP:0009115', 'UPHENO:0031254', 'UPHENO:0084448', 'HP:0011842', 'HP:0002118', 'GO:0048609', 'UPHENO:0003488', 'UBERON:5101466', 'UPHENO:0025401', 'UBERON:0003059', 'UBERON:0003056', 'UPHENO:0076692', 'GO:0043231', 'UPHENO:0033592', 'UPHENO:0076739', 'GO:0005622', 'UBERON:5002544', 'UPHENO:0049966', 'UBERON:0002329', 'UPHENO:0082875', 'HP:0002664', 'UPHENO:0046755', 'UPHENO:0076740', 'HP:0000924', 'UPHENO:0002269', 'UBERON:0002529', 'UPHENO:0033626', 'UBERON:0011779', 'UPHENO:0002830', 'HP:0011004', 'HP:0410008', 'UBERON:0012357', 'UPHENO:0002632', 'HP:0000864', 'UPHENO:0014285', 'UPHENO:0002600', 'UPHENO:0002983', 'UPHENO:0086048', 'UBERON:0000465', 'HP:0002011', 'UBERON:0016526', 'UPHENO:0005986', 'UBERON:0002101', 'HP:0000119', 'UBERON:0006601', 'UBERON:0010188', 'UBERON:0003102', 'UPHENO:0026404', 'UBERON:0015203', 'UPHENO:0086633', 'UBERON:0004288', 'UBERON:0000026', 'UPHENO:0031124', 'GO:0009605', 'HP:0000366', 'UPHENO:0004482', 'UPHENO:0072185', 'UPHENO:0011531', 'UBERON:0007272', 'HP:0011545', 'UPHENO:0005437', 'UPHENO:7000632', 'UPHENO:0072359', 'UPHENO:0049756', 'UPHENO:0004418', 'HP:0002863', 'UPHENO:0008958', 'HP:0000118', 'UBERON:0015833', 'UBERON:0001016', 'UPHENO:0026407', 'HP:0007400', 'UPHENO:0068898', 'UPHENO:0084767', 'UBERON:0004710', 'UBERON:0002108', 'HP:0001654', 'HP:0100691', 'UPHENO:0041041', 'UPHENO:0069119', 'HP:0009122', 'UPHENO:0008850', 'UBERON:0010708', 'UPHENO:0002764', 'UBERON:0000061', 'UPHENO:0002708', 'UPHENO:0088319', 'UPHENO:0005166', 'HP:0001507', 'UBERON:0003077', 'UBERON:0002342', 'HP:0031816', 'UPHENO:0002746', 'HP:0031826', 'UPHENO:0088170', 'UPHENO:0001002', 'UPHENO:0031227', 'UBERON:0016548', 'UPHENO:0003085', 'NCBITaxon:6072', 'UBERON:0000947', 'UBERON:0002553', 'UPHENO:0002872', 'UPHENO:0005058', 'NBO:0000389', 'UBERON:0000483', 'HP:0001199', 'UBERON:0002050', 'HP:0002023', 'UPHENO:0081574', 'GO:0050879', 'UPHENO:0086088', 'UBERON:0015204', 'UBERON:0003620', 'UPHENO:0080079', 'HP:0001511', 'UBERON:0003834', 'GO:0001841', 'HP:0000174', 'UPHENO:0004469', 'UPHENO:0087347', 'UPHENO:0076727', 'HP:0001881', 'UPHENO:0002701', 'UPHENO:7000208', 'UPHENO:0069327', 'GO:0003008', 'UBERON:0001733', 'UPHENO:0002593', 'UBERON:5003625', 'UBERON:0010130', 'HP:0001373', 'HP:0012745', 'GO:0007610', 'UPHENO:0035151', 'UPHENO:0003236', 'UPHENO:0011538', 'UPHENO:0005206', 'UPHENO:0002552', 'UPHENO:0088116', 'UBERON:0002104', 'UBERON:0010363', 'UPHENO:0082905', 'UBERON:0007005', 'UPHENO:0068912', 'UPHENO:0087367', 'UPHENO:0086614', 'UPHENO:0080010', 'UBERON:0005881', 'UPHENO:0004513', 'UPHENO:0052778', 'UBERON:0002398', 'UPHENO:0002371', 'UBERON:0004708', 'UPHENO:0067645', 'UPHENO:0086769', 'UPHENO:7000428', 'UBERON:0005623', 'UBERON:0002204', 'UPHENO:0072195', 'UPHENO:0005356', 'HP:0002921', 'UPHENO:3000004', 'UPHENO:0087006', 'UBERON:0034713', 'UPHENO:0002945', 'UBERON:0001440', 'UPHENO:0069328', 'UBERON:0001530', 'UPHENO:0002650', 'UPHENO:0076760', 'UPHENO:0001392', 'UPHENO:0052159', 'HP:0000347', 'UBERON:0003081', 'UPHENO:0087852', 'UBERON:0003071', 'UBERON:0002349', 'UPHENO:0002906', 'UPHENO:0075997', 'UBERON:0002470', 'UPHENO:0001003', 'UPHENO:0002782', 'UPHENO:0002715', 'UPHENO:0002360', 'HP:0031105', 'UPHENO:0086172', 'UBERON:0000179', 'UBERON:0011584', 'HP:0011024', 'UBERON:0000946', 'UBERON:0004756', 'UBERON:0008785', 'UPHENO:0002554', 'HP:0100587', 'UPHENO:0087974', 'UPHENO:0002808', 'CL:0000000', 'HP:0007364', 'UBERON:0005291', 'UPHENO:0078742', 'UPHENO:0072194', 'UPHENO:0002712', 'UPHENO:0003163', 'HP:0006265', 'UPHENO:0005596', 'UPHENO:0086487', 'UBERON:0002331', 'UBERON:0001017', 'UPHENO:0002954', 'UPHENO:0031194', 'BFO:0000001', 'UPHENO:0068839', 'UPHENO:0002574', 'UPHENO:0087089', 'UBERON:0004053', 'UBERON:0007830', 'UPHENO:7000595', 'UBERON:0004381', 'UPHENO:0086486', 'UPHENO:0002525', 'HP:0040069', 'UBERON:0000075', 'UPHENO:0003019', 'HP:0000707', 'UPHENO:0084761', 'NBO:0000313', 'HP:0011297', 'UPHENO:0079876', 'UBERON:0003104', 'UPHENO:0078179', 'HP:0025031', 'UPHENO:0005515', 'UPHENO:0004459', 'UPHENO:0081570', 'UPHENO:0004757', 'UPHENO:0004831', 'UBERON:0001460', 'UPHENO:0011901', 'HP:0011017', 'UBERON:0002544', 'HP:0010987', 'HP:0002575', 'UPHENO:0002568', 'UPHENO:0002864', 'UPHENO:0072414', 'BFO:0000040', 'UPHENO:0003189', 'HP:0040064', 'UPHENO:0000543', 'UPHENO:0003366', 'UPHENO:0080165', 'UPHENO:0002949', 'UPHENO:0004881', 'UBERON:0001809', 'UPHENO:0003550', 'HP:0001924', 'UBERON:0012141', 'UPHENO:0001101', 'UPHENO:0002861', 'UPHENO:0003334', 'UPHENO:0081424', 'UBERON:0004089', 'UPHENO:0087294', 'UPHENO:0080126', 'UPHENO:0004829', 'UPHENO:0081581', 'UPHENO:7000280', 'CL:0000738', 'UPHENO:0077418', 'UBERON:0007524', 'UPHENO:0002586', 'UPHENO:0080200', 'UPHENO:0003827', 'UPHENO:0054957', 'UPHENO:0004885', 'UPHENO:0041083', 'UPHENO:0083161', 'UPHENO:0046487', 'BFO:0000003', 'GO:0043229', 'UBERON:0000178', 'UPHENO:0025109', 'UBERON:0007503', 'UBERON:0010712', 'UPHENO:0005172', 'UPHENO:0087472', 'UBERON:0004357', 'UBERON:0001457', 'UBERON:0005061', 'HP:0025015', 'UPHENO:0004476', 'GO:0050953', 'UPHENO:0003095', 'UPHENO:0004680', 'UPHENO:0011708', 'UPHENO:0078629', 'UPHENO:0005110', 'UPHENO:0002721', 'UBERON:0000463', 'UBERON:0011158', 'UBERON:0000167', 'UBERON:0000926', 'UPHENO:0002891', 'UPHENO:0005170', 'UPHENO:0088049', 'UPHENO:0076723', 'UBERON:0003607', 'UPHENO:0002656', 'UPHENO:0002536', 'UPHENO:0004621', 'UBERON:0004572', 'HP:0001551', 'UPHENO:0011498', 'UPHENO:0004475', 'UBERON:0004375', 'UBERON:0002193', 'UBERON:0004120', 'UPHENO:0079835', 'UPHENO:0075198', 'UBERON:0000922', 'UBERON:0000383', 'UPHENO:0076694', 'UPHENO:0069266', 'HP:0000202', 'HP:0002414', 'UPHENO:0087846', 'UPHENO:0002976', 'UBERON:0000949', 'UPHENO:0087232', 'HP:0012733', 'UBERON:0010371', 'UBERON:0000479', 'UPHENO:0002553', 'UPHENO:0049587', 'HP:0040068', 'HP:0000163', 'BFO:0000015', 'UPHENO:0075220', 'UPHENO:0049874', 'UPHENO:7000376', 'UPHENO:0046445', 'GO:0008150', 'UPHENO:0002899', 'HP:0000315', 'GO:0050896', 'UBERON:0011156', 'UPHENO:0051150', 'UBERON:0004092', 'HP:0006101', 'UPHENO:0088140', 'UPHENO:0003799', 'UPHENO:0076697', 'UBERON:0012360', 'UPHENO:0087907', 'UPHENO:0072264', 'HP:0001627', 'UPHENO:0074228', 'HP:0032251', 'UPHENO:0025875', 'NBO:0000403', 'UPHENO:0003116', 'UPHENO:0001147', 'UBERON:0003498', 'UBERON:0000055', 'HP:0000505', 'HP:0009815', 'UPHENO:0085330', 'UPHENO:0049590', 'UBERON:0004119', 'UBERON:0010191', 'HP:0005922', 'HP:0001626', 'UBERON:0010323', 'GO:0060606', 'UPHENO:0051276', 'UPHENO:0002880', 'HP:0000818', 'UPHENO:7000875', 'UBERON:0003625', 'UPHENO:0001304', 'UPHENO:0001584', 'HP:0000929', 'UBERON:0000164', 'UPHENO:0018424', 'UBERON:0001048', 'UPHENO:0002733', 'UPHENO:0081314', 'UBERON:0005417', 'UBERON:0001805', 'HP:0011844', 'UBERON:0001637', 'UPHENO:0074227', 'HP:0000271', 'UBERON:0000924', 'UBERON:0001062', 'UBERON:0003129', 'UPHENO:0063722', 'UPHENO:0004888', 'UBERON:0004905', 'UPHENO:0003446', 'UPHENO:0002928', 'UPHENO:0005025', 'UPHENO:0083646', 'UPHENO:0002761', 'UBERON:0000307', 'UPHENO:0086485', 'UPHENO:0072200', 'UBERON:0001332', 'UBERON:0013765', 'UPHENO:0012440', 'UBERON:0001353', 'UBERON:0006800', 'UPHENO:0087892', 'UBERON:0001032', 'UPHENO:0015324', 'HP:0012547', 'UBERON:0000117', 'UPHENO:0072266', 'HP:0000481', 'UBERON:0000062', 'UPHENO:7000183', 'UPHENO:0002530', 'UPHENO:0002754', 'UPHENO:0088132', 'HP:0000175', 'UBERON:0000490', 'HP:0002246', 'UPHENO:0003100', 'UBERON:0000925', 'UPHENO:0026327', 'HP:0012252', 'UPHENO:0002850', 'UBERON:0002199', 'HP:0025354', 'UBERON:0002097', 'GO:0043473', 'UPHENO:0074575', 'UPHENO:0066972', 'UPHENO:0033560', 'UBERON:0005409', 'UPHENO:0054970', 'UPHENO:0084770', 'UBERON:0001555', 'UPHENO:0086621', 'UPHENO:0076803', 'UPHENO:0087530', 'UPHENO:0080087', 'HP:0025033', 'UPHENO:0003058', 'UBERON:0006314', 'UPHENO:0003413', 'UBERON:0016525', 'UPHENO:0004518', 'UPHENO:0002378', 'HP:0031704', 'UBERON:0002513', 'UBERON:0002114', 'UPHENO:0003004', 'CL:0000019', 'HP:0003330', 'UBERON:0000025', 'UBERON:0000964', 'GO:0050905', 'UBERON:0001007', 'UPHENO:0068848', 'UBERON:0002020', 'HP:0100867', 'UBERON:5002389', 'UPHENO:0003093', 'UBERON:0001155', 'UBERON:0001890', 'UPHENO:0002546', 'UPHENO:0026279', 'UPHENO:0081594', 'UBERON:0003278', 'UPHENO:0003415', 'UBERON:0004921', 'UPHENO:0002725', 'UPHENO:0049664', 'UPHENO:0071310', 'HP:0002242', 'HP:0001643', 'UPHENO:0002859', 'UPHENO:0078730', 'UPHENO:0002948', 'HP:0012718', 'UPHENO:0086482', 'HP:0004328', 'UPHENO:0002957', 'HP:0012848', 'UPHENO:0086858', 'UPHENO:0002639', 'UPHENO:0087612', 'UBERON:0005181', 'HP:0000047', 'UPHENO:0002832', 'UBERON:0015228', 'UBERON:0005337', 'UPHENO:0002263', 'UPHENO:0002634', 'UPHENO:0033565', 'HP:0001172', 'UPHENO:7000267', 'UBERON:0002365', 'UPHENO:0004386', 'UPHENO:0075949', 'HP:0002715', 'UPHENO:0035147', 'UPHENO:0086824', 'UBERON:0001167', 'UPHENO:0087070', 'UPHENO:0004405', 'UPHENO:0004403', 'UPHENO:0005080', 'HP:0100736', 'UBERON:0002084', 'UPHENO:0087186', 'UPHENO:0004827', 'UBERON:0002091', 'UPHENO:0004360', 'HP:0001671', 'UBERON:0035553', 'UBERON:0009569', 'UPHENO:0075945', 'UBERON:0004771', 'UBERON:0005156', 'UBERON:0012275', 'UBERON:0002082', 'HP:0002250', 'UPHENO:0086492', 'UBERON:0003978', 'UPHENO:0076805', 'UPHENO:0005285', 'UPHENO:0003092', 'UPHENO:0002901', 'UBERON:0003914', 'HP:0012639', 'NBO:0000001', 'UBERON:0009881', 'UBERON:0004248', 'HP:0000951', 'UPHENO:0076810', 'UPHENO:0052675', 'UBERON:0007285', 'UBERON:0002137', 'UPHENO:0002944', 'UPHENO:0080300', 'UPHENO:7000372', 'UPHENO:0003066', 'UBERON:0005177', 'HP:0001871', 'UBERON:0003103', 'UPHENO:0002246', 'UPHENO:0003084', 'UPHENO:0003828', 'GO:0009653', 'UPHENO:0002523', 'UPHENO:0003086', 'UPHENO:0002964', 'HP:0001646', 'UPHENO:0056250', 'UBERON:0036146', 'UPHENO:0086680', 'UBERON:0004140', 'UBERON:0004141', 'UBERON:0001456', 'UPHENO:0001001', 'UBERON:0001041', 'UPHENO:0053330', 'UPHENO:0046403', 'UBERON:0005178', 'UPHENO:0004616', 'UBERON:0005956', 'UPHENO:0076743', 'UPHENO:0001360', 'UPHENO:0005230', 'UBERON:0003084', 'UBERON:0000153', 'UBERON:0015410', 'UPHENO:0004615', 'UPHENO:0009163', 'BFO:0000141', 'UPHENO:0027017', 'UPHENO:0001570', 'UPHENO:0004962', 'UPHENO:0002550', 'UPHENO:0001454', 'HP:0030962', 'UBERON:0000915', 'UPHENO:0087022', 'UPHENO:0001004', 'UPHENO:0041667', 'UPHENO:0002838', 'UPHENO:0033599', 'HP:0000508', 'UPHENO:0041410', 'UBERON:0003462', 'UPHENO:0005106', 'UPHENO:0041226', 'UBERON:0000004', 'UPHENO:0087802', 'HP:0002119', 'HP:5201015', 'UPHENO:0087423', 'UPHENO:0033635', 'UPHENO:0004509', 'UPHENO:0033612', 'UBERON:0010316', 'UPHENO:0004262', 'UPHENO:0002828', 'UPHENO:0001213', 'UPHENO:0075998', 'UBERON:0000165', 'UPHENO:0002777', 'UPHENO:0004520', 'UPHENO:0076704', 'UBERON:0000978', 'UPHENO:7000055', 'UBERON:0002346', 'UPHENO:0004443', 'UBERON:0001709', 'UPHENO:0076786', 'UPHENO:0003414', 'HP:0002244', 'UPHENO:0025146', 'UPHENO:3000000', 'UBERON:0011595', 'UPHENO:0002816', 'UBERON:0008907', 'HP:0010972', 'UBERON:0004175', 'UPHENO:0076800', 'UPHENO:0004900', 'UPHENO:0025637', 'HP:0010301', 'HP:0000153', 'UPHENO:0075655', 'UBERON:0009617', 'CL:0000219', 'UPHENO:0087585', 'GO:0008152', 'UPHENO:7000149', 'HP:0010468', 'UBERON:0001442', 'UPHENO:0002685', 'UPHENO:0087806', 'UBERON:0000990', 'UPHENO:0003015', 'HP:0032101', 'UBERON:0005440', 'UBERON:0000166', 'UBERON:0004122', 'UPHENO:0069161', 'UBERON:0012140', 'UBERON:0003100', 'UPHENO:7000297', 'UBERON:0012139', 'UPHENO:0003055', 'GO:0042756', 'UPHENO:0087547', 'HP:0012243', 'UBERON:0005983', 'UPHENO:0002642', 'UPHENO:0041151', 'NBO:0000417', 'UPHENO:0003053', 'UBERON:0004139', 'HP:0010460', 'UPHENO:0002687', 'UPHENO:0001154', 'HP:0000078', 'UPHENO:0004709', 'UBERON:0000072', 'UPHENO:0086121', 'UPHENO:0071326', 'UPHENO:0002598', 'UPHENO:0005022', 'HP:0001763', 'HP:0000130', 'UPHENO:0010850', 'UPHENO:0002547', 'UPHENO:0076766', 'UBERON:0013515', 'UBERON:0004761', 'UBERON:0000993', 'UBERON:0002410', 'HP:0000008', 'UPHENO:0079837', 'UBERON:0013768', 'UPHENO:0004956', 'UPHENO:0002977', 'UPHENO:0002875', 'UBERON:0000995', 'UPHENO:0077373', 'HP:0040195', 'HP:0001999', 'HP:0001537', 'UPHENO:0084771', 'UPHENO:0081575', 'UPHENO:0003065', 'UPHENO:0004521', 'UPHENO:0087121', 'HP:0010461', 'UPHENO:0026010', 'UPHENO:0004401', 'UPHENO:0075804', 'UBERON:0011137', 'HP:0012211', 'UPHENO:0063595', 'UPHENO:0003177', 'UBERON:0007914', 'UPHENO:0004828', 'UPHENO:0053563', 'UBERON:0011138', 'UPHENO:0075148', 'HP:0002060', 'UPHENO:0002570', 'UPHENO:0076799', 'UPHENO:0069236', 'UBERON:0000064', 'UPHENO:0003811', 'UBERON:0000073', 'UBERON:0003080', 'UPHENO:0002833', 'UPHENO:0076702', 'UBERON:0009145', 'UPHENO:0002971', 'UPHENO:0087363', 'UPHENO:0075873', 'UBERON:0012150', 'UBERON:0000948', 'UBERON:0005944', 'UPHENO:0086159', 'UBERON:0002090', 'UPHENO:0002381', 'UPHENO:0005104', 'UBERON:0002616', 'UBERON:0010913', 'UPHENO:0002736', 'UBERON:0004770', 'HP:0002977', 'UPHENO:0075995', 'UPHENO:0081598', 'UPHENO:0003050', 'UPHENO:0069352', 'UPHENO:0076791', 'HP:0009121', 'UBERON:0002268', 'UPHENO:0069149', 'UBERON:0001711', 'HP:0000240', 'UBERON:0001049', 'UPHENO:0067691', 'UBERON:0002355', 'UBERON:0002389', 'UBERON:8450002', 'UPHENO:0085874', 'UPHENO:0071337', 'UPHENO:0002448', 'UBERON:0001008', 'UPHENO:0041033', 'UPHENO:0087578', 'HP:0000080', 'HP:0000144', 'UPHENO:0071315', 'UPHENO:0087597', 'UPHENO:0081435', 'HP:0005344', 'UPHENO:0087663', 'UBERON:0001638', 'UPHENO:3000003', 'UPHENO:0002952', 'UPHENO:0063581', 'UBERON:0001043', 'UBERON:0000065', 'UPHENO:0014292', 'UPHENO:0087433', 'UPHENO:0088162', 'CL:0000763', 'UPHENO:0004891', 'UPHENO:0002388', 'UPHENO:0086144', 'HP:0000811', 'UPHENO:0005177', 'UPHENO:0087478', 'HP:0004377', 'UPHENO:0002987', 'UPHENO:0002434', 'UBERON:0004908', 'UPHENO:0076785', 'HP:0005607', 'GO:0060429', 'UPHENO:0002734', 'UPHENO:0004486', 'UBERON:0000079', 'UBERON:0001004', 'UPHENO:0086792', 'UPHENO:0074229', 'UPHENO:0076798', 'UPHENO:0002529', 'UBERON:0002075', 'UBERON:0005911', 'UPHENO:0087662', 'UPHENO:0079539', 'UPHENO:0079839', 'UBERON:0034923', 'UPHENO:7000359', 'HP:0200005', 'UPHENO:7000623', 'UPHENO:0087359', 'UPHENO:0087518', 'UPHENO:0086717', 'UBERON:0000945', 'UPHENO:0053456', 'UPHENO:0084829', 'UPHENO:0004481', 'UBERON:0010707', 'UPHENO:0003605', 'HP:0000218', 'UBERON:0007196', 'UBERON:0003947', 'HP:0002086', 'UPHENO:0002907', 'UBERON:0002530', 'UBERON:0008811', 'UBERON:0001005', 'UBERON:0015030', 'UPHENO:0002731', 'UPHENO:0003405', 'UBERON:0004582', 'UBERON:0001132', 'UBERON:0003920', 'UPHENO:0002659', 'UPHENO:0053571', 'HP:0001710', 'UPHENO:0076761', 'HP:0002778', 'UBERON:0003258', 'UBERON:0001021', 'UPHENO:0076752', 'UPHENO:0002940', 'UPHENO:0003056', 'GO:0009790', 'UPHENO:0002579', 'UPHENO:0002261', 'UPHENO:0075159', 'UPHENO:0080114', 'UPHENO:0001134', 'UPHENO:0001340', 'UPHENO:7000182', 'UBERON:0008784', 'UPHENO:0005029', 'UBERON:0004923', 'UBERON:0000060', 'UPHENO:0088047', 'UPHENO:0075175', 'UBERON:0003221', 'UBERON:0005282', 'UPHENO:0002562', 'UPHENO:0001355', 'UPHENO:0002567', 'UPHENO:0005008', 'UPHENO:0003021', 'HP:0012372', 'HP:0002012', 'UBERON:0001893', 'UPHENO:0004261', 'UBERON:0005867', 'UPHENO:7000299', 'UPHENO:0002526', 'UBERON:0004768', 'HP:0010936', 'UPHENO:0087344', 'UBERON:0005281', 'HP:0000812', 'UBERON:0001684', 'HP:0100547', 'HP:0011793', 'UPHENO:0075890', 'UPHENO:0084654', 'UBERON:0004742', 'UPHENO:0068932', 'UPHENO:0087404', 'HP:0009118', 'UPHENO:0084457', 'HP:0000152', 'UBERON:0034944', 'UBERON:0000981', 'UPHENO:0004525', 'UPHENO:0081091', 'UPHENO:0031125', 'GO:0035295', 'UPHENO:0002804', 'UPHENO:0009209', 'UBERON:5102389', 'UBERON:0003113', 'UPHENO:0002815', 'UBERON:0007842', 'UBERON:0002514', 'HP:0030791', 'UBERON:8450003', 'HP:0001939', 'UBERON:0012151', 'CL:0000329', 'UBERON:0004128', 'UPHENO:0005257', 'UPHENO:0081788', 'UPHENO:0086518', 'HP:0000002', 'UPHENO:0087661', 'UBERON:0005062', 'UPHENO:0063594', 'UBERON:0000473', 'UBERON:0012314', 'UBERON:0001708', 'UBERON:0002539', 'UPHENO:0002564', 'UBERON:0001710', 'UBERON:0003457', 'UPHENO:0087558', 'HP:0000277', 'HP:0001155', 'UPHENO:0076724', 'UBERON:0003101', 'UPHENO:0002988', 'UBERON:0010364', 'UPHENO:0087228', 'UPHENO:0053561', 'UBERON:0001716', 'UPHENO:7000069', 'UPHENO:0046505', 'UPHENO:0053566', 'UPHENO:7000206', 'UPHENO:0003182', 'UPHENO:0002682', 'UPHENO:0002910', 'UPHENO:0053580', 'UPHENO:0053644', 'HP:0000035', 'UPHENO:0077885', 'UPHENO:0003101', 'UPHENO:0053647', 'HP:0000028', 'UPHENO:0083637', 'HP:0000032', 'UBERON:0000991', 'CL:0000764', 'UPHENO:0084763', 'UBERON:0003135', 'GO:0040007', 'UBERON:0004176', 'UPHENO:0002393', 'UPHENO:0085881', 'UPHENO:0025941', 'UPHENO:0056150', 'UPHENO:0005016', 'UPHENO:0053572', 'UBERON:0004537', 'UPHENO:0009021', 'HP:0011277', 'CL:0000586', 'HP:0010978', 'HP:0000010', 'HP:0002719', 'UPHENO:0027014', 'UPHENO:0008781', 'UPHENO:0008523', 'UBERON:0019231', 'UPHENO:0003082', 'UPHENO:0026148', 'UPHENO:0005055', 'UPHENO:0026506', 'GO:0002376', 'UPHENO:0003514', 'UPHENO:0026146', 'UPHENO:0003094', 'UPHENO:0011533', 'UPHENO:0025243', 'HP:0010469', 'GO:0110165', 'UBERON:0005162', 'UPHENO:0011485', 'UPHENO:0085478', 'UBERON:0000467', 'UPHENO:0008960', 'UPHENO:0033584', 'UBERON:0012469', 'HP:0045058', 'NBO:0000444', 'UPHENO:0081566', 'UPHENO:0009154', 'UPHENO:0011572', 'UBERON:0006058', 'UPHENO:0002678', 'UPHENO:0009020', 'GO:0050881', 'UPHENO:0026149', 'UPHENO:0003198', 'UPHENO:0002866', 'UBERON:0000323', 'UBERON:0008001', 'UBERON:0004086', 'HP:0000252', 'HP:0001562', 'HP:0001560', 'UPHENO:0087849', 'UPHENO:0053559', 'UPHENO:3000001', 'UBERON:0000173', 'UBERON:0001444', 'HP:0001197', 'UPHENO:0084124', 'UPHENO:0075852', 'UPHENO:0072345', 'UBERON:0002330', 'UPHENO:0002926', 'UBERON:0005173', 'UPHENO:0004061', 'UBERON:0002107', 'UBERON:0002423', 'UPHENO:0002780', 'UBERON:0001785', 'UPHENO:0002756', 'UBERON:0005172', 'UPHENO:0072402', 'UPHENO:0087387', 'UBERON:0002416', 'UBERON:0002417', 'UBERON:0000475', 'HP:0009602', 'UBERON:0001819', 'UBERON:0005419', 'UBERON:0005897', 'UBERON:5102544', 'UBERON:5001463', 'UPHENO:0087924', 'UBERON:0000481', 'UBERON:0011676', 'UBERON:0001463', 'GO:0048729', 'UBERON:0004876', 'UBERON:0015024', 'GO:0007276', 'UBERON:0003338', 'UBERON:0015023', 'UBERON:5101463', 'UPHENO:0003069', 'UBERON:5106048', 'UBERON:0010688', 'UBERON:0018260', 'UBERON:0004249', 'UBERON:0002495', 'UBERON:0012358', 'UBERON:0006048', 'UPHENO:0002767', 'UPHENO:0033593', 'UBERON:0010741', 'UBERON:0003606'], 'has_phenotype_closure_label': ['increased height of the multi-tissue structure', 'increased height of the anatomical structure', 'increased height of the multicellular anatomical structure', 'Abnormal cerebrospinal fluid morphology', 'increased number of ventricle of nervous system in the cerebrospinal fluid', 'cerebrospinal fluid phenotype', 'increased number of anatomical structure in the cerebrospinal fluid', 'Hydrocephalus', 'number of anatomical enitites of type organ part phenotype', 'increased number of brain ventricle/choroid plexus in the cerebrospinal fluid', 'increased number of brain ventricle', 'increased number of organ part in the cerebrospinal fluid', 'vascular plexus', 'head or neck skin', 'increased length of the anatomical structure', 'increased length of the zone of skin', 'compound organ physiology phenotype', 'increased length of the head or neck skin', 'increased length of the zone of organ', 'skin of face', 'increased length of the material anatomical entity', 'Abnormality of refraction', 'curved anatomical entity', 'buphthalmos', 'structure with developmental contribution from neural crest, curved phenotype', 'shape of cornea phenotype', 'increased size of the structure with developmental contribution from neural crest', 'Astigmatism', 'multicellular anatomical structure, curved phenotype', 'shape of forehead phenotype', 'Bicornuate uterus', 'bicornuate uterus', 'shape of uterus phenotype', 'Conotruncal defect', 'sloped forehead', 'Tetralogy of Fallot', 'layer of muscle tissue', 'increased length of the skin of face', 'decreased functionality of the myocardium', 'layer of muscle tissue phenotype', 'myocardium phenotype', 'Abnormal myocardium morphology', 'Renal insufficiency', 'myocardium morphology phenotype', 'multicellular anatomical structure mass phenotype', 'decreased anatomical structure mass', 'Abnormality of body weight', 'anatomical entity mass phenotype', 'Decreased multicellular organism mass', 'gut wall', 'Cardiomyopathy', 'incomplete closing of the skeletal element', 'vertebra morphology phenotype', 'dorsum', 'Abnormal neural tube morphology', 'Neural tube defect', 'incomplete closing of the arch of centrum of vertebra', 'Spina bifida', 'mucosa of stomach morphology phenotype', 'zone of skin', 'dorsal region element phenotype', 'vertebral element', 'mucosa phenotype', 'increased number of organ component layer in the cerebrospinal fluid', 'skin of head morphology phenotype', 'vertebral element phenotype', 'cartilage element phenotype', 'Abnormal spinal cord morphology', 'Spinal dysraphism', 'incomplete closing of the organ', 'cartilaginous condensation', 'spina bifida', 'increased number of anatomical structure', 'Arteriovenous malformation', 'increased number of hematopoietic cell', 'increased number of anatomical entity', 'arteriovenous malformation', 'increased number of erythrocyte', 'heart primordium morphology', 'urethral opening', 'lower urinary tract', 'primitive urogenital sinus', 'kinetochore organization; kinetochore organization variant', 'morphology of chromosome phenotype', 'cavitated compound organ physiology phenotype', 'cloaca phenotype', 'cellular anatomical structure', 'morphology of intracellular organelle phenotype', 'male urethral meatus', 'intracellular anatomical structure', 'membraneless organelle', 'intracellular organelle', 'membrane-bounded organelle', 'chromosome', 'nucleus', 'urethral meatus', 'morphology of cellular_component phenotype', 'urethra morphology phenotype', 'lower urinary tract phenotype', 'increased length of the structure with developmental contribution from neural crest', 'urethral meatus morphology phenotype', 'sensory perception of mechanical stimulus phenotype', 'sensory perception of sound phenotype', 'ear physiology phenotype', 'decreased qualitatively sensory perception of mechanical stimulus', 'Hearing abnormality', 'decreased size of the eyeball of camera-type eye', 'size of eyeball of camera-type eye phenotype', 'decreased size of the sense organ', 'Abnormality of globe size', 'decreased qualitatively multicellular organism development', 'decreased qualitatively embryo development', 'decreased multicellular organismal process', 'decreased embryo development', 'girdle skeleton', 'pelvic girdle skeleton phenotype', 'zone of bone organ phenotype', 'mesenchyme from somatopleure phenotype', 'abdominal segment bone', 'girdle skeleton phenotype', 'Hip dislocation', 'hindlimb joint', 'synovial joint of pelvic girdle', 'synovial joint of pelvic girdle morphology phenotype', 'trunk bone', 'hip joint phenotype', 'skeletal joint', 'hip', 'appendage girdle region', 'pelvic girdle region', 'anatomical entity dislocation', 'synovial joint', 'pelvic girdle bone/zone', 'trunk bone phenotype', 'abdominal segment bone phenotype', 'joint of girdle morphology phenotype', 'articulation', 'Lower extremity joint dislocation', 'decreased size of the material anatomical entity in the pectoral complex', 'decreased size of the anatomical entity in the pectoral complex', 'forehead morphology phenotype', 'increased number of cell', 'decreased anatomical structure development', 'forelimb zeugopod bone hypoplasia', 'decreased size of the anatomical structure in the pectoral complex', 'decreased size of the bone of pectoral complex', 'Forearm undergrowth', 'decreased length of forelimb zeugopod bone', 'decreased size of the arm bone', 'decreased length of arm bone', 'decreased length of bone of free limb or fin', 'decreased length of bone element', 'Upper limb undergrowth', 'decreased size of the forelimb endochondral element', 'Limb undergrowth', 'decreased length of organ', 'increased size of the eyeball of camera-type eye', 'decreased size of the bone of free limb or fin', 'synovial joint phenotype', 'Hypoplasia of the ulna', 'aplasia or hypoplasia of ulna', 'decreased size of the limb endochondral element', 'cranial nerve phenotype', 'nerve of head region phenotype', 'Abnormal cranial nerve physiology', 'paralysed cranial nerve', 'shape of palpebral fissure phenotype', 'Almond-shaped palpebral fissure', 'Abnormal shape of the palpebral fissure', 'opaque anatomical entity', 'lens of camera-type eye phenotype', 'lens of camera-type eye morphology phenotype', 'fused pedal digit and anatomical entity', 'fused anatomical entity and pedal digit', 'Toe syndactyly', 'Abnormal localization of kidney', 'decreased biological_process in multicellular organism', 'Hypopigmentation of the skin', 'decreased size of the endochondral bone', 'Abnormal choanae morphology', 'increased size of the multi-tissue structure', 'posterior nasal aperture phenotype', 'Abnormal nasal morphology', 'naris atresia', 'internal naris atresia', 'posterior nasal aperture', 'olfactory system', 'decreased size of the forelimb zeugopod bone', 'nerve of head region', 'internal naris', 'olfactory organ phenotype', 'posterior nasal aperture atresia', 'chemosensory system', 'fused pedal digit and pedal digit', 'decreased qualitatively system process', 'sensory perception of light stimulus phenotype', 'Visual impairment', 'decreased qualitatively sensory perception', 'structure with developmental contribution from neural crest, asymmetrically curved phenotype', 'pelvic girdle skeleton', 'sensory perception', 'Abnormality of vision', 'decreased qualitatively multicellular organismal process', 'decreased qualitatively visual perception', 'hindlimb stylopod morphology phenotype', 'femur', 'High palate', 'bone of hip region phenotype', 'hindlimb stylopod', 'femur endochondral element', 'leg bone', 'pelvic girdle bone/zone phenotype', 'leg bone phenotype', 'upper leg bone phenotype', 'decreased multicellular organism development', 'fused digit and digit', 'fused manual digit and anatomical entity', 'fused anatomical entity and manual digit', 'fused anatomical entity and digit', 'fused digit and anatomical entity', 'fused manual digit and manual digit', 'fused anatomical entity and anatomical entity', 'decreased number of platelet', 'secretory cell', 'biogenic amine secreting cell', 'Choanal atresia', 'Abnormal platelet morphology', 'joint of girdle', 'cerebral amyloid angiopathy', 'platelet phenotype', 'irregular bone phenotype', 'platelet', 'Thrombocytopenia', 'neural crest-derived structure, curved phenotype', 'Abnormal platelet count', 'number of platelet phenotype', 'increased size of the mesoderm-derived structure', 'increased length of the multicellular anatomical structure', 'increased size of the tube', 'abdominal segment element physiology phenotype', 'ureter morphology phenotype', 'decreased qualitatively sensory perception of light stimulus', 'pelvic region element', 'Abnormal ureter morphology', 'ureter', 'renal pelvis/ureter', 'excretory tube phenotype', 'excretory tube', 'increased size of the excretory tube', 'increased size of the pelvic region element', 'mucosa of stomach phenotype', 'increased size of the abdominal segment element', 'cranial nerve physiology phenotype', 'Abnormality of the ureter', 'Hydroureter', 'incomplete closing of the cardiac septum', 'eyelid apraxia', 'organ part physiology phenotype', 'atrial septum morphology', 'Abnormal cardiac septum morphology', 'Abnormal uterus morphology', 'decreased sensory perception', 'septum', 'cardiac atrium phenotype', 'cardiac atrium', 'cardiac septum morphology phenotype', 'cardiac septum phenotype', 'delayed sorocarp development', 'sorocarp development phenotype', 'biological process involved in intraspecies interaction between organisms phenotype', 'interatrial septum morphology phenotype', 'anatomical structure development phenotype', 'delayed anatomical structure development', 'socially cooperative development phenotype', 'Neurodevelopmental delay', 'stomach', 'biological process involved in intraspecies interaction between organisms', 'internal male genitalia phenotype', 'number of sperm phenotype', 'decreased developmental process', 'Functional abnormality of male internal genitalia', 'absent sperm in the semen', 'germ line cell', 'haploid cell', 'decreased developmental process involved in reproduction', 'material anatomical entity, asymmetrically curved phenotype', 'decreased gamete generation', 'decreased spermatogenesis', 'absent germ cell', 'decreased multicellular organismal reproductive process', 'pelvic girdle bone/zone morphology phenotype', 'sperm', 'decreased reproductive process', 'decreased qualitatively developmental process', 'morphology of organelle phenotype', 'absent anatomical entity in the semen', 'gamete', 'internal male genitalia', 'cerebrospinal fluid', 'developmental process involved in reproduction phenotype', 'spermatogenesis', 'anatomical entity dysfunction in independent continuant', 'paralysed anatomical entity', 'Puberty and gonadal disorders', 'Abnormal male urethral meatus morphology', 'developmental process rate phenotype', 'Hypogonadism', 'decreased functionality of the gonad', 'external ectoderm morphology phenotype', 'increased size of the sense organ', 'Joint dislocation', 'decreased functionality of the reproductive organ', 'decreased functionality of the reproductive structure', 'increased size of the camera-type eye', 'reproductive structure physiology phenotype', 'reproductive organ physiology phenotype', 'decreased functionality of the material anatomical entity', 'decreased functionality of the anatomical entity', 'cognition', 'Neurodevelopmental abnormality', 'decreased male gamete generation', 'Intellectual disability', 'Abnormality of mental function', 'trunk blood vessel phenotype', 'size of camera-type eye phenotype', 'coronary vessel morphology phenotype', 'incomplete closing of the thoracic segment blood vessel', 'posterior nasal aperture morphology phenotype', 'male gamete', 'incomplete closing of the heart blood vessel', 'incomplete closing of the systemic artery', 'skin of eyelid', 'heart blood vessel', 'organ component layer physiology phenotype', 'vasculature of organ phenotype', 'incomplete closing of the trunk blood vessel', 'incomplete closing of the artery', 'thoracic segment blood vessel', 'ductus arteriosus morphology phenotype', 'coronary vessel', 'spermatogenesis phenotype', 'Patent ductus arteriosus', 'trunk blood vessel', 'anatomical structure morphology in the heart phenotype', 'vasculature of trunk', 'decreased pigmentation in multicellular organism', 'internal naris phenotype', 'Congenital malformation of the great arteries', 'male germ cell', 'Abnormal ileum morphology', 'Atrial septal defect', 'Meckel diverticulum', 'ileum', 'large intestine morphology phenotype', 'anatomical structure formation involved in morphogenesis', 'hindgut morphology phenotype', 'parasympathetic nervous system', 'tube closure phenotype', 'hindgut phenotype', 'peripheral nervous system phenotype', 'Abnormal enteric nervous system morphology', 'neural tube formation', 'hypospadia; hypospadias', 'enteric nervous system morphology', 'morphogenesis of an epithelium', 'number of anatomical enitites of type organ component layer phenotype', 'morphogenesis of embryonic epithelium', 'increased size of the colon', 'Abnormal enteric ganglion morphology', 'lower digestive tract', 'colon', 'increased size of the subdivision of digestive tract', 'internal anal region', 'Abnormal autonomic nervous system morphology', 'increased size of the subdivision of tube', 'tube morphogenesis', 'tissue morphogenesis', 'embryonic morphogenesis', 'tube development', 'system development', 'tissue development', 'colon morphology phenotype', 'neural tube closure phenotype', 'kidney morphology phenotype', 'renal system morphology phenotype', 'kidney phenotype', 'kidney', 'upper urinary tract', 'Abnormality of the upper urinary tract', 'decreased biological_process in skin of body', 'cavitated compound organ phenotype', 'aplasia or hypoplasia of radius bone', 'Aplasia/Hypoplasia of the radius', 'Aplasia/hypoplasia involving forearm bones', 'radius bone morphology phenotype', 'Scoliosis', 'Abnormal lens morphology', 'migrating mesenchyme population', 'Abnormal curvature of the vertebral column', 'epithelial vesicle', 'scoliosis', 'vertebral column morphology phenotype', 'cell condensation', 'presomitic mesoderm', 'somite', 'external ectoderm', 'vertebral column phenotype', 'developing mesenchymal condensation', 'cell condensation phenotype', 'Abnormality of the vertebral column', 'Proptosis', 'anatomical entity morphology in the pelvic complex phenotype', 'flat longitudinal arch of pes', 'Abnormal renal morphology', 'flat anatomical entity', 'increased number of organ component layer', 'curvature anatomical entity', 'frontal lobe', 'vault of skull', 'paraxial mesoderm morphology phenotype', 'development of anatomical entity phenotype', 'neurocranium phenotype', 'neurocranium bone', 'chemosensory system phenotype', 'gray matter of telencephalon', 'Abnormal spermatogenesis', 'cartilaginous neurocranium phenotype', 'decreased qualitatively nervous system process', 'presumptive paraxial mesoderm phenotype', 'frontal cortex', 'cranial nerve', 'brain gray matter', 'lens of camera-type eye', 'cerebral hemisphere gray matter', 'decreased sensory perception of mechanical stimulus', 'cartilaginous neurocranium', 'cranium', 'presumptive paraxial mesoderm', 'head mesenchyme morphology phenotype', 'lobe of cerebral hemisphere', 'neurocranium bone phenotype', 'embryo development rate phenotype', 'epithelium development', 'gray matter', 'cerebral cortex', 'shape of frontal cortex phenotype', 'forehead', 'Abnormal frontal bone morphology', 'cranium morphology phenotype', 'cerebral hemisphere', 'paraxial mesoderm', 'internal male genitalia physiology phenotype', 'head paraxial mesoderm morphology phenotype', 'multi cell part structure phenotype', 'forehead phenotype', 'prominent anatomical entity', 'nervous system cell part layer phenotype', 'pallium', 'cranial bone', 'head paraxial mesoderm', 'multi cell part structure', 'flat bone phenotype', 'cranial bone phenotype', 'frontal cortex morphology phenotype', 'central nervous system gray matter layer phenotype', 'brain gray matter phenotype', 'central nervous system cell part cluster phenotype', 'decreased size of the bone element', 'ectoderm-derived structure atresia', 'anatomical structure atresia', 'multicellular anatomical structure atresia', 'closing of the anatomical entity', 'Anal atresia', 'anus atresia', 'closing of the multicellular anatomical structure', 'anus phenotype', 'Abnormality of thrombocytes', 'Abnormal anus morphology', 'upper leg bone', 'migrating mesenchyme population phenotype', 'closing of the material anatomical entity', 'Abnormality of the anus', 'anatomical conduit atresia', 'closing of the anatomical structure', 'hemoglobin', 'ossification', 'organ system subdivision physiology phenotype', 'Reduced bone mineral density', 'anatomical entity mass density phenotype', 'lymphocyte of B lineage', 'absent sperm', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'Decreased anatomical entity mass density', 'leukocyte physiology phenotype', 'anatomical entity atresia', 'single nucleate cell', 'decreased qualitatively developmental process involved in reproduction', 'Abnormal large intestine morphology', 'bone ossification', 'Abnormal bone structure', 'cornea', 'material anatomical entity mass phenotype', 'Abnormal shape of the frontal region', 'tunica fibrosa of eyeball', 'Strabismus', 'location of camera-type eye phenotype', 'cornea phenotype', 'arm bone phenotype', 'forelimb zeugopod', 'forelimb skeleton phenotype', 'Abnormal forearm bone morphology', 'decreased length of forelimb endochondral element', 'Abnormal morphology of ulna', 'forelimb endochondral element phenotype', 'bone of pectoral complex morphology phenotype', 'gamete phenotype', 'Abnormal long bone morphology', 'zeugopod', 'forelimb zeugopod skeleton', 'forelimb zeugopod morphology phenotype', 'ulna', 'zeugopod phenotype', 'Abnormal forearm morphology', 'Abnormal upper limb bone morphology', 'increased number of myeloid cell', 'intromittent organ phenotype', 'external soft tissue zone', 'intermediate mesoderm', 'undifferentiated genital tubercle', 'embryonic cardiovascular system', 'Abnormal preputium morphology', 'external soft tissue zone phenotype', 'developing mesenchymal condensation phenotype', 'prepuce', 'embryonic cloacal fold', 'penis morphology phenotype', 'Abnormal penis morphology', 'food storage organ phenotype', 'anal region', 'trunk mesenchyme phenotype', 'prepuce of penis phenotype', 'intromittent organ', 'penis phenotype', 'pes bone phenotype', 'hindlimb bud phenotype', 'asymmetrically curved cornea', 'visual perception phenotype', 'decreased number of myeloid cell', 'digitopodium bone phenotype', 'increased size of the anatomical conduit', 'bone of pelvic complex phenotype', 'decreased length of forelimb bone', 'bone of pelvic complex', 'Decreased anatomical entity mass', 'septum phenotype', 'Clubbing of toes', 'pedal digitopodium bone', 'phalanx of pes', 'hindlimb', 'pedal digit morphology phenotype', 'neural tube development', 'pes', 'clavate digit', 'segment of pes', 'naris phenotype', 'hindlimb long bone', 'skeleton of pelvic complex', 'pelvic appendage bud', 'Abnormal pelvic girdle bone morphology', 'decreased qualitatively reproductive process', 'hindlimb skeleton phenotype', 'material anatomical entity, curved phenotype', 'phalanx phenotype', 'Global developmental delay', 'leg', 'limb joint', 'Abnormal toe phalanx morphology', 'hindlimb phenotype', '3-D shape anatomical entity', 'large intestine', 'Frontal bossing', 'pedal digit bone', 'shape of digit phenotype', 'bone of pelvic complex morphology phenotype', 'pelvic appendage bud phenotype', 'Cranial nerve paralysis', 'Abnormality of the lower limb', 'pedal digitopodium bone phenotype', 'femur endochondral element phenotype', 'hindlimb endochondral element phenotype', 'autopod endochondral element phenotype', 'pelvic appendage phenotype', 'arch of centrum of vertebra phenotype', 'skeleton of pedal acropodium', 'multicellular anatomical structure morphology in the heart phenotype', 'skeleton of pedal digitopodium', 'Clubbing', 'clavate anatomical entity', 'phalanx of pes morphology phenotype', 'morphology of nucleus phenotype', 'pes bone', 'hindlimb skeleton', 'Abnormality of the urethra', 'incomplete closing of the ductus arteriosus', 'posterior region of body', 'limb long bone phenotype', 'pelvic appendage skeleton', 'pedal digit', 'Abnormal toe morphology', 'olfactory organ', 'pes phenotype', 'phalanx endochondral element phenotype', 'homeostatic process phenotype', 'sexual reproduction', 'bone of pectoral complex phenotype', 'metabolic process', 'Abnormal cellular phenotype', 'decreased material anatomical entity mass', 'decreased height of the multicellular organism', 'multicellular organism height phenotype', 'decreased height of the anatomical entity', 'size of multicellular organism phenotype', 'decreased functionality of the organ', 'anatomical entity height phenotype', 'skeleton of pes', 'Abnormality of body height', 'Anemia', 'myeloid cell homeostasis', 'cellular developmental process', 'multicellular organismal-level homeostasis', 'articulation phenotype', 'oxygen accumulating cell', 'food storage organ', 'myeloid cell differentiation', 'consumption behavior phenotype', 'anemia', 'decreased size of the long bone', 'polydipsia', 'Sideroblastic anemia', 'hindlimb endochondral element', 'erythrocyte', 'hematopoietic system morphology phenotype', 'erythrocyte homeostasis', 'number of myeloid cell phenotype', 'cell differentiation', 'cellular process', 'homeostatic process', 'Facial asymmetry', 'asymmetry of face phenotype', 'asymmetry of anatomical entity phenotype', 'Pes planus', 'Abnormal facial shape', 'Slanting of the palpebral fissure', 'abdominal wall', 'protruding anatomical entity', 'umbilical cord phenotype', 'hip joint', 'umbilical cord', 'hip dislocation', 'indifferent external genitalia', 'extraembryonic structure phenotype', 'conceptus', 'abdominal viscera', 'entire extraembryonic component', 'Abnormal umbilicus morphology', 'Abnormality of the abdominal wall', 'Abdominal wall defect', 'Hernia of the abdominal wall', 'connective tissue phenotype', 'developmental process phenotype', 'herniated abdominal wall', 'Hernia', 'sloped anatomical entity', 'deviation of manual digit 5 towards the middle', 'Deviation of finger', 'mucosa of stomach', 'limb long bone morphology phenotype', 'myeloid cell', 'Clinodactyly', 'Abnormal 5th finger morphology', 'ganglion of peripheral nervous system', 'spatial pattern of anatomical entity phenotype', 'deviation of manual digit towards the middle', 'deviation of anatomical entity', 'hindgut', 'Macule', 'Multiple cafe-au-lait spots', 'Cafe-au-lait spot', 'Hypermelanotic macule', 'nose phenotype', 'Localized skin lesion', 'anterior segment of eyeball', 'girdle bone/zone', 'Abnormal uvea morphology', 'bicornuate anatomical entity', 'formed material anatomical entity', 'decreased qualitatively sensory perception of sound', 'germ cell', 'anterior uvea', 'uvea', 'anterior chamber of eyeball morphology phenotype', 'abdomen element physiology phenotype', 'Aplasia/Hypoplasia affecting the anterior segment of the eye', 'Aplasia/Hypoplasia of the iris', 'Ocular anterior segment dysgenesis', 'aplasia or hypoplasia of eyeball of camera-type eye', 'cranial neuron projection bundle phenotype', 'formed anterior chamber of eyeball', 'iris', 'gamete generation phenotype', 'organ subunit', 'Aplasia/Hypoplasia affecting the uvea', 'formed multicellular anatomical structure', 'formed organ subunit', 'male gamete generation phenotype', 'iris phenotype', 'manual digit 5', 'organ subunit phenotype', 'malformed anatomical entity', 'organelle', 'formed anatomical structure', 'chordate embryonic development', 'aplasia or hypoplasia of uvea', 'anterior chamber of eyeball', 'aplasia or hypoplasia of iris', 'ear morphology phenotype', 'Abnormal pinna morphology', 'deviation of anatomical entity towards the middle', 'external ear phenotype', 'vestibulo-auditory system phenotype', 'external ear', 'Abnormality of the outer ear', 'external ear morphology phenotype', 'Abnormality of the ear', 'Abnormal ear morphology', 'vestibulo-auditory system', 'shape of external ear phenotype', 'cornea scarring; corneal scarring', 'skeleton of upper jaw', 'consumption behavior', 'aplasia or hypoplasia of palatine uvula', 'palatine uvula morphology phenotype', 'maxillary prominence', 'cell development', 'soft palate morphology phenotype', 'maxillary prominence morphology phenotype', 'Abnormal hip joint morphology', 'morphological feature', 'palatine uvula phenotype', 'polycythemia', 'decreased size of the endochondral element', 'palatine uvula', 'embryonic cloaca', 'Aplasia/Hypoplasia of the uvula', 'digit 1 plus metapodial segment', 'forelimb endochondral element', 'decreased size of the multicellular organism', 'limb long bone', 'cornea, curved phenotype', 'integumental system', 'ectoderm-derived structure phenotype', 'aorta morphology phenotype', 'arch of centrum of vertebra', 'increased pigmentation in skin of body', 'decreased qualitatively pigmentation', 'integument phenotype', 'Abnormal eyelid morphology', 'skin of body phenotype', 'internal genitalia phenotype', 'decreased multicellular anatomical structure mass', 'embryo development ending in birth or egg hatching', 'organ part', 'leg phenotype', 'pigmentation phenotype', 'Eukaryota', 'optic cup morphology phenotype', 'anatomical projection phenotype', 'Abnormality of the skeletal system', 'Abnormal gastrointestinal tract morphology', 'Abnormal calvaria morphology', 'Abnormality of the face', 'palpebral fissure phenotype', 'multi organ part structure phenotype', 'increased pigmentation', 'presumptive ectoderm phenotype', 'Abnormality of chromosome stability', 'decreased length of anatomical structure', 'connective tissue', 'anatomical entity physiology phenotype', 'concave 3-D shape anatomical entity', 'decreased length of multicellular anatomical structure', 'trachea phenotype', 'craniofacial/craniocervical phenotype', 'anatomical line', 'head bone phenotype', 'Abnormality of head or neck', 'mucosa', 'heart tube', 'renal system phenotype', 'dilated anatomical entity', 'Abnormality of the ocular adnexa', 'neural plate phenotype', 'immaterial anatomical entity', 'axial skeleton plus cranial skeleton phenotype', 'camera-type eye morphology phenotype', 'pedal digit digitopodial skeleton', 'decreased size of the palpebral fissure', 'decreased length of anatomical entity', 'nose', 'Abnormal heart valve morphology', 'Abnormality of the upper limb', 'neurocranium morphology phenotype', 'orbital region phenotype', 'naris', 'pelvic complex', 'reflex', 'decreased size of the orifice', 'absent material anatomical entity in the reproductive system', 'decreased length of bone of appendage girdle complex', 'bone element mass density phenotype', 'Abnormality of the head', 'vasculature of central nervous system plus retina', 'pedal digit phenotype', 'decreased length of orifice', 'decreased number of hematopoietic cell', 'absent multicellular anatomical structure in the reproductive system', 'decreased size of the multicellular anatomical structure', 'decreased qualitatively anatomical structure development', 'uvea morphology phenotype', 'ectoderm-derived structure physiology phenotype', 'Aplasia/Hypoplasia of the ulna', 'increased size of the anatomical structure', 'multicellular organismal process phenotype', 'anatomical projection', 'hematopoietic cell', 'decreased length of limb endochondral element', 'Abnormality of eye movement', 'Abnormality of the kidney', 'digitopodium bone', 'decreased size of the anatomical structure', 'skull morphology phenotype', 'manual digit', 'camera-type eye physiology phenotype', 'cartilaginous condensation phenotype', 'flat bone', 'bone of pectoral complex', 'organ physiology phenotype', 'incomplete closing of the organ part', 'physiologic nystagmus', 'nervous system physiology phenotype', 'decreased size of the forelimb bone', 'forebrain phenotype', 'neuron projection bundle', 'absent organ in the male reproductive system', 'increased qualitatively response to stimulus', 'bone of appendage girdle complex', 'Abnormal cornea morphology', 'increased size of the ventricle of nervous system', 'Micrognathia', 'decreased functionality of the organ component layer', 'musculoskeletal movement phenotype', 'neuromuscular process', 'material anatomical entity morphology in the heart phenotype', 'brain ventricle', 'anatomical structure mass phenotype', 'voluntary musculoskeletal movement', 'nervous system', 'skeleton of upper jaw phenotype', 'subdivision of digestive tract phenotype', 'epithelial tube', 'increased number of material anatomical entity', 'delayed developmental process', 'behavior process phenotype', 'facial skeleton phenotype', 'increased qualitatively biological_process', 'Abnormal reproductive system morphology', 'Growth delay', 'Abnormal nervous system physiology', 'nervous system process', 'increased size of the multicellular anatomical structure', 'acidosis', 'cardiovascular system phenotype', 'vertebra phenotype', 'telencephalon morphology phenotype', 'Aplasia/Hypoplasia affecting the eye', 'behavior process', 'pectoral appendage bud', 'autonomic nervous system', 'central nervous system phenotype', 'voluntary musculoskeletal movement phenotype', 'vascular plexus phenotype', 'voluntary movement behavior phenotype', 'blood vasculature', 'response to stimulus phenotype', 'pelvic region element phenotype', 'Abnormal vascular morphology', 'strabismus', 'Abnormality of the cardiovascular system', 'gamete generation', 'decreased functionality of the anatomical structure', 'Abnormal ocular adnexa morphology', 'Deviation of the hand or of fingers of the hand', 'limb endochondral element', 'gonad', 'limb bone', 'eye phenotype', 'systemic artery phenotype', 'Hyperpigmentation of the skin', 'anterior segment of eyeball morphology phenotype', 'drooping anatomical entity', 'decreased qualitatively multicellular organismal reproductive process', 'bone structure', 'systemic artery', 'roof of mouth morphology phenotype', 'upper urinary tract phenotype', 'manual digit 1 or 5', 'anatomical cluster', 'Abnormal systemic arterial morphology', 'anatomical structure morphogenesis', 'great vessel of heart', 'Abnormality of skin pigmentation', 'decreased pigmentation in skin of body', 'material anatomical entity physiology phenotype', 'proximo-distal subdivision of respiratory tract phenotype', 'vascular system', 'central nervous system gray matter layer', 'vasculature phenotype', 'behavior', 'number of cell phenotype', 'increased response to external stimulus', 'anatomical cavity', 'artery', 'aorta', 'systemic arterial system', 'blood cell', 'postcranial axial skeleton', 'absent organ in the reproductive system', 'blood vessel', 'orbital region', 'limb skeleton subdivision', 'anatomical conduit', 'decreased biological_process', 'thoracic cavity blood vessel phenotype', 'immaterial entity', 'cardiovascular system morphology phenotype', 'Irregular hyperpigmentation', 'appendicular skeletal system', 'undifferentiated genital tubercle morphology phenotype', 'erythrocyte morphology phenotype', 'vascular system morphology phenotype', 'increased number of multicellular anatomical structure', 'opaque lens of camera-type eye', 'localised gonad', 'increased height of the secondary palate', 'blood vessel phenotype', 'enteric ganglion', 'great vessel of heart morphology phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'urethra phenotype', 'haemolymphatic fluid phenotype', 'thoracic cavity blood vessel', 'forelimb long bone phenotype', 'female reproductive organ', 'Aplasia/Hypoplasia involving the central nervous system', 'Abnormality of metabolism/homeostasis', 'upper digestive tract', 'cranial neuron projection bundle', 'Abnormal morphology of the great vessels', 'blood', 'blood island phenotype', 'decreased number of anatomical entity', 'pharyngeal arch 1', 'autonomic ganglion', 'Abnormal immune system morphology', 'tube closure', 'decreased number of anatomical structure', 'transparent eye structure', 'epithelial tube morphogenesis', 'Abnormality of blood and blood-forming tissues', 'liver phenotype', 'increased height of the material anatomical entity', 'skeleton of lower jaw phenotype', 'nucleate cell', 'deviation of manual digit 5', 'semi-lunar valve', 'Opisthokonta', 'foregut phenotype', 'long bone phenotype', 'motile cell', 'hindlimb bud', 'palpebral fissure', 'bodily fluid', 'bone of craniocervical region phenotype', 'decreased size of the material anatomical entity', 'presomitic mesoderm morphology phenotype', 'Aplasia/hypoplasia involving bones of the hand', 'forelimb zeugopod bone morphology phenotype', 'cell', 'Epicanthus', 'Abnormal leukocyte morphology', 'orifice atresia', 'Finger clinodactyly', 'oviduct', 'Nystagmus', 'facial bone', 'Abnormality of the lower urinary tract', 'decreased number of anatomical entity in the blood', 'Abnormality of the vasculature', 'decreased number of leukocyte in the blood', 'cardiovascular system', 'Abnormal brain morphology', 'artery morphology phenotype', 'developmental process', 'multi-limb segment region', 'uterus morphology phenotype', 'leukocyte', 'cortex of cerebral lobe', 'Abnormal reflex', 'arm phenotype', 'bodily fluid phenotype', 'nerve', 'endochondral bone', 'anucleate cell', 'hindlimb morphology phenotype', 'meso-epithelium', 'respiratory system', 'primary subdivision of cranial skeletal system phenotype', 'increased size of the lateral structure', 'zeugopodial skeleton', 'number of anatomical entities of type anatomical entity in blood phenotype', 'number of anatomical enitites of type material anatomical entity phenotype', 'Abnormal leukocyte count', 'cell phenotype', 'phalanx', 'decreased sensory perception of sound', 'phalanx morphology phenotype', 'multicellular organismal movement phenotype', 'epithelial tube phenotype', 'leukocyte morphology phenotype', 'Cataract', 'pre-chordal neural plate phenotype', 'future nervous system', 'Abnormal aortic morphology', 'Hypertelorism', 'multi organ part structure physiology phenotype', 'jaw skeleton morphology phenotype', 'multi-tissue structure', 'thoracic segment organ', 'prepuce of penis', 'optic vesicle phenotype', 'Abnormal ear physiology', 'orifice', 'localised testis', 'reflexive behavior', 'multi-tissue structure phenotype', 'Abnormal cellular immune system morphology', 'immune system process', 'heart primordium', 'sclerotome phenotype', 'Abnormal bone ossification', 'Abnormal axial skeleton morphology', 'arterial blood vessel', 'phenotypic effect', 'eye primordium phenotype', 'sensory perception of light stimulus', 'decreased length of material anatomical entity', 'neural plate morphology phenotype', 'mandible morphology phenotype', 'ectoderm', 'decreased number of cell', 'cerebrospinal fluid morphology phenotype', 'cerebral cortex phenotype', 'internal female genitalia', 'aganglionic megacolon', 'nervous system process phenotype', 'cardiac valve morphology phenotype', 'epithelial fold', 'unilaminar epithelium phenotype', 'flattened anatomical entity', 'increased biological_process', 'intermediate mesoderm morphology phenotype', 'blastula', 'sensory system phenotype', 'endocrine system', 'unilaminar epithelium', 'decreased length of endochondral bone', 'structure with developmental contribution from neural crest physiology phenotype', 'myocardium', 'non-material anatomical boundary', 'Umbilical hernia', 'presumptive structure phenotype', 'skeletal element phenotype', 'immaterial anatomical entity phenotype', 'entity', 'decreased number of material anatomical entity', 'primary neural tube formation', 'musculoskeletal movement', 'Abnormality of the male genitalia', 'Abnormality of the nose', 'absent multicellular anatomical structure', 'Syndactyly', 'pedal digit plus metapodial segment', 'entire sense organ system', 'sclerotome', 'vision/eye phenotype', 'anatomical line between pupils', 'heart layer phenotype', 'response to external stimulus phenotype', 'viscus', 'localised material anatomical entity', 'hindlimb bone phenotype', 'ecto-epithelium', 'Neoplasm by anatomical site', 'serotonin secreting cell', 'optic vesicle', 'heart plus pericardium', 'neurectoderm', 'increased number of brain ventricle in the cerebrospinal fluid', 'cerebral hemisphere morphology phenotype', 'Abnormal limb bone morphology', 'soft palate', 'epithelium', 'simple eye phenotype', 'multicellular organism phenotype', 'skin of body morphology phenotype', 'zone of organ phenotype', 'epithelium phenotype', 'response to stimulus', 'subdivision of organism along main body axis phenotype', 'dermal bone phenotype', 'location of anatomical entity phenotype', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'Hematological neoplasm', 'localised multicellular anatomical structure', 'artery phenotype', 'Abnormality of the endocrine system', 'Abnormal morphology of female internal genitalia', 'reproductive structure', 'continuant', 'neural crest morphology phenotype', 'primary subdivision of skull phenotype', 'aplasia or hypoplasia of skeleton', 'Triphalangeal thumb', 'lateral structure', 'vertebra', 'mesoderm-derived structure', 'Weight loss', 'neuron projection bundle phenotype', 'forelimb skeleton', 'Abnormality of the curvature of the cornea', 'skeletal system', 'dermal bone', 'large intestine phenotype', 'tracheoesophageal fistula', 'phalanx endochondral element', 'subdivision of head', 'ulna endochondral element', 'All', 'pectoral appendage bud phenotype', 'anatomical structure formation involved in morphogenesis phenotype', 'digestive tract', 'testis phenotype', 'non-connected functional system', 'embryonic tissue', 'disconnected anatomical group', 'absent gonad in the reproductive system', 'blood phenotype', 'aortic valve morphology phenotype', 'heart layer morphology phenotype', 'decreased length of long bone', 'immature eye phenotype', 'manus', 'embryonic autopod plate morphology phenotype', 'dentary phenotype', 'blood island', 'blood cell phenotype', 'subdivision of skeleton phenotype', 'lateral plate mesoderm phenotype', 'endo-epithelium', 'body part movement', 'heart vasculature', 'Abnormal morphology of the radius', 'reproductive organ phenotype', 'Abnormal eye morphology', 'resistance to salt stress', 'formed organ part', 'autopodial skeleton', 'Abnormal lower limb bone morphology', 'cardiac valve', 'digit 5', 'eyelid', 'transparent eye structure phenotype', 'neural tube morphology phenotype', 'bone element phenotype', 'increased size of the zone of organ', 'skeletal joint dislocation', 'mandible phenotype', 'Abnormal mandible morphology', 'Recurrent infections', 'erythroid lineage cell', 'voluntary movement behavior', 'limb bud morphology phenotype', 'Abnormal hand morphology', 'neural tube closure', 'embryo morphology phenotype', 'germ layer / neural crest', 'simple eye', 'autopodial extension', 'face morphology phenotype', 'phenotype', 'Hypopigmented skin patches', 'organ part phenotype', 'circulatory system phenotype', 'root', 'mononuclear leukocyte', 'dysesthesia; hyperalgesia', 'weight loss', 'Cleft palate', 'organ', 'incomplete closing of the interatrial septum', 'arm bone', 'upper limb segment', 'Dolichocephaly', 'manual digit 1 plus metapodial segment', 'skeletal joint morphology phenotype', 'bone element', 'subdivision of organism along appendicular axis', 'Decreased body weight', 'somite phenotype', 'Aplasia/Hypoplasia of fingers', 'drinking behavior phenotype', 'incomplete closing of the anatomical wall', 'haemolymphatic fluid', 'paired limb/fin skeleton', 'absent male reproductive organ', 'decreased length of anatomical conduit', 'lower limb segment phenotype', 'Abnormal digit morphology', 'anatomical entity morphology in the pectoral complex phenotype', 'Microphthalmia', 'increased length of the immaterial anatomical entity', 'Pyridoxine-responsive sideroblastic anemia', 'digestive tract epithelium', 'immune system phenotype', 'Abnormal small intestine morphology', 'reproductive process phenotype', 'anterior lateral plate mesoderm', 'kinesthetic behavior', 'transudate', 'head', 'decreased qualitatively biological_process', 'musculature of body', 'socially cooperative development', 'gonad physiology phenotype', 'skeleton of limb', 'organ system subdivision phenotype', 'erythroid lineage cell morphology phenotype', 'Abnormality iris morphology', 'lateral plate mesoderm morphology phenotype', 'increased size of the anatomical entity', 'decreased number of anatomical structure in the multicellular organism', 'forebrain', 'subdivision of head phenotype', 'male urethra', 'manual digitopodium region', 'Abnormal finger morphology', 'pectoral appendage phenotype', 'zone of bone organ', 'skeletal element', 'Abnormal male reproductive system physiology', 'forelimb bud phenotype', 'skeleton of limb phenotype', 'mesoderm phenotype', 'wall of stomach', 'neuromuscular process phenotype', 'hip joint morphology phenotype', 'pedal digitopodium region', 'aortic system', 'germ layer', 'eukaryotic cell', 'trunk region element physiology phenotype', 'upper limb segment phenotype', 'anatomical system phenotype', 'skeleton of manus', 'lower jaw region', 'anatomical entity morphology phenotype', 'pectoral appendage', 'structure with developmental contribution from neural crest', 'Abnormal soft palate morphology', 'limb bone phenotype', 'system', 'appendage girdle region phenotype', 'vessel phenotype', 'skeleton of pectoral complex', 'bone of appendage girdle complex phenotype', 'neural plate', 'paired limb/fin bud', 'subdivision of trunk', 'material anatomical entity phenotype', 'anatomical conduit phenotype', 'outflow tract of ventricle phenotype', 'manual digit 1 phalanx endochondral element', 'cavitated compound organ', 'arterial system', 'number of leukocyte phenotype', 'Abnormality of the urinary system', 'Abnormality of limbs', 'visual system', 'subdivision of tube phenotype', 'Abnormal size of the palpebral fissures', 'alimentary part of gastrointestinal system morphology phenotype', 'Abnormality of bone mineral density', 'face phenotype', 'blood vessel morphology phenotype', 'regional part of nervous system phenotype', 'Azoospermia', 'dilated colon', 'Decreased bone element mass density', 'pelvic appendage skeleton phenotype', 'digit phenotype', 'decreased size of the subdivision of organism along main body axis', 'multicellular anatomical structure, asymmetrically curved phenotype', 'multicellular organismal process', 'increased number of anatomical entity in the cerebrospinal fluid', 'increased size of the simple eye', 'camera-type eye phenotype', 'cardiac ventricle', 'hemopoiesis', 'system process', 'orifice phenotype', 'digestive system morphology phenotype', 'anatomical entity morphology in the heart phenotype', 'Abnormal external genitalia morphology', 'Decreased fertility in males', 'embryonic autopod plate', 'digit 5 plus metapodial segment', 'Abnormal cardiovascular system morphology', 'trunk phenotype', 'increased length of the anatomical line', 'lateral plate mesoderm', 'mesoderm-derived structure phenotype', 'Absent testis', 'ductus arteriosus', 'system process phenotype', 'nervous system phenotype', 'circulatory system', 'material anatomical entity', 'Abnormality of the immune system', 'limb endochondral element phenotype', 'pelvic region of trunk', 'mouth morphology phenotype', 'autopodial extension phenotype', 'cardiac ventricle phenotype', 'pharyngeal arch morphology phenotype', 'ocular adnexa phenotype', 'decreased system process', 'incomplete closing of the septum', 'pectoral complex', 'embryo phenotype', 'cardiac chamber', 'vestibulo-ocular reflex phenotype', 'skeleton of lower jaw', 'pectoral appendage skeleton', 'neural groove phenotype', 'deviation of manual digit', 'limb skeleton subdivision phenotype', 'appendicular skeleton', 'cranial skeletal system', 'arm', 'decreased size of the organ', 'Aplasia/hypoplasia involving bones of the extremities', 'germ layer morphology phenotype', 'increased length of the anatomical entity', 'subdivision of organism along main body axis', 'outflow part of left ventricle morphology phenotype', 'vasculature', 'hindlimb joint phenotype', 'dense mesenchyme tissue phenotype', 'limb phenotype', 'primitive urogenital sinus morphology phenotype', 'increased size of the ureter', 'embryonic structure', 'anatomical entity', 'paired limb/fin skeleton phenotype', 'entire embryonic mesenchyme', 'bone of jaw phenotype', 'autopod bone phenotype', 'Deviation of the 5th finger', 'musculoskeletal system', 'limb bone morphology phenotype', 'heart left ventricle morphology phenotype', 'number of hematopoietic cell phenotype', 'increased reflex', 'phalanx of manus', 'developmental process involved in reproduction', 'musculature of body phenotype', 'Abnormality of the autonomic nervous system', 'pes morphology phenotype', 'forelimb morphology phenotype', 'limb segment phenotype', 'immature eye', 'multicellular organismal movement', 'cardiac septum', 'independent continuant', 'tissue', 'digit 1 digitopodial skeleton', 'subdivision of digestive tract', 'Aplasia/hypoplasia involving bones of the upper limbs', 'spinal cord morphology phenotype', 'neural crest-derived structure phenotype', 'future central nervous system', 'embryo', 'outflow part of left ventricle', 'multi-limb segment region phenotype', 'immune system morphology phenotype', 'biological_process', 'decreased size of the limb bone', 'anus morphology phenotype', 'germ layer phenotype', 'size of palpebral fissure phenotype', 'increased biological_process in skin of body', 'absent reproductive structure in the male reproductive system', 'segment of autopod', 'presomitic mesoderm phenotype', 'Abnormal skin morphology', 'uterus phenotype', 'external male genitalia phenotype', 'vasculature of central nervous system plus retina phenotype', 'stylopod', 'aplasia or hypoplasia of anatomical entity', 'visual system phenotype', 'organ system subdivision', 'abdomen element phenotype', 'foregut morphology phenotype', 'surface structure phenotype', 'anatomical entity morphology in the manus phenotype', 'decreased number of leukocyte', 'eyeball of camera-type eye phenotype', 'limb bud phenotype', 'eye movement phenotype', 'forelimb zeugopod phenotype', 'umbilicus morphology phenotype', 'esophagus phenotype', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'paired limb/fin', 'limb segment', 'increased size of the organ', 'radius endochondral element', 'vault of skull phenotype', 'pigmentation', 'vein morphology phenotype', 'Displacement of the urethral meatus', 'Aplasia/Hypoplasia involving bones of the skull', 'cranial nerve related reflex', 'aplasia or hypoplasia of manual digit', 'paired limb/fin segment phenotype', 'femur morphology phenotype', 'hematopoietic system phenotype', 'left cardiac chamber phenotype', 'Abnormality of the genital system', 'Abnormality of the musculoskeletal system', 'endochondral element', 'absent reproductive structure', 'neural crest-derived structure, asymmetrically curved phenotype', 'incomplete closing of the abdominal wall', 'decreased length of palpebral fissure', 'foregut', 'Sloping forehead', 'embryonic tissue phenotype', 'Abnormal aortic valve morphology', 'organism substance', 'great vessel of heart phenotype', 'growth phenotype', 'size of skull phenotype', 'appendage girdle complex', 'dorsal region element', 'biological_process rate phenotype', 'Short palpebral fissure', 'Abnormal blood vessel morphology', 'craniocervical region', 'increased size of the zone of skin', 'forelimb long bone', 'Abnormality of the palpebral fissures', 'respiratory system physiology phenotype', 'neocortex morphology phenotype', 'manus phenotype', 'pelvic appendage', 'genitourinary system phenotype', 'subdivision of skeleton', 'anatomical entity phenotype', 'thoracic cavity element', 'ulna hypoplasia', 'incomplete closing of the vessel', 'phalanx of pes phenotype', 'reflex phenotype', 'appendage phenotype', 'skeleton', 'respiratory system morphology phenotype', 'anatomical structure phenotype', 'meningomyelocele; myelomeningocele', 'face', 'Abnormal erythrocyte morphology', 'Abnormal involuntary eye movements', 'gastrointestinal system mucosa phenotype', 'ecto-epithelium phenotype', 'exocrine gland', 'skeletal system morphology phenotype', 'paired limb/fin phenotype', 'Renal hypoplasia/aplasia', 'Abnormal uvula morphology', 'localised reproductive organ', 'femur phenotype', 'umbilicus', 'amniotic fluid phenotype', 'manual digit 1', 'lateral structure physiology phenotype', 'autopod region phenotype', 'Abnormal renal physiology', 'appendicular skeleton morphology phenotype', 'decreased functionality of the multicellular anatomical structure', 'female reproductive system morphology phenotype', 'anatomical collection phenotype', 'girdle bone/zone phenotype', 'anatomical collection', 'Abnormal skeletal morphology', 'skeletal joint phenotype', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'decreased number of material anatomical entity in the multicellular organism', 'oral cavity morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'digit', 'cardiopharyngeal field', 'systemic artery morphology phenotype', 'peripheral nervous system morphology phenotype', 'mouth phenotype', 'anlage phenotype', 'segment of manus', 'digitopodium region', 'ocular adnexa physiology phenotype', 'formed chamber of eyeball', 'tube', 'olfactory system morphology phenotype', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'aorta phenotype', 'innominate bone morphology phenotype', 'extraembryonic structure', 'trachea morphology phenotype', 'acropodium region', 'anatomical structure physiology phenotype', 'paired limb/fin segment', 'response to external stimulus', 'longitudinal arch of pes', 'multi organ part structure', 'paired limb/fin bud phenotype', 'testis', 'epicanthal fold', 'decreased size of the skeletal element', 'autopod region morphology phenotype', 'increased size of the anatomical line', 'forelimb', 'forelimb bud', 'lateral structure phenotype', 'Abnormal atrial septum morphology', 'morphological feature phenotype', 'Abnormal appendicular skeleton morphology', 'camera-type eye', 'bone of free limb or fin', 'anatomical entity length phenotype', 'ocular adnexa', 'immune system', 'Abnormal joint morphology', 'decreased length of endochondral element', 'forelimb bud morphology phenotype', 'nervous system development', 'cardiogenic splanchnic mesoderm morphology phenotype', 'anatomical line phenotype', 'organism subdivision', 'Abnormality of the respiratory system', 'subdivision of skeletal system', 'eyelid physiology phenotype', 'endoderm phenotype', 'Abnormality of the nervous system', 'multicellular anatomical structure', 'process', 'increased length of the organ part', 'colon phenotype', 'glandular system', 'reproductive organ', 'Abnormality of the hand', 'kidney physiology phenotype', 'gray matter phenotype', 'multicellular organism', 'hematopoietic system', 'urogenital fold morphology phenotype', 'Phenotypic abnormality', 'platelet morphology', 'limb bud', 'gray matter of forebrain phenotype', 'Growth abnormality', 'feeding behavior', 'acropodial skeleton', 'delayed biological_process', 'female reproductive organ morphology phenotype', 'pectoral appendage skeleton phenotype', 'ectoderm-derived structure', 'duodenum phenotype', 'simple eye physiology phenotype', 'secondary palate', 'embryonic cloacal fold morphology phenotype', 'sensory system', 'stomach morphology phenotype', 'head morphology phenotype', 'biological_process phenotype', 'left isomerism; left-sided isomerism', 'oral cavity', 'sensory perception of sound', 'vasculature of trunk phenotype', 'Abnormality of movement', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'occurrent', 'lower limb segment', 'Duodenal stenosis', 'Abnormality of limb bone', 'limb morphology phenotype', 'skeleton phenotype', 'Orofacial cleft', 'Abnormal male external genitalia morphology', 'male reproductive system morphology phenotype', 'gastrula', 'Abnormality of the eye', 'forelimb zeugopod bone phenotype', 'pedal digit phalanx endochondral element', 'hypothalamus-pituitary axis', 'limb', 'neurocranium', 'endocrine system phenotype', 'parasympathetic ganglion', 'Abnormal cerebral ventricle morphology', 'Short long bone', 'organism subdivision phenotype', 'visual perception', 'structure with developmental contribution from neural crest phenotype', 'size of brain ventricle phenotype', 'increased size of the ectoderm-derived structure', 'Hyperreflexia', 'Short stature', 'tissue phenotype', 'spinal cord phenotype', 'physiologic nystagmus phenotype', 'Decreased head circumference', 'hindlimb long bone phenotype', 'Abnormal testis morphology', 'primordium phenotype', 'eye', 'sense organ phenotype', 'digit morphology phenotype', 'anatomical structure, asymmetrically curved phenotype', 'neural fold', 'Decreased total leukocyte count', 'eye morphology', 'sense organ', 'anlage', 'appendage', 'cornea morphology', 'tetrapod frontal bone', 'pharyngeal arch phenotype', 'bone of hip region', 'ear', 'increased size of the immaterial anatomical entity', 'neurectoderm phenotype', 'tetrapod frontal bone phenotype', 'male reproductive organ phenotype', 'head phenotype', 'Abnormal cellular physiology', 'Abnormality of prenatal development or birth', 'increased size of the non-material anatomical boundary', 'mesenchyme', 'incomplete closing of the secondary palate', 'ventricle of nervous system phenotype', 'increased length of the non-material anatomical boundary', 'Abnormality of the hypothalamus-pituitary axis', 'main body axis', 'body proper', 'incomplete closing of the arterial blood vessel', 'sense organ physiology phenotype', 'surface structure', 'ganglion', 'eyeball of camera-type eye', 'long bone morphology phenotype', 'Abnormal thumb morphology', 'delayed growth', 'musculature phenotype', 'digit 1', 'craniocervical region phenotype', 'compound organ phenotype', 'subdivision of organism along appendicular axis phenotype', 'growth', 'Abnormality of the skin', 'anatomical space phenotype', 'anatomical structure development', 'Abnormality of the integument', 'skin of face morphology phenotype', 'renal system physiology phenotype', 'gland', 'integument', 'skin of body', 'zone of skin morphology phenotype', 'ureter phenotype', 'duodenum morphology phenotype', 'eye physiology phenotype', 'tracheobronchial tree morphology phenotype', 'intestine', 'female reproductive system phenotype', 'alimentary part of gastrointestinal system phenotype', 'small intestine', 'pre-chordal neural plate', 'intestine phenotype', 'shape of longitudinal arch of pes phenotype', 'Abnormal digestive system morphology', 'manual digit phalanx endochondral element', 'subdivision of tube', 'trunk mesenchyme', 'incomplete closing of the multicellular anatomical structure', 'decreased size of the anatomical entity', 'ventricular system of central nervous system', 'Abnormality of the amniotic fluid', 'digestive system', 'intermediate mesoderm phenotype', 'intestine morphology phenotype', 'irregular bone', 'prominent forehead', 'Abnormality of globe location', 'increased response to stimulus', 'digestive system element phenotype', 'ectoderm-derived structure, asymmetrically curved phenotype', 'Small intestinal stenosis', 'Abnormality of the digestive system', 'Eumetazoa', 'immune system physiology phenotype', 'forelimb zeugopod bone', 'small intestine morphology phenotype', 'esophagus', 'autopod endochondral element', 'Abnormal duodenum morphology', 'Tracheoesophageal fistula', 'appendicular skeleton phenotype', 'primary subdivision of skull', 'decreased size of the bone of appendage girdle complex', 'valve phenotype', 'urethra', 'head mesenchyme', 'hindlimb bone', 'heart phenotype', 'male reproductive organ physiology phenotype', 'reproductive process', 'cardiac chamber phenotype', 'absent anatomical structure in the male reproductive system', 'semi-lunar valve morphology phenotype', 'intracellular membrane-bounded organelle', 'trunk region element', 'chamber of eyeball', 'absent anatomical entity in the male reproductive system', 'erythrocyte differentiation', 'primordium', 'compound organ', 'heart layer', 'cellular_component phenotype', 'Abnormal palate morphology', 'hindlimb bud morphology phenotype', 'ventricular system of brain', 'outflow tract', 'subdivision of trunk phenotype', 'multicellular organismal reproductive process', 'manus morphology phenotype', 'primary heart field phenotype', 'drinking behavior', 'mouth', 'cloaca', 'multicellular organismal reproductive process phenotype', 'heart morphology phenotype', 'primary heart field', 'left cardiac chamber', 'mesoderm morphology phenotype', 'craniocervical region morphology phenotype', 'musculature', 'brain ventricle phenotype', 'increased number of multicellular anatomical structure in the cerebrospinal fluid', 'thoracic segment organ phenotype', 'increased number of brain ventricle/choroid plexus', 'peripheral nervous system', 'Abnormal skull morphology', 'circulatory organ', 'lymphocyte', 'outflow tract of ventricle', 'wall of stomach morphology phenotype', 'cell physiology phenotype', 'herniated anatomical entity', 'heart tube morphology phenotype', 'vessel', 'anatomical cavity phenotype', 'multicellular organism mass phenotype', 'Abnormality of skull size', 'trunk region element phenotype', 'multicellular organism development', 'Aplasia/hypoplasia involving the skeleton', 'thoracic cavity element phenotype', 'homeostasis of number of cells', 'number of anatomical enitites of type reproductive organ phenotype', 'subdivision of oviduct phenotype', 'cardiac ventricle morphology phenotype', 'skin of head', 'primary circulatory organ', 'glans', 'Abnormality of the gastrointestinal tract', 'skeletal system phenotype', 'cardiogenic splanchnic mesoderm', 'viscus phenotype', 'Abnormal heart morphology', 'Abnormal hip bone morphology', 'heart primordium phenotype', 'mesoderm', 'neural tube', 'cardiogenic plate', 'neural crest-derived structure', 'Megacolon', 'heart', 'outflow tract phenotype', 'Hearing impairment', 'splanchnic layer of lateral plate mesoderm phenotype', 'decreased functionality of the organ part', 'liver', 'anatomical entity hypoplasia in face', 'meso-epithelium phenotype', 'trunk', 'hemolymphoid system', 'primary circulatory organ phenotype', 'shape of anatomical entity phenotype', 'B cell', 'forelimb bone phenotype', 'anterior region of body', 'shape of eyelid phenotype', 'mesenchyme morphology phenotype', 'shape of continuant phenotype', 'innominate bone phenotype', 'ocular surface region', 'Ptosis', 'male reproductive system physiology phenotype', 'drooping eyelid', 'individual digit of digitopodial skeleton', 'upper jaw region', 'brain ventricle/choroid plexus phenotype', 'endochondral bone phenotype', 'autopod region', 'Abnormality of the mouth', 'increased height of the roof of mouth', 'incomplete closing of the anatomical structure', 'decreased length of skeletal element', 'midface phenotype', 'secondary palate morphology phenotype', 'neural tube morphology', 'postcranial axial skeletal system', 'Abnormal anterior eye segment morphology', 'oral cleft; orofacial cleft', 'subdivision of skeletal system phenotype', 'incomplete closing of the anatomical entity', 'midface morphology phenotype', 'roof of mouth', 'incomplete closing of the material anatomical entity', 'respiratory system morphology', 'female reproductive system', 'decreased number of anatomical entity in the multicellular organism', 'anatomical space', 'male reproductive system phenotype', 'feeding behavior phenotype', 'anatomical structure', 'incomplete closing of the multi-tissue structure', 'aortic valve', 'external genitalia morphology; external genitalia phenotype', 'vertebral column', 'Abnormal oral cavity morphology', 'developing anatomical structure', 'jaw region', 'cell nucleus phenotype', 'Aplasia/Hypoplasia of the cerebrum', 'sensory perception phenotype', 'Craniofacial cleft', 'gastrointestinal system mucosa', 'midface', 'sclerotome morphology phenotype', 'gastrointestinal arteriovenous malformation', 'oral cavity phenotype', 'opening of the anatomical entity', 'facial bone hypoplasia', 'reproductive system morphology phenotype', 'Abnormality of the genitourinary system', 'cellular_component', 'herniated umbilical cord', 'digestive system gland phenotype', 'internal female genitalia morphology phenotype', 'anatomical wall phenotype', 'upper eyelid', 'absent material anatomical entity', 'Abnormality of the female genitalia', 'Abnormal internal genitalia', 'organ phenotype', 'integumental system phenotype', 'testis morphology phenotype', 'tube phenotype', 'oligohydramnios', 'reproductive structure phenotype', 'subdivision of oviduct', 'mesenchyme from somatopleure', 'localised reproductive structure', 'female organism phenotype', 'incomplete closing of the blood vessel', 'reproductive system', 'protruding eyeball of camera-type eye', 'cardiogenic splanchnic mesoderm phenotype', 'respiratory system phenotype', 'Aplasia/Hypoplasia of the mandible', 'absent reproductive structure in the reproductive system', 'genitourinary system', 'oviduct phenotype', 'innominate bone', 'closing of the ectoderm-derived structure', 'female reproductive organ phenotype', 'reproductive system phenotype', 'increased number of material anatomical entity in the cerebrospinal fluid', 'female organism', 'increased length of the skin of head', 'internal genitalia', 'cerebral cortex morphology phenotype', 'uterus', 'Abnormal cardiac atrium morphology', 'valve', 'Abnormality of the uterus', 'Decreased fertility', 'telencephalon', 'neural tube phenotype', 'Abnormal connection of the cardiac segments', 'Morphological central nervous system abnormality', 'cardiogenic plate morphology phenotype', 'Abnormal forebrain morphology', 'enteric nervous system', 'forebrain morphology phenotype', 'manus bone', 'urogenital fold', 'manual digit bone', 'central nervous system', 'brain phenotype', 'nerve phenotype', 'nervous system morphology phenotype', 'tube formation phenotype', 'telencephalon phenotype', 'glans penis', 'anus', 'dermal skeletal element phenotype', 'Hypertrophic cardiomyopathy', 'olfactory system phenotype', 'heart left ventricle', 'Abnormal nervous system morphology', 'Aganglionic megacolon', 'decreased size of the organism subdivision', 'respiratory tract', 'brain ventricle morphology phenotype', 'increased number of anatomical entity in the blood', 'multicellular organism development phenotype', 'incomplete closing of the roof of mouth', 'brain', 'embryonic cloaca morphology phenotype', 'radius bone phenotype', 'endocrine gland', 'central nervous system morphology phenotype', 'regional part of nervous system', 'anatomical structure, curved phenotype', 'Microcephaly', 'Abnormal cerebral morphology', 'regional part of brain phenotype', 'axial skeletal system', 'skull', 'behavior phenotype', 'Metazoa', 'anterior neural tube phenotype', 'decreased size of the head', 'increased number of ventricle of nervous system', 'involuntary movement behavior', 'mesenchyme phenotype', 'size of head phenotype', 'Abnormality of the liver', 'head mesenchyme phenotype', 'axial skeleton plus cranial skeleton', 'aplasia or hypoplasia of mandible', 'regional part of brain', 'increased length of the epicanthal fold', 'ectoderm-derived structure, curved phenotype', 'cardiac valve phenotype', 'renal system', 'cartilage element', 'Abnormal foot morphology', 'excretory system', 'Abnormality of reproductive system physiology', 'increased size of the trunk region element', 'Abnormal conjugate eye movement', 'eye movement', 'reproductive system physiology phenotype', 'embryonic cloaca phenotype', 'Abnormal carotid artery morphology', 'venous blood vessel phenotype', 'common carotid artery plus branches morphology phenotype', 'Abnormality of lower limb joint', 'common carotid artery plus branches', 'Neoplasm', 'incomplete closing of the coronary vessel', 'nervous system cell part layer', 'neoplasm phenotype', 'gastric ulcer', 'circulatory organ phenotype', 'Myelodysplasia', 'digestive tract epithelium phenotype', 'anatomical entity morphology in the alimentary part of gastrointestinal system phenotype', 'presumptive structure', 'endoderm of foregut', 'endoderm-derived structure phenotype', 'respiratory tube morphology phenotype', 'material entity', 'splanchnic layer of lateral plate mesoderm', 'respiratory airway', 'foregut epithelium', 'sensory perception of mechanical stimulus', 'deviation of digit towards the middle', 'external genitalia', 'parathyroid gland physiology phenotype', 'decreased activity of parathyroid; hypoparathyroidism', 'endoderm-derived structure', 'lower respiratory tract', 'digit plus metapodial segment', 'mandibular prominence', 'penis', 'absent anatomical structure in the reproductive system', 'Aplasia/hypoplasia of the extremities', 'gland phenotype', 'sorocarp development', 'hypothalamus-pituitary axis phenotype', 'vein phenotype', 'increased length of the anatomical line between pupils', 'duodenum', 'venous system', 'tracheobronchial tree', 'membrane bone', 'ectoderm phenotype', 'respiratory tube', 'endoderm morphology phenotype', 'male organism', 'vein', 'Abnormal femur morphology', 'Abnormal respiratory system morphology', 'Intrauterine growth retardation', 'neural fold morphology phenotype', 'shape of face phenotype', 'anatomical system physiology phenotype', 'Abnormal intestine morphology', 'parathyroid gland', 'trachea', 'Abnormal ventriculoarterial connection', 'venous blood vessel', 'Finger syndactyly', 'esophagus morphology phenotype', 'Abnormal tracheal morphology', 'gland physiology phenotype', 'abdominal wall phenotype', 'size of anatomical entity phenotype', 'digestive system gland', 'Oligohydramnios', 'endoderm', 'vestibulo-ocular reflex', 'vasculature morphology in the alimentary part of gastrointestinal system phenotype', 'synovial joint morphology phenotype', 'intramembranous bone phenotype', 'dense mesenchyme tissue', 'proximo-distal subdivision of respiratory tract', 'Abnormal tracheobronchial morphology', 'embryonic structure phenotype', 'endocrine gland phenotype', 'embryonic epithelial tube formation', 'skeletal system physiology phenotype', 'endo-epithelium phenotype', 'manual digit 5 plus metapodial segment', 'renal/urinary system phenotype', 'foregut epithelium phenotype', 'increased size of the organ part', 'hypoventilation', 'increased size of the brain ventricle/choroid plexus', 'eye primordium', 'organ component layer phenotype', 'location of eyeball of camera-type eye phenotype', 'brain ventricle/choroid plexus', 'manual digit phenotype', 'anatomical entity morphology in the brain phenotype', 'increased size of the organ component layer', 'organ component layer', 'brain ventricle/choroid plexus morphology phenotype', 'intracellular membraneless organelle', 'Ventriculomegaly', 'parathyroid gland phenotype', 'increased size of the material anatomical entity', 'incomplete closing of the anatomical conduit', 'brain morphology phenotype', 'increased size of the brain ventricle', 'bone of jaw', 'decreased nervous system process', 'ventricle of nervous system', 'Abnormal jaw morphology', 'interatrial septum', 'ear phenotype', 'dermal skeleton phenotype', 'anatomical entity hypoplasia', 'semen', 'material anatomical entity atresia', 'heart tube phenotype', 'pharyngeal arch system', 'central nervous system cell part cluster', 'mandible hypoplasia', 'eyelid phenotype', 'facial bone phenotype', 'intramembranous bone', 'head bone morphology phenotype', 'dermatocranium', 'pharyngeal arch 1 phenotype', 'increased length of the skin of eyelid', 'decreased length of limb bone', 'dentary', 'epithelial fold phenotype', 'Abnormal facial skeleton morphology', 'increased height of the anatomical entity', 'oral opening', 'neural crest phenotype', 'external anal region', 'musculoskeletal system phenotype', 'embryonic craniocervical region', 'absent reproductive organ', 'absent reproductive organ in the reproductive system', 'stomach phenotype', 'Clinodactyly of the 5th finger', 'dermal skeletal element', 'mandibular prominence morphology phenotype', 'pharyngeal arch', 'aplasia or hypoplasia of skull', 'ulna phenotype', 'cardiac atrium morphology phenotype', 'facial skeleton morphology phenotype', 'ectoderm morphology phenotype', 'neural crest', 'protuberance phenotype', 'male gamete generation', 'Anemia of inadequate production', 'eyelid morphology phenotype', 'pharyngeal region of foregut', 'zone of organ', 'bone of craniocervical region', 'facial skeleton', 'bone of lower jaw', 'autonomic nervous system morphology phenotype', 'tetrapod frontal bone morphology phenotype', 'cornea morphology phenotype', 'Aplasia/Hypoplasia of the testes', 'absent anatomical entity', 'mandible', 'decreased length of bone of pectoral complex', 'prepuce of penis morphology phenotype', 'primary subdivision of cranial skeletal system', 'skeleton of digitopodium', 'dermatocranium phenotype', 'pharyngeal arch 1 morphology phenotype', 'neural fold phenotype', 'spinal cord', 'autonomic nervous system phenotype', 'neural groove', 'head bone', 'embryonic facial prominence', 'jaw skeleton', 'Aplasia/hypoplasia affecting bones of the axial skeleton', 'alimentary part of gastrointestinal system', 'dermal skeleton', 'digestive system element', 'protuberance', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'external male genitalia', 'paraxial mesoderm phenotype', 'Abnormality of the orbital region', 'external genitalia phenotype', 'normal growth on benomyl', 'thoracic segment of trunk', 'male reproductive system', 'Abnormality of the peripheral nervous system', 'tube formation', 'epithelial vesicle phenotype', 'digit 1 or 5 phenotype', 'taxon specific phenotype', 'gonad phenotype', 'epithelial tube formation', 'small intestine phenotype', 'male reproductive organ morphology phenotype', 'late embryo', 'Abnormal forehead morphology', 'endocrine gland physiology phenotype', 'localised male reproductive organ', 'Unusual infection', 'Abnormal eye physiology', 'localised anatomical entity', 'lymphocyte physiology phenotype', 'Abnormal oral morphology', 'localised organ', 'number of anatomical enitites of type organ phenotype', 'Cryptorchidism', 'endoderm of foregut phenotype', 'male organism phenotype', 'localised anatomical structure', 'male reproductive organ', 'Recurrent urinary tract infections', 'skull phenotype', 'anterior neural tube', 'Abnormality of the urinary system physiology', 'absent testis', 'Abnormality of the testis size', 'closing of the anatomical conduit', 'germ layer / neural crest phenotype', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'embryo development', 'axial skeleton plus cranial skeleton morphology phenotype', 'absent multicellular anatomical structure in the male reproductive system', 'B cell physiology phenotype', 'absent organ', 'anatomical cluster phenotype', 'absent anatomical structure in the multicellular organism', 'absent multicellular anatomical structure in the multicellular organism', 'embryonic tissue morphology phenotype', 'membrane bone phenotype', 'absent anatomical entity in the multicellular organism', 'asymmetrically curved anatomical entity', 'endochondral element phenotype', 'absent anatomical entity in the reproductive system', 'number of anatomical enitites of type erythrocyte phenotype', 'bone element hypoplasia in face', 'absent gonad', 'gray matter of forebrain', 'number of anatomical enitites of type gonad phenotype', 'absent organ in the multicellular organism', 'number of anatomical enitites of type anatomical entity phenotype', 'absent anatomical structure', 'internal female genitalia phenotype', 'bone of lower jaw phenotype', 'absent material anatomical entity in the multicellular organism', 'radius bone', 'respiratory tube phenotype', 'digit 1 or 5', 'absent material anatomical entity in the male reproductive system', 'embryonic development/birth phenotype', 'Upslanted palpebral fissure', 'late embryo phenotype', 'amniotic fluid', 'cellular organisms', 'aorta coarctation; coarctation of aorta', 'anatomical entity morphology in the appendage girdle complex phenotype', 'abdominal segment element phenotype', 'anatomical system', 'hepatobiliary system phenotype', 'increased number of organ part', 'increased size of the eye', 'multicellular anatomical structure phenotype', 'decreased size of the anatomical conduit', 'number of anatomical enitites of type reproductive structure phenotype', 'exocrine gland phenotype', 'abdominal segment element', 'arterial blood vessel phenotype', 'organism substance phenotype', 'skeleton of manual digitopodium', 'Abnormality of connective tissue', 'exocrine system', 'Hypospadias', 'presumptive ectoderm', 'manual digit 1 phalanx', 'hepatobiliary system', 'abdomen element', 'neocortex', 'Abnormal esophagus morphology', 'Abnormality of the abdominal organs', 'absent gamete', 'manual digit 5 morphology phenotype', 'Abnormality of immune system physiology', 'abdominal segment of trunk', 'developing anatomical structure phenotype', 'abdomen', 'embryo development phenotype', 'optic cup', 'number of anatomical enitites of type anatomical structure phenotype', 'digit 1 phenotype', 'manual digit digitopodial skeleton', 'articular system', 'skeleton of manual acropodium', 'manual digit 1 morphology phenotype', 'long bone', 'non-material anatomical boundary phenotype', 'autopod bone', 'forelimb bone', 'anatomical wall', 'manual digit 1 digitopodial skeleton', 'ocular surface region morphology phenotype', 'Abnormality of thumb phalanx', 'manual digitopodium bone'], 'has_descendant': ['MONDO:0013566', 'MONDO:0054748', 'MONDO:0010351', 'MONDO:0044325', 'MONDO:0013565', 'MONDO:0009213', 'MONDO:0019391', 'MONDO:0009214', 'MONDO:0014986', 'MONDO:0012186', 'MONDO:0009215', 'MONDO:0010953', 'MONDO:0013499', 'MONDO:0014987', 'MONDO:0014638', 'MONDO:0012565', 'MONDO:0012187', 'MONDO:0011584', 'MONDO:0014108', 'MONDO:0013248', 'MONDO:0014985', 'MONDO:0011325'], 'has_descendant_label': ['Fanconi anemia complementation group L', 'Fanconi anemia, complementation group S', 'Fanconi anemia complementation group B', 'Fanconi anemia, complementation group W', 'Fanconi anemia complementation group G', 'Fanconi anemia complementation group C', 'Fanconi anemia', 'Fanconi anemia complementation group D2', 'Fanconi anemia complementation group R', 'Fanconi anemia complementation group I', 'Fanconi anemia complementation group A', 'Fanconi anemia complementation group E', 'Fanconi anemia complementation group P', 'Fanconi anemia complementation group U', 'Fanconi anemia complementation group T', 'Fanconi anemia complementation group N', 'Fanconi anemia complementation group J', 'Fanconi anemia complementation group D1', 'Fanconi anemia complementation group Q', 'Fanconi anemia complementation group O', 'Fanconi anemia complementation group V', 'Fanconi anemia complementation group F'], 'has_descendant_count': 22, 'highlighting': None}, {'id': 'MONDO:0013499', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group P', 'description': 'Any Fanconi anemia in which the cause of the disease is a mutation in the SLX4 gene.', 'xref': ['DOID:0111092', 'GARD:15731', 'MEDGEN:854020', 'OMIM:613951', 'UMLS:C3469542'], 'synonym': ['FANCP', 'Fanconi Anemia, complementation group type P', 'Fanconi anaemia caused by mutation in SLX4', 'Fanconi anaemia caused by mutation in Slx4', 'Fanconi anaemia complementation group type P', 'Fanconi anemia caused by mutation in SLX4', 'Fanconi anemia caused by mutation in Slx4', 'Fanconi anemia complementation group type P', 'Fanconi anemia, complementation group P', 'SLX4 Fanconi anaemia', 'SLX4 Fanconi anemia', 'Slx4 Fanconi anaemia', 'Slx4 Fanconi anemia'], 'exact_synonym': ['FANCP', 'Fanconi Anemia, complementation group type P', 'Fanconi anaemia caused by mutation in SLX4', 'Fanconi anaemia caused by mutation in Slx4', 'Fanconi anaemia complementation group type P', 'Fanconi anemia caused by mutation in SLX4', 'Fanconi anemia caused by mutation in Slx4', 'Fanconi anemia complementation group type P', 'SLX4 Fanconi anaemia', 'SLX4 Fanconi anemia', 'Slx4 Fanconi anaemia', 'Slx4 Fanconi anemia'], 'related_synonym': ['Fanconi anemia, complementation group P'], 'subsets': ['gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0003221', 'HP:0000957', 'HP:0004322', 'HP:0002984', 'HP:0000085', 'HP:0001876', 'HP:0000125', 'HP:0001903', 'HP:0009777', 'HP:0000581', 'HP:0000414', 'HP:0012745', 'HP:0001510', 'HP:0000347', 'HP:0000252', 'HP:0009778', 'HP:0001045', 'HP:0002860', 'HP:0000028', 'HP:0000365'], 'has_phenotype_label': ['Absent thumb', 'Chromosomal breakage induced by crosslinking agents', 'Cryptorchidism', 'Growth delay', 'Anemia', 'Short stature', 'Pelvic kidney', 'Microcephaly', 'Short thumb', 'Blepharophimosis', 'Micrognathia', 'Pancytopenia', 'Hearing impairment', 'Hypoplasia of the radius', 'Vitiligo', 'Bulbous nose', 'Squamous cell carcinoma', 'Horseshoe kidney', 'Cafe-au-lait spot', 'Short palpebral fissure'], 'has_phenotype_count': 20, 'has_phenotype_closure': ['HP:0009116', 'UPHENO:0002550', 'UBERON:0004921', 'UBERON:0010364', 'UBERON:0003457', 'UBERON:0001710', 'UBERON:0002539', 'UBERON:0012314', 'UPHENO:0086518', 'UBERON:0011595', 'UBERON:0008907', 'UPHENO:0002546', 'UPHENO:0086595', 'HP:0009122', 'UPHENO:0003776', 'UBERON:0013765', 'UPHENO:0002818', 'UPHENO:0081788', 'UPHENO:0002833', 'HP:0030791', 'UBERON:0002514', 'UBERON:0007842', 'UPHENO:0004481', 'UPHENO:0002772', 'UPHENO:0002815', 'UBERON:0001041', 'UBERON:0000165', 'UBERON:0003113', 'UBERON:0005157', 'UPHENO:0002988', 'UBERON:0013522', 'UBERON:0034944', 'UPHENO:0084457', 'HP:0009118', 'UPHENO:0003298', 'UPHENO:0087404', 'UBERON:0004742', 'UPHENO:0075890', 'UPHENO:0002828', 'UBERON:0001684', 'UBERON:0004768', 'UBERON:0011156', 'UBERON:0005867', 'UPHENO:0004261', 'UPHENO:0002838', 'UPHENO:0087359', 'UPHENO:0086717', 'UPHENO:0076803', 'UBERON:0001555', 'UBERON:0000166', 'UBERON:0012360', 'GO:0003008', 'UPHENO:0002211', 'UPHENO:0005513', 'UPHENO:0002240', 'UPHENO:0002308', 'UBERON:0002105', 'UPHENO:0005437', 'UPHENO:0052161', 'GO:0050954', 'UPHENO:0005433', 'UPHENO:0005104', 'UPHENO:0002267', 'UPHENO:0002942', 'UPHENO:0049703', 'UPHENO:0050625', 'UPHENO:0002385', 'UPHENO:0002386', 'UBERON:0001007', 'UPHENO:0005518', 'UPHENO:0050234', 'UPHENO:0046753', 'UPHENO:0068941', 'UPHENO:0076800', 'UBERON:0000004', 'UBERON:0005497', 'BFO:0000141', 'UPHENO:0001135', 'UPHENO:0002907', 'UPHENO:0002005', 'HP:0010938', 'UPHENO:0087950', 'UPHENO:0088168', 'UBERON:8450003', 'UPHENO:0001360', 'UBERON:0005085', 'UBERON:0006983', 'HP:0000366', 'UPHENO:0003228', 'UPHENO:0003824', 'UBERON:0000466', 'HP:0005105', 'UBERON:0012128', 'UBERON:0000076', 'UPHENO:0084715', 'UPHENO:0003485', 'UPHENO:0001025', 'UPHENO:0002722', 'UPHENO:0002715', 'HP:0002664', 'HP:0011793', 'UBERON:8480069', 'UPHENO:0002932', 'UPHENO:7000161', 'UBERON:0001567', 'HP:0000086', 'UPHENO:0004262', 'UPHENO:0053619', 'UPHENO:0053633', 'UPHENO:0053643', 'UPHENO:0075998', 'UPHENO:0053588', 'UPHENO:0080165', 'UPHENO:0000543', 'GO:0040007', 'HP:0000002', 'HP:0001510', 'UPHENO:0069254', 'UPHENO:0049874', 'UPHENO:0081423', 'UPHENO:0054970', 'UPHENO:0074575', 'HP:0008069', 'HP:0001034', 'UPHENO:0074584', 'HP:0000957', 'HP:0007400', 'HP:0012733', 'UPHENO:0080662', 'HP:0000953', 'UPHENO:0001072', 'GO:0043473', 'UPHENO:0002875', 'UPHENO:7000074', 'UPHENO:0003811', 'UPHENO:0052970', 'UBERON:0002199', 'GO:0043227', 'UPHENO:0067645', 'UPHENO:0087852', 'GO:0043231', 'UPHENO:0003446', 'UBERON:0002416', 'UBERON:0004756', 'HP:0001045', 'HP:0011121', 'UPHENO:0082548', 'GO:0005622', 'UPHENO:0052231', 'HP:0001574', 'UPHENO:0006889', 'UPHENO:0004064', 'UPHENO:0001134', 'HP:0001000', 'UPHENO:0053572', 'UBERON:0004176', 'UBERON:0003135', 'UBERON:0000991', 'UBERON:0000079', 'HP:0000414', 'HP:0000032', 'HP:0000028', 'UPHENO:0053559', 'UPHENO:0081424', 'UPHENO:0003056', 'UPHENO:0053571', 'UPHENO:0053647', 'HP:0000035', 'UPHENO:0053644', 'UBERON:0005062', 'UBERON:0000473', 'UPHENO:0053580', 'UPHENO:0002682', 'UPHENO:7000206', 'HP:0000078', 'UPHENO:0053566', 'UPHENO:7000069', 'UPHENO:0002523', 'HP:0012243', 'UPHENO:0053561', 'UPHENO:0087547', 'UPHENO:0003055', 'HP:0000277', 'UBERON:0003101', 'UBERON:0000990', 'GO:0007605', 'UPHENO:0002685', 'GO:0042756', 'UPHENO:0005512', 'GO:0007610', 'GO:0032501', 'UPHENO:0088162', 'UPHENO:0049664', 'UBERON:0002268', 'UPHENO:0079835', 'UPHENO:0001912', 'GO:0007631', 'HP:0001903', 'GO:0043229', 'UPHENO:0087339', 'UPHENO:0049622', 'UPHENO:0002994', 'GO:0005634', 'CL:0000738', 'UPHENO:0086048', 'UPHENO:0003021', 'UPHENO:0077391', 'UPHENO:0063722', 'HP:0000811', 'CL:0000764', 'CL:0002092', 'UBERON:0002371', 'HP:0002860', 'UPHENO:0063787', 'UPHENO:0086173', 'CL:0000233', 'CL:0001035', 'UPHENO:7000294', 'HP:0000364', 'UPHENO:0004459', 'UPHENO:0077418', 'UPHENO:0063794', 'UPHENO:0080010', 'NBO:0001845', 'UPHENO:7000311', 'CL:0000458', 'HP:0012145', 'UPHENO:0077399', 'UPHENO:0049699', 'HP:0001871', 'UPHENO:0085301', 'CL:0000255', 'CL:0000151', 'CL:0000219', 'UPHENO:0085344', 'UPHENO:7000306', 'UBERON:0004128', 'UPHENO:0003085', 'UPHENO:0005319', 'UPHENO:0075997', 'UPHENO:0075878', 'UPHENO:0002910', 'UPHENO:0077348', 'HP:0000581', 'UPHENO:0050008', 'UPHENO:0005097', 'HP:0000315', 'HP:0030669', 'UPHENO:0002812', 'UPHENO:0069119', 'UPHENO:0076761', 'UPHENO:0004721', 'UBERON:0000047', 'UPHENO:0002643', 'UBERON:0003462', 'UPHENO:0004757', 'UBERON:0004362', 'UPHENO:0004494', 'UBERON:0000064', 'UBERON:0011158', 'UPHENO:0005110', 'UPHENO:0000541', 'UBERON:0000020', 'UBERON:0001456', 'UBERON:0001444', 'HP:0000271', 'UBERON:0000490', 'UBERON:0001711', 'UBERON:0001032', 'HP:0008050', 'UPHENO:0005058', 'UPHENO:0003189', 'UBERON:0002405', 'UBERON:0015203', 'UPHENO:0083646', 'UPHENO:0002928', 'UPHENO:0087472', 'UPHENO:0086486', 'UPHENO:0054957', 'UBERON:0034923', 'UPHENO:0002866', 'UBERON:0000970', 'UBERON:0001048', 'UPHENO:0075159', 'UPHENO:0046411', 'UPHENO:0069684', 'HP:0009778', 'UBERON:0003071', 'UPHENO:0069674', 'UPHENO:0087973', 'UBERON:0000161', 'UPHENO:0046426', 'UPHENO:0046741', 'UPHENO:0002595', 'UPHENO:0046707', 'HP:0011927', 'UPHENO:0046487', 'UPHENO:0069605', 'HP:0009381', 'UBERON:0000483', 'UBERON:0001049', 'UBERON:0034921', 'UPHENO:0002648', 'UPHENO:0085330', 'UBERON:0002386', 'UBERON:0004375', 'UPHENO:0078606', 'HP:0000085', 'UBERON:0003103', 'UPHENO:7000228', 'HP:0000240', 'UPHENO:0004475', 'UPHENO:0087430', 'UPHENO:0005016', 'UPHENO:0012274', 'UPHENO:0087849', 'UPHENO:0049775', 'UPHENO:0087363', 'UPHENO:7000299', 'UBERON:0010712', 'UBERON:0010707', 'HP:0003221', 'UBERON:0005944', 'UPHENO:0004885', 'HP:0000001', 'UPHENO:0046445', 'GO:0008150', 'CL:0000457', 'UPHENO:0069292', 'UPHENO:0004484', 'UPHENO:0001001', 'UBERON:0001016', 'UBERON:0002097', 'GO:0005575', 'UPHENO:0068848', 'UBERON:0007524', 'UBERON:0000475', 'HP:0000598', 'UPHENO:0081581', 'UPHENO:0067691', 'UPHENO:0002861', 'UPHENO:0002785', 'UPHENO:0087228', 'UBERON:0003466', 'HP:0000707', 'UPHENO:0069327', 'UBERON:0001460', 'UPHENO:0082875', 'UPHENO:0046755', 'CL:0000329', 'UPHENO:0076740', 'HP:0003220', 'UBERON:0002495', 'CL:0000000', 'UBERON:0003104', 'UPHENO:0079876', 'UBERON:0003606', 'UPHENO:0041629', 'UPHENO:0002525', 'UPHENO:0002352', 'UPHENO:0087665', 'UPHENO:0046528', 'UPHENO:0008548', 'UPHENO:0084727', 'UPHENO:0079872', 'UPHENO:0069047', 'UBERON:0015212', 'HP:0040064', 'UPHENO:0069266', 'UPHENO:0002976', 'UPHENO:0003069', 'BFO:0000001', 'UPHENO:0002816', 'UPHENO:0004595', 'UPHENO:0068838', 'UPHENO:0004680', 'GO:0050877', 'UBERON:0013702', 'HP:0012745', 'HP:0000077', 'UPHENO:0046624', 'UBERON:0000033', 'UPHENO:0002837', 'UPHENO:0053612', 'UPHENO:0003163', 'HP:0000951', 'UPHENO:0046484', 'UBERON:0002471', 'UPHENO:0086769', 'UBERON:0000383', 'UPHENO:0075198', 'UBERON:0004120', 'UPHENO:0086956', 'UBERON:0010703', 'UPHENO:0052178', 'UBERON:0002389', 'UPHENO:0069064', 'UPHENO:0050435', 'UPHENO:0002554', 'HP:0040070', 'UPHENO:0002600', 'UBERON:0010741', 'HP:0000347', 'UPHENO:0002650', 'HP:0002817', 'CL:0000081', 'UPHENO:0049870', 'UPHENO:0069194', 'UPHENO:0080087', 'UBERON:0005423', 'UPHENO:0088123', 'UPHENO:0003488', 'UBERON:0000153', 'UPHENO:0053610', 'HP:0011842', 'UPHENO:0026108', 'UPHENO:0026757', 'UPHENO:0080126', 'UPHENO:0008668', 'UBERON:0010363', 'UBERON:0005881', 'UPHENO:0087423', 'UBERON:0035639', 'UBERON:0001474', 'UPHENO:0052160', 'GO:0009059', 'UBERON:0000019', 'BFO:0000004', 'UPHENO:0086501', 'UPHENO:0011498', 'UBERON:0034929', 'UPHENO:0079826', 'UBERON:0003075', 'UBERON:0004121', 'UPHENO:0046479', 'UPHENO:0088116', 'UPHENO:0002593', 'UPHENO:0081141', 'UPHENO:0003049', 'HP:0002984', 'UPHENO:0004205', 'UBERON:0004734', 'UPHENO:0046392', 'HP:0004322', 'BFO:0000003', 'UPHENO:0002586', 'UPHENO:0080200', 'UPHENO:0087347', 'UPHENO:0080079', 'UPHENO:0002971', 'UBERON:0002050', 'UPHENO:0002746', 'UBERON:0006058', 'HP:0002813', 'UBERON:0007914', 'HP:0009824', 'BFO:0000002', 'UBERON:0005419', 'UBERON:0001423', 'UPHENO:0003004', 'UBERON:0001690', 'UBERON:0011138', 'HP:0000118', 'UBERON:0000922', 'UPHENO:0004900', 'UPHENO:0002567', 'HP:0000119', 'UBERON:0002101', 'UBERON:0002390', 'UPHENO:0002948', 'UPHENO:0046396', 'HP:0000492', 'UPHENO:0003799', 'UPHENO:0087907', 'UBERON:0009955', 'HP:0006501', 'UPHENO:0002983', 'UPHENO:0046540', 'UPHENO:0002736', 'UPHENO:0002830', 'UPHENO:0069328', 'UBERON:0012141', 'UPHENO:0069163', 'UBERON:0002529', 'UPHENO:0046460', 'UBERON:0011249', 'UBERON:0005177', 'UPHENO:0075148', 'UPHENO:0002868', 'UBERON:0003133', 'UPHENO:0002870', 'UBERON:0000062', 'UPHENO:0002754', 'UPHENO:0004519', 'UPHENO:0003095', 'UPHENO:0087510', 'UPHENO:0002571', 'RO:0002577', 'UPHENO:0003005', 'UPHENO:0002727', 'UPHENO:0068971', 'UBERON:0010740', 'UPHENO:0002637', 'UBERON:0004456', 'UPHENO:0002964', 'UPHENO:0002526', 'UPHENO:0003094', 'UPHENO:0003415', 'UPHENO:0086635', 'HP:0003026', 'UPHENO:0005517', 'UPHENO:0046531', 'HP:0009115', 'UPHENO:0086546', 'HP:0000436', 'UPHENO:0002738', 'UPHENO:0025509', 'UPHENO:0046594', 'UPHENO:0075944', 'UPHENO:0011572', 'UBERON:0000075', 'UBERON:0002104', 'UPHENO:0003236', 'UPHENO:0002761', 'UBERON:0011159', 'UPHENO:0046552', 'UPHENO:0009382', 'UPHENO:0001002', 'UPHENO:0003366', 'UPHENO:0087501', 'UPHENO:0081451', 'HP:0010935', 'UPHENO:0012308', 'UPHENO:0076718', 'UBERON:0004765', 'UPHENO:0087116', 'UPHENO:0002564', 'UBERON:0003278', 'UPHENO:0081566', 'UPHENO:0085302', 'UBERON:0011584', 'UPHENO:0049868', 'GO:0007600', 'UBERON:0002204', 'UPHENO:0046397', 'UPHENO:0049620', 'UPHENO:0004525', 'UPHENO:0026643', 'UPHENO:0003227', 'HP:0005927', 'UBERON:0004111', 'UPHENO:0002542', 'UPHENO:0076703', 'UPHENO:0046465', 'UPHENO:0046554', 'UPHENO:0003812', 'UPHENO:0002747', 'UBERON:0005417', 'HP:0032039', 'UPHENO:0004433', 'UPHENO:0002659', 'HP:0045060', 'UPHENO:0086700', 'HP:0009826', 'UBERON:0010912', 'UPHENO:0003410', 'UBERON:0004710', 'UBERON:0012475', 'UPHENO:0002967', 'UPHENO:0002577', 'HP:0006496', 'UPHENO:0087660', 'UBERON:0010314', 'UBERON:0015021', 'UPHENO:0003159', 'UPHENO:0050620', 'UBERON:0002428', 'UPHENO:0002880', 'UPHENO:0004625', 'UPHENO:0087924', 'UPHENO:0002963', 'GO:0019222', 'UPHENO:3000003', 'UPHENO:0041075', 'UBERON:0002102', 'HP:0000924', 'UPHENO:0003025', 'UPHENO:0002859', 'UBERON:0004288', 'UBERON:0000026', 'UPHENO:0052165', 'UBERON:8450002', 'UPHENO:0005214', 'UBERON:0010188', 'HP:0040068', 'UBERON:0006601', 'UBERON:0005061', 'UBERON:0004357', 'UPHENO:0002732', 'UBERON:0010000', 'UPHENO:0003082', 'UBERON:0001062', 'UPHENO:0069030', 'UPHENO:0077373', 'UBERON:0000468', 'UBERON:0003080', 'UPHENO:0076697', 'UPHENO:0002694', 'UPHENO:0003432', 'UPHENO:0002541', 'UBERON:0001440', 'UPHENO:0002945', 'UPHENO:0003065', 'CL:0000232', 'UPHENO:0080187', 'UBERON:0006598', 'HP:0012210', 'UPHENO:0046455', 'UPHENO:0069046', 'UBERON:0003050', 'UPHENO:0002896', 'HP:0000152', 'BFO:0000040', 'UBERON:0011582', 'UPHENO:0087585', 'UPHENO:0076724', 'UPHENO:0076941', 'UBERON:0002342', 'HP:0009815', 'UBERON:0001015', 'UPHENO:0003412', 'HP:0001155', 'UPHENO:0004888', 'UBERON:0010312', 'UPHENO:0002844', 'UBERON:0004089', 'UPHENO:0003334', 'UPHENO:0002530', 'UPHENO:3000000', 'UPHENO:0069062', 'UPHENO:0011536', 'UPHENO:0004892', 'UPHENO:0002926', 'UPHENO:0081204', 'HP:0005922', 'UPHENO:0081786', 'UBERON:0000923', 'GO:0110165', 'UPHENO:0068912', 'HP:0011355', 'UPHENO:0012440', 'UPHENO:0005055', 'UBERON:0000467', 'UPHENO:0005092', 'UBERON:0007827', 'UBERON:0034925', 'UPHENO:0005141', 'UPHENO:0046740', 'UPHENO:0002969', 'UPHENO:0003413', 'UPHENO:0002635', 'UBERON:0000926', 'UPHENO:0046538', 'UPHENO:0068932', 'UPHENO:0050106', 'HP:0200007', 'UPHENO:0012312', 'UPHENO:0080325', 'UBERON:0001708', 'HP:0011314', 'UPHENO:0026640', 'UPHENO:0004173', 'HP:0005561', 'UBERON:0005291', 'GO:0009987', 'GO:0010556', 'UBERON:0007272', 'UPHENO:0069125', 'HP:0001876', 'UBERON:0000061', 'HP:0001507', 'UPHENO:0085968', 'UPHENO:0002708', 'UPHENO:0049904', 'UPHENO:0002764', 'GO:0010605', 'UBERON:0015061', 'HP:0000234', 'UPHENO:7000146', 'UPHENO:0002632', 'UPHENO:0002597', 'UBERON:0010758', 'UPHENO:0004802', 'UPHENO:0088186', 'HP:0033127', 'HP:0031704', 'UPHENO:0002731', 'UPHENO:0076754', 'UPHENO:0002940', 'NBO:0000313', 'UBERON:0010316', 'UPHENO:0025585', 'UBERON:0003081', 'UBERON:0010313', 'UBERON:0000489', 'UBERON:0010538', 'UBERON:0001463', 'HP:0011844', 'UPHENO:0009146', 'HP:0011821', 'UPHENO:0084004', 'UPHENO:0087663', 'UPHENO:0003088', 'UPHENO:0002568', 'UPHENO:0003514', 'UBERON:0001017', 'UBERON:0000479', 'UBERON:0019231', 'UPHENO:0008523', 'UPHENO:0084448', 'UPHENO:0081314', 'UPHENO:0002733', 'UBERON:0005156', 'UBERON:0009569', 'UPHENO:0076739', 'UPHENO:0088170', 'UPHENO:0050121', 'UPHENO:0076692', 'HP:0009380', 'UPHENO:0026506', 'UPHENO:0080351', 'UPHENO:0005025', 'UPHENO:0002949', 'GO:0050789', 'UPHENO:0026181', 'UPHENO:0026146', 'UBERON:0012354', 'UBERON:5002544', 'UPHENO:0087006', 'UPHENO:0002832', 'UPHENO:0080099', 'HP:0002977', 'UBERON:0008814', 'HP:0001167', 'UPHENO:0069562', 'UPHENO:0076675', 'UPHENO:0011531', 'UPHENO:0050007', 'UBERON:0006717', 'UPHENO:0046483', 'HP:0009601', 'UPHENO:0002905', 'UPHENO:0080114', 'UBERON:0001008', 'UPHENO:0011825', 'UBERON:5001463', 'HP:0009121', 'UPHENO:0076791', 'UBERON:0004708', 'UPHENO:0046405', 'UBERON:0002398', 'UBERON:0005451', 'UPHENO:0026078', 'HP:0009777', 'UBERON:0001442', 'UPHENO:0002559', 'UPHENO:0002902', 'UPHENO:0001003', 'GO:0042592', 'UBERON:0002470', 'UBERON:0002091', 'UPHENO:0004476', 'UPHENO:0005106', 'CL:0000763', 'UPHENO:0086485', 'UPHENO:0009020', 'UBERON:0003102', 'GO:0009058', 'UPHENO:0084761', 'UBERON:0002546', 'UBERON:0002513', 'HP:0011297', 'UPHENO:0009163', 'UPHENO:0027017', 'UPHENO:0003186', 'UPHENO:0046750', 'UBERON:0000307', 'UPHENO:0004909', 'UPHENO:0005030', 'UBERON:0006048', 'HP:0010461', 'UBERON:0003607', 'HP:0002973', 'UPHENO:0076723', 'UPHENO:0087846', 'CL:0002242', 'UPHENO:0025587', 'UBERON:5002389', 'HP:0040072', 'UBERON:5006048', 'UBERON:0002544', 'HP:0001172', 'UPHENO:0049873', 'UPHENO:0004372', 'GO:0010467', 'HP:0011017', 'UBERON:0012140', 'GO:0009892', 'HP:0002818', 'GO:0009889', 'UBERON:0002616', 'GO:0060255', 'CL:0000225', 'UPHENO:0068839', 'UPHENO:0049587', 'UPHENO:0002719', 'UBERON:0011216', 'UBERON:0004347', 'GO:0009890', 'UBERON:0010708', 'UPHENO:0049743', 'GO:0043170', 'GO:0048519', 'UPHENO:0081091', 'UPHENO:0009209', 'UPHENO:0081466', 'GO:0050794', 'UPHENO:0005596', 'UPHENO:0002651', 'UPHENO:0050063', 'UPHENO:0052159', 'HP:0001939', 'UPHENO:0075220', 'BFO:0000015', 'UPHENO:0050065', 'UBERON:0008785', 'GO:0065007', 'UPHENO:0049835', 'GO:0031049', 'UPHENO:0004434', 'UPHENO:0001303', 'UPHENO:0086172', 'UPHENO:0001217', 'UBERON:0002193', 'UPHENO:0026183', 'GO:0031052', 'UPHENO:0049652', 'UBERON:0015001', 'GO:0010558', 'UPHENO:0046505', 'GO:0010468', 'UPHENO:0005008', 'HP:0001877', 'GO:0010629', 'HP:0025354', 'UPHENO:0049837', 'HP:0040012', 'UBERON:0003460', 'UPHENO:0049757', 'UBERON:0010130', 'UPHENO:0050126', 'UPHENO:0069236', 'HP:0009821', 'UPHENO:0049642', 'UPHENO:0053601', 'UPHENO:0046403', 'HP:0006265', 'UPHENO:0050040', 'UPHENO:0002594', 'UBERON:0000073', 'GO:0008152', 'UPHENO:0025507', 'GO:0048523', 'GO:0043226', 'UBERON:0004122', 'HP:0000125', 'UPHENO:0087349', 'UBERON:0005173', 'UPHENO:0002782', 'UPHENO:0002803', 'UBERON:0002113', 'UBERON:0008962', 'UBERON:0013701', 'UBERON:0000465', 'HP:0002011', 'UPHENO:0041821', 'UPHENO:0075804', 'UPHENO:0002642', 'UPHENO:0004466', 'UBERON:0001434', 'UBERON:0011676', 'UPHENO:0078629', 'UPHENO:3000004', 'UPHENO:0041465', 'UPHENO:0080300', 'UBERON:0005172', 'UBERON:0001819', 'UPHENO:0002751', 'UPHENO:0076727', 'UPHENO:0075902', 'UPHENO:0086633', 'UPHENO:0003050', 'UBERON:0003072', 'UBERON:0001890', 'UPHENO:0003093', 'UPHENO:0087802', 'UPHENO:0041226', 'UPHENO:0004482', 'UPHENO:0050778', 'UPHENO:0076779', 'UPHENO:0002750', 'HP:0100542', 'UPHENO:0080352', 'UBERON:0002417', 'UPHENO:0004704', 'UBERON:0010371', 'UBERON:0002100', 'UPHENO:0002962', 'UBERON:0000916', 'UPHENO:0087427', 'UPHENO:0002903', 'UBERON:0019221', 'UPHENO:0087661', 'HP:0040195', 'UBERON:0000025', 'UPHENO:0081313', 'UPHENO:0026010', 'UPHENO:0004521', 'UBERON:0004381', 'HP:0007364', 'UBERON:0000481', 'CL:0000988', 'UPHENO:0075195', 'HP:0100547', 'UPHENO:0084763', 'HP:0012443', 'NCBITaxon:33208', 'UPHENO:0053563', 'UPHENO:0068898', 'UPHENO:0003177', 'UBERON:0011137', 'HP:0006503', 'UBERON:0010323', 'UBERON:0000924', 'UBERON:0003129', 'UPHENO:0004047', 'UBERON:0002346', 'HP:0002060', 'UPHENO:0076799', 'UBERON:0004053', 'UPHENO:0002944', 'UPHENO:0002909', 'UPHENO:0087089', 'UPHENO:0002536', 'UPHENO:0004621', 'UBERON:0004088', 'UBERON:0007811', 'UPHENO:0005285', 'NCBITaxon:131567', 'UBERON:0002090', 'NCBITaxon:6072', 'HP:0012639', 'UBERON:0003914', 'UBERON:0012139', 'UBERON:0003056', 'HP:0000252', 'UPHENO:0076805', 'UPHENO:0002668', 'UPHENO:0018390', 'UPHENO:0002553', 'NCBITaxon:33154', 'UPHENO:0053632', 'UBERON:0016880', 'UBERON:0016879', 'UPHENO:0086589', 'UPHENO:0002531', 'UPHENO:0086679', 'HP:0000079', 'UPHENO:0004615', 'NCBITaxon:1', 'HP:0000929', 'UBERON:0009145', 'UPHENO:0076702', 'NCBITaxon:2759', 'UPHENO:0087518', 'UPHENO:0080377', 'UBERON:0001893', 'UPHENO:0003001', 'UPHENO:0004523', 'UPHENO:0069352', 'HP:0000365', 'UPHENO:0002548', 'UBERON:0011143', 'UPHENO:0069149', 'UPHENO:0085371', 'UBERON:0000955'], 'has_phenotype_closure_label': ['protuberance', 'dermal skeleton', 'facial bone hypoplasia', 'skeleton of lower jaw phenotype', 'anatomical entity hypoplasia in face', 'jaw skeleton', 'neural crest-derived structure', 'neural fold phenotype', 'pharyngeal arch 1 morphology phenotype', 'facial bone', 'primary subdivision of skull', 'mandible', 'bone of lower jaw', 'facial skeleton', 'mandibular prominence', 'digestive system element phenotype', 'digestive system', 'bone of craniocervical region phenotype', 'bone of craniocervical region', 'subdivision of tube', 'Abnormal jaw morphology', 'protuberance phenotype', 'neural crest', 'facial skeleton morphology phenotype', 'primary subdivision of skull phenotype', 'neural crest morphology phenotype', 'jaw skeleton morphology phenotype', 'pharyngeal arch', 'mandibular prominence morphology phenotype', 'dermal skeletal element', 'neural crest phenotype', 'oral opening', 'epithelial fold phenotype', 'dentary', 'dermatocranium', 'head bone morphology phenotype', 'intramembranous bone', 'membrane bone', 'bone of lower jaw phenotype', 'membrane bone phenotype', 'dermal skeleton phenotype', 'decreased qualitatively system process', 'structure with developmental contribution from neural crest physiology phenotype', 'organ physiology phenotype', 'bone of jaw', 'decreased sensory perception of sound', 'decreased sensory perception', 'decreased sensory perception of mechanical stimulus', 'ear physiology phenotype', 'multicellular anatomical structure physiology phenotype', 'decreased biological_process', 'Abnormal ear physiology', 'sensory perception of mechanical stimulus', 'decreased multicellular organismal process', 'sensory perception of sound', 'material anatomical entity physiology phenotype', 'nervous system process phenotype', 'decreased qualitatively sensory perception of sound', 'Hearing impairment', 'dermatocranium phenotype', 'digestive system element', 'Abnormal nasal tip morphology', 'ectodermal placode phenotype', 'Aplasia/hypoplasia affecting bones of the axial skeleton', 'increased size of the ectoderm-derived structure', 'increased volume of anatomical entity', 'nose tip', 'decreased size of the palpebral fissure', 'external nose', 'cranial placode', 'external ectoderm', 'anatomical point', 'nose tip morphology phenotype', 'nervous system process', 'increased size of the multicellular anatomical structure', 'Bulbous nose', 'olfactory placode morphology phenotype', 'head bone', 'increased size of the olfactory organ', 'increased size of the organ', 'nose morphology phenotype', 'decreased size of the orifice', 'nose', 'embryonic craniocervical region', 'neural fold morphology phenotype', 'increased volume of nose', 'anatomical point phenotype', 'external ectoderm morphology phenotype', 'ectodermal placode', 'nose phenotype', 'increased size of the nose', 'mouth', 'olfactory organ phenotype', 'olfactory placode phenotype', 'Neoplasm', 'Pelvic kidney', 'temporofacial region', 'midface', 'pelvic kidney', 'localised trunk region element', 'midface morphology phenotype', 'midface phenotype', 'preauricular skin tag', 'primary subdivision of cranial skeletal system', 'localised abdominal segment element', 'Ectopic kidney', 'localised cavitated compound organ', 'decreased height of the multicellular organism', 'Growth delay', 'decreased size of the multicellular organism', 'anatomical entity height phenotype', 'delayed biological_process', 'growth', 'Short stature', 'Growth abnormality', 'Hyperpigmentation of the skin', 'Irregular hyperpigmentation', 'increased biological_process in skin of body', 'Hypermelanotic macule', 'increased size of the material anatomical entity', 'skin of body', 'Abnormality of the integument', 'Abnormality of the skin', 'skin of body morphology phenotype', 'anatomical structure physiology phenotype', 'morphology of intracellular organelle phenotype', 'Vitiligo', 'intracellular organelle', 'increased size of the anatomical structure', 'increased pigmentation', 'cellular_component phenotype', 'integumental system phenotype', 'skin of body phenotype', 'Abnormality of the genital system', 'external genitalia', 'male reproductive organ', 'sense organ physiology phenotype', 'gonad', 'reproductive system phenotype', 'localised anatomical structure', 'size of multicellular organism phenotype', 'male organism phenotype', 'Cryptorchidism', 'localised reproductive structure', 'Abnormal skin morphology', 'external male genitalia phenotype', 'increased qualitatively biological_process', 'Abnormal reproductive system morphology', 'localised organ', 'localised anatomical entity', 'localised male reproductive organ', 'reproductive organ phenotype', 'localised gonad', 'Abnormal testis morphology', 'Aplasia/Hypoplasia of the mandible', 'reproductive system', 'gonad phenotype', 'pigmentation', 'testis phenotype', 'reproductive structure phenotype', 'location of anatomical entity phenotype', 'male reproductive system', 'normal growth on benomyl', 'external male genitalia', 'reproductive system morphology phenotype', 'drinking behavior', 'anemia', 'pharyngeal arch 1 phenotype', 'Abnormal erythrocyte morphology', 'aplasia or hypoplasia of skull', 'drinking behavior phenotype', 'feeding behavior phenotype', 'hematopoietic system morphology phenotype', 'vestibulo-auditory system', 'erythrocyte morphology phenotype', 'immaterial entity', 'feeding behavior', 'multicellular organismal process', 'number of myeloid cell phenotype', 'Abnormal facial skeleton morphology', 'decreased number of erythrocyte', 'decreased number of leukocyte', 'decreased number of anatomical structure', 'eukaryotic cell', 'membrane-bounded organelle', 'oxygen accumulating cell', 'nucleate cell', 'pancytopenia', 'intramembranous bone phenotype', 'decreased length of orifice', 'decreased number of hematopoietic cell', 'hematopoietic system', 'hemolymphoid system', 'hematopoietic system phenotype', 'behavior', 'number of cell phenotype', 'bone marrow', 'decreased number of myeloid cell', 'Pancytopenia', 'decreased system process', 'neoplasm phenotype', 'biogenic amine secreting cell', 'anucleate cell', 'decreased number of cell', 'metabolic acidosis', 'number of leukocyte phenotype', 'reproductive structure', 'platelet phenotype', 'facial bone phenotype', 'myeloid cell', 'embryonic facial prominence', 'blood cell phenotype', 'pharyngeal arch 1', 'decreased number of anatomical entity', 'number of platelet phenotype', 'multi organ part structure', 'localised testis', 'optic vesicle phenotype', 'eye primordium phenotype', 'skeleton of lower jaw', 'camera-type eye', 'epithelial fold', 'eye primordium', 'non-connected functional system', 'blood cell', 'Abnormality of the face', 'digestive system morphology phenotype', 'Abnormal external genitalia morphology', 'orifice phenotype', 'unilaminar epithelium phenotype', 'palpebral fissure phenotype', 'cheek morphology phenotype', 'decreased number of material anatomical entity', 'visual system phenotype', 'behavior phenotype', 'ocular adnexa', 'entire sense organ system', 'camera-type eye phenotype', 'immature eye', 'localised material anatomical entity', 'primordium', 'Abnormality of the orbital region', 'sensory system phenotype', 'Abnormality of the palpebral fissures', 'enlarged nucleus; increased size of the nucleus', 'face', 'motile cell', 'palpebral fissure', 'Abnormality of multiple cell lineages in the bone marrow', 'disconnected anatomical group', 'optic cup', 'camera-type eye morphology phenotype', 'eyelid phenotype', 'eye phenotype', 'immature eye phenotype', 'integument phenotype', 'Abnormal eyelid morphology', 'orifice', 'localised compound organ', 'sense organ', 'sense organ phenotype', 'Abnormal bone marrow cell morphology', 'Blepharophimosis', 'decreased length of digit 1', 'decreased length of manual digit 1', 'decreased length of manual digit 1 or 5', 'decreased length of manual digit', 'decreased length of organism subdivision', 'decreased length of digit 1 or 5', 'sensory perception of mechanical stimulus phenotype', 'Short thumb', 'decreased size of the autopodial extension', 'decreased size of the manual digit', 'regional part of brain', 'postcranial axial skeleton', 'aplasia or hypoplasia of mandible', 'axial skeleton plus cranial skeleton', 'decreased size of the material anatomical entity in the pectoral complex', 'musculoskeletal system', 'epithelial tube phenotype', 'developing anatomical structure', 'phenotypic effect', 'musculature phenotype', 'immune system', 'forelimb bud morphology phenotype', 'forelimb zeugopod bone hypoplasia', 'decreased nervous system process', 'cellular anatomical structure', 'decreased size of the head', 'biological_process rate phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'pharyngeal arch system', 'anatomical entity hypoplasia', 'decreased size of the bone of pectoral complex', 'decreased size of the digit', 'surface structure phenotype', 'anatomical entity morphology in the manus phenotype', 'abdomen', 'bone of free limb or fin', 'bone of pectoral complex', 'decreased length of endochondral bone', 'Phenotypic abnormality', 'cheek', 'limb skeleton subdivision', 'macromolecule metabolic process', 'testis', 'cellular organisms', 'decreased size of the anatomical entity in the pectoral complex', 'regulation of macromolecule biosynthetic process', 'skeleton phenotype', 'external nose phenotype', 'limb phenotype', 'arm bone phenotype', 'optic vesicle', 'Forearm undergrowth', 'organelle', 'paired limb/fin segment', 'digit 1 phenotype', 'radius endochondral element', 'facial skeleton phenotype', 'behavior process phenotype', 'forelimb long bone', 'aplasia or hypoplasia of radius bone', 'forelimb bone', 'external genitalia phenotype', 'decreased size of the long bone', 'autopodial extension phenotype', 'telencephalon morphology phenotype', 'decreased size of the forelimb zeugopod bone', 'Micrognathia', 'system process phenotype', 'bone of appendage girdle complex', 'pigmentation phenotype', 'organ part', 'size of anatomical entity phenotype', 'embryonic structure', 'anatomical entity', 'external soft tissue zone phenotype', 'cell nucleus phenotype', 'Abnormal skeletal morphology', 'absent material anatomical entity in the limb bud', 'Short long bone', 'anatomical collection', 'growth phenotype', 'size of skull phenotype', 'decreased qualitatively nervous system process', 'paired limb/fin', 'anatomical collection phenotype', 'trunk phenotype', 'decreased length of multicellular anatomical structure', 'optic cup morphology phenotype', 'regulation of biological process', 'Abnormality of the skeletal system', 'manus phenotype', 'long bone', 'manus morphology phenotype', 'Abnormality of the musculoskeletal system', 'localised reproductive organ', 'paired limb/fin phenotype', 'decreased size of the skeletal element', 'surface structure', 'bone marrow cell', 'lateral structure', 'structure with developmental contribution from neural crest', 'long bone phenotype', 'ocular adnexa phenotype', 'pectoral complex', 'decreased length of bone element', 'biological regulation', 'limb long bone morphology phenotype', 'Aplasia/hypoplasia involving forearm bones', 'zone of organ phenotype', 'cheek phenotype', 'simple eye phenotype', 'multicellular organism phenotype', 'limb bud', 'foregut phenotype', 'embryo morphology phenotype', 'Opisthokonta', 'forelimb zeugopod', 'polydipsia', 'aplasia or hypoplasia of manual digit', 'skeletal system morphology phenotype', 'subdivision of head phenotype', 'anterior region of body', 'decreased length of bone of pectoral complex', 'neurogenic placode phenotype', 'Abnormal renal morphology', 'central nervous system', 'digestive tract', 'mesenchyme', 'brain', 'Hearing abnormality', 'embryonic tissue', 'anatomical entity length phenotype', 'integumental system', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'ectoderm-derived structure phenotype', 'material anatomical entity phenotype', 'paired limb/fin bud phenotype', 'delayed growth', 'digit 1', 'bone of jaw phenotype', 'bone of free limb or fin phenotype', 'paired limb/fin skeleton phenotype', 'head bone phenotype', 'eye', 'decreased length of material anatomical entity', 'trunk region element phenotype', 'negative regulation of gene expression phenotype', 'dermal skeletal element phenotype', 'telencephalon phenotype', 'skeleton of limb', 'dense mesenchyme tissue', 'subdivision of skeleton phenotype', 'zeugopodial skeleton', 'kidney', 'decreased length of anatomical conduit', 'Horseshoe kidney', 'organism subdivision', 'Abnormality of the male genitalia', 'absent multicellular anatomical structure', 'pectoral appendage', 'biosynthetic process phenotype', 'anatomical entity morphology phenotype', 'lower jaw region', 'anatomical system phenotype', 'foregut', 'decreased length of palpebral fissure', 'zeugopod', 'forelimb endochondral element phenotype', 'multicellular organism height phenotype', 'subdivision of head', 'All', 'mesoderm phenotype', 'pectoral appendage bud phenotype', 'leukocyte', 'appendicular skeleton phenotype', 'Aplasia/hypoplasia involving bones of the upper limbs', 'forelimb bud', 'limb skeleton subdivision phenotype', 'musculature of body phenotype', 'regulation of macromolecule biosynthetic process phenotype', 'radius bone', 'skeleton of pectoral complex', 'increased pigmentation in skin of body', 'radius bone phenotype', 'biosynthetic process', 'decreased length of organ', 'aplasia or hypoplasia of skeleton', 'mouth phenotype', 'dermal bone', 'skeletal system', 'craniocervical region morphology phenotype', 'decreased length of limb bone', 'structure with developmental contribution from neural crest phenotype', 'decreased length of endochondral element', 'mesoderm-derived structure phenotype', 'decreased size of the arm bone', 'arm phenotype', 'forelimb phenotype', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'primary subdivision of cranial skeletal system phenotype', 'endochondral bone', 'pharyngeal region of foregut', 'decreased length of long bone', 'embryonic tissue morphology phenotype', 'decreased length of arm bone', 'absent digit', 'non-neural ectoderm phenotype', 'increased biological_process', 'Abnormal male external genitalia morphology', 'endochondral bone phenotype', 'neural fold', 'digit morphology phenotype', 'bone of pectoral complex phenotype', 'Abnormal upper limb bone morphology', 'material anatomical entity', 'morphology of organelle phenotype', 'autopod region', 'Abnormality of the nose', 'absent anatomical structure in the forelimb', 'limb bone morphology phenotype', 'appendage phenotype', 'embryo phenotype', 'Microcephaly', 'decreased size of the organ', 'forelimb zeugopod bone phenotype', 'Abnormality of limbs', 'anatomical conduit phenotype', 'process', 'multicellular anatomical structure', 'Abnormality of the nervous system', 'lateral structure phenotype', 'decreased size of the anatomical entity', 'neural groove phenotype', 'Aplasia/hypoplasia involving the skeleton', 'material entity', 'bone element hypoplasia in face', 'subdivision of tube phenotype', 'musculature', 'pre-chordal neural plate', 'subdivision of digestive tract', 'developing anatomical structure phenotype', 'Aplasia/Hypoplasia of the radius', 'germ layer / neural crest phenotype', 'male reproductive organ morphology phenotype', 'negative regulation of biosynthetic process', 'Abnormal ocular adnexa morphology', 'U-shaped kidney', 'limb endochondral element', 'paired limb/fin bud', 'Abnormal localization of kidney', 'decreased qualitatively sensory perception', 'neural plate', 'decreased size of the endochondral element', 'cellular process', 'subdivision of skeletal system', 'central nervous system morphology phenotype', 'decreased size of the forelimb endochondral element', 'Aplasia/hypoplasia involving bones of the extremities', 'dense mesenchyme tissue phenotype', 'Abnormality of skull size', 'presumptive ectoderm', 'mesenchyme phenotype', 'Abnormality of chromosome stability', 'sensory system', 'axial skeleton plus cranial skeleton morphology phenotype', 'musculoskeletal system phenotype', 'aplasia or hypoplasia of anatomical entity', 'foregut morphology phenotype', 'Macule', 'organ system subdivision', 'mandible hypoplasia', 'radius bone hypoplasia', 'decreased size of the forelimb bone', 'decreased length of skeletal element', 'multicellular organism', 'nervous system morphology phenotype', 'axial skeletal system', 'decreased size of the anatomical conduit', 'limb', 'erythroid lineage cell', 'radius bone morphology phenotype', 'forelimb', 'Abnormal forearm bone morphology', 'decreased size of the endochondral bone', 'forelimb bone phenotype', 'Anemia', 'telencephalon', 'anatomical entity physiology phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'decreased length of anatomical structure', 'decreased number of platelet', 'mesenchyme morphology phenotype', 'forelimb morphology phenotype', 'anatomical structure phenotype', 'zeugopod phenotype', 'multicellular anatomical structure phenotype', 'mesoderm morphology phenotype', 'decreased size of the multicellular anatomical structure', 'cellular process phenotype', 'germ layer phenotype', 'decreased size of the organism subdivision', 'embryonic structure phenotype', 'mouth morphology phenotype', 'olfactory organ', 'limb endochondral element phenotype', 'forelimb zeugopod phenotype', 'Aplasia/Hypoplasia involving bones of the skull', 'limb segment', 'Abnormality of limb bone', 'decreased length of anatomical entity', 'germ layer', 'digestive system phenotype', 'localised multicellular anatomical structure', 'multicellular organism morphology phenotype', 'jaw region', 'Aplasia/Hypoplasia of the cerebrum', 'reproductive organ', 'Aplasia/hypoplasia of the extremities', 'pectoral appendage skeleton phenotype', 'male reproductive system morphology phenotype', 'taxon specific phenotype', 'appendicular skeleton morphology phenotype', 'pharyngeal arch phenotype', 'appendage', 'male reproductive organ phenotype', 'neurectoderm phenotype', 'limb bone phenotype', 'system', 'Abnormal forearm morphology', 'negative regulation of macromolecule metabolic process phenotype', 'Localized skin lesion', 'regulation of biosynthetic process phenotype', 'embryo', 'increased size of the anatomical entity', 'lateral plate mesoderm morphology phenotype', 'organ system subdivision phenotype', 'Squamous cell carcinoma', 'neural tube phenotype', 'head', 'eyelid morphology phenotype', 'orbital region phenotype', 'Abnormality of the upper limb', 'Abnormal morphology of the radius', 'gene expression', 'sensory perception phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'forelimb endochondral element', 'decreased qualitatively sensory perception of mechanical stimulus', 'Chromosome breakage', 'skeletal element', 'neurogenic placode', 'decreased length of forelimb endochondral element', 'limb long bone', 'long bone morphology phenotype', 'olfactory placode', 'forelimb long bone phenotype', 'renal system morphology phenotype', 'organism subdivision phenotype', 'homeostatic process', 'increased size of the sense organ', 'independent continuant', 'consumption behavior', 'anatomical entity phenotype', 'genitourinary system phenotype', 'presumptive structure', 'appendicular skeletal system', 'forelimb zeugopod skeleton', 'appendage girdle complex', 'decreased size of the bone of appendage girdle complex', 'subdivision of skeletal system phenotype', 'embryonic tissue phenotype', 'decreased qualitatively biological_process', 'endochondral element', 'Abnormal appendicular skeleton morphology', 'lateral plate mesoderm', 'absent autopodial extension', 'skeletal element phenotype', 'presumptive structure phenotype', 'variable depigmentation; vitiligo', 'skeleton', 'cell', 'Abnormal cellular physiology', 'vestibulo-auditory system phenotype', 'renal system', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'gastrula morphology phenotype', 'immaterial anatomical entity phenotype', 'entity', 'paired limb/fin segment phenotype', 'neural groove', 'arm bone', 'morphology of nucleus phenotype', 'mesoderm-derived structure', 'forelimb skeleton', 'simple eye', 'germ layer / neural crest', 'lateral plate mesoderm phenotype', 'decreased length of forelimb bone', 'Upper limb undergrowth', 'upper limb segment phenotype', 'autopod region morphology phenotype', 'regulation of cellular process phenotype', 'limb bud phenotype', 'paired limb/fin skeleton', 'Aplasia/Hypoplasia of fingers', 'cellular_component', 'subdivision of organism along appendicular axis', 'forelimb zeugopod bone', 'bone element', 'integument', 'forelimb zeugopod bone morphology phenotype', 'Short finger', 'tissue phenotype', 'Decreased head circumference', 'decreased length of autopodial extension', 'manual digit 1 plus metapodial segment', 'upper limb segment', 'decreased length of forelimb zeugopod bone', 'external soft tissue zone', 'macromolecule metabolic process phenotype', 'organ', 'intracellular membrane-bounded organelle', 'multi-limb segment region', 'decreased size of the anatomical structure in the pectoral complex', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'ear', 'Abnormality of the ear', 'bone of appendage girdle complex phenotype', 'Abnormal long bone morphology', 'Abnormality of the hand', 'limb bud morphology phenotype', 'arm', 'forelimb skeleton phenotype', 'anatomical system', 'absent material anatomical entity in the limb', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'segment of autopod', 'absent material anatomical entity in the forelimb', 'absent organism subdivision in the multicellular organism', 'absent anatomical structure in the multicellular organism', 'programmed DNA elimination by chromosome breakage', 'visual system', 'brain morphology phenotype', 'aplastic manual digit 1', 'Abnormal limb bone morphology', 'neurectoderm', 'Abnormal cerebral morphology', 'shape of kidney phenotype', 'number of anatomical enitites of type anatomical entity phenotype', 'macromolecule biosynthetic process phenotype', 'autopodial skeleton', 'Short digit', 'number of anatomical enitites of type material anatomical entity phenotype', 'digit 1 or 5', 'absent material anatomical entity in the multicellular organism', 'Abnormal forebrain morphology', 'Cafe-au-lait spot', 'musculature of body', 'Limb undergrowth', 'number of anatomical enitites of type organism subdivision phenotype', 'skeletal system phenotype', 'blastula', 'size of palpebral fissure phenotype', 'craniofacial/craniocervical phenotype', 'agenesis of anatomical entity', 'Finger aplasia', 'endochondral element phenotype', 'limb segment phenotype', 'abdomen element phenotype', 'Neoplasm by anatomical site', 'ecto-epithelium', 'ear phenotype', 'decreased size of the bone of free limb or fin', 'autopod region phenotype', 'external genitalia morphology; external genitalia phenotype', 'absent anatomical entity', 'erythroid lineage cell morphology phenotype', 'number of hematopoietic cell phenotype', 'absent organism subdivision', 'regulation of gene expression phenotype', 'digit plus metapodial segment', 'face morphology phenotype', 'ecto-epithelium phenotype', 'autopodial extension', 'organ part phenotype', 'absent anatomical structure in the limb', 'sensory perception of sound phenotype', 'absent multicellular anatomical structure in the forelimb', 'absent anatomical entity in the limb bud', 'pectoral appendage phenotype', 'Abnormal finger morphology', 'size of head phenotype', 'nucleus', 'decreased length of bone of free limb or fin', 'decreased size of the material anatomical entity', 'Aplasia/hypoplasia involving bones of the hand', 'decreased length of bone of appendage girdle complex', 'tissue', 'absent material anatomical entity', 'negative regulation of macromolecule metabolic process', 'root', 'Abnormal hand morphology', 'unilaminar epithelium', 'digit 1 or 5 phenotype', 'Eumetazoa', 'dentary phenotype', 'embryonic autopod plate morphology phenotype', 'postcranial axial skeletal system', 'forelimb zeugopod morphology phenotype', 'Abnormal thumb morphology', 'Absent thumb', 'Abnormal nasal morphology', 'non-neural ectoderm', 'manual digit 1 morphology phenotype', 'system process', 'number of anatomical enitites of type anatomical structure phenotype', 'Abnormal mandible morphology', 'mandible phenotype', 'Abnormality of body height', 'bone element phenotype', 'digit phenotype', 'Abnormality of blood and blood-forming tissues', 'Aplasia/Hypoplasia of the thumb', 'absent multicellular anatomical structure in the limb', 'manual digit morphology in the manus phenotype', 'Abnormal digit morphology', 'bone cell', 'manual digit 1', 'localised kidney', 'craniocervical region', 'segment of manus', 'Neoplasm of the skin', 'intracellular anatomical structure', 'ectoderm phenotype', 'subdivision of trunk', 'Abnormal external nose morphology', 'manual digitopodium region', 'pectoral appendage skeleton', 'aplastic anatomical entity', 'absent multicellular anatomical structure in the multicellular organism', 'absent anatomical entity in the multicellular organism', 'organ phenotype', 'subdivision of organism along appendicular axis phenotype', 'manual digit 1 or 5', 'absent anatomical structure', 'manual digit phenotype', 'cavitated compound organ', 'aplasia or hypoplasia of telencephalon', 'manual digit plus metapodial segment', 'localised abdomen element', 'limb morphology phenotype', 'occurrent', 'decreased size of the limb endochondral element', 'digit 1 plus metapodial segment', 'digit', 'male reproductive system phenotype', 'negative regulation of biological process phenotype', 'decreased size of the anatomical structure', 'manual digit', 'skeleton of manus', 'absent anatomical entity in the limb', 'decreased size of the bone element', 'Abnormal cellular phenotype', 'forebrain', 'absent anatomical entity in the forelimb', 'embryonic autopod plate', 'decreased length of digit', 'negative regulation of biological process', 'regulation of cellular process', 'cell phenotype', 'phenotype', 'metabolic process phenotype', 'anatomical conduit', 'regulation of metabolic process phenotype', 'regulation of biosynthetic process', 'multi-limb segment region phenotype', 'biological_process', 'anterior neural tube', 'gene expression phenotype', 'Abnormal size of the palpebral fissures', 'skull phenotype', 'head morphology phenotype', 'ectoderm-derived structure', 'zone of organ', 'Abnormality of metabolism/homeostasis', 'negative regulation of cellular process', 'Abnormality of the head', 'negative regulation of metabolic process', 'regulation of macromolecule metabolic process', 'regulation of macromolecule metabolic process phenotype', 'hematopoietic cell', 'orbital region', 'skull morphology phenotype', 'programmed DNA elimination', 'biological regulation phenotype', 'neural crest-derived structure phenotype', 'mesoderm', 'macromolecule biosynthetic process', 'decreased height of the anatomical entity', 'number of anatomical enitites of type erythrocyte phenotype', 'aplasia or hypoplasia of manual digit 1', 'regulation of metabolic process', 'negative regulation of cellular process phenotype', 'negative regulation of macromolecule biosynthetic process', 'regulation of gene expression', 'regional part of brain phenotype', 'negative regulation of metabolic process phenotype', 'Chromosomal breakage induced by crosslinking agents', 'localised lateral structure', 'Abnormal brain morphology', 'head phenotype', 'regulation of biological process phenotype', 'primordium phenotype', 'metabolic process', 'Short palpebral fissure', 'homeostatic process phenotype', 'shape of anatomical entity phenotype', 'abdominal segment element phenotype', 'anterior neural tube phenotype', 'trunk region element', 'compound organ', 'biological_process phenotype', 'renal/urinary system phenotype', 'subdivision of trunk phenotype', 'acropodium region', 'neural tube', 'pharyngeal arch morphology phenotype', 'anatomical structure', 'cavitated compound organ phenotype', 'Abnormality of the genitourinary system', 'main body axis', 'nose tip phenotype', 'upper urinary tract phenotype', 'body proper', 'shape of continuant phenotype', 'serotonin secreting cell', 'abdominal segment element', 'concave 3-D shape anatomical entity', 'dermal bone phenotype', 'subdivision of organism along main body axis phenotype', 'Abnormality of the kidney', 'secretory cell', 'Abnormality of the upper urinary tract', 'Hypoplasia of the radius', 'negative regulation of gene expression', 'future central nervous system phenotype', 'continuant', '3-D shape anatomical entity', 'consumption behavior phenotype', 'limb long bone phenotype', 'genitourinary system', 'upper urinary tract', 'abdomen element', 'excretory system', 'U-shaped anatomical entity', 'kidney phenotype', 'abdominal segment of trunk', 'trunk', 'cranial placode phenotype', 'Abnormality of the urinary system', 'immune system phenotype', 'kidney morphology phenotype', 'Aplasia/Hypoplasia involving the central nervous system', 'male organism', 'Morphological central nervous system abnormality', 'morphology of cellular_component phenotype', 'testis morphology phenotype', 'cranial skeletal system phenotype', 'digitopodium region', 'tube', 'Abnormal skull morphology', 'forebrain morphology phenotype', 'face phenotype', 'decreased size of the subdivision of organism along main body axis', 'regional part of nervous system phenotype', 'manus', 'renal system phenotype', 'ectoderm morphology phenotype', 'external nose morphology phenotype', 'brain phenotype', 'eyelid', 'bone of pectoral complex morphology phenotype', 'neural tube morphology phenotype', 'limb bone', 'decreased length of limb endochondral element', 'Abnormality of head or neck', 'behavior process', 'pectoral appendage bud', 'central nervous system phenotype', 'pre-chordal neural plate phenotype', 'compound organ phenotype', 'craniocervical region phenotype', 'epithelium phenotype', 'Abnormal nervous system morphology', 'forebrain phenotype', 'epithelium', 'erythrocyte', 'tube phenotype', 'absent manual digit', 'Metazoa', 'subdivision of digestive tract phenotype', 'nervous system', 'regional part of nervous system', 'decreased qualitatively multicellular organismal process', 'immaterial anatomical entity', 'Abnormality of the ocular adnexa', 'axial skeleton plus cranial skeleton phenotype', 'neural plate phenotype', 'multi organ part structure phenotype', 'presumptive ectoderm phenotype', 'platelet', 'nervous system phenotype', 'epithelial tube', 'subdivision of skeleton', 'Abnormal axial skeleton morphology', 'multicellular organismal process phenotype', 'gastrula', 'decreased size of the limb bone', 'appendicular skeleton', 'cranial skeletal system', 'skull', 'ectoderm', 'mandible morphology phenotype', 'neural plate morphology phenotype', 'multi-tissue structure phenotype', 'Eukaryota', 'multi-tissue structure', 'sensory perception', 'future nervous system', 'Abnormality of skin pigmentation', 'future central nervous system'], 'has_descendant': ['MONDO:0013499'], 'has_descendant_label': ['Fanconi anemia complementation group P'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0013248', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group O', 'description': 'Any Fanconi anemia in which the cause of the disease is a mutation in the RAD51C gene.', 'xref': ['DOID:0111096', 'GARD:15656', 'MEDGEN:462003', 'OMIM:613390', 'UMLS:C3150653'], 'synonym': ['FANCO', 'Fanconi Anemia, complementation group type O', 'Fanconi anaemia caused by mutation in RAD51C', 'Fanconi anaemia caused by mutation in Rad51C', 'Fanconi anaemia complementation group type O', 'Fanconi anemia caused by mutation in RAD51C', 'Fanconi anemia caused by mutation in Rad51C', 'Fanconi anemia complementation group type O', 'Fanconi anemia, complementation group O', 'RAD51C Fanconi anaemia', 'RAD51C Fanconi anemia', 'Rad51C Fanconi anaemia', 'Rad51C Fanconi anemia'], 'exact_synonym': ['FANCO', 'Fanconi Anemia, complementation group type O', 'Fanconi anaemia caused by mutation in RAD51C', 'Fanconi anaemia caused by mutation in Rad51C', 'Fanconi anaemia complementation group type O', 'Fanconi anemia caused by mutation in RAD51C', 'Fanconi anemia caused by mutation in Rad51C', 'Fanconi anemia complementation group type O', 'RAD51C Fanconi anaemia', 'RAD51C Fanconi anemia', 'Rad51C Fanconi anaemia', 'Rad51C Fanconi anemia'], 'related_synonym': ['Fanconi anemia, complementation group O'], 'subsets': ['gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0000126', 'HP:0009623', 'HP:0009778', 'HP:0000107', 'HP:0009777', 'HP:0001627', 'HP:0000028', 'HP:0025023', 'HP:0004322', 'HP:0040012', 'HP:0002023', 'HP:0001245', 'HP:0003241', 'HP:0003774', 'HP:0002984'], 'has_phenotype_label': ['Proximal placement of thumb', 'Abnormal heart morphology', 'Hypoplasia of the radius', 'Chromosome breakage', 'Renal cyst', 'Small thenar eminence', 'Hydronephrosis', 'External genital hypoplasia', 'Absent thumb', 'Stage 5 chronic kidney disease', 'Cryptorchidism', 'Anal atresia', 'Short stature', 'Short thumb', 'Rectal atresia'], 'has_phenotype_count': 15, 'has_phenotype_closure': ['GO:0009059', 'UPHENO:0049870', 'HP:0040012', 'UPHENO:0049837', 'UPHENO:0050435', 'HP:0025354', 'GO:0010629', 'UPHENO:0049775', 'UPHENO:0049652', 'UPHENO:0050007', 'GO:0031049', 'UPHENO:0078606', 'HP:0003220', 'CL:0000000', 'UPHENO:0049868', 'UPHENO:0050065', 'HP:0001939', 'GO:0048519', 'GO:0043170', 'UPHENO:0049620', 'UPHENO:0049904', 'GO:0060255', 'GO:0010467', 'UPHENO:0049873', 'UPHENO:0050063', 'UPHENO:0002651', 'UBERON:0014793', 'UPHENO:0002647', 'UBERON:0004481', 'UPHENO:0002786', 'GO:0008152', 'UPHENO:0003047', 'UBERON:0007269', 'UBERON:0001630', 'UPHENO:0002649', 'HP:0003011', 'HP:0001446', 'MPATH:62', 'MPATH:56', 'UPHENO:0083423', 'MPATH:1000', 'UPHENO:0000543', 'GO:0040007', 'UBERON:0007271', 'GO:0008150', 'BFO:0000003', 'HP:0004322', 'HP:0001510', 'UPHENO:0069254', 'UPHENO:0049874', 'BFO:0000015', 'UPHENO:0063563', 'HP:0002242', 'UPHENO:0063632', 'UBERON:0004921', 'UPHENO:0076773', 'HP:0011100', 'UPHENO:0002988', 'NCBITaxon:1', 'HP:0012732', 'UPHENO:0087367', 'UPHENO:0081341', 'UPHENO:0004487', 'UPHENO:0002546', 'UPHENO:0000541', 'UPHENO:0076735', 'HP:0002589', 'UBERON:0013765', 'UBERON:0000481', 'UPHENO:0002994', 'UPHENO:0084771', 'UPHENO:0074330', 'UBERON:0004907', 'UBERON:0000160', 'UBERON:0001046', 'UBERON:0006866', 'NCBITaxon:6072', 'NCBITaxon:131567', 'HP:0025023', 'UBERON:0013522', 'UPHENO:0002714', 'UPHENO:0004518', 'UPHENO:0063586', 'UPHENO:0003022', 'UPHENO:0002725', 'HP:0002250', 'NCBITaxon:33208', 'UPHENO:0063575', 'UBERON:0004489', 'UBERON:0000059', 'HP:0002034', 'HP:0011024', 'HP:0002023', 'UPHENO:0063599', 'UPHENO:0002548', 'UPHENO:0002859', 'UPHENO:0074229', 'UPHENO:0002861', 'UPHENO:0001360', 'UPHENO:0049757', 'UBERON:0003460', 'UPHENO:0011572', 'HP:0040064', 'HP:0004097', 'BFO:0000040', 'UPHENO:0086644', 'HP:0001421', 'UBERON:0001460', 'UPHENO:0046750', 'UPHENO:0086700', 'UPHENO:0003514', 'UBERON:0001353', 'UPHENO:0002816', 'UPHENO:0002554', 'GO:0065007', 'UBERON:0008785', 'UPHENO:0002360', 'UPHENO:0002650', 'UBERON:0004120', 'UBERON:0000383', 'HP:0002817', 'UBERON:0017716', 'UBERON:0000153', 'HP:0011842', 'UBERON:0012354', 'UPHENO:0026146', 'UBERON:0005451', 'UBERON:0010363', 'UPHENO:0003069', 'UPHENO:0002976', 'MPATH:603', 'UPHENO:0076810', 'UPHENO:0087346', 'UPHENO:0069266', 'MPATH:0', 'UBERON:0006058', 'HP:0002813', 'UPHENO:0081423', 'UBERON:0000948', 'UBERON:0034925', 'UPHENO:0083426', 'UBERON:0002529', 'UPHENO:0002269', 'UPHENO:0076803', 'UPHENO:0005214', 'HP:0000032', 'GO:0009058', 'UBERON:0003102', 'UPHENO:0002833', 'UBERON:0010314', 'UPHENO:0003049', 'UBERON:0004480', 'UPHENO:0068848', 'HP:0001167', 'UPHENO:0002531', 'UPHENO:0084761', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0087665', 'UBERON:5001463', 'UPHENO:0002422', 'UPHENO:0002945', 'UPHENO:0087006', 'UBERON:0004357', 'UPHENO:0002655', 'HP:0009623', 'UBERON:0004288', 'UPHENO:0069327', 'UPHENO:0002983', 'UBERON:0000465', 'UPHENO:0002902', 'UPHENO:0002559', 'HP:0001227', 'UPHENO:0001134', 'UPHENO:0087347', 'GO:0009892', 'HP:0011017', 'UPHENO:0005046', 'UBERON:0012140', 'UPHENO:0002746', 'HP:0001626', 'UPHENO:0049743', 'UBERON:0010708', 'UPHENO:0053644', 'UPHENO:0076724', 'UPHENO:0084132', 'GO:0042592', 'UPHENO:0001003', 'UBERON:0002470', 'UBERON:0000922', 'HP:0000118', 'UBERON:0000923', 'UBERON:0001463', 'UPHENO:0087663', 'UPHENO:0003088', 'HP:0012243', 'UPHENO:0053572', 'HP:0011844', 'UPHENO:0009146', 'UPHENO:0074227', 'UPHENO:0004892', 'UPHENO:0002926', 'HP:0000078', 'UPHENO:0087660', 'UPHENO:0001072', 'UPHENO:0063581', 'UPHENO:0084763', 'UPHENO:0076710', 'UPHENO:0086769', 'UBERON:0002471', 'UBERON:0005409', 'HP:0009778', 'UPHENO:0086635', 'HP:0000077', 'UPHENO:0074310', 'UPHENO:0002880', 'UBERON:0002102', 'UPHENO:0002733', 'UPHENO:0084448', 'UBERON:0019221', 'UPHENO:0074228', 'UBERON:0000075', 'UBERON:0002204', 'UPHENO:0046397', 'UPHENO:0050126', 'UBERON:0010130', 'UPHENO:0009020', 'UPHENO:0002593', 'HP:0010946', 'HP:0000126', 'UPHENO:0002267', 'UBERON:0000991', 'GO:0031052', 'UPHENO:0026183', 'UPHENO:0069292', 'UBERON:0004765', 'UPHENO:0002564', 'UBERON:0009569', 'UBERON:0005156', 'UBERON:0004122', 'UPHENO:0086546', 'UBERON:0000064', 'UPHENO:3000004', 'UBERON:0001434', 'UPHENO:0004466', 'UBERON:0011676', 'UBERON:0002389', 'UPHENO:0003334', 'UPHENO:0002530', 'UBERON:8450002', 'UPHENO:0075763', 'UBERON:0000026', 'UPHENO:0087427', 'UBERON:0000915', 'HP:0001507', 'UPHENO:0002708', 'UBERON:0000061', 'UBERON:0002075', 'UPHENO:0003065', 'HP:0000924', 'HP:0009127', 'UBERON:0000475', 'UPHENO:0002246', 'UPHENO:0002747', 'UPHENO:0084829', 'HP:0033127', 'UPHENO:0002731', 'UPHENO:0046624', 'UPHENO:0002576', 'UPHENO:0004173', 'UBERON:0002513', 'HP:0011297', 'UBERON:0010538', 'UBERON:0000489', 'GO:0019222', 'UPHENO:0002963', 'UBERON:0006598', 'HP:0012210', 'UPHENO:0080187', 'UPHENO:0063615', 'UPHENO:0076697', 'UPHENO:0003432', 'UPHENO:0002541', 'UBERON:0002091', 'UPHENO:0004476', 'HP:0000002', 'HP:0012211', 'UPHENO:0002896', 'UPHENO:0001044', 'UBERON:0010912', 'GO:0009987', 'UBERON:0005291', 'UPHENO:0086682', 'UBERON:0004535', 'MPATH:55', 'UBERON:0012361', 'UPHENO:0084841', 'UBERON:0015212', 'UPHENO:0069047', 'UPHENO:0079876', 'UBERON:0003104', 'UPHENO:0002782', 'UPHENO:0002803', 'UPHENO:0053571', 'UPHENO:0086172', 'UPHENO:0001303', 'UBERON:0001224', 'UPHENO:0069062', 'UPHENO:0011536', 'UBERON:0034923', 'UBERON:0000926', 'UPHENO:0046538', 'UPHENO:0003799', 'UBERON:0005881', 'UBERON:0036295', 'UPHENO:0001002', 'UPHENO:0063629', 'UBERON:0000477', 'UPHENO:0002568', 'UPHENO:0002525', 'UPHENO:0005277', 'UPHENO:7000069', 'UPHENO:0075195', 'UPHENO:0053559', 'UBERON:0005419', 'BFO:0000002', 'UBERON:0002101', 'HP:0000119', 'UPHENO:0069064', 'UBERON:0005417', 'UBERON:0003103', 'UPHENO:0002648', 'UBERON:0004375', 'UBERON:0002386', 'UPHENO:0087849', 'UPHENO:0063565', 'UPHENO:0003163', 'HP:0005922', 'UPHENO:0081204', 'UPHENO:0002600', 'UPHENO:0003366', 'UPHENO:0002870', 'UBERON:0003133', 'UBERON:0000468', 'UBERON:0005177', 'UBERON:0011249', 'UBERON:0005172', 'BFO:0000001', 'UPHENO:0003086', 'UBERON:0004111', 'UPHENO:0002542', 'UPHENO:0046741', 'HP:0009603', 'UPHENO:0076703', 'UBERON:0013702', 'UPHENO:0004680', 'HP:0003241', 'UBERON:0011582', 'UPHENO:0086633', 'UPHENO:0003050', 'UBERON:0001555', 'UPHENO:0050778', 'UPHENO:0076779', 'UPHENO:0003415', 'UPHENO:0003094', 'HP:0000001', 'UPHENO:0004885', 'UPHENO:0002668', 'UBERON:0001062', 'HP:0000079', 'UBERON:0002050', 'HP:0009484', 'UPHENO:0002754', 'UBERON:0000062', 'UPHENO:0011498', 'UBERON:0034929', 'UBERON:0004121', 'BFO:0000004', 'UPHENO:0081581', 'UBERON:0002113', 'UBERON:0011143', 'UPHENO:0076718', 'UPHENO:0003227', 'HP:0005927', 'UPHENO:0001001', 'UPHENO:0002442', 'UBERON:0005173', 'UPHENO:0087349', 'UBERON:0007688', 'UPHENO:0002830', 'UPHENO:0069328', 'UPHENO:0003093', 'UBERON:0010707', 'UBERON:0010712', 'HP:0003774', 'HP:0010935', 'UPHENO:0087501', 'UPHENO:0081451', 'UPHENO:0002536', 'UBERON:0001474', 'UPHENO:0049587', 'UPHENO:0068839', 'UPHENO:0088123', 'UBERON:0005423', 'GO:0010605', 'UBERON:0015061', 'UPHENO:0002632', 'UBERON:0001008', 'UPHENO:0002905', 'UPHENO:0080114', 'UPHENO:0004900', 'HP:0001155', 'UPHENO:0080352', 'UBERON:0002417', 'UPHENO:0003082', 'UBERON:0010000', 'UPHENO:0075893', 'UBERON:0002100', 'UPHENO:0001478', 'UPHENO:0002567', 'UPHENO:0003025', 'UPHENO:0002852', 'UPHENO:0053563', 'UPHENO:0068898', 'UPHENO:0004909', 'UPHENO:0002308', 'UPHENO:0088082', 'UPHENO:0026643', 'UBERON:0000479', 'UPHENO:0002685', 'UPHENO:0075159', 'UPHENO:0046411', 'UBERON:0004176', 'UBERON:0000990', 'UBERON:5002544', 'UPHENO:0003055', 'UBERON:0004381', 'UPHENO:0053561', 'UBERON:0012139', 'UBERON:0000916', 'UPHENO:0002523', 'UPHENO:0087547', 'HP:0011927', 'UPHENO:0063596', 'UPHENO:0002642', 'HP:0000811', 'UPHENO:7000206', 'UPHENO:0081065', 'UBERON:0001245', 'UBERON:0006048', 'UBERON:0002428', 'NCBITaxon:2759', 'UPHENO:0080369', 'UPHENO:0050121', 'UPHENO:0076692', 'HP:0009380', 'UPHENO:0002586', 'HP:0040068', 'UPHENO:0003084', 'UPHENO:0046445', 'UPHENO:0086956', 'UPHENO:0063558', 'UPHENO:0002526', 'UPHENO:0002964', 'UPHENO:0004475', 'UPHENO:0005016', 'UPHENO:0012274', 'UBERON:0007524', 'HP:0011805', 'UBERON:5002389', 'UBERON:0002544', 'UBERON:0001007', 'UPHENO:0082875', 'UPHENO:0076740', 'UPHENO:0049642', 'HP:0009821', 'HP:0001172', 'UPHENO:0063562', 'RO:0002577', 'UPHENO:0002571', 'UPHENO:0003005', 'UPHENO:0076783', 'UPHENO:0004507', 'UBERON:0010741', 'UBERON:0001009', 'HP:0010944', 'HP:0030680', 'UPHENO:0002832', 'UBERON:0005181', 'UBERON:0015228', 'UPHENO:0025509', 'UPHENO:0046594', 'UPHENO:0081424', 'UPHENO:0003056', 'UPHENO:0004831', 'UBERON:0001442', 'UPHENO:0049835', 'UPHENO:0076776', 'UPHENO:0004360', 'UPHENO:0004827', 'HP:0001627', 'UPHENO:0002634', 'UPHENO:0074245', 'UPHENO:0002944', 'UPHENO:0002909', 'UBERON:0004053', 'UPHENO:9002003', 'GO:0009889', 'HP:0002818', 'HP:0000035', 'UBERON:0005178', 'UPHENO:0011825', 'UPHENO:0080079', 'UPHENO:0004469', 'HP:0011277', 'UPHENO:0002386', 'UPHENO:0002385', 'HP:0000083', 'UPHENO:0074311', 'UPHENO:0002377', 'UPHENO:0008548', 'UPHENO:0046528', 'UPHENO:0074230', 'UPHENO:0002426', 'UPHENO:0003057', 'HP:0012622', 'UPHENO:0069605', 'UPHENO:0002427', 'UPHENO:0046540', 'UPHENO:0002967', 'UBERON:0008837', 'HP:0034915', 'UPHENO:0012308', 'UBERON:0010740', 'UPHENO:0068971', 'HP:0003026', 'UPHENO:0063594', 'UPHENO:0002577', 'HP:0006496', 'UPHENO:0046460', 'UPHENO:0002812', 'UBERON:0004710', 'UBERON:0012475', 'UBERON:0001423', 'HP:0002984', 'UPHENO:0002738', 'UBERON:5006048', 'HP:0040072', 'UPHENO:0069030', 'UPHENO:0003095', 'UPHENO:0087510', 'UBERON:0003081', 'UPHENO:0025585', 'UPHENO:0002637', 'UPHENO:0001147', 'UPHENO:0012440', 'UBERON:0011584', 'HP:0011314', 'UPHENO:0026640', 'UPHENO:0075944', 'UBERON:0003918', 'UPHENO:0046465', 'UPHENO:0088186', 'HP:0009826', 'UPHENO:0068912', 'UPHENO:0068932', 'UPHENO:0012312', 'UPHENO:0080325', 'HP:0006503', 'UPHENO:0002750', 'UBERON:0013701', 'UBERON:0008962', 'UPHENO:0026108', 'GO:0010558', 'UBERON:0015001', 'UPHENO:0074335', 'HP:0000028', 'UBERON:0001015', 'HP:0009815', 'UPHENO:0076754', 'UPHENO:0003045', 'UPHENO:0069194', 'HP:0009824', 'UPHENO:0053566', 'HP:0040070', 'UBERON:0010703', 'UPHENO:0002594', 'UPHENO:0046484', 'UPHENO:0068838', 'UBERON:0001440', 'UPHENO:0046479', 'UPHENO:0046392', 'HP:0045060', 'UPHENO:0002659', 'UBERON:0001052', 'UPHENO:0080126', 'UPHENO:0008668', 'UPHENO:0004595', 'UPHENO:0079872', 'UPHENO:0069046', 'GO:0010556', 'UPHENO:0069125', 'UBERON:0007272', 'UBERON:0002495', 'UPHENO:0003812', 'UPHENO:0046554', 'GO:0010468', 'UPHENO:0046505', 'UPHENO:0046396', 'UPHENO:0076727', 'UPHENO:0075902', 'UPHENO:0002751', 'UBERON:0008878', 'UPHENO:0026757', 'UBERON:0012141', 'UPHENO:0069163', 'UBERON:0003466', 'UPHENO:0046455', 'UBERON:0003606', 'UPHENO:0003159', 'UBERON:0015021', 'GO:0009890', 'UBERON:0011216', 'UBERON:0004347', 'UPHENO:0002719', 'HP:0009381', 'UBERON:0004708', 'UBERON:0002398', 'UPHENO:0046405', 'UPHENO:0002411', 'UPHENO:0002785', 'HP:0009115', 'UPHENO:0046531', 'UPHENO:0046552', 'UPHENO:0084834', 'UPHENO:0009382', 'HP:0012718', 'HP:0006501', 'UBERON:0003101', 'UBERON:0010758', 'UPHENO:0002597', 'UBERON:0007100', 'UPHENO:0053632', 'UPHENO:0076723', 'HP:0002973', 'UBERON:0003607', 'HP:0010461', 'UPHENO:0087802', 'UPHENO:0002682', 'UPHENO:0053580', 'HP:0001245', 'UPHENO:0084124', 'UBERON:0000473', 'UPHENO:0053647', 'UBERON:0010316', 'UPHENO:0002940', 'GO:0050789', 'UPHENO:0080351', 'UPHENO:0002949', 'UPHENO:0005025', 'UBERON:0000079', 'UBERON:0003135', 'NCBITaxon:33154', 'UPHENO:0002553', 'UPHENO:0018390', 'UBERON:0005090', 'UPHENO:0002595', 'UPHENO:0046707', 'HP:0000107', 'UPHENO:0080099', 'UPHENO:0069236', 'UBERON:0006717', 'UPHENO:0046483', 'HP:0009601', 'UPHENO:0069674', 'UPHENO:0050040', 'UPHENO:0046403', 'HP:0006265', 'UPHENO:0069684', 'UBERON:0019231', 'UPHENO:0008523', 'UPHENO:0026506', 'UPHENO:0026181', 'UPHENO:0011531', 'UPHENO:0063577', 'UPHENO:0026078', 'HP:0009777', 'GO:0048523', 'UPHENO:0063639', 'UPHENO:0025507', 'UBERON:0015410', 'UPHENO:0009163', 'UPHENO:0027017', 'GO:0050794', 'UPHENO:0081091', 'UPHENO:0009209', 'UPHENO:0081466', 'UPHENO:0081313', 'UPHENO:0026010', 'UPHENO:0087846', 'UPHENO:0025587', 'HP:0025031', 'UPHENO:0046740', 'UPHENO:0003413', 'UPHENO:0002969', 'HP:0025033', 'UPHENO:0002839', 'HP:0004378', 'UPHENO:0046426', 'UPHENO:0087973', 'UBERON:0000161', 'UBERON:0000025', 'UPHENO:0074237'], 'has_phenotype_closure_label': ['biological regulation phenotype', 'Abnormal cellular physiology', 'homeostatic process phenotype', 'metabolic process', 'negative regulation of metabolic process phenotype', 'regulation of gene expression', 'negative regulation of macromolecule biosynthetic process', 'negative regulation of cellular process phenotype', 'negative regulation of cellular process', 'cell', 'biosynthetic process phenotype', 'regulation of gene expression phenotype', 'programmed DNA elimination by chromosome breakage', 'programmed DNA elimination', 'regulation of macromolecule metabolic process phenotype', 'regulation of biosynthetic process', 'negative regulation of metabolic process', 'Abnormality of metabolism/homeostasis', 'gene expression phenotype', 'negative regulation of macromolecule metabolic process', 'cellular process phenotype', 'cell phenotype', 'negative regulation of macromolecule metabolic process phenotype', 'regulation of cellular process', 'macromolecule metabolic process', 'biological regulation', 'cellular process', 'homeostatic process', 'musculature of pectoral complex', 'Abnormal skeletal muscle morphology', 'Abnormality of the musculature of the hand', 'musculature of pectoral complex phenotype', 'musculature of limb phenotype', 'palmar part of manus phenotype', 'musculature of manus', 'Abnormality of chromosome stability', 'appendage musculature', 'Abnormality of the thenar eminence', 'pectoral appendage musculature phenotype', 'muscle structure phenotype', 'palmar/plantar part of autopod', 'musculature of upper limb', 'musculature of limb', 'muscle organ phenotype', 'thenar eminence phenotype', 'regulation of macromolecule metabolic process', 'Abnormality of the musculature of the limbs', 'musculature of manus phenotype', 'developmental and structural abnormality', 'anatomical entity cyst', 'pathological anatomical entity', 'pathological entity', 'pathological phenotype observation', 'regulation of biological process phenotype', 'Renal cyst', 'decreased height of the multicellular organism', 'Growth delay', 'decreased size of the multicellular organism', 'anatomical entity height phenotype', 'delayed biological_process', 'growth', 'Short stature', 'growth phenotype', 'Growth abnormality', 'Rectal atresia', 'Small thenar eminence', 'Abnormal intestine morphology', 'Eukaryota', 'biosynthetic process', 'closing of the anatomical system', 'Abnormal rectum morphology', 'multi-tissue structure phenotype', 'rectum phenotype', 'hindgut phenotype', 'digestive system element phenotype', 'intestine morphology phenotype', 'Eumetazoa', 'Abnormality of the musculature', 'closing of the subdivision of tube', 'subdivision of tube', 'root', 'Intestinal atresia', 'intestine phenotype', 'subdivision of digestive tract phenotype', 'large intestine', 'Abnormality of the gastrointestinal tract', 'anal region', 'alimentary part of gastrointestinal system morphology phenotype', 'alimentary part of gastrointestinal system phenotype', 'lower digestive tract', 'intestine', 'hindgut', 'terminal part of digestive tract', 'rectum', 'digestive system element', 'regulation of metabolic process phenotype', 'Anorectal anomaly', 'alimentary part of gastrointestinal system atresia', 'anatomical entity morphology in the alimentary part of gastrointestinal system phenotype', 'rectum morphology phenotype', 'ectoderm-derived structure atresia', 'closing of the anatomical conduit', 'muscle structure', 'Abnormality of the digestive system', 'macromolecule biosynthetic process', 'mesoderm', 'skeleton phenotype', 'bone of free limb or fin phenotype', 'paired limb/fin skeleton phenotype', 'limb skeleton subdivision phenotype', 'digit morphology phenotype', 'digit 1 phenotype', 'paired limb/fin segment', 'anatomical structure physiology phenotype', 'acropodium region', 'segment of manus', 'subdivision of trunk', 'pectoral complex', 'decreased length of bone element', 'manual digit morphology in the manus phenotype', 'anatomical collection', 'arm bone phenotype', 'limb endochondral element', 'paired limb/fin bud', 'skeletal system', 'musculoskeletal system', 'regulation of macromolecule biosynthetic process', 'decreased size of the anatomical entity in the pectoral complex', 'musculature of upper limb phenotype', 'surface structure', 'subdivision of skeleton phenotype', 'intestine atresia', 'renal pelvis', 'lateral structure physiology phenotype', 'male reproductive system', 'localised anatomical structure', 'skeletal system morphology phenotype', 'anterior region of body', 'Abnormal renal morphology', 'manual digit 1 morphology phenotype', 'Hydronephrosis', 'material anatomical entity phenotype', 'anatomical structure phenotype', 'embryonic autopod plate morphology phenotype', 'multicellular anatomical structure atresia', 'limb bud', 'multicellular organism phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'external genitalia', 'structure with developmental contribution from neural crest phenotype', 'structure with developmental contribution from neural crest', 'increased size of the anatomical structure', 'material anatomical entity', 'reproductive structure phenotype', 'decreased length of digit 1', 'skeleton', 'paired limb/fin segment phenotype', 'paired limb/fin', 'digit 1 or 5 phenotype', 'anatomical collection phenotype', 'pectoral appendage phenotype', 'Abnormal finger morphology', 'skeletal element', 'Abnormality of limb bone', 'limb segment', 'autopodial extension', 'digit plus metapodial segment', 'appendage', 'bone of appendage girdle complex phenotype', 'long bone phenotype', 'autopodial extension phenotype', 'regulation of macromolecule biosynthetic process phenotype', 'musculature of body phenotype', 'delayed growth', 'digit 1', 'material anatomical entity atresia', 'anatomical entity morphology in the manus phenotype', 'abdomen', 'hindgut morphology phenotype', 'decreased size of the bone of pectoral complex', 'Abnormal limb bone morphology', 'decreased length of digit 1 or 5', 'embryonic autopod plate', 'bone of appendage girdle complex', 'negative regulation of gene expression phenotype', 'trunk region element phenotype', 'multi-tissue structure', 'thoracic segment organ', 'decreased size of the forelimb zeugopod bone', 'regulation of cellular process phenotype', 'autopod region morphology phenotype', 'heart', 'decreased size of the organ', 'Cryptorchidism', 'Abnormality of limbs', 'anatomical conduit phenotype', 'paired limb/fin skeleton', 'Aplasia/Hypoplasia of fingers', 'limb bud phenotype', 'palmar part of manus', 'Abnormality of the musculoskeletal system', 'manus morphology phenotype', 'regulation of biological process', 'Abnormal gastrointestinal tract morphology', 'Abnormality of the skeletal system', 'radius bone phenotype', 'male reproductive organ phenotype', 'deviation of manual digit 1', 'decreased length of forelimb endochondral element', 'musculoskeletal system phenotype', 'organ system subdivision', 'aplasia or hypoplasia of anatomical entity', 'limb bone morphology phenotype', 'appendicular skeleton morphology phenotype', 'endochondral element', 'thoracic segment organ phenotype', 'decreased length of limb bone', 'Gastrointestinal atresia', 'Abnormality of the kidney', 'excretory system', 'decreased size of the long bone', 'external genitalia phenotype', 'renal pelvis/ureter', 'organ system subdivision phenotype', 'lateral plate mesoderm morphology phenotype', 'increased size of the anatomical entity', 'multicellular organism', 'decreased size of the forelimb bone', 'decreased length of skeletal element', 'male reproductive system morphology phenotype', 'taxon specific phenotype', 'orifice atresia', 'limb', 'radius bone morphology phenotype', 'disconnected anatomical group', 'spatial pattern of anatomical entity phenotype', 'absent multicellular anatomical structure in the limb', 'cyst', 'radius bone', 'embryonic tissue', 'decreased length of manual digit', 'Deviation of finger', 'main body axis', 'upper urinary tract phenotype', 'anatomical system', 'material entity', 'anus atresia', 'manus phenotype', 'organ part atresia', 'body proper', 'gonad phenotype', 'negative regulation of biosynthetic process', 'male reproductive organ morphology phenotype', 'Abnormal hand morphology', 'germ layer / neural crest', 'dilated renal pelvis', 'bone of pectoral complex', 'decreased size of the manual digit', 'forelimb zeugopod bone', 'bone element', 'subdivision of organism along appendicular axis', 'pectoral appendage musculature', 'mesoderm phenotype', 'multicellular organism height phenotype', 'All', 'Abnormal large intestine morphology', 'multicellular anatomical structure phenotype', 'forelimb long bone phenotype', 'renal system morphology phenotype', 'organ physiology phenotype', 'independent continuant', 'Abnormality of the urinary system physiology', 'organism subdivision phenotype', 'kidney mesenchyme', 'anatomical system atresia', 'heart morphology phenotype', 'Opisthokonta', 'embryo morphology phenotype', 'aplasia or hypoplasia of radius bone', 'embryonic tissue phenotype', 'decreased size of the autopodial extension', 'dilated anatomical entity', 'pectoral appendage bud', 'germ layer phenotype', 'decreased size of the organism subdivision', 'biological_process', 'multi-limb segment region phenotype', 'embryonic structure phenotype', 'External genital hypoplasia', 'biological_process phenotype', 'renal/urinary system phenotype', 'thenar eminence hypoplasia', 'arm phenotype', 'forelimb phenotype', 'lateral structure phenotype', 'absent anatomical structure', 'deviation of anatomical entity', 'germ layer', 'multicellular organism cyst', 'continuant', 'decreased length of bone of pectoral complex', 'renal pelvis morphology phenotype', 'Renal insufficiency', 'forelimb zeugopod bone morphology phenotype', 'paired limb/fin phenotype', 'localised reproductive organ', 'upper limb segment phenotype', 'compound organ phenotype', 'Abnormality of the genitourinary system', 'anatomical conduit', 'organism subdivision', 'limb phenotype', 'anatomical entity', 'embryonic structure', 'metabolic process phenotype', 'appendage musculature phenotype', 'phenotype', 'reproductive structure', 'abdominal segment element phenotype', 'anlage phenotype', 'kidney cyst', 'trunk', 'endochondral element phenotype', 'limb segment phenotype', 'abdomen element phenotype', 'renal system physiology phenotype', 'agenesis of anatomical entity', 'Finger aplasia', 'genitourinary system phenotype', 'presumptive structure', 'occurrent', 'limb morphology phenotype', 'localised male reproductive organ', 'process', 'multicellular anatomical structure', 'Abnormality of the genital system', 'Chromosome breakage', 'anatomical entity atresia', 'anatomical system phenotype', 'zeugopod', 'kidney', 'zeugopodial skeleton', 'anatomical entity morphology phenotype', 'reproductive system phenotype', 'Aplasia/hypoplasia involving the skeleton', 'anatomical structure', 'cavitated compound organ phenotype', 'subdivision of tube phenotype', 'musculature', 'subdivision of digestive tract', 'developing anatomical structure phenotype', 'embryo phenotype', 'Abnormal renal physiology', 'decreased length of organism subdivision', 'multi-limb segment region', 'digestive system phenotype', 'multicellular organism morphology phenotype', 'localised multicellular anatomical structure', 'macromolecule metabolic process phenotype', 'external soft tissue zone', 'organ', 'manus', 'renal system phenotype', 'Abnormal renal pelvis morphology', 'manual digit 1', 'abdominal segment of trunk', 'subdivision of trunk phenotype', 'thoracic segment of trunk', 'absent organism subdivision in the multicellular organism', 'abdominal segment element physiology phenotype', 'kidney morphology phenotype', 'Abnormal reproductive system morphology', 'subdivision of organism along main body axis phenotype', 'mesenchyme phenotype', 'renal system', 'Abnormality of the upper limb', 'regulation of biosynthetic process phenotype', 'embryo', 'compound organ', 'kidney phenotype', 'forelimb morphology phenotype', 'mesenchyme morphology phenotype', 'anatomical cluster', 'trunk region element', 'anus morphology phenotype', 'limb bud morphology phenotype', 'Abnormality of the upper urinary tract', 'renal pelvis phenotype', 'appendicular skeleton phenotype', 'pectoral appendage bud phenotype', 'Abnormal digit morphology', 'phenotypic effect', 'developing anatomical structure', 'increased size of the multicellular anatomical structure', 'large intestine morphology phenotype', 'lateral structure', 'Abnormality of body height', 'digit phenotype', 'bone element phenotype', 'reproductive system morphology phenotype', 'absent digit', 'embryonic tissue morphology phenotype', 'subdivision of skeleton', 'lateral plate mesoderm phenotype', 'abdomen element', 'anlage', 'size of anatomical entity phenotype', 'organ part', 'digestive tract', 'mesenchyme', 'upper urinary tract', 'kidney mesenchyme morphology phenotype', 'normal growth on benomyl', 'decreased length of anatomical entity', 'kidney mesenchyme phenotype', 'absent organism subdivision', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'endochondral bone', 'decreased length of long bone', 'increased size of the organ part', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'bone of pectoral complex morphology phenotype', 'decreased size of the anatomical structure in the pectoral complex', 'absent multicellular anatomical structure', 'Abnormality of the male genitalia', 'pectoral appendage', 'Dilatation of the renal pelvis', 'localised anatomical entity', 'absent anatomical structure in the multicellular organism', 'Phenotypic abnormality', 'limb skeleton subdivision', 'subdivision of tube atresia', 'arm', 'germ layer / neural crest phenotype', 'Aplasia/Hypoplasia of the radius', 'increased size of the renal pelvis', 'paired limb/fin bud phenotype', 'abdomen element physiology phenotype', 'increased size of the material anatomical entity', 'appendicular skeletal system', 'segment of autopod', 'absent material anatomical entity in the limb', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'cavitated compound organ', 'manual digit phenotype', 'Abnormality of the urinary system', 'digestive system morphology phenotype', 'orifice phenotype', 'Abnormal external genitalia morphology', 'reproductive system', 'reproductive organ phenotype', 'forelimb bud', 'manual digitopodium region', 'dense mesenchyme tissue phenotype', 'Abnormal appendicular skeleton morphology', 'lateral plate mesoderm', 'absent autopodial extension', 'deviation of manual digit', 'bone of free limb or fin', 'anatomical entity morphology in the appendage girdle complex phenotype', 'anatomical entity hypoplasia', 'musculature phenotype', 'forelimb bud morphology phenotype', 'Deviation of the thumb', 'alimentary part of gastrointestinal system', 'subdivision of skeletal system', 'skeleton of limb', 'dense mesenchyme tissue', 'manual digit plus metapodial segment', 'organ part phenotype', 'absent anatomical structure in the limb', 'circulatory system phenotype', 'digit', 'multicellular anatomical structure physiology phenotype', 'appendage girdle complex', 'decreased size of the bone of appendage girdle complex', 'subdivision of skeletal system phenotype', 'manual digit 1 or 5', 'organ phenotype', 'subdivision of organism along appendicular axis phenotype', 'Abnormality of the hand', 'Abnormal long bone morphology', 'external soft tissue zone phenotype', 'Abnormal skeletal morphology', 'absent material anatomical entity in the limb bud', 'skeletal system phenotype', 'subdivision of digestive tract atresia', 'heart phenotype', 'cardiovascular system morphology phenotype', 'closing of the material anatomical entity', 'circulatory organ', 'localised organ', 'trunk phenotype', 'Abnormal cardiovascular system morphology', 'Abnormality of the cardiovascular system', 'thoracic cavity element phenotype', 'muscle organ', 'localised testis', 'circulatory organ phenotype', 'autopod region', 'circulatory system', 'anatomical entity phenotype', 'thoracic cavity element', 'primary circulatory organ', 'forelimb endochondral element', 'Abnormal heart morphology', 'cardiovascular system', 'Forearm undergrowth', 'heart plus pericardium', 'negative regulation of gene expression', 'Hypoplasia of the radius', 'muscle organ morphology phenotype', 'decreased length of manual digit 1 or 5', 'primary circulatory organ phenotype', 'viscus phenotype', 'anatomical conduit atresia', 'forelimb zeugopod bone hypoplasia', 'cardiovascular system phenotype', 'anatomical system physiology phenotype', 'Upper limb undergrowth', 'material anatomical entity physiology phenotype', 'abdominal segment element', 'kidney physiology phenotype', 'developmental or adult structural  defect', 'decreased length of organ', 'trunk region element physiology phenotype', 'skeletal element phenotype', 'presumptive structure phenotype', 'cavitated compound organ physiology phenotype', 'decreased length of arm bone', 'compound organ physiology phenotype', 'bone of pectoral complex phenotype', 'Abnormal upper limb bone morphology', 'limb bone phenotype', 'system', 'Abnormal forearm morphology', 'digestive system', 'zeugopod phenotype', 'Aplasia/hypoplasia involving bones of the extremities', 'mesoderm morphology phenotype', 'decreased size of the multicellular anatomical structure', 'digit 1 plus metapodial segment', 'decreased size of the limb endochondral element', 'large intestine phenotype', 'forelimb zeugopod bone phenotype', 'Abnormal cellular phenotype', 'decreased size of the bone element', 'Aplasia/hypoplasia involving bones of the upper limbs', 'radius bone hypoplasia', 'autopod region phenotype', 'decreased size of the bone of free limb or fin', 'forelimb bone phenotype', 'anatomical entity length phenotype', 'decreased size of the material anatomical entity', 'Aplasia/hypoplasia involving bones of the hand', 'decreased length of bone of free limb or fin', 'internal anal region', 'decreased size of the endochondral element', 'decreased size of the forelimb endochondral element', 'closing of the subdivision of digestive tract', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'genitourinary system', 'limb long bone phenotype', 'mesoderm-derived structure', 'forelimb skeleton', 'appendage phenotype', 'Abnormal anus morphology', 'arm bone', 'decreased size of the arm bone', 'mesoderm-derived structure phenotype', 'decreased length of endochondral element', 'decreased length of endochondral bone', 'Abnormal thumb morphology', 'forelimb zeugopod morphology phenotype', 'limb endochondral element phenotype', 'forelimb zeugopod phenotype', 'forelimb zeugopod skeleton', 'decreased length of material anatomical entity', 'forelimb endochondral element phenotype', 'decreased size of the anatomical entity', 'decreased length of forelimb bone', 'decreased size of the endochondral bone', 'limb long bone morphology phenotype', 'Aplasia/hypoplasia involving forearm bones', 'long bone', 'aplasia or hypoplasia of skeleton', 'decreased size of the skeletal element', 'decreased length of multicellular anatomical structure', 'programmed DNA elimination by chromosome breakage phenotype', 'anatomical entity physiology phenotype', 'decreased length of anatomical structure', 'Abnormality of the musculature of the upper limbs', 'Abnormal digestive system morphology', 'forelimb', 'Abnormal forearm bone morphology', 'Short long bone', 'anatomical structure atresia', 'limb bone', 'decreased length of limb endochondral element', 'absent anatomical structure in the forelimb', 'forelimb skeleton phenotype', 'anatomical cluster phenotype', 'ectoderm-derived structure phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'closing of the organ part', 'entity', 'anus phenotype', 'skeleton of pectoral complex', 'forelimb bone', 'endochondral bone phenotype', 'Abnormal male external genitalia morphology', 'closing of the multicellular anatomical structure', 'forelimb long bone', 'radius endochondral element', 'forelimb zeugopod', 'aplasia or hypoplasia of manual digit', 'decreased length of forelimb zeugopod bone', 'long bone morphology phenotype', 'limb long bone', 'gene expression', 'Abnormal morphology of the radius', 'reproductive organ', 'pectoral appendage skeleton phenotype', 'Aplasia/hypoplasia of the extremities', 'appendicular skeleton', 'decreased size of the limb bone', 'decreased size of the material anatomical entity in the pectoral complex', 'cellular organisms', 'testis', 'external male genitalia', 'negative regulation of biological process phenotype', 'male reproductive system phenotype', 'location of anatomical entity phenotype', 'testis phenotype', 'Abnormal testis morphology', 'localised gonad', 'Deviation of the hand or of fingers of the hand', 'external male genitalia phenotype', 'increased size of the anatomical conduit', 'localised reproductive structure', 'size of multicellular organism phenotype', 'Proximal placement of thumb', 'male organism phenotype', 'rectum atresia', 'male organism', 'gonad', 'pectoral appendage skeleton', 'aplastic anatomical entity', 'male reproductive organ', 'closing of the ectoderm-derived structure', 'viscus', 'localised material anatomical entity', 'upper limb segment', 'manual digit 1 plus metapodial segment', 'decreased length of autopodial extension', 'absent material anatomical entity in the forelimb', 'macromolecule biosynthetic process phenotype', 'autopodial skeleton', 'thenar eminence', 'Short thumb', 'regulation of metabolic process', 'decreased height of the anatomical entity', 'aplasia or hypoplasia of manual digit 1', 'tissue phenotype', 'Short finger', 'decreased length of manual digit 1', 'Aplasia/Hypoplasia of the thumb', 'negative regulation of biological process', 'decreased length of digit', 'surface structure phenotype', 'Stage 5 chronic kidney disease', 'decreased size of the digit', 'aplastic manual digit 1', 'number of anatomical enitites of type anatomical entity phenotype', 'Anal atresia', 'Short digit', 'number of anatomical enitites of type material anatomical entity phenotype', 'digit 1 or 5', 'absent material anatomical entity in the multicellular organism', 'musculature of body', 'Limb undergrowth', 'number of anatomical enitites of type organism subdivision phenotype', 'external genitalia morphology; external genitalia phenotype', 'absent anatomical entity', 'absent multicellular anatomical structure in the forelimb', 'absent anatomical entity in the limb bud', 'tissue', 'decreased length of bone of appendage girdle complex', 'absent material anatomical entity', 'Metazoa', 'absent manual digit', 'Absent thumb', 'number of anatomical enitites of type anatomical structure phenotype', 'absent multicellular anatomical structure in the multicellular organism', 'absent anatomical entity in the multicellular organism', 'manual digit', 'decreased size of the anatomical structure', 'skeleton of manus', 'absent anatomical entity in the limb', 'absent anatomical entity in the forelimb', 'closing of the anatomical structure', 'Chronic kidney disease', 'orifice', 'digitopodium region', 'testis morphology phenotype', 'tube', 'Abnormality of the anus', 'anus', 'tube phenotype', 'ectoderm-derived structure', 'closing of the anatomical entity'], 'has_descendant': ['MONDO:0013248'], 'has_descendant_label': ['Fanconi anemia complementation group O'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0024525', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome 1', 'xref': ['DOID:0080757', 'MEDGEN:1635492', 'OMIM:134600', 'UMLS:C4551503'], 'synonym': ['DeToni-Debré-Fanconi syndrome', 'FRTS1', 'Fanconi renotubular syndrome', 'Fanconi renotubular syndrome 1', 'Fanconi syndrome without cystinosis', 'Luder-Sheldon syndrome', 'adult Fanconi syndrome', 'primary Fanconi renal syndrome', 'primary Fanconi renotubular syndrome', 'renal Fanconi syndrome'], 'exact_synonym': ['DeToni-Debré-Fanconi syndrome', 'FRTS1', 'Fanconi renotubular syndrome 1', 'primary Fanconi renal syndrome', 'primary Fanconi renotubular syndrome'], 'related_synonym': ['Fanconi renotubular syndrome', 'Fanconi syndrome without cystinosis', 'Luder-Sheldon syndrome', 'adult Fanconi syndrome', 'renal Fanconi syndrome'], 'subsets': ['gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0001942', 'HP:0002748', 'HP:0003126', 'HP:0004322', 'HP:0003648', 'HP:0002749', 'HP:0002900', 'HP:0003355', 'HP:0001324', 'HP:0034359', 'HP:0003109', 'HP:0002148', 'HP:0000083', 'HP:0000124', 'HP:0003155', 'HP:0003076'], 'has_phenotype_label': ['Low-molecular-weight proteinuria', 'Metabolic acidosis', 'Rickets', 'Renal tubular dysfunction', 'Hyperphosphaturia', 'Short stature', 'Lacticaciduria', 'Glycosuria', 'Aminoaciduria', 'Hypophosphatemia', 'Muscle weakness', 'Renal insufficiency', 'Osteomalacia', 'Impaired renal tubular reabsorption of phosphate', 'Hypokalemia', 'Elevated circulating alkaline phosphatase concentration'], 'has_phenotype_count': 16, 'has_phenotype_closure': ['GO:0070293', 'HP:0011038', 'UPHENO:0080559', 'CHEBI:60911', 'GO:0003008', 'CHEBI:59999', 'UPHENO:7000809', 'UBERON:0004176', 'CL:1000497', 'CL:0002522', 'UPHENO:0081424', 'CL:1000612', 'UPHENO:0046348', 'UBERON:0000174', 'CHEBI:26020', 'CHEBI:26079', 'CHEBI:36359', 'UPHENO:0080010', 'UPHENO:0003941', 'HP:0034359', 'CHEBI:26082', 'HP:0012591', 'UPHENO:0002943', 'CHEBI:32988', 'GO:0006629', 'CHEBI:33302', 'UPHENO:0088134', 'CL:0000232', 'UPHENO:0068565', 'UPHENO:0080556', 'UPHENO:0002308', 'UBERON:0004188', 'UPHENO:0002554', 'UBERON:0000179', 'UPHENO:0081423', 'UPHENO:7000393', 'HP:0003330', 'UPHENO:0002442', 'UPHENO:0001001', 'UPHENO:0085602', 'UPHENO:0002816', 'CHEBI:24870', 'HP:0000118', 'UBERON:0000922', 'CHEBI:33674', 'UBERON:0011216', 'UBERON:0000383', 'UPHENO:0005141', 'UPHENO:0004459', 'UPHENO:0002320', 'CL:0002584', 'UPHENO:0085578', 'UPHENO:0002267', 'UPHENO:0068169', 'UBERON:0003060', 'GO:0044283', 'CL:0000236', 'PR:000000001', 'UBERON:0000074', 'UBERON:0001474', 'CHEBI:33241', 'UBERON:0002390', 'UPHENO:0002948', 'HP:0003126', 'UBERON:0034923', 'HP:0003076', 'UPHENO:0082835', 'UBERON:0005256', 'UPHENO:0085566', 'HP:0001939', 'HP:0002748', 'UPHENO:0055014', 'HP:0001942', 'UBERON:0000080', 'CL:0000542', 'UPHENO:0088166', 'UBERON:0001015', 'UPHENO:0002346', 'UBERON:0002405', 'UBERON:0015203', 'HP:0025745', 'UPHENO:0055082', 'UBERON:0003133', 'UPHENO:0002870', 'CL:0000219', 'UPHENO:0050106', 'UPHENO:0066913', 'UPHENO:0085616', 'HP:0003110', 'UPHENO:0002685', 'UPHENO:0002281', 'CHEBI:51143', 'UPHENO:0002803', 'UPHENO:0002541', 'UPHENO:0003432', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0084654', 'UBERON:0009142', 'UBERON:0002193', 'UPHENO:0055032', 'UBERON:0002204', 'UPHENO:0054954', 'GO:1902224', 'UPHENO:0049628', 'CHEBI:33575', 'UPHENO:0054970', 'UBERON:0003104', 'CL:0000842', 'BFO:0000015', 'UPHENO:0002754', 'UBERON:0000062', 'CHEBI:33579', 'UBERON:0000479', 'UPHENO:0003055', 'CL:0000081', 'UBERON:0002120', 'UPHENO:0054967', 'CHEBI:36962', 'CHEBI:33582', 'UPHENO:0082834', 'CHEBI:25806', 'UPHENO:0002976', 'UPHENO:0069266', 'HP:0000924', 'CL:0000329', 'UPHENO:0082875', 'CHEBI:36914', 'CL:1000450', 'UPHENO:0066739', 'CHEBI:33675', 'HP:0011849', 'UPHENO:0076286', 'UBERON:0013701', 'UPHENO:0002832', 'HP:0011804', 'UPHENO:0088162', 'UBERON:0000025', 'UPHENO:0046284', 'UPHENO:0076692', 'UPHENO:0088170', 'UPHENO:0050121', 'UPHENO:0002568', 'UPHENO:0002525', 'UPHENO:0005277', 'UPHENO:7000414', 'UPHENO:7000815', 'HP:0000079', 'GO:0032501', 'CL:0000764', 'GO:0033500', 'UPHENO:0068491', 'CHEBI:33285', 'CHEBI:33917', 'CL:0002518', 'CHEBI:37577', 'UBERON:0004122', 'UPHENO:0049835', 'CL:1000510', 'UPHENO:0084653', 'CHEBI:18133', 'CHEBI:33256', 'GO:0042593', 'CHEBI:24431', 'UPHENO:0081547', 'CHEBI:33304', 'UBERON:0000465', 'UPHENO:7000382', 'UBERON:8450002', 'UPHENO:0003867', 'HP:0011842', 'UPHENO:0050240', 'BFO:0000040', 'UPHENO:0068054', 'UPHENO:7000212', 'UPHENO:0046383', 'UPHENO:0068110', 'UPHENO:0054955', 'HP:0033354', 'CHEBI:78616', 'HP:0003355', 'UPHENO:0002385', 'UBERON:0000468', 'UPHENO:0051763', 'UPHENO:0002526', 'UPHENO:0002964', 'UPHENO:0051191', 'CL:0002242', 'UPHENO:0002963', 'UBERON:0000489', 'CHEBI:24651', 'UPHENO:7000305', 'UBERON:0001229', 'UPHENO:0069254', 'GO:0048878', 'HP:0004360', 'GO:1901568', 'UPHENO:0002443', 'CHEBI:37622', 'HP:0004348', 'UBERON:0000463', 'UPHENO:0002559', 'UPHENO:0002902', 'UPHENO:0086172', 'GO:0001503', 'HP:0010930', 'CHEBI:17234', 'HP:0020129', 'UPHENO:3000004', 'HP:6000531', 'HP:0000119', 'UPHENO:0089294', 'CHEBI:60004', 'UPHENO:0055071', 'HP:0001510', 'UPHENO:0002270', 'HP:0010935', 'CL:0000226', 'HP:0000001', 'UPHENO:0004885', 'UPHENO:0051739', 'UPHENO:0003094', 'UPHENO:0051686', 'UBERON:0001007', 'UPHENO:0080377', 'UBERON:0005172', 'UPHENO:0001002', 'UPHENO:0081544', 'BFO:0000002', 'UPHENO:0004503', 'HP:0011277', 'UPHENO:0005015', 'UPHENO:0051635', 'CHEBI:36915', 'UBERON:0005751', 'CL:0000738', 'GO:1901570', 'UBERON:0000475', 'UPHENO:0051280', 'UBERON:0000481', 'CHEBI:36360', 'UPHENO:0000543', 'UPHENO:0003381', 'UPHENO:7000630', 'CHEBI:15693', 'UPHENO:0080555', 'UPHENO:0002576', 'GO:0046951', 'GO:0040007', 'UPHENO:0003093', 'UBERON:0010000', 'UPHENO:0002269', 'UPHENO:0005002', 'UPHENO:7000381', 'UBERON:0011143', 'UBERON:0001008', 'UPHENO:0002642', 'UPHENO:0066927', 'CHEBI:16541', 'UPHENO:0080658', 'CL:0000255', 'UBERON:0001062', 'UPHENO:0050433', 'HP:0012337', 'CHEBI:23367', 'CHEBI:16670', 'UBERON:0006553', 'CHEBI:33559', 'UPHENO:0068352', 'UBERON:0000063', 'UPHENO:0003413', 'CHEBI:16646', 'UPHENO:0051673', 'UBERON:0004211', 'UPHENO:7000317', 'UBERON:0003061', 'CL:0000945', 'UPHENO:0002536', 'UPHENO:0066943', 'UPHENO:0068971', 'UPHENO:0049873', 'UPHENO:0050791', 'UPHENO:0002386', 'UPHENO:0080662', 'UPHENO:0054961', 'GO:0044281', 'UPHENO:0055132', 'HP:0034684', 'HP:0004349', 'BFO:0000004', 'CHEBI:36963', 'CHEBI:50047', 'UPHENO:0002311', 'UPHENO:0076703', 'UPHENO:0005000', 'PR:000018263', 'UPHENO:0055153', 'CHEBI:36357', 'UPHENO:0051900', 'UPHENO:7000318', 'UPHENO:0080352', 'UBERON:0002417', 'GO:0009058', 'UPHENO:0069062', 'CL:0000763', 'GO:0008610', 'UBERON:0001230', 'UBERON:0001434', 'UBERON:0011676', 'HP:0000093', 'CHEBI:33250', 'UPHENO:0055077', 'CL:0000000', 'UPHENO:0050220', 'UPHENO:0001003', 'GO:0042592', 'GO:0044238', 'UPHENO:0087123', 'UPHENO:7000306', 'UPHENO:0004791', 'UPHENO:0002833', 'BFO:0000001', 'HP:0012599', 'UPHENO:7000615', 'UPHENO:0050416', 'CHEBI:35352', 'UBERON:0010316', 'UBERON:0004120', 'UPHENO:0003430', 'CHEBI:15841', 'UPHENO:0002532', 'UPHENO:0000541', 'UPHENO:0075159', 'UPHENO:0049723', 'HP:0001941', 'UPHENO:7000586', 'BFO:0000003', 'HP:0004322', 'UPHENO:0069327', 'HP:0001507', 'CL:0000988', 'UPHENO:0075195', 'UPHENO:0003022', 'UPHENO:0046283', 'UBERON:0001285', 'UPHENO:0034351', 'UPHENO:0066951', 'UBERON:0002050', 'UPHENO:0004683', 'UBERON:0000483', 'UPHENO:0034522', 'UPHENO:0002909', 'UPHENO:0075902', 'UPHENO:0051804', 'UPHENO:0051645', 'UBERON:0000926', 'HP:0000077', 'UPHENO:0089756', 'UPHENO:0089770', 'UBERON:0001088', 'UPHENO:0003207', 'UPHENO:0003159', 'HP:0002900', 'UPHENO:0004505', 'UPHENO:0046286', 'UPHENO:0002564', 'UPHENO:0002411', 'UPHENO:0002569', 'CHEBI:33318', 'UBERON:0003081', 'UPHENO:0002567', 'CHEBI:33839', 'HP:0032180', 'UBERON:0000178', 'UPHENO:0034253', 'UPHENO:7000595', 'UPHENO:0004418', 'UPHENO:0004900', 'HP:0002749', 'UBERON:0003918', 'UPHENO:0002571', 'CHEBI:50860', 'GO:0009987', 'UBERON:0005291', 'UPHENO:0066903', 'CHEBI:26216', 'UBERON:0007503', 'UPHENO:0003163', 'UPHENO:0079822', 'GO:0097205', 'CHEBI:24835', 'CHEBI:33259', 'UPHENO:0066960', 'CHEBI:33521', 'HP:0003111', 'UBERON:0006598', 'HP:0010929', 'UBERON:0004819', 'UBERON:0003074', 'UBERON:0004111', 'UPHENO:0002542', 'HP:0003648', 'UBERON:0005423', 'UPHENO:0004680', 'UPHENO:0002636', 'UBERON:0013702', 'UPHENO:0052002', 'UBERON:0007524', 'UPHENO:7000394', 'UPHENO:0002577', 'UPHENO:0051960', 'UPHENO:0024906', 'CHEBI:33238', 'CHEBI:36916', 'UBERON:0015212', 'UPHENO:7000608', 'UPHENO:0049904', 'UPHENO:0066964', 'UPHENO:0002523', 'CHEBI:22314', 'UBERON:0003103', 'CHEBI:24867', 'HP:0000002', 'HP:0012211', 'HP:0004379', 'UPHENO:0081777', 'UBERON:0000477', 'UBERON:0000061', 'HP:0012379', 'UPHENO:0034199', 'UPHENO:0002427', 'HP:0003155', 'PR:000003968', 'UPHENO:0075666', 'CHEBI:25367', 'UPHENO:0066925', 'UPHENO:0049874', 'CHEBI:24833', 'UBERON:0000064', 'CHEBI:36587', 'CHEBI:72695', 'CHEBI:33608', 'UPHENO:0066939', 'CHEBI:35605', 'HP:0033127', 'CHEBI:36586', 'CHEBI:64709', 'HP:0003109', 'UPHENO:0002359', 'HP:0003011', 'UBERON:0001630', 'GO:0008152', 'UPHENO:0003047', 'UPHENO:0051709', 'UBERON:0002100', 'UPHENO:0055067', 'HP:0100529', 'HP:0002148', 'UPHENO:0049587', 'UPHENO:0085627', 'UBERON:0005173', 'UBERON:0006555', 'UPHENO:0049618', 'UBERON:0006314', 'UBERON:0000923', 'UPHENO:0066950', 'UPHENO:0002731', 'UPHENO:0002422', 'UBERON:0005156', 'UBERON:0009569', 'UPHENO:0066921', 'UPHENO:0002531', 'UPHENO:0005201', 'UPHENO:0003088', 'UPHENO:0005285', 'UPHENO:0055006', 'UBERON:0003914', 'UPHENO:0049703', 'HP:0011042', 'UPHENO:0066954', 'CHEBI:60242', 'UPHENO:0002252', 'UPHENO:0048707', 'UPHENO:0004892', 'UPHENO:0002926', 'HP:0012072', 'UPHENO:0080351', 'UPHENO:0002949', 'UBERON:0007684', 'UPHENO:0081581', 'UPHENO:0005312', 'UBERON:0009773', 'UPHENO:0002248', 'CHEBI:33709', 'UPHENO:0002360', 'UPHENO:0002668', 'UPHENO:0002210', 'UBERON:0003064', 'GO:0006091', 'HP:0000124', 'UPHENO:0066959', 'UBERON:0002113', 'UPHENO:0066946', 'UPHENO:0002377', 'UPHENO:0003050', 'UBERON:0008987', 'UBERON:0001231', 'UPHENO:0002287', 'UPHENO:0002426', 'UBERON:0000916', 'UPHENO:0002246', 'UPHENO:0002859', 'UPHENO:0003025', 'CHEBI:35381', 'HP:0001324', 'HP:0000083', 'CHEBI:28358', 'CL:0002681', 'UBERON:0000990', 'UPHENO:0003999', 'UPHENO:0080379', 'UBERON:0005177', 'CL:0000424', 'UBERON:0005721', 'UPHENO:0080012', 'GO:0003014', 'UPHENO:0003191', 'UPHENO:0002793', 'UPHENO:7000428', 'UPHENO:0002765', 'UPHENO:0050391', 'UBERON:0012275', 'UPHENO:0050116', 'UBERON:0000353', 'UBERON:0001851', 'CL:1000449', 'UPHENO:0003209', 'UBERON:0007688', 'UPHENO:0003382', 'GO:0008150', 'UPHENO:0068144', 'UBERON:0005103', 'UBERON:0009201', 'UPHENO:0004969', 'UBERON:0000083', 'UPHENO:0003265', 'CL:1000746', 'HP:0032943', 'CL:0000066', 'UPHENO:0005075', 'UBERON:0005090', 'UPHENO:0002595', 'UPHENO:0068511', 'UBERON:0001225', 'UBERON:0004765', 'UBERON:0000058', 'UPHENO:0004360', 'CL:0000653', 'UPHENO:0002530', 'UPHENO:0003185'], 'has_phenotype_closure_label': ['Impaired renal tubular reabsorption of phosphate', 'renal absorption', 'decreased bone element strength', 'b cell morphology', 'Osteomalacia', 'kidney epithelial cell', 'renal corpuscle', 'cortex of kidney', 'renal glomerulus phenotype', 'multi-tissue structure', 'meso-epithelium phenotype', 'delayed growth', 'delayed biological_process', 'multicellular organism chemical entity level phenotype', 'increased level of carboxylic acid in urine', 'Growth abnormality', 'cell physiology phenotype', 'multicellular organism phenotype', 'glomerular cell', 'phosphorus molecular entity', 'mesonephric epithelium', 'anatomical entity height phenotype', 'oxoacid derivative', 'cellular process phenotype', 'uriniferous tubule', 'embryo phenotype', 'Abnormal renal physiology', 'mesonephric duct phenotype', 'primary amide', 'increased level of protein polypeptide chain in urine', 'protein polypeptide chain', 'Abnormality of metabolism/homeostasis', 'pnictogen molecular entity', 'epithelial vesicle', 'ketoacidosis', 'erythroid lineage cell', 'mononuclear leukocyte', 'skeletal system phenotype', 'heteroatomic molecular entity', 'leukocyte morphology phenotype', 'musculature phenotype', 'immune system', 'organ system subdivision physiology phenotype', 'anatomical structure physiology phenotype', 'hematopoietic cell', 'oxygen accumulating cell', 'Short stature', 'nephron', 'nucleate cell', 'urine protein level phenotype', 'small molecule biosynthetic process phenotype', 'skeletal system physiology phenotype', 'lateral plate mesoderm', 'skeletal system morphology phenotype', 'non-connected functional system', 'Hypokalemia', 'organ phenotype', 'mesoderm-derived structure', 'reproductive structure', 'decreased size of the anatomical entity', 'cell', 'renal system', 'decreased size of the material anatomical entity', 'Abnormal urine pH', 'skeletal system', 'Abnormal circulating metabolite concentration', 'musculature', 'amino acid chain', 'fatty acid derivative biosynthetic process', 'size of multicellular organism phenotype', 'hemolymphoid system', 'Abnormality of the musculoskeletal system', 'intermediate mesoderm phenotype', 'musculoskeletal system', 'epithelial tube phenotype', 'phosphate', 'anatomical entity mass density phenotype', 'oxygen molecular entity', 'lymphocyte morphology phenotype', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'urine phosphate level phenotype', 'decreased level of chemical entity', 'decreased functionality of the kidney epithelium', 'organ', 'reproductive organ', 'mesoderm-derived structure phenotype', 'trunk region element phenotype', 'disconnected anatomical group', 'Decreased anatomical entity mass density', 'leukocyte physiology phenotype', 'embryonic tissue', 'renal tubule', 'Reduced bone mineral density', 'organic amino compound', 'Elevated circulating alkaline phosphatase concentration', 'immune system phenotype', 'myeloid cell', 'anatomical entity dysfunction in independent continuant', 'duct', 'anatomical structure phenotype', 'musculature of body', 'protein', 'musculature of body phenotype', 'carbohydrate homeostasis phenotype', 'leukocyte', 'primary metabolic process', 'blood cell', 'Abnormality of the upper urinary tract', 'Abnormal bone ossification', 'cell phenotype', 'lymphocyte physiology phenotype', 'phosphorus oxoacids and derivatives', 't cell morphology', 'increased fatty acid derivative biosynthetic process', 'podocyte', 'amide', 'Growth delay', 'external genitalia', 'Metabolic acidosis', 'Abnormal renal tubular resorption', 'nephric duct', 'increased small molecule biosynthetic process', 'increased generation of precursor metabolites and energy', 'polypeptide', 'Abnormality of the skeletal system', 'decreased functionality of the nephron epithelium', 'motile cell', 'increased lipid biosynthetic process', 'renal absorption phenotype', 'occurrent', 'B cell physiology phenotype', 'organism subdivision', 'chemical entity', 'bone structure', 'epithelium phenotype', 'ketone body metabolic process', 'elemental molecular entity', 'hexose', 'Abnormality of bone mineral density', 'organ physiology phenotype', 'material anatomical entity phenotype', 'increased level of glucose in urine', 'chalcogen molecular entity', 'small molecule biosynthetic process', 'renal system phenotype', 'increased ketone body biosynthetic process', 'carbohydrate', 'Abnormal homeostasis', 'Abnormal urine protein level', 'glucose homeostasis phenotype', 'blood monoatomic ion level phenotype', 'aldohexose', 'podocyte phenotype', 'anatomical entity physiology phenotype', 'renal tubule phenotype', 'bone element mass density phenotype', 'decreased functionality of the renal tubule', 'renal/urinary system phenotype', 'biological_process phenotype', 'excretory system', 'phosphorus oxoacid derivative', 'carboxamide', 'Rickets', 'genitourinary system', 'upper urinary tract', 'organ system subdivision', 'musculoskeletal system phenotype', 'increased biosynthetic process', 'organochalcogen compound', 'Abnormality of the genitourinary system', 'anatomical system', 'organ part phenotype', 'homeostatic process', 'kidney mesenchyme', 'monosaccharide', 'hematopoietic system', 'Phenotypic abnormality', 'urine', 'anatomical entity morphology phenotype', 'anatomical system phenotype', 'increased cellular process', 'anatomical entity phenotype', 'main group molecular entity', 'mesonephric tubule', 'increased ketone body metabolic process', 'kidney epithelium', 'renal glomerulus', 'B cell', 'hemoglobin', 'continuant', 'decreased functionality of the anatomical structure', 'Abnormality of urine homeostasis', 'role urine level phenotype', 'increased level of monosaccharide in urine', 'Abnormality of the musculature', 'anatomical conduit', 'renal system physiology phenotype', 'abdomen element phenotype', 'Abnormal urine phosphate concentration', 'growth', 'anatomical conduit physiology phenotype', 'entity', 'polyatomic entity', 'increased metabolic process', 'external genitalia phenotype', 'Decreased bone element mass density', 'phenotypic effect', 'developing anatomical structure', 'blood cell phenotype', 'cortex phenotype', 'bodily fluid', 'decreased size of the multicellular anatomical structure', 'peptide', 'multicellular anatomical structure phenotype', 'Abnormal urinary electrolyte concentration', 'organic molecular entity', 'metabolic process phenotype', 'phenotype', 'small molecule metabolic process phenotype', 'decreased size of the multicellular organism', 'immune system morphology phenotype', 'Hyperphosphaturia', 'lipid metabolic process', 'phosphoric acid derivative', 'multicellular anatomical structure physiology phenotype', 'multicellular organism', 'lymphocyte of B lineage', 'glucose', 'renal filtration', 'Abnormal urinary organic compound level', 'material anatomical entity physiology phenotype', 'organism substance phenotype', 'Abnormality of the urinary system', 'muscle organ', 'independent continuant', 'Abnormality of the urinary system physiology', 'decreased functionality of the tissue', 'intermediate mesoderm', 'increased qualitatively biological_process', 'organism subdivision phenotype', 'pronephric duct phenotype', 'anatomical system physiology phenotype', 'vomiting', 'multicellular organismal process', 'epithelial cell of glomerular capsule', 'material entity', 'organooxygen compound', 'bone element', 'urine glucose level phenotype', 'cellular process', 'urine chemical entity level phenotype', 'acidosis', 'excretory tube', 'Abnormal muscle physiology', 'organism substance', 'growth phenotype', 'carbon group molecular entity', 'decreased functionality of the epithelium', 'kidney glomerular epithelial cell', 'bone ossification', 'eukaryotic cell', 'compound organ phenotype', 'skeletal element', 'Abnormal urine metabolite level', 'lymphocyte', 'tissue chemical entity level phenotype', 'excreta', 'carbohydrates and carbohydrate derivatives', 'decreased size of the anatomical structure', 'mesonephric duct', 'aciduria', 'increased fatty acid derivative metabolic process', 'subdivision of trunk phenotype', 'biological_process rate phenotype', 'p-block molecular entity', 'anatomical conduit phenotype', 'homeostasis', 'molecular entity', 'small molecule metabolic process', 'embryo', 'metabolic process', 'biological_process', 'excretory cell', 'phosphate level phenotype', 'presumptive structure', 'genitourinary system phenotype', 'process', 'multicellular anatomical structure', 'excretory tube physiology phenotype', 'renal system process', 'increased biological_process', 'single nucleate cell', 'hematopoietic system phenotype', 'generation of precursor metabolites and energy', 'blood potassium atom level phenotype', 'biosynthetic process', 'material anatomical entity', 'reproductive structure phenotype', 'increased primary metabolic process', 'metabolic acidosis', 'lipid metabolic process phenotype', 'taxon specific phenotype', 'mixture', 'Abnormal skeletal morphology', 'ossification', 'rickets', 'increased lipid metabolic process', 'anatomical entity', 'embryonic structure', 'mesonephros phenotype', 'insulin resistance', 'Hypophosphatemia', 'renal duct phenotype', 'pronephros phenotype', 'nitrogen molecular entity level phenotype', 'decreased functionality of the nephron tubule', 'chemical homeostasis', 'system process', 'Acidosis', 'ketone body biosynthetic process', 'All', 'multicellular organism height phenotype', 'generation of precursor metabolites and energy phenotype', 'Abnormality of acid-base homeostasis', 'lipid biosynthetic process phenotype', 'erythroid lineage cell morphology phenotype', 'lateral structure', 'Glycosuria', 'chemical homeostasis phenotype', 'embryonic tissue phenotype', 'pronephric mesoderm', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'tube', 'primary metabolic process phenotype', 'digestive system physiology phenotype', 'potassium atom level phenotype', 'biosynthetic process phenotype', 'glucose homeostasis', 'digestive system', 'increased small molecule metabolic process', 'fatty acid derivative metabolic process', 'decreased height of the anatomical entity', 'aldose', 'decreased height of the multicellular organism', 'developing anatomical structure phenotype', 'metal atom', 'main group element atom', 'decreased functionality of the excretory tube', 's-block element atom', 'germ layer / neural crest', 'Abnormal blood cation concentration', 'anlage', 'germ layer / neural crest phenotype', 'renal parenchyma', 'role blood level phenotype', 'Abnormal bone structure', 'alkaline phosphatase, tissue-nonspecific isozyme', 'Abnormality of body height', 'bone element phenotype', 'blood cation level phenotype', 'blood phenotype', 'decreased level of chemical entity in blood', 'lateral plate mesoderm phenotype', 'potassium atom', 'osteomalacia', 'organ system subdivision phenotype', 'organic molecule', 'kidney mesenchyme phenotype', 'inorganic cation', 'tissue', 'Abnormal circulating potassium concentration', 'decreased level of potassium atom in blood', 'epithelium physiology phenotype', 'alkali metal atom', 'Muscle weakness', 'tube physiology phenotype', 'anlage phenotype', 'trunk', 'mesenchyme', 'Low-molecular-weight proteinuria', 'inorganic ion', 'organ subunit phenotype', 'anatomical cluster phenotype', 'chemical entity level phenotype', 'Lacticaciduria', 'monoatomic entity', 'cation', 'amino acid level phenotype', 'monoatomic ion', 'trunk phenotype', 'decreased level of chemical entity in tissue', 'molecule', 'germ layer phenotype', 'decreased functionality of the anatomical entity', 'decreased functionality of the epithelial tube', 'haemolymphatic fluid phenotype', 'Abnormal blood monovalent inorganic cation concentration', 'trunk mesenchyme phenotype', 'tissue phenotype', 'mesoderm', 'mesenchyme phenotype', 'Renal tubular dysfunction', 'role bodily fluid level phenotype', 'podocyte physiology phenotype', 'atom', 'blood monovalent inorganic cation level phenotype', 'blood island phenotype', 'kidney corpuscule cell', 'ion', 'blood chemical entity level phenotype', 'dense mesenchyme tissue', 'embryonic structure phenotype', 'monovalent inorganic cation', 'blood', 'carbohydrate homeostasis', 'Aminoaciduria', 'inorganic molecular entity', 'blood island', 'Abnormal enzyme concentration or activity', 'alkaline phosphatase, tissue-nonspecific isozyme level phenotype', 'nephron epithelium phenotype', 'Abnormal circulating enzyme concentration or activity', 'germ layer', 'parenchyma phenotype', 'Abnormality of alkaline phosphatase level', 'increased level of alkaline phosphatase, tissue-nonspecific isozyme', 'kidney epithelium phenotype', 'epithelial cell', 'increased level of chemical entity', 'mesonephric epithelium phenotype', 'organonitrogen compound', 'Abnormal urine amino acid level', 'decreased level of phosphate in blood', 'kidney phenotype', 'hydroxides', 'hydrogen molecular entity', 'increased level of phosphate in urine', 'dense mesenchyme tissue phenotype', 'amino acid', 'lipid biosynthetic process', 'excretory tube phenotype', 'increased level of organic acid in urine', 'oxoacid', 'organic acid', 'organic oxo compound', 'increased level of amino acid in urine', 'carbon oxoacid', 'carbonyl compound', 'Aciduria', 'carboxylic acid', 'detached podocyte; visceral epithelial cell detachment', 'urine amino acid level phenotype', 'pronephros', 'cortex', 'muscle structure physiology phenotype', 's-block molecular entity', 'muscle organ phenotype', 'muscle organ physiology phenotype', 'muscle structure phenotype', 'muscle structure', 'decreased muscle organ strength', 'increased level of chemical entity in urine', 'increased urine role level', 'Abnormal blood phosphate concentration', 'size of anatomical entity phenotype', 'organ part', 'Abnormal blood ion concentration', 'decreased functionality of the multicellular anatomical structure', 'nephron tubule phenotype', 'decreased functionality of the anatomical conduit', 'blood phosphate level phenotype', 'trunk region element physiology phenotype', 'parenchyma', 'abdominal segment element physiology phenotype', 'glomerular visceral epithelium', 'abdominal segment element phenotype', 'trunk region element', 'epithelial vesicle phenotype', 'compound organ', 'kidney cortical cell', 'nephron epithelium', 'anatomical structure', 'cavitated compound organ phenotype', 'main body axis', 'upper urinary tract phenotype', 'subdivision of trunk', 'body proper', 'decreased functionality of the material anatomical entity', 'kidney physiology phenotype', 'abdominal segment element', 'subdivision of organism along main body axis phenotype', 'nephron phenotype', 'Abnormality of the kidney', 'skeletal element phenotype', 'presumptive structure phenotype', 'cavitated compound organ physiology phenotype', 'erythrocyte', 'heteroorganic entity', 'tube phenotype', 'epithelial tube physiology phenotype', 'epithelium', 'compound organ physiology phenotype', 'lateral structure physiology phenotype', 'entire embryonic mesenchyme', 'abdomen element', 'glomerular epithelium', 'abdomen element physiology phenotype', 'epithelial tube', 'tissue physiology phenotype', 'kidney', 'subdivision of organism along main body axis', 'chemical substance', 'lateral structure phenotype', 'nephron tubule', 'decreased functionality of the tube', 'abdominal segment of trunk', 'macromolecule', 'abdomen', 'glomerular capsule', 'Renal insufficiency', 'nephric duct phenotype', 'multicellular organismal process phenotype', 'kidney cell', 'renal duct', 'erythrocyte morphology phenotype', 'haemolymphatic fluid', 'epithelial cell of nephron', 'renal cortical epithelial cell', 'pronephric duct', 'duct phenotype', 'decreased creatinine clearance; decreased glomerular filtration rate', 'homeostatic process phenotype', 'increased level of rac-lactic acid in urine', 'bodily fluid phenotype', 'decreased anatomical entity strength', 'meso-epithelium', 'mesonephros', 'organ subunit', 'renal filtration cell', 'Proteinuria', 'rac-lactic acid', 'renal filtration phenotype', 'cavitated compound organ', 'pronephric mesoderm phenotype', 'reproductive system', 'trunk mesenchyme', 'racemate', 'renal system process phenotype', 'reproductive organ phenotype', 'system process phenotype', 'urine ph', 'nitrogen molecular entity', 'anatomical cluster', 'multi-tissue structure phenotype', 'mesonephric tubule phenotype', 'mesoderm phenotype', 'renal filtration rate phenotype', 'decreased role blood level', 'reproductive system phenotype'], 'has_descendant': ['MONDO:0024525'], 'has_descendant_label': ['Fanconi renotubular syndrome 1'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0014985', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group V', 'description': 'Any Fanconi anemia in which the cause of the disease is a mutation in the MAD2L2 gene.', 'xref': ['DOID:0111080', 'GARD:16213', 'MEDGEN:934619', 'OMIM:617243', 'UMLS:C4310652'], 'synonym': ['FANCV', 'Fanconi Anemia, complementation Group 5', 'Fanconi Anemia, complementation group V', 'Fanconi Anemia, complementation group type V', 'Fanconi anaemia caused by mutation in MAD2L2', 'Fanconi anaemia complementation group type V', 'Fanconi anemia caused by mutation in MAD2L2', 'Fanconi anemia complementation group type V', 'Fanconi anemia, complementation GROUP V', 'MAD2L2 Fanconi anaemia', 'MAD2L2 Fanconi anemia'], 'exact_synonym': ['FANCV', 'Fanconi Anemia, complementation group V', 'Fanconi Anemia, complementation group type V', 'Fanconi anaemia caused by mutation in MAD2L2', 'Fanconi anaemia complementation group type V', 'Fanconi anemia caused by mutation in MAD2L2', 'Fanconi anemia complementation group type V', 'MAD2L2 Fanconi anaemia', 'MAD2L2 Fanconi anemia'], 'related_synonym': ['Fanconi Anemia, complementation Group 5', 'Fanconi anemia, complementation GROUP V'], 'subsets': ['gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0006254', 'HP:0001903', 'HP:0000252', 'HP:0001875', 'HP:0004322', 'HP:0003221', 'HP:0001873', 'HP:0005528'], 'has_phenotype_label': ['Decreased total neutrophil count', 'Thrombocytopenia', 'Elevated circulating alpha-fetoprotein concentration', 'Short stature', 'Anemia', 'Chromosomal breakage induced by crosslinking agents', 'Bone marrow hypocellularity', 'Microcephaly'], 'has_phenotype_count': 8, 'has_phenotype_closure': ['UPHENO:0069149', 'HP:0009121', 'UPHENO:0069352', 'HP:0002977', 'HP:0002011', 'UBERON:0000475', 'HP:0000929', 'UBERON:0000153', 'HP:0000707', 'UPHENO:0086589', 'UPHENO:0002816', 'HP:0011842', 'UBERON:0011676', 'UPHENO:0080079', 'HP:0000152', 'UBERON:0010912', 'UPHENO:0087089', 'HP:0002060', 'UBERON:0004288', 'UPHENO:0075148', 'UPHENO:0002746', 'UBERON:0003129', 'UBERON:0011137', 'UPHENO:0075804', 'HP:0012443', 'UPHENO:0002650', 'HP:0000234', 'HP:0100547', 'UPHENO:0076703', 'UPHENO:0035045', 'UPHENO:0035151', 'UBERON:0004765', 'UPHENO:0085409', 'HP:0012145', 'UPHENO:0002844', 'UBERON:0001434', 'UPHENO:0088326', 'UPHENO:0080009', 'UPHENO:0004480', 'UPHENO:0077371', 'UBERON:0010323', 'UPHENO:0085306', 'GO:0019222', 'GO:0048523', 'UBERON:0001474', 'GO:0009059', 'UPHENO:0069236', 'UPHENO:0050126', 'UPHENO:0049757', 'UPHENO:0049837', 'HP:0025354', 'GO:0010629', 'GO:0010468', 'GO:0010558', 'UPHENO:0049775', 'UPHENO:0049652', 'CL:0002092', 'GO:0031052', 'GO:0031049', 'HP:0003220', 'UPHENO:0049868', 'UPHENO:0050063', 'GO:0009058', 'GO:0043170', 'UPHENO:0049743', 'GO:0010556', 'GO:0009890', 'UBERON:0002204', 'UPHENO:0049620', 'GO:0060255', 'HP:0005561', 'GO:0009892', 'GO:0010467', 'HP:0011017', 'UPHENO:0049873', 'UBERON:0001049', 'UBERON:0003075', 'UBERON:0001890', 'UBERON:0000955', 'UPHENO:0002548', 'UPHENO:0076791', 'UPHENO:0035034', 'UBERON:0001893', 'UPHENO:0087518', 'UPHENO:0003025', 'UPHENO:0002859', 'UPHENO:0086173', 'UPHENO:7000590', 'CL:0000458', 'GO:0009889', 'UBERON:0002616', 'NCBITaxon:2759', 'UPHENO:0086485', 'UPHENO:0005055', 'UBERON:0034925', 'UPHENO:0005092', 'UPHENO:0005141', 'HP:0000252', 'UPHENO:0076805', 'UBERON:0003080', 'NCBITaxon:1', 'UPHENO:0004615', 'UPHENO:0087660', 'UPHENO:0003004', 'UBERON:0016879', 'UBERON:0006601', 'GO:0050794', 'UBERON:0000064', 'NCBITaxon:33154', 'UPHENO:0069254', 'UPHENO:0049874', 'UPHENO:0080351', 'UPHENO:0081423', 'UPHENO:0076692', 'CL:0000457', 'UPHENO:0002536', 'HP:0033127', 'HP:0011992', 'UBERON:0005944', 'UBERON:0005423', 'UPHENO:0068971', 'PR:000003809', 'UBERON:0001062', 'UPHENO:0077391', 'UPHENO:0087661', 'CHEBI:33256', 'CHEBI:16670', 'HP:0001877', 'UPHENO:0075220', 'CHEBI:36963', 'HP:0006254', 'HP:0032180', 'CHEBI:33285', 'CL:0000764', 'UBERON:0001869', 'HP:0005528', 'CHEBI:37622', 'CL:0001035', 'HP:0010876', 'UPHENO:0002554', 'UBERON:0000179', 'CHEBI:35352', 'UPHENO:0075159', 'CL:0000255', 'UPHENO:0088123', 'UBERON:0003104', 'UPHENO:0052002', 'HP:0001911', 'CL:0000766', 'UPHENO:0087363', 'PR:000018263', 'UPHENO:0002926', 'UPHENO:0063794', 'UPHENO:0080352', 'UPHENO:0004505', 'UBERON:0000479', 'CHEBI:33579', 'HP:0045056', 'CHEBI:51143', 'CL:0000000', 'UBERON:0007811', 'UPHENO:0004621', 'UPHENO:0050121', 'UPHENO:0089759', 'GO:0032501', 'UPHENO:0077817', 'CHEBI:33304', 'UBERON:0000465', 'HP:0012639', 'CHEBI:33302', 'CHEBI:50047', 'UBERON:0000923', 'UBERON:0000383', 'UBERON:0004120', 'UPHENO:0004892', 'UPHENO:0051763', 'UPHENO:0002964', 'UPHENO:0049904', 'BFO:0000001', 'GO:0008150', 'UPHENO:0086172', 'UBERON:0003061', 'UPHENO:0049622', 'UBERON:0010371', 'PR:000000001', 'HP:0001939', 'UBERON:0000468', 'UPHENO:0075195', 'UPHENO:0004885', 'HP:0000001', 'UPHENO:0050778', 'CHEBI:24431', 'UPHENO:0081547', 'HP:0001510', 'UPHENO:0051612', 'UPHENO:0081566', 'UPHENO:0002564', 'HP:0011875', 'UPHENO:7000311', 'UPHENO:0002541', 'HP:0000240', 'UPHENO:0002648', 'UPHENO:0078606', 'UPHENO:0002577', 'UBERON:0006598', 'UPHENO:0050435', 'BFO:0000002', 'UPHENO:0004459', 'GO:0008152', 'CHEBI:23367', 'HP:0000118', 'UBERON:0000922', 'UBERON:0002193', 'UPHENO:0046378', 'CL:0000233', 'GO:0042756', 'UBERON:0005291', 'UPHENO:0002571', 'UPHENO:0002764', 'UBERON:0000061', 'UPHENO:0046383', 'UBERON:0013701', 'CHEBI:33675', 'UPHENO:0076286', 'CHEBI:16541', 'HP:0004322', 'UBERON:0002371', 'UPHENO:0001003', 'BFO:0000015', 'UPHENO:0080200', 'BFO:0000003', 'UPHENO:0049870', 'CHEBI:36357', 'UBERON:0000033', 'GO:0010605', 'UBERON:0000926', 'UPHENO:0003177', 'UPHENO:0003207', 'UPHENO:0004523', 'UPHENO:0051804', 'CL:0000988', 'UPHENO:0002567', 'UPHENO:0035147', 'UPHENO:0076702', 'CHEBI:25806', 'UPHENO:0001002', 'UPHENO:0004900', 'UPHENO:0004418', 'UPHENO:0004047', 'GO:0050789', 'UPHENO:0002532', 'UBERON:0001017', 'CHEBI:50860', 'UPHENO:0002568', 'CHEBI:33839', 'UPHENO:0002542', 'UPHENO:0004802', 'UPHENO:0089764', 'UPHENO:0048751', 'UBERON:0002090', 'CL:0000763', 'NCBITaxon:131567', 'GO:0009987', 'UPHENO:0087907', 'UPHENO:0003799', 'UPHENO:0004503', 'UPHENO:0002559', 'UPHENO:0002870', 'UPHENO:0004519', 'HP:0032309', 'UBERON:0010316', 'CHEBI:32988', 'UPHENO:0003432', 'UPHENO:0087665', 'UPHENO:0002525', 'UBERON:0000467', 'UPHENO:0046284', 'HP:0040195', 'UBERON:0000025', 'UPHENO:0088162', 'BFO:0000004', 'UBERON:0003081', 'UBERON:0010000', 'HP:0000924', 'GO:0042592', 'UPHENO:0004484', 'UBERON:0004111', 'HP:0003221', 'UBERON:0000178', 'UPHENO:0002976', 'UPHENO:0069266', 'UPHENO:0086679', 'CHEBI:33582', 'UPHENO:0077822', 'CHEBI:36962', 'UPHENO:0001001', 'UBERON:0001016', 'UBERON:0013702', 'UPHENO:0004680', 'UPHENO:0002948', 'UPHENO:0003163', 'HP:0040012', 'UPHENO:0081424', 'UPHENO:0069327', 'UPHENO:0081581', 'UPHENO:0087123', 'HP:0001872', 'CHEBI:15841', 'UPHENO:0000541', 'UBERON:0015203', 'CL:0000094', 'GO:0040007', 'UBERON:0034923', 'UPHENO:0085354', 'UBERON:0000463', 'GO:0007610', 'UPHENO:0002902', 'UBERON:0002390', 'UBERON:0011216', 'UPHENO:0002949', 'UBERON:0006314', 'HP:0000002', 'UPHENO:0000543', 'HP:0001507', 'UPHENO:0002531', 'UPHENO:0087339', 'CL:0000329', 'UPHENO:0088170', 'UPHENO:0077373', 'UPHENO:0002668', 'HP:0001871', 'UBERON:0011138', 'GO:0007631', 'UPHENO:0079835', 'UPHENO:0079826', 'HP:0001873', 'UPHENO:0049664', 'CL:0000081', 'GO:0048519', 'UPHENO:0050106', 'UPHENO:0076675', 'UPHENO:0086176', 'UPHENO:0080010', 'HP:0001874', 'UPHENO:0085371', 'UPHENO:0085344', 'CL:0000738', 'UPHENO:0034969', 'HP:0010974', 'CL:0000219', 'UPHENO:0002963', 'CL:0002242', 'HP:0001881', 'UPHENO:0049835', 'UPHENO:0077348', 'UPHENO:0077399', 'UPHENO:0050007', 'NBO:0000313', 'UPHENO:0011531', 'HP:0010987', 'HP:0011991', 'NBO:0001845', 'NCBITaxon:6072', 'UPHENO:0050040', 'UPHENO:0077826', 'UBERON:0000073', 'UBERON:0002405', 'HP:0002715', 'UPHENO:7000530', 'UPHENO:0035160', 'UPHENO:0088166', 'UBERON:0000075', 'HP:0001903', 'UPHENO:0003236', 'UBERON:0007524', 'UPHENO:0077418', 'UBERON:0001015', 'HP:0011873', 'UPHENO:0004888', 'BFO:0000040', 'UPHENO:0085356', 'NCBITaxon:33208', 'UBERON:0000483', 'UBERON:0002050', 'UPHENO:7000538', 'UPHENO:0088175', 'UPHENO:0085302', 'HP:0011893', 'UPHENO:3000000', 'UPHENO:0002530', 'UPHENO:0086016', 'UPHENO:0069062', 'UPHENO:0078629', 'UPHENO:0011536', 'UBERON:0002346', 'UPHENO:0063787', 'UPHENO:0085330', 'UBERON:0016880', 'UPHENO:0088176', 'UPHENO:0049642', 'UPHENO:0006894', 'UPHENO:0011498', 'UBERON:0000062', 'UBERON:0004121', 'GO:0065007', 'UPHENO:0050065', 'UPHENO:0063722', 'HP:0032251', 'UBERON:0003056', 'HP:0007364', 'UBERON:0000481', 'UPHENO:0086019', 'UPHENO:0004521', 'UPHENO:0002526', 'UPHENO:7000299', 'UPHENO:0002731', 'UPHENO:0002736', 'UBERON:0000924', 'CL:0000151', 'UBERON:0004734', 'UBERON:0000307', 'CL:0000232', 'UPHENO:0005030', 'UPHENO:0076799', 'CL:0000225', 'UPHENO:0049587', 'UPHENO:0003001', 'UPHENO:0005285', 'UPHENO:0004704', 'UBERON:0015212', 'HP:0001875', 'UBERON:0003914', 'CL:0000775', 'UPHENO:0003186', 'UPHENO:0003159', 'UPHENO:0087531', 'UPHENO:7000599'], 'has_phenotype_closure_label': ['axial skeleton plus cranial skeleton', 'Abnormal skeletal morphology', 'subdivision of skeletal system', 'Abnormality of the musculoskeletal system', 'craniofacial/craniocervical phenotype', 'aplasia or hypoplasia of telencephalon', 'subdivision of organism along main body axis', 'decreased size of the head', 'Decreased head circumference', 'skull', 'postcranial axial skeletal system', 'cranial skeletal system', 'Abnormal axial skeleton morphology', 'subdivision of skeleton', 'Abnormal nervous system morphology', 'subdivision of organism along main body axis phenotype', 'anatomical collection phenotype', 'craniocervical region', 'body proper', 'main body axis', 'musculature of body phenotype', 'Abnormal skull morphology', 'Morphological central nervous system abnormality', 'bone marrow cell', 'skeletal system phenotype', 'Abnormality of multiple cell lineages in the bone marrow', 'number of bone marrow cell phenotype', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'decreased number of anatomical structure in the multicellular organism', 'bone marrow', 'decreased number of anatomical structure in the bone element', 'decreased number of anatomical entity in the multicellular organism', 'bone element', 'skeletal element', 'decreased number of anatomical entity in the bone marrow', 'bone element phenotype', 'negative regulation of biological process phenotype', 'regulation of biological process phenotype', 'Abnormal brain morphology', 'Chromosomal breakage induced by crosslinking agents', 'negative regulation of metabolic process phenotype', 'negative regulation of gene expression', 'negative regulation of macromolecule biosynthetic process', 'negative regulation of cellular process phenotype', 'regulation of metabolic process', 'macromolecule biosynthetic process', 'biosynthetic process phenotype', 'biological regulation phenotype', 'programmed DNA elimination', 'programmed DNA elimination by chromosome breakage phenotype', 'head phenotype', 'regulation of macromolecule metabolic process phenotype', 'skull phenotype', 'gene expression phenotype', 'Chromosome breakage', 'regulation of macromolecule biosynthetic process phenotype', 'regulation of macromolecule biosynthetic process', 'negative regulation of macromolecule metabolic process', 'cranial skeletal system phenotype', 'cellular process phenotype', 'Abnormal cellular phenotype', 'bone cell', 'negative regulation of macromolecule metabolic process phenotype', 'regulation of cellular process', 'negative regulation of biological process', 'macromolecule biosynthetic process phenotype', 'biosynthetic process', 'serotonin secreting cell', 'regional part of brain', 'musculoskeletal system', 'epithelial tube phenotype', 'embryonic tissue morphology phenotype', 'multi-tissue structure', 'aplasia or hypoplasia of anatomical entity', 'musculoskeletal system phenotype', 'organ system subdivision', 'Eukaryota', 'multi-tissue structure phenotype', 'neural plate morphology phenotype', 'ectoderm', 'anterior neural tube phenotype', 'gastrula', 'lateral structure phenotype', 'secretory cell', 'Abnormal bone marrow cell morphology', 'ectoderm-derived structure phenotype', 'musculature', 'pre-chordal neural plate', 'epithelial tube', 'organ part', 'nervous system phenotype', 'presumptive ectoderm phenotype', 'neural plate phenotype', 'regional part of nervous system', 'nervous system', 'root', 'gastrula morphology phenotype', 'central nervous system morphology phenotype', 'epithelium', 'Aplasia/Hypoplasia of the cerebrum', 'multicellular organism morphology phenotype', 'number of anatomical enitites of type neutrophil phenotype', 'Abnormal myeloid leukocyte morphology', 'decreased size of the multicellular organism', 'decreased size of the anatomical entity', 'Abnormality of the nervous system', 'multicellular anatomical structure', 'number of anatomical enitites of type anatomical entity phenotype', 'subdivision of skeleton phenotype', 'blood island', 'skeleton', 'presumptive structure phenotype', 'anatomical entity phenotype', 'presumptive structure', 'organic amino compound', 'Abnormal granulocyte morphology', 'neural tube', 'Abnormal circulating alpha-fetoprotein concentration', 'molecular entity', 'mesenchyme phenotype', 'blood organic amino compound level phenotype', 'Abnormality of skull size', 'presumptive ectoderm', 'dense mesenchyme tissue phenotype', 'axial skeleton plus cranial skeleton morphology phenotype', 'Abnormality of chromosome stability', 'germ layer morphology phenotype', 'Growth delay', 'amide', 'bodily fluid phenotype', 'blood alpha-fetoprotein level phenotype', 'drinking behavior', 'central nervous system phenotype', 'carboxamide', 'gene expression', 'organic molecular entity', 'ecto-epithelium phenotype', 'phenotype', 'nitrogen molecular entity', 'occurrent', 'blood', 'anemia', 'decreased size of the organism subdivision', 'germ layer phenotype', 'regulation of biosynthetic process phenotype', 'embryonic structure phenotype', 'p-block molecular entity', 'size of head phenotype', 'alpha-fetoprotein', 'skeletal system morphology phenotype', 'blood oxygen molecular entity level phenotype', 'tube', 'Abnormal immune system morphology', 'mesoderm', 'tissue chemical entity level phenotype', 'haemolymphatic fluid phenotype', 'organ', 'size of skull phenotype', 'anatomical collection', 'increased level of alpha-fetoprotein', 'decreased size of the subdivision of organism along main body axis', 'embryo morphology phenotype', 'blood nitrogen molecular entity level phenotype', 'feeding behavior', 'forebrain', 'taxon specific phenotype', 'decreased size of the anatomical structure', 'embryonic tissue phenotype', 'size of multicellular organism phenotype', 'amino acid chain', 'organooxygen compound', 'material entity', 'multicellular organismal process', 'behavior process phenotype', 'Abnormal cerebral morphology', 'neurectoderm', 'bone marrow cell phenotype', 'independent continuant', 'anterior region of body', 'protein', 'embryonic structure', 'telencephalon morphology phenotype', 'skeleton phenotype', 'process', 'forebrain morphology phenotype', 'peptide', 'multicellular anatomical structure phenotype', 'decreased size of the multicellular anatomical structure', 'blood chemical entity level phenotype', 'biogenic amine secreting cell', 'tissue', 'decreased number of platelet', 'blood island phenotype', 'Anemia', 'immune system morphology phenotype', 'anterior neural tube', 'biological_process', 'blood organic molecular entity level phenotype', 'developing anatomical structure phenotype', 'blood phenotype', 'organism subdivision phenotype', 'homeostatic process', 'organism subdivision', 'anatomical entity height phenotype', 'size of anatomical entity phenotype', 'anatomical entity', 'anatomical entity morphology phenotype', 'chemical entity level phenotype', 'decreased number of neutrophil', 'decreased number of granulocyte', 'chemical entity', 'brain', 'mesenchyme', 'non-connected functional system', 'germ layer / neural crest', 'Growth abnormality', 'multicellular organism phenotype', 'craniocervical region morphology phenotype', 'skeletal system', 'Abnormal circulating metabolite concentration', 'dense mesenchyme tissue', 'myeloid leukocyte phenotype', 'Abnormal forebrain morphology', 'number of anatomical enitites of type material anatomical entity phenotype', 'epithelium phenotype', 'macromolecule', 'cellular process', 'role blood level phenotype', 'regulation of gene expression', 'regional part of brain phenotype', 'consumption behavior', 'mesoderm-derived structure phenotype', 'disconnected anatomical group', 'decreased number of hematopoietic cell', 'future nervous system', 'cerebral amyloid angiopathy', 'Abnormal circulating protein concentration', 'main group molecular entity', 'material anatomical entity', 'negative regulation of metabolic process', 'Abnormal neutrophil morphology', 'behavior process', 'embryo', 'decreased height of the anatomical entity', 'erythrocyte', 'metabolic process', 'Elevated circulating alpha-fetoprotein concentration', 'organonitrogen compound', 'lateral plate mesoderm', 'haemolymphatic fluid', 'tissue phenotype', 'craniocervical region phenotype', 'oxygen accumulating cell', 'macromolecule metabolic process', 'cellular organisms', 'anatomical structure', 'behavior', 'heteroorganic entity', 'nitrogen molecular entity level phenotype', 'postcranial axial skeleton', 'metabolic process phenotype', 'anatomical conduit', 'subdivision of skeletal system phenotype', 'growth phenotype', 'organism substance', 'decreased number of material anatomical entity in the bone element', 'role bodily fluid level phenotype', 'Metazoa', 'anisocytosis', 'ectoderm phenotype', 'material anatomical entity phenotype', 'platelet phenotype', 'neural tube morphology phenotype', 'head morphology phenotype', 'ectoderm-derived structure', 'biological_process phenotype', 'lateral plate mesoderm phenotype', 'polypeptide', 'head', 'musculature of body', 'Bone marrow hypocellularity', 'organ system subdivision phenotype', 'neural tube phenotype', 'decreased number of material anatomical entity in the multicellular organism', 'biological regulation', 'primary amide', 'skull morphology phenotype', 'chalcogen molecular entity', 'consumption behavior phenotype', 'delayed growth', 'pre-chordal neural plate phenotype', 'Abnormality of the skeletal system', 'hematopoietic system phenotype', 'delayed biological_process', 'multicellular organism chemical entity level phenotype', 'All', 'mesoderm phenotype', 'embryonic tissue', 'developing anatomical structure', 'phenotypic effect', 'organochalcogen compound', 'anatomical structure phenotype', 'anatomical conduit phenotype', 'organism substance phenotype', 'neural plate', 'Abnormality of body height', 'Eumetazoa', 'immune system phenotype', 'Microcephaly', 'embryo phenotype', 'pnictogen molecular entity', 'Abnormal cellular physiology', 'cell', 'decreased size of the material anatomical entity', 'multicellular organism height phenotype', 'oxygen molecular entity', 'Abnormality of the immune system', 'decreased number of anatomical entity in the bone element', 'multicellular organismal process phenotype', 'Abnormality of thrombocytes', 'cell phenotype', 'erythrocyte morphology phenotype', 'leukocyte', 'Aplasia/Hypoplasia involving the central nervous system', 'hematopoietic system morphology phenotype', 'polyatomic entity', 'feeding behavior phenotype', 'hemolymphoid system', 'carbon group molecular entity', 'number of anatomical enitites of type anatomical structure phenotype', 'myeloid cell', 'drinking behavior phenotype', 'Phenotypic abnormality', 'hematopoietic system', 'Abnormal erythrocyte morphology', 'Abnormal leukocyte count', 'platelet', 'polydipsia', 'regulation of cellular process phenotype', 'eukaryotic cell', 'hematopoietic cell', 'bodily fluid', 'blood cell phenotype', 'behavior phenotype', 'Abnormality of blood and blood-forming tissues', 'lateral structure', 'erythroid lineage cell morphology phenotype', 'germ layer', 'erythroid lineage cell', 'alpha-fetoprotein level phenotype', 'anatomical system phenotype', 'neutrophil morphology phenotype', 'future central nervous system phenotype', 'blood cell', 'decreased number of material anatomical entity', 'skeletal element phenotype', 'regulation of biological process', 'decreased number of anatomical entity', 'number of leukocyte phenotype', 'Abnormality of neutrophils', 'continuant', 'Abnormal cellular immune system morphology', 'Abnormality of the head', 'protein polypeptide chain', 'Abnormality of metabolism/homeostasis', 'myeloid leukocyte morphology', 'granulocyte', 'decreased number of cell', 'Abnormality of head or neck', 'granulocyte morphology phenotype', 'regulation of macromolecule metabolic process', 'number of anatomical enitites of type granulocyte phenotype', 'neutrophil', 'decreased number of myeloid cell', 'musculature phenotype', 'negative regulation of cellular process', 'immune system', 'negative regulation of biosynthetic process', 'germ layer / neural crest phenotype', 'Decreased total neutrophil count', 'decreased number of bone marrow cell', 'negative regulation of gene expression phenotype', 'telencephalon phenotype', 'homeostatic process phenotype', 'Abnormal leukocyte morphology', 'Opisthokonta', 'motile cell', 'mesoderm-derived structure', 'Thrombocytopenia', 'Short stature', 'nucleate cell', 'neutrophil phenotype', 'decreased number of anatomical structure', 'growth', 'entity', 'decreased number of leukocyte', 'Abnormal total neutrophil count', 'number of hematopoietic cell phenotype', 'Abnormal granulocyte count', 'future central nervous system', 'leukocyte morphology phenotype', 'number of myeloid cell phenotype', 'myeloid leukocyte', 'number of platelet phenotype', 'bone marrow phenotype', 'regulation of gene expression phenotype', 'platelet morphology', 'programmed DNA elimination by chromosome breakage', 'anucleate cell', 'brain morphology phenotype', 'regional part of nervous system phenotype', 'tube phenotype', 'Abnormal platelet count', 'axial skeletal system', 'multicellular organism', 'nervous system morphology phenotype', 'regulation of biosynthetic process', 'regulation of metabolic process phenotype', 'blood protein polypeptide chain level phenotype', 'cerebral hemisphere', 'organ phenotype', 'central nervous system', 'ectoderm morphology phenotype', 'brain phenotype', 'neurectoderm phenotype', 'axial skeleton plus cranial skeleton phenotype', 'blastula', 'decreased height of the multicellular organism', 'Abnormal platelet morphology', 'cerebral hemisphere morphology phenotype', 'anatomical system', 'organ part phenotype', 'forebrain phenotype', 'macromolecule metabolic process phenotype', 'telencephalon', 'number of cell phenotype', 'ecto-epithelium'], 'has_descendant': ['MONDO:0014985'], 'has_descendant_label': ['Fanconi anemia complementation group V'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0014986', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group R', 'description': 'Any Fanconi anemia in which the cause of the disease is a mutation in the RAD51 gene.', 'xref': ['DOID:0111090', 'GARD:16214', 'MEDGEN:924579', 'OMIM:617244', 'UMLS:C4284093'], 'synonym': ['FANCR', 'Fanconi Anemia, complementation group R', 'Fanconi Anemia, complementation group type R', 'Fanconi anaemia caused by mutation in RAD51', 'Fanconi anaemia complementation group type R', 'Fanconi anemia caused by mutation in RAD51', 'Fanconi anemia complementation group type R', 'Fanconi anemia, complementation GROUP R', 'RAD51 Fanconi anaemia', 'RAD51 Fanconi anemia'], 'exact_synonym': ['FANCR', 'Fanconi Anemia, complementation group R', 'Fanconi Anemia, complementation group type R', 'Fanconi anaemia caused by mutation in RAD51', 'Fanconi anaemia complementation group type R', 'Fanconi anemia caused by mutation in RAD51', 'Fanconi anemia complementation group type R', 'RAD51 Fanconi anaemia', 'RAD51 Fanconi anemia'], 'related_synonym': ['Fanconi anemia, complementation GROUP R'], 'subsets': ['gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0005528', 'HP:0006433', 'HP:0002144', 'HP:0003221', 'HP:0006349', 'HP:0000568', 'HP:0001249', 'HP:0000252', 'HP:0001510', 'HP:0000238', 'HP:0031936', 'HP:0009777', 'HP:0007099', 'HP:0001903', 'HP:0000125', 'HP:0003764', 'HP:0002650', 'HP:0002023'], 'has_phenotype_label': ['Bone marrow hypocellularity', 'Agenesis of permanent teeth', 'Delayed ability to walk', 'Pelvic kidney', 'Scoliosis', 'Radial ray deficiency', 'Anemia', 'Growth delay', 'Microcephaly', 'Intellectual disability', 'Hydrocephalus', 'Absent thumb', 'Chromosomal breakage induced by crosslinking agents', 'Tethered cord', 'Anal atresia', 'Microphthalmia', 'Nevus', 'Chiari type I malformation'], 'has_phenotype_count': 18, 'has_phenotype_closure': ['UBERON:0004128', 'UPHENO:0075997', 'HP:0100887', 'UPHENO:0004721', 'UBERON:0000047', 'UPHENO:0004757', 'UPHENO:0004494', 'UBERON:0000490', 'UBERON:0001032', 'UPHENO:0005058', 'UPHENO:0003189', 'UPHENO:0069064', 'UPHENO:0002866', 'UPHENO:0080209', 'UBERON:0001048', 'HP:0000568', 'HP:0001172', 'UBERON:0002544', 'UBERON:5002389', 'UPHENO:0025587', 'UPHENO:0009020', 'UBERON:0006048', 'UBERON:0012141', 'UPHENO:0026108', 'UPHENO:0026640', 'UPHENO:0025509', 'UBERON:0001442', 'HP:0009777', 'UPHENO:0026078', 'HP:0005927', 'UPHENO:0003069', 'HP:0001155', 'UBERON:0012354', 'UBERON:0005451', 'UBERON:0001463', 'UBERON:0002389', 'UBERON:5001463', 'UPHENO:0011825', 'UPHENO:0009146', 'HP:0009601', 'HP:0005922', 'UBERON:0006717', 'UPHENO:0026643', 'UPHENO:0027017', 'UPHENO:0009163', 'HP:0001167', 'UPHENO:0026757', 'UPHENO:0080099', 'UPHENO:0087006', 'UPHENO:0008548', 'UBERON:0005881', 'UBERON:5002544', 'UPHENO:0080114', 'UPHENO:0002905', 'UPHENO:0026146', 'UPHENO:0026181', 'UPHENO:0026506', 'UPHENO:0086769', 'UPHENO:0002733', 'UPHENO:0084448', 'HP:0009115', 'UBERON:0019231', 'UPHENO:0008523', 'UBERON:0036302', 'UBERON:0005629', 'UBERON:0004535', 'UPHENO:0003571', 'UPHENO:0009382', 'UPHENO:0002678', 'UPHENO:0056150', 'UPHENO:0056237', 'UPHENO:0056230', 'UPHENO:0002704', 'UPHENO:0014291', 'UPHENO:0014761', 'UBERON:0003947', 'UBERON:0000179', 'HP:0008056', 'UPHENO:0056158', 'UPHENO:0056250', 'UPHENO:0088047', 'UPHENO:9002003', 'UBERON:0004923', 'UPHENO:0005029', 'HP:0000238', 'UPHENO:0014351', 'UPHENO:0086486', 'UPHENO:0088185', 'UPHENO:0056242', 'UBERON:0000178', 'UPHENO:0085938', 'UBERON:0001009', 'UBERON:0007798', 'HP:0012372', 'HP:0002921', 'UPHENO:0004788', 'UBERON:0001893', 'HP:0000240', 'UPHENO:0081598', 'HP:0002977', 'UPHENO:0004956', 'UPHENO:0014285', 'UPHENO:0087518', 'UBERON:0003080', 'UPHENO:0081566', 'UPHENO:0069327', 'UPHENO:0069266', 'HP:0000252', 'UBERON:0012139', 'UBERON:0003056', 'UPHENO:0069062', 'UPHENO:0069236', 'UPHENO:0076799', 'HP:0002060', 'UPHENO:0075148', 'UBERON:0002104', 'UPHENO:0003236', 'UPHENO:0075804', 'HP:0040195', 'HP:0002023', 'UPHENO:0074229', 'HP:0034915', 'UPHENO:0002812', 'UPHENO:0074227', 'UPHENO:0074228', 'UBERON:0000161', 'UPHENO:0085410', 'UPHENO:0063577', 'UPHENO:0086644', 'HP:0004378', 'UPHENO:0063562', 'UBERON:0001245', 'UPHENO:0063594', 'UPHENO:0074230', 'HP:0025031', 'GO:0042756', 'CL:0000232', 'CL:0000764', 'UPHENO:0002987', 'UPHENO:0088162', 'UPHENO:0049664', 'UPHENO:0080010', 'UPHENO:0079835', 'UBERON:0006876', 'GO:0007631', 'HP:0001903', 'UPHENO:0075195', 'HP:0100547', 'CL:0000988', 'UPHENO:0003391', 'UPHENO:0087339', 'UPHENO:0049622', 'UBERON:0001049', 'UBERON:0000955', 'UPHENO:0075948', 'UPHENO:0071339', 'UPHENO:0081601', 'UPHENO:0002736', 'UPHENO:0071310', 'UBERON:0004732', 'NCBITaxon:2759', 'UPHENO:0086932', 'UPHENO:0004519', 'UPHENO:0071317', 'UPHENO:0004507', 'UPHENO:0004484', 'CL:0000763', 'UPHENO:0086485', 'UPHENO:0076805', 'UBERON:0003057', 'HP:0007099', 'UPHENO:0002839', 'UPHENO:0003004', 'UPHENO:0003237', 'UBERON:0000481', 'UPHENO:0003186', 'UBERON:0004733', 'UPHENO:0005285', 'UPHENO:0071325', 'UPHENO:0084761', 'UPHENO:0002765', 'UBERON:0002028', 'UBERON:0004734', 'NCBITaxon:33208', 'UPHENO:0071315', 'UPHENO:0071344', 'GO:0007610', 'HP:0002438', 'UPHENO:0002548', 'UPHENO:0076791', 'UPHENO:0076702', 'UPHENO:0005055', 'UBERON:0016879', 'UBERON:0005174', 'UBERON:0001137', 'UPHENO:0087858', 'UBERON:0003914', 'HP:0012639', 'UPHENO:0004888', 'UBERON:0003129', 'UBERON:0000924', 'UPHENO:0026010', 'UPHENO:0004521', 'HP:0012758', 'UPHENO:7000241', 'UPHENO:0004418', 'UPHENO:0063599', 'UBERON:0001567', 'UPHENO:0002576', 'UPHENO:0004173', 'CL:0000081', 'UPHENO:0049870', 'HP:0002817', 'UPHENO:0050435', 'HP:0025354', 'HP:0001877', 'HP:0002308', 'GO:0010629', 'UPHENO:0076720', 'GO:0010468', 'UPHENO:0049652', 'HP:0000924', 'UPHENO:0003812', 'UPHENO:0050007', 'HP:0003220', 'CL:0000329', 'UPHENO:0082875', 'UPHENO:0076740', 'UBERON:0007285', 'UPHENO:0003182', 'UPHENO:0049868', 'UBERON:0011584', 'GO:0043170', 'UPHENO:0081526', 'HP:0000077', 'UBERON:0000033', 'UPHENO:0011538', 'UPHENO:0049873', 'UBERON:0000464', 'HP:0003221', 'UBERON:0010707', 'UPHENO:7000299', 'UBERON:0010712', 'GO:0050890', 'UPHENO:0076800', 'GO:0003008', 'UPHENO:0002593', 'UPHENO:0003001', 'UPHENO:0004523', 'UPHENO:0002385', 'UBERON:0001130', 'HP:0031816', 'UPHENO:0087363', 'UPHENO:0049775', 'UPHENO:0075220', 'BFO:0000015', 'UBERON:0007779', 'HP:0012759', 'UPHENO:0050065', 'UPHENO:0074237', 'HP:0006433', 'UPHENO:0063722', 'UPHENO:0086700', 'HP:0012638', 'UBERON:0005282', 'GO:0009889', 'HP:0002818', 'UBERON:0001016', 'UPHENO:0001001', 'HP:0011446', 'GO:0065007', 'UBERON:0008785', 'UPHENO:0002433', 'HP:0000951', 'UPHENO:0003811', 'UBERON:0002199', 'UPHENO:0002525', 'UPHENO:0003234', 'UPHENO:0086505', 'UPHENO:0087665', 'HP:0011121', 'UBERON:0000468', 'HP:0001574', 'UBERON:0000479', 'UPHENO:0004885', 'CL:0002092', 'UPHENO:0002554', 'UPHENO:0011498', 'UPHENO:0086482', 'UPHENO:0004431', 'UBERON:0003104', 'UBERON:0002371', 'UBERON:0002470', 'GO:0042592', 'UPHENO:0001003', 'UPHENO:0063787', 'UPHENO:0008668', 'UPHENO:0080126', 'HP:0010674', 'UPHENO:0011845', 'CL:0001035', 'UPHENO:0002747', 'GO:0008150', 'UBERON:0006601', 'HP:0040068', 'UPHENO:0086172', 'UPHENO:0002830', 'UPHENO:0063565', 'UPHENO:0053612', 'UPHENO:0003163', 'UPHENO:0005097', 'UBERON:0007503', 'UPHENO:0077418', 'UBERON:0007524', 'HP:0011355', 'UBERON:0000026', 'UPHENO:0003432', 'UPHENO:0002541', 'UBERON:0003072', 'UBERON:0001890', 'HP:0011044', 'UBERON:0003061', 'UPHENO:0063794', 'UPHENO:0004900', 'UPHENO:0002567', 'UPHENO:0053561', 'HP:0007364', 'UBERON:0004381', 'UPHENO:0035151', 'UBERON:0005944', 'UBERON:0002405', 'UBERON:0015203', 'HP:0011844', 'UBERON:0004765', 'HP:0001871', 'UBERON:0007530', 'UBERON:0004086', 'UPHENO:0002668', 'UPHENO:0002902', 'UPHENO:0002559', 'UPHENO:0002870', 'UBERON:0000062', 'UPHENO:0002754', 'UPHENO:0080009', 'UBERON:0001008', 'UPHENO:0078606', 'UPHENO:0003936', 'UBERON:0003103', 'HP:0006496', 'UPHENO:0002577', 'UPHENO:0002648', 'UBERON:0002386', 'UBERON:0004375', 'UBERON:0000477', 'HP:0002011', 'UBERON:0000465', 'UPHENO:0002983', 'UPHENO:0025585', 'UBERON:0003081', 'UBERON:0034923', 'UPHENO:0004459', 'UPHENO:0011589', 'UBERON:0001460', 'UBERON:0001456', 'NBO:0000313', 'UBERON:0010316', 'UPHENO:0011531', 'UPHENO:0076675', 'UPHENO:0088326', 'UPHENO:0063849', 'UBERON:0002616', 'UPHENO:0047287', 'UPHENO:0053580', 'HP:0010935', 'UPHENO:0081451', 'UPHENO:0003092', 'UPHENO:0087501', 'UPHENO:3000000', 'UBERON:0000061', 'UBERON:0000467', 'UPHENO:0005092', 'UBERON:0034925', 'UPHENO:0005141', 'UBERON:0015212', 'UPHENO:0002782', 'UPHENO:0002803', 'UPHENO:0049620', 'UBERON:0002204', 'UPHENO:0076695', 'UBERON:0006314', 'UBERON:0000923', 'UPHENO:0075998', 'UPHENO:0087924', 'GO:0019222', 'UPHENO:0002963', 'UPHENO:0002976', 'UBERON:0000475', 'UPHENO:0063731', 'HP:0040012', 'GO:0032501', 'UPHENO:0049837', 'UPHENO:0047387', 'UPHENO:0053566', 'UBERON:0004357', 'UPHENO:0004476', 'UBERON:0002091', 'UPHENO:0003093', 'GO:0040007', 'UPHENO:0081435', 'UPHENO:0001002', 'UPHENO:0002928', 'UBERON:0005423', 'UPHENO:0088123', 'HP:0002143', 'UBERON:0001062', 'UPHENO:0005230', 'UPHENO:7000079', 'UPHENO:0077371', 'UBERON:0006598', 'HP:0012210', 'UPHENO:0053588', 'GO:0009987', 'HP:0005561', 'UBERON:0005291', 'UPHENO:0081466', 'UPHENO:0009209', 'GO:0050794', 'UBERON:0000064', 'UPHENO:0087349', 'HP:0009804', 'HP:0000125', 'UBERON:0005173', 'UPHENO:0085409', 'UPHENO:0004064', 'UBERON:0001359', 'UPHENO:0004802', 'UBERON:0010758', 'UPHENO:0047344', 'UPHENO:0087472', 'HP:0006265', 'UPHENO:0003181', 'HP:0003764', 'UPHENO:0050040', 'UPHENO:0053601', 'UPHENO:7000632', 'UBERON:0007272', 'GO:0010556', 'HP:0001249', 'UPHENO:0002600', 'UPHENO:0047444', 'UPHENO:0002564', 'UPHENO:0087116', 'UPHENO:0002764', 'UPHENO:0049904', 'UBERON:0004456', 'UPHENO:0002526', 'UPHENO:0002964', 'UPHENO:0053633', 'UBERON:0002390', 'UPHENO:0002948', 'UPHENO:0063581', 'HP:0012443', 'UPHENO:0084763', 'UPHENO:0053619', 'UPHENO:0002731', 'UBERON:0019221', 'UPHENO:0087661', 'UPHENO:0034969', 'UBERON:0016880', 'UPHENO:0053632', 'UPHENO:0076786', 'HP:0001939', 'HP:0000707', 'UBERON:0001004', 'UBERON:0003466', 'UBERON:0009569', 'UBERON:0002416', 'UBERON:0010312', 'UPHENO:0002844', 'UPHENO:0085306', 'UBERON:0010323', 'BFO:0000040', 'UPHENO:0087427', 'UBERON:8450002', 'UPHENO:0002448', 'UPHENO:0047285', 'UBERON:0002417', 'UBERON:0005281', 'UPHENO:0004680', 'UBERON:0010314', 'UBERON:0013702', 'GO:0050877', 'UPHENO:0002547', 'UBERON:0004122', 'UPHENO:7000161', 'UPHENO:0000543', 'UPHENO:3000007', 'UPHENO:0003088', 'UPHENO:0087663', 'UPHENO:0053643', 'HP:0011297', 'UBERON:0002513', 'UPHENO:0078629', 'UPHENO:3000004', 'UBERON:0005177', 'CL:0000000', 'UPHENO:0047356', 'UBERON:0011249', 'UBERON:0005172', 'BFO:0000001', 'HP:0009380', 'UPHENO:0088170', 'UPHENO:0050121', 'UPHENO:0076739', 'UPHENO:0076692', 'UBERON:0000019', 'BFO:0000004', 'UBERON:0000916', 'UPHENO:0002962', 'UPHENO:0002832', 'UPHENO:0081581', 'UBERON:0010230', 'UPHENO:0002926', 'UPHENO:0004892', 'HP:0000086', 'UBERON:0002097', 'UPHENO:0086589', 'UPHENO:0026183', 'GO:0031052', 'UBERON:0002193', 'GO:0031049', 'UBERON:0002113', 'UPHENO:0069149', 'UBERON:0011143', 'UBERON:0000060', 'UPHENO:0076718', 'UPHENO:0079826', 'UBERON:0003075', 'UBERON:0004121', 'UBERON:0034929', 'UPHENO:0002269', 'UPHENO:0076803', 'UBERON:0000153', 'UPHENO:0011586', 'UPHENO:7000640', 'NBO:0001845', 'UPHENO:7000311', 'HP:0012145', 'UBERON:0003076', 'UPHENO:0005214', 'UPHENO:0004621', 'UPHENO:0002536', 'UPHENO:0087907', 'UPHENO:0003460', 'UPHENO:0002910', 'UBERON:0001555', 'GO:0048519', 'UPHENO:0076724', 'UPHENO:0087585', 'UPHENO:0014865', 'UBERON:0001444', 'HP:0001510', 'UBERON:0000922', 'UPHENO:0069161', 'HP:0000118', 'HP:0005528', 'UPHENO:0005284', 'UPHENO:0002861', 'UPHENO:0011536', 'UBERON:0005358', 'UBERON:0013522', 'UBERON:0004120', 'UBERON:0000383', 'HP:0000001', 'UBERON:0003913', 'UPHENO:0063558', 'UPHENO:0086956', 'UBERON:0003460', 'UPHENO:0049757', 'UPHENO:0002932', 'UBERON:0001474', 'UPHENO:0056251', 'GO:0009059', 'UBERON:0010371', 'UPHENO:0004704', 'UBERON:0002100', 'UPHENO:0003082', 'UBERON:0010000', 'UPHENO:0004482', 'UPHENO:0050778', 'UPHENO:0076779', 'UBERON:0012140', 'GO:0009892', 'HP:0011017', 'UBERON:0002471', 'BFO:0000003', 'UPHENO:0047355', 'UPHENO:0002530', 'UPHENO:0003334', 'UBERON:0004089', 'UPHENO:0086679', 'UPHENO:0002531', 'UBERON:0000466', 'UBERON:8480069', 'UBERON:0000489', 'UBERON:0010538', 'NCBITaxon:33154', 'UPHENO:0002553', 'UPHENO:0018390', 'GO:0060255', 'UBERON:0000463', 'UPHENO:0002746', 'UPHENO:0003025', 'UBERON:0000165', 'UPHENO:0035147', 'BFO:0000141', 'UPHENO:0002859', 'UPHENO:0002642', 'UPHENO:0050063', 'UPHENO:0002651', 'UPHENO:0004615', 'HP:0000079', 'UBERON:0002050', 'UBERON:0000483', 'UPHENO:0002267', 'UBERON:0004088', 'UBERON:0007811', 'UPHENO:0035034', 'UBERON:0010130', 'UPHENO:0050126', 'UPHENO:0049642', 'GO:0008152', 'UPHENO:0011533', 'UPHENO:0002949', 'GO:0050789', 'UBERON:0002346', 'UBERON:0003089', 'UPHENO:0004047', 'UPHENO:0025507', 'GO:0048523', 'UBERON:0002329', 'UBERON:0000075', 'UBERON:0000307', 'UPHENO:0076703', 'UPHENO:0069523', 'NCBITaxon:6072', 'UBERON:0002553', 'HP:0000925', 'HP:0000164', 'HP:0031938', 'UPHENO:0002650', 'UBERON:0000926', 'UPHENO:0002635', 'UPHENO:0004143', 'HP:0002118', 'UPHENO:0053610', 'HP:0011842', 'UPHENO:0003177', 'UPHENO:0053563', 'UBERON:0011137', 'UPHENO:0003459', 'UBERON:0011138', 'UBERON:0000073', 'UPHENO:0002594', 'HP:0033127', 'UPHENO:0004969', 'UBERON:0004288', 'UBERON:0003077', 'UBERON:0002049', 'NCBITaxon:131567', 'UPHENO:0003191', 'UPHENO:0074245', 'UPHENO:0002944', 'UPHENO:0002909', 'UPHENO:0087089', 'UPHENO:0015184', 'UBERON:0001895', 'UPHENO:0002813', 'UBERON:0003059', 'UBERON:0005856', 'UPHENO:0005110', 'UBERON:0009142', 'HP:0009815', 'UBERON:0001015', 'UPHENO:0003020', 'UPHENO:0071335', 'UBERON:0010912', 'HP:0006483', 'UPHENO:0047461', 'UBERON:0005256', 'UPHENO:0079876', 'CL:0000255', 'UPHENO:0002527', 'UBERON:5006048', 'HP:0040072', 'UBERON:0013701', 'UPHENO:7000389', 'UBERON:0008962', 'UPHENO:0002543', 'UBERON:0005417', 'UBERON:0011585', 'UPHENO:0002816', 'HP:0001270', 'UPHENO:0003799', 'UPHENO:0086480', 'UPHENO:0003207', 'UPHENO:0003159', 'UBERON:0015021', 'UPHENO:0004536', 'UBERON:0002090', 'HP:0009121', 'UPHENO:0049587', 'HP:0000163', 'UPHENO:0075877', 'UPHENO:0011564', 'UPHENO:0047297', 'GO:0010467', 'UPHENO:0002826', 'UPHENO:0004545', 'HP:0100542', 'UPHENO:0002750', 'UPHENO:0004505', 'HP:0000234', 'GO:0010605', 'UBERON:0015061', 'UPHENO:0002828', 'HP:0011283', 'UPHENO:0002568', 'UBERON:0003672', 'UPHENO:0011568', 'UPHENO:0002833', 'GO:0009058', 'UBERON:0003102', 'UPHENO:0004520', 'UBERON:0007774', 'HP:0000152', 'UPHENO:0002896', 'UPHENO:0014292', 'UPHENO:0002988', 'UPHENO:0035148', 'UPHENO:0080079', 'UPHENO:0087347', 'UPHENO:0014240', 'UPHENO:0003952', 'UPHENO:0063789', 'HP:0002650', 'UBERON:0010703', 'HP:0000271', 'UPHENO:0004480', 'UPHENO:0002945', 'UPHENO:0050106', 'UPHENO:0080325', 'UPHENO:0014971', 'UPHENO:0049874', 'UBERON:0002037', 'UPHENO:0035160', 'UPHENO:0002542', 'UBERON:0004111', 'HP:0031936', 'UPHENO:0002994', 'UBERON:0000025', 'UBERON:0001007', 'UBERON:0000970', 'UPHENO:0063744', 'UBERON:0001017', 'UPHENO:0003514', 'UPHENO:0002957', 'UPHENO:0063844', 'UPHENO:0087849', 'UBERON:0000167', 'UPHENO:0002891', 'UPHENO:0049835', 'UBERON:0001091', 'HP:0001317', 'UPHENO:0047324', 'UPHENO:0011572', 'UBERON:0003071', 'UPHENO:0002558', 'UPHENO:0047376', 'UBERON:0002398', 'UBERON:0004708', 'UPHENO:0011503', 'HP:0000153', 'UPHENO:0011588', 'UBERON:0002240', 'UBERON:0004921', 'UBERON:0000020', 'UPHENO:0002532', 'UPHENO:0000541', 'UPHENO:0002708', 'HP:0001507', 'HP:0011282', 'UPHENO:7000376', 'UPHENO:0002967', 'UPHENO:0069352', 'UPHENO:0047317', 'UPHENO:0075219', 'UBERON:0002102', 'UPHENO:0047299', 'UPHENO:0047425', 'UPHENO:0047323', 'UPHENO:0003065', 'UPHENO:0002880', 'HP:0000119', 'UBERON:0002101', 'UPHENO:0049743', 'UBERON:0010708', 'UPHENO:0004503', 'BFO:0000002', 'UBERON:0005419', 'UPHENO:0063865', 'UBERON:0001423', 'UPHENO:0047419', 'HP:0040064', 'UPHENO:0086546', 'UPHENO:0002738', 'HP:0002194', 'UBERON:0001434', 'UBERON:0011676', 'UPHENO:0004466', 'NCBITaxon:1', 'UPHENO:0047289', 'HP:0000929', 'UPHENO:0063596', 'UPHENO:0047408', 'UPHENO:0003095', 'UPHENO:0087510', 'UPHENO:0002637', 'HP:0006349', 'UPHENO:0047302', 'UBERON:0011582', 'UPHENO:0076957', 'UPHENO:0003049', 'UPHENO:0003227', 'HP:0002144', 'UBERON:0002529', 'UPHENO:0047345', 'UPHENO:0075944', 'UPHENO:0005030', 'UPHENO:0004909', 'UPHENO:7000146', 'UPHENO:0002632', 'HP:0025033', 'UBERON:0000063', 'UPHENO:0003413', 'UPHENO:0002969', 'UPHENO:0068971', 'UBERON:0010740', 'UPHENO:0047409', 'HP:0000478', 'UPHENO:0086635', 'UBERON:0006058', 'HP:0002813', 'UBERON:0010363', 'UPHENO:0076723', 'HP:0002973', 'UBERON:0003607', 'GO:0010558', 'UBERON:0015001', 'UPHENO:0076754', 'HP:0040070', 'UBERON:0001440', 'UPHENO:0002767', 'UPHENO:0047411', 'UPHENO:0003094', 'UPHENO:0003415', 'UPHENO:0003050', 'UPHENO:0086633', 'UPHENO:0004433', 'HP:0045060', 'UPHENO:0002659', 'UPHENO:0004595', 'UPHENO:0079872', 'UPHENO:0056333', 'UPHENO:0035045', 'UBERON:0002495', 'UPHENO:0087660', 'UPHENO:0075902', 'UPHENO:0076727', 'UPHENO:0002751', 'UPHENO:0003366', 'UPHENO:0076697', 'UBERON:0010741', 'UBERON:0002428', 'UBERON:0003606', 'UBERON:0004347', 'GO:0009890', 'UBERON:0011216', 'UPHENO:0002719', 'UPHENO:0056149', 'UPHENO:0080200', 'UPHENO:0002586', 'UPHENO:0003410', 'UBERON:0004710', 'UBERON:0012475', 'UPHENO:0002785', 'UPHENO:0011509', 'UPHENO:0047388', 'UPHENO:0004475', 'UPHENO:0002571', 'RO:0002577', 'UPHENO:0003005'], 'has_phenotype_closure_label': ['decreased size of the eyeball of camera-type eye', 'optic vesicle phenotype', 'eyeball of camera-type eye phenotype', 'Abnormal eye morphology', 'Microphthalmia', 'eye primordium phenotype', 'camera-type eye', 'eye primordium', 'size of eyeball of camera-type eye phenotype', 'entire sense organ system', 'immature eye', 'vision/eye phenotype', 'aplasia or hypoplasia of eyeball of camera-type eye', 'optic vesicle', 'eye', 'optic cup', 'camera-type eye morphology phenotype', 'dysesthesia; hyperalgesia', 'immature eye phenotype', 'sense organ phenotype', 'embryonic autopod plate', 'Abnormality of the hand', 'digit', 'digit 1 plus metapodial segment', 'Aplasia/Hypoplasia of fingers', 'absent anatomical structure', 'Finger aplasia', 'manual digitopodium region', 'absent multicellular anatomical structure', 'Abnormal digit morphology', 'manual digit morphology in the manus phenotype', 'absent anatomical structure in the forelimb', 'absent multicellular anatomical structure in the limb', 'aplasia or hypoplasia of skeleton', 'absent anatomical entity in the multicellular organism', 'absent multicellular anatomical structure in the multicellular organism', 'manual digit 1 morphology phenotype', 'Absent thumb', 'embryonic autopod plate morphology phenotype', 'digit morphology phenotype', 'unilaminar epithelium', 'digit 1 or 5 phenotype', 'Abnormal hand morphology', 'segment of autopod', 'digit 1 phenotype', 'absent material anatomical entity in the limb bud', 'absent anatomical entity in the limb bud', 'absent multicellular anatomical structure in the forelimb', 'digit plus metapodial segment', 'absent anatomical entity', 'autopod region phenotype', 'autopodial extension phenotype', 'anatomical entity morphology in the manus phenotype', 'Aplasia/hypoplasia involving the skeleton', 'absent digit', 'absent material anatomical entity in the multicellular organism', 'digit 1 or 5', 'aplastic manual digit 1', 'absent anatomical structure in the multicellular organism', 'Aplasia/hypoplasia involving bones of the extremities', 'absent organism subdivision in the multicellular organism', 'absent material anatomical entity in the forelimb', 'ventricle of nervous system', 'cerebrospinal fluid morphology phenotype', 'increased number of anatomical structure', 'anatomical wall phenotype', 'increased number of ventricle of nervous system', 'increased number of anatomical entity in the blood', 'Abnormal cerebrospinal fluid morphology', 'eye phenotype', 'cardiovascular system', 'increased number of ventricle of nervous system in the cerebrospinal fluid', 'cerebrospinal fluid phenotype', 'increased number of anatomical structure in the cerebrospinal fluid', 'bodily fluid', 'brain ventricle/choroid plexus morphology phenotype', 'organ component layer', 'autopod region', 'circulatory system', 'vascular system', 'number of anatomical enitites of type organ part phenotype', 'vasculature phenotype', 'vasculature', 'transudate', 'organism substance', 'organ component layer phenotype', 'vascular plexus phenotype', 'increased number of brain ventricle/choroid plexus', 'increased number of multicellular anatomical structure in the cerebrospinal fluid', 'increased number of organ part', 'brain ventricle/choroid plexus phenotype', 'number of anatomical entities of type anatomical entity in blood phenotype', 'Abnormal cerebral ventricle morphology', 'increased number of anatomical entity', 'increased number of organ part in the cerebrospinal fluid', 'brain ventricle phenotype', 'vasculature of central nervous system plus retina', 'vascular plexus', 'absent anatomical entity in the limb', 'skeleton of manus', 'manual digit', 'decreased size of the anatomical structure', 'size of head phenotype', 'skull phenotype', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'anterior neural tube', 'decreased size of the head', 'Aplasia/hypoplasia involving bones of the hand', 'decreased size of the material anatomical entity', 'Abnormal cerebral morphology', 'pre-chordal neural plate', 'Microcephaly', 'increased number of material anatomical entity in the cerebrospinal fluid', 'Aplasia/Hypoplasia of the cerebrum', 'decreased size of the anatomical entity', 'brain ventricle morphology phenotype', 'decreased size of the organism subdivision', 'pre-chordal neural plate phenotype', 'telencephalon phenotype', 'forebrain morphology phenotype', 'Abnormal skull morphology', 'Abnormal forebrain morphology', 'Aplasia/Hypoplasia involving the central nervous system', 'ectoderm-derived structure atresia', 'closing of the anatomical conduit', 'Anal atresia', 'anus atresia', 'closing of the multicellular anatomical structure', 'camera-type eye phenotype', 'material anatomical entity atresia', 'Abnormal digestive system morphology', 'unilaminar epithelium phenotype', 'anus', 'anus morphology phenotype', 'Abnormality of the anus', 'orifice', 'closing of the ectoderm-derived structure', 'orifice atresia', 'closing of the anatomical structure', 'telencephalon', 'Anemia', 'absent organism subdivision', 'erythroid lineage cell morphology phenotype', 'behavior phenotype', 'oxygen accumulating cell', 'anemia', 'Abnormal erythrocyte morphology', 'drinking behavior phenotype', 'myeloid cell', 'blood cell phenotype', 'feeding behavior phenotype', 'eye morphology', 'hematopoietic system morphology phenotype', 'regional part of brain', 'epithelial tube phenotype', 'formed regional part of nervous system', 'multi-tissue structure', 'Eukaryota', 'formed cerebellum', 'vasculature of organ phenotype', 'neural plate morphology phenotype', 'Abnormal metencephalon morphology', 'multi-tissue structure phenotype', 'increased number of brain ventricle in the cerebrospinal fluid', 'segmental subdivision of nervous system phenotype', 'chordal neural plate', 'multicellular organismal process phenotype', 'gastrula', 'Abnormal cerebellum morphology', 'epithelial tube', 'Eumetazoa', 'hindbrain phenotype', 'regional part of nervous system', 'root', 'sensory system phenotype', 'formed multi-tissue structure', 'absent manual digit', 'Metazoa', 'haemolymphatic fluid phenotype', 'gastrula morphology phenotype', 'acropodium region', 'neural tube', 'neural plate', 'brain', 'ecto-epithelium', 'drinking behavior', 'metencephalon', 'anatomical entity morphology in the brain phenotype', 'organ subunit', 'hindbrain morphology phenotype', 'neurectoderm phenotype', 'formed multicellular anatomical structure', 'metencephalon morphology phenotype', 'Chiari type I malformation', 'Abnormal hindbrain morphology', 'segmental subdivision of hindbrain', 'visual system', 'brain morphology phenotype', 'segmental subdivision of hindbrain phenotype', 'cellular organisms', 'posterior neural tube phenotype', 'neural tube phenotype', 'aplasia or hypoplasia of manual digit', 'polydipsia', 'Chiari malformation', 'future central nervous system', 'presumptive ectoderm', 'ventricle of nervous system phenotype', 'future nervous system', 'ectoderm', 'spinal cord', 'presumptive ectoderm phenotype', 'central nervous system morphology phenotype', 'spinal cord morphology phenotype', 'Abnormal nervous system morphology', 'dorsal region element', 'Tethered cord', 'nervous system morphology phenotype', 'Abnormal spinal cord morphology', 'central nervous system', 'Abnormal conus terminalis morphology', 'Delayed gross motor development', 'vacuole', 'motor delay; motor developmental delay', 'Neurodevelopmental delay', 'negative regulation of metabolic process phenotype', 'future central nervous system phenotype', 'negative regulation of gene expression', 'negative regulation of macromolecule biosynthetic process', 'immune system', 'forelimb bud morphology phenotype', 'biosynthetic process phenotype', 'Morphological central nervous system abnormality', 'cognition', 'pectoral appendage', 'orbital region', 'skull morphology phenotype', 'hematopoietic cell', 'programmed DNA elimination', 'biological regulation phenotype', 'regulation of macromolecule metabolic process', 'Abnormality of metabolism/homeostasis', 'negative regulation of cellular process', 'Abnormality of the head', 'gene expression phenotype', 'anatomical entity atresia', 'Chromosome breakage', 'forelimb endochondral element', 'brain ventricle', 'limb skeleton subdivision phenotype', 'Abnormality of chromosome stability', 'sensory system', 'axial skeleton plus cranial skeleton morphology phenotype', 'regulation of macromolecule biosynthetic process', 'Abnormal cellular phenotype', 'localised cavitated compound organ', 'negative regulation of macromolecule metabolic process phenotype', 'manual digit 1', 'blood phenotype', 'bone cell', 'digestive system', 'autopod region morphology phenotype', 'regulation of cellular process phenotype', 'eukaryotic cell', 'upper limb segment phenotype', 'biosynthetic process', 'autopodial skeleton', 'macromolecule biosynthetic process phenotype', 'macromolecule metabolic process', 'biological regulation', 'pectoral complex', 'trunk mesenchyme', 'regulation of biosynthetic process', 'regulation of metabolic process phenotype', 'homeostatic process', 'organism subdivision phenotype', 'autopodial extension', 'increased number of brain ventricle', 'ecto-epithelium phenotype', 'face morphology phenotype', 'long bone phenotype', 'cardiovascular system phenotype', 'telencephalon morphology phenotype', 'anatomical system physiology phenotype', 'Abnormality of the nervous system', 'midface', 'nervous system phenotype', 'material anatomical entity physiology phenotype', 'presumptive paraxial mesoderm phenotype', 'regional part of brain phenotype', 'regulation of gene expression', 'Abnormal nervous system physiology', 'nervous system process', 'dentition', 'skin of body', 'Abnormality of the eye', 'Abnormality of the kidney', 'Nevus', 'trunk phenotype', 'integument phenotype', 'localised trunk region element', 'decreased number of calcareous tooth', 'skeleton of limb', 'dense mesenchyme tissue', 'skin of body morphology phenotype', 'decreased number of multicellular anatomical structure', 'decreased size of the sense organ', 'negative regulation of biosynthetic process', 'regulation of cellular process', 'decreased number of anatomical structure', 'closing of the material anatomical entity', 'postcranial axial skeleton', 'anatomical conduit', 'manus phenotype', 'Abnormality of the dentition', 'cerebellum', 'dysgenesis of the endochondral element', 'Aplasia/Hypoplasia of the thumb', 'posterior neural tube', 'Abnormality of blood and blood-forming tissues', 'anatomical structure physiology phenotype', 'blood island phenotype', 'decreased number of anatomical entity', 'paired limb/fin segment', 'aplasia or hypoplasia of manual digit 1', 'regulation of metabolic process', 'number of bone marrow cell phenotype', 'germ layer / neural crest phenotype', 'bone marrow cell phenotype', 'independent continuant', 'Abnormality of globe size', 'decreased number of anatomical entity in the bone element', 'craniocervical region morphology phenotype', 'integumental system phenotype', 'hematopoietic system', 'Phenotypic abnormality', 'musculoskeletal system', 'hematopoietic system phenotype', 'optic cup morphology phenotype', 'regulation of biological process', 'Abnormality of the skeletal system', 'Abnormal bone marrow cell morphology', 'dysgenesis of the endochondral bone', 'embryonic tissue', 'skeletal system', 'mouth phenotype', 'limb phenotype', 'germ layer phenotype', 'blood', 'Delayed ability to walk', 'embryonic structure phenotype', 'skeletal element', 'mesoderm-derived structure phenotype', 'vasculature of organ', 'negative regulation of gene expression phenotype', 'trunk region element phenotype', 'bone of appendage girdle complex', 'decreased number of cell', 'blood island', 'subdivision of skeleton phenotype', 'skeletal element phenotype', 'presumptive structure phenotype', 'skeleton', 'hindbrain', 'multicellular organismal process', 'material entity', 'Abnormal curvature of the vertebral column', 'manual digit phenotype', 'cavitated compound organ', 'negative regulation of metabolic process', 'structure with developmental contribution from neural crest phenotype', 'decreased size of the multicellular anatomical structure', 'somite', 'mesoderm morphology phenotype', 'number of anatomical enitites of type organ component layer phenotype', 'multicellular anatomical structure', 'process', 'skeleton phenotype', 'material anatomical entity', 'closing of the anatomical entity', 'number of anatomical enitites of type skeletal element phenotype', 'location of anatomical entity phenotype', 'appendicular skeleton', 'cranial skeletal system', 'dysgenesis of the forelimb zeugopod bone', 'preauricular skin tag', 'increased number of brain ventricle/choroid plexus in the cerebrospinal fluid', 'forelimb endochondral element phenotype', 'material anatomical entity phenotype', 'Abnormal finger morphology', 'pectoral appendage phenotype', 'increased number of material anatomical entity', 'face', 'cerebellum phenotype', 'tooth-like structure phenotype', 'anatomical structure phenotype', 'localised abdominal segment element', 'upper urinary tract', 'scoliosis', 'aplastic secondary dentition', 'epithelial vesicle', 'phenotypic effect', 'absent anatomical entity in the forelimb', 'forebrain', 'decreased number of anatomical structure in the multicellular organism', 'Pelvic kidney', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'neural tube morphology phenotype', 'bone of pectoral complex morphology phenotype', 'anatomical system phenotype', 'zeugopod', 'kidney', 'zeugopodial skeleton', 'dysgenesis of the forelimb bone', 'anatomical entity morphology phenotype', 'simple eye', 'germ layer / neural crest', 'trunk', 'abdominal segment element phenotype', 'dorsal region element phenotype', 'Abnormality of the integument', 'Abnormal anus morphology', 'appendage phenotype', 'Abnormal forearm morphology', 'limb bone phenotype', 'Neurodevelopmental abnormality', 'system', 'Abnormality of the genitourinary system', 'organism subdivision', 'pelvic kidney', 'decreased number of anatomical entity in the multicellular organism', 'multi-limb segment region', 'Aplasia/hypoplasia involving bones of the upper limbs', 'decreased number of material anatomical entity in the bone element', 'renal system', 'increased number of anatomical entity in the cerebrospinal fluid', 'Abnormal cellular physiology', 'anatomical wall', 'decreased number of anatomical structure in the bone element', 'germ layer', 'continuant', 'number of anatomical enitites of type anatomical entity phenotype', 'Abnormal brain morphology', 'localised lateral structure', 'organism substance phenotype', 'Abnormality of the urinary system', 'lateral plate mesoderm morphology phenotype', 'organ system subdivision phenotype', 'Bone marrow hypocellularity', 'number of anatomical enitites of type organism subdivision phenotype', 'musculature of body', 'mesoderm phenotype', 'subdivision of head', 'All', 'bone element', 'forelimb zeugopod bone', 'subdivision of organism along appendicular axis', 'malformed anatomical entity', 'anatomical structure', 'cavitated compound organ phenotype', 'Aplasia/Hypoplasia affecting the eye', 'multicellular anatomical structure phenotype', 'embryonic structure', 'anatomical entity', 'Abnormality of skull size', 'anatomical cavity phenotype', 'subdivision of trunk phenotype', 'regulation of macromolecule metabolic process phenotype', 'head morphology phenotype', 'excretory system', 'multicellular anatomical structure atresia', 'cell condensation', 'midface phenotype', 'temporofacial region', 'arm', 'sense organ', 'localised compound organ', 'compound organ phenotype', 'craniocervical region phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'anatomical entity physiology phenotype', 'haemolymphatic fluid', 'erythrocyte morphology phenotype', 'paraxial mesoderm phenotype', 'subdivision of organism along main body axis phenotype', 'absent material anatomical entity', 'tissue', 'Motor delay', 'presomitic mesoderm morphology phenotype', 'abdominal segment of trunk', 'paraxial mesoderm', 'Abnormal renal morphology', 'immune system phenotype', 'kidney morphology phenotype', 'manus', 'ectoderm morphology phenotype', 'renal system phenotype', 'dense mesenchyme tissue phenotype', 'mesenchyme phenotype', 'Ectopic kidney', 'cellular process', 'Radial ray deficiency', 'forebrain phenotype', 'nervous system physiology phenotype', 'spinal cord phenotype', 'craniofacial/craniocervical phenotype', 'agenesis of anatomical entity', 'trunk region element', 'localised anatomical entity', 'programmed DNA elimination by chromosome breakage', 'Abnormality of the upper urinary tract', 'visual system phenotype', 'cheek morphology phenotype', 'decreased number of material anatomical entity', 'Cerebellar malformation', 'skin of body phenotype', 'Abnormal number of permanent teeth', 'midface morphology phenotype', 'erythroid lineage cell', 'radius bone morphology phenotype', 'limb', 'cellular process phenotype', 'behavior process', 'central nervous system phenotype', 'pectoral appendage bud', 'Hydrocephalus', 'secondary dentition', 'taxon specific phenotype', 'multicellular organism', 'craniocervical region', 'localised kidney', 'structure with developmental contribution from neural crest', 'orbital region phenotype', 'Abnormality of the upper limb', 'cell', 'dysgenesis of the anatomical entity', 'cerebellum morphology phenotype', 'bone marrow cell', 'lateral structure', 'lateral plate mesoderm phenotype', 'Abnormal skin morphology', 'appendicular skeletal system', 'body proper', 'Abnormal localization of kidney', 'paired limb/fin bud', 'limb endochondral element', 'negative regulation of cellular process phenotype', 'non-connected functional system', 'behavior process phenotype', 'forelimb long bone', 'respiratory system phenotype', 'regulation of biosynthetic process phenotype', 'embryo', 'Localized skin lesion', 'decreased number of anatomical entity in the bone marrow', 'macromolecule metabolic process phenotype', 'organ', 'external soft tissue zone', 'regulation of gene expression phenotype', 'bone marrow phenotype', 'decreased size of the subdivision of organism along main body axis', 'regional part of nervous system phenotype', 'face phenotype', 'limb skeleton subdivision', 'cheek', 'negative regulation of macromolecule metabolic process', 'segment of manus', 'Intellectual disability', 'epithelium phenotype', 'presumptive paraxial mesoderm', 'Decreased head circumference', 'tissue phenotype', 'main body axis', 'upper urinary tract phenotype', 'abdomen', 'surface structure phenotype', 'brain ventricle/choroid plexus', 'dysgenesis of the limb long bone', 'lateral structure phenotype', 'organ system subdivision', 'musculoskeletal system phenotype', 'aplasia or hypoplasia of anatomical entity', 'mesoderm', 'macromolecule biosynthetic process', 'Abnormality of the digestive system', 'bone marrow', 'ventricular system of central nervous system', 'subdivision of tube', 'decreased number of bone marrow cell', 'developing anatomical structure phenotype', 'subdivision of digestive tract', 'localised anatomical structure', 'ventricular system of brain', 'compound organ', 'kidney phenotype', 'growth', 'number of anatomical enitites of type material anatomical entity phenotype', 'simple eye phenotype', 'cheek phenotype', 'multicellular organism phenotype', 'decreased size of the organ', 'Abnormality of the vertebral column', 'Growth abnormality', 'limb bud', 'anatomical system', 'absent anatomical structure in the limb', 'circulatory system phenotype', 'organ part phenotype', 'metabolic process phenotype', 'phenotype', 'Tooth agenesis', 'disconnected anatomical group', 'Abnormality of multiple cell lineages in the bone marrow', 'arm phenotype', 'absent autopodial extension', 'lateral plate mesoderm', 'cell phenotype', 'consumption behavior', 'anatomical entity phenotype', 'genitourinary system phenotype', 'presumptive structure', 'digit phenotype', 'bone element phenotype', 'system process', 'number of anatomical enitites of type anatomical structure phenotype', 'hemolymphoid system', 'ectoderm phenotype', 'subdivision of trunk', 'embryonic tissue phenotype', 'Chromosomal breakage induced by crosslinking agents', 'paraxial mesoderm morphology phenotype', 'head phenotype', 'regulation of biological process phenotype', 'primordium phenotype', 'metabolic process', 'homeostatic process phenotype', 'anatomical space', 'negative regulation of biological process phenotype', 'forelimb zeugopod skeleton', 'dysgenesis of the material anatomical entity', 'Opisthokonta', 'embryo morphology phenotype', 'somite phenotype', 'regulation of macromolecule biosynthetic process phenotype', 'musculature of body phenotype', 'forelimb morphology phenotype', 'mesenchyme morphology phenotype', 'skull', 'cell condensation phenotype', 'manus morphology phenotype', 'Abnormality of the musculoskeletal system', 'dysgenesis of the bone of appendage girdle complex', 'chordal neural plate phenotype', 'respiratory system physiology phenotype', 'head', 'trunk mesenchyme phenotype', 'skeletal system phenotype', 'blastula', 'neural plate phenotype', 'immaterial anatomical entity', 'axial skeleton plus cranial skeleton phenotype', 'developing mesenchymal condensation', 'migrating mesenchyme population phenotype', 'subdivision of head phenotype', 'anterior region of body', 'sclerotome morphology phenotype', 'vasculature of central nervous system plus retina phenotype', 'dorsum', 'nervous system', 'subdivision of digestive tract phenotype', 'epithelium', 'formed material anatomical entity', 'brain phenotype', 'sclerotome phenotype', 'vertebral column phenotype', 'presomitic mesoderm', 'skeletal system morphology phenotype', 'subdivision of skeleton', 'Abnormal axial skeleton morphology', 'segmental subdivision of nervous system', 'oral cavity phenotype', 'postcranial axial skeletal system', 'axial skeletal system', 'vertebral column', 'Growth delay', 'increased number of organ component layer', 'vertebral column morphology phenotype', 'presomitic mesoderm phenotype', 'anatomical cluster', 'subdivision of skeletal system', 'appendage girdle complex', 'subdivision of skeletal system phenotype', 'size of skull phenotype', 'growth phenotype', 'appendicular skeleton morphology phenotype', 'external soft tissue zone phenotype', 'Abnormal skeletal morphology', 'embryonic tissue morphology phenotype', 'anatomical collection', 'developing mesenchymal condensation phenotype', 'cerebrospinal fluid', 'anatomical conduit atresia', 'Scoliosis', 'axial skeleton plus cranial skeleton', 'limb endochondral element phenotype', 'forelimb zeugopod phenotype', 'mouth morphology phenotype', 'paired limb/fin skeleton phenotype', 'bone of free limb or fin phenotype', 'absent material anatomical entity in the limb', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'digitopodium region', 'cranial skeletal system phenotype', 'tube', 'localised multicellular anatomical structure', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'number of anatomical enitites of type tooth-like structure phenotype', 'localised organ', 'Abnormality of mental function', 'number of anatomical enitites of type organ phenotype', 'negative regulation of biological process', 'Abnormal oral morphology', 'Abnormality of the mouth', 'dysgenesis of the arm bone', 'mouth', 'paired limb/fin phenotype', 'Agenesis of permanent teeth', 'feeding behavior', 'immaterial entity', 'occurrent', 'localised abdomen element', 'limb morphology phenotype', 'number of anatomical enitites of type secondary dentition phenotype', 'number of anatomical enitites of type anatomical collection phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'mesenchyme', 'digestive tract', 'digit 1', 'delayed growth', 'decreased number of tooth-like structure', 'musculature', 'subdivision of tube phenotype', 'limb long bone morphology phenotype', 'surface structure', 'tooth-like structure', 'embryo phenotype', 'decreased number of multicellular anatomical structure in the multicellular organism', 'increased number of organ component layer in the cerebrospinal fluid', 'erythrocyte', 'tube phenotype', 'abdominal segment element', 'calcareous tooth phenotype', 'number of anatomical enitites of type dentition phenotype', 'renal/urinary system phenotype', 'biological_process phenotype', 'oral cavity', 'anus phenotype', 'entity', 'immaterial anatomical entity phenotype', 'Aplasia/hypoplasia of the extremities', 'pectoral appendage skeleton phenotype', 'epithelial vesicle phenotype', 'decreased number of organ', 'size of anatomical entity phenotype', 'organ part', 'anatomical conduit phenotype', 'Abnormality of limbs', 'number of anatomical enitites of type structure with developmental contribution from neural crest phenotype', 'limb bone morphology phenotype', 'Abnormal oral cavity morphology', 'arm bone phenotype', 'Abnormal number of teeth', 'forelimb zeugopod', 'decreased number of structure with developmental contribution from neural crest', 'delayed biological_process', 'blood cell', 'Abnormality of the face', 'calcareous tooth', 'behavior', 'number of cell phenotype', 'anatomical cavity', 'dysgenesis of the bone element', 'number of anatomical enitites of type calcareous tooth phenotype', 'pectoral appendage skeleton', 'aplastic anatomical entity', 'Abnormality of the skin', 'anatomical space phenotype', 'dysgenesis of the long bone', 'dentition phenotype', 'decreased number of skeletal element', 'orifice phenotype', 'digestive system morphology phenotype', 'biological_process', 'multi-limb segment region phenotype', 'bone of pectoral complex phenotype', 'Abnormal upper limb bone morphology', 'zeugopod phenotype', 'forelimb zeugopod bone phenotype', 'limb bud phenotype', 'bodily fluid phenotype', 'respiratory system', 'endochondral bone', 'developing anatomical structure', 'dysgenesis of the bone of free limb or fin', 'neurectoderm', 'Abnormal limb bone morphology', 'dysgenesis of the forelimb endochondral element', 'dysgenesis of the organ', 'limb segment', 'Abnormality of limb bone', 'pectoral appendage bud phenotype', 'forelimb bone phenotype', 'paired limb/fin bud phenotype', 'dysgenesis of the skeletal element', 'consumption behavior phenotype', 'genitourinary system', 'limb long bone phenotype', 'appendage', 'metencephalon phenotype', 'mesoderm-derived structure', 'forelimb skeleton', 'arm bone', 'radius bone', 'bone of appendage girdle complex phenotype', 'primordium', 'localised material anatomical entity', 'dysgenesis of the limb bone', 'eyeball of camera-type eye', 'Abnormal thumb morphology', 'forelimb zeugopod morphology phenotype', 'paired limb/fin segment phenotype', 'sclerotome', 'paired limb/fin skeleton', 'endochondral element', 'manual digit 1 plus metapodial segment', 'upper limb segment', 'anatomical entity morphology in the pectoral complex phenotype', 'forelimb phenotype', 'formed anatomical structure', 'limb bud morphology phenotype', 'dysgenesis of the multicellular anatomical structure', 'long bone', 'musculature phenotype', 'hypoventilation', 'dysgenesis of the bone of pectoral complex', 'radius bone phenotype', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'forelimb', 'decreased number of material anatomical entity in the multicellular organism', 'oral cavity morphology phenotype', 'Abnormal forearm bone morphology', 'anatomical collection phenotype', 'dysgenesis of the forelimb long bone', 'abdomen element phenotype', 'limb segment phenotype', 'endochondral element phenotype', 'forelimb skeleton phenotype', 'ectoderm-derived structure', 'dysgenesis of the radius endochondral element', 'organ subunit phenotype', 'ectoderm-derived structure phenotype', 'integumental system', 'anatomical cluster phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'forelimb bone', 'radius endochondral element', 'anterior neural tube phenotype', 'dysgenesis of the anatomical structure', 'increased number of multicellular anatomical structure', 'endochondral bone phenotype', 'paired limb/fin', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'forelimb bud', 'renal system morphology phenotype', 'forelimb long bone phenotype', 'Abnormal appendicular skeleton morphology', 'bone of pectoral complex', 'bone of free limb or fin', 'anatomical structure atresia', 'formed regional part of brain', 'Abnormality of head or neck', 'limb bone', 'long bone morphology phenotype', 'limb long bone', 'abdomen element', 'entire embryonic mesenchyme', 'dysgenesis of the limb endochondral element', 'appendicular skeleton phenotype', 'gene expression', 'Abnormal morphology of the radius', 'dysgenesis of the radius bone', 'manual digit 1 or 5', 'organ phenotype', 'migrating mesenchyme population', 'subdivision of organism along appendicular axis phenotype', 'integument', 'forelimb zeugopod bone morphology phenotype', 'skeleton of pectoral complex'], 'has_descendant': ['MONDO:0014986'], 'has_descendant_label': ['Fanconi anemia complementation group R'], 'has_descendant_count': 1, 'highlighting': None}]}, 'facet_counts': {'facet_fields': {}, 'facet_queries': {}}, 'highlighting': {}}
