
import pytest

@pytest.fixture
def search_response():
    return {'responseHeader': {'QTime': 3, 'params': {'mm': '100%', 'hl': 'false', 'start': '0', 'q.op': 'AND', 'fq': 'name:*', 'rows': '20', 'q': 'fanconi', 'defType': 'edismax', 'facet_min_count': '1', 'qf': 'id^100 name^10 name_t^5 name_ac symbol^10 symbol_t^5 symbol_ac synonym synonym_t synonym_ac description_t xref', 'boost': 'product(if(termfreq(category,"biolink:PhenotypicFeature"),1.1,1),if(termfreq(category,"biolink:Disease"),1.3,1),if(and(termfreq(in_taxon,"NCBITaxon:9606"),termfreq(category,"biolink:Gene")),1.1,1),if(termfreq(deprecated,"true"),0.1,1))', 'facet.mincount': '1', 'facet': 'true'}}, 'response': {'num_found': 131, 'start': 0, 'docs': [{'id': 'MONDO:0019391', 'category': 'biolink:Disease', 'name': 'Fanconi anemia', 'description': 'Fanconi anemia (FA) is a hereditary DNA repair disorder characterized by progressive pancytopenia with bone marrow failure, variable congenital malformations and predisposition to develop hematological or solid tumors.', 'xref': ['DOID:13636', 'GARD:6425', 'ICD9:284.09', 'MEDGEN:41967', 'MESH:D005199', 'MedDRA:10055206', 'NANDO:1200303', 'NANDO:1200891', 'NANDO:2200652', 'NCIT:C62505', 'NORD:1132', 'OMIMPS:227650', 'Orphanet:84', 'SCTID:30575002', 'UMLS:C0015625'], 'synonym': ['Fanconi anemia', 'Fanconi pancytopenia', 'Fanconi panmyelopathy', "Fanconi's anaemia", "Fanconi's anemia", 'Panmyelopathy, Fanconi', 'pancytopenia, congenital', 'primary erythroid hypoplasia'], 'exact_synonym': ['Fanconi anemia', 'Fanconi pancytopenia', 'Fanconi panmyelopathy', "Fanconi's anaemia", "Fanconi's anemia", 'Panmyelopathy, Fanconi', 'pancytopenia, congenital', 'primary erythroid hypoplasia'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'ordo_disorder', 'ordo_malformation_syndrome', 'orphanet_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0002827', 'HP:0001511', 'HP:0000504', 'HP:0008053', 'HP:0001537', 'HP:0003220', 'HP:0001249', 'HP:0000453', 'HP:0000047', 'HP:0001824', 'HP:0000813', 'HP:0001882', 'HP:0001199', 'HP:0004209', 'HP:0000486', 'HP:0001873', 'HP:0006101', 'HP:0100026', 'HP:0001679', 'HP:0002863', 'HP:0000568', 'HP:0000079', 'HP:0004322', 'HP:0001000', 'HP:0002007', 'HP:0000027', 'HP:0000364', 'HP:0006265', 'HP:0001871', 'HP:0100867', 'HP:0000028', 'HP:0001263', 'HP:0000268', 'HP:0002817', 'HP:0001636', 'HP:0000508', 'HP:0002414', 'HP:0001639', 'HP:0010293', 'HP:0000324', 'HP:0001903', 'HP:0004349', 'HP:0000218', 'HP:0001562', 'HP:0100760', 'HP:0008678', 'HP:0007874', 'HP:0001760', 'HP:0000483', 'HP:0000252', 'HP:0005344', 'HP:0002251', 'HP:0002245', 'HP:0000864', 'HP:0012745', 'HP:0000130', 'HP:0010469', 'HP:0000377', 'HP:0007565', 'HP:0100587', 'HP:0006501', 'HP:0001643', 'HP:0001631', 'HP:0000035', 'HP:0000286', 'HP:0000083', 'HP:0001510', 'HP:0000347', 'HP:0012639', 'HP:0000072', 'HP:0100542', 'HP:0000518', 'HP:0001671', 'HP:0006824', 'HP:0003022', 'HP:0000238', 'HP:0000175', 'HP:0002119', 'HP:0000478', 'HP:0000010', 'HP:0000492', 'HP:0000582', 'HP:0002023', 'HP:0002650', 'HP:0001770', 'HP:0000340', 'HP:0012041', 'HP:0005522', 'HP:0001763', 'HP:0001172', 'HP:0002823', 'HP:0000639', 'HP:0040071', 'HP:0012210', 'HP:0000135', 'HP:0001053', 'HP:0000316', 'HP:0001347', 'HP:0007400', 'HP:0001646', 'HP:0002575', 'HP:0001392', 'HP:0000520', 'HP:0002664', 'HP:0000505', 'HP:0000365'], 'has_phenotype_label': ['Cryptorchidism', 'Oligohydramnios', 'Abnormal preputium morphology', 'Anal atresia', 'Aganglionic megacolon', 'Abnormal thumb morphology', 'Abnormality of the upper limb', 'Abnormality of vision', 'Abnormal aortic valve morphology', 'Abnormality of the eye', 'Upslanted palpebral fissure', 'Facial asymmetry', 'Intellectual disability', 'Hypoplasia of the ulna', 'Intrauterine growth retardation', 'Hydrocephalus', 'Microcephaly', 'Renal hypoplasia/aplasia', 'Hypospadias', 'Arteriovenous malformation', 'Bicornuate uterus', 'Abnormal aortic morphology', 'Aplasia/Hypoplasia of the uvula', 'Clinodactyly of the 5th finger', 'Hip dislocation', 'High palate', 'Short stature', 'Anemia', 'Scoliosis', 'Abnormal renal morphology', 'Choanal atresia', 'Abnormal localization of kidney', 'Weight loss', 'Hearing abnormality', 'Growth delay', 'Abnormality of the hypothalamus-pituitary axis', 'Duodenal stenosis', 'Strabismus', 'Hydroureter', 'Cranial nerve paralysis', 'Spina bifida', 'Ptosis', 'Pyridoxine-responsive sideroblastic anemia', 'Hypogonadism', 'Azoospermia', 'Visual impairment', 'Abnormal testis morphology', 'Abnormality of chromosome stability', 'Meckel diverticulum', 'Global developmental delay', 'Cataract', 'Hearing impairment', 'Tetralogy of Fallot', 'Hyperreflexia', 'Abnormality of skin pigmentation', 'Pes planus', 'Aplasia/Hypoplasia of fingers', 'Abnormality of the uterus', 'Myelodysplasia', 'Micrognathia', 'Frontal bossing', 'Aplasia/Hypoplasia of the radius', 'Atrial septal defect', 'Abnormal cardiac septum morphology', 'Cleft palate', 'Decreased fertility in males', 'Recurrent urinary tract infections', 'Triphalangeal thumb', 'Abnormal morphology of ulna', 'Proptosis', 'Thrombocytopenia', 'Hypopigmented skin patches', 'Epicanthus', 'Renal insufficiency', 'Hypertelorism', 'Abnormality of the urinary system', 'Neoplasm', 'Dolichocephaly', 'Hypertrophic cardiomyopathy', 'Astigmatism', 'Abnormality of blood and blood-forming tissues', 'Nystagmus', 'Abnormal pinna morphology', 'Umbilical hernia', 'Reduced bone mineral density', 'Abnormal nervous system morphology', 'Finger syndactyly', 'Abnormal femur morphology', 'Multiple cafe-au-lait spots', 'Patent ductus arteriosus', 'Toe syndactyly', 'Abnormal foot morphology', 'Sloping forehead', 'Decreased total leukocyte count', 'Short palpebral fissure', 'Abnormal carotid artery morphology', 'Abnormal eyelid morphology', 'Clubbing of toes', 'Irregular hyperpigmentation', 'Tracheoesophageal fistula', 'Ventriculomegaly', 'Absent testis', 'Abnormality of the liver', 'Aplasia/Hypoplasia of the iris', 'Almond-shaped palpebral fissure', 'Microphthalmia'], 'has_phenotype_count': 106, 'has_phenotype_closure': ['UPHENO:0002427', 'UPHENO:0002411', 'UPHENO:0063524', 'UPHENO:0063519', 'UPHENO:0063518', 'UPHENO:0063513', 'UBERON:0036302', 'UPHENO:0003391', 'UPHENO:0015184', 'UPHENO:0014865', 'UPHENO:0056251', 'UPHENO:0056333', 'UPHENO:0056158', 'UPHENO:0075877', 'UPHENO:0056149', 'HP:0000238', 'UPHENO:0014351', 'UPHENO:0056242', 'UPHENO:0085938', 'UPHENO:0072263', 'UBERON:0001712', 'UBERON:0000014', 'UPHENO:0072332', 'UPHENO:0072315', 'UPHENO:0087928', 'UBERON:0000076', 'UPHENO:0001231', 'UPHENO:0072355', 'HP:0000286', 'UPHENO:0072415', 'UPHENO:0072212', 'UPHENO:0031179', 'UPHENO:0031144', 'UPHENO:0031228', 'UPHENO:0001217', 'UPHENO:0001227', 'UPHENO:0031226', 'UPHENO:0001519', 'UPHENO:0001187', 'UPHENO:0031123', 'UPHENO:0041037', 'UPHENO:0001025', 'UPHENO:0031129', 'UPHENO:0041395', 'HP:0011563', 'UPHENO:0077800', 'UPHENO:0004724', 'UPHENO:0002802', 'UPHENO:7000168', 'UPHENO:0067030', 'UPHENO:0054374', 'HP:0004323', 'UPHENO:0082794', 'UBERON:1000021', 'UPHENO:0010808', 'UPHENO:0010763', 'HP:0001824', 'UPHENO:0054304', 'UPHENO:0054315', 'UPHENO:0002904', 'UPHENO:7000916', 'UBERON:0001359', 'HP:0410043', 'UBERON:0000344', 'UBERON:0005863', 'UPHENO:0002646', 'UBERON:0002412', 'UPHENO:0081609', 'UBERON:0001199', 'UPHENO:0033628', 'UBERON:0010358', 'UBERON:0007844', 'UBERON:0005174', 'UBERON:0001137', 'UPHENO:0003112', 'UPHENO:0002959', 'UPHENO:7001123', 'UPHENO:0033562', 'UBERON:0000328', 'UPHENO:0076744', 'UPHENO:0086958', 'UPHENO:0002688', 'UBERON:0010039', 'UPHENO:0085534', 'UPHENO:0085538', 'UPHENO:0014291', 'UBERON:0000162', 'UPHENO:0002824', 'UBERON:0035651', 'UBERON:0012241', 'UPHENO:7000052', 'UBERON:0001333', 'UBERON:0005629', 'UPHENO:7000305', 'UPHENO:0087424', 'UPHENO:0084004', 'UPHENO:0087871', 'GO:0005694', 'UPHENO:7000141', 'HP:0032076', 'UPHENO:0006889', 'UBERON:0001556', 'UPHENO:0005513', 'UPHENO:0005512', 'UPHENO:0052231', 'GO:0050954', 'UPHENO:0050625', 'UPHENO:0052970', 'UPHENO:0067095', 'UPHENO:0069523', 'HP:0000568', 'UPHENO:0075219', 'UPHENO:0052694', 'UPHENO:0002927', 'UPHENO:0050034', 'UPHENO:0005642', 'UPHENO:0080393', 'UBERON:0005913', 'UBERON:0010719', 'UPHENO:0076767', 'UBERON:0007828', 'UPHENO:0081608', 'UPHENO:0002766', 'UPHENO:0002728', 'UPHENO:0076728', 'HP:0003272', 'UBERON:0000982', 'UBERON:0011107', 'UPHENO:0086091', 'HP:0001384', 'UPHENO:0075871', 'UBERON:0008114', 'UBERON:0003657', 'UBERON:0007832', 'UPHENO:0081584', 'UPHENO:0086100', 'UBERON:0001464', 'UBERON:0001271', 'UBERON:0001272', 'HP:0002827', 'UPHENO:0003376', 'UBERON:0003463', 'UPHENO:0046405', 'UPHENO:0069292', 'UPHENO:0069163', 'UPHENO:0046397', 'UPHENO:0085968', 'UPHENO:0046554', 'HP:0006495', 'UPHENO:0079872', 'UPHENO:0069047', 'UPHENO:0046392', 'UPHENO:0046479', 'UPHENO:0069194', 'UPHENO:0081344', 'HP:0030311', 'UPHENO:0046538', 'UPHENO:0046465', 'UPHENO:0069125', 'UPHENO:0031206', 'UPHENO:0069064', 'UPHENO:0069030', 'UPHENO:0012274', 'UPHENO:0046460', 'UPHENO:0075943', 'HP:0003022', 'UPHENO:0046540', 'UBERON:0000122', 'UPHENO:0004508', 'UPHENO:0081709', 'UPHENO:0081700', 'UPHENO:0004142', 'HP:0031910', 'HP:0007874', 'UPHENO:0041462', 'HP:0000268', 'HP:0000517', 'UPHENO:0084815', 'HP:0000518', 'UBERON:0000965', 'UPHENO:0004765', 'UPHENO:0078246', 'HP:0001770', 'UPHENO:0078375', 'UPHENO:0078347', 'UBERON:0012240', 'HP:0100542', 'HP:0001053', 'UPHENO:0077874', 'UPHENO:0077877', 'UBERON:0010377', 'UBERON:0005726', 'UPHENO:0086610', 'UBERON:0005725', 'UPHENO:0002711', 'UPHENO:0063588', 'UPHENO:0003395', 'GO:0007600', 'UPHENO:0052164', 'UPHENO:0050620', 'UPHENO:0052160', 'UPHENO:0050236', 'HP:0009826', 'HP:0000504', 'UPHENO:0004470', 'UPHENO:0087894', 'UBERON:0003826', 'UPHENO:0003584', 'UBERON:0000376', 'UBERON:0015052', 'UBERON:0005893', 'HP:0000083', 'HP:0002823', 'UPHENO:0046396', 'UPHENO:0078267', 'UPHENO:0078215', 'UPHENO:0078288', 'UPHENO:0078125', 'UPHENO:0078159', 'CL:0000457', 'UPHENO:0077391', 'UPHENO:0086173', 'UBERON:0010418', 'HP:0009821', 'UPHENO:7000590', 'CL:0000458', 'UPHENO:0075213', 'UPHENO:7000599', 'CL:0000225', 'CL:0000151', 'UPHENO:0001447', 'UBERON:0005179', 'UPHENO:7000351', 'UPHENO:0001019', 'HP:0000072', 'UPHENO:0063529', 'UPHENO:0001439', 'UPHENO:0002806', 'UPHENO:0001174', 'UPHENO:0076780', 'UBERON:0006555', 'HP:0011994', 'UPHENO:0033559', 'UPHENO:0002740', 'UPHENO:7000601', 'HP:0000415', 'UBERON:0002099', 'UPHENO:0003815', 'UPHENO:0002456', 'UPHENO:0033607', 'UBERON:0003037', 'HP:0005120', 'UBERON:0002081', 'UPHENO:0033596', 'UPHENO:7000198', 'UPHENO:0086857', 'UPHENO:0086863', 'HP:0001631', 'UPHENO:0083162', 'GO:0051703', 'UPHENO:0050068', 'UPHENO:0041079', 'HP:0001263', 'UPHENO:0014761', 'UPHENO:0000508', 'UPHENO:0083046', 'GO:0048232', 'GO:0019953', 'GO:0003006', 'UPHENO:0078081', 'UPHENO:0005592', 'UPHENO:0005651', 'HP:0012874', 'UPHENO:0080011', 'UPHENO:0046484', 'UPHENO:0049701', 'UPHENO:0053500', 'HP:0000025', 'GO:0005634', 'UPHENO:0078452', 'CL:0000015', 'CL:0000408', 'UPHENO:0085875', 'UBERON:0001968', 'UPHENO:0002599', 'UBERON:0004054', 'UPHENO:0053298', 'UPHENO:0012312', 'UPHENO:0002321', 'CL:0000039', 'UPHENO:0080382', 'UPHENO:0052965', 'UPHENO:0086201', 'UPHENO:0077404', 'UPHENO:0066925', 'HP:0001638', 'GO:0099120', 'UPHENO:0066945', 'UPHENO:0031142', 'HP:0000135', 'UPHENO:0024906', 'UPHENO:0002323', 'GO:0050890', 'HP:0012759', 'GO:0043232', 'HP:0001249', 'HP:0011446', 'UPHENO:0002869', 'HP:0011603', 'UBERON:0006876', 'UBERON:0002201', 'UPHENO:0015277', 'HP:0025633', 'UPHENO:0033603', 'UPHENO:0033579', 'UPHENO:0015281', 'UPHENO:0015331', 'UBERON:0018674', 'UPHENO:0033580', 'UPHENO:0005069', 'UPHENO:0005134', 'UPHENO:0087309', 'UPHENO:0087018', 'UBERON:0011695', 'HP:0001159', 'UPHENO:0033581', 'UBERON:0005985', 'HP:0001549', 'UPHENO:0049985', 'UPHENO:0049940', 'HP:0002245', 'UBERON:0002472', 'GO:0009792', 'GO:0007275', 'UPHENO:0051077', 'UPHENO:0076773', 'UBERON:0000011', 'UPHENO:0004487', 'UPHENO:0002790', 'UPHENO:0001342', 'UPHENO:0084121', 'HP:0004362', 'UPHENO:0087058', 'UBERON:0000045', 'UPHENO:0066902', 'UPHENO:0086997', 'UPHENO:0002941', 'UBERON:0004907', 'UBERON:0001046', 'HP:0001367', 'GO:0060562', 'GO:0002009', 'GO:0016331', 'GO:0072175', 'GO:0021915', 'UBERON:0000010', 'GO:0035148', 'GO:0048731', 'GO:0009888', 'UBERON:0001808', 'UPHENO:0003979', 'HP:6000852', 'GO:0001843', 'GO:0001838', 'UPHENO:0001031', 'UPHENO:0081436', 'UPHENO:0050108', 'UPHENO:0005046', 'UPHENO:0005116', 'UBERON:0000059', 'UPHENO:0067694', 'HP:0006824', 'UPHENO:7000670', 'HP:0010935', 'UPHENO:0076779', 'UPHENO:0087427', 'UPHENO:0075902', 'UPHENO:0002467', 'UBERON:0011143', 'UPHENO:0005433', 'UPHENO:0002909', 'UPHENO:0003571', 'HP:0012210', 'HP:0000077', 'UBERON:0000163', 'UPHENO:0002803', 'HP:0006501', 'UPHENO:0076754', 'HP:0006503', 'UPHENO:0046455', 'UPHENO:0075944', 'UBERON:0000057', 'UBERON:0001423', 'UPHENO:0002967', 'UBERON:0007530', 'UPHENO:0002558', 'UBERON:0003089', 'UPHENO:0086480', 'UBERON:0001486', 'HP:0010674', 'UPHENO:0086505', 'UPHENO:0002527', 'HP:0002650', 'UBERON:0005856', 'UPHENO:0004969', 'HP:0000925', 'UPHENO:0046531', 'HP:0000520', 'UPHENO:0041098', 'UPHENO:0041203', 'UBERON:0000956', 'UPHENO:0076695', 'UPHENO:7000389', 'UBERON:0011215', 'UBERON:0022303', 'UPHENO:0084465', 'HP:0011218', 'UBERON:0002116', 'UBERON:0004339', 'UBERON:0000209', 'UBERON:0011164', 'UPHENO:0087214', 'UBERON:0010428', 'UPHENO:0003098', 'UPHENO:0063621', 'HP:0025028', 'UPHENO:0004149', 'UPHENO:0003052', 'HP:0430000', 'UPHENO:0033609', 'UPHENO:0081603', 'UPHENO:0033573', 'HP:0000290', 'UBERON:0008200', 'HP:0002683', 'UPHENO:0002700', 'UPHENO:0076748', 'UPHENO:0002730', 'UBERON:0004766', 'UBERON:0001950', 'UBERON:0001703', 'UBERON:0005253', 'UPHENO:0003103', 'UPHENO:0087531', 'UPHENO:0002820', 'UPHENO:0014240', 'CL:0000233', 'HP:0008373', 'UPHENO:0041369', 'UPHENO:0082900', 'HP:0002007', 'UBERON:0001869', 'UPHENO:0088115', 'UBERON:0016529', 'UBERON:0003128', 'UPHENO:0002985', 'HP:0100491', 'UPHENO:0004143', 'UBERON:0003528', 'UPHENO:0063599', 'HP:0034915', 'UPHENO:0063577', 'UPHENO:0086644', 'HP:0004378', 'UBERON:0005389', 'UPHENO:0063565', 'UBERON:0013766', 'UPHENO:0002839', 'UPHENO:0001369', 'UBERON:0001245', 'UPHENO:0074230', 'GO:0001503', 'GO:0048646', 'CL:0000842', 'UPHENO:0082834', 'UPHENO:0082835', 'UPHENO:0085602', 'UPHENO:0056230', 'CL:0000226', 'UPHENO:0002270', 'HP:0003026', 'UPHENO:7000414', 'CL:0000945', 'UPHENO:0085578', 'CL:0000236', 'UPHENO:0003184', 'UPHENO:0085566', 'HP:0004349', 'CL:0000542', 'UPHENO:0085616', 'UPHENO:0002281', 'UPHENO:0004764', 'UPHENO:7000169', 'UPHENO:0018418', 'UPHENO:7000365', 'HP:0000486', 'UPHENO:0002785', 'UPHENO:0002719', 'UPHENO:0084816', 'UPHENO:0087349', 'UBERON:0003466', 'UPHENO:0002751', 'UPHENO:0004595', 'UPHENO:0002594', 'UBERON:0002085', 'UBERON:0010703', 'UPHENO:0002377', 'UBERON:0015003', 'UPHENO:0005573', 'HP:0011314', 'HP:0040071', 'HP:0040072', 'UPHENO:0002738', 'UPHENO:0052165', 'UBERON:0001424', 'UPHENO:0050101', 'UBERON:0003460', 'UPHENO:0002651', 'UPHENO:0075915', 'HP:0100026', 'HP:0000036', 'UBERON:0012361', 'UPHENO:0078729', 'UBERON:0034929', 'UPHENO:0087905', 'UPHENO:0002813', 'UPHENO:0086965', 'UBERON:0009196', 'UBERON:0012292', 'UBERON:0009142', 'UBERON:0000989', 'UBERON:0011374', 'UPHENO:0002569', 'UPHENO:0052178', 'HP:0002270', 'UPHENO:0004596', 'UPHENO:0086628', 'UBERON:5001466', 'UPHENO:0002758', 'UPHENO:0005597', 'HP:0010161', 'UPHENO:0066905', 'UPHENO:0063596', 'HP:0001780', 'UPHENO:0086956', 'HP:0009824', 'UPHENO:0001347', 'UBERON:0015022', 'UPHENO:0063562', 'UBERON:0010742', 'GO:0048598', 'UPHENO:0087369', 'UBERON:0012359', 'UBERON:0012142', 'UPHENO:0002992', 'UBERON:0001449', 'UPHENO:0002917', 'UBERON:0001441', 'UPHENO:0003110', 'UBERON:0012180', 'HP:0000539', 'UBERON:0010696', 'UBERON:0012152', 'HP:0001760', 'UPHENO:0066903', 'UBERON:0002387', 'UBERON:0003608', 'UPHENO:0002750', 'UPHENO:0002585', 'UBERON:0001466', 'UPHENO:0002969', 'UPHENO:0002716', 'UBERON:0001445', 'UPHENO:0003411', 'UPHENO:0080185', 'UPHENO:0002856', 'UPHENO:0002601', 'UPHENO:0002883', 'UPHENO:0002697', 'UBERON:0005899', 'UBERON:0012476', 'UBERON:0005420', 'UBERON:0001870', 'UBERON:0002471', 'UBERON:0010709', 'UPHENO:0002292', 'UBERON:0004709', 'HP:0100760', 'HP:0008678', 'UPHENO:0041212', 'UPHENO:0076806', 'UPHENO:0004456', 'UBERON:0005418', 'UBERON:0002103', 'UPHENO:0087422', 'HP:0001217', 'HP:0003220', 'GO:0007601', 'UPHENO:0049904', 'HP:0004322', 'UPHENO:0069254', 'HP:0001873', 'UPHENO:0080352', 'UPHENO:0080351', 'UPHENO:0081423', 'GO:0030097', 'NBO:0001845', 'UPHENO:0087858', 'UPHENO:0002638', 'GO:0048856', 'GO:0002262', 'GO:0035239', 'GO:0048869', 'GO:0022414', 'GO:0048871', 'CL:0000232', 'GO:0032502', 'GO:0009987', 'UPHENO:0005508', 'GO:0042592', 'HP:0001877', 'HP:0005522', 'HP:0045005', 'GO:0034101', 'GO:0030154', 'GO:0048468', 'GO:0007631', 'UBERON:0003828', 'GO:0048872', 'UPHENO:0001252', 'UPHENO:0002968', 'HP:0001903', 'GO:0030218', 'HP:0000483', 'UPHENO:0087339', 'UPHENO:0084729', 'HP:0000324', 'HP:0100627', 'HP:0000365', 'UBERON:0000056', 'HP:0200006', 'HP:0000582', 'HP:0001636', 'UPHENO:0033616', 'UBERON:0003697', 'UBERON:0007118', 'UBERON:0002384', 'HP:0004299', 'UBERON:0007779', 'UPHENO:0087577', 'UPHENO:0033610', 'UPHENO:0014971', 'UPHENO:0076722', 'UPHENO:0033615', 'HP:0003549', 'UPHENO:0002755', 'UBERON:0008202', 'UPHENO:0086122', 'HP:0100790', 'UBERON:0000154', 'HP:0010866', 'HP:0012758', 'UBERON:0005401', 'UPHENO:0075843', 'UBERON:0016887', 'HP:0005105', 'UPHENO:0085876', 'UPHENO:0076794', 'UPHENO:0075872', 'UBERON:0007823', 'UPHENO:0081313', 'UPHENO:0086116', 'UPHENO:0041664', 'UPHENO:0051003', 'UBERON:0000489', 'HP:0004298', 'UPHENO:0005071', 'UBERON:0005445', 'HP:0009179', 'UPHENO:0076736', 'UBERON:5006052', 'UPHENO:0005982', 'UPHENO:0086150', 'UBERON:0011585', 'UPHENO:0003191', 'UPHENO:0080369', 'HP:0004097', 'HP:0004209', 'UPHENO:0084834', 'UPHENO:0086143', 'UPHENO:0084842', 'UPHENO:0049970', 'HP:0004207', 'HP:0030084', 'HP:0007565', 'UPHENO:0010799', 'HP:0001034', 'UPHENO:0001427', 'HP:0011355', 'UPHENO:0012308', 'UPHENO:0087548', 'HP:0000957', 'UBERON:0001769', 'UPHENO:0076804', 'CL:0000300', 'UPHENO:0071332', 'UBERON:0000063', 'UBERON:0001801', 'GO:0014020', 'UBERON:0035133', 'UPHENO:7000311', 'UPHENO:0071317', 'UBERON:0011892', 'UBERON:0001768', 'HP:0008062', 'UPHENO:0080202', 'UPHENO:0041591', 'UBERON:0006311', 'HP:0008056', 'HP:0007700', 'UBERON:0001766', 'UPHENO:0002765', 'UPHENO:0076781', 'UPHENO:0076957', 'UPHENO:0076941', 'HP:0000553', 'UPHENO:0080201', 'UPHENO:0080209', 'UPHENO:0071334', 'HP:0000525', 'UPHENO:0063527', 'UBERON:0001691', 'HP:0000598', 'HP:0000356', 'UBERON:0001690', 'UPHENO:0086699', 'HP:0000377', 'GO:0005575', 'UPHENO:0003412', 'UBERON:0000003', 'UPHENO:0076730', 'HP:0001639', 'HP:0031703', 'UPHENO:0088088', 'UPHENO:0087403', 'HP:0010293', 'HP:0001872', 'UBERON:0003277', 'UBERON:0001734', 'UBERON:0005868', 'UPHENO:0001044', 'UPHENO:0041525', 'UPHENO:0004436', 'UBERON:0034768', 'UPHENO:0003034', 'UBERON:0004529', 'UBERON:5006048', 'UPHENO:0056237', 'UBERON:0015063', 'HP:0001574', 'UPHENO:0005319', 'UPHENO:0002442', 'UPHENO:0046552', 'UBERON:0011159', 'UPHENO:0002963', 'NCBITaxon:2759', 'NCBITaxon:1', 'HP:0030669', 'UPHENO:0002812', 'HP:0004348', 'UPHENO:0086679', 'HP:0000795', 'UPHENO:7000780', 'HP:0040070', 'NCBITaxon:33154', 'UPHENO:0018390', 'UPHENO:7000293', 'UPHENO:0087980', 'HP:0032039', 'UPHENO:0004433', 'HP:0045060', 'UPHENO:0087203', 'NCBITaxon:131567', 'GO:0043009', 'UBERON:0002049', 'UBERON:0001474', 'HP:0000492', 'UBERON:0003072', 'HP:0002143', 'UPHENO:0003158', 'UBERON:0004734', 'NCBITaxon:33208', 'UPHENO:0041565', 'UPHENO:0068971', 'UBERON:0010740', 'UPHENO:0002713', 'CL:0000081', 'HP:0000496', 'HP:0000639', 'UPHENO:0072255', 'UPHENO:0002543', 'UPHENO:0002301', 'UPHENO:0003298', 'UPHENO:0046594', 'UPHENO:0002403', 'UPHENO:0003031', 'UPHENO:0005517', 'UPHENO:0002352', 'UPHENO:0087665', 'UBERON:0001558', 'HP:0012373', 'UPHENO:0087814', 'NBO:0000338', 'UBERON:0017672', 'GO:0050882', 'UPHENO:0050622', 'UPHENO:0080377', 'UPHENO:0005647', 'UPHENO:0005275', 'UPHENO:0004788', 'UPHENO:0050106', 'HP:0200007', 'UPHENO:0080103', 'UPHENO:0079833', 'UPHENO:7000356', 'UBERON:0000970', 'UPHENO:0050079', 'UPHENO:0005214', 'UPHENO:0050613', 'GO:0043228', 'UBERON:0002368', 'UPHENO:0068941', 'UPHENO:0050606', 'UPHENO:0002267', 'UPHENO:0085302', 'UBERON:0000474', 'UPHENO:0052161', 'UPHENO:0003104', 'UPHENO:0076718', 'UPHENO:0079826', 'UBERON:0003075', 'UBERON:0004121', 'UPHENO:0055094', 'UPHENO:0080187', 'UPHENO:0049703', 'UPHENO:0002942', 'GO:0050877', 'HP:0012331', 'UBERON:0013702', 'NBO:0000388', 'UPHENO:0002385', 'HP:0001347', 'UPHENO:0087816', 'UPHENO:0004094', 'GO:0007399', 'UPHENO:0080662', 'UPHENO:0002577', 'UBERON:0000203', 'UPHENO:0083263', 'HP:0008055', 'UPHENO:0002430', 'UBERON:0007273', 'UPHENO:0049622', 'UPHENO:0002916', 'UBERON:0004571', 'UBERON:0006052', 'HP:0001510', 'UPHENO:0002822', 'UBERON:0010543', 'UPHENO:0005118', 'HP:0033353', 'UPHENO:0002772', 'UBERON:0000464', 'UPHENO:0004723', 'UPHENO:0085344', 'UBERON:0004111', 'UPHENO:0035160', 'UPHENO:0002240', 'UPHENO:0087334', 'HP:0002597', 'HP:0000001', 'UPHENO:0004523', 'UBERON:0003519', 'UBERON:0003509', 'UPHENO:0003776', 'HP:0009484', 'UPHENO:0003423', 'UPHENO:0063515', 'UPHENO:0087307', 'CL:0000413', 'HP:0040019', 'HP:0012638', 'HP:0000340', 'GO:0043227', 'HP:0000069', 'UPHENO:0086700', 'UPHENO:9002003', 'HP:0001679', 'UBERON:0005157', 'UPHENO:0076776', 'UPHENO:0003234', 'HP:0030680', 'UBERON:0019221', 'UPHENO:0033572', 'HP:0012041', 'HP:0002973', 'UBERON:0001009', 'UPHENO:0002206', 'UPHENO:0004507', 'UPHENO:0076783', 'UPHENO:0087083', 'HP:0011875', 'UBERON:0010409', 'UPHENO:0004484', 'UBERON:0003929', 'UBERON:0002217', 'UPHENO:0002576', 'HP:0000364', 'UPHENO:0005648', 'UBERON:0004716', 'UPHENO:0002635', 'UPHENO:0002994', 'HP:0100887', 'UPHENO:0004467', 'UPHENO:0085410', 'UPHENO:0046753', 'HP:0000027', 'UPHENO:0069062', 'UPHENO:0011536', 'UBERON:0000160', 'UPHENO:0075933', 'UPHENO:0086595', 'HP:0011893', 'UBERON:0006717', 'UPHENO:0004505', 'UPHENO:0086855', 'HP:0000234', 'UPHENO:0087123', 'UPHENO:7000586', 'UPHENO:0088166', 'UPHENO:0055092', 'UBERON:0001015', 'UPHENO:0041147', 'UPHENO:0002532', 'UBERON:0000020', 'UPHENO:0000541', 'HP:0002644', 'UPHENO:0076735', 'UBERON:0000161', 'UPHENO:0088185', 'UBERON:0002386', 'UPHENO:0002807', 'UPHENO:0087973', 'UBERON:0002405', 'UPHENO:0041053', 'UPHENO:0004172', 'UPHENO:0004434', 'UPHENO:0076675', 'UBERON:0010425', 'UPHENO:0005636', 'UPHENO:0002219', 'UPHENO:0069562', 'UPHENO:0082548', 'UBERON:0003975', 'UPHENO:0010795', 'UPHENO:0077399', 'UPHENO:0049708', 'UPHENO:0077348', 'UPHENO:0076765', 'UPHENO:0002433', 'UPHENO:0002668', 'UPHENO:0049699', 'CL:0000988', 'UBERON:0003064', 'UPHENO:0002542', 'GO:0060004', 'HP:0011873', 'UPHENO:0003207', 'UPHENO:0003026', 'UPHENO:0003159', 'GO:0007605', 'UPHENO:0005336', 'UPHENO:0004536', 'UBERON:0015021', 'UPHENO:0085371', 'UBERON:0002100', 'UPHENO:0004704', 'UPHENO:0033598', 'UBERON:0000478', 'UPHENO:0002211', 'UPHENO:0063787', 'UPHENO:0004047', 'UPHENO:0002538', 'UPHENO:7000640', 'UPHENO:0002426', 'UPHENO:0003025', 'UPHENO:0002887', 'UPHENO:0002537', 'UPHENO:0050234', 'UBERON:0001130', 'UPHENO:0002595', 'UPHENO:0084653', 'UPHENO:0004909', 'UPHENO:0005030', 'UPHENO:0052162', 'UBERON:0035639', 'HP:0001392', 'HP:0001010', 'UPHENO:0002637', 'UPHENO:0005097', 'UBERON:0002113', 'UPHENO:0055024', 'UPHENO:0041146', 'HP:0000079', 'UPHENO:0086589', 'HP:0001000', 'UBERON:0003513', 'UPHENO:0087501', 'UBERON:0001436', 'UPHENO:0004494', 'UBERON:0004362', 'UBERON:0034921', 'UPHENO:0002386', 'UPHENO:0002648', 'UPHENO:0003516', 'UBERON:0016879', 'UBERON:0004145', 'UPHENO:0049586', 'UPHENO:0002636', 'UBERON:0007100', 'UPHENO:0053632', 'UPHENO:0003020', 'UBERON:0010912', 'UPHENO:0003002', 'UPHENO:0086866', 'HP:0000549', 'UBERON:0004088', 'UBERON:0007811', 'UBERON:0000477', 'UPHENO:3000007', 'UPHENO:0003088', 'UPHENO:0075195', 'UBERON:0001434', 'UPHENO:0003048', 'UPHENO:0066913', 'UPHENO:0004466', 'HP:0000953', 'UBERON:0000015', 'UPHENO:0088118', 'UPHENO:0074245', 'UPHENO:0088186', 'UPHENO:0003186', 'HP:0001637', 'UPHENO:0041821', 'UBERON:0011582', 'UBERON:0006925', 'HP:0002817', 'UPHENO:0004545', 'UBERON:0015212', 'UPHENO:0082761', 'CL:0000255', 'HP:0011849', 'UPHENO:0088123', 'UBERON:0005423', 'UBERON:0015025', 'UPHENO:0049623', 'NBO:0000411', 'UBERON:0012354', 'UBERON:0036295', 'UPHENO:0002919', 'UPHENO:0004910', 'UPHENO:0074584', 'UBERON:0004872', 'UPHENO:0077889', 'UPHENO:0002308', 'UBERON:0005451', 'UBERON:0002390', 'UBERON:0011216', 'UBERON:0004347', 'UPHENO:0002531', 'UBERON:0004765', 'UPHENO:0076809', 'UPHENO:0084734', 'UPHENO:0002962', 'UPHENO:0063558', 'UBERON:0003134', 'UBERON:0000916', 'UPHENO:0066927', 'UBERON:0000019', 'UPHENO:0074237', 'UPHENO:0002903', 'UBERON:0010000', 'UPHENO:0002732', 'UPHENO:0086797', 'HP:0011821', 'UBERON:0011300', 'UBERON:0010538', 'UBERON:0010313', 'UPHENO:0050875', 'UPHENO:0002541', 'UPHENO:0086198', 'GO:0030099', 'UPHENO:0003432', 'UPHENO:0003038', 'UPHENO:0087510', 'HP:0008053', 'UPHENO:0002694', 'UPHENO:0003999', 'RO:0002577', 'UBERON:0002240', 'UPHENO:0003005', 'UPHENO:0002571', 'UBERON:0005876', 'HP:0033127', 'UBERON:0015001', 'BFO:0000004', 'UPHENO:0075878', 'UPHENO:0086484', 'UPHENO:0002643', 'UBERON:0004786', 'UPHENO:0004625', 'UPHENO:0005141', 'UBERON:0003840', 'UPHENO:0005092', 'HP:0008050', 'UBERON:0034925', 'GO:0043226', 'UPHENO:0005518', 'UPHENO:0033568', 'UBERON:0004535', 'HP:0001882', 'UPHENO:0002548', 'UBERON:0007375', 'UPHENO:0001135', 'HP:0009116', 'UPHENO:0068838', 'UBERON:0005256', 'HP:0002814', 'UBERON:0008962', 'UPHENO:0002905', 'UPHENO:0076703', 'HP:0000172', 'UPHENO:0002955', 'UBERON:0002005', 'GO:0032501', 'HP:0005927', 'UPHENO:0050008', 'UPHENO:0003227', 'GO:0007283', 'UBERON:0016880', 'HP:0011121', 'UBERON:0010222', 'HP:0000813', 'UBERON:0000468', 'HP:0002251', 'UBERON:0015061', 'UBERON:0001299', 'UPHENO:0002704', 'UBERON:0013701', 'UPHENO:0004064', 'UBERON:0010758', 'HP:0006496', 'UPHENO:0004802', 'UPHENO:0002597', 'UPHENO:0002844', 'UBERON:0010312', 'UPHENO:0004892', 'UBERON:0003126', 'UBERON:0010230', 'UPHENO:0088337', 'UPHENO:7000342', 'UBERON:0013522', 'UBERON:0005358', 'UPHENO:0076729', 'HP:0002818', 'HP:0002813', 'UPHENO:0000509', 'UPHENO:0005231', 'CL:0002242', 'UBERON:0004573', 'UPHENO:0001440', 'UPHENO:0063794', 'UBERON:0003061', 'HP:0012443', 'UPHENO:0004457', 'UPHENO:0001072', 'UPHENO:0087660', 'UPHENO:0002747', 'UBERON:0006598', 'UBERON:0002102', 'UPHENO:0041644', 'UBERON:0002428', 'UPHENO:0001303', 'UPHENO:0026529', 'UPHENO:0002422', 'GO:0030587', 'UPHENO:0004721', 'UBERON:0004151', 'BFO:0000002', 'HP:0000453', 'UPHENO:0004503', 'UPHENO:0005994', 'UPHENO:0002818', 'UPHENO:0046483', 'UBERON:0001084', 'UBERON:0011250', 'HP:0000316', 'UBERON:0000047', 'HP:0002031', 'HP:0004325', 'UBERON:0012430', 'UBERON:0012475', 'UPHENO:0003070', 'UPHENO:0003410', 'UPHENO:0069046', 'HP:0001167', 'UPHENO:0002896', 'NBO:0000416', 'UBERON:0008814', 'UBERON:0000466', 'UBERON:0019264', 'HP:0100022', 'UBERON:0011249', 'UBERON:0010314', 'UPHENO:0003049', 'UPHENO:0081141', 'UPHENO:0011845', 'UPHENO:0086546', 'UPHENO:7000774', 'UPHENO:0033602', 'UBERON:0007688', 'UPHENO:0003001', 'UBERON:0000923', 'HP:0008669', 'UPHENO:0081786', 'UPHENO:0004173', 'UBERON:0000033', 'UBERON:0007798', 'HP:0100886', 'UPHENO:0086635', 'UPHENO:0079828', 'HP:0000478', 'UBERON:0004456', 'UPHENO:0004519', 'UPHENO:0002870', 'UBERON:0003133', 'UPHENO:0002868', 'UBERON:0003464', 'UPHENO:0002559', 'UBERON:0001981', 'UPHENO:0002902', 'UPHENO:0075919', 'UPHENO:0003812', 'UPHENO:0002792', 'UPHENO:0002814', 'UBERON:0002105', 'UBERON:0000955', 'HP:0009115', 'UPHENO:0031254', 'UPHENO:0084448', 'HP:0011842', 'HP:0002118', 'GO:0048609', 'UPHENO:0003488', 'UBERON:5101466', 'UPHENO:0025401', 'UBERON:0003059', 'UBERON:0003056', 'UPHENO:0076692', 'GO:0043231', 'UPHENO:0033592', 'UPHENO:0076739', 'GO:0005622', 'UBERON:5002544', 'UPHENO:0049966', 'UBERON:0002329', 'UPHENO:0082875', 'HP:0002664', 'UPHENO:0046755', 'UPHENO:0076740', 'HP:0000924', 'UPHENO:0002269', 'UBERON:0002529', 'UPHENO:0033626', 'UBERON:0011779', 'UPHENO:0002830', 'HP:0011004', 'HP:0410008', 'UBERON:0012357', 'UPHENO:0002632', 'HP:0000864', 'UPHENO:0014285', 'UPHENO:0002600', 'UPHENO:0002983', 'UPHENO:0086048', 'UBERON:0000465', 'HP:0002011', 'UBERON:0016526', 'UPHENO:0005986', 'UBERON:0002101', 'HP:0000119', 'UBERON:0006601', 'UBERON:0010188', 'UBERON:0003102', 'UPHENO:0026404', 'UBERON:0015203', 'UPHENO:0086633', 'UBERON:0004288', 'UBERON:0000026', 'UPHENO:0031124', 'GO:0009605', 'HP:0000366', 'UPHENO:0004482', 'UPHENO:0072185', 'UPHENO:0011531', 'UBERON:0007272', 'HP:0011545', 'UPHENO:0005437', 'UPHENO:7000632', 'UPHENO:0072359', 'UPHENO:0049756', 'UPHENO:0004418', 'HP:0002863', 'UPHENO:0008958', 'HP:0000118', 'UBERON:0015833', 'UBERON:0001016', 'UPHENO:0026407', 'HP:0007400', 'UPHENO:0068898', 'UPHENO:0084767', 'UBERON:0004710', 'UBERON:0002108', 'HP:0001654', 'HP:0100691', 'UPHENO:0041041', 'UPHENO:0069119', 'HP:0009122', 'UPHENO:0008850', 'UBERON:0010708', 'UPHENO:0002764', 'UBERON:0000061', 'UPHENO:0002708', 'UPHENO:0088319', 'UPHENO:0005166', 'HP:0001507', 'UBERON:0003077', 'UBERON:0002342', 'HP:0031816', 'UPHENO:0002746', 'HP:0031826', 'UPHENO:0088170', 'UPHENO:0001002', 'UPHENO:0031227', 'UBERON:0016548', 'UPHENO:0003085', 'NCBITaxon:6072', 'UBERON:0000947', 'UBERON:0002553', 'UPHENO:0002872', 'UPHENO:0005058', 'NBO:0000389', 'UBERON:0000483', 'HP:0001199', 'UBERON:0002050', 'HP:0002023', 'UPHENO:0081574', 'GO:0050879', 'UPHENO:0086088', 'UBERON:0015204', 'UBERON:0003620', 'UPHENO:0080079', 'HP:0001511', 'UBERON:0003834', 'GO:0001841', 'HP:0000174', 'UPHENO:0004469', 'UPHENO:0087347', 'UPHENO:0076727', 'HP:0001881', 'UPHENO:0002701', 'UPHENO:7000208', 'UPHENO:0069327', 'GO:0003008', 'UBERON:0001733', 'UPHENO:0002593', 'UBERON:5003625', 'UBERON:0010130', 'HP:0001373', 'HP:0012745', 'GO:0007610', 'UPHENO:0035151', 'UPHENO:0003236', 'UPHENO:0011538', 'UPHENO:0005206', 'UPHENO:0002552', 'UPHENO:0088116', 'UBERON:0002104', 'UBERON:0010363', 'UPHENO:0082905', 'UBERON:0007005', 'UPHENO:0068912', 'UPHENO:0087367', 'UPHENO:0086614', 'UPHENO:0080010', 'UBERON:0005881', 'UPHENO:0004513', 'UPHENO:0052778', 'UBERON:0002398', 'UPHENO:0002371', 'UBERON:0004708', 'UPHENO:0067645', 'UPHENO:0086769', 'UPHENO:7000428', 'UBERON:0005623', 'UBERON:0002204', 'UPHENO:0072195', 'UPHENO:0005356', 'HP:0002921', 'UPHENO:3000004', 'UPHENO:0087006', 'UBERON:0034713', 'UPHENO:0002945', 'UBERON:0001440', 'UPHENO:0069328', 'UBERON:0001530', 'UPHENO:0002650', 'UPHENO:0076760', 'UPHENO:0001392', 'UPHENO:0052159', 'HP:0000347', 'UBERON:0003081', 'UPHENO:0087852', 'UBERON:0003071', 'UBERON:0002349', 'UPHENO:0002906', 'UPHENO:0075997', 'UBERON:0002470', 'UPHENO:0001003', 'UPHENO:0002782', 'UPHENO:0002715', 'UPHENO:0002360', 'HP:0031105', 'UPHENO:0086172', 'UBERON:0000179', 'UBERON:0011584', 'HP:0011024', 'UBERON:0000946', 'UBERON:0004756', 'UBERON:0008785', 'UPHENO:0002554', 'HP:0100587', 'UPHENO:0087974', 'UPHENO:0002808', 'CL:0000000', 'HP:0007364', 'UBERON:0005291', 'UPHENO:0078742', 'UPHENO:0072194', 'UPHENO:0002712', 'UPHENO:0003163', 'HP:0006265', 'UPHENO:0005596', 'UPHENO:0086487', 'UBERON:0002331', 'UBERON:0001017', 'UPHENO:0002954', 'UPHENO:0031194', 'BFO:0000001', 'UPHENO:0068839', 'UPHENO:0002574', 'UPHENO:0087089', 'UBERON:0004053', 'UBERON:0007830', 'UPHENO:7000595', 'UBERON:0004381', 'UPHENO:0086486', 'UPHENO:0002525', 'HP:0040069', 'UBERON:0000075', 'UPHENO:0003019', 'HP:0000707', 'UPHENO:0084761', 'NBO:0000313', 'HP:0011297', 'UPHENO:0079876', 'UBERON:0003104', 'UPHENO:0078179', 'HP:0025031', 'UPHENO:0005515', 'UPHENO:0004459', 'UPHENO:0081570', 'UPHENO:0004757', 'UPHENO:0004831', 'UBERON:0001460', 'UPHENO:0011901', 'HP:0011017', 'UBERON:0002544', 'HP:0010987', 'HP:0002575', 'UPHENO:0002568', 'UPHENO:0002864', 'UPHENO:0072414', 'BFO:0000040', 'UPHENO:0003189', 'HP:0040064', 'UPHENO:0000543', 'UPHENO:0003366', 'UPHENO:0080165', 'UPHENO:0002949', 'UPHENO:0004881', 'UBERON:0001809', 'UPHENO:0003550', 'HP:0001924', 'UBERON:0012141', 'UPHENO:0001101', 'UPHENO:0002861', 'UPHENO:0003334', 'UPHENO:0081424', 'UBERON:0004089', 'UPHENO:0087294', 'UPHENO:0080126', 'UPHENO:0004829', 'UPHENO:0081581', 'UPHENO:7000280', 'CL:0000738', 'UPHENO:0077418', 'UBERON:0007524', 'UPHENO:0002586', 'UPHENO:0080200', 'UPHENO:0003827', 'UPHENO:0054957', 'UPHENO:0004885', 'UPHENO:0041083', 'UPHENO:0083161', 'UPHENO:0046487', 'BFO:0000003', 'GO:0043229', 'UBERON:0000178', 'UPHENO:0025109', 'UBERON:0007503', 'UBERON:0010712', 'UPHENO:0005172', 'UPHENO:0087472', 'UBERON:0004357', 'UBERON:0001457', 'UBERON:0005061', 'HP:0025015', 'UPHENO:0004476', 'GO:0050953', 'UPHENO:0003095', 'UPHENO:0004680', 'UPHENO:0011708', 'UPHENO:0078629', 'UPHENO:0005110', 'UPHENO:0002721', 'UBERON:0000463', 'UBERON:0011158', 'UBERON:0000167', 'UBERON:0000926', 'UPHENO:0002891', 'UPHENO:0005170', 'UPHENO:0088049', 'UPHENO:0076723', 'UBERON:0003607', 'UPHENO:0002656', 'UPHENO:0002536', 'UPHENO:0004621', 'UBERON:0004572', 'HP:0001551', 'UPHENO:0011498', 'UPHENO:0004475', 'UBERON:0004375', 'UBERON:0002193', 'UBERON:0004120', 'UPHENO:0079835', 'UPHENO:0075198', 'UBERON:0000922', 'UBERON:0000383', 'UPHENO:0076694', 'UPHENO:0069266', 'HP:0000202', 'HP:0002414', 'UPHENO:0087846', 'UPHENO:0002976', 'UBERON:0000949', 'UPHENO:0087232', 'HP:0012733', 'UBERON:0010371', 'UBERON:0000479', 'UPHENO:0002553', 'UPHENO:0049587', 'HP:0040068', 'HP:0000163', 'BFO:0000015', 'UPHENO:0075220', 'UPHENO:0049874', 'UPHENO:7000376', 'UPHENO:0046445', 'GO:0008150', 'UPHENO:0002899', 'HP:0000315', 'GO:0050896', 'UBERON:0011156', 'UPHENO:0051150', 'UBERON:0004092', 'HP:0006101', 'UPHENO:0088140', 'UPHENO:0003799', 'UPHENO:0076697', 'UBERON:0012360', 'UPHENO:0087907', 'UPHENO:0072264', 'HP:0001627', 'UPHENO:0074228', 'HP:0032251', 'UPHENO:0025875', 'NBO:0000403', 'UPHENO:0003116', 'UPHENO:0001147', 'UBERON:0003498', 'UBERON:0000055', 'HP:0000505', 'HP:0009815', 'UPHENO:0085330', 'UPHENO:0049590', 'UBERON:0004119', 'UBERON:0010191', 'HP:0005922', 'HP:0001626', 'UBERON:0010323', 'GO:0060606', 'UPHENO:0051276', 'UPHENO:0002880', 'HP:0000818', 'UPHENO:7000875', 'UBERON:0003625', 'UPHENO:0001304', 'UPHENO:0001584', 'HP:0000929', 'UBERON:0000164', 'UPHENO:0018424', 'UBERON:0001048', 'UPHENO:0002733', 'UPHENO:0081314', 'UBERON:0005417', 'UBERON:0001805', 'HP:0011844', 'UBERON:0001637', 'UPHENO:0074227', 'HP:0000271', 'UBERON:0000924', 'UBERON:0001062', 'UBERON:0003129', 'UPHENO:0063722', 'UPHENO:0004888', 'UBERON:0004905', 'UPHENO:0003446', 'UPHENO:0002928', 'UPHENO:0005025', 'UPHENO:0083646', 'UPHENO:0002761', 'UBERON:0000307', 'UPHENO:0086485', 'UPHENO:0072200', 'UBERON:0001332', 'UBERON:0013765', 'UPHENO:0012440', 'UBERON:0001353', 'UBERON:0006800', 'UPHENO:0087892', 'UBERON:0001032', 'UPHENO:0015324', 'HP:0012547', 'UBERON:0000117', 'UPHENO:0072266', 'HP:0000481', 'UBERON:0000062', 'UPHENO:7000183', 'UPHENO:0002530', 'UPHENO:0002754', 'UPHENO:0088132', 'HP:0000175', 'UBERON:0000490', 'HP:0002246', 'UPHENO:0003100', 'UBERON:0000925', 'UPHENO:0026327', 'HP:0012252', 'UPHENO:0002850', 'UBERON:0002199', 'HP:0025354', 'UBERON:0002097', 'GO:0043473', 'UPHENO:0074575', 'UPHENO:0066972', 'UPHENO:0033560', 'UBERON:0005409', 'UPHENO:0054970', 'UPHENO:0084770', 'UBERON:0001555', 'UPHENO:0086621', 'UPHENO:0076803', 'UPHENO:0087530', 'UPHENO:0080087', 'HP:0025033', 'UPHENO:0003058', 'UBERON:0006314', 'UPHENO:0003413', 'UBERON:0016525', 'UPHENO:0004518', 'UPHENO:0002378', 'HP:0031704', 'UBERON:0002513', 'UBERON:0002114', 'UPHENO:0003004', 'CL:0000019', 'HP:0003330', 'UBERON:0000025', 'UBERON:0000964', 'GO:0050905', 'UBERON:0001007', 'UPHENO:0068848', 'UBERON:0002020', 'HP:0100867', 'UBERON:5002389', 'UPHENO:0003093', 'UBERON:0001155', 'UBERON:0001890', 'UPHENO:0002546', 'UPHENO:0026279', 'UPHENO:0081594', 'UBERON:0003278', 'UPHENO:0003415', 'UBERON:0004921', 'UPHENO:0002725', 'UPHENO:0049664', 'UPHENO:0071310', 'HP:0002242', 'HP:0001643', 'UPHENO:0002859', 'UPHENO:0078730', 'UPHENO:0002948', 'HP:0012718', 'UPHENO:0086482', 'HP:0004328', 'UPHENO:0002957', 'HP:0012848', 'UPHENO:0086858', 'UPHENO:0002639', 'UPHENO:0087612', 'UBERON:0005181', 'HP:0000047', 'UPHENO:0002832', 'UBERON:0015228', 'UBERON:0005337', 'UPHENO:0002263', 'UPHENO:0002634', 'UPHENO:0033565', 'HP:0001172', 'UPHENO:7000267', 'UBERON:0002365', 'UPHENO:0004386', 'UPHENO:0075949', 'HP:0002715', 'UPHENO:0035147', 'UPHENO:0086824', 'UBERON:0001167', 'UPHENO:0087070', 'UPHENO:0004405', 'UPHENO:0004403', 'UPHENO:0005080', 'HP:0100736', 'UBERON:0002084', 'UPHENO:0087186', 'UPHENO:0004827', 'UBERON:0002091', 'UPHENO:0004360', 'HP:0001671', 'UBERON:0035553', 'UBERON:0009569', 'UPHENO:0075945', 'UBERON:0004771', 'UBERON:0005156', 'UBERON:0012275', 'UBERON:0002082', 'HP:0002250', 'UPHENO:0086492', 'UBERON:0003978', 'UPHENO:0076805', 'UPHENO:0005285', 'UPHENO:0003092', 'UPHENO:0002901', 'UBERON:0003914', 'HP:0012639', 'NBO:0000001', 'UBERON:0009881', 'UBERON:0004248', 'HP:0000951', 'UPHENO:0076810', 'UPHENO:0052675', 'UBERON:0007285', 'UBERON:0002137', 'UPHENO:0002944', 'UPHENO:0080300', 'UPHENO:7000372', 'UPHENO:0003066', 'UBERON:0005177', 'HP:0001871', 'UBERON:0003103', 'UPHENO:0002246', 'UPHENO:0003084', 'UPHENO:0003828', 'GO:0009653', 'UPHENO:0002523', 'UPHENO:0003086', 'UPHENO:0002964', 'HP:0001646', 'UPHENO:0056250', 'UBERON:0036146', 'UPHENO:0086680', 'UBERON:0004140', 'UBERON:0004141', 'UBERON:0001456', 'UPHENO:0001001', 'UBERON:0001041', 'UPHENO:0053330', 'UPHENO:0046403', 'UBERON:0005178', 'UPHENO:0004616', 'UBERON:0005956', 'UPHENO:0076743', 'UPHENO:0001360', 'UPHENO:0005230', 'UBERON:0003084', 'UBERON:0000153', 'UBERON:0015410', 'UPHENO:0004615', 'UPHENO:0009163', 'BFO:0000141', 'UPHENO:0027017', 'UPHENO:0001570', 'UPHENO:0004962', 'UPHENO:0002550', 'UPHENO:0001454', 'HP:0030962', 'UBERON:0000915', 'UPHENO:0087022', 'UPHENO:0001004', 'UPHENO:0041667', 'UPHENO:0002838', 'UPHENO:0033599', 'HP:0000508', 'UPHENO:0041410', 'UBERON:0003462', 'UPHENO:0005106', 'UPHENO:0041226', 'UBERON:0000004', 'UPHENO:0087802', 'HP:0002119', 'HP:5201015', 'UPHENO:0087423', 'UPHENO:0033635', 'UPHENO:0004509', 'UPHENO:0033612', 'UBERON:0010316', 'UPHENO:0004262', 'UPHENO:0002828', 'UPHENO:0001213', 'UPHENO:0075998', 'UBERON:0000165', 'UPHENO:0002777', 'UPHENO:0004520', 'UPHENO:0076704', 'UBERON:0000978', 'UPHENO:7000055', 'UBERON:0002346', 'UPHENO:0004443', 'UBERON:0001709', 'UPHENO:0076786', 'UPHENO:0003414', 'HP:0002244', 'UPHENO:0025146', 'UPHENO:3000000', 'UBERON:0011595', 'UPHENO:0002816', 'UBERON:0008907', 'HP:0010972', 'UBERON:0004175', 'UPHENO:0076800', 'UPHENO:0004900', 'UPHENO:0025637', 'HP:0010301', 'HP:0000153', 'UPHENO:0075655', 'UBERON:0009617', 'CL:0000219', 'UPHENO:0087585', 'GO:0008152', 'UPHENO:7000149', 'HP:0010468', 'UBERON:0001442', 'UPHENO:0002685', 'UPHENO:0087806', 'UBERON:0000990', 'UPHENO:0003015', 'HP:0032101', 'UBERON:0005440', 'UBERON:0000166', 'UBERON:0004122', 'UPHENO:0069161', 'UBERON:0012140', 'UBERON:0003100', 'UPHENO:7000297', 'UBERON:0012139', 'UPHENO:0003055', 'GO:0042756', 'UPHENO:0087547', 'HP:0012243', 'UBERON:0005983', 'UPHENO:0002642', 'UPHENO:0041151', 'NBO:0000417', 'UPHENO:0003053', 'UBERON:0004139', 'HP:0010460', 'UPHENO:0002687', 'UPHENO:0001154', 'HP:0000078', 'UPHENO:0004709', 'UBERON:0000072', 'UPHENO:0086121', 'UPHENO:0071326', 'UPHENO:0002598', 'UPHENO:0005022', 'HP:0001763', 'HP:0000130', 'UPHENO:0010850', 'UPHENO:0002547', 'UPHENO:0076766', 'UBERON:0013515', 'UBERON:0004761', 'UBERON:0000993', 'UBERON:0002410', 'HP:0000008', 'UPHENO:0079837', 'UBERON:0013768', 'UPHENO:0004956', 'UPHENO:0002977', 'UPHENO:0002875', 'UBERON:0000995', 'UPHENO:0077373', 'HP:0040195', 'HP:0001999', 'HP:0001537', 'UPHENO:0084771', 'UPHENO:0081575', 'UPHENO:0003065', 'UPHENO:0004521', 'UPHENO:0087121', 'HP:0010461', 'UPHENO:0026010', 'UPHENO:0004401', 'UPHENO:0075804', 'UBERON:0011137', 'HP:0012211', 'UPHENO:0063595', 'UPHENO:0003177', 'UBERON:0007914', 'UPHENO:0004828', 'UPHENO:0053563', 'UBERON:0011138', 'UPHENO:0075148', 'HP:0002060', 'UPHENO:0002570', 'UPHENO:0076799', 'UPHENO:0069236', 'UBERON:0000064', 'UPHENO:0003811', 'UBERON:0000073', 'UBERON:0003080', 'UPHENO:0002833', 'UPHENO:0076702', 'UBERON:0009145', 'UPHENO:0002971', 'UPHENO:0087363', 'UPHENO:0075873', 'UBERON:0012150', 'UBERON:0000948', 'UBERON:0005944', 'UPHENO:0086159', 'UBERON:0002090', 'UPHENO:0002381', 'UPHENO:0005104', 'UBERON:0002616', 'UBERON:0010913', 'UPHENO:0002736', 'UBERON:0004770', 'HP:0002977', 'UPHENO:0075995', 'UPHENO:0081598', 'UPHENO:0003050', 'UPHENO:0069352', 'UPHENO:0076791', 'HP:0009121', 'UBERON:0002268', 'UPHENO:0069149', 'UBERON:0001711', 'HP:0000240', 'UBERON:0001049', 'UPHENO:0067691', 'UBERON:0002355', 'UBERON:0002389', 'UBERON:8450002', 'UPHENO:0085874', 'UPHENO:0071337', 'UPHENO:0002448', 'UBERON:0001008', 'UPHENO:0041033', 'UPHENO:0087578', 'HP:0000080', 'HP:0000144', 'UPHENO:0071315', 'UPHENO:0087597', 'UPHENO:0081435', 'HP:0005344', 'UPHENO:0087663', 'UBERON:0001638', 'UPHENO:3000003', 'UPHENO:0002952', 'UPHENO:0063581', 'UBERON:0001043', 'UBERON:0000065', 'UPHENO:0014292', 'UPHENO:0087433', 'UPHENO:0088162', 'CL:0000763', 'UPHENO:0004891', 'UPHENO:0002388', 'UPHENO:0086144', 'HP:0000811', 'UPHENO:0005177', 'UPHENO:0087478', 'HP:0004377', 'UPHENO:0002987', 'UPHENO:0002434', 'UBERON:0004908', 'UPHENO:0076785', 'HP:0005607', 'GO:0060429', 'UPHENO:0002734', 'UPHENO:0004486', 'UBERON:0000079', 'UBERON:0001004', 'UPHENO:0086792', 'UPHENO:0074229', 'UPHENO:0076798', 'UPHENO:0002529', 'UBERON:0002075', 'UBERON:0005911', 'UPHENO:0087662', 'UPHENO:0079539', 'UPHENO:0079839', 'UBERON:0034923', 'UPHENO:7000359', 'HP:0200005', 'UPHENO:7000623', 'UPHENO:0087359', 'UPHENO:0087518', 'UPHENO:0086717', 'UBERON:0000945', 'UPHENO:0053456', 'UPHENO:0084829', 'UPHENO:0004481', 'UBERON:0010707', 'UPHENO:0003605', 'HP:0000218', 'UBERON:0007196', 'UBERON:0003947', 'HP:0002086', 'UPHENO:0002907', 'UBERON:0002530', 'UBERON:0008811', 'UBERON:0001005', 'UBERON:0015030', 'UPHENO:0002731', 'UPHENO:0003405', 'UBERON:0004582', 'UBERON:0001132', 'UBERON:0003920', 'UPHENO:0002659', 'UPHENO:0053571', 'HP:0001710', 'UPHENO:0076761', 'HP:0002778', 'UBERON:0003258', 'UBERON:0001021', 'UPHENO:0076752', 'UPHENO:0002940', 'UPHENO:0003056', 'GO:0009790', 'UPHENO:0002579', 'UPHENO:0002261', 'UPHENO:0075159', 'UPHENO:0080114', 'UPHENO:0001134', 'UPHENO:0001340', 'UPHENO:7000182', 'UBERON:0008784', 'UPHENO:0005029', 'UBERON:0004923', 'UBERON:0000060', 'UPHENO:0088047', 'UPHENO:0075175', 'UBERON:0003221', 'UBERON:0005282', 'UPHENO:0002562', 'UPHENO:0001355', 'UPHENO:0002567', 'UPHENO:0005008', 'UPHENO:0003021', 'HP:0012372', 'HP:0002012', 'UBERON:0001893', 'UPHENO:0004261', 'UBERON:0005867', 'UPHENO:7000299', 'UPHENO:0002526', 'UBERON:0004768', 'HP:0010936', 'UPHENO:0087344', 'UBERON:0005281', 'HP:0000812', 'UBERON:0001684', 'HP:0100547', 'HP:0011793', 'UPHENO:0075890', 'UPHENO:0084654', 'UBERON:0004742', 'UPHENO:0068932', 'UPHENO:0087404', 'HP:0009118', 'UPHENO:0084457', 'HP:0000152', 'UBERON:0034944', 'UBERON:0000981', 'UPHENO:0004525', 'UPHENO:0081091', 'UPHENO:0031125', 'GO:0035295', 'UPHENO:0002804', 'UPHENO:0009209', 'UBERON:5102389', 'UBERON:0003113', 'UPHENO:0002815', 'UBERON:0007842', 'UBERON:0002514', 'HP:0030791', 'UBERON:8450003', 'HP:0001939', 'UBERON:0012151', 'CL:0000329', 'UBERON:0004128', 'UPHENO:0005257', 'UPHENO:0081788', 'UPHENO:0086518', 'HP:0000002', 'UPHENO:0087661', 'UBERON:0005062', 'UPHENO:0063594', 'UBERON:0000473', 'UBERON:0012314', 'UBERON:0001708', 'UBERON:0002539', 'UPHENO:0002564', 'UBERON:0001710', 'UBERON:0003457', 'UPHENO:0087558', 'HP:0000277', 'HP:0001155', 'UPHENO:0076724', 'UBERON:0003101', 'UPHENO:0002988', 'UBERON:0010364', 'UPHENO:0087228', 'UPHENO:0053561', 'UBERON:0001716', 'UPHENO:7000069', 'UPHENO:0046505', 'UPHENO:0053566', 'UPHENO:7000206', 'UPHENO:0003182', 'UPHENO:0002682', 'UPHENO:0002910', 'UPHENO:0053580', 'UPHENO:0053644', 'HP:0000035', 'UPHENO:0077885', 'UPHENO:0003101', 'UPHENO:0053647', 'HP:0000028', 'UPHENO:0083637', 'HP:0000032', 'UBERON:0000991', 'CL:0000764', 'UPHENO:0084763', 'UBERON:0003135', 'GO:0040007', 'UBERON:0004176', 'UPHENO:0002393', 'UPHENO:0085881', 'UPHENO:0025941', 'UPHENO:0056150', 'UPHENO:0005016', 'UPHENO:0053572', 'UBERON:0004537', 'UPHENO:0009021', 'HP:0011277', 'CL:0000586', 'HP:0010978', 'HP:0000010', 'HP:0002719', 'UPHENO:0027014', 'UPHENO:0008781', 'UPHENO:0008523', 'UBERON:0019231', 'UPHENO:0003082', 'UPHENO:0026148', 'UPHENO:0005055', 'UPHENO:0026506', 'GO:0002376', 'UPHENO:0003514', 'UPHENO:0026146', 'UPHENO:0003094', 'UPHENO:0011533', 'UPHENO:0025243', 'HP:0010469', 'GO:0110165', 'UBERON:0005162', 'UPHENO:0011485', 'UPHENO:0085478', 'UBERON:0000467', 'UPHENO:0008960', 'UPHENO:0033584', 'UBERON:0012469', 'HP:0045058', 'NBO:0000444', 'UPHENO:0081566', 'UPHENO:0009154', 'UPHENO:0011572', 'UBERON:0006058', 'UPHENO:0002678', 'UPHENO:0009020', 'GO:0050881', 'UPHENO:0026149', 'UPHENO:0003198', 'UPHENO:0002866', 'UBERON:0000323', 'UBERON:0008001', 'UBERON:0004086', 'HP:0000252', 'HP:0001562', 'HP:0001560', 'UPHENO:0087849', 'UPHENO:0053559', 'UPHENO:3000001', 'UBERON:0000173', 'UBERON:0001444', 'HP:0001197', 'UPHENO:0084124', 'UPHENO:0075852', 'UPHENO:0072345', 'UBERON:0002330', 'UPHENO:0002926', 'UBERON:0005173', 'UPHENO:0004061', 'UBERON:0002107', 'UBERON:0002423', 'UPHENO:0002780', 'UBERON:0001785', 'UPHENO:0002756', 'UBERON:0005172', 'UPHENO:0072402', 'UPHENO:0087387', 'UBERON:0002416', 'UBERON:0002417', 'UBERON:0000475', 'HP:0009602', 'UBERON:0001819', 'UBERON:0005419', 'UBERON:0005897', 'UBERON:5102544', 'UBERON:5001463', 'UPHENO:0087924', 'UBERON:0000481', 'UBERON:0011676', 'UBERON:0001463', 'GO:0048729', 'UBERON:0004876', 'UBERON:0015024', 'GO:0007276', 'UBERON:0003338', 'UBERON:0015023', 'UBERON:5101463', 'UPHENO:0003069', 'UBERON:5106048', 'UBERON:0010688', 'UBERON:0018260', 'UBERON:0004249', 'UBERON:0002495', 'UBERON:0012358', 'UBERON:0006048', 'UPHENO:0002767', 'UPHENO:0033593', 'UBERON:0010741', 'UBERON:0003606'], 'has_phenotype_closure_label': ['increased height of the multi-tissue structure', 'increased height of the anatomical structure', 'increased height of the multicellular anatomical structure', 'Abnormal cerebrospinal fluid morphology', 'increased number of ventricle of nervous system in the cerebrospinal fluid', 'cerebrospinal fluid phenotype', 'increased number of anatomical structure in the cerebrospinal fluid', 'Hydrocephalus', 'number of anatomical enitites of type organ part phenotype', 'increased number of brain ventricle/choroid plexus in the cerebrospinal fluid', 'increased number of brain ventricle', 'increased number of organ part in the cerebrospinal fluid', 'vascular plexus', 'head or neck skin', 'increased length of the anatomical structure', 'increased length of the zone of skin', 'compound organ physiology phenotype', 'increased length of the head or neck skin', 'increased length of the zone of organ', 'skin of face', 'increased length of the material anatomical entity', 'Abnormality of refraction', 'curved anatomical entity', 'buphthalmos', 'structure with developmental contribution from neural crest, curved phenotype', 'shape of cornea phenotype', 'increased size of the structure with developmental contribution from neural crest', 'Astigmatism', 'multicellular anatomical structure, curved phenotype', 'shape of forehead phenotype', 'Bicornuate uterus', 'bicornuate uterus', 'shape of uterus phenotype', 'Conotruncal defect', 'sloped forehead', 'Tetralogy of Fallot', 'layer of muscle tissue', 'increased length of the skin of face', 'decreased functionality of the myocardium', 'layer of muscle tissue phenotype', 'myocardium phenotype', 'Abnormal myocardium morphology', 'Renal insufficiency', 'myocardium morphology phenotype', 'multicellular anatomical structure mass phenotype', 'decreased anatomical structure mass', 'Abnormality of body weight', 'anatomical entity mass phenotype', 'Decreased multicellular organism mass', 'gut wall', 'Cardiomyopathy', 'incomplete closing of the skeletal element', 'vertebra morphology phenotype', 'dorsum', 'Abnormal neural tube morphology', 'Neural tube defect', 'incomplete closing of the arch of centrum of vertebra', 'Spina bifida', 'mucosa of stomach morphology phenotype', 'zone of skin', 'dorsal region element phenotype', 'vertebral element', 'mucosa phenotype', 'increased number of organ component layer in the cerebrospinal fluid', 'skin of head morphology phenotype', 'vertebral element phenotype', 'cartilage element phenotype', 'Abnormal spinal cord morphology', 'Spinal dysraphism', 'incomplete closing of the organ', 'cartilaginous condensation', 'spina bifida', 'increased number of anatomical structure', 'Arteriovenous malformation', 'increased number of hematopoietic cell', 'increased number of anatomical entity', 'arteriovenous malformation', 'increased number of erythrocyte', 'heart primordium morphology', 'urethral opening', 'lower urinary tract', 'primitive urogenital sinus', 'kinetochore organization; kinetochore organization variant', 'morphology of chromosome phenotype', 'cavitated compound organ physiology phenotype', 'cloaca phenotype', 'cellular anatomical structure', 'morphology of intracellular organelle phenotype', 'male urethral meatus', 'intracellular anatomical structure', 'membraneless organelle', 'intracellular organelle', 'membrane-bounded organelle', 'chromosome', 'nucleus', 'urethral meatus', 'morphology of cellular_component phenotype', 'urethra morphology phenotype', 'lower urinary tract phenotype', 'increased length of the structure with developmental contribution from neural crest', 'urethral meatus morphology phenotype', 'sensory perception of mechanical stimulus phenotype', 'sensory perception of sound phenotype', 'ear physiology phenotype', 'decreased qualitatively sensory perception of mechanical stimulus', 'Hearing abnormality', 'decreased size of the eyeball of camera-type eye', 'size of eyeball of camera-type eye phenotype', 'decreased size of the sense organ', 'Abnormality of globe size', 'decreased qualitatively multicellular organism development', 'decreased qualitatively embryo development', 'decreased multicellular organismal process', 'decreased embryo development', 'girdle skeleton', 'pelvic girdle skeleton phenotype', 'zone of bone organ phenotype', 'mesenchyme from somatopleure phenotype', 'abdominal segment bone', 'girdle skeleton phenotype', 'Hip dislocation', 'hindlimb joint', 'synovial joint of pelvic girdle', 'synovial joint of pelvic girdle morphology phenotype', 'trunk bone', 'hip joint phenotype', 'skeletal joint', 'hip', 'appendage girdle region', 'pelvic girdle region', 'anatomical entity dislocation', 'synovial joint', 'pelvic girdle bone/zone', 'trunk bone phenotype', 'abdominal segment bone phenotype', 'joint of girdle morphology phenotype', 'articulation', 'Lower extremity joint dislocation', 'decreased size of the material anatomical entity in the pectoral complex', 'decreased size of the anatomical entity in the pectoral complex', 'forehead morphology phenotype', 'increased number of cell', 'decreased anatomical structure development', 'forelimb zeugopod bone hypoplasia', 'decreased size of the anatomical structure in the pectoral complex', 'decreased size of the bone of pectoral complex', 'Forearm undergrowth', 'decreased length of forelimb zeugopod bone', 'decreased size of the arm bone', 'decreased length of arm bone', 'decreased length of bone of free limb or fin', 'decreased length of bone element', 'Upper limb undergrowth', 'decreased size of the forelimb endochondral element', 'Limb undergrowth', 'decreased length of organ', 'increased size of the eyeball of camera-type eye', 'decreased size of the bone of free limb or fin', 'synovial joint phenotype', 'Hypoplasia of the ulna', 'aplasia or hypoplasia of ulna', 'decreased size of the limb endochondral element', 'cranial nerve phenotype', 'nerve of head region phenotype', 'Abnormal cranial nerve physiology', 'paralysed cranial nerve', 'shape of palpebral fissure phenotype', 'Almond-shaped palpebral fissure', 'Abnormal shape of the palpebral fissure', 'opaque anatomical entity', 'lens of camera-type eye phenotype', 'lens of camera-type eye morphology phenotype', 'fused pedal digit and anatomical entity', 'fused anatomical entity and pedal digit', 'Toe syndactyly', 'Abnormal localization of kidney', 'decreased biological_process in multicellular organism', 'Hypopigmentation of the skin', 'decreased size of the endochondral bone', 'Abnormal choanae morphology', 'increased size of the multi-tissue structure', 'posterior nasal aperture phenotype', 'Abnormal nasal morphology', 'naris atresia', 'internal naris atresia', 'posterior nasal aperture', 'olfactory system', 'decreased size of the forelimb zeugopod bone', 'nerve of head region', 'internal naris', 'olfactory organ phenotype', 'posterior nasal aperture atresia', 'chemosensory system', 'fused pedal digit and pedal digit', 'decreased qualitatively system process', 'sensory perception of light stimulus phenotype', 'Visual impairment', 'decreased qualitatively sensory perception', 'structure with developmental contribution from neural crest, asymmetrically curved phenotype', 'pelvic girdle skeleton', 'sensory perception', 'Abnormality of vision', 'decreased qualitatively multicellular organismal process', 'decreased qualitatively visual perception', 'hindlimb stylopod morphology phenotype', 'femur', 'High palate', 'bone of hip region phenotype', 'hindlimb stylopod', 'femur endochondral element', 'leg bone', 'pelvic girdle bone/zone phenotype', 'leg bone phenotype', 'upper leg bone phenotype', 'decreased multicellular organism development', 'fused digit and digit', 'fused manual digit and anatomical entity', 'fused anatomical entity and manual digit', 'fused anatomical entity and digit', 'fused digit and anatomical entity', 'fused manual digit and manual digit', 'fused anatomical entity and anatomical entity', 'decreased number of platelet', 'secretory cell', 'biogenic amine secreting cell', 'Choanal atresia', 'Abnormal platelet morphology', 'joint of girdle', 'cerebral amyloid angiopathy', 'platelet phenotype', 'irregular bone phenotype', 'platelet', 'Thrombocytopenia', 'neural crest-derived structure, curved phenotype', 'Abnormal platelet count', 'number of platelet phenotype', 'increased size of the mesoderm-derived structure', 'increased length of the multicellular anatomical structure', 'increased size of the tube', 'abdominal segment element physiology phenotype', 'ureter morphology phenotype', 'decreased qualitatively sensory perception of light stimulus', 'pelvic region element', 'Abnormal ureter morphology', 'ureter', 'renal pelvis/ureter', 'excretory tube phenotype', 'excretory tube', 'increased size of the excretory tube', 'increased size of the pelvic region element', 'mucosa of stomach phenotype', 'increased size of the abdominal segment element', 'cranial nerve physiology phenotype', 'Abnormality of the ureter', 'Hydroureter', 'incomplete closing of the cardiac septum', 'eyelid apraxia', 'organ part physiology phenotype', 'atrial septum morphology', 'Abnormal cardiac septum morphology', 'Abnormal uterus morphology', 'decreased sensory perception', 'septum', 'cardiac atrium phenotype', 'cardiac atrium', 'cardiac septum morphology phenotype', 'cardiac septum phenotype', 'delayed sorocarp development', 'sorocarp development phenotype', 'biological process involved in intraspecies interaction between organisms phenotype', 'interatrial septum morphology phenotype', 'anatomical structure development phenotype', 'delayed anatomical structure development', 'socially cooperative development phenotype', 'Neurodevelopmental delay', 'stomach', 'biological process involved in intraspecies interaction between organisms', 'internal male genitalia phenotype', 'number of sperm phenotype', 'decreased developmental process', 'Functional abnormality of male internal genitalia', 'absent sperm in the semen', 'germ line cell', 'haploid cell', 'decreased developmental process involved in reproduction', 'material anatomical entity, asymmetrically curved phenotype', 'decreased gamete generation', 'decreased spermatogenesis', 'absent germ cell', 'decreased multicellular organismal reproductive process', 'pelvic girdle bone/zone morphology phenotype', 'sperm', 'decreased reproductive process', 'decreased qualitatively developmental process', 'morphology of organelle phenotype', 'absent anatomical entity in the semen', 'gamete', 'internal male genitalia', 'cerebrospinal fluid', 'developmental process involved in reproduction phenotype', 'spermatogenesis', 'anatomical entity dysfunction in independent continuant', 'paralysed anatomical entity', 'Puberty and gonadal disorders', 'Abnormal male urethral meatus morphology', 'developmental process rate phenotype', 'Hypogonadism', 'decreased functionality of the gonad', 'external ectoderm morphology phenotype', 'increased size of the sense organ', 'Joint dislocation', 'decreased functionality of the reproductive organ', 'decreased functionality of the reproductive structure', 'increased size of the camera-type eye', 'reproductive structure physiology phenotype', 'reproductive organ physiology phenotype', 'decreased functionality of the material anatomical entity', 'decreased functionality of the anatomical entity', 'cognition', 'Neurodevelopmental abnormality', 'decreased male gamete generation', 'Intellectual disability', 'Abnormality of mental function', 'trunk blood vessel phenotype', 'size of camera-type eye phenotype', 'coronary vessel morphology phenotype', 'incomplete closing of the thoracic segment blood vessel', 'posterior nasal aperture morphology phenotype', 'male gamete', 'incomplete closing of the heart blood vessel', 'incomplete closing of the systemic artery', 'skin of eyelid', 'heart blood vessel', 'organ component layer physiology phenotype', 'vasculature of organ phenotype', 'incomplete closing of the trunk blood vessel', 'incomplete closing of the artery', 'thoracic segment blood vessel', 'ductus arteriosus morphology phenotype', 'coronary vessel', 'spermatogenesis phenotype', 'Patent ductus arteriosus', 'trunk blood vessel', 'anatomical structure morphology in the heart phenotype', 'vasculature of trunk', 'decreased pigmentation in multicellular organism', 'internal naris phenotype', 'Congenital malformation of the great arteries', 'male germ cell', 'Abnormal ileum morphology', 'Atrial septal defect', 'Meckel diverticulum', 'ileum', 'large intestine morphology phenotype', 'anatomical structure formation involved in morphogenesis', 'hindgut morphology phenotype', 'parasympathetic nervous system', 'tube closure phenotype', 'hindgut phenotype', 'peripheral nervous system phenotype', 'Abnormal enteric nervous system morphology', 'neural tube formation', 'hypospadia; hypospadias', 'enteric nervous system morphology', 'morphogenesis of an epithelium', 'number of anatomical enitites of type organ component layer phenotype', 'morphogenesis of embryonic epithelium', 'increased size of the colon', 'Abnormal enteric ganglion morphology', 'lower digestive tract', 'colon', 'increased size of the subdivision of digestive tract', 'internal anal region', 'Abnormal autonomic nervous system morphology', 'increased size of the subdivision of tube', 'tube morphogenesis', 'tissue morphogenesis', 'embryonic morphogenesis', 'tube development', 'system development', 'tissue development', 'colon morphology phenotype', 'neural tube closure phenotype', 'kidney morphology phenotype', 'renal system morphology phenotype', 'kidney phenotype', 'kidney', 'upper urinary tract', 'Abnormality of the upper urinary tract', 'decreased biological_process in skin of body', 'cavitated compound organ phenotype', 'aplasia or hypoplasia of radius bone', 'Aplasia/Hypoplasia of the radius', 'Aplasia/hypoplasia involving forearm bones', 'radius bone morphology phenotype', 'Scoliosis', 'Abnormal lens morphology', 'migrating mesenchyme population', 'Abnormal curvature of the vertebral column', 'epithelial vesicle', 'scoliosis', 'vertebral column morphology phenotype', 'cell condensation', 'presomitic mesoderm', 'somite', 'external ectoderm', 'vertebral column phenotype', 'developing mesenchymal condensation', 'cell condensation phenotype', 'Abnormality of the vertebral column', 'Proptosis', 'anatomical entity morphology in the pelvic complex phenotype', 'flat longitudinal arch of pes', 'Abnormal renal morphology', 'flat anatomical entity', 'increased number of organ component layer', 'curvature anatomical entity', 'frontal lobe', 'vault of skull', 'paraxial mesoderm morphology phenotype', 'development of anatomical entity phenotype', 'neurocranium phenotype', 'neurocranium bone', 'chemosensory system phenotype', 'gray matter of telencephalon', 'Abnormal spermatogenesis', 'cartilaginous neurocranium phenotype', 'decreased qualitatively nervous system process', 'presumptive paraxial mesoderm phenotype', 'frontal cortex', 'cranial nerve', 'brain gray matter', 'lens of camera-type eye', 'cerebral hemisphere gray matter', 'decreased sensory perception of mechanical stimulus', 'cartilaginous neurocranium', 'cranium', 'presumptive paraxial mesoderm', 'head mesenchyme morphology phenotype', 'lobe of cerebral hemisphere', 'neurocranium bone phenotype', 'embryo development rate phenotype', 'epithelium development', 'gray matter', 'cerebral cortex', 'shape of frontal cortex phenotype', 'forehead', 'Abnormal frontal bone morphology', 'cranium morphology phenotype', 'cerebral hemisphere', 'paraxial mesoderm', 'internal male genitalia physiology phenotype', 'head paraxial mesoderm morphology phenotype', 'multi cell part structure phenotype', 'forehead phenotype', 'prominent anatomical entity', 'nervous system cell part layer phenotype', 'pallium', 'cranial bone', 'head paraxial mesoderm', 'multi cell part structure', 'flat bone phenotype', 'cranial bone phenotype', 'frontal cortex morphology phenotype', 'central nervous system gray matter layer phenotype', 'brain gray matter phenotype', 'central nervous system cell part cluster phenotype', 'decreased size of the bone element', 'ectoderm-derived structure atresia', 'anatomical structure atresia', 'multicellular anatomical structure atresia', 'closing of the anatomical entity', 'Anal atresia', 'anus atresia', 'closing of the multicellular anatomical structure', 'anus phenotype', 'Abnormality of thrombocytes', 'Abnormal anus morphology', 'upper leg bone', 'migrating mesenchyme population phenotype', 'closing of the material anatomical entity', 'Abnormality of the anus', 'anatomical conduit atresia', 'closing of the anatomical structure', 'hemoglobin', 'ossification', 'organ system subdivision physiology phenotype', 'Reduced bone mineral density', 'anatomical entity mass density phenotype', 'lymphocyte of B lineage', 'absent sperm', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'Decreased anatomical entity mass density', 'leukocyte physiology phenotype', 'anatomical entity atresia', 'single nucleate cell', 'decreased qualitatively developmental process involved in reproduction', 'Abnormal large intestine morphology', 'bone ossification', 'Abnormal bone structure', 'cornea', 'material anatomical entity mass phenotype', 'Abnormal shape of the frontal region', 'tunica fibrosa of eyeball', 'Strabismus', 'location of camera-type eye phenotype', 'cornea phenotype', 'arm bone phenotype', 'forelimb zeugopod', 'forelimb skeleton phenotype', 'Abnormal forearm bone morphology', 'decreased length of forelimb endochondral element', 'Abnormal morphology of ulna', 'forelimb endochondral element phenotype', 'bone of pectoral complex morphology phenotype', 'gamete phenotype', 'Abnormal long bone morphology', 'zeugopod', 'forelimb zeugopod skeleton', 'forelimb zeugopod morphology phenotype', 'ulna', 'zeugopod phenotype', 'Abnormal forearm morphology', 'Abnormal upper limb bone morphology', 'increased number of myeloid cell', 'intromittent organ phenotype', 'external soft tissue zone', 'intermediate mesoderm', 'undifferentiated genital tubercle', 'embryonic cardiovascular system', 'Abnormal preputium morphology', 'external soft tissue zone phenotype', 'developing mesenchymal condensation phenotype', 'prepuce', 'embryonic cloacal fold', 'penis morphology phenotype', 'Abnormal penis morphology', 'food storage organ phenotype', 'anal region', 'trunk mesenchyme phenotype', 'prepuce of penis phenotype', 'intromittent organ', 'penis phenotype', 'pes bone phenotype', 'hindlimb bud phenotype', 'asymmetrically curved cornea', 'visual perception phenotype', 'decreased number of myeloid cell', 'digitopodium bone phenotype', 'increased size of the anatomical conduit', 'bone of pelvic complex phenotype', 'decreased length of forelimb bone', 'bone of pelvic complex', 'Decreased anatomical entity mass', 'septum phenotype', 'Clubbing of toes', 'pedal digitopodium bone', 'phalanx of pes', 'hindlimb', 'pedal digit morphology phenotype', 'neural tube development', 'pes', 'clavate digit', 'segment of pes', 'naris phenotype', 'hindlimb long bone', 'skeleton of pelvic complex', 'pelvic appendage bud', 'Abnormal pelvic girdle bone morphology', 'decreased qualitatively reproductive process', 'hindlimb skeleton phenotype', 'material anatomical entity, curved phenotype', 'phalanx phenotype', 'Global developmental delay', 'leg', 'limb joint', 'Abnormal toe phalanx morphology', 'hindlimb phenotype', '3-D shape anatomical entity', 'large intestine', 'Frontal bossing', 'pedal digit bone', 'shape of digit phenotype', 'bone of pelvic complex morphology phenotype', 'pelvic appendage bud phenotype', 'Cranial nerve paralysis', 'Abnormality of the lower limb', 'pedal digitopodium bone phenotype', 'femur endochondral element phenotype', 'hindlimb endochondral element phenotype', 'autopod endochondral element phenotype', 'pelvic appendage phenotype', 'arch of centrum of vertebra phenotype', 'skeleton of pedal acropodium', 'multicellular anatomical structure morphology in the heart phenotype', 'skeleton of pedal digitopodium', 'Clubbing', 'clavate anatomical entity', 'phalanx of pes morphology phenotype', 'morphology of nucleus phenotype', 'pes bone', 'hindlimb skeleton', 'Abnormality of the urethra', 'incomplete closing of the ductus arteriosus', 'posterior region of body', 'limb long bone phenotype', 'pelvic appendage skeleton', 'pedal digit', 'Abnormal toe morphology', 'olfactory organ', 'pes phenotype', 'phalanx endochondral element phenotype', 'homeostatic process phenotype', 'sexual reproduction', 'bone of pectoral complex phenotype', 'metabolic process', 'Abnormal cellular phenotype', 'decreased material anatomical entity mass', 'decreased height of the multicellular organism', 'multicellular organism height phenotype', 'decreased height of the anatomical entity', 'size of multicellular organism phenotype', 'decreased functionality of the organ', 'anatomical entity height phenotype', 'skeleton of pes', 'Abnormality of body height', 'Anemia', 'myeloid cell homeostasis', 'cellular developmental process', 'multicellular organismal-level homeostasis', 'articulation phenotype', 'oxygen accumulating cell', 'food storage organ', 'myeloid cell differentiation', 'consumption behavior phenotype', 'anemia', 'decreased size of the long bone', 'polydipsia', 'Sideroblastic anemia', 'hindlimb endochondral element', 'erythrocyte', 'hematopoietic system morphology phenotype', 'erythrocyte homeostasis', 'number of myeloid cell phenotype', 'cell differentiation', 'cellular process', 'homeostatic process', 'Facial asymmetry', 'asymmetry of face phenotype', 'asymmetry of anatomical entity phenotype', 'Pes planus', 'Abnormal facial shape', 'Slanting of the palpebral fissure', 'abdominal wall', 'protruding anatomical entity', 'umbilical cord phenotype', 'hip joint', 'umbilical cord', 'hip dislocation', 'indifferent external genitalia', 'extraembryonic structure phenotype', 'conceptus', 'abdominal viscera', 'entire extraembryonic component', 'Abnormal umbilicus morphology', 'Abnormality of the abdominal wall', 'Abdominal wall defect', 'Hernia of the abdominal wall', 'connective tissue phenotype', 'developmental process phenotype', 'herniated abdominal wall', 'Hernia', 'sloped anatomical entity', 'deviation of manual digit 5 towards the middle', 'Deviation of finger', 'mucosa of stomach', 'limb long bone morphology phenotype', 'myeloid cell', 'Clinodactyly', 'Abnormal 5th finger morphology', 'ganglion of peripheral nervous system', 'spatial pattern of anatomical entity phenotype', 'deviation of manual digit towards the middle', 'deviation of anatomical entity', 'hindgut', 'Macule', 'Multiple cafe-au-lait spots', 'Cafe-au-lait spot', 'Hypermelanotic macule', 'nose phenotype', 'Localized skin lesion', 'anterior segment of eyeball', 'girdle bone/zone', 'Abnormal uvea morphology', 'bicornuate anatomical entity', 'formed material anatomical entity', 'decreased qualitatively sensory perception of sound', 'germ cell', 'anterior uvea', 'uvea', 'anterior chamber of eyeball morphology phenotype', 'abdomen element physiology phenotype', 'Aplasia/Hypoplasia affecting the anterior segment of the eye', 'Aplasia/Hypoplasia of the iris', 'Ocular anterior segment dysgenesis', 'aplasia or hypoplasia of eyeball of camera-type eye', 'cranial neuron projection bundle phenotype', 'formed anterior chamber of eyeball', 'iris', 'gamete generation phenotype', 'organ subunit', 'Aplasia/Hypoplasia affecting the uvea', 'formed multicellular anatomical structure', 'formed organ subunit', 'male gamete generation phenotype', 'iris phenotype', 'manual digit 5', 'organ subunit phenotype', 'malformed anatomical entity', 'organelle', 'formed anatomical structure', 'chordate embryonic development', 'aplasia or hypoplasia of uvea', 'anterior chamber of eyeball', 'aplasia or hypoplasia of iris', 'ear morphology phenotype', 'Abnormal pinna morphology', 'deviation of anatomical entity towards the middle', 'external ear phenotype', 'vestibulo-auditory system phenotype', 'external ear', 'Abnormality of the outer ear', 'external ear morphology phenotype', 'Abnormality of the ear', 'Abnormal ear morphology', 'vestibulo-auditory system', 'shape of external ear phenotype', 'cornea scarring; corneal scarring', 'skeleton of upper jaw', 'consumption behavior', 'aplasia or hypoplasia of palatine uvula', 'palatine uvula morphology phenotype', 'maxillary prominence', 'cell development', 'soft palate morphology phenotype', 'maxillary prominence morphology phenotype', 'Abnormal hip joint morphology', 'morphological feature', 'palatine uvula phenotype', 'polycythemia', 'decreased size of the endochondral element', 'palatine uvula', 'embryonic cloaca', 'Aplasia/Hypoplasia of the uvula', 'digit 1 plus metapodial segment', 'forelimb endochondral element', 'decreased size of the multicellular organism', 'limb long bone', 'cornea, curved phenotype', 'integumental system', 'ectoderm-derived structure phenotype', 'aorta morphology phenotype', 'arch of centrum of vertebra', 'increased pigmentation in skin of body', 'decreased qualitatively pigmentation', 'integument phenotype', 'Abnormal eyelid morphology', 'skin of body phenotype', 'internal genitalia phenotype', 'decreased multicellular anatomical structure mass', 'embryo development ending in birth or egg hatching', 'organ part', 'leg phenotype', 'pigmentation phenotype', 'Eukaryota', 'optic cup morphology phenotype', 'anatomical projection phenotype', 'Abnormality of the skeletal system', 'Abnormal gastrointestinal tract morphology', 'Abnormal calvaria morphology', 'Abnormality of the face', 'palpebral fissure phenotype', 'multi organ part structure phenotype', 'increased pigmentation', 'presumptive ectoderm phenotype', 'Abnormality of chromosome stability', 'decreased length of anatomical structure', 'connective tissue', 'anatomical entity physiology phenotype', 'concave 3-D shape anatomical entity', 'decreased length of multicellular anatomical structure', 'trachea phenotype', 'craniofacial/craniocervical phenotype', 'anatomical line', 'head bone phenotype', 'Abnormality of head or neck', 'mucosa', 'heart tube', 'renal system phenotype', 'dilated anatomical entity', 'Abnormality of the ocular adnexa', 'neural plate phenotype', 'immaterial anatomical entity', 'axial skeleton plus cranial skeleton phenotype', 'camera-type eye morphology phenotype', 'pedal digit digitopodial skeleton', 'decreased size of the palpebral fissure', 'decreased length of anatomical entity', 'nose', 'Abnormal heart valve morphology', 'Abnormality of the upper limb', 'neurocranium morphology phenotype', 'orbital region phenotype', 'naris', 'pelvic complex', 'reflex', 'decreased size of the orifice', 'absent material anatomical entity in the reproductive system', 'decreased length of bone of appendage girdle complex', 'bone element mass density phenotype', 'Abnormality of the head', 'vasculature of central nervous system plus retina', 'pedal digit phenotype', 'decreased length of orifice', 'decreased number of hematopoietic cell', 'absent multicellular anatomical structure in the reproductive system', 'decreased size of the multicellular anatomical structure', 'decreased qualitatively anatomical structure development', 'uvea morphology phenotype', 'ectoderm-derived structure physiology phenotype', 'Aplasia/Hypoplasia of the ulna', 'increased size of the anatomical structure', 'multicellular organismal process phenotype', 'anatomical projection', 'hematopoietic cell', 'decreased length of limb endochondral element', 'Abnormality of eye movement', 'Abnormality of the kidney', 'digitopodium bone', 'decreased size of the anatomical structure', 'skull morphology phenotype', 'manual digit', 'camera-type eye physiology phenotype', 'cartilaginous condensation phenotype', 'flat bone', 'bone of pectoral complex', 'organ physiology phenotype', 'incomplete closing of the organ part', 'physiologic nystagmus', 'nervous system physiology phenotype', 'decreased size of the forelimb bone', 'forebrain phenotype', 'neuron projection bundle', 'absent organ in the male reproductive system', 'increased qualitatively response to stimulus', 'bone of appendage girdle complex', 'Abnormal cornea morphology', 'increased size of the ventricle of nervous system', 'Micrognathia', 'decreased functionality of the organ component layer', 'musculoskeletal movement phenotype', 'neuromuscular process', 'material anatomical entity morphology in the heart phenotype', 'brain ventricle', 'anatomical structure mass phenotype', 'voluntary musculoskeletal movement', 'nervous system', 'skeleton of upper jaw phenotype', 'subdivision of digestive tract phenotype', 'epithelial tube', 'increased number of material anatomical entity', 'delayed developmental process', 'behavior process phenotype', 'facial skeleton phenotype', 'increased qualitatively biological_process', 'Abnormal reproductive system morphology', 'Growth delay', 'Abnormal nervous system physiology', 'nervous system process', 'increased size of the multicellular anatomical structure', 'acidosis', 'cardiovascular system phenotype', 'vertebra phenotype', 'telencephalon morphology phenotype', 'Aplasia/Hypoplasia affecting the eye', 'behavior process', 'pectoral appendage bud', 'autonomic nervous system', 'central nervous system phenotype', 'voluntary musculoskeletal movement phenotype', 'vascular plexus phenotype', 'voluntary movement behavior phenotype', 'blood vasculature', 'response to stimulus phenotype', 'pelvic region element phenotype', 'Abnormal vascular morphology', 'strabismus', 'Abnormality of the cardiovascular system', 'gamete generation', 'decreased functionality of the anatomical structure', 'Abnormal ocular adnexa morphology', 'Deviation of the hand or of fingers of the hand', 'limb endochondral element', 'gonad', 'limb bone', 'eye phenotype', 'systemic artery phenotype', 'Hyperpigmentation of the skin', 'anterior segment of eyeball morphology phenotype', 'drooping anatomical entity', 'decreased qualitatively multicellular organismal reproductive process', 'bone structure', 'systemic artery', 'roof of mouth morphology phenotype', 'upper urinary tract phenotype', 'manual digit 1 or 5', 'anatomical cluster', 'Abnormal systemic arterial morphology', 'anatomical structure morphogenesis', 'great vessel of heart', 'Abnormality of skin pigmentation', 'decreased pigmentation in skin of body', 'material anatomical entity physiology phenotype', 'proximo-distal subdivision of respiratory tract phenotype', 'vascular system', 'central nervous system gray matter layer', 'vasculature phenotype', 'behavior', 'number of cell phenotype', 'increased response to external stimulus', 'anatomical cavity', 'artery', 'aorta', 'systemic arterial system', 'blood cell', 'postcranial axial skeleton', 'absent organ in the reproductive system', 'blood vessel', 'orbital region', 'limb skeleton subdivision', 'anatomical conduit', 'decreased biological_process', 'thoracic cavity blood vessel phenotype', 'immaterial entity', 'cardiovascular system morphology phenotype', 'Irregular hyperpigmentation', 'appendicular skeletal system', 'undifferentiated genital tubercle morphology phenotype', 'erythrocyte morphology phenotype', 'vascular system morphology phenotype', 'increased number of multicellular anatomical structure', 'opaque lens of camera-type eye', 'localised gonad', 'increased height of the secondary palate', 'blood vessel phenotype', 'enteric ganglion', 'great vessel of heart morphology phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'urethra phenotype', 'haemolymphatic fluid phenotype', 'thoracic cavity blood vessel', 'forelimb long bone phenotype', 'female reproductive organ', 'Aplasia/Hypoplasia involving the central nervous system', 'Abnormality of metabolism/homeostasis', 'upper digestive tract', 'cranial neuron projection bundle', 'Abnormal morphology of the great vessels', 'blood', 'blood island phenotype', 'decreased number of anatomical entity', 'pharyngeal arch 1', 'autonomic ganglion', 'Abnormal immune system morphology', 'tube closure', 'decreased number of anatomical structure', 'transparent eye structure', 'epithelial tube morphogenesis', 'Abnormality of blood and blood-forming tissues', 'liver phenotype', 'increased height of the material anatomical entity', 'skeleton of lower jaw phenotype', 'nucleate cell', 'deviation of manual digit 5', 'semi-lunar valve', 'Opisthokonta', 'foregut phenotype', 'long bone phenotype', 'motile cell', 'hindlimb bud', 'palpebral fissure', 'bodily fluid', 'bone of craniocervical region phenotype', 'decreased size of the material anatomical entity', 'presomitic mesoderm morphology phenotype', 'Aplasia/hypoplasia involving bones of the hand', 'forelimb zeugopod bone morphology phenotype', 'cell', 'Epicanthus', 'Abnormal leukocyte morphology', 'orifice atresia', 'Finger clinodactyly', 'oviduct', 'Nystagmus', 'facial bone', 'Abnormality of the lower urinary tract', 'decreased number of anatomical entity in the blood', 'Abnormality of the vasculature', 'decreased number of leukocyte in the blood', 'cardiovascular system', 'Abnormal brain morphology', 'artery morphology phenotype', 'developmental process', 'multi-limb segment region', 'uterus morphology phenotype', 'leukocyte', 'cortex of cerebral lobe', 'Abnormal reflex', 'arm phenotype', 'bodily fluid phenotype', 'nerve', 'endochondral bone', 'anucleate cell', 'hindlimb morphology phenotype', 'meso-epithelium', 'respiratory system', 'primary subdivision of cranial skeletal system phenotype', 'increased size of the lateral structure', 'zeugopodial skeleton', 'number of anatomical entities of type anatomical entity in blood phenotype', 'number of anatomical enitites of type material anatomical entity phenotype', 'Abnormal leukocyte count', 'cell phenotype', 'phalanx', 'decreased sensory perception of sound', 'phalanx morphology phenotype', 'multicellular organismal movement phenotype', 'epithelial tube phenotype', 'leukocyte morphology phenotype', 'Cataract', 'pre-chordal neural plate phenotype', 'future nervous system', 'Abnormal aortic morphology', 'Hypertelorism', 'multi organ part structure physiology phenotype', 'jaw skeleton morphology phenotype', 'multi-tissue structure', 'thoracic segment organ', 'prepuce of penis', 'optic vesicle phenotype', 'Abnormal ear physiology', 'orifice', 'localised testis', 'reflexive behavior', 'multi-tissue structure phenotype', 'Abnormal cellular immune system morphology', 'immune system process', 'heart primordium', 'sclerotome phenotype', 'Abnormal bone ossification', 'Abnormal axial skeleton morphology', 'arterial blood vessel', 'phenotypic effect', 'eye primordium phenotype', 'sensory perception of light stimulus', 'decreased length of material anatomical entity', 'neural plate morphology phenotype', 'mandible morphology phenotype', 'ectoderm', 'decreased number of cell', 'cerebrospinal fluid morphology phenotype', 'cerebral cortex phenotype', 'internal female genitalia', 'aganglionic megacolon', 'nervous system process phenotype', 'cardiac valve morphology phenotype', 'epithelial fold', 'unilaminar epithelium phenotype', 'flattened anatomical entity', 'increased biological_process', 'intermediate mesoderm morphology phenotype', 'blastula', 'sensory system phenotype', 'endocrine system', 'unilaminar epithelium', 'decreased length of endochondral bone', 'structure with developmental contribution from neural crest physiology phenotype', 'myocardium', 'non-material anatomical boundary', 'Umbilical hernia', 'presumptive structure phenotype', 'skeletal element phenotype', 'immaterial anatomical entity phenotype', 'entity', 'decreased number of material anatomical entity', 'primary neural tube formation', 'musculoskeletal movement', 'Abnormality of the male genitalia', 'Abnormality of the nose', 'absent multicellular anatomical structure', 'Syndactyly', 'pedal digit plus metapodial segment', 'entire sense organ system', 'sclerotome', 'vision/eye phenotype', 'anatomical line between pupils', 'heart layer phenotype', 'response to external stimulus phenotype', 'viscus', 'localised material anatomical entity', 'hindlimb bone phenotype', 'ecto-epithelium', 'Neoplasm by anatomical site', 'serotonin secreting cell', 'optic vesicle', 'heart plus pericardium', 'neurectoderm', 'increased number of brain ventricle in the cerebrospinal fluid', 'cerebral hemisphere morphology phenotype', 'Abnormal limb bone morphology', 'soft palate', 'epithelium', 'simple eye phenotype', 'multicellular organism phenotype', 'skin of body morphology phenotype', 'zone of organ phenotype', 'epithelium phenotype', 'response to stimulus', 'subdivision of organism along main body axis phenotype', 'dermal bone phenotype', 'location of anatomical entity phenotype', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'Hematological neoplasm', 'localised multicellular anatomical structure', 'artery phenotype', 'Abnormality of the endocrine system', 'Abnormal morphology of female internal genitalia', 'reproductive structure', 'continuant', 'neural crest morphology phenotype', 'primary subdivision of skull phenotype', 'aplasia or hypoplasia of skeleton', 'Triphalangeal thumb', 'lateral structure', 'vertebra', 'mesoderm-derived structure', 'Weight loss', 'neuron projection bundle phenotype', 'forelimb skeleton', 'Abnormality of the curvature of the cornea', 'skeletal system', 'dermal bone', 'large intestine phenotype', 'tracheoesophageal fistula', 'phalanx endochondral element', 'subdivision of head', 'ulna endochondral element', 'All', 'pectoral appendage bud phenotype', 'anatomical structure formation involved in morphogenesis phenotype', 'digestive tract', 'testis phenotype', 'non-connected functional system', 'embryonic tissue', 'disconnected anatomical group', 'absent gonad in the reproductive system', 'blood phenotype', 'aortic valve morphology phenotype', 'heart layer morphology phenotype', 'decreased length of long bone', 'immature eye phenotype', 'manus', 'embryonic autopod plate morphology phenotype', 'dentary phenotype', 'blood island', 'blood cell phenotype', 'subdivision of skeleton phenotype', 'lateral plate mesoderm phenotype', 'endo-epithelium', 'body part movement', 'heart vasculature', 'Abnormal morphology of the radius', 'reproductive organ phenotype', 'Abnormal eye morphology', 'resistance to salt stress', 'formed organ part', 'autopodial skeleton', 'Abnormal lower limb bone morphology', 'cardiac valve', 'digit 5', 'eyelid', 'transparent eye structure phenotype', 'neural tube morphology phenotype', 'bone element phenotype', 'increased size of the zone of organ', 'skeletal joint dislocation', 'mandible phenotype', 'Abnormal mandible morphology', 'Recurrent infections', 'erythroid lineage cell', 'voluntary movement behavior', 'limb bud morphology phenotype', 'Abnormal hand morphology', 'neural tube closure', 'embryo morphology phenotype', 'germ layer / neural crest', 'simple eye', 'autopodial extension', 'face morphology phenotype', 'phenotype', 'Hypopigmented skin patches', 'organ part phenotype', 'circulatory system phenotype', 'root', 'mononuclear leukocyte', 'dysesthesia; hyperalgesia', 'weight loss', 'Cleft palate', 'organ', 'incomplete closing of the interatrial septum', 'arm bone', 'upper limb segment', 'Dolichocephaly', 'manual digit 1 plus metapodial segment', 'skeletal joint morphology phenotype', 'bone element', 'subdivision of organism along appendicular axis', 'Decreased body weight', 'somite phenotype', 'Aplasia/Hypoplasia of fingers', 'drinking behavior phenotype', 'incomplete closing of the anatomical wall', 'haemolymphatic fluid', 'paired limb/fin skeleton', 'absent male reproductive organ', 'decreased length of anatomical conduit', 'lower limb segment phenotype', 'Abnormal digit morphology', 'anatomical entity morphology in the pectoral complex phenotype', 'Microphthalmia', 'increased length of the immaterial anatomical entity', 'Pyridoxine-responsive sideroblastic anemia', 'digestive tract epithelium', 'immune system phenotype', 'Abnormal small intestine morphology', 'reproductive process phenotype', 'anterior lateral plate mesoderm', 'kinesthetic behavior', 'transudate', 'head', 'decreased qualitatively biological_process', 'musculature of body', 'socially cooperative development', 'gonad physiology phenotype', 'skeleton of limb', 'organ system subdivision phenotype', 'erythroid lineage cell morphology phenotype', 'Abnormality iris morphology', 'lateral plate mesoderm morphology phenotype', 'increased size of the anatomical entity', 'decreased number of anatomical structure in the multicellular organism', 'forebrain', 'subdivision of head phenotype', 'male urethra', 'manual digitopodium region', 'Abnormal finger morphology', 'pectoral appendage phenotype', 'zone of bone organ', 'skeletal element', 'Abnormal male reproductive system physiology', 'forelimb bud phenotype', 'skeleton of limb phenotype', 'mesoderm phenotype', 'wall of stomach', 'neuromuscular process phenotype', 'hip joint morphology phenotype', 'pedal digitopodium region', 'aortic system', 'germ layer', 'eukaryotic cell', 'trunk region element physiology phenotype', 'upper limb segment phenotype', 'anatomical system phenotype', 'skeleton of manus', 'lower jaw region', 'anatomical entity morphology phenotype', 'pectoral appendage', 'structure with developmental contribution from neural crest', 'Abnormal soft palate morphology', 'limb bone phenotype', 'system', 'appendage girdle region phenotype', 'vessel phenotype', 'skeleton of pectoral complex', 'bone of appendage girdle complex phenotype', 'neural plate', 'paired limb/fin bud', 'subdivision of trunk', 'material anatomical entity phenotype', 'anatomical conduit phenotype', 'outflow tract of ventricle phenotype', 'manual digit 1 phalanx endochondral element', 'cavitated compound organ', 'arterial system', 'number of leukocyte phenotype', 'Abnormality of the urinary system', 'Abnormality of limbs', 'visual system', 'subdivision of tube phenotype', 'Abnormal size of the palpebral fissures', 'alimentary part of gastrointestinal system morphology phenotype', 'Abnormality of bone mineral density', 'face phenotype', 'blood vessel morphology phenotype', 'regional part of nervous system phenotype', 'Azoospermia', 'dilated colon', 'Decreased bone element mass density', 'pelvic appendage skeleton phenotype', 'digit phenotype', 'decreased size of the subdivision of organism along main body axis', 'multicellular anatomical structure, asymmetrically curved phenotype', 'multicellular organismal process', 'increased number of anatomical entity in the cerebrospinal fluid', 'increased size of the simple eye', 'camera-type eye phenotype', 'cardiac ventricle', 'hemopoiesis', 'system process', 'orifice phenotype', 'digestive system morphology phenotype', 'anatomical entity morphology in the heart phenotype', 'Abnormal external genitalia morphology', 'Decreased fertility in males', 'embryonic autopod plate', 'digit 5 plus metapodial segment', 'Abnormal cardiovascular system morphology', 'trunk phenotype', 'increased length of the anatomical line', 'lateral plate mesoderm', 'mesoderm-derived structure phenotype', 'Absent testis', 'ductus arteriosus', 'system process phenotype', 'nervous system phenotype', 'circulatory system', 'material anatomical entity', 'Abnormality of the immune system', 'limb endochondral element phenotype', 'pelvic region of trunk', 'mouth morphology phenotype', 'autopodial extension phenotype', 'cardiac ventricle phenotype', 'pharyngeal arch morphology phenotype', 'ocular adnexa phenotype', 'decreased system process', 'incomplete closing of the septum', 'pectoral complex', 'embryo phenotype', 'cardiac chamber', 'vestibulo-ocular reflex phenotype', 'skeleton of lower jaw', 'pectoral appendage skeleton', 'neural groove phenotype', 'deviation of manual digit', 'limb skeleton subdivision phenotype', 'appendicular skeleton', 'cranial skeletal system', 'arm', 'decreased size of the organ', 'Aplasia/hypoplasia involving bones of the extremities', 'germ layer morphology phenotype', 'increased length of the anatomical entity', 'subdivision of organism along main body axis', 'outflow part of left ventricle morphology phenotype', 'vasculature', 'hindlimb joint phenotype', 'dense mesenchyme tissue phenotype', 'limb phenotype', 'primitive urogenital sinus morphology phenotype', 'increased size of the ureter', 'embryonic structure', 'anatomical entity', 'paired limb/fin skeleton phenotype', 'entire embryonic mesenchyme', 'bone of jaw phenotype', 'autopod bone phenotype', 'Deviation of the 5th finger', 'musculoskeletal system', 'limb bone morphology phenotype', 'heart left ventricle morphology phenotype', 'number of hematopoietic cell phenotype', 'increased reflex', 'phalanx of manus', 'developmental process involved in reproduction', 'musculature of body phenotype', 'Abnormality of the autonomic nervous system', 'pes morphology phenotype', 'forelimb morphology phenotype', 'limb segment phenotype', 'immature eye', 'multicellular organismal movement', 'cardiac septum', 'independent continuant', 'tissue', 'digit 1 digitopodial skeleton', 'subdivision of digestive tract', 'Aplasia/hypoplasia involving bones of the upper limbs', 'spinal cord morphology phenotype', 'neural crest-derived structure phenotype', 'future central nervous system', 'embryo', 'outflow part of left ventricle', 'multi-limb segment region phenotype', 'immune system morphology phenotype', 'biological_process', 'decreased size of the limb bone', 'anus morphology phenotype', 'germ layer phenotype', 'size of palpebral fissure phenotype', 'increased biological_process in skin of body', 'absent reproductive structure in the male reproductive system', 'segment of autopod', 'presomitic mesoderm phenotype', 'Abnormal skin morphology', 'uterus phenotype', 'external male genitalia phenotype', 'vasculature of central nervous system plus retina phenotype', 'stylopod', 'aplasia or hypoplasia of anatomical entity', 'visual system phenotype', 'organ system subdivision', 'abdomen element phenotype', 'foregut morphology phenotype', 'surface structure phenotype', 'anatomical entity morphology in the manus phenotype', 'decreased number of leukocyte', 'eyeball of camera-type eye phenotype', 'limb bud phenotype', 'eye movement phenotype', 'forelimb zeugopod phenotype', 'umbilicus morphology phenotype', 'esophagus phenotype', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'paired limb/fin', 'limb segment', 'increased size of the organ', 'radius endochondral element', 'vault of skull phenotype', 'pigmentation', 'vein morphology phenotype', 'Displacement of the urethral meatus', 'Aplasia/Hypoplasia involving bones of the skull', 'cranial nerve related reflex', 'aplasia or hypoplasia of manual digit', 'paired limb/fin segment phenotype', 'femur morphology phenotype', 'hematopoietic system phenotype', 'left cardiac chamber phenotype', 'Abnormality of the genital system', 'Abnormality of the musculoskeletal system', 'endochondral element', 'absent reproductive structure', 'neural crest-derived structure, asymmetrically curved phenotype', 'incomplete closing of the abdominal wall', 'decreased length of palpebral fissure', 'foregut', 'Sloping forehead', 'embryonic tissue phenotype', 'Abnormal aortic valve morphology', 'organism substance', 'great vessel of heart phenotype', 'growth phenotype', 'size of skull phenotype', 'appendage girdle complex', 'dorsal region element', 'biological_process rate phenotype', 'Short palpebral fissure', 'Abnormal blood vessel morphology', 'craniocervical region', 'increased size of the zone of skin', 'forelimb long bone', 'Abnormality of the palpebral fissures', 'respiratory system physiology phenotype', 'neocortex morphology phenotype', 'manus phenotype', 'pelvic appendage', 'genitourinary system phenotype', 'subdivision of skeleton', 'anatomical entity phenotype', 'thoracic cavity element', 'ulna hypoplasia', 'incomplete closing of the vessel', 'phalanx of pes phenotype', 'reflex phenotype', 'appendage phenotype', 'skeleton', 'respiratory system morphology phenotype', 'anatomical structure phenotype', 'meningomyelocele; myelomeningocele', 'face', 'Abnormal erythrocyte morphology', 'Abnormal involuntary eye movements', 'gastrointestinal system mucosa phenotype', 'ecto-epithelium phenotype', 'exocrine gland', 'skeletal system morphology phenotype', 'paired limb/fin phenotype', 'Renal hypoplasia/aplasia', 'Abnormal uvula morphology', 'localised reproductive organ', 'femur phenotype', 'umbilicus', 'amniotic fluid phenotype', 'manual digit 1', 'lateral structure physiology phenotype', 'autopod region phenotype', 'Abnormal renal physiology', 'appendicular skeleton morphology phenotype', 'decreased functionality of the multicellular anatomical structure', 'female reproductive system morphology phenotype', 'anatomical collection phenotype', 'girdle bone/zone phenotype', 'anatomical collection', 'Abnormal skeletal morphology', 'skeletal joint phenotype', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'decreased number of material anatomical entity in the multicellular organism', 'oral cavity morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'digit', 'cardiopharyngeal field', 'systemic artery morphology phenotype', 'peripheral nervous system morphology phenotype', 'mouth phenotype', 'anlage phenotype', 'segment of manus', 'digitopodium region', 'ocular adnexa physiology phenotype', 'formed chamber of eyeball', 'tube', 'olfactory system morphology phenotype', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'aorta phenotype', 'innominate bone morphology phenotype', 'extraembryonic structure', 'trachea morphology phenotype', 'acropodium region', 'anatomical structure physiology phenotype', 'paired limb/fin segment', 'response to external stimulus', 'longitudinal arch of pes', 'multi organ part structure', 'paired limb/fin bud phenotype', 'testis', 'epicanthal fold', 'decreased size of the skeletal element', 'autopod region morphology phenotype', 'increased size of the anatomical line', 'forelimb', 'forelimb bud', 'lateral structure phenotype', 'Abnormal atrial septum morphology', 'morphological feature phenotype', 'Abnormal appendicular skeleton morphology', 'camera-type eye', 'bone of free limb or fin', 'anatomical entity length phenotype', 'ocular adnexa', 'immune system', 'Abnormal joint morphology', 'decreased length of endochondral element', 'forelimb bud morphology phenotype', 'nervous system development', 'cardiogenic splanchnic mesoderm morphology phenotype', 'anatomical line phenotype', 'organism subdivision', 'Abnormality of the respiratory system', 'subdivision of skeletal system', 'eyelid physiology phenotype', 'endoderm phenotype', 'Abnormality of the nervous system', 'multicellular anatomical structure', 'process', 'increased length of the organ part', 'colon phenotype', 'glandular system', 'reproductive organ', 'Abnormality of the hand', 'kidney physiology phenotype', 'gray matter phenotype', 'multicellular organism', 'hematopoietic system', 'urogenital fold morphology phenotype', 'Phenotypic abnormality', 'platelet morphology', 'limb bud', 'gray matter of forebrain phenotype', 'Growth abnormality', 'feeding behavior', 'acropodial skeleton', 'delayed biological_process', 'female reproductive organ morphology phenotype', 'pectoral appendage skeleton phenotype', 'ectoderm-derived structure', 'duodenum phenotype', 'simple eye physiology phenotype', 'secondary palate', 'embryonic cloacal fold morphology phenotype', 'sensory system', 'stomach morphology phenotype', 'head morphology phenotype', 'biological_process phenotype', 'left isomerism; left-sided isomerism', 'oral cavity', 'sensory perception of sound', 'vasculature of trunk phenotype', 'Abnormality of movement', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'occurrent', 'lower limb segment', 'Duodenal stenosis', 'Abnormality of limb bone', 'limb morphology phenotype', 'skeleton phenotype', 'Orofacial cleft', 'Abnormal male external genitalia morphology', 'male reproductive system morphology phenotype', 'gastrula', 'Abnormality of the eye', 'forelimb zeugopod bone phenotype', 'pedal digit phalanx endochondral element', 'hypothalamus-pituitary axis', 'limb', 'neurocranium', 'endocrine system phenotype', 'parasympathetic ganglion', 'Abnormal cerebral ventricle morphology', 'Short long bone', 'organism subdivision phenotype', 'visual perception', 'structure with developmental contribution from neural crest phenotype', 'size of brain ventricle phenotype', 'increased size of the ectoderm-derived structure', 'Hyperreflexia', 'Short stature', 'tissue phenotype', 'spinal cord phenotype', 'physiologic nystagmus phenotype', 'Decreased head circumference', 'hindlimb long bone phenotype', 'Abnormal testis morphology', 'primordium phenotype', 'eye', 'sense organ phenotype', 'digit morphology phenotype', 'anatomical structure, asymmetrically curved phenotype', 'neural fold', 'Decreased total leukocyte count', 'eye morphology', 'sense organ', 'anlage', 'appendage', 'cornea morphology', 'tetrapod frontal bone', 'pharyngeal arch phenotype', 'bone of hip region', 'ear', 'increased size of the immaterial anatomical entity', 'neurectoderm phenotype', 'tetrapod frontal bone phenotype', 'male reproductive organ phenotype', 'head phenotype', 'Abnormal cellular physiology', 'Abnormality of prenatal development or birth', 'increased size of the non-material anatomical boundary', 'mesenchyme', 'incomplete closing of the secondary palate', 'ventricle of nervous system phenotype', 'increased length of the non-material anatomical boundary', 'Abnormality of the hypothalamus-pituitary axis', 'main body axis', 'body proper', 'incomplete closing of the arterial blood vessel', 'sense organ physiology phenotype', 'surface structure', 'ganglion', 'eyeball of camera-type eye', 'long bone morphology phenotype', 'Abnormal thumb morphology', 'delayed growth', 'musculature phenotype', 'digit 1', 'craniocervical region phenotype', 'compound organ phenotype', 'subdivision of organism along appendicular axis phenotype', 'growth', 'Abnormality of the skin', 'anatomical space phenotype', 'anatomical structure development', 'Abnormality of the integument', 'skin of face morphology phenotype', 'renal system physiology phenotype', 'gland', 'integument', 'skin of body', 'zone of skin morphology phenotype', 'ureter phenotype', 'duodenum morphology phenotype', 'eye physiology phenotype', 'tracheobronchial tree morphology phenotype', 'intestine', 'female reproductive system phenotype', 'alimentary part of gastrointestinal system phenotype', 'small intestine', 'pre-chordal neural plate', 'intestine phenotype', 'shape of longitudinal arch of pes phenotype', 'Abnormal digestive system morphology', 'manual digit phalanx endochondral element', 'subdivision of tube', 'trunk mesenchyme', 'incomplete closing of the multicellular anatomical structure', 'decreased size of the anatomical entity', 'ventricular system of central nervous system', 'Abnormality of the amniotic fluid', 'digestive system', 'intermediate mesoderm phenotype', 'intestine morphology phenotype', 'irregular bone', 'prominent forehead', 'Abnormality of globe location', 'increased response to stimulus', 'digestive system element phenotype', 'ectoderm-derived structure, asymmetrically curved phenotype', 'Small intestinal stenosis', 'Abnormality of the digestive system', 'Eumetazoa', 'immune system physiology phenotype', 'forelimb zeugopod bone', 'small intestine morphology phenotype', 'esophagus', 'autopod endochondral element', 'Abnormal duodenum morphology', 'Tracheoesophageal fistula', 'appendicular skeleton phenotype', 'primary subdivision of skull', 'decreased size of the bone of appendage girdle complex', 'valve phenotype', 'urethra', 'head mesenchyme', 'hindlimb bone', 'heart phenotype', 'male reproductive organ physiology phenotype', 'reproductive process', 'cardiac chamber phenotype', 'absent anatomical structure in the male reproductive system', 'semi-lunar valve morphology phenotype', 'intracellular membrane-bounded organelle', 'trunk region element', 'chamber of eyeball', 'absent anatomical entity in the male reproductive system', 'erythrocyte differentiation', 'primordium', 'compound organ', 'heart layer', 'cellular_component phenotype', 'Abnormal palate morphology', 'hindlimb bud morphology phenotype', 'ventricular system of brain', 'outflow tract', 'subdivision of trunk phenotype', 'multicellular organismal reproductive process', 'manus morphology phenotype', 'primary heart field phenotype', 'drinking behavior', 'mouth', 'cloaca', 'multicellular organismal reproductive process phenotype', 'heart morphology phenotype', 'primary heart field', 'left cardiac chamber', 'mesoderm morphology phenotype', 'craniocervical region morphology phenotype', 'musculature', 'brain ventricle phenotype', 'increased number of multicellular anatomical structure in the cerebrospinal fluid', 'thoracic segment organ phenotype', 'increased number of brain ventricle/choroid plexus', 'peripheral nervous system', 'Abnormal skull morphology', 'circulatory organ', 'lymphocyte', 'outflow tract of ventricle', 'wall of stomach morphology phenotype', 'cell physiology phenotype', 'herniated anatomical entity', 'heart tube morphology phenotype', 'vessel', 'anatomical cavity phenotype', 'multicellular organism mass phenotype', 'Abnormality of skull size', 'trunk region element phenotype', 'multicellular organism development', 'Aplasia/hypoplasia involving the skeleton', 'thoracic cavity element phenotype', 'homeostasis of number of cells', 'number of anatomical enitites of type reproductive organ phenotype', 'subdivision of oviduct phenotype', 'cardiac ventricle morphology phenotype', 'skin of head', 'primary circulatory organ', 'glans', 'Abnormality of the gastrointestinal tract', 'skeletal system phenotype', 'cardiogenic splanchnic mesoderm', 'viscus phenotype', 'Abnormal heart morphology', 'Abnormal hip bone morphology', 'heart primordium phenotype', 'mesoderm', 'neural tube', 'cardiogenic plate', 'neural crest-derived structure', 'Megacolon', 'heart', 'outflow tract phenotype', 'Hearing impairment', 'splanchnic layer of lateral plate mesoderm phenotype', 'decreased functionality of the organ part', 'liver', 'anatomical entity hypoplasia in face', 'meso-epithelium phenotype', 'trunk', 'hemolymphoid system', 'primary circulatory organ phenotype', 'shape of anatomical entity phenotype', 'B cell', 'forelimb bone phenotype', 'anterior region of body', 'shape of eyelid phenotype', 'mesenchyme morphology phenotype', 'shape of continuant phenotype', 'innominate bone phenotype', 'ocular surface region', 'Ptosis', 'male reproductive system physiology phenotype', 'drooping eyelid', 'individual digit of digitopodial skeleton', 'upper jaw region', 'brain ventricle/choroid plexus phenotype', 'endochondral bone phenotype', 'autopod region', 'Abnormality of the mouth', 'increased height of the roof of mouth', 'incomplete closing of the anatomical structure', 'decreased length of skeletal element', 'midface phenotype', 'secondary palate morphology phenotype', 'neural tube morphology', 'postcranial axial skeletal system', 'Abnormal anterior eye segment morphology', 'oral cleft; orofacial cleft', 'subdivision of skeletal system phenotype', 'incomplete closing of the anatomical entity', 'midface morphology phenotype', 'roof of mouth', 'incomplete closing of the material anatomical entity', 'respiratory system morphology', 'female reproductive system', 'decreased number of anatomical entity in the multicellular organism', 'anatomical space', 'male reproductive system phenotype', 'feeding behavior phenotype', 'anatomical structure', 'incomplete closing of the multi-tissue structure', 'aortic valve', 'external genitalia morphology; external genitalia phenotype', 'vertebral column', 'Abnormal oral cavity morphology', 'developing anatomical structure', 'jaw region', 'cell nucleus phenotype', 'Aplasia/Hypoplasia of the cerebrum', 'sensory perception phenotype', 'Craniofacial cleft', 'gastrointestinal system mucosa', 'midface', 'sclerotome morphology phenotype', 'gastrointestinal arteriovenous malformation', 'oral cavity phenotype', 'opening of the anatomical entity', 'facial bone hypoplasia', 'reproductive system morphology phenotype', 'Abnormality of the genitourinary system', 'cellular_component', 'herniated umbilical cord', 'digestive system gland phenotype', 'internal female genitalia morphology phenotype', 'anatomical wall phenotype', 'upper eyelid', 'absent material anatomical entity', 'Abnormality of the female genitalia', 'Abnormal internal genitalia', 'organ phenotype', 'integumental system phenotype', 'testis morphology phenotype', 'tube phenotype', 'oligohydramnios', 'reproductive structure phenotype', 'subdivision of oviduct', 'mesenchyme from somatopleure', 'localised reproductive structure', 'female organism phenotype', 'incomplete closing of the blood vessel', 'reproductive system', 'protruding eyeball of camera-type eye', 'cardiogenic splanchnic mesoderm phenotype', 'respiratory system phenotype', 'Aplasia/Hypoplasia of the mandible', 'absent reproductive structure in the reproductive system', 'genitourinary system', 'oviduct phenotype', 'innominate bone', 'closing of the ectoderm-derived structure', 'female reproductive organ phenotype', 'reproductive system phenotype', 'increased number of material anatomical entity in the cerebrospinal fluid', 'female organism', 'increased length of the skin of head', 'internal genitalia', 'cerebral cortex morphology phenotype', 'uterus', 'Abnormal cardiac atrium morphology', 'valve', 'Abnormality of the uterus', 'Decreased fertility', 'telencephalon', 'neural tube phenotype', 'Abnormal connection of the cardiac segments', 'Morphological central nervous system abnormality', 'cardiogenic plate morphology phenotype', 'Abnormal forebrain morphology', 'enteric nervous system', 'forebrain morphology phenotype', 'manus bone', 'urogenital fold', 'manual digit bone', 'central nervous system', 'brain phenotype', 'nerve phenotype', 'nervous system morphology phenotype', 'tube formation phenotype', 'telencephalon phenotype', 'glans penis', 'anus', 'dermal skeletal element phenotype', 'Hypertrophic cardiomyopathy', 'olfactory system phenotype', 'heart left ventricle', 'Abnormal nervous system morphology', 'Aganglionic megacolon', 'decreased size of the organism subdivision', 'respiratory tract', 'brain ventricle morphology phenotype', 'increased number of anatomical entity in the blood', 'multicellular organism development phenotype', 'incomplete closing of the roof of mouth', 'brain', 'embryonic cloaca morphology phenotype', 'radius bone phenotype', 'endocrine gland', 'central nervous system morphology phenotype', 'regional part of nervous system', 'anatomical structure, curved phenotype', 'Microcephaly', 'Abnormal cerebral morphology', 'regional part of brain phenotype', 'axial skeletal system', 'skull', 'behavior phenotype', 'Metazoa', 'anterior neural tube phenotype', 'decreased size of the head', 'increased number of ventricle of nervous system', 'involuntary movement behavior', 'mesenchyme phenotype', 'size of head phenotype', 'Abnormality of the liver', 'head mesenchyme phenotype', 'axial skeleton plus cranial skeleton', 'aplasia or hypoplasia of mandible', 'regional part of brain', 'increased length of the epicanthal fold', 'ectoderm-derived structure, curved phenotype', 'cardiac valve phenotype', 'renal system', 'cartilage element', 'Abnormal foot morphology', 'excretory system', 'Abnormality of reproductive system physiology', 'increased size of the trunk region element', 'Abnormal conjugate eye movement', 'eye movement', 'reproductive system physiology phenotype', 'embryonic cloaca phenotype', 'Abnormal carotid artery morphology', 'venous blood vessel phenotype', 'common carotid artery plus branches morphology phenotype', 'Abnormality of lower limb joint', 'common carotid artery plus branches', 'Neoplasm', 'incomplete closing of the coronary vessel', 'nervous system cell part layer', 'neoplasm phenotype', 'gastric ulcer', 'circulatory organ phenotype', 'Myelodysplasia', 'digestive tract epithelium phenotype', 'anatomical entity morphology in the alimentary part of gastrointestinal system phenotype', 'presumptive structure', 'endoderm of foregut', 'endoderm-derived structure phenotype', 'respiratory tube morphology phenotype', 'material entity', 'splanchnic layer of lateral plate mesoderm', 'respiratory airway', 'foregut epithelium', 'sensory perception of mechanical stimulus', 'deviation of digit towards the middle', 'external genitalia', 'parathyroid gland physiology phenotype', 'decreased activity of parathyroid; hypoparathyroidism', 'endoderm-derived structure', 'lower respiratory tract', 'digit plus metapodial segment', 'mandibular prominence', 'penis', 'absent anatomical structure in the reproductive system', 'Aplasia/hypoplasia of the extremities', 'gland phenotype', 'sorocarp development', 'hypothalamus-pituitary axis phenotype', 'vein phenotype', 'increased length of the anatomical line between pupils', 'duodenum', 'venous system', 'tracheobronchial tree', 'membrane bone', 'ectoderm phenotype', 'respiratory tube', 'endoderm morphology phenotype', 'male organism', 'vein', 'Abnormal femur morphology', 'Abnormal respiratory system morphology', 'Intrauterine growth retardation', 'neural fold morphology phenotype', 'shape of face phenotype', 'anatomical system physiology phenotype', 'Abnormal intestine morphology', 'parathyroid gland', 'trachea', 'Abnormal ventriculoarterial connection', 'venous blood vessel', 'Finger syndactyly', 'esophagus morphology phenotype', 'Abnormal tracheal morphology', 'gland physiology phenotype', 'abdominal wall phenotype', 'size of anatomical entity phenotype', 'digestive system gland', 'Oligohydramnios', 'endoderm', 'vestibulo-ocular reflex', 'vasculature morphology in the alimentary part of gastrointestinal system phenotype', 'synovial joint morphology phenotype', 'intramembranous bone phenotype', 'dense mesenchyme tissue', 'proximo-distal subdivision of respiratory tract', 'Abnormal tracheobronchial morphology', 'embryonic structure phenotype', 'endocrine gland phenotype', 'embryonic epithelial tube formation', 'skeletal system physiology phenotype', 'endo-epithelium phenotype', 'manual digit 5 plus metapodial segment', 'renal/urinary system phenotype', 'foregut epithelium phenotype', 'increased size of the organ part', 'hypoventilation', 'increased size of the brain ventricle/choroid plexus', 'eye primordium', 'organ component layer phenotype', 'location of eyeball of camera-type eye phenotype', 'brain ventricle/choroid plexus', 'manual digit phenotype', 'anatomical entity morphology in the brain phenotype', 'increased size of the organ component layer', 'organ component layer', 'brain ventricle/choroid plexus morphology phenotype', 'intracellular membraneless organelle', 'Ventriculomegaly', 'parathyroid gland phenotype', 'increased size of the material anatomical entity', 'incomplete closing of the anatomical conduit', 'brain morphology phenotype', 'increased size of the brain ventricle', 'bone of jaw', 'decreased nervous system process', 'ventricle of nervous system', 'Abnormal jaw morphology', 'interatrial septum', 'ear phenotype', 'dermal skeleton phenotype', 'anatomical entity hypoplasia', 'semen', 'material anatomical entity atresia', 'heart tube phenotype', 'pharyngeal arch system', 'central nervous system cell part cluster', 'mandible hypoplasia', 'eyelid phenotype', 'facial bone phenotype', 'intramembranous bone', 'head bone morphology phenotype', 'dermatocranium', 'pharyngeal arch 1 phenotype', 'increased length of the skin of eyelid', 'decreased length of limb bone', 'dentary', 'epithelial fold phenotype', 'Abnormal facial skeleton morphology', 'increased height of the anatomical entity', 'oral opening', 'neural crest phenotype', 'external anal region', 'musculoskeletal system phenotype', 'embryonic craniocervical region', 'absent reproductive organ', 'absent reproductive organ in the reproductive system', 'stomach phenotype', 'Clinodactyly of the 5th finger', 'dermal skeletal element', 'mandibular prominence morphology phenotype', 'pharyngeal arch', 'aplasia or hypoplasia of skull', 'ulna phenotype', 'cardiac atrium morphology phenotype', 'facial skeleton morphology phenotype', 'ectoderm morphology phenotype', 'neural crest', 'protuberance phenotype', 'male gamete generation', 'Anemia of inadequate production', 'eyelid morphology phenotype', 'pharyngeal region of foregut', 'zone of organ', 'bone of craniocervical region', 'facial skeleton', 'bone of lower jaw', 'autonomic nervous system morphology phenotype', 'tetrapod frontal bone morphology phenotype', 'cornea morphology phenotype', 'Aplasia/Hypoplasia of the testes', 'absent anatomical entity', 'mandible', 'decreased length of bone of pectoral complex', 'prepuce of penis morphology phenotype', 'primary subdivision of cranial skeletal system', 'skeleton of digitopodium', 'dermatocranium phenotype', 'pharyngeal arch 1 morphology phenotype', 'neural fold phenotype', 'spinal cord', 'autonomic nervous system phenotype', 'neural groove', 'head bone', 'embryonic facial prominence', 'jaw skeleton', 'Aplasia/hypoplasia affecting bones of the axial skeleton', 'alimentary part of gastrointestinal system', 'dermal skeleton', 'digestive system element', 'protuberance', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'external male genitalia', 'paraxial mesoderm phenotype', 'Abnormality of the orbital region', 'external genitalia phenotype', 'normal growth on benomyl', 'thoracic segment of trunk', 'male reproductive system', 'Abnormality of the peripheral nervous system', 'tube formation', 'epithelial vesicle phenotype', 'digit 1 or 5 phenotype', 'taxon specific phenotype', 'gonad phenotype', 'epithelial tube formation', 'small intestine phenotype', 'male reproductive organ morphology phenotype', 'late embryo', 'Abnormal forehead morphology', 'endocrine gland physiology phenotype', 'localised male reproductive organ', 'Unusual infection', 'Abnormal eye physiology', 'localised anatomical entity', 'lymphocyte physiology phenotype', 'Abnormal oral morphology', 'localised organ', 'number of anatomical enitites of type organ phenotype', 'Cryptorchidism', 'endoderm of foregut phenotype', 'male organism phenotype', 'localised anatomical structure', 'male reproductive organ', 'Recurrent urinary tract infections', 'skull phenotype', 'anterior neural tube', 'Abnormality of the urinary system physiology', 'absent testis', 'Abnormality of the testis size', 'closing of the anatomical conduit', 'germ layer / neural crest phenotype', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'embryo development', 'axial skeleton plus cranial skeleton morphology phenotype', 'absent multicellular anatomical structure in the male reproductive system', 'B cell physiology phenotype', 'absent organ', 'anatomical cluster phenotype', 'absent anatomical structure in the multicellular organism', 'absent multicellular anatomical structure in the multicellular organism', 'embryonic tissue morphology phenotype', 'membrane bone phenotype', 'absent anatomical entity in the multicellular organism', 'asymmetrically curved anatomical entity', 'endochondral element phenotype', 'absent anatomical entity in the reproductive system', 'number of anatomical enitites of type erythrocyte phenotype', 'bone element hypoplasia in face', 'absent gonad', 'gray matter of forebrain', 'number of anatomical enitites of type gonad phenotype', 'absent organ in the multicellular organism', 'number of anatomical enitites of type anatomical entity phenotype', 'absent anatomical structure', 'internal female genitalia phenotype', 'bone of lower jaw phenotype', 'absent material anatomical entity in the multicellular organism', 'radius bone', 'respiratory tube phenotype', 'digit 1 or 5', 'absent material anatomical entity in the male reproductive system', 'embryonic development/birth phenotype', 'Upslanted palpebral fissure', 'late embryo phenotype', 'amniotic fluid', 'cellular organisms', 'aorta coarctation; coarctation of aorta', 'anatomical entity morphology in the appendage girdle complex phenotype', 'abdominal segment element phenotype', 'anatomical system', 'hepatobiliary system phenotype', 'increased number of organ part', 'increased size of the eye', 'multicellular anatomical structure phenotype', 'decreased size of the anatomical conduit', 'number of anatomical enitites of type reproductive structure phenotype', 'exocrine gland phenotype', 'abdominal segment element', 'arterial blood vessel phenotype', 'organism substance phenotype', 'skeleton of manual digitopodium', 'Abnormality of connective tissue', 'exocrine system', 'Hypospadias', 'presumptive ectoderm', 'manual digit 1 phalanx', 'hepatobiliary system', 'abdomen element', 'neocortex', 'Abnormal esophagus morphology', 'Abnormality of the abdominal organs', 'absent gamete', 'manual digit 5 morphology phenotype', 'Abnormality of immune system physiology', 'abdominal segment of trunk', 'developing anatomical structure phenotype', 'abdomen', 'embryo development phenotype', 'optic cup', 'number of anatomical enitites of type anatomical structure phenotype', 'digit 1 phenotype', 'manual digit digitopodial skeleton', 'articular system', 'skeleton of manual acropodium', 'manual digit 1 morphology phenotype', 'long bone', 'non-material anatomical boundary phenotype', 'autopod bone', 'forelimb bone', 'anatomical wall', 'manual digit 1 digitopodial skeleton', 'ocular surface region morphology phenotype', 'Abnormality of thumb phalanx', 'manual digitopodium bone'], 'has_descendant': ['MONDO:0013566', 'MONDO:0054748', 'MONDO:0010351', 'MONDO:0044325', 'MONDO:0013565', 'MONDO:0009213', 'MONDO:0019391', 'MONDO:0009214', 'MONDO:0014986', 'MONDO:0012186', 'MONDO:0009215', 'MONDO:0010953', 'MONDO:0013499', 'MONDO:0014987', 'MONDO:0014638', 'MONDO:0012565', 'MONDO:0012187', 'MONDO:0011584', 'MONDO:0014108', 'MONDO:0013248', 'MONDO:0014985', 'MONDO:0011325'], 'has_descendant_label': ['Fanconi anemia complementation group L', 'Fanconi anemia, complementation group S', 'Fanconi anemia complementation group B', 'Fanconi anemia, complementation group W', 'Fanconi anemia complementation group G', 'Fanconi anemia complementation group C', 'Fanconi anemia', 'Fanconi anemia complementation group D2', 'Fanconi anemia complementation group R', 'Fanconi anemia complementation group I', 'Fanconi anemia complementation group A', 'Fanconi anemia complementation group E', 'Fanconi anemia complementation group P', 'Fanconi anemia complementation group U', 'Fanconi anemia complementation group T', 'Fanconi anemia complementation group N', 'Fanconi anemia complementation group J', 'Fanconi anemia complementation group D1', 'Fanconi anemia complementation group Q', 'Fanconi anemia complementation group O', 'Fanconi anemia complementation group V', 'Fanconi anemia complementation group F'], 'has_descendant_count': 22, 'highlighting': None}, {'id': 'MONDO:1011504', 'category': 'biolink:Disease', 'name': 'Fanconi syndrome, horse', 'description': 'Fanconi syndrome that occurs in horse.', 'xref': ['OMIA:000366-9796'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:1011504'], 'has_descendant_label': ['Fanconi syndrome, horse'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0001083', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome', 'description': 'A genetic or acquired disorder characterized by impairment of the function of the proximal tubules of the kidney. It results in decreased reabsorption of electrolytes, glucose, amino acids, and other nutrients.', 'xref': ['DOID:1062', 'GARD:9120', 'MEDGEN:4653', 'MESH:D005198', 'NANDO:2100027', 'NANDO:2200187', 'NCIT:C3034', 'SCTID:236466005', 'SCTID:40488004', 'UMLS:C0015624'], 'synonym': ['De toni-Fanconi syndrome', 'De toni-debre-Fanconi syndrome', 'Fanconi syndrome', "Fanconi's syndrome", 'Fanconi-de toni syndrome', 'Fanconi-de-toni syndrome', 'Lignac-Fanconi syndrome', 'adult Fanconi syndrome', 'congenital Fanconi syndrome', 'deToni Fanconi syndrome', 'infantile nephropathic cystinosis', 'toni-debre-Fanconi syndrome'], 'exact_synonym': ['De toni-Fanconi syndrome', 'De toni-debre-Fanconi syndrome', 'Fanconi syndrome', "Fanconi's syndrome", 'Fanconi-de toni syndrome', 'Fanconi-de-toni syndrome', 'Lignac-Fanconi syndrome', 'deToni Fanconi syndrome'], 'narrow_synonym': ['adult Fanconi syndrome', 'congenital Fanconi syndrome'], 'related_synonym': ['infantile nephropathic cystinosis', 'toni-debre-Fanconi syndrome'], 'subsets': ['gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:0060778', 'MONDO:0024525', 'MONDO:0013247', 'MONDO:0007600', 'MONDO:0014275', 'MONDO:0001083', 'MONDO:0014458', 'MONDO:0030056', 'MONDO:0022948', 'MONDO:0060779', 'MONDO:0100238', 'MONDO:0060781'], 'has_descendant_label': ['adult Fanconi syndrome', 'Fanconi renotubular syndrome 1', 'Fanconi renotubular syndrome 2', 'primary Fanconi syndrome', 'Fanconi renotubular syndrome 3', 'Fanconi renotubular syndrome', 'Fanconi renotubular syndrome 4 with maturity-onset diabetes of the young', 'Fanconi renotubular syndrome 5', 'Deal Barratt Dillon syndrome', 'acquired Fanconi syndrome', 'inherited Fanconi renotubular syndrome', 'Preeyasombat-Varavithya syndrome'], 'has_descendant_count': 12, 'highlighting': None}, {'id': 'MONDO:0060779', 'category': 'biolink:Disease', 'name': 'acquired Fanconi syndrome', 'description': 'Fanconi Syndrome caused by exposure to noxious agents.', 'xref': ['MEDGEN:90966', 'NCIT:C78296', 'SCTID:236467001', 'UMLS:C0341702'], 'synonym': ['acquired Fanconi syndrome'], 'exact_synonym': ['acquired Fanconi syndrome'], 'subsets': ['gard_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:0060781', 'MONDO:0060779'], 'has_descendant_label': ['Preeyasombat-Varavithya syndrome', 'acquired Fanconi syndrome'], 'has_descendant_count': 2, 'highlighting': None}, {'id': 'MONDO:0009217', 'category': 'biolink:Disease', 'name': 'Fanconi-like syndrome', 'description': 'A syndrome characterized by pancytopenia, immune deficiency and cutaneous malignancies.', 'xref': ['DOID:0090066', 'MEDGEN:56237', 'MESH:C536855', 'OMIM:227850', 'SCTID:236469003', 'UMLS:C0151638'], 'synonym': ['Fanconi-like syndrome'], 'exact_synonym': ['Fanconi-like syndrome'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0007606', 'HP:0002783', 'HP:0001876', 'HP:0005939', 'HP:0002754'], 'has_phenotype_label': ['Osteomyelitis', 'Recurrent lower respiratory tract infections', 'Multiple cutaneous malignancies', 'Pancytopenia', 'Multiple bilateral pneumothoraces'], 'has_phenotype_count': 5, 'has_phenotype_closure': ['UPHENO:0063722', 'UPHENO:0086173', 'CL:0000764', 'CL:0000458', 'UPHENO:0085330', 'UPHENO:0063787', 'CL:0000233', 'CL:0001035', 'UPHENO:7000294', 'UPHENO:0086048', 'UPHENO:0086172', 'UPHENO:0004459', 'UPHENO:0080010', 'HP:0001876', 'UPHENO:0077373', 'CL:0000225', 'HP:0012145', 'UPHENO:0077399', 'CL:0000988', 'CL:0000329', 'CL:0000151', 'UPHENO:0085344', 'UBERON:0002193', 'UPHENO:7000306', 'HP:0000951', 'UPHENO:0003811', 'UBERON:0002416', 'CL:0000000', 'UPHENO:0002635', 'HP:0002664', 'HP:0008069', 'UBERON:0010314', 'UPHENO:0002553', 'HP:0001574', 'UPHENO:0004064', 'GO:0006954', 'UPHENO:0080377', 'UPHENO:0049586', 'UPHENO:0002964', 'GO:0050896', 'HP:0012649', 'UPHENO:0074682', 'UPHENO:0076684', 'HP:0011843', 'UPHENO:0002546', 'UBERON:0013765', 'UBERON:0001474', 'UBERON:0004765', 'HP:0007606', 'UPHENO:0081440', 'UPHENO:7000655', 'UPHENO:0080693', 'UPHENO:0049585', 'UBERON:0000160', 'HP:0012647', 'UPHENO:0004518', 'UPHENO:0076783', 'UPHENO:0074681', 'HP:0033127', 'UPHENO:0055024', 'HP:0002754', 'UPHENO:0074687', 'UPHENO:0080662', 'UPHENO:0049588', 'UBERON:0002108', 'UBERON:0002204', 'UBERON:0005409', 'UPHENO:0083263', 'UPHENO:0085371', 'HP:0002719', 'UPHENO:0002263', 'UPHENO:0002541', 'UPHENO:0004143', 'UPHENO:0002559', 'UPHENO:0002870', 'UPHENO:0002754', 'UBERON:0010316', 'UBERON:0002097', 'UPHENO:0079826', 'UPHENO:0005135', 'UBERON:0001630', 'UBERON:0001007', 'UPHENO:0002949', 'UBERON:0011676', 'UPHENO:0003047', 'UPHENO:0002564', 'UPHENO:0005092', 'UBERON:0034925', 'UPHENO:0005141', 'HP:0005939', 'UBERON:0013701', 'HP:0002088', 'UPHENO:0076735', 'UPHENO:0001001', 'HP:0002086', 'UPHENO:0002531', 'UPHENO:0087359', 'UBERON:0001558', 'UBERON:0017650', 'HP:0012252', 'UPHENO:0011536', 'UBERON:0013522', 'UBERON:0000072', 'UPHENO:0002988', 'NCBITaxon:33208', 'CL:0000763', 'NCBITaxon:131567', 'UPHENO:0002679', 'UBERON:0005911', 'UBERON:0002048', 'UBERON:0000060', 'UBERON:0000042', 'NCBITaxon:6072', 'GO:0050905', 'UPHENO:0002833', 'BFO:0000040', 'UPHENO:0003372', 'UBERON:0018254', 'NBO:0000338', 'UPHENO:0003077', 'NCBITaxon:33154', 'UBERON:0005256', 'UPHENO:0051246', 'GO:0050877', 'UBERON:0000481', 'UBERON:0001015', 'GO:0003012', 'GO:0050882', 'HP:0011793', 'UPHENO:0002385', 'GO:0050881', 'UBERON:0009569', 'UPHENO:0077391', 'UBERON:0000171', 'UBERON:0003077', 'GO:0003010', 'UPHENO:0002530', 'UBERON:0015833', 'UPHENO:0002994', 'UBERON:0015203', 'UBERON:0004921', 'UPHENO:0081590', 'UPHENO:0050875', 'UPHENO:0002542', 'UPHENO:0004969', 'UPHENO:0049708', 'UPHENO:0002434', 'UBERON:0000468', 'GO:0006936', 'UPHENO:0002529', 'UBERON:0000475', 'UPHENO:0077418', 'UBERON:0007524', 'UPHENO:0002388', 'UPHENO:0081581', 'HP:0000118', 'UBERON:0000922', 'UPHENO:0002526', 'UPHENO:0087433', 'UPHENO:0002576', 'UPHENO:0002816', 'UPHENO:0002783', 'HP:0002107', 'UPHENO:0063794', 'UPHENO:0002926', 'HP:0005561', 'UBERON:0000490', 'UPHENO:0050606', 'UPHENO:0002267', 'UBERON:0001048', 'CL:0000081', 'UPHENO:0002720', 'UBERON:0003929', 'UBERON:0009778', 'UBERON:0001062', 'UPHENO:0087662', 'CL:0002242', 'UPHENO:0083955', 'UPHENO:0002963', 'UBERON:0005181', 'HP:0002103', 'UPHENO:7000331', 'UPHENO:0086908', 'UBERON:0000925', 'UPHENO:7000208', 'CL:0000232', 'UBERON:0000307', 'UPHENO:0005110', 'UPHENO:0003160', 'UPHENO:0054970', 'UBERON:0000065', 'UBERON:0003104', 'UPHENO:0051293', 'UPHENO:0003088', 'UBERON:0005291', 'UPHENO:0002571', 'UBERON:0002329', 'UPHENO:0004094', 'UBERON:0001434', 'GO:0006952', 'UBERON:0000486', 'UBERON:0002368', 'UPHENO:0011531', 'NBO:0000313', 'GO:0003009', 'BFO:0000002', 'BFO:0000015', 'UBERON:0002390', 'UBERON:0011216', 'UPHENO:0003116', 'UBERON:0000977', 'RO:0002577', 'UPHENO:7000623', 'UPHENO:0004900', 'UPHENO:0004481', 'UPHENO:0002731', 'UPHENO:0049622', 'UPHENO:0004536', 'UPHENO:0005257', 'UPHENO:0001002', 'UPHENO:0002386', 'UPHENO:0003022', 'BFO:0000003', 'GO:0032501', 'UBERON:0002075', 'UBERON:0000061', 'UPHENO:0002634', 'UPHENO:0049587', 'UPHENO:0051267', 'UBERON:0001004', 'UPHENO:0003025', 'UPHENO:0004891', 'UPHENO:0002859', 'UPHENO:0076675', 'HP:0011947', 'UPHENO:0004545', 'UBERON:0003059', 'UPHENO:0002734', 'UPHENO:0082875', 'UBERON:0000477', 'UPHENO:0005029', 'UBERON:0005178', 'UBERON:0000923', 'UBERON:0015212', 'UPHENO:0003191', 'UBERON:0000170', 'UBERON:0002199', 'UPHENO:0003432', 'UPHENO:0003234', 'UPHENO:0002525', 'UBERON:0000467', 'UPHENO:0087665', 'BFO:0000004', 'UPHENO:0011498', 'UBERON:0000062', 'UPHENO:0076803', 'UPHENO:0002269', 'UPHENO:0085302', 'UBERON:0002100', 'UBERON:0004111', 'CL:0000255', 'UPHENO:0088123', 'UPHENO:3000003', 'UPHENO:0002897', 'UBERON:0034923', 'UBERON:0005090', 'HP:0002715', 'UBERON:0004119', 'UBERON:0002050', 'UBERON:0000483', 'UBERON:0002530', 'UBERON:0007503', 'UPHENO:0003163', 'UBERON:0005177', 'UPHENO:0002577', 'UPHENO:0002648', 'UBERON:0003103', 'UBERON:0000025', 'UBERON:0010000', 'UBERON:0005906', 'UPHENO:0079833', 'NBO:0000403', 'UPHENO:0050613', 'NBO:0000001', 'UPHENO:0076692', 'UPHENO:0049584', 'UBERON:0015204', 'GO:0050879', 'HP:0001871', 'UPHENO:0002668', 'GO:0008150', 'UPHENO:0003084', 'UBERON:0002371', 'UPHENO:0002808', 'UPHENO:0074624', 'UPHENO:0001003', 'UPHENO:0049699', 'BFO:0000001', 'UPHENO:0003086', 'UBERON:0000064', 'UPHENO:0049703', 'UPHENO:0051196', 'UBERON:0000465', 'UPHENO:0003550', 'UPHENO:0002823', 'UPHENO:0002567', 'UPHENO:0004482', 'UPHENO:0087660', 'NCBITaxon:1', 'UBERON:0003082', 'UBERON:0001555', 'UPHENO:0003050', 'UPHENO:0085301', 'UPHENO:0002554', 'NCBITaxon:2759', 'UPHENO:0074751', 'UBERON:0005423', 'UBERON:0003258', 'UPHENO:0002976', 'UBERON:0000949', 'UPHENO:0050106', 'UBERON:0013702', 'UPHENO:0004680', 'UPHENO:0002902', 'GO:0007610', 'UPHENO:0002948', 'CL:0000457', 'UPHENO:0002536', 'HP:0002205', 'UBERON:0001005', 'UBERON:0014892', 'UPHENO:0002308', 'UPHENO:0003413', 'UBERON:0004120', 'UBERON:0000383', 'CL:0000738', 'UPHENO:0002448', 'UBERON:0000915', 'UPHENO:0002725', 'UPHENO:0002579', 'UPHENO:7000345', 'UPHENO:0002574', 'HP:0000001', 'UPHENO:0004885', 'CL:0002092', 'GO:0006941', 'HP:0010978', 'UPHENO:0003081', 'CL:0000219', 'UPHENO:0051197', 'UBERON:0009142', 'UBERON:0002385', 'UPHENO:0002822', 'UPHENO:0002261', 'UPHENO:0077348', 'UBERON:0007285', 'UPHENO:0004443', 'UPHENO:0003182', 'UBERON:0000479', 'UBERON:0001132', 'GO:0003008', 'GO:0006950', 'UBERON:0006598', 'HP:0032101', 'UBERON:0002405', 'UBERON:0001041', 'UPHENO:0002568', 'HP:0002783'], 'has_phenotype_closure_label': ['bone marrow cell', 'decreased number of erythrocyte', 'Abnormality of multiple cell lineages in the bone marrow', 'number of hematopoietic cell phenotype', 'Abnormality of blood and blood-forming tissues', 'hematopoietic cell', 'oxygen accumulating cell', 'decreased number of hematopoietic cell', 'hematopoietic system phenotype', 'number of cell phenotype', 'decreased number of myeloid cell', 'number of anatomical enitites of type erythrocyte phenotype', 'Pancytopenia', 'erythrocyte', 'biogenic amine secreting cell', 'leukocyte', 'anucleate cell', 'decreased number of cell', 'metabolic acidosis', 'platelet phenotype', 'platelet', 'myeloid cell', 'number of anatomical enitites of type material anatomical entity phenotype', 'number of anatomical enitites of type anatomical entity phenotype', 'blood cell', 'decreased number of material anatomical entity', 'cell phenotype', 'number of platelet phenotype', 'Multiple cutaneous malignancies', 'integumental system', 'structure with developmental contribution from neural crest', 'neoplasm phenotype', 'number of myeloid cell phenotype', 'integument phenotype', 'Neoplasm', 'skin of body phenotype', 'skeletal system phenotype', 'Osteomyelitis', 'Abnormality of the musculoskeletal system', 'inflammatory response phenotype', 'response to stress', 'increased qualitatively inflammatory response', 'digestive system element phenotype', 'intestine morphology phenotype', 'integumental system phenotype', 'skeletal system', 'musculoskeletal system', 'musculoskeletal system physiology phenotype', 'Abnormal inflammatory response', 'Increased inflammatory response', 'Abnormal musculoskeletal physiology', 'bone element', 'skeletal element', 'small intestinal bleeding; small intestine hemorrhage', 'alimentary part of gastrointestinal system morphology phenotype', 'alimentary part of gastrointestinal system phenotype', 'intestine', 'increased qualitatively biological_process', 'response to stress phenotype', 'bone element phenotype', 'increased inflammatory response', 'biological_process rate phenotype', 'respiratory system morphology phenotype', 'anatomical system phenotype', 'alimentary part of gastrointestinal system', 'anatomical entity morphology phenotype', 'response to stimulus', 'subdivision of organism along main body axis phenotype', 'Abnormality of the integument', 'system', 'body part movement', 'Neoplasm of the skin', 'voluntary movement behavior', 'skeletal muscle organ, vertebrate', 'epithelium', 'thoracic cavity element', 'developing mesenchymal structure phenotype', 'respiratory tract', 'muscle organ', 'increased inflammatory response in bone element', 'nervous system process phenotype', 'serous membrane', 'anatomical structure phenotype', 'biological_process phenotype', 'respiratory system morphology', 'multicellular anatomical structure physiology phenotype', 'pneumothorax', 'phenotype', 'digestive tract', 'primordium', 'endoderm-derived structure phenotype', 'endocrine gland', 'anatomical conduit', 'organism subdivision', 'multi-tissue structure', 'disconnected anatomical group', 'entire embryonic mesenchyme', 'subdivision of trunk', 'germ layer / neural crest phenotype', 'biological_process', 'multicellular organismal process', 'endoderm morphology phenotype', 'nucleate cell', 'digestive tract epithelium', 'presumptive structure phenotype', 'secretory cell', 'lateral structure phenotype', 'muscle system process', 'athetosis; athetotic walking movements', 'embryonic tissue phenotype', 'pleura', 'taxon specific phenotype', 'presumptive structure', 'anatomical entity phenotype', 'organism subdivision phenotype', 'cell', 'viscus phenotype', 'voluntary musculoskeletal movement', 'embryonic tissue morphology phenotype', 'muscle system process phenotype', 'anatomical conduit phenotype', 'cellular organisms', 'increased biological_process in bone element', 'tissue phenotype', 'Abnormality of the skin', 'subdivision of organism along main body axis', 'skeletal muscle contraction phenotype', 'increased response to stimulus', 'occurrent', 'endocrine system phenotype', 'lung phenotype', 'Respiratory tract infection', 'musculoskeletal movement', 'primordium phenotype', 'anatomical system physiology phenotype', 'inflammatory response', 'foregut', 'material entity', 'pleura phenotype', 'decreased number of anatomical entity', 'skeletal element phenotype', 'anatomical structure physiology phenotype', 'tissue', 'muscle organ phenotype', 'multicellular organismal process phenotype', 'presomitic mesoderm', 'serotonin secreting cell', 'nervous system process', 'thoracic segment organ phenotype', 'trunk mesenchyme phenotype', 'pancytopenia', 'behavior process', 'digestive tract epithelium phenotype', 'material anatomical entity', 'parathyroid gland physiology phenotype', 'endocrine gland phenotype', 'endoderm of foregut', 'Metazoa', 'mesenchyme', 'small intestine phenotype', 'organ phenotype', 'non-connected functional system', 'musculature', 'musculature of body phenotype', 'increased qualitatively response to stimulus', 'endo-epithelium', 'biological_process in muscle organ phenotype', 'embryo phenotype', 'striated muscle contraction', 'developing anatomical structure phenotype', 'lower respiratory tract', 'Abnormal bone marrow cell morphology', 'endocrine system', 'increased defense response in bone element', 'respiratory system phenotype', 'subdivision of digestive tract phenotype', 'proximo-distal subdivision of respiratory tract', 'body proper', 'anatomical entity', 'structure with developmental contribution from neural crest phenotype', 'muscle tissue', 'endo-epithelium phenotype', 'multicellular anatomical structure phenotype', 'muscle structure phenotype', 'Abnormality of the respiratory system', 'digestive system element', 'foregut phenotype', 'embryo morphology phenotype', 'myotome phenotype', 'material anatomical entity phenotype', 'thoracic segment organ', 'mesoderm-derived structure phenotype', 'trunk region element phenotype', 'lung morphology phenotype', 'continuant', 'multicellular organism morphology phenotype', 'erythroid lineage cell', 'germ layer', 'Pneumothorax', 'Abnormality of immune system physiology', 'decreased number of anatomical structure', 'viscus', 'defense response phenotype', 'Eukaryota', 'organ part phenotype', 'anatomical system', 'multicellular organism phenotype', 'germ layer morphology phenotype', 'Neoplasm by anatomical site', 'intestine phenotype', 'muscle structure', 'dense mesenchyme tissue phenotype', 'Recurrent respiratory infections', 'compound organ', 'immune system physiology phenotype', 'Abnormal respiratory system morphology', 'mesenchyme phenotype', 'serous sac', 'Abnormality of the immune system', 'parathyroid gland', 'respiratory airway', 'increased response to stress in bone element', 'multilaminar epithelium phenotype', 'voluntary musculoskeletal movement phenotype', 'Abnormal pleura morphology', 'trunk phenotype', 'anatomical collection phenotype', 'pleural sac', 'gland', 'independent continuant', 'serous membrane phenotype', 'subdivision of trunk phenotype', 'anatomical cluster phenotype', 'main body axis', 'small intestine', 'respiratory system physiology phenotype', 'Abnormal lung morphology', 'decreased activity of parathyroid; hypoparathyroidism', 'trunk region element', 'epithelial vesicle phenotype', 'embryo', 'behavior process phenotype', 'embryonic structure', 'presomitic mesoderm phenotype', 'parathyroid gland phenotype', 'response to stimulus phenotype', 'respiration organ', 'voluntary movement behavior phenotype', 'hemolymphoid system', 'number of anatomical enitites of type anatomical structure phenotype', 'unilaminar epithelium', 'lung', 'subdivision of tube phenotype', 'pleura morphology phenotype', 'organ part', 'tube phenotype', 'musculature of body', 'organ system subdivision phenotype', 'kinesthetic behavior', 'digestive system morphology phenotype', 'germ layer / neural crest', 'Recurrent infections', 'thoracic cavity element phenotype', 'embryonic structure phenotype', 'germ layer phenotype', 'somite', 'Unusual infection', 'embryonic tissue', 'foregut epithelium', 'All', 'foregut epithelium phenotype', 'root', 'developing mesenchymal structure', 'skeletal muscle organ, vertebrate phenotype', 'lateral structure', 'mesoderm-derived structure', 'anatomical wall', 'epithelial vesicle', 'muscle tissue phenotype', 'endoderm of foregut phenotype', 'anatomical collection', 'skeletal musculature', 'gland phenotype', 'endoderm-derived structure', 'bone cell', 'digestive system', 'proximo-distal subdivision of respiratory tract phenotype', 'trunk mesenchyme', 'dense mesenchyme tissue', 'integument', 'skeletal muscle contraction', 'neuromuscular process', 'organ', 'muscle contraction', 'organ physiology phenotype', 'endocrine gland physiology phenotype', 'endoderm phenotype', 'paraxial mesoderm', 'Multiple bilateral pneumothoraces', 'voluntary skeletal muscle contraction phenotype', 'respiratory system', 'increased response to stimulus in bone element', 'epithelium phenotype', 'presumptive paraxial mesoderm', 'increased biological_process', 'blastula', 'unilaminar epithelium phenotype', 'blood cell phenotype', 'behavior phenotype', 'musculoskeletal movement phenotype', 'system process phenotype', 'skin of body', 'gland physiology phenotype', 'anatomical entity physiology phenotype', 'paraxial mesoderm phenotype', 'process', 'multi-tissue structure phenotype', 'trunk', 'anatomical cluster', 'decreased number of leukocyte', 'entity', 'pair of lungs', 'myotome', 'decreased number of platelet', 'endoderm', 'multilaminar epithelium', 'voluntary skeletal muscle contraction', 'tube', 'digestive system phenotype', 'material anatomical entity physiology phenotype', 'presumptive paraxial mesoderm phenotype', 'eukaryotic cell', 'compound organ phenotype', 'neuromuscular process phenotype', 'hematopoietic system', 'Phenotypic abnormality', 'muscle contraction phenotype', 'multicellular organismal movement phenotype', 'defense response', 'respiration organ phenotype', 'motile cell', 'Opisthokonta', 'behavior', 'anatomical structure', 'system process', 'number of leukocyte phenotype', 'somite phenotype', 'striated muscle contraction phenotype', 'anatomical wall phenotype', 'skeletal musculature phenotype', 'phenotypic effect', 'developing anatomical structure', 'musculoskeletal system phenotype', 'organ system subdivision', 'thoracic segment of trunk', 'foregut morphology phenotype', 'Recurrent lower respiratory tract infections', 'glandular system', 'multicellular anatomical structure', 'multicellular organism', 'bone marrow', 'subdivision of tube', 'subdivision of digestive tract', 'Eumetazoa', 'immune system phenotype', 'multicellular organismal movement', 'musculature phenotype', 'immune system'], 'has_descendant': ['MONDO:0009217', 'MONDO:0100578'], 'has_descendant_label': ['Fanconi-like syndrome', 'FANCM Fanconi-like genomic instability disorder'], 'has_descendant_count': 2, 'highlighting': None}, {'id': 'MONDO:1011502', 'category': 'biolink:Disease', 'name': 'Fanconi syndrome, cattle', 'description': 'Fanconi syndrome that occurs in cattle.', 'xref': ['OMIA:000366-9913'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:1011502'], 'has_descendant_label': ['Fanconi syndrome, cattle'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0007600', 'category': 'biolink:Disease', 'name': 'primary Fanconi syndrome', 'description': 'A condition in which the kidneys do not absorb certain substances into the body. These substances, such as cysteine, fructose, galactose, or glycogen, are lost in the urine. Fanconi syndrome is thought to be caused by genetic and environmental factors, and it may be diagnosed at any age. Symptoms of Fanconi syndrome include increased urine production (which may cause dehydration), weakness, and abnormalities of the bones.', 'xref': ['GARD:9118', 'MEDGEN:341765', 'NCIT:C123229', 'Orphanet:3337', 'UMLS:C1857395'], 'synonym': ['FRTS1', 'Fanconi renotubular syndrome 1', 'primary Fanconi renotubular syndrome'], 'narrow_synonym': ['FRTS1', 'Fanconi renotubular syndrome 1', 'primary Fanconi renotubular syndrome'], 'subsets': ['gard_rare', 'ordo_disorder', 'orphanet_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0012606', 'HP:0003774', 'HP:0002049', 'HP:0002659', 'HP:0000117', 'HP:0001510', 'HP:0001324', 'HP:0001944', 'HP:0002900', 'HP:0001943', 'HP:0002148', 'HP:0032943', 'HP:0002150', 'HP:0002206', 'HP:0004910', 'HP:0002653', 'HP:0003126', 'HP:0003081', 'HP:0003149', 'HP:0002749', 'HP:0003076', 'HP:0012622', 'HP:0002909', 'HP:0003646', 'HP:0003537', 'HP:0004912', 'HP:0004918', 'HP:0003234', 'HP:0001824'], 'has_phenotype_label': ['Hypouricemia', 'Osteomalacia', 'Chronic kidney disease', 'Bone pain', 'Hypokalemia', 'Hypercalciuria', 'Proximal renal tubular acidosis', 'Muscle weakness', 'Stage 5 chronic kidney disease', 'Pulmonary fibrosis', 'Renal sodium wasting', 'Hypophosphatemic rickets', 'Hyperuricosuria', 'Increased urinary potassium', 'Bicarbonate-wasting renal tubular acidosis', 'Weight loss', 'Hypophosphatemia', 'Renal phosphate wasting', 'Bicarbonaturia', 'Hypoglycemia', 'Decreased circulating carnitine concentration', 'Generalized aminoaciduria', 'Low-molecular-weight proteinuria', 'Hyperchloremic metabolic acidosis', 'Abnormal urine pH', 'Glycosuria', 'Growth delay', 'Increased susceptibility to fractures', 'Dehydration'], 'has_phenotype_count': 29, 'has_phenotype_closure': ['HP:0004910', 'UPHENO:0082761', 'UPHENO:7000293', 'UPHENO:0082794', 'UPHENO:0069327', 'UPHENO:0010808', 'UPHENO:0010850', 'UPHENO:0069254', 'UPHENO:0069062', 'UPHENO:0054315', 'UPHENO:0010795', 'HP:0003149', 'UPHENO:0051608', 'UPHENO:0051849', 'UPHENO:0068296', 'HP:0004918', 'UPHENO:0003182', 'UBERON:0003089', 'UPHENO:7000390', 'UPHENO:0076695', 'UPHENO:0010799', 'UPHENO:0010763', 'UBERON:0003059', 'HP:0001824', 'UPHENO:0086505', 'UPHENO:0002543', 'UBERON:0005856', 'UPHENO:0002813', 'UBERON:0011138', 'UPHENO:0004545', 'UBERON:0000307', 'UBERON:0000075', 'CHEBI:36916', 'CHEBI:36914', 'HP:0010929', 'CHEBI:36915', 'HP:0010930', 'HP:0002900', 'UBERON:0007285', 'UPHENO:0089756', 'UPHENO:0051645', 'HP:0012610', 'UPHENO:0046283', 'UPHENO:0068565', 'CHEBI:37622', 'HP:0003126', 'CHEBI:15841', 'HP:0000093', 'CHEBI:16541', 'PR:000000001', 'UPHENO:0051673', 'UPHENO:0050064', 'UPHENO:0050065', 'HP:0001944', 'UPHENO:0002261', 'UBERON:0000915', 'UBERON:0004921', 'HP:0003081', 'UBERON:0000072', 'UBERON:0000949', 'UBERON:0003258', 'HP:0002206', 'UPHENO:0005257', 'UPHENO:0087660', 'UBERON:0005178', 'UBERON:0001132', 'UPHENO:0003086', 'UBERON:0001005', 'UBERON:0002530', 'UBERON:0004119', 'UPHENO:0068971', 'UBERON:0000171', 'UPHENO:0088582', 'UBERON:0015204', 'UPHENO:0004481', 'UBERON:0001041', 'UBERON:0001558', 'UBERON:0003929', 'UPHENO:0087359', 'UPHENO:0087662', 'UPHENO:0002529', 'UBERON:0002048', 'UPHENO:0086908', 'UPHENO:0004094', 'UBERON:0001004', 'HP:0006530', 'UPHENO:0002679', 'UBERON:0000490', 'HP:0012252', 'UBERON:0000925', 'UPHENO:0076803', 'HP:0020129', 'UPHENO:0002434', 'UBERON:0000065', 'UBERON:0001555', 'UBERON:0002075', 'UPHENO:0080559', 'UPHENO:0002648', 'UPHENO:0002988', 'UPHENO:0076299', 'HP:0000117', 'HP:0012599', 'HP:0004359', 'UPHENO:0084541', 'UPHENO:0051777', 'UPHENO:0034319', 'HP:0025354', 'CHEBI:35281', 'CHEBI:26469', 'CHEBI:35366', 'CHEBI:83821', 'UPHENO:0004443', 'CHEBI:28868', 'CHEBI:27369', 'GO:0043227', 'UPHENO:0089735', 'CHEBI:35284', 'GO:0043231', 'GO:0110165', 'UPHENO:0051628', 'HP:0010996', 'CHEBI:29067', 'GO:0005575', 'HP:0012103', 'HP:0010967', 'GO:0005622', 'UPHENO:0051881', 'UPHENO:0084472', 'HP:0003234', 'HP:0003287', 'UPHENO:0006889', 'UPHENO:0089739', 'HP:0003119', 'UPHENO:0046337', 'HP:0011017', 'UPHENO:0068024', 'UPHENO:0081550', 'UBERON:0011585', 'HP:0010966', 'UPHENO:0082544', 'GO:0001503', 'UPHENO:7000586', 'HP:0003330', 'CL:0000232', 'UPHENO:0002994', 'CL:0000738', 'UPHENO:0002388', 'UPHENO:0004891', 'HP:0004354', 'CL:0000764', 'CL:0000842', 'UPHENO:0082834', 'UPHENO:0088162', 'UPHENO:7000393', 'UPHENO:0085602', 'UPHENO:0002579', 'CL:0000081', 'UPHENO:0002270', 'HP:0011842', 'UPHENO:0085566', 'HP:0002748', 'UPHENO:0080010', 'HP:0012598', 'HP:0004349', 'CL:0000542', 'UBERON:0002405', 'UBERON:0015203', 'CHEBI:18059', 'HP:0000924', 'CL:0002242', 'CL:0000219', 'UPHENO:0084654', 'CHEBI:25699', 'CHEBI:33692', 'UPHENO:0002267', 'HP:0002659', 'UPHENO:0085578', 'UPHENO:0068169', 'CHEBI:36962', 'CHEBI:33582', 'UPHENO:0052178', 'UPHENO:7000414', 'UPHENO:7000815', 'UPHENO:0002568', 'UBERON:0007530', 'CHEBI:24431', 'UPHENO:0081547', 'UPHENO:0081440', 'UBERON:0000179', 'UPHENO:7000319', 'UPHENO:0089921', 'UBERON:0005751', 'UPHENO:0002554', 'UPHENO:0089764', 'HP:0001995', 'CHEBI:17234', 'UBERON:0002368', 'GO:0033500', 'UPHENO:0068491', 'UPHENO:0052160', 'UBERON:0001229', 'UPHENO:0002443', 'UPHENO:0002746', 'HP:0004348', 'UBERON:0000463', 'UPHENO:0002559', 'UPHENO:0002902', 'UBERON:0002193', 'UPHENO:0034276', 'UPHENO:0055032', 'UPHENO:7000630', 'UPHENO:0077817', 'CL:0000066', 'UPHENO:0066951', 'UBERON:0001630', 'BFO:0000003', 'UPHENO:0004885', 'CL:0000226', 'HP:0000001', 'UPHENO:0003094', 'UPHENO:0051739', 'UPHENO:0075902', 'UPHENO:0002909', 'UPHENO:0003025', 'UPHENO:0002859', 'UPHENO:0003941', 'CHEBI:36359', 'UBERON:0002417', 'UPHENO:0051900', 'CHEBI:33671', 'UPHENO:7000318', 'CHEBI:33608', 'CHEBI:33693', 'CL:0002522', 'UBERON:0005256', 'UPHENO:7000595', 'UPHENO:0004418', 'HP:0002749', 'UBERON:0003918', 'UPHENO:0004900', 'HP:0003110', 'UPHENO:0002685', 'CHEBI:33655', 'CL:1000497', 'CHEBI:36902', 'UPHENO:0088123', 'UBERON:0005423', 'UBERON:0000063', 'UPHENO:0003413', 'UPHENO:0004680', 'CHEBI:22860', 'UPHENO:0081544', 'CL:0000329', 'UPHENO:0082875', 'HP:0011014', 'CL:1000450', 'CL:0002518', 'CHEBI:33917', 'UPHENO:0002634', 'UPHENO:0068251', 'UBERON:0011216', 'UBERON:0004765', 'UBERON:0000058', 'UPHENO:0046284', 'GO:0007588', 'UBERON:0001225', 'UPHENO:0003381', 'UPHENO:0000543', 'UPHENO:0002576', 'CHEBI:17126', 'HP:0025142', 'UPHENO:0080555', 'UPHENO:0002385', 'CHEBI:18282', 'UBERON:0001007', 'UBERON:0034925', 'UPHENO:0051686', 'UBERON:0004188', 'UPHENO:0002308', 'UBERON:0000475', 'UBERON:0000479', 'CHEBI:33579', 'UPHENO:0002642', 'UPHENO:0066927', 'UPHENO:0002734', 'UPHENO:0046356', 'UPHENO:0049587', 'UPHENO:0085627', 'HP:0011032', 'HP:0002148', 'UPHENO:0034522', 'UPHENO:0002870', 'UBERON:0003133', 'UBERON:0000178', 'UPHENO:0034253', 'UBERON:0005181', 'UPHENO:0002832', 'UBERON:0001048', 'HP:0011804', 'UBERON:0004819', 'UPHENO:0087849', 'UBERON:0000174', 'UBERON:0001130', 'UPHENO:0046348', 'HP:0011277', 'UPHENO:7000428', 'UPHENO:0002765', 'UPHENO:0005277', 'UPHENO:0002525', 'UBERON:0000061', 'UPHENO:0002793', 'UPHENO:7000308', 'UBERON:0003104', 'UPHENO:0054970', 'UPHENO:0005201', 'CL:0002584', 'UPHENO:0050433', 'HP:0004325', 'UPHENO:0003084', 'CHEBI:33672', 'UBERON:0001062', 'UPHENO:0002527', 'CL:0000255', 'UPHENO:0005141', 'UBERON:0000467', 'UPHENO:0005092', 'UPHENO:0002564', 'UPHENO:0084653', 'UPHENO:0050078', 'UBERON:0005721', 'UPHENO:0002442', 'UPHENO:0001001', 'CL:0002681', 'GO:0043226', 'UBERON:0004122', 'CHEBI:37577', 'UPHENO:0001002', 'UBERON:0000477', 'UPHENO:0003867', 'UPHENO:0082835', 'HP:0011279', 'UBERON:0003060', 'UPHENO:0004505', 'UPHENO:0046286', 'UPHENO:0002976', 'UPHENO:0046344', 'UPHENO:0003093', 'UBERON:0002329', 'CHEBI:23367', 'HP:0012337', 'GO:0040007', 'UPHENO:0076703', 'UPHENO:0005000', 'CHEBI:36963', 'BFO:0000004', 'CHEBI:50047', 'UPHENO:0002311', 'UPHENO:0077826', 'UPHENO:0002943', 'HP:0012591', 'UPHENO:0004459', 'UPHENO:0089724', 'UPHENO:0003055', 'UBERON:0000916', 'CHEBI:50860', 'GO:0009987', 'UBERON:0005291', 'UPHENO:0002571', 'UBERON:0012275', 'UBERON:0001285', 'UBERON:0005173', 'CHEBI:25741', 'UPHENO:0050791', 'UPHENO:0002386', 'UPHENO:0049873', 'UBERON:0015833', 'HP:0000118', 'UBERON:0000922', 'CHEBI:33674', 'UPHENO:0005537', 'CHEBI:25806', 'UPHENO:0002567', 'CL:1000449', 'UPHENO:0002569', 'UPHENO:0002411', 'UPHENO:0002531', 'UPHENO:7000377', 'UBERON:0002120', 'UPHENO:0080012', 'UBERON:0000489', 'UPHENO:0002963', 'BFO:0000015', 'UPHENO:0003999', 'GO:0043229', 'UPHENO:0005015', 'UPHENO:0089737', 'HP:0001939', 'UPHENO:0051979', 'UBERON:0005156', 'UBERON:0009569', 'UPHENO:0003191', 'UPHENO:7000381', 'UPHENO:0005002', 'UPHENO:0086172', 'CHEBI:26216', 'UPHENO:0066903', 'UBERON:0007503', 'UPHENO:0050619', 'UPHENO:0002833', 'CL:0000000', 'CHEBI:26082', 'UBERON:0004176', 'UBERON:0000990', 'UPHENO:0002964', 'UPHENO:0002526', 'UPHENO:7000809', 'UPHENO:0054954', 'CHEBI:22984', 'UBERON:0002204', 'UPHENO:0004143', 'UBERON:0000926', 'UPHENO:0054304', 'HP:0000077', 'UPHENO:0002803', 'UBERON:0009201', 'UPHENO:0004683', 'UBERON:0000483', 'UBERON:0002050', 'CL:1000612', 'HP:0012606', 'UPHENO:0002731', 'CHEBI:33635', 'UBERON:0000383', 'UBERON:0001851', 'UPHENO:0087433', 'UPHENO:0051763', 'UPHENO:0085616', 'GO:0030421', 'UPHENO:0048707', 'UPHENO:0002926', 'UPHENO:0004892', 'UPHENO:0003185', 'UPHENO:0002530', 'UPHENO:0003088', 'UPHENO:0005285', 'UPHENO:0005110', 'UBERON:0009142', 'HP:0004323', 'CHEBI:33304', 'UPHENO:0067998', 'UBERON:0000465', 'UPHENO:0002542', 'UBERON:0004111', 'UBERON:0015212', 'UPHENO:0049904', 'UPHENO:0066964', 'CHEBI:16670', 'CHEBI:33559', 'UBERON:0006553', 'UPHENO:0055082', 'UPHENO:0051619', 'UPHENO:0003209', 'UPHENO:0080556', 'UPHENO:0076294', 'UBERON:0002113', 'UBERON:0011143', 'UBERON:0000025', 'HP:0000119', 'UPHENO:0004503', 'BFO:0000002', 'UBERON:0013701', 'HP:0011849', 'UPHENO:0076286', 'UPHENO:0066739', 'CHEBI:33675', 'CHEBI:35352', 'UBERON:0010316', 'HP:0010932', 'UPHENO:7000307', 'UBERON:0004120', 'UPHENO:0003430', 'CHEBI:35757', 'UPHENO:0050416', 'UBERON:0001434', 'UBERON:0001230', 'UBERON:0011676', 'UBERON:0000353', 'UPHENO:0050116', 'UPHENO:0003163', 'UPHENO:0079822', 'UBERON:0034923', 'HP:0003076', 'UPHENO:0002595', 'UBERON:0005090', 'UPHENO:0051804', 'UPHENO:0003050', 'UPHENO:0003550', 'UPHENO:0002949', 'UBERON:0007684', 'UPHENO:0048750', 'UPHENO:0081581', 'UPHENO:0005312', 'UPHENO:3000004', 'UPHENO:0003265', 'UBERON:0013702', 'UPHENO:0002636', 'CL:1000510', 'UPHENO:0049835', 'UBERON:0006555', 'CL:0000653', 'UPHENO:0004360', 'UBERON:0000064', 'UPHENO:7000320', 'UPHENO:0003432', 'UPHENO:0002541', 'CHEBI:26020', 'UBERON:0002100', 'UBERON:0003077', 'UPHENO:0051709', 'UPHENO:0002269', 'UBERON:0010000', 'CHEBI:35875', 'HP:0002653', 'CL:1000746', 'UPHENO:0005075', 'HP:0002049', 'UBERON:0007688', 'UPHENO:0003382', 'UBERON:0006598', 'HP:0001943', 'UBERON:0000468', 'UBERON:0005172', 'UPHENO:0046281', 'UPHENO:0080377', 'UPHENO:0002574', 'BFO:0000001', 'CHEBI:25384', 'CL:0000424', 'UBERON:0005177', 'UPHENO:0002668', 'UPHENO:0075195', 'CL:0000988', 'UPHENO:0068036', 'HP:0032943', 'HP:0000079', 'UPHENO:0002754', 'UBERON:0000062', 'UBERON:0003061', 'UPHENO:0084537', 'UBERON:0004211', 'UPHENO:7000317', 'CL:0000945', 'UPHENO:0002536', 'UPHENO:0066943', 'CHEBI:36357', 'UPHENO:7000623', 'CHEBI:24835', 'CHEBI:16646', 'CHEBI:18133', 'CHEBI:33256', 'GO:0042593', 'HP:0002157', 'CHEBI:15693', 'CHEBI:33659', 'UBERON:0003081', 'CHEBI:33285', 'HP:0033354', 'CHEBI:78616', 'HP:0003355', 'UPHENO:0089730', 'UPHENO:7000212', 'UPHENO:0052002', 'UPHENO:0051637', 'UPHENO:0049628', 'CHEBI:52625', 'CHEBI:33575', 'UPHENO:0034308', 'GO:0048878', 'CHEBI:33242', 'UPHENO:0087665', 'UPHENO:0089294', 'UPHENO:0046383', 'UPHENO:0054955', 'UPHENO:0068110', 'UPHENO:0003234', 'HP:0011280', 'CHEBI:33318', 'UBERON:0000083', 'UPHENO:0004969', 'CHEBI:24532', 'UPHENO:0089770', 'UPHENO:0004536', 'UPHENO:0003159', 'UPHENO:0003207', 'UBERON:0001088', 'UBERON:0003074', 'UPHENO:0068134', 'CHEBI:26079', 'CHEBI:15377', 'HP:0002150', 'GO:1901570', 'CHEBI:22313', 'HP:0012603', 'UBERON:0001008', 'UPHENO:0051887', 'UPHENO:0002523', 'UPHENO:0051712', 'CHEBI:22314', 'UPHENO:0068442', 'HP:6000531', 'BFO:0000040', 'UPHENO:0068054', 'UPHENO:0080658', 'UPHENO:0034351', 'UPHENO:0068556', 'UPHENO:0068064', 'UBERON:0007524', 'UPHENO:0051736', 'HP:0430071', 'CHEBI:25367', 'CHEBI:37176', 'UPHENO:0066925', 'UPHENO:0089745', 'UPHENO:0002281', 'CHEBI:35406', 'UPHENO:0066781', 'CHEBI:33839', 'GO:0065007', 'HP:0032180', 'CHEBI:33832', 'CHEBI:5686', 'CHEBI:33636', 'UPHENO:0002547', 'CHEBI:72695', 'CHEBI:32988', 'CHEBI:33595', 'HP:0012531', 'CHEBI:33302', 'CHEBI:26401', 'UPHENO:0069266', 'HP:0004364', 'CHEBI:25810', 'HP:0001941', 'CHEBI:27226', 'UPHENO:0004482', 'CHEBI:22563', 'UPHENO:0051635', 'CHEBI:38101', 'UPHENO:0088134', 'CHEBI:27171', 'UBERON:0013522', 'UPHENO:0055067', 'HP:0100529', 'CHEBI:33241', 'UPHENO:0002558', 'UBERON:0000080', 'HP:0001942', 'CHEBI:33259', 'UPHENO:0066960', 'UPHENO:0002783', 'CHEBI:24870', 'UPHENO:0002816', 'CHEBI:33521', 'HP:0003111', 'UBERON:0000481', 'CHEBI:36360', 'UPHENO:7000394', 'UPHENO:0002577', 'UPHENO:0051960', 'UPHENO:0024906', 'UBERON:0005911', 'CHEBI:33238', 'UBERON:0003103', 'CHEBI:24867', 'GO:0005739', 'HP:0012211', 'GO:0065008', 'UPHENO:0053346', 'UPHENO:0005596', 'CHEBI:24833', 'UBERON:0001988', 'UPHENO:0049874', 'UPHENO:0002822', 'HP:0001510', 'UPHENO:0002532', 'UPHENO:0000541', 'HP:0001507', 'CHEBI:26708', 'UPHENO:0002422', 'CHEBI:33709', 'UPHENO:0002360', 'UPHENO:0002426', 'HP:0012622', 'UPHENO:0034199', 'UPHENO:0002427', 'HP:0003774', 'CHEBI:33833', 'HP:0010935', 'UPHENO:0002246', 'HP:0025745', 'CHEBI:36587', 'GO:0008150', 'UBERON:0005103', 'UPHENO:0068144', 'UPHENO:0066939', 'CHEBI:35605', 'CHEBI:64709', 'UPHENO:0080662', 'CHEBI:36358', 'UPHENO:0054961', 'UBERON:0000170', 'GO:0046951', 'UPHENO:0002948', 'UBERON:0002390', 'UPHENO:7000321', 'HP:0004912', 'HP:0004360', 'GO:1901568', 'UPHENO:0055132', 'PR:000018263', 'UPHENO:0055153', 'UPHENO:0087123', 'UPHENO:0051766', 'HP:0002909', 'UPHENO:7000306', 'UPHENO:0004791', 'GO:0042592', 'UPHENO:0001003', 'UPHENO:0050220', 'GO:0044238', 'UPHENO:0049995', 'CHEBI:51143', 'GO:0022600', 'GO:0009058', 'GO:0044281', 'UPHENO:0054374', 'UPHENO:0066921', 'UBERON:0001474', 'UBERON:0000074', 'UPHENO:7000309', 'UBERON:0006314', 'UBERON:0000923', 'UPHENO:0066950', 'UPHENO:0049618', 'GO:0006629', 'UBERON:0003914', 'UPHENO:0055006', 'UPHENO:0005433', 'UPHENO:0086482', 'HP:0011042', 'UPHENO:0049703', 'UPHENO:0066954', 'CHEBI:60242', 'UPHENO:0002252', 'UBERON:0009773', 'UPHENO:0054967', 'UPHENO:0002320', 'UPHENO:0005579', 'CHEBI:33250', 'UPHENO:0055077', 'UPHENO:0055014', 'UPHENO:0002248', 'CHEBI:24651', 'UPHENO:7000305', 'HP:0033127', 'CHEBI:36586', 'UPHENO:0051460', 'UPHENO:0002359', 'UPHENO:0055071', 'UPHENO:0086480', 'UPHENO:0002210', 'UPHENO:7000208', 'UBERON:0003064', 'GO:0006091', 'HP:0000124', 'UPHENO:0002346', 'UPHENO:0066959', 'UPHENO:0005539', 'UPHENO:0075159', 'UPHENO:0049723', 'UPHENO:0088170', 'UPHENO:0076692', 'UPHENO:0050121', 'HP:0011015', 'GO:0003008', 'UBERON:0008987', 'UBERON:0001231', 'UPHENO:0002287', 'CHEBI:51151', 'UPHENO:0005517', 'CHEBI:25696', 'GO:0050878', 'GO:0032501', 'UPHENO:0066913', 'UPHENO:0050106', 'UPHENO:7000382', 'UPHENO:0002448', 'UBERON:8450002', 'UPHENO:0052165', 'HP:0001947', 'GO:0007586', 'CL:0000236', 'GO:0044283', 'CL:0000763', 'GO:0008610', 'UPHENO:0003116', 'GO:1902224', 'UPHENO:0088166', 'UBERON:0001015', 'UPHENO:0050240', 'HP:0011843', 'UPHENO:0003022', 'HP:0003011', 'GO:0008152', 'HP:0003537', 'UPHENO:0003047', 'HP:0000083', 'CHEBI:35381', 'HP:0001324', 'UPHENO:0084542', 'HP:0002088', 'HP:0003646', 'UPHENO:0002377', 'CHEBI:35604', 'HP:0002086', 'CHEBI:33273', 'GO:0005737', 'CHEBI:38166', 'UPHENO:0066946', 'CHEBI:17544', 'UPHENO:0051714'], 'has_phenotype_closure_label': ['Bicarbonate-wasting renal tubular acidosis', 'decreased bone element strength', 'b cell morphology', 'Osteomalacia', 'decreased size of the anatomical structure', 'decreased size of the material anatomical entity', 'decreased size of the multicellular organism', 'multicellular anatomical structure mass phenotype', 'decreased size of the anatomical entity', 'Decreased body weight', 'decreased anatomical structure mass', 'decreased material anatomical entity mass', 'multicellular organism mass phenotype', 'Decreased multicellular organism mass', 'Abnormality of urinary uric acid level', 'urine uric acid level phenotype', 'Hyperuricosuria', 'increased level of potassium atom in urine', 'Increased urinary potassium', 'Hyperchloremic acidosis', 'paraxial mesoderm morphology phenotype', 'subdivision of skeletal system phenotype', 'presumptive paraxial mesoderm phenotype', 'presomitic mesoderm phenotype', 'vertebral column morphology phenotype', 'postcranial axial skeletal system', 'cell condensation', 'fragile skeleton; increased susceptibility to fractures', 'sclerotome morphology phenotype', 'presomitic mesoderm', 'vertebral column phenotype', 'migrating mesenchyme population phenotype', 'presomitic mesoderm morphology phenotype', 'paraxial mesoderm', 'cell condensation phenotype', 'somite phenotype', 'Hypokalemia', 'blood potassium atom level phenotype', 'blood monovalent inorganic cation level phenotype', 'Abnormal blood monovalent inorganic cation concentration', 'cation', 'decreased level of potassium atom in blood', 'Abnormal circulating potassium concentration', 'potassium atom', 'Abnormal blood cation concentration', 'primary amide', 'carboxamide', 'increased level of protein polypeptide chain in urine', 'protein polypeptide chain', 'amino acid chain', 'peptide', 'polypeptide', 'Proteinuria', 'inorganic ion', 'Low-molecular-weight proteinuria', 'protein', 'biological regulation phenotype', 'regulation of biological quality', 'regulation of body fluid levels phenotype', 'Abnormality of fluid regulation', 'nausea', 'dehydration', 'digestive system morphology phenotype', 'endocrine gland phenotype', 'lung phenotype', 'endoderm', 'pair of lungs', 'proximo-distal subdivision of respiratory tract phenotype', 'unilaminar epithelium phenotype', 'viscus phenotype', 'sclerotome phenotype', 'endocrine gland physiology phenotype', 'developing mesenchymal condensation phenotype', 'anatomical collection', 'lung morphology phenotype', 'Abnormal respiratory system morphology', 'glandular system', 'thoracic cavity element phenotype', 'anatomical collection phenotype', 'subdivision of digestive tract phenotype', 'respiratory system morphology', 'respiratory tract', 'endocrine gland', 'respiration organ', 'Pulmonary fibrosis', 'lung', 'Hyperchloremic metabolic acidosis', 'gland phenotype', 'foregut', 'lower respiratory tract', 'Decreased anatomical entity mass', 'decreased activity of parathyroid; hypoparathyroidism', 'parathyroid gland physiology phenotype', 'Abnormal pulmonary interstitial morphology', 'anatomical entity morphology in the respiratory system phenotype', 'foregut phenotype', 'embryo morphology phenotype', 'respiratory airway', 'endoderm-derived structure phenotype', 'digestive tract epithelium phenotype', 'Renal phosphate wasting', 'Abnormal circulating monocarboxylic acid concentration', 'humpback; kyphosis', 'Abnormal cellular physiology', 'Abnormal circulating lipid concentration', 'Abnormality of mitochondrial metabolism', 'amino-acid derivative level phenotype', 'presumptive paraxial mesoderm', 'blood monocarboxylic acid level phenotype', 'quaternary nitrogen compound', 'fatty acid', 'amino-acid derivative', 'monocarboxylic acid anion', 'zwitterion', 'mitochondrion phenotype', 'blood fatty acid anion level phenotype', 'acid bodily fluid level phenotype', 'cellular anatomical structure', 'ammonium betaine', 'carboxylic acid anion', 'amino-acid betaine', 'monocarboxylic acid', 'blood carboxylic acid level phenotype', 'Abnormal circulating carnitine concentration', 'decreased level of carnitine in blood', 'intracellular membrane-bounded organelle', 'intracellular organelle', 'Abnormality of the mitochondrion', 'cellular_component phenotype', 'developing mesenchymal condensation', 'blood carnitine level phenotype', 'erythroid lineage cell', 'decreased level of amino-acid betaine', 'mononuclear leukocyte', 'hemoglobin', 'amino-acid betaine level phenotype', 'Abnormal skeletal morphology', 'leukocyte morphology phenotype', 'erythroid lineage cell morphology phenotype', 'B cell physiology phenotype', 'organ system subdivision physiology phenotype', 'non-connected functional system', 'Reduced bone mineral density', 'B cell', 'hematopoietic cell', 'membrane-bounded organelle', 'oxygen accumulating cell', 'urine protein level phenotype', 'Abnormal circulating carboxylic acid concentration', 'nucleate cell', 'onium betaine', 'skeletal system physiology phenotype', 'skeletal system morphology phenotype', 'bone element mass density phenotype', 'Abnormality of the skeletal system', 'skeletal system', 'Abnormality of bone mineral density', 'decreased multicellular anatomical structure mass', 'anatomical entity mass density phenotype', 'cellular_component', 'bone element', 'leukocyte', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'increased level of uric acid in urine', 'skeletal element', 'Decreased anatomical entity mass density', 'bone structure', 'immune system phenotype', 'blood cell', 'single nucleate cell', 'myeloid cell', 'blood cell phenotype', 'foregut epithelium phenotype', 'Abnormal bone structure', 'anatomical entity morphology phenotype', 'blood cation level phenotype', 'bone element phenotype', 'carnitine', 'Abnormal bone ossification', 'Rickets', 'ossification', 'rickets', 'increased level of purines', 'lymphocyte physiology phenotype', 'hydrogencarbonate level phenotype', 'urine hydrogencarbonate level phenotype', 'duct phenotype', 'lymphocyte', 'tissue chemical entity level phenotype', 'embryonic tissue morphology phenotype', 'Abnormal urine metabolite level', 'Abnormal circulating organic compound concentration', 'subdivision of skeletal system', 'endoderm phenotype', 'intermediate mesoderm phenotype', 'dipolar compound', 'Abnormality of the musculoskeletal system', 'hematopoietic system', 'Phenotypic abnormality', 'polyatomic ion', 'trunk', 'alkali metal atom', 'fatty acid level phenotype', 'Muscle weakness', 'digestive system physiology phenotype', 'multicellular organism chemical entity level phenotype', 'delayed biological_process', 'chalcogen molecular entity', 'endocrine system', 'hemolymphoid system', 'anatomical entity mass phenotype', 'hydrides', 'endoderm of foregut phenotype', 'decreased functionality of the nephron tubule', 'increased level of chemical entity in feces', 'decreased level of chemical entity', 'decreased functionality of the kidney epithelium', 'organism substance', 'growth phenotype', 'carbon group molecular entity', 'decreased functionality of the epithelium', 'decreased level of chemical entity in blood', 'Stage 5 chronic kidney disease', 'Abnormality of urine bicarbonate level', 'main group molecular entity', 'mesonephric tubule', 'polyatomic entity', 'endocrine system phenotype', 'constipation', 'p-block molecular entity', 'mitochondrion', 'alkaline earth metal atom', 'insulin resistance', 'renal duct phenotype', 'Hypophosphatemia', 'digestive tract', 'mesenchyme', 'carbon oxoanion', 'feces chemical entity level phenotype', 'epithelium phenotype', 'heteroarene', 'heteroatomic molecular entity', 'kidney epithelial cell', 'Constitutional symptom', 'amide', 'unilaminar epithelium', 'podocyte', 'material anatomical entity mass phenotype', 'oxoanion', 'Abnormality of the respiratory system', 'developing anatomical structure', 'Decreased bone element mass density', 'phenotypic effect', 'multicellular anatomical structure phenotype', 'homeostasis', 'anatomical conduit phenotype', 'aromatic compound', 'cell physiology phenotype', 'glomerular cell', 'multicellular organism phenotype', 'Dehydration', 'respiratory system morphology phenotype', 'heterocyclic compound', 't cell morphology', 'phosphorus oxoacids and derivatives', 'Growth abnormality', 'increased primary metabolic process', 'carbohydrate', 'Abnormal urine protein level', 'glucose homeostasis phenotype', 'aldohexose', 'podocyte phenotype', 'primordium', 'viscus', 'blood monoatomic ion level phenotype', 'taxon specific phenotype', 'calcium atom level phenotype', 'nucleobase', 'independent continuant', 'intermediate mesoderm', 'decreased functionality of the tissue', 'macromolecule', 'abdomen', 'glomerular capsule', 'mesenchyme phenotype', 'Renal tubular dysfunction', 'epithelial cell of glomerular capsule', 'multicellular organismal process', 'organic anion', 'renal glomerulus', 'increased ketone body metabolic process', 'epithelial vesicle', 'pnictogen molecular entity', 'mesoderm', 'renal glomerulus phenotype', 'ketoacidosis', 'multi-tissue structure phenotype', 'parathyroid gland', 'urine ph', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'tissue phenotype', 'reproductive organ phenotype', 'glomerular visceral epithelium', 'decreased functionality of the renal tubule', 'endoderm-derived structure', 'excretory cell', 'Abnormal circulating fatty-acid concentration', 'biological_process', 'bone ossification', 'eukaryotic cell', 'compound organ phenotype', 'occurrent', 'kidney', 'anatomical system phenotype', 'trunk mesenchyme', 'endoderm of foregut', 'leukocyte physiology phenotype', 'blood glucose level phenotype', 'embryonic tissue phenotype', 'inorganic hydroxy compound', 'pronephric mesoderm', 'anatomical cluster phenotype', 'organ subunit phenotype', 'fatty acid derivative metabolic process', 'mesonephric duct', 'carbohydrates and carbohydrate derivatives', 'lymphocyte of B lineage', 'multicellular organism', 'decreased defecation', 'organ', 'cortex', 'urine amino acid level phenotype', 'detached podocyte; visceral epithelial cell detachment', 'pronephros', 'body proper', 'homeostatic process', 'kidney mesenchyme', 'Abnormality of the urinary system physiology', 'blood nucleobase level phenotype', 'embryo', 'small molecule metabolic process', 'blood fatty acid level phenotype', 'musculature of body', 'hydrogen molecular entity', 'material anatomical entity physiology phenotype', 'urine sodium atom level phenotype', 'nitrogen molecular entity level phenotype', 'pronephros phenotype', 'blood carbohydrate level phenotype', 'decreased qualitatively biological_process', 'epithelial cell', 'kidney epithelium phenotype', 'epithelial tube phenotype', 'musculoskeletal system', 'renal system phenotype', 'increased ketone body biosynthetic process', 'renal cortical epithelial cell', 'decreased biological_process', 'reproductive structure', 'mesoderm-derived structure', 'size of multicellular organism phenotype', 'fatty acid derivative biosynthetic process', 'increased level of water in feces', 'tissue', 'erythrocyte', 'heteroorganic entity', 'tube phenotype', 'aldose', 'Abnormal lung morphology', 'kidney glomerular epithelial cell', 'homeostatic process phenotype', 'feces water level phenotype', 'trunk mesenchyme phenotype', 'external genitalia phenotype', 'increased metabolic process', 'excretory tube physiology phenotype', 'uriniferous tubule', 'decreased functionality of the nephron epithelium', 'anatomical structure physiology phenotype', 'oxygen hydride', 'mesonephric duct phenotype', 'embryo phenotype', 'Abnormal renal physiology', 'digestive system process phenotype', 'anatomical system physiology phenotype', 'endo-epithelium phenotype', 'vomiting', 'material anatomical entity phenotype', 'paraxial mesoderm phenotype', 'erythrocyte morphology phenotype', 'haemolymphatic fluid', 'epithelial cell of nephron', 'trunk region element', 'epithelial vesicle phenotype', 'thoracic cavity element', 'anatomical entity phenotype', 'anion', 'glucose', 'renal parenchyma', 'role blood level phenotype', 'nephric duct', 'foregut epithelium', 'external genitalia', 'Metabolic acidosis', 'meso-epithelium phenotype', 'compound organ', 'cell phenotype', 'parenchyma phenotype', 'germ layer', 'continuant', 'decreased functionality of the anatomical structure', 'water', 'pronephric duct', 'trunk region element phenotype', 'mesoderm-derived structure phenotype', 'material anatomical entity', 'kidney phenotype', 'decreased level of phosphate in blood', 'kidney cortical cell', 'nephron epithelium', 'renal system physiology phenotype', 'abdomen element phenotype', 'thoracic segment organ', 'multi-tissue structure', 'anatomical structure mass phenotype', 'elemental molecular entity', 'ketone body metabolic process', 'chemical entity', 'organism subdivision', 'cyclic compound', 'anatomical conduit', 'role urine level phenotype', 'phenotype', 'metabolic process phenotype', 'increased level of monosaccharide in urine', 'Abnormality of the musculature', 'embryonic tissue', 'renal tubule', 'Abnormal urine pH', 'renal system', 'lung fibrosis', 'Hypoglycemia', 'role bodily fluid level phenotype', 'increased level of chemical entity in tissue', 'proximo-distal subdivision of respiratory tract', 'nephron', 'mesonephric tubule phenotype', 'blood organic molecular entity level phenotype', 'subdivision of digestive tract', 'developing anatomical structure phenotype', 'nephron epithelium phenotype', 'increased biosynthetic process', 'parathyroid gland phenotype', 'mesonephric epithelium', 'genitourinary system phenotype', 'presumptive structure', 'phosphate level phenotype', 'germ layer / neural crest', 'nephric duct phenotype', 'kidney mesenchyme phenotype', 'osteomalacia', 'organ system subdivision phenotype', 'organic molecule', 'tube', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'excretory tube phenotype', 'lipid biosynthetic process', 'Abnormal blood glucose concentration', 'cellular process', 'biological regulation', 'urine chemical entity level phenotype', 'hydroxides', 'chalcogen hydride', 'gland physiology phenotype', 'lipid metabolic process phenotype', 'anatomical entity', 'embryonic structure', 'endoderm morphology phenotype', 'increased lipid metabolic process', 'renal corpuscle', 'diarrhea', 'Abnormality of the genitourinary system', 'organochalcogen compound', 'subdivision of trunk phenotype', 'increased fatty acid derivative metabolic process', 'hexose', 'main body axis', 'upper urinary tract phenotype', 'germ layer / neural crest phenotype', 'intracellular anatomical structure', 'blood lipid level phenotype', 'Abnormal circulating fatty-acid anion concentration', 'subdivision of trunk', 'disconnected anatomical group', 'kidney physiology phenotype', 'abdominal segment element', 'blood phenotype', 'pronephric mesoderm phenotype', 'cavitated compound organ', 'Weight loss', 'material entity', 'organic amino compound', 'excretory system', 'renal/urinary system phenotype', 'biological_process phenotype', 'thoracic segment of trunk', 'Abnormality of urine homeostasis', 'Abnormal circulating nitrogen compound concentration', 'duct', 'anatomical structure phenotype', 'blood uric acid level phenotype', 'genitourinary system', 'upper urinary tract', 'primordium phenotype', 'metabolic process', 'anatomical cluster', 'nitrogen molecular entity', 'mesonephros', 'organ subunit', 'abdominal segment element phenotype', 'feces', 'renal duct', 'kidney cell', 'organism subdivision phenotype', 'pronephric duct phenotype', 'increased qualitatively biological_process', 'anatomical entity physiology phenotype', 'subdivision of organism along main body axis phenotype', 'anatomical structure', 'cavitated compound organ phenotype', 'mesoderm phenotype', 'All', 'organism substance phenotype', 'increased level of hydrogencarbonate in urine', 'Abnormality of the urinary system', 'muscle organ', 'Abnormal urine phosphate concentration', 'growth', 'cortex of kidney', 'Renal sodium wasting', 'renal filtration cell', 'immune system morphology phenotype', 'Generalized aminoaciduria', 'organ part phenotype', 'anatomical system', 'abdominal segment element physiology phenotype', 'parenchyma', 'multicellular anatomical structure physiology phenotype', 'decreased multicellular organismal process', 'nephron phenotype', 'Increased susceptibility to fractures', 'polyatomic anion', 'trunk phenotype', 'monoatomic ion', 'epithelium', 'bodily fluid', 'cortex phenotype', 'phosphorus oxoacid derivative', 'germ layer phenotype', 'decreased level of uric acid in blood', 'regulation of biological quality phenotype', 'epithelium physiology phenotype', 'migrating mesenchyme population', 'organ phenotype', 'decreased level of glucose in blood', 'Abnormality of metabolism/homeostasis', 'mesonephros phenotype', 'foregut morphology phenotype', 'organ system subdivision', 'musculoskeletal system phenotype', 'lateral structure', 'anlage', 'size of anatomical entity phenotype', 'organ part', 'respiratory system phenotype', 'reproductive system', 'epithelial tube', 'entire embryonic mesenchyme', 'abdomen element', 'digestive system', 'glucose homeostasis', 'decreased level of chemical entity in tissue', 'molecule', 'hydrogencarbonate', 'endo-epithelium', 'lateral plate mesoderm phenotype', 'mononuclear parent hydride', 'amino acid level phenotype', 'organic molecular entity', 'oxygen molecular entity', 'immune system', 'increased level of calcium atom in urine', 'haemolymphatic fluid phenotype', 'blood oxygen molecular entity level phenotype', 'anatomical entity fibrosis', 'lymphocyte morphology phenotype', 'Proximal renal tubular acidosis', 'amino acid', 'dense mesenchyme tissue phenotype', 'inorganic cation', 'Abnormal glucose homeostasis', 'urine', 'mesonephric epithelium phenotype', 'increased level of chemical entity', 'lipid', 'excreta', 'lateral plate mesoderm', 'organooxygen compound', 'reproductive system phenotype', 'decreased role blood level', 'molecular entity', 'Abnormal urine potassium concentration', 'chemical homeostasis', 'system process', 'chemical entity level phenotype', 'cytoplasm', 'blood island phenotype', 'kidney corpuscule cell', 'ion', 'blood chemical entity level phenotype', 'dense mesenchyme tissue', 'carbohydrate homeostasis phenotype', 'monovalent inorganic cation', 'embryonic structure phenotype', 'blood', 'fatty acid anion', 'carbohydrate homeostasis', 'Aminoaciduria', 'inorganic molecular entity', 'blood island', 'metal atom', 'main group element atom', 'decreased functionality of the excretory tube', 's-block element atom', 'decreased size of the multicellular anatomical structure', 'somite', 'Hypercalciuria', 'respiration organ phenotype', 'subdivision of tube', 'Abnormal urinary electrolyte concentration', 'reproductive structure phenotype', 'urine calcium atom level phenotype', 'podocyte physiology phenotype', 'atom', 'sodium atom', 'cell', 'sodium atom level phenotype', 'Abnormal urine sodium concentration', 'increased level of glucose in urine', 'urine glucose level phenotype', 'Abnormal urinary organic compound level', 'chemical homeostasis phenotype', 'Glycosuria', 'Abnormal urine amino acid level', 'organonitrogen compound', 'Azotemia', 'urine organic anion level phenotype', 'blastula', 'skeletal system phenotype', 'Hypouricemia', 'multicellular organism water level phenotype', 'imidazopyrimidine', 'purines', 'reproductive organ', 'increased level of chemical entity in blood', 'blood nitrogen molecular entity level phenotype', 'urine potassium atom level phenotype', 'mesenchyme morphology phenotype', 'decreased level of purines', 'Abnormal circulating metabolite concentration', 'increased level of carboxylic acid in urine', 'uric acid', 'vertebral column', 'organic cyclic compound', 'digestive tract epithelium', 'increased cellular process', 'polycyclic compound', 'heteropolycyclic compound', 'heterobicyclic compound', 'lateral structure phenotype', 'organic heteropolycyclic compound', 'organonitrogen heterocyclic compound', 'organic heterobicyclic compound', 'Abnormal circulating nucleobase concentration', 'increased level of nitrogen molecular entity in blood', 'process', 'multicellular anatomical structure', 'decreased qualitatively digestive system process', 'oxoacid derivative', 'cellular process phenotype', 'defecation', 'monoatomic entity', 'phosphorus molecular entity', 'phosphoric acid derivative', 'phosphate', 'delayed growth', 'Growth delay', 'increased fatty acid derivative biosynthetic process', 'Chronic kidney disease', 'generation of precursor metabolites and energy phenotype', 'Abnormality of acid-base homeostasis', 'blood phosphate level phenotype', 'trunk region element physiology phenotype', 'decreased functionality of the anatomical conduit', 'Abnormality of the kidney', 'Abnormality of the upper urinary tract', 'skeletal element phenotype', 'presumptive structure phenotype', 'cavitated compound organ physiology phenotype', 'organic heterocyclic compound', 'compound organ physiology phenotype', 'lateral structure physiology phenotype', 'glomerular epithelium', 'abdomen element physiology phenotype', 'organ physiology phenotype', 'regulation of body fluid levels', 'Renal insufficiency', 'organelle', 'increased level of organic acid in urine', 'weight loss', 'respiratory system', 'bodily fluid phenotype', 'meso-epithelium', 'inorganic hydride', 'decreased anatomical entity strength', 'oxoacid', 'hypoglycemia', 'organic acid', 'organic oxo compound', 'increased level of amino acid in urine', 'carbon oxoacid', 'carbonyl compound', 'bicyclic compound', 'biological_process rate phenotype', 'Abnormal blood ion concentration', 'decreased functionality of the multicellular anatomical structure', 'nephron tubule phenotype', 'increased biological_process', 'decreased qualitatively multicellular organismal process', 'Abnormality of urine calcium concentration', 'acidosis', 'excretory tube', 'Abnormal muscle physiology', 'Abnormal blood phosphate concentration', 'increased level of chemical entity in urine', 'increased urine role level', 'excretion', 'digestive system process', 'hematopoietic system phenotype', 'generation of precursor metabolites and energy', 'Abnormality of body weight', 'kidney epithelium', 'digestion', 'Pain', 'biosynthetic process', 'primary metabolic process', 'monosaccharide', 'decreased digestive system process', 'multicellular organismal process phenotype', 'Acidosis', 'decreased functionality of the anatomical entity', 'decreased functionality of the epithelial tube', 'entity', 'anatomical conduit physiology phenotype', 'metabolic acidosis', 'lipid biosynthetic process phenotype', 'carboxylic acid', 'decreased system process', 'respiratory system physiology phenotype', 'decreased functionality of the material anatomical entity', 'Abnormal cellular phenotype', 'defecation phenotype', 'primary metabolic process phenotype', 'lipid level phenotype', 'ketone body biosynthetic process', 'small molecule biosynthetic process phenotype', 'epithelial tube physiology phenotype', 'small molecule metabolic process phenotype', 'potassium atom level phenotype', 'biosynthetic process phenotype', 'sclerotome', 'Abnormal homeostasis', 'renal tubular acidosis', 'Renal tubular acidosis', 'thoracic segment organ phenotype', 'small molecule biosynthetic process', 'lipid metabolic process', 'anlage phenotype', 'tube physiology phenotype', 'abdominal segment of trunk', 'decreased functionality of the tube', 'decreased excretion', 'tissue physiology phenotype', 'system process phenotype', 'increased small molecule metabolic process', 'renal tubule phenotype', 'excretion phenotype', 'nephron tubule', 'gland', 'Decreased circulating carnitine concentration', 'motile cell', 'increased lipid biosynthetic process', 'increased generation of precursor metabolites and energy', 'organic aromatic compound', 'increased small molecule biosynthetic process', 'decreased qualitatively system process', 'anatomical entity dysfunction in independent continuant', 'musculature of body phenotype', 'Bone pain', 'Abnormal musculoskeletal physiology', 'urine phosphate level phenotype', 'Hypophosphatemic rickets', 'musculoskeletal system physiology phenotype', 'subdivision of tube phenotype', 'musculature', 'increased level of chemical entity in bodily fluid', 'musculature phenotype', 'muscle structure physiology phenotype', 's-block molecular entity', 'muscle organ phenotype', 'oxopurine', 'oxide', 'muscle organ physiology phenotype', 'muscle structure phenotype', 'muscle structure', 'Bicarbonaturia', 'calcium atom', 'decreased muscle organ strength', 'organic ion'], 'has_descendant': ['MONDO:0007600', 'MONDO:0024525', 'MONDO:0013247', 'MONDO:0014275'], 'has_descendant_label': ['primary Fanconi syndrome', 'Fanconi renotubular syndrome 1', 'Fanconi renotubular syndrome 2', 'Fanconi renotubular syndrome 3'], 'has_descendant_count': 4, 'highlighting': None}, {'id': 'MONDO:0060778', 'category': 'biolink:Disease', 'name': 'adult Fanconi syndrome', 'description': 'A Fanconi renotubular syndrome that occurs in an adult. Adult Fanconi syndrome is typically acquired.', 'xref': ['MEDGEN:137960', 'NCIT:C4377', 'UMLS:C0341703'], 'synonym': ['adult Fanconi syndrome', "adult Fanconi's syndrome"], 'exact_synonym': ['adult Fanconi syndrome', "adult Fanconi's syndrome"], 'subsets': ['gard_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0003581'], 'has_phenotype_label': ['Adult onset'], 'has_phenotype_count': 1, 'has_phenotype_closure': ['HP:0012823', 'HP:0000001', 'HP:0003581', 'HP:0031797', 'HP:0003674'], 'has_phenotype_closure_label': ['Adult onset', 'Clinical course', 'All', 'Onset', 'Clinical modifier'], 'has_descendant': ['MONDO:0060778'], 'has_descendant_label': ['adult Fanconi syndrome'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:1011503', 'category': 'biolink:Disease', 'name': 'Fanconi syndrome, dog', 'description': 'Fanconi syndrome that occurs in dog.', 'xref': ['OMIA:000366-9615'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:1011503'], 'has_descendant_label': ['Fanconi syndrome, dog'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0013247', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome 2', 'description': 'Any Fanconi syndrome in which the cause of the disease is a mutation in the SLC34A1 gene.', 'xref': ['DOID:0080758', 'GARD:15655', 'MEDGEN:462002', 'OMIM:613388', 'UMLS:C3150652'], 'synonym': ['FRTS2', 'Fanconi renotubular syndrome 2', 'Fanconi renotubular syndrome type 2', 'Fanconi syndrome caused by mutation in SLC34A1', 'SLC34A1 Fanconi syndrome'], 'exact_synonym': ['Fanconi renotubular syndrome 2', 'Fanconi renotubular syndrome type 2', 'Fanconi syndrome caused by mutation in SLC34A1', 'SLC34A1 Fanconi syndrome'], 'related_synonym': ['FRTS2'], 'subsets': ['gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0000093', 'HP:0012213', 'HP:0002148', 'HP:0000083', 'HP:0002757', 'HP:0000114', 'HP:0000117', 'HP:0003165', 'HP:0000938', 'HP:0031415', 'HP:0002748', 'HP:0004322', 'HP:0002150', 'HP:0002909', 'HP:0003076', 'HP:0002749', 'HP:0002653'], 'has_phenotype_label': ['Osteopenia', 'High serum calcitriol', 'Renal insufficiency', 'Hypercalciuria', 'Proximal tubulopathy', 'Glycosuria', 'Bone pain', 'Osteomalacia', 'Decreased glomerular filtration rate', 'Rickets', 'Elevated circulating parathyroid hormone level', 'Generalized aminoaciduria', 'Recurrent fractures', 'Proteinuria', 'Renal phosphate wasting', 'Hypophosphatemia', 'Short stature'], 'has_phenotype_count': 17, 'has_phenotype_closure': ['HP:0000083', 'UPHENO:0080658', 'CHEBI:15693', 'CHEBI:18133', 'UPHENO:0051635', 'HP:6000531', 'CHEBI:33238', 'HP:0002148', 'HP:0032180', 'HP:0100529', 'UPHENO:0034522', 'UPHENO:0088134', 'HP:0002748', 'UPHENO:0080559', 'UPHENO:0088166', 'HP:0002749', 'CHEBI:33575', 'CHEBI:64709', 'CHEBI:36586', 'CHEBI:35605', 'CHEBI:78616', 'HP:0003355', 'CHEBI:36587', 'CL:0000738', 'UPHENO:0068491', 'CL:0000764', 'UPHENO:0085602', 'CL:0000081', 'UPHENO:0066739', 'CL:0000226', 'CL:0000763', 'UPHENO:7000414', 'CL:0000000', 'UBERON:0002405', 'CL:0000542', 'UPHENO:0084653', 'UPHENO:0088170', 'CL:0000988', 'CL:0000329', 'CHEBI:36360', 'UPHENO:0002948', 'CHEBI:33241', 'UPHENO:7000595', 'UPHENO:0050106', 'UPHENO:7000203', 'UPHENO:7000615', 'UPHENO:0050391', 'GO:0003014', 'HP:0012213', 'UPHENO:0080379', 'CHEBI:33256', 'CHEBI:36963', 'CHEBI:32988', 'CHEBI:33302', 'CHEBI:33839', 'UPHENO:7000390', 'UPHENO:7000377', 'UPHENO:0051673', 'UPHENO:0086480', 'HP:0011843', 'CHEBI:16646', 'HP:0002659', 'HP:0020129', 'UBERON:0011585', 'CL:0000255', 'UPHENO:0088123', 'UBERON:0001474', 'UBERON:0004765', 'UPHENO:0002543', 'UPHENO:0084654', 'UBERON:0009142', 'UBERON:0005856', 'UBERON:0003059', 'UPHENO:0002813', 'UPHENO:0003191', 'UBERON:0000477', 'HP:0033127', 'UPHENO:0002746', 'UBERON:0011138', 'HP:0011842', 'UPHENO:0004143', 'UBERON:0003089', 'UPHENO:0004545', 'UPHENO:0076703', 'CL:0000232', 'UBERON:0000307', 'UBERON:0000075', 'UPHENO:0076695', 'UBERON:0002204', 'UBERON:0001969', 'PR:000013429', 'HP:0000093', 'HP:0000818', 'UPHENO:0087849', 'PR:000018263', 'UPHENO:0068054', 'HP:0003117', 'UPHENO:0087123', 'UPHENO:0002320', 'UPHENO:7000586', 'UBERON:0015204', 'HP:0003076', 'UBERON:0005090', 'UBERON:0034923', 'UPHENO:0003047', 'UPHENO:7000428', 'UPHENO:7000403', 'CL:0000236', 'PR:000000001', 'HP:0012599', 'UBERON:0001015', 'UPHENO:7000394', 'UPHENO:0051648', 'HP:0025745', 'UBERON:0015203', 'UPHENO:0002359', 'HP:0003111', 'UPHENO:0068477', 'HP:0033331', 'CHEBI:16541', 'GO:0006766', 'UPHENO:0001072', 'UBERON:0007524', 'CHEBI:35381', 'CL:0000842', 'UPHENO:0079534', 'GO:0003008', 'UPHENO:0050121', 'UPHENO:0068047', 'UPHENO:0049723', 'CHEBI:35341', 'CHEBI:36853', 'CHEBI:51958', 'CHEBI:26191', 'CHEBI:35350', 'UPHENO:0008328', 'GO:0032501', 'HP:0002757', 'UPHENO:0010808', 'UPHENO:0082834', 'UPHENO:7000264', 'CHEBI:73558', 'CHEBI:27300', 'CHEBI:24870', 'UPHENO:0002816', 'CHEBI:47042', 'CHEBI:36357', 'UPHENO:0077817', 'UPHENO:0046286', 'UPHENO:0004505', 'HP:0000938', 'UPHENO:0008317', 'CHEBI:33608', 'CHEBI:33304', 'CHEBI:36962', 'CHEBI:33582', 'HP:0012531', 'CHEBI:33595', 'CHEBI:72695', 'UPHENO:0068565', 'CHEBI:24651', 'UPHENO:0003088', 'UPHENO:0004680', 'UBERON:0013702', 'UPHENO:0002542', 'CHEBI:33822', 'CHEBI:33675', 'UPHENO:0076286', 'UBERON:0013701', 'UPHENO:0002422', 'GO:0008150', 'HP:0004348', 'UPHENO:0002536', 'UPHENO:7000382', 'UBERON:0004819', 'UPHENO:0046291', 'GO:0097205', 'UPHENO:0002526', 'UBERON:0003061', 'UPHENO:0066943', 'UPHENO:0003182', 'UBERON:0007285', 'UPHENO:0008273', 'UPHENO:0002636', 'UBERON:0006555', 'UBERON:0001977', 'UBERON:0005173', 'UBERON:0001285', 'HP:0000079', 'BFO:0000003', 'UPHENO:0066959', 'HP:0004349', 'UPHENO:0002311', 'UPHENO:0002547', 'HP:0100530', 'UPHENO:0049587', 'UPHENO:0068144', 'UPHENO:0010850', 'UPHENO:0066939', 'UBERON:0001008', 'HP:0002150', 'UPHENO:0002269', 'HP:0002653', 'UBERON:0010000', 'UPHENO:0051709', 'UBERON:0002100', 'UPHENO:0080555', 'HP:0025142', 'UPHENO:0002576', 'GO:0009987', 'UPHENO:0051900', 'CHEBI:27136', 'UPHENO:0010799', 'CHEBI:22984', 'UBERON:8450002', 'HP:0000124', 'UPHENO:3000004', 'CHEBI:24867', 'HP:0012211', 'UBERON:0001130', 'UPHENO:0002385', 'UPHENO:0066921', 'UPHENO:0068169', 'UPHENO:0085578', 'UPHENO:0002267', 'UBERON:0009569', 'UPHENO:0085566', 'HP:0001939', 'UPHENO:0051712', 'UPHENO:0002564', 'UPHENO:0051763', 'UPHENO:0002964', 'UPHENO:0049904', 'UPHENO:0048711', 'UPHENO:0004892', 'CHEBI:23367', 'GO:0008152', 'CHEBI:33559', 'UBERON:0001231', 'CHEBI:18059', 'HP:0012591', 'HP:0011280', 'HP:0001510', 'UPHENO:0051686', 'HP:0002909', 'BFO:0000001', 'UPHENO:0080377', 'UBERON:0005172', 'CHEBI:16670', 'GO:0006629', 'UPHENO:0049618', 'UBERON:0001062', 'HP:0000119', 'BFO:0000002', 'HP:0012212', 'UPHENO:0008388', 'HP:0003330', 'UPHENO:0002442', 'UPHENO:0001001', 'CL:0000945', 'CHEBI:33674', 'UBERON:0000922', 'HP:0000118', 'UPHENO:0002252', 'CHEBI:15841', 'UPHENO:0000541', 'CHEBI:35352', 'UPHENO:0075159', 'UPHENO:0002530', 'UPHENO:0066927', 'UPHENO:0002642', 'UPHENO:0069254', 'UPHENO:0003022', 'UPHENO:0075195', 'UPHENO:0005285', 'UPHENO:0080352', 'UBERON:0009773', 'UBERON:0001088', 'UBERON:0006598', 'UBERON:0000465', 'UPHENO:0004969', 'UPHENO:0001294', 'UPHENO:0002532', 'UPHENO:0046348', 'UBERON:0000174', 'HP:0011277', 'UPHENO:0081440', 'UPHENO:0081547', 'CHEBI:24431', 'UPHENO:0085616', 'HP:0003110', 'UPHENO:0081423', 'UPHENO:0068971', 'UPHENO:0002386', 'UPHENO:0049873', 'UPHENO:0080351', 'UPHENO:0068064', 'UPHENO:0046383', 'UBERON:0000061', 'HP:0000924', 'UPHENO:0082875', 'GO:0042592', 'HP:0033354', 'UBERON:0004111', 'UBERON:0004122', 'CHEBI:37577', 'CHEBI:26079', 'UPHENO:0068134', 'CHEBI:26082', 'BFO:0000040', 'UPHENO:0004791', 'GO:0044238', 'UBERON:0010316', 'UPHENO:0003430', 'UPHENO:0087665', 'UPHENO:0086505', 'UPHENO:0003234', 'UPHENO:0003432', 'UBERON:0000467', 'UPHENO:0002525', 'UPHENO:0001003', 'UPHENO:0002527', 'HP:0004322', 'UPHENO:0089294', 'BFO:0000015', 'UPHENO:0052002', 'UPHENO:0050502', 'UPHENO:0002832', 'UPHENO:0081581', 'UPHENO:0081424', 'UPHENO:0088162', 'UBERON:0000025', 'UPHENO:7000381', 'UBERON:0011143', 'UBERON:0002113', 'CHEBI:33259', 'UBERON:0002329', 'UPHENO:0066960', 'HP:0100511', 'CHEBI:33318', 'UPHENO:0069327', 'UPHENO:0051191', 'UPHENO:0001002', 'UPHENO:0001303', 'UPHENO:0069062', 'CHEBI:22313', 'HP:0031415', 'UPHENO:0005201', 'UBERON:0003104', 'UPHENO:0003413', 'CL:0002242', 'UBERON:0000489', 'UPHENO:0002963', 'CHEBI:35788', 'HP:0000114', 'HP:0001507', 'UPHENO:0002531', 'UPHENO:0076692', 'UBERON:0000949', 'UPHENO:0002976', 'UPHENO:0069266', 'GO:0042359', 'UPHENO:0046344', 'UBERON:0003077', 'UPHENO:0068556', 'UBERON:0000463', 'UPHENO:0049874', 'GO:0008202', 'CHEBI:51143', 'UPHENO:0002281', 'UPHENO:0002803', 'UPHENO:0002411', 'CHEBI:33521', 'CHEBI:33579', 'UBERON:0000479', 'UPHENO:0068110', 'UPHENO:0049703', 'UPHENO:0048707', 'UPHENO:0066954', 'UPHENO:0046284', 'BFO:0000004', 'UPHENO:0086482', 'UBERON:0000062', 'UPHENO:0051960', 'UPHENO:0024906', 'UBERON:0003914', 'UPHENO:0034351', 'UPHENO:0066951', 'UPHENO:0002926', 'UPHENO:0050116', 'UBERON:0011676', 'UPHENO:0002558', 'UPHENO:0068068', 'UBERON:0003081', 'UBERON:0007684', 'UPHENO:0002567', 'UBERON:0003918', 'UPHENO:0004418', 'UPHENO:0004900', 'CHEBI:25806', 'CHEBI:26020', 'UPHENO:0002541', 'UPHENO:0002248', 'UPHENO:0002360', 'UPHENO:0002577', 'UBERON:0003103', 'UPHENO:0051739', 'UPHENO:0004885', 'HP:0000001', 'UPHENO:0003094', 'UBERON:0007530', 'UPHENO:0002668', 'CHEBI:33709', 'UBERON:0007503', 'UPHENO:0003163', 'CHEBI:24833', 'UPHENO:0004360', 'UBERON:0000064', 'UPHENO:0002210', 'UPHENO:0034253', 'UBERON:0000178', 'HP:0011849', 'UPHENO:0082539', 'UPHENO:0002346', 'HP:0000117', 'UPHENO:0002571', 'UBERON:0005291', 'UBERON:0000916', 'UPHENO:0066946', 'UPHENO:0002377', 'UBERON:0015212', 'UPHENO:0066964', 'UPHENO:0003050', 'CHEBI:17823', 'UPHENO:0051804', 'UBERON:0000475', 'UPHENO:0002287', 'GO:0040007', 'UPHENO:0003093', 'CL:0000219', 'CHEBI:33250', 'UPHENO:0066913', 'UPHENO:0002559', 'UPHENO:0002870', 'UPHENO:0002754', 'UPHENO:0001134', 'UPHENO:0002426', 'UPHENO:7000416', 'UPHENO:0002308', 'UPHENO:0002427', 'UBERON:0002417', 'UPHENO:0080010', 'CHEBI:36359', 'UPHENO:0003941', 'UPHENO:0002270', 'HP:0010935', 'UPHENO:0078589', 'UPHENO:0002246', 'UPHENO:0002859', 'UPHENO:0003025', 'UPHENO:0002909', 'UPHENO:0075902', 'UPHENO:0003207', 'UBERON:0001630', 'UBERON:0007688', 'UBERON:0002050', 'UBERON:0000483', 'UBERON:0002193', 'UBERON:0011216', 'UBERON:0002390', 'HP:0000077', 'UBERON:0000926', 'UPHENO:0003159', 'CHEBI:33285', 'UPHENO:0010795', 'HP:0100508', 'UPHENO:7000393', 'UBERON:0001434', 'UPHENO:7000795', 'UPHENO:0046281', 'CHEBI:50047', 'UBERON:0000923', 'GO:0044281', 'UPHENO:0003116', 'UPHENO:0081544', 'UPHENO:0004503', 'GO:0001503', 'UPHENO:0086172', 'UPHENO:0066903', 'UPHENO:0008312', 'HP:0032245', 'UBERON:0005177', 'UPHENO:0076293', 'UBERON:0000383', 'UBERON:0004120', 'UPHENO:0066925', 'CHEBI:25367', 'CHEBI:17234', 'UPHENO:0089764', 'UBERON:0000468', 'UPHENO:0048763', 'UPHENO:0002554', 'UBERON:0004211', 'UBERON:0000179', 'UPHENO:0005092', 'UPHENO:0005141', 'UPHENO:0010763', 'UPHENO:0078628', 'UPHENO:0002568', 'UPHENO:0005277', 'CHEBI:50860', 'CHEBI:37622', 'HP:0003165', 'UPHENO:0001360', 'UPHENO:0066950', 'CHEBI:33832', 'UPHENO:0002731', 'CHEBI:33635', 'CHEBI:33917', 'UPHENO:0068251', 'UPHENO:0004459', 'UBERON:0005423', 'UPHENO:0051628', 'UPHENO:0082835', 'UBERON:0005256', 'UPHENO:0080643', 'UPHENO:0003381', 'HP:0000002', 'UPHENO:0002949', 'UPHENO:0000543', 'UBERON:0006314'], 'has_phenotype_closure_label': ['Renal insufficiency', 'Glycosuria', 'glucose', 'aldose', 'monosaccharide', 'Abnormal urinary organic compound level', 'urine glucose level phenotype', 'increased level of glucose in urine', 'monoatomic entity', 'Hypophosphatemia', 'carbohydrate', 'blood monoatomic ion level phenotype', 'Rickets', 'leukocyte morphology phenotype', 'carboxylic acid', 'carbonyl compound', 'carbon oxoacid', 'increased level of amino acid in urine', 'organic oxo compound', 'organic acid', 'oxoacid', 'decreased anatomical entity strength', 'increased level of organic acid in urine', 'Generalized aminoaciduria', 'amino acid level phenotype', 'Constitutional symptom', 'Bone pain', 'mononuclear leukocyte', 'Abnormal skeletal morphology', 'B cell physiology phenotype', 'B cell', 'hematopoietic cell', 'oxygen accumulating cell', 'Osteopenia', 'erythrocyte', 'Decreased anatomical entity mass density', 'immune system phenotype', 'single nucleate cell', 'myeloid cell', 'bone element phenotype', 'Abnormal bone ossification', 'Decreased bone element mass density', 'phosphate', 'phosphoric acid derivative', 'phosphorus oxoacid derivative', 'phosphorus molecular entity', 'phosphate level phenotype', 'renal filtration rate phenotype', 'system process', 'system process phenotype', 'renal system process phenotype', 'lymphocyte of B lineage', 'renal filtration', 'Decreased glomerular filtration rate', 'renal filtration phenotype', 'decreased creatinine clearance; decreased glomerular filtration rate', 'decreased nerve conduction velocity', 'multicellular organismal process phenotype', 'primary amide', 'Reduced bone mineral density', 'organic amino compound', 'organooxygen compound', 'heteroorganic entity', 'increased level of protein polypeptide chain in urine', 'erythrocyte morphology phenotype', 'urine protein level phenotype', 'Proteinuria', 'skeletal system phenotype', 'developing mesenchymal condensation phenotype', 'embryonic tissue morphology phenotype', 'paraxial mesoderm morphology phenotype', 'Abnormal blood ion concentration', 'Recurrent fractures', 'migrating mesenchyme population', 'subdivision of skeletal system', 'organ system subdivision physiology phenotype', 'anatomical cluster', 'anatomical cluster phenotype', 'vertebral column morphology phenotype', 'blood phosphate level phenotype', 'postcranial axial skeletal system', 'skeletal system physiology phenotype', 'multicellular organismal process', 'cell condensation', 'presomitic mesoderm', 'Abnormal circulating metabolite concentration', 'skeletal system', 'sclerotome phenotype', 'musculoskeletal system physiology phenotype', 'migrating mesenchyme population phenotype', 'bone element', 'carboxamide', 'developing mesenchymal condensation', 'blastula', 'skeletal element', 'biological_process rate phenotype', 'humpback; kyphosis', 'trunk mesenchyme phenotype', 'aldohexose', 'Abnormality of the musculoskeletal system', 'cell condensation phenotype', 'mesenchyme morphology phenotype', 'hexose', 'somite phenotype', 'rickets', 'sclerotome', 'parathyroid hormone', 'polypeptide', 'increased level of parathyroid hormone in blood', 'non-connected functional system', 'muscle structure', 'disconnected anatomical group', 'circulating hormone concentration; circulating hormone level', 'musculature', 'Abnormal circulating hormone concentration', 'blood parathyroid hormone level phenotype', 'muscle structure phenotype', 'muscle organ physiology phenotype', 'decreased bone element strength', 'musculature of body phenotype', 'muscle organ phenotype', 'protein', 'Acute phase response', 'endocrine system phenotype', 'endocrine system', 'sclerotome morphology phenotype', 'blood serum', 'blood plasma', 'Aminoaciduria', 'blood', 'hormone blood level phenotype', 'dense mesenchyme tissue', 'blood chemical entity level phenotype', 'blood island phenotype', 'molecular entity', 'steroid', 'triol', 'hydroxy seco-steroid', 'elemental molecular entity', 'lipid', 'decreased level of chemical entity in blood', 'organic polycyclic compound', 'polyol', 'mesoderm', 'dense mesenchyme tissue phenotype', 'skeletal system morphology phenotype', 'blood oxygen molecular entity level phenotype', 'haemolymphatic fluid phenotype', 'ion', 'organic molecular entity', 'polycyclic compound', 'organic cyclic compound', 'material anatomical entity mass phenotype', 'germ layer phenotype', 'vertebral column phenotype', 'metabolism', 'lipid metabolic process', 'trunk mesenchyme', 'vitamin metabolic process', 's-block molecular entity', 'mesoderm-derived structure', 'Abnormal urine metabolite level', 'tissue chemical entity level phenotype', 'High serum calcitriol', 'cell phenotype', 'increased size of the multicellular anatomical structure', 'increased level of chemical entity in tissue', 'role bodily fluid level phenotype', 'increased level of chemical entity in blood', 'lipid metabolic process phenotype', 'subdivision of trunk', 'germ layer / neural crest phenotype', 'kidney physiology phenotype', 'hydroxides', 'embryonic tissue phenotype', 't cell morphology', 'presumptive structure', 'anatomical entity phenotype', 'anlage', 'Abnormal blood phosphate concentration', 'organ part', 'cavitated compound organ phenotype', 'musculature of body', 'organ system subdivision phenotype', 'decreased height of the anatomical entity', 'nephron phenotype', 'tube phenotype', 'ossification', 'renal tubule phenotype', 'amino acid', 'excretory tube phenotype', 'subdivision of trunk phenotype', 'trunk region element physiology phenotype', 'decreased functionality of the anatomical conduit', 'bone ossification', 'anatomical entity dysfunction in independent continuant', 'epithelial vesicle phenotype', 'trunk region element', 'muscle organ', 'Abnormality of the urinary system', 'bone structure', 'presumptive paraxial mesoderm', 'epithelium phenotype', 'lymphocyte morphology phenotype', 'chemical entity level phenotype', 'biological_process', 'peptide', 'tube physiology phenotype', 'homeostatic process phenotype', 'lymphocyte physiology phenotype', 'anatomical conduit physiology phenotype', 'motile cell', 'anatomical entity mass phenotype', 'metabolic process', 'osteomalacia', 'nitrogen molecular entity', 'excretory tube', 'main body axis', 'upper urinary tract phenotype', 'embryo', 'small molecule metabolic process', 'excretory system', 'biological_process phenotype', 'increased level of chemical entity in bodily fluid', 'developing anatomical structure phenotype', 'calcium atom', 'nephron epithelium', 'abdominal segment element physiology phenotype', 'atom', 'Abnormal urinary electrolyte concentration', 'phenotype', 'Abnormal glomerular filtration rate', 'presumptive paraxial mesoderm phenotype', 'material anatomical entity physiology phenotype', 'decreased level of chemical entity', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'urine phosphate level phenotype', 'decreased functionality of the kidney epithelium', 'multicellular anatomical structure physiology phenotype', 'hydrogen molecular entity', 'renal system phenotype', 'musculoskeletal system', 'epithelial tube phenotype', 'vitamin D level phenotype', 'anatomical conduit phenotype', 'organism substance phenotype', 'multicellular organism morphology phenotype', 'b cell morphology', 'lipid level phenotype', 'anatomical entity morphology phenotype', 'anatomical system phenotype', 'kidney', 'small molecule metabolic process phenotype', 'decreased size of the multicellular organism', 'paraxial mesoderm phenotype', 'increased level of parathyroid hormone in blood serum', 'anatomical entity physiology phenotype', 'subdivision of organism along main body axis phenotype', 'Renal phosphate wasting', 'amino acid chain', 'size of multicellular organism phenotype', 'lymphocyte', 'Increased susceptibility to fractures', 'anatomical structure phenotype', 'Abnormality of urine homeostasis', 'main group element atom', 'pnictogen molecular entity', 'Abnormal circulating calcium-phosphate regulating hormone concentration', 'epithelial vesicle', 'renal/urinary system phenotype', 'increased level of chemical entity', 'eukaryotic cell', 'compound organ phenotype', 'delayed growth', 'tube', 'hemoglobin', 'mesoderm phenotype', 'All', 'material anatomical entity phenotype', 'Abnormal urine phosphate concentration', 'uriniferous tubule', 'organonitrogen compound', 'lateral plate mesoderm', 'vitamin metabolic process phenotype', 'abdominal segment element phenotype', 'increased urine role level', 'increased material anatomical entity mass', 'p-block molecular entity', 'alkaline earth metal atom', 'Hypercalciuria', 'decreased functionality of the tube', 'phenotypic effect', 'developing anatomical structure', 'protein polypeptide chain', 'Abnormality of metabolism/homeostasis', 'multicellular organism mass phenotype', 'amide', 'vertebral column', 'Growth delay', 'primary metabolic process phenotype', 'blood lipid level phenotype', 'presumptive structure phenotype', 'entity', 'growth', 'polyatomic entity', 'increased size of the multicellular organism', 'material entity', 'Abnormality of the endocrine system', 'organism subdivision', 'anatomical entity height phenotype', 'cyclic compound', 'bone element mass density phenotype', 'decreased functionality of the renal tubule', 'anatomical structure', 'body proper', 'multicellular anatomical structure phenotype', 'decreased size of the multicellular anatomical structure', 'size of anatomical entity phenotype', 'anatomical entity', 'compound organ', 'decreased level of phosphate in blood', 'Abnormal urine amino acid level', 'kidney phenotype', 'macromolecule', 'urine calcium atom level phenotype', 'increased size of the anatomical entity', 'cavitated compound organ', 'material anatomical entity', 'multicellular organism height phenotype', 'skeletal element phenotype', 'anatomical structure physiology phenotype', 'cell physiology phenotype', 'phosphorus oxoacids and derivatives', 'multicellular organism phenotype', 'Growth abnormality', 'cell', 'renal system', 'decreased size of the material anatomical entity', 'increased level of monosaccharide in urine', 'occurrent', 'decreased size of the anatomical entity', 'lateral structure phenotype', 'Abnormality of bone mineral density', 'organ physiology phenotype', 'decreased height of the multicellular organism', 'Abnormality of urine calcium concentration', 'increased level of carboxylic acid in urine', 'delayed biological_process', 'multicellular organism chemical entity level phenotype', 'hematopoietic system', 'Phenotypic abnormality', 'abdomen', 'Abnormality of vitamin metabolism', 'nephron epithelium phenotype', 'urine', 'calcium atom level phenotype', 'taxon specific phenotype', 'oxoacid derivative', 'cellular process phenotype', 'fragile skeleton; increased susceptibility to fractures', 'multicellular organism', 'excreta', 'anatomical entity mass density phenotype', 'oxygen molecular entity', 'increased level of calcium atom in urine', 'vitamin D metabolic process phenotype', 'genitourinary system phenotype', 'process', 'anatomical structure mass phenotype', 'Abnormal musculoskeletal physiology', 'seco-steroid', 'urine chemical entity level phenotype', 'cellular process', 'Abnormality of the kidney', 'chemical entity', 'Elevated circulating parathyroid hormone level', 'metal atom', 'blood cell phenotype', 'bodily fluid', 'multicellular anatomical structure mass phenotype', 'calcitriol', 'anatomical system physiology phenotype', 'Proximal tubulopathy', 'blood organic molecular entity level phenotype', 'increased bodily fluid role level', 's-block element atom', 'steroid metabolic process', 'kidney mesenchyme', 'organism subdivision phenotype', 'homeostatic process', 'increased level of chemical entity in urine', 'blood cell', 'Abnormality of the upper urinary tract', 'Abnormal renal physiology', 'embryo phenotype', 'Abnormality of body height', 'decreased functionality of the material anatomical entity', 'organ', 'abdominal segment element', 'nucleate cell', 'Short stature', 'nephron', 'decreased functionality of the anatomical entity', 'decreased functionality of the epithelial tube', 'Abnormal bone structure', 'anatomical system', 'organ part phenotype', 'kidney epithelium phenotype', 'presomitic mesoderm morphology phenotype', 'tissue', 'paraxial mesoderm', 'abdominal segment of trunk', 'increased anatomical structure mass', 'epithelium', 'monoatomic ion', 'trunk phenotype', 'organic hydroxy compound', 'cavitated compound organ physiology phenotype', 'epithelial tube physiology phenotype', 'embryonic structure', 'compound organ physiology phenotype', 'leukocyte physiology phenotype', 'renal tubule', 'embryonic tissue', 'Abnormality of the urinary system physiology', 'independent continuant', 'decreased functionality of the tissue', 'decreased functionality of the excretory tube', 'leukocyte', 'primary metabolic process', 'increased blood role level', 'blood island', 'D3 vitamins', 'mesenchyme', 'organ phenotype', 'Osteomalacia', 'embryonic structure phenotype', 'epithelium physiology phenotype', 'lateral structure physiology phenotype', 'erythroid lineage cell morphology phenotype', 'lateral structure', 'continuant', 'decreased functionality of the anatomical structure', 'abdomen element', 'epithelial tube', 'lateral plate mesoderm phenotype', 'abdomen element physiology phenotype', 'renal system physiology phenotype', 'abdomen element phenotype', 'subdivision of skeletal system phenotype', 'organism substance', 'growth phenotype', 'decreased functionality of the epithelium', 'nitrogen molecular entity level phenotype', 'decreased functionality of the nephron tubule', 'decreased functionality of the multicellular anatomical structure', 'nephron tubule phenotype', 'increased size of the material anatomical entity', 'tissue physiology phenotype', 'Abnormality of the skeletal system', 'hematopoietic system phenotype', 'decreased functionality of the nephron epithelium', 'germ layer / neural crest', 'genitourinary system', 'upper urinary tract', 'subdivision of organism along main body axis', 'tissue phenotype', 'immune system morphology phenotype', 'kidney epithelium', 'Renal tubular dysfunction', 'mesenchyme phenotype', 'hydroxycalciol', 'nephron tubule', 'renal system process', 'glandular system', 'multicellular anatomical structure', 'excretory tube physiology phenotype', 'musculoskeletal system phenotype', 'organ system subdivision', 'increased level of vitamin D', 'immune system', 'musculature phenotype', 'increased level of lipid in blood', 'muscle spasm', 'hydroxy steroid', 'anatomical conduit', 'role urine level phenotype', 'metabolic process phenotype', 'increased size of the anatomical structure', 'somite', 'steroid metabolic process phenotype', 'heteroatomic molecular entity', 'decreased level of chemical entity in tissue', 'embryo morphology phenotype', 'molecule', 'Abnormal urine protein level', 'obese; obesity', 'trunk region element phenotype', 'mesoderm-derived structure phenotype', 'role blood level phenotype', 'Abnormal metabolism', 'blood phenotype', 'increased multicellular anatomical structure mass', 'Pain', 'main group molecular entity', 'erythroid lineage cell', 'germ layer', 'vitamin D metabolic process', 'bodily fluid phenotype', 'increased level of calcitriol in blood', 'entire embryonic mesenchyme', 'kidney mesenchyme phenotype', 'organic molecule', 'hemolymphoid system', 'carbon group molecular entity', 'urine amino acid level phenotype', 'chalcogen molecular entity', 'carbohydrates and carbohydrate derivatives', 'decreased size of the anatomical structure', 'increased level of lipid', 'organochalcogen compound', 'Abnormality of the genitourinary system', 'increased multicellular organism mass', 'presomitic mesoderm phenotype', 'muscle structure physiology phenotype', 'Abnormality of vitamin D metabolism', 'increased anatomical entity mass', 'anlage phenotype', 'trunk', 'haemolymphatic fluid', 'vitamin D'], 'has_descendant': ['MONDO:0013247'], 'has_descendant_label': ['Fanconi renotubular syndrome 2'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0024525', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome 1', 'xref': ['DOID:0080757', 'MEDGEN:1635492', 'OMIM:134600', 'UMLS:C4551503'], 'synonym': ['DeToni-Debré-Fanconi syndrome', 'FRTS1', 'Fanconi renotubular syndrome', 'Fanconi renotubular syndrome 1', 'Fanconi syndrome without cystinosis', 'Luder-Sheldon syndrome', 'adult Fanconi syndrome', 'primary Fanconi renal syndrome', 'primary Fanconi renotubular syndrome', 'renal Fanconi syndrome'], 'exact_synonym': ['DeToni-Debré-Fanconi syndrome', 'FRTS1', 'Fanconi renotubular syndrome 1', 'primary Fanconi renal syndrome', 'primary Fanconi renotubular syndrome'], 'related_synonym': ['Fanconi renotubular syndrome', 'Fanconi syndrome without cystinosis', 'Luder-Sheldon syndrome', 'adult Fanconi syndrome', 'renal Fanconi syndrome'], 'subsets': ['gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0001942', 'HP:0002748', 'HP:0003126', 'HP:0004322', 'HP:0003648', 'HP:0002749', 'HP:0002900', 'HP:0003355', 'HP:0001324', 'HP:0034359', 'HP:0003109', 'HP:0002148', 'HP:0000083', 'HP:0000124', 'HP:0003155', 'HP:0003076'], 'has_phenotype_label': ['Low-molecular-weight proteinuria', 'Metabolic acidosis', 'Rickets', 'Renal tubular dysfunction', 'Hyperphosphaturia', 'Short stature', 'Lacticaciduria', 'Glycosuria', 'Aminoaciduria', 'Hypophosphatemia', 'Muscle weakness', 'Renal insufficiency', 'Osteomalacia', 'Impaired renal tubular reabsorption of phosphate', 'Hypokalemia', 'Elevated circulating alkaline phosphatase concentration'], 'has_phenotype_count': 16, 'has_phenotype_closure': ['GO:0070293', 'HP:0011038', 'UPHENO:0080559', 'CHEBI:60911', 'GO:0003008', 'CHEBI:59999', 'UPHENO:7000809', 'UBERON:0004176', 'CL:1000497', 'CL:0002522', 'UPHENO:0081424', 'CL:1000612', 'UPHENO:0046348', 'UBERON:0000174', 'CHEBI:26020', 'CHEBI:26079', 'CHEBI:36359', 'UPHENO:0080010', 'UPHENO:0003941', 'HP:0034359', 'CHEBI:26082', 'HP:0012591', 'UPHENO:0002943', 'CHEBI:32988', 'GO:0006629', 'CHEBI:33302', 'UPHENO:0088134', 'CL:0000232', 'UPHENO:0068565', 'UPHENO:0080556', 'UPHENO:0002308', 'UBERON:0004188', 'UPHENO:0002554', 'UBERON:0000179', 'UPHENO:0081423', 'UPHENO:7000393', 'HP:0003330', 'UPHENO:0002442', 'UPHENO:0001001', 'UPHENO:0085602', 'UPHENO:0002816', 'CHEBI:24870', 'HP:0000118', 'UBERON:0000922', 'CHEBI:33674', 'UBERON:0011216', 'UBERON:0000383', 'UPHENO:0005141', 'UPHENO:0004459', 'UPHENO:0002320', 'CL:0002584', 'UPHENO:0085578', 'UPHENO:0002267', 'UPHENO:0068169', 'UBERON:0003060', 'GO:0044283', 'CL:0000236', 'PR:000000001', 'UBERON:0000074', 'UBERON:0001474', 'CHEBI:33241', 'UBERON:0002390', 'UPHENO:0002948', 'HP:0003126', 'UBERON:0034923', 'HP:0003076', 'UPHENO:0082835', 'UBERON:0005256', 'UPHENO:0085566', 'HP:0001939', 'HP:0002748', 'UPHENO:0055014', 'HP:0001942', 'UBERON:0000080', 'CL:0000542', 'UPHENO:0088166', 'UBERON:0001015', 'UPHENO:0002346', 'UBERON:0002405', 'UBERON:0015203', 'HP:0025745', 'UPHENO:0055082', 'UBERON:0003133', 'UPHENO:0002870', 'CL:0000219', 'UPHENO:0050106', 'UPHENO:0066913', 'UPHENO:0085616', 'HP:0003110', 'UPHENO:0002685', 'UPHENO:0002281', 'CHEBI:51143', 'UPHENO:0002803', 'UPHENO:0002541', 'UPHENO:0003432', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0084654', 'UBERON:0009142', 'UBERON:0002193', 'UPHENO:0055032', 'UBERON:0002204', 'UPHENO:0054954', 'GO:1902224', 'UPHENO:0049628', 'CHEBI:33575', 'UPHENO:0054970', 'UBERON:0003104', 'CL:0000842', 'BFO:0000015', 'UPHENO:0002754', 'UBERON:0000062', 'CHEBI:33579', 'UBERON:0000479', 'UPHENO:0003055', 'CL:0000081', 'UBERON:0002120', 'UPHENO:0054967', 'CHEBI:36962', 'CHEBI:33582', 'UPHENO:0082834', 'CHEBI:25806', 'UPHENO:0002976', 'UPHENO:0069266', 'HP:0000924', 'CL:0000329', 'UPHENO:0082875', 'CHEBI:36914', 'CL:1000450', 'UPHENO:0066739', 'CHEBI:33675', 'HP:0011849', 'UPHENO:0076286', 'UBERON:0013701', 'UPHENO:0002832', 'HP:0011804', 'UPHENO:0088162', 'UBERON:0000025', 'UPHENO:0046284', 'UPHENO:0076692', 'UPHENO:0088170', 'UPHENO:0050121', 'UPHENO:0002568', 'UPHENO:0002525', 'UPHENO:0005277', 'UPHENO:7000414', 'UPHENO:7000815', 'HP:0000079', 'GO:0032501', 'CL:0000764', 'GO:0033500', 'UPHENO:0068491', 'CHEBI:33285', 'CHEBI:33917', 'CL:0002518', 'CHEBI:37577', 'UBERON:0004122', 'UPHENO:0049835', 'CL:1000510', 'UPHENO:0084653', 'CHEBI:18133', 'CHEBI:33256', 'GO:0042593', 'CHEBI:24431', 'UPHENO:0081547', 'CHEBI:33304', 'UBERON:0000465', 'UPHENO:7000382', 'UBERON:8450002', 'UPHENO:0003867', 'HP:0011842', 'UPHENO:0050240', 'BFO:0000040', 'UPHENO:0068054', 'UPHENO:7000212', 'UPHENO:0046383', 'UPHENO:0068110', 'UPHENO:0054955', 'HP:0033354', 'CHEBI:78616', 'HP:0003355', 'UPHENO:0002385', 'UBERON:0000468', 'UPHENO:0051763', 'UPHENO:0002526', 'UPHENO:0002964', 'UPHENO:0051191', 'CL:0002242', 'UPHENO:0002963', 'UBERON:0000489', 'CHEBI:24651', 'UPHENO:7000305', 'UBERON:0001229', 'UPHENO:0069254', 'GO:0048878', 'HP:0004360', 'GO:1901568', 'UPHENO:0002443', 'CHEBI:37622', 'HP:0004348', 'UBERON:0000463', 'UPHENO:0002559', 'UPHENO:0002902', 'UPHENO:0086172', 'GO:0001503', 'HP:0010930', 'CHEBI:17234', 'HP:0020129', 'UPHENO:3000004', 'HP:6000531', 'HP:0000119', 'UPHENO:0089294', 'CHEBI:60004', 'UPHENO:0055071', 'HP:0001510', 'UPHENO:0002270', 'HP:0010935', 'CL:0000226', 'HP:0000001', 'UPHENO:0004885', 'UPHENO:0051739', 'UPHENO:0003094', 'UPHENO:0051686', 'UBERON:0001007', 'UPHENO:0080377', 'UBERON:0005172', 'UPHENO:0001002', 'UPHENO:0081544', 'BFO:0000002', 'UPHENO:0004503', 'HP:0011277', 'UPHENO:0005015', 'UPHENO:0051635', 'CHEBI:36915', 'UBERON:0005751', 'CL:0000738', 'GO:1901570', 'UBERON:0000475', 'UPHENO:0051280', 'UBERON:0000481', 'CHEBI:36360', 'UPHENO:0000543', 'UPHENO:0003381', 'UPHENO:7000630', 'CHEBI:15693', 'UPHENO:0080555', 'UPHENO:0002576', 'GO:0046951', 'GO:0040007', 'UPHENO:0003093', 'UBERON:0010000', 'UPHENO:0002269', 'UPHENO:0005002', 'UPHENO:7000381', 'UBERON:0011143', 'UBERON:0001008', 'UPHENO:0002642', 'UPHENO:0066927', 'CHEBI:16541', 'UPHENO:0080658', 'CL:0000255', 'UBERON:0001062', 'UPHENO:0050433', 'HP:0012337', 'CHEBI:23367', 'CHEBI:16670', 'UBERON:0006553', 'CHEBI:33559', 'UPHENO:0068352', 'UBERON:0000063', 'UPHENO:0003413', 'CHEBI:16646', 'UPHENO:0051673', 'UBERON:0004211', 'UPHENO:7000317', 'UBERON:0003061', 'CL:0000945', 'UPHENO:0002536', 'UPHENO:0066943', 'UPHENO:0068971', 'UPHENO:0049873', 'UPHENO:0050791', 'UPHENO:0002386', 'UPHENO:0080662', 'UPHENO:0054961', 'GO:0044281', 'UPHENO:0055132', 'HP:0034684', 'HP:0004349', 'BFO:0000004', 'CHEBI:36963', 'CHEBI:50047', 'UPHENO:0002311', 'UPHENO:0076703', 'UPHENO:0005000', 'PR:000018263', 'UPHENO:0055153', 'CHEBI:36357', 'UPHENO:0051900', 'UPHENO:7000318', 'UPHENO:0080352', 'UBERON:0002417', 'GO:0009058', 'UPHENO:0069062', 'CL:0000763', 'GO:0008610', 'UBERON:0001230', 'UBERON:0001434', 'UBERON:0011676', 'HP:0000093', 'CHEBI:33250', 'UPHENO:0055077', 'CL:0000000', 'UPHENO:0050220', 'UPHENO:0001003', 'GO:0042592', 'GO:0044238', 'UPHENO:0087123', 'UPHENO:7000306', 'UPHENO:0004791', 'UPHENO:0002833', 'BFO:0000001', 'HP:0012599', 'UPHENO:7000615', 'UPHENO:0050416', 'CHEBI:35352', 'UBERON:0010316', 'UBERON:0004120', 'UPHENO:0003430', 'CHEBI:15841', 'UPHENO:0002532', 'UPHENO:0000541', 'UPHENO:0075159', 'UPHENO:0049723', 'HP:0001941', 'UPHENO:7000586', 'BFO:0000003', 'HP:0004322', 'UPHENO:0069327', 'HP:0001507', 'CL:0000988', 'UPHENO:0075195', 'UPHENO:0003022', 'UPHENO:0046283', 'UBERON:0001285', 'UPHENO:0034351', 'UPHENO:0066951', 'UBERON:0002050', 'UPHENO:0004683', 'UBERON:0000483', 'UPHENO:0034522', 'UPHENO:0002909', 'UPHENO:0075902', 'UPHENO:0051804', 'UPHENO:0051645', 'UBERON:0000926', 'HP:0000077', 'UPHENO:0089756', 'UPHENO:0089770', 'UBERON:0001088', 'UPHENO:0003207', 'UPHENO:0003159', 'HP:0002900', 'UPHENO:0004505', 'UPHENO:0046286', 'UPHENO:0002564', 'UPHENO:0002411', 'UPHENO:0002569', 'CHEBI:33318', 'UBERON:0003081', 'UPHENO:0002567', 'CHEBI:33839', 'HP:0032180', 'UBERON:0000178', 'UPHENO:0034253', 'UPHENO:7000595', 'UPHENO:0004418', 'UPHENO:0004900', 'HP:0002749', 'UBERON:0003918', 'UPHENO:0002571', 'CHEBI:50860', 'GO:0009987', 'UBERON:0005291', 'UPHENO:0066903', 'CHEBI:26216', 'UBERON:0007503', 'UPHENO:0003163', 'UPHENO:0079822', 'GO:0097205', 'CHEBI:24835', 'CHEBI:33259', 'UPHENO:0066960', 'CHEBI:33521', 'HP:0003111', 'UBERON:0006598', 'HP:0010929', 'UBERON:0004819', 'UBERON:0003074', 'UBERON:0004111', 'UPHENO:0002542', 'HP:0003648', 'UBERON:0005423', 'UPHENO:0004680', 'UPHENO:0002636', 'UBERON:0013702', 'UPHENO:0052002', 'UBERON:0007524', 'UPHENO:7000394', 'UPHENO:0002577', 'UPHENO:0051960', 'UPHENO:0024906', 'CHEBI:33238', 'CHEBI:36916', 'UBERON:0015212', 'UPHENO:7000608', 'UPHENO:0049904', 'UPHENO:0066964', 'UPHENO:0002523', 'CHEBI:22314', 'UBERON:0003103', 'CHEBI:24867', 'HP:0000002', 'HP:0012211', 'HP:0004379', 'UPHENO:0081777', 'UBERON:0000477', 'UBERON:0000061', 'HP:0012379', 'UPHENO:0034199', 'UPHENO:0002427', 'HP:0003155', 'PR:000003968', 'UPHENO:0075666', 'CHEBI:25367', 'UPHENO:0066925', 'UPHENO:0049874', 'CHEBI:24833', 'UBERON:0000064', 'CHEBI:36587', 'CHEBI:72695', 'CHEBI:33608', 'UPHENO:0066939', 'CHEBI:35605', 'HP:0033127', 'CHEBI:36586', 'CHEBI:64709', 'HP:0003109', 'UPHENO:0002359', 'HP:0003011', 'UBERON:0001630', 'GO:0008152', 'UPHENO:0003047', 'UPHENO:0051709', 'UBERON:0002100', 'UPHENO:0055067', 'HP:0100529', 'HP:0002148', 'UPHENO:0049587', 'UPHENO:0085627', 'UBERON:0005173', 'UBERON:0006555', 'UPHENO:0049618', 'UBERON:0006314', 'UBERON:0000923', 'UPHENO:0066950', 'UPHENO:0002731', 'UPHENO:0002422', 'UBERON:0005156', 'UBERON:0009569', 'UPHENO:0066921', 'UPHENO:0002531', 'UPHENO:0005201', 'UPHENO:0003088', 'UPHENO:0005285', 'UPHENO:0055006', 'UBERON:0003914', 'UPHENO:0049703', 'HP:0011042', 'UPHENO:0066954', 'CHEBI:60242', 'UPHENO:0002252', 'UPHENO:0048707', 'UPHENO:0004892', 'UPHENO:0002926', 'HP:0012072', 'UPHENO:0080351', 'UPHENO:0002949', 'UBERON:0007684', 'UPHENO:0081581', 'UPHENO:0005312', 'UBERON:0009773', 'UPHENO:0002248', 'CHEBI:33709', 'UPHENO:0002360', 'UPHENO:0002668', 'UPHENO:0002210', 'UBERON:0003064', 'GO:0006091', 'HP:0000124', 'UPHENO:0066959', 'UBERON:0002113', 'UPHENO:0066946', 'UPHENO:0002377', 'UPHENO:0003050', 'UBERON:0008987', 'UBERON:0001231', 'UPHENO:0002287', 'UPHENO:0002426', 'UBERON:0000916', 'UPHENO:0002246', 'UPHENO:0002859', 'UPHENO:0003025', 'CHEBI:35381', 'HP:0001324', 'HP:0000083', 'CHEBI:28358', 'CL:0002681', 'UBERON:0000990', 'UPHENO:0003999', 'UPHENO:0080379', 'UBERON:0005177', 'CL:0000424', 'UBERON:0005721', 'UPHENO:0080012', 'GO:0003014', 'UPHENO:0003191', 'UPHENO:0002793', 'UPHENO:7000428', 'UPHENO:0002765', 'UPHENO:0050391', 'UBERON:0012275', 'UPHENO:0050116', 'UBERON:0000353', 'UBERON:0001851', 'CL:1000449', 'UPHENO:0003209', 'UBERON:0007688', 'UPHENO:0003382', 'GO:0008150', 'UPHENO:0068144', 'UBERON:0005103', 'UBERON:0009201', 'UPHENO:0004969', 'UBERON:0000083', 'UPHENO:0003265', 'CL:1000746', 'HP:0032943', 'CL:0000066', 'UPHENO:0005075', 'UBERON:0005090', 'UPHENO:0002595', 'UPHENO:0068511', 'UBERON:0001225', 'UBERON:0004765', 'UBERON:0000058', 'UPHENO:0004360', 'CL:0000653', 'UPHENO:0002530', 'UPHENO:0003185'], 'has_phenotype_closure_label': ['Impaired renal tubular reabsorption of phosphate', 'renal absorption', 'decreased bone element strength', 'b cell morphology', 'Osteomalacia', 'kidney epithelial cell', 'renal corpuscle', 'cortex of kidney', 'renal glomerulus phenotype', 'multi-tissue structure', 'meso-epithelium phenotype', 'delayed growth', 'delayed biological_process', 'multicellular organism chemical entity level phenotype', 'increased level of carboxylic acid in urine', 'Growth abnormality', 'cell physiology phenotype', 'multicellular organism phenotype', 'glomerular cell', 'phosphorus molecular entity', 'mesonephric epithelium', 'anatomical entity height phenotype', 'oxoacid derivative', 'cellular process phenotype', 'uriniferous tubule', 'embryo phenotype', 'Abnormal renal physiology', 'mesonephric duct phenotype', 'primary amide', 'increased level of protein polypeptide chain in urine', 'protein polypeptide chain', 'Abnormality of metabolism/homeostasis', 'pnictogen molecular entity', 'epithelial vesicle', 'ketoacidosis', 'erythroid lineage cell', 'mononuclear leukocyte', 'skeletal system phenotype', 'heteroatomic molecular entity', 'leukocyte morphology phenotype', 'musculature phenotype', 'immune system', 'organ system subdivision physiology phenotype', 'anatomical structure physiology phenotype', 'hematopoietic cell', 'oxygen accumulating cell', 'Short stature', 'nephron', 'nucleate cell', 'urine protein level phenotype', 'small molecule biosynthetic process phenotype', 'skeletal system physiology phenotype', 'lateral plate mesoderm', 'skeletal system morphology phenotype', 'non-connected functional system', 'Hypokalemia', 'organ phenotype', 'mesoderm-derived structure', 'reproductive structure', 'decreased size of the anatomical entity', 'cell', 'renal system', 'decreased size of the material anatomical entity', 'Abnormal urine pH', 'skeletal system', 'Abnormal circulating metabolite concentration', 'musculature', 'amino acid chain', 'fatty acid derivative biosynthetic process', 'size of multicellular organism phenotype', 'hemolymphoid system', 'Abnormality of the musculoskeletal system', 'intermediate mesoderm phenotype', 'musculoskeletal system', 'epithelial tube phenotype', 'phosphate', 'anatomical entity mass density phenotype', 'oxygen molecular entity', 'lymphocyte morphology phenotype', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'urine phosphate level phenotype', 'decreased level of chemical entity', 'decreased functionality of the kidney epithelium', 'organ', 'reproductive organ', 'mesoderm-derived structure phenotype', 'trunk region element phenotype', 'disconnected anatomical group', 'Decreased anatomical entity mass density', 'leukocyte physiology phenotype', 'embryonic tissue', 'renal tubule', 'Reduced bone mineral density', 'organic amino compound', 'Elevated circulating alkaline phosphatase concentration', 'immune system phenotype', 'myeloid cell', 'anatomical entity dysfunction in independent continuant', 'duct', 'anatomical structure phenotype', 'musculature of body', 'protein', 'musculature of body phenotype', 'carbohydrate homeostasis phenotype', 'leukocyte', 'primary metabolic process', 'blood cell', 'Abnormality of the upper urinary tract', 'Abnormal bone ossification', 'cell phenotype', 'lymphocyte physiology phenotype', 'phosphorus oxoacids and derivatives', 't cell morphology', 'increased fatty acid derivative biosynthetic process', 'podocyte', 'amide', 'Growth delay', 'external genitalia', 'Metabolic acidosis', 'Abnormal renal tubular resorption', 'nephric duct', 'increased small molecule biosynthetic process', 'increased generation of precursor metabolites and energy', 'polypeptide', 'Abnormality of the skeletal system', 'decreased functionality of the nephron epithelium', 'motile cell', 'increased lipid biosynthetic process', 'renal absorption phenotype', 'occurrent', 'B cell physiology phenotype', 'organism subdivision', 'chemical entity', 'bone structure', 'epithelium phenotype', 'ketone body metabolic process', 'elemental molecular entity', 'hexose', 'Abnormality of bone mineral density', 'organ physiology phenotype', 'material anatomical entity phenotype', 'increased level of glucose in urine', 'chalcogen molecular entity', 'small molecule biosynthetic process', 'renal system phenotype', 'increased ketone body biosynthetic process', 'carbohydrate', 'Abnormal homeostasis', 'Abnormal urine protein level', 'glucose homeostasis phenotype', 'blood monoatomic ion level phenotype', 'aldohexose', 'podocyte phenotype', 'anatomical entity physiology phenotype', 'renal tubule phenotype', 'bone element mass density phenotype', 'decreased functionality of the renal tubule', 'renal/urinary system phenotype', 'biological_process phenotype', 'excretory system', 'phosphorus oxoacid derivative', 'carboxamide', 'Rickets', 'genitourinary system', 'upper urinary tract', 'organ system subdivision', 'musculoskeletal system phenotype', 'increased biosynthetic process', 'organochalcogen compound', 'Abnormality of the genitourinary system', 'anatomical system', 'organ part phenotype', 'homeostatic process', 'kidney mesenchyme', 'monosaccharide', 'hematopoietic system', 'Phenotypic abnormality', 'urine', 'anatomical entity morphology phenotype', 'anatomical system phenotype', 'increased cellular process', 'anatomical entity phenotype', 'main group molecular entity', 'mesonephric tubule', 'increased ketone body metabolic process', 'kidney epithelium', 'renal glomerulus', 'B cell', 'hemoglobin', 'continuant', 'decreased functionality of the anatomical structure', 'Abnormality of urine homeostasis', 'role urine level phenotype', 'increased level of monosaccharide in urine', 'Abnormality of the musculature', 'anatomical conduit', 'renal system physiology phenotype', 'abdomen element phenotype', 'Abnormal urine phosphate concentration', 'growth', 'anatomical conduit physiology phenotype', 'entity', 'polyatomic entity', 'increased metabolic process', 'external genitalia phenotype', 'Decreased bone element mass density', 'phenotypic effect', 'developing anatomical structure', 'blood cell phenotype', 'cortex phenotype', 'bodily fluid', 'decreased size of the multicellular anatomical structure', 'peptide', 'multicellular anatomical structure phenotype', 'Abnormal urinary electrolyte concentration', 'organic molecular entity', 'metabolic process phenotype', 'phenotype', 'small molecule metabolic process phenotype', 'decreased size of the multicellular organism', 'immune system morphology phenotype', 'Hyperphosphaturia', 'lipid metabolic process', 'phosphoric acid derivative', 'multicellular anatomical structure physiology phenotype', 'multicellular organism', 'lymphocyte of B lineage', 'glucose', 'renal filtration', 'Abnormal urinary organic compound level', 'material anatomical entity physiology phenotype', 'organism substance phenotype', 'Abnormality of the urinary system', 'muscle organ', 'independent continuant', 'Abnormality of the urinary system physiology', 'decreased functionality of the tissue', 'intermediate mesoderm', 'increased qualitatively biological_process', 'organism subdivision phenotype', 'pronephric duct phenotype', 'anatomical system physiology phenotype', 'vomiting', 'multicellular organismal process', 'epithelial cell of glomerular capsule', 'material entity', 'organooxygen compound', 'bone element', 'urine glucose level phenotype', 'cellular process', 'urine chemical entity level phenotype', 'acidosis', 'excretory tube', 'Abnormal muscle physiology', 'organism substance', 'growth phenotype', 'carbon group molecular entity', 'decreased functionality of the epithelium', 'kidney glomerular epithelial cell', 'bone ossification', 'eukaryotic cell', 'compound organ phenotype', 'skeletal element', 'Abnormal urine metabolite level', 'lymphocyte', 'tissue chemical entity level phenotype', 'excreta', 'carbohydrates and carbohydrate derivatives', 'decreased size of the anatomical structure', 'mesonephric duct', 'aciduria', 'increased fatty acid derivative metabolic process', 'subdivision of trunk phenotype', 'biological_process rate phenotype', 'p-block molecular entity', 'anatomical conduit phenotype', 'homeostasis', 'molecular entity', 'small molecule metabolic process', 'embryo', 'metabolic process', 'biological_process', 'excretory cell', 'phosphate level phenotype', 'presumptive structure', 'genitourinary system phenotype', 'process', 'multicellular anatomical structure', 'excretory tube physiology phenotype', 'renal system process', 'increased biological_process', 'single nucleate cell', 'hematopoietic system phenotype', 'generation of precursor metabolites and energy', 'blood potassium atom level phenotype', 'biosynthetic process', 'material anatomical entity', 'reproductive structure phenotype', 'increased primary metabolic process', 'metabolic acidosis', 'lipid metabolic process phenotype', 'taxon specific phenotype', 'mixture', 'Abnormal skeletal morphology', 'ossification', 'rickets', 'increased lipid metabolic process', 'anatomical entity', 'embryonic structure', 'mesonephros phenotype', 'insulin resistance', 'Hypophosphatemia', 'renal duct phenotype', 'pronephros phenotype', 'nitrogen molecular entity level phenotype', 'decreased functionality of the nephron tubule', 'chemical homeostasis', 'system process', 'Acidosis', 'ketone body biosynthetic process', 'All', 'multicellular organism height phenotype', 'generation of precursor metabolites and energy phenotype', 'Abnormality of acid-base homeostasis', 'lipid biosynthetic process phenotype', 'erythroid lineage cell morphology phenotype', 'lateral structure', 'Glycosuria', 'chemical homeostasis phenotype', 'embryonic tissue phenotype', 'pronephric mesoderm', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'tube', 'primary metabolic process phenotype', 'digestive system physiology phenotype', 'potassium atom level phenotype', 'biosynthetic process phenotype', 'glucose homeostasis', 'digestive system', 'increased small molecule metabolic process', 'fatty acid derivative metabolic process', 'decreased height of the anatomical entity', 'aldose', 'decreased height of the multicellular organism', 'developing anatomical structure phenotype', 'metal atom', 'main group element atom', 'decreased functionality of the excretory tube', 's-block element atom', 'germ layer / neural crest', 'Abnormal blood cation concentration', 'anlage', 'germ layer / neural crest phenotype', 'renal parenchyma', 'role blood level phenotype', 'Abnormal bone structure', 'alkaline phosphatase, tissue-nonspecific isozyme', 'Abnormality of body height', 'bone element phenotype', 'blood cation level phenotype', 'blood phenotype', 'decreased level of chemical entity in blood', 'lateral plate mesoderm phenotype', 'potassium atom', 'osteomalacia', 'organ system subdivision phenotype', 'organic molecule', 'kidney mesenchyme phenotype', 'inorganic cation', 'tissue', 'Abnormal circulating potassium concentration', 'decreased level of potassium atom in blood', 'epithelium physiology phenotype', 'alkali metal atom', 'Muscle weakness', 'tube physiology phenotype', 'anlage phenotype', 'trunk', 'mesenchyme', 'Low-molecular-weight proteinuria', 'inorganic ion', 'organ subunit phenotype', 'anatomical cluster phenotype', 'chemical entity level phenotype', 'Lacticaciduria', 'monoatomic entity', 'cation', 'amino acid level phenotype', 'monoatomic ion', 'trunk phenotype', 'decreased level of chemical entity in tissue', 'molecule', 'germ layer phenotype', 'decreased functionality of the anatomical entity', 'decreased functionality of the epithelial tube', 'haemolymphatic fluid phenotype', 'Abnormal blood monovalent inorganic cation concentration', 'trunk mesenchyme phenotype', 'tissue phenotype', 'mesoderm', 'mesenchyme phenotype', 'Renal tubular dysfunction', 'role bodily fluid level phenotype', 'podocyte physiology phenotype', 'atom', 'blood monovalent inorganic cation level phenotype', 'blood island phenotype', 'kidney corpuscule cell', 'ion', 'blood chemical entity level phenotype', 'dense mesenchyme tissue', 'embryonic structure phenotype', 'monovalent inorganic cation', 'blood', 'carbohydrate homeostasis', 'Aminoaciduria', 'inorganic molecular entity', 'blood island', 'Abnormal enzyme concentration or activity', 'alkaline phosphatase, tissue-nonspecific isozyme level phenotype', 'nephron epithelium phenotype', 'Abnormal circulating enzyme concentration or activity', 'germ layer', 'parenchyma phenotype', 'Abnormality of alkaline phosphatase level', 'increased level of alkaline phosphatase, tissue-nonspecific isozyme', 'kidney epithelium phenotype', 'epithelial cell', 'increased level of chemical entity', 'mesonephric epithelium phenotype', 'organonitrogen compound', 'Abnormal urine amino acid level', 'decreased level of phosphate in blood', 'kidney phenotype', 'hydroxides', 'hydrogen molecular entity', 'increased level of phosphate in urine', 'dense mesenchyme tissue phenotype', 'amino acid', 'lipid biosynthetic process', 'excretory tube phenotype', 'increased level of organic acid in urine', 'oxoacid', 'organic acid', 'organic oxo compound', 'increased level of amino acid in urine', 'carbon oxoacid', 'carbonyl compound', 'Aciduria', 'carboxylic acid', 'detached podocyte; visceral epithelial cell detachment', 'urine amino acid level phenotype', 'pronephros', 'cortex', 'muscle structure physiology phenotype', 's-block molecular entity', 'muscle organ phenotype', 'muscle organ physiology phenotype', 'muscle structure phenotype', 'muscle structure', 'decreased muscle organ strength', 'increased level of chemical entity in urine', 'increased urine role level', 'Abnormal blood phosphate concentration', 'size of anatomical entity phenotype', 'organ part', 'Abnormal blood ion concentration', 'decreased functionality of the multicellular anatomical structure', 'nephron tubule phenotype', 'decreased functionality of the anatomical conduit', 'blood phosphate level phenotype', 'trunk region element physiology phenotype', 'parenchyma', 'abdominal segment element physiology phenotype', 'glomerular visceral epithelium', 'abdominal segment element phenotype', 'trunk region element', 'epithelial vesicle phenotype', 'compound organ', 'kidney cortical cell', 'nephron epithelium', 'anatomical structure', 'cavitated compound organ phenotype', 'main body axis', 'upper urinary tract phenotype', 'subdivision of trunk', 'body proper', 'decreased functionality of the material anatomical entity', 'kidney physiology phenotype', 'abdominal segment element', 'subdivision of organism along main body axis phenotype', 'nephron phenotype', 'Abnormality of the kidney', 'skeletal element phenotype', 'presumptive structure phenotype', 'cavitated compound organ physiology phenotype', 'erythrocyte', 'heteroorganic entity', 'tube phenotype', 'epithelial tube physiology phenotype', 'epithelium', 'compound organ physiology phenotype', 'lateral structure physiology phenotype', 'entire embryonic mesenchyme', 'abdomen element', 'glomerular epithelium', 'abdomen element physiology phenotype', 'epithelial tube', 'tissue physiology phenotype', 'kidney', 'subdivision of organism along main body axis', 'chemical substance', 'lateral structure phenotype', 'nephron tubule', 'decreased functionality of the tube', 'abdominal segment of trunk', 'macromolecule', 'abdomen', 'glomerular capsule', 'Renal insufficiency', 'nephric duct phenotype', 'multicellular organismal process phenotype', 'kidney cell', 'renal duct', 'erythrocyte morphology phenotype', 'haemolymphatic fluid', 'epithelial cell of nephron', 'renal cortical epithelial cell', 'pronephric duct', 'duct phenotype', 'decreased creatinine clearance; decreased glomerular filtration rate', 'homeostatic process phenotype', 'increased level of rac-lactic acid in urine', 'bodily fluid phenotype', 'decreased anatomical entity strength', 'meso-epithelium', 'mesonephros', 'organ subunit', 'renal filtration cell', 'Proteinuria', 'rac-lactic acid', 'renal filtration phenotype', 'cavitated compound organ', 'pronephric mesoderm phenotype', 'reproductive system', 'trunk mesenchyme', 'racemate', 'renal system process phenotype', 'reproductive organ phenotype', 'system process phenotype', 'urine ph', 'nitrogen molecular entity', 'anatomical cluster', 'multi-tissue structure phenotype', 'mesonephric tubule phenotype', 'mesoderm phenotype', 'renal filtration rate phenotype', 'decreased role blood level', 'reproductive system phenotype'], 'has_descendant': ['MONDO:0024525'], 'has_descendant_label': ['Fanconi renotubular syndrome 1'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0100238', 'category': 'biolink:Disease', 'name': 'inherited Fanconi renotubular syndrome', 'description': 'An instance of Fanconi renotubular syndrome that is inherited.', 'xref': ['OMIMPS:134600'], 'synonym': ['hereditary Fanconi renotubular syndrome'], 'exact_synonym': ['hereditary Fanconi renotubular syndrome'], 'subsets': ['gard_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype_count': 0, 'has_descendant': ['MONDO:0030056', 'MONDO:0007600', 'MONDO:0100238', 'MONDO:0014275', 'MONDO:0013247', 'MONDO:0024525', 'MONDO:0014458'], 'has_descendant_label': ['Fanconi renotubular syndrome 5', 'primary Fanconi syndrome', 'inherited Fanconi renotubular syndrome', 'Fanconi renotubular syndrome 3', 'Fanconi renotubular syndrome 2', 'Fanconi renotubular syndrome 1', 'Fanconi renotubular syndrome 4 with maturity-onset diabetes of the young'], 'has_descendant_count': 7, 'highlighting': None}, {'id': 'MONDO:0014275', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome 3', 'description': 'Any Fanconi syndrome in which the cause of the disease is a mutation in the EHHADH gene.', 'xref': ['DOID:0080759', 'GARD:15991', 'MEDGEN:816430', 'OMIM:615605', 'UMLS:C3810100'], 'synonym': ['EHHADH Fanconi syndrome', 'FRTS3', 'Fanconi renotubular syndrome 3', 'Fanconi renotubular syndrome type 3', 'Fanconi syndrome caused by mutation in EHHADH'], 'exact_synonym': ['EHHADH Fanconi syndrome', 'Fanconi renotubular syndrome 3', 'Fanconi renotubular syndrome type 3', 'Fanconi syndrome caused by mutation in EHHADH'], 'related_synonym': ['FRTS3'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0003076', 'HP:0003259', 'HP:0002979', 'HP:0003109', 'HP:0000083', 'HP:0001942', 'HP:0004322', 'HP:0001510', 'HP:0003355', 'HP:0003126', 'HP:0002748'], 'has_phenotype_label': ['Aminoaciduria', 'Bowing of the legs', 'Renal insufficiency', 'Low-molecular-weight proteinuria', 'Elevated circulating creatinine concentration', 'Glycosuria', 'Growth delay', 'Hyperphosphaturia', 'Short stature', 'Metabolic acidosis', 'Rickets'], 'has_phenotype_count': 11, 'has_phenotype_closure': ['UPHENO:0068565', 'HP:0003126', 'CHEBI:15841', 'HP:0000093', 'CHEBI:16541', 'PR:000000001', 'UPHENO:0051673', 'HP:0020129', 'UPHENO:0003025', 'UPHENO:0002246', 'HP:0010935', 'UBERON:0002100', 'UPHENO:0002427', 'UPHENO:0002426', 'UPHENO:0003093', 'UPHENO:0003050', 'UPHENO:0002377', 'UBERON:0002113', 'UBERON:0011143', 'UBERON:0005172', 'UBERON:0003103', 'UBERON:0005177', 'UBERON:0000916', 'UPHENO:0003088', 'UBERON:0009569', 'UPHENO:0002386', 'UPHENO:0002422', 'HP:0000077', 'UPHENO:0002803', 'UBERON:0005173', 'GO:0001503', 'UPHENO:7000586', 'HP:0003330', 'UPHENO:0088134', 'CL:0000232', 'CL:0000738', 'UPHENO:0002308', 'CL:0000764', 'GO:0032501', 'UPHENO:0082834', 'UPHENO:7000393', 'UPHENO:0085602', 'CL:0000081', 'CL:0000000', 'UPHENO:0085578', 'UPHENO:0080010', 'HP:0004349', 'UPHENO:7000428', 'UBERON:0002405', 'UBERON:0015203', 'CL:0000255', 'CL:0002242', 'CL:0000219', 'UPHENO:0085616', 'UPHENO:0002281', 'UBERON:0034923', 'HP:0011849', 'UPHENO:0076286', 'UPHENO:0076285', 'UPHENO:0052002', 'UBERON:0001977', 'UBERON:0001969', 'UPHENO:0051894', 'CHEBI:37622', 'CHEBI:25693', 'CHEBI:24532', 'CHEBI:55370', 'UPHENO:7000414', 'CHEBI:38261', 'UPHENO:0003516', 'UBERON:0001460', 'UPHENO:0004459', 'UBERON:0004357', 'UBERON:0002091', 'UBERON:0007376', 'UPHENO:0003227', 'UBERON:3000961', 'UBERON:0004288', 'UPHENO:0003163', 'UPHENO:0002360', 'CHEBI:33709', 'UPHENO:0002983', 'UBERON:0000465', 'UPHENO:0002559', 'UPHENO:0002870', 'UPHENO:0004467', 'UBERON:0003460', 'UPHENO:0002443', 'UPHENO:0001360', 'UBERON:0005893', 'UBERON:0011249', 'CHEBI:26079', 'HP:0002814', 'HP:0000118', 'UBERON:0000922', 'CHEBI:33674', 'UPHENO:0082835', 'UBERON:0004709', 'UPHENO:0003799', 'UPHENO:0081544', 'UPHENO:0002830', 'UBERON:0003061', 'UBERON:0010709', 'UPHENO:0084767', 'UBERON:0010708', 'UPHENO:0004504', 'HP:0011844', 'UPHENO:0047891', 'HP:0025745', 'UPHENO:0001134', 'UPHENO:0001340', 'UPHENO:0068556', 'UPHENO:0002880', 'UBERON:0008784', 'UBERON:0002102', 'UPHENO:0002525', 'CL:0000842', 'UBERON:0002199', 'HP:0002979', 'UBERON:0000981', 'HP:0003109', 'UBERON:0010363', 'UPHENO:0004064', 'UPHENO:0031123', 'UBERON:0010758', 'UPHENO:0076703', 'UBERON:0000075', 'UBERON:0012476', 'UBERON:0002204', 'UPHENO:0054954', 'UPHENO:0002648', 'UPHENO:0002577', 'CHEBI:33670', 'UBERON:0002386', 'UBERON:0004375', 'HP:0006487', 'UBERON:0010912', 'UPHENO:0002967', 'GO:0044281', 'UPHENO:0055082', 'UPHENO:0047948', 'UPHENO:0002731', 'UPHENO:0055006', 'UBERON:0000026', 'UPHENO:0047833', 'HP:0012211', 'HP:0000002', 'CHEBI:33661', 'GO:0040007', 'UPHENO:0052038', 'UPHENO:0081581', 'UPHENO:0069327', 'UBERON:0002417', 'UPHENO:0080352', 'UPHENO:0047883', 'UPHENO:0081424', 'UPHENO:0086928', 'UPHENO:0081423', 'UPHENO:0004404', 'UBERON:0004251', 'GO:0006629', 'UPHENO:0049628', 'HP:0000940', 'CHEBI:33575', 'UPHENO:0085691', 'UPHENO:0054970', 'UBERON:0003104', 'UPHENO:0084763', 'CHEBI:33241', 'HP:0001942', 'UPHENO:0050791', 'UPHENO:0049873', 'UPHENO:0002949', 'UPHENO:0080351', 'HP:0001941', 'UBERON:0015061', 'UPHENO:0075159', 'UPHENO:0049723', 'UPHENO:0003812', 'CHEBI:24431', 'CHEBI:16737', 'UPHENO:0081547', 'UPHENO:0087852', 'HP:0002748', 'UBERON:0004381', 'UPHENO:0069062', 'UPHENO:0086172', 'UPHENO:0001303', 'UPHENO:0055067', 'UBERON:0004120', 'UPHENO:0086956', 'UBERON:0000383', 'UPHENO:0055014', 'UPHENO:0002909', 'UPHENO:0002944', 'UBERON:0003464', 'UPHENO:0080377', 'UPHENO:0082536', 'UPHENO:0001002', 'UPHENO:0046348', 'UBERON:0004923', 'UBERON:0006058', 'UPHENO:0085566', 'UPHENO:7000227', 'HP:0002813', 'UBERON:0001008', 'UPHENO:0002832', 'CHEBI:33579', 'UBERON:0000479', 'BFO:0000015', 'UPHENO:0055032', 'UBERON:0002193', 'UPHENO:0088170', 'UPHENO:0076739', 'UPHENO:0076692', 'UPHENO:0050121', 'UPHENO:0002593', 'UPHENO:0046284', 'HP:0012337', 'CHEBI:23367', 'GO:0008152', 'UPHENO:0002442', 'UPHENO:0001001', 'UPHENO:0003095', 'HP:0040064', 'UPHENO:3000004', 'UBERON:0006314', 'UPHENO:0049618', 'UBERON:0000923', 'UPHENO:0003378', 'UBERON:0000064', 'UPHENO:0049874', 'CHEBI:24833', 'CHEBI:33302', 'UBERON:0000307', 'UPHENO:0047979', 'UBERON:0000468', 'CHEBI:33917', 'UPHENO:0068251', 'CHEBI:26082', 'UBERON:0015022', 'UBERON:0000061', 'UPHENO:0054955', 'UPHENO:0046383', 'UPHENO:0068110', 'UPHENO:0002659', 'UBERON:0001007', 'UBERON:0002027', 'CHEBI:36360', 'UPHENO:0002738', 'CHEBI:26020', 'HP:0033354', 'CHEBI:78616', 'UPHENO:0051630', 'UPHENO:0002568', 'UPHENO:7000630', 'UBERON:0004765', 'UBERON:0000154', 'UBERON:0000976', 'UBERON:0015212', 'CHEBI:36359', 'CHEBI:35605', 'UPHENO:0054961', 'UBERON:0000924', 'UBERON:0013702', 'UPHENO:0004723', 'GO:0048878', 'HP:0004348', 'UPHENO:0002746', 'UBERON:0000463', 'UPHENO:0050416', 'CHEBI:35352', 'UBERON:0010316', 'UPHENO:0003110', 'BFO:0000001', 'UPHENO:0049904', 'UPHENO:0002526', 'UPHENO:0002964', 'UPHENO:0051763', 'HP:0001510', 'CL:0000226', 'HP:0000001', 'UPHENO:0004885', 'UPHENO:0051739', 'HP:0012591', 'UBERON:8450002', 'UBERON:0006715', 'UPHENO:0000541', 'UPHENO:0002532', 'HP:0011277', 'CHEBI:38101', 'UPHENO:0051635', 'UBERON:0015002', 'UPHENO:0076697', 'UBERON:0005417', 'UPHENO:0068049', 'UBERON:0003607', 'UBERON:0001003', 'UPHENO:0002642', 'UPHENO:0003100', 'HP:0001939', 'UBERON:0005418', 'CL:0000988', 'UPHENO:0075195', 'UPHENO:0049835', 'UPHENO:0054967', 'UPHENO:0004726', 'UPHENO:0047894', 'HP:0000924', 'CHEBI:37577', 'UBERON:0004122', 'CHEBI:33256', 'GO:0042593', 'CHEBI:18133', 'CHEBI:17234', 'UPHENO:0002554', 'UPHENO:0089764', 'BFO:0000003', 'HP:0004322', 'CL:0000236', 'GO:0044283', 'UPHENO:0003049', 'UPHENO:0055071', 'UPHENO:0041098', 'UBERON:0010703', 'UPHENO:0087665', 'UPHENO:0089294', 'UPHENO:0002632', 'UBERON:0005419', 'UPHENO:0004503', 'BFO:0000002', 'UPHENO:0079534', 'UBERON:0002101', 'HP:0000119', 'UPHENO:0002963', 'CHEBI:33582', 'CHEBI:36962', 'UPHENO:0002267', 'UPHENO:0068169', 'UPHENO:0004173', 'GO:0046951', 'UPHENO:0002270', 'UPHENO:0086546', 'HP:0012599', 'UPHENO:0004888', 'UPHENO:0088166', 'UBERON:0001015', 'HP:0000079', 'CL:0000945', 'UPHENO:0002536', 'UPHENO:0002269', 'UBERON:0002529', 'UBERON:0010000', 'UPHENO:0050240', 'BFO:0000040', 'UPHENO:0068054', 'UPHENO:0031122', 'UBERON:0010742', 'CHEBI:25806', 'UPHENO:0002976', 'HP:0004364', 'UPHENO:0069266', 'UPHENO:0002530', 'UPHENO:0003334', 'CHEBI:33675', 'GO:1901568', 'HP:0004360', 'UPHENO:0002861', 'CHEBI:33304', 'CHEBI:16646', 'UPHENO:0002411', 'UPHENO:0002785', 'UBERON:0010720', 'HP:0001507', 'HP:0000083', 'CHEBI:35381', 'HP:0003110', 'CHEBI:15693', 'UPHENO:0031220', 'UPHENO:0004456', 'CHEBI:33285', 'BFO:0000004', 'CHEBI:50047', 'CHEBI:36963', 'UBERON:0000475', 'UPHENO:0080658', 'UPHENO:0087661', 'UBERON:0001062', 'UPHENO:0004506', 'UPHENO:0003198', 'UPHENO:0050433', 'GO:1901570', 'UPHENO:0031142', 'UPHENO:0080662', 'UPHENO:0055132', 'UPHENO:0069254', 'UPHENO:0002585', 'PR:000018263', 'UPHENO:0055153', 'UPHENO:0002635', 'UBERON:0000926', 'GO:0006091', 'UPHENO:0003065', 'UPHENO:0051900', 'UPHENO:7000318', 'GO:0033500', 'HP:0002981', 'UPHENO:0068491', 'UPHENO:0068352', 'UPHENO:0002896', 'UPHENO:0002833', 'GO:0009058', 'UBERON:0003102', 'HP:0040068', 'UBERON:0006601', 'UPHENO:0050220', 'UPHENO:0001003', 'GO:0042592', 'GO:0044238', 'UPHENO:0050116', 'UPHENO:0049587', 'UPHENO:0087123', 'UPHENO:7000306', 'UPHENO:0041573', 'UPHENO:0002750', 'UPHENO:0055077', 'UPHENO:0002945', 'UBERON:0008202', 'UPHENO:0041536', 'UPHENO:0002531', 'UPHENO:0002637', 'UPHENO:0005029', 'UPHENO:0004537', 'UPHENO:7000317', 'UPHENO:0002968', 'UBERON:0011582', 'UPHENO:0084654', 'UBERON:0003461', 'HP:0002157', 'UBERON:0000060', 'CHEBI:23443', 'UBERON:0034944', 'UPHENO:0068346', 'UPHENO:0003432', 'UPHENO:0002541', 'UPHENO:0075952', 'UPHENO:0047838', 'UPHENO:0002385', 'UPHENO:0003411', 'UPHENO:0087344', 'UPHENO:0031323', 'UPHENO:0003864', 'UBERON:0010314', 'UPHENO:0001135', 'UBERON:0000490', 'UBERON:0000076', 'UBERON:0011584', 'UPHENO:0000543', 'UBERON:0005055', 'UPHENO:0003722', 'UPHENO:0003364', 'HP:0011314', 'UPHENO:0068064', 'UPHENO:0002639', 'UPHENO:0047887', 'UPHENO:0005030', 'UPHENO:0004909', 'CHEBI:36357', 'UPHENO:0041258', 'UBERON:0000978', 'UPHENO:0082539', 'UPHENO:0003413', 'UPHENO:0002969', 'UPHENO:0048707', 'UPHENO:0004892', 'UPHENO:0002926', 'UPHENO:0051686', 'UBERON:0034925', 'UBERON:0000467', 'UPHENO:0005092', 'UPHENO:0005141', 'UBERON:0003081', 'UBERON:0005913', 'UPHENO:0068472', 'UPHENO:0068971', 'UBERON:0010740', 'UBERON:0002513', 'UPHENO:0002567', 'UPHENO:0002747', 'UBERON:0006598', 'UPHENO:0087663', 'UPHENO:0005232', 'UBERON:0010741', 'UPHENO:0031339', 'UPHENO:0002564', 'UPHENO:0086635', 'UBERON:0005420', 'UPHENO:0047917', 'UPHENO:0002754', 'UBERON:0000062', 'UBERON:0001474', 'UBERON:0013701', 'UBERON:0008962', 'UBERON:0003608', 'UBERON:0015052', 'UBERON:0007272', 'UBERON:0003822', 'CHEBI:16670', 'UBERON:0001441', 'HP:0011842', 'UBERON:0002103', 'UBERON:0006714', 'UPHENO:0002650', 'UPHENO:0003193', 'UPHENO:0002600', 'UPHENO:0084653', 'UBERON:0004708', 'UPHENO:0003584', 'UPHENO:0086628', 'UPHENO:7000215', 'UPHENO:0002948', 'UBERON:0002390', 'UPHENO:0002553', 'UBERON:0004769', 'UBERON:0002471', 'CHEBI:33839', 'HP:0032180', 'UBERON:0008785', 'CL:0000763', 'GO:0008610', 'UBERON:0002472', 'UBERON:0002416', 'UPHENO:0005110', 'UBERON:0000174', 'UPHENO:0087849', 'UPHENO:0002594', 'UPHENO:0080300', 'UPHENO:0002816', 'HP:0003259', 'UPHENO:0003514', 'UPHENO:0041591', 'UBERON:0001440', 'UBERON:0000489', 'UBERON:0010538', 'UPHENO:0003094', 'UPHENO:0003415', 'UBERON:0000179', 'UPHENO:0001392', 'UPHENO:0004595', 'UBERON:0011676', 'UPHENO:0004466', 'UBERON:0001434', 'UBERON:0007273', 'UBERON:0002495', 'UPHENO:0041610', 'UBERON:0003823', 'CHEBI:33608', 'UPHENO:0047949', 'UPHENO:0087660', 'UBERON:0015053', 'UPHENO:0001072', 'UPHENO:0005214', 'UPHENO:7000212', 'UPHENO:0031166', 'UPHENO:0002542', 'UPHENO:0075902', 'UPHENO:0076727', 'UPHENO:0002751', 'HP:0003076', 'UPHENO:0003366', 'UPHENO:0003865', 'UBERON:0002097', 'UPHENO:0075955', 'UBERON:0010707', 'UBERON:0010712', 'UBERON:0000178', 'CHEBI:50860', 'GO:0009987', 'UBERON:0005291', 'UBERON:0000153', 'UBERON:0003826', 'CHEBI:24995', 'UBERON:0003466', 'UBERON:0004250', 'UPHENO:0047821', 'UPHENO:0003811', 'UPHENO:0086780', 'UPHENO:0004470', 'HP:0012100', 'UPHENO:0031276', 'UBERON:0003606', 'UPHENO:0078550', 'UPHENO:0031271', 'UBERON:0004347', 'UBERON:0011216', 'UPHENO:0002719', 'UPHENO:0003070', 'UPHENO:0002586', 'UPHENO:0088162', 'UPHENO:0002987', 'UPHENO:0088123', 'UBERON:0005423', 'UBERON:0004710', 'UPHENO:0004172', 'UBERON:0012475', 'UBERON:0002428', 'UBERON:0013754', 'UPHENO:0031228', 'UPHENO:0041226', 'UPHENO:0004680', 'UPHENO:0002758', 'UPHENO:0046286', 'UPHENO:0004505', 'UPHENO:0087435', 'UPHENO:0004475', 'UBERON:0007524', 'CL:0000329', 'UPHENO:0082875', 'UPHENO:0076740', 'UPHENO:0004900', 'UPHENO:7000595', 'UPHENO:0004418', 'UPHENO:7000381', 'UPHENO:0004596', 'CHEBI:51143', 'CL:0000542', 'UPHENO:0031302', 'RO:0002577', 'UPHENO:0002571', 'UPHENO:0003005', 'GO:1902224', 'UPHENO:0001147', 'HP:0003355', 'UBERON:0000376', 'UPHENO:0031318', 'UBERON:0002050', 'UBERON:0000483', 'CHEBI:25367', 'CHEBI:36587', 'UPHENO:7000305', 'CHEBI:24651', 'CHEBI:72695', 'GO:0008150', 'UPHENO:0068144', 'HP:0033127', 'CHEBI:36586', 'CHEBI:64709', 'UPHENO:0003159', 'UBERON:0015021', 'UBERON:0001088', 'UPHENO:0003207', 'UPHENO:0051804', 'HP:6000531', 'UPHENO:0068442', 'HP:0430071', 'UPHENO:0077826', 'CHEBI:33832', 'CHEBI:5686', 'CHEBI:32988', 'CHEBI:33595', 'UPHENO:0077817', 'CHEBI:38304'], 'has_phenotype_closure_label': ['increased level of protein polypeptide chain in urine', 'amino acid chain', 'peptide', 'polypeptide', 'Proteinuria', 'Low-molecular-weight proteinuria', 'protein', 'Renal insufficiency', 'trunk', 'abdominal segment of trunk', 'kidney phenotype', 'upper urinary tract phenotype', 'organ physiology phenotype', 'kidney', 'upper urinary tract', 'trunk phenotype', 'abdomen element physiology phenotype', 'abdomen element', 'lateral structure physiology phenotype', 'Abnormality of the upper urinary tract', 'Abnormality of the kidney', 'trunk region element phenotype', 'subdivision of organism along main body axis phenotype', 'macromolecule', 'abdomen', 'cavitated compound organ', 'trunk region element physiology phenotype', 'body proper', 'main body axis', 'abdominal segment element', 'kidney physiology phenotype', 'compound organ phenotype', 'subdivision of trunk phenotype', 'compound organ', 'abdominal segment element phenotype', 'abdominal segment element physiology phenotype', 'erythroid lineage cell', 'mononuclear leukocyte', 'hemoglobin', 'cell physiology phenotype', 'leukocyte morphology phenotype', 'organ system subdivision physiology phenotype', 'non-connected functional system', 'B cell', 'oxygen accumulating cell', 'skeletal system physiology phenotype', 'bone element mass density phenotype', 'multicellular anatomical structure physiology phenotype', 'Abnormality of bone mineral density', 'immune system', 'anatomical entity mass density phenotype', 'lymphocyte morphology phenotype', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'leukocyte physiology phenotype', 'bone structure', 'immune system phenotype', 'blood cell', 'single nucleate cell', 'myeloid cell', 'blood cell phenotype', 'eukaryotic cell', 'bone ossification', 'Abnormal bone structure', 'Abnormal bone ossification', 'Rickets', 'ossification', 'rickets', 'cell phenotype', 'multicellular organismal process', 'lymphocyte physiology phenotype', 'increased level of nitrogen molecular entity in blood', 'blood chemical entity level phenotype', 'blood island phenotype', 'role bodily fluid level phenotype', 'increased level of chemical entity in tissue', 'carboxamide', 'organic heteromonocyclic compound', 'organonitrogen heterocyclic compound', 'heteromonocyclic compound', 'compound organ physiology phenotype', 'organic heterocyclic compound', 'blood oxygen molecular entity level phenotype', 'haemolymphatic fluid phenotype', 'organic cyclic compound', 'paired limb/fin bud', 'organic oxo compound', 'aldohexose', 'pelvic appendage skeleton', 'organism subdivision phenotype', 'homeostatic process', 'forelimb bone phenotype', 'mesenchyme morphology phenotype', 'germ layer / neural crest phenotype', 'musculature of body phenotype', 'role blood serum level phenotype', 'urine protein level phenotype', 'nucleate cell', 'curvature anatomical entity', 'hindlimb bone phenotype', 'Decreased anatomical entity mass density', 'stratum corneum of epidermis', 'organic amino compound', 'zeugopodial skeleton', 'increased size of the anatomical structure', 'structure with developmental contribution from neural crest', 'Bowing of the legs', 'biosynthetic process', 'Abnormality of body height', 'bone element phenotype', 'carbohydrate homeostasis phenotype', 'limb bud morphology phenotype', 'leg bone phenotype', 'bone of appendage girdle complex', 'mesoderm-derived structure phenotype', 'germ layer / neural crest', 'forelimb zeugopod bone phenotype', 'hindlimb long bone phenotype', 'pectoral appendage skeleton', 'increased size of the multicellular anatomical structure', 'chalcogen molecular entity', 'bone of free limb or fin phenotype', 'urine amino acid level phenotype', 'shape of anatomical entity phenotype', 'multicellular anatomical structure, curved phenotype', 'forelimb phenotype', 'upper leg bone phenotype', 'limb bone morphology phenotype', 'monocyclic compound', 'chemical entity level phenotype', 'subdivision of organism along main body axis', 'germ layer morphology phenotype', 'p-block molecular entity', 'homeostasis', 'molecular entity', 'structure with developmental contribution from neural crest phenotype', 'developing anatomical structure phenotype', 'skin of body phenotype', 'primary amide', 'upper leg bone', 'paired limb/fin segment, curved phenotype', 'increased level of creatinine in blood serum', 'increased level of creatinine in blood', 'appendage phenotype', 'Reduced bone mineral density', 'limb bone phenotype', 'system', 'hindlimb morphology phenotype', 'taxon specific phenotype', 'skeleton of pelvic complex', 'embryo phenotype', 'surface structure phenotype', 'Abnormal renal physiology', 'external ectoderm', 'ketone body biosynthetic process', 'musculature of body', 'fatty acid derivative metabolic process', 'decreased height of the anatomical entity', 'decreased size of the anatomical entity', 'femur endochondral element phenotype', 'delayed biological_process', 'multicellular organism chemical entity level phenotype', 'increased level of carboxylic acid in urine', 'Short stature', 'Growth abnormality', 'multicellular organism phenotype', 't cell morphology', 'phosphorus oxoacids and derivatives', 'limb bud', 'increased fatty acid derivative biosynthetic process', 'Growth delay', 'external integument structure', 'carbonyl compound', 'Metabolic acidosis', 'skin epidermis', 'arm bone phenotype', 'increased small molecule biosynthetic process', 'motile cell', 'increased lipid biosynthetic process', 'heterocyclic compound', 'skeleton', 'ketone body metabolic process', 'small molecule biosynthetic process', 'glucose homeostasis', 'digestive system', 'hindlimb zeugopod bone', 'external ectoderm morphology phenotype', 'nitrogen molecular entity level phenotype', 'bodily fluid', 'embryonic tissue phenotype', 'pelvic appendage', 'Abnormal urine protein level', 'glucose homeostasis phenotype', 'radio-ulna phenotype', 'curved hindlimb zeugopod', 'biosynthetic process phenotype', 'integument phenotype', 'phosphorus molecular entity', 'appendage', 'increased blood role level', 'femur endochondral element', 'increased level of monosaccharide in urine', 'increased small molecule metabolic process', 'urine phosphate level phenotype', 'integumentary system layer phenotype', 'increased thickness of the organ part', 'blood phenotype', 'disconnected anatomical group', 'limb segment, curved phenotype', 'musculoskeletal system phenotype', 'organ system subdivision', 'lipid metabolic process', 'increased level of chemical entity in blood serum', 'immune system morphology phenotype', 'Hyperphosphaturia', 'limb segment', 'increased level of chemical entity in blood plasma', 'Abnormality of limb bone', 'shoulder bone phenotype', 'blood nitrogen molecular entity level phenotype', 'anatomical entity morphology phenotype', 'increased cellular process', 'zeugopod', 'lymphocyte of B lineage', 'multicellular organism', 'hexose', 'posterior region of body', 'long bone phenotype', 'pnictogen molecular entity', 'hindlimb bone', 'anatomical entity height phenotype', 'chemical entity', 'organism subdivision', 'radio-ulna', 'cyclic compound', 'oxoacid derivative', 'cellular process phenotype', 'lymphocyte', 'tissue chemical entity level phenotype', 'pectoral appendage bud', 'bone of hip region phenotype', 'material anatomical entity phenotype', 'increased level of glucose in urine', 'Abnormality of urine homeostasis', 'limb long bone phenotype', 'genitourinary system', 'increased biosynthetic process', 'Abnormal homeostasis', 'paired limb/fin skeleton', 'paired limb/fin skeleton phenotype', 'organochalcogen compound', 'bone of hip region', 'small molecule biosynthetic process phenotype', 'appendicular skeleton morphology phenotype', 'excretory system', 'decreased height of the multicellular organism', 'aldose', 'bone of appendage girdle complex phenotype', 'decreased size of the multicellular organism', 'anatomical entity physiology phenotype', 'increased ketone body biosynthetic process', 'embryo morphology phenotype', 'molecule', 'increased level of chemical entity', 'renal system', 'imidazolidinone', 'decreased size of the material anatomical entity', 'main group molecular entity', 'anatomical structure phenotype', 'Abnormal circulating nitrogen compound concentration', 'skeletal element, curved phenotype', 'pectoral appendage bud phenotype', 'curved anatomical entity', 'multicellular organism height phenotype', 'All', 'outer epithelium', 'mesoderm phenotype', 'Abnormal limb bone morphology', 'humerus', 'entity', 'lower limb segment, curved phenotype', 'lipid biosynthetic process', 'anatomical entity phenotype', 'polyatomic entity', 'urine glucose level phenotype', 'continuant', 'renal system physiology phenotype', 'anatomical system', 'organ part phenotype', 'Decreased bone element mass density', 'phenotypic effect', 'developing anatomical structure', 'zeugopod phenotype', 'phosphoric acid derivative', 'unilaminar epithelium phenotype', 'mesoderm morphology phenotype', 'decreased size of the multicellular anatomical structure', 'multicellular anatomical structure phenotype', 'cavitated compound organ phenotype', 'anatomical structure', 'upper arm bone phenotype', 'endochondral element', 'pectoral appendage', 'Abnormality of the lower limb', 'phosphorus oxoacid derivative', 'lateral plate mesoderm', 'outer epithelium phenotype', 'cellular process', 'urine chemical entity level phenotype', 'growth', 'Abnormal urine phosphate concentration', 'homeostatic process phenotype', 'independent continuant', 'Abnormality of the urinary system physiology', 'material entity', 'organooxygen compound', 'Elevated circulating creatinine concentration', 'role urine level phenotype', 'limb bud phenotype', 'organism substance', 'growth phenotype', 'parakeratosis', 'appendage girdle complex', 'subdivision of skeletal system phenotype', 'metabolic process phenotype', 'phenotype', 'organic molecular entity', 'Abnormal urinary electrolyte concentration', 'skeletal system morphology phenotype', 'phosphate', 'limb endochondral element phenotype', 'forelimb zeugopod phenotype', 'integumental system phenotype', 'Abnormality of the calf', 'skeletal system', 'Abnormal circulating metabolite concentration', 'Phenotypic abnormality', 'limb skeleton subdivision', 'hematopoietic system', 'small molecule metabolic process', 'embryo', 'increased thickness of the organ component layer', 'metabolic process', 'multicellular anatomical structure', 'process', 'skeleton phenotype', 'hindlimb bud phenotype', 'multi-limb segment region phenotype', 'biological_process', 'increased thickness of the organ', 'organism substance phenotype', 'Abnormality of the urinary system', 'carbon group molecular entity', 'hemolymphoid system', 'phosphate level phenotype', 'genitourinary system phenotype', 'presumptive structure', 'humerus endochondral element', 'excreta', 'erythrocyte', 'Abnormal circulating creatinine concentration', 'heteroorganic entity', 'increased generation of precursor metabolites and energy', 'appendicular skeletal system', 'Abnormal circulating organic compound concentration', 'material anatomical entity physiology phenotype', 'Abnormal urinary organic compound level', 'monosaccharide', 'increased urine role level', 'increased level of chemical entity in urine', 'forelimb long bone phenotype', 'glucose', 'anatomical system physiology phenotype', 'vomiting', 'anatomical structure physiology phenotype', 'cavitated compound organ physiology phenotype', 'presumptive structure phenotype', 'stylopod', 'skeletal element phenotype', 'increased qualitatively biological_process', 'paired limb/fin bud phenotype', 'carbohydrates and carbohydrate derivatives', 'decreased size of the anatomical structure', 'increased fatty acid derivative metabolic process', 'hindlimb bud', 'curved long bone', 'material anatomical entity', 'increased primary metabolic process', 'primary metabolic process', 'hindlimb long bone', 'metabolic acidosis', 'limb', 'lipid metabolic process phenotype', 'increased ketone body metabolic process', 'ketoacidosis', 'increased lipid metabolic process', 'zone of long bone', 'anatomical entity', 'embryonic structure', 'limb phenotype', 'insulin resistance', 'hematopoietic cell', 'hindlimb endochondral element phenotype', 'pectoral appendage phenotype', 'increased thickness of the anatomical structure', 'Abnormal appendicular skeleton morphology', 'chemical homeostasis', 'Acidosis', 'oxygen molecular entity', 'lipid biosynthetic process phenotype', 'Glycosuria', 'chemical homeostasis phenotype', 'increased blood serum role level', 'Abnormality of metabolism/homeostasis', 'zone of organ', 's-block molecular entity', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'increased thickness of the integumentary system layer', 'primary metabolic process phenotype', 'hindlimb endochondral element', 'size of multicellular organism phenotype', 'fatty acid derivative biosynthetic process', 'digestive system physiology phenotype', 'anatomical system phenotype', 'hindlimb skeleton', 'paired limb/fin', 'cyclic amide', 'mesoderm-derived structure', 'forelimb skeleton', 'cell', 'lower limb segment phenotype', 'leg bone', 'tissue', 'protein polypeptide chain', 'arm bone', 'increased thickness of the structure with developmental contribution from neural crest', 'integumentary system layer', 'renal system phenotype', 'ectoderm morphology phenotype', 'bone of pectoral complex phenotype', 'shape of continuant phenotype', 'lateral plate mesoderm phenotype', 'humerus endochondral element phenotype', 'leg phenotype', 'bone of free limb or fin', 'upper limb segment phenotype', 'blood', 'embryonic structure phenotype', 'organ component layer phenotype', 'organ', 'erythroid lineage cell morphology phenotype', 'stratum corneum of epidermis morphology phenotype', 'paired limb/fin phenotype', 'humerus phenotype', 'increased size of the organ part', 'hindlimb zeugopod phenotype', 'generation of precursor metabolites and energy phenotype', 'Abnormality of acid-base homeostasis', 'external integument structure phenotype', 'shoulder bone', 'anatomical collection phenotype', 'forelimb zeugopod bone', 'subdivision of organism along appendicular axis', 'bone element', 'multi-limb segment region', 'increased thickness of the stratum corneum of epidermis', 'hindlimb zeugopod skeleton', 'forelimb zeugopod skeleton', 'integument', 'diaphysis', 'Abnormality of the musculoskeletal system', 'lower limb segment', 'upper limb segment', 'long bone', 'pelvic appendage phenotype', 'forelimb endochondral element phenotype', 'paired limb/fin segment', 'increased level of organic acid in urine', 'blood island', 'Abnormal long bone morphology', 'epithelium phenotype', 'epithelium', 'pelvic appendage bud phenotype', 'subdivision of skeleton phenotype', 'increased thickness of the material anatomical entity', 'organism subdivision, curved phenotype', 'embryonic tissue', 'mesenchyme', 'anterior region of body', 'tibiofibula', 'increased size of the organ', 'blastula', 'skeletal system phenotype', 'hindlimb phenotype', 'occurrent', 'limb morphology phenotype', 'lateral structure', 'surface structure', 'role blood level phenotype', 'Bowing of the long bones', 'musculoskeletal system', 'musculature', 'bone of pelvic complex', 'subdivision of skeleton', 'anatomical wall', 'arm', 'leg', 'trunk region element', 'blood creatinine level phenotype', 'radius-ulna endochondral element phenotype', 'shape of long bone phenotype', 'increased size of the structure with developmental contribution from neural crest', 'increased thickness of the multicellular anatomical structure', 'acidosis', 'organ, curved phenotype', 'limb endochondral element', 'oxoacid', 'organic acid', 'tibiofibula phenotype', 'forelimb zeugopod', 'Abnormality of limbs', 'blood plasma chemical entity level phenotype', 'presumptive ectoderm phenotype', 'Abnormality of the skeletal system', 'generation of precursor metabolites and energy', 'hematopoietic system phenotype', 'anatomical structure, curved phenotype', 'skin of body morphology phenotype', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'anatomical collection', 'size of anatomical entity phenotype', 'organ part', 'integumental system', 'musculature phenotype', 'increased thickness of the anatomical entity', 'increased level of chemical entity in bodily fluid', 'abdomen element phenotype', 'endochondral element phenotype', 'limb segment phenotype', 'subdivision of organism along appendicular axis, curved phenotype', 'subdivision of organism along appendicular axis phenotype', 'organ phenotype', 'shape of hindlimb zeugopod phenotype', 'blood serum chemical entity level phenotype', 'germ layer phenotype', 'urine', 'hindlimb skeleton phenotype', 'carbohydrate', 'zone of bone organ', 'forelimb skeleton phenotype', 'paired limb/fin segment phenotype', 'femur', 'germ layer', 'pelvic complex', 'small molecule metabolic process phenotype', 'pectoral complex', 'heteroatomic molecular entity', 'pelvic appendage bud', 'forelimb bone', 'forelimb long bone', 'renal/urinary system phenotype', 'biological_process phenotype', 'radius-ulna endochondral element', 'hindlimb stylopod', 'hindlimb zeugopod', 'diaphysis morphology', 'skeleton of limb', 'dense mesenchyme tissue', 'forelimb stylopod', 'pelvic appendage skeleton phenotype', 'increased biological_process', 'endochondral bone phenotype', 'hindlimb zeugopod morphology phenotype', 'skin epidermis morphology phenotype', 'limb skeleton subdivision phenotype', 'arm phenotype', 'skin of body', 'B cell physiology phenotype', 'ectoderm', 'material anatomical entity, curved phenotype', 'mesoderm', 'forelimb', 'forelimb bud', 'lateral structure phenotype', 'mesenchyme phenotype', 'presumptive ectoderm', 'increased size of the material anatomical entity', 'increased thickness of the skin of body', 'anatomical entity morphology in the pelvic complex phenotype', 'bone of pectoral complex', 'limb bone', 'long bone morphology phenotype', 'increased metabolic process', 'limb long bone', 'forelimb endochondral element', 'biological_process rate phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'anatomical entity thickness phenotype', 'leukocyte', 'femur phenotype', 'appendicular skeleton phenotype', 'forelimb stylopod phenotype', 'skeletal element', 'bone of pelvic complex phenotype', 'anatomical wall phenotype', 'skin epidermis phenotype', 'Abnormality of the genitourinary system', 'Abnormal diaphysis morphology', 'subdivision of skeletal system', 'bone element, curved phenotype', 'Abnormal skeletal morphology', 'Abnormal urine metabolite level', 'embryonic tissue morphology phenotype', 'delayed growth', 'hindlimb bud morphology phenotype', 'tissue phenotype', 'amide', 'unilaminar epithelium', 'hindlimb zeugopod bone phenotype', 'skeleton of pectoral complex', 'appendicular skeleton', 'amino acid level phenotype', 'hydroxides', 'lateral plate mesoderm morphology phenotype', 'organ system subdivision phenotype', 'increased size of the anatomical entity', 'organic molecule', 'hydrogen molecular entity', 'carbohydrate homeostasis', 'Aminoaciduria', 'increased level of phosphate in urine', 'dense mesenchyme tissue phenotype', 'amino acid', 'zeugopod, curved phenotype', 'nitrogen molecular entity', 'increased level of amino acid in urine', 'carbon oxoacid', 'carboxylic acid', 'blood plasma', 'hindlimb', 'increased size of the organ component layer', 'organ component layer', 'blood serum', 'organonitrogen compound', 'Abnormal urine amino acid level', 'Azotemia', 'upper arm bone', 'increased bodily fluid role level', 'blood organic molecular entity level phenotype', 'endochondral bone', 'bodily fluid phenotype', 'erythrocyte morphology phenotype', 'haemolymphatic fluid', 'lactam', 'subdivision of trunk', 'ectoderm phenotype', 'diazolidine', 'creatinine', 'imidazolidines', 'pectoral appendage skeleton phenotype', 'increased level of chemical entity in blood'], 'has_descendant': ['MONDO:0014275'], 'has_descendant_label': ['Fanconi renotubular syndrome 3'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0030056', 'category': 'biolink:Disease', 'name': 'Fanconi renotubular syndrome 5', 'xref': ['DOID:0080761', 'GARD:16392', 'MEDGEN:1711127', 'OMIM:618913', 'UMLS:C5394473'], 'synonym': ['FANCONI RENOTUBULAR SYNDROME 5', 'FRTS5', 'Fanconi Renotubular Syndrome, Acadian Variant', 'Fanconi renotubular syndrome 5'], 'exact_synonym': ['FANCONI RENOTUBULAR SYNDROME 5', 'FRTS5', 'Fanconi Renotubular Syndrome, Acadian Variant', 'Fanconi renotubular syndrome 5'], 'subsets': ['gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0004918', 'HP:0004912', 'HP:0003076', 'HP:0000822', 'HP:0002148', 'HP:0045051', 'HP:0002097', 'HP:0002206', 'HP:0005576', 'HP:0030078', 'HP:0000093', 'HP:0002857', 'HP:0003774', 'HP:0003355'], 'has_phenotype_label': ['Aminoaciduria', 'Emphysema', 'Lung adenocarcinoma', 'Hyperchloremic metabolic acidosis', 'Tubulointerstitial fibrosis', 'Stage 5 chronic kidney disease', 'Pulmonary fibrosis', 'Genu valgum', 'Hypertension', 'Glycosuria', 'Hypophosphatemic rickets', 'Hypophosphatemia', 'Decreased DLCO', 'Proteinuria'], 'has_phenotype_count': 14, 'has_phenotype_closure': ['HP:0045049', 'HP:0045051', 'GO:0001503', 'UPHENO:7000586', 'HP:0003330', 'UPHENO:0088134', 'CL:0000232', 'GO:0032501', 'UPHENO:0082834', 'UPHENO:7000393', 'UPHENO:0085602', 'UPHENO:7000414', 'CL:0000000', 'UPHENO:0085578', 'HP:0011849', 'UPHENO:0080010', 'HP:0004349', 'CL:0000255', 'CL:0002242', 'CL:0000219', 'UPHENO:0085616', 'UPHENO:0002281', 'UPHENO:0034253', 'UPHENO:0052002', 'CHEBI:26079', 'HP:0002148', 'CHEBI:33259', 'UBERON:0003061', 'CHEBI:33241', 'UPHENO:7000595', 'UPHENO:0004418', 'UPHENO:0004459', 'CHEBI:36359', 'CHEBI:26082', 'UPHENO:0051709', 'UPHENO:0051804', 'UPHENO:0034351', 'HP:0100491', 'CL:0000988', 'UPHENO:0075195', 'UPHENO:7000381', 'UPHENO:0004596', 'UPHENO:0047891', 'UPHENO:0086628', 'UBERON:0007524', 'UBERON:0000383', 'UPHENO:0034522', 'HP:0002857', 'UPHENO:0004475', 'UPHENO:0087435', 'UPHENO:0002758', 'UPHENO:0003015', 'UPHENO:0041226', 'UPHENO:0031228', 'UBERON:0005913', 'UBERON:0002091', 'UBERON:0010712', 'UBERON:0004905', 'UPHENO:0088162', 'UPHENO:0002987', 'UPHENO:0002586', 'UPHENO:0003070', 'UPHENO:0086956', 'UPHENO:0031271', 'UBERON:0013754', 'UBERON:0002428', 'UBERON:0004375', 'UBERON:0010741', 'UBERON:0010742', 'UBERON:0000981', 'HP:0002813', 'UPHENO:0047883', 'UPHENO:0086780', 'UPHENO:0047821', 'UPHENO:0001135', 'UBERON:0004250', 'UBERON:0003466', 'UPHENO:0076697', 'HP:0040064', 'UPHENO:0003865', 'UPHENO:0086172', 'UPHENO:0001303', 'UPHENO:0005214', 'UPHENO:0047949', 'UBERON:0015061', 'UBERON:0000978', 'UBERON:0001460', 'UBERON:0002495', 'UBERON:0002513', 'HP:0002748', 'UBERON:0004381', 'UBERON:0007272', 'UPHENO:0003066', 'UPHENO:0004595', 'UPHENO:0002659', 'CHEBI:26020', 'UBERON:0000982', 'UBERON:0001440', 'UPHENO:0041591', 'UPHENO:0003100', 'UPHENO:0003514', 'UPHENO:0002816', 'UPHENO:0003110', 'UBERON:0010707', 'UPHENO:0075955', 'UPHENO:0080300', 'UPHENO:0002594', 'UBERON:0002471', 'UBERON:0008784', 'UBERON:0003840', 'UPHENO:0041098', 'UBERON:0010703', 'UBERON:0010720', 'UPHENO:0002554', 'UPHENO:7000215', 'UPHENO:0084653', 'UBERON:0004708', 'UPHENO:0003584', 'UPHENO:0002600', 'UPHENO:0003193', 'UPHENO:0087462', 'HP:0011842', 'UPHENO:0031220', 'UBERON:0003822', 'UPHENO:0076767', 'UBERON:0002386', 'CL:0000542', 'UPHENO:0031302', 'UBERON:0001465', 'UBERON:0015002', 'UPHENO:0001072', 'UBERON:0015053', 'UBERON:0003608', 'UBERON:0003464', 'UPHENO:0084654', 'UBERON:0003461', 'UBERON:0010363', 'UBERON:0001474', 'UBERON:0004765', 'UPHENO:0001360', 'UPHENO:0086635', 'UPHENO:0031339', 'UPHENO:0005232', 'UPHENO:0087663', 'UPHENO:0002585', 'UBERON:0003081', 'UPHENO:0002632', 'UPHENO:0031123', 'UPHENO:0047887', 'UPHENO:0004173', 'UPHENO:0002639', 'HP:0011314', 'UPHENO:0003722', 'UPHENO:0003364', 'UPHENO:0003227', 'UBERON:0002529', 'UBERON:0005055', 'CHEBI:36360', 'UBERON:0002027', 'UPHENO:0003864', 'UPHENO:0031323', 'UPHENO:0003049', 'UBERON:0004251', 'UPHENO:0004404', 'UPHENO:0047838', 'UPHENO:0047894', 'UPHENO:0004726', 'UPHENO:0086928', 'UBERON:0000061', 'UBERON:0002075', 'UBERON:0000479', 'CL:0000081', 'UPHENO:0002579', 'UPHENO:0002725', 'UBERON:0000924', 'UPHENO:0004885', 'CL:0000226', 'HP:0000001', 'UPHENO:0003415', 'UPHENO:0003094', 'UPHENO:0002643', 'UPHENO:0051739', 'HP:0030078', 'UBERON:0034921', 'UPHENO:0002648', 'CHEBI:24867', 'UBERON:0003103', 'UPHENO:0051960', 'UPHENO:0002577', 'UBERON:0000465', 'UPHENO:0002983', 'UPHENO:0004680', 'UBERON:0000072', 'UBERON:0003258', 'MPATH:1000', 'CHEBI:25367', 'UPHENO:0004443', 'UPHENO:0049835', 'UBERON:0005178', 'HP:0100606', 'UPHENO:0002567', 'UPHENO:0002668', 'UBERON:0001005', 'UPHENO:0002308', 'UPHENO:0003163', 'UBERON:0007503', 'UPHENO:0003198', 'UPHENO:0004506', 'UBERON:0002530', 'HP:0001941', 'UBERON:0000483', 'UBERON:0002050', 'UBERON:0004119', 'UBERON:0010740', 'UBERON:0000171', 'HP:0030878', 'HP:0002664', 'UPHENO:0002246', 'UPHENO:0002750', 'UPHENO:0041573', 'HP:0002086', 'UPHENO:0002531', 'UPHENO:0004900', 'UPHENO:7000623', 'UBERON:0003918', 'UPHENO:0002471', 'CL:0000738', 'UPHENO:0002994', 'UPHENO:0005141', 'UPHENO:0005110', 'UBERON:0034923', 'UPHENO:0003366', 'HP:0003076', 'UPHENO:0081544', 'UPHENO:0003799', 'UPHENO:0002634', 'UPHENO:0049587', 'UBERON:0001041', 'UPHENO:0002568', 'UPHENO:0087359', 'UPHENO:0081581', 'HP:0003110', 'UBERON:0004921', 'UBERON:0002405', 'UBERON:0015203', 'HP:0025745', 'HP:0011844', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0005277', 'UPHENO:0002525', 'UPHENO:0075952', 'UPHENO:0002541', 'UPHENO:0003432', 'UPHENO:7000428', 'UPHENO:0002765', 'UPHENO:0002822', 'UBERON:0011584', 'UPHENO:0002261', 'UPHENO:0075945', 'UPHENO:0076803', 'UPHENO:0002269', 'UBERON:0000064', 'UPHENO:0004360', 'CHEBI:24833', 'UPHENO:0003378', 'CL:0000764', 'UPHENO:0002388', 'UPHENO:0004891', 'UPHENO:0003025', 'UPHENO:0002859', 'UBERON:0000065', 'UPHENO:0054970', 'UBERON:0003104', 'UBERON:0001555', 'UPHENO:0003050', 'UBERON:0001558', 'UPHENO:0087344', 'UPHENO:0003411', 'UPHENO:0002385', 'UBERON:0000916', 'HP:0002979', 'UBERON:0002417', 'UPHENO:7000318', 'UBERON:0001008', 'UPHENO:0002969', 'UBERON:0000063', 'UPHENO:0003413', 'HP:0002815', 'UPHENO:0002427', 'UBERON:0034944', 'HP:0012622', 'UPHENO:0002426', 'UPHENO:0003093', 'HP:0011793', 'UBERON:0000949', 'UPHENO:0002976', 'UPHENO:0002751', 'UPHENO:0076727', 'UPHENO:0075902', 'UPHENO:0002944', 'UPHENO:0002909', 'UBERON:0000475', 'UPHENO:0031142', 'GO:1901570', 'UPHENO:0002377', 'UPHENO:0004094', 'UBERON:0005181', 'UPHENO:0002832', 'UBERON:0015204', 'UPHENO:0004505', 'UBERON:0000014', 'UPHENO:0002679', 'HP:0000079', 'UPHENO:0002870', 'UPHENO:0002559', 'UPHENO:0003086', 'UPHENO:0002574', 'BFO:0000001', 'UPHENO:0049904', 'UPHENO:0055014', 'UBERON:0000170', 'GO:0046951', 'CHEBI:50860', 'UBERON:0005291', 'GO:0009987', 'HP:0012211', 'UPHENO:0085165', 'HP:0034669', 'HP:0003774', 'HP:0010935', 'UPHENO:0054967', 'UBERON:0000468', 'UBERON:0009569', 'UPHENO:0041610', 'HP:0012575', 'HP:0001939', 'HP:0002981', 'UPHENO:3000003', 'PR:000018263', 'UPHENO:0055153', 'UBERON:0015833', 'HP:0000118', 'UBERON:0000922', 'CHEBI:33674', 'HP:0002814', 'UBERON:0003102', 'GO:0009058', 'UBERON:0001007', 'UBERON:0034925', 'UPHENO:0051686', 'UPHENO:0003381', 'UPHENO:0002564', 'HP:0001942', 'UPHENO:0084763', 'UPHENO:0086908', 'HP:0002088', 'UBERON:0008962', 'UBERON:0013701', 'UPHENO:0066739', 'CHEBI:33675', 'UPHENO:0001001', 'UPHENO:0002442', 'UPHENO:0002542', 'UBERON:0004111', 'CL:0000329', 'UPHENO:0076740', 'UPHENO:0082875', 'HP:0000924', 'UBERON:0002048', 'CHEBI:33709', 'UPHENO:0002360', 'UPHENO:0055077', 'UPHENO:0054954', 'UBERON:0012476', 'UBERON:0002204', 'UPHENO:0054961', 'UPHENO:0050240', 'UPHENO:0049873', 'UPHENO:0050791', 'UPHENO:0002386', 'BFO:0000015', 'UPHENO:0088123', 'HP:0100526', 'UBERON:0005423', 'UPHENO:0055032', 'UBERON:0002193', 'UBERON:0001132', 'UPHENO:7000341', 'UPHENO:0002593', 'UPHENO:0080662', 'UBERON:0001048', 'UPHENO:7000630', 'UPHENO:0087662', 'UPHENO:0002963', 'UBERON:0010538', 'UBERON:0000489', 'HP:0002206', 'UPHENO:0002267', 'UPHENO:0068169', 'UBERON:0004347', 'UPHENO:0002719', 'UBERON:0011216', 'UPHENO:0002948', 'UBERON:8600017', 'UBERON:0002390', 'UPHENO:0002830', 'UPHENO:0049628', 'UPHENO:0002833', 'HP:0040068', 'UBERON:0006601', 'MPATH:596', 'GO:0044281', 'UPHENO:0002967', 'UPHENO:0055132', 'GO:0048878', 'UPHENO:0090176', 'UPHENO:0002443', 'CHEBI:37622', 'HP:0030358', 'UBERON:0003460', 'UBERON:0000490', 'UBERON:0000925', 'HP:0012252', 'HP:0001626', 'HP:0004348', 'UBERON:0000463', 'UPHENO:0002746', 'UBERON:0005173', 'HP:0100529', 'UBERON:0013522', 'UPHENO:0055067', 'GO:0042592', 'UPHENO:0001003', 'GO:0044238', 'UPHENO:0050220', 'UPHENO:0005257', 'UBERON:0000915', 'UBERON:0005418', 'UBERON:0002368', 'GO:0033500', 'UPHENO:0068491', 'UBERON:0000153', 'HP:0001367', 'UPHENO:0055071', 'CL:0000236', 'GO:0044283', 'UPHENO:0087495', 'UPHENO:0031166', 'UPHENO:7000212', 'UPHENO:0002880', 'GO:0008152', 'HP:0012337', 'CHEBI:23367', 'HP:0004918', 'UPHENO:0055082', 'UPHENO:0049723', 'UPHENO:0031318', 'UBERON:0000376', 'HP:0003355', 'HP:0033354', 'CHEBI:78616', 'UPHENO:0050433', 'UBERON:0001062', 'UBERON:0005172', 'UPHENO:0080377', 'GO:0006629', 'UBERON:0001441', 'CHEBI:16670', 'UBERON:0005177', 'UBERON:0011249', 'UPHENO:0050416', 'UBERON:0004120', 'UPHENO:0003430', 'UBERON:0004535', 'UBERON:0005893', 'UBERON:0001004', 'UPHENO:0003334', 'UPHENO:0002530', 'UPHENO:0001002', 'UPHENO:0002734', 'UPHENO:0002803', 'CHEBI:51143', 'UBERON:0002100', 'UBERON:0010000', 'UPHENO:0087660', 'CL:0000945', 'UPHENO:0002536', 'UBERON:0006715', 'UPHENO:0002448', 'UBERON:8450002', 'UBERON:0000026', 'CL:0000763', 'UBERON:0002472', 'GO:0008610', 'UPHENO:0001147', 'UPHENO:0003116', 'GO:1902224', 'HP:0011277', 'UPHENO:0087123', 'UPHENO:0004791', 'UPHENO:7000306', 'UPHENO:7000327', 'UPHENO:0087665', 'UPHENO:0089294', 'UPHENO:0002352', 'UBERON:0003657', 'UBERON:0004122', 'CHEBI:37577', 'UPHENO:0002964', 'UPHENO:0002526', 'UPHENO:0085691', 'HP:0000077', 'UPHENO:0003084', 'UBERON:0009911', 'CHEBI:18133', 'UPHENO:0002422', 'BFO:0000003', 'UPHENO:0003021', 'UPHENO:0002731', 'UPHENO:0047948', 'HP:0004912', 'GO:1901568', 'HP:0004360', 'UBERON:0000025', 'UBERON:0011143', 'UBERON:0008202', 'UPHENO:0041536', 'UPHENO:0002785', 'UPHENO:0002411', 'UPHENO:0004481', 'UPHENO:0003088', 'UBERON:0015212', 'UBERON:0005409', 'UBERON:0000976', 'UPHENO:0002754', 'UBERON:0000062', 'UPHENO:0046383', 'UPHENO:0054955', 'UPHENO:0068110', 'HP:0000093', 'MPATH:14', 'UPHENO:0004892', 'UPHENO:0002926', 'UPHENO:0048707', 'UPHENO:0087849', 'UBERON:0000174', 'UBERON:0004923', 'UPHENO:0051673', 'UPHENO:0084767', 'UPHENO:0087433', 'UPHENO:0051763', 'PR:000000001', 'HP:0032180', 'UBERON:0008785', 'CHEBI:33839', 'CHEBI:24431', 'UBERON:0000101', 'UPHENO:0003812', 'UPHENO:0002532', 'CHEBI:16541', 'CHEBI:25806', 'CHEBI:36962', 'CHEBI:33582', 'CHEBI:15841', 'CHEBI:33302', 'UPHENO:0002861', 'CHEBI:33304', 'UPHENO:0046284', 'UPHENO:0041258', 'CHEBI:36357', 'UBERON:0010316', 'CHEBI:35352', 'CHEBI:32988', 'UPHENO:0047917', 'UBERON:0005420', 'CHEBI:50047', 'BFO:0000004', 'CHEBI:36963', 'GO:0042593', 'CHEBI:33256', 'UPHENO:7000305', 'CHEBI:24651', 'UBERON:0006555', 'HP:0005576', 'UPHENO:0002943', 'UBERON:0004819', 'UPHENO:0004969', 'UBERON:0008946', 'UPHENO:0005201', 'UPHENO:0005285', 'UPHENO:0055006', 'UBERON:0003914', 'UPHENO:0002642', 'UBERON:0001003', 'HP:0030760', 'UPHENO:0001392', 'UBERON:0000179', 'UBERON:0000154', 'UPHENO:0003550', 'UPHENO:0002949', 'UBERON:0007684', 'UBERON:0015022', 'UPHENO:0087427', 'UBERON:0009773', 'UBERON:0002113', 'UPHENO:0076294', 'UBERON:0003826', 'UBERON:0005157', 'UBERON:0000923', 'UBERON:0006314', 'UPHENO:0049618', 'UPHENO:0076756', 'UBERON:0006598', 'HP:0012210', 'UBERON:0003607', 'UBERON:0001231', 'UBERON:0003606', 'UPHENO:0031276', 'UBERON:0001285', 'UPHENO:0003941', 'UBERON:0000055', 'UPHENO:0087993', 'UPHENO:0004482', 'UPHENO:0076779', 'UPHENO:0051635', 'UPHENO:0046348', 'UPHENO:0076714', 'UPHENO:0068565', 'UPHENO:7000219', 'UBERON:0007688', 'MPATH:31', 'UPHENO:3000004', 'UBERON:0006524', 'UPHENO:0050116', 'UBERON:0000353', 'CL:0000842', 'UBERON:0002199', 'UBERON:0010368', 'UPHENO:0087480', 'UBERON:0005153', 'HP:0002097', 'UBERON:0008874', 'UPHENO:0002270', 'UPHENO:0086546', 'UBERON:0010369', 'CHEBI:64709', 'UPHENO:0003776', 'UBERON:0004288', 'HP:0000091', 'UPHENO:0086549', 'UBERON:0010758', 'UBERON:0008947', 'UPHENO:0088582', 'UBERON:0005597', 'UBERON:0013702', 'UPHENO:0002636', 'UPHENO:0004723', 'MPATH:597', 'UPHENO:0003005', 'UPHENO:0002571', 'RO:0002577', 'UBERON:0015052', 'UBERON:0009912', 'UPHENO:7000208', 'GO:0006091', 'UPHENO:0003065', 'UPHENO:0003834', 'UBERON:0006058', 'MPATH:0', 'CHEBI:33285', 'HP:0011025', 'MPATH:25', 'CHEBI:36587', 'CHEBI:72695', 'UBERON:0003823', 'CHEBI:33608', 'GO:0008150', 'UPHENO:0068144', 'CHEBI:35605', 'UBERON:0006714', 'UPHENO:0002650', 'UBERON:0002103', 'HP:0033127', 'CHEBI:36586', 'UPHENO:0046286', 'UPHENO:0087661', 'UPHENO:0002434', 'HP:0020129', 'UPHENO:7000207', 'UPHENO:0004470', 'UBERON:0003929', 'UPHENO:0004507', 'UBERON:0007798', 'HP:0003111', 'UPHENO:0002747', 'UBERON:0001981', 'UBERON:0001009', 'UPHENO:0087852', 'UBERON:0000926', 'UPHENO:0002635', 'UPHENO:0002406', 'UPHENO:0004888', 'UPHENO:0088166', 'UBERON:0001015', 'UPHENO:0004064', 'UPHENO:0047979', 'UBERON:0000118', 'UBERON:0000307', 'UPHENO:0004909', 'UPHENO:0005030', 'UBERON:0000477', 'UPHENO:0005029', 'UBERON:0004769', 'UPHENO:0002553', 'UBERON:0002049', 'UPHENO:9002003', 'UBERON:0010314', 'UBERON:0000076', 'UPHENO:0085566', 'UPHENO:7000227', 'UBERON:0004537', 'UPHENO:0087928', 'UPHENO:0088170', 'UPHENO:0076692', 'UPHENO:0050121', 'UPHENO:0076739', 'UBERON:0004357', 'CHEBI:33579', 'HP:0000822', 'UBERON:0000178', 'UBERON:0002416', 'UBERON:0002097', 'UPHENO:0003811', 'HP:6000531', 'BFO:0000040', 'UPHENO:0068054', 'CHEBI:16646', 'HP:0000083', 'CHEBI:35381', 'CHEBI:15693', 'CHEBI:33917', 'HP:0001995', 'CHEBI:17234', 'UPHENO:0080658', 'UPHENO:0076703', 'HP:0006530', 'CHEBI:24870', 'UPHENO:0002783', 'UPHENO:0047833', 'HP:0006487', 'UBERON:0010912', 'HP:0032581', 'UBERON:0000075', 'HP:0030972', 'UPHENO:7000317', 'UBERON:0004211', 'UBERON:0011582', 'UPHENO:0002968', 'CHEBI:33575', 'HP:0000940', 'UBERON:0002102', 'UBERON:0005417', 'UPHENO:0002529', 'UPHENO:0004456', 'UPHENO:0001134', 'UPHENO:0001340', 'UPHENO:0003207', 'UBERON:0015021', 'HP:0032263', 'UPHENO:0004536', 'UBERON:0001088', 'UPHENO:0003159', 'UPHENO:0002896', 'UPHENO:0002885', 'UPHENO:0082835', 'UBERON:0004709', 'HP:0000119', 'UBERON:0002101', 'HP:0002795', 'UBERON:0010709', 'UPHENO:0004504', 'UBERON:0010708', 'UPHENO:0004503', 'BFO:0000002', 'UBERON:0005419', 'UBERON:0004710', 'UPHENO:0004172', 'UBERON:0012475', 'HP:0001969', 'UPHENO:0003095', 'UPHENO:0004467', 'UPHENO:0031122', 'UPHENO:0002738', 'UPHENO:0002988', 'UPHENO:0076299', 'UBERON:0004770', 'UPHENO:0088082', 'UBERON:3000961', 'CHEBI:33238', 'UBERON:0005911', 'UBERON:0007376', 'UPHENO:0003516', 'UPHENO:0002945', 'UPHENO:0002637', 'UPHENO:0004537', 'UBERON:0007273', 'UBERON:0011676', 'UPHENO:0004466', 'UBERON:0001434', 'UBERON:0000060'], 'has_phenotype_closure_label': ['Abnormality on pulmonary function testing', 'Decreased DLCO', 'Abnormal DLCO', 'erythroid lineage cell', 'mononuclear leukocyte', 'hemoglobin', 'immune system morphology phenotype', 'cell physiology phenotype', 'leukocyte morphology phenotype', 'B cell', 'oxygen accumulating cell', 'skeletal system physiology phenotype', 'bone element mass density phenotype', 'Abnormality of bone mineral density', 'immune system', 'anatomical entity mass density phenotype', 'decreased circulating antibody concentration; decreased immunoglobulin level', 'bone structure', 'blood cell', 'single nucleate cell', 'myeloid cell', 'blood cell phenotype', 'eukaryotic cell', 'bone ossification', 'Abnormal bone ossification', 'Hypophosphatemic rickets', 'ossification', 'rickets', 'cell phenotype', 'multicellular organismal process', 'lymphocyte physiology phenotype', 'blood island phenotype', 'phosphate', 't cell morphology', 'phosphorus oxoacids and derivatives', 'haemolymphatic fluid phenotype', 'phosphorus oxoacid derivative', 'phosphorus molecular entity', 'Abnormal blood ion concentration', 'decreased level of chemical entity in tissue', 'Abnormal circulating metabolite concentration', 'oxoacid derivative', 'decreased level of chemical entity in blood', 'blood chemical entity level phenotype', 'ion', 'elemental molecular entity', 'blood phenotype', 'Hypophosphatemia', 'appendicular skeleton', 'subdivision of organism along appendicular axis, curved phenotype', 'hindlimb bud morphology phenotype', 'Abnormal skeletal morphology', 'hindlimb bud phenotype', 'multi organ part structure', 'skin epidermis phenotype', 'anatomical wall phenotype', 'forelimb stylopod phenotype', 'leukocyte', 'femur phenotype', 'appendicular skeleton phenotype', 'anatomical entity thickness phenotype', 'hindlimb endochondral element', 'forelimb endochondral element', 'limb bone', 'bone of free limb or fin', 'bone of pectoral complex', 'femur', 'curved anatomical entity', 'bone of hip region phenotype', 'Abnormal appendicular skeleton morphology', 'increased size of the material anatomical entity', 'upper arm bone', 'knee phenotype', 'radio-ulna', 'hindlimb bud', 'forelimb', 'paired limb/fin', 'articular system', 'skeleton phenotype', 'limb phenotype', 'arm phenotype', 'decreased level of phosphate in blood', 'lower limb segment, curved phenotype', 'arm bone phenotype', 'shape of long bone phenotype', 'bone of free limb or fin phenotype', 'pelvic appendage skeleton phenotype', 'forelimb stylopod', 'hindlimb zeugopod', 'hindlimb stylopod', 'humerus endochondral element', 'femur endochondral element', 'hindlimb long bone', 'knee', 'forelimb long bone', 'forelimb bone', 'hindlimb bone', 'skeleton of pectoral complex', 'skeleton of pelvic complex', 'lymphocyte', 'tissue chemical entity level phenotype', 'pectoral appendage bud', 'limb', 'skeletal joint phenotype', 'forelimb skeleton phenotype', 'skeletal system morphology phenotype', 'anatomical structure, curved phenotype', 'Abnormality of the skeletal system', 'tibiofibula phenotype', 'forelimb bud phenotype', 'skeleton of limb phenotype', 'leg', 'arm', 'anatomical wall', 'bone of pelvic complex', 'subdivision of skeleton', 'long bone phenotype', 'subdivision of skeleton phenotype', 'hindlimb phenotype', 'musculature phenotype', 'increased thickness of the anatomical entity', 'anterior region of body', 'radio-ulna phenotype', 'limb bud morphology phenotype', 'organism subdivision, curved phenotype', 'increased thickness of the material anatomical entity', 'hindlimb', 'organ component layer', 'increased size of the organ component layer', 'pelvic appendage bud phenotype', 'pectoral appendage', 'Abnormality of the lower limb', 'limb bud', 'forelimb endochondral element phenotype', 'increased thickness of the organ part', 'increased thickness of the stratum corneum of epidermis', 'increased thickness of the organ', 'pectoral appendage skeleton phenotype', 'hematopoietic cell', 'hindlimb endochondral element phenotype', 'blood island', 'Abnormal long bone morphology', 'long bone', 'pelvic appendage phenotype', 'upper limb segment', 'Abnormality of the musculoskeletal system', 'lower limb segment', 'diaphysis', 'forelimb zeugopod skeleton', 'hindlimb zeugopod skeleton', 'endochondral element', 'multi-limb segment region', 'musculature of body', 'erythroid lineage cell morphology phenotype', 'stratum corneum of epidermis morphology phenotype', 'bone of pelvic complex phenotype', 'skeletal element', 'forelimb zeugopod bone', 'bone element', 'subdivision of organism along appendicular axis', 'organ component layer phenotype', 'forelimb bud', 'skeletal joint morphology phenotype', 'Abnormality of limb bone', 'leg phenotype', 'femur endochondral element phenotype', 'paired limb/fin segment phenotype', 'hindlimb joint phenotype', 'lipid metabolic process', 'Decreased bone element mass density', 'phenotypic effect', 'increased level of glucose in urine', 'Abnormal bone structure', 'foregut epithelium phenotype', 'Neoplasm of the respiratory system', 'subdivision of tube', 'respiration organ phenotype', 'homeostatic process phenotype', 'entity', 'Abnormality of the kidney', 'pair of lungs', 'skin of body', 'forelimb zeugopod', 'anatomical entity morphology in the respiratory system phenotype', 'unilaminar epithelium phenotype', 'zeugopod phenotype', 'limb joint', 'bodily fluid phenotype', 'endochondral bone', 'respiratory system', 'increased ketone body metabolic process', 'pelvic complex', 'kidney epithelium', 'pulmonary lobule', 'kidney phenotype', 'organ physiology phenotype', 'size of anatomical entity phenotype', 'organ part', 'anatomical collection', 'endoderm of foregut phenotype', 'limb segment, curved phenotype', 'disconnected anatomical group', 'hindlimb joint', 'anatomical collection phenotype', 'trunk phenotype', 'glandular system', 'germ layer phenotype', 'pathological entity', 'digestive system morphology phenotype', 'Non-small cell lung carcinoma', 'carbohydrate homeostasis phenotype', 'bone element phenotype', 'anatomical system', 'endocrine gland phenotype', 'increased level of chemical entity', 'musculature', 'subdivision of tube phenotype', 'thoracic segment organ', 'trunk region element phenotype', 'mesoderm-derived structure phenotype', 'bone of appendage girdle complex', 'lung', 'carbon group molecular entity', 'foregut phenotype', 'embryo morphology phenotype', 'molecule', 'anatomical entity morphology in the pelvic complex phenotype', 'Neoplasm by anatomical site', 'Abnormal limb bone morphology', 'humerus', 'pelvic appendage', 'embryonic tissue phenotype', 'fatty acid derivative metabolic process', 'respiratory system physiology phenotype', 'Abnormal lung morphology', 'humerus endochondral element phenotype', 'decreased activity of parathyroid; hypoparathyroidism', 'All', 'increased size of the organ', 'respiratory airway', 'increased fatty acid derivative biosynthetic process', 'increased thickness of the skin of body', 'tube', 'leg bone phenotype', 'germ layer / neural crest', 'endoderm-derived structure phenotype', 'endocrine system phenotype', 'ketoacidosis', 'hemolymphoid system', 'endocrine system', 'blood vasculature', 'developing anatomical structure', 'Abnormality of the respiratory system', 'subdivision of digestive tract', 'developing anatomical structure phenotype', 'lower respiratory tract', 'respiratory system phenotype', 'nephron epithelium', 'embryo phenotype', 'Abnormality of the urinary system physiology', 'independent continuant', 'lung morphology phenotype', 'continuant', 'endocrine gland', 'lateral structure phenotype', 'tissue phenotype', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'emphysema', 'upper urinary tract', 'non-connected functional system', 'leukocyte physiology phenotype', 'endoderm of foregut', 'limb bone morphology phenotype', 'subdivision of organism along appendicular axis phenotype', 'organ phenotype', 'epithelium', 'viscus phenotype', 'renal system', 'abdomen element physiology phenotype', 'paired limb/fin bud phenotype', 'abdomen element', 'lateral structure', 'multicellular anatomical structure phenotype', 'body proper', 'integumentary system layer', 'epithelial bud', 'excretory system', 'biosynthetic process', 'paired limb/fin skeleton', 'Abnormal homeostasis', 'lung phenotype', 'zone of bone organ', 'carbohydrate', 'appendicular skeleton morphology phenotype', 'radius-ulna endochondral element', 'biological_process phenotype', 'renal/urinary system phenotype', 'pnictogen molecular entity', 'epithelial vesicle', 'material anatomical entity phenotype', 'hindlimb zeugopod bone', 'nephron', 'proximo-distal subdivision of respiratory tract', 'subdivision of digestive tract phenotype', 'compound organ phenotype', 'increased fatty acid derivative metabolic process', 'subdivision of trunk phenotype', 'tissue', 'parathyroid gland', 'pulmonary acinus morphology phenotype', 'abdominal segment of trunk', 'fatty acid derivative biosynthetic process', 'Pulmonary fibrosis', 'material entity', 'Renal insufficiency', 'lymphocyte of B lineage', 'multicellular organism', 'organism substance', 'limb long bone', 'long bone morphology phenotype', 'increased metabolic process', 'embryonic tissue', 'renal tubule', 'primary metabolic process', 'gland physiology phenotype', 'lipid metabolic process phenotype', 'zeugopod', 'foregut', 'homeostatic process', 'organism subdivision phenotype', 'kidney mesenchyme', 'erythrocyte', 'tube phenotype', 'heteroorganic entity', 'epithelium phenotype', 's-block molecular entity', 'external integument structure phenotype', 'generation of precursor metabolites and energy phenotype', 'Abnormality of acid-base homeostasis', 'Chronic kidney disease', 'respiratory primordium', 'curved hindlimb zeugopod', 'digestive system physiology phenotype', 'endoderm', 'p-block molecular entity', 'vascular system', 'paired limb/fin segment, curved phenotype', 'digestive system phenotype', 'multicellular organism morphology phenotype', 'Abnormal respiratory system morphology', 'compound organ', 'molecular entity', 'structure with developmental contribution from neural crest phenotype', 'mesoderm morphology phenotype', 'pathological process', 'hematopoietic system phenotype', 'generation of precursor metabolites and energy', 'parathyroid gland phenotype', 'shape of continuant phenotype', 'endoderm morphology phenotype', 'increased lipid metabolic process', 'compound organ physiology phenotype', 'petechiae', 'hematemesis', 'lipid biosynthetic process phenotype', 'endochondral bone phenotype', 'increased biological_process', 'skeletal system phenotype', 'blastula', 'gland phenotype', 'Hyperchloremic metabolic acidosis', 'taxon specific phenotype', 'hindlimb morphology phenotype', 'cellular process phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'biological_process rate phenotype', 'motile cell', 'gland', 'increased lipid biosynthetic process', 'Abnormal diaphysis morphology', 'Abnormality of the genitourinary system', 'hypertension', 'anatomical structure phenotype', 'renal system physiology phenotype', 'Hyperchloremic acidosis', 'zone of organ', 'Abnormality of metabolism/homeostasis', 'arm bone', 'protein polypeptide chain', 'epithelial fold phenotype', 'proximo-distal subdivision of respiratory tract phenotype', 'respiratory system morphology', 'limb endochondral element', 'oxoacid', 'organic acid', 'multicellular anatomical structure physiology phenotype', 'abdominal segment element physiology phenotype', 'parenchyma', 'bronchopulmonary segment', 'material anatomical entity physiology phenotype', 'secondary pulmonary lobule', 'appendicular skeletal system', 'increased generation of precursor metabolites and energy', 'skeletal element phenotype', 'stylopod', 'cavitated compound organ physiology phenotype', 'presumptive structure phenotype', 'ketone body metabolic process', 'foregut morphology phenotype', 'organ system subdivision', 'musculoskeletal system phenotype', 'increased biosynthetic process', 'nephron epithelium phenotype', 'tissue specific degenerative process', 'anatomical conduit', 'role urine level phenotype', 'cardiovascular system phenotype', 'anatomical system physiology phenotype', 'endo-epithelium phenotype', 'vomiting', 'increased qualitatively biological_process', 'anatomical structure physiology phenotype', 'insulin resistance', 'metabolic process phenotype', 'phenotype', 'pectoral complex', 'small molecule metabolic process phenotype', 'parathyroid gland physiology phenotype', 'vessel', 'digestive tract epithelium phenotype', 'multi organ part structure phenotype', 'presumptive ectoderm phenotype', 'increased primary metabolic process', 'material anatomical entity', 'biosynthetic process phenotype', 'respiratory tract', 'zone of skin morphology phenotype', 'nephron tubule morphology phenotype', 'bodily fluid', 'glucose homeostasis', 'digestive system', 'thoracic segment organ phenotype', 'small molecule biosynthetic process', 'shoulder bone phenotype', 'thoracic cavity element phenotype', 'monoatomic ion', 'integumentary system layer phenotype', 'thoracic cavity element', 'anatomical entity phenotype', 'main body axis', 'upper urinary tract phenotype', 'limb morphology phenotype', 'occurrent', 'organ part phenotype', 'circulatory system phenotype', 'increased level of monosaccharide in urine', 'increased small molecule metabolic process', 'Abnormal respiratory system physiology', 'knee morphology phenotype', 'trunk', 'anlage phenotype', 'Hypertension', 'erythrocyte morphology phenotype', 'haemolymphatic fluid', 'multicellular anatomical structure', 'process', 'Abnormal renal physiology', 'external ectoderm', 'Stage 5 chronic kidney disease', 'surface structure phenotype', 'Phenotypic abnormality', 'pathological phenotype observation', 'hematopoietic system', 'homeostasis', 'anatomical conduit phenotype', 'Abnormality of the urinary system', 'organism substance phenotype', 'Abnormality of limbs', 'small molecule metabolic process', 'embryo', 'lung primordium phenotype', 'increased thickness of the organ component layer', 'primordium phenotype', 'metabolic process', 'metabolic acidosis', 'increased ketone body biosynthetic process', 'blood monoatomic ion level phenotype', 'primordium', 'viscus', 'foregut epithelium', 'Metabolic acidosis', 'lobe of lung', 'lateral structure physiology phenotype', 'phosphate level phenotype', 'genitourinary system phenotype', 'presumptive structure', 'increased small molecule biosynthetic process', 'abdominal segment element phenotype', 'posterior region of body', 'radius-ulna endochondral element phenotype', 'trunk region element', 'epithelial vesicle phenotype', 'anatomical structure', 'cavitated compound organ phenotype', 'ketone body biosynthetic process', 'Acidosis', 'chemical homeostasis', 'Abnormal tubulointerstitial morphology', 'anatomical entity morphology phenotype', 'skeleton', 'respiratory system morphology phenotype', 'digestive tract epithelium', 'increased cellular process', 'kidney', 'zeugopodial skeleton', 'germ layer / neural crest phenotype', 'ectoderm phenotype', 'subdivision of trunk', 'endocrine gland physiology phenotype', 'alveolar system morphology phenotype', 'respiration organ', 'blood phosphate level phenotype', 'trunk region element physiology phenotype', 'organ', 'kidney physiology phenotype', 'abdominal segment element', 'cavitated compound organ', 'anatomical entity physiology phenotype', 'Abnormality of the knee', 'subdivision of organism along main body axis phenotype', 'cellular process', 'urine chemical entity level phenotype', 'organ, curved phenotype', 'acidosis', 'Abnormality of the upper urinary tract', 'protein', 'bone element, curved phenotype', 'Abnormal renal morphology', 'abdomen', 'macromolecule', 'polyatomic entity', 'main group molecular entity', 'Proteinuria', 'thoracic segment of trunk', 'Abnormality of urine homeostasis', 'hindlimb skeleton phenotype', 'urine', 'polypeptide', 'increased size of the multicellular anatomical structure', 'chalcogen molecular entity', 'urine amino acid level phenotype', 'organochalcogen compound', 'paired limb/fin skeleton phenotype', 'embryonic tissue morphology phenotype', 'Abnormal urine metabolite level', 'multicellular organism chemical entity level phenotype', 'increased level of carboxylic acid in urine', 'organism subdivision', 'chemical entity', 'lung primordium', 'peptide', 'increased thickness of the structure with developmental contribution from neural crest', 'amino acid chain', 'excretory tube', 'organic molecular entity', 'nitrogen molecular entity level phenotype', 'external ectoderm morphology phenotype', 'Abnormal blood phosphate concentration', 'forelimb long bone phenotype', 'renal system morphology phenotype', 'increased level of chemical entity in urine', 'increased urine role level', 'nucleate cell', 'urine protein level phenotype', 'curvature anatomical entity', 'hindlimb bone phenotype', 'increased level of protein polypeptide chain in urine', 'excreta', 'lung bud morphology phenotype', 'circulatory system', 'Abnormal urine amino acid level', 'organonitrogen compound', 'outer epithelium phenotype', 'lateral plate mesoderm', 'organooxygen compound', 'carboxamide', 'organic amino compound', 'Decreased anatomical entity mass density', 'stratum corneum of epidermis', 'glucose homeostasis phenotype', 'Abnormal urine protein level', 'alveolar system', 'chemical entity level phenotype', 'biological_process', 'multi-limb segment region phenotype', 'Abnormal renal insterstitial morphology', 'subdivision of skeletal system', 'endoderm phenotype', 'alimentary part of gastrointestinal system', 'Tubulointerstitial fibrosis', 'uriniferous tubule', 'kidney fibrosis', 'tibiofibula', 'anlage', 'mesenchyme morphology phenotype', 'Renal fibrosis', 'Genu valgum', 'kidney epithelium morphology phenotype', 'lymphocyte morphology phenotype', 'anatomical entity fibrosis', 'upper leg bone', 'primary amide', 'Abnormal renal tubule morphology', 'lipid biosynthetic process', 'excretory tube phenotype', 'dense mesenchyme tissue phenotype', 'amino acid', 'nephron phenotype', 'digestive tract', 'mesenchyme', 'epithelial tube', 'phosphoric acid derivative', 'kidney mesenchyme morphology phenotype', 'oxygen molecular entity', 'anatomical lobe', 'skin epidermis', 'Abnormal nephron morphology', 'pectoral appendage skeleton', 'nephron tubule phenotype', 'kidney mesenchyme phenotype', 'mesenchyme phenotype', 'renal tubule phenotype', 'surface structure', 'nephron tubule', 'immune system phenotype', 'kidney morphology phenotype', 'epithelial tube phenotype', 'Emphysema', 'increased thickness of the multicellular anatomical structure', 'increased size of the structure with developmental contribution from neural crest', 'Rickets', 'pulmonary acinus', 'Reduced bone mineral density', 'limb bone phenotype', 'system', 'appendage phenotype', 'limb bud phenotype', 'lobe of lung morphology phenotype', 'alimentary part of gastrointestinal system phenotype', 'organ subunit', 'alimentary part of gastrointestinal system physiology phenotype', 'germ layer', 'parenchyma phenotype', 'mesoderm', 'material anatomical entity, curved phenotype', 'lung bud', 'upper limb segment phenotype', 'Lung adenocarcinoma', 'cell and tissue damage process', 'lobule', 'amino acid level phenotype', 'pelvic appendage bud', 'heteroatomic molecular entity', 'hydroxides', 'hydrogen molecular entity', 'Abnormal knee morphology', 'carbohydrate homeostasis', 'Aminoaciduria', 'embryonic structure phenotype', 'blood', 'organic oxo compound', 'genitourinary system', 'limb long bone phenotype', 'increased level of amino acid in urine', 'carbonyl compound', 'epithelial fold', 'external integument structure', 'neoplasm phenotype', 'carboxylic acid', 'monoatomic entity', 'skin of body phenotype', 'integument phenotype', 'integumental system phenotype', 'multicellular organism phenotype', 'zone of organ phenotype', 'skeletal joint', 'carbon oxoacid', 'Abnormal systemic blood pressure', 'endochondral element phenotype', 'abdomen element phenotype', 'limb segment phenotype', 'renal system phenotype', 'ectoderm morphology phenotype', 'limb skeleton subdivision', 'blood vessel', 'Abnormal cardiovascular system physiology', 'decreased level of chemical entity', 'vasculature', 'endoderm-derived structure', 'presumptive ectoderm', 'Abnormality of the cardiovascular system', 'structure with developmental contribution from neural crest', 'increased size of the anatomical structure', 'skin of body morphology phenotype', 'organ subunit phenotype', 'integumental system', 'paired limb/fin segment', 'increased level of organic acid in urine', 'Increased blood pressure', 'zeugopod, curved phenotype', 'nitrogen molecular entity', 'anatomical cluster', 'zone of skin', 'integument', 'organ system subdivision physiology phenotype', 'cardiovascular system', 'B cell physiology phenotype', 'ectoderm', 'shoulder bone', 'Neoplasm', 'cardiovascular system physiology phenotype', 'structure with developmental contribution from neural crest physiology phenotype', 'urine glucose level phenotype', 'Abnormal urinary organic compound level', 'monosaccharide', 'hexose', 'aldose', 'bone of appendage girdle complex phenotype', 'aldohexose', 'humerus phenotype', 'paired limb/fin phenotype', 'glucose', 'carbohydrates and carbohydrate derivatives', 'chemical homeostasis phenotype', 'Glycosuria', 'Abnormal pulmonary interstitial morphology', 'lung fibrosis', 'skeletal system', 'Abnormality of the calf', 'subdivision of skeletal system phenotype', 'appendage girdle complex', 'parakeratosis', 'skin epidermis morphology phenotype', 'limb skeleton subdivision phenotype', 'hindlimb zeugopod morphology phenotype', 'pectoral appendage phenotype', 'process of degenerative change', 'increased thickness of the anatomical structure', 'cell', 'leg bone', 'lower limb segment phenotype', 'upper leg bone phenotype', 'forelimb phenotype', 'shape of hindlimb zeugopod phenotype', 'nephron morphology phenotype', 'articulation', 'multicellular anatomical structure, curved phenotype', 'shape of anatomical entity phenotype', 'hindlimb long bone phenotype', 'forelimb zeugopod bone phenotype', 'upper arm bone phenotype', 'Neoplasm of the lung', 'organ system subdivision phenotype', 'increased size of the anatomical entity', 'organic molecule', 'lateral plate mesoderm morphology phenotype', 'small molecule biosynthetic process phenotype', 'bone of hip region', 'Bowing of the legs', 'musculature of body phenotype', 'primary metabolic process phenotype', 'increased thickness of the integumentary system layer', 'skeletal element, curved phenotype', 'pectoral appendage bud phenotype', 'anatomical entity', 'embryonic structure', 'zone of long bone', 'limb segment', 'lung parenchyma', 'curved long bone', 'kidney epithelium phenotype', 'articulation phenotype', 'forelimb bone phenotype', 'hindlimb zeugopod phenotype', 'increased size of the organ part', 'Abnormality of lower limb joint', 'pelvic appendage skeleton', 'dense mesenchyme tissue', 'diaphysis morphology', 'skeleton of limb', 'hindlimb zeugopod bone phenotype', 'unilaminar epithelium', 'amide', 'Abnormal joint morphology', 'musculoskeletal system', 'Bowing of the long bones', 'mesoderm phenotype', 'outer epithelium', 'paired limb/fin bud', 'appendage', 'anatomical system phenotype', 'hindlimb skeleton', 'mesoderm-derived structure', 'forelimb skeleton', 'bone of pectoral complex phenotype', 'endo-epithelium', 'lateral plate mesoderm phenotype', 'limb endochondral element phenotype', 'forelimb zeugopod phenotype'], 'has_descendant': ['MONDO:0030056'], 'has_descendant_label': ['Fanconi renotubular syndrome 5'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'HP:0001994', 'category': 'biolink:PhenotypicFeature', 'name': 'Renal Fanconi syndrome', 'description': 'An inability of the tubules in the kidney to reabsorb small molecules, causing increased urinary loss of electrolytes (sodium, potassium, bicarbonate), minerals, glucose, amino acids, and water.', 'xref': ['SNOMEDCT_US:236468006', 'SNOMEDCT_US:44673006', 'UMLS:C0341703'], 'synonym': ['De toni-fanconi-debre syndrome', 'Renal tubular fanconi syndrome'], 'exact_synonym': ['De toni-fanconi-debre syndrome', 'Renal tubular fanconi syndrome'], 'provided_by': 'phenio_nodes', 'namespace': 'HP', 'has_phenotype_count': 0, 'has_descendant': ['HP:0001994'], 'has_descendant_label': ['Renal Fanconi syndrome'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0011325', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group F', 'description': 'Fanconi anemia caused by mutations of the FANCF gene. This gene encodes a polypeptide with homology to the prokaryotic RNA-binding protein ROM.', 'xref': ['DOID:0111088', 'GARD:15355', 'MEDGEN:854016', 'NCIT:C125707', 'OMIM:603467', 'UMLS:C3469526'], 'synonym': ['FANCF', 'Fanconi Anemia, complementation group type F', 'Fanconi anaemia complementation group type F', 'Fanconi anemia complementation group F', 'Fanconi anemia complementation group type F', 'Fanconi anemia, complementation group F'], 'exact_synonym': ['FANCF', 'Fanconi Anemia, complementation group type F', 'Fanconi anaemia complementation group type F', 'Fanconi anemia complementation group F', 'Fanconi anemia complementation group type F'], 'related_synonym': ['Fanconi anemia, complementation group F'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0005528', 'HP:0001873', 'HP:0001882', 'HP:0001561', 'HP:0000076', 'HP:0000028', 'HP:0001511', 'HP:0008551', 'HP:0000089', 'HP:0003221', 'HP:0004322', 'HP:0000957', 'HP:0000568', 'HP:0002984', 'HP:0000960', 'HP:0001233', 'HP:0000405', 'HP:0000953', 'HP:0009778', 'HP:0000252', 'HP:0030260', 'HP:0001195', 'HP:0009777', 'HP:0000750', 'HP:0002090', 'HP:0002247', 'HP:0001508', 'HP:0001903', 'HP:0000824', 'HP:0000125', 'HP:0011419', 'HP:0001631', 'HP:0001328', 'HP:0001643'], 'has_phenotype_label': ['Bone marrow hypocellularity', 'Failure to thrive', 'Sacral dimple', 'Delayed speech and language development', 'Short stature', 'Anemia', 'Pelvic kidney', 'Short thumb', 'Microcephaly', 'Decreased total leukocyte count', 'Cafe-au-lait spot', 'Intrauterine growth retardation', 'Absent thumb', '2-3 finger cutaneous syndactyly', 'Chromosomal breakage induced by crosslinking agents', 'Microtia', 'Polyhydramnios', 'Hyperpigmentation of the skin', 'Cryptorchidism', 'Microphthalmia', 'Placental abruption', 'Vesicoureteral reflux', 'Specific learning disability', 'Conductive hearing impairment', 'Patent ductus arteriosus', 'Decreased response to growth hormone stimulation test', 'Pneumonia', 'Renal hypoplasia', 'Single umbilical artery', 'Thrombocytopenia', 'Microphallus', 'Hypoplasia of the radius', 'Atrial septal defect', 'Duodenal atresia'], 'has_phenotype_count': 34, 'has_phenotype_closure': ['HP:0011419', 'UPHENO:0005170', 'HP:0100767', 'UPHENO:0005022', 'UPHENO:0063563', 'UPHENO:0002792', 'UPHENO:0081594', 'HP:0002589', 'UPHENO:0063629', 'UPHENO:0063615', 'HP:0002247', 'HP:0002246', 'UPHENO:0084771', 'UPHENO:0074330', 'UPHENO:0063562', 'UPHENO:0063565', 'UPHENO:0063586', 'UPHENO:0063558', 'UPHENO:0086621', 'UPHENO:0053572', 'UBERON:0000991', 'HP:0000028', 'UPHENO:0003056', 'UPHENO:0002940', 'UPHENO:0053644', 'UPHENO:0063594', 'UBERON:0000473', 'UPHENO:0087802', 'HP:0100542', 'UPHENO:0087116', 'UPHENO:0053601', 'HP:0025033', 'UPHENO:0002932', 'UPHENO:7000161', 'UBERON:0034929', 'UPHENO:0053643', 'UPHENO:0075998', 'UPHENO:0053588', 'UPHENO:0053561', 'UPHENO:0053632', 'UPHENO:0053563', 'UPHENO:0087427', 'HP:0000089', 'UPHENO:0076779', 'HP:0012210', 'HP:0000077', 'HP:0008678', 'NBO:0001845', 'CL:0000232', 'HP:0001877', 'HP:0002242', 'UPHENO:0049664', 'UPHENO:0079835', 'UPHENO:7000311', 'UPHENO:0087339', 'HP:0006501', 'UPHENO:0046531', 'UPHENO:0002785', 'UPHENO:0046405', 'UPHENO:0069292', 'UPHENO:0002719', 'UPHENO:0087349', 'UPHENO:0068848', 'UPHENO:0086956', 'UBERON:0015021', 'UBERON:0003606', 'UBERON:0003466', 'UPHENO:0069163', 'UPHENO:0002751', 'UPHENO:0046397', 'UPHENO:0046554', 'UBERON:0002495', 'UPHENO:0079872', 'UPHENO:0069047', 'UPHENO:0004595', 'UPHENO:0053571', 'UPHENO:0002659', 'UPHENO:0046392', 'UPHENO:0046479', 'UPHENO:0081313', 'UPHENO:0046484', 'UPHENO:0002594', 'UBERON:0002471', 'HP:0009824', 'UPHENO:0069194', 'UPHENO:0076754', 'UPHENO:0087973', 'UBERON:0002386', 'UBERON:0003607', 'UPHENO:0002750', 'HP:0006503', 'UPHENO:0068932', 'UPHENO:0046538', 'HP:0009826', 'UPHENO:0069328', 'UPHENO:0002969', 'UPHENO:0046465', 'UPHENO:0046455', 'UPHENO:0075944', 'UPHENO:0069125', 'HP:0011024', 'UBERON:0011584', 'UPHENO:0069030', 'HP:0040072', 'UPHENO:0002738', 'UBERON:0001423', 'UBERON:0003460', 'UPHENO:0046460', 'UPHENO:0081204', 'UPHENO:0002967', 'GO:0003824', 'UPHENO:7000086', 'HP:0001561', 'UBERON:0000173', 'HP:0001560', 'UPHENO:0002916', 'UPHENO:0002869', 'HP:0011603', 'UBERON:0004572', 'UBERON:0004571', 'UPHENO:0002954', 'UPHENO:0076765', 'UBERON:0006876', 'UBERON:0002201', 'UPHENO:0033579', 'HP:0033353', 'UBERON:0010741', 'UPHENO:0033593', 'UPHENO:0081210', 'UPHENO:0015331', 'UBERON:0013768', 'UPHENO:0033609', 'UPHENO:0003019', 'UBERON:0018674', 'UBERON:0001637', 'UBERON:0004145', 'UPHENO:0033580', 'UBERON:0004573', 'UPHENO:0086797', 'HP:0002597', 'UPHENO:0033573', 'UPHENO:0087501', 'UBERON:0003513', 'UPHENO:0087309', 'UPHENO:0087018', 'UBERON:0011695', 'UPHENO:0033584', 'UPHENO:0004405', 'UPHENO:0033599', 'UBERON:0005985', 'GO:0007600', 'GO:0003008', 'GO:0007631', 'GO:0055127', 'UPHENO:0005513', 'UPHENO:0076901', 'UPHENO:0052165', 'HP:0011452', 'UPHENO:0005512', 'UPHENO:0079826', 'UPHENO:0076718', 'UPHENO:0052161', 'UPHENO:0050620', 'UPHENO:0052231', 'UPHENO:0080187', 'UPHENO:0049703', 'UBERON:0001756', 'GO:0050877', 'UPHENO:0050625', 'UPHENO:0052159', 'UPHENO:0049699', 'UPHENO:0052970', 'HP:0000370', 'UPHENO:0003017', 'HP:0000405', 'UBERON:5006049', 'HP:0001233', 'UBERON:0006049', 'UBERON:0019232', 'UPHENO:0046396', 'UPHENO:0078267', 'UPHENO:0078215', 'UPHENO:0078327', 'UPHENO:0033581', 'HP:0001159', 'UBERON:0019222', 'GO:0050954', 'UBERON:5003622', 'UPHENO:0078125', 'UPHENO:0078278', 'UPHENO:0078081', 'HP:0010554', 'UPHENO:0078159', 'UBERON:0000079', 'UPHENO:0002697', 'HP:0000032', 'HP:0000036', 'UPHENO:0005025', 'HP:0003241', 'UPHENO:0002597', 'HP:0008736', 'UBERON:0004053', 'HP:0030260', 'HP:0000078', 'UPHENO:0081320', 'HP:0000811', 'UPHENO:0031742', 'UPHENO:7000069', 'UBERON:0000989', 'HP:0012243', 'UPHENO:0002682', 'UPHENO:0003182', 'UBERON:0007530', 'UPHENO:0081095', 'UPHENO:0002558', 'UBERON:0003089', 'UBERON:0003828', 'UPHENO:0075852', 'UBERON:0003690', 'UPHENO:0076695', 'UPHENO:0086505', 'UPHENO:0086482', 'UBERON:0005174', 'UBERON:0001137', 'HP:0010767', 'UPHENO:0068838', 'UBERON:0008962', 'UBERON:0005256', 'HP:0000960', 'UBERON:0005856', 'UBERON:0003077', 'UPHENO:0087374', 'UPHENO:0004969', 'UPHENO:7000206', 'UPHENO:0002763', 'UPHENO:0050234', 'UPHENO:0002595', 'UBERON:0001130', 'UBERON:0001270', 'UBERON:0007285', 'UPHENO:0086769', 'UBERON:0001987', 'UPHENO:0003016', 'HP:0003026', 'UPHENO:0049585', 'UPHENO:0003812', 'GO:0015833', 'UPHENO:0002476', 'UPHENO:0076703', 'HP:0025031', 'UPHENO:0078179', 'HP:0002090', 'UPHENO:7000208', 'UPHENO:0002755', 'HP:0030962', 'UBERON:0006075', 'UBERON:0000915', 'UPHENO:0003177', 'UBERON:0011137', 'UBERON:0016879', 'UPHENO:0015277', 'HP:0005561', 'UBERON:0005291', 'GO:0009987', 'UPHENO:0003027', 'UPHENO:0081423', 'UBERON:0002099', 'UPHENO:0052867', 'UPHENO:0046741', 'UPHENO:0015281', 'UBERON:0004141', 'UPHENO:0002827', 'UBERON:0004872', 'UBERON:0003037', 'UPHENO:0080393', 'UBERON:0002199', 'HP:0005120', 'UPHENO:0087663', 'UPHENO:0003088', 'UPHENO:3000007', 'UBERON:0002081', 'UPHENO:0046528', 'UPHENO:0008548', 'UBERON:0012275', 'UPHENO:0046594', 'UPHENO:0002403', 'HP:0001627', 'UPHENO:0087907', 'UPHENO:0076776', 'UPHENO:0003999', 'UBERON:0002100', 'UPHENO:0004704', 'HP:0031703', 'UPHENO:0086857', 'UPHENO:0081628', 'UPHENO:0086863', 'UPHENO:0004386', 'HP:0001631', 'UBERON:0005181', 'UBERON:0015228', 'UPHENO:0002832', 'HP:0002973', 'UBERON:0001009', 'UPHENO:0004507', 'UPHENO:0082022', 'UPHENO:0076783', 'UBERON:0003929', 'UPHENO:0054374', 'UPHENO:0075937', 'HP:0100547', 'CL:0000988', 'HP:0000118', 'UBERON:0015833', 'UBERON:0002104', 'UPHENO:0053580', 'UPHENO:0002910', 'UPHENO:0002637', 'UPHENO:0005097', 'UBERON:0000019', 'UPHENO:0050108', 'UPHENO:0005080', 'HP:0011446', 'UPHENO:0080220', 'UBERON:0003084', 'UPHENO:0069327', 'UPHENO:0086589', 'UBERON:0001556', 'UPHENO:0015324', 'UPHENO:0004494', 'HP:0033127', 'UPHENO:0003020', 'UBERON:0010912', 'UBERON:0004088', 'UBERON:0007811', 'GO:0046879', 'HP:0008056', 'UPHENO:0003410', 'UPHENO:7000108', 'UPHENO:0002543', 'UPHENO:0002301', 'UPHENO:0078742', 'HP:0012649', 'UPHENO:0069523', 'UPHENO:0074335', 'NCBITaxon:6072', 'UPHENO:0003158', 'UPHENO:0002731', 'UPHENO:7000198', 'UBERON:0004708', 'UPHENO:0075997', 'UPHENO:0004433', 'GO:0042886', 'HP:0045060', 'UPHENO:0068971', 'UBERON:0010740', 'UPHENO:0033603', 'UBERON:0000171', 'UPHENO:0074228', 'UBERON:0006077', 'HP:0032251', 'UBERON:0010230', 'UPHENO:0004892', 'UPHENO:0033559', 'UPHENO:0002964', 'UPHENO:0002733', 'UBERON:0009569', 'UBERON:0005156', 'UBERON:0010312', 'UPHENO:0002844', 'UBERON:0001048', 'HP:0000568', 'UPHENO:0002593', 'UPHENO:0075219', 'UBERON:0002102', 'GO:0048856', 'UPHENO:0053633', 'GO:0032502', 'UPHENO:0003004', 'UBERON:0006555', 'UPHENO:0080209', 'UBERON:0004176', 'GO:0040007', 'UBERON:0002405', 'UPHENO:0000541', 'UBERON:0000020', 'UPHENO:0076735', 'UPHENO:0002532', 'UPHENO:0052160', 'GO:0009059', 'HP:0001510', 'UBERON:0003509', 'UPHENO:0053013', 'UPHENO:0002822', 'UPHENO:0080382', 'UBERON:0003071', 'UPHENO:0088118', 'UPHENO:0035160', 'UPHENO:0002542', 'UBERON:0005177', 'UPHENO:0035045', 'UPHENO:0003236', 'UPHENO:0035151', 'UBERON:0000490', 'UBERON:0000925', 'CL:0002092', 'HP:0012252', 'UBERON:0002398', 'UPHENO:0052778', 'UPHENO:0069062', 'UPHENO:0011536', 'UPHENO:0049724', 'UPHENO:0084448', 'UPHENO:0005016', 'CL:0001035', 'UBERON:0012475', 'HP:0004325', 'UBERON:0003061', 'UPHENO:0063794', 'UPHENO:0004459', 'UPHENO:0004757', 'UPHENO:0004831', 'UBERON:0007524', 'UBERON:0003081', 'UPHENO:0025585', 'UPHENO:0085409', 'UPHENO:0076675', 'UPHENO:0053274', 'UPHENO:7000640', 'CL:0000458', 'UPHENO:0080009', 'UPHENO:0002651', 'HP:0005528', 'UPHENO:0002945', 'UPHENO:0076694', 'UPHENO:0077371', 'UBERON:0004120', 'UBERON:0002193', 'GO:0031052', 'UPHENO:0026183', 'UBERON:0034921', 'UPHENO:0002577', 'HP:0012718', 'UPHENO:0063575', 'UPHENO:0002948', 'UBERON:0002390', 'GO:0007610', 'UPHENO:7000299', 'UPHENO:0002526', 'GO:0005515', 'UPHENO:0050106', 'UPHENO:0012312', 'UPHENO:0080325', 'GO:0032501', 'GO:0005488', 'HP:0011844', 'UPHENO:0004457', 'HP:0002167', 'GO:0003674', 'UPHENO:0033596', 'HP:0034434', 'HP:0012759', 'UPHENO:0005319', 'UPHENO:0002813', 'HP:0031073', 'UPHENO:0002442', 'HP:4000072', 'HP:0002463', 'UPHENO:0002360', 'UPHENO:0052715', 'UPHENO:0005356', 'UPHENO:3000004', 'UPHENO:0074311', 'UPHENO:0002430', 'UPHENO:0049622', 'GO:0019222', 'HP:0011314', 'UPHENO:0005573', 'UPHENO:0069236', 'UPHENO:0031743', 'UPHENO:0075961', 'UPHENO:0074584', 'GO:0009914', 'UPHENO:9002003', 'HP:0012638', 'GO:0046903', 'UBERON:0004288', 'UPHENO:0049829', 'UBERON:0015204', 'GO:0140352', 'UPHENO:0002267', 'UPHENO:7000601', 'UPHENO:0052180', 'UPHENO:0078288', 'UPHENO:0050064', 'UPHENO:0049890', 'UPHENO:0033568', 'UPHENO:0005518', 'UBERON:0004535', 'UBERON:0010316', 'UPHENO:0002963', 'UPHENO:0049813', 'UPHENO:0003082', 'UPHENO:0005517', 'UPHENO:0002352', 'UPHENO:0087665', 'GO:0042756', 'UPHENO:0087547', 'UPHENO:0004484', 'HP:0011875', 'UPHENO:0003186', 'UBERON:0000465', 'HP:0002011', 'UBERON:0003834', 'HP:0001511', 'UPHENO:0004469', 'UPHENO:0080079', 'NCBITaxon:131567', 'UBERON:0002049', 'UPHENO:0052694', 'HP:0000086', 'HP:0002984', 'UBERON:0000990', 'HP:0012639', 'GO:0051179', 'UPHENO:0087359', 'UPHENO:0049874', 'GO:0007267', 'UPHENO:0086480', 'GO:0030072', 'UBERON:0001255', 'UBERON:0006601', 'HP:0040068', 'UPHENO:0033602', 'UBERON:0007688', 'UPHENO:0075995', 'HP:0000356', 'UBERON:0013522', 'UPHENO:0088337', 'UPHENO:0002656', 'UPHENO:0002536', 'UPHENO:0053355', 'UPHENO:0004482', 'UPHENO:0050778', 'UPHENO:0002567', 'UBERON:0003059', 'UBERON:0003056', 'UPHENO:0003055', 'UBERON:0012139', 'HP:0012503', 'UPHENO:0088170', 'UPHENO:0005552', 'UPHENO:0001002', 'UPHENO:0080377', 'UBERON:0001893', 'NCBITaxon:2759', 'UBERON:0011585', 'UPHENO:0003191', 'UPHENO:0080369', 'UPHENO:0002564', 'UBERON:0007005', 'UBERON:0010363', 'UPHENO:0018390', 'UPHENO:0086735', 'UBERON:0013702', 'UBERON:0007100', 'UPHENO:0002636', 'UPHENO:0075195', 'UBERON:0001434', 'UPHENO:0004466', 'UPHENO:0078307', 'BFO:0000015', 'UPHENO:0075220', 'UPHENO:0083008', 'UPHENO:0005120', 'UPHENO:0003815', 'HP:0000377', 'UBERON:0001049', 'UPHENO:0002928', 'UPHENO:0003159', 'GO:0007605', 'UPHENO:0004536', 'GO:0023052', 'UPHENO:0052714', 'HP:0012758', 'UPHENO:0049652', 'UPHENO:0063787', 'UPHENO:0004047', 'UBERON:0001041', 'UBERON:0001456', 'UPHENO:0001001', 'UBERON:0001016', 'HP:0031072', 'UBERON:0000047', 'UPHENO:0005427', 'HP:0001903', 'UPHENO:0005470', 'UPHENO:0049871', 'UPHENO:0011498', 'UBERON:0000062', 'UBERON:0004121', 'UBERON:0012141', 'UBERON:0034923', 'UPHENO:0002708', 'UPHENO:0088319', 'UPHENO:0002388', 'UPHENO:0074229', 'UPHENO:0002529', 'UPHENO:0005534', 'UBERON:0002529', 'UBERON:0003296', 'GO:0065008', 'UPHENO:0050063', 'UPHENO:0005652', 'UPHENO:0075772', 'UPHENO:0005431', 'CL:0000000', 'UPHENO:0002808', 'UPHENO:0033572', 'HP:0008551', 'UBERON:0019221', 'UPHENO:0074237', 'UBERON:0010000', 'UPHENO:0002903', 'UPHENO:0002559', 'UBERON:0011216', 'UBERON:0004347', 'HP:0011994', 'GO:0009890', 'UBERON:0009881', 'UBERON:0005423', 'UPHENO:0004621', 'UPHENO:0088326', 'HP:0000830', 'UPHENO:0083951', 'UPHENO:0002523', 'UPHENO:0088123', 'HP:0040075', 'UBERON:0000153', 'UBERON:0015410', 'UPHENO:0027017', 'UPHENO:0002621', 'UPHENO:0077890', 'GO:0002790', 'UPHENO:0005285', 'HP:0001194', 'UBERON:0002368', 'HP:0000925', 'UPHENO:0069064', 'UBERON:0005419', 'UPHENO:0004503', 'GO:0007275', 'UBERON:0005473', 'UBERON:0003104', 'UPHENO:0049691', 'GO:0009790', 'UPHENO:0002579', 'UPHENO:0087940', 'UPHENO:0049870', 'CL:0000081', 'HP:0001643', 'UPHENO:0002859', 'UPHENO:0052554', 'UBERON:0010703', 'UBERON:0002085', 'UBERON:0007798', 'UPHENO:0002754', 'UPHENO:0002530', 'UPHENO:0003334', 'UBERON:0000170', 'HP:0012443', 'UBERON:0015203', 'UPHENO:0086633', 'UPHENO:0053610', 'UPHENO:0046403', 'UPHENO:0053330', 'UBERON:0005178', 'UBERON:0002616', 'UPHENO:0005058', 'HP:0001671', 'UPHENO:0005458', 'UPHENO:0069046', 'HP:0001167', 'UBERON:0000307', 'UPHENO:0003002', 'UPHENO:0046750', 'UPHENO:7000266', 'UPHENO:0005030', 'UPHENO:0004909', 'UPHENO:0002764', 'UPHENO:0087376', 'UPHENO:0049904', 'UBERON:0000061', 'UPHENO:0002648', 'UPHENO:0002386', 'UPHENO:0068912', 'GO:0032940', 'UBERON:0002050', 'UBERON:8480069', 'UPHENO:0005597', 'UBERON:0010260', 'UPHENO:0087518', 'UBERON:0036146', 'UBERON:0000483', 'UBERON:0004734', 'BFO:0000003', 'HP:0004322', 'UBERON:0000075', 'UPHENO:0002456', 'GO:0023061', 'UPHENO:0002541', 'UPHENO:0003432', 'UPHENO:0050068', 'UPHENO:0050014', 'UBERON:0009142', 'UPHENO:0005434', 'NCBITaxon:33208', 'HP:0000929', 'UBERON:0035639', 'UBERON:0001474', 'UBERON:0002196', 'UPHENO:0076791', 'UBERON:0005417', 'UPHENO:0052226', 'UPHENO:0054304', 'UPHENO:0003058', 'UPHENO:0003413', 'UBERON:0006314', 'UPHENO:0046540', 'UPHENO:0004618', 'UPHENO:0063569', 'HP:0002088', 'UBERON:0000970', 'HP:0000014', 'UPHENO:0086485', 'HP:0010936', 'UPHENO:0088162', 'UPHENO:0004891', 'CL:0000763', 'UPHENO:0081436', 'UPHENO:0003116', 'UPHENO:0012440', 'HP:0011355', 'UPHENO:0005542', 'UBERON:0003133', 'UPHENO:0002870', 'UPHENO:0002571', 'RO:0002577', 'UPHENO:0003005', 'UPHENO:0002393', 'UPHENO:0003065', 'UPHENO:0004521', 'HP:0010461', 'UPHENO:0026010', 'UBERON:0002530', 'UPHENO:0005437', 'UPHENO:7000632', 'GO:0010556', 'UPHENO:0003163', 'UPHENO:0002433', 'UPHENO:0002668', 'UPHENO:0082878', 'UPHENO:0002634', 'UPHENO:0033565', 'UPHENO:0002553', 'UPHENO:0049587', 'CL:0000225', 'UPHENO:0088065', 'UPHENO:0005647', 'UPHENO:0053234', 'UPHENO:0087472', 'UPHENO:0050034', 'UPHENO:0080662', 'UBERON:0015001', 'BFO:0000004', 'UPHENO:0075878', 'UPHENO:0002743', 'HP:0012647', 'UPHENO:0002643', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0005141', 'UBERON:0003072', 'HP:0025634', 'UPHENO:0076805', 'UBERON:0008001', 'HP:0000252', 'UPHENO:0005477', 'UBERON:0036295', 'UBERON:0000007', 'GO:0010558', 'UBERON:0002371', 'UPHENO:0001003', 'UBERON:0002470', 'HP:0000824', 'GO:0042592', 'UBERON:0000475', 'UPHENO:0052518', 'HP:0012372', 'UPHENO:0010808', 'HP:0008772', 'UBERON:0000073', 'UPHENO:0003811', 'UBERON:0000064', 'UPHENO:0085306', 'UPHENO:0005504', 'UBERON:0004092', 'UPHENO:0075655', 'UPHENO:0002385', 'UPHENO:0005441', 'UPHENO:0004721', 'UPHENO:0002422', 'UPHENO:0011531', 'UBERON:0007272', 'UPHENO:0080029', 'UBERON:0010707', 'UPHENO:0076692', 'UPHENO:0050121', 'HP:0009380', 'UPHENO:0076739', 'UPHENO:0002525', 'UPHENO:0049647', 'UBERON:0006598', 'UPHENO:0003086', 'BFO:0000001', 'UPHENO:0068839', 'UPHENO:0002574', 'GO:0006954', 'UPHENO:0074310', 'UPHENO:0087660', 'UPHENO:0052178', 'UPHENO:0086679', 'UBERON:0004765', 'UPHENO:0002531', 'UPHENO:7000143', 'UBERON:0001691', 'UPHENO:0009163', 'UPHENO:0004615', 'HP:0000079', 'UPHENO:0049894', 'UBERON:0003622', 'UPHENO:0075902', 'UPHENO:0087516', 'UPHENO:0050581', 'UBERON:0003937', 'UPHENO:0076740', 'UBERON:0004139', 'UPHENO:0078743', 'UPHENO:0033560', 'UPHENO:0002269', 'UPHENO:0052678', 'UPHENO:0049873', 'NCBITaxon:1', 'UPHENO:0005571', 'UBERON:0003080', 'UBERON:0001032', 'GO:0030252', 'UBERON:0003075', 'UBERON:0001894', 'UPHENO:0004403', 'UPHENO:0005611', 'HP:0006496', 'UPHENO:0004802', 'UBERON:0010758', 'HP:0000864', 'UPHENO:0069266', 'UPHENO:0087846', 'UPHENO:0002976', 'UBERON:0000949', 'UPHENO:0081581', 'HP:0000598', 'UPHENO:0000543', 'UPHENO:0002949', 'UPHENO:0053612', 'HP:0040070', 'HP:0005107', 'NCBITaxon:33154', 'GO:0050789', 'UPHENO:7000334', 'UPHENO:0080351', 'GO:0010817', 'UPHENO:0003550', 'UPHENO:0004519', 'UPHENO:0078629', 'UPHENO:0005110', 'UPHENO:0087363', 'UPHENO:0049775', 'BFO:0000002', 'UBERON:0004151', 'UBERON:0004140', 'UPHENO:0025587', 'HP:0000478', 'UPHENO:0086635', 'UPHENO:0004888', 'UPHENO:0063722', 'CL:0000764', 'UBERON:0003135', 'UPHENO:0084763', 'UPHENO:0052245', 'UPHENO:0050065', 'GO:0065007', 'UPHENO:0002554', 'UBERON:0008785', 'UBERON:0000924', 'UBERON:0001062', 'UBERON:0003129', 'UPHENO:0002736', 'UPHENO:0004523', 'UPHENO:0052937', 'UBERON:0000923', 'UPHENO:0003001', 'UBERON:0000926', 'HP:0010987', 'UPHENO:0004143', 'UPHENO:0004173', 'UBERON:0000033', 'UPHENO:0046624', 'UPHENO:0052354', 'UPHENO:0005642', 'GO:0008150', 'HP:0000009', 'UPHENO:0002548', 'HP:0000001', 'UPHENO:0003827', 'UPHENO:0054957', 'UPHENO:0004885', 'UBERON:0000025', 'UPHENO:0049835', 'BFO:0000040', 'UPHENO:0003189', 'UBERON:0002331', 'UPHENO:0005596', 'UBERON:0001017', 'UPHENO:0002568', 'UPHENO:0005506', 'HP:0009115', 'UBERON:0002105', 'UPHENO:0005570', 'UBERON:0000955', 'UPHENO:0085371', 'UPHENO:0002219', 'GO:0007154', 'GO:0051234', 'UPHENO:0004900', 'GO:0071705', 'UPHENO:0002896', 'HP:0000818', 'UPHENO:0002880', 'UPHENO:0002830', 'HP:0006101', 'UPHENO:0076697', 'UPHENO:0003799', 'UBERON:0010130', 'UPHENO:0050126', 'UBERON:0010708', 'UPHENO:0049743', 'UBERON:0011249', 'UPHENO:0002746', 'UBERON:0000463', 'UPHENO:0002427', 'UPHENO:0004680', 'UPHENO:0003095', 'UPHENO:0087347', 'UPHENO:0005134', 'HP:0011927', 'UPHENO:0012274', 'UBERON:0018707', 'UPHENO:0002905', 'HP:0000924', 'HP:0011747', 'UPHENO:0049584', 'UPHENO:0002983', 'UPHENO:0086908', 'UPHENO:0086546', 'UBERON:0004357', 'UPHENO:0005426', 'UBERON:0000026', 'UBERON:5002544', 'UPHENO:0046707', 'UPHENO:0087006', 'UPHENO:0002782', 'UPHENO:0002803', 'UPHENO:0080099', 'UPHENO:0046445', 'UBERON:0011582', 'GO:0006810', 'UBERON:0001015', 'UPHENO:0088166', 'UBERON:0010314', 'UPHENO:0003049', 'UBERON:0003102', 'GO:0009058', 'UPHENO:0050008', 'UPHENO:0003227', 'UPHENO:0087294', 'UPHENO:0080126', 'UPHENO:0008668', 'UPHENO:0046483', 'HP:0009601', 'UPHENO:0002632', 'UPHENO:0074245', 'UPHENO:0088186', 'UBERON:0034925', 'UBERON:5001463', 'UBERON:0002114', 'HP:0031704', 'UBERON:0002513', 'NBO:0000313', 'HP:0011297', 'UPHENO:0046426', 'UPHENO:0002747', 'UPHENO:0002902', 'UBERON:0001981', 'UPHENO:0087924', 'UBERON:0011676', 'UBERON:0000481', 'UBERON:0001463', 'UPHENO:0002308', 'UPHENO:0077887', 'UPHENO:0077889', 'UBERON:0005451', 'HP:0000035', 'GO:0009892', 'UPHENO:7000157', 'UBERON:0012354', 'UPHENO:0003412', 'HP:0011842', 'UPHENO:0003069', 'UBERON:0001567', 'HP:0002817', 'HP:0005927', 'UPHENO:0002650', 'HP:0001508', 'UPHENO:0002600', 'UPHENO:0002685', 'UBERON:0001442', 'HP:0006265', 'UPHENO:0050040', 'UPHENO:0018414', 'UPHENO:0002816', 'UPHENO:0004360', 'UBERON:0002091', 'UPHENO:0082794', 'UPHENO:0076684', 'UBERON:0001440', 'UBERON:0010538', 'UBERON:0000489', 'UPHENO:0087089', 'UPHENO:0005433', 'UPHENO:0002909', 'UBERON:0004921', 'UPHENO:0082678', 'UPHENO:0003415', 'UPHENO:0005602', 'UPHENO:0003094', 'HP:0009778', 'UBERON:0005409', 'HP:0000707', 'UPHENO:0084761', 'UPHENO:0079876', 'UPHENO:0086486', 'UBERON:0004381', 'HP:0007364', 'UBERON:0001460', 'UBERON:0015061', 'UBERON:0004456', 'GO:0010605', 'UPHENO:0053566', 'UPHENO:0046505', 'UPHENO:0069605', 'GO:0010468', 'UPHENO:0049588', 'UPHENO:0069684', 'UPHENO:0005214', 'UPHENO:0002527', 'UPHENO:0046411', 'UPHENO:0080114', 'UPHENO:0075159', 'UPHENO:0003366', 'UPHENO:0080588', 'HP:0040064', 'UPHENO:0002861', 'HP:0004323', 'HP:0002818', 'HP:0002813', 'UBERON:0003101', 'HP:0000750', 'HP:0001155', 'UPHENO:0076724', 'UBERON:0019231', 'UPHENO:0008523', 'UBERON:0006048', 'UBERON:0004375', 'UBERON:0002428', 'GO:0060255', 'UPHENO:0002586', 'UPHENO:0080200', 'HP:0010781', 'UBERON:0007503', 'UPHENO:0034969', 'UBERON:0010712', 'UPHENO:0076723', 'UPHENO:0004475', 'UPHENO:0046552', 'UBERON:5006048', 'HP:0011017', 'UBERON:0002544', 'UPHENO:0080111', 'HP:0001172', 'HP:0003221', 'GO:0010467', 'UBERON:0009856', 'UPHENO:7000599', 'UPHENO:0078606', 'UPHENO:0049620', 'GO:0043170', 'GO:0048519', 'GO:0050794', 'UPHENO:0081466', 'UPHENO:0081091', 'HP:0001939', 'HP:0003220', 'GO:0031049', 'UPHENO:0050007', 'GO:0010629', 'UPHENO:0063639', 'UPHENO:7000146', 'UPHENO:0050435', 'HP:0011100', 'UPHENO:0049837', 'HP:0025015', 'UPHENO:0004476', 'HP:0040012', 'UPHENO:0087334', 'UPHENO:0002240', 'UPHENO:0049757', 'UPHENO:0005540', 'UPHENO:0049642', 'GO:0008152', 'UBERON:0001444', 'HP:0001197', 'UPHENO:0002704', 'UBERON:0013701', 'UPHENO:0004064', 'UPHENO:0054315', 'UPHENO:0010763', 'UPHENO:0053559', 'UPHENO:0087849', 'UPHENO:3000001', 'UPHENO:0002806', 'UPHENO:0053208', 'UPHENO:0002547', 'UPHENO:0010850', 'UPHENO:0075872', 'CL:0000255', 'GO:0048523', 'UPHENO:0082761', 'UPHENO:0005055', 'UPHENO:0026506', 'UPHENO:0026181', 'UPHENO:0003514', 'UPHENO:0026146', 'UBERON:0000383', 'UBERON:0000922', 'UPHENO:0026757', 'UPHENO:0053647', 'UPHENO:0003101', 'UPHENO:0075949', 'UPHENO:0035147', 'HP:0002715', 'UPHENO:0009382', 'UPHENO:0026643', 'UPHENO:0074652', 'UPHENO:0009146', 'UPHENO:0011825', 'UPHENO:0026078', 'HP:0009777', 'UPHENO:0025509', 'UPHENO:0004480', 'UPHENO:0026640', 'UPHENO:0026108', 'UPHENO:0081451', 'UPHENO:0076747', 'UBERON:0003103', 'HP:0001871', 'GO:0006952', 'UPHENO:0049927', 'UPHENO:0011572', 'UBERON:0006058', 'UPHENO:0002678', 'UPHENO:0009020', 'UPHENO:0077373', 'HP:0040195', 'UPHENO:0086855', 'HP:0000234', 'UBERON:0006717', 'UPHENO:0004505', 'UPHENO:0004401', 'UPHENO:0075804', 'HP:0001626', 'HP:0005922', 'UBERON:0010323', 'UBERON:0011138', 'UBERON:0001690', 'UPHENO:0075148', 'HP:0002060', 'UPHENO:0076799', 'HP:0000152', 'UPHENO:0081566', 'HP:0002244', 'HP:0000050', 'UPHENO:0074804', 'UPHENO:0002437', 'UPHENO:3000000', 'UBERON:0000948', 'UBERON:0005944', 'UBERON:0002090', 'HP:0012725', 'HP:0002977', 'UPHENO:0003050', 'UPHENO:0069352', 'HP:0009121', 'UPHENO:0069149', 'UPHENO:0035034', 'UPHENO:0002467', 'UBERON:0011143', 'UBERON:0001711', 'HP:0000240', 'UPHENO:0080110', 'HP:0000125', 'UPHENO:0076730', 'UPHENO:0033607', 'HP:0008771', 'UPHENO:0086699', 'HP:0025792', 'UPHENO:0087531', 'UPHENO:0002944', 'UPHENO:0080300', 'UPHENO:0003092', 'UBERON:0003914', 'UPHENO:0002901', 'UBERON:0002101', 'UPHENO:0005986', 'UPHENO:0081119', 'UPHENO:0077348', 'UBERON:0004119', 'UPHENO:0053121', 'UPHENO:0041226', 'HP:0000119', 'UPHENO:0082023', 'UBERON:0005440', 'UBERON:0004122', 'UPHENO:0002926', 'UBERON:0005173', 'UPHENO:0002603', 'UBERON:0002355', 'UBERON:0002389', 'UBERON:8450002', 'UPHENO:0002448', 'UPHENO:0002282', 'UBERON:0000477', 'HP:0001507', 'UPHENO:0005166', 'UPHENO:0083689', 'UPHENO:0002411', 'UPHENO:0002642', 'UPHENO:0002368', 'HP:0000076', 'UPHENO:0075933', 'UBERON:0000474', 'UPHENO:0085302', 'UPHENO:0002261', 'UBERON:0000916', 'UPHENO:0002654', 'UBERON:0002204', 'UPHENO:0002303', 'UPHENO:0018426', 'UBERON:0005179', 'UBERON:0005172', 'UBERON:0001007', 'UPHENO:0086700', 'HP:0000069', 'UPHENO:0002377', 'UBERON:5002389', 'UPHENO:0003093', 'UPHENO:0003025', 'UPHENO:0002426', 'UBERON:0001008', 'UBERON:0004247', 'HP:0001873', 'UPHENO:0080352', 'HP:0010935', 'UPHENO:0003084', 'UPHENO:0002246', 'HP:0000365', 'UBERON:0000056', 'UPHENO:0009209', 'UPHENO:0002804', 'UPHENO:0033598', 'UPHENO:0002211', 'UBERON:0000478', 'UPHENO:0049966', 'UPHENO:0082875', 'UBERON:0002329', 'UPHENO:0049733', 'UPHENO:0002866', 'UBERON:0000323', 'UBERON:0003100', 'UPHENO:0069161', 'UBERON:0012140', 'HP:0010948', 'UPHENO:0002576', 'UPHENO:0083648', 'UBERON:0004111', 'UPHENO:0085344', 'HP:0001195', 'UBERON:0016887', 'HP:0011425', 'UPHENO:0003031', 'HP:0000953', 'HP:0034058', 'UBERON:0001558', 'HP:0000364', 'UPHENO:0002635', 'UBERON:0004716', 'UPHENO:0002616', 'UBERON:0003498', 'UBERON:0000055', 'HP:0012145', 'HP:0011403', 'UPHENO:0025507', 'HP:0010881', 'UBERON:0004537', 'UPHENO:0076729', 'UPHENO:0004827', 'UPHENO:0087186', 'UBERON:0004089', 'UPHENO:0069674', 'UPHENO:0081424', 'UPHENO:0069254', 'UPHENO:0087661', 'HP:0000002', 'CL:0000151', 'UPHENO:0005590', 'UBERON:0001869', 'HP:0001872', 'UPHENO:0003207', 'UPHENO:0076812', 'HP:0011873', 'UBERON:0005881', 'UPHENO:0080010', 'CL:0000233', 'UPHENO:0086173', 'HP:0009821', 'UPHENO:7000590', 'UPHENO:0077391', 'CL:0000457', 'UPHENO:0083263', 'UPHENO:0068898', 'UBERON:0004710', 'UBERON:0002108', 'UPHENO:0053619', 'HP:0007400', 'UBERON:0001555', 'UBERON:0000065', 'UPHENO:0087433', 'UPHENO:0002434', 'UPHENO:0076803', 'UPHENO:0049868', 'UPHENO:0002679', 'GO:0043473', 'UPHENO:0002783', 'UBERON:0016880', 'GO:0009889', 'HP:0011121', 'UPHENO:0002734', 'UBERON:0001004', 'UBERON:0002113', 'UPHENO:0055024', 'UPHENO:0004094', 'UPHENO:0074722', 'UBERON:0000468', 'UBERON:0002048', 'UPHENO:0004518', 'UBERON:0002075', 'UBERON:0005911', 'UPHENO:0087662', 'UPHENO:7000623', 'UPHENO:0002988', 'UBERON:0000160', 'HP:0000951', 'UPHENO:0076810', 'HP:0011947', 'HP:0010978', 'UPHENO:0081978', 'UPHENO:0087510', 'UPHENO:0003038', 'UPHENO:0002239', 'UPHENO:0080693', 'CL:0002242', 'UPHENO:7000655', 'UPHENO:0053456', 'UPHENO:0004481', 'UPHENO:0074801', 'UBERON:0003258', 'UPHENO:0076702', 'UPHENO:0002833', 'UPHENO:0002994', 'UPHENO:0077418', 'CL:0000738', 'HP:0002086', 'UBERON:0013765', 'UBERON:0008811', 'UBERON:0001005', 'UPHENO:0002263', 'UBERON:0001890', 'UPHENO:0002546', 'UBERON:0001132', 'UPHENO:0074794', 'CL:0000329', 'UBERON:0004128', 'UPHENO:0005257', 'UBERON:0002346', 'UPHENO:0004443', 'GO:0050896', 'UBERON:0000072', 'UPHENO:0002725', 'UPHENO:0049586', 'UPHENO:0054970', 'GO:0006950', 'UPHENO:0087585', 'CL:0000219', 'UPHENO:0046740', 'UPHENO:0076727', 'HP:0001881', 'UPHENO:0010795', 'UPHENO:0077399', 'UPHENO:0086172', 'UBERON:0000179', 'UBERON:0000178', 'HP:0001882', 'UPHENO:0087123', 'UPHENO:0004418', 'HP:0009381', 'HP:0011893', 'HP:0100887', 'UPHENO:0085410', 'UPHENO:0083952', 'HP:0009815', 'UPHENO:0085330', 'HP:0001000', 'UBERON:0010371', 'UBERON:0000479', 'HP:0012733', 'HP:0001574', 'UPHENO:0012308', 'HP:0000957', 'UBERON:0002417', 'UBERON:0002416', 'HP:0025354', 'UBERON:0002097', 'UPHENO:0010799', 'HP:0001034', 'UPHENO:0074575', 'HP:0034057', 'HP:0001328', 'UPHENO:0003029', 'UBERON:0003463', 'UBERON:0015212', 'UPHENO:0004545', 'HP:0030680', 'UPHENO:0003234'], 'has_phenotype_closure_label': ['female organism', 'female reproductive system phenotype', 'Abnormal placenta morphology', 'placenta', 'Placental abruption', 'Abnormal duodenum morphology', 'subdivision of tube atresia', 'Abnormality of the digestive system', 'closing of the organ part', 'subdivision of digestive tract atresia', 'multicellular anatomical structure atresia', 'closing of the anatomical entity', 'closing of the multicellular anatomical structure', 'Intestinal atresia', 'Abnormal digestive system morphology', 'anatomical entity atresia', 'Abnormal gastrointestinal tract morphology', 'duodenum', 'anatomical system atresia', 'anatomical entity morphology in the alimentary part of gastrointestinal system phenotype', 'duodenum phenotype', 'closing of the anatomical structure', 'Cryptorchidism', 'female organism phenotype', 'localised reproductive structure', 'localised gonad', 'Abnormal testis morphology', 'testis phenotype', 'localised material anatomical entity', 'temporofacial region', 'midface', 'localised anatomical structure', 'localised organ', 'cheek', 'external soft tissue zone', 'pelvic kidney', 'localised anatomical entity', 'Abnormal localization of kidney', 'Gastrointestinal atresia', 'cheek morphology phenotype', 'localised trunk region element', 'midface morphology phenotype', 'localised abdomen element', 'localised multicellular anatomical structure', 'localised cavitated compound organ', 'localised lateral structure', 'Renal hypoplasia', 'kidney morphology phenotype', 'renal system morphology phenotype', 'Abnormality of the kidney', 'localised reproductive organ', 'Renal hypoplasia/aplasia', 'Abnormal renal morphology', 'kidney hypoplasia', 'Anemia', 'oxygen accumulating cell', 'drinking behavior', 'consumption behavior', 'anemia', 'erythrocyte', 'Abnormal erythrocyte morphology', 'hematopoietic system morphology phenotype', 'aplasia or hypoplasia of radius bone', 'decreased size of the bone of pectoral complex', 'forelimb endochondral element', 'bone of pectoral complex', 'Forearm undergrowth', 'forelimb long bone phenotype', 'decreased length of forelimb zeugopod bone', 'small intestine morphology phenotype', 'forelimb zeugopod bone', 'arm bone phenotype', 'decreased length of forelimb endochondral element', 'forelimb zeugopod', 'forelimb bone', 'polydipsia', 'decreased size of the long bone', 'midface phenotype', 'decreased length of skeletal element', 'decreased size of the forelimb zeugopod bone', 'Aplasia/Hypoplasia of the radius', 'decreased length of limb endochondral element', 'decreased length of arm bone', 'long bone', 'Aplasia/hypoplasia involving forearm bones', 'decreased size of the endochondral bone', 'decreased length of bone of free limb or fin', 'placenta phenotype', 'decreased size of the bone of appendage girdle complex', 'decreased length of bone element', 'forelimb endochondral element phenotype', 'bone of pectoral complex morphology phenotype', 'zeugopod', 'forelimb zeugopod skeleton', 'decreased length of limb bone', 'forelimb zeugopod phenotype', 'radius bone morphology phenotype', 'decreased size of the forelimb endochondral element', 'decreased size of the endochondral element', 'decreased length of organ', 'decreased size of the bone of free limb or fin', 'radius bone hypoplasia', 'decreased size of the limb endochondral element', 'decreased length of bone of pectoral complex', 'zeugopod phenotype', 'Abnormal forearm morphology', 'Abnormal upper limb bone morphology', 'amniotic fluid', 'amniotic fluid phenotype', 'Polyhydramnios', 'altered substrate specificity', 'catalytic activity', 'trunk blood vessel phenotype', 'coronary vessel morphology phenotype', 'incomplete closing of the thoracic segment blood vessel', 'systemic artery phenotype', 'systemic artery', 'artery phenotype', 'incomplete closing of the heart blood vessel', 'great vessel of heart phenotype', 'incomplete closing of the systemic artery', 'great vessel of heart', 'artery morphology phenotype', 'vasculature of organ phenotype', 'incomplete closing of the coronary vessel', 'incomplete closing of the trunk blood vessel', 'incomplete closing of the artery', 'thoracic segment blood vessel', 'artery', 'systemic arterial system', 'ductus arteriosus morphology phenotype', 'coronary vessel', 'Patent ductus arteriosus', 'Abnormality of the vasculature', 'trunk blood vessel', 'arterial blood vessel', 'incomplete closing of the ductus arteriosus', 'outflow tract', 'Abnormal blood vessel morphology', 'Abnormal morphology of the great vessels', 'multicellular anatomical structure morphology in the heart phenotype', 'systemic artery morphology phenotype', 'Congenital malformation of the great arteries', 'system process', 'vibrational conductance of sound to the inner ear', 'Abnormality of the middle ear', 'decreased sensory perception of sound', 'decreased sensory perception of mechanical stimulus', 'sensory perception of sound phenotype', 'Conductive hearing impairment', 'decreased qualitatively sensory perception', 'sensory perception', 'localised testis', 'Abnormal ear physiology', 'forelimb skeleton phenotype', 'middle ear physiology phenotype', 'decreased qualitatively sensory perception of mechanical stimulus', 'vasculature of trunk phenotype', 'sensory perception of sound', 'nervous system process phenotype', 'organ part atresia', 'Functional abnormality of the middle ear', 'sensory perception phenotype', 'Hearing abnormality', 'decreased nervous system process', 'decreased qualitatively sensory perception of sound', 'nervous system process', 'manual digit 2 morphology phenotype', 'Finger syndactyly', 'digit 2', 'manual digit 2, 3 or 4', 'fused manual digit and anatomical entity', 'fused anatomical entity and manual digit', 'fused anatomical entity and digit', 'fused digit and anatomical entity', 'fused manual digit and manual digit', 'Cutaneous finger syndactyly', 'fused anatomical entity and anatomical entity', 'intromittent organ phenotype', 'sensory perception of mechanical stimulus', 'external genitalia', 'male reproductive organ', 'male organism', 'Pelvic kidney', 'external male genitalia phenotype', 'Abnormal reproductive system morphology', 'external genitalia morphology; external genitalia phenotype', 'Hypoplasia of penis', 'penis hypoplasia', 'male reproductive system phenotype', 'Abnormality of the male genitalia', 'Abnormal penis morphology', 'Microphallus', 'external male genitalia hypoplasia', 'External genital hypoplasia', 'intromittent organ', 'penis phenotype', 'male reproductive system morphology phenotype', 'Abnormal male external genitalia morphology', 'developing mesenchymal condensation phenotype', 'digit 2, 3 or 4', 'paraxial mesoderm morphology phenotype', 'migrating mesenchyme population', 'bone of dorsum phenotype', 'decreased qualitatively nervous system process', 'presumptive paraxial mesoderm phenotype', 'epithelial vesicle', 'dorsum', 'external genitalia phenotype', 'paraxial mesoderm phenotype', 'sacral region of vertebral column phenotype', 'vertebral column morphology phenotype', 'vertebral column', 'manual digit 2', 'subdivision of vertebral column', 'bony pelvis', 'presumptive paraxial mesoderm', 'incomplete closing of the multicellular anatomical structure', 'trunk mesenchyme', 'cell condensation', 'presomitic mesoderm', 'somite', 'sclerotome morphology phenotype', 'vertebral column phenotype', 'dorsal region element phenotype', 'entire embryonic mesenchyme', 'developing mesenchymal condensation', 'Abnormal sacrum morphology', 'bone of dorsum', 'limb bone morphology phenotype', 'manual digit 1 plus metapodial segment', 'regulation of hormone levels phenotype', 'multi-limb segment region phenotype', 'Delayed speech and language development', 'decreased size of the manual digit', 'system', 'Neurodevelopmental abnormality', 'limb bone phenotype', 'incomplete closing of the vessel', 'appendage phenotype', 'appendicular skeleton morphology phenotype', 'radius bone', 'digit 1 or 5', 'biological_process in central nervous system phenotype', 'absent material anatomical entity in the multicellular organism', 'male reproductive system', 'thoracic segment of trunk', 'Skin dimple', 'eyelid apraxia', 'atrial septum morphology', 'multi organ part structure physiology phenotype', 'pectoral appendage skeleton', 'anatomical structure atresia', 'aplastic anatomical entity', 'Hearing impairment', 'splanchnic layer of lateral plate mesoderm phenotype', 'heart primordium phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'haemolymphatic fluid phenotype', 'multi organ part structure phenotype', 'multi-tissue structure phenotype', 'Abnormal cellular immune system morphology', 'primary circulatory organ', 'thoracic cavity element', 'lower urinary tract phenotype', 'sacral region', 'viscus physiology phenotype', 'Abnormal cognitive process', 'peptide transport phenotype', 'Abnormality of the cardiovascular system', 'eye physiology phenotype', 'cardiac chamber', 'embryo phenotype', 'circulatory organ', 'cardiac septum morphology phenotype', 'erythrocyte morphology phenotype', 'vascular system morphology phenotype', 'cardiovascular system morphology phenotype', 'Irregular hyperpigmentation', 'subdivision of trunk', 'ectoderm phenotype', 'cardiovascular system phenotype', 'cardiac atrium morphology phenotype', 'secretion by cell', 'telencephalon morphology phenotype', 'primary heart field', 'cardiopharyngeal field', 'developmental process phenotype', 'digit', 'forelimb morphology phenotype', 'decreased number of platelet', 'incomplete closing of the anatomical structure', 'forelimb zeugopod morphology phenotype', 'decreased extent and duration of protein-protein interaction', 'meso-epithelium phenotype', 'cell-cell signaling', 'trunk region element', 'anatomical structure mass phenotype', 'cardiac chamber phenotype', 'size of eyeball of camera-type eye phenotype', 'anatomical structure morphology in the heart phenotype', 'orbital region phenotype', 'Abnormality of the upper limb', 'cardiac septum phenotype', 'camera-type eye physiology phenotype', 'Microtia', 'decreased size of the anatomical structure', 'skeleton of manus', 'absent anatomical entity in the limb', 'decreased size of the eyeball of camera-type eye', 'heart tube morphology phenotype', 'optic vesicle phenotype', 'organ part physiology phenotype', 'optic cup morphology phenotype', 'regulation of biological process', 'Abnormality of the skeletal system', 'Microphthalmia', 'male reproductive organ morphology phenotype', 'small intestine phenotype', 'eye primordium', 'unilaminar epithelium phenotype', 'decreased number of material anatomical entity', 'lateral structure', 'aplasia or hypoplasia of eyeball of camera-type eye', 'reproductive gland morphology phenotype', 'urinary bladder physiology phenotype', 'thoracic segment organ phenotype', 'Abnormal skull morphology', 'Hypoplastic male external genitalia', 'heart plus pericardium', 'simple eye phenotype', 'multicellular organism phenotype', 'eyeball of camera-type eye', 'long bone morphology phenotype', 'Abnormal thumb morphology', 'subdivision of head', 'multicellular organism height phenotype', 'endocrine system morphology phenotype', 'decreased length of long bone', 'immature eye phenotype', 'Decreased total leukocyte count', 'eye morphology', 'decreased size of the multicellular anatomical structure', 'heart tube', 'eye phenotype', 'limb bone', 'Abnormality of head or neck', 'primordium phenotype', 'bone of pectoral complex phenotype', 'metabolic process', 'visual system', 'ectoderm-derived structure physiology phenotype', 'decreased qualitatively anatomical structure development', 'Intrauterine growth retardation', 'response to stimulus phenotype', 'decreased developmental process', 'ear morphology phenotype', 'decreased qualitatively developmental process', 'umbilical cord phenotype', 'multicellular anatomical structure physiology phenotype', '2-3 finger cutaneous syndactyly', 'decreased multicellular organismal process', 'forelimb zeugopod bone hypoplasia', 'decreased anatomical structure development', 'camera-type eye morphology phenotype', 'decreased embryo development', 'outflow tract phenotype', 'rotated external ear', 'increased defense response in lung', 'growth phenotype', 'developmental process rate phenotype', 'size of skull phenotype', 'decreased qualitatively multicellular organismal process', 'neural plate phenotype', 'axial skeleton plus cranial skeleton phenotype', 'blood island phenotype', 'decreased number of anatomical entity', 'Abnormality of multiple cell lineages in the bone marrow', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'localised compound organ', 'compound organ', 'primordium', 'decreased number of anatomical structure', 'subdivision of head phenotype', 'forelimb bone phenotype', 'anterior region of body', 'fused digit and digit', 'decreased multicellular organism development', 'forebrain', 'vasculature of trunk', 'absent anatomical entity in the forelimb', 'subdivision of digestive tract', 'Ectopic kidney', 'viscus phenotype', 'closing of the subdivision of tube', 'presomitic mesoderm morphology phenotype', 'Aplasia/hypoplasia involving bones of the hand', 'skeletal system', 'hematopoietic system phenotype', 'primary circulatory organ phenotype', 'hemolymphoid system', 'bone marrow', 'ocular adnexa', 'immune system', 'thoracic segment organ', 'decreased length of autopodial extension', 'multi-tissue structure', 'trunk region element phenotype', 'penis', 'negative regulation of gene expression phenotype', 'mesoderm-derived structure phenotype', 'Aplasia/hypoplasia involving bones of the upper limbs', 'decreased number of anatomical entity in the multicellular organism', 'bone element', 'macromolecule biosynthetic process', 'skeletal element', 'decreased number of cell', 'Language impairment', 'decreased number of anatomical entity in the bone marrow', 'decreased qualitatively embryo development', 'arm phenotype', 'number of anatomical enitites of type material anatomical entity phenotype', 'limb long bone phenotype', 'Short digit', 'lateral plate mesoderm', 'absent autopodial extension', 'secretion phenotype', 'bone marrow phenotype', 'embryonic development/birth phenotype', 'lateral plate mesoderm phenotype', 'endo-epithelium', 'preauricular skin tag', 'behavior', 'number of cell phenotype', 'protein binding', 'neural tube morphology phenotype', 'localization', 'organ physiology phenotype', 'nervous system physiology phenotype', 'decreased size of the forelimb bone', 'forebrain phenotype', 'Abnormal cardiac septum morphology', 'Abnormal speech pattern', 'autopod region', 'endochondral bone phenotype', 'increased biological_process', 'opening of the anatomical entity', 'behavior process phenotype', 'small intestinal bleeding; small intestine hemorrhage', 'appendage', 'cardiac atrium phenotype', 'Abnormality of mental function', 'molecular_function phenotype', 'forelimb zeugopod bone morphology phenotype', 'cell', 'molecular_function', 'decreased qualitatively biological_process in central nervous system', 'Abnormal cardiovascular system morphology', 'binding phenotype', 'alimentary part of gastrointestinal system morphology phenotype', 'speech pattern; vocalization', 'Hyperpigmentation of the skin', 'endochondral bone', 'respiratory system', 'bodily fluid phenotype', 'manual digit 2 plus metapodial segment', 'Neurodevelopmental delay', 'Abnormal nervous system physiology', 'Abnormality of globe size', 'Vesicoureteral reflux', 'multicellular organismal process phenotype', 'camera-type eye phenotype', 'increased response to stress in lung', 'biological_process in digestive tract phenotype', 'multicellular organismal process', 'Abnormality of the anterior pituitary', 'binding', 'organ', 'cardiogenic splanchnic mesoderm morphology phenotype', 'Aplasia/Hypoplasia of the thumb', 'regional part of brain', 'Abnormality of skin pigmentation', 'Abnormal nervous system morphology', 'entity', 'regional part of brain phenotype', 'regulation of gene expression', 'subdivision of organism along main body axis phenotype', 'anatomical entity physiology phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'Abnormality of the outer ear', 'mesoderm-derived structure physiology phenotype', 'decreased hormone transport', 'absent anatomical entity', 'central nervous system phenotype', 'pituitary gland phenotype', 'pectoral appendage bud', 'gland of diencephalon', 'radius bone phenotype', 'endocrine gland', 'regional part of nervous system', 'anatomical conduit', 'incomplete closing of the cardiac septum', 'occurrent', 'incomplete closing of the anatomical conduit', 'brain morphology phenotype', 'Hypopituitarism', 'telencephalon', 'craniocervical region phenotype', 'compound organ phenotype', 'establishment of localization phenotype', 'decreased qualitatively regulation of hormone levels', 'programmed DNA elimination', 'manual digit', 'skull morphology phenotype', 'hematopoietic cell', 'brain phenotype', 'localised male reproductive organ', 'endocrine gland physiology phenotype', 'decreased qualitatively multicellular organism development', 'biological regulation phenotype', 'decreased size of the sense organ', 'negative regulation of biosynthetic process', 'late embryo', 'brain', 'multicellular organism development phenotype', 'anatomical system phenotype', 'anatomical entity morphology phenotype', 'Atrial septal defect', 'decreased number of material anatomical entity in the bone element', 'decreased qualitatively peptide transport', 'Abnormal cardiac atrium morphology', 'ectoderm morphology phenotype', 'renal system phenotype', 'pigmentation phenotype', 'neurectoderm', 'catalytic activity phenotype', 'export from cell', 'decreased growth hormone secretion', 'negative regulation of biological process', 'decreased cellular process', 'heart', 'decreased establishment of localization', 'closing of the subdivision of digestive tract', 'glandular system', 'bone marrow cell', 'decreased length of digit 1 or 5', 'developing anatomical structure', 'Abnormality of the respiratory system', 'phenotypic effect', 'embryo development rate phenotype', 'amide transport phenotype', 'vasculature phenotype', 'Abnormality of limbs', 'anatomical conduit phenotype', 'simple eye', 'organism subdivision', 'hormone secretion', 'Abnormality of the endocrine system', 'reproductive structure', 'circulatory system phenotype', 'organ part phenotype', 'absent anatomical structure in the limb', 'incomplete closing of the material anatomical entity', 'lung morphology phenotype', 'signal release phenotype', 'erythroid lineage cell morphology phenotype', 'middle ear', 'lateral plate mesoderm morphology phenotype', 'skeleton of limb', 'organ system subdivision phenotype', 'Aplasia/hypoplasia involving bones of the extremities', 'decreased size of the organ', 'Abnormality of the vertebral column', 'decreased qualitatively secretion by cell', 'immature eye', 'closing of the material anatomical entity', 'migrating mesenchyme population phenotype', 'bone marrow cell phenotype', 'number of bone marrow cell phenotype', 'cardiac septum', 'independent continuant', 'regulation of hormone levels', 'proximo-distal subdivision of respiratory tract phenotype', 'material anatomical entity physiology phenotype', 'blood island', 'cell communication', 'diencephalon', 'paired limb/fin skeleton phenotype', 'decreased secretion', 'process', 'multicellular anatomical structure', 'Abnormal umbilical cord blood vessel morphology', 'dysesthesia; hyperalgesia', 'root', 'regulation of biological quality', 'aplasia or hypoplasia of skeleton', 'endocrine system phenotype', 'heart morphology phenotype', 'Abnormal ear morphology', 'duodenum morphology phenotype', 'ureter phenotype', 'face morphology phenotype', 'ecto-epithelium phenotype', 'autopodial extension', 'Short long bone', 'organism subdivision phenotype', 'main body axis', 'Abnormality of the hypothalamus-pituitary axis', 'decreased length of endochondral element', 'forelimb bud morphology phenotype', 'decreased qualitatively biological regulation', 'anatomical entity phenotype', 'subdivision of skeleton', 'sclerotome phenotype', 'Abnormal axial skeleton morphology', 'face phenotype', 'decreased qualitatively localization', 'blastula', 'Abnormality of the gastrointestinal tract', 'cardiogenic splanchnic mesoderm', 'skeletal system phenotype', 'Growth delay', 'nervous system morphology phenotype', 'future nervous system', 'decreased number of material anatomical entity in the multicellular organism', 'forelimb bud', 'lateral structure phenotype', 'forelimb', 'trunk phenotype', 'biological regulation', 'genitourinary system phenotype', 'peptide secretion phenotype', 'feeding behavior', 'delayed biological_process', 'decreased qualitatively hormone secretion', 'subdivision of organism along appendicular axis', 'regulation of metabolic process', 'decreased height of the anatomical entity', 'Syndactyly', 'entire sense organ system', 'decreased qualitatively hormone transport', 'digit 1 plus metapodial segment', 'Abnormal small intestine morphology', 'immune system phenotype', 'immune system physiology phenotype', 'Eumetazoa', 'Anterior hypopituitarism', 'anterior lateral plate mesoderm', 'Abnormal endocrine physiology', 'future central nervous system', 'embryo', 'defense response', 'Localized skin lesion', 'arm bone', 'upper limb segment', 'incomplete closing of the interatrial septum', 'craniocervical region', 'decreased transport', 'regulation of biological quality phenotype', 'integument phenotype', 'anlage', 'sense organ', 'cellular process', 'increased inflammatory response', 'polyhydramnios', 'Sacral dimple', 'transport', 'negative regulation of gene expression', 'decreased regulation of hormone levels', 'dorsal region element', 'biological_process rate phenotype', 'peptide hormone secretion', 'heart phenotype', 'pre-chordal neural plate phenotype', 'leukocyte morphology phenotype', 'material anatomical entity atresia', 'heart tube phenotype', 'Opisthokonta', 'germ layer / neural crest', 'embryo morphology phenotype', 'foregut phenotype', 'decreased qualitatively establishment of localization', 'decreased qualitatively export from cell', 'decreased vibrational conductance of sound to the inner ear', 'ocular adnexa physiology phenotype', 'tube', 'digitopodium region', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'decreased number of anatomical structure in the multicellular organism', 'decreased qualitatively transport', 'gonad', 'fused sacrum phenotype', 'decreased qualitatively amide transport', 'consumption behavior phenotype', 'pituitary gland morphology phenotype', 'reproductive organ', 'anatomical entity', 'embryonic structure', 'multicellular anatomical structure phenotype', 'behavior process', 'Aplasia/Hypoplasia affecting the eye', 'amide transport', 'embryonic tissue phenotype', 'eyelid phenotype', 'continuant', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'eukaryotic cell', 'germ layer', 'decreased qualitatively system process', 'growth hormone secretion phenotype', 'Growth abnormality', 'germ layer morphology phenotype', 'endocrine system physiology phenotype', 'subdivision of organism along main body axis', 'neural plate', 'decreased secretion by cell', 'posteriorly rotated ears', 'localization phenotype', 'cardiovascular system', 'Abnormal brain morphology', 'decreased number of leukocyte in the blood', 'bone element phenotype', 'decreased size of the subdivision of organism along main body axis', 'digit phenotype', 'Abnormality of body height', 'localised abdominal segment element', 'reproductive system morphology phenotype', 'gland phenotype', 'Aplasia/hypoplasia of the extremities', 'decreased qualitatively nitrogen compound transport', 'Abnormal external genitalia morphology', 'anatomical entity morphology in the heart phenotype', 'mesoderm-derived structure', 'forelimb skeleton', 'trunk', 'anlage phenotype', 'Failure to thrive', 'multi organ part structure', 'arterial blood vessel phenotype', 'organism substance phenotype', 'cellular organisms', 'Short finger', 'Decreased head circumference', 'development of anatomical entity phenotype', 'reproductive structure phenotype', 'material anatomical entity', 'pituitary gland', 'decreased biological regulation', 'epithelial tube', 'decreased length of digit', 'decreased peptide hormone secretion', 'cardiogenic plate morphology phenotype', 'Abnormal forebrain morphology', 'anatomical system', 'forebrain morphology phenotype', 'secretion by cell phenotype', 'material anatomical entity phenotype', 'decreased regulation of biological quality', 'bodily fluid', 'decreased sensory perception', 'septum', 'long bone phenotype', 'motile cell', 'Abnormal heart morphology', 'epithelium phenotype', 'sacral region of vertebral column', 'aplasia or hypoplasia of manual digit 1', 'eye primordium phenotype', 'presumptive structure phenotype', 'skeletal element phenotype', 'cavitated compound organ physiology phenotype', 'endocrine system', 'sensory system phenotype', 'decreased length of endochondral bone', 'structure with developmental contribution from neural crest physiology phenotype', 'cellular process phenotype', 'gastrula', 'Abnormality of the eye', 'forelimb zeugopod bone phenotype', 'hypothalamus-pituitary axis', 'gonad phenotype', 'digit 1 or 5 phenotype', 'epithelial vesicle phenotype', 'taxon specific phenotype', 'export from cell phenotype', 'tissue', 'absent material anatomical entity', 'trunk bone', 'diencephalon morphology phenotype', 'anatomical structure phenotype', 'dense mesenchyme tissue phenotype', 'presumptive ectoderm', 'lower respiratory tract', 'endoderm-derived structure', 'hematopoietic system', 'abdominal segment bone', 'Single umbilical artery', 'Phenotypic abnormality', 'feeding behavior phenotype', 'anatomical structure', 'cavitated compound organ phenotype', 'gland morphology phenotype', 'paraxial mesoderm', 'Abnormal bone marrow cell morphology', 'ectoderm-derived structure phenotype', 'integumental system', 'subdivision of trunk phenotype', 'mesoderm', 'cardiogenic plate', 'neural tube', 'epithelium', 'eye', 'sense organ phenotype', 'decreased size of the arm bone', 'Abnormal language feature', 'decreased export from cell', 'gland', 'integument', 'circulatory organ phenotype', 'peptide secretion', 'size of multicellular organism phenotype', 'mesenchyme', 'digestive tract', 'decreased size of the anatomical entity', 'endocrine gland morphology phenotype', 'biological_process rate in brain phenotype', 'decreased hormone secretion', 'Abnormal vascular morphology', 'hormone transport', 'pelvic region element phenotype', 'decreased biological_process in pituitary gland', 'adenohypophysis', 'anatomical entity length phenotype', 'blood', 'decreased size of the limb bone', 'germ layer phenotype', 'behavior phenotype', 'anterior neural tube phenotype', 'Metazoa', 'absent manual digit', 'adenohypophysis phenotype', 'central nervous system', 'non-connected functional system', 'reproductive system phenotype', 'decreased biological_process in brain', 'embryonic tissue', 'reproductive gland', 'alimentary part of gastrointestinal system', 'eyelid physiology phenotype', 'endoderm phenotype', 'body proper', 'male reproductive organ phenotype', 'decreased localization', 'arm', 'mesoderm phenotype', 'regulation of metabolic process phenotype', 'female reproductive system', 'respiratory system morphology', 'phenotype', 'metabolic process phenotype', 'decreased biological_process', 'central nervous system morphology phenotype', 'structure with developmental contribution from neural crest', 'sensory system', 'embryo development', 'axial skeleton plus cranial skeleton morphology phenotype', 'head morphology phenotype', 'hypothalamus-pituitary axis phenotype', 'biological_process phenotype', 'pectoral appendage skeleton phenotype', 'ectoderm-derived structure', 'incomplete closing of the blood vessel', 'reproductive system', 'cardiogenic splanchnic mesoderm phenotype', 'respiratory system phenotype', 'nervous system', 'subdivision of digestive tract phenotype', 'ductus arteriosus', 'system process phenotype', 'circulatory system', 'nervous system phenotype', 'irregular bone phenotype', 'platelet', 'limb bud phenotype', 'eyeball of camera-type eye phenotype', 'Hypoplasia of the radius', 'nitrogen compound transport phenotype', 'structure with developmental contribution from neural crest phenotype', 'secretion', 'dense mesenchyme tissue', 'proximo-distal subdivision of respiratory tract', 'unilaminar epithelium', 'Decreased response to growth hormone stimulation test', 'decreased system process', 'incomplete closing of the septum', 'pectoral complex', 'decreased length of forelimb bone', 'decreased qualitatively regulation of biological quality', 'subdivision of skeletal system', 'biological_process in nervous system phenotype', 'rotated anatomical entity', 'decreased secretion in pituitary gland', 'musculoskeletal system', 'number of leukocyte phenotype', 'Abnormality of the urinary system', 'Abnormal pituitary gland morphology', 'epithelial tube phenotype', 'simple eye physiology phenotype', 'Abnormal morphology of the radius', 'heart vasculature', 'decreased peptide secretion', 'reproductive organ phenotype', 'Eukaryota', 'gland of diencephalon phenotype', 'decreased biological_process in multicellular organism', 'vision/eye phenotype', 'sclerotome', 'ectoderm', 'decreased nitrogen compound transport', 'skull phenotype', 'anterior neural tube', 'Abnormality of the bladder', 'external ear', 'head phenotype', 'endochondral element', 'regulation of biological process phenotype', 'growth hormone secretion', 'septum phenotype', 'Decreased anatomical entity mass', 'decreased activity of parathyroid; hypoparathyroidism', 'diencephalon phenotype', 'decreased qualitatively secretion', 'foregut epithelium', 'Abnormality of the nervous system', 'anatomical structure development phenotype', 'interatrial septum morphology phenotype', 'face', 'Morphological central nervous system abnormality', 'eyelid', 'establishment of localization', 'Duodenal atresia', 'head', 'trunk mesenchyme phenotype', 'anatomical structure physiology phenotype', 'decreased length of material anatomical entity', 'neural plate morphology phenotype', 'embryonic structure phenotype', 'endocrine gland phenotype', 'aplasia or hypoplasia of anatomical entity', 'musculoskeletal system phenotype', 'visual system phenotype', 'organ system subdivision', 'Macule', 'heart primordium', 'Bone marrow hypocellularity', 'neural tube phenotype', 'ecto-epithelium', 'bone cell', 'lateral structure physiology phenotype', 'manual digit 1', 'blood phenotype', 'platelet phenotype', 'decreased qualitatively cellular process', 'bone of appendage girdle complex', 'limb segment phenotype', 'endochondral element phenotype', 'foregut morphology phenotype', 'abdomen element phenotype', 'surface structure phenotype', 'All', 'decreased size of the digit', 'thoracic cavity element phenotype', 'multicellular organism development', 'Aplasia/hypoplasia involving the skeleton', 'anatomical entity morphology in the manus phenotype', 'Abnormal communication', 'respiratory tract', 'regulation of macromolecule biosynthetic process phenotype', 'ureter physiology phenotype', 'autopodial extension phenotype', 'external ear hypoplasia', 'closing of the anatomical system', 'pectoral appendage bud phenotype', 'autopodial skeleton', 'macromolecule biosynthetic process phenotype', 'decreased length of anatomical entity', 'decreased size of the autopodial extension', 'primary heart field phenotype', 'manus morphology phenotype', 'Abnormality of the genital system', 'Abnormality of the musculoskeletal system', 'Short thumb', 'testis', 'paired limb/fin bud phenotype', 'decreased size of the bone element', 'decreased length of organism subdivision', 'paired limb/fin phenotype', 'autopod region phenotype', 'interatrial septum', 'ear phenotype', 'pelvic region of trunk', 'paired limb/fin bud', 'decreased anatomical structure mass', 'digit plus metapodial segment', 'paired limb/fin segment', 'bone of appendage girdle complex phenotype', 'decreased qualitatively signal release', 'Abnormality of the ear', 'neurectoderm phenotype', 'ear', 'limb morphology phenotype', 'Abnormality of limb bone', 'Abnormal finger morphology', 'pectoral appendage phenotype', 'optic cup', 'embryo development phenotype', 'number of anatomical enitites of type anatomical structure phenotype', 'digit 1 phenotype', 'decreased amide transport', 'anatomical collection phenotype', 'decreased qualitatively biological_process', 'musculature of body', 'normal growth on benomyl', 'number of anatomical enitites of type organism subdivision phenotype', 'Cafe-au-lait spot', 'segment of autopod', 'decreased length of manual digit', 'Abnormal hand morphology', 'decreased size of the organism subdivision', 'extraembryonic structure', 'acropodium region', 'decreased length of manual digit 1 or 5', 'digit morphology phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'manus', 'embryonic autopod plate morphology phenotype', 'decreased length of manual digit 1', 'erythroid lineage cell', 'limb bud morphology phenotype', 'manual digit 1 morphology phenotype', 'decreased size of the material anatomical entity', 'Abnormalities of placenta or umbilical cord', 'incomplete closing of the arterial blood vessel', 'sense organ physiology phenotype', 'surface structure', 'mesoderm morphology phenotype', 'craniocervical region morphology phenotype', 'musculature', 'subdivision of tube phenotype', 'limb endochondral element', 'skeleton of limb phenotype', 'fused manual digit 2 and manual digit 3', 'forelimb bud phenotype', 'decreased length of multicellular anatomical structure', 'anatomical collection', 'protein binding phenotype', 'increased qualitatively biological_process in digestive tract', 'skeletal system morphology phenotype', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'fused sacrum morphology phenotype', 'macromolecule metabolic process phenotype', 'Abnormal digit morphology', 'transport phenotype', 'aplasia or hypoplasia of manual digit', 'paired limb/fin segment phenotype', 'Abnormal limb bone morphology', 'cerebral hemisphere morphology phenotype', 'embryonic autopod plate', 'ureter', 'extraembryonic structure phenotype', 'limb', 'pectoral appendage', 'appendicular skeletal system', 'regional part of nervous system phenotype', 'blood vessel morphology phenotype', 'segment of manus', 'external male genitalia', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'limb phenotype', 'skeleton phenotype', 'skeleton', 'respiratory system morphology phenotype', 'appendage girdle complex', 'incomplete closing of the anatomical entity', 'subdivision of skeletal system phenotype', 'manual digitopodium region', 'decreased size of the skeletal element', 'autopod region morphology phenotype', 'Abnormal forearm bone morphology', 'regulation of cellular process phenotype', 'peptide transport', 'Abnormal atrial septum morphology', 'Abnormal appendicular skeleton morphology', 'camera-type eye', 'bone of free limb or fin', 'decreased size of the anatomical structure in the pectoral complex', 'appendicular skeleton phenotype', 'leukocyte', 'digit 1', 'musculature phenotype', 'manual digit phenotype', 'arterial system', 'cavitated compound organ', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'decreased size of the anatomical entity in the pectoral complex', 'regulation of macromolecule biosynthetic process', 'Abnormality of the hand', 'nitrogen compound transport', 'Abnormal skeletal morphology', 'decreased size of the material anatomical entity in the pectoral complex', 'orbital region', 'limb skeleton subdivision', 'blood vessel', 'limb skeleton subdivision phenotype', 'appendicular skeleton', 'cranial skeletal system', 'homeostatic process', 'macromolecule metabolic process', 'biosynthetic process', 'vesicoureteral reflux', 'negative regulation of macromolecule metabolic process phenotype', 'Abnormal cellular phenotype', 'musculature of body phenotype', 'negative regulation of macromolecule metabolic process', 'decreased length of anatomical structure', 'Abnormality of chromosome stability', 'gene expression phenotype', 'Abnormality of metabolism/homeostasis', 'Abnormality of the ureter', 'gene expression', 'regulation of biosynthetic process', 'regulation of macromolecule metabolic process', 'regulation of macromolecule metabolic process phenotype', 'programmed DNA elimination by chromosome breakage', 'regulation of gene expression phenotype', 'biosynthetic process phenotype', 'great vessel of heart morphology phenotype', 'negative regulation of cellular process', 'material anatomical entity mass phenotype', 'decreased length of bone of appendage girdle complex', 'Abnormality of the head', 'negative regulation of cellular process phenotype', 'external soft tissue zone phenotype', 'negative regulation of macromolecule biosynthetic process', 'sac physiology phenotype', 'limb segment', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'paired limb/fin', 'negative regulation of metabolic process phenotype', 'Chromosomal breakage induced by crosslinking agents', 'homeostatic process phenotype', 'Abnormality of prenatal development or birth', 'Abnormal cellular physiology', 'decreased number of anatomical entity in the bone element', 'negative regulation of biological process phenotype', 'organ part', 'decreased multicellular anatomical structure mass', 'Decreased multicellular organism mass', 'intestine atresia', 'Abnormality of skull size', 'multicellular organism mass phenotype', 'anatomical entity mass phenotype', 'Abnormal long bone morphology', 'aplastic manual digit 1', 'Abnormality of body weight', 'somite phenotype', 'Aplasia/Hypoplasia of fingers', 'Decreased body weight', 'multicellular anatomical structure mass phenotype', 'decreased growth', 'material anatomical entity morphology in the heart phenotype', 'inflammatory response', 'decreased qualitatively growth', 'limb endochondral element phenotype', 'Abnormality of the immune system', 'germ layer / neural crest phenotype', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'absent material anatomical entity in the limb', 'excretory tube phenotype', 'absent material anatomical entity in the forelimb', 'delayed growth', 'absent organism subdivision in the multicellular organism', 'alimentary part of gastrointestinal system atresia', 'abdominal segment element physiology phenotype', 'anatomical cluster phenotype', 'absent anatomical structure in the multicellular organism', 'ocular adnexa phenotype', 'absent digit', 'agenesis of anatomical entity', 'craniofacial/craniocervical phenotype', 'Abnormal eye morphology', 'absent organism subdivision', 'heart blood vessel', 'umbilical blood vessel morphology phenotype', 'number of hematopoietic cell phenotype', 'absent multicellular anatomical structure in the forelimb', 'absent anatomical entity in the limb bud', 'digit 2 plus metapodial segment', 'respiration organ', 'embryonic cardiovascular system', 'Absent thumb', 'Abnormality of the lower urinary tract', 'decreased number of anatomical entity in the blood', 'absent multicellular anatomical structure in the multicellular organism', 'embryonic tissue morphology phenotype', 'absent anatomical entity in the multicellular organism', 'Upper limb undergrowth', 'absent multicellular anatomical structure in the limb', 'spatial pattern of anatomical entity phenotype', 'absent anatomical structure in the forelimb', 'absent multicellular anatomical structure', 'Finger aplasia', 'number of anatomical enitites of type anatomical entity phenotype', 'absent anatomical structure', 'Aplasia/Hypoplasia involving the central nervous system', 'vessel', 'telencephalon phenotype', 'Abnormal fetal morphology', 'Aplasia/Hypoplasia of the cerebrum', 'Pneumonia', 'regulation of biosynthetic process phenotype', 'Microcephaly', 'Abnormal cerebral morphology', 'axial skeletal system', 'decreased length of digit 1', 'postcranial axial skeletal system', 'skull', 'cell condensation phenotype', 'decreased size of the head', 'mesenchyme phenotype', 'size of head phenotype', 'axial skeleton plus cranial skeleton', 'decreased number of anatomical structure in the bone element', 'shape of external ear phenotype', 'fused anatomical entity and manual digit 3', 'anatomical entity hypoplasia', 'signaling', 'vestibulo-auditory system', 'drinking behavior phenotype', 'paired limb/fin skeleton', 'haemolymphatic fluid', 'shape of anatomical entity phenotype', 'Functional abnormality of the bladder', 'mesenchyme morphology phenotype', 'shape of continuant phenotype', 'disconnected anatomical group', 'Aplasia/Hypoplasia of the external ear', 'vestibulo-auditory system phenotype', 'renal system', 'external ear phenotype', 'aplasia or hypoplasia of external ear', 'pre-chordal neural plate', 'intestine phenotype', 'aplasia or hypoplasia of ear', 'umbilical blood vessel phenotype', 'Abnormal pinna morphology', 'skin of body phenotype', 'manus phenotype', 'Aplasia/Hypoplasia of the ear', 'blood vessel phenotype', 'viscus', 'urinary bladder phenotype', 'renal system physiology phenotype', 'anatomical structure development', 'Abnormality of the integument', 'anatomical entity morphology in the appendage girdle complex phenotype', 'abdominal segment element phenotype', 'bladder organ phenotype', 'external ear morphology phenotype', 'location of external ear phenotype', 'sac phenotype', 'subdivision of tube', 'respiration organ phenotype', 'Abnormality of the genitourinary system', 'multicellular organism', 'kidney physiology phenotype', 'abdominal segment element', 'optic vesicle', 'serotonin secreting cell', 'cheek phenotype', 'kidney', 'cerebral hemisphere', 'upper limb segment phenotype', 'trunk region element physiology phenotype', 'excretory tube', 'urinary bladder', 'bladder organ', 'organism substance', 'renal pelvis/ureter', 'developing anatomical structure phenotype', 'abdomen', 'location of anatomical entity phenotype', 'bladder organ physiology phenotype', 'location of ear phenotype', 'skin of body morphology phenotype', 'Abnormality of the upper urinary tract', 'secretory cell', 'compound organ physiology phenotype', 'genitourinary system', 'pelvic region element', 'abdomen element', 'abdomen element physiology phenotype', 'multi-limb segment region', 'developmental process', 'sac', 'fused sacrum', 'excretory system', 'anatomical cluster', 'upper urinary tract', 'manual digit 1 or 5', 'upper urinary tract phenotype', 'kidney phenotype', 'localised kidney', 'lower urinary tract', 'Abnormality of immune system physiology', 'abdominal segment of trunk', 'blood vasculature', 'skeleton of pectoral complex', 'vessel phenotype', 'Fetal anomaly', 'vasculature', 'Abnormality of the umbilical cord', 'late embryo phenotype', 'entire extraembryonic component', 'umbilical blood vessel', 'conceptus', 'middle ear phenotype', 'vascular system', 'Fetal ultrasound soft marker', 'signal release', 'umbilical cord', 'Abnormal fetal cardiovascular morphology', 'fused manual digit 2 and anatomical entity', 'tissue phenotype', 'Short stature', 'anatomical entity height phenotype', 'limb long bone', 'decreased size of the multicellular organism', 'decreased material anatomical entity mass', 'decreased height of the multicellular organism', 'number of platelet phenotype', 'limb bud', 'platelet morphology', 'Abnormal platelet count', 'ear physiology phenotype', 'increased inflammatory response in lung', 'defense response phenotype', 'regulation of cellular process', 'small intestine', 'subdivision of skeleton phenotype', 'blood cell phenotype', 'Thrombocytopenia', 'limb long bone morphology phenotype', 'myeloid cell', 'postcranial axial skeleton', 'blood cell', 'cerebral amyloid angiopathy', 'decreased signal release', 'Abnormality of thrombocytes', 'Abnormal platelet morphology', 'meso-epithelium', 'anucleate cell', 'biogenic amine secreting cell', 'duodenum atresia', 'decreased number of myeloid cell', 'decreased number of hematopoietic cell', 'number of myeloid cell phenotype', 'reproductive gland phenotype', 'digestive tract epithelium phenotype', 'response to stimulus', 'presumptive structure', 'endoderm of foregut', 'endoderm-derived structure phenotype', 'digestive system element', 'splanchnic layer of lateral plate mesoderm', 'material entity', 'absent material anatomical entity in the limb bud', 'respiratory airway', 'Abnormality of blood and blood-forming tissues', 'decreased number of bone marrow cell', 'Abnormal lung morphology', 'parathyroid gland physiology phenotype', 'increased qualitatively biological_process', 'intestine', 'foregut', 'alimentary part of gastrointestinal system phenotype', 'abdominal segment bone phenotype', 'increased response to stimulus in lung', 'respiratory system physiology phenotype', 'lung', 'male organism phenotype', 'endoderm of foregut phenotype', 'response to stress phenotype', 'endoderm morphology phenotype', 'decreased peptide transport', 'Respiratory tract infection', 'Increased inflammatory response', 'negative regulation of metabolic process', 'Abnormal leukocyte morphology', 'Abnormal ureter physiology', 'Abnormal respiratory system morphology', 'forelimb long bone', 'Abnormal inflammatory response', 'Abnormal intestine morphology', 'anatomical system physiology phenotype', 'parathyroid gland', 'Abnormality of the amniotic fluid', 'digestive system', 'digestive tract epithelium', 'intestine morphology phenotype', 'irregular bone', 'increased response to stimulus', 'digestive system element phenotype', 'sensory perception of mechanical stimulus phenotype', 'increased qualitatively inflammatory response', 'subdivision of vertebral column phenotype', 'increased qualitatively response to stimulus', 'cell phenotype', 'increased biological_process in lung', 'gland physiology phenotype', 'pair of lungs', 'skin of body', 'size of anatomical entity phenotype', 'Abnormal response to endocrine stimulation test', 'endoderm', 'response to stress', 'parathyroid gland phenotype', 'lung phenotype', 'inflammatory response phenotype', 'digestive system morphology phenotype', 'Chromosome breakage', 'endo-epithelium phenotype', 'renal/urinary system phenotype', 'foregut epithelium phenotype', 'Abnormal leukocyte count', 'zeugopodial skeleton', 'number of anatomical entities of type anatomical entity in blood phenotype', 'nucleate cell', 'Abnormal immune system morphology', 'biological_process', 'immune system morphology phenotype', 'presomitic mesoderm phenotype', 'Abnormal skin morphology', 'radius endochondral element', 'pigmentation', 'testis morphology phenotype', 'tube phenotype', 'organ phenotype', 'integumental system phenotype', 'Hypermelanotic macule', 'increased pigmentation in skin of body', 'presumptive ectoderm phenotype', 'increased pigmentation', 'increased biological_process in skin of body', 'growth', 'subdivision of organism along appendicular axis phenotype', 'Abnormality of the skin', 'Limb undergrowth', 'Specific learning disability', 'trunk bone phenotype', 'Cutaneous syndactyly', 'cardiac atrium', 'Sacrococcygeal pilonidal abnormality', 'decreased number of leukocyte', 'postcranial axial skeleton phenotype'], 'has_descendant': ['MONDO:0011325'], 'has_descendant_label': ['Fanconi anemia complementation group F'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0044325', 'category': 'biolink:Disease', 'name': 'Fanconi anemia, complementation group W', 'xref': ['DOID:0060978', 'MEDGEN:1621245', 'OMIM:617784', 'UMLS:C4521564'], 'synonym': ['FANCW', 'Fanconi anemia, complementation group W'], 'exact_synonym': ['Fanconi anemia, complementation group W'], 'related_synonym': ['FANCW'], 'subsets': ['gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0002518', 'HP:0002247', 'HP:0001510', 'HP:0000252', 'HP:0001748', 'HP:0009777', 'HP:0000089', 'HP:0001511', 'HP:0000824', 'HP:0002308', 'HP:0002863', 'HP:0002984', 'HP:0410049', 'HP:0011800', 'HP:0031689', 'HP:0002119'], 'has_phenotype_label': ['Renal hypoplasia', 'Ventriculomegaly', 'Hypoplasia of the radius', 'Myelodysplasia', 'Duodenal atresia', 'Megakaryocyte dysplasia', 'obsolete Abnormal radial ray morphology', 'Decreased response to growth hormone stimulation test', 'Polysplenia', 'Chiari malformation', 'Midface retrusion', 'Absent thumb', 'Intrauterine growth retardation', 'Growth delay', 'Abnormal periventricular white matter morphology', 'Microcephaly'], 'has_phenotype_count': 16, 'has_phenotype_closure': ['UPHENO:0001072', 'UPHENO:0002987', 'UPHENO:0001360', 'UPHENO:0005230', 'UPHENO:0088047', 'UPHENO:0001440', 'UBERON:0004923', 'UPHENO:0005029', 'UPHENO:0001340', 'UPHENO:0001134', 'CL:0002092', 'UBERON:0002371', 'CL:0001035', 'UPHENO:0001303', 'UPHENO:0086172', 'CL:0000000', 'UPHENO:0088145', 'CL:0000255', 'HP:0002244', 'UPHENO:0074335', 'UPHENO:0074229', 'HP:0002242', 'UPHENO:0002725', 'UBERON:0004921', 'HP:0011100', 'UPHENO:0074311', 'UPHENO:0074237', 'CL:0000556', 'UPHENO:0002546', 'UPHENO:0074228', 'UBERON:0013765', 'UPHENO:0002994', 'HP:0002246', 'UPHENO:0074330', 'UPHENO:0063562', 'UBERON:0000160', 'UPHENO:0002988', 'UPHENO:0063586', 'UPHENO:0063594', 'UPHENO:0076803', 'UPHENO:0063575', 'UPHENO:0086621', 'UPHENO:0063569', 'UBERON:0001555', 'UBERON:0002108', 'HP:0011024', 'UBERON:0001895', 'UPHENO:0075948', 'UBERON:0004732', 'UPHENO:0086932', 'UBERON:0005409', 'UPHENO:0071317', 'UPHENO:0003237', 'HP:0002308', 'UBERON:0004733', 'UBERON:0002028', 'UPHENO:0004518', 'UPHENO:0071315', 'UPHENO:0071344', 'HP:0002438', 'GO:0048856', 'GO:0007275', 'GO:0032501', 'UPHENO:0050068', 'UPHENO:0052160', 'UPHENO:0049966', 'UPHENO:0080382', 'UPHENO:0050034', 'HP:0002589', 'UPHENO:0005642', 'UPHENO:0080393', 'UPHENO:0081436', 'HP:0001172', 'UBERON:0002544', 'UBERON:5002389', 'UPHENO:0025587', 'UPHENO:0009020', 'UBERON:0006048', 'UPHENO:0081451', 'UPHENO:0026108', 'UPHENO:0026640', 'UPHENO:0086700', 'UPHENO:0002765', 'UPHENO:0084761', 'UPHENO:0063639', 'UPHENO:0025507', 'UBERON:0001442', 'HP:0009777', 'UPHENO:0026078', 'HP:0005927', 'UPHENO:0003069', 'HP:0001155', 'UBERON:0012354', 'UBERON:0005451', 'UBERON:0001463', 'UBERON:5001463', 'UPHENO:0011825', 'UPHENO:0009146', 'UBERON:0006717', 'UPHENO:0026643', 'UPHENO:0027017', 'UPHENO:0009163', 'UPHENO:0080099', 'UPHENO:0087006', 'UPHENO:0008548', 'UBERON:5002544', 'UPHENO:0080114', 'UPHENO:0002905', 'UPHENO:0026146', 'UPHENO:0026181', 'UPHENO:0026506', 'UPHENO:0002733', 'UPHENO:0084448', 'UBERON:0019231', 'UPHENO:0008523', 'UPHENO:0002708', 'HP:0001507', 'UPHENO:0000543', 'GO:0040007', 'UPHENO:0076735', 'UPHENO:0000541', 'UPHENO:0049874', 'HP:0000240', 'HP:0009121', 'UPHENO:0069352', 'UPHENO:0081598', 'HP:0002977', 'UBERON:0002090', 'UPHENO:0081594', 'UPHENO:0081566', 'UPHENO:0001004', 'HP:0000252', 'UPHENO:0005573', 'UPHENO:0069236', 'UPHENO:0075148', 'UPHENO:0003459', 'UBERON:0011138', 'UPHENO:0075804', 'UPHENO:0084771', 'HP:0040195', 'UBERON:0010130', 'UPHENO:0056047', 'UPHENO:0002661', 'UPHENO:0011558', 'UPHENO:0011498', 'HP:0001317', 'UPHENO:0011572', 'UBERON:0004535', 'UPHENO:0075774', 'UPHENO:0011931', 'UPHENO:0014335', 'UBERON:0017672', 'UPHENO:0056077', 'UBERON:0003061', 'UBERON:0001007', 'UBERON:0002465', 'UPHENO:0087267', 'UPHENO:0063629', 'UBERON:0000477', 'HP:0001748', 'UPHENO:0087123', 'UPHENO:0014291', 'UPHENO:0056134', 'UPHENO:0026757', 'HP:0002715', 'HP:0025408', 'UPHENO:9002003', 'UPHENO:0011531', 'UPHENO:0056059', 'UPHENO:0076790', 'UPHENO:0002833', 'UPHENO:0011609', 'UBERON:0005944', 'UPHENO:0014347', 'UPHENO:0011533', 'UPHENO:0004004', 'UPHENO:0014351', 'UBERON:0012140', 'UPHENO:0014244', 'HP:0002012', 'UPHENO:0003952', 'UPHENO:0014240', 'HP:0025031', 'HP:0001743', 'UPHENO:0087339', 'UPHENO:0002634', 'UBERON:0002075', 'UBERON:0002106', 'UBERON:0001009', 'UPHENO:0014287', 'UPHENO:0002576', 'UBERON:0011215', 'UBERON:0005162', 'UPHENO:0002841', 'UPHENO:0003030', 'HP:0002500', 'UBERON:0011299', 'UPHENO:0002874', 'UPHENO:0074051', 'UBERON:0007798', 'UPHENO:0089366', 'UBERON:0002437', 'UPHENO:0074038', 'UPHENO:0081562', 'UPHENO:0001355', 'UPHENO:0074028', 'UPHENO:0076799', 'UPHENO:0073886', 'HP:0002060', 'UBERON:0001869', 'UBERON:0000955', 'UPHENO:0005506', 'UPHENO:0002570', 'HP:0010993', 'UPHENO:0005427', 'UBERON:0000025', 'UPHENO:0077889', 'UPHENO:0004885', 'HP:0002597', 'HP:0000001', 'UPHENO:0002548', 'UPHENO:0052354', 'UBERON:0000033', 'UBERON:0001474', 'UPHENO:0003001', 'UPHENO:0004523', 'UBERON:0005281', 'UPHENO:0004680', 'GO:0009790', 'UBERON:0013702', 'UPHENO:0002736', 'UBERON:0003129', 'UBERON:0000924', 'UPHENO:0052778', 'UPHENO:0046540', 'HP:0000271', 'HP:0011800', 'UPHENO:0087363', 'UPHENO:0087849', 'UPHENO:0076702', 'GO:0007154', 'UPHENO:0083952', 'UPHENO:0004519', 'UBERON:0000479', 'GO:0008150', 'UPHENO:0046445', 'UPHENO:0081581', 'UPHENO:0008668', 'UPHENO:0080126', 'UPHENO:0002976', 'UPHENO:0069266', 'UPHENO:0081601', 'HP:0000864', 'UPHENO:0002632', 'UPHENO:0005611', 'UBERON:0001894', 'UPHENO:0002593', 'HP:0031073', 'UBERON:0003080', 'NCBITaxon:1', 'UPHENO:0052678', 'HP:0009821', 'UBERON:0003937', 'UPHENO:0076740', 'UPHENO:0082875', 'UPHENO:0004173', 'UPHENO:0050581', 'HP:0000924', 'UPHENO:0068838', 'UPHENO:0002531', 'UPHENO:0086679', 'UBERON:0002389', 'UPHENO:0052178', 'UPHENO:0073898', 'UPHENO:0087660', 'UPHENO:0076783', 'UPHENO:0004507', 'UPHENO:0004484', 'UPHENO:0069292', 'UPHENO:0002747', 'HP:0009380', 'UPHENO:0050121', 'UPHENO:0076692', 'UBERON:0002114', 'GO:0032502', 'UPHENO:0003004', 'UBERON:0001423', 'UPHENO:0005441', 'UBERON:0001440', 'UBERON:0004092', 'HP:0012718', 'HP:0006501', 'UPHENO:0076724', 'UPHENO:0087585', 'UPHENO:0005504', 'UBERON:0000064', 'UPHENO:0052518', 'UBERON:0000475', 'UPHENO:0087347', 'UBERON:0005881', 'UPHENO:0005477', 'UPHENO:0012274', 'UPHENO:0004475', 'UPHENO:0076805', 'UPHENO:0052245', 'UPHENO:0005141', 'UBERON:0005057', 'UBERON:0034925', 'UPHENO:0053121', 'UPHENO:0087472', 'UPHENO:0080588', 'UPHENO:0088065', 'UBERON:0004086', 'UPHENO:0002668', 'HP:0001871', 'UPHENO:0063565', 'UPHENO:0003163', 'HP:0002119', 'HP:0005922', 'UPHENO:0081204', 'UBERON:0002530', 'UBERON:0015061', 'HP:0000234', 'UBERON:0000481', 'UPHENO:0026010', 'UPHENO:0081313', 'UPHENO:0004521', 'UPHENO:0074245', 'UPHENO:0087089', 'UPHENO:0002944', 'UPHENO:0002909', 'HP:0005561', 'GO:0009987', 'UBERON:0005291', 'UPHENO:0063563', 'UPHENO:0005552', 'UBERON:0005423', 'UPHENO:0088123', 'UPHENO:0087516', 'UPHENO:0063615', 'UPHENO:0076697', 'BFO:0000003', 'UPHENO:0046392', 'UPHENO:0005571', 'HP:0002817', 'HP:0011747', 'UPHENO:0076723', 'HP:0002973', 'UBERON:0003607', 'UPHENO:0050014', 'UPHENO:0005590', 'UPHENO:0002267', 'UPHENO:0080220', 'UPHENO:0011559', 'UBERON:0004177', 'UPHENO:0011566', 'UPHENO:0003366', 'UPHENO:0071310', 'UBERON:0000454', 'UPHENO:0005652', 'UPHENO:0077890', 'UPHENO:0005647', 'UPHENO:0005540', 'HP:0009601', 'UPHENO:0046483', 'UPHENO:0005433', 'HP:0009799', 'UPHENO:0087547', 'UPHENO:0076791', 'HP:0000077', 'UPHENO:0052226', 'UPHENO:0002754', 'UBERON:0000062', 'UPHENO:0005434', 'UPHENO:0075772', 'UPHENO:0078743', 'UPHENO:0046484', 'UPHENO:3000003', 'HP:0000118', 'UPHENO:0005470', 'UPHENO:0002529', 'UBERON:0002529', 'UPHENO:0005534', 'HP:0040075', 'UPHENO:0002844', 'HP:0000830', 'UPHENO:0002523', 'UPHENO:0083951', 'UPHENO:0071339', 'UBERON:0002196', 'UPHENO:0002579', 'UPHENO:0049691', 'UBERON:0003104', 'UPHENO:0009382', 'UPHENO:0002678', 'UPHENO:0002873', 'UPHENO:0087902', 'UPHENO:0004618', 'UBERON:0019221', 'UPHENO:0087661', 'UPHENO:0076812', 'UPHENO:0014319', 'UPHENO:0074054', 'UPHENO:0050065', 'HP:0004377', 'UPHENO:0069064', 'UPHENO:0049647', 'UBERON:0002616', 'UPHENO:0001001', 'UBERON:0003947', 'HP:0031072', 'UPHENO:0002538', 'UBERON:0001016', 'UPHENO:0026183', 'UBERON:0002193', 'UPHENO:0014322', 'UPHENO:0081628', 'UBERON:0000061', 'UPHENO:0087376', 'UPHENO:0002764', 'HP:0009826', 'UBERON:0000483', 'UPHENO:0011536', 'UBERON:0019261', 'UPHENO:0049724', 'UBERON:0010363', 'NCBITaxon:6072', 'UPHENO:0004788', 'UBERON:0001893', 'UPHENO:0080377', 'UBERON:0005172', 'UPHENO:0081435', 'UPHENO:0001002', 'UPHENO:0005285', 'BFO:0000001', 'UBERON:0015204', 'GO:0140352', 'UPHENO:0004956', 'UPHENO:0003087', 'UPHENO:0014285', 'UPHENO:0087518', 'HP:0031689', 'UPHENO:0005597', 'UBERON:0002050', 'GO:0032940', 'UPHENO:0002525', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0087665', 'UPHENO:0002541', 'UPHENO:0003432', 'UBERON:0002470', 'UPHENO:0001003', 'UPHENO:0005120', 'UBERON:0010323', 'HP:0006503', 'UPHENO:0080187', 'UBERON:0006598', 'HP:0012210', 'UPHENO:0075220', 'BFO:0000015', 'UPHENO:0050108', 'BFO:0000004', 'UBERON:0004734', 'HP:0002984', 'HP:0011283', 'UPHENO:0002568', 'UPHENO:0080079', 'UPHENO:0087940', 'UBERON:0016879', 'HP:0002011', 'UBERON:0000465', 'UPHENO:0002983', 'UBERON:0004120', 'UPHENO:0063558', 'UBERON:0006558', 'UPHENO:0002621', 'UPHENO:0086956', 'UPHENO:0002834', 'UBERON:0000383', 'UPHENO:0077887', 'UBERON:0000468', 'UPHENO:0003025', 'UPHENO:0002859', 'UBERON:0011137', 'UPHENO:0003177', 'UPHENO:0068898', 'UBERON:0000949', 'HP:0011793', 'UBERON:0001049', 'HP:0002664', 'GO:0051179', 'UPHENO:0004459', 'UBERON:0001460', 'UBERON:0004089', 'UPHENO:0003334', 'UPHENO:0002530', 'UPHENO:3000000', 'UPHENO:0073937', 'UBERON:0002368', 'HP:0000089', 'UBERON:0034923', 'UBERON:0000926', 'UPHENO:0046538', 'UBERON:0000307', 'HP:0001510', 'UPHENO:0053013', 'UPHENO:0049829', 'UPHENO:0002963', 'CL:0000763', 'UPHENO:0086485', 'HP:0001511', 'UBERON:0002405', 'UBERON:0015203', 'HP:0100763', 'HP:0011844', 'HP:0000707', 'UBERON:0003466', 'GO:0006810', 'HP:0002247', 'UPHENO:0053274', 'UBERON:0005358', 'UBERON:0013522', 'UPHENO:0075995', 'UPHENO:0074036', 'BFO:0000040', 'UPHENO:0081466', 'UPHENO:0009209', 'UPHENO:0081091', 'UPHENO:0002536', 'UPHENO:0004621', 'GO:0046879', 'UBERON:0007811', 'UPHENO:0003186', 'UPHENO:0052694', 'UBERON:0000990', 'UPHENO:0002559', 'UPHENO:0002902', 'GO:0030252', 'UPHENO:0074037', 'UPHENO:0002685', 'HP:0001167', 'UPHENO:0005458', 'UPHENO:0003236', 'UBERON:0000075', 'GO:0002790', 'UPHENO:0004888', 'HP:0009815', 'UBERON:0001015', 'HP:0001626', 'UPHENO:0050064', 'HP:0000119', 'UBERON:0002101', 'UPHENO:0005570', 'UPHENO:0014332', 'UPHENO:0083689', 'HP:0000929', 'HP:0000818', 'UPHENO:0002750', 'NCBITaxon:33208', 'UPHENO:0003799', 'UPHENO:0087907', 'UPHENO:0052867', 'UPHENO:0002870', 'UBERON:0003133', 'UPHENO:0005542', 'UPHENO:0049871', 'UPHENO:0079872', 'UPHENO:0002808', 'UBERON:0000922', 'HP:0002863', 'UPHENO:0005055', 'UPHENO:0001147', 'UPHENO:0003116', 'UPHENO:0012440', 'UPHENO:0004047', 'UBERON:0002346', 'UPHENO:0052714', 'HP:0012143', 'UBERON:0003606', 'GO:0023052', 'UPHENO:0075998', 'UBERON:0003544', 'UPHENO:0086769', 'UPHENO:0003016', 'UPHENO:0002928', 'UBERON:0001062', 'GO:0010817', 'UPHENO:0086735', 'NCBITaxon:33154', 'UPHENO:0002553', 'UPHENO:0002564', 'UBERON:0003914', 'HP:0012639', 'UPHENO:0002819', 'NCBITaxon:2759', 'UBERON:0010314', 'HP:0012503', 'UBERON:0012139', 'UBERON:0003056', 'UPHENO:0004900', 'UPHENO:0002567', 'UPHENO:0003055', 'UPHENO:0053355', 'HP:0040068', 'UBERON:0006601', 'UPHENO:0075175', 'GO:0030072', 'UPHENO:0002554', 'UBERON:0016880', 'GO:0007267', 'UPHENO:0052180', 'UPHENO:0068932', 'UBERON:0000153', 'UBERON:0002049', 'NCBITaxon:131567', 'UPHENO:0003082', 'UBERON:0010000', 'UPHENO:0049813', 'UPHENO:0073978', 'UBERON:0010316', 'UPHENO:0049890', 'UPHENO:0002746', 'UBERON:0001890', 'UBERON:0004121', 'UBERON:0003075', 'HP:0040064', 'UPHENO:0002949', 'GO:0050789', 'UPHENO:0005596', 'UBERON:0003296', 'GO:0065008', 'GO:0071705', 'GO:0042886', 'HP:0045060', 'UPHENO:0002659', 'UBERON:0005282', 'HP:0002818', 'UBERON:0003057', 'GO:0009914', 'HP:0011282', 'UPHENO:0002967', 'HP:0006496', 'UPHENO:0002577', 'UBERON:0002386', 'UBERON:0004375', 'UPHENO:0002648', 'UPHENO:0003936', 'UBERON:0003103', 'UPHENO:0012308', 'UPHENO:0003065', 'UBERON:0002204', 'UPHENO:0046397', 'HP:0003026', 'UPHENO:0076703', 'UBERON:0002102', 'UBERON:0005417', 'UPHENO:0049587', 'UPHENO:0068839', 'HP:0025033', 'UBERON:0000063', 'HP:0000824', 'UPHENO:0002969', 'UPHENO:0003413', 'UPHENO:0087501', 'HP:0010935', 'UPHENO:0052937', 'HP:0012443', 'UPHENO:0084763', 'UPHENO:0050106', 'UPHENO:0080325', 'UPHENO:0012312', 'UPHENO:0002731', 'UPHENO:0002896', 'HP:0000152', 'UPHENO:0046460', 'UPHENO:0074310', 'UPHENO:0002880', 'UPHENO:0002830', 'UPHENO:0069328', 'UBERON:0010708', 'BFO:0000002', 'UBERON:0005419', 'UBERON:0011249', 'UBERON:0005177', 'UBERON:0004710', 'UBERON:0012475', 'UBERON:0003460', 'UPHENO:0002861', 'UPHENO:0086546', 'HP:0033127', 'UPHENO:0002738', 'UPHENO:0011670', 'UBERON:0011676', 'UBERON:0001434', 'UPHENO:0004466', 'UPHENO:0069327', 'UBERON:0004357', 'UPHENO:0004476', 'UBERON:0002091', 'UBERON:0000026', 'UBERON:8450002', 'UBERON:5006048', 'HP:0040072', 'UPHENO:0069030', 'UPHENO:0002945', 'UPHENO:0003095', 'UPHENO:0087510', 'UPHENO:0002637', 'UBERON:0011582', 'UPHENO:0071335', 'UBERON:0010912', 'UPHENO:0005426', 'UPHENO:0002926', 'UPHENO:0004892', 'UPHENO:0076957', 'UPHENO:0003049', 'UPHENO:0069062', 'UBERON:0015212', 'UPHENO:0071325', 'UPHENO:0069047', 'UBERON:0011584', 'UPHENO:0003227', 'GO:0051234', 'HP:0011314', 'UBERON:0000060', 'UPHENO:0076718', 'UPHENO:0069149', 'UBERON:0011143', 'UPHENO:0075944', 'UPHENO:0005030', 'UPHENO:0004909', 'UPHENO:0052554', 'UPHENO:0046465', 'UPHENO:0088186', 'UPHENO:0025585', 'UBERON:0003081', 'UPHENO:0049733', 'UPHENO:0068971', 'UBERON:0010740', 'HP:0011297', 'UBERON:0002513', 'UPHENO:0068912', 'UPHENO:0003094', 'UPHENO:0003415', 'UPHENO:0087663', 'UPHENO:0003088', 'UPHENO:0086635', 'UPHENO:0004802', 'UBERON:0010758', 'UPHENO:0068848', 'UBERON:0004765', 'UPHENO:0005602', 'UBERON:0006058', 'HP:0002813', 'UPHENO:0053234', 'UBERON:0013701', 'UBERON:0008962', 'UBERON:0000007', 'UBERON:0015001', 'HP:0002118', 'HP:0011842', 'UPHENO:0076754', 'UPHENO:0053456', 'UPHENO:0052715', 'UPHENO:0069194', 'UPHENO:0002650', 'HP:0009824', 'UPHENO:0002600', 'HP:0040070', 'UBERON:0010703', 'UBERON:0002471', 'UPHENO:0014302', 'GO:0065007', 'UBERON:0008785', 'UBERON:0000073', 'UPHENO:0002594', 'UPHENO:0002816', 'UBERON:0001017', 'UPHENO:0003514', 'UBERON:0000489', 'UBERON:0010538', 'UPHENO:0003050', 'UPHENO:0086633', 'UPHENO:0046479', 'HP:0002518', 'UPHENO:0004595', 'UPHENO:0025509', 'UPHENO:0046594', 'UPHENO:0069046', 'UPHENO:0079876', 'UPHENO:0069125', 'UBERON:0007272', 'UBERON:0001456', 'HP:0007364', 'UBERON:0004381', 'UBERON:0002495', 'UPHENO:0002792', 'GO:0015833', 'UPHENO:0003812', 'UPHENO:0046554', 'UPHENO:0076720', 'UPHENO:0046505', 'UBERON:0003076', 'UPHENO:0005214', 'UPHENO:0002948', 'UBERON:0002390', 'UPHENO:0046396', 'UBERON:0002037', 'UBERON:0004111', 'UPHENO:0002542', 'UPHENO:0049894', 'UPHENO:0075902', 'UPHENO:0076727', 'UPHENO:0002751', 'UBERON:0012141', 'UPHENO:0049927', 'UPHENO:0069163', 'UBERON:0010707', 'UBERON:0010712', 'UPHENO:0046455', 'GO:0023061', 'UBERON:0010741', 'UBERON:0002428', 'UPHENO:0003207', 'UBERON:0002316', 'UPHENO:0003159', 'UBERON:0015021', 'UBERON:0011216', 'UBERON:0004347', 'UPHENO:0002719', 'UPHENO:0080200', 'UPHENO:0002586', 'HP:0410049', 'UBERON:0002398', 'UBERON:0004708', 'UPHENO:0046405', 'UPHENO:0014333', 'UPHENO:0002785', 'UPHENO:0002526', 'UPHENO:0002964', 'UPHENO:0053330', 'HP:0009115', 'UPHENO:0046531', 'UPHENO:0046552', 'UBERON:0007524', 'UPHENO:0003181', 'HP:0006265', 'UPHENO:0046403', 'UPHENO:0002571', 'RO:0002577', 'UPHENO:0003005', 'UBERON:0000923', 'UPHENO:0081786', 'UBERON:0001444', 'UBERON:0004288', 'GO:0046903', 'HP:0000309', 'UBERON:0004122', 'UPHENO:0086589', 'UPHENO:0003460', 'UPHENO:0002910', 'UBERON:0003102', 'UPHENO:0081227', 'HP:0008678', 'UPHENO:0087349', 'UBERON:0005173', 'UPHENO:0087531', 'UPHENO:0081210', 'UPHENO:0002782', 'UPHENO:0002803', 'UBERON:0002113', 'UBERON:0005156', 'UBERON:0009569', 'UPHENO:3000004', 'UBERON:0000916', 'UPHENO:0002596', 'UPHENO:0002832', 'UPHENO:0003093', 'UPHENO:0004615', 'HP:0000079', 'UPHENO:0076779', 'UBERON:0001008', 'UBERON:0002417', 'UPHENO:0004704', 'UBERON:0010371', 'UBERON:0002100', 'UPHENO:0087427', 'UPHENO:0002642', 'CL:0000988', 'UPHENO:0075195', 'HP:0100547', 'HP:0002352'], 'has_phenotype_closure_label': ['ventricle of nervous system', 'increased size of the brain ventricle', 'increased size of the material anatomical entity', 'anatomical wall', 'organ component layer', 'increased size of the organ component layer', 'brain ventricle/choroid plexus', 'organ component layer phenotype', 'increased size of the brain ventricle/choroid plexus', 'brain ventricle/choroid plexus phenotype', 'increased size of the organ part', 'increased size of the anatomical structure', 'brain ventricle phenotype', 'eukaryotic cell', 'cell', 'Abnormal bone marrow cell morphology', 'myeloid cell', 'digestive system morphology phenotype', 'small intestine morphology phenotype', 'closing of the anatomical system', 'subdivision of digestive tract atresia', 'digestive system element phenotype', 'closing of the anatomical entity', 'closing of the multicellular anatomical structure', 'intestine morphology phenotype', 'closing of the subdivision of tube', 'material anatomical entity atresia', 'ventricular system of central nervous system', 'subdivision of tube', 'Duodenal atresia', 'intestine atresia', 'Abnormal digestive system morphology', 'intestine phenotype', 'anatomical entity atresia', 'small intestine', 'small intestine phenotype', 'intestine', 'duodenum', 'digestive system element', 'duodenum morphology phenotype', 'alimentary part of gastrointestinal system atresia', 'anatomical system atresia', 'anatomical entity morphology in the alimentary part of gastrointestinal system phenotype', 'closing of the anatomical structure', 'segmental subdivision of nervous system', 'formed cerebellum', 'segmental subdivision of nervous system phenotype', 'chordal neural plate', 'Abnormal cerebellum morphology', 'hindbrain phenotype', 'formed multi-tissue structure', 'metencephalon', 'organ subunit', 'formed multicellular anatomical structure', 'chordal neural plate phenotype', 'metencephalon morphology phenotype', 'Abnormal hindbrain morphology', 'cerebellum', 'Cerebellar malformation', 'segmental subdivision of hindbrain phenotype', 'posterior neural tube phenotype', 'cerebellum phenotype', 'decreased qualitatively anatomical structure development', 'multicellular organism development phenotype', 'Abnormal intestine morphology', 'anatomical structure development', 'Intrauterine growth retardation', 'multicellular organism development', 'decreased developmental process', 'anatomical structure development phenotype', 'decreased multicellular organism development', 'decreased qualitatively developmental process', 'decreased multicellular organismal process', 'embryo development phenotype', 'decreased anatomical structure development', 'decreased embryo development', 'embryo development', 'embryonic autopod plate', 'Abnormality of the hand', 'developmental process phenotype', 'digit', 'Aplasia/Hypoplasia of fingers', 'absent anatomical structure', 'Finger aplasia', 'autopod region morphology phenotype', 'manual digitopodium region', 'absent multicellular anatomical structure', 'segment of manus', 'bone cell', 'manual digit 1', 'Abnormal digit morphology', 'manual digit morphology in the manus phenotype', 'absent anatomical structure in the forelimb', 'absent anatomical entity in the multicellular organism', 'absent multicellular anatomical structure in the multicellular organism', 'manual digit 1 morphology phenotype', 'Absent thumb', 'embryonic autopod plate morphology phenotype', 'digit morphology phenotype', 'digit 1 or 5 phenotype', 'Abnormal hand morphology', 'segment of autopod', 'digit 1 phenotype', 'absent material anatomical entity in the limb bud', 'absent anatomical entity in the limb bud', 'digit plus metapodial segment', 'absent organism subdivision', 'manus phenotype', 'autopodial skeleton', 'autopodial extension phenotype', 'anatomical entity morphology in the manus phenotype', 'absent digit', 'aplastic manual digit 1', 'absent anatomical structure in the multicellular organism', 'absent organism subdivision in the multicellular organism', 'absent material anatomical entity in the forelimb', 'Growth delay', 'digit 1', 'delayed growth', 'growth', 'Growth abnormality', 'closing of the material anatomical entity', 'postcranial axial skeleton', 'axial skeleton plus cranial skeleton', 'Intestinal atresia', 'size of head phenotype', 'developmental process rate phenotype', 'growth phenotype', 'size of skull phenotype', 'alimentary part of gastrointestinal system morphology phenotype', 'skull phenotype', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'decreased size of the head', 'skull', 'postcranial axial skeletal system', 'axial skeletal system', 'Abnormality of skull size', 'Microcephaly', 'Aplasia/Hypoplasia of the cerebrum', 'brain ventricle morphology phenotype', 'decreased size of the organism subdivision', 'axial skeleton plus cranial skeleton morphology phenotype', 'Abnormal skull morphology', 'hematopoietic cell', 'skull morphology phenotype', 'Aplasia/Hypoplasia involving the central nervous system', 'immune system morphology phenotype', 'increased number of material anatomical entity in the abdomen', 'increased number of anatomical structure', 'blood island phenotype', 'bone marrow', 'Abnormality of the digestive system', 'Abnormality of the spleen', 'number of anatomical enitites of type organ phenotype', 'spleen morphology phenotype', 'number of anatomical enitites of type abdomen element phenotype', 'increased number of organ', 'Megakaryocyte dysplasia', 'cardiovascular system', 'increased number of multicellular anatomical structure in the abdomen', 'absent multicellular anatomical structure in the forelimb', 'abdominal viscera phenotype', 'number of anatomical enitites of type hemopoietic organ phenotype', 'increased number of abdominal viscera', 'increased number of viscus', 'increased number of anatomical structure in the abdomen', 'viscus phenotype', 'digestive system', 'Chiari malformation', 'aplasia or hypoplasia of manual digit', 'lymphoid system', 'anatomical cluster', 'lymphatic part of lymphoid system', 'autopod region', 'circulatory system', 'vascular system', 'hemopoietic organ phenotype', 'number of anatomical enitites of type anatomical structure phenotype', 'Abnormality of the cardiovascular system', 'increased number of immune organ', 'viscus', 'increased number of trunk region element', 'spleen', 'decreased qualitatively multicellular organism development', 'immune organ', 'increased number of abdominal segment element', 'number of anatomical enitites of type immune organ phenotype', 'Abnormality of the vasculature', 'cell phenotype', 'Abnormality of the lymphatic system', 'number of anatomical enitites of type material anatomical entity phenotype', 'increased number of spleen', 'spleen phenotype', 'increased number of anatomical entity', 'number of anatomical enitites of type anatomical entity phenotype', 'lymphatic part of lymphoid system phenotype', 'number of anatomical enitites of type viscus phenotype', 'Polysplenia', 'Abnormality of the immune system', 'vasculature', 'Abnormal spleen morphology', 'absent material anatomical entity in the limb', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'brain white matter morphology phenotype', 'absent multicellular anatomical structure in the limb', 'white matter of telencephalon', 'alimentary part of gastrointestinal system phenotype', 'cerebral hemisphere white matter phenotype', 'material anatomical entity degeneration', 'brain white matter', 'white matter phenotype', 'white matter of forebrain degeneration', 'central nervous system cell part cluster degeneration', 'anatomical entity degeneration', 'Abnormal cerebral morphology', 'central nervous system cell part cluster', 'white matter of telencephalon degeneration', 'anatomical entity morphology in the brain phenotype', 'telencephalon phenotype', 'multi cell part structure degeneration', 'brain white matter phenotype', 'increased size of the multicellular anatomical structure', 'multi cell part structure phenotype', 'anatomical entity degeneration in central nervous system', 'organ system subdivision', 'musculoskeletal system phenotype', 'aplasia or hypoplasia of anatomical entity', 'endocrine gland phenotype', 'neural plate morphology phenotype', 'ectoderm', 'reproductive gland morphology phenotype', 'paired limb/fin segment', 'Morphological central nervous system abnormality', 'increased number of material anatomical entity', 'face', 'Abnormality of the nervous system', 'decreased qualitatively secretion', 'diencephalon phenotype', 'midface', 'growth hormone secretion', 'head phenotype', 'anterior neural tube', 'anterior neural tube phenotype', 'abdominal segment element phenotype', 'gland of diencephalon phenotype', 'Eukaryota', 'reproductive organ phenotype', 'segmental subdivision of hindbrain', 'biological_process in nervous system phenotype', 'decreased qualitatively regulation of biological quality', 'endochondral bone', 'increased number of hemopoietic organ', 'decreased length of long bone', 'secretion', 'decreased peptide transport', 'size of brain ventricle phenotype', 'structure with developmental contribution from neural crest phenotype', 'nitrogen compound transport phenotype', 'nervous system phenotype', 'peptide transport phenotype', 'neoplasm phenotype', 'subdivision of digestive tract phenotype', 'nervous system', 'reproductive system', 'absent material anatomical entity in the multicellular organism', 'digit 1 or 5', 'biological_process in central nervous system phenotype', 'ectoderm-derived structure', 'duodenum phenotype', 'increased number of abdomen element', 'hypothalamus-pituitary axis phenotype', 'head morphology phenotype', 'structure with developmental contribution from neural crest', 'megakaryocyte', 'decreased biological_process', 'phenotype', 'nitrogen compound transport', 'skeleton of pectoral complex', 'organ part atresia', 'body proper', 'decreased length of bone of pectoral complex', 'embryonic tissue', 'reproductive system phenotype', 'Aplasia/hypoplasia involving the skeleton', 'non-connected functional system', 'forelimb long bone', 'central nervous system', 'absent manual digit', 'Metazoa', 'limb phenotype', 'Abnormality of the upper urinary tract', 'germ layer phenotype', 'cardiovascular system phenotype', 'telencephalon morphology phenotype', 'secretion by cell', 'embryonic structure phenotype', 'decreased hormone secretion', 'biological_process rate in brain phenotype', 'gastrula morphology phenotype', 'closing of the subdivision of digestive tract', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'endocrine gland morphology phenotype', 'decreased size of the anatomical entity', 'digestive tract', 'mesenchyme', 'peptide secretion', 'appendicular skeleton phenotype', 'epithelium', 'gland morphology phenotype', 'forebrain phenotype', 'radius endochondral element', 'diencephalon morphology phenotype', 'reproductive structure phenotype', 'pituitary gland', 'material anatomical entity', 'Abnormal nervous system morphology', 'material anatomical entity phenotype', 'Abnormal finger morphology', 'pectoral appendage phenotype', 'secretion by cell phenotype', 'forebrain morphology phenotype', 'absent anatomical structure in the limb', 'circulatory system phenotype', 'organ part phenotype', 'anatomical system', 'duodenum atresia', 'epithelial tube phenotype', 'musculoskeletal system', 'Ventriculomegaly', 'cerebral hemisphere white matter', 'decreased size of the anatomical entity in the pectoral complex', 'decreased regulation of biological quality', 'number of anatomical enitites of type trunk region element phenotype', 'pre-chordal neural plate phenotype', 'organ', 'absent anatomical entity', 'decreased hormone transport', 'gland of diencephalon', 'appendicular skeletal system', 'brain', 'endocrine gland', 'root', 'neural tube phenotype', 'establishment of localization', 'head', 'subdivision of organism along main body axis phenotype', 'forelimb zeugopod bone hypoplasia', 'decreased regulation of hormone levels', 'cell-cell signaling', 'hemopoietic organ', 'Abnormal pituitary gland morphology', 'arm bone', 'biological regulation', 'decreased length of bone element', 'pectoral complex', 'craniocervical region', 'cellular process', 'Decreased response to growth hormone stimulation test', 'decreased size of the endochondral element', 'Abnormal renal morphology', 'decreased signal release', 'delayed biological_process', 'signaling', 'excretory system', 'Abnormal metencephalon morphology', 'peptide transport', 'absent anatomical entity in the forelimb', 'forebrain', 'limb segment', 'Abnormality of limb bone', 'multicellular organism', 'increased number of anatomical entity in the abdomen', 'nervous system morphology phenotype', 'decreased size of the forelimb bone', 'decreased length of skeletal element', 'number of anatomical enitites of type abdominal segment element phenotype', 'embryonic tissue phenotype', 'endocrine system', 'hemolymphoid system', 'decreased qualitatively multicellular organismal process', 'axial skeleton plus cranial skeleton phenotype', 'neural plate phenotype', 'regulation of biological quality phenotype', 'decreased transport', 'abdominal segment of trunk', 'Short long bone', 'pituitary gland morphology phenotype', 'decreased qualitatively amide transport', 'decreased qualitatively transport', 'embryo phenotype', 'manual digit 1 or 5', 'organ phenotype', 'subdivision of organism along appendicular axis phenotype', 'acropodium region', 'neural tube', 'subdivision of trunk phenotype', 'anatomical entity morphology phenotype', 'anatomical system phenotype', 'zeugopod', 'germ layer', 'digestive system phenotype', 'Hematological neoplasm', 'multicellular organism morphology phenotype', 'continuant', 'epithelium phenotype', 'closing of the organ part', 'entity', 'Abnormal duodenum morphology', 'decreased qualitatively establishment of localization', 'Abnormal response to endocrine stimulation test', 'presumptive ectoderm', 'dense mesenchyme tissue phenotype', 'Phenotypic abnormality', 'hematopoietic system', 'limb skeleton subdivision', 'embryonic structure', 'anatomical entity', 'amide transport', 'multicellular anatomical structure phenotype', 'hematopoietic system morphology phenotype', 'decreased qualitatively signal release', 'bone of appendage girdle complex phenotype', 'independent continuant', 'regulation of hormone levels', 'decreased size of the material anatomical entity in the pectoral complex', 'skeletal system phenotype', 'blastula', 'ecto-epithelium', 'Neoplasm by anatomical site', 'decreased qualitatively localization', 'pre-chordal neural plate', 'subdivision of tube phenotype', 'musculature', 'endocrine system morphology phenotype', 'adenohypophysis', 'gland phenotype', 'mesoderm phenotype', 'posterior neural tube', 'Aplasia/Hypoplasia of the thumb', 'hemopoietic organ morphology phenotype', 'Renal hypoplasia', 'Abnormality of blood and blood-forming tissues', 'subdivision of digestive tract', 'developing anatomical structure phenotype', 'development of anatomical entity phenotype', 'Myelodysplasia', 'Neoplasm', 'anatomical entity hypoplasia in face', 'decreased secretion by cell', 'cerebral hemisphere white matter morphology phenotype', 'neural plate', 'paired limb/fin bud', 'limb endochondral element', 'germ layer / neural crest', 'paired limb/fin bud phenotype', 'material entity', 'hormone secretion', 'decreased cellular process', 'Abnormal thumb morphology', 'forelimb zeugopod morphology phenotype', 'embryo development rate phenotype', 'phenotypic effect', 'developing anatomical structure', 'glandular system', 'decreased establishment of localization', 'decreased amide transport', 'growth hormone secretion phenotype', 'Abnormality of the face', 'multicellular organism phenotype', 'limb bud', 'anatomical structure phenotype', 'transport phenotype', 'regional part of brain phenotype', 'hormone transport', 'Opisthokonta', 'embryo morphology phenotype', 'aplasia or hypoplasia of radius bone', 'formed regional part of nervous system', 'signal release phenotype', 'reproductive gland phenotype', 'organism subdivision', 'Abnormality of the endocrine system', 'reproductive structure', 'Abnormality of the gastrointestinal tract', 'Abnormal brain morphology', 'hematopoietic system phenotype', 'Abnormal gastrointestinal tract morphology', 'regulation of biological process', 'secretion phenotype', 'Abnormality of the skeletal system', 'Abnormal axial skeleton morphology', 'subdivision of skeleton', 'decreased qualitatively biological regulation', 'manual digit phenotype', 'cavitated compound organ', 'aplasia or hypoplasia of manual digit 1', 'decreased qualitatively hormone secretion', 'anatomical entity phenotype', 'peptide secretion phenotype', 'Supernumerary spleens', 'zeugopodial skeleton', 'cerebral hemisphere', 'kidney', 'localization phenotype', 'decreased qualitatively export from cell', 'decreased length of endochondral bone', 'reproductive system morphology phenotype', 'digit phenotype', 'bone element phenotype', 'presumptive ectoderm phenotype', 'decreased qualitatively nitrogen compound transport', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'neural tube morphology phenotype', 'bone of pectoral complex morphology phenotype', 'decreased size of the anatomical structure in the pectoral complex', 'Decreased head circumference', 'tissue phenotype', 'Forearm undergrowth', 'cellular organisms', 'trunk', 'gland', 'decreased biological_process in brain', 'white matter', 'decreased length of forelimb bone', 'digitopodium region', 'cranial skeletal system phenotype', 'tube', 'epithelial tube', 'Midface retrusion', 'decreased biological regulation', 'taxon specific phenotype', 'cellular process phenotype', 'Abnormal cerebral ventricle morphology', 'endocrine system phenotype', 'organism subdivision phenotype', 'autopodial extension', 'ecto-epithelium phenotype', 'face morphology phenotype', 'skeletal element phenotype', 'presumptive structure phenotype', 'skeleton', 'multicellular organismal process phenotype', 'gastrula', 'export from cell phenotype', 'radius bone phenotype', 'Abnormal small intestine morphology', 'Abnormal endocrine physiology', 'embryo', 'hindbrain', 'multicellular organismal process', 'Abnormality of the anterior pituitary', 'tube phenotype', 'germ layer / neural crest phenotype', 'Aplasia/Hypoplasia of the radius', 'multi-tissue structure phenotype', 'multicellular anatomical structure', 'process', 'skeleton phenotype', 'presumptive structure', 'genitourinary system phenotype', 'diencephalon', 'subdivision of skeleton phenotype', 'central nervous system phenotype', 'pectoral appendage bud', 'pituitary gland phenotype', 'lateral structure phenotype', 'Abnormal megakaryocyte morphology', 'material anatomical entity physiology phenotype', 'anatomical wall phenotype', 'decreased qualitatively secretion by cell', 'increased size of the anatomical entity', 'organ system subdivision phenotype', 'lateral plate mesoderm morphology phenotype', 'decreased size of the organ', 'brain morphology phenotype', 'anatomical conduit phenotype', 'Abnormality of limbs', 'vasculature phenotype', 'amide transport phenotype', 'upper limb segment phenotype', 'establishment of localization phenotype', 'craniocervical region phenotype', 'compound organ phenotype', 'decreased growth hormone secretion', 'export from cell', 'bone of free limb or fin', 'Abnormal limb bone morphology', 'neurectoderm', 'main body axis', 'upper urinary tract phenotype', 'size of anatomical entity phenotype', 'organ part', 'decreased qualitatively peptide transport', 'decreased length of forelimb endochondral element', 'formed material anatomical entity', 'brain phenotype', 'neurectoderm phenotype', 'appendage', 'telencephalon', 'Hypopituitarism', 'decreased size of the arm bone', 'decreased length of endochondral element', 'mesoderm-derived structure phenotype', 'increased size of the ventricle of nervous system', 'bone of appendage girdle complex', 'decreased size of the forelimb zeugopod bone', 'trunk region element phenotype', 'disconnected anatomical group', 'multi-tissue structure', 'anatomical conduit', 'regional part of nervous system', 'decreased qualitatively regulation of hormone levels', 'anatomical entity length phenotype', 'decreased biological_process in pituitary gland', 'embryonic tissue morphology phenotype', 'decreased qualitatively cellular process', 'Eumetazoa', 'Anterior hypopituitarism', 'decreased secretion in pituitary gland', 'decreased peptide secretion', 'biological regulation phenotype', 'ventricle of nervous system phenotype', 'future nervous system', 'future central nervous system', 'regional part of brain', 'appendicular skeleton morphology phenotype', 'appendage phenotype', 'anatomical entity hypoplasia', 'peptide hormone secretion', 'biological_process rate phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'biological_process', 'multi-limb segment region phenotype', 'limb bone morphology phenotype', 'immune organ phenotype', 'zeugopod phenotype', 'Aplasia/hypoplasia involving bones of the extremities', 'mesoderm morphology phenotype', 'decreased size of the multicellular anatomical structure', 'absent material anatomical entity', 'tissue', 'decreased length of bone of appendage girdle complex', 'obsolete Abnormal radial ray morphology', 'paired limb/fin skeleton phenotype', 'bone of free limb or fin phenotype', 'limb long bone', 'long bone morphology phenotype', 'digit 1 plus metapodial segment', 'decreased qualitatively hormone transport', 'decreased size of the limb endochondral element', 'localization', 'forelimb zeugopod bone phenotype', 'limb bud phenotype', 'absent autopodial extension', 'lateral plate mesoderm', 'surface structure phenotype', 'decreased size of the bone of pectoral complex', 'abdomen', 'forelimb phenotype', 'signal release', 'Abnormal forearm morphology', 'system', 'limb bone phenotype', 'Aplasia/hypoplasia involving bones of the upper limbs', 'hindbrain morphology phenotype', 'radius bone hypoplasia', 'musculature of body phenotype', 'pectoral appendage bud phenotype', 'autopod region phenotype', 'decreased size of the bone of free limb or fin', 'decreased length of organ', 'decreased length of anatomical entity', 'forelimb morphology phenotype', 'mesenchyme morphology phenotype', 'forelimb bone phenotype', 'aplastic anatomical entity', 'pectoral appendage skeleton', 'white matter degeneration', 'decreased nitrogen compound transport', 'long bone phenotype', 'number of anatomical enitites of type organism subdivision phenotype', 'musculature of body', 'Limb undergrowth', 'central nervous system morphology phenotype', 'decreased size of the forelimb endochondral element', 'paired limb/fin phenotype', 'manus morphology phenotype', 'Abnormality of the musculoskeletal system', 'radius bone morphology phenotype', 'limb', 'midface morphology phenotype', 'metencephalon phenotype', 'mesoderm-derived structure', 'forelimb skeleton', 'radius bone', 'Abnormal upper limb bone morphology', 'bone of pectoral complex phenotype', 'musculature phenotype', 'immune system', 'Leukoencephalopathy', 'forelimb bud morphology phenotype', 'lateral plate mesoderm phenotype', 'limb endochondral element phenotype', 'forelimb zeugopod phenotype', 'Abnormality of the hypothalamus-pituitary axis', 'Upper limb undergrowth', 'decreased length of limb bone', 'skeletal element', 'Abnormality of the upper limb', 'decreased biological_process in multicellular organism', 'paired limb/fin skeleton', 'forelimb zeugopod bone', 'subdivision of organism along appendicular axis', 'bone element', 'lymphoid system phenotype', 'anatomical structure degeneration', 'multi-limb segment region', 'decreased qualitatively biological_process', 'adenohypophysis phenotype', 'endocrine system physiology phenotype', 'endochondral element', 'forelimb zeugopod skeleton', 'manual digit 1 plus metapodial segment', 'regulation of hormone levels phenotype', 'upper limb segment', 'blood island', 'Abnormal cerebral subcortex morphology', 'cell communication', 'Abnormal long bone morphology', 'decreased length of material anatomical entity', 'forelimb endochondral element phenotype', 'agenesis of anatomical entity', 'cerebral subcortex', 'white matter of forebrain', 'craniofacial/craniocervical phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'Aplasia/hypoplasia involving forearm bones', 'limb long bone morphology phenotype', 'surface structure', 'formed anatomical structure', 'limb bud morphology phenotype', 'decreased size of the endochondral bone', 'occurrent', 'limb morphology phenotype', 'bone marrow cell', 'cerebellum morphology phenotype', 'lateral structure', 'skeletal system', 'craniocervical region morphology phenotype', 'central nervous system cell part cluster phenotype', 'long bone', 'subdivision of tube atresia', 'decreased localization', 'arm', 'regulation of biological quality', 'aplasia or hypoplasia of skeleton', 'decreased size of the skeletal element', 'All', 'subdivision of head', 'decreased length of multicellular anatomical structure', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'anatomical collection phenotype', 'decreased qualitatively biological_process in central nervous system', 'trunk phenotype', 'anatomical entity physiology phenotype', 'decreased length of anatomical structure', 'anatomical collection', 'forelimb', 'Abnormal forearm bone morphology', 'skeletal system morphology phenotype', 'Aplasia/hypoplasia involving bones of the hand', 'decreased length of bone of free limb or fin', 'decreased size of the material anatomical entity', 'renal system', 'abdomen element phenotype', 'limb segment phenotype', 'endochondral element phenotype', 'forelimb skeleton phenotype', 'organ subunit phenotype', 'anatomical cluster phenotype', 'ectoderm-derived structure phenotype', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'decreased size of the long bone', 'cerebral hemisphere morphology phenotype', 'paired limb/fin segment phenotype', 'pectoral appendage', 'Abnormal periventricular white matter morphology', 'forelimb bone', 'forelimb zeugopod', 'future central nervous system phenotype', 'transport', 'Hypoplasia of the radius', 'increased number of multicellular anatomical structure', 'endochondral bone phenotype', 'brain ventricle', 'limb skeleton subdivision phenotype', 'white matter of telencephalon phenotype', 'arm bone phenotype', 'decreased qualitatively embryo development', 'arm phenotype', 'Abnormal midface morphology', 'paired limb/fin', 'mesoderm', 'forelimb bud', 'abdominal viscera', 'decreased length of forelimb zeugopod bone', 'renal system morphology phenotype', 'forelimb long bone phenotype', 'multi cell part structure', 'mesenchyme phenotype', 'Abnormal appendicular skeleton morphology', 'bone of pectoral complex', 'forelimb endochondral element', 'alimentary part of gastrointestinal system', 'reproductive gland', 'subdivision of skeletal system', 'skeleton of limb', 'dense mesenchyme tissue', 'Abnormal morphology of the radius', 'decreased size of the bone of appendage girdle complex', 'appendage girdle complex', 'subdivision of skeletal system phenotype', 'reproductive organ', 'pectoral appendage skeleton phenotype', 'Aplasia/hypoplasia of the extremities', 'Abnormal skeletal morphology', 'decreased export from cell', 'Renal hypoplasia/aplasia', 'forelimb zeugopod bone morphology phenotype', 'cranial skeletal system', 'appendicular skeleton', 'decreased size of the limb bone', 'absent anatomical entity in the limb', 'skeleton of manus', 'manual digit', 'decreased size of the anatomical structure', 'decreased size of the subdivision of organism along main body axis', 'regional part of nervous system phenotype', 'face phenotype', 'brain ventricle/choroid plexus morphology phenotype', 'midface hypoplasia', 'Abnormality of the head', 'anterior region of body', 'subdivision of head phenotype', 'anatomical structure atresia', 'formed regional part of brain', 'decreased length of limb endochondral element', 'limb bone', 'Abnormality of head or neck', 'multicellular anatomical structure atresia', 'midface phenotype', 'decreased secretion', 'decreased length of arm bone', 'kidney hypoplasia', 'ectoderm phenotype', 'subdivision of trunk', 'trunk region element', 'ventricular system of brain', 'megakaryocyte morphology phenotype', 'compound organ', 'biological_process phenotype', 'renal/urinary system phenotype', 'manus', 'ectoderm morphology phenotype', 'renal system phenotype', 'malformed anatomical entity', 'anatomical structure', 'Abnormal cerebral white matter morphology', 'cavitated compound organ phenotype', 'Abnormality of the genitourinary system', 'abdominal segment element', 'Gastrointestinal atresia', 'hypothalamus-pituitary axis', 'Abnormality of the kidney', 'white matter of forebrain phenotype', 'limb long bone phenotype', 'genitourinary system', 'upper urinary tract', 'abdomen element', 'Abnormality of the abdominal organs', 'kidney phenotype', 'developmental process', 'Abnormality of the urinary system', 'immune system phenotype', 'kidney morphology phenotype', 'cerebral hemisphere white matter degeneration', 'decreased peptide hormone secretion', 'Abnormal forebrain morphology', 'decreased size of the bone element', 'brain white matter degeneration'], 'has_descendant': ['MONDO:0044325'], 'has_descendant_label': ['Fanconi anemia, complementation group W'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0012187', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group J', 'description': 'Fanconi anemia caused by mutations in the BRIP1 gene, encoding Fanconi anemia group J protein.', 'xref': ['DOID:0111097', 'GARD:15449', 'MEDGEN:323015', 'MESH:C563801', 'NCIT:C129027', 'OMIM:609054', 'UMLS:C1836860'], 'synonym': ['FANCJ', 'Fanconi Anemia, complementation group type J', 'Fanconi anaemia complementation group type J', 'Fanconi anemia complementation group J', 'Fanconi anemia complementation group type J', 'Fanconi anemia, complementation group J'], 'exact_synonym': ['FANCJ', 'Fanconi Anemia, complementation group type J', 'Fanconi anaemia complementation group type J', 'Fanconi anemia complementation group J', 'Fanconi anemia complementation group type J'], 'related_synonym': ['Fanconi anemia, complementation group J'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0007565', 'HP:0009778', 'HP:0008897', 'HP:0000568', 'HP:0005528', 'HP:0003221', 'HP:0001511', 'HP:0001263'], 'has_phenotype_label': ['Postnatal growth retardation', 'Microphthalmia', 'Multiple cafe-au-lait spots', 'Short thumb', 'Intrauterine growth retardation', 'Bone marrow hypocellularity', 'Chromosomal breakage induced by crosslinking agents', 'Global developmental delay'], 'has_phenotype_count': 8, 'has_phenotype_closure': ['UPHENO:0004523', 'HP:0000707', 'UPHENO:0000509', 'UPHENO:0002267', 'HP:0012759', 'UPHENO:0002385', 'UPHENO:0083046', 'UPHENO:0002433', 'GO:0022414', 'UPHENO:0078722', 'HP:0008897', 'UPHENO:0005508', 'UBERON:0004347', 'UPHENO:0003005', 'UBERON:5006048', 'UPHENO:0046552', 'UPHENO:0076723', 'UBERON:0012475', 'UPHENO:0002586', 'UBERON:0002428', 'UBERON:0004708', 'UPHENO:0076697', 'UPHENO:0003366', 'UPHENO:0049940', 'UPHENO:0046411', 'UPHENO:0046505', 'UBERON:0015061', 'UPHENO:0079876', 'HP:0045060', 'UPHENO:0086700', 'HP:0011297', 'UPHENO:0084761', 'UPHENO:0086633', 'UPHENO:0003415', 'UPHENO:0002944', 'UBERON:0001440', 'UPHENO:0003514', 'UPHENO:0002816', 'HP:0006265', 'HP:0001263', 'UPHENO:0002650', 'HP:0011842', 'HP:0009815', 'UBERON:0012354', 'HP:0002813', 'UBERON:0006058', 'UPHENO:0086635', 'UPHENO:0087663', 'UPHENO:0046426', 'UBERON:0010740', 'UBERON:0019221', 'UBERON:5001463', 'UPHENO:0002632', 'UPHENO:0004909', 'HP:0009601', 'HP:0005927', 'UPHENO:0003227', 'UPHENO:0002269', 'UBERON:0002529', 'UBERON:0006717', 'UPHENO:0076727', 'UPHENO:0046528', 'UPHENO:0003049', 'HP:0012758', 'UBERON:0010912', 'UBERON:0011582', 'UPHENO:0080099', 'UPHENO:0002782', 'UPHENO:0002945', 'UPHENO:0087006', 'UBERON:0010363', 'UBERON:0005881', 'UBERON:5002544', 'UBERON:0004288', 'HP:0033127', 'UPHENO:0086546', 'UPHENO:0002905', 'UPHENO:0004475', 'UPHENO:0012274', 'HP:0011927', 'UPHENO:0002746', 'UBERON:0011249', 'UBERON:0002101', 'UPHENO:0002880', 'UPHENO:0002896', 'HP:0009381', 'UPHENO:0012312', 'UBERON:0002102', 'HP:0009115', 'UPHENO:0076703', 'UPHENO:0003065', 'UPHENO:0012308', 'HP:0012638', 'GO:0019222', 'GO:0048523', 'GO:0050789', 'GO:0008152', 'UPHENO:0049642', 'UPHENO:0049757', 'UPHENO:0082875', 'HP:0000924', 'GO:0042592', 'HP:0002817', 'UPHENO:0049870', 'HP:0040012', 'UPHENO:0049837', 'UPHENO:0002593', 'UPHENO:0050121', 'UPHENO:0049590', 'HP:0025354', 'GO:0010629', 'GO:0010468', 'GO:0010558', 'UPHENO:0049775', 'UPHENO:0069684', 'UPHENO:0049652', 'UPHENO:0003812', 'UPHENO:0050778', 'GO:0031049', 'UPHENO:0076740', 'HP:0003220', 'UPHENO:0049835', 'HP:0001939', 'UPHENO:0069674', 'UPHENO:0050063', 'UBERON:0010130', 'GO:0009058', 'GO:0043170', 'UPHENO:0049743', 'UPHENO:0002600', 'GO:0010556', 'GO:0009890', 'GO:0060255', 'GO:0009889', 'GO:0010467', 'HP:0009778', 'UPHENO:0086769', 'HP:0011017', 'UPHENO:0053298', 'UPHENO:0049873', 'UBERON:0010712', 'UBERON:0010707', 'HP:0003221', 'HP:0000951', 'UPHENO:0054957', 'HP:0007565', 'HP:0001034', 'UBERON:0002097', 'UBERON:0001442', 'UPHENO:0002902', 'UPHENO:0050068', 'GO:0009987', 'UPHENO:0049966', 'HP:0001155', 'UBERON:0001015', 'UPHENO:0004888', 'UBERON:0005419', 'UPHENO:0004721', 'UPHENO:0049874', 'UPHENO:0088186', 'HP:0001511', 'UPHENO:0081436', 'UBERON:0000479', 'UPHENO:0035160', 'BFO:0000040', 'UPHENO:0046707', 'UPHENO:0035045', 'UPHENO:0080382', 'UPHENO:0002536', 'UPHENO:0005214', 'HP:0012145', 'UPHENO:0049587', 'UPHENO:0049904', 'UPHENO:0002964', 'GO:0065007', 'UPHENO:0050065', 'UPHENO:0063722', 'UPHENO:0069236', 'UPHENO:0050126', 'UPHENO:0005433', 'UPHENO:0080393', 'UPHENO:0002554', 'UBERON:0003102', 'UBERON:0006601', 'UBERON:0010000', 'GO:0050794', 'HP:0012372', 'HP:0040068', 'UPHENO:0046445', 'GO:0008150', 'UPHENO:0086172', 'UPHENO:0002830', 'UBERON:0003061', 'UPHENO:0005597', 'UPHENO:0075195', 'UBERON:0000383', 'UBERON:0004120', 'HP:0001871', 'UPHENO:0034969', 'UPHENO:0005647', 'UBERON:0002544', 'UBERON:0002104', 'UPHENO:0080114', 'UPHENO:0080009', 'UPHENO:0046740', 'UPHENO:0084763', 'UPHENO:0002948', 'UBERON:0013702', 'UPHENO:0004680', 'UPHENO:0050007', 'UPHENO:0011531', 'UPHENO:0035151', 'HP:0001172', 'UPHENO:0050034', 'NCBITaxon:33208', 'UBERON:0001062', 'UPHENO:0087661', 'UPHENO:0083162', 'UPHENO:0052160', 'UPHENO:0002541', 'UBERON:0005451', 'UPHENO:0074584', 'UBERON:0003081', 'UPHENO:0087849', 'UPHENO:0005110', 'UPHENO:0000508', 'UBERON:0008785', 'UPHENO:0053456', 'UBERON:0005417', 'UBERON:0004456', 'BFO:0000003', 'UPHENO:0003207', 'UPHENO:0003025', 'UPHENO:0001002', 'UPHENO:0035147', 'UPHENO:0080377', 'UBERON:0000923', 'UBERON:0002416', 'UPHENO:0085306', 'UPHENO:0004480', 'UPHENO:0002747', 'UBERON:0006598', 'UPHENO:0084448', 'CL:0001035', 'UPHENO:0087660', 'UBERON:0000481', 'UBERON:0004375', 'UPHENO:0002648', 'UPHENO:0078606', 'UPHENO:0002577', 'UPHENO:0004900', 'UPHENO:0004482', 'UPHENO:0002567', 'UBERON:0015212', 'UPHENO:0053330', 'BFO:0000001', 'UPHENO:0049620', 'UBERON:0002204', 'UPHENO:0076724', 'UPHENO:0004892', 'UBERON:0011216', 'UBERON:0002390', 'UBERON:0007272', 'UBERON:0001456', 'UPHENO:0046483', 'HP:0006496', 'UBERON:0000047', 'UBERON:0002193', 'UPHENO:0035034', 'UPHENO:0050040', 'UBERON:0002405', 'UBERON:0004381', 'CL:0000000', 'UPHENO:0002635', 'UPHENO:0002526', 'UPHENO:0002708', 'UBERON:0000061', 'UPHENO:0002764', 'UPHENO:0077371', 'UBERON:0006048', 'GO:0032501', 'UPHENO:0002866', 'UBERON:0012140', 'UPHENO:0087347', 'UPHENO:0080079', 'NCBITaxon:1', 'BFO:0000004', 'UPHENO:0002564', 'UBERON:0004765', 'UBERON:0034925', 'UPHENO:0005092', 'UPHENO:0005141', 'UPHENO:7000632', 'UPHENO:0003163', 'UPHENO:0002963', 'HP:0011844', 'UBERON:0000970', 'UBERON:0015203', 'UPHENO:0046741', 'UPHENO:0002542', 'UPHENO:0052778', 'UPHENO:0000541', 'UPHENO:0004476', 'UPHENO:0005596', 'UPHENO:0086485', 'UBERON:0019231', 'HP:0000001', 'UPHENO:0004885', 'UPHENO:0002861', 'HP:0005528', 'GO:0048519', 'UPHENO:0050106', 'HP:0001510', 'UBERON:0001444', 'UPHENO:0002983', 'UBERON:0000465', 'UBERON:5002389', 'UPHENO:0086486', 'UBERON:0010538', 'UBERON:0001463', 'HP:0008056', 'UBERON:0016879', 'GO:0031052', 'CL:0002092', 'GO:0048856', 'UPHENO:0002530', 'UBERON:0005291', 'UPHENO:0002571', 'UPHENO:0088326', 'UPHENO:0002844', 'UBERON:0001434', 'BFO:0000015', 'UBERON:0012141', 'UBERON:0002371', 'UPHENO:0001003', 'UBERON:0010758', 'UPHENO:0004064', 'UPHENO:0085409', 'UPHENO:0002733', 'UBERON:0010312', 'UBERON:0004128', 'UPHENO:0076675', 'UBERON:0010316', 'UBERON:0013701', 'UPHENO:3000007', 'UBERON:0004710', 'UBERON:0000922', 'HP:0000118', 'UBERON:0001016', 'UPHENO:0001001', 'UPHENO:0003410', 'UPHENO:0077418', 'UBERON:0007524', 'GO:0019954', 'UBERON:0000475', 'UPHENO:0069523', 'GO:0009059', 'UBERON:0001474', 'UPHENO:0002949', 'UPHENO:0000543', 'HP:0001167', 'UPHENO:0005642', 'HP:0001507', 'UPHENO:0069605', 'UPHENO:0054970', 'UBERON:0003104', 'GO:0007275', 'UBERON:0000026', 'HP:0011355', 'UPHENO:0075219', 'GO:0043473', 'HP:0000568', 'NCBITaxon:33154', 'UBERON:0001048', 'UBERON:0003072', 'UBERON:0010230', 'GO:0040007', 'UPHENO:0080209', 'UBERON:0010314', 'NCBITaxon:2759', 'UPHENO:0068971', 'UBERON:0000924', 'UPHENO:0049868', 'UBERON:0004088', 'UPHENO:0087472', 'UPHENO:0046624', 'UPHENO:0002731', 'UPHENO:0003159', 'UPHENO:0002928', 'UBERON:0000075', 'UPHENO:0003236', 'UPHENO:0003432', 'UBERON:0002199', 'UPHENO:0002525', 'UBERON:0000467', 'UPHENO:0087665', 'UBERON:0004734', 'UBERON:0000307', 'UPHENO:0005030', 'UPHENO:0063787', 'UBERON:0002346', 'UPHENO:0003334', 'UPHENO:0003069', 'UPHENO:0002976', 'UPHENO:0069266', 'GO:0099120', 'UPHENO:0012440', 'UPHENO:0005055', 'UPHENO:0050435', 'BFO:0000002', 'UPHENO:0069064', 'UPHENO:0002568', 'UPHENO:0003189', 'UPHENO:0002553', 'UPHENO:0046750', 'UBERON:0002513', 'UPHENO:0069161', 'UPHENO:0052178', 'UPHENO:0086679', 'UBERON:0001032', 'UPHENO:0011536', 'UPHENO:0069062', 'UPHENO:0074575', 'NCBITaxon:131567', 'UBERON:0007811', 'UPHENO:0011498', 'UBERON:0000062', 'UBERON:0004121', 'UPHENO:0082952', 'UPHENO:0005058', 'NCBITaxon:6072', 'GO:0009892', 'HP:0005561', 'UBERON:0000490', 'UBERON:0003056', 'UPHENO:0052694', 'UBERON:0000153', 'UPHENO:0003186', 'HP:0005922', 'UPHENO:0063794', 'UPHENO:0002926', 'GO:0009790', 'UBERON:0011676', 'GO:0051703', 'CL:0000255', 'UPHENO:0088123', 'UPHENO:0050108', 'HP:0012733', 'UBERON:0001460', 'UPHENO:0004459', 'UBERON:0000020', 'UBERON:0016880', 'UPHENO:0080662', 'UPHENO:0003020', 'UBERON:0002398', 'UPHENO:0004757', 'UPHENO:0076692', 'UPHENO:0086589', 'UPHENO:0004466', 'HP:0100887', 'UPHENO:0069327', 'UPHENO:0083161', 'UPHENO:0004615', 'UBERON:0034923', 'UBERON:0003071', 'RO:0002577', 'UBERON:0002389', 'UBERON:0000019', 'UBERON:0002050', 'UBERON:0000483', 'UPHENO:0003811', 'UPHENO:0005097', 'GO:0010605', 'UBERON:0000926', 'UBERON:0000033', 'UPHENO:0003799', 'UPHENO:0087907', 'UBERON:0010371', 'UPHENO:0002910', 'UBERON:0005423', 'HP:0000957', 'HP:0000478', 'UPHENO:0080126', 'UPHENO:0081581', 'UBERON:0002470', 'UPHENO:0004433', 'UPHENO:0075997', 'GO:0030587', 'UPHENO:0005573', 'UPHENO:0087924', 'UPHENO:0002559', 'UPHENO:0002870', 'UPHENO:0004519', 'UBERON:0012139', 'GO:0032502', 'UPHENO:0050008', 'UPHENO:0002548', 'UPHENO:7000640', 'HP:0040064', 'UPHENO:0003095', 'UBERON:0003075', 'HP:0000953', 'UPHENO:0004494', 'HP:0001000', 'UBERON:0010708', 'HP:0007400', 'HP:0001574', 'UPHENO:0003082', 'UBERON:0002091', 'UBERON:0004357', 'UPHENO:0076739', 'UBERON:0000468', 'HP:0011121'], 'has_phenotype_closure_label': ['delayed sorocarp development', 'nervous system physiology phenotype', 'nervous system phenotype', 'nervous system', 'delayed anatomical structure development', 'material anatomical entity physiology phenotype', 'Neurodevelopmental delay', 'Abnormal nervous system physiology', 'anatomical system physiology phenotype', 'anatomical entity physiology phenotype', 'decreased qualitatively reproductive process', 'decreased asexual reproduction', 'asexual reproduction phenotype', 'appendicular skeleton', 'skeleton of pectoral complex', 'Abnormal skeletal morphology', 'Abnormality of the hand', 'Aplasia/hypoplasia of the extremities', 'socially cooperative development phenotype', 'Short digit', 'decreased size of the digit', 'digit 1 plus metapodial segment', 'subdivision of skeletal system', 'anatomical entity morphology in the appendage girdle complex phenotype', 'limb bone', 'bone of free limb or fin', 'manual digit 1 or 5', 'Abnormal appendicular skeleton morphology', 'decreased length of digit', 'forelimb bud', 'reproductive process phenotype', 'paired limb/fin', 'acropodium region', 'digitopodium region', 'segment of manus', 'manus', 'limb', 'embryonic autopod plate', 'paired limb/fin segment phenotype', 'Abnormal digit morphology', 'manual digit morphology in the manus phenotype', 'endochondral element phenotype', 'skeletal system morphology phenotype', 'anatomical collection', 'decreased length of anatomical structure', 'forelimb bud phenotype', 'Aplasia/Hypoplasia of the thumb', 'decreased length of multicellular anatomical structure', 'digit phenotype', 'aplasia or hypoplasia of skeleton', 'subdivision of skeleton', 'limb morphology phenotype', 'manual digit 1 morphology phenotype', 'limb bud morphology phenotype', 'forelimb phenotype', 'embryonic autopod plate morphology phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'decreased length of manual digit 1 or 5', 'socially cooperative development', 'Abnormal hand morphology', 'upper limb segment', 'sorocarp development', 'endochondral element', 'multi-limb segment region', 'Aplasia/Hypoplasia of fingers', 'paired limb/fin skeleton', 'Aplasia/hypoplasia involving bones of the hand', 'Abnormal finger morphology', 'Short finger', 'bone of appendage girdle complex phenotype', 'forelimb skeleton', 'autopodial extension', 'aplasia or hypoplasia of manual digit', 'asexual reproduction', 'aplasia or hypoplasia of manual digit 1', 'autopod region phenotype', 'Abnormality of the musculoskeletal system', 'paired limb/fin phenotype', 'manus phenotype', 'paired limb/fin bud phenotype', 'Short thumb', 'skeleton of limb phenotype', 'mesenchyme morphology phenotype', 'anatomical collection phenotype', 'decreased size of the autopodial extension', 'decreased length of anatomical entity', 'Abnormality of limb bone', 'limb segment', 'pectoral appendage bud phenotype', 'autopodial extension phenotype', 'digit 1', 'musculature of body phenotype', 'Aplasia/hypoplasia involving the skeleton', 'Aplasia/hypoplasia involving bones of the upper limbs', 'decreased length of digit 1 or 5', 'Abnormal limb bone morphology', 'anatomical entity morphology in the manus phenotype', 'surface structure phenotype', 'limb segment phenotype', 'endochondral bone', 'manual digit', 'digit 1 or 5', 'Abnormality of limbs', 'limb bud phenotype', 'bone of free limb or fin phenotype', 'paired limb/fin skeleton phenotype', 'Aplasia/hypoplasia involving bones of the extremities', 'limb bone morphology phenotype', 'decreased length of autopodial extension', 'multi-limb segment region phenotype', 'delayed developmental process', 'decreased size of the manual digit', 'appendicular skeleton morphology phenotype', 'homeostatic process phenotype', 'metabolic process', 'regulation of biological process phenotype', 'Chromosomal breakage induced by crosslinking agents', 'negative regulation of metabolic process phenotype', 'negative regulation of gene expression', 'regulation of gene expression', 'negative regulation of macromolecule biosynthetic process', 'negative regulation of cellular process phenotype', 'regulation of metabolic process', 'macromolecule biosynthetic process', 'pectoral appendage', 'biosynthetic process phenotype', 'biological regulation phenotype', 'programmed DNA elimination', 'skeleton of limb', 'programmed DNA elimination by chromosome breakage phenotype', 'regulation of macromolecule metabolic process', 'negative regulation of metabolic process', 'Postnatal growth retardation', 'Abnormality of the upper limb', 'gene expression', 'Abnormality of metabolism/homeostasis', 'gene expression phenotype', 'Chromosome breakage', 'biological process involved in intraspecies interaction between organisms phenotype', 'limb skeleton subdivision phenotype', 'regulation of macromolecule biosynthetic process phenotype', 'appendage girdle complex', 'regulation of macromolecule biosynthetic process', 'negative regulation of macromolecule metabolic process', 'regulation of biosynthetic process', 'regulation of metabolic process phenotype', 'metabolic process phenotype', 'Abnormal cellular phenotype', 'limb endochondral element phenotype', 'macromolecule metabolic process phenotype', 'regulation of cellular process', 'negative regulation of biological process', 'limb bone phenotype', 'macromolecule biosynthetic process phenotype', 'biosynthetic process', 'cellular process', 'Hyperpigmentation of the skin', 'Irregular hyperpigmentation', 'integument', 'system', 'appendage phenotype', 'Abnormality of the integument', 'pigmentation phenotype', 'integumental system', 'segment of autopod', 'increased biological_process in skin of body', 'increased pigmentation', 'manual digit plus metapodial segment', 'occurrent', 'decreased size of the material anatomical entity in the pectoral complex', 'Growth delay', 'decreased qualitatively biological_process', 'embryo development phenotype', 'future nervous system', 'developmental process phenotype', 'anatomical structure development phenotype', 'embryo', 'decreased qualitatively anatomical structure development', 'Global developmental delay', 'forelimb morphology phenotype', 'anatomical structure phenotype', 'decreased length of manual digit 1', 'face', 'subdivision of skeletal system phenotype', 'growth phenotype', 'digit', 'negative regulation of biological process phenotype', 'decreased multicellular organismal process', 'decreased qualitatively multicellular organismal process', 'manual digit 1', 'craniocervical region', 'subdivision of skeleton phenotype', 'blood island', 'skeleton', 'presumptive structure phenotype', 'anatomical entity phenotype', 'presumptive structure', 'skeletal system phenotype', 'multi-tissue structure', 'pectoral appendage skeleton', 'Abnormality of multiple cell lineages in the bone marrow', 'arm phenotype', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'lateral plate mesoderm', 'mesenchyme phenotype', 'Abnormality of chromosome stability', 'germ layer morphology phenotype', 'limb endochondral element', 'paired limb/fin bud', 'neural plate', 'Abnormal thumb morphology', 'eye primordium phenotype', 'regulation of gene expression phenotype', 'bone marrow phenotype', 'non-connected functional system', 'pigmentation', 'organ phenotype', 'mesenchyme', 'Metazoa', 'germ layer', 'continuant', 'embryo development', 'multicellular organism morphology phenotype', 'decreased anatomical structure development', 'subdivision of organism along appendicular axis phenotype', 'biological_process rate phenotype', 'decreased size of the organism subdivision', 'germ layer phenotype', 'regulation of biosynthetic process phenotype', 'embryonic structure phenotype', 'biological_process', 'decreased length of material anatomical entity', 'negative regulation of gene expression phenotype', 'decreased number of bone marrow cell', 'mesoderm-derived structure', 'lateral structure', 'limb skeleton subdivision', 'Phenotypic abnormality', 'hematopoietic system', 'embryo morphology phenotype', 'decreased number of anatomical entity in the bone marrow', 'Localized skin lesion', 'bone of appendage girdle complex', 'mesoderm-derived structure phenotype', 'disconnected anatomical group', 'immature eye phenotype', 'anatomical structure', 'tissue phenotype', 'forelimb', 'macromolecule metabolic process', 'developmental process', 'cellular organisms', 'decreased number of anatomical entity in the multicellular organism', 'skeletal element', 'anatomical structure physiology phenotype', 'digit 1 phenotype', 'paired limb/fin segment', 'regulation of biological process', 'skeletal element phenotype', 'decreased number of anatomical entity', 'epithelium phenotype', 'multicellular organism', 'vision/eye phenotype', 'decreased size of the anatomical structure', 'embryonic tissue phenotype', 'skin of body', 'orbital region phenotype', 'bone marrow cell', 'programmed DNA elimination by chromosome breakage', 'increased pigmentation in skin of body', 'manual digit phenotype', 'entity', 'growth', 'decreased length of organism subdivision', 'embryo phenotype', 'eye phenotype', 'decreased qualitatively developmental process', 'anatomical system', 'limb bud', 'Growth abnormality', 'multicellular organism phenotype', 'manual digitopodium region', 'decreased multicellular organism development', 'decreased number of anatomical structure in the multicellular organism', 'subdivision of head phenotype', 'upper limb segment phenotype', 'regulation of cellular process phenotype', 'eukaryotic cell', 'biological process involved in intraspecies interaction between organisms', 'germ layer / neural crest', 'dense mesenchyme tissue', 'developing anatomical structure phenotype', 'visual system phenotype', 'negative regulation of biosynthetic process', 'germ layer / neural crest phenotype', 'embryo development rate phenotype', 'number of anatomical enitites of type anatomical entity phenotype', 'Abnormality of the nervous system', 'multicellular anatomical structure', 'integumental system phenotype', 'skeletal system', 'craniocervical region morphology phenotype', 'subdivision of head', 'blood island phenotype', 'arm', 'decreased size of the eyeball of camera-type eye', 'Abnormality of blood and blood-forming tissues', 'bone marrow', 'cell phenotype', 'autopodial skeleton', 'Abnormal eye morphology', 'future central nervous system phenotype', 'decreased number of material anatomical entity', 'delayed biological_process', 'pectoral complex', 'biological regulation', 'decreased number of material anatomical entity in the multicellular organism', 'decreased developmental process', 'number of bone marrow cell phenotype', 'skin of body morphology phenotype', 'multicellular anatomical structure phenotype', 'decreased size of the multicellular anatomical structure', 'Intrauterine growth retardation', 'Macule', 'bone element phenotype', 'neural plate morphology phenotype', 'ectoderm', 'embryonic tissue morphology phenotype', 'decreased number of anatomical structure', 'negative regulation of macromolecule metabolic process phenotype', 'bone cell', 'lateral plate mesoderm phenotype', 'limb phenotype', 'embryonic structure', 'anatomical structure development', 'decreased length of digit 1', 'autopod region', 'material anatomical entity', 'organ', 'bone element', 'neurectoderm', 'subdivision of organism along appendicular axis', 'All', 'mesoderm phenotype', 'multicellular organismal process phenotype', 'decreased number of anatomical entity in the bone element', 'tissue', 'sorocarp development phenotype', 'Abnormal cellular physiology', 'decreased size of the material anatomical entity', 'cell', 'decreased size of the anatomical entity', 'lateral structure phenotype', 'decreased length of manual digit', 'embryonic tissue', 'decreased number of cell', 'camera-type eye', 'developing anatomical structure', 'phenotypic effect', 'decreased number of material anatomical entity in the bone element', 'aplasia or hypoplasia of anatomical entity', 'organ system subdivision', 'musculoskeletal system phenotype', 'forelimb bud morphology phenotype', 'musculature phenotype', 'negative regulation of cellular process', 'immune system', 'Abnormality of the skeletal system', 'manus morphology phenotype', 'hematopoietic system phenotype', 'increased qualitatively biological_process', 'mesoderm', 'decreased size of the anatomical entity in the pectoral complex', 'musculoskeletal system', 'skeleton phenotype', 'process', 'taxon specific phenotype', 'Abnormality of the eye', 'organism subdivision', 'simple eye', 'multi-tissue structure phenotype', 'multicellular organism development', 'number of anatomical enitites of type material anatomical entity phenotype', 'decreased qualitatively embryo development', 'decreased qualitatively multicellular organism development', 'autopod region morphology phenotype', 'lateral plate mesoderm morphology phenotype', 'decreased number of anatomical structure in the bone element', 'decreased size of the organ', 'primordium', 'musculature of body', 'organ system subdivision phenotype', 'Bone marrow hypocellularity', 'head', 'material entity', 'size of eyeball of camera-type eye phenotype', 'Abnormality of globe size', 'visual system', 'primordium phenotype', 'orbital region', 'appendicular skeleton phenotype', 'sense organ phenotype', 'digit plus metapodial segment', 'multicellular organismal process', 'camera-type eye phenotype', 'reproductive process', 'endochondral bone phenotype', 'digit morphology phenotype', 'eye morphology', 'sense organ', 'anatomical system phenotype', 'multicellular organism development phenotype', 'decreased size of the sense organ', 'appendage', 'neurectoderm phenotype', 'regulation of macromolecule metabolic process phenotype', 'head phenotype', 'anatomical entity', 'size of anatomical entity phenotype', 'decreased embryo development', 'camera-type eye morphology phenotype', 'pectoral appendage bud', 'cellular process phenotype', 'sensory system phenotype', 'Aplasia/Hypoplasia affecting the eye', 'optic cup', 'main body axis', 'body proper', 'appendicular skeletal system', 'Abnormal skin morphology', 'developmental process rate phenotype', 'ectoderm morphology phenotype', 'decreased size of the anatomical structure in the pectoral complex', 'Abnormality of the skin', 'development of anatomical entity phenotype', 'subdivision of organism along main body axis', 'eye', 'surface structure', 'eyeball of camera-type eye', 'delayed growth', 'pre-chordal neural plate phenotype', 'Opisthokonta', 'eye primordium', 'craniocervical region phenotype', 'unilaminar epithelium phenotype', 'subdivision of organism along main body axis phenotype', 'mesoderm morphology phenotype', 'structure with developmental contribution from neural crest phenotype', 'simple eye phenotype', 'manual digit 1 plus metapodial segment', 'optic vesicle', 'number of cell phenotype', 'ecto-epithelium', 'anatomical entity length phenotype', 'Abnormal bone marrow cell morphology', 'ectoderm-derived structure phenotype', 'face phenotype', 'aplasia or hypoplasia of eyeball of camera-type eye', 'decreased reproductive process', 'phenotype', 'decreased biological_process', 'ecto-epithelium phenotype', 'bone marrow cell phenotype', 'independent continuant', 'immature eye', 'epithelium', 'anterior region of body', 'skeleton of manus', 'dysesthesia; hyperalgesia', 'root', 'dense mesenchyme tissue phenotype', 'presumptive ectoderm', 'structure with developmental contribution from neural crest', 'biological_process phenotype', 'head morphology phenotype', 'sensory system', 'ectoderm-derived structure', 'entire sense organ system', 'neural plate phenotype', 'presumptive ectoderm phenotype', 'future central nervous system', 'digit 1 or 5 phenotype', 'immune system phenotype', 'Eumetazoa', 'hemolymphoid system', 'number of anatomical enitites of type anatomical structure phenotype', 'unilaminar epithelium', 'musculature', 'pre-chordal neural plate', 'increased biological_process', 'blastula', 'gastrula', 'Microphthalmia', 'optic cup morphology phenotype', 'Neurodevelopmental abnormality', 'homeostatic process', 'organism subdivision phenotype', 'face morphology phenotype', 'pectoral appendage phenotype', 'material anatomical entity phenotype', 'ectoderm phenotype', 'eyeball of camera-type eye phenotype', 'optic vesicle phenotype', 'Eukaryota', 'skin of body phenotype', 'integument phenotype', 'Abnormality of skin pigmentation', 'anatomical entity morphology phenotype', 'Hypermelanotic macule', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'gastrula morphology phenotype', 'Cafe-au-lait spot', 'Multiple cafe-au-lait spots'], 'has_descendant': ['MONDO:0012187'], 'has_descendant_label': ['Fanconi anemia complementation group J'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0009213', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group C', 'description': 'Fanconi anemia caused by mutations of the FANCC gene. This gene provides instructions for making a protein that delays the onset of apoptosis and promotes homologous recombination repair of damaged DNA.', 'xref': ['DOID:0111087', 'GARD:15168', 'MEDGEN:483324', 'NCIT:C125704', 'OMIM:227645', 'UMLS:C3468041'], 'synonym': ['FA3', 'FACC', 'FANCC', 'Fanconi Anemia, complementation group type C', 'Fanconi anaemia complementation group type C', 'Fanconi anemia complementation group C', 'Fanconi anemia complementation group type C', 'Fanconi anemia, complementation group C', 'Fanconi pancytopenia type 3', 'Fanconi pancytopenia, type 3', 'facc'], 'exact_synonym': ['FA3', 'FACC', 'FANCC', 'Fanconi Anemia, complementation group type C', 'Fanconi anaemia complementation group type C', 'Fanconi anemia complementation group C', 'Fanconi anemia complementation group type C', 'Fanconi pancytopenia type 3'], 'related_synonym': ['Fanconi anemia, complementation group C', 'Fanconi pancytopenia, type 3', 'facc'], 'subsets': ['clingen', 'gard_rare', 'nord_rare', 'otar', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0003974', 'HP:0000325', 'HP:0000286', 'HP:0001896', 'HP:0001903', 'HP:0009942', 'HP:0001875', 'HP:0000815', 'HP:0009777', 'HP:0000252', 'HP:0009778', 'HP:0001017', 'HP:0003214', 'HP:0000086', 'HP:0001371', 'HP:0009943', 'HP:0000568', 'HP:0000085', 'HP:0001876', 'HP:0000978', 'HP:0001873', 'HP:0000486', 'HP:0005528', 'HP:0000104', 'HP:0020073', 'HP:0004322', 'HP:0000081', 'HP:0003221', 'HP:0000957', 'HP:0001249', 'HP:0000953', 'HP:0001511', 'HP:0003213', 'HP:0001909', 'HP:0001518', 'HP:0011940', 'HP:0000365', 'HP:0000028', 'HP:0001629'], 'has_phenotype_label': ['Ectopic kidney', 'Duplicated collecting system', 'Thrombocytopenia', 'Epicanthus', 'Anterior wedging of T12', 'Ventricular septal defect', 'Triangular face', 'Deficient excision of UV-induced pyrimidine dimers in DNA', 'Cafe-au-lait spot', 'Microphthalmia', 'Horseshoe kidney', 'Renal agenesis', 'Prolonged G2 phase of cell cycle', 'Strabismus', 'Flexion contracture', 'Duplication of thumb phalanx', 'Absent radius', 'Microcephaly', 'Short thumb', 'Bruising susceptibility', 'Intrauterine growth retardation', 'Intellectual disability', 'Small for gestational age', 'Absent thumb', 'Pancytopenia', 'Bone marrow hypocellularity', 'Leukemia', 'Hyperpigmentation of the skin', 'Chromosomal breakage induced by crosslinking agents', 'Cryptorchidism', 'Hypergonadotropic hypogonadism', 'Hearing impairment', 'Complete duplication of thumb phalanx', 'Decreased total neutrophil count', 'Reticulocytopenia', 'Anemic pallor', 'Short stature', 'Anemia', 'Hypopigmented macule'], 'has_phenotype_count': 39, 'has_phenotype_closure': ['UBERON:0015063', 'UBERON:0003620', 'UBERON:0012358', 'HP:0009142', 'UBERON:0004249', 'UBERON:5102389', 'HP:0005918', 'UBERON:5101463', 'UBERON:0015024', 'UBERON:0003221', 'HP:0009943', 'UBERON:0010543', 'UBERON:5102544', 'UBERON:0012357', 'HP:0009998', 'UPHENO:0008668', 'UPHENO:0081466', 'UPHENO:0026108', 'HP:0009777', 'UPHENO:0009146', 'UPHENO:0009382', 'UPHENO:0008548', 'HP:0009380', 'MPATH:0', 'UPHENO:0076804', 'HP:0011276', 'UPHENO:0004036', 'UPHENO:0087228', 'UPHENO:0076729', 'HP:0009997', 'UPHENO:0076777', 'UBERON:0001802', 'UBERON:0005388', 'UBERON:0006876', 'UBERON:0002200', 'MPATH:119', 'MPATH:105', 'UPHENO:0002580', 'UBERON:0011818', 'UBERON:0001768', 'UPHENO:7000539', 'HP:0001933', 'UPHENO:7000303', 'UPHENO:0086296', 'UBERON:0003496', 'GO:0043228', 'UPHENO:0086297', 'UPHENO:0003776', 'UBERON:0002443', 'UBERON:0000055', 'GO:0110165', 'UPHENO:0003369', 'UPHENO:0002343', 'UPHENO:0002410', 'UPHENO:0088164', 'UBERON:0007213', 'HP:0002597', 'UPHENO:0003031', 'UPHENO:0005093', 'UBERON:0003099', 'UBERON:0005157', 'UPHENO:0004766', 'UBERON:0000053', 'UBERON:0019207', 'HP:0011354', 'UPHENO:0087596', 'UPHENO:0076782', 'UPHENO:0006889', 'UPHENO:0005090', 'UPHENO:0002393', 'UPHENO:0003123', 'UBERON:0007798', 'HP:0000978', 'HP:0001892', 'UPHENO:0003082', 'UPHENO:0046624', 'HP:0001172', 'UBERON:5006048', 'UBERON:0006048', 'UBERON:0019231', 'UPHENO:0086700', 'HP:0006265', 'UBERON:0002470', 'HP:0005927', 'UPHENO:0003069', 'UBERON:0012354', 'UPHENO:0046426', 'UBERON:5001463', 'HP:0009601', 'UBERON:0006717', 'UPHENO:0046528', 'HP:0001167', 'UPHENO:0080099', 'UPHENO:0002782', 'UPHENO:0087006', 'GO:0005622', 'UBERON:5002544', 'UPHENO:0002905', 'HP:0009942', 'UPHENO:0012274', 'HP:0011927', 'UBERON:0010130', 'UPHENO:0012312', 'UPHENO:0086769', 'UPHENO:0002733', 'UPHENO:0084448', 'HP:0000957', 'UPHENO:0012308', 'UPHENO:0053572', 'UBERON:0000079', 'HP:0000032', 'UPHENO:0005025', 'HP:0000028', 'UPHENO:0053647', 'UPHENO:0002597', 'UPHENO:0053644', 'UBERON:0004053', 'UBERON:0000473', 'UPHENO:0087802', 'UPHENO:7000206', 'HP:0000811', 'UPHENO:7000069', 'HP:0012243', 'UPHENO:0076724', 'HP:0001155', 'UBERON:0003101', 'HP:0011355', 'UPHENO:0035160', 'UBERON:0003061', 'UPHENO:0085409', 'UPHENO:0080009', 'HP:0005528', 'UPHENO:0085306', 'UBERON:0007530', 'UPHENO:0002558', 'UBERON:0003089', 'UBERON:0005863', 'UPHENO:0002646', 'UBERON:0002412', 'UBERON:0001075', 'UPHENO:0086480', 'UPHENO:0076695', 'HP:0009778', 'HP:0011940', 'UPHENO:0086505', 'UBERON:0007844', 'HP:0003312', 'UPHENO:0046411', 'UPHENO:0002527', 'UPHENO:0004509', 'UBERON:0005856', 'UPHENO:0002813', 'UBERON:0011585', 'UPHENO:0003191', 'UPHENO:0084420', 'UPHENO:0076744', 'HP:0000925', 'UPHENO:0076707', 'GO:0006974', 'GO:0051716', 'GO:0006950', 'GO:0050896', 'HP:0003213', 'GO:0006281', 'UPHENO:0049720', 'UPHENO:0049671', 'UPHENO:0050019', 'UPHENO:0069684', 'UPHENO:0049588', 'UPHENO:0069149', 'HP:0009121', 'UBERON:0002090', 'HP:0002011', 'HP:0000929', 'HP:0007364', 'UBERON:0008001', 'HP:0000252', 'UPHENO:0069236', 'HP:0012639', 'UPHENO:0049990', 'UPHENO:0087089', 'HP:0002060', 'UPHENO:0075148', 'UPHENO:0075220', 'UBERON:0011138', 'HP:0012443', 'UPHENO:0080200', 'GO:0007600', 'UPHENO:0005513', 'HP:0000598', 'UPHENO:0052165', 'UPHENO:0005512', 'HP:0000365', 'UPHENO:0050620', 'UPHENO:0052231', 'UPHENO:0041381', 'GO:0050954', 'UPHENO:0002595', 'UBERON:0001130', 'UPHENO:0002537', 'UPHENO:0050234', 'UPHENO:0002204', 'UPHENO:0049699', 'UPHENO:0052970', 'GO:0019222', 'GO:0009059', 'UPHENO:0050040', 'UPHENO:0049642', 'UPHENO:0002240', 'UPHENO:0049757', 'GO:0065007', 'UPHENO:0049870', 'UPHENO:0004476', 'HP:0040012', 'UPHENO:0049837', 'UPHENO:0050435', 'GO:0010629', 'UPHENO:0069605', 'GO:0010468', 'HP:0020073', 'GO:0010558', 'UPHENO:0050778', 'UPHENO:0002765', 'HP:0001574', 'UPHENO:0053571', 'UPHENO:0002659', 'HP:0045060', 'HP:0032039', 'UPHENO:0002866', 'UBERON:0010230', 'UPHENO:0004892', 'UPHENO:0004765', 'HP:0032251', 'UBERON:0010740', 'UPHENO:0068971', 'HP:0010987', 'UBERON:0000926', 'HP:0000364', 'UPHENO:0002635', 'UPHENO:0004143', 'UPHENO:3000003', 'UPHENO:0041075', 'UPHENO:0011817', 'UPHENO:0087123', 'UPHENO:7000306', 'UPHENO:0035147', 'HP:0002715', 'UBERON:0007688', 'UBERON:0000915', 'UPHENO:0026309', 'UPHENO:0003413', 'UPHENO:0002969', 'UBERON:0000063', 'HP:0010438', 'UPHENO:0063787', 'UPHENO:0088166', 'UBERON:0001015', 'UPHENO:0088118', 'UBERON:0016879', 'UPHENO:0080079', 'HP:0003011', 'GO:0007610', 'UPHENO:0008475', 'UPHENO:0015277', 'UBERON:0005291', 'HP:0005561', 'UBERON:0002099', 'UBERON:0003084', 'HP:0100887', 'UBERON:0000468', 'HP:0040195', 'UPHENO:0077373', 'UPHENO:0005356', 'UPHENO:3000004', 'UPHENO:0072195', 'UPHENO:0025187', 'UBERON:0004141', 'UBERON:0000965', 'UPHENO:0011573', 'UBERON:0004872', 'UPHENO:0074584', 'UBERON:5106048', 'HP:0003254', 'UPHENO:0086854', 'UBERON:0003037', 'UPHENO:0080393', 'UBERON:0002082', 'UPHENO:0001231', 'UBERON:0034923', 'UPHENO:0015324', 'UBERON:0010312', 'UPHENO:0002844', 'UBERON:0009569', 'UBERON:0005156', 'UPHENO:0003935', 'HP:0003468', 'HP:0001627', 'UPHENO:0008703', 'UPHENO:0087907', 'UBERON:0002094', 'UPHENO:0033596', 'UPHENO:0004403', 'UPHENO:0076776', 'UPHENO:0003999', 'UPHENO:0086019', 'HP:0002664', 'UPHENO:0046750', 'UPHENO:0086866', 'UPHENO:0004884', 'UPHENO:0004386', 'UBERON:0005181', 'UBERON:0015228', 'UPHENO:0002832', 'UPHENO:0003234', 'HP:0030680', 'UBERON:0019221', 'UPHENO:0033572', 'HP:0001903', 'UBERON:0001048', 'UPHENO:0085263', 'UPHENO:7000853', 'UBERON:0001032', 'HP:0001877', 'UPHENO:0086002', 'UBERON:0002428', 'UPHENO:0088148', 'UBERON:0002398', 'UPHENO:0052778', 'UPHENO:0026600', 'HP:0100547', 'HP:0011793', 'UBERON:0000949', 'UPHENO:0003815', 'UBERON:0001049', 'UPHENO:0069352', 'UPHENO:0003050', 'UBERON:0001890', 'UBERON:0003072', 'UPHENO:0085371', 'UPHENO:0085302', 'UBERON:0011584', 'UPHENO:0003177', 'UPHENO:0002548', 'UPHENO:0004523', 'UPHENO:0077391', 'UPHENO:0004261', 'UBERON:0001893', 'UPHENO:0080377', 'UPHENO:0087518', 'UPHENO:0003025', 'UPHENO:0002859', 'UPHENO:0086173', 'UPHENO:0004881', 'CL:0000458', 'UPHENO:7000640', 'NBO:0001845', 'HP:0012145', 'NCBITaxon:2759', 'UPHENO:0076702', 'UPHENO:0086485', 'NCBITaxon:1', 'UPHENO:0008743', 'UPHENO:0041221', 'UPHENO:0086712', 'HP:0000079', 'UPHENO:0086679', 'HP:0001713', 'UPHENO:0086172', 'UPHENO:0053632', 'UPHENO:0018390', 'UPHENO:0026227', 'CL:0000763', 'UPHENO:0088162', 'HP:0004377', 'UPHENO:0002987', 'UBERON:0000025', 'UPHENO:0072359', 'UPHENO:0002542', 'UBERON:0003059', 'UBERON:0003056', 'UBERON:0003914', 'UPHENO:0005058', 'NCBITaxon:6072', 'UPHENO:0069523', 'NCBITaxon:131567', 'UPHENO:0005285', 'HP:0001872', 'UBERON:0002405', 'UPHENO:0086633', 'UBERON:0015203', 'UPHENO:0004469', 'HP:0001511', 'UPHENO:0002594', 'BFO:0000015', 'UPHENO:0088326', 'UPHENO:0004621', 'UPHENO:0087186', 'UPHENO:0004827', 'UPHENO:0050126', 'UPHENO:0046606', 'UPHENO:0025845', 'UPHENO:0076799', 'UBERON:0002346', 'UBERON:0004734', 'UPHENO:0011492', 'UPHENO:0004205', 'CL:0000988', 'UBERON:0001434', 'UPHENO:0075195', 'NCBITaxon:33208', 'UPHENO:0002634', 'UBERON:0016491', 'UPHENO:0033565', 'UPHENO:0002553', 'UPHENO:0049587', 'CL:0000225', 'UBERON:0001849', 'UBERON:0004111', 'UPHENO:0085344', 'CL:0000232', 'UPHENO:0049703', 'UPHENO:0080187', 'UPHENO:0009010', 'UPHENO:0005030', 'UPHENO:0004909', 'UBERON:0000307', 'UPHENO:0026183', 'GO:0031052', 'UPHENO:0076675', 'UPHENO:0004475', 'UBERON:0004347', 'UPHENO:0002719', 'UBERON:0011216', 'GO:0009890', 'UBERON:0011137', 'UPHENO:0011548', 'UPHENO:0002219', 'UPHENO:0026073', 'UBERON:0005881', 'UPHENO:0080010', 'RO:0002577', 'UPHENO:0002571', 'HP:0006501', 'HP:0012759', 'UPHENO:0076723', 'UPHENO:0049989', 'UBERON:0009955', 'UPHENO:7000847', 'UPHENO:0004900', 'UPHENO:0076740', 'CL:0000738', 'UPHENO:0077418', 'UBERON:0007524', 'UPHENO:0002903', 'UBERON:0010000', 'UBERON:0004140', 'UPHENO:0025587', 'CL:0002242', 'UBERON:0005423', 'UPHENO:0088123', 'UBERON:0009856', 'UPHENO:0049904', 'UPHENO:0025497', 'UPHENO:0002764', 'UPHENO:0002964', 'UPHENO:0046699', 'UBERON:0013702', 'GO:0009790', 'GO:0050877', 'UPHENO:0026074', 'UBERON:0010913', 'UPHENO:0002736', 'UBERON:0000924', 'UBERON:0001630', 'UBERON:0001009', 'HP:0002973', 'UBERON:0003607', 'UPHENO:0008640', 'UPHENO:0003084', 'UPHENO:0005016', 'CL:0001035', 'GO:0005840', 'GO:0008150', 'HP:0040068', 'UBERON:0006601', 'UPHENO:0002949', 'UPHENO:0080351', 'HP:0003953', 'UPHENO:0004047', 'UPHENO:0027547', 'UPHENO:0054315', 'UPHENO:0009399', 'HP:0010461', 'UPHENO:0026010', 'UPHENO:0025553', 'UBERON:0015021', 'UPHENO:0003159', 'UPHENO:0004757', 'UPHENO:0004831', 'UPHENO:0004459', 'UBERON:0001981', 'UBERON:0001678', 'UPHENO:0002902', 'UPHENO:0002559', 'GO:0043229', 'UPHENO:0025955', 'UPHENO:0087665', 'UPHENO:0005517', 'UPHENO:0002352', 'UPHENO:0076791', 'UPHENO:0002564', 'UPHENO:0035151', 'UPHENO:0003236', 'UBERON:0002104', 'UPHENO:0003015', 'UBERON:0000075', 'UPHENO:0026078', 'UBERON:0001016', 'UPHENO:0002926', 'UBERON:0005173', 'UPHENO:0004545', 'UBERON:0015212', 'UPHENO:0002568', 'UPHENO:0087814', 'NBO:0000338', 'UPHENO:0003828', 'UPHENO:0002523', 'UBERON:0001869', 'UPHENO:0072414', 'UPHENO:0049835', 'UPHENO:0003189', 'BFO:0000040', 'UPHENO:0033607', 'UBERON:0002199', 'UPHENO:7000547', 'UPHENO:0002896', 'UPHENO:0080325', 'UPHENO:0004466', 'UPHENO:0066913', 'HP:0003974', 'UPHENO:0081511', 'HP:0009822', 'UBERON:0007833', 'UPHENO:0009356', 'UPHENO:0087294', 'UPHENO:0080126', 'UPHENO:0002945', 'UPHENO:0075655', 'UBERON:0001440', 'UBERON:0002101', 'HP:0000119', 'UPHENO:0026643', 'UPHENO:0025508', 'UBERON:0004151', 'BFO:0000002', 'UBERON:0005897', 'UBERON:0005419', 'UPHENO:0026098', 'UBERON:0002050', 'UPHENO:0005597', 'UPHENO:0003415', 'UPHENO:0004360', 'UBERON:0002091', 'UPHENO:0082794', 'UBERON:0004357', 'UPHENO:0011568', 'UBERON:0003102', 'GO:0009058', 'HP:0004312', 'UBERON:0000026', 'UBERON:0004288', 'UPHENO:0003334', 'UPHENO:0087846', 'UPHENO:0002976', 'GO:0042592', 'UPHENO:0001003', 'UPHENO:0086497', 'HP:0000924', 'UPHENO:0003005', 'UPHENO:0009295', 'UPHENO:0002738', 'HP:0009381', 'HP:0011893', 'UPHENO:0086546', 'UPHENO:0003094', 'UPHENO:0011533', 'UBERON:0000015', 'HP:0000953', 'UBERON:0010912', 'UPHENO:0003020', 'CL:0000151', 'UPHENO:0002577', 'UPHENO:0002967', 'UBERON:0004710', 'UPHENO:0003410', 'GO:0044238', 'UPHENO:0002603', 'HP:0001629', 'UPHENO:0003514', 'UPHENO:0026146', 'UPHENO:0026181', 'UPHENO:0025136', 'UPHENO:0087423', 'UPHENO:0026808', 'UPHENO:0003004', 'HP:0011018', 'UBERON:0001423', 'UBERON:0002102', 'UPHENO:0075219', 'UPHENO:0009163', 'UPHENO:0004615', 'UPHENO:0025545', 'UPHENO:0076692', 'UPHENO:0076739', 'UPHENO:0050121', 'UPHENO:0003366', 'UPHENO:0011559', 'UPHENO:0088170', 'UPHENO:0001002', 'UPHENO:0009366', 'CL:0000329', 'UBERON:0004128', 'UPHENO:0066925', 'UPHENO:0002948', 'UBERON:0002390', 'UBERON:0010688', 'UPHENO:0049952', 'UPHENO:7000101', 'UPHENO:0003812', 'UPHENO:0076703', 'UBERON:0001444', 'UBERON:0007005', 'UBERON:0010363', 'UBERON:0002517', 'UPHENO:0076810', 'HP:0000951', 'UPHENO:0054957', 'UPHENO:0004885', 'HP:0000001', 'UBERON:0000970', 'HP:0011844', 'UPHENO:0003088', 'UPHENO:3000007', 'UPHENO:0004764', 'UBERON:0003067', 'UPHENO:0087663', 'UBERON:0010538', 'UPHENO:0003001', 'UBERON:0000923', 'HP:0033127', 'UPHENO:0077371', 'UPHENO:0076694', 'UPHENO:0002731', 'UBERON:0003606', 'HP:0001875', 'UPHENO:0002804', 'UPHENO:0025661', 'UPHENO:0009209', 'GO:0050794', 'UPHENO:0075944', 'CL:0000219', 'UBERON:0009617', 'HP:0000118', 'UBERON:0012140', 'UPHENO:0069161', 'UPHENO:0026757', 'UBERON:0000383', 'UBERON:0000922', 'UPHENO:0077348', 'UPHENO:0046706', 'UPHENO:0027014', 'UPHENO:0015281', 'UPHENO:0076944', 'UBERON:0003051', 'UBERON:0003080', 'UPHENO:0080300', 'UPHENO:0002944', 'UPHENO:0005055', 'UPHENO:0026506', 'UBERON:0005417', 'UPHENO:0026095', 'UPHENO:0050106', 'UPHENO:0006894', 'UBERON:0000966', 'UPHENO:0002747', 'HP:0012210', 'UBERON:0002204', 'UPHENO:0025507', 'UPHENO:9002003', 'UPHENO:0027630', 'UBERON:0000489', 'UPHENO:0026486', 'MPATH:1000', 'UBERON:0010703', 'UPHENO:0086635', 'HP:0004275', 'HP:0000478', 'UPHENO:0079828', 'UBERON:0002075', 'HP:0000568', 'UBERON:0000061', 'UPHENO:7000223', 'HP:0006496', 'UPHENO:0004802', 'UBERON:0010758', 'UPHENO:0002632', 'UBERON:0004456', 'GO:0010605', 'UPHENO:0008523', 'UPHENO:0035045', 'UPHENO:0003066', 'UBERON:0005177', 'UBERON:0011249', 'UBERON:0000060', 'UPHENO:0005214', 'UPHENO:0009115', 'UBERON:0005451', 'UPHENO:0002308', 'UPHENO:0003186', 'UPHENO:0087347', 'MPATH:120', 'UBERON:0007100', 'UPHENO:0009337', 'UBERON:0000483', 'UPHENO:7000590', 'UPHENO:0025961', 'UBERON:0010708', 'UPHENO:0087531', 'UPHENO:0079835', 'UPHENO:0008604', 'UPHENO:0046740', 'HP:0001881', 'UPHENO:0076727', 'UPHENO:0002751', 'UPHENO:0075902', 'UPHENO:0010743', 'UPHENO:0003207', 'HP:0011873', 'UPHENO:0063722', 'UPHENO:0004888', 'UBERON:0003129', 'UBERON:0001062', 'UPHENO:0025652', 'UPHENO:0003038', 'UPHENO:0087510', 'UPHENO:0004680', 'UPHENO:0003095', 'UPHENO:0025585', 'UBERON:0003081', 'HP:0040072', 'UPHENO:0027631', 'UPHENO:0049652', 'UPHENO:0026023', 'UPHENO:0072332', 'UPHENO:0009391', 'UPHENO:0005080', 'HP:0011446', 'UBERON:0002529', 'HP:0000135', 'UPHENO:0002830', 'UPHENO:0011536', 'UPHENO:0002983', 'UBERON:0011582', 'UPHENO:0041821', 'UPHENO:0076697', 'UPHENO:0003799', 'HP:0000492', 'UPHENO:0025546', 'UPHENO:0079872', 'UBERON:0010314', 'UPHENO:0003049', 'UPHENO:0081581', 'UBERON:0005256', 'UBERON:0008962', 'UPHENO:0076762', 'UPHENO:0003086', 'BFO:0000001', 'UPHENO:0025166', 'UPHENO:0087915', 'UPHENO:0002746', 'UPHENO:0002785', 'UPHENO:0026312', 'UPHENO:0004480', 'UPHENO:0026640', 'UBERON:0012150', 'UBERON:0005944', 'UBERON:0000948', 'UPHENO:0081423', 'UPHENO:0002678', 'UPHENO:0009020', 'UBERON:0006058', 'HP:0002818', 'HP:0002813', 'UPHENO:0063794', 'UPHENO:0005141', 'UPHENO:0004704', 'HP:0000980', 'UPHENO:0088115', 'UPHENO:0005092', 'UBERON:0000467', 'UBERON:0034925', 'UPHENO:0003432', 'UPHENO:0002541', 'UPHENO:0002525', 'UPHENO:7000311', 'UPHENO:0025176', 'UPHENO:0005277', 'GO:0043226', 'UPHENO:0005518', 'UBERON:0004535', 'UPHENO:0086502', 'UPHENO:0009344', 'UPHENO:0004262', 'HP:0001896', 'UBERON:0010316', 'HP:0011297', 'NBO:0000313', 'UPHENO:0076754', 'HP:0031704', 'UBERON:0002513', 'UPHENO:0046741', 'UBERON:0002546', 'UPHENO:0004482', 'UPHENO:0076779', 'UPHENO:0002567', 'UPHENO:0011531', 'UBERON:0007272', 'UBERON:0002203', 'UPHENO:0005437', 'UPHENO:7000632', 'GO:0010556', 'UPHENO:0087363', 'UPHENO:0076805', 'UPHENO:0025852', 'UPHENO:0053559', 'UPHENO:0087849', 'UBERON:0011362', 'UPHENO:0004484', 'UBERON:0010409', 'HP:0011875', 'UPHENO:0002531', 'UBERON:0004765', 'UBERON:0012275', 'UPHENO:0027189', 'UPHENO:0002957', 'UPHENO:0086482', 'HP:0006503', 'HP:0005922', 'HP:0001626', 'UBERON:0010323', 'UPHENO:0087577', 'UPHENO:0002750', 'HP:0100542', 'UBERON:0015061', 'HP:0034430', 'UBERON:0003460', 'UPHENO:0002861', 'UPHENO:0086750', 'UPHENO:0072415', 'HP:0004323', 'UPHENO:0050108', 'UPHENO:0003184', 'UPHENO:0002704', 'UBERON:0013701', 'UPHENO:0004064', 'UBERON:0001436', 'UPHENO:0087501', 'UPHENO:0087081', 'UPHENO:0081451', 'UBERON:0001474', 'UBERON:0035639', 'HP:0001671', 'HP:0001871', 'UBERON:0003103', 'HP:0011729', 'UBERON:0034921', 'UBERON:0004375', 'UPHENO:0087973', 'UBERON:0002386', 'HP:0009815', 'UPHENO:0076745', 'UPHENO:0085330', 'UBERON:0004121', 'UBERON:0003075', 'UPHENO:0052161', 'UPHENO:0076718', 'UPHENO:0079826', 'UPHENO:0002530', 'UPHENO:7000183', 'UPHENO:0002754', 'GO:0006139', 'UPHENO:0004707', 'UPHENO:0011498', 'HP:0011842', 'UBERON:0005178', 'UPHENO:0053330', 'UPHENO:0053610', 'UBERON:0015410', 'UBERON:0000153', 'UBERON:0001839', 'NBO:0000001', 'UBERON:0009881', 'UBERON:0002329', 'UPHENO:0082875', 'UPHENO:0025883', 'UPHENO:0049966', 'HP:0003214', 'UPHENO:0025808', 'HP:0002817', 'UPHENO:0086956', 'HP:0001017', 'UBERON:0004139', 'UPHENO:0003824', 'BFO:0000003', 'HP:0004322', 'UPHENO:0002650', 'UPHENO:0002963', 'UBERON:0010741', 'UPHENO:0002600', 'GO:0043232', 'UPHENO:0049775', 'HP:0001249', 'UPHENO:0002656', 'UPHENO:0002536', 'UPHENO:0076943', 'UPHENO:0011825', 'UPHENO:0087574', 'UBERON:0036215', 'UPHENO:0002593', 'UBERON:0002471', 'UBERON:0008785', 'UPHENO:0002554', 'UPHENO:0011770', 'GO:0050789', 'NCBITaxon:33154', 'HP:0040070', 'UPHENO:0053612', 'UPHENO:0009341', 'UPHENO:0008865', 'UPHENO:0002816', 'UBERON:0002100', 'UPHENO:0088040', 'UBERON:0001463', 'UBERON:0011676', 'UBERON:0000481', 'UPHENO:0087924', 'UPHENO:0026097', 'HP:0012372', 'UBERON:0000073', 'UPHENO:0003811', 'UBERON:0000064', 'UPHENO:0088175', 'UPHENO:0025547', 'UPHENO:0004595', 'UPHENO:0004519', 'UPHENO:0002870', 'UBERON:0003133', 'UPHENO:0025509', 'UPHENO:0079876', 'UBERON:0003104', 'UBERON:0001840', 'CL:0000000', 'UBERON:0002495', 'UBERON:0001460', 'CL:0002422', 'UPHENO:0026096', 'HP:0040064', 'UBERON:0002384', 'UPHENO:0034969', 'UBERON:0007503', 'UBERON:0010712', 'UPHENO:7000538', 'UPHENO:0002526', 'UPHENO:7000299', 'UBERON:0010707', 'UPHENO:0046707', 'UPHENO:0026504', 'UPHENO:0025135', 'UBERON:0003466', 'UBERON:0006598', 'HP:0000325', 'UBERON:0000019', 'UPHENO:0066927', 'UBERON:0004708', 'UPHENO:0011572', 'UPHENO:0087660', 'UPHENO:0026317', 'HP:0009602', 'UBERON:0000475', 'UBERON:0000490', 'UBERON:0000076', 'UBERON:0003950', 'HP:0010974', 'HP:0001876', 'UPHENO:0087928', 'UPHENO:0087349', 'UPHENO:0084816', 'UBERON:0016880', 'GO:0009889', 'HP:0011121', 'UBERON:0007811', 'HP:0000549', 'UBERON:0004088', 'CL:0000094', 'UBERON:0000020', 'UPHENO:0000541', 'UPHENO:0001001', 'UBERON:0001456', 'UBERON:0005389', 'UPHENO:0078629', 'UPHENO:0005110', 'UBERON:0011158', 'UBERON:0009142', 'UPHENO:7000235', 'UPHENO:0003229', 'UPHENO:0084815', 'UPHENO:0004494', 'UBERON:0000047', 'UPHENO:0004721', 'UPHENO:0002825', 'HP:0008422', 'UPHENO:0087852', 'UBERON:0003071', 'UPHENO:0080382', 'UBERON:0005061', 'UPHENO:0041838', 'UBERON:0001457', 'UBERON:0000014', 'UPHENO:0085356', 'UPHENO:0086855', 'HP:0000234', 'HP:0025354', 'UBERON:0002097', 'UPHENO:0002637', 'UPHENO:0005097', 'UPHENO:0003227', 'UPHENO:0050008', 'UBERON:0001801', 'UBERON:0001442', 'UPHENO:0002685', 'UPHENO:0075997', 'UPHENO:0004173', 'UBERON:0000033', 'UPHENO:0086176', 'HP:0001874', 'HP:0000486', 'UBERON:0002049', 'HP:0001911', 'HP:0032309', 'HP:0004742', 'UPHENO:0010795', 'UPHENO:0077399', 'CL:0000775', 'UPHENO:0004525', 'HP:0011991', 'UPHENO:0086589', 'UBERON:0012141', 'UPHENO:7000530', 'HP:0011992', 'UPHENO:0085354', 'UPHENO:0088176', 'GO:0032501', 'HP:0000286', 'CL:0000766', 'UPHENO:0084761', 'HP:0000707', 'UPHENO:0081436', 'HP:0001909', 'UPHENO:0005642', 'UPHENO:0002927', 'UPHENO:0050034', 'UPHENO:0080662', 'UPHENO:0049874', 'UPHENO:0052178', 'HP:0001510', 'UPHENO:0066905', 'UPHENO:0052160', 'UPHENO:0053456', 'UPHENO:0002909', 'UPHENO:0005433', 'UPHENO:0050068', 'UPHENO:0005573', 'UPHENO:0005647', 'GO:0007605', 'UPHENO:0005336', 'UPHENO:0001369', 'UBERON:0001017', 'UPHENO:0086487', 'UPHENO:0005596', 'MPATH:603', 'UPHENO:0009129', 'UPHENO:0050063', 'UBERON:0004176', 'GO:0040007', 'UPHENO:0000543', 'UPHENO:0025544', 'HP:0001507', 'UPHENO:0025811', 'GO:0007275', 'UBERON:0006273', 'GO:0048856', 'UPHENO:0080209', 'UPHENO:0002323', 'UBERON:0004381', 'UPHENO:0086486', 'UPHENO:0087472', 'UPHENO:0069064', 'UPHENO:0069062', 'UPHENO:0027231', 'HP:0008056', 'HP:0000315', 'UPHENO:0069266', 'UPHENO:0069327', 'UBERON:0001712', 'UPHENO:0069674', 'UPHENO:0081424', 'UPHENO:0002940', 'UPHENO:0003056', 'HP:0001873', 'UPHENO:0080352', 'UPHENO:0069254', 'UBERON:0005062', 'UPHENO:0087661', 'HP:0000002', 'UBERON:0002544', 'HP:0011017', 'UPHENO:0076789', 'HP:0000035', 'GO:0009892', 'GO:0051325', 'UPHENO:0003021', 'GO:0051319', 'UBERON:0012151', 'UPHENO:0002311', 'HP:0001939', 'GO:0044848', 'UBERON:0000990', 'HP:0000086', 'UPHENO:7000599', 'GO:0007049', 'GO:0008152', 'UPHENO:0003047', 'UPHENO:0002668', 'UPHENO:0002433', 'UBERON:0000955', 'HP:0009115', 'UBERON:0002105', 'UPHENO:0002267', 'UPHENO:0002385', 'UPHENO:0002269', 'UBERON:0016566', 'GO:0003008', 'GO:0050890', 'UBERON:0004122', 'UPHENO:0002803', 'HP:0000077', 'UPHENO:0054304', 'HP:0000085', 'UBERON:0002389', 'UBERON:8450002', 'UBERON:0002113', 'UPHENO:0005329', 'UPHENO:0002642', 'UPHENO:0041465', 'UBERON:0005172', 'UPHENO:0035034', 'UPHENO:0002467', 'UBERON:0011143', 'UPHENO:0076941', 'UPHENO:0005106', 'UPHENO:0041226', 'UBERON:0001008', 'UBERON:0000916', 'UPHENO:0051124', 'UPHENO:0002962', 'HP:0010935', 'UPHENO:0087427', 'UPHENO:0053561', 'UPHENO:0053588', 'GO:0048523', 'CL:0000255', 'UPHENO:0082761', 'UPHENO:0049743', 'HP:0000815', 'UPHENO:0002928', 'UBERON:0004905', 'UPHENO:0002910', 'UPHENO:0053580', 'UPHENO:0053643', 'UPHENO:0087541', 'GO:0032502', 'UPHENO:0053633', 'HP:0007400', 'UPHENO:0053619', 'UPHENO:0053601', 'UBERON:0034944', 'HP:0000152', 'HP:0000271', 'HP:0001999', 'UPHENO:0041147', 'HP:0012373', 'UPHENO:0087547', 'GO:0042756', 'UPHENO:0004433', 'UPHENO:0041119', 'CL:0000233', 'HP:0008373', 'UPHENO:0066903', 'UBERON:0012139', 'UPHENO:0003055', 'UPHENO:0025776', 'UPHENO:0002648', 'UPHENO:0002386', 'UPHENO:0024906', 'HP:0000078', 'UBERON:0002616', 'UPHENO:0005104', 'UPHENO:0002381', 'UBERON:0015204', 'HP:0000080', 'UPHENO:0049664', 'UPHENO:0066902', 'UBERON:0001776', 'UPHENO:0033560', 'UPHENO:0066972', 'UPHENO:0004507', 'UPHENO:0002206', 'UPHENO:0087339', 'UPHENO:0086016', 'UPHENO:0003116', 'UPHENO:0001147', 'UPHENO:0002880', 'HP:0000818', 'UPHENO:0002378', 'UPHENO:0066945', 'CL:0000081', 'HP:0000496', 'UBERON:0000991', 'UBERON:0015025', 'HP:0000081', 'UPHENO:0002682', 'UPHENO:0003182', 'UPHENO:0050625', 'UPHENO:0075787', 'UBERON:0002342', 'UBERON:0003077', 'UPHENO:0072212', 'UBERON:0004100', 'UBERON:0003918', 'UPHENO:0002576', 'UPHENO:3000000', 'UPHENO:0003414', 'UPHENO:0086568', 'UBERON:0002193', 'UBERON:0004120', 'UPHENO:0081439', 'UPHENO:0003485', 'UPHENO:0003022', 'UPHENO:0002952', 'UPHENO:0012440', 'UBERON:0006800', 'UPHENO:0004401', 'UPHENO:0075804', 'UPHENO:0076730', 'UBERON:0007285', 'UBERON:0003128', 'UPHENO:0004344', 'UBERON:0004761', 'UBERON:0011159', 'UPHENO:0046552', 'GO:0005575', 'UPHENO:0003412', 'UPHENO:0026344', 'UPHENO:0004372', 'GO:0010467', 'UPHENO:0004711', 'UPHENO:0025855', 'UBERON:0000477', 'HP:0002977', 'UBERON:0004770', 'UPHENO:0046445', 'UBERON:0000466', 'CL:0000558', 'UBERON:0007499', 'UBERON:0001846', 'HP:0001371', 'UPHENO:0046698', 'UBERON:0007845', 'UBERON:0005253', 'UBERON:0002241', 'UBERON:0001703', 'GO:0006259', 'UPHENO:0072315', 'UBERON:0001694', 'UPHENO:0003210', 'UPHENO:0046483', 'UPHENO:0002698', 'UPHENO:0008709', 'UPHENO:0088186', 'UBERON:0000464', 'UBERON:0005085', 'UPHENO:0002699', 'UPHENO:0081440', 'UPHENO:0002586', 'UBERON:0007846', 'GO:0060255', 'UPHENO:0076710', 'UBERON:8450003', 'UPHENO:0003044', 'UBERON:0002416', 'UBERON:0002417', 'UPHENO:0072402', 'UPHENO:0072263', 'CL:0000457', 'HP:0011805', 'UPHENO:0046759', 'UBERON:0005090', 'HP:0003549', 'UBERON:0000982', 'UBERON:0015023', 'HP:0011843', 'UPHENO:0053566', 'UPHENO:0046505', 'UPHENO:0052694', 'HP:0100261', 'UBERON:0010313', 'UPHENO:0046638', 'UPHENO:0002708', 'UPHENO:0069218', 'UBERON:0000062', 'UPHENO:0072266', 'UPHENO:0087058', 'UBERON:0001690', 'UBERON:0005913', 'UPHENO:0003158', 'GO:0022403', 'UPHENO:0087888', 'HP:0034392', 'UPHENO:0027017', 'BFO:0000141', 'UBERON:0004537', 'UPHENO:0009021', 'UBERON:0003069', 'GO:0009987', 'UBERON:0000043', 'GO:0090304', 'UPHENO:0075938', 'UPHENO:0003212', 'UBERON:0004923', 'UBERON:0004681', 'UPHENO:0002643', 'UPHENO:0086484', 'UPHENO:0053563', 'UPHENO:0004454', 'UPHENO:0002403', 'UPHENO:0069007', 'UBERON:0005497', 'UPHENO:0049622', 'UPHENO:0087597', 'HP:0012733', 'UBERON:0010371', 'UBERON:0000479', 'UPHENO:0033604', 'UPHENO:0087232', 'UPHENO:0081566', 'NBO:0000444', 'UPHENO:0041629', 'UPHENO:0018418', 'UPHENO:0005029', 'UPHENO:7000169', 'UBERON:5002389', 'UPHENO:0003093', 'UPHENO:0008827', 'UBERON:0010222', 'UPHENO:0002360', 'UBERON:0000964', 'UPHENO:0002430', 'HP:0004325', 'UBERON:0012475', 'UBERON:0012430', 'UPHENO:0002550', 'UPHENO:0002211', 'UPHENO:0050116', 'UPHENO:0054374', 'HP:0001000', 'GO:0043473', 'UPHENO:0074575', 'UPHENO:0054970', 'GO:0007631', 'UPHENO:0080114', 'UPHENO:0075159', 'UPHENO:0001134', 'UBERON:0011250', 'UBERON:0001084', 'UPHENO:0072355', 'UPHENO:0072345', 'UPHENO:0049964', 'UBERON:0012180', 'HP:0000240', 'UBERON:0011823', 'UBERON:0001711', 'UPHENO:0002543', 'UPHENO:0002301', 'UPHENO:0072255', 'UPHENO:0010808', 'UBERON:1000021', 'UPHENO:0025882', 'UPHENO:0001360', 'UBERON:0013766', 'UPHENO:0026806', 'UPHENO:0076761', 'HP:0030669', 'UPHENO:0052159', 'UPHENO:0001392', 'UPHENO:0025211', 'UBERON:0015001', 'BFO:0000004', 'UPHENO:0075878', 'HP:0012638', 'UPHENO:0002581', 'UPHENO:0087307', 'UPHENO:0041467', 'UPHENO:0001072', 'UPHENO:0005319', 'HP:0008678', 'UPHENO:0003163', 'UPHENO:0002712', 'UPHENO:0011749', 'UPHENO:0001303', 'UPHENO:0008816', 'UPHENO:0026507', 'UPHENO:0011566', 'UPHENO:0008545', 'UPHENO:0008825', 'UPHENO:0049873', 'UPHENO:0025631', 'HP:0000104', 'UBERON:0036146', 'UPHENO:0026630', 'UPHENO:0009011', 'UPHENO:0004521', 'UPHENO:0003065', 'UPHENO:0008593', 'UPHENO:0026308', 'UPHENO:0011931', 'UPHENO:0049586', 'GO:0033554', 'UPHENO:0011739', 'UPHENO:0085301', 'UPHENO:7000294', 'UBERON:0002371', 'UBERON:0006003', 'CL:0002092', 'UBERON:0000465', 'UPHENO:0086048', 'UPHENO:0004969', 'HP:0001518', 'UBERON:0008193', 'UPHENO:0010763', 'HP:0001034', 'UPHENO:0010799', 'UPHENO:0002547', 'UPHENO:0010850', 'HP:0003221', 'UPHENO:0078606', 'UPHENO:0049620', 'GO:0043170', 'GO:0048519', 'UBERON:0003135', 'CL:0000764', 'UPHENO:0084763', 'UPHENO:0050065', 'UPHENO:0008430', 'UPHENO:0049868', 'HP:0003220', 'GO:0031049', 'UPHENO:0050007'], 'has_phenotype_closure_label': ['autopod endochondral element', 'phalanx endochondral element', 'manual digit phalanx endochondral element', 'phalanx', 'autopod bone', 'Duplication of bones involving the upper extremities', 'manual digit bone', 'manual digit digitopodial skeleton', 'skeleton of manual digitopodium', 'Duplication of hand bones', 'manus bone', 'individual digit of digitopodial skeleton', 'skeleton of digitopodium', 'Abnormal finger phalanx morphology', 'Duplication of thumb phalanx', 'Finger aplasia', 'Absent thumb', 'aplastic manual digit 1', 'Irregular hyperpigmentation', 'Cafe-au-lait spot', 'Hypermelanotic macule', 'photoreceptor array', 'circulatory disorder', 'organ part physiology phenotype', 'ribosome biogenesis', 'uvea', 'neural fold', 'neural fold phenotype', 'subcutaneous hemorrhage', 'ribosome function phenotype', 'cranial neural crest', 'epithelial fold', 'cellular anatomical structure', 'pathological phenotype observation', 'choroidal blood vessel phenotype', 'head blood vessel', 'macula lutea', 'chorioretinal region', 'vascular system', 'head blood vessel phenotype', 'vasculature of organ phenotype', 'choroidal blood vessel morphology phenotype', 'cellular_component', 'vasculature phenotype', 'neural crest morphology phenotype', 'Generalized abnormality of skin', 'absent manual digit', 'choroidal blood vessel', 'integumentary adnexa', 'vasculature', 'organelle', 'photoreceptor array phenotype', 'neural groove phenotype', 'neural crest phenotype', 'blood vessel', 'skin vasculature morphology; vascular skin abnormality', 'vasculature of eye phenotype', 'vasculature of head phenotype', 'epithelial fold phenotype', 'cranial blood vasculature', 'cranial neural crest phenotype', 'vasculature of eye', 'retina', 'optic choroid morphology phenotype', 'anatomical conduit physiology phenotype', 'Bruising susceptibility', 'cellular_component function phenotype', 'mesenchyme derived from head neural crest phenotype', 'membraneless organelle', 'intracellular organelle', 'Abnormality of the vasculature', 'blood vessel phenotype', 'manual digitopodium bone', 'Vascular skin abnormality', 'ribosome', 'cellular_component phenotype', 'integumentary adnexa physiology phenotype', 'vessel', 'blood vasculature', 'vasculature of eye morphology phenotype', 'blood vessel physiology phenotype', 'vessel physiology phenotype', 'decreased size of the material anatomical entity in the pectoral complex', 'Abnormality of the hand', 'decreased size of the anatomical entity in the pectoral complex', 'digit', 'digit 1 plus metapodial segment', 'manual digit plus metapodial segment', 'manual digit phenotype', 'decreased size of the anatomical structure in the pectoral complex', 'decreased length of digit', 'manual digitopodium region', 'digitopodium region', 'segment of manus', 'embryonic autopod plate', 'manual digit 1 morphology phenotype', 'decreased length of manual digit 1', 'manus', 'embryonic autopod plate morphology phenotype', 'digit morphology phenotype', 'acropodium region', 'decreased length of manual digit 1 or 5', 'Abnormal hand morphology', 'decreased length of manual digit', 'segment of autopod', 'skeleton of manus', 'Abnormal finger morphology', 'autopodial extension', 'digit plus metapodial segment', 'autopod region phenotype', 'manus phenotype', 'head blood vessel morphology phenotype', 'decreased length of organism subdivision', 'Short thumb', 'decreased size of the autopodial extension', 'autopodial skeleton', 'posterior segment of eyeball morphology phenotype', 'superficial fascia', 'anatomical entity morphology in the manus phenotype', 'Complete duplication of thumb phalanx', 'manual digit 1 plus metapodial segment', 'pathological entity', 'decreased size of the manual digit', 'male reproductive organ', 'male organism', 'male organism phenotype', 'Cryptorchidism', 'localised reproductive structure', 'external male genitalia phenotype', 'male reproductive organ phenotype', 'localised male reproductive organ', 'Abnormal testis morphology', 'male reproductive organ morphology phenotype', 'external genitalia morphology; external genitalia phenotype', 'testis phenotype', 'male reproductive system phenotype', 'Abnormality of the male genitalia', 'number of anatomical enitites of type organism subdivision phenotype', 'normal growth on benomyl', 'male reproductive system morphology phenotype', 'Abnormal male external genitalia morphology', 'Macule', 'Hypopigmented macule', 'Localized skin lesion', 'blood island', 'number of bone marrow cell phenotype', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'decreased number of anatomical structure in the multicellular organism', 'decreased number of anatomical structure in the bone element', 'decreased number of material anatomical entity in the bone element', 'decreased number of anatomical entity in the bone marrow', 'decreased number of material anatomical entity in the multicellular organism', 'developing mesenchymal condensation phenotype', 'vertebra morphology phenotype', 'migrating mesenchyme population', 'cuneate anatomical entity', 'Abnormal vertebral morphology', 'epithelial vesicle', 'Abnormal form of the vertebral bodies', 'vertebral column morphology phenotype', 'vertebral column', 'trunk mesenchyme', 'cell condensation', 'presomitic mesoderm', 'bony vertebral centrum', 'somite', 'sclerotome morphology phenotype', 'bone marrow cell phenotype', 'migrating mesenchyme population phenotype', 'vertebral centrum element', 'vertebral element', 'Aplasia/hypoplasia involving bones of the hand', 'presomitic mesoderm morphology phenotype', 'cartilage element phenotype', 'bony vertebral centrum morphology phenotype', 'trunk mesenchyme phenotype', 'cell condensation phenotype', 'irregular bone', 'Abnormality of the vertebral column', 'cuneate vertebra', 'cartilaginous condensation', 'cellular response to stimulus', 'response to stress', 'DNA metabolic process phenotype', 'nucleic acid metabolic process phenotype', 'cellular response to stress phenotype', 'digit 1 digitopodial skeleton', 'primary metabolic process phenotype', 'DNA metabolic process', 'DNA repair', 'DNA repair phenotype', 'Deficient excision of UV-induced pyrimidine dimers in DNA', 'response to stress phenotype', 'nucleobase-containing compound metabolic process', 'primary metabolic process', 'cellular response to stress', 'response to stimulus phenotype', 'size of skull phenotype', 'aplasia or hypoplasia of telencephalon', 'decreased size of the head', 'Decreased head circumference', 'decreased length of digit 1', 'postcranial axial skeletal system', 'sclerotome phenotype', 'Abnormal axial skeleton morphology', 'Abnormal cerebral morphology', 'Aplasia/Hypoplasia of the cerebrum', 'digit phenotype', 'decreased size of the subdivision of organism along main body axis', 'decreased size of the organism subdivision', 'axial skeleton plus cranial skeleton phenotype', 'nucleic acid metabolic process', 'Abnormal nervous system morphology', 'Abnormal skull morphology', 'Morphological central nervous system abnormality', 'Aplasia/Hypoplasia involving the central nervous system', 'decreased qualitatively system process', 'sensory perception of mechanical stimulus phenotype', 'decreased sensory perception of sound', 'Duplication of phalanx of hand', 'sensory perception of sound phenotype', 'decreased qualitatively sensory perception', 'sensory perception', 'ear physiology phenotype', 'localised testis', 'Abnormal ear physiology', 'external genitalia', 'sensory perception of mechanical stimulus', 'decreased qualitatively sensory perception of mechanical stimulus', 'sensory perception of sound', 'Abnormality of the ear', 'sensory perception phenotype', 'decreased nervous system process', 'decreased qualitatively sensory perception of sound', 'decreased number of anatomical entity in the bone element', 'negative regulation of biological process phenotype', 'Chromosomal breakage induced by crosslinking agents', 'negative regulation of gene expression', 'negative regulation of macromolecule biosynthetic process', 'negative regulation of cellular process phenotype', 'negative regulation of cellular process', 'biosynthetic process phenotype', 'regulation of gene expression phenotype', 'programmed DNA elimination by chromosome breakage', 'programmed DNA elimination', 'programmed DNA elimination by chromosome breakage phenotype', 'regulation of macromolecule metabolic process phenotype', 'subdivision of head phenotype', 'subdivision of head', 'decreased size of the digit', 'All', 'multicellular organism height phenotype', 'Abnormal brain morphology', 'cardiovascular system', 'multicellular organism phenotype', 'simple eye phenotype', 'visual system', 'brain morphology phenotype', 'face phenotype', 'blood vessel morphology phenotype', 'regional part of nervous system phenotype', 'skin of body phenotype', 'Abnormal immune system morphology', 'forelimb skeleton phenotype', 'absent lateral structure', 'Leukemia', 'absent multicellular anatomical structure in the renal system', 'leukocyte', 'neoplasm phenotype', 'Neoplasm', 'neural groove', 'absent forelimb bone in the forelimb', 'absent anatomical structure in the tissue', 'Pallor', 'aplastic forelimb zeugopod bone', 'male reproductive system', 'thoracic segment of trunk', 'heart plus pericardium', 'Hearing impairment', 'splanchnic layer of lateral plate mesoderm phenotype', 'main body axis', 'localised kidney', 'anterior lateral plate mesoderm', 'nucleobase-containing compound metabolic process phenotype', 'Microcephaly', 'regulation of biosynthetic process phenotype', 'circulatory organ phenotype', 'immature eye phenotype', 'cartilaginous neurocranium phenotype', 'subdivision of organism along main body axis phenotype', 'cardiac ventricle morphology phenotype', 'gene expression', 'Abnormal cardiovascular system morphology', 'absent organ in the tissue', 'heart tube morphology phenotype', 'primary subdivision of cranial skeletal system phenotype', 'Abnormality of the genitourinary system', 'cardiovascular system morphology phenotype', 'thoracic segment organ phenotype', 'body proper', 'autopod region morphology phenotype', 'epicanthal fold', 'subdivision of trunk', 'ectoderm phenotype', 'Abnormality of the upper limb', 'anatomical structure morphology in the heart phenotype', 'eyelid morphology phenotype', 'heart tube', 'eye phenotype', 'limb bone', 'Abnormality of head or neck', 'primary heart field', 'cardiopharyngeal field', 'developmental process phenotype', 'anlage', 'sense organ', 'nervous system process phenotype', 'incomplete closing of the interventricular septum', 'response to stimulus', 'Decreased total neutrophil count', 'nucleate cell', 'structure with developmental contribution from neural crest phenotype', 'material anatomical entity morphology in the heart phenotype', 'meso-epithelium phenotype', 'Abnormal tendon morphology', 'interventricular septum morphology phenotype', 'trunk region element', 'anatomical structure mass phenotype', 'Hematological neoplasm', 'multicellular organism morphology phenotype', 'localised multicellular anatomical structure', 'Abnormal forebrain morphology', 'cardiogenic plate morphology phenotype', 'primordium phenotype', 'decreased size of the connective tissue', 'enucleated reticulocyte morphology phenotype', 'Hearing abnormality', 'absent bone of free limb or fin in the forelimb', 'Abnormal bleeding', 'number of anatomical enitites of type reticulocyte phenotype', 'cerebral hemisphere', 'kidney', 'enucleated reticulocyte', 'bone of appendage girdle complex', 'Reticulocytopenia', 'central nervous system phenotype', 'pectoral appendage bud', 'decreased number of reticulocyte', 'Abnormal neutrophil morphology', 'Aplasia/Hypoplasia of the thumb', 'regional part of brain', 'leukocyte morphology phenotype', 'pre-chordal neural plate phenotype', 'number of anatomical enitites of type trunk region element phenotype', 'embryo', 'future central nervous system', 'Abnormality of skin pigmentation', 'integument phenotype', 'Abnormal eyelid morphology', 'number of myeloid cell phenotype', 'decreased length of autopodial extension', 'multi-tissue structure', 'thoracic segment organ', 'Eukaryota', 'phalanx of manus', 'number of hematopoietic cell phenotype', 'cranial placode', 'homeostatic process phenotype', 'multi-tissue structure phenotype', 'Abnormal cellular immune system morphology', 'Bone marrow hypocellularity', 'heart primordium', 'ectoderm', 'immune system morphology phenotype', 'biological_process', 'multi-limb segment region phenotype', 'decreased number of platelet', 'viscus', 'localised compound organ', 'compound organ', 'primordium', 'localised material anatomical entity', 'decreased number of anatomical structure', 'hematopoietic cell', 'manual digit', 'skull morphology phenotype', 'circulatory system phenotype', 'organ part phenotype', 'absent anatomical structure in the limb', 'occurrent', 'incomplete closing of the cardiac septum', 'localised abdomen element', 'regional part of brain phenotype', 'absent radius endochondral element', 'ectoderm-derived structure phenotype', 'organ subunit phenotype', 'integumental system', 'epithelial tube', 'immune system phenotype', 'kidney morphology phenotype', 'Eumetazoa', 'system process phenotype', 'circulatory system', 'nervous system phenotype', 'choroidal neovascularization', 'irregular bone phenotype', 'platelet', 'multi organ part structure phenotype', 'neural plate phenotype', 'absent bone of pectoral complex in the limb', 'decreased qualitatively multicellular organismal process', 'immaterial anatomical entity', 'Abnormality of the ocular adnexa', 'nervous system', 'absent endochondral element', 'root', 'anatomical entity morphology in the skeleton of pectoral complex phenotype', 'gastrula morphology phenotype', 'opening of the anatomical entity', 'decreased number of myeloid cell', 'epithelium', 'subdivision of trunk phenotype', 'forebrain phenotype', 'nervous system physiology phenotype', 'Abnormal skeletal muscle morphology', 'Abnormal heart morphology', 'Abnormal localization of kidney', 'forelimb morphology phenotype', 'regular connective tissue', 'epithelium phenotype', 'aplasia or hypoplasia of manual digit', 'paired limb/fin segment phenotype', 'Anterior wedging of T12', 'biological_process phenotype', 'renal/urinary system phenotype', 'Abnormal platelet morphology', 'telencephalon phenotype', 'blastula', 'bone of pectoral complex morphology phenotype', 'interventricular septum', 'Abnormality of neutrophils', 'eyelid', 'brain phenotype', 'decreased number of cell', 'intracellular anatomical structure', 'absent organ in the limb', 'neural crest', 'ectoderm morphology phenotype', 'renal system phenotype', 'hemorrhage and non-specified extravasation', 'neurectoderm', 'cerebral hemisphere morphology phenotype', 'Abnormal limb bone morphology', 'future nervous system', 'decreased length of tissue', 'cardiogenic splanchnic mesoderm phenotype', 'Abnormal platelet count', 'forebrain morphology phenotype', 'erythrocyte', 'temporal bone', 'postcranial axial skeleton', 'blood cell', 'Abnormality of the face', 'decreased number of material anatomical entity', 'cell phenotype', 'tube', 'future central nervous system phenotype', 'cranial skeletal system phenotype', 'cranial skeletal system', 'multicellular anatomical structure phenotype', 'cardiac septum morphology phenotype', 'absent forelimb endochondral element', 'behavior process', 'Aplasia/Hypoplasia affecting the eye', 'cardiac chamber phenotype', 'size of eyeball of camera-type eye phenotype', 'cell', 'forelimb zeugopod bone morphology phenotype', 'integument', 'localised reproductive organ', 'Renal hypoplasia/aplasia', 'absent skeletal element in the limb', 'Aplasia/hypoplasia of the extremities', 'ectoderm-derived structure', 'pectoral appendage skeleton phenotype', 'absent anatomical entity in the forelimb', 'forebrain', 'absent anatomical entity in the limb', 'decreased size of the anatomical structure', 'appendage girdle complex', 'bone marrow phenotype', 'renal collecting system phenotype', 'mesenchyme derived from head neural crest', 'macula lutea morphology phenotype', 'subdivision of skeletal system', 'nervous system morphology phenotype', 'multicellular organism', 'absent bone of free limb or fin in the limb', 'anterior polar cataract', 'eye morphology', 'hematopoietic system morphology phenotype', 'biological_process rate phenotype', 'absent forelimb zeugopod bone', 'inner ear canal', 'skin of head', 'primary circulatory organ', 'forelimb endochondral element', 'blood island phenotype', 'Anemic pallor', 'heart tube phenotype', 'drinking behavior', 'Opisthokonta', 'Abnormal thumb morphology', 'long bone morphology phenotype', 'manus morphology phenotype', 'primary heart field phenotype', 'absent anatomical entity in the limb bud', 'forelimb zeugopod skeleton', 'presomitic mesoderm phenotype', 'Abnormal skin morphology', 'appendicular skeletal system', 'tissue', 'endochondral element phenotype', 'abdomen element phenotype', 'absent material anatomical entity in the skeletal system', 'homeostatic process', 'cardiogenic splanchnic mesoderm morphology phenotype', 'Abnormal digit morphology', 'macromolecule metabolic process phenotype', 'cavitated compound organ phenotype', 'compound organ phenotype', 'craniocervical region phenotype', 'neutrophil morphology phenotype', 'upper limb segment phenotype', 'ecchymosis', 'embryo morphology phenotype', 'germ layer / neural crest', 'simple eye', 'intracellular organelle function phenotype', 'pectoral appendage', 'lateral plate mesoderm phenotype', 'platelet phenotype', 'Abnormality of the endocrine system', 'reproductive structure', 'forelimb skeleton', 'vertebra', 'mesoderm-derived structure', 'bone of appendage girdle complex phenotype', 'incomplete closing of the anatomical structure', 'central nervous system morphology phenotype', 'structure with developmental contribution from neural crest', 'organ', 'semicircular canal phenotype', 'subdivision of skeletal system phenotype', 'incomplete closing of the anatomical entity', 'reproductive structure physiology phenotype', 'absent forelimb long bone', 'digit 1 or 5 phenotype', 'epithelial vesicle phenotype', 'taxon specific phenotype', 'gonad phenotype', 'entity', 'immaterial anatomical entity phenotype', 'absent material anatomical entity in the multicellular organism', 'epithelial sac', 'number of anatomical enitites of type material anatomical entity phenotype', 'tendon', 'Abnormal ventricular septum morphology', 'system', 'Abnormal forearm morphology', 'limb bone phenotype', 'Neurodevelopmental abnormality', 'number of cell phenotype', 'behavior', 'Neoplasm by anatomical site', 'agenesis of anatomical entity', 'digit 1 or 5', 'DNA damage response', 'radius bone', 'cornea', 'arm bone', 'upper limb segment', 'trunk', 'anlage phenotype', 'developing mesenchymal condensation', 'absent endochondral bone', 'absent forelimb endochondral element in the forelimb', 'presumptive structure', 'absent forelimb bone', 'genitourinary system phenotype', 'anatomical entity', 'embryonic structure', 'heart morphology phenotype', 'organism subdivision phenotype', 'manual digit 1 phalanx endochondral element', 'posterior segment of eyeball', 'number of anatomical enitites of type endochondral bone phenotype', 'testis', 'paired limb/fin bud phenotype', 'anterior region of body', 'forelimb bone phenotype', 'abdominal segment element', 'forelimb zeugopod phenotype', 'Abnormality of the immune system', 'limb endochondral element phenotype', 'cell cycle phenotype', 'absent trunk region element', 'arm', 'Abnormal reticulocyte morphology', 'aplastic anatomical entity', 'pectoral appendage skeleton', 'multi organ part structure physiology phenotype', 'decreased functionality of the multicellular anatomical structure', 'anatomical collection phenotype', 'absent limb long bone', 'absent material anatomical entity in the forelimb', 'number of anatomical enitites of type endochondral element phenotype', 'pectoral appendage bud phenotype', 'zeugopodial skeleton', 'skin of face morphology phenotype', 'blood cell phenotype', 'subdivision of skeleton phenotype', 'embryonic tissue phenotype', 'regulation of biological process', 'number of anatomical enitites of type abdominal segment element phenotype', 'thoracic cavity element', 'subdivision of skeleton', 'anatomical entity phenotype', 'Prolonged G2 phase of cell cycle', 'increased size of the zone of organ', 'Abnormality of thrombocytes', 'cellular organisms', 'absent bone of free limb or fin', 'zeugopod phenotype', 'vasculature of head', 'appendage phenotype', 'embryonic structure phenotype', 'germ layer phenotype', 'absent bone of pectoral complex in the forelimb', 'anterior neural tube phenotype', 'Metazoa', 'behavior phenotype', 'surface structure phenotype', 'telencephalon', 'Anemia', 'ocular adnexa', 'immune system', 'forelimb bud morphology phenotype', 'digit 1', 'musculature phenotype', 'metabolic process', 'bone of pectoral complex phenotype', 'Abnormal upper limb bone morphology', 'anatomical conduit', 'ear vesicle', 'absent skeletal element', 'incomplete closing of the material anatomical entity', 'cardiac ventricle', 'camera-type eye phenotype', 'heart phenotype', 'head mesenchyme', 'decreased number of hematopoietic cell', 'absent bone element', 'abdominal segment of trunk', 'Aplasia/hypoplasia involving bones of the upper limbs', 'petrous part of temporal bone', 'cardiogenic plate', 'neural tube', 'mesoderm', 'neural crest-derived structure phenotype', 'absent anatomical structure', 'number of anatomical enitites of type anatomical entity phenotype', 'endochondral bone', 'biological phase', 'multicellular anatomical structure', 'process', 'basicranium', 'continuant', '3-D shape anatomical entity', 'radius bone morphology phenotype', 'biogenic amine secreting cell', 'absent skeletal element in the forelimb', 'absent limb endochondral element in the forelimb', 'eukaryotic cell', 'germ layer', 'visual system phenotype', 'organ system subdivision', 'aplasia or hypoplasia of anatomical entity', 'absent anatomical structure in the skeletal system', 'vascular system morphology phenotype', 'erythrocyte morphology phenotype', 'vestibulo-auditory system', 'Strabismus', 'appendicular skeleton morphology phenotype', 'anatomical system', 'decreased qualitatively developmental process', 'germ layer morphology phenotype', 'manual digit 1 phalanx', 'presumptive ectoderm', 'dense mesenchyme tissue phenotype', 'Abnormal reproductive system morphology', 'renal collecting system', 'decreased sensory perception', 'septum', 'multicellular organismal process phenotype', 'absent organ in the multicellular organism', 'decreased functionality of the material anatomical entity', 'decreased size of the multicellular anatomical structure in the pectoral complex', 'negative regulation of metabolic process phenotype', 'paired limb/fin', 'limb segment', 'limb morphology phenotype', 'Abnormality of limb bone', 'cardiac septum', 'independent continuant', 'Abnormal myeloid leukocyte morphology', 'absent organ', 'axial skeleton plus cranial skeleton morphology phenotype', 'embryo development', 'decreased length of regular connective tissue', 'appendicular skeleton', 'limb skeleton subdivision phenotype', 'forelimb zeugopod bone', 'bone element', 'regulation of metabolic process', 'subdivision of organism along appendicular axis', 'decreased size of the multicellular anatomical structure', 'autopodial extension phenotype', 'absent organ in the forelimb', 'Decreased multicellular organism mass', 'number of anatomical enitites of type organ phenotype', 'Abnormality of mental function', 'localised organ', 'Aplasia/hypoplasia involving forearm bones', 'decreased system process', 'incomplete closing of the septum', 'pectoral complex', 'size of head phenotype', 'mesenchyme phenotype', 'absent arm bone', 'forelimb long bone phenotype', 'renal system morphology phenotype', 'limb bone morphology phenotype', 'pre-chordal neural plate', 'absent material anatomical entity', 'upper eyelid', 'anatomical conduit phenotype', 'Abnormality of limbs', 'decreased length of connective tissue', 'aplasia or hypoplasia of radius bone', 'skeleton of limb phenotype', 'forelimb bud phenotype', 'dense mesenchyme tissue', 'myeloid leukocyte', 'head paraxial mesoderm', 'embryo phenotype', 'cardiac chamber', 'lens of camera-type eye phenotype', 'cerebral amyloid angiopathy', 'absent forelimb zeugopod bone in the forelimb', 'paraxial mesoderm morphology phenotype', 'heart primordium phenotype', 'forelimb zeugopod bone phenotype', 'absent material anatomical entity in the limb', 'pectoral appendage phenotype', 'material anatomical entity phenotype', 'heart', 'erythroid lineage cell morphology phenotype', 'lateral plate mesoderm morphology phenotype', 'autopod region', 'endochondral bone phenotype', 'increased biological_process', 'lateral plate mesoderm', 'Abnormal skeletal morphology', 'bone element phenotype', 'Abnormality of body height', 'paired limb/fin phenotype', 'anatomical entity dysfunction in independent continuant', 'absent material anatomical entity in the tissue', 'Short finger', 'muscle structure', 'bone marrow', 'retina morphology phenotype', 'ecto-epithelium phenotype', 'head paraxial mesoderm morphology phenotype', 'phenotype', 'pathological anatomical entity', 'metabolic process phenotype', 'anatomical system phenotype', 'zeugopod', 'reticulocyte', 'absent multicellular anatomical structure', 'organism subdivision', 'meso-epithelium', 'anucleate cell', 'anatomical cluster phenotype', 'absent anatomical structure in the multicellular organism', 'anatomical surface region phenotype', 'chondrocranium', 'Abnormal forearm bone morphology', 'regulation of cellular process phenotype', 'material anatomical entity', 'Abnormal cardiac ventricle morphology', 'arm phenotype', 'decreased qualitatively embryo development', 'Short digit', 'limb long bone phenotype', 'genitourinary system', 'Absent forearm bone', 'consumption behavior phenotype', 'radius bone phenotype', 'increased pigmentation in skin of body', 'vessel phenotype', 'skeleton of pectoral complex', 'forelimb zeugopod morphology phenotype', 'eyeball of camera-type eye', 'absent limb bone in the limb', 'ectodermal placode phenotype', 'absent arm bone in the forelimb', 'interphase', 'absent long bone in the forelimb', 'mesenchyme morphology phenotype', 'shape of continuant phenotype', 'Abnormality of DNA repair', 'splanchnic layer of lateral plate mesoderm', 'absent material anatomical entity in the limb bud', 'material entity', 'presumptive structure phenotype', 'optic choroid', 'skeletal element phenotype', 'non-material anatomical boundary', 'skeleton', 'Abnormality of thumb phalanx', 'ocular surface region morphology phenotype', 'regulation of biological process phenotype', 'endochondral element', 'musculature of body', 'decreased qualitatively biological_process', 'absent forelimb long bone in the forelimb', 'forelimb endochondral element phenotype', 'anatomical entity morphology in the pectoral complex phenotype', 'number of anatomical enitites of type bone element phenotype', 'cornea scarring; corneal scarring', 'ear', 'neurectoderm phenotype', 'appendage', 'neural tube phenotype', 'absent forelimb endochondral element in the limb', 'platelet morphology', 'limb bud', 'erythroid lineage cell', 'limb bud morphology phenotype', 'Flexion contracture', 'bony labyrinth phenotype', 'trunk region element phenotype', 'negative regulation of gene expression phenotype', 'number of anatomical enitites of type skeletal element phenotype', 'mesoderm-derived structure phenotype', 'skeletal system phenotype', 'cardiogenic splanchnic mesoderm', 'anterior segment of eyeball morphology phenotype', 'limb', 'semicircular canal', 'absent endochondral bone in the forelimb', 'anatomical entity morphology phenotype', 'absent multicellular anatomical structure in the multicellular organism', 'embryonic tissue morphology phenotype', 'absent anatomical entity in the multicellular organism', 'limb phenotype', 'embryonic tissue', 'mesenchyme', 'central nervous system', 'pallor', 'skeletal system morphology phenotype', 'absent anatomical structure in the forelimb', 'developing anatomical structure', 'localised gonad', 'opaque lens of camera-type eye', 'embryo development rate phenotype', 'forelimb zeugopod', 'vertebral element phenotype', 'skin of head morphology phenotype', 'primary circulatory organ phenotype', 'hemolymphoid system', 'system process', 'motile cell', 'long bone phenotype', 'lateral structure', 'decreased length of digit 1 or 5', 'bone marrow cell', 'Abnormal external genitalia morphology', 'anatomical entity morphology in the heart phenotype', 'Thrombocytopenia', 'absent multicellular anatomical structure in the skeletal system', 'kinesthetic behavior', 'epithelial tube phenotype', 'musculoskeletal system', 'regional part of nervous system', 'testis morphology phenotype', 'tube phenotype', 'organ phenotype', 'integumental system phenotype', 'skeletal system', 'aplasia or hypoplasia of skeleton', 'number of anatomical enitites of type neutrophil phenotype', 'long bone', 'neural plate', 'paired limb/fin bud', 'decreased anatomical structure mass', 'limb endochondral element', 'U-shaped kidney', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'germ layer / neural crest phenotype', 'Aplasia/Hypoplasia of the radius', 'absent bone of pectoral complex', 'anatomical structure phenotype', 'absent limb bone in the forelimb', 'absent bone of appendage girdle complex', 'Absent radius', 'skeleton of manual acropodium', 'articular system', 'hematopoietic system phenotype', 'Abnormality of the skeletal system', 'optic cup morphology phenotype', 'absent limb bone', 'manual digit 1 digitopodial skeleton', 'vestibular system', 'anatomical wall', 'absent multicellular anatomical structure in the tissue', 'radius endochondral element', 'pigmentation', 'disconnected anatomical group', 'Abnormality of multiple cell lineages in the bone marrow', 'absent bone of appendage girdle complex in the forelimb', 'absent endochondral element in the limb', 'absent multicellular anatomical structure in the limb', 'absent bone element in the limb', 'cardiovascular system phenotype', 'vertebra phenotype', 'telencephalon morphology phenotype', 'shape of face phenotype', 'anatomical system physiology phenotype', 'anatomical collection', 'cellular response to stimulus phenotype', 'size of anatomical entity phenotype', 'pigmentation phenotype', 'absent forelimb bone in the limb', 'absent limb endochondral element', 'sense organ phenotype', 'eye', 'neural plate morphology phenotype', 'decreased length of material anatomical entity', 'anatomical line', 'head phenotype', 'pneumatized bone', 'absent limb long bone in the forelimb', 'regulation of macromolecule biosynthetic process', 'forelimb bone', 'non-connected functional system', 'behavior process phenotype', 'consumption behavior', 'absent anatomical entity in the skeletal system', 'decreased number of anatomical entity', 'Subcutaneous hemorrhage', 'Puberty and gonadal disorders', 'paired limb/fin segment', 'reproductive organ', 'absent anatomical entity in the tissue', 'paired limb/fin skeleton phenotype', 'external male genitalia', 'forelimb phenotype', 'bone of free limb or fin phenotype', 'arm bone phenotype', 'absent cavitated compound organ', 'skeleton phenotype', 'Abnormal erythrocyte morphology', 'hematopoietic system', 'orbital region', 'limb skeleton subdivision', 'zone of bone organ phenotype', 'Phenotypic abnormality', 'secretory cell', 'DNA damage response phenotype', 'number of anatomical enitites of type granulocyte phenotype', 'Abnormality of the upper urinary tract', 'forelimb', 'forelimb bud', 'lateral structure phenotype', 'Abnormal appendicular skeleton morphology', 'cartilaginous condensation phenotype', 'bone of pectoral complex', 'camera-type eye physiology phenotype', 'lens of camera-type eye', 'sensory system', 'organ subunit', 'face', 'endocrine system', 'sensory system phenotype', 'neutrophil', 'external genitalia phenotype', 'paraxial mesoderm phenotype', 'Abnormality of the orbital region', 'immature eye', 'entire sense organ system', 'zone of organ', 'Abnormality of metabolism/homeostasis', 'zone of skin morphology phenotype', 'zone of organ phenotype', 'skin of body morphology phenotype', 'decreased number of bone marrow cell', 'Abnormality of blood and blood-forming tissues', 'transparent eye structure', 'Hypergonadotropic hypogonadism', 'unilaminar epithelium', 'vertebral column phenotype', 'external ectoderm', 'absent anatomical entity', 'cornea morphology phenotype', 'unilaminar epithelium phenotype', 'neural tube morphology phenotype', 'transparent eye structure phenotype', 'anatomical space phenotype', 'zone of skin', 'dysesthesia; hyperalgesia', 'skeletal joint mobility phenotype', 'bone of free limb or fin', 'camera-type eye', 'skin of body', 'aplasia or hypoplasia of manual digit 1', 'eye primordium phenotype', 'absent radius bone', 'opaque anatomical entity', 'eye movement phenotype', 'limb bud phenotype', 'eyeball of camera-type eye phenotype', 'optic vesicle phenotype', 'muscle organ', 'ear vesicle morphology phenotype', 'head', 'anterior segment of eyeball', 'myeloid leukocyte morphology', 'increased size of the organ part', 'increased size of the anatomical entity', 'decreased number of neutrophil', 'head mesenchyme morphology phenotype', 'Abnormal leukocyte count', 'bony labyrinth', 'absent autopodial extension', 'anisocytosis', 'Abnormal granulocyte morphology', 'presumptive paraxial mesoderm', 'granulocyte', 'granulocyte morphology phenotype', 'decreased size of the eyeball of camera-type eye', 'cardiac septum phenotype', 'myeloid leukocyte phenotype', 'eye primordium', 'organ component layer phenotype', 'number of platelet phenotype', 'decreased number of granulocyte', 'neutrophil phenotype', 'otic placode phenotype', 'inner ear canal morphology phenotype', 'Abnormal total neutrophil count', 'Growth abnormality', 'growth phenotype', 'Hypogonadism', 'developmental process rate phenotype', 'absent radius endochondral element in the forelimb', 'absent lateral structure in the renal system', 'multicellular organismal process', 'subdivision of organism along appendicular axis phenotype', 'Abnormality of the skin', 'growth', 'number of leukocyte phenotype', 'Abnormality of the urinary system', 'Abnormal cardiac septum morphology', 'cranial placode phenotype', 'neurocranium phenotype', 'development of anatomical entity phenotype', 'decreased anatomical structure development', 'decreased multicellular organismal process', 'decreased multicellular organism development', 'skin of eyelid', 'absent organism subdivision in the multicellular organism', 'delayed growth', 'decreased biological_process', 'anatomical structure development phenotype', 'Growth delay', 'decreased developmental process', 'ear morphology phenotype', 'thoracic cavity element phenotype', 'Aplasia/hypoplasia involving the skeleton', 'multicellular organism development', 'neural fold morphology phenotype', 'Intrauterine growth retardation', 'brain', 'multicellular organism development phenotype', 'regular connective tissue phenotype', 'biological regulation phenotype', 'decreased qualitatively multicellular organism development', 'head morphology phenotype', 'gastrula', 'Abnormality of the eye', 'digitopodium bone', 'Abnormality of the kidney', 'Abnormality of globe size', 'mesoderm morphology phenotype', 'musculature', 'craniocervical region morphology phenotype', 'camera-type eye morphology phenotype', 'Aplasia/hypoplasia involving bones of the extremities', 'decreased size of the organ', 'decreased size of the sense organ', 'aplasia or hypoplasia of eyeball of camera-type eye', 'sclerotome', 'vision/eye phenotype', 'decreased size of the anatomical entity', 'dense regular connective tissue', 'decreased size of the material anatomical entity', 'Microphthalmia', 'absent organism subdivision', 'Abnormal eye morphology', 'tissue phenotype', 'Short stature', 'skin of face', 'limb long bone', 'decreased size of the multicellular organism', 'size of multicellular organism phenotype', 'decreased height of the anatomical entity', 'number of anatomical enitites of type erythrocyte phenotype', 'Complete duplication of phalanx of hand', 'decreased material anatomical entity mass', 'decreased height of the multicellular organism', 'cellular process', 'absent compound organ in the renal system', 'Abnormal cellular phenotype', 'phenotypic effect', 'cell cycle', 'orbital region phenotype', 'neurocranium morphology phenotype', 'cell cycle phase', 'Abnormal cellular physiology', 'negative regulation of biosynthetic process', 'decreased size of the tissue', 'Abnormality of the cell cycle', 'connective tissue phenotype', 'nervous system process', 'Abnormal nervous system physiology', 'increased size of the multicellular anatomical structure', 'material anatomical entity physiology phenotype', 'anatomical structure physiology phenotype', 'Intellectual disability', 'Small for gestational age', 'cognition', 'Abnormality of the nervous system', 'shape of anatomical entity phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'abdominal segment element phenotype', 'anatomical entity physiology phenotype', 'connective tissue', 'limb long bone morphology phenotype', 'myeloid cell', 'shape of kidney phenotype', 'absent organ in the renal system', 'Abnormal renal morphology', 'neurogenic placode phenotype', 'Aplasia involving forearm bones', 'dense connective tissue', 'cavitated compound organ', 'vestibulo-auditory system phenotype', 'abdomen element', 'entire embryonic mesenchyme', 'cartilage element', 'excretory system', 'upper urinary tract', 'manual digit 1 or 5', 'upper urinary tract phenotype', 'absent abdomen element', 'Horseshoe kidney', 'kidney phenotype', 'developing anatomical structure phenotype', 'abdomen', 'cranium', 'localised lateral structure', 'Abnormality of joint mobility', 'localised cavitated compound organ', 'otic pit', 'viscus phenotype', 'Ectopic kidney', 'reproductive system morphology phenotype', 'localised abdominal segment element', 'primary subdivision of cranial skeletal system', 'Aplasia/Hypoplasia of fingers', 'somite phenotype', 'Decreased body weight', 'location of anatomical entity phenotype', 'Ventricular septal defect', 'localised trunk region element', 'localised anatomical structure', 'retina phenotype', 'absent endochondral element in the forelimb', 'Abnormal facial shape', 'Abnormality of the head', 'tunica fibrosa of eyeball', 'material anatomical entity mass phenotype', 'Triangular face', 'Vertebral wedging', '2-D shape anatomical entity', 'anatomical line between pupils', 'triangular anatomical entity', 'triangular face', 'anatomical entity height phenotype', 'decreased functionality of the organ', 'neurocranium', 'endocrine system phenotype', 'ocular surface region', 'Abnormality of reproductive system physiology', 'decreased functionality of the anatomical entity', 'Abnormal morphology of the radius', 'reproductive organ phenotype', 'body part movement', 'reproductive organ physiology phenotype', 'reproductive structure phenotype', 'decreased functionality of the reproductive structure', 'reproductive system', 'skeleton of limb', 'organ system subdivision phenotype', 'gonad physiology phenotype', 'cranium morphology phenotype', 'multicellular anatomical structure physiology phenotype', 'external ectoderm morphology phenotype', 'decreased functionality of the reproductive organ', 'decreased functionality of the gonad', 'Chromosome breakage', 'organ physiology phenotype', 'Abnormal ocular adnexa morphology', 'decreased functionality of the anatomical structure', 'decreased sensory perception of mechanical stimulus', 'cartilaginous neurocranium', 'absent anatomical entity in the renal system', 'reproductive system phenotype', 'gonad', 'surface structure', 'sense organ physiology phenotype', 'absent long bone', 'Abnormality of the musculoskeletal system', 'Abnormality of the genital system', 'Abnormal renal collecting system morphology', 'kidney mesenchyme phenotype', 'kidney mesenchyme', 'absent abdominal segment element in the renal system', 'regulation of macromolecule biosynthetic process phenotype', 'basicranium morphology phenotype', 'absent digit', 'cardiac ventricle phenotype', 'ocular adnexa phenotype', 'posterior semicircular canal morphology', 'articulation', 'decreased number of leukocyte', 'skeletal joint physiology phenotype', 'absent bone element in the forelimb', 'increased length of the material anatomical entity', 'Renal agenesis', 'ectodermal placode', 'membranous labyrinth', 'concave 3-D shape anatomical entity', 'decreased length of multicellular anatomical structure', 'intracellular membraneless organelle', 'dorsolateral placode', 'axial skeleton plus cranial skeleton', 'head mesenchyme phenotype', 'epithelial sac phenotype', 'Joint contracture', 'absent endochondral bone in the limb', 'ear vesicle phenotype', 'muscle organ phenotype', 'anatomical entity mobility phenotype', 'paired limb/fin skeleton', 'drinking behavior phenotype', 'integumentary adnexa phenotype', 'sac phenotype', 'Abnormality of the integument', 'anatomical structure development', 'osseus semicircular canal', 'petrous part of temporal bone morphology phenotype', 'decreased length of anatomical entity', 'oxygen accumulating cell', 'articulation phenotype', 'anatomical entity length phenotype', 'internal ear morphology phenotype', 'osseus semicircular canal morphology phenotype', 'immaterial entity', 'acropodial skeleton', 'delayed biological_process', 'feeding behavior', 'paraxial mesoderm', 'skeletal joint', 'basicranium phenotype', 'anatomical wall phenotype', 'increased length of the head or neck skin', 'decreased length of tendon', 'dorsolateral placode phenotype', 'ear phenotype', 'circulatory organ', 'otic pit morphology phenotype', 'musculoskeletal system phenotype', 'embryonic craniocervical region', 'increased length of the multicellular anatomical structure', 'muscle structure phenotype', 'face morphology phenotype', 'Abnormal musculoskeletal physiology', 'non-neural ectoderm', 'primary subdivision of skull phenotype', 'otic placode morphology phenotype', 'G2 phase', 'Abnormality of the musculature', 'musculoskeletal system physiology phenotype', 'semicircular canal morphology phenotype', 'muscle organ morphology phenotype', 'Abnormal joint physiology', 'decreased number of anatomical entity in the multicellular organism', 'anatomical space', 'multi-limb segment region', 'developmental process', 'sac', 'temporal bone morphology phenotype', 'vasculature of organ', 'manual digit morphology in the manus phenotype', 'tendon morphology phenotype', 'skeletal joint phenotype', 'decreased length of dense connective tissue', 'Abnormality of connective tissue', 'absent cavitated compound organ in the renal system', 'axial skeletal system', 'anatomical surface region', 'appendicular skeleton phenotype', 'pit phenotype', 'primary subdivision of skull', 'skull', 'tendon phenotype', 'anatomical cluster', 'eye movement', 'reproductive system physiology phenotype', 'Abnormal conjugate eye movement', 'increased length of the structure with developmental contribution from neural crest', 'neurogenic placode', 'decreased qualitatively nervous system process', 'presumptive paraxial mesoderm phenotype', 'joint contracture', 'dense connective tissue phenotype', 'anterior neural tube', 'skull phenotype', 'increased length of the zone of organ', 'decreased length of dense regular connective tissue', 'optic vesicle', 'serotonin secreting cell', 'pancytopenia', 'otic placode', 'multi organ part structure', 'internal ear phenotype', 'limb segment phenotype', 'metabolic acidosis', 'macromolecule biosynthetic process', 'skeletal element', 'zone of bone organ', 'localised anatomical entity', 'Abnormal eye physiology', 'dense regular connective tissue phenotype', 'cornea phenotype', 'eye physiology phenotype', 'absent multicellular anatomical structure in the forelimb', 'location of camera-type eye phenotype', 'Abnormality of the cardiovascular system', 'strabismus', 'manual digit 1', 'internal ear', 'lateral structure physiology phenotype', 'organ component layer', 'Abnormality of eye movement', 'regulation of metabolic process phenotype', 'Abnormal granulocyte count', 'neural crest-derived structure', 'simple eye physiology phenotype', 'cellular process phenotype', 'structure with developmental contribution from neural crest physiology phenotype', 'uvea morphology phenotype', 'decreased qualitatively anatomical structure development', 'ectoderm-derived structure physiology phenotype', 'increased size of the anatomical structure', 'increased qualitatively biological_process', 'presumptive ectoderm phenotype', 'increased pigmentation', 'pit', 'increased biological_process in skin of body', 'Hyperpigmentation of the skin', 'anatomical structure', 'feeding behavior phenotype', 'polydipsia', 'anemia', 'increased size of the structure with developmental contribution from neural crest', 'shape of vertebra phenotype', 'increased length of the skin of face', 'eyelid phenotype', 'renal system', 'increased length of the epicanthal fold', 'increased length of the zone of skin', 'subdivision of organism along main body axis', 'increased length of the anatomical entity', 'increased length of the skin of head', 'absent abdominal segment element', 'glandular system', 'increased length of the organ part', 'increased length of the anatomical structure', 'head or neck skin', 'increased length of the skin of eyelid', 'increased size of the material anatomical entity', 'forelimb long bone', 'increased size of the zone of skin', 'number of anatomical enitites of type compound organ phenotype', 'mesoderm phenotype', 'number of anatomical enitites of type kidney phenotype', 'absent kidney', 'craniocervical region', 'number of anatomical enitites of type lateral structure phenotype', 'craniofacial/craniocervical phenotype', 'absent anatomical structure in the renal system', 'absent bone of appendage girdle complex in the limb', 'decreased embryo development', 'absent trunk region element in the multicellular organism', 'regulation of gene expression', 'absent material anatomical entity in the renal system', 'absent compound organ', 'absent trunk region element in the renal system', 'digit 1 phenotype', 'optic cup', 'number of anatomical enitites of type anatomical structure phenotype', 'embryo development phenotype', 'absent abdomen element in the renal system', 'number of anatomical enitites of type abdomen element phenotype', 'number of anatomical enitites of type cavitated compound organ phenotype', 'ecto-epithelium', 'bone cell', 'Pancytopenia', 'Abnormal bone marrow cell morphology', 'Duplicated collecting system', 'decreased number of erythrocyte', 'organ part', 'decreased multicellular anatomical structure mass', 'Abnormality of skull size', 'non-neural ectoderm phenotype', 'multicellular organism mass phenotype', 'anatomical entity mass phenotype', 'absent limb endochondral element in the limb', 'Abnormality of body weight', 'septum phenotype', 'Decreased anatomical entity mass', 'multicellular anatomical structure mass phenotype', 'trunk phenotype', 'biological regulation', 'macromolecule metabolic process', 'biosynthetic process', 'negative regulation of biological process', 'regulation of cellular process', 'negative regulation of macromolecule metabolic process phenotype', 'musculature of body phenotype', 'negative regulation of macromolecule metabolic process', 'decreased length of anatomical structure', 'Abnormality of chromosome stability', 'U-shaped anatomical entity', 'macromolecule biosynthetic process phenotype', 'gene expression phenotype', 'Abnormal leukocyte morphology', 'Epicanthus', 'negative regulation of metabolic process', 'regulation of biosynthetic process', 'regulation of macromolecule metabolic process'], 'has_descendant': ['MONDO:0009213'], 'has_descendant_label': ['Fanconi anemia complementation group C'], 'has_descendant_count': 1, 'highlighting': None}, {'id': 'MONDO:0014108', 'category': 'biolink:Disease', 'name': 'Fanconi anemia complementation group Q', 'description': 'Any Fanconi anemia in which the cause of the disease is a mutation in the ERCC4 gene.', 'xref': ['DOID:0111093', 'GARD:15934', 'MEDGEN:815318', 'OMIM:615272', 'UMLS:C3808988'], 'synonym': ['ERCC4 Fanconi anaemia', 'ERCC4 Fanconi anemia', 'FANCQ', 'Fanconi Anemia, complementation group type Q', 'Fanconi anaemia caused by mutation in ERCC4', 'Fanconi anaemia complementation group type Q', 'Fanconi anemia caused by mutation in ERCC4', 'Fanconi anemia complementation group type Q', 'Fanconi anemia, complementation group Q'], 'exact_synonym': ['ERCC4 Fanconi anaemia', 'ERCC4 Fanconi anemia', 'FANCQ', 'Fanconi Anemia, complementation group type Q', 'Fanconi anaemia caused by mutation in ERCC4', 'Fanconi anaemia complementation group type Q', 'Fanconi anemia caused by mutation in ERCC4', 'Fanconi anemia complementation group type Q'], 'related_synonym': ['Fanconi anemia, complementation group Q'], 'subsets': ['gard_rare', 'nord_rare', 'rare'], 'provided_by': 'phenio_nodes', 'namespace': 'MONDO', 'has_phenotype': ['HP:0010445', 'HP:0000369', 'HP:0005912', 'HP:0001510', 'HP:0002032', 'HP:0005528', 'HP:0009777', 'HP:0000252', 'HP:0001545', 'HP:0040012', 'HP:0004322'], 'has_phenotype_label': ['Esophageal atresia', 'Low-set ears', 'Anteriorly placed anus', 'Chromosome breakage', 'Bone marrow hypocellularity', 'Primum atrial septal defect', 'Short stature', 'Growth delay', 'Microcephaly', 'Biliary atresia', 'Absent thumb'], 'has_phenotype_count': 11, 'has_phenotype_closure': ['UPHENO:0035045', 'CL:0002092', 'UPHENO:0035151', 'UBERON:0002371', 'UPHENO:0063787', 'UPHENO:0077418', 'UBERON:0003061', 'UPHENO:0063794', 'HP:0012145', 'UPHENO:0088326', 'HP:0001871', 'CL:0000255', 'UPHENO:0080009', 'HP:0005528', 'UBERON:0002390', 'UPHENO:0002948', 'UPHENO:0003951', 'UBERON:0000949', 'HP:0012440', 'UPHENO:0003093', 'HP:0004297', 'UPHENO:0003116', 'UBERON:0005172', 'UBERON:0002530', 'UBERON:0004119', 'UPHENO:0002780', 'UBERON:0000916', 'UBERON:0015204', 'UPHENO:0086927', 'UBERON:0002294', 'UBERON:0002107', 'UPHENO:0002529', 'UPHENO:0004061', 'HP:0002012', 'UPHENO:0087100', 'UPHENO:0003405', 'UPHENO:0003423', 'UPHENO:0063630', 'UPHENO:0063645', 'UBERON:0005173', 'UBERON:0002368', 'UBERON:0002330', 'HP:0034915', 'HP:0001545', 'UPHENO:0002812', 'UBERON:0000161', 'UPHENO:0086644', 'HP:0004378', 'HP:0004397', 'UPHENO:0053580', 'UPHENO:0053657', 'UPHENO:0053566', 'UBERON:0001245', 'UPHENO:0053561', 'HP:0001172', 'UBERON:0002544', 'UBERON:5006048', 'UBERON:5002389', 'UPHENO:0004475', 'UPHENO:0076723', 'UBERON:0010712', 'UPHENO:0009020', 'UBERON:0002428', 'UBERON:0004375', 'UBERON:0006048', 'UPHENO:0076724', 'UPHENO:0011498', 'HP:0002813', 'UPHENO:0011572', 'UPHENO:0002861', 'UBERON:0012141', 'UBERON:0010707', 'HP:0040064', 'UPHENO:0003366', 'UPHENO:0081451', 'UPHENO:0026108', 'UPHENO:0026640', 'UPHENO:0011536', 'UBERON:0001460', 'UPHENO:0079876', 'UPHENO:0086700', 'UBERON:0002513', 'HP:0011297', 'UPHENO:0084761', 'UPHENO:0025509', 'UPHENO:0003094', 'UPHENO:0003415', 'UBERON:0010538', 'UBERON:0001440', 'UBERON:0002091', 'UPHENO:0004476', 'UBERON:0001442', 'UPHENO:0002600', 'HP:0009777', 'UPHENO:0026078', 'HP:0005927', 'HP:0002817', 'UPHENO:0003069', 'UBERON:0012354', 'UBERON:0005451', 'UBERON:0001463', 'UBERON:0006058', 'UBERON:0004765', 'UPHENO:0086635', 'UPHENO:0002747', 'UPHENO:0080325', 'UBERON:0002389', 'UBERON:5001463', 'UPHENO:0011825', 'UPHENO:0009146', 'UPHENO:0002632', 'HP:0009601', 'HP:0005922', 'UPHENO:0008668', 'UPHENO:0080126', 'UPHENO:0003227', 'UBERON:0002529', 'UBERON:0006717', 'UPHENO:0026643', 'UPHENO:0076727', 'UPHENO:0003049', 'HP:0001626', 'UPHENO:0002746', 'UPHENO:7000601', 'UPHENO:0035147', 'HP:0011024', 'UBERON:0000926', 'UBERON:0000033', 'UBERON:0015061', 'GO:0010605', 'UPHENO:0086857', 'UPHENO:0004386', 'UPHENO:0004459', 'UPHENO:0004831', 'UBERON:0002075', 'UBERON:0000061', 'UBERON:0005181', 'UPHENO:0033559', 'UBERON:0005417', 'UBERON:0001049', 'UPHENO:0003815', 'UBERON:0000479', 'UBERON:0000955', 'UBERON:0001048', 'UPHENO:0069149', 'UPHENO:0002568', 'UPHENO:0003514', 'UBERON:0001017', 'UPHENO:0003189', 'UPHENO:0004885', 'HP:0000001', 'UPHENO:0033560', 'UPHENO:0002548', 'UPHENO:0003025', 'UBERON:0004120', 'UPHENO:0069352', 'UPHENO:0002764', 'UPHENO:0049904', 'UPHENO:0004680', 'UBERON:0013702', 'HP:0000240', 'UBERON:0003103', 'UPHENO:0074231', 'UPHENO:0002736', 'UPHENO:0002725', 'UBERON:0002090', 'NCBITaxon:131567', 'UBERON:0005944', 'UPHENO:0025587', 'UBERON:0004151', 'UPHENO:0005110', 'UPHENO:0087849', 'UPHENO:0076702', 'HP:0000002', 'UPHENO:0000543', 'UPHENO:0086485', 'UPHENO:3000000', 'UPHENO:0003334', 'UPHENO:0002530', 'UBERON:0002085', 'UBERON:0000475', 'HP:0000929', 'UPHENO:0076805', 'UPHENO:0003799', 'UBERON:0003080', 'UPHENO:0004615', 'UPHENO:0069327', 'UPHENO:0005080', 'UPHENO:0087660', 'UBERON:0006598', 'HP:0001080', 'UPHENO:0002623', 'HP:0040068', 'UBERON:0006601', 'UPHENO:0002833', 'UPHENO:0002816', 'UPHENO:0002668', 'UPHENO:0076791', 'UPHENO:0053632', 'UBERON:0016880', 'UBERON:0007100', 'UBERON:0034925', 'UPHENO:0005141', 'UPHENO:0002643', 'UPHENO:0075878', 'UPHENO:0002393', 'UBERON:0001893', 'UPHENO:0003082', 'UBERON:0010000', 'UPHENO:0002456', 'UPHENO:0004900', 'HP:0002977', 'UPHENO:0087359', 'UPHENO:0080099', 'UPHENO:0002567', 'UPHENO:0004466', 'UBERON:0001434', 'UBERON:0011676', 'UPHENO:0005092', 'UBERON:0000467', 'UPHENO:0002541', 'UPHENO:0003432', 'UPHENO:0002525', 'UPHENO:0003186', 'UPHENO:0002866', 'NCBITaxon:1', 'UPHENO:0087347', 'UBERON:0000153', 'HP:0011842', 'UBERON:0012139', 'UBERON:0003056', 'UPHENO:0002385', 'HP:0000377', 'UPHENO:0085409', 'UBERON:0007651', 'UPHENO:0005285', 'HP:0000152', 'UPHENO:0033607', 'UPHENO:0002896', 'UPHENO:0004523', 'UPHENO:0003001', 'UPHENO:0049587', 'NCBITaxon:2759', 'UBERON:0000073', 'UPHENO:0049837', 'UPHENO:0001002', 'UPHENO:0002839', 'UPHENO:0003004', 'GO:0010629', 'UPHENO:0074232', 'UPHENO:0050063', 'UPHENO:0085306', 'UPHENO:0002844', 'UBERON:0010312', 'UBERON:0009569', 'UPHENO:0002733', 'UBERON:0008785', 'GO:0065007', 'UPHENO:0050065', 'UBERON:0005423', 'UPHENO:0088123', 'UBERON:0009881', 'UPHENO:0053661', 'UPHENO:0002586', 'UPHENO:0080200', 'UPHENO:0077371', 'UBERON:0004139', 'HP:0001392', 'UPHENO:0004909', 'UPHENO:0005030', 'UBERON:0010316', 'UBERON:0004535', 'UBERON:0013701', 'UPHENO:0002579', 'UPHENO:0049870', 'UPHENO:0002650', 'UPHENO:0081566', 'UPHENO:0002564', 'UBERON:0002365', 'UPHENO:0002634', 'UPHENO:0033565', 'UPHENO:0087363', 'HP:0000369', 'UPHENO:0049775', 'UPHENO:0050435', 'UBERON:0000025', 'HP:0040195', 'GO:0031049', 'UPHENO:0086863', 'UPHENO:0002656', 'UBERON:0015228', 'UPHENO:0004484', 'UPHENO:0004507', 'HP:0003220', 'UBERON:0001173', 'UPHENO:0050007', 'UPHENO:0076675', 'UPHENO:0002219', 'UPHENO:0011531', 'UPHENO:0001001', 'UBERON:0001016', 'UPHENO:0018426', 'HP:0000118', 'UBERON:0000922', 'UPHENO:0004482', 'UPHENO:0050778', 'UPHENO:0074228', 'UPHENO:0003812', 'UBERON:0002470', 'UPHENO:0001003', 'GO:0042592', 'HP:0000924', 'UPHENO:0076740', 'UPHENO:0082875', 'UPHENO:0026010', 'UPHENO:0004521', 'UBERON:0000481', 'UBERON:0004381', 'HP:0007364', 'UPHENO:0063559', 'UPHENO:0026506', 'UBERON:0000490', 'UBERON:0000075', 'UBERON:0001009', 'HP:0002060', 'UPHENO:0004486', 'UPHENO:0004519', 'UBERON:0000062', 'UPHENO:0002754', 'UPHENO:0002870', 'UPHENO:0002902', 'UPHENO:0002559', 'HP:0040012', 'UPHENO:0076752', 'UPHENO:0081424', 'UPHENO:0049868', 'UPHENO:0035034', 'UBERON:0007811', 'UBERON:0004088', 'GO:0060255', 'NCBITaxon:6072', 'UPHENO:0005058', 'UBERON:0000064', 'BFO:0000015', 'UPHENO:0075220', 'HP:0001155', 'UPHENO:0003412', 'GO:0009889', 'UBERON:0002616', 'UBERON:0005178', 'UBERON:0002193', 'UPHENO:0026183', 'GO:0031052', 'UBERON:0000483', 'UBERON:0002050', 'UBERON:0007272', 'GO:0010556', 'UPHENO:0002859', 'UPHENO:0063603', 'GO:0043170', 'GO:0010467', 'UPHENO:0004888', 'HP:0009815', 'UBERON:0001015', 'UBERON:0010740', 'UPHENO:0068971', 'UPHENO:0081784', 'UPHENO:0049873', 'UPHENO:0002386', 'UPHENO:0087907', 'HP:0001627', 'UBERON:0004121', 'UBERON:0003075', 'UPHENO:0003095', 'UBERON:0010130', 'UPHENO:0050126', 'UPHENO:0069236', 'UPHENO:0087665', 'UPHENO:0002352', 'UPHENO:0003086', 'HP:0009121', 'HP:0000707', 'HP:0001939', 'UBERON:0012140', 'GO:0009892', 'HP:0011017', 'UPHENO:0086769', 'UBERON:0001062', 'UPHENO:0049642', 'GO:0010468', 'UPHENO:0002648', 'UBERON:0034921', 'HP:0002011', 'UBERON:0000465', 'UPHENO:0002983', 'UPHENO:0004621', 'UPHENO:0002536', 'GO:0010558', 'UBERON:0004347', 'GO:0009890', 'UBERON:0011216', 'UBERON:0000970', 'UBERON:0002405', 'UBERON:0015203', 'UBERON:0002105', 'HP:0011844', 'UPHENO:0049757', 'UBERON:0010758', 'UPHENO:0004802', 'UPHENO:0076703', 'UPHENO:0002976', 'UPHENO:0069266', 'UPHENO:0076810', 'UPHENO:0002944', 'UPHENO:0074245', 'UPHENO:0087089', 'UBERON:0002423', 'UPHENO:0049652', 'GO:0008152', 'GO:0009059', 'UPHENO:0002963', 'GO:0019222', 'UPHENO:9002003', 'UBERON:0002204', 'UPHENO:0049620', 'GO:0048519', 'UBERON:0003102', 'GO:0009058', 'UBERON:0004456', 'UPHENO:0002964', 'UPHENO:0002526', 'UPHENO:0086172', 'GO:0008150', 'CL:0001035', 'UPHENO:0003084', 'HP:0000234', 'UBERON:0000923', 'UPHENO:0075804', 'UPHENO:0086633', 'UPHENO:0003050', 'UBERON:0001555', 'UBERON:0004734', 'UPHENO:0002994', 'UPHENO:0074229', 'UPHENO:0069062', 'UBERON:0001890', 'UPHENO:0003158', 'UPHENO:0003163', 'UPHENO:0063565', 'HP:0000356', 'UBERON:0013522', 'UBERON:0002100', 'UBERON:0010371', 'HP:0031703', 'UPHENO:0004704', 'UBERON:0015212', 'UPHENO:0076799', 'UPHENO:0004360', 'UPHENO:0004827', 'UBERON:0001474', 'UBERON:0035639', 'UBERON:0010323', 'HP:0001631', 'UBERON:0002417', 'UPHENO:0080352', 'UBERON:0003914', 'HP:0012639', 'UPHENO:0086589', 'UBERON:0004288', 'UPHENO:0005055', 'HP:0005912', 'UPHENO:0075195', 'HP:0100547', 'UPHENO:0004047', 'UBERON:0002346', 'CL:0000000', 'UPHENO:7000510', 'BFO:0000040', 'UPHENO:0075148', 'UBERON:0005177', 'UBERON:0011249', 'UBERON:0010912', 'UBERON:0004708', 'UBERON:0002398', 'UPHENO:7000198', 'UPHENO:0053599', 'UPHENO:0002731', 'UBERON:0000383', 'UPHENO:0076694', 'UPHENO:0003207', 'UPHENO:0003159', 'UPHENO:0002928', 'UPHENO:0049835', 'UPHENO:0076776', 'UPHENO:0004403', 'UBERON:0000307', 'HP:0010445', 'UPHENO:0078606', 'UPHENO:0033596', 'UPHENO:0002593', 'UPHENO:0002467', 'UBERON:0000026', 'HP:0045060', 'UPHENO:0004433', 'UPHENO:0075997', 'UPHENO:0069254', 'UPHENO:0002403', 'UBERON:0034923', 'UBERON:0003071', 'UBERON:0001691', 'UPHENO:0086679', 'UPHENO:0002531', 'UPHENO:0063579', 'HP:0001167', 'UPHENO:0087663', 'UBERON:0012275', 'UPHENO:0008548', 'UBERON:0002081', 'UBERON:0001032', 'UBERON:0001711', 'UPHENO:0034969', 'UBERON:0019221', 'UPHENO:0087661', 'UPHENO:0002903', 'UPHENO:0078742', 'UPHENO:0002301', 'UPHENO:0002926', 'UPHENO:0004892', 'HP:0033127', 'UPHENO:0003827', 'UBERON:0003037', 'UBERON:0010314', 'UBERON:0010363', 'UBERON:0007005', 'UPHENO:0074330', 'UBERON:0012475', 'UBERON:0004710', 'UPHENO:0003410', 'UPHENO:0035160', 'UBERON:0004111', 'UPHENO:0002542', 'UPHENO:0002267', 'UBERON:0004872', 'UPHENO:0003088', 'UPHENO:3000007', 'UBERON:0001444', 'HP:0001510', 'UBERON:0001456', 'UPHENO:0002360', 'UPHENO:0002574', 'BFO:0000001', 'UBERON:0002087', 'UPHENO:7000158', 'UPHENO:0002430', 'UPHENO:0002626', 'UPHENO:0004494', 'UPHENO:0015324', 'UPHENO:0004757', 'UPHENO:0087518', 'UBERON:0036146', 'UPHENO:0076803', 'UBERON:0004140', 'UBERON:0001041', 'UBERON:0004141', 'HP:0002031', 'UBERON:0000047', 'UPHENO:0002577', 'HP:0006496', 'UPHENO:0004721', 'BFO:0000002', 'UBERON:0005419', 'UPHENO:0015281', 'HP:0012718', 'UPHENO:0005356', 'HP:0025031', 'UBERON:0000468', 'UPHENO:0087294', 'UPHENO:0063615', 'UPHENO:0003999', 'UPHENO:0076697', 'UBERON:0003084', 'UBERON:0001043', 'UPHENO:0002666', 'UBERON:0002099', 'UBERON:0011138', 'UBERON:0001690', 'BFO:0000004', 'UBERON:0000019', 'UPHENO:0003005', 'UPHENO:0002571', 'RO:0002577', 'UBERON:0003104', 'UPHENO:0063563', 'UPHENO:0002910', 'HP:0005561', 'UBERON:0005291', 'GO:0009987', 'UPHENO:0015277', 'UPHENO:0002554', 'UPHENO:0027017', 'UPHENO:0009163', 'UBERON:0015410', 'UPHENO:0002546', 'NCBITaxon:33208', 'HP:0006695', 'HP:0001671', 'UBERON:0005881', 'UPHENO:0086855', 'UPHENO:0080079', 'UPHENO:0004469', 'UPHENO:0003236', 'UBERON:0002104', 'UBERON:0001007', 'UBERON:0016879', 'UPHENO:0004401', 'UPHENO:0003177', 'UBERON:0011137', 'HP:0011994', 'UPHENO:0088118', 'HP:0025354', 'UPHENO:0075655', 'UPHENO:0074348', 'UPHENO:0002308', 'HP:0025033', 'UPHENO:0003413', 'UPHENO:0002240', 'UPHENO:0084448', 'UBERON:0007524', 'HP:0000252', 'UBERON:0000915', 'HP:0030680', 'UPHENO:0033572', 'UPHENO:0005319', 'UPHENO:0002211', 'UBERON:0004128', 'UBERON:0007688', 'UBERON:0005409', 'UPHENO:0005097', 'UPHENO:0063575', 'HP:0002032', 'UPHENO:0063558', 'UPHENO:0063594', 'HP:0009115', 'UPHENO:0063586', 'UPHENO:0086699', 'UPHENO:0005214', 'UPHENO:0063576', 'UPHENO:0002988', 'UBERON:0004908', 'UBERON:0000924', 'UBERON:0003129', 'UPHENO:0063580', 'UPHENO:0063562', 'UPHENO:0004481', 'UBERON:0013765', 'HP:0002589', 'UPHENO:0003065', 'UPHENO:0063722', 'UPHENO:0074237', 'UPHENO:0025507', 'GO:0048523', 'UPHENO:0063639', 'UPHENO:0080114', 'UPHENO:0002905', 'UPHENO:0053636', 'UPHENO:0074311', 'HP:0005120', 'UBERON:0004921', 'UPHENO:0074335', 'UPHENO:0086546', 'UBERON:0000948', 'UPHENO:0081423', 'UPHENO:0075159', 'UPHENO:0002949', 'GO:0050789', 'UPHENO:0080351', 'UPHENO:0049874', 'BFO:0000003', 'HP:0004322', 'UPHENO:0076735', 'UBERON:0000020', 'UPHENO:0000541', 'GO:0040007', 'UPHENO:0002708', 'HP:0001507', 'HP:0006265', 'UPHENO:0050040', 'UPHENO:0018414', 'UPHENO:0076730', 'UPHENO:0081783', 'UPHENO:0080300', 'UPHENO:0002901', 'UPHENO:0005986', 'UPHENO:0041226', 'NCBITaxon:33154', 'UPHENO:0002553', 'UPHENO:0018390', 'UPHENO:0081466', 'GO:0050794', 'UPHENO:0009209', 'UPHENO:0081581', 'HP:0000598', 'UBERON:0019231', 'UPHENO:0008523', 'UBERON:0002102', 'HP:0012443', 'UPHENO:0084763', 'UPHENO:0074329', 'UBERON:0003081', 'UPHENO:0025585', 'UPHENO:0050121', 'UPHENO:0076692', 'HP:0009380', 'UPHENO:0074310', 'UPHENO:0002880', 'UPHENO:0002830', 'UBERON:0002101', 'UPHENO:0049743', 'UBERON:0011820', 'HP:0000357', 'UBERON:0010708', 'UPHENO:0026181', 'UPHENO:0026146', 'UBERON:0004357', 'UBERON:5002544', 'UPHENO:0087006', 'UPHENO:0004480', 'UPHENO:0002945', 'UPHENO:0002782', 'UBERON:0006925', 'UBERON:0011582', 'UPHENO:0063574', 'UPHENO:0026757', 'UPHENO:0009382'], 'has_phenotype_closure_label': ['blood island', 'decreased number of anatomical structure', 'eukaryotic cell', 'decreased number of anatomical entity in the bone element', 'hematopoietic system', 'hematopoietic system phenotype', 'Abnormal bone marrow cell morphology', 'decreased number of anatomical structure in the bone element', 'decreased number of cell', 'immune system phenotype', 'decreased number of anatomical entity in the bone marrow', 'blood island phenotype', 'decreased number of anatomical entity', 'Bone marrow hypocellularity', 'bone marrow phenotype', 'closing of the endoderm-derived structure', 'abdominal segment of trunk', 'endocrine gland phenotype', 'endoderm-derived structure atresia', 'Abnormality of the abdominal organs', 'abdomen element', 'biliary system', 'hepatobiliary system', 'exocrine system', 'hepatobiliary system morphology phenotype', 'glandular system', 'Abnormality of the biliary system', 'biliary tree phenotype', 'biliary tree atresia', 'abdomen', 'liver', 'abdominal segment element', 'exocrine gland', 'digestive system gland', 'Abnormal biliary tract morphology', 'exocrine gland phenotype', 'biliary system phenotype', 'hepatobiliary system phenotype', 'gland phenotype', 'gland', 'endoderm-derived structure phenotype', 'abdominal segment element phenotype', 'endocrine system phenotype', 'hemolymphoid system', 'endocrine system', 'localised anatomical structure', 'localised anatomical entity', 'Ectopic anus', 'anus morphology phenotype', 'Abnormality of the anus', 'orifice', 'limb skeleton subdivision', 'skeleton of pectoral complex', 'embryonic autopod plate', 'Abnormality of the hand', 'Aplasia/hypoplasia of the extremities', 'immune system', 'forelimb bud morphology phenotype', 'digit 1 plus metapodial segment', 'manual digit phenotype', 'Aplasia/Hypoplasia of fingers', 'appendicular skeleton phenotype', 'anatomical entity morphology in the appendage girdle complex phenotype', 'absent anatomical structure', 'bone of free limb or fin', 'Abnormal appendicular skeleton morphology', 'Finger aplasia', 'manual digitopodium region', 'decreased number of material anatomical entity in the multicellular organism', 'forelimb', 'limb phenotype', 'arm phenotype', 'bone of free limb or fin phenotype', 'limb skeleton subdivision phenotype', 'endochondral bone phenotype', 'absent multicellular anatomical structure', 'segment of manus', 'bone cell', 'manual digit 1', 'appendicular skeletal system', 'pectoral appendage', 'limb', 'Abnormal digit morphology', 'manual digit morphology in the manus phenotype', 'absent anatomical structure in the forelimb', 'abdomen element phenotype', 'endochondral element phenotype', 'limb segment phenotype', 'absent multicellular anatomical structure in the limb', 'Abnormality of blood and blood-forming tissues', 'liver phenotype', 'Aplasia/Hypoplasia of the thumb', 'aplasia or hypoplasia of skeleton', 'forelimb bud phenotype', 'skeleton of limb phenotype', 'limb endochondral element', 'surface structure', 'number of anatomical enitites of type anatomical structure phenotype', 'absent anatomical entity in the multicellular organism', 'absent multicellular anatomical structure in the multicellular organism', 'manual digit 1 morphology phenotype', 'Absent thumb', 'limb bud morphology phenotype', 'Abnormal thumb morphology', 'forelimb phenotype', 'embryonic autopod plate morphology phenotype', 'limb bud', 'anatomical entity morphology in the pectoral complex phenotype', 'digit morphology phenotype', 'biliary tree morphology phenotype', 'Abnormal hand morphology', 'segment of autopod', 'localised ectoderm-derived structure', 'endochondral element', 'decreased number of anatomical entity in the multicellular organism', 'multi-limb segment region', 'paired limb/fin skeleton', 'paired limb/fin segment phenotype', 'digit 1 phenotype', 'pectoral appendage phenotype', 'Abnormal finger morphology', 'absent material anatomical entity in the limb bud', 'skeletal element', 'bone element', 'subdivision of organism along appendicular axis', 'localised anatomical conduit', 'Abnormality of limb bone', 'upper limb segment phenotype', 'absent anatomical entity in the limb bud', 'absent multicellular anatomical structure in the forelimb', 'absent autopodial extension', 'lateral plate mesoderm', 'cardiogenic plate morphology phenotype', 'splanchnic layer of lateral plate mesoderm', 'gene expression phenotype', 'ostium primum atrial septal defect; primum atrial septal defect', 'vestibulo-auditory system', 'Biliary atresia', 'biological regulation phenotype', 'structure with developmental contribution from neural crest phenotype', 'axial skeleton plus cranial skeleton', 'localised orifice', 'epithelial tube phenotype', 'musculoskeletal system', 'Abnormal skeletal morphology', 'anatomical collection', 'cardiac septum phenotype', 'Decreased external ear position', 'aplasia or hypoplasia of anatomical entity', 'musculoskeletal system phenotype', 'developing anatomical structure', 'biliary tree', 'phenotypic effect', 'Eukaryota', 'neural plate morphology phenotype', 'external ear morphology phenotype', 'digestive system gland phenotype', 'Abnormality of the nervous system', 'manual digit plus metapodial segment', 'aplasia or hypoplasia of telencephalon', 'embryonic tissue morphology phenotype', 'Atrial septal defect', 'anterior neural tube phenotype', 'skull', 'postcranial axial skeletal system', 'multicellular anatomical structure atresia', 'gastrula', 'septum', 'regional part of brain phenotype', 'regulation of gene expression', 'Aplasia/hypoplasia involving bones of the hand', 'decreased size of the material anatomical entity', 'cell', 'Abnormal cellular physiology', 'viscus phenotype', 'Abnormal cerebral morphology', 'aplastic manual digit 1', 'nervous system phenotype', 'cardiac atrium', 'future central nervous system', 'Microcephaly', 'skeletal system', 'craniocervical region morphology phenotype', 'atrial septum morphology', 'paired limb/fin phenotype', 'Aplasia/Hypoplasia of the cerebrum', 'skeletal system morphology phenotype', 'embryonic tissue', 'germ layer phenotype', 'decreased size of the organism subdivision', 'embryonic structure phenotype', 'tube phenotype', 'sense organ phenotype', 'central nervous system morphology phenotype', 'structure with developmental contribution from neural crest', 'epithelium', 'acropodium region', 'neural tube', 'subdivision of trunk phenotype', 'digestive system element', 'absent material anatomical entity', 'tissue', 'ectoderm-derived structure phenotype', 'ear physiology phenotype', 'ecto-epithelium', 'craniofacial/craniocervical phenotype', 'agenesis of anatomical entity', 'telencephalon', 'localised anus', 'limb endochondral element phenotype', 'Abnormal nervous system morphology', 'decreased size of the head', 'subdivision of organism along main body axis phenotype', 'head', 'neural tube phenotype', 'embryo morphology phenotype', 'foregut phenotype', 'Opisthokonta', 'heart tube phenotype', 'pre-chordal neural plate phenotype', 'digit 1', 'delayed growth', 'pre-chordal neural plate', 'musculature phenotype', 'decreased number of anatomical structure in the multicellular organism', 'absent anatomical entity in the forelimb', 'forebrain', 'limb segment', 'multicellular organism', 'axial skeletal system', 'nervous system morphology phenotype', 'epithelial tube', 'regulation of macromolecule metabolic process phenotype', 'regulation of macromolecule metabolic process', 'main body axis', 'negative regulation of metabolic process', 'cellular process', 'material entity', 'decreased size of the anatomical entity', 'organism subdivision', 'anatomical entity height phenotype', 'anatomical conduit', 'phenotype', 'metabolic process phenotype', 'biological_process phenotype', 'ectoderm-derived structure', 'head morphology phenotype', 'anatomical structure', 'primary circulatory organ', 'future nervous system', 'atrioventricular canal', 'material anatomical entity phenotype', 'biological regulation', 'telencephalon phenotype', 'localised multicellular anatomical structure', 'multicellular organism morphology phenotype', 'digestive system phenotype', 'negative regulation of macromolecule biosynthetic process', 'programmed DNA elimination by chromosome breakage', 'absent anatomical structure in the multicellular organism', 'material anatomical entity', 'mesoderm phenotype', 'closing of the trunk region element', 'gene expression', 'germ layer', 'negative regulation of cellular process', 'Abnormality of the head', 'Abnormality of metabolism/homeostasis', 'continuant', 'autopod region morphology phenotype', 'regulation of cellular process phenotype', 'craniocervical region phenotype', 'compound organ phenotype', 'neural plate phenotype', 'axial skeleton plus cranial skeleton phenotype', 'musculature of body', 'number of anatomical enitites of type organism subdivision phenotype', 'forebrain phenotype', 'closing of the anatomical structure', 'Abnormal esophagus morphology', 'number of bone marrow cell phenotype', 'bone marrow cell phenotype', 'germ layer / neural crest phenotype', 'negative regulation of biosynthetic process', 'appendicular skeleton', 'cranial skeletal system', 'location of anatomical entity phenotype', 'organism subdivision phenotype', 'homeostatic process', 'organ system subdivision phenotype', 'lateral plate mesoderm morphology phenotype', 'heart', 'macromolecule metabolic process', 'cellular organisms', 'multi organ part structure', 'heart phenotype', 'subdivision of digestive tract atresia', 'anatomical junction phenotype', 'Morphological central nervous system abnormality', 'interatrial septum morphology phenotype', 'regulation of biosynthetic process', 'regulation of metabolic process phenotype', 'Abnormality of the outer ear', 'anatomical entity physiology phenotype', 'programmed DNA elimination by chromosome breakage phenotype', 'esophagus morphology phenotype', 'cell phenotype', 'limb morphology phenotype', 'occurrent', 'incomplete closing of the cardiac septum', 'presumptive structure', 'brain morphology phenotype', 'visual system', 'negative regulation of macromolecule metabolic process phenotype', 'digestive system', 'central nervous system', 'subdivision of organism along appendicular axis phenotype', 'manual digit 1 or 5', 'organ phenotype', 'Abnormal cellular phenotype', 'camera-type eye physiology phenotype', 'taxon specific phenotype', 'cellular process phenotype', 'digitopodium region', 'tube', 'cranial skeletal system phenotype', 'sensory system phenotype', 'anatomical structure phenotype', 'epithelium phenotype', 'Anteriorly placed anus', 'Abnormal heart morphology', 'growth', 'Gastrointestinal atresia', 'cardiac chamber phenotype', 'neurectoderm', 'Abnormal limb bone morphology', 'skeleton phenotype', 'multicellular anatomical structure', 'process', 'Eumetazoa', 'homeostatic process phenotype', 'mesoderm morphology phenotype', 'decreased size of the multicellular anatomical structure', 'multicellular anatomical structure phenotype', 'organ part atresia', 'body proper', 'negative regulation of biological process', 'cardiac septum morphology phenotype', 'endocrine gland', 'brain', 'digestive tract', 'mesenchyme', 'independent continuant', 'immature eye', 'regulation of cellular process', 'pectoral appendage bud', 'central nervous system phenotype', 'biosynthetic process phenotype', 'Chromosome breakage', 'anatomical entity atresia', 'regulation of macromolecule biosynthetic process', 'future central nervous system phenotype', 'negative regulation of gene expression', 'negative regulation of metabolic process phenotype', 'head phenotype', 'regulation of biological process phenotype', 'trunk region element atresia', 'regulation of gene expression phenotype', 'absent organism subdivision', 'Biliary tract abnormality', 'anatomical conduit phenotype', 'Abnormality of limbs', 'primordium phenotype', 'metabolic process', 'dense mesenchyme tissue phenotype', 'anatomical structure physiology phenotype', 'paired limb/fin segment', 'Abnormality of the upper limb', 'anatomical structure morphology in the heart phenotype', 'ocular adnexa physiology phenotype', 'orbital region phenotype', 'appendage girdle complex', 'subdivision of skeletal system phenotype', 'size of skull phenotype', 'growth phenotype', 'embryonic tissue phenotype', 'absent manual digit', 'Metazoa', 'negative regulation of cellular process phenotype', 'simple eye', 'germ layer / neural crest', 'neural plate', 'paired limb/fin bud', 'Abnormality of chromosome stability', 'sensory system', 'axial skeleton plus cranial skeleton morphology phenotype', 'negative regulation of biological process phenotype', 'multicellular anatomical structure physiology phenotype', 'Atrioventricular canal defect', 'Phenotypic abnormality', 'arm', 'subdivision of tube atresia', 'upper digestive tract', 'Aplasia/Hypoplasia involving the central nervous system', 'Abnormality of the musculoskeletal system', 'manus morphology phenotype', 'root', 'Abnormal forebrain morphology', 'number of anatomical enitites of type material anatomical entity phenotype', 'subdivision of skeleton phenotype', 'organ atresia', 'blastula', 'skeletal system phenotype', 'regulation of biological process', 'Abnormality of the skeletal system', 'Abnormal gastrointestinal tract morphology', 'paired limb/fin skeleton phenotype', 'skeletal element phenotype', 'presumptive structure phenotype', 'skeleton', 'thoracic segment organ atresia', 'germ layer morphology phenotype', 'subdivision of organism along main body axis', 'eye', 'Decreased head circumference', 'tissue phenotype', 'negative regulation of macromolecule metabolic process', 'Growth abnormality', 'anatomical system', 'subdivision of skeleton', 'Abnormal axial skeleton morphology', 'ectoderm', 'closing of the thoracic segment organ', 'regional part of brain', 'forebrain morphology phenotype', 'decreased size of the subdivision of organism along main body axis', 'face phenotype', 'regional part of nervous system phenotype', 'anatomical entity', 'embryonic structure', 'manus', 'ectoderm morphology phenotype', 'Abnormal cardiac atrium morphology', 'anatomical entity morphology phenotype', 'subdivision of skeletal system', 'alimentary part of gastrointestinal system', 'anatomical system phenotype', 'brain phenotype', 'programmed DNA elimination', 'skull morphology phenotype', 'orbital region', 'musculature of body phenotype', 'regulation of macromolecule biosynthetic process phenotype', 'neurectoderm phenotype', 'Abnormality of the liver', 'size of head phenotype', 'regional part of nervous system', 'craniocervical region', 'incomplete closing of the interatrial septum', 'regulation of biosynthetic process phenotype', 'embryo', 'anterior lateral plate mesoderm', 'anatomical collection phenotype', 'Abnormal cardiovascular system morphology', 'trunk phenotype', 'trunk region element', 'Abnormal location of ears', 'compound organ', 'meso-epithelium phenotype', 'anlage phenotype', 'trunk', 'material anatomical entity morphology in the heart phenotype', 'Short stature', 'primary heart field phenotype', 'cardiac septum', 'cardiovascular system phenotype', 'telencephalon morphology phenotype', 'cardiac atrium morphology phenotype', 'incomplete closing of the anatomical structure', 'number of anatomical enitites of type anatomical entity phenotype', 'sense organ', 'anlage', 'immature eye phenotype', 'thoracic cavity element phenotype', 'forelimb morphology phenotype', 'mesenchyme morphology phenotype', 'Abnormal atrial septum morphology', 'eyelid phenotype', 'material anatomical entity physiology phenotype', 'incomplete closing of the anatomical entity', 'digit', 'cardiopharyngeal field', 'primary heart field', 'anatomical entity morphology in the heart phenotype', 'forelimb skeleton', 'mesoderm-derived structure', 'ectoderm phenotype', 'subdivision of trunk', 'heart morphology phenotype', 'anatomical system atresia', 'Abnormal ear morphology', 'thoracic cavity element atresia', 'tinnitus', 'Abnormal skull morphology', 'thoracic segment organ phenotype', 'upper limb segment', 'manual digit 1 plus metapodial segment', 'lateral plate mesoderm phenotype', 'anterior region of body', 'subdivision of head phenotype', 'cardiovascular system morphology phenotype', 'postcranial axial skeleton', 'closing of the material anatomical entity', 'pectoral complex', 'ocular adnexa phenotype', 'absent anatomical entity in the limb', 'skeleton of manus', 'decreased size of the anatomical structure', 'manual digit', 'multi-tissue structure', 'thoracic segment organ', 'negative regulation of gene expression phenotype', 'trunk region element phenotype', 'mesoderm-derived structure phenotype', 'bone of appendage girdle complex', 'eyelid physiology phenotype', 'circulatory organ', 'endochondral bone', 'meso-epithelium', 'atrioventricular region', 'embryo phenotype', 'cardiac chamber', 'eye physiology phenotype', 'Abnormality of skull size', 'heart tube morphology phenotype', 'optic vesicle phenotype', 'cardiac atrium phenotype', 'multicellular organism phenotype', 'simple eye phenotype', 'Abnormality of the cardiovascular system', 'cardiogenic splanchnic mesoderm phenotype', 'vestibulo-auditory system phenotype', 'macromolecule biosynthetic process', 'mesoderm', 'localised material anatomical entity', 'viscus', 'primordium', 'material anatomical entity atresia', 'camera-type eye phenotype', 'digit plus metapodial segment', 'septum phenotype', 'lateral structure physiology phenotype', 'ear phenotype', 'autopod region phenotype', 'circulatory organ phenotype', 'vision/eye phenotype', 'bone marrow cell', 'lateral structure', 'entire sense organ system', 'ocular adnexa', 'neural tube morphology phenotype', 'eyelid', 'anatomical entity phenotype', 'thoracic cavity element', 'decreased number of material anatomical entity', 'visual system phenotype', 'incomplete closing of the material anatomical entity', 'Abnormality of multiple cell lineages in the bone marrow', 'disconnected anatomical group', 'anus phenotype', 'entity', 'closing of the organ part', 'ear morphology phenotype', 'anatomical junction', 'size of anatomical entity phenotype', 'organ part', 'organ part physiology phenotype', 'endoderm-derived structure', 'presumptive ectoderm', 'Low-set ears', 'digit 1 or 5 phenotype', 'unilaminar epithelium', 'cardiogenic splanchnic mesoderm', 'multi-tissue structure phenotype', 'heart primordium', 'presumptive ectoderm phenotype', 'multi organ part structure phenotype', 'anterior neural tube', 'external ear', 'gastrula morphology phenotype', 'interatrial septum', 'anus', 'unilaminar epithelium phenotype', 'heart primordium phenotype', 'sense organ physiology phenotype', 'eye phenotype', 'cardiovascular system', 'shape of external ear phenotype', 'autopod region', 'circulatory system', 'Abnormal cardiac septum morphology', 'non-connected functional system', 'cardiogenic plate', 'eye primordium', 'organ physiology phenotype', 'camera-type eye', 'eye primordium phenotype', 'macromolecule metabolic process phenotype', 'organ', 'cardiogenic splanchnic mesoderm morphology phenotype', 'lateral structure phenotype', 'mesenchyme phenotype', 'splanchnic layer of lateral plate mesoderm phenotype', 'Primum atrial septal defect', 'paired limb/fin', 'esophagus phenotype', 'incomplete closing of the septum', 'appendage', 'atrioventricular canal phenotype', 'optic vesicle', 'heart plus pericardium', 'eyelid apraxia', 'simple eye physiology phenotype', 'skeleton of limb', 'dense mesenchyme tissue', 'thoracic segment of trunk', 'absent material anatomical entity in the multicellular organism', 'digit 1 or 5', 'structure with developmental contribution from neural crest physiology phenotype', 'primary circulatory organ phenotype', 'opening of the anatomical entity', 'ectoderm-derived structure physiology phenotype', 'limb bone phenotype', 'system', 'Abnormal anus morphology', 'appendage phenotype', 'number of cell phenotype', 'alimentary part of gastrointestinal system atresia', 'foregut', 'alimentary part of gastrointestinal system phenotype', 'skull phenotype', 'alimentary part of gastrointestinal system morphology phenotype', 'esophagus atresia', 'Abnormal brain morphology', 'Abnormality of the gastrointestinal tract', 'paired limb/fin bud phenotype', 'esophagus', 'musculature', 'subdivision of tube phenotype', 'nervous system', 'subdivision of digestive tract phenotype', 'number of anatomical entities of type anatomical entity in bone marrow phenotype', 'forelimb bud', 'digestive system element atresia', 'closing of the subdivision of digestive tract', 'Abnormal digestive system morphology', 'Esophageal atresia', 'subdivision of tube', 'decreased number of bone marrow cell', 'developing anatomical structure phenotype', 'subdivision of digestive tract', 'closing of the subdivision of tube', 'closing of the multicellular anatomical structure', 'closing of the anatomical entity', 'digestive system element phenotype', 'closing of the organ', 'bone marrow', 'Abnormality of the digestive system', 'biosynthetic process', 'closing of the anatomical system', 'orifice phenotype', 'digestive system morphology phenotype', 'limb bone', 'heart tube', 'Abnormality of head or neck', 'anatomical structure atresia', 'face', 'Decreased anatomical entity position', 'organ system subdivision', 'foregut morphology phenotype', 'delayed biological_process', 'decreased size of the multicellular organism', 'Growth delay', 'external ear phenotype', 'size of multicellular organism phenotype', 'All', 'subdivision of head', 'multicellular organism height phenotype', 'decreased height of the multicellular organism', 'location of ear phenotype', 'shape of anatomical entity phenotype', 'location of external ear phenotype', 'shape of continuant phenotype', 'Abnormal pinna morphology', 'appendicular skeleton morphology phenotype', 'absent material anatomical entity in the limb', 'number of anatomical enitites of type multicellular anatomical structure phenotype', 'biological_process', 'multi-limb segment region phenotype', 'limb bone morphology phenotype', 'absent material anatomical entity in the forelimb', 'absent organism subdivision in the multicellular organism', 'Aplasia/hypoplasia involving bones of the extremities', 'limb bud phenotype', 'surface structure phenotype', 'anatomical entity morphology in the manus phenotype', 'absent digit', 'digit phenotype', 'Abnormality of body height', 'bone element phenotype', 'decreased number of material anatomical entity in the bone element', 'Aplasia/hypoplasia involving bones of the upper limbs', 'Aplasia/hypoplasia involving the skeleton', 'autopodial extension phenotype', 'pectoral appendage bud phenotype', 'macromolecule biosynthetic process phenotype', 'autopodial skeleton', 'aplastic anatomical entity', 'multi organ part structure physiology phenotype', 'pectoral appendage skeleton', 'manus phenotype', 'regulation of metabolic process', 'decreased height of the anatomical entity', 'aplasia or hypoplasia of manual digit 1', 'absent anatomical entity', 'aplasia or hypoplasia of manual digit', 'ecto-epithelium phenotype', 'autopodial extension', 'Abnormality of the ear', 'ear', 'bone of appendage girdle complex phenotype', 'circulatory system phenotype', 'organ part phenotype', 'absent anatomical structure in the limb'], 'has_descendant': ['MONDO:0014108'], 'has_descendant_label': ['Fanconi anemia complementation group Q'], 'has_descendant_count': 1, 'highlighting': None}]}, 'facet_counts': {'facet_fields': {}, 'facet_queries': {}}, 'highlighting': {}}
