# This file was auto-generated by Fern from our API Definition.

from .....core.pydantic_utilities import UniversalBaseModel
import typing
from .bgp_view_prefix import BgpViewPrefix
import pydantic
from .bgp_view_rir_allocation import BgpViewRirAllocation
from .....core.pydantic_utilities import IS_PYDANTIC_V2


class BgpViewData(UniversalBaseModel):
    """
    Data section of BgpView response containing ASN and prefix information
    """

    ipv_4_prefixes: typing.List[BgpViewPrefix] = pydantic.Field(alias="ipv4_prefixes")
    """
    List of IPv4 prefixes
    """

    ipv_6_prefixes: typing.List[BgpViewPrefix] = pydantic.Field(alias="ipv6_prefixes")
    """
    List of IPv6 prefixes
    """

    asn: int = pydantic.Field()
    """
    Autonomous System Number
    """

    name: str = pydantic.Field()
    """
    Name of the ASN
    """

    description_short: str = pydantic.Field()
    """
    Short description of the ASN
    """

    country_code: str = pydantic.Field()
    """
    Country code for the ASN
    """

    website: str = pydantic.Field()
    """
    Website associated with the ASN
    """

    email_contacts: typing.List[str] = pydantic.Field()
    """
    List of email contacts
    """

    abuse_contacts: typing.List[str] = pydantic.Field()
    """
    List of abuse contacts
    """

    rir_allocation: typing.Optional[BgpViewRirAllocation] = pydantic.Field(default=None)
    """
    Rir allocation information
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
