import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="scailo_sdk",
    version="0.2.3",
    author="Pratheek Adidela",
    author_email="apratheek@unaxiom.com",
    description="Python SDK for the Scailo API",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/scailo/python-sdk",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    license="Apache-2.0",
    python_requires='>=3.6',
    install_requires=[
        "aiohappyeyeballs==2.6.1",
        "aiohttp==3.12.15",
        "aiosignal==1.4.0",
        "annotated-types==0.7.0",
        "anyio==4.10.0",
        "attrs==25.3.0",
        "certifi==2025.8.3",
        "connect-python==0.4.2",
        "frozenlist==1.7.0",
        "googleapis-common-protos==1.70.0",
        "grpcio==1.75.0",
        "grpcio-tools==1.75.0",
        "h11==0.16.0",
        "h2==4.3.0",
        "hpack==4.1.0",
        "httpcore==1.0.9",
        "hyperframe==6.1.0",
        "idna==3.10",
        "multidict==6.6.4",
        "propcache==0.3.2",
        "protobuf==6.32.1",
        "protogen==0.3.1",
        "pydantic==2.11.9",
        "pydantic_core==2.33.2",
        "setuptools>=80.1.0",
        "sniffio==1.3.1",
        "starlette==0.48.0",
        "types-protobuf==6.32.1.20250918",
        "typing-inspection==0.4.1",
        "typing_extensions==4.15.0",
        "urllib3==2.5.0",
        "yarl==1.20.1",
    ],
)