# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendStaticRoleArgs', 'SecretBackendStaticRole']

@pulumi.input_type
class SecretBackendStaticRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 db_name: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 self_managed_password: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SecretBackendStaticRole resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for the static role.
        :param pulumi.Input[_builtins.str] username: The database username that this static role corresponds to.
        :param pulumi.Input[_builtins.str] credential_type: The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        :param pulumi.Input[_builtins.str] name: A unique name to give the static role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time Vault should wait before rotating the password, in seconds.
               Mutually exclusive with `rotation_schedule`.
        :param pulumi.Input[_builtins.str] rotation_schedule: A cron-style string that will define the schedule on which rotations should occur.
               Mutually exclusive with `rotation_period`.
               
               **Warning**: The `rotation_period` and `rotation_schedule` fields are
               mutually exclusive. One of them must be set but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rotation_statements: Database statements to execute to rotate the password for the configured database user.
        :param pulumi.Input[_builtins.int] rotation_window: The amount of time, in seconds, in which rotations are allowed to occur starting
               from a given `rotation_schedule`.
        :param pulumi.Input[_builtins.str] self_managed_password: The password corresponding to the username in the database.
               Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
               select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.bool] skip_import_rotation: If set to true, Vault will skip the
               initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "username", username)
        if credential_config is not None:
            pulumi.set(__self__, "credential_config", credential_config)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_statements is not None:
            pulumi.set(__self__, "rotation_statements", rotation_statements)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if self_managed_password is not None:
            pulumi.set(__self__, "self_managed_password", self_managed_password)
        if skip_import_rotation is not None:
            pulumi.set(__self__, "skip_import_rotation", skip_import_rotation)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the database connection to use for the static role.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The database username that this static role corresponds to.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="credentialConfig")
    def credential_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "credential_config")

    @credential_config.setter
    def credential_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "credential_config", value)

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to give the static role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time Vault should wait before rotating the password, in seconds.
        Mutually exclusive with `rotation_schedule`.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A cron-style string that will define the schedule on which rotations should occur.
        Mutually exclusive with `rotation_period`.

        **Warning**: The `rotation_period` and `rotation_schedule` fields are
        mutually exclusive. One of them must be set but not both.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationStatements")
    def rotation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Database statements to execute to rotate the password for the configured database user.
        """
        return pulumi.get(self, "rotation_statements")

    @rotation_statements.setter
    def rotation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotation_statements", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in seconds, in which rotations are allowed to occur starting
        from a given `rotation_schedule`.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="selfManagedPassword")
    def self_managed_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password corresponding to the username in the database.
        Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
        select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        """
        return pulumi.get(self, "self_managed_password")

    @self_managed_password.setter
    def self_managed_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_managed_password", value)

    @_builtins.property
    @pulumi.getter(name="skipImportRotation")
    def skip_import_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, Vault will skip the
        initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        """
        return pulumi.get(self, "skip_import_rotation")

    @skip_import_rotation.setter
    def skip_import_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_import_rotation", value)


@pulumi.input_type
class _SecretBackendStaticRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 self_managed_password: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendStaticRole resources.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[_builtins.str] credential_type: The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for the static role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the static role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time Vault should wait before rotating the password, in seconds.
               Mutually exclusive with `rotation_schedule`.
        :param pulumi.Input[_builtins.str] rotation_schedule: A cron-style string that will define the schedule on which rotations should occur.
               Mutually exclusive with `rotation_period`.
               
               **Warning**: The `rotation_period` and `rotation_schedule` fields are
               mutually exclusive. One of them must be set but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rotation_statements: Database statements to execute to rotate the password for the configured database user.
        :param pulumi.Input[_builtins.int] rotation_window: The amount of time, in seconds, in which rotations are allowed to occur starting
               from a given `rotation_schedule`.
        :param pulumi.Input[_builtins.str] self_managed_password: The password corresponding to the username in the database.
               Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
               select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.bool] skip_import_rotation: If set to true, Vault will skip the
               initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.str] username: The database username that this static role corresponds to.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if credential_config is not None:
            pulumi.set(__self__, "credential_config", credential_config)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_statements is not None:
            pulumi.set(__self__, "rotation_statements", rotation_statements)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if self_managed_password is not None:
            pulumi.set(__self__, "self_managed_password", self_managed_password)
        if skip_import_rotation is not None:
            pulumi.set(__self__, "skip_import_rotation", skip_import_rotation)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="credentialConfig")
    def credential_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "credential_config")

    @credential_config.setter
    def credential_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "credential_config", value)

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the database connection to use for the static role.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to give the static role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time Vault should wait before rotating the password, in seconds.
        Mutually exclusive with `rotation_schedule`.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A cron-style string that will define the schedule on which rotations should occur.
        Mutually exclusive with `rotation_period`.

        **Warning**: The `rotation_period` and `rotation_schedule` fields are
        mutually exclusive. One of them must be set but not both.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationStatements")
    def rotation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Database statements to execute to rotate the password for the configured database user.
        """
        return pulumi.get(self, "rotation_statements")

    @rotation_statements.setter
    def rotation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotation_statements", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in seconds, in which rotations are allowed to occur starting
        from a given `rotation_schedule`.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="selfManagedPassword")
    def self_managed_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password corresponding to the username in the database.
        Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
        select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        """
        return pulumi.get(self, "self_managed_password")

    @self_managed_password.setter
    def self_managed_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_managed_password", value)

    @_builtins.property
    @pulumi.getter(name="skipImportRotation")
    def skip_import_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, Vault will skip the
        initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        """
        return pulumi.get(self, "skip_import_rotation")

    @skip_import_rotation.setter
    def skip_import_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_import_rotation", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database username that this static role corresponds to.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("vault:database/secretBackendStaticRole:SecretBackendStaticRole")
class SecretBackendStaticRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 self_managed_password: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Database Secret Backend static role in Vault. Database secret backend
        static roles can be used to manage 1-to-1 mapping of a Vault Role to a user in a
        database for the database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            backend=db.path,
            name="postgres",
            allowed_roles=["*"],
            postgresql={
                "connection_url": "postgres://username:password@host:port/database",
            })
        # configure a static role with period-based rotations
        period_role = vault.database.SecretBackendStaticRole("period_role",
            backend=db.path,
            name="my-period-role",
            db_name=postgres.name,
            username="example",
            rotation_period=3600,
            rotation_statements=["ALTER USER \\"{{name}}\\" WITH PASSWORD '{{password}}';"])
        # configure a static role with schedule-based rotations
        schedule_role = vault.database.SecretBackendStaticRole("schedule_role",
            backend=db.path,
            name="my-schedule-role",
            db_name=postgres.name,
            username="example",
            rotation_schedule="0 0 * * SAT",
            rotation_window=172800,
            rotation_statements=["ALTER USER \\"{{name}}\\" WITH PASSWORD '{{password}}';"])
        ```

        ## Import

        Database secret backend static roles can be imported using the `backend`, `/static-roles/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:database/secretBackendStaticRole:SecretBackendStaticRole example postgres/static-roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[_builtins.str] credential_type: The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for the static role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the static role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time Vault should wait before rotating the password, in seconds.
               Mutually exclusive with `rotation_schedule`.
        :param pulumi.Input[_builtins.str] rotation_schedule: A cron-style string that will define the schedule on which rotations should occur.
               Mutually exclusive with `rotation_period`.
               
               **Warning**: The `rotation_period` and `rotation_schedule` fields are
               mutually exclusive. One of them must be set but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rotation_statements: Database statements to execute to rotate the password for the configured database user.
        :param pulumi.Input[_builtins.int] rotation_window: The amount of time, in seconds, in which rotations are allowed to occur starting
               from a given `rotation_schedule`.
        :param pulumi.Input[_builtins.str] self_managed_password: The password corresponding to the username in the database.
               Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
               select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.bool] skip_import_rotation: If set to true, Vault will skip the
               initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.str] username: The database username that this static role corresponds to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendStaticRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Database Secret Backend static role in Vault. Database secret backend
        static roles can be used to manage 1-to-1 mapping of a Vault Role to a user in a
        database for the database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            backend=db.path,
            name="postgres",
            allowed_roles=["*"],
            postgresql={
                "connection_url": "postgres://username:password@host:port/database",
            })
        # configure a static role with period-based rotations
        period_role = vault.database.SecretBackendStaticRole("period_role",
            backend=db.path,
            name="my-period-role",
            db_name=postgres.name,
            username="example",
            rotation_period=3600,
            rotation_statements=["ALTER USER \\"{{name}}\\" WITH PASSWORD '{{password}}';"])
        # configure a static role with schedule-based rotations
        schedule_role = vault.database.SecretBackendStaticRole("schedule_role",
            backend=db.path,
            name="my-schedule-role",
            db_name=postgres.name,
            username="example",
            rotation_schedule="0 0 * * SAT",
            rotation_window=172800,
            rotation_statements=["ALTER USER \\"{{name}}\\" WITH PASSWORD '{{password}}';"])
        ```

        ## Import

        Database secret backend static roles can be imported using the `backend`, `/static-roles/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:database/secretBackendStaticRole:SecretBackendStaticRole example postgres/static-roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendStaticRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendStaticRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 self_managed_password: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendStaticRoleArgs.__new__(SecretBackendStaticRoleArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["credential_config"] = credential_config
            __props__.__dict__["credential_type"] = credential_type
            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_statements"] = rotation_statements
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["self_managed_password"] = None if self_managed_password is None else pulumi.Output.secret(self_managed_password)
            __props__.__dict__["skip_import_rotation"] = skip_import_rotation
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["selfManagedPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackendStaticRole, __self__).__init__(
            'vault:database/secretBackendStaticRole:SecretBackendStaticRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            credential_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            self_managed_password: Optional[pulumi.Input[_builtins.str]] = None,
            skip_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackendStaticRole':
        """
        Get an existing SecretBackendStaticRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[_builtins.str] credential_type: The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for the static role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the static role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time Vault should wait before rotating the password, in seconds.
               Mutually exclusive with `rotation_schedule`.
        :param pulumi.Input[_builtins.str] rotation_schedule: A cron-style string that will define the schedule on which rotations should occur.
               Mutually exclusive with `rotation_period`.
               
               **Warning**: The `rotation_period` and `rotation_schedule` fields are
               mutually exclusive. One of them must be set but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rotation_statements: Database statements to execute to rotate the password for the configured database user.
        :param pulumi.Input[_builtins.int] rotation_window: The amount of time, in seconds, in which rotations are allowed to occur starting
               from a given `rotation_schedule`.
        :param pulumi.Input[_builtins.str] self_managed_password: The password corresponding to the username in the database.
               Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
               select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.bool] skip_import_rotation: If set to true, Vault will skip the
               initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        :param pulumi.Input[_builtins.str] username: The database username that this static role corresponds to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendStaticRoleState.__new__(_SecretBackendStaticRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["credential_config"] = credential_config
        __props__.__dict__["credential_type"] = credential_type
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_statements"] = rotation_statements
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["self_managed_password"] = self_managed_password
        __props__.__dict__["skip_import_rotation"] = skip_import_rotation
        __props__.__dict__["username"] = username
        return SecretBackendStaticRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="credentialConfig")
    def credential_config(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "credential_config")

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[_builtins.str]:
        """
        The credential type for the user, can be one of "password", "rsa_private_key" or "client_certificate".The configuration can be done in `credential_config`.
        """
        return pulumi.get(self, "credential_type")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the database connection to use for the static role.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name to give the static role.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time Vault should wait before rotating the password, in seconds.
        Mutually exclusive with `rotation_schedule`.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A cron-style string that will define the schedule on which rotations should occur.
        Mutually exclusive with `rotation_period`.

        **Warning**: The `rotation_period` and `rotation_schedule` fields are
        mutually exclusive. One of them must be set but not both.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationStatements")
    def rotation_statements(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Database statements to execute to rotate the password for the configured database user.
        """
        return pulumi.get(self, "rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time, in seconds, in which rotations are allowed to occur starting
        from a given `rotation_schedule`.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="selfManagedPassword")
    def self_managed_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password corresponding to the username in the database.
        Required when using the Rootless Password Rotation workflow for static roles. Only enabled for
        select DB engines (Postgres). Requires Vault 1.18+ Enterprise.
        """
        return pulumi.get(self, "self_managed_password")

    @_builtins.property
    @pulumi.getter(name="skipImportRotation")
    def skip_import_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, Vault will skip the
        initial secret rotation on import. Requires Vault 1.18+ Enterprise.
        """
        return pulumi.get(self, "skip_import_rotation")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The database username that this static role corresponds to.
        """
        return pulumi.get(self, "username")

