# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AuthBackendCustomEndpoint',
    'AuthBackendTune',
    'SecretRolesetBinding',
    'SecretStaticAccountBinding',
]

@pulumi.output_type
class AuthBackendCustomEndpoint(dict):
    def __init__(__self__, *,
                 api: Optional[_builtins.str] = None,
                 compute: Optional[_builtins.str] = None,
                 crm: Optional[_builtins.str] = None,
                 iam: Optional[_builtins.str] = None):
        """
        :param _builtins.str api: Replaces the service endpoint used in API requests to `https://www.googleapis.com`.
        :param _builtins.str compute: Replaces the service endpoint used in API requests to `https://compute.googleapis.com`.
               
               The endpoint value provided for a given key has the form of `scheme://host:port`.
               The `scheme://` and `:port` portions of the endpoint value are optional.
        :param _builtins.str crm: Replaces the service endpoint used in API requests to `https://cloudresourcemanager.googleapis.com`.
        :param _builtins.str iam: Replaces the service endpoint used in API requests to `https://iam.googleapis.com`.
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if crm is not None:
            pulumi.set(__self__, "crm", crm)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)

    @_builtins.property
    @pulumi.getter
    def api(self) -> Optional[_builtins.str]:
        """
        Replaces the service endpoint used in API requests to `https://www.googleapis.com`.
        """
        return pulumi.get(self, "api")

    @_builtins.property
    @pulumi.getter
    def compute(self) -> Optional[_builtins.str]:
        """
        Replaces the service endpoint used in API requests to `https://compute.googleapis.com`.

        The endpoint value provided for a given key has the form of `scheme://host:port`.
        The `scheme://` and `:port` portions of the endpoint value are optional.
        """
        return pulumi.get(self, "compute")

    @_builtins.property
    @pulumi.getter
    def crm(self) -> Optional[_builtins.str]:
        """
        Replaces the service endpoint used in API requests to `https://cloudresourcemanager.googleapis.com`.
        """
        return pulumi.get(self, "crm")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[_builtins.str]:
        """
        Replaces the service endpoint used in API requests to `https://iam.googleapis.com`.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class AuthBackendTune(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedResponseHeaders":
            suggest = "allowed_response_headers"
        elif key == "auditNonHmacRequestKeys":
            suggest = "audit_non_hmac_request_keys"
        elif key == "auditNonHmacResponseKeys":
            suggest = "audit_non_hmac_response_keys"
        elif key == "defaultLeaseTtl":
            suggest = "default_lease_ttl"
        elif key == "listingVisibility":
            suggest = "listing_visibility"
        elif key == "maxLeaseTtl":
            suggest = "max_lease_ttl"
        elif key == "passthroughRequestHeaders":
            suggest = "passthrough_request_headers"
        elif key == "tokenType":
            suggest = "token_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthBackendTune. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthBackendTune.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthBackendTune.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_response_headers: Optional[Sequence[_builtins.str]] = None,
                 audit_non_hmac_request_keys: Optional[Sequence[_builtins.str]] = None,
                 audit_non_hmac_response_keys: Optional[Sequence[_builtins.str]] = None,
                 default_lease_ttl: Optional[_builtins.str] = None,
                 listing_visibility: Optional[_builtins.str] = None,
                 max_lease_ttl: Optional[_builtins.str] = None,
                 passthrough_request_headers: Optional[Sequence[_builtins.str]] = None,
                 token_type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] allowed_response_headers: List of headers to whitelist and allowing
               a plugin to include them in the response.
        :param Sequence[_builtins.str] audit_non_hmac_request_keys: Specifies the list of keys that will
               not be HMAC'd by audit devices in the request data object.
        :param Sequence[_builtins.str] audit_non_hmac_response_keys: Specifies the list of keys that will
               not be HMAC'd by audit devices in the response data object.
        :param _builtins.str default_lease_ttl: Specifies the default time-to-live.
               If set, this overrides the global default.
               Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        :param _builtins.str listing_visibility: Specifies whether to show this mount in
               the UI-specific listing endpoint. Valid values are "unauth" or "hidden".
        :param _builtins.str max_lease_ttl: Specifies the maximum time-to-live.
               If set, this overrides the global default.
               Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        :param Sequence[_builtins.str] passthrough_request_headers: List of headers to whitelist and
               pass from the request to the backend.
        :param _builtins.str token_type: Specifies the type of tokens that should be returned by
               the mount. Valid values are "default-service", "default-batch", "service", "batch".
               
               
               For more details on the usage of each argument consult the [Vault GCP API documentation](https://www.vaultproject.io/api-docs/auth/gcp#configure).
        """
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if default_lease_ttl is not None:
            pulumi.set(__self__, "default_lease_ttl", default_lease_ttl)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if max_lease_ttl is not None:
            pulumi.set(__self__, "max_lease_ttl", max_lease_ttl)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of headers to whitelist and allowing
        a plugin to include them in the response.
        """
        return pulumi.get(self, "allowed_response_headers")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will
        not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will
        not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtl")
    def default_lease_ttl(self) -> Optional[_builtins.str]:
        """
        Specifies the default time-to-live.
        If set, this overrides the global default.
        Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        """
        return pulumi.get(self, "default_lease_ttl")

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[_builtins.str]:
        """
        Specifies whether to show this mount in
        the UI-specific listing endpoint. Valid values are "unauth" or "hidden".
        """
        return pulumi.get(self, "listing_visibility")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtl")
    def max_lease_ttl(self) -> Optional[_builtins.str]:
        """
        Specifies the maximum time-to-live.
        If set, this overrides the global default.
        Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        """
        return pulumi.get(self, "max_lease_ttl")

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of headers to whitelist and
        pass from the request to the backend.
        """
        return pulumi.get(self, "passthrough_request_headers")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of tokens that should be returned by
        the mount. Valid values are "default-service", "default-batch", "service", "batch".


        For more details on the usage of each argument consult the [Vault GCP API documentation](https://www.vaultproject.io/api-docs/auth/gcp#configure).
        """
        return pulumi.get(self, "token_type")


@pulumi.output_type
class SecretRolesetBinding(dict):
    def __init__(__self__, *,
                 resource: _builtins.str,
                 roles: Sequence[_builtins.str]):
        """
        :param _builtins.str resource: Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#roleset-bindings).
        :param Sequence[_builtins.str] roles: List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> _builtins.str:
        """
        Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#roleset-bindings).
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class SecretStaticAccountBinding(dict):
    def __init__(__self__, *,
                 resource: _builtins.str,
                 roles: Sequence[_builtins.str]):
        """
        :param _builtins.str resource: Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#bindings).
        :param Sequence[_builtins.str] roles: List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> _builtins.str:
        """
        Resource or resource path for which IAM policy information will be bound. The resource path may be specified in a few different [formats](https://www.vaultproject.io/docs/secrets/gcp/index.html#bindings).
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        List of [GCP IAM roles](https://cloud.google.com/iam/docs/understanding-roles) for the resource.
        """
        return pulumi.get(self, "roles")


