# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 data_json: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 disable_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_absent_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 write_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[_builtins.str] data_json: String containing a JSON-encoded object that will be
               written to the given path as the secret data.
        :param pulumi.Input[_builtins.str] path: The full logical path at which to write the given
               data. Consult each backend's documentation to see which endpoints
               support the `PUT` methods and to determine whether they also support
               `DELETE` and `GET`.
        :param pulumi.Input[_builtins.bool] disable_delete: - (Optional) True/false. Set this to true if your
               vault authentication is not able to delete the data or if the endpoint
               does not support the `DELETE` method. Defaults to false.
        :param pulumi.Input[_builtins.bool] disable_read: True/false. Set this to true if your vault
               authentication is not able to read the data or if the endpoint does
               not support the `GET` method. Setting this to `true` will break drift
               detection. You should set this to `true` for endpoints that are
               write-only. Defaults to false.
        :param pulumi.Input[_builtins.bool] ignore_absent_fields: - (Optional) True/false. If set to true,
               ignore any fields present when the endpoint is read but that were not
               in `data_json`. Also, if a field that was written is not returned when
               the endpoint is read, treat that field as being up to date. You should
               set this to `true` when writing to endpoint that, when read, returns a
               different set of fields from the ones you wrote, as is common with
               many configuration endpoints. Defaults to false.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] write_fields: - (Optional). A list of fields that should be returned
               in `write_data_json` and `write_data`. If omitted, data returned by
               the write operation is not available to the resource or included in
               state. This helps to avoid accidental storage of sensitive values in
               state. Some endpoints, such as many dynamic secrets endpoints, return
               data from writing to an endpoint rather than reading it. You should
               use `write_fields` if you need information returned in this way.
        """
        pulumi.set(__self__, "data_json", data_json)
        pulumi.set(__self__, "path", path)
        if disable_delete is not None:
            pulumi.set(__self__, "disable_delete", disable_delete)
        if disable_read is not None:
            pulumi.set(__self__, "disable_read", disable_read)
        if ignore_absent_fields is not None:
            pulumi.set(__self__, "ignore_absent_fields", ignore_absent_fields)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if write_fields is not None:
            pulumi.set(__self__, "write_fields", write_fields)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Input[_builtins.str]:
        """
        String containing a JSON-encoded object that will be
        written to the given path as the secret data.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The full logical path at which to write the given
        data. Consult each backend's documentation to see which endpoints
        support the `PUT` methods and to determine whether they also support
        `DELETE` and `GET`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="disableDelete")
    def disable_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) True/false. Set this to true if your
        vault authentication is not able to delete the data or if the endpoint
        does not support the `DELETE` method. Defaults to false.
        """
        return pulumi.get(self, "disable_delete")

    @disable_delete.setter
    def disable_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_delete", value)

    @_builtins.property
    @pulumi.getter(name="disableRead")
    def disable_read(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True/false. Set this to true if your vault
        authentication is not able to read the data or if the endpoint does
        not support the `GET` method. Setting this to `true` will break drift
        detection. You should set this to `true` for endpoints that are
        write-only. Defaults to false.
        """
        return pulumi.get(self, "disable_read")

    @disable_read.setter
    def disable_read(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_read", value)

    @_builtins.property
    @pulumi.getter(name="ignoreAbsentFields")
    def ignore_absent_fields(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) True/false. If set to true,
        ignore any fields present when the endpoint is read but that were not
        in `data_json`. Also, if a field that was written is not returned when
        the endpoint is read, treat that field as being up to date. You should
        set this to `true` when writing to endpoint that, when read, returns a
        different set of fields from the ones you wrote, as is common with
        many configuration endpoints. Defaults to false.
        """
        return pulumi.get(self, "ignore_absent_fields")

    @ignore_absent_fields.setter
    def ignore_absent_fields(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_absent_fields", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="writeFields")
    def write_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional). A list of fields that should be returned
        in `write_data_json` and `write_data`. If omitted, data returned by
        the write operation is not available to the resource or included in
        state. This helps to avoid accidental storage of sensitive values in
        state. Some endpoints, such as many dynamic secrets endpoints, return
        data from writing to an endpoint rather than reading it. You should
        use `write_fields` if you need information returned in this way.
        """
        return pulumi.get(self, "write_fields")

    @write_fields.setter
    def write_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "write_fields", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_absent_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 write_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 write_data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 write_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[_builtins.str] data_json: String containing a JSON-encoded object that will be
               written to the given path as the secret data.
        :param pulumi.Input[_builtins.bool] disable_delete: - (Optional) True/false. Set this to true if your
               vault authentication is not able to delete the data or if the endpoint
               does not support the `DELETE` method. Defaults to false.
        :param pulumi.Input[_builtins.bool] disable_read: True/false. Set this to true if your vault
               authentication is not able to read the data or if the endpoint does
               not support the `GET` method. Setting this to `true` will break drift
               detection. You should set this to `true` for endpoints that are
               write-only. Defaults to false.
        :param pulumi.Input[_builtins.bool] ignore_absent_fields: - (Optional) True/false. If set to true,
               ignore any fields present when the endpoint is read but that were not
               in `data_json`. Also, if a field that was written is not returned when
               the endpoint is read, treat that field as being up to date. You should
               set this to `true` when writing to endpoint that, when read, returns a
               different set of fields from the ones you wrote, as is common with
               many configuration endpoints. Defaults to false.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The full logical path at which to write the given
               data. Consult each backend's documentation to see which endpoints
               support the `PUT` methods and to determine whether they also support
               `DELETE` and `GET`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] write_data: - A map whose keys are the top-level data keys
               returned from Vault by the write operation and whose values are the
               corresponding values. This map can only represent string data, so
               any non-string values returned from Vault are serialized as JSON.
               Only fields set in `write_fields` are present in the JSON data.
        :param pulumi.Input[_builtins.str] write_data_json: - The JSON data returned by the write operation.
               Only fields set in `write_fields` are present in the JSON data.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] write_fields: - (Optional). A list of fields that should be returned
               in `write_data_json` and `write_data`. If omitted, data returned by
               the write operation is not available to the resource or included in
               state. This helps to avoid accidental storage of sensitive values in
               state. Some endpoints, such as many dynamic secrets endpoints, return
               data from writing to an endpoint rather than reading it. You should
               use `write_fields` if you need information returned in this way.
        """
        if data_json is not None:
            pulumi.set(__self__, "data_json", data_json)
        if disable_delete is not None:
            pulumi.set(__self__, "disable_delete", disable_delete)
        if disable_read is not None:
            pulumi.set(__self__, "disable_read", disable_read)
        if ignore_absent_fields is not None:
            pulumi.set(__self__, "ignore_absent_fields", ignore_absent_fields)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if write_data is not None:
            pulumi.set(__self__, "write_data", write_data)
        if write_data_json is not None:
            pulumi.set(__self__, "write_data_json", write_data_json)
        if write_fields is not None:
            pulumi.set(__self__, "write_fields", write_fields)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String containing a JSON-encoded object that will be
        written to the given path as the secret data.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter(name="disableDelete")
    def disable_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) True/false. Set this to true if your
        vault authentication is not able to delete the data or if the endpoint
        does not support the `DELETE` method. Defaults to false.
        """
        return pulumi.get(self, "disable_delete")

    @disable_delete.setter
    def disable_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_delete", value)

    @_builtins.property
    @pulumi.getter(name="disableRead")
    def disable_read(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True/false. Set this to true if your vault
        authentication is not able to read the data or if the endpoint does
        not support the `GET` method. Setting this to `true` will break drift
        detection. You should set this to `true` for endpoints that are
        write-only. Defaults to false.
        """
        return pulumi.get(self, "disable_read")

    @disable_read.setter
    def disable_read(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_read", value)

    @_builtins.property
    @pulumi.getter(name="ignoreAbsentFields")
    def ignore_absent_fields(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) True/false. If set to true,
        ignore any fields present when the endpoint is read but that were not
        in `data_json`. Also, if a field that was written is not returned when
        the endpoint is read, treat that field as being up to date. You should
        set this to `true` when writing to endpoint that, when read, returns a
        different set of fields from the ones you wrote, as is common with
        many configuration endpoints. Defaults to false.
        """
        return pulumi.get(self, "ignore_absent_fields")

    @ignore_absent_fields.setter
    def ignore_absent_fields(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_absent_fields", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full logical path at which to write the given
        data. Consult each backend's documentation to see which endpoints
        support the `PUT` methods and to determine whether they also support
        `DELETE` and `GET`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="writeData")
    def write_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - A map whose keys are the top-level data keys
        returned from Vault by the write operation and whose values are the
        corresponding values. This map can only represent string data, so
        any non-string values returned from Vault are serialized as JSON.
        Only fields set in `write_fields` are present in the JSON data.
        """
        return pulumi.get(self, "write_data")

    @write_data.setter
    def write_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "write_data", value)

    @_builtins.property
    @pulumi.getter(name="writeDataJson")
    def write_data_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The JSON data returned by the write operation.
        Only fields set in `write_fields` are present in the JSON data.
        """
        return pulumi.get(self, "write_data_json")

    @write_data_json.setter
    def write_data_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "write_data_json", value)

    @_builtins.property
    @pulumi.getter(name="writeFields")
    def write_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - (Optional). A list of fields that should be returned
        in `write_data_json` and `write_data`. If omitted, data returned by
        the write operation is not available to the resource or included in
        state. This helps to avoid accidental storage of sensitive values in
        state. Some endpoints, such as many dynamic secrets endpoints, return
        data from writing to an endpoint rather than reading it. You should
        use `write_fields` if you need information returned in this way.
        """
        return pulumi.get(self, "write_fields")

    @write_fields.setter
    def write_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "write_fields", value)


@pulumi.type_token("vault:generic/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_absent_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 write_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        userpass = vault.AuthBackend("userpass", type="userpass")
        u1 = vault.generic.Endpoint("u1",
            path="auth/userpass/users/u1",
            ignore_absent_fields=True,
            data_json=\"\"\"{
          "policies": ["p1"],
          "password": "changeme"
        }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[userpass]))
        u1_token = vault.generic.Endpoint("u1_token",
            path="auth/userpass/login/u1",
            disable_read=True,
            disable_delete=True,
            data_json=\"\"\"{
          "password": "changeme"
        }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[u1]))
        u1_entity = vault.generic.Endpoint("u1_entity",
            disable_read=True,
            disable_delete=True,
            path="identity/lookup/entity",
            ignore_absent_fields=True,
            write_fields=["id"],
            data_json=\"\"\"{
          "alias_name": "u1",
          "alias_mount_accessor": vault_auth_backend.userpass.accessor
        }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[u1_token]))
        pulumi.export("u1Id", u1_entity.write_data["id"])
        ```

        ## Required Vault Capabilities

        Use of this resource requires the `create` or `update` capability
        (depending on whether the resource already exists) on the given path. If
        `disable_delete` is false, the `delete` capability is also required. If
        `disable_read` is false, the `read` capability is required.

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_json: String containing a JSON-encoded object that will be
               written to the given path as the secret data.
        :param pulumi.Input[_builtins.bool] disable_delete: - (Optional) True/false. Set this to true if your
               vault authentication is not able to delete the data or if the endpoint
               does not support the `DELETE` method. Defaults to false.
        :param pulumi.Input[_builtins.bool] disable_read: True/false. Set this to true if your vault
               authentication is not able to read the data or if the endpoint does
               not support the `GET` method. Setting this to `true` will break drift
               detection. You should set this to `true` for endpoints that are
               write-only. Defaults to false.
        :param pulumi.Input[_builtins.bool] ignore_absent_fields: - (Optional) True/false. If set to true,
               ignore any fields present when the endpoint is read but that were not
               in `data_json`. Also, if a field that was written is not returned when
               the endpoint is read, treat that field as being up to date. You should
               set this to `true` when writing to endpoint that, when read, returns a
               different set of fields from the ones you wrote, as is common with
               many configuration endpoints. Defaults to false.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The full logical path at which to write the given
               data. Consult each backend's documentation to see which endpoints
               support the `PUT` methods and to determine whether they also support
               `DELETE` and `GET`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] write_fields: - (Optional). A list of fields that should be returned
               in `write_data_json` and `write_data`. If omitted, data returned by
               the write operation is not available to the resource or included in
               state. This helps to avoid accidental storage of sensitive values in
               state. Some endpoints, such as many dynamic secrets endpoints, return
               data from writing to an endpoint rather than reading it. You should
               use `write_fields` if you need information returned in this way.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        userpass = vault.AuthBackend("userpass", type="userpass")
        u1 = vault.generic.Endpoint("u1",
            path="auth/userpass/users/u1",
            ignore_absent_fields=True,
            data_json=\"\"\"{
          "policies": ["p1"],
          "password": "changeme"
        }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[userpass]))
        u1_token = vault.generic.Endpoint("u1_token",
            path="auth/userpass/login/u1",
            disable_read=True,
            disable_delete=True,
            data_json=\"\"\"{
          "password": "changeme"
        }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[u1]))
        u1_entity = vault.generic.Endpoint("u1_entity",
            disable_read=True,
            disable_delete=True,
            path="identity/lookup/entity",
            ignore_absent_fields=True,
            write_fields=["id"],
            data_json=\"\"\"{
          "alias_name": "u1",
          "alias_mount_accessor": vault_auth_backend.userpass.accessor
        }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[u1_token]))
        pulumi.export("u1Id", u1_entity.write_data["id"])
        ```

        ## Required Vault Capabilities

        Use of this resource requires the `create` or `update` capability
        (depending on whether the resource already exists) on the given path. If
        `disable_delete` is false, the `delete` capability is also required. If
        `disable_read` is false, the `read` capability is required.

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_absent_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 write_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            if data_json is None and not opts.urn:
                raise TypeError("Missing required property 'data_json'")
            __props__.__dict__["data_json"] = None if data_json is None else pulumi.Output.secret(data_json)
            __props__.__dict__["disable_delete"] = disable_delete
            __props__.__dict__["disable_read"] = disable_read
            __props__.__dict__["ignore_absent_fields"] = ignore_absent_fields
            __props__.__dict__["namespace"] = namespace
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["write_fields"] = write_fields
            __props__.__dict__["write_data"] = None
            __props__.__dict__["write_data_json"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["dataJson"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Endpoint, __self__).__init__(
            'vault:generic/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_json: Optional[pulumi.Input[_builtins.str]] = None,
            disable_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_absent_fields: Optional[pulumi.Input[_builtins.bool]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            write_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            write_data_json: Optional[pulumi.Input[_builtins.str]] = None,
            write_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_json: String containing a JSON-encoded object that will be
               written to the given path as the secret data.
        :param pulumi.Input[_builtins.bool] disable_delete: - (Optional) True/false. Set this to true if your
               vault authentication is not able to delete the data or if the endpoint
               does not support the `DELETE` method. Defaults to false.
        :param pulumi.Input[_builtins.bool] disable_read: True/false. Set this to true if your vault
               authentication is not able to read the data or if the endpoint does
               not support the `GET` method. Setting this to `true` will break drift
               detection. You should set this to `true` for endpoints that are
               write-only. Defaults to false.
        :param pulumi.Input[_builtins.bool] ignore_absent_fields: - (Optional) True/false. If set to true,
               ignore any fields present when the endpoint is read but that were not
               in `data_json`. Also, if a field that was written is not returned when
               the endpoint is read, treat that field as being up to date. You should
               set this to `true` when writing to endpoint that, when read, returns a
               different set of fields from the ones you wrote, as is common with
               many configuration endpoints. Defaults to false.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The full logical path at which to write the given
               data. Consult each backend's documentation to see which endpoints
               support the `PUT` methods and to determine whether they also support
               `DELETE` and `GET`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] write_data: - A map whose keys are the top-level data keys
               returned from Vault by the write operation and whose values are the
               corresponding values. This map can only represent string data, so
               any non-string values returned from Vault are serialized as JSON.
               Only fields set in `write_fields` are present in the JSON data.
        :param pulumi.Input[_builtins.str] write_data_json: - The JSON data returned by the write operation.
               Only fields set in `write_fields` are present in the JSON data.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] write_fields: - (Optional). A list of fields that should be returned
               in `write_data_json` and `write_data`. If omitted, data returned by
               the write operation is not available to the resource or included in
               state. This helps to avoid accidental storage of sensitive values in
               state. Some endpoints, such as many dynamic secrets endpoints, return
               data from writing to an endpoint rather than reading it. You should
               use `write_fields` if you need information returned in this way.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["data_json"] = data_json
        __props__.__dict__["disable_delete"] = disable_delete
        __props__.__dict__["disable_read"] = disable_read
        __props__.__dict__["ignore_absent_fields"] = ignore_absent_fields
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["write_data"] = write_data
        __props__.__dict__["write_data_json"] = write_data_json
        __props__.__dict__["write_fields"] = write_fields
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Output[_builtins.str]:
        """
        String containing a JSON-encoded object that will be
        written to the given path as the secret data.
        """
        return pulumi.get(self, "data_json")

    @_builtins.property
    @pulumi.getter(name="disableDelete")
    def disable_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) True/false. Set this to true if your
        vault authentication is not able to delete the data or if the endpoint
        does not support the `DELETE` method. Defaults to false.
        """
        return pulumi.get(self, "disable_delete")

    @_builtins.property
    @pulumi.getter(name="disableRead")
    def disable_read(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        True/false. Set this to true if your vault
        authentication is not able to read the data or if the endpoint does
        not support the `GET` method. Setting this to `true` will break drift
        detection. You should set this to `true` for endpoints that are
        write-only. Defaults to false.
        """
        return pulumi.get(self, "disable_read")

    @_builtins.property
    @pulumi.getter(name="ignoreAbsentFields")
    def ignore_absent_fields(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) True/false. If set to true,
        ignore any fields present when the endpoint is read but that were not
        in `data_json`. Also, if a field that was written is not returned when
        the endpoint is read, treat that field as being up to date. You should
        set this to `true` when writing to endpoint that, when read, returns a
        different set of fields from the ones you wrote, as is common with
        many configuration endpoints. Defaults to false.
        """
        return pulumi.get(self, "ignore_absent_fields")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The full logical path at which to write the given
        data. Consult each backend's documentation to see which endpoints
        support the `PUT` methods and to determine whether they also support
        `DELETE` and `GET`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="writeData")
    def write_data(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - A map whose keys are the top-level data keys
        returned from Vault by the write operation and whose values are the
        corresponding values. This map can only represent string data, so
        any non-string values returned from Vault are serialized as JSON.
        Only fields set in `write_fields` are present in the JSON data.
        """
        return pulumi.get(self, "write_data")

    @_builtins.property
    @pulumi.getter(name="writeDataJson")
    def write_data_json(self) -> pulumi.Output[_builtins.str]:
        """
        - The JSON data returned by the write operation.
        Only fields set in `write_fields` are present in the JSON data.
        """
        return pulumi.get(self, "write_data_json")

    @_builtins.property
    @pulumi.getter(name="writeFields")
    def write_fields(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        - (Optional). A list of fields that should be returned
        in `write_data_json` and `write_data`. If omitted, data returned by
        the write operation is not available to the resource or included in
        state. This helps to avoid accidental storage of sensitive values in
        state. Some endpoints, such as many dynamic secrets endpoints, return
        data from writing to an endpoint rather than reading it. You should
        use `write_fields` if you need information returned in this way.
        """
        return pulumi.get(self, "write_fields")

