# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAuthBackendsResult',
    'AwaitableGetAuthBackendsResult',
    'get_auth_backends',
    'get_auth_backends_output',
]

@pulumi.output_type
class GetAuthBackendsResult:
    """
    A collection of values returned by getAuthBackends.
    """
    def __init__(__self__, accessors=None, id=None, namespace=None, paths=None, type=None):
        if accessors and not isinstance(accessors, list):
            raise TypeError("Expected argument 'accessors' to be a list")
        pulumi.set(__self__, "accessors", accessors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if paths and not isinstance(paths, list):
            raise TypeError("Expected argument 'paths' to be a list")
        pulumi.set(__self__, "paths", paths)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def accessors(self) -> Sequence[_builtins.str]:
        """
        The accessor IDs for the auth methods.
        """
        return pulumi.get(self, "accessors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        List of auth backend mount points.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


class AwaitableGetAuthBackendsResult(GetAuthBackendsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthBackendsResult(
            accessors=self.accessors,
            id=self.id,
            namespace=self.namespace,
            paths=self.paths,
            type=self.type)


def get_auth_backends(namespace: Optional[_builtins.str] = None,
                      type: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthBackendsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    example = vault.get_auth_backends()
    ```

    ```python
    import pulumi
    import pulumi_vault as vault

    example_filter = vault.get_auth_backends(type="kubernetes")
    ```


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str type: The name of the auth method type. Allows filtering of backends returned by type.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:index/getAuthBackends:getAuthBackends', __args__, opts=opts, typ=GetAuthBackendsResult).value

    return AwaitableGetAuthBackendsResult(
        accessors=pulumi.get(__ret__, 'accessors'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        paths=pulumi.get(__ret__, 'paths'),
        type=pulumi.get(__ret__, 'type'))
def get_auth_backends_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthBackendsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    example = vault.get_auth_backends()
    ```

    ```python
    import pulumi
    import pulumi_vault as vault

    example_filter = vault.get_auth_backends(type="kubernetes")
    ```


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str type: The name of the auth method type. Allows filtering of backends returned by type.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:index/getAuthBackends:getAuthBackends', __args__, opts=opts, typ=GetAuthBackendsResult)
    return __ret__.apply(lambda __response__: GetAuthBackendsResult(
        accessors=pulumi.get(__response__, 'accessors'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        paths=pulumi.get(__response__, 'paths'),
        type=pulumi.get(__response__, 'type')))
