# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OciAuthBackendArgs', 'OciAuthBackend']

@pulumi.input_type
class OciAuthBackendArgs:
    def __init__(__self__, *,
                 home_tenancy_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tune: Optional[pulumi.Input['OciAuthBackendTuneArgs']] = None):
        """
        The set of arguments for constructing a OciAuthBackend resource.
        :param pulumi.Input[_builtins.str] home_tenancy_id: The Tenancy OCID of your OCI account.
        :param pulumi.Input[_builtins.str] description: A description of the auth backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Stops rotation of the root credential until set to false.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Unique name of the auth backend to configure.
        :param pulumi.Input[_builtins.int] rotation_period: The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        :param pulumi.Input[_builtins.str] rotation_schedule: The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        :param pulumi.Input['OciAuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        pulumi.set(__self__, "home_tenancy_id", home_tenancy_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)

    @_builtins.property
    @pulumi.getter(name="homeTenancyId")
    def home_tenancy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Tenancy OCID of your OCI account.
        """
        return pulumi.get(self, "home_tenancy_id")

    @home_tenancy_id.setter
    def home_tenancy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "home_tenancy_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the auth backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Stops rotation of the root credential until set to false.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the auth backend to configure.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['OciAuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['OciAuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)


@pulumi.input_type
class _OciAuthBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 home_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tune: Optional[pulumi.Input['OciAuthBackendTuneArgs']] = None):
        """
        Input properties used for looking up and filtering OciAuthBackend resources.
        :param pulumi.Input[_builtins.str] accessor: The accessor of the auth backend
        :param pulumi.Input[_builtins.str] description: A description of the auth backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Stops rotation of the root credential until set to false.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.str] home_tenancy_id: The Tenancy OCID of your OCI account.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Unique name of the auth backend to configure.
        :param pulumi.Input[_builtins.int] rotation_period: The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        :param pulumi.Input[_builtins.str] rotation_schedule: The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        :param pulumi.Input['OciAuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if home_tenancy_id is not None:
            pulumi.set(__self__, "home_tenancy_id", home_tenancy_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The accessor of the auth backend
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the auth backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Stops rotation of the root credential until set to false.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="homeTenancyId")
    def home_tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenancy OCID of your OCI account.
        """
        return pulumi.get(self, "home_tenancy_id")

    @home_tenancy_id.setter
    def home_tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_tenancy_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the auth backend to configure.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['OciAuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['OciAuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)


@pulumi.type_token("vault:index/ociAuthBackend:OciAuthBackend")
class OciAuthBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 home_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tune: Optional[pulumi.Input[Union['OciAuthBackendTuneArgs', 'OciAuthBackendTuneArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.OciAuthBackend("example",
            path=example_vault_auth_backend["path"],
            home_tenancy_id="ocid1.tenancy.oc1..aaaaaaaah7zkvaffv26pzyauoe2zbnionqvhvsexamplee557wakiofi4ysgqq")
        ```

        ## Import

        OCI auth backends can be imported using the backend's `path`, e.g.

        ```sh
        $ pulumi import vault:index/ociAuthBackend:OciAuthBackend example oci
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the auth backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Stops rotation of the root credential until set to false.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.str] home_tenancy_id: The Tenancy OCID of your OCI account.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Unique name of the auth backend to configure.
        :param pulumi.Input[_builtins.int] rotation_period: The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        :param pulumi.Input[_builtins.str] rotation_schedule: The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        :param pulumi.Input[Union['OciAuthBackendTuneArgs', 'OciAuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OciAuthBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.OciAuthBackend("example",
            path=example_vault_auth_backend["path"],
            home_tenancy_id="ocid1.tenancy.oc1..aaaaaaaah7zkvaffv26pzyauoe2zbnionqvhvsexamplee557wakiofi4ysgqq")
        ```

        ## Import

        OCI auth backends can be imported using the backend's `path`, e.g.

        ```sh
        $ pulumi import vault:index/ociAuthBackend:OciAuthBackend example oci
        ```

        :param str resource_name: The name of the resource.
        :param OciAuthBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OciAuthBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 home_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tune: Optional[pulumi.Input[Union['OciAuthBackendTuneArgs', 'OciAuthBackendTuneArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OciAuthBackendArgs.__new__(OciAuthBackendArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["disable_remount"] = disable_remount
            if home_tenancy_id is None and not opts.urn:
                raise TypeError("Missing required property 'home_tenancy_id'")
            __props__.__dict__["home_tenancy_id"] = None if home_tenancy_id is None else pulumi.Output.secret(home_tenancy_id)
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["tune"] = tune
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["homeTenancyId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OciAuthBackend, __self__).__init__(
            'vault:index/ociAuthBackend:OciAuthBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            home_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            tune: Optional[pulumi.Input[Union['OciAuthBackendTuneArgs', 'OciAuthBackendTuneArgsDict']]] = None) -> 'OciAuthBackend':
        """
        Get an existing OciAuthBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: The accessor of the auth backend
        :param pulumi.Input[_builtins.str] description: A description of the auth backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Stops rotation of the root credential until set to false.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.str] home_tenancy_id: The Tenancy OCID of your OCI account.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Unique name of the auth backend to configure.
        :param pulumi.Input[_builtins.int] rotation_period: The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        :param pulumi.Input[_builtins.str] rotation_schedule: The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        :param pulumi.Input[Union['OciAuthBackendTuneArgs', 'OciAuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OciAuthBackendState.__new__(_OciAuthBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["home_tenancy_id"] = home_tenancy_id
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["tune"] = tune
        return OciAuthBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The accessor of the auth backend
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the auth backend.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Stops rotation of the root credential until set to false.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter(name="homeTenancyId")
    def home_tenancy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Tenancy OCID of your OCI account.
        """
        return pulumi.get(self, "home_tenancy_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique name of the auth backend to configure.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The period of time in seconds between each rotation of the root credential. Cannot be used with rotation_schedule.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cron-style schedule for the root credential to be rotated on. Cannot be used with rotation_period.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds Vault is allowed to complete a rotation once a scheduled rotation is triggered. Can only be used with rotation_schedule.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def tune(self) -> pulumi.Output['outputs.OciAuthBackendTune']:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

