# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackendAcmeEabArgs', 'BackendAcmeEab']

@pulumi.input_type
class BackendAcmeEabArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackendAcmeEab resource.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               create the EAB token within, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] issuer: Create an EAB token that is specific to an issuer's ACME directory.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Create an EAB token that is specific to a role's ACME directory.
               
               **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;
               
               1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
               2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
               3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
               4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        pulumi.set(__self__, "backend", backend)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the PKI secret backend to
        create the EAB token within, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create an EAB token that is specific to an issuer's ACME directory.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create an EAB token that is specific to a role's ACME directory.

        **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;

        1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
        2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
        3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
        4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _BackendAcmeEabState:
    def __init__(__self__, *,
                 acme_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 eab_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackendAcmeEab resources.
        :param pulumi.Input[_builtins.str] acme_directory: The ACME directory to which the key belongs
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               create the EAB token within, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] created_on: An RFC3339 formatted date time when the EAB token was created
        :param pulumi.Input[_builtins.str] eab_id: The identifier of a specific ACME EAB token
        :param pulumi.Input[_builtins.str] issuer: Create an EAB token that is specific to an issuer's ACME directory.
        :param pulumi.Input[_builtins.str] key: The EAB token
        :param pulumi.Input[_builtins.str] key_type: The key type of the EAB key
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Create an EAB token that is specific to a role's ACME directory.
               
               **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;
               
               1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
               2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
               3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
               4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        if acme_directory is not None:
            pulumi.set(__self__, "acme_directory", acme_directory)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if eab_id is not None:
            pulumi.set(__self__, "eab_id", eab_id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="acmeDirectory")
    def acme_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACME directory to which the key belongs
        """
        return pulumi.get(self, "acme_directory")

    @acme_directory.setter
    def acme_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acme_directory", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the PKI secret backend to
        create the EAB token within, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An RFC3339 formatted date time when the EAB token was created
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="eabId")
    def eab_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of a specific ACME EAB token
        """
        return pulumi.get(self, "eab_id")

    @eab_id.setter
    def eab_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eab_id", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create an EAB token that is specific to an issuer's ACME directory.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EAB token
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key type of the EAB key
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create an EAB token that is specific to a role's ACME directory.

        **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;

        1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
        2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
        3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
        4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("vault:pkiSecret/backendAcmeEab:BackendAcmeEab")
class BackendAcmeEab(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows creating ACME EAB (External Account Binding) tokens and deleting unused ones.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.Mount("test",
            path="pki",
            type="pki",
            description="PKI secret engine mount")
        test_backend_acme_eab = vault.pkisecret.BackendAcmeEab("test", backend=test.path)
        ```

        ## Import

        As EAB tokens are only available on initial creation there is no possibility to

        import or update this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               create the EAB token within, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] issuer: Create an EAB token that is specific to an issuer's ACME directory.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Create an EAB token that is specific to a role's ACME directory.
               
               **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;
               
               1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
               2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
               3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
               4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendAcmeEabArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows creating ACME EAB (External Account Binding) tokens and deleting unused ones.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.Mount("test",
            path="pki",
            type="pki",
            description="PKI secret engine mount")
        test_backend_acme_eab = vault.pkisecret.BackendAcmeEab("test", backend=test.path)
        ```

        ## Import

        As EAB tokens are only available on initial creation there is no possibility to

        import or update this resource.

        :param str resource_name: The name of the resource.
        :param BackendAcmeEabArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendAcmeEabArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendAcmeEabArgs.__new__(BackendAcmeEabArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["role"] = role
            __props__.__dict__["acme_directory"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["eab_id"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["key_type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BackendAcmeEab, __self__).__init__(
            'vault:pkiSecret/backendAcmeEab:BackendAcmeEab',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acme_directory: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            eab_id: Optional[pulumi.Input[_builtins.str]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackendAcmeEab':
        """
        Get an existing BackendAcmeEab resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acme_directory: The ACME directory to which the key belongs
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               create the EAB token within, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] created_on: An RFC3339 formatted date time when the EAB token was created
        :param pulumi.Input[_builtins.str] eab_id: The identifier of a specific ACME EAB token
        :param pulumi.Input[_builtins.str] issuer: Create an EAB token that is specific to an issuer's ACME directory.
        :param pulumi.Input[_builtins.str] key: The EAB token
        :param pulumi.Input[_builtins.str] key_type: The key type of the EAB key
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Create an EAB token that is specific to a role's ACME directory.
               
               **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;
               
               1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
               2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
               3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
               4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendAcmeEabState.__new__(_BackendAcmeEabState)

        __props__.__dict__["acme_directory"] = acme_directory
        __props__.__dict__["backend"] = backend
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["eab_id"] = eab_id
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["key"] = key
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["role"] = role
        return BackendAcmeEab(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acmeDirectory")
    def acme_directory(self) -> pulumi.Output[_builtins.str]:
        """
        The ACME directory to which the key belongs
        """
        return pulumi.get(self, "acme_directory")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the PKI secret backend to
        create the EAB token within, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        An RFC3339 formatted date time when the EAB token was created
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="eabId")
    def eab_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of a specific ACME EAB token
        """
        return pulumi.get(self, "eab_id")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Create an EAB token that is specific to an issuer's ACME directory.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The EAB token
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[_builtins.str]:
        """
        The key type of the EAB key
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Create an EAB token that is specific to a role's ACME directory.

        **NOTE**: Within Vault ACME there are different ACME directories which an EAB token is associated with;

        1. Default directory (`pki/acme/`) - Do not specify a value for issuer nor role parameters.
        2. Issuer specific (`pki/issuer/:issuer_ref/acme/`) - Specify a value for the issuer parameter
        3. Role specific (`pki/roles/:role/acme/`) - Specify a value for the role parameter
        4. Issuer and Role specific (`pki/issuer/:issuer_ref/roles/:role/acme/`) - Specify a value for both the issuer and role parameters
        """
        return pulumi.get(self, "role")

