# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendIntermediateCertRequestArgs', 'SecretBackendIntermediateCertRequest']

@pulumi.input_type
class SecretBackendIntermediateCertRequestArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 common_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 add_basic_constraints: Optional[pulumi.Input[_builtins.bool]] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendIntermediateCertRequest resource.
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[_builtins.bool] add_basic_constraints: Adds a Basic Constraints extension with 'CA: true'.
               Only needed as a workaround in some compatibility scenarios with Active Directory
               Certificate Services
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specifies key_usage to encode in the generated certificate.
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.str] serial_number: The requested Subject's named Serial Number
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "type", type)
        if add_basic_constraints is not None:
            pulumi.set(__self__, "add_basic_constraints", add_basic_constraints)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_ref is not None:
            pulumi.set(__self__, "key_ref", key_ref)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if key_usages is not None:
            pulumi.set(__self__, "key_usages", key_usages)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if managed_key_id is not None:
            pulumi.set(__self__, "managed_key_id", managed_key_id)
        if managed_key_name is not None:
            pulumi.set(__self__, "managed_key_name", managed_key_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature_bits is not None:
            pulumi.set(__self__, "signature_bits", signature_bits)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
        or \\"kms\\"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="addBasicConstraints")
    def add_basic_constraints(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Adds a Basic Constraints extension with 'CA: true'.
        Only needed as a workaround in some compatibility scenarios with Active Directory
        Certificate Services
        """
        return pulumi.get(self, "add_basic_constraints")

    @add_basic_constraints.setter
    def add_basic_constraints(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "add_basic_constraints", value)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When a new key is created with this request, optionally specifies
        the name for this. The global ref `default` may not be used as a name.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyRef")
    def key_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key (either default, by name, or by identifier) to use
        for generating this request. Only suitable for `type=existing` requests.
        """
        return pulumi.get(self, "key_ref")

    @key_ref.setter
    def key_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_ref", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies key_usage to encode in the generated certificate.
        """
        return pulumi.get(self, "key_usages")

    @key_usages.setter
    def key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_usages", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the previously configured managed key. This field is
        required if `type` is `kms` and it conflicts with `managed_key_name`
        """
        return pulumi.get(self, "managed_key_id")

    @managed_key_id.setter
    def managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the previously configured managed key. This field is
        required if `type` is `kms`  and it conflicts with `managed_key_id`
        """
        return pulumi.get(self, "managed_key_name")

    @managed_key_name.setter
    def managed_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ou", value)

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postal_code", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_format", value)

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "province", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The requested Subject's named Serial Number
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @signature_bits.setter
    def signature_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "signature_bits", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.input_type
class _SecretBackendIntermediateCertRequestState:
    def __init__(__self__, *,
                 add_basic_constraints: Optional[pulumi.Input[_builtins.bool]] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendIntermediateCertRequest resources.
        :param pulumi.Input[_builtins.bool] add_basic_constraints: Adds a Basic Constraints extension with 'CA: true'.
               Only needed as a workaround in some compatibility scenarios with Active Directory
               Certificate Services
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.str] csr: The CSR
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_id: The ID of the generated key.
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specifies key_usage to encode in the generated certificate.
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key: The private key
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] private_key_type: The private key type
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.str] serial_number: The requested Subject's named Serial Number
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        if add_basic_constraints is not None:
            pulumi.set(__self__, "add_basic_constraints", add_basic_constraints)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_ref is not None:
            pulumi.set(__self__, "key_ref", key_ref)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if key_usages is not None:
            pulumi.set(__self__, "key_usages", key_usages)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if managed_key_id is not None:
            pulumi.set(__self__, "managed_key_id", managed_key_id)
        if managed_key_name is not None:
            pulumi.set(__self__, "managed_key_name", managed_key_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if private_key_type is not None:
            pulumi.set(__self__, "private_key_type", private_key_type)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature_bits is not None:
            pulumi.set(__self__, "signature_bits", signature_bits)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @_builtins.property
    @pulumi.getter(name="addBasicConstraints")
    def add_basic_constraints(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Adds a Basic Constraints extension with 'CA: true'.
        Only needed as a workaround in some compatibility scenarios with Active Directory
        Certificate Services
        """
        return pulumi.get(self, "add_basic_constraints")

    @add_basic_constraints.setter
    def add_basic_constraints(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "add_basic_constraints", value)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the generated key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When a new key is created with this request, optionally specifies
        the name for this. The global ref `default` may not be used as a name.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyRef")
    def key_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key (either default, by name, or by identifier) to use
        for generating this request. Only suitable for `type=existing` requests.
        """
        return pulumi.get(self, "key_ref")

    @key_ref.setter
    def key_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_ref", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies key_usage to encode in the generated certificate.
        """
        return pulumi.get(self, "key_usages")

    @key_usages.setter
    def key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_usages", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the previously configured managed key. This field is
        required if `type` is `kms` and it conflicts with `managed_key_name`
        """
        return pulumi.get(self, "managed_key_id")

    @managed_key_id.setter
    def managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the previously configured managed key. This field is
        required if `type` is `kms`  and it conflicts with `managed_key_id`
        """
        return pulumi.get(self, "managed_key_name")

    @managed_key_name.setter
    def managed_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ou", value)

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postal_code", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_format", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyType")
    def private_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key type
        """
        return pulumi.get(self, "private_key_type")

    @private_key_type.setter
    def private_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_type", value)

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "province", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The requested Subject's named Serial Number
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @signature_bits.setter
    def signature_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "signature_bits", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
        or \\"kms\\"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.type_token("vault:pkiSecret/secretBackendIntermediateCertRequest:SecretBackendIntermediateCertRequest")
class SecretBackendIntermediateCertRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_basic_constraints: Optional[pulumi.Input[_builtins.bool]] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pkisecret.SecretBackendIntermediateCertRequest("test",
            backend=pki["path"],
            type="internal",
            common_name="app.my.domain",
            opts = pulumi.ResourceOptions(depends_on=[pki]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] add_basic_constraints: Adds a Basic Constraints extension with 'CA: true'.
               Only needed as a workaround in some compatibility scenarios with Active Directory
               Certificate Services
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specifies key_usage to encode in the generated certificate.
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.str] serial_number: The requested Subject's named Serial Number
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendIntermediateCertRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pkisecret.SecretBackendIntermediateCertRequest("test",
            backend=pki["path"],
            type="internal",
            common_name="app.my.domain",
            opts = pulumi.ResourceOptions(depends_on=[pki]))
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendIntermediateCertRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendIntermediateCertRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_basic_constraints: Optional[pulumi.Input[_builtins.bool]] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendIntermediateCertRequestArgs.__new__(SecretBackendIntermediateCertRequestArgs)

            __props__.__dict__["add_basic_constraints"] = add_basic_constraints
            __props__.__dict__["alt_names"] = alt_names
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["country"] = country
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["key_bits"] = key_bits
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["key_ref"] = key_ref
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["key_usages"] = key_usages
            __props__.__dict__["locality"] = locality
            __props__.__dict__["managed_key_id"] = managed_key_id
            __props__.__dict__["managed_key_name"] = managed_key_name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["organization"] = organization
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["ou"] = ou
            __props__.__dict__["postal_code"] = postal_code
            __props__.__dict__["private_key_format"] = private_key_format
            __props__.__dict__["province"] = province
            __props__.__dict__["serial_number"] = serial_number
            __props__.__dict__["signature_bits"] = signature_bits
            __props__.__dict__["street_address"] = street_address
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["csr"] = None
            __props__.__dict__["key_id"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["private_key_type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackendIntermediateCertRequest, __self__).__init__(
            'vault:pkiSecret/secretBackendIntermediateCertRequest:SecretBackendIntermediateCertRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_basic_constraints: Optional[pulumi.Input[_builtins.bool]] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            country: Optional[pulumi.Input[_builtins.str]] = None,
            csr: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_bits: Optional[pulumi.Input[_builtins.int]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_ref: Optional[pulumi.Input[_builtins.str]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            locality: Optional[pulumi.Input[_builtins.str]] = None,
            managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ou: Optional[pulumi.Input[_builtins.str]] = None,
            postal_code: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_type: Optional[pulumi.Input[_builtins.str]] = None,
            province: Optional[pulumi.Input[_builtins.str]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
            street_address: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecretBackendIntermediateCertRequest':
        """
        Get an existing SecretBackendIntermediateCertRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] add_basic_constraints: Adds a Basic Constraints extension with 'CA: true'.
               Only needed as a workaround in some compatibility scenarios with Active Directory
               Certificate Services
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.str] csr: The CSR
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_id: The ID of the generated key.
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specifies key_usage to encode in the generated certificate.
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key: The private key
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] private_key_type: The private key type
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.str] serial_number: The requested Subject's named Serial Number
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendIntermediateCertRequestState.__new__(_SecretBackendIntermediateCertRequestState)

        __props__.__dict__["add_basic_constraints"] = add_basic_constraints
        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["backend"] = backend
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["country"] = country
        __props__.__dict__["csr"] = csr
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["key_bits"] = key_bits
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["key_ref"] = key_ref
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["key_usages"] = key_usages
        __props__.__dict__["locality"] = locality
        __props__.__dict__["managed_key_id"] = managed_key_id
        __props__.__dict__["managed_key_name"] = managed_key_name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["organization"] = organization
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["ou"] = ou
        __props__.__dict__["postal_code"] = postal_code
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_format"] = private_key_format
        __props__.__dict__["private_key_type"] = private_key_type
        __props__.__dict__["province"] = province
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature_bits"] = signature_bits
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["type"] = type
        __props__.__dict__["uri_sans"] = uri_sans
        return SecretBackendIntermediateCertRequest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addBasicConstraints")
    def add_basic_constraints(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Adds a Basic Constraints extension with 'CA: true'.
        Only needed as a workaround in some compatibility scenarios with Active Directory
        Certificate Services
        """
        return pulumi.get(self, "add_basic_constraints")

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Output[_builtins.str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the generated key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[_builtins.str]:
        """
        When a new key is created with this request, optionally specifies
        the name for this. The global ref `default` may not be used as a name.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="keyRef")
    def key_ref(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the key (either default, by name, or by identifier) to use
        for generating this request. Only suitable for `type=existing` requests.
        """
        return pulumi.get(self, "key_ref")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies key_usage to encode in the generated certificate.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the previously configured managed key. This field is
        required if `type` is `kms` and it conflicts with `managed_key_name`
        """
        return pulumi.get(self, "managed_key_id")

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the previously configured managed key. This field is
        required if `type` is `kms`  and it conflicts with `managed_key_id`
        """
        return pulumi.get(self, "managed_key_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @_builtins.property
    @pulumi.getter
    def ou(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @_builtins.property
    @pulumi.getter(name="privateKeyType")
    def private_key_type(self) -> pulumi.Output[_builtins.str]:
        """
        The private key type
        """
        return pulumi.get(self, "private_key_type")

    @_builtins.property
    @pulumi.getter
    def province(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The requested Subject's named Serial Number
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of intermediate to create. Must be either \\"exported\\" or \\"internal\\"
        or \\"kms\\"
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

