# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SyncAwsDestinationArgs', 'SyncAwsDestination']

@pulumi.input_type
class SyncAwsDestinationArgs:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SyncAwsDestination resource.
        :param pulumi.Input[_builtins.str] access_key_id: Access key id to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
               variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: Custom tags to set on the secret managed at the destination.
        :param pulumi.Input[_builtins.str] external_id: Optional extra protection that must match the trust policy granting access to the
               AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
               The field is mutable with no special condition, but users must be careful that the new value fits with the trust
               relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
               denied errors. Ignored if the `role_arn` field is empty.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource 
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the AWS destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] region: Region where to manage the secrets manager entries.
               Can be omitted and directly provided to Vault using the `AWS_REGION` environment
               variable.
        :param pulumi.Input[_builtins.str] role_arn: Specifies a role to assume when connecting to AWS. When assuming a role, 
               Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
               exist for Vault to be able to assume this role. The role can be in a different account.
               The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
               It is possible to provide both an access key pair and a role to assume.
        :param pulumi.Input[_builtins.str] secret_access_key: Secret access key to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
               variable.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if secret_name_template is not None:
            pulumi.set(__self__, "secret_name_template", secret_name_template)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access key id to authenticate against the AWS secrets manager.
        Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
        variable.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom tags to set on the secret managed at the destination.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional extra protection that must match the trust policy granting access to the
        AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
        The field is mutable with no special condition, but users must be careful that the new value fits with the trust
        relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
        denied errors. Ignored if the `role_arn` field is empty.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines what level of information is synced as a distinct resource 
        at the destination. Supports `secret-path` and `secret-key`.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granularity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the AWS destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where to manage the secrets manager entries.
        Can be omitted and directly provided to Vault using the `AWS_REGION` environment
        variable.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a role to assume when connecting to AWS. When assuming a role, 
        Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
        exist for Vault to be able to assume this role. The role can be in a different account.
        The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
        It is possible to provide both an access key pair and a role to assume.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret access key to authenticate against the AWS secrets manager.
        Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
        variable.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter(name="secretNameTemplate")
    def secret_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template describing how to generate external secret names.
        Supports a subset of the Go Template syntax.
        """
        return pulumi.get(self, "secret_name_template")

    @secret_name_template.setter
    def secret_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name_template", value)


@pulumi.input_type
class _SyncAwsDestinationState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SyncAwsDestination resources.
        :param pulumi.Input[_builtins.str] access_key_id: Access key id to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
               variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: Custom tags to set on the secret managed at the destination.
        :param pulumi.Input[_builtins.str] external_id: Optional extra protection that must match the trust policy granting access to the
               AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
               The field is mutable with no special condition, but users must be careful that the new value fits with the trust
               relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
               denied errors. Ignored if the `role_arn` field is empty.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource 
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the AWS destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] region: Region where to manage the secrets manager entries.
               Can be omitted and directly provided to Vault using the `AWS_REGION` environment
               variable.
        :param pulumi.Input[_builtins.str] role_arn: Specifies a role to assume when connecting to AWS. When assuming a role, 
               Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
               exist for Vault to be able to assume this role. The role can be in a different account.
               The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
               It is possible to provide both an access key pair and a role to assume.
        :param pulumi.Input[_builtins.str] secret_access_key: Secret access key to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
               variable.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        :param pulumi.Input[_builtins.str] type: The type of the secrets destination (`aws-sm`).
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if secret_name_template is not None:
            pulumi.set(__self__, "secret_name_template", secret_name_template)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access key id to authenticate against the AWS secrets manager.
        Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
        variable.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom tags to set on the secret managed at the destination.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional extra protection that must match the trust policy granting access to the
        AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
        The field is mutable with no special condition, but users must be careful that the new value fits with the trust
        relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
        denied errors. Ignored if the `role_arn` field is empty.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines what level of information is synced as a distinct resource 
        at the destination. Supports `secret-path` and `secret-key`.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granularity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the AWS destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where to manage the secrets manager entries.
        Can be omitted and directly provided to Vault using the `AWS_REGION` environment
        variable.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a role to assume when connecting to AWS. When assuming a role, 
        Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
        exist for Vault to be able to assume this role. The role can be in a different account.
        The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
        It is possible to provide both an access key pair and a role to assume.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret access key to authenticate against the AWS secrets manager.
        Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
        variable.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter(name="secretNameTemplate")
    def secret_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template describing how to generate external secret names.
        Supports a subset of the Go Template syntax.
        """
        return pulumi.get(self, "secret_name_template")

    @secret_name_template.setter
    def secret_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name_template", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secrets destination (`aws-sm`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vault:secrets/syncAwsDestination:SyncAwsDestination")
class SyncAwsDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.secrets.SyncAwsDestination("aws",
            name="aws-dest",
            access_key_id=access_key_id,
            secret_access_key=secret_access_key,
            region="us-east-1",
            role_arn="role-arn",
            external_id="external-id",
            secret_name_template="vault_{{ .MountAccessor | lowercase }}_{{ .SecretPath | lowercase }}",
            custom_tags={
                "foo": "bar",
            })
        ```

        ## Import

        AWS Secrets sync destinations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:secrets/syncAwsDestination:SyncAwsDestination aws aws-dest
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: Access key id to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
               variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: Custom tags to set on the secret managed at the destination.
        :param pulumi.Input[_builtins.str] external_id: Optional extra protection that must match the trust policy granting access to the
               AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
               The field is mutable with no special condition, but users must be careful that the new value fits with the trust
               relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
               denied errors. Ignored if the `role_arn` field is empty.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource 
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the AWS destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] region: Region where to manage the secrets manager entries.
               Can be omitted and directly provided to Vault using the `AWS_REGION` environment
               variable.
        :param pulumi.Input[_builtins.str] role_arn: Specifies a role to assume when connecting to AWS. When assuming a role, 
               Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
               exist for Vault to be able to assume this role. The role can be in a different account.
               The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
               It is possible to provide both an access key pair and a role to assume.
        :param pulumi.Input[_builtins.str] secret_access_key: Secret access key to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
               variable.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SyncAwsDestinationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.secrets.SyncAwsDestination("aws",
            name="aws-dest",
            access_key_id=access_key_id,
            secret_access_key=secret_access_key,
            region="us-east-1",
            role_arn="role-arn",
            external_id="external-id",
            secret_name_template="vault_{{ .MountAccessor | lowercase }}_{{ .SecretPath | lowercase }}",
            custom_tags={
                "foo": "bar",
            })
        ```

        ## Import

        AWS Secrets sync destinations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:secrets/syncAwsDestination:SyncAwsDestination aws aws-dest
        ```

        :param str resource_name: The name of the resource.
        :param SyncAwsDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyncAwsDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyncAwsDestinationArgs.__new__(SyncAwsDestinationArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["granularity"] = granularity
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["region"] = region
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["secret_access_key"] = None if secret_access_key is None else pulumi.Output.secret(secret_access_key)
            __props__.__dict__["secret_name_template"] = secret_name_template
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SyncAwsDestination, __self__).__init__(
            'vault:secrets/syncAwsDestination:SyncAwsDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            granularity: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SyncAwsDestination':
        """
        Get an existing SyncAwsDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: Access key id to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
               variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: Custom tags to set on the secret managed at the destination.
        :param pulumi.Input[_builtins.str] external_id: Optional extra protection that must match the trust policy granting access to the
               AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
               The field is mutable with no special condition, but users must be careful that the new value fits with the trust
               relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
               denied errors. Ignored if the `role_arn` field is empty.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource 
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the AWS destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] region: Region where to manage the secrets manager entries.
               Can be omitted and directly provided to Vault using the `AWS_REGION` environment
               variable.
        :param pulumi.Input[_builtins.str] role_arn: Specifies a role to assume when connecting to AWS. When assuming a role, 
               Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
               exist for Vault to be able to assume this role. The role can be in a different account.
               The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
               It is possible to provide both an access key pair and a role to assume.
        :param pulumi.Input[_builtins.str] secret_access_key: Secret access key to authenticate against the AWS secrets manager.
               Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
               variable.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        :param pulumi.Input[_builtins.str] type: The type of the secrets destination (`aws-sm`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyncAwsDestinationState.__new__(_SyncAwsDestinationState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["granularity"] = granularity
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["secret_name_template"] = secret_name_template
        __props__.__dict__["type"] = type
        return SyncAwsDestination(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access key id to authenticate against the AWS secrets manager.
        Can be omitted and directly provided to Vault using the `AWS_ACCESS_KEY_ID` environment
        variable.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Custom tags to set on the secret managed at the destination.
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional extra protection that must match the trust policy granting access to the
        AWS IAM role ARN. We recommend using a different random UUID per destination. The value is generated by users.
        The field is mutable with no special condition, but users must be careful that the new value fits with the trust
        relationship condition they set on AWS otherwise sync operations will start to fail due to client-side access
        denied errors. Ignored if the `role_arn` field is empty.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines what level of information is synced as a distinct resource 
        at the destination. Supports `secret-path` and `secret-key`.
        """
        return pulumi.get(self, "granularity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name of the AWS destination.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Region where to manage the secrets manager entries.
        Can be omitted and directly provided to Vault using the `AWS_REGION` environment
        variable.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a role to assume when connecting to AWS. When assuming a role, 
        Vault uses temporary STS credentials to authenticate. An initial session with the proper trust relationship must
        exist for Vault to be able to assume this role. The role can be in a different account.
        The value is mutable as long as the new role targets the same AWS account ID. If not, the BE will return an error.
        It is possible to provide both an access key pair and a role to assume.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Secret access key to authenticate against the AWS secrets manager.
        Can be omitted and directly provided to Vault using the `AWS_SECRET_ACCESS_KEY` environment
        variable.
        """
        return pulumi.get(self, "secret_access_key")

    @_builtins.property
    @pulumi.getter(name="secretNameTemplate")
    def secret_name_template(self) -> pulumi.Output[_builtins.str]:
        """
        Template describing how to generate external secret names.
        Supports a subset of the Go Template syntax.
        """
        return pulumi.get(self, "secret_name_template")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the secrets destination (`aws-sm`).
        """
        return pulumi.get(self, "type")

