# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TokenArgs', 'Token']

@pulumi.input_type
class TokenArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 explicit_max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_parent: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_increment: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_min_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Token resource.
        :param pulumi.Input[_builtins.str] display_name: String containing the token display name
        :param pulumi.Input[_builtins.str] explicit_max_ttl: The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata to be set on this token
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_default_policy: Flag to not attach the default policy to this token
        :param pulumi.Input[_builtins.bool] no_parent: Flag to create a token without parent
        :param pulumi.Input[_builtins.int] num_uses: The number of allowed uses of this token
        :param pulumi.Input[_builtins.str] period: The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: List of policies to attach to this token
        :param pulumi.Input[_builtins.int] renew_increment: The renew increment. This is specified in seconds
        :param pulumi.Input[_builtins.int] renew_min_lease: The minimal lease to renew this token
        :param pulumi.Input[_builtins.bool] renewable: Flag to allow to renew this token
        :param pulumi.Input[_builtins.str] role_name: The token role name
        :param pulumi.Input[_builtins.str] ttl: The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[_builtins.str] wrapping_ttl: The TTL period of the wrapped token.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if explicit_max_ttl is not None:
            pulumi.set(__self__, "explicit_max_ttl", explicit_max_ttl)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if no_default_policy is not None:
            pulumi.set(__self__, "no_default_policy", no_default_policy)
        if no_parent is not None:
            pulumi.set(__self__, "no_parent", no_parent)
        if num_uses is not None:
            pulumi.set(__self__, "num_uses", num_uses)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if renew_increment is not None:
            pulumi.set(__self__, "renew_increment", renew_increment)
        if renew_min_lease is not None:
            pulumi.set(__self__, "renew_min_lease", renew_min_lease)
        if renewable is not None:
            pulumi.set(__self__, "renewable", renewable)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if wrapping_ttl is not None:
            pulumi.set(__self__, "wrapping_ttl", wrapping_ttl)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String containing the token display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="explicitMaxTtl")
    def explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "explicit_max_ttl")

    @explicit_max_ttl.setter
    def explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata to be set on this token
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="noDefaultPolicy")
    def no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to not attach the default policy to this token
        """
        return pulumi.get(self, "no_default_policy")

    @no_default_policy.setter
    def no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="noParent")
    def no_parent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to create a token without parent
        """
        return pulumi.get(self, "no_parent")

    @no_parent.setter
    def no_parent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_parent", value)

    @_builtins.property
    @pulumi.getter(name="numUses")
    def num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of allowed uses of this token
        """
        return pulumi.get(self, "num_uses")

    @num_uses.setter
    def num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_uses", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of policies to attach to this token
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter(name="renewIncrement")
    def renew_increment(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The renew increment. This is specified in seconds
        """
        return pulumi.get(self, "renew_increment")

    @renew_increment.setter
    def renew_increment(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_increment", value)

    @_builtins.property
    @pulumi.getter(name="renewMinLease")
    def renew_min_lease(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimal lease to renew this token
        """
        return pulumi.get(self, "renew_min_lease")

    @renew_min_lease.setter
    def renew_min_lease(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_min_lease", value)

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow to renew this token
        """
        return pulumi.get(self, "renewable")

    @renewable.setter
    def renewable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renewable", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token role name
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="wrappingTtl")
    def wrapping_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL period of the wrapped token.
        """
        return pulumi.get(self, "wrapping_ttl")

    @wrapping_ttl.setter
    def wrapping_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wrapping_ttl", value)


@pulumi.input_type
class _TokenState:
    def __init__(__self__, *,
                 client_token: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 explicit_max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 lease_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 lease_started: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_parent: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_increment: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_min_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 wrapped_token: Optional[pulumi.Input[_builtins.str]] = None,
                 wrapping_accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Token resources.
        :param pulumi.Input[_builtins.str] client_token: String containing the client token if stored in present file
        :param pulumi.Input[_builtins.str] display_name: String containing the token display name
        :param pulumi.Input[_builtins.str] explicit_max_ttl: The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[_builtins.int] lease_duration: String containing the token lease duration if present in state file
        :param pulumi.Input[_builtins.str] lease_started: String containing the token lease started time if present in state file
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata to be set on this token
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_default_policy: Flag to not attach the default policy to this token
        :param pulumi.Input[_builtins.bool] no_parent: Flag to create a token without parent
        :param pulumi.Input[_builtins.int] num_uses: The number of allowed uses of this token
        :param pulumi.Input[_builtins.str] period: The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: List of policies to attach to this token
        :param pulumi.Input[_builtins.int] renew_increment: The renew increment. This is specified in seconds
        :param pulumi.Input[_builtins.int] renew_min_lease: The minimal lease to renew this token
        :param pulumi.Input[_builtins.bool] renewable: Flag to allow to renew this token
        :param pulumi.Input[_builtins.str] role_name: The token role name
        :param pulumi.Input[_builtins.str] ttl: The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[_builtins.str] wrapped_token: The client wrapped token.
        :param pulumi.Input[_builtins.str] wrapping_accessor: The client wrapping accessor.
        :param pulumi.Input[_builtins.str] wrapping_ttl: The TTL period of the wrapped token.
        """
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if explicit_max_ttl is not None:
            pulumi.set(__self__, "explicit_max_ttl", explicit_max_ttl)
        if lease_duration is not None:
            pulumi.set(__self__, "lease_duration", lease_duration)
        if lease_started is not None:
            pulumi.set(__self__, "lease_started", lease_started)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if no_default_policy is not None:
            pulumi.set(__self__, "no_default_policy", no_default_policy)
        if no_parent is not None:
            pulumi.set(__self__, "no_parent", no_parent)
        if num_uses is not None:
            pulumi.set(__self__, "num_uses", num_uses)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if renew_increment is not None:
            pulumi.set(__self__, "renew_increment", renew_increment)
        if renew_min_lease is not None:
            pulumi.set(__self__, "renew_min_lease", renew_min_lease)
        if renewable is not None:
            pulumi.set(__self__, "renewable", renewable)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if wrapped_token is not None:
            pulumi.set(__self__, "wrapped_token", wrapped_token)
        if wrapping_accessor is not None:
            pulumi.set(__self__, "wrapping_accessor", wrapping_accessor)
        if wrapping_ttl is not None:
            pulumi.set(__self__, "wrapping_ttl", wrapping_ttl)

    @_builtins.property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String containing the client token if stored in present file
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_token", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String containing the token display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="explicitMaxTtl")
    def explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "explicit_max_ttl")

    @explicit_max_ttl.setter
    def explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="leaseDuration")
    def lease_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        String containing the token lease duration if present in state file
        """
        return pulumi.get(self, "lease_duration")

    @lease_duration.setter
    def lease_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lease_duration", value)

    @_builtins.property
    @pulumi.getter(name="leaseStarted")
    def lease_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String containing the token lease started time if present in state file
        """
        return pulumi.get(self, "lease_started")

    @lease_started.setter
    def lease_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lease_started", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata to be set on this token
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="noDefaultPolicy")
    def no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to not attach the default policy to this token
        """
        return pulumi.get(self, "no_default_policy")

    @no_default_policy.setter
    def no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="noParent")
    def no_parent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to create a token without parent
        """
        return pulumi.get(self, "no_parent")

    @no_parent.setter
    def no_parent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_parent", value)

    @_builtins.property
    @pulumi.getter(name="numUses")
    def num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of allowed uses of this token
        """
        return pulumi.get(self, "num_uses")

    @num_uses.setter
    def num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_uses", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of policies to attach to this token
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter(name="renewIncrement")
    def renew_increment(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The renew increment. This is specified in seconds
        """
        return pulumi.get(self, "renew_increment")

    @renew_increment.setter
    def renew_increment(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_increment", value)

    @_builtins.property
    @pulumi.getter(name="renewMinLease")
    def renew_min_lease(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimal lease to renew this token
        """
        return pulumi.get(self, "renew_min_lease")

    @renew_min_lease.setter
    def renew_min_lease(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_min_lease", value)

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow to renew this token
        """
        return pulumi.get(self, "renewable")

    @renewable.setter
    def renewable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renewable", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token role name
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="wrappedToken")
    def wrapped_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client wrapped token.
        """
        return pulumi.get(self, "wrapped_token")

    @wrapped_token.setter
    def wrapped_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wrapped_token", value)

    @_builtins.property
    @pulumi.getter(name="wrappingAccessor")
    def wrapping_accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client wrapping accessor.
        """
        return pulumi.get(self, "wrapping_accessor")

    @wrapping_accessor.setter
    def wrapping_accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wrapping_accessor", value)

    @_builtins.property
    @pulumi.getter(name="wrappingTtl")
    def wrapping_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL period of the wrapped token.
        """
        return pulumi.get(self, "wrapping_ttl")

    @wrapping_ttl.setter
    def wrapping_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wrapping_ttl", value)


@pulumi.type_token("vault:index/token:Token")
class Token(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 explicit_max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_parent: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_increment: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_min_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Token("example",
            role_name="app",
            policies=[
                "policy1",
                "policy2",
            ],
            renewable=True,
            ttl="24h",
            renew_min_lease=43200,
            renew_increment=86400,
            metadata={
                "purpose": "service-account",
            })
        ```

        ## Import

        Tokens can be imported using its `id` as accessor id, e.g.

        ```sh
        $ pulumi import vault:index/token:Token example <accessor_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: String containing the token display name
        :param pulumi.Input[_builtins.str] explicit_max_ttl: The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata to be set on this token
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_default_policy: Flag to not attach the default policy to this token
        :param pulumi.Input[_builtins.bool] no_parent: Flag to create a token without parent
        :param pulumi.Input[_builtins.int] num_uses: The number of allowed uses of this token
        :param pulumi.Input[_builtins.str] period: The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: List of policies to attach to this token
        :param pulumi.Input[_builtins.int] renew_increment: The renew increment. This is specified in seconds
        :param pulumi.Input[_builtins.int] renew_min_lease: The minimal lease to renew this token
        :param pulumi.Input[_builtins.bool] renewable: Flag to allow to renew this token
        :param pulumi.Input[_builtins.str] role_name: The token role name
        :param pulumi.Input[_builtins.str] ttl: The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[_builtins.str] wrapping_ttl: The TTL period of the wrapped token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Token("example",
            role_name="app",
            policies=[
                "policy1",
                "policy2",
            ],
            renewable=True,
            ttl="24h",
            renew_min_lease=43200,
            renew_increment=86400,
            metadata={
                "purpose": "service-account",
            })
        ```

        ## Import

        Tokens can be imported using its `id` as accessor id, e.g.

        ```sh
        $ pulumi import vault:index/token:Token example <accessor_id>
        ```

        :param str resource_name: The name of the resource.
        :param TokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 explicit_max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_parent: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_increment: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_min_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 wrapping_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenArgs.__new__(TokenArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["explicit_max_ttl"] = explicit_max_ttl
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["no_default_policy"] = no_default_policy
            __props__.__dict__["no_parent"] = no_parent
            __props__.__dict__["num_uses"] = num_uses
            __props__.__dict__["period"] = period
            __props__.__dict__["policies"] = policies
            __props__.__dict__["renew_increment"] = renew_increment
            __props__.__dict__["renew_min_lease"] = renew_min_lease
            __props__.__dict__["renewable"] = renewable
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["wrapping_ttl"] = wrapping_ttl
            __props__.__dict__["client_token"] = None
            __props__.__dict__["lease_duration"] = None
            __props__.__dict__["lease_started"] = None
            __props__.__dict__["wrapped_token"] = None
            __props__.__dict__["wrapping_accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientToken", "wrappedToken", "wrappingAccessor"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Token, __self__).__init__(
            'vault:index/token:Token',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_token: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            explicit_max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            lease_duration: Optional[pulumi.Input[_builtins.int]] = None,
            lease_started: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            no_parent: Optional[pulumi.Input[_builtins.bool]] = None,
            num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            renew_increment: Optional[pulumi.Input[_builtins.int]] = None,
            renew_min_lease: Optional[pulumi.Input[_builtins.int]] = None,
            renewable: Optional[pulumi.Input[_builtins.bool]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None,
            wrapped_token: Optional[pulumi.Input[_builtins.str]] = None,
            wrapping_accessor: Optional[pulumi.Input[_builtins.str]] = None,
            wrapping_ttl: Optional[pulumi.Input[_builtins.str]] = None) -> 'Token':
        """
        Get an existing Token resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_token: String containing the client token if stored in present file
        :param pulumi.Input[_builtins.str] display_name: String containing the token display name
        :param pulumi.Input[_builtins.str] explicit_max_ttl: The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[_builtins.int] lease_duration: String containing the token lease duration if present in state file
        :param pulumi.Input[_builtins.str] lease_started: String containing the token lease started time if present in state file
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata to be set on this token
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_default_policy: Flag to not attach the default policy to this token
        :param pulumi.Input[_builtins.bool] no_parent: Flag to create a token without parent
        :param pulumi.Input[_builtins.int] num_uses: The number of allowed uses of this token
        :param pulumi.Input[_builtins.str] period: The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: List of policies to attach to this token
        :param pulumi.Input[_builtins.int] renew_increment: The renew increment. This is specified in seconds
        :param pulumi.Input[_builtins.int] renew_min_lease: The minimal lease to renew this token
        :param pulumi.Input[_builtins.bool] renewable: Flag to allow to renew this token
        :param pulumi.Input[_builtins.str] role_name: The token role name
        :param pulumi.Input[_builtins.str] ttl: The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        :param pulumi.Input[_builtins.str] wrapped_token: The client wrapped token.
        :param pulumi.Input[_builtins.str] wrapping_accessor: The client wrapping accessor.
        :param pulumi.Input[_builtins.str] wrapping_ttl: The TTL period of the wrapped token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenState.__new__(_TokenState)

        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["explicit_max_ttl"] = explicit_max_ttl
        __props__.__dict__["lease_duration"] = lease_duration
        __props__.__dict__["lease_started"] = lease_started
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["no_default_policy"] = no_default_policy
        __props__.__dict__["no_parent"] = no_parent
        __props__.__dict__["num_uses"] = num_uses
        __props__.__dict__["period"] = period
        __props__.__dict__["policies"] = policies
        __props__.__dict__["renew_increment"] = renew_increment
        __props__.__dict__["renew_min_lease"] = renew_min_lease
        __props__.__dict__["renewable"] = renewable
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["wrapped_token"] = wrapped_token
        __props__.__dict__["wrapping_accessor"] = wrapping_accessor
        __props__.__dict__["wrapping_ttl"] = wrapping_ttl
        return Token(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[_builtins.str]:
        """
        String containing the client token if stored in present file
        """
        return pulumi.get(self, "client_token")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        String containing the token display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="explicitMaxTtl")
    def explicit_max_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The explicit max TTL of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "explicit_max_ttl")

    @_builtins.property
    @pulumi.getter(name="leaseDuration")
    def lease_duration(self) -> pulumi.Output[_builtins.int]:
        """
        String containing the token lease duration if present in state file
        """
        return pulumi.get(self, "lease_duration")

    @_builtins.property
    @pulumi.getter(name="leaseStarted")
    def lease_started(self) -> pulumi.Output[_builtins.str]:
        """
        String containing the token lease started time if present in state file
        """
        return pulumi.get(self, "lease_started")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata to be set on this token
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="noDefaultPolicy")
    def no_default_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to not attach the default policy to this token
        """
        return pulumi.get(self, "no_default_policy")

    @_builtins.property
    @pulumi.getter(name="noParent")
    def no_parent(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag to create a token without parent
        """
        return pulumi.get(self, "no_parent")

    @_builtins.property
    @pulumi.getter(name="numUses")
    def num_uses(self) -> pulumi.Output[_builtins.int]:
        """
        The number of allowed uses of this token
        """
        return pulumi.get(self, "num_uses")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of policies to attach to this token
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="renewIncrement")
    def renew_increment(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The renew increment. This is specified in seconds
        """
        return pulumi.get(self, "renew_increment")

    @_builtins.property
    @pulumi.getter(name="renewMinLease")
    def renew_min_lease(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimal lease to renew this token
        """
        return pulumi.get(self, "renew_min_lease")

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag to allow to renew this token
        """
        return pulumi.get(self, "renewable")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The token role name
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TTL period of this token. This is specified as a numeric string with suffix like "30s" ro "5m"
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="wrappedToken")
    def wrapped_token(self) -> pulumi.Output[_builtins.str]:
        """
        The client wrapped token.
        """
        return pulumi.get(self, "wrapped_token")

    @_builtins.property
    @pulumi.getter(name="wrappingAccessor")
    def wrapping_accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The client wrapping accessor.
        """
        return pulumi.get(self, "wrapping_accessor")

    @_builtins.property
    @pulumi.getter(name="wrappingTtl")
    def wrapping_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TTL period of the wrapped token.
        """
        return pulumi.get(self, "wrapping_ttl")

